// services/network/public/mojom/websocket.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace network {
namespace mojom {
namespace internal {
class  AuthenticationHandler_OnAuthRequired_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(AuthenticationHandler_OnAuthRequired_Params_Data));
      new (data()) AuthenticationHandler_OnAuthRequired_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    AuthenticationHandler_OnAuthRequired_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<AuthenticationHandler_OnAuthRequired_Params_Data>(index_);
    }
    AuthenticationHandler_OnAuthRequired_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::AuthChallengeInfo_Data> info;
  mojo::internal::Pointer<::network::mojom::internal::HttpResponseHeaders_Data> headers;
  mojo::internal::Pointer<::network::mojom::internal::IPEndPoint_Data> remote_endpoint;

 private:
  AuthenticationHandler_OnAuthRequired_Params_Data();
  ~AuthenticationHandler_OnAuthRequired_Params_Data() = delete;
};
static_assert(sizeof(AuthenticationHandler_OnAuthRequired_Params_Data) == 32,
              "Bad sizeof(AuthenticationHandler_OnAuthRequired_Params_Data)");
class  AuthenticationHandler_OnAuthRequired_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(AuthenticationHandler_OnAuthRequired_ResponseParams_Data));
      new (data()) AuthenticationHandler_OnAuthRequired_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    AuthenticationHandler_OnAuthRequired_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<AuthenticationHandler_OnAuthRequired_ResponseParams_Data>(index_);
    }
    AuthenticationHandler_OnAuthRequired_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::AuthCredentials_Data> credentials;

 private:
  AuthenticationHandler_OnAuthRequired_ResponseParams_Data();
  ~AuthenticationHandler_OnAuthRequired_ResponseParams_Data() = delete;
};
static_assert(sizeof(AuthenticationHandler_OnAuthRequired_ResponseParams_Data) == 16,
              "Bad sizeof(AuthenticationHandler_OnAuthRequired_ResponseParams_Data)");
class  WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data));
      new (data()) WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data>(index_);
    }
    WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::WebSocketHandshakeRequest_Data> request;

 private:
  WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data();
  ~WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data() = delete;
};
static_assert(sizeof(WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data) == 16,
              "Bad sizeof(WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data)");
class  WebSocketHandshakeClient_OnConnectionEstablished_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebSocketHandshakeClient_OnConnectionEstablished_Params_Data));
      new (data()) WebSocketHandshakeClient_OnConnectionEstablished_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebSocketHandshakeClient_OnConnectionEstablished_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebSocketHandshakeClient_OnConnectionEstablished_Params_Data>(index_);
    }
    WebSocketHandshakeClient_OnConnectionEstablished_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data socket;
  mojo::internal::Handle_Data client_receiver;
  mojo::internal::Handle_Data readable;
  mojo::internal::Pointer<internal::WebSocketHandshakeResponse_Data> response;
  mojo::internal::Handle_Data writable;
  uint8_t padfinal_[4];

 private:
  WebSocketHandshakeClient_OnConnectionEstablished_Params_Data();
  ~WebSocketHandshakeClient_OnConnectionEstablished_Params_Data() = delete;
};
static_assert(sizeof(WebSocketHandshakeClient_OnConnectionEstablished_Params_Data) == 40,
              "Bad sizeof(WebSocketHandshakeClient_OnConnectionEstablished_Params_Data)");
class  WebSocketClient_OnDataFrame_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebSocketClient_OnDataFrame_Params_Data));
      new (data()) WebSocketClient_OnDataFrame_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebSocketClient_OnDataFrame_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebSocketClient_OnDataFrame_Params_Data>(index_);
    }
    WebSocketClient_OnDataFrame_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t fin : 1;
  uint8_t pad0_[3];
  int32_t type;
  uint64_t data_length;

 private:
  WebSocketClient_OnDataFrame_Params_Data();
  ~WebSocketClient_OnDataFrame_Params_Data() = delete;
};
static_assert(sizeof(WebSocketClient_OnDataFrame_Params_Data) == 24,
              "Bad sizeof(WebSocketClient_OnDataFrame_Params_Data)");
class  WebSocketClient_OnDropChannel_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebSocketClient_OnDropChannel_Params_Data));
      new (data()) WebSocketClient_OnDropChannel_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebSocketClient_OnDropChannel_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebSocketClient_OnDropChannel_Params_Data>(index_);
    }
    WebSocketClient_OnDropChannel_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t was_clean : 1;
  uint8_t pad0_[1];
  uint16_t code;
  uint8_t pad1_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> reason;

 private:
  WebSocketClient_OnDropChannel_Params_Data();
  ~WebSocketClient_OnDropChannel_Params_Data() = delete;
};
static_assert(sizeof(WebSocketClient_OnDropChannel_Params_Data) == 24,
              "Bad sizeof(WebSocketClient_OnDropChannel_Params_Data)");
class  WebSocketClient_OnClosingHandshake_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebSocketClient_OnClosingHandshake_Params_Data));
      new (data()) WebSocketClient_OnClosingHandshake_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebSocketClient_OnClosingHandshake_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebSocketClient_OnClosingHandshake_Params_Data>(index_);
    }
    WebSocketClient_OnClosingHandshake_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  WebSocketClient_OnClosingHandshake_Params_Data();
  ~WebSocketClient_OnClosingHandshake_Params_Data() = delete;
};
static_assert(sizeof(WebSocketClient_OnClosingHandshake_Params_Data) == 8,
              "Bad sizeof(WebSocketClient_OnClosingHandshake_Params_Data)");
class  WebSocket_SendMessage_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebSocket_SendMessage_Params_Data));
      new (data()) WebSocket_SendMessage_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebSocket_SendMessage_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebSocket_SendMessage_Params_Data>(index_);
    }
    WebSocket_SendMessage_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  uint8_t pad0_[4];
  uint64_t data_length;

 private:
  WebSocket_SendMessage_Params_Data();
  ~WebSocket_SendMessage_Params_Data() = delete;
};
static_assert(sizeof(WebSocket_SendMessage_Params_Data) == 24,
              "Bad sizeof(WebSocket_SendMessage_Params_Data)");
class  WebSocket_StartReceiving_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebSocket_StartReceiving_Params_Data));
      new (data()) WebSocket_StartReceiving_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebSocket_StartReceiving_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebSocket_StartReceiving_Params_Data>(index_);
    }
    WebSocket_StartReceiving_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  WebSocket_StartReceiving_Params_Data();
  ~WebSocket_StartReceiving_Params_Data() = delete;
};
static_assert(sizeof(WebSocket_StartReceiving_Params_Data) == 8,
              "Bad sizeof(WebSocket_StartReceiving_Params_Data)");
class  WebSocket_StartClosingHandshake_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebSocket_StartClosingHandshake_Params_Data));
      new (data()) WebSocket_StartClosingHandshake_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebSocket_StartClosingHandshake_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebSocket_StartClosingHandshake_Params_Data>(index_);
    }
    WebSocket_StartClosingHandshake_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint16_t code;
  uint8_t pad0_[6];
  mojo::internal::Pointer<mojo::internal::String_Data> reason;

 private:
  WebSocket_StartClosingHandshake_Params_Data();
  ~WebSocket_StartClosingHandshake_Params_Data() = delete;
};
static_assert(sizeof(WebSocket_StartClosingHandshake_Params_Data) == 24,
              "Bad sizeof(WebSocket_StartClosingHandshake_Params_Data)");

}  // namespace internal


class AuthenticationHandler_OnAuthRequired_ParamsDataView {
 public:
  AuthenticationHandler_OnAuthRequired_ParamsDataView() {}

  AuthenticationHandler_OnAuthRequired_ParamsDataView(
      internal::AuthenticationHandler_OnAuthRequired_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      ::network::mojom::AuthChallengeInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInfo(UserType* output) {
    
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::network::mojom::AuthChallengeInfoDataView>(
        pointer, output, context_);
  }
  inline void GetHeadersDataView(
      ::network::mojom::HttpResponseHeadersDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpResponseHeadersDataView>(
        pointer, output, context_);
  }
  inline void GetRemoteEndpointDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRemoteEndpoint(UserType* output) {
    
    auto* pointer = data_->remote_endpoint.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, context_);
  }
 private:
  internal::AuthenticationHandler_OnAuthRequired_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class AuthenticationHandler_OnAuthRequired_ResponseParamsDataView {
 public:
  AuthenticationHandler_OnAuthRequired_ResponseParamsDataView() {}

  AuthenticationHandler_OnAuthRequired_ResponseParamsDataView(
      internal::AuthenticationHandler_OnAuthRequired_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetCredentialsDataView(
      ::network::mojom::AuthCredentialsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCredentials(UserType* output) {
    
    auto* pointer = data_->credentials.Get();
    return mojo::internal::Deserialize<::network::mojom::AuthCredentialsDataView>(
        pointer, output, context_);
  }
 private:
  internal::AuthenticationHandler_OnAuthRequired_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsDataView {
 public:
  WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsDataView() {}

  WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsDataView(
      internal::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetRequestDataView(
      WebSocketHandshakeRequestDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequest(UserType* output) {
    
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::network::mojom::WebSocketHandshakeRequestDataView>(
        pointer, output, context_);
  }
 private:
  internal::WebSocketHandshakeClient_OnOpeningHandshakeStarted_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class WebSocketHandshakeClient_OnConnectionEstablished_ParamsDataView {
 public:
  WebSocketHandshakeClient_OnConnectionEstablished_ParamsDataView() {}

  WebSocketHandshakeClient_OnConnectionEstablished_ParamsDataView(
      internal::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeSocket() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::WebSocketInterfaceBase>>(
            &data_->socket, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::WebSocketClientInterfaceBase>>(
            &data_->client_receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetResponseDataView(
      WebSocketHandshakeResponseDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResponse(UserType* output) {
    
    auto* pointer = data_->response.Get();
    return mojo::internal::Deserialize<::network::mojom::WebSocketHandshakeResponseDataView>(
        pointer, output, context_);
  }
  mojo::ScopedDataPipeConsumerHandle TakeReadable() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->readable, &result, context_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeProducerHandle TakeWritable() {
    mojo::ScopedDataPipeProducerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeProducerHandle>(
            &data_->writable, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::WebSocketHandshakeClient_OnConnectionEstablished_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class WebSocketClient_OnDataFrame_ParamsDataView {
 public:
  WebSocketClient_OnDataFrame_ParamsDataView() {}

  WebSocketClient_OnDataFrame_ParamsDataView(
      internal::WebSocketClient_OnDataFrame_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool fin() const {
    return data_->fin;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::WebSocketMessageType>(
        data_value, output);
  }

  WebSocketMessageType type() const {
    return static_cast<WebSocketMessageType>(data_->type);
  }
  uint64_t data_length() const {
    return data_->data_length;
  }
 private:
  internal::WebSocketClient_OnDataFrame_Params_Data* data_ = nullptr;
};



class WebSocketClient_OnDropChannel_ParamsDataView {
 public:
  WebSocketClient_OnDropChannel_ParamsDataView() {}

  WebSocketClient_OnDropChannel_ParamsDataView(
      internal::WebSocketClient_OnDropChannel_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool was_clean() const {
    return data_->was_clean;
  }
  uint16_t code() const {
    return data_->code;
  }
  inline void GetReasonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReason(UserType* output) {
    
    auto* pointer = data_->reason.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::WebSocketClient_OnDropChannel_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class WebSocketClient_OnClosingHandshake_ParamsDataView {
 public:
  WebSocketClient_OnClosingHandshake_ParamsDataView() {}

  WebSocketClient_OnClosingHandshake_ParamsDataView(
      internal::WebSocketClient_OnClosingHandshake_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::WebSocketClient_OnClosingHandshake_Params_Data* data_ = nullptr;
};



class WebSocket_SendMessage_ParamsDataView {
 public:
  WebSocket_SendMessage_ParamsDataView() {}

  WebSocket_SendMessage_ParamsDataView(
      internal::WebSocket_SendMessage_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::WebSocketMessageType>(
        data_value, output);
  }

  WebSocketMessageType type() const {
    return static_cast<WebSocketMessageType>(data_->type);
  }
  uint64_t data_length() const {
    return data_->data_length;
  }
 private:
  internal::WebSocket_SendMessage_Params_Data* data_ = nullptr;
};



class WebSocket_StartReceiving_ParamsDataView {
 public:
  WebSocket_StartReceiving_ParamsDataView() {}

  WebSocket_StartReceiving_ParamsDataView(
      internal::WebSocket_StartReceiving_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::WebSocket_StartReceiving_Params_Data* data_ = nullptr;
};



class WebSocket_StartClosingHandshake_ParamsDataView {
 public:
  WebSocket_StartClosingHandshake_ParamsDataView() {}

  WebSocket_StartClosingHandshake_ParamsDataView(
      internal::WebSocket_StartClosingHandshake_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint16_t code() const {
    return data_->code;
  }
  inline void GetReasonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReason(UserType* output) {
    
    auto* pointer = data_->reason.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::WebSocket_StartClosingHandshake_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void AuthenticationHandler_OnAuthRequired_ParamsDataView::GetInfoDataView(
    ::network::mojom::AuthChallengeInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = ::network::mojom::AuthChallengeInfoDataView(pointer, context_);
}
inline void AuthenticationHandler_OnAuthRequired_ParamsDataView::GetHeadersDataView(
    ::network::mojom::HttpResponseHeadersDataView* output) {
  auto pointer = data_->headers.Get();
  *output = ::network::mojom::HttpResponseHeadersDataView(pointer, context_);
}
inline void AuthenticationHandler_OnAuthRequired_ParamsDataView::GetRemoteEndpointDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->remote_endpoint.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, context_);
}


inline void AuthenticationHandler_OnAuthRequired_ResponseParamsDataView::GetCredentialsDataView(
    ::network::mojom::AuthCredentialsDataView* output) {
  auto pointer = data_->credentials.Get();
  *output = ::network::mojom::AuthCredentialsDataView(pointer, context_);
}


inline void WebSocketHandshakeClient_OnOpeningHandshakeStarted_ParamsDataView::GetRequestDataView(
    WebSocketHandshakeRequestDataView* output) {
  auto pointer = data_->request.Get();
  *output = WebSocketHandshakeRequestDataView(pointer, context_);
}


inline void WebSocketHandshakeClient_OnConnectionEstablished_ParamsDataView::GetResponseDataView(
    WebSocketHandshakeResponseDataView* output) {
  auto pointer = data_->response.Get();
  *output = WebSocketHandshakeResponseDataView(pointer, context_);
}




inline void WebSocketClient_OnDropChannel_ParamsDataView::GetReasonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reason.Get();
  *output = mojo::StringDataView(pointer, context_);
}








inline void WebSocket_StartClosingHandshake_ParamsDataView::GetReasonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reason.Get();
  *output = mojo::StringDataView(pointer, context_);
}

}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_WEBSOCKET_MOJOM_PARAMS_DATA_H_