// services/network/public/mojom/trust_tokens.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/trust_tokens.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "services/network/public/mojom/trust_tokens.mojom-params-data.h"
namespace network {
namespace mojom {

std::ostream& operator<<(std::ostream& os, TrustTokenOperationStatus value) {
  switch(value) {
    case TrustTokenOperationStatus::kOk:
      return os << "TrustTokenOperationStatus::kOk";
    case TrustTokenOperationStatus::kInvalidArgument:
      return os << "TrustTokenOperationStatus::kInvalidArgument";
    case TrustTokenOperationStatus::kFailedPrecondition:
      return os << "TrustTokenOperationStatus::kFailedPrecondition";
    case TrustTokenOperationStatus::kResourceExhausted:
      return os << "TrustTokenOperationStatus::kResourceExhausted";
    case TrustTokenOperationStatus::kAlreadyExists:
      return os << "TrustTokenOperationStatus::kAlreadyExists";
    case TrustTokenOperationStatus::kUnavailable:
      return os << "TrustTokenOperationStatus::kUnavailable";
    case TrustTokenOperationStatus::kBadResponse:
      return os << "TrustTokenOperationStatus::kBadResponse";
    case TrustTokenOperationStatus::kInternalError:
      return os << "TrustTokenOperationStatus::kInternalError";
    case TrustTokenOperationStatus::kUnknownError:
      return os << "TrustTokenOperationStatus::kUnknownError";
    default:
      return os << "Unknown TrustTokenOperationStatus value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, TrustTokenOperationType value) {
  switch(value) {
    case TrustTokenOperationType::kIssuance:
      return os << "TrustTokenOperationType::kIssuance";
    case TrustTokenOperationType::kRedemption:
      return os << "TrustTokenOperationType::kRedemption";
    case TrustTokenOperationType::kSigning:
      return os << "TrustTokenOperationType::kSigning";
    default:
      return os << "Unknown TrustTokenOperationType value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, TrustTokenRefreshPolicy value) {
  switch(value) {
    case TrustTokenRefreshPolicy::kUseCached:
      return os << "TrustTokenRefreshPolicy::kUseCached";
    case TrustTokenRefreshPolicy::kRefresh:
      return os << "TrustTokenRefreshPolicy::kRefresh";
    default:
      return os << "Unknown TrustTokenRefreshPolicy value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, TrustTokenSignRequestData value) {
  switch(value) {
    case TrustTokenSignRequestData::kOmit:
      return os << "TrustTokenSignRequestData::kOmit";
    case TrustTokenSignRequestData::kHeadersOnly:
      return os << "TrustTokenSignRequestData::kHeadersOnly";
    case TrustTokenSignRequestData::kInclude:
      return os << "TrustTokenSignRequestData::kInclude";
    default:
      return os << "Unknown TrustTokenSignRequestData value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool TrustTokenParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TrustTokenParams_Data* object = static_cast<const TrustTokenParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 48 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::network::mojom::internal::TrustTokenOperationType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::network::mojom::internal::TrustTokenRefreshPolicy_Data
        ::Validate(object->refresh_policy, validation_context))
    return false;


  if (!::network::mojom::internal::TrustTokenSignRequestData_Data
        ::Validate(object->sign_request_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->issuers, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams issuers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->issuers, validation_context,
                                         &issuers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->additional_signed_headers, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams additional_signed_headers_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->additional_signed_headers, validation_context,
                                         &additional_signed_headers_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams possibly_unsafe_additional_signing_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->possibly_unsafe_additional_signing_data, validation_context,
                                         &possibly_unsafe_additional_signing_data_validate_params)) {
    return false;
  }

  return true;
}

TrustTokenParams_Data::TrustTokenParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HasTrustTokensResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HasTrustTokensResult_Data* object = static_cast<const HasTrustTokensResult_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::network::mojom::internal::TrustTokenOperationStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

HasTrustTokensResult_Data::HasTrustTokensResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustTokenVerificationKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TrustTokenVerificationKey_Data* object = static_cast<const TrustTokenVerificationKey_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->body, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams body_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->body, validation_context,
                                         &body_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expiry, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expiry, validation_context))
    return false;

  return true;
}

TrustTokenVerificationKey_Data::TrustTokenVerificationKey_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustTokenKeyCommitmentResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TrustTokenKeyCommitmentResult_Data* object = static_cast<const TrustTokenKeyCommitmentResult_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keys, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams keys_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->keys, validation_context,
                                         &keys_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signed_redemption_record_verification_key, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams signed_redemption_record_verification_key_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->signed_redemption_record_verification_key, validation_context,
                                         &signed_redemption_record_verification_key_validate_params)) {
    return false;
  }

  return true;
}

TrustTokenKeyCommitmentResult_Data::TrustTokenKeyCommitmentResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HasTrustTokensAnswerer_HasTrustTokens_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HasTrustTokensAnswerer_HasTrustTokens_Params_Data* object = static_cast<const HasTrustTokensAnswerer_HasTrustTokens_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->issuer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->issuer, validation_context))
    return false;

  return true;
}

HasTrustTokensAnswerer_HasTrustTokens_Params_Data::HasTrustTokensAnswerer_HasTrustTokens_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HasTrustTokensAnswerer_HasTrustTokens_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const HasTrustTokensAnswerer_HasTrustTokens_ResponseParams_Data* object = static_cast<const HasTrustTokensAnswerer_HasTrustTokens_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

HasTrustTokensAnswerer_HasTrustTokens_ResponseParams_Data::HasTrustTokensAnswerer_HasTrustTokens_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network