// services/network/public/mojom/tls_socket.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/tls_socket.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/tls_socket.mojom-params-data.h"
#include "services/network/public/mojom/tls_socket.mojom-shared-message-ids.h"

#include "services/network/public/mojom/tls_socket.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TLS_SOCKET_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TLS_SOCKET_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
TLSClientSocketOptions::TLSClientSocketOptions()
    : version_min(::network::mojom::SSLVersion::kTLS1),
      version_max(::network::mojom::SSLVersion::kTLS13),
      send_ssl_info(false),
      unsafely_skip_cert_verification(false) {}

TLSClientSocketOptions::TLSClientSocketOptions(
    ::network::mojom::SSLVersion version_min_in,
    ::network::mojom::SSLVersion version_max_in,
    bool send_ssl_info_in,
    bool unsafely_skip_cert_verification_in)
    : version_min(std::move(version_min_in)),
      version_max(std::move(version_max_in)),
      send_ssl_info(std::move(send_ssl_info_in)),
      unsafely_skip_cert_verification(std::move(unsafely_skip_cert_verification_in)) {}

TLSClientSocketOptions::~TLSClientSocketOptions() = default;
size_t TLSClientSocketOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->version_min);
  seed = mojo::internal::Hash(seed, this->version_max);
  seed = mojo::internal::Hash(seed, this->send_ssl_info);
  seed = mojo::internal::Hash(seed, this->unsafely_skip_cert_verification);
  return seed;
}

void TLSClientSocketOptions::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("version_min", base::trace_event::ValueToString(this->version_min));
  value->SetString("version_max", base::trace_event::ValueToString(this->version_max));
  value->SetBoolean("send_ssl_info", this->send_ssl_info);
  value->SetBoolean("unsafely_skip_cert_verification", this->unsafely_skip_cert_verification);
}

bool TLSClientSocketOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char TLSClientSocket::Name_[] = "network.mojom.TLSClientSocket";

TLSClientSocketProxy::TLSClientSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool TLSClientSocketStubDispatch::Accept(
    TLSClientSocket* impl,
    mojo::Message* message) {
  return false;
}

// static
bool TLSClientSocketStubDispatch::AcceptWithResponder(
    TLSClientSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}



bool TLSClientSocketRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TLSClientSocket::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, {});
}

}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::TLSClientSocketOptions::DataView, ::network::mojom::TLSClientSocketOptionsPtr>::Read(
    ::network::mojom::TLSClientSocketOptions::DataView input,
    ::network::mojom::TLSClientSocketOptionsPtr* output) {
  bool success = true;
  ::network::mojom::TLSClientSocketOptionsPtr result(::network::mojom::TLSClientSocketOptions::New());
  
      if (success && !input.ReadVersionMin(&result->version_min))
        success = false;
      if (success && !input.ReadVersionMax(&result->version_max))
        success = false;
      if (success)
        result->send_ssl_info = input.send_ssl_info();
      if (success)
        result->unsafely_skip_cert_verification = input.unsafely_skip_cert_verification();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif