// services/network/public/mojom/network_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/network_service.mojom-shared.h"
#include "services/network/public/mojom/network_service.mojom-forward.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom-forward.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "services/network/public/mojom/cookie_manager.mojom.h"
#include "services/network/public/mojom/host_resolver.mojom.h"
#include "services/network/public/mojom/http_raw_headers.mojom.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom.h"
#include "services/network/public/mojom/net_log.mojom.h"
#include "services/network/public/mojom/network_change_manager.mojom.h"
#include "services/network/public/mojom/network_context.mojom.h"
#include "services/network/public/mojom/network_interface.mojom.h"
#include "services/network/public/mojom/network_param.mojom-forward.h"
#include "services/network/public/mojom/network_quality_estimator_manager.mojom.h"
#include "services/network/public/mojom/network_service_test.mojom.h"
#include "services/network/public/mojom/trust_tokens.mojom.h"
#include "services/network/public/mojom/url_loader.mojom.h"
#include "services/network/public/mojom/url_loader_factory.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {

class NetworkServiceClientProxy;

template <typename ImplRefTraits>
class NetworkServiceClientStub;

class NetworkServiceClientRequestValidator;
class NetworkServiceClientResponseValidator;


class  NetworkServiceClient
    : public NetworkServiceClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = NetworkServiceClientInterfaceBase;
  using Proxy_ = NetworkServiceClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetworkServiceClientStub<ImplRefTraits>;

  using RequestValidator_ = NetworkServiceClientRequestValidator;
  using ResponseValidator_ = NetworkServiceClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnLoadingStateUpdateMinVersion = 0,
    kOnDataUseUpdateMinVersion = 0,
    kOnRawRequestMinVersion = 0,
    kOnRawResponseMinVersion = 0,
    kOnCorsPreflightRequestMinVersion = 0,
    kOnCorsPreflightResponseMinVersion = 0,
    kOnCorsPreflightRequestCompletedMinVersion = 0,
  };
  virtual ~NetworkServiceClient() {}


  using OnLoadingStateUpdateCallback = base::OnceCallback<void()>;
  
  virtual void OnLoadingStateUpdate(std::vector<LoadInfoPtr> infos, OnLoadingStateUpdateCallback callback) = 0;

  
  virtual void OnDataUseUpdate(int32_t network_traffic_annotation_id_hash, int64_t recv_bytes, int64_t sent_bytes) = 0;

  
  virtual void OnRawRequest(int32_t process_id, int32_t routing_id, const std::string& devtool_request_id, const std::vector<::net::CookieWithAccessResult>& cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers) = 0;

  
  virtual void OnRawResponse(int32_t process_id, int32_t routing_id, const std::string& devtool_request_id, const std::vector<::net::CookieAndLineWithAccessResult>& cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers, const base::Optional<std::string>& raw_response_headers) = 0;

  
  virtual void OnCorsPreflightRequest(int32_t process_id, int32_t render_frame_id, const ::base::UnguessableToken& devtool_request_id, const ::network::ResourceRequest& request, const ::GURL& initiator_url) = 0;

  
  virtual void OnCorsPreflightResponse(int32_t process_id, int32_t render_frame_id, const ::base::UnguessableToken& devtool_request_id, const ::GURL& url, ::network::mojom::URLResponseHeadPtr head) = 0;

  
  virtual void OnCorsPreflightRequestCompleted(int32_t process_id, int32_t render_frame_id, const ::base::UnguessableToken& devtool_request_id, const ::network::URLLoaderCompletionStatus& status) = 0;
};

class NetworkServiceProxy;

template <typename ImplRefTraits>
class NetworkServiceStub;

class NetworkServiceRequestValidator;
class NetworkServiceResponseValidator;


class  NetworkService
    : public NetworkServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = NetworkServiceInterfaceBase;
  using Proxy_ = NetworkServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetworkServiceStub<ImplRefTraits>;

  using RequestValidator_ = NetworkServiceRequestValidator;
  using ResponseValidator_ = NetworkServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetClientMinVersion = 0,
    kStartNetLogMinVersion = 0,
    kAttachNetLogProxyMinVersion = 0,
    kSetSSLKeyLogFileMinVersion = 0,
    kCreateNetworkContextMinVersion = 0,
    kConfigureStubHostResolverMinVersion = 0,
    kDisableQuicMinVersion = 0,
    kSetUpHttpAuthMinVersion = 0,
    kConfigureHttpAuthPrefsMinVersion = 0,
    kSetRawHeadersAccessMinVersion = 0,
    kSetMaxConnectionsPerProxyMinVersion = 0,
    kGetNetworkChangeManagerMinVersion = 0,
    kGetNetworkQualityEstimatorManagerMinVersion = 0,
    kGetDnsConfigChangeManagerMinVersion = 0,
    kGetTotalNetworkUsagesMinVersion = 0,
    kGetNetworkListMinVersion = 0,
    kUpdateCRLSetMinVersion = 0,
    kUpdateLegacyTLSConfigMinVersion = 0,
    kOnCertDBChangedMinVersion = 0,
    kSetCryptConfigMinVersion = 0,
    kAddCorbExceptionForPluginMinVersion = 0,
    kAddAllowedRequestInitiatorForPluginMinVersion = 0,
    kRemoveSecurityExceptionsForPluginMinVersion = 0,
    kOnMemoryPressureMinVersion = 0,
    kOnPeerToPeerConnectionsCountChangeMinVersion = 0,
    kSetEnvironmentMinVersion = 0,
    kSetTrustTokenKeyCommitmentsMinVersion = 0,
    kClearSCTAuditingCacheMinVersion = 0,
    kConfigureSCTAuditingMinVersion = 0,
    kBindTestInterfaceMinVersion = 0,
    kSetPreloadedFirstPartySetsMinVersion = 0,
  };
  virtual ~NetworkService() {}

  
  virtual void SetClient(::mojo::PendingRemote<NetworkServiceClient> client, NetworkServiceParamsPtr params) = 0;

  
  virtual void StartNetLog(::base::File file, ::net::NetLogCaptureMode capture_mode, ::base::Value constants) = 0;

  
  virtual void AttachNetLogProxy(::mojo::PendingRemote<::network::mojom::NetLogProxySource> proxy_source, ::mojo::PendingReceiver<::network::mojom::NetLogProxySink> proxy_sink) = 0;

  
  virtual void SetSSLKeyLogFile(::base::File file) = 0;

  
  virtual void CreateNetworkContext(::mojo::PendingReceiver<::network::mojom::NetworkContext> context, ::network::mojom::NetworkContextParamsPtr params) = 0;

  
  virtual void ConfigureStubHostResolver(bool insecure_dns_client_enabled, ::net::SecureDnsMode secure_dns_mode, base::Optional<std::vector<::network::mojom::DnsOverHttpsServerPtr>> dns_over_https_servers) = 0;

  
  virtual void DisableQuic() = 0;

  
  virtual void SetUpHttpAuth(HttpAuthStaticParamsPtr http_auth_static_params) = 0;

  
  virtual void ConfigureHttpAuthPrefs(HttpAuthDynamicParamsPtr http_auth_dynamic_params) = 0;

  
  virtual void SetRawHeadersAccess(int32_t process_id, const std::vector<::url::Origin>& origins) = 0;

  
  virtual void SetMaxConnectionsPerProxy(int32_t max_connections) = 0;

  
  virtual void GetNetworkChangeManager(::mojo::PendingReceiver<::network::mojom::NetworkChangeManager> network_change_manager) = 0;

  
  virtual void GetNetworkQualityEstimatorManager(::mojo::PendingReceiver<::network::mojom::NetworkQualityEstimatorManager> receiver) = 0;

  
  virtual void GetDnsConfigChangeManager(::mojo::PendingReceiver<::network::mojom::DnsConfigChangeManager> receiver) = 0;


  using GetTotalNetworkUsagesCallback = base::OnceCallback<void(std::vector<::network::mojom::NetworkUsagePtr>)>;
  
  virtual void GetTotalNetworkUsages(GetTotalNetworkUsagesCallback callback) = 0;


  using GetNetworkListCallback = base::OnceCallback<void(const base::Optional<std::vector<::net::NetworkInterface>>&)>;
  
  virtual void GetNetworkList(uint32_t policy, GetNetworkListCallback callback) = 0;


  using UpdateCRLSetCallback = base::OnceCallback<void()>;
  
  virtual void UpdateCRLSet(::base::span<const ::uint8_t> crl_set, UpdateCRLSetCallback callback) = 0;


  using UpdateLegacyTLSConfigCallback = base::OnceCallback<void()>;
  
  virtual void UpdateLegacyTLSConfig(::base::span<const ::uint8_t> config, UpdateLegacyTLSConfigCallback callback) = 0;

  
  virtual void OnCertDBChanged() = 0;

  
  virtual void SetCryptConfig(CryptConfigPtr crypt_config) = 0;

  
  virtual void AddCorbExceptionForPlugin(int32_t process_id) = 0;

  
  virtual void AddAllowedRequestInitiatorForPlugin(int32_t process_id, const ::url::Origin& allowed_request_initiator) = 0;

  
  virtual void RemoveSecurityExceptionsForPlugin(int32_t process_id) = 0;

  
  virtual void OnMemoryPressure(::base::MemoryPressureListener::MemoryPressureLevel memory_pressure_level) = 0;

  
  virtual void OnPeerToPeerConnectionsCountChange(uint32_t count) = 0;

  
  virtual void SetEnvironment(std::vector<EnvironmentVariablePtr> environment) = 0;


  using SetTrustTokenKeyCommitmentsCallback = base::OnceCallback<void()>;
  
  virtual void SetTrustTokenKeyCommitments(const std::string& raw_commitments, SetTrustTokenKeyCommitmentsCallback callback) = 0;

  
  virtual void ClearSCTAuditingCache() = 0;

  
  virtual void ConfigureSCTAuditing(bool enabled, double sampling_rate, const ::GURL& report_uri, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> factory) = 0;

  
  virtual void BindTestInterface(::mojo::PendingReceiver<::network::mojom::NetworkServiceTest> receiver) = 0;

  
  virtual void SetPreloadedFirstPartySets(const std::string& raw_sets) = 0;
};



class  NetworkServiceClientProxy
    : public NetworkServiceClient {
 public:
  using InterfaceType = NetworkServiceClient;

  explicit NetworkServiceClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnLoadingStateUpdate(std::vector<LoadInfoPtr> infos, OnLoadingStateUpdateCallback callback) final;
  
  void OnDataUseUpdate(int32_t network_traffic_annotation_id_hash, int64_t recv_bytes, int64_t sent_bytes) final;
  
  void OnRawRequest(int32_t process_id, int32_t routing_id, const std::string& devtool_request_id, const std::vector<::net::CookieWithAccessResult>& cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers) final;
  
  void OnRawResponse(int32_t process_id, int32_t routing_id, const std::string& devtool_request_id, const std::vector<::net::CookieAndLineWithAccessResult>& cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers, const base::Optional<std::string>& raw_response_headers) final;
  
  void OnCorsPreflightRequest(int32_t process_id, int32_t render_frame_id, const ::base::UnguessableToken& devtool_request_id, const ::network::ResourceRequest& request, const ::GURL& initiator_url) final;
  
  void OnCorsPreflightResponse(int32_t process_id, int32_t render_frame_id, const ::base::UnguessableToken& devtool_request_id, const ::GURL& url, ::network::mojom::URLResponseHeadPtr head) final;
  
  void OnCorsPreflightRequestCompleted(int32_t process_id, int32_t render_frame_id, const ::base::UnguessableToken& devtool_request_id, const ::network::URLLoaderCompletionStatus& status) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  NetworkServiceProxy
    : public NetworkService {
 public:
  using InterfaceType = NetworkService;

  explicit NetworkServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetClient(::mojo::PendingRemote<NetworkServiceClient> client, NetworkServiceParamsPtr params) final;
  
  void StartNetLog(::base::File file, ::net::NetLogCaptureMode capture_mode, ::base::Value constants) final;
  
  void AttachNetLogProxy(::mojo::PendingRemote<::network::mojom::NetLogProxySource> proxy_source, ::mojo::PendingReceiver<::network::mojom::NetLogProxySink> proxy_sink) final;
  
  void SetSSLKeyLogFile(::base::File file) final;
  
  void CreateNetworkContext(::mojo::PendingReceiver<::network::mojom::NetworkContext> context, ::network::mojom::NetworkContextParamsPtr params) final;
  
  void ConfigureStubHostResolver(bool insecure_dns_client_enabled, ::net::SecureDnsMode secure_dns_mode, base::Optional<std::vector<::network::mojom::DnsOverHttpsServerPtr>> dns_over_https_servers) final;
  
  void DisableQuic() final;
  
  void SetUpHttpAuth(HttpAuthStaticParamsPtr http_auth_static_params) final;
  
  void ConfigureHttpAuthPrefs(HttpAuthDynamicParamsPtr http_auth_dynamic_params) final;
  
  void SetRawHeadersAccess(int32_t process_id, const std::vector<::url::Origin>& origins) final;
  
  void SetMaxConnectionsPerProxy(int32_t max_connections) final;
  
  void GetNetworkChangeManager(::mojo::PendingReceiver<::network::mojom::NetworkChangeManager> network_change_manager) final;
  
  void GetNetworkQualityEstimatorManager(::mojo::PendingReceiver<::network::mojom::NetworkQualityEstimatorManager> receiver) final;
  
  void GetDnsConfigChangeManager(::mojo::PendingReceiver<::network::mojom::DnsConfigChangeManager> receiver) final;
  
  void GetTotalNetworkUsages(GetTotalNetworkUsagesCallback callback) final;
  
  void GetNetworkList(uint32_t policy, GetNetworkListCallback callback) final;
  
  void UpdateCRLSet(::base::span<const ::uint8_t> crl_set, UpdateCRLSetCallback callback) final;
  
  void UpdateLegacyTLSConfig(::base::span<const ::uint8_t> config, UpdateLegacyTLSConfigCallback callback) final;
  
  void OnCertDBChanged() final;
  
  void SetCryptConfig(CryptConfigPtr crypt_config) final;
  
  void AddCorbExceptionForPlugin(int32_t process_id) final;
  
  void AddAllowedRequestInitiatorForPlugin(int32_t process_id, const ::url::Origin& allowed_request_initiator) final;
  
  void RemoveSecurityExceptionsForPlugin(int32_t process_id) final;
  
  void OnMemoryPressure(::base::MemoryPressureListener::MemoryPressureLevel memory_pressure_level) final;
  
  void OnPeerToPeerConnectionsCountChange(uint32_t count) final;
  
  void SetEnvironment(std::vector<EnvironmentVariablePtr> environment) final;
  
  void SetTrustTokenKeyCommitments(const std::string& raw_commitments, SetTrustTokenKeyCommitmentsCallback callback) final;
  
  void ClearSCTAuditingCache() final;
  
  void ConfigureSCTAuditing(bool enabled, double sampling_rate, const ::GURL& report_uri, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> factory) final;
  
  void BindTestInterface(::mojo::PendingReceiver<::network::mojom::NetworkServiceTest> receiver) final;
  
  void SetPreloadedFirstPartySets(const std::string& raw_sets) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NetworkServiceClientStubDispatch {
 public:
  static bool Accept(NetworkServiceClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetworkServiceClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetworkServiceClient>>
class NetworkServiceClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetworkServiceClientStub() {}
  ~NetworkServiceClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkServiceClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkServiceClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetworkServiceStubDispatch {
 public:
  static bool Accept(NetworkService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetworkService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetworkService>>
class NetworkServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetworkServiceStub() {}
  ~NetworkServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetworkServiceClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetworkServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetworkServiceClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetworkServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  EnvironmentVariable {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EnvironmentVariable, T>::value>;
  using DataView = EnvironmentVariableDataView;
  using Data_ = internal::EnvironmentVariable_Data;

  template <typename... Args>
  static EnvironmentVariablePtr New(Args&&... args) {
    return EnvironmentVariablePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EnvironmentVariablePtr From(const U& u) {
    return mojo::TypeConverter<EnvironmentVariablePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EnvironmentVariable>::Convert(*this);
  }


  EnvironmentVariable();

  EnvironmentVariable(
      const std::string& name,
      const std::string& value);

  ~EnvironmentVariable();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EnvironmentVariablePtr>
  EnvironmentVariablePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EnvironmentVariable::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EnvironmentVariable::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EnvironmentVariable::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EnvironmentVariable_UnserializedMessageContext<
            UserType, EnvironmentVariable::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<EnvironmentVariable::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return EnvironmentVariable::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EnvironmentVariable_UnserializedMessageContext<
            UserType, EnvironmentVariable::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EnvironmentVariable::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string name;
  
  std::string value;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EnvironmentVariable::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EnvironmentVariable::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EnvironmentVariable::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EnvironmentVariable::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  LoadInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LoadInfo, T>::value>;
  using DataView = LoadInfoDataView;
  using Data_ = internal::LoadInfo_Data;

  template <typename... Args>
  static LoadInfoPtr New(Args&&... args) {
    return LoadInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LoadInfoPtr From(const U& u) {
    return mojo::TypeConverter<LoadInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LoadInfo>::Convert(*this);
  }


  LoadInfo();

  LoadInfo(
      int32_t process_id,
      int32_t routing_id,
      const std::string& host,
      uint32_t load_state,
      const ::base::string16& state_param,
      uint64_t upload_position,
      uint64_t upload_size);

  ~LoadInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LoadInfoPtr>
  LoadInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LoadInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoadInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LoadInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LoadInfo_UnserializedMessageContext<
            UserType, LoadInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<LoadInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return LoadInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LoadInfo_UnserializedMessageContext<
            UserType, LoadInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LoadInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t process_id;
  
  int32_t routing_id;
  
  std::string host;
  
  uint32_t load_state;
  
  ::base::string16 state_param;
  
  uint64_t upload_position;
  
  uint64_t upload_size;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LoadInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LoadInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LoadInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LoadInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  HttpAuthStaticParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HttpAuthStaticParams, T>::value>;
  using DataView = HttpAuthStaticParamsDataView;
  using Data_ = internal::HttpAuthStaticParams_Data;

  template <typename... Args>
  static HttpAuthStaticParamsPtr New(Args&&... args) {
    return HttpAuthStaticParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HttpAuthStaticParamsPtr From(const U& u) {
    return mojo::TypeConverter<HttpAuthStaticParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HttpAuthStaticParams>::Convert(*this);
  }


  HttpAuthStaticParams();

  HttpAuthStaticParams(
      std::vector<std::string> supported_schemes,
      const std::string& gssapi_library_name);

  ~HttpAuthStaticParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HttpAuthStaticParamsPtr>
  HttpAuthStaticParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HttpAuthStaticParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpAuthStaticParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HttpAuthStaticParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HttpAuthStaticParams_UnserializedMessageContext<
            UserType, HttpAuthStaticParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<HttpAuthStaticParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return HttpAuthStaticParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HttpAuthStaticParams_UnserializedMessageContext<
            UserType, HttpAuthStaticParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HttpAuthStaticParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<std::string> supported_schemes;
  
  std::string gssapi_library_name;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HttpAuthStaticParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HttpAuthStaticParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HttpAuthStaticParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HttpAuthStaticParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  HttpAuthDynamicParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HttpAuthDynamicParams, T>::value>;
  using DataView = HttpAuthDynamicParamsDataView;
  using Data_ = internal::HttpAuthDynamicParams_Data;

  template <typename... Args>
  static HttpAuthDynamicParamsPtr New(Args&&... args) {
    return HttpAuthDynamicParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HttpAuthDynamicParamsPtr From(const U& u) {
    return mojo::TypeConverter<HttpAuthDynamicParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HttpAuthDynamicParams>::Convert(*this);
  }


  HttpAuthDynamicParams();

  HttpAuthDynamicParams(
      const std::string& server_allowlist,
      const std::string& delegate_allowlist,
      bool delegate_by_kdc_policy,
      bool negotiate_disable_cname_lookup,
      bool enable_negotiate_port,
      bool ntlm_v2_enabled,
      const std::string& android_negotiate_account_type,
      bool allow_gssapi_library_load);

  ~HttpAuthDynamicParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HttpAuthDynamicParamsPtr>
  HttpAuthDynamicParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HttpAuthDynamicParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpAuthDynamicParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HttpAuthDynamicParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HttpAuthDynamicParams_UnserializedMessageContext<
            UserType, HttpAuthDynamicParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<HttpAuthDynamicParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return HttpAuthDynamicParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HttpAuthDynamicParams_UnserializedMessageContext<
            UserType, HttpAuthDynamicParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HttpAuthDynamicParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string server_allowlist;
  
  std::string delegate_allowlist;
  
  bool delegate_by_kdc_policy;
  
  bool negotiate_disable_cname_lookup;
  
  bool enable_negotiate_port;
  
  bool ntlm_v2_enabled;
  
  std::string android_negotiate_account_type;
  
  bool allow_gssapi_library_load;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HttpAuthDynamicParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HttpAuthDynamicParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HttpAuthDynamicParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HttpAuthDynamicParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CryptConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CryptConfig, T>::value>;
  using DataView = CryptConfigDataView;
  using Data_ = internal::CryptConfig_Data;

  template <typename... Args>
  static CryptConfigPtr New(Args&&... args) {
    return CryptConfigPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CryptConfigPtr From(const U& u) {
    return mojo::TypeConverter<CryptConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CryptConfig>::Convert(*this);
  }


  CryptConfig();

  CryptConfig(
      const std::string& store,
      const std::string& product_name,
      bool should_use_preference,
      const ::base::FilePath& user_data_path);

  ~CryptConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CryptConfigPtr>
  CryptConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CryptConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CryptConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CryptConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CryptConfig_UnserializedMessageContext<
            UserType, CryptConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CryptConfig::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CryptConfig::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CryptConfig_UnserializedMessageContext<
            UserType, CryptConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CryptConfig::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string store;
  
  std::string product_name;
  
  bool should_use_preference;
  
  ::base::FilePath user_data_path;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CryptConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CryptConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CryptConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CryptConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  NetworkServiceParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NetworkServiceParams, T>::value>;
  using DataView = NetworkServiceParamsDataView;
  using Data_ = internal::NetworkServiceParams_Data;

  template <typename... Args>
  static NetworkServiceParamsPtr New(Args&&... args) {
    return NetworkServiceParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NetworkServiceParamsPtr From(const U& u) {
    return mojo::TypeConverter<NetworkServiceParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkServiceParams>::Convert(*this);
  }


  NetworkServiceParams();

  NetworkServiceParams(
      ::network::mojom::ConnectionType initial_connection_type,
      ::network::mojom::ConnectionSubtype initial_connection_subtype,
      std::vector<EnvironmentVariablePtr> environment);

  ~NetworkServiceParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NetworkServiceParamsPtr>
  NetworkServiceParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NetworkServiceParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkServiceParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkServiceParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NetworkServiceParams_UnserializedMessageContext<
            UserType, NetworkServiceParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<NetworkServiceParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return NetworkServiceParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NetworkServiceParams_UnserializedMessageContext<
            UserType, NetworkServiceParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NetworkServiceParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::network::mojom::ConnectionType initial_connection_type;
  
  ::network::mojom::ConnectionSubtype initial_connection_subtype;
  
  std::vector<EnvironmentVariablePtr> environment;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(NetworkServiceParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NetworkServiceParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NetworkServiceParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NetworkServiceParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NetworkServiceParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LoadInfoPtr LoadInfo::Clone() const {
  return New(
      mojo::Clone(process_id),
      mojo::Clone(routing_id),
      mojo::Clone(host),
      mojo::Clone(load_state),
      mojo::Clone(state_param),
      mojo::Clone(upload_position),
      mojo::Clone(upload_size)
  );
}

template <typename T, LoadInfo::EnableIfSame<T>*>
bool LoadInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->process_id, other_struct.process_id))
    return false;
  if (!mojo::Equals(this->routing_id, other_struct.routing_id))
    return false;
  if (!mojo::Equals(this->host, other_struct.host))
    return false;
  if (!mojo::Equals(this->load_state, other_struct.load_state))
    return false;
  if (!mojo::Equals(this->state_param, other_struct.state_param))
    return false;
  if (!mojo::Equals(this->upload_position, other_struct.upload_position))
    return false;
  if (!mojo::Equals(this->upload_size, other_struct.upload_size))
    return false;
  return true;
}

template <typename T, LoadInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.process_id, rhs.process_id))
    return true;
  if (std::less<>{}(rhs.process_id, lhs.process_id))
    return false;
  if (std::less<>{}(lhs.routing_id, rhs.routing_id))
    return true;
  if (std::less<>{}(rhs.routing_id, lhs.routing_id))
    return false;
  if (std::less<>{}(lhs.host, rhs.host))
    return true;
  if (std::less<>{}(rhs.host, lhs.host))
    return false;
  if (std::less<>{}(lhs.load_state, rhs.load_state))
    return true;
  if (std::less<>{}(rhs.load_state, lhs.load_state))
    return false;
  if (std::less<>{}(lhs.state_param, rhs.state_param))
    return true;
  if (std::less<>{}(rhs.state_param, lhs.state_param))
    return false;
  if (std::less<>{}(lhs.upload_position, rhs.upload_position))
    return true;
  if (std::less<>{}(rhs.upload_position, lhs.upload_position))
    return false;
  if (std::less<>{}(lhs.upload_size, rhs.upload_size))
    return true;
  if (std::less<>{}(rhs.upload_size, lhs.upload_size))
    return false;
  return false;
}
template <typename StructPtrType>
HttpAuthStaticParamsPtr HttpAuthStaticParams::Clone() const {
  return New(
      mojo::Clone(supported_schemes),
      mojo::Clone(gssapi_library_name)
  );
}

template <typename T, HttpAuthStaticParams::EnableIfSame<T>*>
bool HttpAuthStaticParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->supported_schemes, other_struct.supported_schemes))
    return false;
  if (!mojo::Equals(this->gssapi_library_name, other_struct.gssapi_library_name))
    return false;
  return true;
}

template <typename T, HttpAuthStaticParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.supported_schemes, rhs.supported_schemes))
    return true;
  if (std::less<>{}(rhs.supported_schemes, lhs.supported_schemes))
    return false;
  if (std::less<>{}(lhs.gssapi_library_name, rhs.gssapi_library_name))
    return true;
  if (std::less<>{}(rhs.gssapi_library_name, lhs.gssapi_library_name))
    return false;
  return false;
}
template <typename StructPtrType>
HttpAuthDynamicParamsPtr HttpAuthDynamicParams::Clone() const {
  return New(
      mojo::Clone(server_allowlist),
      mojo::Clone(delegate_allowlist),
      mojo::Clone(delegate_by_kdc_policy),
      mojo::Clone(negotiate_disable_cname_lookup),
      mojo::Clone(enable_negotiate_port),
      mojo::Clone(ntlm_v2_enabled),
      mojo::Clone(android_negotiate_account_type),
      mojo::Clone(allow_gssapi_library_load)
  );
}

template <typename T, HttpAuthDynamicParams::EnableIfSame<T>*>
bool HttpAuthDynamicParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->server_allowlist, other_struct.server_allowlist))
    return false;
  if (!mojo::Equals(this->delegate_allowlist, other_struct.delegate_allowlist))
    return false;
  if (!mojo::Equals(this->delegate_by_kdc_policy, other_struct.delegate_by_kdc_policy))
    return false;
  if (!mojo::Equals(this->negotiate_disable_cname_lookup, other_struct.negotiate_disable_cname_lookup))
    return false;
  if (!mojo::Equals(this->enable_negotiate_port, other_struct.enable_negotiate_port))
    return false;
  if (!mojo::Equals(this->ntlm_v2_enabled, other_struct.ntlm_v2_enabled))
    return false;
  if (!mojo::Equals(this->android_negotiate_account_type, other_struct.android_negotiate_account_type))
    return false;
  if (!mojo::Equals(this->allow_gssapi_library_load, other_struct.allow_gssapi_library_load))
    return false;
  return true;
}

template <typename T, HttpAuthDynamicParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.server_allowlist, rhs.server_allowlist))
    return true;
  if (std::less<>{}(rhs.server_allowlist, lhs.server_allowlist))
    return false;
  if (std::less<>{}(lhs.delegate_allowlist, rhs.delegate_allowlist))
    return true;
  if (std::less<>{}(rhs.delegate_allowlist, lhs.delegate_allowlist))
    return false;
  if (std::less<>{}(lhs.delegate_by_kdc_policy, rhs.delegate_by_kdc_policy))
    return true;
  if (std::less<>{}(rhs.delegate_by_kdc_policy, lhs.delegate_by_kdc_policy))
    return false;
  if (std::less<>{}(lhs.negotiate_disable_cname_lookup, rhs.negotiate_disable_cname_lookup))
    return true;
  if (std::less<>{}(rhs.negotiate_disable_cname_lookup, lhs.negotiate_disable_cname_lookup))
    return false;
  if (std::less<>{}(lhs.enable_negotiate_port, rhs.enable_negotiate_port))
    return true;
  if (std::less<>{}(rhs.enable_negotiate_port, lhs.enable_negotiate_port))
    return false;
  if (std::less<>{}(lhs.ntlm_v2_enabled, rhs.ntlm_v2_enabled))
    return true;
  if (std::less<>{}(rhs.ntlm_v2_enabled, lhs.ntlm_v2_enabled))
    return false;
  if (std::less<>{}(lhs.android_negotiate_account_type, rhs.android_negotiate_account_type))
    return true;
  if (std::less<>{}(rhs.android_negotiate_account_type, lhs.android_negotiate_account_type))
    return false;
  if (std::less<>{}(lhs.allow_gssapi_library_load, rhs.allow_gssapi_library_load))
    return true;
  if (std::less<>{}(rhs.allow_gssapi_library_load, lhs.allow_gssapi_library_load))
    return false;
  return false;
}
template <typename StructPtrType>
CryptConfigPtr CryptConfig::Clone() const {
  return New(
      mojo::Clone(store),
      mojo::Clone(product_name),
      mojo::Clone(should_use_preference),
      mojo::Clone(user_data_path)
  );
}

template <typename T, CryptConfig::EnableIfSame<T>*>
bool CryptConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->store, other_struct.store))
    return false;
  if (!mojo::Equals(this->product_name, other_struct.product_name))
    return false;
  if (!mojo::Equals(this->should_use_preference, other_struct.should_use_preference))
    return false;
  if (!mojo::Equals(this->user_data_path, other_struct.user_data_path))
    return false;
  return true;
}

template <typename T, CryptConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.store, rhs.store))
    return true;
  if (std::less<>{}(rhs.store, lhs.store))
    return false;
  if (std::less<>{}(lhs.product_name, rhs.product_name))
    return true;
  if (std::less<>{}(rhs.product_name, lhs.product_name))
    return false;
  if (std::less<>{}(lhs.should_use_preference, rhs.should_use_preference))
    return true;
  if (std::less<>{}(rhs.should_use_preference, lhs.should_use_preference))
    return false;
  if (std::less<>{}(lhs.user_data_path, rhs.user_data_path))
    return true;
  if (std::less<>{}(rhs.user_data_path, lhs.user_data_path))
    return false;
  return false;
}
template <typename StructPtrType>
EnvironmentVariablePtr EnvironmentVariable::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(value)
  );
}

template <typename T, EnvironmentVariable::EnableIfSame<T>*>
bool EnvironmentVariable::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, EnvironmentVariable::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.value, rhs.value))
    return true;
  if (std::less<>{}(rhs.value, lhs.value))
    return false;
  return false;
}
template <typename StructPtrType>
NetworkServiceParamsPtr NetworkServiceParams::Clone() const {
  return New(
      mojo::Clone(initial_connection_type),
      mojo::Clone(initial_connection_subtype),
      mojo::Clone(environment)
  );
}

template <typename T, NetworkServiceParams::EnableIfSame<T>*>
bool NetworkServiceParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->initial_connection_type, other_struct.initial_connection_type))
    return false;
  if (!mojo::Equals(this->initial_connection_subtype, other_struct.initial_connection_subtype))
    return false;
  if (!mojo::Equals(this->environment, other_struct.environment))
    return false;
  return true;
}

template <typename T, NetworkServiceParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.initial_connection_type, rhs.initial_connection_type))
    return true;
  if (std::less<>{}(rhs.initial_connection_type, lhs.initial_connection_type))
    return false;
  if (std::less<>{}(lhs.initial_connection_subtype, rhs.initial_connection_subtype))
    return true;
  if (std::less<>{}(rhs.initial_connection_subtype, lhs.initial_connection_subtype))
    return false;
  if (std::less<>{}(lhs.environment, rhs.environment))
    return true;
  if (std::less<>{}(rhs.environment, lhs.environment))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct  StructTraits<::network::mojom::LoadInfo::DataView,
                                         ::network::mojom::LoadInfoPtr> {
  static bool IsNull(const ::network::mojom::LoadInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::LoadInfoPtr* output) { output->reset(); }

  static decltype(::network::mojom::LoadInfo::process_id) process_id(
      const ::network::mojom::LoadInfoPtr& input) {
    return input->process_id;
  }

  static decltype(::network::mojom::LoadInfo::routing_id) routing_id(
      const ::network::mojom::LoadInfoPtr& input) {
    return input->routing_id;
  }

  static const decltype(::network::mojom::LoadInfo::host)& host(
      const ::network::mojom::LoadInfoPtr& input) {
    return input->host;
  }

  static decltype(::network::mojom::LoadInfo::load_state) load_state(
      const ::network::mojom::LoadInfoPtr& input) {
    return input->load_state;
  }

  static const decltype(::network::mojom::LoadInfo::state_param)& state_param(
      const ::network::mojom::LoadInfoPtr& input) {
    return input->state_param;
  }

  static decltype(::network::mojom::LoadInfo::upload_position) upload_position(
      const ::network::mojom::LoadInfoPtr& input) {
    return input->upload_position;
  }

  static decltype(::network::mojom::LoadInfo::upload_size) upload_size(
      const ::network::mojom::LoadInfoPtr& input) {
    return input->upload_size;
  }

  static bool Read(::network::mojom::LoadInfo::DataView input, ::network::mojom::LoadInfoPtr* output);
};


template <>
struct  StructTraits<::network::mojom::HttpAuthStaticParams::DataView,
                                         ::network::mojom::HttpAuthStaticParamsPtr> {
  static bool IsNull(const ::network::mojom::HttpAuthStaticParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::HttpAuthStaticParamsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::HttpAuthStaticParams::supported_schemes)& supported_schemes(
      const ::network::mojom::HttpAuthStaticParamsPtr& input) {
    return input->supported_schemes;
  }

  static const decltype(::network::mojom::HttpAuthStaticParams::gssapi_library_name)& gssapi_library_name(
      const ::network::mojom::HttpAuthStaticParamsPtr& input) {
    return input->gssapi_library_name;
  }

  static bool Read(::network::mojom::HttpAuthStaticParams::DataView input, ::network::mojom::HttpAuthStaticParamsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::HttpAuthDynamicParams::DataView,
                                         ::network::mojom::HttpAuthDynamicParamsPtr> {
  static bool IsNull(const ::network::mojom::HttpAuthDynamicParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::HttpAuthDynamicParamsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::HttpAuthDynamicParams::server_allowlist)& server_allowlist(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->server_allowlist;
  }

  static const decltype(::network::mojom::HttpAuthDynamicParams::delegate_allowlist)& delegate_allowlist(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->delegate_allowlist;
  }

  static decltype(::network::mojom::HttpAuthDynamicParams::delegate_by_kdc_policy) delegate_by_kdc_policy(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->delegate_by_kdc_policy;
  }

  static decltype(::network::mojom::HttpAuthDynamicParams::negotiate_disable_cname_lookup) negotiate_disable_cname_lookup(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->negotiate_disable_cname_lookup;
  }

  static decltype(::network::mojom::HttpAuthDynamicParams::enable_negotiate_port) enable_negotiate_port(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->enable_negotiate_port;
  }

  static decltype(::network::mojom::HttpAuthDynamicParams::ntlm_v2_enabled) ntlm_v2_enabled(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->ntlm_v2_enabled;
  }

  static const decltype(::network::mojom::HttpAuthDynamicParams::android_negotiate_account_type)& android_negotiate_account_type(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->android_negotiate_account_type;
  }

  static decltype(::network::mojom::HttpAuthDynamicParams::allow_gssapi_library_load) allow_gssapi_library_load(
      const ::network::mojom::HttpAuthDynamicParamsPtr& input) {
    return input->allow_gssapi_library_load;
  }

  static bool Read(::network::mojom::HttpAuthDynamicParams::DataView input, ::network::mojom::HttpAuthDynamicParamsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CryptConfig::DataView,
                                         ::network::mojom::CryptConfigPtr> {
  static bool IsNull(const ::network::mojom::CryptConfigPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CryptConfigPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CryptConfig::store)& store(
      const ::network::mojom::CryptConfigPtr& input) {
    return input->store;
  }

  static const decltype(::network::mojom::CryptConfig::product_name)& product_name(
      const ::network::mojom::CryptConfigPtr& input) {
    return input->product_name;
  }

  static decltype(::network::mojom::CryptConfig::should_use_preference) should_use_preference(
      const ::network::mojom::CryptConfigPtr& input) {
    return input->should_use_preference;
  }

  static const decltype(::network::mojom::CryptConfig::user_data_path)& user_data_path(
      const ::network::mojom::CryptConfigPtr& input) {
    return input->user_data_path;
  }

  static bool Read(::network::mojom::CryptConfig::DataView input, ::network::mojom::CryptConfigPtr* output);
};


template <>
struct  StructTraits<::network::mojom::EnvironmentVariable::DataView,
                                         ::network::mojom::EnvironmentVariablePtr> {
  static bool IsNull(const ::network::mojom::EnvironmentVariablePtr& input) { return !input; }
  static void SetToNull(::network::mojom::EnvironmentVariablePtr* output) { output->reset(); }

  static const decltype(::network::mojom::EnvironmentVariable::name)& name(
      const ::network::mojom::EnvironmentVariablePtr& input) {
    return input->name;
  }

  static const decltype(::network::mojom::EnvironmentVariable::value)& value(
      const ::network::mojom::EnvironmentVariablePtr& input) {
    return input->value;
  }

  static bool Read(::network::mojom::EnvironmentVariable::DataView input, ::network::mojom::EnvironmentVariablePtr* output);
};


template <>
struct  StructTraits<::network::mojom::NetworkServiceParams::DataView,
                                         ::network::mojom::NetworkServiceParamsPtr> {
  static bool IsNull(const ::network::mojom::NetworkServiceParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::NetworkServiceParamsPtr* output) { output->reset(); }

  static decltype(::network::mojom::NetworkServiceParams::initial_connection_type) initial_connection_type(
      const ::network::mojom::NetworkServiceParamsPtr& input) {
    return input->initial_connection_type;
  }

  static decltype(::network::mojom::NetworkServiceParams::initial_connection_subtype) initial_connection_subtype(
      const ::network::mojom::NetworkServiceParamsPtr& input) {
    return input->initial_connection_subtype;
  }

  static const decltype(::network::mojom::NetworkServiceParams::environment)& environment(
      const ::network::mojom::NetworkServiceParamsPtr& input) {
    return input->environment;
  }

  static bool Read(::network::mojom::NetworkServiceParams::DataView input, ::network::mojom::NetworkServiceParamsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_H_