// services/network/public/mojom/network_context.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_SHARED_INTERNAL_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared-internal.h"
#include "services/network/public/mojom/address_list.mojom-shared-internal.h"
#include "services/network/public/mojom/cert_verifier_service.mojom-shared-internal.h"
#include "services/network/public/mojom/client_security_state.mojom-shared-internal.h"
#include "services/network/public/mojom/cookie_access_observer.mojom-shared-internal.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared-internal.h"
#include "services/network/public/mojom/cors_origin_pattern.mojom-shared-internal.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared-internal.h"
#include "services/network/public/mojom/default_credentials.mojom-shared-internal.h"
#include "services/network/public/mojom/host_resolver.mojom-shared-internal.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_address.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared-internal.h"
#include "services/network/public/mojom/mdns_responder.mojom-shared-internal.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared-internal.h"
#include "services/network/public/mojom/net_log.mojom-shared-internal.h"
#include "services/network/public/mojom/network_isolation_key.mojom-shared-internal.h"
#include "services/network/public/mojom/isolation_info.mojom-shared-internal.h"
#include "services/network/public/mojom/network_param.mojom-shared-internal.h"
#include "services/network/public/mojom/origin_policy_manager.mojom-shared-internal.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared-internal.h"
#include "services/network/public/mojom/p2p.mojom-shared-internal.h"
#include "services/network/public/mojom/p2p_trusted.mojom-shared-internal.h"
#include "services/network/public/mojom/proxy_config.mojom-shared-internal.h"
#include "services/network/public/mojom/proxy_config_with_annotation.mojom-shared-internal.h"
#include "services/network/public/mojom/proxy_lookup_client.mojom-shared-internal.h"
#include "services/network/public/mojom/proxy_resolving_socket.mojom-shared-internal.h"
#include "services/network/public/mojom/quic_transport.mojom-shared-internal.h"
#include "services/network/public/mojom/restricted_cookie_manager.mojom-shared-internal.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared-internal.h"
#include "services/network/public/mojom/ssl_config.mojom-shared-internal.h"
#include "services/network/public/mojom/tcp_socket.mojom-shared-internal.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared-internal.h"
#include "services/network/public/mojom/udp_socket.mojom-shared-internal.h"
#include "services/network/public/mojom/url_loader.mojom-shared-internal.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared-internal.h"
#include "services/network/public/mojom/url_response_head.mojom-shared-internal.h"
#include "services/network/public/mojom/websocket.mojom-shared-internal.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "services/network/public/mojom/ct_log_info.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace network {
namespace mojom {
namespace internal {
class CustomProxyConfig_Data;
class CertVerifierCreationParams_Data;
class CertVerifierServiceRemoteParams_Data;
class HttpAuthStaticNetworkContextParams_Data;
class CTPolicy_Data;
class NetworkContextParams_Data;
class NetworkConditions_Data;
class ClearDataFilter_Data;
class NetworkUsage_Data;
class SignedExchangeReport_Data;
class URLLoaderFactoryOverride_Data;
class URLLoaderFactoryParams_Data;
class CertVerifierParams_Data;

struct TrustTokenRedemptionPolicy_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct ClearDataFilter_Type_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct NetworkContext_DomainReliabilityClearMode_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class  CertVerifierParams_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  CertVerifierParams_Data() {}
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~CertVerifierParams_Data() {}

  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CertVerifierParams_Data));
      new (data()) CertVerifierParams_Data();
    }

    void AllocateInline(mojo::internal::Buffer* serialization_buffer,
                        void* ptr) {
      const char* start = static_cast<const char*>(
          serialization_buffer->data());
      const char* slot = static_cast<const char*>(ptr);
      DCHECK_GT(slot, start);
      serialization_buffer_ = serialization_buffer;
      index_ = slot - start;
      new (data()) CertVerifierParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CertVerifierParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CertVerifierParams_Data>(index_);
    }
    CertVerifierParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<CertVerifierParams_Tag>(0);
    data.unknown = 0U;
  }

  enum class CertVerifierParams_Tag : uint32_t {

    
    REMOTE_PARAMS,
    
    CREATION_PARAMS,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::CertVerifierServiceRemoteParams_Data> f_remote_params;
    mojo::internal::Pointer<internal::CertVerifierCreationParams_Data> f_creation_params;
    uint64_t unknown;
  };

  uint32_t size;
  CertVerifierParams_Tag tag;
  Union_ data;
};
static_assert(sizeof(CertVerifierParams_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(CertVerifierParams_Data)");
class  CustomProxyConfig_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CustomProxyConfig_Data));
      new (data()) CustomProxyConfig_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CustomProxyConfig_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CustomProxyConfig_Data>(index_);
    }
    CustomProxyConfig_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::ProxyRules_Data> rules;
  uint8_t should_override_existing_config : 1;
  uint8_t allow_non_idempotent_methods : 1;
  uint8_t pad2_[7];
  mojo::internal::Pointer<::network::mojom::internal::HttpRequestHeaders_Data> connect_tunnel_headers;

 private:
  CustomProxyConfig_Data();
  ~CustomProxyConfig_Data() = delete;
};
static_assert(sizeof(CustomProxyConfig_Data) == 32,
              "Bad sizeof(CustomProxyConfig_Data)");
// Used by CustomProxyConfig::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CustomProxyConfig_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CustomProxyConfig_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CustomProxyConfig_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    CustomProxyConfig_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CustomProxyConfig_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CertVerifierCreationParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CertVerifierCreationParams_Data));
      new (data()) CertVerifierCreationParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CertVerifierCreationParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CertVerifierCreationParams_Data>(index_);
    }
    CertVerifierCreationParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  CertVerifierCreationParams_Data();
  ~CertVerifierCreationParams_Data() = delete;
};
static_assert(sizeof(CertVerifierCreationParams_Data) == 8,
              "Bad sizeof(CertVerifierCreationParams_Data)");
// Used by CertVerifierCreationParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CertVerifierCreationParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CertVerifierCreationParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CertVerifierCreationParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    CertVerifierCreationParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CertVerifierCreationParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CertVerifierServiceRemoteParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CertVerifierServiceRemoteParams_Data));
      new (data()) CertVerifierServiceRemoteParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CertVerifierServiceRemoteParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CertVerifierServiceRemoteParams_Data>(index_);
    }
    CertVerifierServiceRemoteParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data cert_verifier_service;

 private:
  CertVerifierServiceRemoteParams_Data();
  ~CertVerifierServiceRemoteParams_Data() = delete;
};
static_assert(sizeof(CertVerifierServiceRemoteParams_Data) == 16,
              "Bad sizeof(CertVerifierServiceRemoteParams_Data)");
// Used by CertVerifierServiceRemoteParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CertVerifierServiceRemoteParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CertVerifierServiceRemoteParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CertVerifierServiceRemoteParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    CertVerifierServiceRemoteParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CertVerifierServiceRemoteParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  HttpAuthStaticNetworkContextParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(HttpAuthStaticNetworkContextParams_Data));
      new (data()) HttpAuthStaticNetworkContextParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    HttpAuthStaticNetworkContextParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<HttpAuthStaticNetworkContextParams_Data>(index_);
    }
    HttpAuthStaticNetworkContextParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t allow_default_credentials;
  uint8_t padfinal_[4];

 private:
  HttpAuthStaticNetworkContextParams_Data();
  ~HttpAuthStaticNetworkContextParams_Data() = delete;
};
static_assert(sizeof(HttpAuthStaticNetworkContextParams_Data) == 16,
              "Bad sizeof(HttpAuthStaticNetworkContextParams_Data)");
// Used by HttpAuthStaticNetworkContextParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct HttpAuthStaticNetworkContextParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  HttpAuthStaticNetworkContextParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~HttpAuthStaticNetworkContextParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    HttpAuthStaticNetworkContextParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    HttpAuthStaticNetworkContextParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CTPolicy_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CTPolicy_Data));
      new (data()) CTPolicy_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CTPolicy_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CTPolicy_Data>(index_);
    }
    CTPolicy_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> required_hosts;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> excluded_hosts;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> excluded_spkis;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> excluded_legacy_spkis;

 private:
  CTPolicy_Data();
  ~CTPolicy_Data() = delete;
};
static_assert(sizeof(CTPolicy_Data) == 40,
              "Bad sizeof(CTPolicy_Data)");
// Used by CTPolicy::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CTPolicy_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CTPolicy_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CTPolicy_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    CTPolicy_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CTPolicy_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  NetworkContextParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NetworkContextParams_Data));
      new (data()) NetworkContextParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NetworkContextParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NetworkContextParams_Data>(index_);
    }
    NetworkContextParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> context_name;
  mojo::internal::Pointer<mojo::internal::String_Data> user_agent;
  mojo::internal::Pointer<mojo::internal::String_Data> accept_language;
  uint8_t enable_brotli : 1;
  uint8_t enable_referrers : 1;
  uint8_t validate_referrer_policy_on_initial_request : 1;
  uint8_t enable_encrypted_cookies : 1;
  uint8_t restore_old_session_cookies : 1;
  uint8_t persist_session_cookies : 1;
  uint8_t http_cache_enabled : 1;
  uint8_t enable_ftp_url_support : 1;
  uint8_t disable_idle_sockets_close_on_memory_pressure : 1;
  uint8_t pac_quick_check_enabled : 1;
  uint8_t enable_certificate_reporting : 1;
  uint8_t enforce_chrome_ct_policy : 1;
  uint8_t enable_expect_ct_reporting : 1;
  uint8_t enable_sct_auditing : 1;
  uint8_t enable_domain_reliability : 1;
  uint8_t discard_domain_reliablity_uploads : 1;
  uint8_t skip_reporting_send_permission_check : 1;
  uint8_t allow_any_cors_exempt_header_for_browser : 1;
  uint8_t reset_http_cache_backend : 1;
  uint8_t split_auth_cache_by_network_isolation_key : 1;
  uint8_t require_network_isolation_key : 1;
  uint8_t pad23_[1];
  int32_t http_cache_max_size;
  mojo::internal::Pointer<mojo::internal::String_Data> quic_user_agent_id;
  mojo::internal::Interface_Data proxy_resolver_factory;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> cookie_path;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> trust_token_path;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> http_cache_path;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> http_server_properties_path;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> transport_security_persister_path;
  mojo::internal::Pointer<::network::mojom::internal::SSLConfig_Data> initial_ssl_config;
  mojo::internal::Handle_Data ssl_config_client_receiver;
  mojo::internal::Handle_Data proxy_config_client_receiver;
  mojo::internal::Pointer<::network::mojom::internal::ProxyConfigWithAnnotation_Data> initial_proxy_config;
  mojo::internal::Pointer<internal::CustomProxyConfig_Data> initial_custom_proxy_config;
  mojo::internal::Handle_Data custom_proxy_config_client_receiver;
  mojo::internal::Interface_Data proxy_config_poller_client;
  mojo::internal::Interface_Data proxy_error_client;
  mojo::internal::Handle_Data cookie_manager;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::CTLogInfo_Data>>> ct_logs;
  mojo::internal::Pointer<internal::CTPolicy_Data> ct_policy;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> ct_log_update_time;
  internal::CertVerifierParams_Data cert_verifier_params;
  mojo::internal::Pointer<::network::mojom::internal::CookieManagerParams_Data> cookie_manager_params;
  mojo::internal::Pointer<mojo::internal::String_Data> domain_reliability_upload_reporter;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> reporting_delivery_interval;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::CorsOriginAccessPatterns_Data>>> cors_origin_access_list;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> cors_exempt_header_list;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> hsts_policy_bypass_list;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> reporting_and_nel_store_path;
  mojo::internal::Pointer<internal::HttpAuthStaticNetworkContextParams_Data> http_auth_static_network_context_params;

 private:
  NetworkContextParams_Data();
  ~NetworkContextParams_Data() = delete;
};
static_assert(sizeof(NetworkContextParams_Data) == 256,
              "Bad sizeof(NetworkContextParams_Data)");
// Used by NetworkContextParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct NetworkContextParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  NetworkContextParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~NetworkContextParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    NetworkContextParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    NetworkContextParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  NetworkConditions_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NetworkConditions_Data));
      new (data()) NetworkConditions_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NetworkConditions_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NetworkConditions_Data>(index_);
    }
    NetworkConditions_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t offline : 1;
  uint8_t pad0_[7];
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> latency;
  double download_throughput;
  double upload_throughput;

 private:
  NetworkConditions_Data();
  ~NetworkConditions_Data() = delete;
};
static_assert(sizeof(NetworkConditions_Data) == 40,
              "Bad sizeof(NetworkConditions_Data)");
// Used by NetworkConditions::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct NetworkConditions_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  NetworkConditions_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~NetworkConditions_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    NetworkConditions_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    NetworkConditions_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ClearDataFilter_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ClearDataFilter_Data));
      new (data()) ClearDataFilter_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ClearDataFilter_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ClearDataFilter_Data>(index_);
    }
    ClearDataFilter_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> domains;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::url::mojom::internal::Origin_Data>>> origins;

 private:
  ClearDataFilter_Data();
  ~ClearDataFilter_Data() = delete;
};
static_assert(sizeof(ClearDataFilter_Data) == 32,
              "Bad sizeof(ClearDataFilter_Data)");
// Used by ClearDataFilter::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ClearDataFilter_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ClearDataFilter_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ClearDataFilter_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    ClearDataFilter_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ClearDataFilter_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  NetworkUsage_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NetworkUsage_Data));
      new (data()) NetworkUsage_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NetworkUsage_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NetworkUsage_Data>(index_);
    }
    NetworkUsage_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t process_id;
  int32_t routing_id;
  int64_t total_bytes_received;
  int64_t total_bytes_sent;

 private:
  NetworkUsage_Data();
  ~NetworkUsage_Data() = delete;
};
static_assert(sizeof(NetworkUsage_Data) == 32,
              "Bad sizeof(NetworkUsage_Data)");
// Used by NetworkUsage::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct NetworkUsage_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  NetworkUsage_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~NetworkUsage_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    NetworkUsage_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    NetworkUsage_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SignedExchangeReport_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(SignedExchangeReport_Data));
      new (data()) SignedExchangeReport_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    SignedExchangeReport_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<SignedExchangeReport_Data>(index_);
    }
    SignedExchangeReport_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t pad0_[3];
  int32_t status_code;
  mojo::internal::Pointer<mojo::internal::String_Data> type;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> outer_url;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> inner_url;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> cert_url;
  mojo::internal::Pointer<mojo::internal::String_Data> referrer;
  mojo::internal::Pointer<::network::mojom::internal::IPAddress_Data> server_ip_address;
  mojo::internal::Pointer<mojo::internal::String_Data> protocol;
  mojo::internal::Pointer<mojo::internal::String_Data> method;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> elapsed_time;

 private:
  SignedExchangeReport_Data();
  ~SignedExchangeReport_Data() = delete;
};
static_assert(sizeof(SignedExchangeReport_Data) == 88,
              "Bad sizeof(SignedExchangeReport_Data)");
// Used by SignedExchangeReport::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SignedExchangeReport_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SignedExchangeReport_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SignedExchangeReport_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    SignedExchangeReport_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SignedExchangeReport_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  URLLoaderFactoryOverride_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(URLLoaderFactoryOverride_Data));
      new (data()) URLLoaderFactoryOverride_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    URLLoaderFactoryOverride_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<URLLoaderFactoryOverride_Data>(index_);
    }
    URLLoaderFactoryOverride_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data overriding_factory;
  mojo::internal::Handle_Data overridden_factory_receiver;
  uint8_t skip_cors_enabled_scheme_check : 1;
  uint8_t padfinal_[3];

 private:
  URLLoaderFactoryOverride_Data();
  ~URLLoaderFactoryOverride_Data() = delete;
};
static_assert(sizeof(URLLoaderFactoryOverride_Data) == 24,
              "Bad sizeof(URLLoaderFactoryOverride_Data)");
// Used by URLLoaderFactoryOverride::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct URLLoaderFactoryOverride_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  URLLoaderFactoryOverride_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~URLLoaderFactoryOverride_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    URLLoaderFactoryOverride_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    URLLoaderFactoryOverride_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  URLLoaderFactoryParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(URLLoaderFactoryParams_Data));
      new (data()) URLLoaderFactoryParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    URLLoaderFactoryParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<URLLoaderFactoryParams_Data>(index_);
    }
    URLLoaderFactoryParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t process_id;
  uint8_t is_corb_enabled : 1;
  uint8_t ignore_isolated_world_origin : 1;
  uint8_t unsafe_non_webby_initiator : 1;
  uint8_t disable_web_security : 1;
  uint8_t disable_secure_dns : 1;
  uint8_t is_trusted : 1;
  uint8_t automatically_assign_isolation_info : 1;
  uint8_t pad7_[3];
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> request_initiator_origin_lock;
  mojo::internal::Interface_Data header_client;
  mojo::internal::Pointer<::network::mojom::internal::CorsOriginAccessPatterns_Data> factory_bound_access_patterns;
  mojo::internal::Pointer<::network::mojom::internal::IsolationInfo_Data> isolation_info;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> top_frame_id;
  mojo::internal::Pointer<internal::URLLoaderFactoryOverride_Data> factory_override;
  mojo::internal::Pointer<::network::mojom::internal::ClientSecurityState_Data> client_security_state;
  mojo::internal::Interface_Data coep_reporter;
  mojo::internal::Interface_Data cookie_observer;
  int32_t trust_token_redemption_policy;
  uint8_t pad17_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> debug_tag;

 private:
  URLLoaderFactoryParams_Data();
  ~URLLoaderFactoryParams_Data() = delete;
};
static_assert(sizeof(URLLoaderFactoryParams_Data) == 104,
              "Bad sizeof(URLLoaderFactoryParams_Data)");
// Used by URLLoaderFactoryParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct URLLoaderFactoryParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  URLLoaderFactoryParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~URLLoaderFactoryParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    URLLoaderFactoryParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    URLLoaderFactoryParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace network

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_SHARED_INTERNAL_H_