// services/network/public/mojom/cross_origin_embedder_policy.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/cross_origin_embedder_policy.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-params-data.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared-message-ids.h"

#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_EMBEDDER_POLICY_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_EMBEDDER_POLICY_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
CrossOriginEmbedderPolicy::CrossOriginEmbedderPolicy()
    : value(CrossOriginEmbedderPolicyValue::kNone),
      reporting_endpoint(),
      report_only_value(CrossOriginEmbedderPolicyValue::kNone),
      report_only_reporting_endpoint() {}

CrossOriginEmbedderPolicy::CrossOriginEmbedderPolicy(
    CrossOriginEmbedderPolicyValue value_in,
    const base::Optional<std::string>& reporting_endpoint_in,
    CrossOriginEmbedderPolicyValue report_only_value_in,
    const base::Optional<std::string>& report_only_reporting_endpoint_in)
    : value(std::move(value_in)),
      reporting_endpoint(std::move(reporting_endpoint_in)),
      report_only_value(std::move(report_only_value_in)),
      report_only_reporting_endpoint(std::move(report_only_reporting_endpoint_in)) {}

CrossOriginEmbedderPolicy::~CrossOriginEmbedderPolicy() = default;

void CrossOriginEmbedderPolicy::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("value", base::trace_event::ValueToString(this->value));
  if (this->reporting_endpoint.has_value()) {
    value->SetString("reporting_endpoint", this->reporting_endpoint.value());
  } else {
    value->SetString("reporting_endpoint", "base::nullopt");
  }
  value->SetString("report_only_value", base::trace_event::ValueToString(this->report_only_value));
  if (this->report_only_reporting_endpoint.has_value()) {
    value->SetString("report_only_reporting_endpoint", this->report_only_reporting_endpoint.value());
  } else {
    value->SetString("report_only_reporting_endpoint", "base::nullopt");
  }
}

bool CrossOriginEmbedderPolicy::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char CrossOriginEmbedderPolicyReporter::Name_[] = "network.mojom.CrossOriginEmbedderPolicyReporter";

CrossOriginEmbedderPolicyReporterProxy::CrossOriginEmbedderPolicyReporterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CrossOriginEmbedderPolicyReporterProxy::QueueCorpViolationReport(
    const ::GURL& in_blocked_url, ::network::mojom::RequestDestination in_destination, bool in_report_only) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CrossOriginEmbedderPolicyReporter::QueueCorpViolationReport", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("blocked_url", base::trace_event::ValueToString(in_blocked_url, "<value of type const ::GURL&>"));
      raw_value->SetString("destination", base::trace_event::ValueToString(in_destination));
      raw_value->SetBoolean("report_only", in_report_only);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->blocked_url)::BaseType::BufferWriter
      blocked_url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_blocked_url, buffer, &blocked_url_writer, &serialization_context);
  params->blocked_url.Set(
      blocked_url_writer.is_null() ? nullptr : blocked_url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->blocked_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null blocked_url in CrossOriginEmbedderPolicyReporter.QueueCorpViolationReport request");
  mojo::internal::Serialize<::network::mojom::RequestDestination>(
      in_destination, &params->destination);
  params->report_only = in_report_only;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CrossOriginEmbedderPolicyReporter::Name_);
  message.set_method_name("QueueCorpViolationReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CrossOriginEmbedderPolicyReporterProxy::Clone(
    ::mojo::PendingReceiver<CrossOriginEmbedderPolicyReporter> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CrossOriginEmbedderPolicyReporter::Clone", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCrossOriginEmbedderPolicyReporter_Clone_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CrossOriginEmbedderPolicyReporter_Clone_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::CrossOriginEmbedderPolicyReporterInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in CrossOriginEmbedderPolicyReporter.Clone request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CrossOriginEmbedderPolicyReporter::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CrossOriginEmbedderPolicyReporterStubDispatch::Accept(
    CrossOriginEmbedderPolicyReporter* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kCrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CrossOriginEmbedderPolicyReporter::QueueCorpViolationReport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CrossOriginEmbedderPolicyReporter::QueueCorpViolationReport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data* params =
          reinterpret_cast<internal::CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_blocked_url{};
      ::network::mojom::RequestDestination p_destination{};
      bool p_report_only{};
      CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadBlockedUrl(&p_blocked_url))
        success = false;
      if (success && !input_data_view.ReadDestination(&p_destination))
        success = false;
      if (success)
        p_report_only = input_data_view.report_only();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CrossOriginEmbedderPolicyReporter::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueCorpViolationReport(
std::move(p_blocked_url), 
std::move(p_destination), 
std::move(p_report_only));
      return true;
    }
    case internal::kCrossOriginEmbedderPolicyReporter_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CrossOriginEmbedderPolicyReporter::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CrossOriginEmbedderPolicyReporter::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CrossOriginEmbedderPolicyReporter_Clone_Params_Data* params =
          reinterpret_cast<internal::CrossOriginEmbedderPolicyReporter_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<CrossOriginEmbedderPolicyReporter> p_receiver{};
      CrossOriginEmbedderPolicyReporter_Clone_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CrossOriginEmbedderPolicyReporter::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool CrossOriginEmbedderPolicyReporterStubDispatch::AcceptWithResponder(
    CrossOriginEmbedderPolicyReporter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Name: {
      break;
    }
    case internal::kCrossOriginEmbedderPolicyReporter_Clone_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCrossOriginEmbedderPolicyReporterValidationInfo[] = {
    {internal::kCrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Name,
     {&internal::CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCrossOriginEmbedderPolicyReporter_Clone_Name,
     {&internal::CrossOriginEmbedderPolicyReporter_Clone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CrossOriginEmbedderPolicyReporterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::CrossOriginEmbedderPolicyReporter::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCrossOriginEmbedderPolicyReporterValidationInfo);
}

}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::CrossOriginEmbedderPolicy::DataView, ::network::mojom::CrossOriginEmbedderPolicyPtr>::Read(
    ::network::mojom::CrossOriginEmbedderPolicy::DataView input,
    ::network::mojom::CrossOriginEmbedderPolicyPtr* output) {
  bool success = true;
  ::network::mojom::CrossOriginEmbedderPolicyPtr result(::network::mojom::CrossOriginEmbedderPolicy::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadReportingEndpoint(&result->reporting_endpoint))
        success = false;
      if (success && !input.ReadReportOnlyValue(&result->report_only_value))
        success = false;
      if (success && !input.ReadReportOnlyReportingEndpoint(&result->report_only_reporting_endpoint))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif