// services/network/public/mojom/cors_origin_pattern.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/cors_origin_pattern.mojom-shared.h"
#include "services/network/public/mojom/cors_origin_pattern.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>







// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {









class  CorsOriginPattern {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CorsOriginPattern, T>::value>;
  using DataView = CorsOriginPatternDataView;
  using Data_ = internal::CorsOriginPattern_Data;

  template <typename... Args>
  static CorsOriginPatternPtr New(Args&&... args) {
    return CorsOriginPatternPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CorsOriginPatternPtr From(const U& u) {
    return mojo::TypeConverter<CorsOriginPatternPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CorsOriginPattern>::Convert(*this);
  }


  CorsOriginPattern();

  CorsOriginPattern(
      const std::string& protocol,
      const std::string& domain,
      uint16_t port,
      CorsDomainMatchMode domain_match_mode,
      CorsPortMatchMode port_match_mode,
      CorsOriginAccessMatchPriority priority);

  ~CorsOriginPattern();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CorsOriginPatternPtr>
  CorsOriginPatternPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CorsOriginPattern::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CorsOriginPattern::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CorsOriginPattern::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CorsOriginPattern_UnserializedMessageContext<
            UserType, CorsOriginPattern::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CorsOriginPattern::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CorsOriginPattern::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CorsOriginPattern_UnserializedMessageContext<
            UserType, CorsOriginPattern::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CorsOriginPattern::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string protocol;
  
  std::string domain;
  
  uint16_t port;
  
  CorsDomainMatchMode domain_match_mode;
  
  CorsPortMatchMode port_match_mode;
  
  CorsOriginAccessMatchPriority priority;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CorsOriginPattern::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CorsOriginPattern::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CorsOriginPattern::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CorsOriginPattern::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CorsOriginAccessPatterns {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CorsOriginAccessPatterns, T>::value>;
  using DataView = CorsOriginAccessPatternsDataView;
  using Data_ = internal::CorsOriginAccessPatterns_Data;

  template <typename... Args>
  static CorsOriginAccessPatternsPtr New(Args&&... args) {
    return CorsOriginAccessPatternsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CorsOriginAccessPatternsPtr From(const U& u) {
    return mojo::TypeConverter<CorsOriginAccessPatternsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CorsOriginAccessPatterns>::Convert(*this);
  }


  CorsOriginAccessPatterns();

  CorsOriginAccessPatterns(
      const ::url::Origin& source_origin,
      std::vector<CorsOriginPatternPtr> allow_patterns,
      std::vector<CorsOriginPatternPtr> block_patterns);

  ~CorsOriginAccessPatterns();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CorsOriginAccessPatternsPtr>
  CorsOriginAccessPatternsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CorsOriginAccessPatterns::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CorsOriginAccessPatterns::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CorsOriginAccessPatterns::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CorsOriginAccessPatterns_UnserializedMessageContext<
            UserType, CorsOriginAccessPatterns::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CorsOriginAccessPatterns::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CorsOriginAccessPatterns::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CorsOriginAccessPatterns_UnserializedMessageContext<
            UserType, CorsOriginAccessPatterns::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CorsOriginAccessPatterns::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::url::Origin source_origin;
  
  std::vector<CorsOriginPatternPtr> allow_patterns;
  
  std::vector<CorsOriginPatternPtr> block_patterns;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CorsOriginAccessPatterns);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CorsOriginAccessPatterns::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CorsOriginAccessPatterns::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CorsOriginAccessPatterns::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CorsOriginAccessPatterns::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CorsOriginPatternPtr CorsOriginPattern::Clone() const {
  return New(
      mojo::Clone(protocol),
      mojo::Clone(domain),
      mojo::Clone(port),
      mojo::Clone(domain_match_mode),
      mojo::Clone(port_match_mode),
      mojo::Clone(priority)
  );
}

template <typename T, CorsOriginPattern::EnableIfSame<T>*>
bool CorsOriginPattern::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->protocol, other_struct.protocol))
    return false;
  if (!mojo::Equals(this->domain, other_struct.domain))
    return false;
  if (!mojo::Equals(this->port, other_struct.port))
    return false;
  if (!mojo::Equals(this->domain_match_mode, other_struct.domain_match_mode))
    return false;
  if (!mojo::Equals(this->port_match_mode, other_struct.port_match_mode))
    return false;
  if (!mojo::Equals(this->priority, other_struct.priority))
    return false;
  return true;
}

template <typename T, CorsOriginPattern::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.protocol, rhs.protocol))
    return true;
  if (std::less<>{}(rhs.protocol, lhs.protocol))
    return false;
  if (std::less<>{}(lhs.domain, rhs.domain))
    return true;
  if (std::less<>{}(rhs.domain, lhs.domain))
    return false;
  if (std::less<>{}(lhs.port, rhs.port))
    return true;
  if (std::less<>{}(rhs.port, lhs.port))
    return false;
  if (std::less<>{}(lhs.domain_match_mode, rhs.domain_match_mode))
    return true;
  if (std::less<>{}(rhs.domain_match_mode, lhs.domain_match_mode))
    return false;
  if (std::less<>{}(lhs.port_match_mode, rhs.port_match_mode))
    return true;
  if (std::less<>{}(rhs.port_match_mode, lhs.port_match_mode))
    return false;
  if (std::less<>{}(lhs.priority, rhs.priority))
    return true;
  if (std::less<>{}(rhs.priority, lhs.priority))
    return false;
  return false;
}
template <typename StructPtrType>
CorsOriginAccessPatternsPtr CorsOriginAccessPatterns::Clone() const {
  return New(
      mojo::Clone(source_origin),
      mojo::Clone(allow_patterns),
      mojo::Clone(block_patterns)
  );
}

template <typename T, CorsOriginAccessPatterns::EnableIfSame<T>*>
bool CorsOriginAccessPatterns::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->source_origin, other_struct.source_origin))
    return false;
  if (!mojo::Equals(this->allow_patterns, other_struct.allow_patterns))
    return false;
  if (!mojo::Equals(this->block_patterns, other_struct.block_patterns))
    return false;
  return true;
}

template <typename T, CorsOriginAccessPatterns::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.source_origin, rhs.source_origin))
    return true;
  if (std::less<>{}(rhs.source_origin, lhs.source_origin))
    return false;
  if (std::less<>{}(lhs.allow_patterns, rhs.allow_patterns))
    return true;
  if (std::less<>{}(rhs.allow_patterns, lhs.allow_patterns))
    return false;
  if (std::less<>{}(lhs.block_patterns, rhs.block_patterns))
    return true;
  if (std::less<>{}(rhs.block_patterns, lhs.block_patterns))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct  StructTraits<::network::mojom::CorsOriginPattern::DataView,
                                         ::network::mojom::CorsOriginPatternPtr> {
  static bool IsNull(const ::network::mojom::CorsOriginPatternPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CorsOriginPatternPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CorsOriginPattern::protocol)& protocol(
      const ::network::mojom::CorsOriginPatternPtr& input) {
    return input->protocol;
  }

  static const decltype(::network::mojom::CorsOriginPattern::domain)& domain(
      const ::network::mojom::CorsOriginPatternPtr& input) {
    return input->domain;
  }

  static decltype(::network::mojom::CorsOriginPattern::port) port(
      const ::network::mojom::CorsOriginPatternPtr& input) {
    return input->port;
  }

  static decltype(::network::mojom::CorsOriginPattern::domain_match_mode) domain_match_mode(
      const ::network::mojom::CorsOriginPatternPtr& input) {
    return input->domain_match_mode;
  }

  static decltype(::network::mojom::CorsOriginPattern::port_match_mode) port_match_mode(
      const ::network::mojom::CorsOriginPatternPtr& input) {
    return input->port_match_mode;
  }

  static decltype(::network::mojom::CorsOriginPattern::priority) priority(
      const ::network::mojom::CorsOriginPatternPtr& input) {
    return input->priority;
  }

  static bool Read(::network::mojom::CorsOriginPattern::DataView input, ::network::mojom::CorsOriginPatternPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CorsOriginAccessPatterns::DataView,
                                         ::network::mojom::CorsOriginAccessPatternsPtr> {
  static bool IsNull(const ::network::mojom::CorsOriginAccessPatternsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CorsOriginAccessPatternsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CorsOriginAccessPatterns::source_origin)& source_origin(
      const ::network::mojom::CorsOriginAccessPatternsPtr& input) {
    return input->source_origin;
  }

  static const decltype(::network::mojom::CorsOriginAccessPatterns::allow_patterns)& allow_patterns(
      const ::network::mojom::CorsOriginAccessPatternsPtr& input) {
    return input->allow_patterns;
  }

  static const decltype(::network::mojom::CorsOriginAccessPatterns::block_patterns)& block_patterns(
      const ::network::mojom::CorsOriginAccessPatternsPtr& input) {
    return input->block_patterns;
  }

  static bool Read(::network::mojom::CorsOriginAccessPatterns::DataView input, ::network::mojom::CorsOriginAccessPatternsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_H_