// services/network/public/mojom/content_security_policy.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/source_location.mojom-shared.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"







namespace network {
namespace mojom {
class ContentSecurityPolicyHeaderDataView;

class CSPSourceDataView;

class CSPHashSourceDataView;

class CSPSourceListDataView;

class ContentSecurityPolicyDataView;

class CSPViolationDataView;

class AllowCSPFromHeaderValueDataView;


}  // namespace mojom
}  // namespace network

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::ContentSecurityPolicyHeaderDataView> {
  using Data = ::network::mojom::internal::ContentSecurityPolicyHeader_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CSPSourceDataView> {
  using Data = ::network::mojom::internal::CSPSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CSPHashSourceDataView> {
  using Data = ::network::mojom::internal::CSPHashSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CSPSourceListDataView> {
  using Data = ::network::mojom::internal::CSPSourceList_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ContentSecurityPolicyDataView> {
  using Data = ::network::mojom::internal::ContentSecurityPolicy_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CSPViolationDataView> {
  using Data = ::network::mojom::internal::CSPViolation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::AllowCSPFromHeaderValueDataView> {
  using Data = ::network::mojom::internal::AllowCSPFromHeaderValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network {
namespace mojom {


enum class ContentSecurityPolicyType : int32_t {
  
  kReport = 0,
  
  kEnforce = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ContentSecurityPolicyType value);
inline bool IsKnownEnumValue(ContentSecurityPolicyType value) {
  return internal::ContentSecurityPolicyType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ContentSecurityPolicySource : int32_t {
  
  kHTTP = 0,
  
  kMeta = 1,
  
  kOriginPolicy = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ContentSecurityPolicySource value);
inline bool IsKnownEnumValue(ContentSecurityPolicySource value) {
  return internal::ContentSecurityPolicySource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CSPDisposition : int32_t {
  
  CHECK = 0,
  
  DO_NOT_CHECK = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CSPDisposition value);
inline bool IsKnownEnumValue(CSPDisposition value) {
  return internal::CSPDisposition_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CSPHashAlgorithm : int32_t {
  
  SHA256 = 0,
  
  SHA384 = 1,
  
  SHA512 = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CSPHashAlgorithm value);
inline bool IsKnownEnumValue(CSPHashAlgorithm value) {
  return internal::CSPHashAlgorithm_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CSPDirectiveName : int32_t {
  
  Unknown = 0,
  
  BaseURI = 1,
  
  BlockAllMixedContent = 2,
  
  ChildSrc = 3,
  
  ConnectSrc = 4,
  
  DefaultSrc = 5,
  
  FontSrc = 6,
  
  FormAction = 7,
  
  FrameAncestors = 8,
  
  FrameSrc = 9,
  
  ImgSrc = 10,
  
  ManifestSrc = 11,
  
  MediaSrc = 12,
  
  NavigateTo = 13,
  
  ObjectSrc = 14,
  
  PluginTypes = 15,
  
  PrefetchSrc = 16,
  
  ReportTo = 17,
  
  ReportURI = 18,
  
  RequireTrustedTypesFor = 19,
  
  Sandbox = 20,
  
  ScriptSrc = 21,
  
  ScriptSrcAttr = 22,
  
  ScriptSrcElem = 23,
  
  StyleSrc = 24,
  
  StyleSrcAttr = 25,
  
  StyleSrcElem = 26,
  
  TreatAsPublicAddress = 27,
  
  TrustedTypes = 28,
  
  UpgradeInsecureRequests = 29,
  
  WorkerSrc = 30,
  kMinValue = 0,
  kMaxValue = 30,
};

 std::ostream& operator<<(std::ostream& os, CSPDirectiveName value);
inline bool IsKnownEnumValue(CSPDirectiveName value) {
  return internal::CSPDirectiveName_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ContentSecurityPolicyHeaderDataView {
 public:
  ContentSecurityPolicyHeaderDataView() {}

  ContentSecurityPolicyHeaderDataView(
      internal::ContentSecurityPolicyHeader_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetHeaderValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHeaderValue(UserType* output) {
    
    auto* pointer = data_->header_value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::ContentSecurityPolicyType>(
        data_value, output);
  }

  ContentSecurityPolicyType type() const {
    return static_cast<ContentSecurityPolicyType>(data_->type);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSource(UserType* output) const {
    auto data_value = data_->source;
    return mojo::internal::Deserialize<::network::mojom::ContentSecurityPolicySource>(
        data_value, output);
  }

  ContentSecurityPolicySource source() const {
    return static_cast<ContentSecurityPolicySource>(data_->source);
  }
 private:
  internal::ContentSecurityPolicyHeader_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CSPSourceDataView {
 public:
  CSPSourceDataView() {}

  CSPSourceDataView(
      internal::CSPSource_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSchemeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScheme(UserType* output) {
    
    auto* pointer = data_->scheme.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetHostDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHost(UserType* output) {
    
    auto* pointer = data_->host.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  int32_t port() const {
    return data_->port;
  }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  bool is_host_wildcard() const {
    return data_->is_host_wildcard;
  }
  bool is_port_wildcard() const {
    return data_->is_port_wildcard;
  }
 private:
  internal::CSPSource_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CSPHashSourceDataView {
 public:
  CSPHashSourceDataView() {}

  CSPHashSourceDataView(
      internal::CSPHashSource_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAlgorithm(UserType* output) const {
    auto data_value = data_->algorithm;
    return mojo::internal::Deserialize<::network::mojom::CSPHashAlgorithm>(
        data_value, output);
  }

  CSPHashAlgorithm algorithm() const {
    return static_cast<CSPHashAlgorithm>(data_->algorithm);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::CSPHashSource_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CSPSourceListDataView {
 public:
  CSPSourceListDataView() {}

  CSPSourceListDataView(
      internal::CSPSourceList_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSourcesDataView(
      mojo::ArrayDataView<CSPSourceDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSources(UserType* output) {
    
    auto* pointer = data_->sources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CSPSourceDataView>>(
        pointer, output, context_);
  }
  inline void GetNoncesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNonces(UserType* output) {
    
    auto* pointer = data_->nonces.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetHashesDataView(
      mojo::ArrayDataView<CSPHashSourceDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHashes(UserType* output) {
    
    auto* pointer = data_->hashes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CSPHashSourceDataView>>(
        pointer, output, context_);
  }
  bool allow_self() const {
    return data_->allow_self;
  }
  bool allow_star() const {
    return data_->allow_star;
  }
  bool allow_response_redirects() const {
    return data_->allow_response_redirects;
  }
  bool allow_inline() const {
    return data_->allow_inline;
  }
  bool allow_eval() const {
    return data_->allow_eval;
  }
  bool allow_wasm_eval() const {
    return data_->allow_wasm_eval;
  }
  bool allow_dynamic() const {
    return data_->allow_dynamic;
  }
  bool allow_unsafe_hashes() const {
    return data_->allow_unsafe_hashes;
  }
  bool report_sample() const {
    return data_->report_sample;
  }
 private:
  internal::CSPSourceList_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ContentSecurityPolicyDataView {
 public:
  ContentSecurityPolicyDataView() {}

  ContentSecurityPolicyDataView(
      internal::ContentSecurityPolicy_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDirectivesDataView(
      mojo::MapDataView<CSPDirectiveName, CSPSourceListDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDirectives(UserType* output) {
    
    auto* pointer = data_->directives.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::network::mojom::CSPDirectiveName, ::network::mojom::CSPSourceListDataView>>(
        pointer, output, context_);
  }
  bool upgrade_insecure_requests() const {
    return data_->upgrade_insecure_requests;
  }
  bool treat_as_public_address() const {
    return data_->treat_as_public_address;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSandbox(UserType* output) const {
    auto data_value = data_->sandbox;
    return mojo::internal::Deserialize<::network::mojom::WebSandboxFlags>(
        data_value, output);
  }

  ::network::mojom::WebSandboxFlags sandbox() const {
    return static_cast<::network::mojom::WebSandboxFlags>(data_->sandbox);
  }
  inline void GetHeaderDataView(
      ContentSecurityPolicyHeaderDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHeader(UserType* output) {
    
    auto* pointer = data_->header.Get();
    return mojo::internal::Deserialize<::network::mojom::ContentSecurityPolicyHeaderDataView>(
        pointer, output, context_);
  }
  bool use_reporting_api() const {
    return data_->use_reporting_api;
  }
  inline void GetReportEndpointsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReportEndpoints(UserType* output) {
    
    auto* pointer = data_->report_endpoints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetPluginTypesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPluginTypes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `plugin_types` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPluginTypes` instead "
    "of `ReadPluginTypes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->plugin_types.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetParsingErrorsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParsingErrors(UserType* output) {
    
    auto* pointer = data_->parsing_errors.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
 private:
  internal::ContentSecurityPolicy_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CSPViolationDataView {
 public:
  CSPViolationDataView() {}

  CSPViolationDataView(
      internal::CSPViolation_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDirectiveDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDirective(UserType* output) {
    
    auto* pointer = data_->directive.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetEffectiveDirectiveDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEffectiveDirective(UserType* output) {
    
    auto* pointer = data_->effective_directive.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetConsoleMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadConsoleMessage(UserType* output) {
    
    auto* pointer = data_->console_message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetBlockedUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBlockedUrl(UserType* output) {
    
    auto* pointer = data_->blocked_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetReportEndpointsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReportEndpoints(UserType* output) {
    
    auto* pointer = data_->report_endpoints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  bool use_reporting_api() const {
    return data_->use_reporting_api;
  }
  inline void GetHeaderDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHeader(UserType* output) {
    
    auto* pointer = data_->header.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::ContentSecurityPolicyType>(
        data_value, output);
  }

  ContentSecurityPolicyType type() const {
    return static_cast<ContentSecurityPolicyType>(data_->type);
  }
  bool after_redirect() const {
    return data_->after_redirect;
  }
  inline void GetSourceLocationDataView(
      ::network::mojom::SourceLocationDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSourceLocation(UserType* output) {
    
    auto* pointer = data_->source_location.Get();
    return mojo::internal::Deserialize<::network::mojom::SourceLocationDataView>(
        pointer, output, context_);
  }
 private:
  internal::CSPViolation_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class AllowCSPFromHeaderValueDataView {
 public:
  using Tag = internal::AllowCSPFromHeaderValue_Data::AllowCSPFromHeaderValue_Tag;

  AllowCSPFromHeaderValueDataView() {}

  AllowCSPFromHeaderValueDataView(
      internal::AllowCSPFromHeaderValue_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_allow_star() const { return data_->tag == Tag::ALLOW_STAR; }
  bool allow_star() const {
    DCHECK(is_allow_star());
    return data_->data.f_allow_star;
  }
  bool is_origin() const { return data_->tag == Tag::ORIGIN; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOrigin(UserType* output) {
    
    DCHECK(is_origin());
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        data_->data.f_origin.Get(), output, context_);
  }
  bool is_error_message() const { return data_->tag == Tag::ERROR_MESSAGE; }
  inline void GetErrorMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadErrorMessage(UserType* output) {
    
    DCHECK(is_error_message());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_error_message.Get(), output, context_);
  }

 private:
  internal::AllowCSPFromHeaderValue_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace network

namespace std {

template <>
struct hash<::network::mojom::ContentSecurityPolicyType>
    : public mojo::internal::EnumHashImpl<::network::mojom::ContentSecurityPolicyType> {};

template <>
struct hash<::network::mojom::ContentSecurityPolicySource>
    : public mojo::internal::EnumHashImpl<::network::mojom::ContentSecurityPolicySource> {};

template <>
struct hash<::network::mojom::CSPDisposition>
    : public mojo::internal::EnumHashImpl<::network::mojom::CSPDisposition> {};

template <>
struct hash<::network::mojom::CSPHashAlgorithm>
    : public mojo::internal::EnumHashImpl<::network::mojom::CSPHashAlgorithm> {};

template <>
struct hash<::network::mojom::CSPDirectiveName>
    : public mojo::internal::EnumHashImpl<::network::mojom::CSPDirectiveName> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::network::mojom::ContentSecurityPolicyType, ::network::mojom::ContentSecurityPolicyType> {
  static ::network::mojom::ContentSecurityPolicyType ToMojom(::network::mojom::ContentSecurityPolicyType input) { return input; }
  static bool FromMojom(::network::mojom::ContentSecurityPolicyType input, ::network::mojom::ContentSecurityPolicyType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ContentSecurityPolicyType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ContentSecurityPolicyType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::ContentSecurityPolicyType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::network::mojom::ContentSecurityPolicySource, ::network::mojom::ContentSecurityPolicySource> {
  static ::network::mojom::ContentSecurityPolicySource ToMojom(::network::mojom::ContentSecurityPolicySource input) { return input; }
  static bool FromMojom(::network::mojom::ContentSecurityPolicySource input, ::network::mojom::ContentSecurityPolicySource* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ContentSecurityPolicySource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ContentSecurityPolicySource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::ContentSecurityPolicySource>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::network::mojom::CSPDisposition, ::network::mojom::CSPDisposition> {
  static ::network::mojom::CSPDisposition ToMojom(::network::mojom::CSPDisposition input) { return input; }
  static bool FromMojom(::network::mojom::CSPDisposition input, ::network::mojom::CSPDisposition* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CSPDisposition, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CSPDisposition, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::CSPDisposition>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::network::mojom::CSPHashAlgorithm, ::network::mojom::CSPHashAlgorithm> {
  static ::network::mojom::CSPHashAlgorithm ToMojom(::network::mojom::CSPHashAlgorithm input) { return input; }
  static bool FromMojom(::network::mojom::CSPHashAlgorithm input, ::network::mojom::CSPHashAlgorithm* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CSPHashAlgorithm, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CSPHashAlgorithm, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::CSPHashAlgorithm>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::network::mojom::CSPDirectiveName, ::network::mojom::CSPDirectiveName> {
  static ::network::mojom::CSPDirectiveName ToMojom(::network::mojom::CSPDirectiveName input) { return input; }
  static bool FromMojom(::network::mojom::CSPDirectiveName input, ::network::mojom::CSPDirectiveName* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CSPDirectiveName, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CSPDirectiveName, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::CSPDirectiveName>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ContentSecurityPolicyHeaderDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ContentSecurityPolicyHeaderDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::ContentSecurityPolicyHeader_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::header_value(input)) in_header_value = Traits::header_value(input);
    typename decltype((*output)->header_value)::BaseType::BufferWriter
        header_value_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_header_value, buffer, &header_value_writer, context);
    (*output)->header_value.Set(
        header_value_writer.is_null() ? nullptr : header_value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->header_value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null header_value in ContentSecurityPolicyHeader struct");
    mojo::internal::Serialize<::network::mojom::ContentSecurityPolicyType>(
        Traits::type(input), &(*output)->type);
    mojo::internal::Serialize<::network::mojom::ContentSecurityPolicySource>(
        Traits::source(input), &(*output)->source);
  }

  static bool Deserialize(::network::mojom::internal::ContentSecurityPolicyHeader_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ContentSecurityPolicyHeaderDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CSPSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CSPSourceDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::CSPSource_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::scheme(input)) in_scheme = Traits::scheme(input);
    typename decltype((*output)->scheme)::BaseType::BufferWriter
        scheme_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_scheme, buffer, &scheme_writer, context);
    (*output)->scheme.Set(
        scheme_writer.is_null() ? nullptr : scheme_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->scheme.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scheme in CSPSource struct");
    decltype(Traits::host(input)) in_host = Traits::host(input);
    typename decltype((*output)->host)::BaseType::BufferWriter
        host_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_host, buffer, &host_writer, context);
    (*output)->host.Set(
        host_writer.is_null() ? nullptr : host_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->host.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host in CSPSource struct");
    (*output)->port = Traits::port(input);
    decltype(Traits::path(input)) in_path = Traits::path(input);
    typename decltype((*output)->path)::BaseType::BufferWriter
        path_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_path, buffer, &path_writer, context);
    (*output)->path.Set(
        path_writer.is_null() ? nullptr : path_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->path.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in CSPSource struct");
    (*output)->is_host_wildcard = Traits::is_host_wildcard(input);
    (*output)->is_port_wildcard = Traits::is_port_wildcard(input);
  }

  static bool Deserialize(::network::mojom::internal::CSPSource_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CSPSourceDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CSPHashSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CSPHashSourceDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::CSPHashSource_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::network::mojom::CSPHashAlgorithm>(
        Traits::algorithm(input), &(*output)->algorithm);
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in CSPHashSource struct");
  }

  static bool Deserialize(::network::mojom::internal::CSPHashSource_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CSPHashSourceDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CSPSourceListDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CSPSourceListDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::CSPSourceList_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::sources(input)) in_sources = Traits::sources(input);
    typename decltype((*output)->sources)::BaseType::BufferWriter
        sources_writer;
    const mojo::internal::ContainerValidateParams sources_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CSPSourceDataView>>(
        in_sources, buffer, &sources_writer, &sources_validate_params,
        context);
    (*output)->sources.Set(
        sources_writer.is_null() ? nullptr : sources_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->sources.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sources in CSPSourceList struct");
    decltype(Traits::nonces(input)) in_nonces = Traits::nonces(input);
    typename decltype((*output)->nonces)::BaseType::BufferWriter
        nonces_writer;
    const mojo::internal::ContainerValidateParams nonces_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_nonces, buffer, &nonces_writer, &nonces_validate_params,
        context);
    (*output)->nonces.Set(
        nonces_writer.is_null() ? nullptr : nonces_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->nonces.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null nonces in CSPSourceList struct");
    decltype(Traits::hashes(input)) in_hashes = Traits::hashes(input);
    typename decltype((*output)->hashes)::BaseType::BufferWriter
        hashes_writer;
    const mojo::internal::ContainerValidateParams hashes_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CSPHashSourceDataView>>(
        in_hashes, buffer, &hashes_writer, &hashes_validate_params,
        context);
    (*output)->hashes.Set(
        hashes_writer.is_null() ? nullptr : hashes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->hashes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hashes in CSPSourceList struct");
    (*output)->allow_self = Traits::allow_self(input);
    (*output)->allow_star = Traits::allow_star(input);
    (*output)->allow_response_redirects = Traits::allow_response_redirects(input);
    (*output)->allow_inline = Traits::allow_inline(input);
    (*output)->allow_eval = Traits::allow_eval(input);
    (*output)->allow_wasm_eval = Traits::allow_wasm_eval(input);
    (*output)->allow_dynamic = Traits::allow_dynamic(input);
    (*output)->allow_unsafe_hashes = Traits::allow_unsafe_hashes(input);
    (*output)->report_sample = Traits::report_sample(input);
  }

  static bool Deserialize(::network::mojom::internal::CSPSourceList_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CSPSourceListDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ContentSecurityPolicyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ContentSecurityPolicyDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::ContentSecurityPolicy_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::directives(input)) in_directives = Traits::directives(input);
    typename decltype((*output)->directives)::BaseType::BufferWriter
        directives_writer;
    const mojo::internal::ContainerValidateParams directives_validate_params(
        new mojo::internal::ContainerValidateParams(0, ::network::mojom::internal::CSPDirectiveName_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<::network::mojom::CSPDirectiveName, ::network::mojom::CSPSourceListDataView>>(
        in_directives, buffer, &directives_writer, &directives_validate_params,
        context);
    (*output)->directives.Set(
        directives_writer.is_null() ? nullptr : directives_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->directives.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null directives in ContentSecurityPolicy struct");
    (*output)->upgrade_insecure_requests = Traits::upgrade_insecure_requests(input);
    (*output)->treat_as_public_address = Traits::treat_as_public_address(input);
    mojo::internal::Serialize<::network::mojom::WebSandboxFlags>(
        Traits::sandbox(input), &(*output)->sandbox);
    decltype(Traits::header(input)) in_header = Traits::header(input);
    typename decltype((*output)->header)::BaseType::BufferWriter
        header_writer;
    mojo::internal::Serialize<::network::mojom::ContentSecurityPolicyHeaderDataView>(
        in_header, buffer, &header_writer, context);
    (*output)->header.Set(
        header_writer.is_null() ? nullptr : header_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->header.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null header in ContentSecurityPolicy struct");
    (*output)->use_reporting_api = Traits::use_reporting_api(input);
    decltype(Traits::report_endpoints(input)) in_report_endpoints = Traits::report_endpoints(input);
    typename decltype((*output)->report_endpoints)::BaseType::BufferWriter
        report_endpoints_writer;
    const mojo::internal::ContainerValidateParams report_endpoints_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_report_endpoints, buffer, &report_endpoints_writer, &report_endpoints_validate_params,
        context);
    (*output)->report_endpoints.Set(
        report_endpoints_writer.is_null() ? nullptr : report_endpoints_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->report_endpoints.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null report_endpoints in ContentSecurityPolicy struct");
    decltype(Traits::plugin_types(input)) in_plugin_types = Traits::plugin_types(input);
    typename decltype((*output)->plugin_types)::BaseType::BufferWriter
        plugin_types_writer;
    const mojo::internal::ContainerValidateParams plugin_types_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_plugin_types, buffer, &plugin_types_writer, &plugin_types_validate_params,
        context);
    (*output)->plugin_types.Set(
        plugin_types_writer.is_null() ? nullptr : plugin_types_writer.data());
    decltype(Traits::parsing_errors(input)) in_parsing_errors = Traits::parsing_errors(input);
    typename decltype((*output)->parsing_errors)::BaseType::BufferWriter
        parsing_errors_writer;
    const mojo::internal::ContainerValidateParams parsing_errors_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_parsing_errors, buffer, &parsing_errors_writer, &parsing_errors_validate_params,
        context);
    (*output)->parsing_errors.Set(
        parsing_errors_writer.is_null() ? nullptr : parsing_errors_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->parsing_errors.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null parsing_errors in ContentSecurityPolicy struct");
  }

  static bool Deserialize(::network::mojom::internal::ContentSecurityPolicy_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ContentSecurityPolicyDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CSPViolationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CSPViolationDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::CSPViolation_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::directive(input)) in_directive = Traits::directive(input);
    typename decltype((*output)->directive)::BaseType::BufferWriter
        directive_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_directive, buffer, &directive_writer, context);
    (*output)->directive.Set(
        directive_writer.is_null() ? nullptr : directive_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->directive.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null directive in CSPViolation struct");
    decltype(Traits::effective_directive(input)) in_effective_directive = Traits::effective_directive(input);
    typename decltype((*output)->effective_directive)::BaseType::BufferWriter
        effective_directive_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_effective_directive, buffer, &effective_directive_writer, context);
    (*output)->effective_directive.Set(
        effective_directive_writer.is_null() ? nullptr : effective_directive_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->effective_directive.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null effective_directive in CSPViolation struct");
    decltype(Traits::console_message(input)) in_console_message = Traits::console_message(input);
    typename decltype((*output)->console_message)::BaseType::BufferWriter
        console_message_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_console_message, buffer, &console_message_writer, context);
    (*output)->console_message.Set(
        console_message_writer.is_null() ? nullptr : console_message_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->console_message.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null console_message in CSPViolation struct");
    decltype(Traits::blocked_url(input)) in_blocked_url = Traits::blocked_url(input);
    typename decltype((*output)->blocked_url)::BaseType::BufferWriter
        blocked_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_blocked_url, buffer, &blocked_url_writer, context);
    (*output)->blocked_url.Set(
        blocked_url_writer.is_null() ? nullptr : blocked_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->blocked_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null blocked_url in CSPViolation struct");
    decltype(Traits::report_endpoints(input)) in_report_endpoints = Traits::report_endpoints(input);
    typename decltype((*output)->report_endpoints)::BaseType::BufferWriter
        report_endpoints_writer;
    const mojo::internal::ContainerValidateParams report_endpoints_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_report_endpoints, buffer, &report_endpoints_writer, &report_endpoints_validate_params,
        context);
    (*output)->report_endpoints.Set(
        report_endpoints_writer.is_null() ? nullptr : report_endpoints_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->report_endpoints.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null report_endpoints in CSPViolation struct");
    (*output)->use_reporting_api = Traits::use_reporting_api(input);
    decltype(Traits::header(input)) in_header = Traits::header(input);
    typename decltype((*output)->header)::BaseType::BufferWriter
        header_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_header, buffer, &header_writer, context);
    (*output)->header.Set(
        header_writer.is_null() ? nullptr : header_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->header.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null header in CSPViolation struct");
    mojo::internal::Serialize<::network::mojom::ContentSecurityPolicyType>(
        Traits::type(input), &(*output)->type);
    (*output)->after_redirect = Traits::after_redirect(input);
    decltype(Traits::source_location(input)) in_source_location = Traits::source_location(input);
    typename decltype((*output)->source_location)::BaseType::BufferWriter
        source_location_writer;
    mojo::internal::Serialize<::network::mojom::SourceLocationDataView>(
        in_source_location, buffer, &source_location_writer, context);
    (*output)->source_location.Set(
        source_location_writer.is_null() ? nullptr : source_location_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->source_location.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_location in CSPViolation struct");
  }

  static bool Deserialize(::network::mojom::internal::CSPViolation_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CSPViolationDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::AllowCSPFromHeaderValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::AllowCSPFromHeaderValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::AllowCSPFromHeaderValue_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::network::mojom::internal::AllowCSPFromHeaderValue_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::network::mojom::AllowCSPFromHeaderValueDataView::Tag::ALLOW_STAR: {
        decltype(Traits::allow_star(input))
            in_allow_star = Traits::allow_star(input);
        result->data.f_allow_star = in_allow_star;
        break;
      }
      case ::network::mojom::AllowCSPFromHeaderValueDataView::Tag::ORIGIN: {
        decltype(Traits::origin(input))
            in_origin = Traits::origin(input);
        typename decltype(result->data.f_origin)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::url::mojom::OriginDataView>(
            in_origin, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null origin in AllowCSPFromHeaderValue union");
        result->data.f_origin.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::network::mojom::AllowCSPFromHeaderValueDataView::Tag::ERROR_MESSAGE: {
        decltype(Traits::error_message(input))
            in_error_message = Traits::error_message(input);
        typename decltype(result->data.f_error_message)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<mojo::StringDataView>(
            in_error_message, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null error_message in AllowCSPFromHeaderValue union");
        result->data.f_error_message.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
    }
  }

  static bool Deserialize(::network::mojom::internal::AllowCSPFromHeaderValue_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::AllowCSPFromHeaderValueDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network {
namespace mojom {

inline void ContentSecurityPolicyHeaderDataView::GetHeaderValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->header_value.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void CSPSourceDataView::GetSchemeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->scheme.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CSPSourceDataView::GetHostDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->host.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CSPSourceDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void CSPHashSourceDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void CSPSourceListDataView::GetSourcesDataView(
    mojo::ArrayDataView<CSPSourceDataView>* output) {
  auto pointer = data_->sources.Get();
  *output = mojo::ArrayDataView<CSPSourceDataView>(pointer, context_);
}
inline void CSPSourceListDataView::GetNoncesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->nonces.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void CSPSourceListDataView::GetHashesDataView(
    mojo::ArrayDataView<CSPHashSourceDataView>* output) {
  auto pointer = data_->hashes.Get();
  *output = mojo::ArrayDataView<CSPHashSourceDataView>(pointer, context_);
}


inline void ContentSecurityPolicyDataView::GetDirectivesDataView(
    mojo::MapDataView<CSPDirectiveName, CSPSourceListDataView>* output) {
  auto pointer = data_->directives.Get();
  *output = mojo::MapDataView<CSPDirectiveName, CSPSourceListDataView>(pointer, context_);
}
inline void ContentSecurityPolicyDataView::GetHeaderDataView(
    ContentSecurityPolicyHeaderDataView* output) {
  auto pointer = data_->header.Get();
  *output = ContentSecurityPolicyHeaderDataView(pointer, context_);
}
inline void ContentSecurityPolicyDataView::GetReportEndpointsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->report_endpoints.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void ContentSecurityPolicyDataView::GetPluginTypesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->plugin_types.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void ContentSecurityPolicyDataView::GetParsingErrorsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->parsing_errors.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}


inline void CSPViolationDataView::GetDirectiveDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->directive.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CSPViolationDataView::GetEffectiveDirectiveDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->effective_directive.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CSPViolationDataView::GetConsoleMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->console_message.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CSPViolationDataView::GetBlockedUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->blocked_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void CSPViolationDataView::GetReportEndpointsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->report_endpoints.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void CSPViolationDataView::GetHeaderDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->header.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CSPViolationDataView::GetSourceLocationDataView(
    ::network::mojom::SourceLocationDataView* output) {
  auto pointer = data_->source_location.Get();
  *output = ::network::mojom::SourceLocationDataView(pointer, context_);
}


inline void AllowCSPFromHeaderValueDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  DCHECK(is_origin());
  *output = ::url::mojom::OriginDataView(data_->data.f_origin.Get(), context_);
}
inline void AllowCSPFromHeaderValueDataView::GetErrorMessageDataView(
    mojo::StringDataView* output) {
  DCHECK(is_error_message());
  *output = mojo::StringDataView(data_->data.f_error_message.Get(), context_);
}


}  // namespace mojom
}  // namespace network

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_SHARED_H_