// services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-params-data.h"
#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-shared-message-ids.h"

#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-import-headers.h"


#ifndef SERVICES_CERT_VERIFIER_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_FACTORY_MOJOM_JUMBO_H_
#define SERVICES_CERT_VERIFIER_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_FACTORY_MOJOM_JUMBO_H_
#endif
namespace cert_verifier {
namespace mojom {
const char CertVerifierServiceFactory::Name_[] = "cert_verifier.mojom.CertVerifierServiceFactory";

CertVerifierServiceFactoryProxy::CertVerifierServiceFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CertVerifierServiceFactoryProxy::GetNewCertVerifier(
    ::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierService> in_receiver, ::network::mojom::CertVerifierCreationParamsPtr in_creation_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "cert_verifier::mojom::CertVerifierServiceFactory::GetNewCertVerifier", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      if (in_creation_params.is_null()) {
        raw_value->SetString("creation_params", "nullptr");
      } else {
        raw_value->BeginDictionary("creation_params");
        in_creation_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCertVerifierServiceFactory_GetNewCertVerifier_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::cert_verifier::mojom::internal::CertVerifierServiceFactory_GetNewCertVerifier_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::cert_verifier::mojom::CertVerifierServiceInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in CertVerifierServiceFactory.GetNewCertVerifier request");
  typename decltype(params->creation_params)::BaseType::BufferWriter
      creation_params_writer;
  mojo::internal::Serialize<::network::mojom::CertVerifierCreationParamsDataView>(
      in_creation_params, buffer, &creation_params_writer, &serialization_context);
  params->creation_params.Set(
      creation_params_writer.is_null() ? nullptr : creation_params_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceFactory::Name_);
  message.set_method_name("GetNewCertVerifier");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CertVerifierServiceFactoryStubDispatch::Accept(
    CertVerifierServiceFactory* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kCertVerifierServiceFactory_GetNewCertVerifier_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)cert_verifier::mojom::CertVerifierServiceFactory::GetNewCertVerifier",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)cert_verifier::mojom::CertVerifierServiceFactory::GetNewCertVerifier");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CertVerifierServiceFactory_GetNewCertVerifier_Params_Data* params =
          reinterpret_cast<internal::CertVerifierServiceFactory_GetNewCertVerifier_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierService> p_receiver{};
      ::network::mojom::CertVerifierCreationParamsPtr p_creation_params{};
      CertVerifierServiceFactory_GetNewCertVerifier_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadCreationParams(&p_creation_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierServiceFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNewCertVerifier(
std::move(p_receiver), 
std::move(p_creation_params));
      return true;
    }
  }
  return false;
}

// static
bool CertVerifierServiceFactoryStubDispatch::AcceptWithResponder(
    CertVerifierServiceFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCertVerifierServiceFactory_GetNewCertVerifier_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCertVerifierServiceFactoryValidationInfo[] = {
    {internal::kCertVerifierServiceFactory_GetNewCertVerifier_Name,
     {&internal::CertVerifierServiceFactory_GetNewCertVerifier_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CertVerifierServiceFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::cert_verifier::mojom::CertVerifierServiceFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCertVerifierServiceFactoryValidationInfo);
}

}  // namespace mojom
}  // namespace cert_verifier

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif