// media/mojo/mojom/renderer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_RENDERER_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_RENDERER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "media/mojo/mojom/renderer.mojom-shared-internal.h"
#include "media/mojo/mojom/demuxer_stream.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace media {
namespace mojom {
class MediaUrlParamsDataView;



}  // namespace mojom
}  // namespace media

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::MediaUrlParamsDataView> {
  using Data = ::media::mojom::internal::MediaUrlParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media {
namespace mojom {
// Interface base classes. They are used for type safety check.
class RendererInterfaceBase {};

using RendererPtrDataView =
    mojo::InterfacePtrDataView<RendererInterfaceBase>;
using RendererRequestDataView =
    mojo::InterfaceRequestDataView<RendererInterfaceBase>;
using RendererAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RendererInterfaceBase>;
using RendererAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RendererInterfaceBase>;
class RendererClientInterfaceBase {};

using RendererClientPtrDataView =
    mojo::InterfacePtrDataView<RendererClientInterfaceBase>;
using RendererClientRequestDataView =
    mojo::InterfaceRequestDataView<RendererClientInterfaceBase>;
using RendererClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RendererClientInterfaceBase>;
using RendererClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RendererClientInterfaceBase>;


class MediaUrlParamsDataView {
 public:
  MediaUrlParamsDataView() {}

  MediaUrlParamsDataView(
      internal::MediaUrlParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetMediaUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMediaUrl(UserType* output) {
    
    auto* pointer = data_->media_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetSiteForCookiesDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSiteForCookies(UserType* output) {
    
    auto* pointer = data_->site_for_cookies.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetTopFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTopFrameOrigin(UserType* output) {
    
    auto* pointer = data_->top_frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  bool allow_credentials() const {
    return data_->allow_credentials;
  }
  bool is_hls() const {
    return data_->is_hls;
  }
 private:
  internal::MediaUrlParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace media

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::MediaUrlParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::MediaUrlParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::mojom::internal::MediaUrlParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::media_url(input)) in_media_url = Traits::media_url(input);
    typename decltype((*output)->media_url)::BaseType::BufferWriter
        media_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_media_url, buffer, &media_url_writer, context);
    (*output)->media_url.Set(
        media_url_writer.is_null() ? nullptr : media_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->media_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null media_url in MediaUrlParams struct");
    decltype(Traits::site_for_cookies(input)) in_site_for_cookies = Traits::site_for_cookies(input);
    typename decltype((*output)->site_for_cookies)::BaseType::BufferWriter
        site_for_cookies_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_site_for_cookies, buffer, &site_for_cookies_writer, context);
    (*output)->site_for_cookies.Set(
        site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->site_for_cookies.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site_for_cookies in MediaUrlParams struct");
    decltype(Traits::top_frame_origin(input)) in_top_frame_origin = Traits::top_frame_origin(input);
    typename decltype((*output)->top_frame_origin)::BaseType::BufferWriter
        top_frame_origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_top_frame_origin, buffer, &top_frame_origin_writer, context);
    (*output)->top_frame_origin.Set(
        top_frame_origin_writer.is_null() ? nullptr : top_frame_origin_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->top_frame_origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null top_frame_origin in MediaUrlParams struct");
    (*output)->allow_credentials = Traits::allow_credentials(input);
    (*output)->is_hls = Traits::is_hls(input);
  }

  static bool Deserialize(::media::mojom::internal::MediaUrlParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::MediaUrlParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media {
namespace mojom {

inline void MediaUrlParamsDataView::GetMediaUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->media_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void MediaUrlParamsDataView::GetSiteForCookiesDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->site_for_cookies.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void MediaUrlParamsDataView::GetTopFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->top_frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace media

#endif  // MEDIA_MOJO_MOJOM_RENDERER_MOJOM_SHARED_H_