// media/mojo/mojom/media_metrics_provider.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/media_metrics_provider.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/media_metrics_provider.mojom-params-data.h"
#include "media/mojo/mojom/media_metrics_provider.mojom-shared-message-ids.h"

#include "media/mojo/mojom/media_metrics_provider.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_MEDIA_METRICS_PROVIDER_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_MEDIA_METRICS_PROVIDER_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
const char MediaMetricsProvider::Name_[] = "media.mojom.MediaMetricsProvider";

MediaMetricsProviderProxy::MediaMetricsProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaMetricsProviderProxy::Initialize(
    bool in_is_mse, MediaURLScheme in_url_scheme) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::Initialize", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_mse", in_is_mse);
      raw_value->SetString("url_scheme", base::trace_event::ValueToString(in_url_scheme));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_Initialize_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_Initialize_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_mse = in_is_mse;
  mojo::internal::Serialize<::media::mojom::MediaURLScheme>(
      in_url_scheme, &params->url_scheme);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("Initialize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::OnError(
    ::media::PipelineStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::OnError", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("status", static_cast<int>(in_status));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_OnError_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_OnError_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::media::mojom::PipelineStatus>(
      in_status, &params->status);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetHasPlayed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::MediaMetricsProvider::SetHasPlayed");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetHasPlayed_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_SetHasPlayed_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetHasPlayed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetHaveEnough(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::MediaMetricsProvider::SetHaveEnough");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetHaveEnough_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_SetHaveEnough_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetHaveEnough");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetIsEME(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::MediaMetricsProvider::SetIsEME");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetIsEME_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_SetIsEME_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetIsEME");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetTimeToMetadata(
    ::base::TimeDelta in_elapsed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetTimeToMetadata", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("elapsed", base::trace_event::ValueToString(in_elapsed, "<value of type ::base::TimeDelta>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetTimeToMetadata_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_SetTimeToMetadata_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->elapsed)::BaseType::BufferWriter
      elapsed_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_elapsed, buffer, &elapsed_writer, &serialization_context);
  params->elapsed.Set(
      elapsed_writer.is_null() ? nullptr : elapsed_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->elapsed.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null elapsed in MediaMetricsProvider.SetTimeToMetadata request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetTimeToMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetTimeToFirstFrame(
    ::base::TimeDelta in_elapsed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetTimeToFirstFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("elapsed", base::trace_event::ValueToString(in_elapsed, "<value of type ::base::TimeDelta>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetTimeToFirstFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_SetTimeToFirstFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->elapsed)::BaseType::BufferWriter
      elapsed_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_elapsed, buffer, &elapsed_writer, &serialization_context);
  params->elapsed.Set(
      elapsed_writer.is_null() ? nullptr : elapsed_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->elapsed.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null elapsed in MediaMetricsProvider.SetTimeToFirstFrame request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetTimeToFirstFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetTimeToPlayReady(
    ::base::TimeDelta in_elapsed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetTimeToPlayReady", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("elapsed", base::trace_event::ValueToString(in_elapsed, "<value of type ::base::TimeDelta>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetTimeToPlayReady_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_SetTimeToPlayReady_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->elapsed)::BaseType::BufferWriter
      elapsed_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_elapsed, buffer, &elapsed_writer, &serialization_context);
  params->elapsed.Set(
      elapsed_writer.is_null() ? nullptr : elapsed_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->elapsed.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null elapsed in MediaMetricsProvider.SetTimeToPlayReady request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetTimeToPlayReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetContainerName(
    ::media::container_names::MediaContainerName in_container_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetContainerName", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("container_name", static_cast<int>(in_container_name));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetContainerName_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_SetContainerName_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::media::mojom::MediaContainerName>(
      in_container_name, &params->container_name);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetContainerName");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::AcquireWatchTimeRecorder(
    ::media::mojom::PlaybackPropertiesPtr in_properties, ::mojo::PendingReceiver<::media::mojom::WatchTimeRecorder> in_recorder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::AcquireWatchTimeRecorder", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_properties.is_null()) {
        raw_value->SetString("properties", "nullptr");
      } else {
        raw_value->BeginDictionary("properties");
        in_properties->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("recorder", in_recorder.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_AcquireWatchTimeRecorder_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->properties)::BaseType::BufferWriter
      properties_writer;
  mojo::internal::Serialize<::media::mojom::PlaybackPropertiesDataView>(
      in_properties, buffer, &properties_writer, &serialization_context);
  params->properties.Set(
      properties_writer.is_null() ? nullptr : properties_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->properties.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null properties in MediaMetricsProvider.AcquireWatchTimeRecorder request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::WatchTimeRecorderInterfaceBase>>(
      in_recorder, &params->recorder, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->recorder),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid recorder in MediaMetricsProvider.AcquireWatchTimeRecorder request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("AcquireWatchTimeRecorder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::AcquireVideoDecodeStatsRecorder(
    ::mojo::PendingReceiver<::media::mojom::VideoDecodeStatsRecorder> in_recorder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::AcquireVideoDecodeStatsRecorder", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("recorder", in_recorder.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::VideoDecodeStatsRecorderInterfaceBase>>(
      in_recorder, &params->recorder, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->recorder),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid recorder in MediaMetricsProvider.AcquireVideoDecodeStatsRecorder request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("AcquireVideoDecodeStatsRecorder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::AcquireLearningTaskController(
    const std::string& in_taskName, ::mojo::PendingReceiver<::media::learning::mojom::LearningTaskController> in_controller) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::AcquireLearningTaskController", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("taskName", in_taskName);
      raw_value->SetBoolean("controller", in_controller.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_AcquireLearningTaskController_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_AcquireLearningTaskController_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->taskName)::BaseType::BufferWriter
      taskName_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_taskName, buffer, &taskName_writer, &serialization_context);
  params->taskName.Set(
      taskName_writer.is_null() ? nullptr : taskName_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->taskName.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null taskName in MediaMetricsProvider.AcquireLearningTaskController request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::learning::mojom::LearningTaskControllerInterfaceBase>>(
      in_controller, &params->controller, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->controller),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid controller in MediaMetricsProvider.AcquireLearningTaskController request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("AcquireLearningTaskController");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::AcquirePlaybackEventsRecorder(
    ::mojo::PendingReceiver<::media::mojom::PlaybackEventsRecorder> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::AcquirePlaybackEventsRecorder", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_AcquirePlaybackEventsRecorder_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::PlaybackEventsRecorderInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in MediaMetricsProvider.AcquirePlaybackEventsRecorder request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("AcquirePlaybackEventsRecorder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetHasAudio(
    ::media::AudioCodec in_codec) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetHasAudio", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("codec", static_cast<int>(in_codec));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetHasAudio_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_SetHasAudio_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::media::mojom::AudioCodec>(
      in_codec, &params->codec);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetHasAudio");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetHasVideo(
    ::media::VideoCodec in_codec) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetHasVideo", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("codec", static_cast<int>(in_codec));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetHasVideo_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_SetHasVideo_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::media::mojom::VideoCodec>(
      in_codec, &params->codec);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetHasVideo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetVideoPipelineInfo(
    const ::media::PipelineDecoderInfo& in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetVideoPipelineInfo", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("info", base::trace_event::ValueToString(in_info, "<value of type const ::media::PipelineDecoderInfo&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetVideoPipelineInfo_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_SetVideoPipelineInfo_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->info)::BaseType::BufferWriter
      info_writer;
  mojo::internal::Serialize<::media::mojom::PipelineDecoderInfoDataView>(
      in_info, buffer, &info_writer, &serialization_context);
  params->info.Set(
      info_writer.is_null() ? nullptr : info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in MediaMetricsProvider.SetVideoPipelineInfo request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetVideoPipelineInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetAudioPipelineInfo(
    const ::media::PipelineDecoderInfo& in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetAudioPipelineInfo", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("info", base::trace_event::ValueToString(in_info, "<value of type const ::media::PipelineDecoderInfo&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetAudioPipelineInfo_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::MediaMetricsProvider_SetAudioPipelineInfo_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->info)::BaseType::BufferWriter
      info_writer;
  mojo::internal::Serialize<::media::mojom::PipelineDecoderInfoDataView>(
      in_info, buffer, &info_writer, &serialization_context);
  params->info.Set(
      info_writer.is_null() ? nullptr : info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in MediaMetricsProvider.SetAudioPipelineInfo request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetAudioPipelineInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaMetricsProviderStubDispatch::Accept(
    MediaMetricsProvider* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kMediaMetricsProvider_Initialize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::Initialize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::Initialize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_Initialize_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_Initialize_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_mse{};
      MediaURLScheme p_url_scheme{};
      MediaMetricsProvider_Initialize_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_is_mse = input_data_view.is_mse();
      if (success && !input_data_view.ReadUrlScheme(&p_url_scheme))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(
std::move(p_is_mse), 
std::move(p_url_scheme));
      return true;
    }
    case internal::kMediaMetricsProvider_OnError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::OnError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::OnError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_OnError_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_OnError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::PipelineStatus p_status{};
      MediaMetricsProvider_OnError_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(
std::move(p_status));
      return true;
    }
    case internal::kMediaMetricsProvider_SetHasPlayed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetHasPlayed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetHasPlayed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetHasPlayed_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetHasPlayed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaMetricsProvider_SetHasPlayed_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHasPlayed();
      return true;
    }
    case internal::kMediaMetricsProvider_SetHaveEnough_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetHaveEnough",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetHaveEnough");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetHaveEnough_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetHaveEnough_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaMetricsProvider_SetHaveEnough_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHaveEnough();
      return true;
    }
    case internal::kMediaMetricsProvider_SetIsEME_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetIsEME",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetIsEME");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetIsEME_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetIsEME_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaMetricsProvider_SetIsEME_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsEME();
      return true;
    }
    case internal::kMediaMetricsProvider_SetTimeToMetadata_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetTimeToMetadata",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetTimeToMetadata");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetTimeToMetadata_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetTimeToMetadata_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_elapsed{};
      MediaMetricsProvider_SetTimeToMetadata_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadElapsed(&p_elapsed))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTimeToMetadata(
std::move(p_elapsed));
      return true;
    }
    case internal::kMediaMetricsProvider_SetTimeToFirstFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetTimeToFirstFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetTimeToFirstFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetTimeToFirstFrame_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetTimeToFirstFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_elapsed{};
      MediaMetricsProvider_SetTimeToFirstFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadElapsed(&p_elapsed))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTimeToFirstFrame(
std::move(p_elapsed));
      return true;
    }
    case internal::kMediaMetricsProvider_SetTimeToPlayReady_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetTimeToPlayReady",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetTimeToPlayReady");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetTimeToPlayReady_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetTimeToPlayReady_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_elapsed{};
      MediaMetricsProvider_SetTimeToPlayReady_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadElapsed(&p_elapsed))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTimeToPlayReady(
std::move(p_elapsed));
      return true;
    }
    case internal::kMediaMetricsProvider_SetContainerName_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetContainerName",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetContainerName");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetContainerName_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetContainerName_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::container_names::MediaContainerName p_container_name{};
      MediaMetricsProvider_SetContainerName_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadContainerName(&p_container_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetContainerName(
std::move(p_container_name));
      return true;
    }
    case internal::kMediaMetricsProvider_AcquireWatchTimeRecorder_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::AcquireWatchTimeRecorder",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::AcquireWatchTimeRecorder");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::PlaybackPropertiesPtr p_properties{};
      ::mojo::PendingReceiver<::media::mojom::WatchTimeRecorder> p_recorder{};
      MediaMetricsProvider_AcquireWatchTimeRecorder_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadProperties(&p_properties))
        success = false;
      if (success) {
        p_recorder =
            input_data_view.TakeRecorder<decltype(p_recorder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcquireWatchTimeRecorder(
std::move(p_properties), 
std::move(p_recorder));
      return true;
    }
    case internal::kMediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::AcquireVideoDecodeStatsRecorder",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::AcquireVideoDecodeStatsRecorder");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::VideoDecodeStatsRecorder> p_recorder{};
      MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_recorder =
            input_data_view.TakeRecorder<decltype(p_recorder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcquireVideoDecodeStatsRecorder(
std::move(p_recorder));
      return true;
    }
    case internal::kMediaMetricsProvider_AcquireLearningTaskController_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::AcquireLearningTaskController",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::AcquireLearningTaskController");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_AcquireLearningTaskController_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_AcquireLearningTaskController_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_taskName{};
      ::mojo::PendingReceiver<::media::learning::mojom::LearningTaskController> p_controller{};
      MediaMetricsProvider_AcquireLearningTaskController_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadTaskName(&p_taskName))
        success = false;
      if (success) {
        p_controller =
            input_data_view.TakeController<decltype(p_controller)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcquireLearningTaskController(
std::move(p_taskName), 
std::move(p_controller));
      return true;
    }
    case internal::kMediaMetricsProvider_AcquirePlaybackEventsRecorder_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::AcquirePlaybackEventsRecorder",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::AcquirePlaybackEventsRecorder");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::PlaybackEventsRecorder> p_receiver{};
      MediaMetricsProvider_AcquirePlaybackEventsRecorder_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcquirePlaybackEventsRecorder(
std::move(p_receiver));
      return true;
    }
    case internal::kMediaMetricsProvider_SetHasAudio_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetHasAudio",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetHasAudio");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetHasAudio_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetHasAudio_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::AudioCodec p_codec{};
      MediaMetricsProvider_SetHasAudio_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCodec(&p_codec))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHasAudio(
std::move(p_codec));
      return true;
    }
    case internal::kMediaMetricsProvider_SetHasVideo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetHasVideo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetHasVideo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetHasVideo_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetHasVideo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoCodec p_codec{};
      MediaMetricsProvider_SetHasVideo_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCodec(&p_codec))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHasVideo(
std::move(p_codec));
      return true;
    }
    case internal::kMediaMetricsProvider_SetVideoPipelineInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetVideoPipelineInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetVideoPipelineInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetVideoPipelineInfo_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetVideoPipelineInfo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::PipelineDecoderInfo p_info{};
      MediaMetricsProvider_SetVideoPipelineInfo_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVideoPipelineInfo(
std::move(p_info));
      return true;
    }
    case internal::kMediaMetricsProvider_SetAudioPipelineInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetAudioPipelineInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetAudioPipelineInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetAudioPipelineInfo_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetAudioPipelineInfo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::PipelineDecoderInfo p_info{};
      MediaMetricsProvider_SetAudioPipelineInfo_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAudioPipelineInfo(
std::move(p_info));
      return true;
    }
  }
  return false;
}

// static
bool MediaMetricsProviderStubDispatch::AcceptWithResponder(
    MediaMetricsProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaMetricsProvider_Initialize_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_OnError_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetHasPlayed_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetHaveEnough_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetIsEME_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetTimeToMetadata_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetTimeToFirstFrame_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetTimeToPlayReady_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetContainerName_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_AcquireWatchTimeRecorder_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_AcquireLearningTaskController_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_AcquirePlaybackEventsRecorder_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetHasAudio_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetHasVideo_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetVideoPipelineInfo_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetAudioPipelineInfo_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMediaMetricsProviderValidationInfo[] = {
    {internal::kMediaMetricsProvider_Initialize_Name,
     {&internal::MediaMetricsProvider_Initialize_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_OnError_Name,
     {&internal::MediaMetricsProvider_OnError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetHasPlayed_Name,
     {&internal::MediaMetricsProvider_SetHasPlayed_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetHaveEnough_Name,
     {&internal::MediaMetricsProvider_SetHaveEnough_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetIsEME_Name,
     {&internal::MediaMetricsProvider_SetIsEME_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetTimeToMetadata_Name,
     {&internal::MediaMetricsProvider_SetTimeToMetadata_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetTimeToFirstFrame_Name,
     {&internal::MediaMetricsProvider_SetTimeToFirstFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetTimeToPlayReady_Name,
     {&internal::MediaMetricsProvider_SetTimeToPlayReady_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetContainerName_Name,
     {&internal::MediaMetricsProvider_SetContainerName_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_AcquireWatchTimeRecorder_Name,
     {&internal::MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Name,
     {&internal::MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_AcquireLearningTaskController_Name,
     {&internal::MediaMetricsProvider_AcquireLearningTaskController_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_AcquirePlaybackEventsRecorder_Name,
     {&internal::MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetHasAudio_Name,
     {&internal::MediaMetricsProvider_SetHasAudio_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetHasVideo_Name,
     {&internal::MediaMetricsProvider_SetHasVideo_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetVideoPipelineInfo_Name,
     {&internal::MediaMetricsProvider_SetVideoPipelineInfo_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetAudioPipelineInfo_Name,
     {&internal::MediaMetricsProvider_SetAudioPipelineInfo_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MediaMetricsProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::MediaMetricsProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMediaMetricsProviderValidationInfo);
}

}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif