// device/vr/public/mojom/vr_service.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_SHARED_INTERNAL_H_
#define DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "device/gamepad/public/mojom/gamepad.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox_holder.mojom-shared-internal.h"
#include "gpu/ipc/common/sync_token.mojom-shared-internal.h"
#include "ui/display/mojom/display.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "ui/gfx/mojom/gpu_fence_handle.mojom-shared-internal.h"
#include "ui/gfx/mojom/transform.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace device {
namespace mojom {
namespace internal {
class XRSessionOptions_Data;
class XRSession_Data;
class XRPresentationConnection_Data;
class XRInputSourceDescription_Data;
class XRInputSourceState_Data;
class VRFieldOfView_Data;
class VRPose_Data;
class Pose_Data;
class XRRay_Data;
class XRHitResult_Data;
class VREyeParameters_Data;
class VRStageParameters_Data;
class VRDisplayInfo_Data;
class XRPresentationTransportOptions_Data;
class XRPlanePointData_Data;
class XRPlaneData_Data;
class XRPlaneDetectionData_Data;
class XRAnchorData_Data;
class XRAnchorsData_Data;
class XRHitTestSubscriptionResultData_Data;
class XRHitTestTransientInputSubscriptionResultData_Data;
class XRHitTestSubscriptionResultsData_Data;
class RgbTupleF32_Data;
class XRSphericalHarmonics_Data;
class RgbaTupleF16_Data;
class XRCubeMap_Data;
class XRLightProbe_Data;
class XRReflectionProbe_Data;
class XRLightEstimationData_Data;
class XRDepthDataStillValid_Data;
class XRDepthDataUpdated_Data;
class XRFrameData_Data;
class RequestSessionSuccess_Data;
class XRFrameDataRequestOptions_Data;
class XRNativeOriginInformation_Data;
class XRDepthData_Data;
class RequestSessionResult_Data;

struct XRDeviceId_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 7:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct XRHandedness_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct XRTargetRayMode_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct XRSessionFeature_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct XRSessionFeatureRequestStatus_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct XRSessionMode_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct XRPresentationTransportMethod_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct XRReferenceSpaceType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct XRPlaneOrientation_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct RequestSessionError_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct XrCompatibleResult_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct CreateAnchorResult_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct SubscribeToHitTestResult_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct EntityTypeForHitTest_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct XRVisibilityState_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRNativeOriginInformation_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  XRNativeOriginInformation_Data() {}
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~XRNativeOriginInformation_Data() {}

  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRNativeOriginInformation_Data));
      new (data()) XRNativeOriginInformation_Data();
    }

    void AllocateInline(mojo::internal::Buffer* serialization_buffer,
                        void* ptr) {
      const char* start = static_cast<const char*>(
          serialization_buffer->data());
      const char* slot = static_cast<const char*>(ptr);
      DCHECK_GT(slot, start);
      serialization_buffer_ = serialization_buffer;
      index_ = slot - start;
      new (data()) XRNativeOriginInformation_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRNativeOriginInformation_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRNativeOriginInformation_Data>(index_);
    }
    XRNativeOriginInformation_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<XRNativeOriginInformation_Tag>(0);
    data.unknown = 0U;
  }

  enum class XRNativeOriginInformation_Tag : uint32_t {

    
    INPUT_SOURCE_ID,
    
    PLANE_ID,
    
    ANCHOR_ID,
    
    REFERENCE_SPACE_TYPE,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    uint32_t f_input_source_id;
    uint64_t f_plane_id;
    uint64_t f_anchor_id;
    int32_t f_reference_space_type;
    uint64_t unknown;
  };

  uint32_t size;
  XRNativeOriginInformation_Tag tag;
  Union_ data;
};
static_assert(sizeof(XRNativeOriginInformation_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(XRNativeOriginInformation_Data)");


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRDepthData_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  XRDepthData_Data() {}
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~XRDepthData_Data() {}

  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRDepthData_Data));
      new (data()) XRDepthData_Data();
    }

    void AllocateInline(mojo::internal::Buffer* serialization_buffer,
                        void* ptr) {
      const char* start = static_cast<const char*>(
          serialization_buffer->data());
      const char* slot = static_cast<const char*>(ptr);
      DCHECK_GT(slot, start);
      serialization_buffer_ = serialization_buffer;
      index_ = slot - start;
      new (data()) XRDepthData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRDepthData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRDepthData_Data>(index_);
    }
    XRDepthData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<XRDepthData_Tag>(0);
    data.unknown = 0U;
  }

  enum class XRDepthData_Tag : uint32_t {

    
    DATA_STILL_VALID,
    
    UPDATED_DEPTH_DATA,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::XRDepthDataStillValid_Data> f_data_still_valid;
    mojo::internal::Pointer<internal::XRDepthDataUpdated_Data> f_updated_depth_data;
    uint64_t unknown;
  };

  uint32_t size;
  XRDepthData_Tag tag;
  Union_ data;
};
static_assert(sizeof(XRDepthData_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(XRDepthData_Data)");


class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) RequestSessionResult_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  RequestSessionResult_Data() {}
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~RequestSessionResult_Data() {}

  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RequestSessionResult_Data));
      new (data()) RequestSessionResult_Data();
    }

    void AllocateInline(mojo::internal::Buffer* serialization_buffer,
                        void* ptr) {
      const char* start = static_cast<const char*>(
          serialization_buffer->data());
      const char* slot = static_cast<const char*>(ptr);
      DCHECK_GT(slot, start);
      serialization_buffer_ = serialization_buffer;
      index_ = slot - start;
      new (data()) RequestSessionResult_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RequestSessionResult_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RequestSessionResult_Data>(index_);
    }
    RequestSessionResult_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<RequestSessionResult_Tag>(0);
    data.unknown = 0U;
  }

  enum class RequestSessionResult_Tag : uint32_t {

    
    SUCCESS,
    
    FAILURE_REASON,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::RequestSessionSuccess_Data> f_success;
    int32_t f_failure_reason;
    uint64_t unknown;
  };

  uint32_t size;
  RequestSessionResult_Tag tag;
  Union_ data;
};
static_assert(sizeof(RequestSessionResult_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(RequestSessionResult_Data)");
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRSessionOptions_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRSessionOptions_Data));
      new (data()) XRSessionOptions_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRSessionOptions_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRSessionOptions_Data>(index_);
    }
    XRSessionOptions_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t mode;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> required_features;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> optional_features;

 private:
  XRSessionOptions_Data();
  ~XRSessionOptions_Data() = delete;
};
static_assert(sizeof(XRSessionOptions_Data) == 32,
              "Bad sizeof(XRSessionOptions_Data)");
// Used by XRSessionOptions::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRSessionOptions_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRSessionOptions_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRSessionOptions_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRSessionOptions_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRSessionOptions_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRSession_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRSession_Data));
      new (data()) XRSession_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRSession_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRSession_Data>(index_);
    }
    XRSession_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data data_provider;
  mojo::internal::Handle_Data client_receiver;
  uint8_t uses_input_eventing : 1;
  uint8_t pad2_[3];
  mojo::internal::Pointer<internal::VRDisplayInfo_Data> display_info;
  mojo::internal::Pointer<internal::XRPresentationConnection_Data> submit_frame_sink;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> enabled_features;
  float default_framebuffer_scale;
  uint8_t padfinal_[4];

 private:
  XRSession_Data();
  ~XRSession_Data() = delete;
};
static_assert(sizeof(XRSession_Data) == 56,
              "Bad sizeof(XRSession_Data)");
// Used by XRSession::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRSession_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRSession_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRSession_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRSession_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRSession_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRPresentationConnection_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRPresentationConnection_Data));
      new (data()) XRPresentationConnection_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRPresentationConnection_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRPresentationConnection_Data>(index_);
    }
    XRPresentationConnection_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data provider;
  mojo::internal::Handle_Data client_receiver;
  uint8_t pad1_[4];
  mojo::internal::Pointer<internal::XRPresentationTransportOptions_Data> transport_options;

 private:
  XRPresentationConnection_Data();
  ~XRPresentationConnection_Data() = delete;
};
static_assert(sizeof(XRPresentationConnection_Data) == 32,
              "Bad sizeof(XRPresentationConnection_Data)");
// Used by XRPresentationConnection::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRPresentationConnection_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRPresentationConnection_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRPresentationConnection_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRPresentationConnection_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRPresentationConnection_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRInputSourceDescription_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRInputSourceDescription_Data));
      new (data()) XRInputSourceDescription_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRInputSourceDescription_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRInputSourceDescription_Data>(index_);
    }
    XRInputSourceDescription_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t target_ray_mode;
  int32_t handedness;
  mojo::internal::Pointer<::gfx::mojom::internal::Transform_Data> input_from_pointer;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> profiles;

 private:
  XRInputSourceDescription_Data();
  ~XRInputSourceDescription_Data() = delete;
};
static_assert(sizeof(XRInputSourceDescription_Data) == 32,
              "Bad sizeof(XRInputSourceDescription_Data)");
// Used by XRInputSourceDescription::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRInputSourceDescription_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRInputSourceDescription_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRInputSourceDescription_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRInputSourceDescription_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRInputSourceDescription_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRInputSourceState_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRInputSourceState_Data));
      new (data()) XRInputSourceState_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRInputSourceState_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRInputSourceState_Data>(index_);
    }
    XRInputSourceState_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t source_id;
  uint8_t emulated_position : 1;
  uint8_t is_auxiliary : 1;
  uint8_t primary_input_pressed : 1;
  uint8_t primary_input_clicked : 1;
  uint8_t primary_squeeze_pressed : 1;
  uint8_t primary_squeeze_clicked : 1;
  uint8_t pad6_[3];
  mojo::internal::Pointer<internal::XRInputSourceDescription_Data> description;
  mojo::internal::Pointer<::gfx::mojom::internal::Transform_Data> mojo_from_input;
  mojo::internal::Pointer<::device::mojom::internal::Gamepad_Data> gamepad;
  mojo::internal::Pointer<::gfx::mojom::internal::PointF_Data> overlay_pointer_position;

 private:
  XRInputSourceState_Data();
  ~XRInputSourceState_Data() = delete;
};
static_assert(sizeof(XRInputSourceState_Data) == 48,
              "Bad sizeof(XRInputSourceState_Data)");
// Used by XRInputSourceState::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRInputSourceState_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRInputSourceState_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRInputSourceState_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRInputSourceState_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRInputSourceState_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) VRFieldOfView_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VRFieldOfView_Data));
      new (data()) VRFieldOfView_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VRFieldOfView_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VRFieldOfView_Data>(index_);
    }
    VRFieldOfView_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  float up_degrees;
  float down_degrees;
  float left_degrees;
  float right_degrees;

 private:
  VRFieldOfView_Data();
  ~VRFieldOfView_Data() = delete;
};
static_assert(sizeof(VRFieldOfView_Data) == 24,
              "Bad sizeof(VRFieldOfView_Data)");
// Used by VRFieldOfView::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VRFieldOfView_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VRFieldOfView_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VRFieldOfView_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    VRFieldOfView_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VRFieldOfView_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) VRPose_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VRPose_Data));
      new (data()) VRPose_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VRPose_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VRPose_Data>(index_);
    }
    VRPose_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Quaternion_Data> orientation;
  mojo::internal::Pointer<::gfx::mojom::internal::Point3F_Data> position;
  uint8_t emulated_position : 1;
  uint8_t padfinal_[7];

 private:
  VRPose_Data();
  ~VRPose_Data() = delete;
};
static_assert(sizeof(VRPose_Data) == 32,
              "Bad sizeof(VRPose_Data)");
// Used by VRPose::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VRPose_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VRPose_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VRPose_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    VRPose_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VRPose_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) Pose_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Pose_Data));
      new (data()) Pose_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Pose_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Pose_Data>(index_);
    }
    Pose_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Quaternion_Data> orientation;
  mojo::internal::Pointer<::gfx::mojom::internal::Point3F_Data> position;

 private:
  Pose_Data();
  ~Pose_Data() = delete;
};
static_assert(sizeof(Pose_Data) == 24,
              "Bad sizeof(Pose_Data)");
// Used by Pose::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Pose_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Pose_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Pose_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    Pose_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Pose_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRRay_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRRay_Data));
      new (data()) XRRay_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRRay_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRRay_Data>(index_);
    }
    XRRay_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Point3F_Data> origin;
  mojo::internal::Pointer<::gfx::mojom::internal::Vector3dF_Data> direction;

 private:
  XRRay_Data();
  ~XRRay_Data() = delete;
};
static_assert(sizeof(XRRay_Data) == 24,
              "Bad sizeof(XRRay_Data)");
// Used by XRRay::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRRay_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRRay_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRRay_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRRay_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRRay_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRHitResult_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRHitResult_Data));
      new (data()) XRHitResult_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRHitResult_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRHitResult_Data>(index_);
    }
    XRHitResult_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::Pose_Data> mojo_from_result;
  uint64_t plane_id;

 private:
  XRHitResult_Data();
  ~XRHitResult_Data() = delete;
};
static_assert(sizeof(XRHitResult_Data) == 24,
              "Bad sizeof(XRHitResult_Data)");
// Used by XRHitResult::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRHitResult_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRHitResult_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRHitResult_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRHitResult_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRHitResult_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) VREyeParameters_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VREyeParameters_Data));
      new (data()) VREyeParameters_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VREyeParameters_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VREyeParameters_Data>(index_);
    }
    VREyeParameters_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::VRFieldOfView_Data> field_of_view;
  mojo::internal::Pointer<::gfx::mojom::internal::Transform_Data> head_from_eye;
  uint32_t render_width;
  uint32_t render_height;

 private:
  VREyeParameters_Data();
  ~VREyeParameters_Data() = delete;
};
static_assert(sizeof(VREyeParameters_Data) == 32,
              "Bad sizeof(VREyeParameters_Data)");
// Used by VREyeParameters::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VREyeParameters_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VREyeParameters_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VREyeParameters_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    VREyeParameters_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VREyeParameters_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) VRStageParameters_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VRStageParameters_Data));
      new (data()) VRStageParameters_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VRStageParameters_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VRStageParameters_Data>(index_);
    }
    VRStageParameters_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Transform_Data> mojo_from_floor;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::gfx::mojom::internal::Point3F_Data>>> bounds;

 private:
  VRStageParameters_Data();
  ~VRStageParameters_Data() = delete;
};
static_assert(sizeof(VRStageParameters_Data) == 24,
              "Bad sizeof(VRStageParameters_Data)");
// Used by VRStageParameters::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VRStageParameters_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VRStageParameters_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VRStageParameters_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    VRStageParameters_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VRStageParameters_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) VRDisplayInfo_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VRDisplayInfo_Data));
      new (data()) VRDisplayInfo_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VRDisplayInfo_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VRDisplayInfo_Data>(index_);
    }
    VRDisplayInfo_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::VRStageParameters_Data> stage_parameters;
  mojo::internal::Pointer<internal::VREyeParameters_Data> left_eye;
  mojo::internal::Pointer<internal::VREyeParameters_Data> right_eye;

 private:
  VRDisplayInfo_Data();
  ~VRDisplayInfo_Data() = delete;
};
static_assert(sizeof(VRDisplayInfo_Data) == 32,
              "Bad sizeof(VRDisplayInfo_Data)");
// Used by VRDisplayInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VRDisplayInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VRDisplayInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VRDisplayInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    VRDisplayInfo_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VRDisplayInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRPresentationTransportOptions_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRPresentationTransportOptions_Data));
      new (data()) XRPresentationTransportOptions_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRPresentationTransportOptions_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRPresentationTransportOptions_Data>(index_);
    }
    XRPresentationTransportOptions_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t transport_method;
  uint8_t wait_for_transfer_notification : 1;
  uint8_t wait_for_render_notification : 1;
  uint8_t wait_for_gpu_fence : 1;
  uint8_t padfinal_[3];

 private:
  XRPresentationTransportOptions_Data();
  ~XRPresentationTransportOptions_Data() = delete;
};
static_assert(sizeof(XRPresentationTransportOptions_Data) == 16,
              "Bad sizeof(XRPresentationTransportOptions_Data)");
// Used by XRPresentationTransportOptions::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRPresentationTransportOptions_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRPresentationTransportOptions_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRPresentationTransportOptions_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRPresentationTransportOptions_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRPresentationTransportOptions_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRPlanePointData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRPlanePointData_Data));
      new (data()) XRPlanePointData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRPlanePointData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRPlanePointData_Data>(index_);
    }
    XRPlanePointData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  float x;
  float z;

 private:
  XRPlanePointData_Data();
  ~XRPlanePointData_Data() = delete;
};
static_assert(sizeof(XRPlanePointData_Data) == 16,
              "Bad sizeof(XRPlanePointData_Data)");
// Used by XRPlanePointData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRPlanePointData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRPlanePointData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRPlanePointData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRPlanePointData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRPlanePointData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRPlaneData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRPlaneData_Data));
      new (data()) XRPlaneData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRPlaneData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRPlaneData_Data>(index_);
    }
    XRPlaneData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t id;
  int32_t orientation;
  uint8_t pad1_[4];
  mojo::internal::Pointer<internal::Pose_Data> mojo_from_plane;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::XRPlanePointData_Data>>> polygon;

 private:
  XRPlaneData_Data();
  ~XRPlaneData_Data() = delete;
};
static_assert(sizeof(XRPlaneData_Data) == 40,
              "Bad sizeof(XRPlaneData_Data)");
// Used by XRPlaneData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRPlaneData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRPlaneData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRPlaneData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRPlaneData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRPlaneData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRPlaneDetectionData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRPlaneDetectionData_Data));
      new (data()) XRPlaneDetectionData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRPlaneDetectionData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRPlaneDetectionData_Data>(index_);
    }
    XRPlaneDetectionData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint64_t>> all_planes_ids;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::XRPlaneData_Data>>> updated_planes_data;

 private:
  XRPlaneDetectionData_Data();
  ~XRPlaneDetectionData_Data() = delete;
};
static_assert(sizeof(XRPlaneDetectionData_Data) == 24,
              "Bad sizeof(XRPlaneDetectionData_Data)");
// Used by XRPlaneDetectionData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRPlaneDetectionData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRPlaneDetectionData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRPlaneDetectionData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRPlaneDetectionData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRPlaneDetectionData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRAnchorData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRAnchorData_Data));
      new (data()) XRAnchorData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRAnchorData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRAnchorData_Data>(index_);
    }
    XRAnchorData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t id;
  mojo::internal::Pointer<internal::Pose_Data> mojo_from_anchor;

 private:
  XRAnchorData_Data();
  ~XRAnchorData_Data() = delete;
};
static_assert(sizeof(XRAnchorData_Data) == 24,
              "Bad sizeof(XRAnchorData_Data)");
// Used by XRAnchorData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRAnchorData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRAnchorData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRAnchorData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRAnchorData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRAnchorData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRAnchorsData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRAnchorsData_Data));
      new (data()) XRAnchorsData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRAnchorsData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRAnchorsData_Data>(index_);
    }
    XRAnchorsData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint64_t>> all_anchors_ids;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::XRAnchorData_Data>>> updated_anchors_data;

 private:
  XRAnchorsData_Data();
  ~XRAnchorsData_Data() = delete;
};
static_assert(sizeof(XRAnchorsData_Data) == 24,
              "Bad sizeof(XRAnchorsData_Data)");
// Used by XRAnchorsData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRAnchorsData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRAnchorsData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRAnchorsData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRAnchorsData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRAnchorsData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRHitTestSubscriptionResultData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRHitTestSubscriptionResultData_Data));
      new (data()) XRHitTestSubscriptionResultData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRHitTestSubscriptionResultData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRHitTestSubscriptionResultData_Data>(index_);
    }
    XRHitTestSubscriptionResultData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t subscription_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::XRHitResult_Data>>> hit_test_results;

 private:
  XRHitTestSubscriptionResultData_Data();
  ~XRHitTestSubscriptionResultData_Data() = delete;
};
static_assert(sizeof(XRHitTestSubscriptionResultData_Data) == 24,
              "Bad sizeof(XRHitTestSubscriptionResultData_Data)");
// Used by XRHitTestSubscriptionResultData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRHitTestSubscriptionResultData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRHitTestSubscriptionResultData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRHitTestSubscriptionResultData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRHitTestSubscriptionResultData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRHitTestSubscriptionResultData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRHitTestTransientInputSubscriptionResultData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRHitTestTransientInputSubscriptionResultData_Data));
      new (data()) XRHitTestTransientInputSubscriptionResultData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRHitTestTransientInputSubscriptionResultData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRHitTestTransientInputSubscriptionResultData_Data>(index_);
    }
    XRHitTestTransientInputSubscriptionResultData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t subscription_id;
  mojo::internal::Pointer<mojo::internal::Map_Data<uint32_t, mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::XRHitResult_Data>>>>> input_source_id_to_hit_test_results;

 private:
  XRHitTestTransientInputSubscriptionResultData_Data();
  ~XRHitTestTransientInputSubscriptionResultData_Data() = delete;
};
static_assert(sizeof(XRHitTestTransientInputSubscriptionResultData_Data) == 24,
              "Bad sizeof(XRHitTestTransientInputSubscriptionResultData_Data)");
// Used by XRHitTestTransientInputSubscriptionResultData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRHitTestTransientInputSubscriptionResultData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRHitTestTransientInputSubscriptionResultData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRHitTestTransientInputSubscriptionResultData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRHitTestTransientInputSubscriptionResultData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRHitTestTransientInputSubscriptionResultData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRHitTestSubscriptionResultsData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRHitTestSubscriptionResultsData_Data));
      new (data()) XRHitTestSubscriptionResultsData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRHitTestSubscriptionResultsData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRHitTestSubscriptionResultsData_Data>(index_);
    }
    XRHitTestSubscriptionResultsData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::XRHitTestSubscriptionResultData_Data>>> results;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::XRHitTestTransientInputSubscriptionResultData_Data>>> transient_input_results;

 private:
  XRHitTestSubscriptionResultsData_Data();
  ~XRHitTestSubscriptionResultsData_Data() = delete;
};
static_assert(sizeof(XRHitTestSubscriptionResultsData_Data) == 24,
              "Bad sizeof(XRHitTestSubscriptionResultsData_Data)");
// Used by XRHitTestSubscriptionResultsData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRHitTestSubscriptionResultsData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRHitTestSubscriptionResultsData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRHitTestSubscriptionResultsData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRHitTestSubscriptionResultsData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRHitTestSubscriptionResultsData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) RgbTupleF32_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RgbTupleF32_Data));
      new (data()) RgbTupleF32_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RgbTupleF32_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RgbTupleF32_Data>(index_);
    }
    RgbTupleF32_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  float red;
  float green;
  float blue;
  uint8_t padfinal_[4];

 private:
  RgbTupleF32_Data();
  ~RgbTupleF32_Data() = delete;
};
static_assert(sizeof(RgbTupleF32_Data) == 24,
              "Bad sizeof(RgbTupleF32_Data)");
// Used by RgbTupleF32::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct RgbTupleF32_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  RgbTupleF32_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~RgbTupleF32_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    RgbTupleF32_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    RgbTupleF32_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRSphericalHarmonics_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRSphericalHarmonics_Data));
      new (data()) XRSphericalHarmonics_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRSphericalHarmonics_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRSphericalHarmonics_Data>(index_);
    }
    XRSphericalHarmonics_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::RgbTupleF32_Data>>> coefficients;

 private:
  XRSphericalHarmonics_Data();
  ~XRSphericalHarmonics_Data() = delete;
};
static_assert(sizeof(XRSphericalHarmonics_Data) == 16,
              "Bad sizeof(XRSphericalHarmonics_Data)");
// Used by XRSphericalHarmonics::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRSphericalHarmonics_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRSphericalHarmonics_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRSphericalHarmonics_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRSphericalHarmonics_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRSphericalHarmonics_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) RgbaTupleF16_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RgbaTupleF16_Data));
      new (data()) RgbaTupleF16_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RgbaTupleF16_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RgbaTupleF16_Data>(index_);
    }
    RgbaTupleF16_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint16_t red;
  uint16_t green;
  uint16_t blue;
  uint16_t alpha;

 private:
  RgbaTupleF16_Data();
  ~RgbaTupleF16_Data() = delete;
};
static_assert(sizeof(RgbaTupleF16_Data) == 16,
              "Bad sizeof(RgbaTupleF16_Data)");
// Used by RgbaTupleF16::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct RgbaTupleF16_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  RgbaTupleF16_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~RgbaTupleF16_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    RgbaTupleF16_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    RgbaTupleF16_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRCubeMap_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRCubeMap_Data));
      new (data()) XRCubeMap_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRCubeMap_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRCubeMap_Data>(index_);
    }
    XRCubeMap_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t width_and_height;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::RgbaTupleF16_Data>>> positive_x;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::RgbaTupleF16_Data>>> negative_x;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::RgbaTupleF16_Data>>> positive_y;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::RgbaTupleF16_Data>>> negative_y;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::RgbaTupleF16_Data>>> positive_z;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::RgbaTupleF16_Data>>> negative_z;

 private:
  XRCubeMap_Data();
  ~XRCubeMap_Data() = delete;
};
static_assert(sizeof(XRCubeMap_Data) == 64,
              "Bad sizeof(XRCubeMap_Data)");
// Used by XRCubeMap::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRCubeMap_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRCubeMap_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRCubeMap_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRCubeMap_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRCubeMap_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRLightProbe_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRLightProbe_Data));
      new (data()) XRLightProbe_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRLightProbe_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRLightProbe_Data>(index_);
    }
    XRLightProbe_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::XRSphericalHarmonics_Data> spherical_harmonics;
  mojo::internal::Pointer<::gfx::mojom::internal::Vector3dF_Data> main_light_direction;
  mojo::internal::Pointer<internal::RgbTupleF32_Data> main_light_intensity;

 private:
  XRLightProbe_Data();
  ~XRLightProbe_Data() = delete;
};
static_assert(sizeof(XRLightProbe_Data) == 32,
              "Bad sizeof(XRLightProbe_Data)");
// Used by XRLightProbe::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRLightProbe_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRLightProbe_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRLightProbe_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRLightProbe_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRLightProbe_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRReflectionProbe_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRReflectionProbe_Data));
      new (data()) XRReflectionProbe_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRReflectionProbe_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRReflectionProbe_Data>(index_);
    }
    XRReflectionProbe_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::XRCubeMap_Data> cube_map;

 private:
  XRReflectionProbe_Data();
  ~XRReflectionProbe_Data() = delete;
};
static_assert(sizeof(XRReflectionProbe_Data) == 16,
              "Bad sizeof(XRReflectionProbe_Data)");
// Used by XRReflectionProbe::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRReflectionProbe_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRReflectionProbe_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRReflectionProbe_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRReflectionProbe_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRReflectionProbe_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRLightEstimationData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRLightEstimationData_Data));
      new (data()) XRLightEstimationData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRLightEstimationData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRLightEstimationData_Data>(index_);
    }
    XRLightEstimationData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::XRLightProbe_Data> light_probe;
  mojo::internal::Pointer<internal::XRReflectionProbe_Data> reflection_probe;

 private:
  XRLightEstimationData_Data();
  ~XRLightEstimationData_Data() = delete;
};
static_assert(sizeof(XRLightEstimationData_Data) == 24,
              "Bad sizeof(XRLightEstimationData_Data)");
// Used by XRLightEstimationData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRLightEstimationData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRLightEstimationData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRLightEstimationData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRLightEstimationData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRLightEstimationData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRDepthDataStillValid_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRDepthDataStillValid_Data));
      new (data()) XRDepthDataStillValid_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRDepthDataStillValid_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRDepthDataStillValid_Data>(index_);
    }
    XRDepthDataStillValid_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  XRDepthDataStillValid_Data();
  ~XRDepthDataStillValid_Data() = delete;
};
static_assert(sizeof(XRDepthDataStillValid_Data) == 8,
              "Bad sizeof(XRDepthDataStillValid_Data)");
// Used by XRDepthDataStillValid::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRDepthDataStillValid_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRDepthDataStillValid_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRDepthDataStillValid_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRDepthDataStillValid_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRDepthDataStillValid_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRDepthDataUpdated_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRDepthDataUpdated_Data));
      new (data()) XRDepthDataUpdated_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRDepthDataUpdated_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRDepthDataUpdated_Data>(index_);
    }
    XRDepthDataUpdated_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> time_delta;
  ::mojo_base::mojom::internal::BigBuffer_Data pixel_data;
  mojo::internal::Pointer<::gfx::mojom::internal::Transform_Data> norm_texture_from_norm_view;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> size;

 private:
  XRDepthDataUpdated_Data();
  ~XRDepthDataUpdated_Data() = delete;
};
static_assert(sizeof(XRDepthDataUpdated_Data) == 48,
              "Bad sizeof(XRDepthDataUpdated_Data)");
// Used by XRDepthDataUpdated::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRDepthDataUpdated_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRDepthDataUpdated_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRDepthDataUpdated_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRDepthDataUpdated_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRDepthDataUpdated_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRFrameData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRFrameData_Data));
      new (data()) XRFrameData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRFrameData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRFrameData_Data>(index_);
    }
    XRFrameData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::VRPose_Data> pose;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> time_delta;
  mojo::internal::Pointer<::gpu::mojom::internal::MailboxHolder_Data> buffer_holder;
  mojo::internal::Pointer<::gpu::mojom::internal::MailboxHolder_Data> camera_image_buffer_holder;
  internal::XRDepthData_Data depth_data;
  uint8_t mojo_space_reset : 1;
  uint8_t stage_parameters_updated : 1;
  uint8_t pad6_[1];
  int16_t frame_id;
  uint8_t pad7_[4];
  mojo::internal::Pointer<internal::VREyeParameters_Data> left_eye;
  mojo::internal::Pointer<internal::VREyeParameters_Data> right_eye;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::XRInputSourceState_Data>>> input_state;
  mojo::internal::Pointer<internal::VRStageParameters_Data> stage_parameters;
  mojo::internal::Pointer<internal::XRPlaneDetectionData_Data> detected_planes_data;
  mojo::internal::Pointer<internal::XRAnchorsData_Data> anchors_data;
  mojo::internal::Pointer<internal::XRLightEstimationData_Data> light_estimation_data;
  mojo::internal::Pointer<internal::XRHitTestSubscriptionResultsData_Data> hit_test_subscription_results;

 private:
  XRFrameData_Data();
  ~XRFrameData_Data() = delete;
};
static_assert(sizeof(XRFrameData_Data) == 128,
              "Bad sizeof(XRFrameData_Data)");
// Used by XRFrameData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRFrameData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRFrameData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRFrameData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRFrameData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRFrameData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) RequestSessionSuccess_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RequestSessionSuccess_Data));
      new (data()) RequestSessionSuccess_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RequestSessionSuccess_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RequestSessionSuccess_Data>(index_);
    }
    RequestSessionSuccess_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::XRSession_Data> session;
  mojo::internal::Interface_Data metrics_recorder;

 private:
  RequestSessionSuccess_Data();
  ~RequestSessionSuccess_Data() = delete;
};
static_assert(sizeof(RequestSessionSuccess_Data) == 24,
              "Bad sizeof(RequestSessionSuccess_Data)");
// Used by RequestSessionSuccess::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct RequestSessionSuccess_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  RequestSessionSuccess_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~RequestSessionSuccess_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    RequestSessionSuccess_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    RequestSessionSuccess_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(DEVICE_VR_MOJO_BINDINGS_SHARED) XRFrameDataRequestOptions_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(XRFrameDataRequestOptions_Data));
      new (data()) XRFrameDataRequestOptions_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    XRFrameDataRequestOptions_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<XRFrameDataRequestOptions_Data>(index_);
    }
    XRFrameDataRequestOptions_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t include_lighting_estimation_data : 1;
  uint8_t padfinal_[7];

 private:
  XRFrameDataRequestOptions_Data();
  ~XRFrameDataRequestOptions_Data() = delete;
};
static_assert(sizeof(XRFrameDataRequestOptions_Data) == 16,
              "Bad sizeof(XRFrameDataRequestOptions_Data)");
// Used by XRFrameDataRequestOptions::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct XRFrameDataRequestOptions_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  XRFrameDataRequestOptions_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~XRFrameDataRequestOptions_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    XRFrameDataRequestOptions_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    XRFrameDataRequestOptions_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace device

#endif  // DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_SHARED_INTERNAL_H_