// device/vr/public/mojom/browser_test_interfaces.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_BROWSER_TEST_INTERFACES_MOJOM_SHARED_H_
#define DEVICE_VR_PUBLIC_MOJOM_BROWSER_TEST_INTERFACES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "device/vr/public/mojom/browser_test_interfaces.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace device_test {
namespace mojom {
class ColorDataView;

class SubmittedFrameDataDataView;

class PoseFrameDataDataView;

class ProjectionRawDataView;

class DeviceConfigDataView;

class ControllerAxisDataDataView;

class ControllerFrameDataDataView;

class EventDataDataView;



}  // namespace mojom
}  // namespace device_test

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device_test::mojom::ColorDataView> {
  using Data = ::device_test::mojom::internal::Color_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device_test::mojom::SubmittedFrameDataDataView> {
  using Data = ::device_test::mojom::internal::SubmittedFrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device_test::mojom::PoseFrameDataDataView> {
  using Data = ::device_test::mojom::internal::PoseFrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device_test::mojom::ProjectionRawDataView> {
  using Data = ::device_test::mojom::internal::ProjectionRaw_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device_test::mojom::DeviceConfigDataView> {
  using Data = ::device_test::mojom::internal::DeviceConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device_test::mojom::ControllerAxisDataDataView> {
  using Data = ::device_test::mojom::internal::ControllerAxisData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device_test::mojom::ControllerFrameDataDataView> {
  using Data = ::device_test::mojom::internal::ControllerFrameData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device_test::mojom::EventDataDataView> {
  using Data = ::device_test::mojom::internal::EventData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device_test {
namespace mojom {


enum class Eye : int32_t {
  
  LEFT = 1,
  
  RIGHT = 2,
  kMinValue = 1,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, Eye value);
inline bool IsKnownEnumValue(Eye value) {
  return internal::Eye_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TrackedDeviceClass : int32_t {
  
  kTrackedDeviceInvalid = 0,
  
  kTrackedDeviceHmd = 1,
  
  kTrackedDeviceController = 2,
  
  kTrackedDeviceGenericTracker = 3,
  
  kTrackedDeviceTrackingReference = 4,
  
  kTrackedDeviceDisplayRedirect = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, TrackedDeviceClass value);
inline bool IsKnownEnumValue(TrackedDeviceClass value) {
  return internal::TrackedDeviceClass_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ControllerRole : int32_t {
  
  kControllerRoleInvalid = 0,
  
  kControllerRoleLeft = 1,
  
  kControllerRoleRight = 2,
  
  kControllerRoleVoice = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, ControllerRole value);
inline bool IsKnownEnumValue(ControllerRole value) {
  return internal::ControllerRole_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EventType : int32_t {
  
  kSessionLost = 0,
  
  kVisibilityVisibleBlurred = 1,
  
  kInstanceLost = 2,
  
  kInteractionProfileChanged = 3,
  
  kNoEvent = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, EventType value);
inline bool IsKnownEnumValue(EventType value) {
  return internal::EventType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class InteractionProfileType : int32_t {
  
  kWMRMotion = 0,
  
  kKHRSimple = 1,
  
  kInvalid = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_VR_TEST_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, InteractionProfileType value);
inline bool IsKnownEnumValue(InteractionProfileType value) {
  return internal::InteractionProfileType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class XRTestHookInterfaceBase {};

using XRTestHookPtrDataView =
    mojo::InterfacePtrDataView<XRTestHookInterfaceBase>;
using XRTestHookRequestDataView =
    mojo::InterfaceRequestDataView<XRTestHookInterfaceBase>;
using XRTestHookAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRTestHookInterfaceBase>;
using XRTestHookAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRTestHookInterfaceBase>;
class XRServiceTestHookInterfaceBase {};

using XRServiceTestHookPtrDataView =
    mojo::InterfacePtrDataView<XRServiceTestHookInterfaceBase>;
using XRServiceTestHookRequestDataView =
    mojo::InterfaceRequestDataView<XRServiceTestHookInterfaceBase>;
using XRServiceTestHookAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<XRServiceTestHookInterfaceBase>;
using XRServiceTestHookAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<XRServiceTestHookInterfaceBase>;


class ColorDataView {
 public:
  ColorDataView() {}

  ColorDataView(
      internal::Color_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t r() const {
    return data_->r;
  }
  uint8_t g() const {
    return data_->g;
  }
  uint8_t b() const {
    return data_->b;
  }
  uint8_t a() const {
    return data_->a;
  }
 private:
  internal::Color_Data* data_ = nullptr;
};



class SubmittedFrameDataDataView {
 public:
  SubmittedFrameDataDataView() {}

  SubmittedFrameDataDataView(
      internal::SubmittedFrameData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetColorDataView(
      ColorDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadColor(UserType* output) {
    
    auto* pointer = data_->color.Get();
    return mojo::internal::Deserialize<::device_test::mojom::ColorDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEye(UserType* output) const {
    auto data_value = data_->eye;
    return mojo::internal::Deserialize<::device_test::mojom::Eye>(
        data_value, output);
  }

  Eye eye() const {
    return static_cast<Eye>(data_->eye);
  }
  inline void GetViewportDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadViewport(UserType* output) {
    
    auto* pointer = data_->viewport.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, context_);
  }
  inline void GetImageSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadImageSize(UserType* output) {
    
    auto* pointer = data_->image_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
 private:
  internal::SubmittedFrameData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PoseFrameDataDataView {
 public:
  PoseFrameDataDataView() {}

  PoseFrameDataDataView(
      internal::PoseFrameData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceToOriginDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDeviceToOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::TransformDataView, UserType>(),
    "Attempting to read the optional `device_to_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDeviceToOrigin` instead "
    "of `ReadDeviceToOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->device_to_origin.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, context_);
  }
 private:
  internal::PoseFrameData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ProjectionRawDataView {
 public:
  ProjectionRawDataView() {}

  ProjectionRawDataView(
      internal::ProjectionRaw_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float left() const {
    return data_->left;
  }
  float right() const {
    return data_->right;
  }
  float top() const {
    return data_->top;
  }
  float bottom() const {
    return data_->bottom;
  }
 private:
  internal::ProjectionRaw_Data* data_ = nullptr;
};



class DeviceConfigDataView {
 public:
  DeviceConfigDataView() {}

  DeviceConfigDataView(
      internal::DeviceConfig_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  float interpupillary_distance() const {
    return data_->interpupillary_distance;
  }
  inline void GetProjectionLeftDataView(
      ProjectionRawDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadProjectionLeft(UserType* output) {
    
    auto* pointer = data_->projection_left.Get();
    return mojo::internal::Deserialize<::device_test::mojom::ProjectionRawDataView>(
        pointer, output, context_);
  }
  inline void GetProjectionRightDataView(
      ProjectionRawDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadProjectionRight(UserType* output) {
    
    auto* pointer = data_->projection_right.Get();
    return mojo::internal::Deserialize<::device_test::mojom::ProjectionRawDataView>(
        pointer, output, context_);
  }
 private:
  internal::DeviceConfig_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ControllerAxisDataDataView {
 public:
  ControllerAxisDataDataView() {}

  ControllerAxisDataDataView(
      internal::ControllerAxisData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float x() const {
    return data_->x;
  }
  float y() const {
    return data_->y;
  }
  uint8_t axis_type() const {
    return data_->axis_type;
  }
 private:
  internal::ControllerAxisData_Data* data_ = nullptr;
};



class ControllerFrameDataDataView {
 public:
  ControllerFrameDataDataView() {}

  ControllerFrameDataDataView(
      internal::ControllerFrameData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint32_t packet_number() const {
    return data_->packet_number;
  }
  uint64_t buttons_pressed() const {
    return data_->buttons_pressed;
  }
  uint64_t buttons_touched() const {
    return data_->buttons_touched;
  }
  uint64_t supported_buttons() const {
    return data_->supported_buttons;
  }
  inline void GetAxisDataDataView(
      mojo::ArrayDataView<ControllerAxisDataDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAxisData(UserType* output) {
    
    auto* pointer = data_->axis_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device_test::mojom::ControllerAxisDataDataView>>(
        pointer, output, context_);
  }
  inline void GetPoseDataDataView(
      PoseFrameDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPoseData(UserType* output) {
    
    auto* pointer = data_->pose_data.Get();
    return mojo::internal::Deserialize<::device_test::mojom::PoseFrameDataDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRole(UserType* output) const {
    auto data_value = data_->role;
    return mojo::internal::Deserialize<::device_test::mojom::ControllerRole>(
        data_value, output);
  }

  ControllerRole role() const {
    return static_cast<ControllerRole>(data_->role);
  }
  bool is_valid() const {
    return data_->is_valid;
  }
 private:
  internal::ControllerFrameData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class EventDataDataView {
 public:
  EventDataDataView() {}

  EventDataDataView(
      internal::EventData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::device_test::mojom::EventType>(
        data_value, output);
  }

  EventType type() const {
    return static_cast<EventType>(data_->type);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInteractionProfile(UserType* output) const {
    auto data_value = data_->interaction_profile;
    return mojo::internal::Deserialize<::device_test::mojom::InteractionProfileType>(
        data_value, output);
  }

  InteractionProfileType interaction_profile() const {
    return static_cast<InteractionProfileType>(data_->interaction_profile);
  }
 private:
  internal::EventData_Data* data_ = nullptr;
};



}  // namespace mojom
}  // namespace device_test

namespace std {

template <>
struct hash<::device_test::mojom::Eye>
    : public mojo::internal::EnumHashImpl<::device_test::mojom::Eye> {};

template <>
struct hash<::device_test::mojom::TrackedDeviceClass>
    : public mojo::internal::EnumHashImpl<::device_test::mojom::TrackedDeviceClass> {};

template <>
struct hash<::device_test::mojom::ControllerRole>
    : public mojo::internal::EnumHashImpl<::device_test::mojom::ControllerRole> {};

template <>
struct hash<::device_test::mojom::EventType>
    : public mojo::internal::EnumHashImpl<::device_test::mojom::EventType> {};

template <>
struct hash<::device_test::mojom::InteractionProfileType>
    : public mojo::internal::EnumHashImpl<::device_test::mojom::InteractionProfileType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::device_test::mojom::Eye, ::device_test::mojom::Eye> {
  static ::device_test::mojom::Eye ToMojom(::device_test::mojom::Eye input) { return input; }
  static bool FromMojom(::device_test::mojom::Eye input, ::device_test::mojom::Eye* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::Eye, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device_test::mojom::Eye, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device_test::mojom::Eye>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device_test::mojom::TrackedDeviceClass, ::device_test::mojom::TrackedDeviceClass> {
  static ::device_test::mojom::TrackedDeviceClass ToMojom(::device_test::mojom::TrackedDeviceClass input) { return input; }
  static bool FromMojom(::device_test::mojom::TrackedDeviceClass input, ::device_test::mojom::TrackedDeviceClass* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::TrackedDeviceClass, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device_test::mojom::TrackedDeviceClass, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device_test::mojom::TrackedDeviceClass>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device_test::mojom::ControllerRole, ::device_test::mojom::ControllerRole> {
  static ::device_test::mojom::ControllerRole ToMojom(::device_test::mojom::ControllerRole input) { return input; }
  static bool FromMojom(::device_test::mojom::ControllerRole input, ::device_test::mojom::ControllerRole* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::ControllerRole, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device_test::mojom::ControllerRole, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device_test::mojom::ControllerRole>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device_test::mojom::EventType, ::device_test::mojom::EventType> {
  static ::device_test::mojom::EventType ToMojom(::device_test::mojom::EventType input) { return input; }
  static bool FromMojom(::device_test::mojom::EventType input, ::device_test::mojom::EventType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::EventType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device_test::mojom::EventType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device_test::mojom::EventType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::device_test::mojom::InteractionProfileType, ::device_test::mojom::InteractionProfileType> {
  static ::device_test::mojom::InteractionProfileType ToMojom(::device_test::mojom::InteractionProfileType input) { return input; }
  static bool FromMojom(::device_test::mojom::InteractionProfileType input, ::device_test::mojom::InteractionProfileType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::InteractionProfileType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device_test::mojom::InteractionProfileType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::device_test::mojom::InteractionProfileType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::ColorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::ColorDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device_test::mojom::internal::Color_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->r = Traits::r(input);
    (*output)->g = Traits::g(input);
    (*output)->b = Traits::b(input);
    (*output)->a = Traits::a(input);
  }

  static bool Deserialize(::device_test::mojom::internal::Color_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device_test::mojom::ColorDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::SubmittedFrameDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::SubmittedFrameDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device_test::mojom::internal::SubmittedFrameData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::color(input)) in_color = Traits::color(input);
    typename decltype((*output)->color)::BaseType::BufferWriter
        color_writer;
    mojo::internal::Serialize<::device_test::mojom::ColorDataView>(
        in_color, buffer, &color_writer, context);
    (*output)->color.Set(
        color_writer.is_null() ? nullptr : color_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->color.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color in SubmittedFrameData struct");
    mojo::internal::Serialize<::device_test::mojom::Eye>(
        Traits::eye(input), &(*output)->eye);
    decltype(Traits::viewport(input)) in_viewport = Traits::viewport(input);
    typename decltype((*output)->viewport)::BaseType::BufferWriter
        viewport_writer;
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_viewport, buffer, &viewport_writer, context);
    (*output)->viewport.Set(
        viewport_writer.is_null() ? nullptr : viewport_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->viewport.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null viewport in SubmittedFrameData struct");
    decltype(Traits::image_size(input)) in_image_size = Traits::image_size(input);
    typename decltype((*output)->image_size)::BaseType::BufferWriter
        image_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_image_size, buffer, &image_size_writer, context);
    (*output)->image_size.Set(
        image_size_writer.is_null() ? nullptr : image_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->image_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image_size in SubmittedFrameData struct");
  }

  static bool Deserialize(::device_test::mojom::internal::SubmittedFrameData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device_test::mojom::SubmittedFrameDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::PoseFrameDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::PoseFrameDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device_test::mojom::internal::PoseFrameData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::device_to_origin(input)) in_device_to_origin = Traits::device_to_origin(input);
    typename decltype((*output)->device_to_origin)::BaseType::BufferWriter
        device_to_origin_writer;
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_device_to_origin, buffer, &device_to_origin_writer, context);
    (*output)->device_to_origin.Set(
        device_to_origin_writer.is_null() ? nullptr : device_to_origin_writer.data());
  }

  static bool Deserialize(::device_test::mojom::internal::PoseFrameData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device_test::mojom::PoseFrameDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::ProjectionRawDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::ProjectionRawDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device_test::mojom::internal::ProjectionRaw_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->left = Traits::left(input);
    (*output)->right = Traits::right(input);
    (*output)->top = Traits::top(input);
    (*output)->bottom = Traits::bottom(input);
  }

  static bool Deserialize(::device_test::mojom::internal::ProjectionRaw_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device_test::mojom::ProjectionRawDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::DeviceConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::DeviceConfigDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device_test::mojom::internal::DeviceConfig_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->interpupillary_distance = Traits::interpupillary_distance(input);
    decltype(Traits::projection_left(input)) in_projection_left = Traits::projection_left(input);
    typename decltype((*output)->projection_left)::BaseType::BufferWriter
        projection_left_writer;
    mojo::internal::Serialize<::device_test::mojom::ProjectionRawDataView>(
        in_projection_left, buffer, &projection_left_writer, context);
    (*output)->projection_left.Set(
        projection_left_writer.is_null() ? nullptr : projection_left_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->projection_left.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null projection_left in DeviceConfig struct");
    decltype(Traits::projection_right(input)) in_projection_right = Traits::projection_right(input);
    typename decltype((*output)->projection_right)::BaseType::BufferWriter
        projection_right_writer;
    mojo::internal::Serialize<::device_test::mojom::ProjectionRawDataView>(
        in_projection_right, buffer, &projection_right_writer, context);
    (*output)->projection_right.Set(
        projection_right_writer.is_null() ? nullptr : projection_right_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->projection_right.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null projection_right in DeviceConfig struct");
  }

  static bool Deserialize(::device_test::mojom::internal::DeviceConfig_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device_test::mojom::DeviceConfigDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::ControllerAxisDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::ControllerAxisDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device_test::mojom::internal::ControllerAxisData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->x = Traits::x(input);
    (*output)->y = Traits::y(input);
    (*output)->axis_type = Traits::axis_type(input);
  }

  static bool Deserialize(::device_test::mojom::internal::ControllerAxisData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device_test::mojom::ControllerAxisDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::ControllerFrameDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::ControllerFrameDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device_test::mojom::internal::ControllerFrameData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->packet_number = Traits::packet_number(input);
    (*output)->buttons_pressed = Traits::buttons_pressed(input);
    (*output)->buttons_touched = Traits::buttons_touched(input);
    (*output)->supported_buttons = Traits::supported_buttons(input);
    decltype(Traits::axis_data(input)) in_axis_data = Traits::axis_data(input);
    typename decltype((*output)->axis_data)::BaseType::BufferWriter
        axis_data_writer;
    const mojo::internal::ContainerValidateParams axis_data_validate_params(
        5, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::device_test::mojom::ControllerAxisDataDataView>>(
        in_axis_data, buffer, &axis_data_writer, &axis_data_validate_params,
        context);
    (*output)->axis_data.Set(
        axis_data_writer.is_null() ? nullptr : axis_data_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->axis_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null axis_data in ControllerFrameData struct");
    decltype(Traits::pose_data(input)) in_pose_data = Traits::pose_data(input);
    typename decltype((*output)->pose_data)::BaseType::BufferWriter
        pose_data_writer;
    mojo::internal::Serialize<::device_test::mojom::PoseFrameDataDataView>(
        in_pose_data, buffer, &pose_data_writer, context);
    (*output)->pose_data.Set(
        pose_data_writer.is_null() ? nullptr : pose_data_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->pose_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pose_data in ControllerFrameData struct");
    mojo::internal::Serialize<::device_test::mojom::ControllerRole>(
        Traits::role(input), &(*output)->role);
    (*output)->is_valid = Traits::is_valid(input);
  }

  static bool Deserialize(::device_test::mojom::internal::ControllerFrameData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device_test::mojom::ControllerFrameDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device_test::mojom::EventDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device_test::mojom::EventDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::device_test::mojom::internal::EventData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::device_test::mojom::EventType>(
        Traits::type(input), &(*output)->type);
    mojo::internal::Serialize<::device_test::mojom::InteractionProfileType>(
        Traits::interaction_profile(input), &(*output)->interaction_profile);
  }

  static bool Deserialize(::device_test::mojom::internal::EventData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device_test::mojom::EventDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device_test {
namespace mojom {



inline void SubmittedFrameDataDataView::GetColorDataView(
    ColorDataView* output) {
  auto pointer = data_->color.Get();
  *output = ColorDataView(pointer, context_);
}
inline void SubmittedFrameDataDataView::GetViewportDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->viewport.Get();
  *output = ::gfx::mojom::RectDataView(pointer, context_);
}
inline void SubmittedFrameDataDataView::GetImageSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->image_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}


inline void PoseFrameDataDataView::GetDeviceToOriginDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->device_to_origin.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, context_);
}




inline void DeviceConfigDataView::GetProjectionLeftDataView(
    ProjectionRawDataView* output) {
  auto pointer = data_->projection_left.Get();
  *output = ProjectionRawDataView(pointer, context_);
}
inline void DeviceConfigDataView::GetProjectionRightDataView(
    ProjectionRawDataView* output) {
  auto pointer = data_->projection_right.Get();
  *output = ProjectionRawDataView(pointer, context_);
}




inline void ControllerFrameDataDataView::GetAxisDataDataView(
    mojo::ArrayDataView<ControllerAxisDataDataView>* output) {
  auto pointer = data_->axis_data.Get();
  *output = mojo::ArrayDataView<ControllerAxisDataDataView>(pointer, context_);
}
inline void ControllerFrameDataDataView::GetPoseDataDataView(
    PoseFrameDataDataView* output) {
  auto pointer = data_->pose_data.Get();
  *output = PoseFrameDataDataView(pointer, context_);
}





}  // namespace mojom
}  // namespace device_test

#endif  // DEVICE_VR_PUBLIC_MOJOM_BROWSER_TEST_INTERFACES_MOJOM_SHARED_H_