// content/common/renderer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDERER_MOJOM_H_
#define CONTENT_COMMON_RENDERER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/common/renderer.mojom-shared.h"
#include "content/common/renderer.mojom-forward.h"
#include "content/common/agent_scheduling_group.mojom.h"
#include "content/common/native_types.mojom.h"
#include "mojo/public/mojom/base/generic_pending_receiver.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/network_types.mojom.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "content/common/content_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {

class RendererProxy;

template <typename ImplRefTraits>
class RendererStub;

class RendererRequestValidator;


class CONTENT_EXPORT Renderer
    : public RendererInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RendererInterfaceBase;
  using Proxy_ = RendererProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererStub<ImplRefTraits>;

  using RequestValidator_ = RendererRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateAgentSchedulingGroupMinVersion = 0,
    kCreateAssociatedAgentSchedulingGroupMinVersion = 0,
    kOnNetworkConnectionChangedMinVersion = 0,
    kOnNetworkQualityChangedMinVersion = 0,
    kSetWebKitSharedTimersSuspendedMinVersion = 0,
    kSetUserAgentMinVersion = 0,
    kSetUserAgentMetadataMinVersion = 0,
    kSetCorsExemptHeaderListMinVersion = 0,
    kUpdateScrollbarThemeMinVersion = 0,
    kOnSystemColorsChangedMinVersion = 0,
    kUpdateSystemColorInfoMinVersion = 0,
    kPurgePluginListCacheMinVersion = 0,
    kSetProcessStateMinVersion = 0,
    kSetSchedulerKeepActiveMinVersion = 0,
    kSetIsLockedToSiteMinVersion = 0,
    kSetIsCrossOriginIsolatedMinVersion = 0,
  };
  virtual ~Renderer() {}

  
  virtual void CreateAgentSchedulingGroup(::mojo::PendingRemote<::content::mojom::AgentSchedulingGroupHost> agent_scheduling_group_host, ::mojo::PendingReceiver<::content::mojom::AgentSchedulingGroup> agent_scheduling_group) = 0;

  
  virtual void CreateAssociatedAgentSchedulingGroup(::mojo::PendingAssociatedRemote<::content::mojom::AgentSchedulingGroupHost> agent_scheduling_group_host, ::mojo::PendingAssociatedReceiver<::content::mojom::AgentSchedulingGroup> agent_scheduling_group) = 0;

  
  virtual void OnNetworkConnectionChanged(::net::NetworkChangeNotifier::ConnectionType connection_type, double max_bandwidth_mbps) = 0;

  
  virtual void OnNetworkQualityChanged(::net::EffectiveConnectionType effective_connection_type, ::base::TimeDelta http_rtt, ::base::TimeDelta transport_rtt, double bandwidth_kbps) = 0;

  
  virtual void SetWebKitSharedTimersSuspended(bool suspend) = 0;

  
  virtual void SetUserAgent(const std::string& user_agent) = 0;

  
  virtual void SetUserAgentMetadata(const ::blink::UserAgentMetadata& metadata) = 0;

  
  virtual void SetCorsExemptHeaderList(const std::vector<std::string>& list) = 0;

  
  virtual void UpdateScrollbarTheme(UpdateScrollbarThemeParamsPtr params) = 0;

  
  virtual void OnSystemColorsChanged(int32_t aqua_color_variant, const std::string& highlight_text_color, const std::string& highlight_color) = 0;

  
  virtual void UpdateSystemColorInfo(UpdateSystemColorInfoParamsPtr params) = 0;

  
  virtual void PurgePluginListCache(bool reload_pages) = 0;

  
  virtual void SetProcessState(RenderProcessBackgroundState background_state, RenderProcessVisibleState visible_state) = 0;

  
  virtual void SetSchedulerKeepActive(bool keep_active) = 0;

  
  virtual void SetIsLockedToSite() = 0;

  
  virtual void SetIsCrossOriginIsolated(bool value) = 0;
};



class CONTENT_EXPORT RendererProxy
    : public Renderer {
 public:
  using InterfaceType = Renderer;

  explicit RendererProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateAgentSchedulingGroup(::mojo::PendingRemote<::content::mojom::AgentSchedulingGroupHost> agent_scheduling_group_host, ::mojo::PendingReceiver<::content::mojom::AgentSchedulingGroup> agent_scheduling_group) final;
  
  void CreateAssociatedAgentSchedulingGroup(::mojo::PendingAssociatedRemote<::content::mojom::AgentSchedulingGroupHost> agent_scheduling_group_host, ::mojo::PendingAssociatedReceiver<::content::mojom::AgentSchedulingGroup> agent_scheduling_group) final;
  
  void OnNetworkConnectionChanged(::net::NetworkChangeNotifier::ConnectionType connection_type, double max_bandwidth_mbps) final;
  
  void OnNetworkQualityChanged(::net::EffectiveConnectionType effective_connection_type, ::base::TimeDelta http_rtt, ::base::TimeDelta transport_rtt, double bandwidth_kbps) final;
  
  void SetWebKitSharedTimersSuspended(bool suspend) final;
  
  void SetUserAgent(const std::string& user_agent) final;
  
  void SetUserAgentMetadata(const ::blink::UserAgentMetadata& metadata) final;
  
  void SetCorsExemptHeaderList(const std::vector<std::string>& list) final;
  
  void UpdateScrollbarTheme(UpdateScrollbarThemeParamsPtr params) final;
  
  void OnSystemColorsChanged(int32_t aqua_color_variant, const std::string& highlight_text_color, const std::string& highlight_color) final;
  
  void UpdateSystemColorInfo(UpdateSystemColorInfoParamsPtr params) final;
  
  void PurgePluginListCache(bool reload_pages) final;
  
  void SetProcessState(RenderProcessBackgroundState background_state, RenderProcessVisibleState visible_state) final;
  
  void SetSchedulerKeepActive(bool keep_active) final;
  
  void SetIsLockedToSite() final;
  
  void SetIsCrossOriginIsolated(bool value) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT RendererStubDispatch {
 public:
  static bool Accept(Renderer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Renderer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Renderer>>
class RendererStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererStub() {}
  ~RendererStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT RendererRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class CONTENT_EXPORT UpdateScrollbarThemeParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UpdateScrollbarThemeParams, T>::value>;
  using DataView = UpdateScrollbarThemeParamsDataView;
  using Data_ = internal::UpdateScrollbarThemeParams_Data;

  template <typename... Args>
  static UpdateScrollbarThemeParamsPtr New(Args&&... args) {
    return UpdateScrollbarThemeParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UpdateScrollbarThemeParamsPtr From(const U& u) {
    return mojo::TypeConverter<UpdateScrollbarThemeParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UpdateScrollbarThemeParams>::Convert(*this);
  }


  UpdateScrollbarThemeParams();

  UpdateScrollbarThemeParams(
      bool has_initial_button_delay,
      float initial_button_delay,
      bool has_autoscroll_button_delay,
      float autoscroll_button_delay,
      bool jump_on_track_click,
      ::content::mojom::ScrollerStyle preferred_scroller_style,
      bool redraw,
      bool scroll_view_rubber_banding);

  ~UpdateScrollbarThemeParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UpdateScrollbarThemeParamsPtr>
  UpdateScrollbarThemeParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UpdateScrollbarThemeParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UpdateScrollbarThemeParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UpdateScrollbarThemeParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UpdateScrollbarThemeParams_UnserializedMessageContext<
            UserType, UpdateScrollbarThemeParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<UpdateScrollbarThemeParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return UpdateScrollbarThemeParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UpdateScrollbarThemeParams_UnserializedMessageContext<
            UserType, UpdateScrollbarThemeParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UpdateScrollbarThemeParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool has_initial_button_delay;
  
  float initial_button_delay;
  
  bool has_autoscroll_button_delay;
  
  float autoscroll_button_delay;
  
  bool jump_on_track_click;
  
  ::content::mojom::ScrollerStyle preferred_scroller_style;
  
  bool redraw;
  
  bool scroll_view_rubber_banding;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UpdateScrollbarThemeParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UpdateScrollbarThemeParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UpdateScrollbarThemeParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UpdateScrollbarThemeParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT UpdateSystemColorInfoParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UpdateSystemColorInfoParams, T>::value>;
  using DataView = UpdateSystemColorInfoParamsDataView;
  using Data_ = internal::UpdateSystemColorInfoParams_Data;

  template <typename... Args>
  static UpdateSystemColorInfoParamsPtr New(Args&&... args) {
    return UpdateSystemColorInfoParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UpdateSystemColorInfoParamsPtr From(const U& u) {
    return mojo::TypeConverter<UpdateSystemColorInfoParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UpdateSystemColorInfoParams>::Convert(*this);
  }


  UpdateSystemColorInfoParams();

  UpdateSystemColorInfoParams(
      bool is_dark_mode,
      bool is_high_contrast,
      const base::flat_map<::ui::NativeTheme::SystemThemeColor, uint32_t>& colors);

  ~UpdateSystemColorInfoParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UpdateSystemColorInfoParamsPtr>
  UpdateSystemColorInfoParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UpdateSystemColorInfoParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UpdateSystemColorInfoParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UpdateSystemColorInfoParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UpdateSystemColorInfoParams_UnserializedMessageContext<
            UserType, UpdateSystemColorInfoParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<UpdateSystemColorInfoParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return UpdateSystemColorInfoParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UpdateSystemColorInfoParams_UnserializedMessageContext<
            UserType, UpdateSystemColorInfoParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UpdateSystemColorInfoParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool is_dark_mode;
  
  bool is_high_contrast;
  
  base::flat_map<::ui::NativeTheme::SystemThemeColor, uint32_t> colors;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UpdateSystemColorInfoParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UpdateSystemColorInfoParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UpdateSystemColorInfoParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UpdateSystemColorInfoParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
UpdateScrollbarThemeParamsPtr UpdateScrollbarThemeParams::Clone() const {
  return New(
      mojo::Clone(has_initial_button_delay),
      mojo::Clone(initial_button_delay),
      mojo::Clone(has_autoscroll_button_delay),
      mojo::Clone(autoscroll_button_delay),
      mojo::Clone(jump_on_track_click),
      mojo::Clone(preferred_scroller_style),
      mojo::Clone(redraw),
      mojo::Clone(scroll_view_rubber_banding)
  );
}

template <typename T, UpdateScrollbarThemeParams::EnableIfSame<T>*>
bool UpdateScrollbarThemeParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->has_initial_button_delay, other_struct.has_initial_button_delay))
    return false;
  if (!mojo::Equals(this->initial_button_delay, other_struct.initial_button_delay))
    return false;
  if (!mojo::Equals(this->has_autoscroll_button_delay, other_struct.has_autoscroll_button_delay))
    return false;
  if (!mojo::Equals(this->autoscroll_button_delay, other_struct.autoscroll_button_delay))
    return false;
  if (!mojo::Equals(this->jump_on_track_click, other_struct.jump_on_track_click))
    return false;
  if (!mojo::Equals(this->preferred_scroller_style, other_struct.preferred_scroller_style))
    return false;
  if (!mojo::Equals(this->redraw, other_struct.redraw))
    return false;
  if (!mojo::Equals(this->scroll_view_rubber_banding, other_struct.scroll_view_rubber_banding))
    return false;
  return true;
}

template <typename T, UpdateScrollbarThemeParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.has_initial_button_delay, rhs.has_initial_button_delay))
    return true;
  if (std::less<>{}(rhs.has_initial_button_delay, lhs.has_initial_button_delay))
    return false;
  if (std::less<>{}(lhs.initial_button_delay, rhs.initial_button_delay))
    return true;
  if (std::less<>{}(rhs.initial_button_delay, lhs.initial_button_delay))
    return false;
  if (std::less<>{}(lhs.has_autoscroll_button_delay, rhs.has_autoscroll_button_delay))
    return true;
  if (std::less<>{}(rhs.has_autoscroll_button_delay, lhs.has_autoscroll_button_delay))
    return false;
  if (std::less<>{}(lhs.autoscroll_button_delay, rhs.autoscroll_button_delay))
    return true;
  if (std::less<>{}(rhs.autoscroll_button_delay, lhs.autoscroll_button_delay))
    return false;
  if (std::less<>{}(lhs.jump_on_track_click, rhs.jump_on_track_click))
    return true;
  if (std::less<>{}(rhs.jump_on_track_click, lhs.jump_on_track_click))
    return false;
  if (std::less<>{}(lhs.preferred_scroller_style, rhs.preferred_scroller_style))
    return true;
  if (std::less<>{}(rhs.preferred_scroller_style, lhs.preferred_scroller_style))
    return false;
  if (std::less<>{}(lhs.redraw, rhs.redraw))
    return true;
  if (std::less<>{}(rhs.redraw, lhs.redraw))
    return false;
  if (std::less<>{}(lhs.scroll_view_rubber_banding, rhs.scroll_view_rubber_banding))
    return true;
  if (std::less<>{}(rhs.scroll_view_rubber_banding, lhs.scroll_view_rubber_banding))
    return false;
  return false;
}
template <typename StructPtrType>
UpdateSystemColorInfoParamsPtr UpdateSystemColorInfoParams::Clone() const {
  return New(
      mojo::Clone(is_dark_mode),
      mojo::Clone(is_high_contrast),
      mojo::Clone(colors)
  );
}

template <typename T, UpdateSystemColorInfoParams::EnableIfSame<T>*>
bool UpdateSystemColorInfoParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_dark_mode, other_struct.is_dark_mode))
    return false;
  if (!mojo::Equals(this->is_high_contrast, other_struct.is_high_contrast))
    return false;
  if (!mojo::Equals(this->colors, other_struct.colors))
    return false;
  return true;
}

template <typename T, UpdateSystemColorInfoParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.is_dark_mode, rhs.is_dark_mode))
    return true;
  if (std::less<>{}(rhs.is_dark_mode, lhs.is_dark_mode))
    return false;
  if (std::less<>{}(lhs.is_high_contrast, rhs.is_high_contrast))
    return true;
  if (std::less<>{}(rhs.is_high_contrast, lhs.is_high_contrast))
    return false;
  if (std::less<>{}(lhs.colors, rhs.colors))
    return true;
  if (std::less<>{}(rhs.colors, lhs.colors))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace content

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::UpdateScrollbarThemeParams::DataView,
                                         ::content::mojom::UpdateScrollbarThemeParamsPtr> {
  static bool IsNull(const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::UpdateScrollbarThemeParamsPtr* output) { output->reset(); }

  static decltype(::content::mojom::UpdateScrollbarThemeParams::has_initial_button_delay) has_initial_button_delay(
      const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) {
    return input->has_initial_button_delay;
  }

  static decltype(::content::mojom::UpdateScrollbarThemeParams::initial_button_delay) initial_button_delay(
      const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) {
    return input->initial_button_delay;
  }

  static decltype(::content::mojom::UpdateScrollbarThemeParams::has_autoscroll_button_delay) has_autoscroll_button_delay(
      const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) {
    return input->has_autoscroll_button_delay;
  }

  static decltype(::content::mojom::UpdateScrollbarThemeParams::autoscroll_button_delay) autoscroll_button_delay(
      const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) {
    return input->autoscroll_button_delay;
  }

  static decltype(::content::mojom::UpdateScrollbarThemeParams::jump_on_track_click) jump_on_track_click(
      const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) {
    return input->jump_on_track_click;
  }

  static decltype(::content::mojom::UpdateScrollbarThemeParams::preferred_scroller_style) preferred_scroller_style(
      const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) {
    return input->preferred_scroller_style;
  }

  static decltype(::content::mojom::UpdateScrollbarThemeParams::redraw) redraw(
      const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) {
    return input->redraw;
  }

  static decltype(::content::mojom::UpdateScrollbarThemeParams::scroll_view_rubber_banding) scroll_view_rubber_banding(
      const ::content::mojom::UpdateScrollbarThemeParamsPtr& input) {
    return input->scroll_view_rubber_banding;
  }

  static bool Read(::content::mojom::UpdateScrollbarThemeParams::DataView input, ::content::mojom::UpdateScrollbarThemeParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::UpdateSystemColorInfoParams::DataView,
                                         ::content::mojom::UpdateSystemColorInfoParamsPtr> {
  static bool IsNull(const ::content::mojom::UpdateSystemColorInfoParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::UpdateSystemColorInfoParamsPtr* output) { output->reset(); }

  static decltype(::content::mojom::UpdateSystemColorInfoParams::is_dark_mode) is_dark_mode(
      const ::content::mojom::UpdateSystemColorInfoParamsPtr& input) {
    return input->is_dark_mode;
  }

  static decltype(::content::mojom::UpdateSystemColorInfoParams::is_high_contrast) is_high_contrast(
      const ::content::mojom::UpdateSystemColorInfoParamsPtr& input) {
    return input->is_high_contrast;
  }

  static const decltype(::content::mojom::UpdateSystemColorInfoParams::colors)& colors(
      const ::content::mojom::UpdateSystemColorInfoParamsPtr& input) {
    return input->colors;
  }

  static bool Read(::content::mojom::UpdateSystemColorInfoParams::DataView input, ::content::mojom::UpdateSystemColorInfoParamsPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_RENDERER_MOJOM_H_