// content/common/prefetched_signed_exchange_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_SHARED_H_
#define CONTENT_COMMON_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "content/common/prefetched_signed_exchange_info.mojom-shared-internal.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "base/component_export.h"




namespace content {
namespace mojom {
using SHA256HashValueDataView = mojo::native::NativeStructDataView;

class PrefetchedSignedExchangeInfoDataView;



}  // namespace mojom
}  // namespace content

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::PrefetchedSignedExchangeInfoDataView> {
  using Data = ::content::mojom::internal::PrefetchedSignedExchangeInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content {
namespace mojom {


class PrefetchedSignedExchangeInfoDataView {
 public:
  PrefetchedSignedExchangeInfoDataView() {}

  PrefetchedSignedExchangeInfoDataView(
      internal::PrefetchedSignedExchangeInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetOuterUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOuterUrl(UserType* output) {
    
    auto* pointer = data_->outer_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetHeaderIntegrityDataView(
      SHA256HashValueDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHeaderIntegrity(UserType* output) {
    
    auto* pointer = data_->header_integrity.Get();
    return mojo::internal::Deserialize<::content::mojom::SHA256HashValueDataView>(
        pointer, output, context_);
  }
  inline void GetInnerUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInnerUrl(UserType* output) {
    
    auto* pointer = data_->inner_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetInnerResponseDataView(
      ::network::mojom::URLResponseHeadDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInnerResponse(UserType* output) {
    
    auto* pointer = data_->inner_response.Get();
    return mojo::internal::Deserialize<::network::mojom::URLResponseHeadDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  UserType TakeLoaderFactoryHandle() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
            &data_->loader_factory_handle, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PrefetchedSignedExchangeInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace content

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::PrefetchedSignedExchangeInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::PrefetchedSignedExchangeInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::PrefetchedSignedExchangeInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::outer_url(input)) in_outer_url = Traits::outer_url(input);
    typename decltype((*output)->outer_url)::BaseType::BufferWriter
        outer_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_outer_url, buffer, &outer_url_writer, context);
    (*output)->outer_url.Set(
        outer_url_writer.is_null() ? nullptr : outer_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->outer_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null outer_url in PrefetchedSignedExchangeInfo struct");
    decltype(Traits::header_integrity(input)) in_header_integrity = Traits::header_integrity(input);
    typename decltype((*output)->header_integrity)::BaseType::BufferWriter
        header_integrity_writer;
    mojo::internal::Serialize<::content::mojom::SHA256HashValueDataView>(
        in_header_integrity, buffer, &header_integrity_writer, context);
    (*output)->header_integrity.Set(
        header_integrity_writer.is_null() ? nullptr : header_integrity_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->header_integrity.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null header_integrity in PrefetchedSignedExchangeInfo struct");
    decltype(Traits::inner_url(input)) in_inner_url = Traits::inner_url(input);
    typename decltype((*output)->inner_url)::BaseType::BufferWriter
        inner_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_inner_url, buffer, &inner_url_writer, context);
    (*output)->inner_url.Set(
        inner_url_writer.is_null() ? nullptr : inner_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->inner_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null inner_url in PrefetchedSignedExchangeInfo struct");
    decltype(Traits::inner_response(input)) in_inner_response = Traits::inner_response(input);
    typename decltype((*output)->inner_response)::BaseType::BufferWriter
        inner_response_writer;
    mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
        in_inner_response, buffer, &inner_response_writer, context);
    (*output)->inner_response.Set(
        inner_response_writer.is_null() ? nullptr : inner_response_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->inner_response.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null inner_response in PrefetchedSignedExchangeInfo struct");
    decltype(Traits::loader_factory_handle(input)) in_loader_factory_handle = Traits::loader_factory_handle(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
        in_loader_factory_handle, &(*output)->loader_factory_handle, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->loader_factory_handle),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid loader_factory_handle in PrefetchedSignedExchangeInfo struct");
  }

  static bool Deserialize(::content::mojom::internal::PrefetchedSignedExchangeInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::PrefetchedSignedExchangeInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content {
namespace mojom {

inline void PrefetchedSignedExchangeInfoDataView::GetOuterUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->outer_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void PrefetchedSignedExchangeInfoDataView::GetHeaderIntegrityDataView(
    SHA256HashValueDataView* output) {
  auto pointer = data_->header_integrity.Get();
  *output = SHA256HashValueDataView(pointer, context_);
}
inline void PrefetchedSignedExchangeInfoDataView::GetInnerUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->inner_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void PrefetchedSignedExchangeInfoDataView::GetInnerResponseDataView(
    ::network::mojom::URLResponseHeadDataView* output) {
  auto pointer = data_->inner_response.Get();
  *output = ::network::mojom::URLResponseHeadDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace content

#endif  // CONTENT_COMMON_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_SHARED_H_