// content/common/navigation_params.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_NAVIGATION_PARAMS_MOJOM_SHARED_INTERNAL_H_
#define CONTENT_COMMON_NAVIGATION_PARAMS_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "content/common/prefetched_signed_exchange_info.mojom-shared-internal.h"
#include "content/public/common/was_activated_option.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared-internal.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared-internal.h"
#include "services/network/public/mojom/fetch_api.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared-internal.h"
#include "services/network/public/mojom/source_location.mojom-shared-internal.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared-internal.h"
#include "services/network/public/mojom/url_loader.mojom-shared-internal.h"
#include "services/network/public/mojom/url_response_head.mojom-shared-internal.h"
#include "services/network/public/mojom/web_client_hints_types.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/page/page.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace content {
namespace mojom {
namespace internal {
using Impression_Data = mojo::native::internal::NativeStruct_Data;
using NavigationDownloadPolicy_Data = mojo::native::internal::NativeStruct_Data;
using PageState_Data = mojo::native::internal::NativeStruct_Data;
class InitiatorCSPInfo_Data;
class BeginNavigationParams_Data;
class CommonNavigationParams_Data;
class NavigationTiming_Data;
class OldPageInfo_Data;
class CommitNavigationParams_Data;
using MixedContentContextType_Data =
    mojo::internal::NativeEnum_Data;
using PageTransition_Data =
    mojo::internal::NativeEnum_Data;

struct NavigationType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) InitiatorCSPInfo_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(InitiatorCSPInfo_Data));
      new (data()) InitiatorCSPInfo_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    InitiatorCSPInfo_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<InitiatorCSPInfo_Data>(index_);
    }
    InitiatorCSPInfo_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t should_check_main_world_csp;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::ContentSecurityPolicy_Data>>> initiator_csp;
  mojo::internal::Pointer<::network::mojom::internal::CSPSource_Data> initiator_self_source;

 private:
  InitiatorCSPInfo_Data();
  ~InitiatorCSPInfo_Data() = delete;
};
static_assert(sizeof(InitiatorCSPInfo_Data) == 32,
              "Bad sizeof(InitiatorCSPInfo_Data)");
// Used by InitiatorCSPInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct InitiatorCSPInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  InitiatorCSPInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~InitiatorCSPInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    InitiatorCSPInfo_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    InitiatorCSPInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) BeginNavigationParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(BeginNavigationParams_Data));
      new (data()) BeginNavigationParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    BeginNavigationParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<BeginNavigationParams_Data>(index_);
    }
    BeginNavigationParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t initiator_routing_id;
  int32_t load_flags;
  mojo::internal::Pointer<mojo::internal::String_Data> headers;
  uint8_t skip_service_worker : 1;
  uint8_t is_form_submission : 1;
  uint8_t was_initiated_by_link_click : 1;
  uint8_t force_ignore_site_for_cookies : 1;
  uint8_t pad6_[3];
  int32_t request_context_type;
  int32_t request_destination;
  int32_t mixed_content_context_type;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> searchable_form_url;
  mojo::internal::Pointer<mojo::internal::String_Data> searchable_form_encoding;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> client_side_redirect_url;
  mojo::internal::Pointer<::mojo_base::mojom::internal::DictionaryValue_Data> devtools_initiator;
  mojo::internal::Pointer<::network::mojom::internal::TrustTokenParams_Data> trust_token_params;
  mojo::internal::Pointer<internal::Impression_Data> impression;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> before_unload_start;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> before_unload_end;

 private:
  BeginNavigationParams_Data();
  ~BeginNavigationParams_Data() = delete;
};
static_assert(sizeof(BeginNavigationParams_Data) == 104,
              "Bad sizeof(BeginNavigationParams_Data)");
// Used by BeginNavigationParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct BeginNavigationParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  BeginNavigationParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~BeginNavigationParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    BeginNavigationParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    BeginNavigationParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) CommonNavigationParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CommonNavigationParams_Data));
      new (data()) CommonNavigationParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CommonNavigationParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CommonNavigationParams_Data>(index_);
    }
    CommonNavigationParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> initiator_origin;
  mojo::internal::Pointer<::blink::mojom::internal::Referrer_Data> referrer;
  int32_t transition;
  int32_t navigation_type;
  mojo::internal::Pointer<internal::NavigationDownloadPolicy_Data> download_policy;
  uint8_t should_replace_current_entry : 1;
  uint8_t started_from_context_menu : 1;
  uint8_t has_user_gesture : 1;
  uint8_t text_fragment_token : 1;
  uint8_t is_history_navigation_in_new_child_frame : 1;
  uint8_t pad10_[3];
  int32_t previews_state;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> base_url_for_data_url;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> history_url_for_data_url;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> navigation_start;
  mojo::internal::Pointer<mojo::internal::String_Data> method;
  mojo::internal::Pointer<::network::mojom::internal::URLRequestBody_Data> post_data;
  mojo::internal::Pointer<::network::mojom::internal::SourceLocation_Data> source_location;
  mojo::internal::Pointer<internal::InitiatorCSPInfo_Data> initiator_csp_info;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> initiator_origin_trial_features;
  mojo::internal::Pointer<mojo::internal::String_Data> href_translate;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> input_start;

 private:
  CommonNavigationParams_Data();
  ~CommonNavigationParams_Data() = delete;
};
static_assert(sizeof(CommonNavigationParams_Data) == 136,
              "Bad sizeof(CommonNavigationParams_Data)");
// Used by CommonNavigationParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CommonNavigationParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CommonNavigationParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CommonNavigationParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    CommonNavigationParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CommonNavigationParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) NavigationTiming_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigationTiming_Data));
      new (data()) NavigationTiming_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigationTiming_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigationTiming_Data>(index_);
    }
    NavigationTiming_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> redirect_start;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> redirect_end;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> fetch_start;

 private:
  NavigationTiming_Data();
  ~NavigationTiming_Data() = delete;
};
static_assert(sizeof(NavigationTiming_Data) == 32,
              "Bad sizeof(NavigationTiming_Data)");
// Used by NavigationTiming::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct NavigationTiming_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  NavigationTiming_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~NavigationTiming_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    NavigationTiming_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    NavigationTiming_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) OldPageInfo_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(OldPageInfo_Data));
      new (data()) OldPageInfo_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    OldPageInfo_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<OldPageInfo_Data>(index_);
    }
    OldPageInfo_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t routing_id_for_old_main_frame;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::blink::mojom::internal::PageLifecycleState_Data> new_lifecycle_state_for_old_page;

 private:
  OldPageInfo_Data();
  ~OldPageInfo_Data() = delete;
};
static_assert(sizeof(OldPageInfo_Data) == 24,
              "Bad sizeof(OldPageInfo_Data)");
// Used by OldPageInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct OldPageInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  OldPageInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~OldPageInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    OldPageInfo_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    OldPageInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) CommitNavigationParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CommitNavigationParams_Data));
      new (data()) CommitNavigationParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CommitNavigationParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CommitNavigationParams_Data>(index_);
    }
    CommitNavigationParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> origin_to_commit;
  uint8_t is_overriding_user_agent : 1;
  uint8_t can_load_local_resources : 1;
  uint8_t intended_as_new_entry : 1;
  uint8_t was_discarded : 1;
  uint8_t is_view_source : 1;
  uint8_t should_clear_history_list : 1;
  uint8_t is_browser_initiated : 1;
  uint8_t origin_isolated : 1;
  uint8_t is_cross_browsing_instance : 1;
  uint8_t pad9_[2];
  int32_t nav_entry_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::url::mojom::internal::Url_Data>>> redirects;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::URLResponseHead_Data>>> redirect_response;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::URLRequestRedirectInfo_Data>>> redirect_infos;
  mojo::internal::Pointer<mojo::internal::String_Data> post_content_type;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> original_url;
  mojo::internal::Pointer<mojo::internal::String_Data> original_method;
  mojo::internal::Pointer<internal::PageState_Data> page_state;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, bool>> subframe_unique_names;
  int32_t pending_history_list_offset;
  int32_t current_history_list_offset;
  int32_t current_history_list_length;
  int32_t was_activated;
  mojo::internal::Pointer<internal::NavigationTiming_Data> navigation_timing;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> appcache_host_id;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> navigation_token;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::content::mojom::internal::PrefetchedSignedExchangeInfo_Data>>> prefetched_signed_exchanges;
  int32_t ip_address_space;
  uint8_t pad27_[4];
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> web_bundle_physical_url;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> web_bundle_claimed_url;
  int64_t document_ukm_source_id;
  mojo::internal::Pointer<::blink::mojom::internal::FramePolicy_Data> frame_policy;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> force_enabled_origin_trials;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> enabled_client_hints;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> forced_content_security_policies;
  mojo::internal::Pointer<internal::OldPageInfo_Data> old_page_info;

 private:
  CommitNavigationParams_Data();
  ~CommitNavigationParams_Data() = delete;
};
static_assert(sizeof(CommitNavigationParams_Data) == 208,
              "Bad sizeof(CommitNavigationParams_Data)");
// Used by CommitNavigationParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CommitNavigationParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CommitNavigationParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CommitNavigationParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    CommitNavigationParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CommitNavigationParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace content

#endif  // CONTENT_COMMON_NAVIGATION_PARAMS_MOJOM_SHARED_INTERNAL_H_