// content/common/frame_sink_provider.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_FRAME_SINK_PROVIDER_MOJOM_PARAMS_DATA_H_
#define CONTENT_COMMON_FRAME_SINK_PROVIDER_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace content {
namespace mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) FrameSinkProvider_CreateForWidget_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkProvider_CreateForWidget_Params_Data));
      new (data()) FrameSinkProvider_CreateForWidget_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkProvider_CreateForWidget_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkProvider_CreateForWidget_Params_Data>(index_);
    }
    FrameSinkProvider_CreateForWidget_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t widget_id;
  mojo::internal::Handle_Data compositor_frame_sink_receiver;
  mojo::internal::Interface_Data compositor_frame_sink_client;

 private:
  FrameSinkProvider_CreateForWidget_Params_Data();
  ~FrameSinkProvider_CreateForWidget_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkProvider_CreateForWidget_Params_Data) == 24,
              "Bad sizeof(FrameSinkProvider_CreateForWidget_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) FrameSinkProvider_RegisterRenderFrameMetadataObserver_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(FrameSinkProvider_RegisterRenderFrameMetadataObserver_Params_Data));
      new (data()) FrameSinkProvider_RegisterRenderFrameMetadataObserver_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    FrameSinkProvider_RegisterRenderFrameMetadataObserver_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<FrameSinkProvider_RegisterRenderFrameMetadataObserver_Params_Data>(index_);
    }
    FrameSinkProvider_RegisterRenderFrameMetadataObserver_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t widget_id;
  mojo::internal::Handle_Data render_frame_metadata_observer_client_receiver;
  mojo::internal::Interface_Data render_frame_metadata_observer;

 private:
  FrameSinkProvider_RegisterRenderFrameMetadataObserver_Params_Data();
  ~FrameSinkProvider_RegisterRenderFrameMetadataObserver_Params_Data() = delete;
};
static_assert(sizeof(FrameSinkProvider_RegisterRenderFrameMetadataObserver_Params_Data) == 24,
              "Bad sizeof(FrameSinkProvider_RegisterRenderFrameMetadataObserver_Params_Data)");

}  // namespace internal


class FrameSinkProvider_CreateForWidget_ParamsDataView {
 public:
  FrameSinkProvider_CreateForWidget_ParamsDataView() {}

  FrameSinkProvider_CreateForWidget_ParamsDataView(
      internal::FrameSinkProvider_CreateForWidget_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t widget_id() const {
    return data_->widget_id;
  }
  template <typename UserType>
  UserType TakeCompositorFrameSinkReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::viz::mojom::CompositorFrameSinkInterfaceBase>>(
            &data_->compositor_frame_sink_receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeCompositorFrameSinkClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::viz::mojom::CompositorFrameSinkClientInterfaceBase>>(
            &data_->compositor_frame_sink_client, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::FrameSinkProvider_CreateForWidget_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FrameSinkProvider_RegisterRenderFrameMetadataObserver_ParamsDataView {
 public:
  FrameSinkProvider_RegisterRenderFrameMetadataObserver_ParamsDataView() {}

  FrameSinkProvider_RegisterRenderFrameMetadataObserver_ParamsDataView(
      internal::FrameSinkProvider_RegisterRenderFrameMetadataObserver_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t widget_id() const {
    return data_->widget_id;
  }
  template <typename UserType>
  UserType TakeRenderFrameMetadataObserverClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::cc::mojom::RenderFrameMetadataObserverClientInterfaceBase>>(
            &data_->render_frame_metadata_observer_client_receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeRenderFrameMetadataObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::cc::mojom::RenderFrameMetadataObserverInterfaceBase>>(
            &data_->render_frame_metadata_observer, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::FrameSinkProvider_RegisterRenderFrameMetadataObserver_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};





}  // namespace mojom
}  // namespace content

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CONTENT_COMMON_FRAME_SINK_PROVIDER_MOJOM_PARAMS_DATA_H_