// content/common/frame.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_FRAME_MOJOM_H_
#define CONTENT_COMMON_FRAME_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/common/frame.mojom-shared.h"
#include "content/common/frame.mojom-forward.h"
#include "content/common/document_scoped_interface_bundle.mojom.h"
#include "content/common/frame_messages.mojom.h"
#include "content/common/native_types.mojom.h"
#include "content/common/navigation_client.mojom.h"
#include "content/common/navigation_params.mojom.h"
#include "content/common/web_ui.mojom.h"
#include "content/public/common/browser_controls_state.mojom.h"
#include "content/public/common/window_container_type.mojom-forward.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "services/network/public/mojom/content_security_policy.mojom.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-forward.h"
#include "services/network/public/mojom/url_loader.mojom.h"
#include "services/network/public/mojom/url_loader_factory.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom.h"
#include "services/service_manager/public/mojom/interface_provider.mojom.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom.h"
#include "third_party/blink/public/mojom/commit_result/commit_result.mojom-forward.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-forward.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom.h"
#include "third_party/blink/public/mojom/feature_policy/document_policy_feature.mojom.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy.mojom.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy_feature.mojom-forward.h"
#include "third_party/blink/public/mojom/feature_policy/policy_value.mojom.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/navigation_initiator.mojom.h"
#include "third_party/blink/public/mojom/loader/resource_load_info.mojom.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-forward.h"
#include "third_party/blink/public/mojom/page/page.mojom.h"
#include "third_party/blink/public/mojom/page/widget.mojom.h"
#include "third_party/blink/public/mojom/portal/portal.mojom.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom.h"
#include "ui/base/mojom/window_open_disposition.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "cc/input/touch_action.h"
#include "content/common/cursors/webcursor.h"
#include "content/common/frame_replication_state.h"
#include "content/common/input/synthetic_pinch_gesture_params.h"
#include "content/common/input/synthetic_pointer_action_list_params.h"
#include "content/common/input/synthetic_smooth_drag_gesture_params.h"
#include "content/common/input/synthetic_smooth_scroll_gesture_params.h"
#include "content/common/input/synthetic_tap_gesture_params.h"
#include "net/base/network_change_notifier.h"
#include "third_party/blink/public/common/input/web_coalesced_input_event_mojom_traits.h"
#include "third_party/blink/public/common/input/web_input_event.h"
#include "third_party/blink/public/common/input/web_mouse_wheel_event.h"
#include "third_party/blink/public/common/input/web_pointer_properties.h"
#include "third_party/blink/public/common/input/web_touch_point.h"
#include "third_party/blink/public/common/navigation/triggering_event_info.h"
#include "third_party/blink/public/common/web_preferences/web_preferences.h"
#include "third_party/blink/public/common/widget/visual_properties.h"
#include "ui/events/blink/did_overscroll_params.h"
#include "ui/events/blink/web_input_event_traits.h"
#include "ui/latency/ipc/latency_info_param_traits.h"
#include "ui/native_theme/native_theme.h"
#include "content/common/content_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {

class FrameHTMLSerializerHandlerProxy;

template <typename ImplRefTraits>
class FrameHTMLSerializerHandlerStub;

class FrameHTMLSerializerHandlerRequestValidator;


class CONTENT_EXPORT FrameHTMLSerializerHandler
    : public FrameHTMLSerializerHandlerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = FrameHTMLSerializerHandlerInterfaceBase;
  using Proxy_ = FrameHTMLSerializerHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameHTMLSerializerHandlerStub<ImplRefTraits>;

  using RequestValidator_ = FrameHTMLSerializerHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDidReceiveDataMinVersion = 0,
    kDoneMinVersion = 0,
  };
  virtual ~FrameHTMLSerializerHandler() {}

  
  virtual void DidReceiveData(const std::string& data_buffer) = 0;

  
  virtual void Done() = 0;
};

class FrameProxy;

template <typename ImplRefTraits>
class FrameStub;

class FrameRequestValidator;
class FrameResponseValidator;


class CONTENT_EXPORT Frame
    : public FrameInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = FrameInterfaceBase;
  using Proxy_ = FrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameStub<ImplRefTraits>;

  using RequestValidator_ = FrameRequestValidator;
  using ResponseValidator_ = FrameResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetInterfaceProviderMinVersion = 0,
    kGetCanonicalUrlForSharingMinVersion = 0,
    kBlockRequestsMinVersion = 0,
    kResumeBlockedRequestsMinVersion = 0,
    kCancelBlockedRequestsMinVersion = 0,
    kUpdateBrowserControlsStateMinVersion = 0,
    kSnapshotAccessibilityTreeMinVersion = 0,
    kGetSerializedHtmlWithLocalLinksMinVersion = 0,
  };
  virtual ~Frame() {}

  
  virtual void GetInterfaceProvider(::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider> interfaces) = 0;


  using GetCanonicalUrlForSharingCallback = base::OnceCallback<void(const base::Optional<::GURL>&)>;
  
  virtual void GetCanonicalUrlForSharing(GetCanonicalUrlForSharingCallback callback) = 0;

  
  virtual void BlockRequests() = 0;

  
  virtual void ResumeBlockedRequests() = 0;

  
  virtual void CancelBlockedRequests() = 0;

  
  virtual void UpdateBrowserControlsState(::content::BrowserControlsState constraints, ::content::BrowserControlsState current, bool animate) = 0;


  using SnapshotAccessibilityTreeCallback = base::OnceCallback<void(const ::ui::AXTreeUpdate&)>;
  
  virtual void SnapshotAccessibilityTree(uint32_t ax_mode, SnapshotAccessibilityTreeCallback callback) = 0;

  
  virtual void GetSerializedHtmlWithLocalLinks(const base::flat_map<::GURL, ::base::FilePath>& url_map, const base::flat_map<::base::UnguessableToken, ::base::FilePath>& frame_token_map, bool save_with_empty_url, ::mojo::PendingRemote<FrameHTMLSerializerHandler> handler_remote) = 0;
};

class FrameNavigationControlProxy;

template <typename ImplRefTraits>
class FrameNavigationControlStub;

class FrameNavigationControlRequestValidator;
class FrameNavigationControlResponseValidator;


class CONTENT_EXPORT FrameNavigationControl
    : public FrameNavigationControlInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = FrameNavigationControlInterfaceBase;
  using Proxy_ = FrameNavigationControlProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameNavigationControlStub<ImplRefTraits>;

  using RequestValidator_ = FrameNavigationControlRequestValidator;
  using ResponseValidator_ = FrameNavigationControlResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCommitSameDocumentNavigationMinVersion = 0,
    kHandleRendererDebugURLMinVersion = 0,
    kUpdateSubresourceLoaderFactoriesMinVersion = 0,
    kBindDevToolsAgentMinVersion = 0,
    kJavaScriptMethodExecuteRequestMinVersion = 0,
    kJavaScriptExecuteRequestMinVersion = 0,
    kJavaScriptExecuteRequestForTestsMinVersion = 0,
    kJavaScriptExecuteRequestInIsolatedWorldMinVersion = 0,
    kSwapInMinVersion = 0,
  };
  virtual ~FrameNavigationControl() {}


  using CommitSameDocumentNavigationCallback = base::OnceCallback<void(::blink::mojom::CommitResult)>;
  
  virtual void CommitSameDocumentNavigation(::content::mojom::CommonNavigationParamsPtr common_params, ::content::mojom::CommitNavigationParamsPtr request_params, CommitSameDocumentNavigationCallback callback) = 0;

  
  virtual void HandleRendererDebugURL(const ::GURL& url) = 0;

  
  virtual void UpdateSubresourceLoaderFactories(::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories) = 0;

  
  virtual void BindDevToolsAgent(::mojo::PendingAssociatedRemote<::blink::mojom::DevToolsAgentHost> agent_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> agent) = 0;


  using JavaScriptMethodExecuteRequestCallback = base::OnceCallback<void(::base::Value)>;
  
  virtual void JavaScriptMethodExecuteRequest(const ::base::string16& object_name, const ::base::string16& method_name, ::base::Value arguments, bool wants_result, JavaScriptMethodExecuteRequestCallback callback) = 0;


  using JavaScriptExecuteRequestCallback = base::OnceCallback<void(::base::Value)>;
  
  virtual void JavaScriptExecuteRequest(const ::base::string16& javascript, bool wants_result, JavaScriptExecuteRequestCallback callback) = 0;


  using JavaScriptExecuteRequestForTestsCallback = base::OnceCallback<void(::base::Value)>;
  
  virtual void JavaScriptExecuteRequestForTests(const ::base::string16& javascript, bool wants_result, bool has_user_gesture, int32_t world_id, JavaScriptExecuteRequestForTestsCallback callback) = 0;


  using JavaScriptExecuteRequestInIsolatedWorldCallback = base::OnceCallback<void(::base::Value)>;
  
  virtual void JavaScriptExecuteRequestInIsolatedWorld(const ::base::string16& javascript, bool wants_result, int32_t world_id, JavaScriptExecuteRequestInIsolatedWorldCallback callback) = 0;

  
  virtual void SwapIn() = 0;
};

class FrameBindingsControlProxy;

template <typename ImplRefTraits>
class FrameBindingsControlStub;

class FrameBindingsControlRequestValidator;


class CONTENT_EXPORT FrameBindingsControl
    : public FrameBindingsControlInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = FrameBindingsControlInterfaceBase;
  using Proxy_ = FrameBindingsControlProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameBindingsControlStub<ImplRefTraits>;

  using RequestValidator_ = FrameBindingsControlRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAllowBindingsMinVersion = 0,
    kEnableMojoJsBindingsMinVersion = 0,
    kBindWebUIMinVersion = 0,
  };
  virtual ~FrameBindingsControl() {}

  
  virtual void AllowBindings(int32_t enabled_bindings_flags) = 0;

  
  virtual void EnableMojoJsBindings() = 0;

  
  virtual void BindWebUI(::mojo::PendingReceiver<::content::mojom::WebUI> receiver, ::mojo::PendingRemote<::content::mojom::WebUIHost> remote) = 0;
};

class FrameFactoryProxy;

template <typename ImplRefTraits>
class FrameFactoryStub;

class FrameFactoryRequestValidator;


class CONTENT_EXPORT FrameFactory
    : public FrameFactoryInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = FrameFactoryInterfaceBase;
  using Proxy_ = FrameFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameFactoryStub<ImplRefTraits>;

  using RequestValidator_ = FrameFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateFrameMinVersion = 0,
  };
  virtual ~FrameFactory() {}

  
  virtual void CreateFrame(int32_t frame_routing_id, ::mojo::PendingReceiver<Frame> frame) = 0;
};

class KeepAliveHandleProxy;

template <typename ImplRefTraits>
class KeepAliveHandleStub;

class KeepAliveHandleRequestValidator;


class CONTENT_EXPORT KeepAliveHandle
    : public KeepAliveHandleInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = KeepAliveHandleInterfaceBase;
  using Proxy_ = KeepAliveHandleProxy;

  template <typename ImplRefTraits>
  using Stub_ = KeepAliveHandleStub<ImplRefTraits>;

  using RequestValidator_ = KeepAliveHandleRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };
  virtual ~KeepAliveHandle() {}
};

class FrameHostProxy;

template <typename ImplRefTraits>
class FrameHostStub;

class FrameHostRequestValidator;
class FrameHostResponseValidator;


class CONTENT_EXPORT FrameHost
    : public FrameHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = FrameHostInterfaceBase;
  using Proxy_ = FrameHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameHostStub<ImplRefTraits>;

  using RequestValidator_ = FrameHostRequestValidator;
  using ResponseValidator_ = FrameHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateNewWindowMinVersion = 0,
    kCreatePortalMinVersion = 0,
    kAdoptPortalMinVersion = 0,
    kCreateNewWidgetMinVersion = 0,
    kCreateNewFullscreenWidgetMinVersion = 0,
    kIssueKeepAliveHandleMinVersion = 0,
    kDidCommitProvisionalLoadMinVersion = 0,
    kDidCommitSameDocumentNavigationMinVersion = 0,
    kBeginNavigationMinVersion = 0,
    kSubresourceResponseStartedMinVersion = 0,
    kResourceLoadCompleteMinVersion = 0,
    kDidChangeNameMinVersion = 0,
    kDidSetFramePolicyHeadersMinVersion = 0,
    kCancelInitialHistoryLoadMinVersion = 0,
    kUpdateEncodingMinVersion = 0,
    kFrameSizeChangedMinVersion = 0,
    kDidAddMessageToConsoleMinVersion = 0,
    kShowCreatedWindowMinVersion = 0,
    kUpdateStateMinVersion = 0,
    kOpenURLMinVersion = 0,
    kDidStopLoadingMinVersion = 0,
  };
  virtual ~FrameHost() {}

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CreateNewWindow(CreateNewWindowParamsPtr params, CreateNewWindowStatus* out_status, CreateNewWindowReplyPtr* out_reply);

  using CreateNewWindowCallback = base::OnceCallback<void(CreateNewWindowStatus, CreateNewWindowReplyPtr)>;
  
  virtual void CreateNewWindow(CreateNewWindowParamsPtr params, CreateNewWindowCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CreatePortal(::mojo::PendingAssociatedReceiver<::blink::mojom::Portal> portal, ::mojo::PendingAssociatedRemote<::blink::mojom::PortalClient> client, int32_t* out_proxy_routing_id, ::content::FrameReplicationState* out_initial_replicated_state, ::blink::PortalToken* out_portal_token, ::base::UnguessableToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token);

  using CreatePortalCallback = base::OnceCallback<void(int32_t, const ::content::FrameReplicationState&, const ::blink::PortalToken&, const ::base::UnguessableToken&, const ::base::UnguessableToken&)>;
  
  virtual void CreatePortal(::mojo::PendingAssociatedReceiver<::blink::mojom::Portal> portal, ::mojo::PendingAssociatedRemote<::blink::mojom::PortalClient> client, CreatePortalCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool AdoptPortal(const ::blink::PortalToken& portal_token, int32_t* out_proxy_routing_id, ::viz::FrameSinkId* out_frame_sink_id, ::content::FrameReplicationState* out_replicated_state, ::base::UnguessableToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token);

  using AdoptPortalCallback = base::OnceCallback<void(int32_t, const ::viz::FrameSinkId&, const ::content::FrameReplicationState&, const ::base::UnguessableToken&, const ::base::UnguessableToken&)>;
  
  virtual void AdoptPortal(const ::blink::PortalToken& portal_token, AdoptPortalCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CreateNewWidget(::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> blink_widget, int32_t* out_routing_id);

  using CreateNewWidgetCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void CreateNewWidget(::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> blink_widget, CreateNewWidgetCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CreateNewFullscreenWidget(::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> blink_widget, int32_t* out_routing_id);

  using CreateNewFullscreenWidgetCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void CreateNewFullscreenWidget(::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> blink_widget, CreateNewFullscreenWidgetCallback callback) = 0;

  
  virtual void IssueKeepAliveHandle(::mojo::PendingReceiver<KeepAliveHandle> keep_alive_handle) = 0;

  
  virtual void DidCommitProvisionalLoad(::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params> params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr interface_params) = 0;

  
  virtual void DidCommitSameDocumentNavigation(::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params> params) = 0;

  
  virtual void BeginNavigation(::content::mojom::CommonNavigationParamsPtr common_params, ::content::mojom::BeginNavigationParamsPtr begin_params, ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token, ::mojo::PendingAssociatedRemote<::content::mojom::NavigationClient> navigation_client, ::mojo::PendingRemote<::blink::mojom::NavigationInitiator> navigation_initiator) = 0;

  
  virtual void SubresourceResponseStarted(const ::GURL& url, uint32_t cert_status) = 0;

  
  virtual void ResourceLoadComplete(::blink::mojom::ResourceLoadInfoPtr url_load_info) = 0;

  
  virtual void DidChangeName(const std::string& name, const std::string& unique_name) = 0;

  
  virtual void DidSetFramePolicyHeaders(::network::mojom::WebSandboxFlags sandbox_flags, const std::vector<::blink::ParsedFeaturePolicyDeclaration>& feature_policy_header, const base::flat_map<::blink::mojom::DocumentPolicyFeature, ::blink::PolicyValue>& document_policy_header) = 0;

  
  virtual void CancelInitialHistoryLoad() = 0;

  
  virtual void UpdateEncoding(const std::string& encoding_name) = 0;

  
  virtual void FrameSizeChanged(const ::gfx::Size& size) = 0;

  
  virtual void DidAddMessageToConsole(::blink::mojom::ConsoleMessageLevel log_level, const ::base::string16& msg, int32_t line_number, const ::base::string16& source_id) = 0;

  
  virtual void ShowCreatedWindow(int32_t pending_widget_routing_id, ::WindowOpenDisposition disposition, const ::gfx::Rect& rect, bool opened_by_user_gesture) = 0;

  
  virtual void UpdateState(const ::content::PageState& state) = 0;

  
  virtual void OpenURL(OpenURLParamsPtr params) = 0;

  
  virtual void DidStopLoading() = 0;
};



class CONTENT_EXPORT FrameHTMLSerializerHandlerProxy
    : public FrameHTMLSerializerHandler {
 public:
  using InterfaceType = FrameHTMLSerializerHandler;

  explicit FrameHTMLSerializerHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidReceiveData(const std::string& data_buffer) final;
  
  void Done() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT FrameProxy
    : public Frame {
 public:
  using InterfaceType = Frame;

  explicit FrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetInterfaceProvider(::mojo::PendingReceiver<::service_manager::mojom::InterfaceProvider> interfaces) final;
  
  void GetCanonicalUrlForSharing(GetCanonicalUrlForSharingCallback callback) final;
  
  void BlockRequests() final;
  
  void ResumeBlockedRequests() final;
  
  void CancelBlockedRequests() final;
  
  void UpdateBrowserControlsState(::content::BrowserControlsState constraints, ::content::BrowserControlsState current, bool animate) final;
  
  void SnapshotAccessibilityTree(uint32_t ax_mode, SnapshotAccessibilityTreeCallback callback) final;
  
  void GetSerializedHtmlWithLocalLinks(const base::flat_map<::GURL, ::base::FilePath>& url_map, const base::flat_map<::base::UnguessableToken, ::base::FilePath>& frame_token_map, bool save_with_empty_url, ::mojo::PendingRemote<FrameHTMLSerializerHandler> handler_remote) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT FrameNavigationControlProxy
    : public FrameNavigationControl {
 public:
  using InterfaceType = FrameNavigationControl;

  explicit FrameNavigationControlProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CommitSameDocumentNavigation(::content::mojom::CommonNavigationParamsPtr common_params, ::content::mojom::CommitNavigationParamsPtr request_params, CommitSameDocumentNavigationCallback callback) final;
  
  void HandleRendererDebugURL(const ::GURL& url) final;
  
  void UpdateSubresourceLoaderFactories(::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories) final;
  
  void BindDevToolsAgent(::mojo::PendingAssociatedRemote<::blink::mojom::DevToolsAgentHost> agent_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> agent) final;
  
  void JavaScriptMethodExecuteRequest(const ::base::string16& object_name, const ::base::string16& method_name, ::base::Value arguments, bool wants_result, JavaScriptMethodExecuteRequestCallback callback) final;
  
  void JavaScriptExecuteRequest(const ::base::string16& javascript, bool wants_result, JavaScriptExecuteRequestCallback callback) final;
  
  void JavaScriptExecuteRequestForTests(const ::base::string16& javascript, bool wants_result, bool has_user_gesture, int32_t world_id, JavaScriptExecuteRequestForTestsCallback callback) final;
  
  void JavaScriptExecuteRequestInIsolatedWorld(const ::base::string16& javascript, bool wants_result, int32_t world_id, JavaScriptExecuteRequestInIsolatedWorldCallback callback) final;
  
  void SwapIn() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT FrameBindingsControlProxy
    : public FrameBindingsControl {
 public:
  using InterfaceType = FrameBindingsControl;

  explicit FrameBindingsControlProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AllowBindings(int32_t enabled_bindings_flags) final;
  
  void EnableMojoJsBindings() final;
  
  void BindWebUI(::mojo::PendingReceiver<::content::mojom::WebUI> receiver, ::mojo::PendingRemote<::content::mojom::WebUIHost> remote) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT FrameFactoryProxy
    : public FrameFactory {
 public:
  using InterfaceType = FrameFactory;

  explicit FrameFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateFrame(int32_t frame_routing_id, ::mojo::PendingReceiver<Frame> frame) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT KeepAliveHandleProxy
    : public KeepAliveHandle {
 public:
  using InterfaceType = KeepAliveHandle;

  explicit KeepAliveHandleProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT FrameHostProxy
    : public FrameHost {
 public:
  using InterfaceType = FrameHost;

  explicit FrameHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool CreateNewWindow(CreateNewWindowParamsPtr params, CreateNewWindowStatus* out_status, CreateNewWindowReplyPtr* out_reply) final;
  
  void CreateNewWindow(CreateNewWindowParamsPtr params, CreateNewWindowCallback callback) final;
  
  bool CreatePortal(::mojo::PendingAssociatedReceiver<::blink::mojom::Portal> portal, ::mojo::PendingAssociatedRemote<::blink::mojom::PortalClient> client, int32_t* out_proxy_routing_id, ::content::FrameReplicationState* out_initial_replicated_state, ::blink::PortalToken* out_portal_token, ::base::UnguessableToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token) final;
  
  void CreatePortal(::mojo::PendingAssociatedReceiver<::blink::mojom::Portal> portal, ::mojo::PendingAssociatedRemote<::blink::mojom::PortalClient> client, CreatePortalCallback callback) final;
  
  bool AdoptPortal(const ::blink::PortalToken& portal_token, int32_t* out_proxy_routing_id, ::viz::FrameSinkId* out_frame_sink_id, ::content::FrameReplicationState* out_replicated_state, ::base::UnguessableToken* out_frame_token, ::base::UnguessableToken* out_devtools_frame_token) final;
  
  void AdoptPortal(const ::blink::PortalToken& portal_token, AdoptPortalCallback callback) final;
  
  bool CreateNewWidget(::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> blink_widget, int32_t* out_routing_id) final;
  
  void CreateNewWidget(::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> blink_widget, CreateNewWidgetCallback callback) final;
  
  bool CreateNewFullscreenWidget(::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> blink_widget, int32_t* out_routing_id) final;
  
  void CreateNewFullscreenWidget(::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> blink_widget, CreateNewFullscreenWidgetCallback callback) final;
  
  void IssueKeepAliveHandle(::mojo::PendingReceiver<KeepAliveHandle> keep_alive_handle) final;
  
  void DidCommitProvisionalLoad(::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params> params, ::content::mojom::DidCommitProvisionalLoadInterfaceParamsPtr interface_params) final;
  
  void DidCommitSameDocumentNavigation(::std::unique_ptr<::FrameHostMsg_DidCommitProvisionalLoad_Params> params) final;
  
  void BeginNavigation(::content::mojom::CommonNavigationParamsPtr common_params, ::content::mojom::BeginNavigationParamsPtr begin_params, ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token, ::mojo::PendingAssociatedRemote<::content::mojom::NavigationClient> navigation_client, ::mojo::PendingRemote<::blink::mojom::NavigationInitiator> navigation_initiator) final;
  
  void SubresourceResponseStarted(const ::GURL& url, uint32_t cert_status) final;
  
  void ResourceLoadComplete(::blink::mojom::ResourceLoadInfoPtr url_load_info) final;
  
  void DidChangeName(const std::string& name, const std::string& unique_name) final;
  
  void DidSetFramePolicyHeaders(::network::mojom::WebSandboxFlags sandbox_flags, const std::vector<::blink::ParsedFeaturePolicyDeclaration>& feature_policy_header, const base::flat_map<::blink::mojom::DocumentPolicyFeature, ::blink::PolicyValue>& document_policy_header) final;
  
  void CancelInitialHistoryLoad() final;
  
  void UpdateEncoding(const std::string& encoding_name) final;
  
  void FrameSizeChanged(const ::gfx::Size& size) final;
  
  void DidAddMessageToConsole(::blink::mojom::ConsoleMessageLevel log_level, const ::base::string16& msg, int32_t line_number, const ::base::string16& source_id) final;
  
  void ShowCreatedWindow(int32_t pending_widget_routing_id, ::WindowOpenDisposition disposition, const ::gfx::Rect& rect, bool opened_by_user_gesture) final;
  
  void UpdateState(const ::content::PageState& state) final;
  
  void OpenURL(OpenURLParamsPtr params) final;
  
  void DidStopLoading() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT FrameHTMLSerializerHandlerStubDispatch {
 public:
  static bool Accept(FrameHTMLSerializerHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameHTMLSerializerHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameHTMLSerializerHandler>>
class FrameHTMLSerializerHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameHTMLSerializerHandlerStub() {}
  ~FrameHTMLSerializerHandlerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameHTMLSerializerHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameHTMLSerializerHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT FrameStubDispatch {
 public:
  static bool Accept(Frame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Frame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Frame>>
class FrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameStub() {}
  ~FrameStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT FrameNavigationControlStubDispatch {
 public:
  static bool Accept(FrameNavigationControl* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameNavigationControl* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameNavigationControl>>
class FrameNavigationControlStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameNavigationControlStub() {}
  ~FrameNavigationControlStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameNavigationControlStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameNavigationControlStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT FrameBindingsControlStubDispatch {
 public:
  static bool Accept(FrameBindingsControl* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameBindingsControl* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameBindingsControl>>
class FrameBindingsControlStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameBindingsControlStub() {}
  ~FrameBindingsControlStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameBindingsControlStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameBindingsControlStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT FrameFactoryStubDispatch {
 public:
  static bool Accept(FrameFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameFactory>>
class FrameFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameFactoryStub() {}
  ~FrameFactoryStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT KeepAliveHandleStubDispatch {
 public:
  static bool Accept(KeepAliveHandle* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      KeepAliveHandle* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<KeepAliveHandle>>
class KeepAliveHandleStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  KeepAliveHandleStub() {}
  ~KeepAliveHandleStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return KeepAliveHandleStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return KeepAliveHandleStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT FrameHostStubDispatch {
 public:
  static bool Accept(FrameHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameHost>>
class FrameHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameHostStub() {}
  ~FrameHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT FrameHTMLSerializerHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT FrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT FrameNavigationControlRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT FrameBindingsControlRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT FrameFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT KeepAliveHandleRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT FrameHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT FrameResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT FrameNavigationControlResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT FrameHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class CONTENT_EXPORT CreateNewWindowParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateNewWindowParams, T>::value>;
  using DataView = CreateNewWindowParamsDataView;
  using Data_ = internal::CreateNewWindowParams_Data;

  template <typename... Args>
  static CreateNewWindowParamsPtr New(Args&&... args) {
    return CreateNewWindowParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateNewWindowParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateNewWindowParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateNewWindowParams>::Convert(*this);
  }


  CreateNewWindowParams();

  CreateNewWindowParams(
      bool allow_popup,
      ::content::mojom::WindowContainerType window_container_type,
      const std::string& session_storage_namespace_id,
      const std::string& clone_from_session_storage_namespace_id,
      const std::string& frame_name,
      bool opener_suppressed,
      ::WindowOpenDisposition disposition,
      const ::GURL& target_url,
      ::blink::mojom::ReferrerPtr referrer,
      ::blink::mojom::WindowFeaturesPtr features);

  ~CreateNewWindowParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateNewWindowParamsPtr>
  CreateNewWindowParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateNewWindowParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateNewWindowParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateNewWindowParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateNewWindowParams_UnserializedMessageContext<
            UserType, CreateNewWindowParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CreateNewWindowParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CreateNewWindowParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateNewWindowParams_UnserializedMessageContext<
            UserType, CreateNewWindowParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateNewWindowParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool allow_popup;
  
  ::content::mojom::WindowContainerType window_container_type;
  
  std::string session_storage_namespace_id;
  
  std::string clone_from_session_storage_namespace_id;
  
  std::string frame_name;
  
  bool opener_suppressed;
  
  ::WindowOpenDisposition disposition;
  
  ::GURL target_url;
  
  ::blink::mojom::ReferrerPtr referrer;
  
  ::blink::mojom::WindowFeaturesPtr features;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CreateNewWindowParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateNewWindowParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateNewWindowParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateNewWindowParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateNewWindowParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT CreateNewWindowReply {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateNewWindowReply, T>::value>;
  using DataView = CreateNewWindowReplyDataView;
  using Data_ = internal::CreateNewWindowReply_Data;

  template <typename... Args>
  static CreateNewWindowReplyPtr New(Args&&... args) {
    return CreateNewWindowReplyPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateNewWindowReplyPtr From(const U& u) {
    return mojo::TypeConverter<CreateNewWindowReplyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateNewWindowReply>::Convert(*this);
  }


  CreateNewWindowReply();

  CreateNewWindowReply(
      int32_t route_id,
      int32_t main_frame_route_id,
      const ::base::UnguessableToken& main_frame_frame_token,
      int32_t main_frame_widget_route_id,
      const ::blink::VisualProperties& visual_properties,
      ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidgetHost> frame_widget_host,
      ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidget> frame_widget,
      ::mojo::PendingAssociatedRemote<::blink::mojom::WidgetHost> widget_host,
      ::mojo::PendingAssociatedReceiver<::blink::mojom::Widget> widget,
      ::mojo::PendingAssociatedReceiver<::blink::mojom::PageBroadcast> page_broadcast,
      ::content::mojom::DocumentScopedInterfaceBundlePtr main_frame_interface_bundle,
      const std::string& cloned_session_storage_namespace_id,
      const ::base::UnguessableToken& devtools_main_frame_token,
      bool wait_for_debugger);

  ~CreateNewWindowReply();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateNewWindowReplyPtr>
  CreateNewWindowReplyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateNewWindowReply::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateNewWindowReply::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateNewWindowReply::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateNewWindowReply_UnserializedMessageContext<
            UserType, CreateNewWindowReply::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CreateNewWindowReply::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CreateNewWindowReply::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateNewWindowReply_UnserializedMessageContext<
            UserType, CreateNewWindowReply::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateNewWindowReply::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t route_id;
  
  int32_t main_frame_route_id;
  
  ::base::UnguessableToken main_frame_frame_token;
  
  int32_t main_frame_widget_route_id;
  
  ::blink::VisualProperties visual_properties;
  
  ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidgetHost> frame_widget_host;
  
  ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidget> frame_widget;
  
  ::mojo::PendingAssociatedRemote<::blink::mojom::WidgetHost> widget_host;
  
  ::mojo::PendingAssociatedReceiver<::blink::mojom::Widget> widget;
  
  ::mojo::PendingAssociatedReceiver<::blink::mojom::PageBroadcast> page_broadcast;
  
  ::content::mojom::DocumentScopedInterfaceBundlePtr main_frame_interface_bundle;
  
  std::string cloned_session_storage_namespace_id;
  
  ::base::UnguessableToken devtools_main_frame_token;
  
  bool wait_for_debugger;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CreateNewWindowReply);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateNewWindowReply::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateNewWindowReply::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateNewWindowReply::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateNewWindowReply::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT OpenURLParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OpenURLParams, T>::value>;
  using DataView = OpenURLParamsDataView;
  using Data_ = internal::OpenURLParams_Data;

  template <typename... Args>
  static OpenURLParamsPtr New(Args&&... args) {
    return OpenURLParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OpenURLParamsPtr From(const U& u) {
    return mojo::TypeConverter<OpenURLParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OpenURLParams>::Convert(*this);
  }


  OpenURLParams();

  OpenURLParams(
      const ::GURL& url,
      const ::url::Origin& initiator_origin,
      int32_t initiator_routing_id,
      ::scoped_refptr<::network::ResourceRequestBody> post_body,
      const std::string& extra_headers,
      ::blink::mojom::ReferrerPtr referrer,
      ::WindowOpenDisposition disposition,
      bool should_replace_current_entry,
      bool user_gesture,
      ::blink::TriggeringEventInfo triggering_event_info,
      ::mojo::ScopedMessagePipeHandle blob_url_token,
      const std::string& href_translate,
      const base::Optional<::content::Impression>& impression,
      const ::content::NavigationDownloadPolicy& download_policy);

  ~OpenURLParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OpenURLParamsPtr>
  OpenURLParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OpenURLParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OpenURLParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OpenURLParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OpenURLParams_UnserializedMessageContext<
            UserType, OpenURLParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<OpenURLParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return OpenURLParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OpenURLParams_UnserializedMessageContext<
            UserType, OpenURLParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OpenURLParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::GURL url;
  
  ::url::Origin initiator_origin;
  
  int32_t initiator_routing_id;
  
  ::scoped_refptr<::network::ResourceRequestBody> post_body;
  
  std::string extra_headers;
  
  ::blink::mojom::ReferrerPtr referrer;
  
  ::WindowOpenDisposition disposition;
  
  bool should_replace_current_entry;
  
  bool user_gesture;
  
  ::blink::TriggeringEventInfo triggering_event_info;
  
  ::mojo::ScopedMessagePipeHandle blob_url_token;
  
  std::string href_translate;
  
  base::Optional<::content::Impression> impression;
  
  ::content::NavigationDownloadPolicy download_policy;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(OpenURLParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OpenURLParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OpenURLParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OpenURLParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OpenURLParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CreateNewWindowParamsPtr CreateNewWindowParams::Clone() const {
  return New(
      mojo::Clone(allow_popup),
      mojo::Clone(window_container_type),
      mojo::Clone(session_storage_namespace_id),
      mojo::Clone(clone_from_session_storage_namespace_id),
      mojo::Clone(frame_name),
      mojo::Clone(opener_suppressed),
      mojo::Clone(disposition),
      mojo::Clone(target_url),
      mojo::Clone(referrer),
      mojo::Clone(features)
  );
}

template <typename T, CreateNewWindowParams::EnableIfSame<T>*>
bool CreateNewWindowParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allow_popup, other_struct.allow_popup))
    return false;
  if (!mojo::Equals(this->window_container_type, other_struct.window_container_type))
    return false;
  if (!mojo::Equals(this->session_storage_namespace_id, other_struct.session_storage_namespace_id))
    return false;
  if (!mojo::Equals(this->clone_from_session_storage_namespace_id, other_struct.clone_from_session_storage_namespace_id))
    return false;
  if (!mojo::Equals(this->frame_name, other_struct.frame_name))
    return false;
  if (!mojo::Equals(this->opener_suppressed, other_struct.opener_suppressed))
    return false;
  if (!mojo::Equals(this->disposition, other_struct.disposition))
    return false;
  if (!mojo::Equals(this->target_url, other_struct.target_url))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->features, other_struct.features))
    return false;
  return true;
}

template <typename T, CreateNewWindowParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.allow_popup, rhs.allow_popup))
    return true;
  if (std::less<>{}(rhs.allow_popup, lhs.allow_popup))
    return false;
  if (std::less<>{}(lhs.window_container_type, rhs.window_container_type))
    return true;
  if (std::less<>{}(rhs.window_container_type, lhs.window_container_type))
    return false;
  if (std::less<>{}(lhs.session_storage_namespace_id, rhs.session_storage_namespace_id))
    return true;
  if (std::less<>{}(rhs.session_storage_namespace_id, lhs.session_storage_namespace_id))
    return false;
  if (std::less<>{}(lhs.clone_from_session_storage_namespace_id, rhs.clone_from_session_storage_namespace_id))
    return true;
  if (std::less<>{}(rhs.clone_from_session_storage_namespace_id, lhs.clone_from_session_storage_namespace_id))
    return false;
  if (std::less<>{}(lhs.frame_name, rhs.frame_name))
    return true;
  if (std::less<>{}(rhs.frame_name, lhs.frame_name))
    return false;
  if (std::less<>{}(lhs.opener_suppressed, rhs.opener_suppressed))
    return true;
  if (std::less<>{}(rhs.opener_suppressed, lhs.opener_suppressed))
    return false;
  if (std::less<>{}(lhs.disposition, rhs.disposition))
    return true;
  if (std::less<>{}(rhs.disposition, lhs.disposition))
    return false;
  if (std::less<>{}(lhs.target_url, rhs.target_url))
    return true;
  if (std::less<>{}(rhs.target_url, lhs.target_url))
    return false;
  if (std::less<>{}(lhs.referrer, rhs.referrer))
    return true;
  if (std::less<>{}(rhs.referrer, lhs.referrer))
    return false;
  if (std::less<>{}(lhs.features, rhs.features))
    return true;
  if (std::less<>{}(rhs.features, lhs.features))
    return false;
  return false;
}
template <typename StructPtrType>
CreateNewWindowReplyPtr CreateNewWindowReply::Clone() const {
  return New(
      mojo::Clone(route_id),
      mojo::Clone(main_frame_route_id),
      mojo::Clone(main_frame_frame_token),
      mojo::Clone(main_frame_widget_route_id),
      mojo::Clone(visual_properties),
      mojo::Clone(frame_widget_host),
      mojo::Clone(frame_widget),
      mojo::Clone(widget_host),
      mojo::Clone(widget),
      mojo::Clone(page_broadcast),
      mojo::Clone(main_frame_interface_bundle),
      mojo::Clone(cloned_session_storage_namespace_id),
      mojo::Clone(devtools_main_frame_token),
      mojo::Clone(wait_for_debugger)
  );
}

template <typename T, CreateNewWindowReply::EnableIfSame<T>*>
bool CreateNewWindowReply::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->route_id, other_struct.route_id))
    return false;
  if (!mojo::Equals(this->main_frame_route_id, other_struct.main_frame_route_id))
    return false;
  if (!mojo::Equals(this->main_frame_frame_token, other_struct.main_frame_frame_token))
    return false;
  if (!mojo::Equals(this->main_frame_widget_route_id, other_struct.main_frame_widget_route_id))
    return false;
  if (!mojo::Equals(this->visual_properties, other_struct.visual_properties))
    return false;
  if (!mojo::Equals(this->frame_widget_host, other_struct.frame_widget_host))
    return false;
  if (!mojo::Equals(this->frame_widget, other_struct.frame_widget))
    return false;
  if (!mojo::Equals(this->widget_host, other_struct.widget_host))
    return false;
  if (!mojo::Equals(this->widget, other_struct.widget))
    return false;
  if (!mojo::Equals(this->page_broadcast, other_struct.page_broadcast))
    return false;
  if (!mojo::Equals(this->main_frame_interface_bundle, other_struct.main_frame_interface_bundle))
    return false;
  if (!mojo::Equals(this->cloned_session_storage_namespace_id, other_struct.cloned_session_storage_namespace_id))
    return false;
  if (!mojo::Equals(this->devtools_main_frame_token, other_struct.devtools_main_frame_token))
    return false;
  if (!mojo::Equals(this->wait_for_debugger, other_struct.wait_for_debugger))
    return false;
  return true;
}

template <typename T, CreateNewWindowReply::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.route_id, rhs.route_id))
    return true;
  if (std::less<>{}(rhs.route_id, lhs.route_id))
    return false;
  if (std::less<>{}(lhs.main_frame_route_id, rhs.main_frame_route_id))
    return true;
  if (std::less<>{}(rhs.main_frame_route_id, lhs.main_frame_route_id))
    return false;
  if (std::less<>{}(lhs.main_frame_frame_token, rhs.main_frame_frame_token))
    return true;
  if (std::less<>{}(rhs.main_frame_frame_token, lhs.main_frame_frame_token))
    return false;
  if (std::less<>{}(lhs.main_frame_widget_route_id, rhs.main_frame_widget_route_id))
    return true;
  if (std::less<>{}(rhs.main_frame_widget_route_id, lhs.main_frame_widget_route_id))
    return false;
  if (std::less<>{}(lhs.visual_properties, rhs.visual_properties))
    return true;
  if (std::less<>{}(rhs.visual_properties, lhs.visual_properties))
    return false;
  if (std::less<>{}(lhs.frame_widget_host, rhs.frame_widget_host))
    return true;
  if (std::less<>{}(rhs.frame_widget_host, lhs.frame_widget_host))
    return false;
  if (std::less<>{}(lhs.frame_widget, rhs.frame_widget))
    return true;
  if (std::less<>{}(rhs.frame_widget, lhs.frame_widget))
    return false;
  if (std::less<>{}(lhs.widget_host, rhs.widget_host))
    return true;
  if (std::less<>{}(rhs.widget_host, lhs.widget_host))
    return false;
  if (std::less<>{}(lhs.widget, rhs.widget))
    return true;
  if (std::less<>{}(rhs.widget, lhs.widget))
    return false;
  if (std::less<>{}(lhs.page_broadcast, rhs.page_broadcast))
    return true;
  if (std::less<>{}(rhs.page_broadcast, lhs.page_broadcast))
    return false;
  if (std::less<>{}(lhs.main_frame_interface_bundle, rhs.main_frame_interface_bundle))
    return true;
  if (std::less<>{}(rhs.main_frame_interface_bundle, lhs.main_frame_interface_bundle))
    return false;
  if (std::less<>{}(lhs.cloned_session_storage_namespace_id, rhs.cloned_session_storage_namespace_id))
    return true;
  if (std::less<>{}(rhs.cloned_session_storage_namespace_id, lhs.cloned_session_storage_namespace_id))
    return false;
  if (std::less<>{}(lhs.devtools_main_frame_token, rhs.devtools_main_frame_token))
    return true;
  if (std::less<>{}(rhs.devtools_main_frame_token, lhs.devtools_main_frame_token))
    return false;
  if (std::less<>{}(lhs.wait_for_debugger, rhs.wait_for_debugger))
    return true;
  if (std::less<>{}(rhs.wait_for_debugger, lhs.wait_for_debugger))
    return false;
  return false;
}
template <typename StructPtrType>
OpenURLParamsPtr OpenURLParams::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(initiator_origin),
      mojo::Clone(initiator_routing_id),
      mojo::Clone(post_body),
      mojo::Clone(extra_headers),
      mojo::Clone(referrer),
      mojo::Clone(disposition),
      mojo::Clone(should_replace_current_entry),
      mojo::Clone(user_gesture),
      mojo::Clone(triggering_event_info),
      mojo::Clone(blob_url_token),
      mojo::Clone(href_translate),
      mojo::Clone(impression),
      mojo::Clone(download_policy)
  );
}

template <typename T, OpenURLParams::EnableIfSame<T>*>
bool OpenURLParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->initiator_origin, other_struct.initiator_origin))
    return false;
  if (!mojo::Equals(this->initiator_routing_id, other_struct.initiator_routing_id))
    return false;
  if (!mojo::Equals(this->post_body, other_struct.post_body))
    return false;
  if (!mojo::Equals(this->extra_headers, other_struct.extra_headers))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->disposition, other_struct.disposition))
    return false;
  if (!mojo::Equals(this->should_replace_current_entry, other_struct.should_replace_current_entry))
    return false;
  if (!mojo::Equals(this->user_gesture, other_struct.user_gesture))
    return false;
  if (!mojo::Equals(this->triggering_event_info, other_struct.triggering_event_info))
    return false;
  if (!mojo::Equals(this->blob_url_token, other_struct.blob_url_token))
    return false;
  if (!mojo::Equals(this->href_translate, other_struct.href_translate))
    return false;
  if (!mojo::Equals(this->impression, other_struct.impression))
    return false;
  if (!mojo::Equals(this->download_policy, other_struct.download_policy))
    return false;
  return true;
}

template <typename T, OpenURLParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  if (std::less<>{}(lhs.initiator_origin, rhs.initiator_origin))
    return true;
  if (std::less<>{}(rhs.initiator_origin, lhs.initiator_origin))
    return false;
  if (std::less<>{}(lhs.initiator_routing_id, rhs.initiator_routing_id))
    return true;
  if (std::less<>{}(rhs.initiator_routing_id, lhs.initiator_routing_id))
    return false;
  if (std::less<>{}(lhs.post_body, rhs.post_body))
    return true;
  if (std::less<>{}(rhs.post_body, lhs.post_body))
    return false;
  if (std::less<>{}(lhs.extra_headers, rhs.extra_headers))
    return true;
  if (std::less<>{}(rhs.extra_headers, lhs.extra_headers))
    return false;
  if (std::less<>{}(lhs.referrer, rhs.referrer))
    return true;
  if (std::less<>{}(rhs.referrer, lhs.referrer))
    return false;
  if (std::less<>{}(lhs.disposition, rhs.disposition))
    return true;
  if (std::less<>{}(rhs.disposition, lhs.disposition))
    return false;
  if (std::less<>{}(lhs.should_replace_current_entry, rhs.should_replace_current_entry))
    return true;
  if (std::less<>{}(rhs.should_replace_current_entry, lhs.should_replace_current_entry))
    return false;
  if (std::less<>{}(lhs.user_gesture, rhs.user_gesture))
    return true;
  if (std::less<>{}(rhs.user_gesture, lhs.user_gesture))
    return false;
  if (std::less<>{}(lhs.triggering_event_info, rhs.triggering_event_info))
    return true;
  if (std::less<>{}(rhs.triggering_event_info, lhs.triggering_event_info))
    return false;
  if (std::less<>{}(lhs.blob_url_token, rhs.blob_url_token))
    return true;
  if (std::less<>{}(rhs.blob_url_token, lhs.blob_url_token))
    return false;
  if (std::less<>{}(lhs.href_translate, rhs.href_translate))
    return true;
  if (std::less<>{}(rhs.href_translate, lhs.href_translate))
    return false;
  if (std::less<>{}(lhs.impression, rhs.impression))
    return true;
  if (std::less<>{}(rhs.impression, lhs.impression))
    return false;
  if (std::less<>{}(lhs.download_policy, rhs.download_policy))
    return true;
  if (std::less<>{}(rhs.download_policy, lhs.download_policy))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace content

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::CreateNewWindowParams::DataView,
                                         ::content::mojom::CreateNewWindowParamsPtr> {
  static bool IsNull(const ::content::mojom::CreateNewWindowParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CreateNewWindowParamsPtr* output) { output->reset(); }

  static decltype(::content::mojom::CreateNewWindowParams::allow_popup) allow_popup(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->allow_popup;
  }

  static decltype(::content::mojom::CreateNewWindowParams::window_container_type) window_container_type(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->window_container_type;
  }

  static const decltype(::content::mojom::CreateNewWindowParams::session_storage_namespace_id)& session_storage_namespace_id(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->session_storage_namespace_id;
  }

  static const decltype(::content::mojom::CreateNewWindowParams::clone_from_session_storage_namespace_id)& clone_from_session_storage_namespace_id(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->clone_from_session_storage_namespace_id;
  }

  static const decltype(::content::mojom::CreateNewWindowParams::frame_name)& frame_name(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->frame_name;
  }

  static decltype(::content::mojom::CreateNewWindowParams::opener_suppressed) opener_suppressed(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->opener_suppressed;
  }

  static decltype(::content::mojom::CreateNewWindowParams::disposition) disposition(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->disposition;
  }

  static const decltype(::content::mojom::CreateNewWindowParams::target_url)& target_url(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->target_url;
  }

  static const decltype(::content::mojom::CreateNewWindowParams::referrer)& referrer(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->referrer;
  }

  static const decltype(::content::mojom::CreateNewWindowParams::features)& features(
      const ::content::mojom::CreateNewWindowParamsPtr& input) {
    return input->features;
  }

  static bool Read(::content::mojom::CreateNewWindowParams::DataView input, ::content::mojom::CreateNewWindowParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::CreateNewWindowReply::DataView,
                                         ::content::mojom::CreateNewWindowReplyPtr> {
  static bool IsNull(const ::content::mojom::CreateNewWindowReplyPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CreateNewWindowReplyPtr* output) { output->reset(); }

  static decltype(::content::mojom::CreateNewWindowReply::route_id) route_id(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->route_id;
  }

  static decltype(::content::mojom::CreateNewWindowReply::main_frame_route_id) main_frame_route_id(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->main_frame_route_id;
  }

  static const decltype(::content::mojom::CreateNewWindowReply::main_frame_frame_token)& main_frame_frame_token(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->main_frame_frame_token;
  }

  static decltype(::content::mojom::CreateNewWindowReply::main_frame_widget_route_id) main_frame_widget_route_id(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->main_frame_widget_route_id;
  }

  static const decltype(::content::mojom::CreateNewWindowReply::visual_properties)& visual_properties(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->visual_properties;
  }

  static  decltype(::content::mojom::CreateNewWindowReply::frame_widget_host)& frame_widget_host(
       ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->frame_widget_host;
  }

  static  decltype(::content::mojom::CreateNewWindowReply::frame_widget)& frame_widget(
       ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->frame_widget;
  }

  static  decltype(::content::mojom::CreateNewWindowReply::widget_host)& widget_host(
       ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->widget_host;
  }

  static  decltype(::content::mojom::CreateNewWindowReply::widget)& widget(
       ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->widget;
  }

  static  decltype(::content::mojom::CreateNewWindowReply::page_broadcast)& page_broadcast(
       ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->page_broadcast;
  }

  static  decltype(::content::mojom::CreateNewWindowReply::main_frame_interface_bundle)& main_frame_interface_bundle(
       ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->main_frame_interface_bundle;
  }

  static const decltype(::content::mojom::CreateNewWindowReply::cloned_session_storage_namespace_id)& cloned_session_storage_namespace_id(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->cloned_session_storage_namespace_id;
  }

  static const decltype(::content::mojom::CreateNewWindowReply::devtools_main_frame_token)& devtools_main_frame_token(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->devtools_main_frame_token;
  }

  static decltype(::content::mojom::CreateNewWindowReply::wait_for_debugger) wait_for_debugger(
      const ::content::mojom::CreateNewWindowReplyPtr& input) {
    return input->wait_for_debugger;
  }

  static bool Read(::content::mojom::CreateNewWindowReply::DataView input, ::content::mojom::CreateNewWindowReplyPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::OpenURLParams::DataView,
                                         ::content::mojom::OpenURLParamsPtr> {
  static bool IsNull(const ::content::mojom::OpenURLParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::OpenURLParamsPtr* output) { output->reset(); }

  static const decltype(::content::mojom::OpenURLParams::url)& url(
      const ::content::mojom::OpenURLParamsPtr& input) {
    return input->url;
  }

  static const decltype(::content::mojom::OpenURLParams::initiator_origin)& initiator_origin(
      const ::content::mojom::OpenURLParamsPtr& input) {
    return input->initiator_origin;
  }

  static decltype(::content::mojom::OpenURLParams::initiator_routing_id) initiator_routing_id(
      const ::content::mojom::OpenURLParamsPtr& input) {
    return input->initiator_routing_id;
  }

  static  decltype(::content::mojom::OpenURLParams::post_body)& post_body(
       ::content::mojom::OpenURLParamsPtr& input) {
    return input->post_body;
  }

  static const decltype(::content::mojom::OpenURLParams::extra_headers)& extra_headers(
      const ::content::mojom::OpenURLParamsPtr& input) {
    return input->extra_headers;
  }

  static const decltype(::content::mojom::OpenURLParams::referrer)& referrer(
      const ::content::mojom::OpenURLParamsPtr& input) {
    return input->referrer;
  }

  static decltype(::content::mojom::OpenURLParams::disposition) disposition(
      const ::content::mojom::OpenURLParamsPtr& input) {
    return input->disposition;
  }

  static decltype(::content::mojom::OpenURLParams::should_replace_current_entry) should_replace_current_entry(
      const ::content::mojom::OpenURLParamsPtr& input) {
    return input->should_replace_current_entry;
  }

  static decltype(::content::mojom::OpenURLParams::user_gesture) user_gesture(
      const ::content::mojom::OpenURLParamsPtr& input) {
    return input->user_gesture;
  }

  static decltype(::content::mojom::OpenURLParams::triggering_event_info) triggering_event_info(
      const ::content::mojom::OpenURLParamsPtr& input) {
    return input->triggering_event_info;
  }

  static  decltype(::content::mojom::OpenURLParams::blob_url_token)& blob_url_token(
       ::content::mojom::OpenURLParamsPtr& input) {
    return input->blob_url_token;
  }

  static const decltype(::content::mojom::OpenURLParams::href_translate)& href_translate(
      const ::content::mojom::OpenURLParamsPtr& input) {
    return input->href_translate;
  }

  static const decltype(::content::mojom::OpenURLParams::impression)& impression(
      const ::content::mojom::OpenURLParamsPtr& input) {
    return input->impression;
  }

  static const decltype(::content::mojom::OpenURLParams::download_policy)& download_policy(
      const ::content::mojom::OpenURLParamsPtr& input) {
    return input->download_policy;
  }

  static bool Read(::content::mojom::OpenURLParams::DataView input, ::content::mojom::OpenURLParamsPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_FRAME_MOJOM_H_