// content/common/download/mhtml_file_writer.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_SHARED_INTERNAL_H_
#define CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/file.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace content {
namespace mojom {
namespace internal {
class SerializeAsMHTMLParams_Data;
class MhtmlOutputHandle_Data;

struct MhtmlSaveStatus_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) MhtmlOutputHandle_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  MhtmlOutputHandle_Data() {}
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~MhtmlOutputHandle_Data() {}

  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MhtmlOutputHandle_Data));
      new (data()) MhtmlOutputHandle_Data();
    }

    void AllocateInline(mojo::internal::Buffer* serialization_buffer,
                        void* ptr) {
      const char* start = static_cast<const char*>(
          serialization_buffer->data());
      const char* slot = static_cast<const char*>(ptr);
      DCHECK_GT(slot, start);
      serialization_buffer_ = serialization_buffer;
      index_ = slot - start;
      new (data()) MhtmlOutputHandle_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MhtmlOutputHandle_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MhtmlOutputHandle_Data>(index_);
    }
    MhtmlOutputHandle_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<MhtmlOutputHandle_Tag>(0);
    data.unknown = 0U;
  }

  enum class MhtmlOutputHandle_Tag : uint32_t {

    
    FILE_HANDLE,
    
    PRODUCER_HANDLE,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<::mojo_base::mojom::internal::File_Data> f_file_handle;
    mojo::internal::Handle_Data f_producer_handle;
    uint64_t unknown;
  };

  uint32_t size;
  MhtmlOutputHandle_Tag tag;
  Union_ data;
};
static_assert(sizeof(MhtmlOutputHandle_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(MhtmlOutputHandle_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) SerializeAsMHTMLParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(SerializeAsMHTMLParams_Data));
      new (data()) SerializeAsMHTMLParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    SerializeAsMHTMLParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<SerializeAsMHTMLParams_Data>(index_);
    }
    SerializeAsMHTMLParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> mhtml_boundary_marker;
  uint8_t mhtml_binary_encoding : 1;
  uint8_t mhtml_popup_overlay_removal : 1;
  uint8_t mhtml_problem_detection : 1;
  uint8_t pad3_[7];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> digests_of_uris_to_skip;
  mojo::internal::Pointer<mojo::internal::String_Data> salt;
  internal::MhtmlOutputHandle_Data output_handle;

 private:
  SerializeAsMHTMLParams_Data();
  ~SerializeAsMHTMLParams_Data() = delete;
};
static_assert(sizeof(SerializeAsMHTMLParams_Data) == 56,
              "Bad sizeof(SerializeAsMHTMLParams_Data)");
// Used by SerializeAsMHTMLParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SerializeAsMHTMLParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SerializeAsMHTMLParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SerializeAsMHTMLParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    SerializeAsMHTMLParams_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SerializeAsMHTMLParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace content

#endif  // CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_SHARED_INTERNAL_H_