// This file is generated by TypeBuilder_h.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Emulation_h
#define content_protocol_Emulation_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "content/browser/devtools/protocol/dom.h"
#include "content/browser/devtools/protocol/page.h"
#include "content/browser/devtools/protocol/runtime.h"

namespace content {
namespace protocol {
namespace Emulation {
class ScreenOrientation;
class DisplayFeature;
class UserAgentBrandVersion;
class UserAgentMetadata;

// ------------- Forward and enum declarations.

namespace SetEmitTouchEventsForMouse {
namespace ConfigurationEnum {
CONTENT_EXPORT extern const char* Mobile;
CONTENT_EXPORT extern const char* Desktop;
} // ConfigurationEnum
} // SetEmitTouchEventsForMouse

namespace SetEmulatedVisionDeficiency {
namespace TypeEnum {
CONTENT_EXPORT extern const char* None;
CONTENT_EXPORT extern const char* Achromatopsia;
CONTENT_EXPORT extern const char* BlurredVision;
CONTENT_EXPORT extern const char* Deuteranopia;
CONTENT_EXPORT extern const char* Protanopia;
CONTENT_EXPORT extern const char* Tritanopia;
} // TypeEnum
} // SetEmulatedVisionDeficiency

// ------------- Type and builder declarations.

class CONTENT_EXPORT ScreenOrientation : public ::crdtp::ProtocolObject<ScreenOrientation> {
public:
    ~ScreenOrientation() override { }

    struct CONTENT_EXPORT TypeEnum {
        static const char* PortraitPrimary;
        static const char* PortraitSecondary;
        static const char* LandscapePrimary;
        static const char* LandscapeSecondary;
    }; // TypeEnum

    String GetType() { return m_type; }
    void SetType(const String& value) { m_type = value; }

    int GetAngle() { return m_angle; }
    void SetAngle(int value) { m_angle = value; }

    template<int STATE>
    class ScreenOrientationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AngleSet = 1 << 2,
            AllFieldsSet = (TypeSet | AngleSet | 0)};


        ScreenOrientationBuilder<STATE | TypeSet>& SetType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->SetType(value);
            return castState<TypeSet>();
        }

        ScreenOrientationBuilder<STATE | AngleSet>& SetAngle(int value)
        {
            static_assert(!(STATE & AngleSet), "property angle should not be set yet");
            m_result->SetAngle(value);
            return castState<AngleSet>();
        }

        std::unique_ptr<ScreenOrientation> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScreenOrientation;
        ScreenOrientationBuilder() : m_result(new ScreenOrientation()) { }

        template<int STEP> ScreenOrientationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScreenOrientationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::ScreenOrientation> m_result;
    };

    static ScreenOrientationBuilder<0> Create()
    {
        return ScreenOrientationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScreenOrientation()
    {
          m_angle = 0;
    }

    String m_type;
    int m_angle;
};


class CONTENT_EXPORT DisplayFeature : public ::crdtp::ProtocolObject<DisplayFeature> {
public:
    ~DisplayFeature() override { }

    struct CONTENT_EXPORT OrientationEnum {
        static const char* Vertical;
        static const char* Horizontal;
    }; // OrientationEnum

    String GetOrientation() { return m_orientation; }
    void SetOrientation(const String& value) { m_orientation = value; }

    int GetOffset() { return m_offset; }
    void SetOffset(int value) { m_offset = value; }

    int GetMaskLength() { return m_maskLength; }
    void SetMaskLength(int value) { m_maskLength = value; }

    template<int STATE>
    class DisplayFeatureBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            OrientationSet = 1 << 1,
            OffsetSet = 1 << 2,
            MaskLengthSet = 1 << 3,
            AllFieldsSet = (OrientationSet | OffsetSet | MaskLengthSet | 0)};


        DisplayFeatureBuilder<STATE | OrientationSet>& SetOrientation(const String& value)
        {
            static_assert(!(STATE & OrientationSet), "property orientation should not be set yet");
            m_result->SetOrientation(value);
            return castState<OrientationSet>();
        }

        DisplayFeatureBuilder<STATE | OffsetSet>& SetOffset(int value)
        {
            static_assert(!(STATE & OffsetSet), "property offset should not be set yet");
            m_result->SetOffset(value);
            return castState<OffsetSet>();
        }

        DisplayFeatureBuilder<STATE | MaskLengthSet>& SetMaskLength(int value)
        {
            static_assert(!(STATE & MaskLengthSet), "property maskLength should not be set yet");
            m_result->SetMaskLength(value);
            return castState<MaskLengthSet>();
        }

        std::unique_ptr<DisplayFeature> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class DisplayFeature;
        DisplayFeatureBuilder() : m_result(new DisplayFeature()) { }

        template<int STEP> DisplayFeatureBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DisplayFeatureBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::DisplayFeature> m_result;
    };

    static DisplayFeatureBuilder<0> Create()
    {
        return DisplayFeatureBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    DisplayFeature()
    {
          m_offset = 0;
          m_maskLength = 0;
    }

    String m_orientation;
    int m_offset;
    int m_maskLength;
};


class CONTENT_EXPORT UserAgentBrandVersion : public ::crdtp::ProtocolObject<UserAgentBrandVersion> {
public:
    ~UserAgentBrandVersion() override { }

    String GetBrand() { return m_brand; }
    void SetBrand(const String& value) { m_brand = value; }

    String GetVersion() { return m_version; }
    void SetVersion(const String& value) { m_version = value; }

    template<int STATE>
    class UserAgentBrandVersionBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            BrandSet = 1 << 1,
            VersionSet = 1 << 2,
            AllFieldsSet = (BrandSet | VersionSet | 0)};


        UserAgentBrandVersionBuilder<STATE | BrandSet>& SetBrand(const String& value)
        {
            static_assert(!(STATE & BrandSet), "property brand should not be set yet");
            m_result->SetBrand(value);
            return castState<BrandSet>();
        }

        UserAgentBrandVersionBuilder<STATE | VersionSet>& SetVersion(const String& value)
        {
            static_assert(!(STATE & VersionSet), "property version should not be set yet");
            m_result->SetVersion(value);
            return castState<VersionSet>();
        }

        std::unique_ptr<UserAgentBrandVersion> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class UserAgentBrandVersion;
        UserAgentBrandVersionBuilder() : m_result(new UserAgentBrandVersion()) { }

        template<int STEP> UserAgentBrandVersionBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<UserAgentBrandVersionBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::UserAgentBrandVersion> m_result;
    };

    static UserAgentBrandVersionBuilder<0> Create()
    {
        return UserAgentBrandVersionBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    UserAgentBrandVersion()
    {
    }

    String m_brand;
    String m_version;
};


class CONTENT_EXPORT UserAgentMetadata : public ::crdtp::ProtocolObject<UserAgentMetadata> {
public:
    ~UserAgentMetadata() override { }

    protocol::Array<protocol::Emulation::UserAgentBrandVersion>* GetBrands() { return m_brands.get(); }
    void SetBrands(std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> value) { m_brands = std::move(value); }

    String GetFullVersion() { return m_fullVersion; }
    void SetFullVersion(const String& value) { m_fullVersion = value; }

    String GetPlatform() { return m_platform; }
    void SetPlatform(const String& value) { m_platform = value; }

    String GetPlatformVersion() { return m_platformVersion; }
    void SetPlatformVersion(const String& value) { m_platformVersion = value; }

    String GetArchitecture() { return m_architecture; }
    void SetArchitecture(const String& value) { m_architecture = value; }

    String GetModel() { return m_model; }
    void SetModel(const String& value) { m_model = value; }

    bool GetMobile() { return m_mobile; }
    void SetMobile(bool value) { m_mobile = value; }

    template<int STATE>
    class UserAgentMetadataBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            BrandsSet = 1 << 1,
            FullVersionSet = 1 << 2,
            PlatformSet = 1 << 3,
            PlatformVersionSet = 1 << 4,
            ArchitectureSet = 1 << 5,
            ModelSet = 1 << 6,
            MobileSet = 1 << 7,
            AllFieldsSet = (BrandsSet | FullVersionSet | PlatformSet | PlatformVersionSet | ArchitectureSet | ModelSet | MobileSet | 0)};


        UserAgentMetadataBuilder<STATE | BrandsSet>& SetBrands(std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> value)
        {
            static_assert(!(STATE & BrandsSet), "property brands should not be set yet");
            m_result->SetBrands(std::move(value));
            return castState<BrandsSet>();
        }

        UserAgentMetadataBuilder<STATE | FullVersionSet>& SetFullVersion(const String& value)
        {
            static_assert(!(STATE & FullVersionSet), "property fullVersion should not be set yet");
            m_result->SetFullVersion(value);
            return castState<FullVersionSet>();
        }

        UserAgentMetadataBuilder<STATE | PlatformSet>& SetPlatform(const String& value)
        {
            static_assert(!(STATE & PlatformSet), "property platform should not be set yet");
            m_result->SetPlatform(value);
            return castState<PlatformSet>();
        }

        UserAgentMetadataBuilder<STATE | PlatformVersionSet>& SetPlatformVersion(const String& value)
        {
            static_assert(!(STATE & PlatformVersionSet), "property platformVersion should not be set yet");
            m_result->SetPlatformVersion(value);
            return castState<PlatformVersionSet>();
        }

        UserAgentMetadataBuilder<STATE | ArchitectureSet>& SetArchitecture(const String& value)
        {
            static_assert(!(STATE & ArchitectureSet), "property architecture should not be set yet");
            m_result->SetArchitecture(value);
            return castState<ArchitectureSet>();
        }

        UserAgentMetadataBuilder<STATE | ModelSet>& SetModel(const String& value)
        {
            static_assert(!(STATE & ModelSet), "property model should not be set yet");
            m_result->SetModel(value);
            return castState<ModelSet>();
        }

        UserAgentMetadataBuilder<STATE | MobileSet>& SetMobile(bool value)
        {
            static_assert(!(STATE & MobileSet), "property mobile should not be set yet");
            m_result->SetMobile(value);
            return castState<MobileSet>();
        }

        std::unique_ptr<UserAgentMetadata> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class UserAgentMetadata;
        UserAgentMetadataBuilder() : m_result(new UserAgentMetadata()) { }

        template<int STEP> UserAgentMetadataBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<UserAgentMetadataBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Emulation::UserAgentMetadata> m_result;
    };

    static UserAgentMetadataBuilder<0> Create()
    {
        return UserAgentMetadataBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    UserAgentMetadata()
    {
          m_mobile = false;
    }

    std::unique_ptr<protocol::Array<protocol::Emulation::UserAgentBrandVersion>> m_brands;
    String m_fullVersion;
    String m_platform;
    String m_platformVersion;
    String m_architecture;
    String m_model;
    bool m_mobile;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse CanEmulate(bool* out_result) = 0;
    virtual DispatchResponse ClearDeviceMetricsOverride() = 0;
    virtual DispatchResponse ClearGeolocationOverride() = 0;
    virtual DispatchResponse SetFocusEmulationEnabled(bool in_enabled) = 0;
    virtual DispatchResponse SetDeviceMetricsOverride(int in_width, int in_height, double in_deviceScaleFactor, bool in_mobile, Maybe<double> in_scale, Maybe<int> in_screenWidth, Maybe<int> in_screenHeight, Maybe<int> in_positionX, Maybe<int> in_positionY, Maybe<bool> in_dontSetVisibleSize, Maybe<protocol::Emulation::ScreenOrientation> in_screenOrientation, Maybe<protocol::Page::Viewport> in_viewport, Maybe<protocol::Emulation::DisplayFeature> in_displayFeature) = 0;
    virtual DispatchResponse SetEmitTouchEventsForMouse(bool in_enabled, Maybe<String> in_configuration) = 0;
    virtual DispatchResponse SetGeolocationOverride(Maybe<double> in_latitude, Maybe<double> in_longitude, Maybe<double> in_accuracy) = 0;
    virtual DispatchResponse SetIdleOverride(bool in_isUserActive, bool in_isScreenUnlocked) = 0;
    virtual DispatchResponse ClearIdleOverride() = 0;
    virtual DispatchResponse SetVisibleSize(int in_width, int in_height) = 0;
    virtual DispatchResponse SetUserAgentOverride(const String& in_userAgent, Maybe<String> in_acceptLanguage, Maybe<String> in_platform, Maybe<protocol::Emulation::UserAgentMetadata> in_userAgentMetadata) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void VirtualTimeBudgetExpired();

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Emulation
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Emulation_h)
