// components/services/storage/public/mojom/session_storage_control.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "components/services/storage/public/mojom/session_storage_control.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-shared.h"
#include "third_party/blink/public/mojom/dom_storage/session_storage_namespace.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace storage {
namespace mojom {
class SessionStorageUsageInfoDataView;



}  // namespace mojom
}  // namespace storage

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::SessionStorageUsageInfoDataView> {
  using Data = ::storage::mojom::internal::SessionStorageUsageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage {
namespace mojom {


enum class SessionStorageCloneType : int32_t {
  
  kImmediate = 0,
  
  kWaitForCloneOnNamespace = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SessionStorageCloneType value);
inline bool IsKnownEnumValue(SessionStorageCloneType value) {
  return internal::SessionStorageCloneType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SessionStorageControlInterfaceBase {};

using SessionStorageControlPtrDataView =
    mojo::InterfacePtrDataView<SessionStorageControlInterfaceBase>;
using SessionStorageControlRequestDataView =
    mojo::InterfaceRequestDataView<SessionStorageControlInterfaceBase>;
using SessionStorageControlAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SessionStorageControlInterfaceBase>;
using SessionStorageControlAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SessionStorageControlInterfaceBase>;


class SessionStorageUsageInfoDataView {
 public:
  SessionStorageUsageInfoDataView() {}

  SessionStorageUsageInfoDataView(
      internal::SessionStorageUsageInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  inline void GetNamespaceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNamespaceId(UserType* output) {
    
    auto* pointer = data_->namespace_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::SessionStorageUsageInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace storage

namespace std {

template <>
struct hash<::storage::mojom::SessionStorageCloneType>
    : public mojo::internal::EnumHashImpl<::storage::mojom::SessionStorageCloneType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::storage::mojom::SessionStorageCloneType, ::storage::mojom::SessionStorageCloneType> {
  static ::storage::mojom::SessionStorageCloneType ToMojom(::storage::mojom::SessionStorageCloneType input) { return input; }
  static bool FromMojom(::storage::mojom::SessionStorageCloneType input, ::storage::mojom::SessionStorageCloneType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::SessionStorageCloneType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::SessionStorageCloneType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::storage::mojom::SessionStorageCloneType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::SessionStorageUsageInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::SessionStorageUsageInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::storage::mojom::internal::SessionStorageUsageInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    typename decltype((*output)->origin)::BaseType::BufferWriter
        origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_origin, buffer, &origin_writer, context);
    (*output)->origin.Set(
        origin_writer.is_null() ? nullptr : origin_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in SessionStorageUsageInfo struct");
    decltype(Traits::namespace_id(input)) in_namespace_id = Traits::namespace_id(input);
    typename decltype((*output)->namespace_id)::BaseType::BufferWriter
        namespace_id_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_namespace_id, buffer, &namespace_id_writer, context);
    (*output)->namespace_id.Set(
        namespace_id_writer.is_null() ? nullptr : namespace_id_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->namespace_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null namespace_id in SessionStorageUsageInfo struct");
  }

  static bool Deserialize(::storage::mojom::internal::SessionStorageUsageInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::SessionStorageUsageInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage {
namespace mojom {

inline void SessionStorageUsageInfoDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}
inline void SessionStorageUsageInfoDataView::GetNamespaceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->namespace_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace storage

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_SHARED_H_