// components/services/storage/public/mojom/indexed_db_control.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "components/services/storage/public/mojom/indexed_db_control.mojom-shared-internal.h"
#include "components/services/storage/public/mojom/indexed_db_control_test.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace storage {
namespace mojom {
class IndexedDBStorageUsageInfoDataView;

class IndexedDBStoragePolicyUpdateDataView;



}  // namespace mojom
}  // namespace storage

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::IndexedDBStorageUsageInfoDataView> {
  using Data = ::storage::mojom::internal::IndexedDBStorageUsageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::storage::mojom::IndexedDBStoragePolicyUpdateDataView> {
  using Data = ::storage::mojom::internal::IndexedDBStoragePolicyUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage {
namespace mojom {


enum class ForceCloseReason : int32_t {
  
  FORCE_CLOSE_DELETE_ORIGIN = 0,
  
  FORCE_CLOSE_BACKING_STORE_FAILURE = 1,
  
  FORCE_CLOSE_INTERNALS_PAGE = 2,
  
  FORCE_CLOSE_COPY_ORIGIN = 3,
  
  FORCE_SCHEMA_DOWNGRADE_INTERNALS_PAGE = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, ForceCloseReason value);
inline bool IsKnownEnumValue(ForceCloseReason value) {
  return internal::ForceCloseReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class IndexedDBObserverInterfaceBase {};

using IndexedDBObserverPtrDataView =
    mojo::InterfacePtrDataView<IndexedDBObserverInterfaceBase>;
using IndexedDBObserverRequestDataView =
    mojo::InterfaceRequestDataView<IndexedDBObserverInterfaceBase>;
using IndexedDBObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<IndexedDBObserverInterfaceBase>;
using IndexedDBObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<IndexedDBObserverInterfaceBase>;
class IndexedDBControlInterfaceBase {};

using IndexedDBControlPtrDataView =
    mojo::InterfacePtrDataView<IndexedDBControlInterfaceBase>;
using IndexedDBControlRequestDataView =
    mojo::InterfaceRequestDataView<IndexedDBControlInterfaceBase>;
using IndexedDBControlAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<IndexedDBControlInterfaceBase>;
using IndexedDBControlAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<IndexedDBControlInterfaceBase>;


class IndexedDBStorageUsageInfoDataView {
 public:
  IndexedDBStorageUsageInfoDataView() {}

  IndexedDBStorageUsageInfoDataView(
      internal::IndexedDBStorageUsageInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  uint64_t size_in_bytes() const {
    return data_->size_in_bytes;
  }
  inline void GetLastModifiedTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLastModifiedTime(UserType* output) {
    
    auto* pointer = data_->last_modified_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
 private:
  internal::IndexedDBStorageUsageInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class IndexedDBStoragePolicyUpdateDataView {
 public:
  IndexedDBStoragePolicyUpdateDataView() {}

  IndexedDBStoragePolicyUpdateDataView(
      internal::IndexedDBStoragePolicyUpdate_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  bool purge_on_shutdown() const {
    return data_->purge_on_shutdown;
  }
 private:
  internal::IndexedDBStoragePolicyUpdate_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace storage

namespace std {

template <>
struct hash<::storage::mojom::ForceCloseReason>
    : public mojo::internal::EnumHashImpl<::storage::mojom::ForceCloseReason> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::storage::mojom::ForceCloseReason, ::storage::mojom::ForceCloseReason> {
  static ::storage::mojom::ForceCloseReason ToMojom(::storage::mojom::ForceCloseReason input) { return input; }
  static bool FromMojom(::storage::mojom::ForceCloseReason input, ::storage::mojom::ForceCloseReason* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::ForceCloseReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::ForceCloseReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::storage::mojom::ForceCloseReason>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::IndexedDBStorageUsageInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::IndexedDBStorageUsageInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::storage::mojom::internal::IndexedDBStorageUsageInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    typename decltype((*output)->origin)::BaseType::BufferWriter
        origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_origin, buffer, &origin_writer, context);
    (*output)->origin.Set(
        origin_writer.is_null() ? nullptr : origin_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in IndexedDBStorageUsageInfo struct");
    (*output)->size_in_bytes = Traits::size_in_bytes(input);
    decltype(Traits::last_modified_time(input)) in_last_modified_time = Traits::last_modified_time(input);
    typename decltype((*output)->last_modified_time)::BaseType::BufferWriter
        last_modified_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_last_modified_time, buffer, &last_modified_time_writer, context);
    (*output)->last_modified_time.Set(
        last_modified_time_writer.is_null() ? nullptr : last_modified_time_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->last_modified_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_modified_time in IndexedDBStorageUsageInfo struct");
  }

  static bool Deserialize(::storage::mojom::internal::IndexedDBStorageUsageInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::IndexedDBStorageUsageInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::IndexedDBStoragePolicyUpdateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::IndexedDBStoragePolicyUpdateDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::storage::mojom::internal::IndexedDBStoragePolicyUpdate_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    typename decltype((*output)->origin)::BaseType::BufferWriter
        origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_origin, buffer, &origin_writer, context);
    (*output)->origin.Set(
        origin_writer.is_null() ? nullptr : origin_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in IndexedDBStoragePolicyUpdate struct");
    (*output)->purge_on_shutdown = Traits::purge_on_shutdown(input);
  }

  static bool Deserialize(::storage::mojom::internal::IndexedDBStoragePolicyUpdate_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::IndexedDBStoragePolicyUpdateDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage {
namespace mojom {

inline void IndexedDBStorageUsageInfoDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}
inline void IndexedDBStorageUsageInfoDataView::GetLastModifiedTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_modified_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}


inline void IndexedDBStoragePolicyUpdateDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace storage

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_MOJOM_SHARED_H_