// components/services/storage/public/mojom/filesystem/directory.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "components/services/storage/public/mojom/filesystem/directory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_string.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_error.mojom-shared.h"
#include "mojo/public/mojom/base/file_info.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace storage {
namespace mojom {
class StrictRelativePathDataView;

class PathAccessInfoDataView;



}  // namespace mojom
}  // namespace storage

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::StrictRelativePathDataView> {
  using Data = ::storage::mojom::internal::StrictRelativePath_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::storage::mojom::PathAccessInfoDataView> {
  using Data = ::storage::mojom::internal::PathAccessInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage {
namespace mojom {


enum class GetEntriesMode : int32_t {
  
  kFilesOnly = 0,
  
  kFilesAndDirectories = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, GetEntriesMode value);
inline bool IsKnownEnumValue(GetEntriesMode value) {
  return internal::GetEntriesMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FileOpenMode : int32_t {
  
  kOpenIfExists = 0,
  
  kCreateAndOpenOnlyIfNotExists = 1,
  
  kAlwaysOpen = 2,
  
  kAlwaysCreate = 3,
  
  kOpenIfExistsAndTruncate = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, FileOpenMode value);
inline bool IsKnownEnumValue(FileOpenMode value) {
  return internal::FileOpenMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FileReadAccess : int32_t {
  
  kReadNotAllowed = 0,
  
  kReadAllowed = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, FileReadAccess value);
inline bool IsKnownEnumValue(FileReadAccess value) {
  return internal::FileReadAccess_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FileWriteAccess : int32_t {
  
  kWriteNotAllowed = 0,
  
  kWriteAllowed = 1,
  
  kAppendOnly = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, FileWriteAccess value);
inline bool IsKnownEnumValue(FileWriteAccess value) {
  return internal::FileWriteAccess_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FileLockInterfaceBase {};

using FileLockPtrDataView =
    mojo::InterfacePtrDataView<FileLockInterfaceBase>;
using FileLockRequestDataView =
    mojo::InterfaceRequestDataView<FileLockInterfaceBase>;
using FileLockAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FileLockInterfaceBase>;
using FileLockAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FileLockInterfaceBase>;
class DirectoryInterfaceBase {};

using DirectoryPtrDataView =
    mojo::InterfacePtrDataView<DirectoryInterfaceBase>;
using DirectoryRequestDataView =
    mojo::InterfaceRequestDataView<DirectoryInterfaceBase>;
using DirectoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DirectoryInterfaceBase>;
using DirectoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DirectoryInterfaceBase>;


class StrictRelativePathDataView {
 public:
  StrictRelativePathDataView() {}

  StrictRelativePathDataView(
      internal::StrictRelativePath_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, context_);
  }
 private:
  internal::StrictRelativePath_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PathAccessInfoDataView {
 public:
  PathAccessInfoDataView() {}

  PathAccessInfoDataView(
      internal::PathAccessInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool can_read() const {
    return data_->can_read;
  }
  bool can_write() const {
    return data_->can_write;
  }
 private:
  internal::PathAccessInfo_Data* data_ = nullptr;
};



}  // namespace mojom
}  // namespace storage

namespace std {

template <>
struct hash<::storage::mojom::GetEntriesMode>
    : public mojo::internal::EnumHashImpl<::storage::mojom::GetEntriesMode> {};

template <>
struct hash<::storage::mojom::FileOpenMode>
    : public mojo::internal::EnumHashImpl<::storage::mojom::FileOpenMode> {};

template <>
struct hash<::storage::mojom::FileReadAccess>
    : public mojo::internal::EnumHashImpl<::storage::mojom::FileReadAccess> {};

template <>
struct hash<::storage::mojom::FileWriteAccess>
    : public mojo::internal::EnumHashImpl<::storage::mojom::FileWriteAccess> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::storage::mojom::GetEntriesMode, ::storage::mojom::GetEntriesMode> {
  static ::storage::mojom::GetEntriesMode ToMojom(::storage::mojom::GetEntriesMode input) { return input; }
  static bool FromMojom(::storage::mojom::GetEntriesMode input, ::storage::mojom::GetEntriesMode* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::GetEntriesMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::GetEntriesMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::storage::mojom::GetEntriesMode>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::storage::mojom::FileOpenMode, ::storage::mojom::FileOpenMode> {
  static ::storage::mojom::FileOpenMode ToMojom(::storage::mojom::FileOpenMode input) { return input; }
  static bool FromMojom(::storage::mojom::FileOpenMode input, ::storage::mojom::FileOpenMode* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::FileOpenMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::FileOpenMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::storage::mojom::FileOpenMode>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::storage::mojom::FileReadAccess, ::storage::mojom::FileReadAccess> {
  static ::storage::mojom::FileReadAccess ToMojom(::storage::mojom::FileReadAccess input) { return input; }
  static bool FromMojom(::storage::mojom::FileReadAccess input, ::storage::mojom::FileReadAccess* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::FileReadAccess, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::FileReadAccess, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::storage::mojom::FileReadAccess>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::storage::mojom::FileWriteAccess, ::storage::mojom::FileWriteAccess> {
  static ::storage::mojom::FileWriteAccess ToMojom(::storage::mojom::FileWriteAccess input) { return input; }
  static bool FromMojom(::storage::mojom::FileWriteAccess input, ::storage::mojom::FileWriteAccess* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::FileWriteAccess, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::FileWriteAccess, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::storage::mojom::FileWriteAccess>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::StrictRelativePathDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::StrictRelativePathDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::storage::mojom::internal::StrictRelativePath_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::path(input)) in_path = Traits::path(input);
    typename decltype((*output)->path)::BaseType::BufferWriter
        path_writer;
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_path, buffer, &path_writer, context);
    (*output)->path.Set(
        path_writer.is_null() ? nullptr : path_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->path.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in StrictRelativePath struct");
  }

  static bool Deserialize(::storage::mojom::internal::StrictRelativePath_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::StrictRelativePathDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::PathAccessInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::PathAccessInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::storage::mojom::internal::PathAccessInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->can_read = Traits::can_read(input);
    (*output)->can_write = Traits::can_write(input);
  }

  static bool Deserialize(::storage::mojom::internal::PathAccessInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::PathAccessInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage {
namespace mojom {

inline void StrictRelativePathDataView::GetPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, context_);
}





}  // namespace mojom
}  // namespace storage

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_SHARED_H_