// components/printing/common/print.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace printing {
namespace mojom {
namespace internal {
class  PrintRenderer_CreatePreviewDocument_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintRenderer_CreatePreviewDocument_Params_Data));
      new (data()) PrintRenderer_CreatePreviewDocument_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintRenderer_CreatePreviewDocument_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintRenderer_CreatePreviewDocument_Params_Data>(index_);
    }
    PrintRenderer_CreatePreviewDocument_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::DictionaryValue_Data> job_settings;

 private:
  PrintRenderer_CreatePreviewDocument_Params_Data();
  ~PrintRenderer_CreatePreviewDocument_Params_Data() = delete;
};
static_assert(sizeof(PrintRenderer_CreatePreviewDocument_Params_Data) == 16,
              "Bad sizeof(PrintRenderer_CreatePreviewDocument_Params_Data)");
class  PrintRenderer_CreatePreviewDocument_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintRenderer_CreatePreviewDocument_ResponseParams_Data));
      new (data()) PrintRenderer_CreatePreviewDocument_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintRenderer_CreatePreviewDocument_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintRenderer_CreatePreviewDocument_ResponseParams_Data>(index_);
    }
    PrintRenderer_CreatePreviewDocument_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> preview_document_region;

 private:
  PrintRenderer_CreatePreviewDocument_ResponseParams_Data();
  ~PrintRenderer_CreatePreviewDocument_ResponseParams_Data() = delete;
};
static_assert(sizeof(PrintRenderer_CreatePreviewDocument_ResponseParams_Data) == 16,
              "Bad sizeof(PrintRenderer_CreatePreviewDocument_ResponseParams_Data)");
class  PrintPreviewUI_SetOptionsFromDocument_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintPreviewUI_SetOptionsFromDocument_Params_Data));
      new (data()) PrintPreviewUI_SetOptionsFromDocument_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintPreviewUI_SetOptionsFromDocument_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintPreviewUI_SetOptionsFromDocument_Params_Data>(index_);
    }
    PrintPreviewUI_SetOptionsFromDocument_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::OptionsFromDocumentParams_Data> params;
  int32_t request_id;
  uint8_t padfinal_[4];

 private:
  PrintPreviewUI_SetOptionsFromDocument_Params_Data();
  ~PrintPreviewUI_SetOptionsFromDocument_Params_Data() = delete;
};
static_assert(sizeof(PrintPreviewUI_SetOptionsFromDocument_Params_Data) == 24,
              "Bad sizeof(PrintPreviewUI_SetOptionsFromDocument_Params_Data)");
class  PrintPreviewUI_PrintPreviewFailed_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintPreviewUI_PrintPreviewFailed_Params_Data));
      new (data()) PrintPreviewUI_PrintPreviewFailed_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintPreviewUI_PrintPreviewFailed_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintPreviewUI_PrintPreviewFailed_Params_Data>(index_);
    }
    PrintPreviewUI_PrintPreviewFailed_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t document_cookie;
  int32_t request_id;

 private:
  PrintPreviewUI_PrintPreviewFailed_Params_Data();
  ~PrintPreviewUI_PrintPreviewFailed_Params_Data() = delete;
};
static_assert(sizeof(PrintPreviewUI_PrintPreviewFailed_Params_Data) == 16,
              "Bad sizeof(PrintPreviewUI_PrintPreviewFailed_Params_Data)");
class  PrintPreviewUI_PrintPreviewCancelled_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintPreviewUI_PrintPreviewCancelled_Params_Data));
      new (data()) PrintPreviewUI_PrintPreviewCancelled_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintPreviewUI_PrintPreviewCancelled_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintPreviewUI_PrintPreviewCancelled_Params_Data>(index_);
    }
    PrintPreviewUI_PrintPreviewCancelled_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t document_cookie;
  int32_t request_id;

 private:
  PrintPreviewUI_PrintPreviewCancelled_Params_Data();
  ~PrintPreviewUI_PrintPreviewCancelled_Params_Data() = delete;
};
static_assert(sizeof(PrintPreviewUI_PrintPreviewCancelled_Params_Data) == 16,
              "Bad sizeof(PrintPreviewUI_PrintPreviewCancelled_Params_Data)");
class  PrintPreviewUI_PrinterSettingsInvalid_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintPreviewUI_PrinterSettingsInvalid_Params_Data));
      new (data()) PrintPreviewUI_PrinterSettingsInvalid_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintPreviewUI_PrinterSettingsInvalid_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintPreviewUI_PrinterSettingsInvalid_Params_Data>(index_);
    }
    PrintPreviewUI_PrinterSettingsInvalid_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t document_cookie;
  int32_t request_id;

 private:
  PrintPreviewUI_PrinterSettingsInvalid_Params_Data();
  ~PrintPreviewUI_PrinterSettingsInvalid_Params_Data() = delete;
};
static_assert(sizeof(PrintPreviewUI_PrinterSettingsInvalid_Params_Data) == 16,
              "Bad sizeof(PrintPreviewUI_PrinterSettingsInvalid_Params_Data)");
class  PrintRenderFrame_PrintRequestedPages_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintRenderFrame_PrintRequestedPages_Params_Data));
      new (data()) PrintRenderFrame_PrintRequestedPages_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintRenderFrame_PrintRequestedPages_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintRenderFrame_PrintRequestedPages_Params_Data>(index_);
    }
    PrintRenderFrame_PrintRequestedPages_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  PrintRenderFrame_PrintRequestedPages_Params_Data();
  ~PrintRenderFrame_PrintRequestedPages_Params_Data() = delete;
};
static_assert(sizeof(PrintRenderFrame_PrintRequestedPages_Params_Data) == 8,
              "Bad sizeof(PrintRenderFrame_PrintRequestedPages_Params_Data)");
class  PrintRenderFrame_PrintForSystemDialog_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintRenderFrame_PrintForSystemDialog_Params_Data));
      new (data()) PrintRenderFrame_PrintForSystemDialog_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintRenderFrame_PrintForSystemDialog_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintRenderFrame_PrintForSystemDialog_Params_Data>(index_);
    }
    PrintRenderFrame_PrintForSystemDialog_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  PrintRenderFrame_PrintForSystemDialog_Params_Data();
  ~PrintRenderFrame_PrintForSystemDialog_Params_Data() = delete;
};
static_assert(sizeof(PrintRenderFrame_PrintForSystemDialog_Params_Data) == 8,
              "Bad sizeof(PrintRenderFrame_PrintForSystemDialog_Params_Data)");
class  PrintRenderFrame_InitiatePrintPreview_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintRenderFrame_InitiatePrintPreview_Params_Data));
      new (data()) PrintRenderFrame_InitiatePrintPreview_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintRenderFrame_InitiatePrintPreview_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintRenderFrame_InitiatePrintPreview_Params_Data>(index_);
    }
    PrintRenderFrame_InitiatePrintPreview_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedInterface_Data print_renderer;
  uint8_t has_selection : 1;
  uint8_t padfinal_[7];

 private:
  PrintRenderFrame_InitiatePrintPreview_Params_Data();
  ~PrintRenderFrame_InitiatePrintPreview_Params_Data() = delete;
};
static_assert(sizeof(PrintRenderFrame_InitiatePrintPreview_Params_Data) == 24,
              "Bad sizeof(PrintRenderFrame_InitiatePrintPreview_Params_Data)");
class  PrintRenderFrame_SetPrintPreviewUI_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintRenderFrame_SetPrintPreviewUI_Params_Data));
      new (data()) PrintRenderFrame_SetPrintPreviewUI_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintRenderFrame_SetPrintPreviewUI_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintRenderFrame_SetPrintPreviewUI_Params_Data>(index_);
    }
    PrintRenderFrame_SetPrintPreviewUI_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedInterface_Data preview;

 private:
  PrintRenderFrame_SetPrintPreviewUI_Params_Data();
  ~PrintRenderFrame_SetPrintPreviewUI_Params_Data() = delete;
};
static_assert(sizeof(PrintRenderFrame_SetPrintPreviewUI_Params_Data) == 16,
              "Bad sizeof(PrintRenderFrame_SetPrintPreviewUI_Params_Data)");
class  PrintRenderFrame_PrintPreview_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintRenderFrame_PrintPreview_Params_Data));
      new (data()) PrintRenderFrame_PrintPreview_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintRenderFrame_PrintPreview_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintRenderFrame_PrintPreview_Params_Data>(index_);
    }
    PrintRenderFrame_PrintPreview_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::DictionaryValue_Data> settings;

 private:
  PrintRenderFrame_PrintPreview_Params_Data();
  ~PrintRenderFrame_PrintPreview_Params_Data() = delete;
};
static_assert(sizeof(PrintRenderFrame_PrintPreview_Params_Data) == 16,
              "Bad sizeof(PrintRenderFrame_PrintPreview_Params_Data)");
class  PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data));
      new (data()) PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data>(index_);
    }
    PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data();
  ~PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data() = delete;
};
static_assert(sizeof(PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data) == 8,
              "Bad sizeof(PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data)");
class  PrintRenderFrame_PrintFrameContent_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintRenderFrame_PrintFrameContent_Params_Data));
      new (data()) PrintRenderFrame_PrintFrameContent_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintRenderFrame_PrintFrameContent_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintRenderFrame_PrintFrameContent_Params_Data>(index_);
    }
    PrintRenderFrame_PrintFrameContent_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::PrintFrameContentParams_Data> params;

 private:
  PrintRenderFrame_PrintFrameContent_Params_Data();
  ~PrintRenderFrame_PrintFrameContent_Params_Data() = delete;
};
static_assert(sizeof(PrintRenderFrame_PrintFrameContent_Params_Data) == 16,
              "Bad sizeof(PrintRenderFrame_PrintFrameContent_Params_Data)");
class  PrintRenderFrame_PrintFrameContent_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintRenderFrame_PrintFrameContent_ResponseParams_Data));
      new (data()) PrintRenderFrame_PrintFrameContent_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintRenderFrame_PrintFrameContent_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintRenderFrame_PrintFrameContent_ResponseParams_Data>(index_);
    }
    PrintRenderFrame_PrintFrameContent_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t document_cookie;
  uint8_t pad0_[4];
  mojo::internal::Pointer<internal::DidPrintContentParams_Data> params;

 private:
  PrintRenderFrame_PrintFrameContent_ResponseParams_Data();
  ~PrintRenderFrame_PrintFrameContent_ResponseParams_Data() = delete;
};
static_assert(sizeof(PrintRenderFrame_PrintFrameContent_ResponseParams_Data) == 24,
              "Bad sizeof(PrintRenderFrame_PrintFrameContent_ResponseParams_Data)");
class  PrintRenderFrame_SetPrintingEnabled_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintRenderFrame_SetPrintingEnabled_Params_Data));
      new (data()) PrintRenderFrame_SetPrintingEnabled_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintRenderFrame_SetPrintingEnabled_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintRenderFrame_SetPrintingEnabled_Params_Data>(index_);
    }
    PrintRenderFrame_SetPrintingEnabled_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t enabled : 1;
  uint8_t padfinal_[7];

 private:
  PrintRenderFrame_SetPrintingEnabled_Params_Data();
  ~PrintRenderFrame_SetPrintingEnabled_Params_Data() = delete;
};
static_assert(sizeof(PrintRenderFrame_SetPrintingEnabled_Params_Data) == 16,
              "Bad sizeof(PrintRenderFrame_SetPrintingEnabled_Params_Data)");
class  PrintRenderFrame_PrintingDone_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintRenderFrame_PrintingDone_Params_Data));
      new (data()) PrintRenderFrame_PrintingDone_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintRenderFrame_PrintingDone_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintRenderFrame_PrintingDone_Params_Data>(index_);
    }
    PrintRenderFrame_PrintingDone_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  PrintRenderFrame_PrintingDone_Params_Data();
  ~PrintRenderFrame_PrintingDone_Params_Data() = delete;
};
static_assert(sizeof(PrintRenderFrame_PrintingDone_Params_Data) == 16,
              "Bad sizeof(PrintRenderFrame_PrintingDone_Params_Data)");
class  PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data));
      new (data()) PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data>(index_);
    }
    PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data();
  ~PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data() = delete;
};
static_assert(sizeof(PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data) == 8,
              "Bad sizeof(PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data)");
class  PrintManagerHost_DidGetPrintedPagesCount_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintManagerHost_DidGetPrintedPagesCount_Params_Data));
      new (data()) PrintManagerHost_DidGetPrintedPagesCount_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintManagerHost_DidGetPrintedPagesCount_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintManagerHost_DidGetPrintedPagesCount_Params_Data>(index_);
    }
    PrintManagerHost_DidGetPrintedPagesCount_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t cookie;
  uint32_t number_pages;

 private:
  PrintManagerHost_DidGetPrintedPagesCount_Params_Data();
  ~PrintManagerHost_DidGetPrintedPagesCount_Params_Data() = delete;
};
static_assert(sizeof(PrintManagerHost_DidGetPrintedPagesCount_Params_Data) == 16,
              "Bad sizeof(PrintManagerHost_DidGetPrintedPagesCount_Params_Data)");
class  PrintManagerHost_DidGetDocumentCookie_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintManagerHost_DidGetDocumentCookie_Params_Data));
      new (data()) PrintManagerHost_DidGetDocumentCookie_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintManagerHost_DidGetDocumentCookie_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintManagerHost_DidGetDocumentCookie_Params_Data>(index_);
    }
    PrintManagerHost_DidGetDocumentCookie_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t cookie;
  uint8_t padfinal_[4];

 private:
  PrintManagerHost_DidGetDocumentCookie_Params_Data();
  ~PrintManagerHost_DidGetDocumentCookie_Params_Data() = delete;
};
static_assert(sizeof(PrintManagerHost_DidGetDocumentCookie_Params_Data) == 16,
              "Bad sizeof(PrintManagerHost_DidGetDocumentCookie_Params_Data)");
class  PrintManagerHost_SetAccessibilityTree_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintManagerHost_SetAccessibilityTree_Params_Data));
      new (data()) PrintManagerHost_SetAccessibilityTree_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintManagerHost_SetAccessibilityTree_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintManagerHost_SetAccessibilityTree_Params_Data>(index_);
    }
    PrintManagerHost_SetAccessibilityTree_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t cookie;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::ax::mojom::internal::AXTreeUpdate_Data> accessibility_tree;

 private:
  PrintManagerHost_SetAccessibilityTree_Params_Data();
  ~PrintManagerHost_SetAccessibilityTree_Params_Data() = delete;
};
static_assert(sizeof(PrintManagerHost_SetAccessibilityTree_Params_Data) == 24,
              "Bad sizeof(PrintManagerHost_SetAccessibilityTree_Params_Data)");
class  PrintManagerHost_GetDefaultPrintSettings_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintManagerHost_GetDefaultPrintSettings_Params_Data));
      new (data()) PrintManagerHost_GetDefaultPrintSettings_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintManagerHost_GetDefaultPrintSettings_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintManagerHost_GetDefaultPrintSettings_Params_Data>(index_);
    }
    PrintManagerHost_GetDefaultPrintSettings_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  PrintManagerHost_GetDefaultPrintSettings_Params_Data();
  ~PrintManagerHost_GetDefaultPrintSettings_Params_Data() = delete;
};
static_assert(sizeof(PrintManagerHost_GetDefaultPrintSettings_Params_Data) == 8,
              "Bad sizeof(PrintManagerHost_GetDefaultPrintSettings_Params_Data)");
class  PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data));
      new (data()) PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data>(index_);
    }
    PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::PrintParams_Data> default_settings;

 private:
  PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data();
  ~PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data() = delete;
};
static_assert(sizeof(PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data) == 16,
              "Bad sizeof(PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data)");
class  PrintManagerHost_DidShowPrintDialog_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintManagerHost_DidShowPrintDialog_Params_Data));
      new (data()) PrintManagerHost_DidShowPrintDialog_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintManagerHost_DidShowPrintDialog_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintManagerHost_DidShowPrintDialog_Params_Data>(index_);
    }
    PrintManagerHost_DidShowPrintDialog_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  PrintManagerHost_DidShowPrintDialog_Params_Data();
  ~PrintManagerHost_DidShowPrintDialog_Params_Data() = delete;
};
static_assert(sizeof(PrintManagerHost_DidShowPrintDialog_Params_Data) == 8,
              "Bad sizeof(PrintManagerHost_DidShowPrintDialog_Params_Data)");
class  PrintManagerHost_ShowInvalidPrinterSettingsError_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintManagerHost_ShowInvalidPrinterSettingsError_Params_Data));
      new (data()) PrintManagerHost_ShowInvalidPrinterSettingsError_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintManagerHost_ShowInvalidPrinterSettingsError_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintManagerHost_ShowInvalidPrinterSettingsError_Params_Data>(index_);
    }
    PrintManagerHost_ShowInvalidPrinterSettingsError_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  PrintManagerHost_ShowInvalidPrinterSettingsError_Params_Data();
  ~PrintManagerHost_ShowInvalidPrinterSettingsError_Params_Data() = delete;
};
static_assert(sizeof(PrintManagerHost_ShowInvalidPrinterSettingsError_Params_Data) == 8,
              "Bad sizeof(PrintManagerHost_ShowInvalidPrinterSettingsError_Params_Data)");
class  PrintManagerHost_PrintingFailed_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PrintManagerHost_PrintingFailed_Params_Data));
      new (data()) PrintManagerHost_PrintingFailed_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PrintManagerHost_PrintingFailed_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PrintManagerHost_PrintingFailed_Params_Data>(index_);
    }
    PrintManagerHost_PrintingFailed_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t cookie;
  uint8_t padfinal_[4];

 private:
  PrintManagerHost_PrintingFailed_Params_Data();
  ~PrintManagerHost_PrintingFailed_Params_Data() = delete;
};
static_assert(sizeof(PrintManagerHost_PrintingFailed_Params_Data) == 16,
              "Bad sizeof(PrintManagerHost_PrintingFailed_Params_Data)");

}  // namespace internal


class PrintRenderer_CreatePreviewDocument_ParamsDataView {
 public:
  PrintRenderer_CreatePreviewDocument_ParamsDataView() {}

  PrintRenderer_CreatePreviewDocument_ParamsDataView(
      internal::PrintRenderer_CreatePreviewDocument_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetJobSettingsDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadJobSettings(UserType* output) {
    
    auto* pointer = data_->job_settings.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, context_);
  }
 private:
  internal::PrintRenderer_CreatePreviewDocument_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PrintRenderer_CreatePreviewDocument_ResponseParamsDataView {
 public:
  PrintRenderer_CreatePreviewDocument_ResponseParamsDataView() {}

  PrintRenderer_CreatePreviewDocument_ResponseParamsDataView(
      internal::PrintRenderer_CreatePreviewDocument_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPreviewDocumentRegionDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPreviewDocumentRegion(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView, UserType>(),
    "Attempting to read the optional `preview_document_region` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPreviewDocumentRegion` instead "
    "of `ReadPreviewDocumentRegion if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->preview_document_region.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, context_);
  }
 private:
  internal::PrintRenderer_CreatePreviewDocument_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PrintPreviewUI_SetOptionsFromDocument_ParamsDataView {
 public:
  PrintPreviewUI_SetOptionsFromDocument_ParamsDataView() {}

  PrintPreviewUI_SetOptionsFromDocument_ParamsDataView(
      internal::PrintPreviewUI_SetOptionsFromDocument_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      OptionsFromDocumentParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::printing::mojom::OptionsFromDocumentParamsDataView>(
        pointer, output, context_);
  }
  int32_t request_id() const {
    return data_->request_id;
  }
 private:
  internal::PrintPreviewUI_SetOptionsFromDocument_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PrintPreviewUI_PrintPreviewFailed_ParamsDataView {
 public:
  PrintPreviewUI_PrintPreviewFailed_ParamsDataView() {}

  PrintPreviewUI_PrintPreviewFailed_ParamsDataView(
      internal::PrintPreviewUI_PrintPreviewFailed_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
  int32_t request_id() const {
    return data_->request_id;
  }
 private:
  internal::PrintPreviewUI_PrintPreviewFailed_Params_Data* data_ = nullptr;
};



class PrintPreviewUI_PrintPreviewCancelled_ParamsDataView {
 public:
  PrintPreviewUI_PrintPreviewCancelled_ParamsDataView() {}

  PrintPreviewUI_PrintPreviewCancelled_ParamsDataView(
      internal::PrintPreviewUI_PrintPreviewCancelled_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
  int32_t request_id() const {
    return data_->request_id;
  }
 private:
  internal::PrintPreviewUI_PrintPreviewCancelled_Params_Data* data_ = nullptr;
};



class PrintPreviewUI_PrinterSettingsInvalid_ParamsDataView {
 public:
  PrintPreviewUI_PrinterSettingsInvalid_ParamsDataView() {}

  PrintPreviewUI_PrinterSettingsInvalid_ParamsDataView(
      internal::PrintPreviewUI_PrinterSettingsInvalid_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
  int32_t request_id() const {
    return data_->request_id;
  }
 private:
  internal::PrintPreviewUI_PrinterSettingsInvalid_Params_Data* data_ = nullptr;
};



class PrintRenderFrame_PrintRequestedPages_ParamsDataView {
 public:
  PrintRenderFrame_PrintRequestedPages_ParamsDataView() {}

  PrintRenderFrame_PrintRequestedPages_ParamsDataView(
      internal::PrintRenderFrame_PrintRequestedPages_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PrintRenderFrame_PrintRequestedPages_Params_Data* data_ = nullptr;
};



class PrintRenderFrame_PrintForSystemDialog_ParamsDataView {
 public:
  PrintRenderFrame_PrintForSystemDialog_ParamsDataView() {}

  PrintRenderFrame_PrintForSystemDialog_ParamsDataView(
      internal::PrintRenderFrame_PrintForSystemDialog_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PrintRenderFrame_PrintForSystemDialog_Params_Data* data_ = nullptr;
};



class PrintRenderFrame_InitiatePrintPreview_ParamsDataView {
 public:
  PrintRenderFrame_InitiatePrintPreview_ParamsDataView() {}

  PrintRenderFrame_InitiatePrintPreview_ParamsDataView(
      internal::PrintRenderFrame_InitiatePrintPreview_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakePrintRenderer() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::printing::mojom::PrintRendererAssociatedPtrInfoDataView>(
            &data_->print_renderer, &result, context_);
    DCHECK(ret);
    return result;
  }
  bool has_selection() const {
    return data_->has_selection;
  }
 private:
  internal::PrintRenderFrame_InitiatePrintPreview_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PrintRenderFrame_SetPrintPreviewUI_ParamsDataView {
 public:
  PrintRenderFrame_SetPrintPreviewUI_ParamsDataView() {}

  PrintRenderFrame_SetPrintPreviewUI_ParamsDataView(
      internal::PrintRenderFrame_SetPrintPreviewUI_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakePreview() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::printing::mojom::PrintPreviewUIAssociatedPtrInfoDataView>(
            &data_->preview, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PrintRenderFrame_SetPrintPreviewUI_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PrintRenderFrame_PrintPreview_ParamsDataView {
 public:
  PrintRenderFrame_PrintPreview_ParamsDataView() {}

  PrintRenderFrame_PrintPreview_ParamsDataView(
      internal::PrintRenderFrame_PrintPreview_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSettingsDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSettings(UserType* output) {
    
    auto* pointer = data_->settings.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, context_);
  }
 private:
  internal::PrintRenderFrame_PrintPreview_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PrintRenderFrame_OnPrintPreviewDialogClosed_ParamsDataView {
 public:
  PrintRenderFrame_OnPrintPreviewDialogClosed_ParamsDataView() {}

  PrintRenderFrame_OnPrintPreviewDialogClosed_ParamsDataView(
      internal::PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PrintRenderFrame_OnPrintPreviewDialogClosed_Params_Data* data_ = nullptr;
};



class PrintRenderFrame_PrintFrameContent_ParamsDataView {
 public:
  PrintRenderFrame_PrintFrameContent_ParamsDataView() {}

  PrintRenderFrame_PrintFrameContent_ParamsDataView(
      internal::PrintRenderFrame_PrintFrameContent_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      PrintFrameContentParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::printing::mojom::PrintFrameContentParamsDataView>(
        pointer, output, context_);
  }
 private:
  internal::PrintRenderFrame_PrintFrameContent_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PrintRenderFrame_PrintFrameContent_ResponseParamsDataView {
 public:
  PrintRenderFrame_PrintFrameContent_ResponseParamsDataView() {}

  PrintRenderFrame_PrintFrameContent_ResponseParamsDataView(
      internal::PrintRenderFrame_PrintFrameContent_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
  inline void GetParamsDataView(
      DidPrintContentParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::printing::mojom::DidPrintContentParamsDataView>(
        pointer, output, context_);
  }
 private:
  internal::PrintRenderFrame_PrintFrameContent_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PrintRenderFrame_SetPrintingEnabled_ParamsDataView {
 public:
  PrintRenderFrame_SetPrintingEnabled_ParamsDataView() {}

  PrintRenderFrame_SetPrintingEnabled_ParamsDataView(
      internal::PrintRenderFrame_SetPrintingEnabled_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool enabled() const {
    return data_->enabled;
  }
 private:
  internal::PrintRenderFrame_SetPrintingEnabled_Params_Data* data_ = nullptr;
};



class PrintRenderFrame_PrintingDone_ParamsDataView {
 public:
  PrintRenderFrame_PrintingDone_ParamsDataView() {}

  PrintRenderFrame_PrintingDone_ParamsDataView(
      internal::PrintRenderFrame_PrintingDone_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::PrintRenderFrame_PrintingDone_Params_Data* data_ = nullptr;
};



class PrintRenderFrame_PrintNodeUnderContextMenu_ParamsDataView {
 public:
  PrintRenderFrame_PrintNodeUnderContextMenu_ParamsDataView() {}

  PrintRenderFrame_PrintNodeUnderContextMenu_ParamsDataView(
      internal::PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PrintRenderFrame_PrintNodeUnderContextMenu_Params_Data* data_ = nullptr;
};



class PrintManagerHost_DidGetPrintedPagesCount_ParamsDataView {
 public:
  PrintManagerHost_DidGetPrintedPagesCount_ParamsDataView() {}

  PrintManagerHost_DidGetPrintedPagesCount_ParamsDataView(
      internal::PrintManagerHost_DidGetPrintedPagesCount_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t cookie() const {
    return data_->cookie;
  }
  uint32_t number_pages() const {
    return data_->number_pages;
  }
 private:
  internal::PrintManagerHost_DidGetPrintedPagesCount_Params_Data* data_ = nullptr;
};



class PrintManagerHost_DidGetDocumentCookie_ParamsDataView {
 public:
  PrintManagerHost_DidGetDocumentCookie_ParamsDataView() {}

  PrintManagerHost_DidGetDocumentCookie_ParamsDataView(
      internal::PrintManagerHost_DidGetDocumentCookie_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t cookie() const {
    return data_->cookie;
  }
 private:
  internal::PrintManagerHost_DidGetDocumentCookie_Params_Data* data_ = nullptr;
};



class PrintManagerHost_SetAccessibilityTree_ParamsDataView {
 public:
  PrintManagerHost_SetAccessibilityTree_ParamsDataView() {}

  PrintManagerHost_SetAccessibilityTree_ParamsDataView(
      internal::PrintManagerHost_SetAccessibilityTree_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t cookie() const {
    return data_->cookie;
  }
  inline void GetAccessibilityTreeDataView(
      ::ax::mojom::AXTreeUpdateDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAccessibilityTree(UserType* output) {
    
    auto* pointer = data_->accessibility_tree.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXTreeUpdateDataView>(
        pointer, output, context_);
  }
 private:
  internal::PrintManagerHost_SetAccessibilityTree_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PrintManagerHost_GetDefaultPrintSettings_ParamsDataView {
 public:
  PrintManagerHost_GetDefaultPrintSettings_ParamsDataView() {}

  PrintManagerHost_GetDefaultPrintSettings_ParamsDataView(
      internal::PrintManagerHost_GetDefaultPrintSettings_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PrintManagerHost_GetDefaultPrintSettings_Params_Data* data_ = nullptr;
};



class PrintManagerHost_GetDefaultPrintSettings_ResponseParamsDataView {
 public:
  PrintManagerHost_GetDefaultPrintSettings_ResponseParamsDataView() {}

  PrintManagerHost_GetDefaultPrintSettings_ResponseParamsDataView(
      internal::PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDefaultSettingsDataView(
      PrintParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDefaultSettings(UserType* output) {
    
    auto* pointer = data_->default_settings.Get();
    return mojo::internal::Deserialize<::printing::mojom::PrintParamsDataView>(
        pointer, output, context_);
  }
 private:
  internal::PrintManagerHost_GetDefaultPrintSettings_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PrintManagerHost_DidShowPrintDialog_ParamsDataView {
 public:
  PrintManagerHost_DidShowPrintDialog_ParamsDataView() {}

  PrintManagerHost_DidShowPrintDialog_ParamsDataView(
      internal::PrintManagerHost_DidShowPrintDialog_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PrintManagerHost_DidShowPrintDialog_Params_Data* data_ = nullptr;
};



class PrintManagerHost_ShowInvalidPrinterSettingsError_ParamsDataView {
 public:
  PrintManagerHost_ShowInvalidPrinterSettingsError_ParamsDataView() {}

  PrintManagerHost_ShowInvalidPrinterSettingsError_ParamsDataView(
      internal::PrintManagerHost_ShowInvalidPrinterSettingsError_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PrintManagerHost_ShowInvalidPrinterSettingsError_Params_Data* data_ = nullptr;
};



class PrintManagerHost_PrintingFailed_ParamsDataView {
 public:
  PrintManagerHost_PrintingFailed_ParamsDataView() {}

  PrintManagerHost_PrintingFailed_ParamsDataView(
      internal::PrintManagerHost_PrintingFailed_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t cookie() const {
    return data_->cookie;
  }
 private:
  internal::PrintManagerHost_PrintingFailed_Params_Data* data_ = nullptr;
};


inline void PrintRenderer_CreatePreviewDocument_ParamsDataView::GetJobSettingsDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->job_settings.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, context_);
}


inline void PrintRenderer_CreatePreviewDocument_ResponseParamsDataView::GetPreviewDocumentRegionDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->preview_document_region.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, context_);
}


inline void PrintPreviewUI_SetOptionsFromDocument_ParamsDataView::GetParamsDataView(
    OptionsFromDocumentParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = OptionsFromDocumentParamsDataView(pointer, context_);
}
















inline void PrintRenderFrame_PrintPreview_ParamsDataView::GetSettingsDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->settings.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, context_);
}




inline void PrintRenderFrame_PrintFrameContent_ParamsDataView::GetParamsDataView(
    PrintFrameContentParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = PrintFrameContentParamsDataView(pointer, context_);
}


inline void PrintRenderFrame_PrintFrameContent_ResponseParamsDataView::GetParamsDataView(
    DidPrintContentParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = DidPrintContentParamsDataView(pointer, context_);
}












inline void PrintManagerHost_SetAccessibilityTree_ParamsDataView::GetAccessibilityTreeDataView(
    ::ax::mojom::AXTreeUpdateDataView* output) {
  auto pointer = data_->accessibility_tree.Get();
  *output = ::ax::mojom::AXTreeUpdateDataView(pointer, context_);
}




inline void PrintManagerHost_GetDefaultPrintSettings_ResponseParamsDataView::GetDefaultSettingsDataView(
    PrintParamsDataView* output) {
  auto pointer = data_->default_settings.Get();
  *output = PrintParamsDataView(pointer, context_);
}







}  // namespace mojom
}  // namespace printing

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_PARAMS_DATA_H_