// cc/mojom/render_frame_metadata.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_H_
#define CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "cc/mojom/render_frame_metadata.mojom-shared.h"
#include "cc/mojom/render_frame_metadata.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom-forward.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom.h"
#include "services/viz/public/mojom/compositing/selection.mojom.h"
#include "services/viz/public/mojom/compositing/vertical_scroll_direction.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "cc/mojom/render_frame_metadata_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace cc {
namespace mojom {

class RenderFrameMetadataObserverProxy;

template <typename ImplRefTraits>
class RenderFrameMetadataObserverStub;

class RenderFrameMetadataObserverRequestValidator;


class  RenderFrameMetadataObserver
    : public RenderFrameMetadataObserverInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RenderFrameMetadataObserverInterfaceBase;
  using Proxy_ = RenderFrameMetadataObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = RenderFrameMetadataObserverStub<ImplRefTraits>;

  using RequestValidator_ = RenderFrameMetadataObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kReportAllFrameSubmissionsForTestingMinVersion = 0,
  };
  virtual ~RenderFrameMetadataObserver() {}

  
  virtual void ReportAllFrameSubmissionsForTesting(bool enabled) = 0;
};

class RenderFrameMetadataObserverClientProxy;

template <typename ImplRefTraits>
class RenderFrameMetadataObserverClientStub;

class RenderFrameMetadataObserverClientRequestValidator;


class  RenderFrameMetadataObserverClient
    : public RenderFrameMetadataObserverClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RenderFrameMetadataObserverClientInterfaceBase;
  using Proxy_ = RenderFrameMetadataObserverClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = RenderFrameMetadataObserverClientStub<ImplRefTraits>;

  using RequestValidator_ = RenderFrameMetadataObserverClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnRenderFrameMetadataChangedMinVersion = 0,
    kOnFrameSubmissionForTestingMinVersion = 0,
  };
  virtual ~RenderFrameMetadataObserverClient() {}

  
  virtual void OnRenderFrameMetadataChanged(uint32_t frame_token, const ::cc::RenderFrameMetadata& metadata) = 0;

  
  virtual void OnFrameSubmissionForTesting(uint32_t frame_token) = 0;
};



class  RenderFrameMetadataObserverProxy
    : public RenderFrameMetadataObserver {
 public:
  using InterfaceType = RenderFrameMetadataObserver;

  explicit RenderFrameMetadataObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReportAllFrameSubmissionsForTesting(bool enabled) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  RenderFrameMetadataObserverClientProxy
    : public RenderFrameMetadataObserverClient {
 public:
  using InterfaceType = RenderFrameMetadataObserverClient;

  explicit RenderFrameMetadataObserverClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnRenderFrameMetadataChanged(uint32_t frame_token, const ::cc::RenderFrameMetadata& metadata) final;
  
  void OnFrameSubmissionForTesting(uint32_t frame_token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  RenderFrameMetadataObserverStubDispatch {
 public:
  static bool Accept(RenderFrameMetadataObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RenderFrameMetadataObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RenderFrameMetadataObserver>>
class RenderFrameMetadataObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RenderFrameMetadataObserverStub() {}
  ~RenderFrameMetadataObserverStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderFrameMetadataObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderFrameMetadataObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  RenderFrameMetadataObserverClientStubDispatch {
 public:
  static bool Accept(RenderFrameMetadataObserverClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RenderFrameMetadataObserverClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RenderFrameMetadataObserverClient>>
class RenderFrameMetadataObserverClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RenderFrameMetadataObserverClientStub() {}
  ~RenderFrameMetadataObserverClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderFrameMetadataObserverClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderFrameMetadataObserverClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  RenderFrameMetadataObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  RenderFrameMetadataObserverClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  RenderFrameMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RenderFrameMetadata, T>::value>;
  using DataView = RenderFrameMetadataDataView;
  using Data_ = internal::RenderFrameMetadata_Data;

  template <typename... Args>
  static RenderFrameMetadataPtr New(Args&&... args) {
    return RenderFrameMetadataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RenderFrameMetadataPtr From(const U& u) {
    return mojo::TypeConverter<RenderFrameMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RenderFrameMetadata>::Convert(*this);
  }


  RenderFrameMetadata();

  RenderFrameMetadata(
      uint32_t root_background_color,
      const base::Optional<::gfx::Vector2dF>& root_scroll_offset,
      bool is_scroll_offset_at_top,
      const ::viz::Selection<::gfx::SelectionBound>& selection,
      bool is_mobile_optimized,
      bool has_delegated_ink_metadata,
      float device_scale_factor,
      const ::gfx::Size& viewport_size_in_pixels,
      const base::Optional<::viz::LocalSurfaceId>& local_surface_id,
      float page_scale_factor,
      float external_page_scale_factor,
      float top_controls_height,
      float top_controls_shown_ratio,
      ::viz::VerticalScrollDirection new_vertical_scroll_direction,
      float bottom_controls_height,
      float bottom_controls_shown_ratio,
      float top_controls_min_height_offset,
      float bottom_controls_min_height_offset,
      float min_page_scale_factor,
      float max_page_scale_factor,
      bool root_overflow_y_hidden,
      const ::gfx::SizeF& scrollable_viewport_size,
      const ::gfx::SizeF& root_layer_size,
      bool has_transparent_background);

  ~RenderFrameMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RenderFrameMetadataPtr>
  RenderFrameMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RenderFrameMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RenderFrameMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RenderFrameMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RenderFrameMetadata_UnserializedMessageContext<
            UserType, RenderFrameMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<RenderFrameMetadata::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return RenderFrameMetadata::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RenderFrameMetadata_UnserializedMessageContext<
            UserType, RenderFrameMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RenderFrameMetadata::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t root_background_color;
  
  base::Optional<::gfx::Vector2dF> root_scroll_offset;
  
  bool is_scroll_offset_at_top;
  
  ::viz::Selection<::gfx::SelectionBound> selection;
  
  bool is_mobile_optimized;
  
  bool has_delegated_ink_metadata;
  
  float device_scale_factor;
  
  ::gfx::Size viewport_size_in_pixels;
  
  base::Optional<::viz::LocalSurfaceId> local_surface_id;
  
  float page_scale_factor;
  
  float external_page_scale_factor;
  
  float top_controls_height;
  
  float top_controls_shown_ratio;
  
  ::viz::VerticalScrollDirection new_vertical_scroll_direction;
  
  float bottom_controls_height;
  
  float bottom_controls_shown_ratio;
  
  float top_controls_min_height_offset;
  
  float bottom_controls_min_height_offset;
  
  float min_page_scale_factor;
  
  float max_page_scale_factor;
  
  bool root_overflow_y_hidden;
  
  ::gfx::SizeF scrollable_viewport_size;
  
  ::gfx::SizeF root_layer_size;
  
  bool has_transparent_background;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RenderFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RenderFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RenderFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RenderFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RenderFrameMetadataPtr RenderFrameMetadata::Clone() const {
  return New(
      mojo::Clone(root_background_color),
      mojo::Clone(root_scroll_offset),
      mojo::Clone(is_scroll_offset_at_top),
      mojo::Clone(selection),
      mojo::Clone(is_mobile_optimized),
      mojo::Clone(has_delegated_ink_metadata),
      mojo::Clone(device_scale_factor),
      mojo::Clone(viewport_size_in_pixels),
      mojo::Clone(local_surface_id),
      mojo::Clone(page_scale_factor),
      mojo::Clone(external_page_scale_factor),
      mojo::Clone(top_controls_height),
      mojo::Clone(top_controls_shown_ratio),
      mojo::Clone(new_vertical_scroll_direction),
      mojo::Clone(bottom_controls_height),
      mojo::Clone(bottom_controls_shown_ratio),
      mojo::Clone(top_controls_min_height_offset),
      mojo::Clone(bottom_controls_min_height_offset),
      mojo::Clone(min_page_scale_factor),
      mojo::Clone(max_page_scale_factor),
      mojo::Clone(root_overflow_y_hidden),
      mojo::Clone(scrollable_viewport_size),
      mojo::Clone(root_layer_size),
      mojo::Clone(has_transparent_background)
  );
}

template <typename T, RenderFrameMetadata::EnableIfSame<T>*>
bool RenderFrameMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->root_background_color, other_struct.root_background_color))
    return false;
  if (!mojo::Equals(this->root_scroll_offset, other_struct.root_scroll_offset))
    return false;
  if (!mojo::Equals(this->is_scroll_offset_at_top, other_struct.is_scroll_offset_at_top))
    return false;
  if (!mojo::Equals(this->selection, other_struct.selection))
    return false;
  if (!mojo::Equals(this->is_mobile_optimized, other_struct.is_mobile_optimized))
    return false;
  if (!mojo::Equals(this->has_delegated_ink_metadata, other_struct.has_delegated_ink_metadata))
    return false;
  if (!mojo::Equals(this->device_scale_factor, other_struct.device_scale_factor))
    return false;
  if (!mojo::Equals(this->viewport_size_in_pixels, other_struct.viewport_size_in_pixels))
    return false;
  if (!mojo::Equals(this->local_surface_id, other_struct.local_surface_id))
    return false;
  if (!mojo::Equals(this->page_scale_factor, other_struct.page_scale_factor))
    return false;
  if (!mojo::Equals(this->external_page_scale_factor, other_struct.external_page_scale_factor))
    return false;
  if (!mojo::Equals(this->top_controls_height, other_struct.top_controls_height))
    return false;
  if (!mojo::Equals(this->top_controls_shown_ratio, other_struct.top_controls_shown_ratio))
    return false;
  if (!mojo::Equals(this->new_vertical_scroll_direction, other_struct.new_vertical_scroll_direction))
    return false;
  if (!mojo::Equals(this->bottom_controls_height, other_struct.bottom_controls_height))
    return false;
  if (!mojo::Equals(this->bottom_controls_shown_ratio, other_struct.bottom_controls_shown_ratio))
    return false;
  if (!mojo::Equals(this->top_controls_min_height_offset, other_struct.top_controls_min_height_offset))
    return false;
  if (!mojo::Equals(this->bottom_controls_min_height_offset, other_struct.bottom_controls_min_height_offset))
    return false;
  if (!mojo::Equals(this->min_page_scale_factor, other_struct.min_page_scale_factor))
    return false;
  if (!mojo::Equals(this->max_page_scale_factor, other_struct.max_page_scale_factor))
    return false;
  if (!mojo::Equals(this->root_overflow_y_hidden, other_struct.root_overflow_y_hidden))
    return false;
  if (!mojo::Equals(this->scrollable_viewport_size, other_struct.scrollable_viewport_size))
    return false;
  if (!mojo::Equals(this->root_layer_size, other_struct.root_layer_size))
    return false;
  if (!mojo::Equals(this->has_transparent_background, other_struct.has_transparent_background))
    return false;
  return true;
}

template <typename T, RenderFrameMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.root_background_color, rhs.root_background_color))
    return true;
  if (std::less<>{}(rhs.root_background_color, lhs.root_background_color))
    return false;
  if (std::less<>{}(lhs.root_scroll_offset, rhs.root_scroll_offset))
    return true;
  if (std::less<>{}(rhs.root_scroll_offset, lhs.root_scroll_offset))
    return false;
  if (std::less<>{}(lhs.is_scroll_offset_at_top, rhs.is_scroll_offset_at_top))
    return true;
  if (std::less<>{}(rhs.is_scroll_offset_at_top, lhs.is_scroll_offset_at_top))
    return false;
  if (std::less<>{}(lhs.selection, rhs.selection))
    return true;
  if (std::less<>{}(rhs.selection, lhs.selection))
    return false;
  if (std::less<>{}(lhs.is_mobile_optimized, rhs.is_mobile_optimized))
    return true;
  if (std::less<>{}(rhs.is_mobile_optimized, lhs.is_mobile_optimized))
    return false;
  if (std::less<>{}(lhs.has_delegated_ink_metadata, rhs.has_delegated_ink_metadata))
    return true;
  if (std::less<>{}(rhs.has_delegated_ink_metadata, lhs.has_delegated_ink_metadata))
    return false;
  if (std::less<>{}(lhs.device_scale_factor, rhs.device_scale_factor))
    return true;
  if (std::less<>{}(rhs.device_scale_factor, lhs.device_scale_factor))
    return false;
  if (std::less<>{}(lhs.viewport_size_in_pixels, rhs.viewport_size_in_pixels))
    return true;
  if (std::less<>{}(rhs.viewport_size_in_pixels, lhs.viewport_size_in_pixels))
    return false;
  if (std::less<>{}(lhs.local_surface_id, rhs.local_surface_id))
    return true;
  if (std::less<>{}(rhs.local_surface_id, lhs.local_surface_id))
    return false;
  if (std::less<>{}(lhs.page_scale_factor, rhs.page_scale_factor))
    return true;
  if (std::less<>{}(rhs.page_scale_factor, lhs.page_scale_factor))
    return false;
  if (std::less<>{}(lhs.external_page_scale_factor, rhs.external_page_scale_factor))
    return true;
  if (std::less<>{}(rhs.external_page_scale_factor, lhs.external_page_scale_factor))
    return false;
  if (std::less<>{}(lhs.top_controls_height, rhs.top_controls_height))
    return true;
  if (std::less<>{}(rhs.top_controls_height, lhs.top_controls_height))
    return false;
  if (std::less<>{}(lhs.top_controls_shown_ratio, rhs.top_controls_shown_ratio))
    return true;
  if (std::less<>{}(rhs.top_controls_shown_ratio, lhs.top_controls_shown_ratio))
    return false;
  if (std::less<>{}(lhs.new_vertical_scroll_direction, rhs.new_vertical_scroll_direction))
    return true;
  if (std::less<>{}(rhs.new_vertical_scroll_direction, lhs.new_vertical_scroll_direction))
    return false;
  if (std::less<>{}(lhs.bottom_controls_height, rhs.bottom_controls_height))
    return true;
  if (std::less<>{}(rhs.bottom_controls_height, lhs.bottom_controls_height))
    return false;
  if (std::less<>{}(lhs.bottom_controls_shown_ratio, rhs.bottom_controls_shown_ratio))
    return true;
  if (std::less<>{}(rhs.bottom_controls_shown_ratio, lhs.bottom_controls_shown_ratio))
    return false;
  if (std::less<>{}(lhs.top_controls_min_height_offset, rhs.top_controls_min_height_offset))
    return true;
  if (std::less<>{}(rhs.top_controls_min_height_offset, lhs.top_controls_min_height_offset))
    return false;
  if (std::less<>{}(lhs.bottom_controls_min_height_offset, rhs.bottom_controls_min_height_offset))
    return true;
  if (std::less<>{}(rhs.bottom_controls_min_height_offset, lhs.bottom_controls_min_height_offset))
    return false;
  if (std::less<>{}(lhs.min_page_scale_factor, rhs.min_page_scale_factor))
    return true;
  if (std::less<>{}(rhs.min_page_scale_factor, lhs.min_page_scale_factor))
    return false;
  if (std::less<>{}(lhs.max_page_scale_factor, rhs.max_page_scale_factor))
    return true;
  if (std::less<>{}(rhs.max_page_scale_factor, lhs.max_page_scale_factor))
    return false;
  if (std::less<>{}(lhs.root_overflow_y_hidden, rhs.root_overflow_y_hidden))
    return true;
  if (std::less<>{}(rhs.root_overflow_y_hidden, lhs.root_overflow_y_hidden))
    return false;
  if (std::less<>{}(lhs.scrollable_viewport_size, rhs.scrollable_viewport_size))
    return true;
  if (std::less<>{}(rhs.scrollable_viewport_size, lhs.scrollable_viewport_size))
    return false;
  if (std::less<>{}(lhs.root_layer_size, rhs.root_layer_size))
    return true;
  if (std::less<>{}(rhs.root_layer_size, lhs.root_layer_size))
    return false;
  if (std::less<>{}(lhs.has_transparent_background, rhs.has_transparent_background))
    return true;
  if (std::less<>{}(rhs.has_transparent_background, lhs.has_transparent_background))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace cc

namespace mojo {


template <>
struct  StructTraits<::cc::mojom::RenderFrameMetadata::DataView,
                                         ::cc::mojom::RenderFrameMetadataPtr> {
  static bool IsNull(const ::cc::mojom::RenderFrameMetadataPtr& input) { return !input; }
  static void SetToNull(::cc::mojom::RenderFrameMetadataPtr* output) { output->reset(); }

  static decltype(::cc::mojom::RenderFrameMetadata::root_background_color) root_background_color(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->root_background_color;
  }

  static const decltype(::cc::mojom::RenderFrameMetadata::root_scroll_offset)& root_scroll_offset(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->root_scroll_offset;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::is_scroll_offset_at_top) is_scroll_offset_at_top(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->is_scroll_offset_at_top;
  }

  static const decltype(::cc::mojom::RenderFrameMetadata::selection)& selection(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->selection;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::is_mobile_optimized) is_mobile_optimized(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->is_mobile_optimized;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::has_delegated_ink_metadata) has_delegated_ink_metadata(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->has_delegated_ink_metadata;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::device_scale_factor) device_scale_factor(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->device_scale_factor;
  }

  static const decltype(::cc::mojom::RenderFrameMetadata::viewport_size_in_pixels)& viewport_size_in_pixels(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->viewport_size_in_pixels;
  }

  static const decltype(::cc::mojom::RenderFrameMetadata::local_surface_id)& local_surface_id(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->local_surface_id;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::page_scale_factor) page_scale_factor(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->page_scale_factor;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::external_page_scale_factor) external_page_scale_factor(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->external_page_scale_factor;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::top_controls_height) top_controls_height(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->top_controls_height;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::top_controls_shown_ratio) top_controls_shown_ratio(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->top_controls_shown_ratio;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::new_vertical_scroll_direction) new_vertical_scroll_direction(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->new_vertical_scroll_direction;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::bottom_controls_height) bottom_controls_height(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->bottom_controls_height;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::bottom_controls_shown_ratio) bottom_controls_shown_ratio(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->bottom_controls_shown_ratio;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::top_controls_min_height_offset) top_controls_min_height_offset(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->top_controls_min_height_offset;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::bottom_controls_min_height_offset) bottom_controls_min_height_offset(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->bottom_controls_min_height_offset;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::min_page_scale_factor) min_page_scale_factor(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->min_page_scale_factor;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::max_page_scale_factor) max_page_scale_factor(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->max_page_scale_factor;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::root_overflow_y_hidden) root_overflow_y_hidden(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->root_overflow_y_hidden;
  }

  static const decltype(::cc::mojom::RenderFrameMetadata::scrollable_viewport_size)& scrollable_viewport_size(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->scrollable_viewport_size;
  }

  static const decltype(::cc::mojom::RenderFrameMetadata::root_layer_size)& root_layer_size(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->root_layer_size;
  }

  static decltype(::cc::mojom::RenderFrameMetadata::has_transparent_background) has_transparent_background(
      const ::cc::mojom::RenderFrameMetadataPtr& input) {
    return input->has_transparent_background;
  }

  static bool Read(::cc::mojom::RenderFrameMetadata::DataView input, ::cc::mojom::RenderFrameMetadataPtr* output);
};

}  // namespace mojo

#endif  // CC_MOJOM_RENDER_FRAME_METADATA_MOJOM_H_