// ----------------------------------------------------------------------------
//
//  Copyright (C) 2024 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#include <Python.h>
#include "jfwcapt.h"


static const char *capslabel = "Jfwcapt";


extern "C" void destroy (PyObject *P)
{
    delete (Jfwcapt *) PyCapsule_GetPointer (P, capslabel);
}


extern "C" PyObject* makecaps (PyObject *self, PyObject *args)
{
    Jfwcapt   *J;
    PyObject  *P;
    const char *client_name;
    const char *server_name;
    int nchan;
    
    if (! PyArg_ParseTuple(args, "Oszi", &P, &client_name, &server_name,
			   &nchan)) return NULL;
    J = new Jfwcapt (client_name, server_name, nchan);
    return Py_BuildValue ("NN",
			  PyCapsule_New (J, capslabel, destroy),
                          PyCapsule_New (dynamic_cast<Jclient *>(J), "Jclient", 0));
}


extern "C" PyObject* create_file (PyObject *self, PyObject *args)
{
    PyObject  *P;
    Jfwcapt   *J;
    char      *fname;
    char      *ftype;
    int       fchan;
    
    if (! PyArg_ParseTuple(args, "Osiz", &P, &fname, &fchan, &ftype)) return 0;
    J = (Jfwcapt *) PyCapsule_GetPointer (P, capslabel);
    return Py_BuildValue ("i", J->create_file (fname, fchan, ftype));
}


static PyMethodDef JackFwcaptMethods[] =
{ 
    {"makecaps",        makecaps,        METH_VARARGS, "Create object capsules."  },
    {"create_file",     create_file,     METH_VARARGS, "Create file for capture." },
    {NULL, NULL, 0, NULL}
};



#if PY_VERSION_HEX >= 0x03000000

static struct PyModuleDef JackFwcaptModule = 
{
   PyModuleDef_HEAD_INIT,
   "jackambbin_ext",
   NULL, 
   -1, 
   JackFwcaptMethods
};

PyMODINIT_FUNC PyInit_jackfwcapt_ext(void)
{
    return PyModule_Create (&JackFwcaptModule);
}

#else
#error "This code requires Python 3."
#endif
