/*-------------------------------------------------------------------------
 *
 * readfuncs.funcs.c
 *    Generated node infrastructure code
 *
 * Portions Copyright (c) 1996-2024, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by src/backend/nodes/gen_node_support.pl
 *
 *-------------------------------------------------------------------------
 */
#include "access/amapi.h"
#include "access/sdir.h"
#include "access/tableam.h"
#include "access/tsmapi.h"
#include "commands/event_trigger.h"
#include "commands/trigger.h"
#include "executor/tuptable.h"
#include "foreign/fdwapi.h"
#include "nodes/bitmapset.h"
#include "nodes/execnodes.h"
#include "nodes/extensible.h"
#include "nodes/lockoptions.h"
#include "nodes/miscnodes.h"
#include "nodes/nodes.h"
#include "nodes/parsenodes.h"
#include "nodes/pathnodes.h"
#include "nodes/plannodes.h"
#include "nodes/primnodes.h"
#include "nodes/replnodes.h"
#include "nodes/supportnodes.h"
#include "nodes/value.h"
#include "utils/rel.h"

static Alias *
_readAlias(void)
{
	READ_LOCALS(Alias);

	READ_STRING_FIELD(aliasname);
	READ_NODE_FIELD(colnames);

	READ_DONE();
}

static RangeVar *
_readRangeVar(void)
{
	READ_LOCALS(RangeVar);

	READ_STRING_FIELD(catalogname);
	READ_STRING_FIELD(schemaname);
	READ_STRING_FIELD(relname);
	READ_BOOL_FIELD(inh);
	READ_CHAR_FIELD(relpersistence);
	READ_NODE_FIELD(alias);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static TableFunc *
_readTableFunc(void)
{
	READ_LOCALS(TableFunc);

	READ_ENUM_FIELD(functype, TableFuncType);
	READ_NODE_FIELD(ns_uris);
	READ_NODE_FIELD(ns_names);
	READ_NODE_FIELD(docexpr);
	READ_NODE_FIELD(rowexpr);
	READ_NODE_FIELD(colnames);
	READ_NODE_FIELD(coltypes);
	READ_NODE_FIELD(coltypmods);
	READ_NODE_FIELD(colcollations);
	READ_NODE_FIELD(colexprs);
	READ_NODE_FIELD(coldefexprs);
	READ_NODE_FIELD(colvalexprs);
	READ_NODE_FIELD(passingvalexprs);
	READ_BITMAPSET_FIELD(notnulls);
	READ_NODE_FIELD(plan);
	READ_INT_FIELD(ordinalitycol);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static IntoClause *
_readIntoClause(void)
{
	READ_LOCALS(IntoClause);

	READ_NODE_FIELD(rel);
	READ_NODE_FIELD(colNames);
	READ_STRING_FIELD(accessMethod);
	READ_NODE_FIELD(options);
	READ_ENUM_FIELD(onCommit, OnCommitAction);
	READ_STRING_FIELD(tableSpaceName);
	READ_NODE_FIELD(viewQuery);
	READ_BOOL_FIELD(skipData);

	READ_DONE();
}

static Var *
_readVar(void)
{
	READ_LOCALS(Var);

	READ_INT_FIELD(varno);
	READ_INT_FIELD(varattno);
	READ_OID_FIELD(vartype);
	READ_INT_FIELD(vartypmod);
	READ_OID_FIELD(varcollid);
	READ_BITMAPSET_FIELD(varnullingrels);
	READ_UINT_FIELD(varlevelsup);
	READ_UINT_FIELD(varnosyn);
	READ_INT_FIELD(varattnosyn);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static Param *
_readParam(void)
{
	READ_LOCALS(Param);

	READ_ENUM_FIELD(paramkind, ParamKind);
	READ_INT_FIELD(paramid);
	READ_OID_FIELD(paramtype);
	READ_INT_FIELD(paramtypmod);
	READ_OID_FIELD(paramcollid);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static Aggref *
_readAggref(void)
{
	READ_LOCALS(Aggref);

	READ_OID_FIELD(aggfnoid);
	READ_OID_FIELD(aggtype);
	READ_OID_FIELD(aggcollid);
	READ_OID_FIELD(inputcollid);
	READ_OID_FIELD(aggtranstype);
	READ_NODE_FIELD(aggargtypes);
	READ_NODE_FIELD(aggdirectargs);
	READ_NODE_FIELD(args);
	READ_NODE_FIELD(aggorder);
	READ_NODE_FIELD(aggdistinct);
	READ_NODE_FIELD(aggfilter);
	READ_BOOL_FIELD(aggstar);
	READ_BOOL_FIELD(aggvariadic);
	READ_CHAR_FIELD(aggkind);
	READ_BOOL_FIELD(aggpresorted);
	READ_UINT_FIELD(agglevelsup);
	READ_ENUM_FIELD(aggsplit, AggSplit);
	READ_INT_FIELD(aggno);
	READ_INT_FIELD(aggtransno);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static GroupingFunc *
_readGroupingFunc(void)
{
	READ_LOCALS(GroupingFunc);

	READ_NODE_FIELD(args);
	READ_NODE_FIELD(refs);
	READ_NODE_FIELD(cols);
	READ_UINT_FIELD(agglevelsup);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static WindowFunc *
_readWindowFunc(void)
{
	READ_LOCALS(WindowFunc);

	READ_OID_FIELD(winfnoid);
	READ_OID_FIELD(wintype);
	READ_OID_FIELD(wincollid);
	READ_OID_FIELD(inputcollid);
	READ_NODE_FIELD(args);
	READ_NODE_FIELD(aggfilter);
	READ_NODE_FIELD(runCondition);
	READ_UINT_FIELD(winref);
	READ_BOOL_FIELD(winstar);
	READ_BOOL_FIELD(winagg);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static WindowFuncRunCondition *
_readWindowFuncRunCondition(void)
{
	READ_LOCALS(WindowFuncRunCondition);

	READ_OID_FIELD(opno);
	READ_OID_FIELD(inputcollid);
	READ_BOOL_FIELD(wfunc_left);
	READ_NODE_FIELD(arg);

	READ_DONE();
}

static MergeSupportFunc *
_readMergeSupportFunc(void)
{
	READ_LOCALS(MergeSupportFunc);

	READ_OID_FIELD(msftype);
	READ_OID_FIELD(msfcollid);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static SubscriptingRef *
_readSubscriptingRef(void)
{
	READ_LOCALS(SubscriptingRef);

	READ_OID_FIELD(refcontainertype);
	READ_OID_FIELD(refelemtype);
	READ_OID_FIELD(refrestype);
	READ_INT_FIELD(reftypmod);
	READ_OID_FIELD(refcollid);
	READ_NODE_FIELD(refupperindexpr);
	READ_NODE_FIELD(reflowerindexpr);
	READ_NODE_FIELD(refexpr);
	READ_NODE_FIELD(refassgnexpr);

	READ_DONE();
}

static FuncExpr *
_readFuncExpr(void)
{
	READ_LOCALS(FuncExpr);

	READ_OID_FIELD(funcid);
	READ_OID_FIELD(funcresulttype);
	READ_BOOL_FIELD(funcretset);
	READ_BOOL_FIELD(funcvariadic);
	READ_ENUM_FIELD(funcformat, CoercionForm);
	READ_OID_FIELD(funccollid);
	READ_OID_FIELD(inputcollid);
	READ_NODE_FIELD(args);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static NamedArgExpr *
_readNamedArgExpr(void)
{
	READ_LOCALS(NamedArgExpr);

	READ_NODE_FIELD(arg);
	READ_STRING_FIELD(name);
	READ_INT_FIELD(argnumber);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static OpExpr *
_readOpExpr(void)
{
	READ_LOCALS(OpExpr);

	READ_OID_FIELD(opno);
	READ_OID_FIELD(opfuncid);
	READ_OID_FIELD(opresulttype);
	READ_BOOL_FIELD(opretset);
	READ_OID_FIELD(opcollid);
	READ_OID_FIELD(inputcollid);
	READ_NODE_FIELD(args);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static DistinctExpr *
_readDistinctExpr(void)
{
	READ_LOCALS(DistinctExpr);

	READ_OID_FIELD(opno);
	READ_OID_FIELD(opfuncid);
	READ_OID_FIELD(opresulttype);
	READ_BOOL_FIELD(opretset);
	READ_OID_FIELD(opcollid);
	READ_OID_FIELD(inputcollid);
	READ_NODE_FIELD(args);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static NullIfExpr *
_readNullIfExpr(void)
{
	READ_LOCALS(NullIfExpr);

	READ_OID_FIELD(opno);
	READ_OID_FIELD(opfuncid);
	READ_OID_FIELD(opresulttype);
	READ_BOOL_FIELD(opretset);
	READ_OID_FIELD(opcollid);
	READ_OID_FIELD(inputcollid);
	READ_NODE_FIELD(args);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static ScalarArrayOpExpr *
_readScalarArrayOpExpr(void)
{
	READ_LOCALS(ScalarArrayOpExpr);

	READ_OID_FIELD(opno);
	READ_OID_FIELD(opfuncid);
	READ_OID_FIELD(hashfuncid);
	READ_OID_FIELD(negfuncid);
	READ_BOOL_FIELD(useOr);
	READ_OID_FIELD(inputcollid);
	READ_NODE_FIELD(args);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static SubLink *
_readSubLink(void)
{
	READ_LOCALS(SubLink);

	READ_ENUM_FIELD(subLinkType, SubLinkType);
	READ_INT_FIELD(subLinkId);
	READ_NODE_FIELD(testexpr);
	READ_NODE_FIELD(operName);
	READ_NODE_FIELD(subselect);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static SubPlan *
_readSubPlan(void)
{
	READ_LOCALS(SubPlan);

	READ_ENUM_FIELD(subLinkType, SubLinkType);
	READ_NODE_FIELD(testexpr);
	READ_NODE_FIELD(paramIds);
	READ_INT_FIELD(plan_id);
	READ_STRING_FIELD(plan_name);
	READ_OID_FIELD(firstColType);
	READ_INT_FIELD(firstColTypmod);
	READ_OID_FIELD(firstColCollation);
	READ_BOOL_FIELD(useHashTable);
	READ_BOOL_FIELD(unknownEqFalse);
	READ_BOOL_FIELD(parallel_safe);
	READ_NODE_FIELD(setParam);
	READ_NODE_FIELD(parParam);
	READ_NODE_FIELD(args);
	READ_FLOAT_FIELD(startup_cost);
	READ_FLOAT_FIELD(per_call_cost);

	READ_DONE();
}

static AlternativeSubPlan *
_readAlternativeSubPlan(void)
{
	READ_LOCALS(AlternativeSubPlan);

	READ_NODE_FIELD(subplans);

	READ_DONE();
}

static FieldSelect *
_readFieldSelect(void)
{
	READ_LOCALS(FieldSelect);

	READ_NODE_FIELD(arg);
	READ_INT_FIELD(fieldnum);
	READ_OID_FIELD(resulttype);
	READ_INT_FIELD(resulttypmod);
	READ_OID_FIELD(resultcollid);

	READ_DONE();
}

static FieldStore *
_readFieldStore(void)
{
	READ_LOCALS(FieldStore);

	READ_NODE_FIELD(arg);
	READ_NODE_FIELD(newvals);
	READ_NODE_FIELD(fieldnums);
	READ_OID_FIELD(resulttype);

	READ_DONE();
}

static RelabelType *
_readRelabelType(void)
{
	READ_LOCALS(RelabelType);

	READ_NODE_FIELD(arg);
	READ_OID_FIELD(resulttype);
	READ_INT_FIELD(resulttypmod);
	READ_OID_FIELD(resultcollid);
	READ_ENUM_FIELD(relabelformat, CoercionForm);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static CoerceViaIO *
_readCoerceViaIO(void)
{
	READ_LOCALS(CoerceViaIO);

	READ_NODE_FIELD(arg);
	READ_OID_FIELD(resulttype);
	READ_OID_FIELD(resultcollid);
	READ_ENUM_FIELD(coerceformat, CoercionForm);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static ArrayCoerceExpr *
_readArrayCoerceExpr(void)
{
	READ_LOCALS(ArrayCoerceExpr);

	READ_NODE_FIELD(arg);
	READ_NODE_FIELD(elemexpr);
	READ_OID_FIELD(resulttype);
	READ_INT_FIELD(resulttypmod);
	READ_OID_FIELD(resultcollid);
	READ_ENUM_FIELD(coerceformat, CoercionForm);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static ConvertRowtypeExpr *
_readConvertRowtypeExpr(void)
{
	READ_LOCALS(ConvertRowtypeExpr);

	READ_NODE_FIELD(arg);
	READ_OID_FIELD(resulttype);
	READ_ENUM_FIELD(convertformat, CoercionForm);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static CollateExpr *
_readCollateExpr(void)
{
	READ_LOCALS(CollateExpr);

	READ_NODE_FIELD(arg);
	READ_OID_FIELD(collOid);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static CaseExpr *
_readCaseExpr(void)
{
	READ_LOCALS(CaseExpr);

	READ_OID_FIELD(casetype);
	READ_OID_FIELD(casecollid);
	READ_NODE_FIELD(arg);
	READ_NODE_FIELD(args);
	READ_NODE_FIELD(defresult);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static CaseWhen *
_readCaseWhen(void)
{
	READ_LOCALS(CaseWhen);

	READ_NODE_FIELD(expr);
	READ_NODE_FIELD(result);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static CaseTestExpr *
_readCaseTestExpr(void)
{
	READ_LOCALS(CaseTestExpr);

	READ_OID_FIELD(typeId);
	READ_INT_FIELD(typeMod);
	READ_OID_FIELD(collation);

	READ_DONE();
}

static ArrayExpr *
_readArrayExpr(void)
{
	READ_LOCALS(ArrayExpr);

	READ_OID_FIELD(array_typeid);
	READ_OID_FIELD(array_collid);
	READ_OID_FIELD(element_typeid);
	READ_NODE_FIELD(elements);
	READ_BOOL_FIELD(multidims);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static RowExpr *
_readRowExpr(void)
{
	READ_LOCALS(RowExpr);

	READ_NODE_FIELD(args);
	READ_OID_FIELD(row_typeid);
	READ_ENUM_FIELD(row_format, CoercionForm);
	READ_NODE_FIELD(colnames);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static RowCompareExpr *
_readRowCompareExpr(void)
{
	READ_LOCALS(RowCompareExpr);

	READ_ENUM_FIELD(rctype, RowCompareType);
	READ_NODE_FIELD(opnos);
	READ_NODE_FIELD(opfamilies);
	READ_NODE_FIELD(inputcollids);
	READ_NODE_FIELD(largs);
	READ_NODE_FIELD(rargs);

	READ_DONE();
}

static CoalesceExpr *
_readCoalesceExpr(void)
{
	READ_LOCALS(CoalesceExpr);

	READ_OID_FIELD(coalescetype);
	READ_OID_FIELD(coalescecollid);
	READ_NODE_FIELD(args);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static MinMaxExpr *
_readMinMaxExpr(void)
{
	READ_LOCALS(MinMaxExpr);

	READ_OID_FIELD(minmaxtype);
	READ_OID_FIELD(minmaxcollid);
	READ_OID_FIELD(inputcollid);
	READ_ENUM_FIELD(op, MinMaxOp);
	READ_NODE_FIELD(args);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static SQLValueFunction *
_readSQLValueFunction(void)
{
	READ_LOCALS(SQLValueFunction);

	READ_ENUM_FIELD(op, SQLValueFunctionOp);
	READ_OID_FIELD(type);
	READ_INT_FIELD(typmod);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static XmlExpr *
_readXmlExpr(void)
{
	READ_LOCALS(XmlExpr);

	READ_ENUM_FIELD(op, XmlExprOp);
	READ_STRING_FIELD(name);
	READ_NODE_FIELD(named_args);
	READ_NODE_FIELD(arg_names);
	READ_NODE_FIELD(args);
	READ_ENUM_FIELD(xmloption, XmlOptionType);
	READ_BOOL_FIELD(indent);
	READ_OID_FIELD(type);
	READ_INT_FIELD(typmod);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonFormat *
_readJsonFormat(void)
{
	READ_LOCALS(JsonFormat);

	READ_ENUM_FIELD(format_type, JsonFormatType);
	READ_ENUM_FIELD(encoding, JsonEncoding);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonReturning *
_readJsonReturning(void)
{
	READ_LOCALS(JsonReturning);

	READ_NODE_FIELD(format);
	READ_OID_FIELD(typid);
	READ_INT_FIELD(typmod);

	READ_DONE();
}

static JsonValueExpr *
_readJsonValueExpr(void)
{
	READ_LOCALS(JsonValueExpr);

	READ_NODE_FIELD(raw_expr);
	READ_NODE_FIELD(formatted_expr);
	READ_NODE_FIELD(format);

	READ_DONE();
}

static JsonConstructorExpr *
_readJsonConstructorExpr(void)
{
	READ_LOCALS(JsonConstructorExpr);

	READ_ENUM_FIELD(type, JsonConstructorType);
	READ_NODE_FIELD(args);
	READ_NODE_FIELD(func);
	READ_NODE_FIELD(coercion);
	READ_NODE_FIELD(returning);
	READ_BOOL_FIELD(absent_on_null);
	READ_BOOL_FIELD(unique);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonIsPredicate *
_readJsonIsPredicate(void)
{
	READ_LOCALS(JsonIsPredicate);

	READ_NODE_FIELD(expr);
	READ_NODE_FIELD(format);
	READ_ENUM_FIELD(item_type, JsonValueType);
	READ_BOOL_FIELD(unique_keys);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonBehavior *
_readJsonBehavior(void)
{
	READ_LOCALS(JsonBehavior);

	READ_ENUM_FIELD(btype, JsonBehaviorType);
	READ_NODE_FIELD(expr);
	READ_BOOL_FIELD(coerce);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonExpr *
_readJsonExpr(void)
{
	READ_LOCALS(JsonExpr);

	READ_ENUM_FIELD(op, JsonExprOp);
	READ_STRING_FIELD(column_name);
	READ_NODE_FIELD(formatted_expr);
	READ_NODE_FIELD(format);
	READ_NODE_FIELD(path_spec);
	READ_NODE_FIELD(returning);
	READ_NODE_FIELD(passing_names);
	READ_NODE_FIELD(passing_values);
	READ_NODE_FIELD(on_empty);
	READ_NODE_FIELD(on_error);
	READ_BOOL_FIELD(use_io_coercion);
	READ_BOOL_FIELD(use_json_coercion);
	READ_ENUM_FIELD(wrapper, JsonWrapper);
	READ_BOOL_FIELD(omit_quotes);
	READ_OID_FIELD(collation);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonTablePath *
_readJsonTablePath(void)
{
	READ_LOCALS(JsonTablePath);

	READ_NODE_FIELD(value);
	READ_STRING_FIELD(name);

	READ_DONE();
}

static JsonTablePathScan *
_readJsonTablePathScan(void)
{
	READ_LOCALS(JsonTablePathScan);

	READ_NODE_FIELD(path);
	READ_BOOL_FIELD(errorOnError);
	READ_NODE_FIELD(child);
	READ_INT_FIELD(colMin);
	READ_INT_FIELD(colMax);

	READ_DONE();
}

static JsonTableSiblingJoin *
_readJsonTableSiblingJoin(void)
{
	READ_LOCALS(JsonTableSiblingJoin);

	READ_NODE_FIELD(lplan);
	READ_NODE_FIELD(rplan);

	READ_DONE();
}

static NullTest *
_readNullTest(void)
{
	READ_LOCALS(NullTest);

	READ_NODE_FIELD(arg);
	READ_ENUM_FIELD(nulltesttype, NullTestType);
	READ_BOOL_FIELD(argisrow);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static BooleanTest *
_readBooleanTest(void)
{
	READ_LOCALS(BooleanTest);

	READ_NODE_FIELD(arg);
	READ_ENUM_FIELD(booltesttype, BoolTestType);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static MergeAction *
_readMergeAction(void)
{
	READ_LOCALS(MergeAction);

	READ_ENUM_FIELD(matchKind, MergeMatchKind);
	READ_ENUM_FIELD(commandType, CmdType);
	READ_ENUM_FIELD(override, OverridingKind);
	READ_NODE_FIELD(qual);
	READ_NODE_FIELD(targetList);
	READ_NODE_FIELD(updateColnos);

	READ_DONE();
}

static CoerceToDomain *
_readCoerceToDomain(void)
{
	READ_LOCALS(CoerceToDomain);

	READ_NODE_FIELD(arg);
	READ_OID_FIELD(resulttype);
	READ_INT_FIELD(resulttypmod);
	READ_OID_FIELD(resultcollid);
	READ_ENUM_FIELD(coercionformat, CoercionForm);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static CoerceToDomainValue *
_readCoerceToDomainValue(void)
{
	READ_LOCALS(CoerceToDomainValue);

	READ_OID_FIELD(typeId);
	READ_INT_FIELD(typeMod);
	READ_OID_FIELD(collation);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static SetToDefault *
_readSetToDefault(void)
{
	READ_LOCALS(SetToDefault);

	READ_OID_FIELD(typeId);
	READ_INT_FIELD(typeMod);
	READ_OID_FIELD(collation);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static CurrentOfExpr *
_readCurrentOfExpr(void)
{
	READ_LOCALS(CurrentOfExpr);

	READ_UINT_FIELD(cvarno);
	READ_STRING_FIELD(cursor_name);
	READ_INT_FIELD(cursor_param);

	READ_DONE();
}

static NextValueExpr *
_readNextValueExpr(void)
{
	READ_LOCALS(NextValueExpr);

	READ_OID_FIELD(seqid);
	READ_OID_FIELD(typeId);

	READ_DONE();
}

static InferenceElem *
_readInferenceElem(void)
{
	READ_LOCALS(InferenceElem);

	READ_NODE_FIELD(expr);
	READ_OID_FIELD(infercollid);
	READ_OID_FIELD(inferopclass);

	READ_DONE();
}

static TargetEntry *
_readTargetEntry(void)
{
	READ_LOCALS(TargetEntry);

	READ_NODE_FIELD(expr);
	READ_INT_FIELD(resno);
	READ_STRING_FIELD(resname);
	READ_UINT_FIELD(ressortgroupref);
	READ_OID_FIELD(resorigtbl);
	READ_INT_FIELD(resorigcol);
	READ_BOOL_FIELD(resjunk);

	READ_DONE();
}

static RangeTblRef *
_readRangeTblRef(void)
{
	READ_LOCALS(RangeTblRef);

	READ_INT_FIELD(rtindex);

	READ_DONE();
}

static JoinExpr *
_readJoinExpr(void)
{
	READ_LOCALS(JoinExpr);

	READ_ENUM_FIELD(jointype, JoinType);
	READ_BOOL_FIELD(isNatural);
	READ_NODE_FIELD(larg);
	READ_NODE_FIELD(rarg);
	READ_NODE_FIELD(usingClause);
	READ_NODE_FIELD(join_using_alias);
	READ_NODE_FIELD(quals);
	READ_NODE_FIELD(alias);
	READ_INT_FIELD(rtindex);

	READ_DONE();
}

static FromExpr *
_readFromExpr(void)
{
	READ_LOCALS(FromExpr);

	READ_NODE_FIELD(fromlist);
	READ_NODE_FIELD(quals);

	READ_DONE();
}

static OnConflictExpr *
_readOnConflictExpr(void)
{
	READ_LOCALS(OnConflictExpr);

	READ_ENUM_FIELD(action, OnConflictAction);
	READ_NODE_FIELD(arbiterElems);
	READ_NODE_FIELD(arbiterWhere);
	READ_OID_FIELD(constraint);
	READ_NODE_FIELD(onConflictSet);
	READ_NODE_FIELD(onConflictWhere);
	READ_INT_FIELD(exclRelIndex);
	READ_NODE_FIELD(exclRelTlist);

	READ_DONE();
}

static Query *
_readQuery(void)
{
	READ_LOCALS(Query);

	READ_ENUM_FIELD(commandType, CmdType);
	READ_ENUM_FIELD(querySource, QuerySource);
	local_node->queryId = 0;
	READ_BOOL_FIELD(canSetTag);
	READ_NODE_FIELD(utilityStmt);
	READ_INT_FIELD(resultRelation);
	READ_BOOL_FIELD(hasAggs);
	READ_BOOL_FIELD(hasWindowFuncs);
	READ_BOOL_FIELD(hasTargetSRFs);
	READ_BOOL_FIELD(hasSubLinks);
	READ_BOOL_FIELD(hasDistinctOn);
	READ_BOOL_FIELD(hasRecursive);
	READ_BOOL_FIELD(hasModifyingCTE);
	READ_BOOL_FIELD(hasForUpdate);
	READ_BOOL_FIELD(hasRowSecurity);
	READ_BOOL_FIELD(isReturn);
	READ_NODE_FIELD(cteList);
	READ_NODE_FIELD(rtable);
	READ_NODE_FIELD(rteperminfos);
	READ_NODE_FIELD(jointree);
	READ_NODE_FIELD(mergeActionList);
	READ_INT_FIELD(mergeTargetRelation);
	READ_NODE_FIELD(mergeJoinCondition);
	READ_NODE_FIELD(targetList);
	READ_ENUM_FIELD(override, OverridingKind);
	READ_NODE_FIELD(onConflict);
	READ_NODE_FIELD(returningList);
	READ_NODE_FIELD(groupClause);
	READ_BOOL_FIELD(groupDistinct);
	READ_NODE_FIELD(groupingSets);
	READ_NODE_FIELD(havingQual);
	READ_NODE_FIELD(windowClause);
	READ_NODE_FIELD(distinctClause);
	READ_NODE_FIELD(sortClause);
	READ_NODE_FIELD(limitOffset);
	READ_NODE_FIELD(limitCount);
	READ_ENUM_FIELD(limitOption, LimitOption);
	READ_NODE_FIELD(rowMarks);
	READ_NODE_FIELD(setOperations);
	READ_NODE_FIELD(constraintDeps);
	READ_NODE_FIELD(withCheckOptions);
	READ_LOCATION_FIELD(stmt_location);
	READ_LOCATION_FIELD(stmt_len);

	READ_DONE();
}

static TypeName *
_readTypeName(void)
{
	READ_LOCALS(TypeName);

	READ_NODE_FIELD(names);
	READ_OID_FIELD(typeOid);
	READ_BOOL_FIELD(setof);
	READ_BOOL_FIELD(pct_type);
	READ_NODE_FIELD(typmods);
	READ_INT_FIELD(typemod);
	READ_NODE_FIELD(arrayBounds);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static ColumnRef *
_readColumnRef(void)
{
	READ_LOCALS(ColumnRef);

	READ_NODE_FIELD(fields);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static ParamRef *
_readParamRef(void)
{
	READ_LOCALS(ParamRef);

	READ_INT_FIELD(number);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static TypeCast *
_readTypeCast(void)
{
	READ_LOCALS(TypeCast);

	READ_NODE_FIELD(arg);
	READ_NODE_FIELD(typeName);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static CollateClause *
_readCollateClause(void)
{
	READ_LOCALS(CollateClause);

	READ_NODE_FIELD(arg);
	READ_NODE_FIELD(collname);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static RoleSpec *
_readRoleSpec(void)
{
	READ_LOCALS(RoleSpec);

	READ_ENUM_FIELD(roletype, RoleSpecType);
	READ_STRING_FIELD(rolename);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static FuncCall *
_readFuncCall(void)
{
	READ_LOCALS(FuncCall);

	READ_NODE_FIELD(funcname);
	READ_NODE_FIELD(args);
	READ_NODE_FIELD(agg_order);
	READ_NODE_FIELD(agg_filter);
	READ_NODE_FIELD(over);
	READ_BOOL_FIELD(agg_within_group);
	READ_BOOL_FIELD(agg_star);
	READ_BOOL_FIELD(agg_distinct);
	READ_BOOL_FIELD(func_variadic);
	READ_ENUM_FIELD(funcformat, CoercionForm);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static A_Star *
_readA_Star(void)
{
	READ_LOCALS_NO_FIELDS(A_Star);


	READ_DONE();
}

static A_Indices *
_readA_Indices(void)
{
	READ_LOCALS(A_Indices);

	READ_BOOL_FIELD(is_slice);
	READ_NODE_FIELD(lidx);
	READ_NODE_FIELD(uidx);

	READ_DONE();
}

static A_Indirection *
_readA_Indirection(void)
{
	READ_LOCALS(A_Indirection);

	READ_NODE_FIELD(arg);
	READ_NODE_FIELD(indirection);

	READ_DONE();
}

static A_ArrayExpr *
_readA_ArrayExpr(void)
{
	READ_LOCALS(A_ArrayExpr);

	READ_NODE_FIELD(elements);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static ResTarget *
_readResTarget(void)
{
	READ_LOCALS(ResTarget);

	READ_STRING_FIELD(name);
	READ_NODE_FIELD(indirection);
	READ_NODE_FIELD(val);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static MultiAssignRef *
_readMultiAssignRef(void)
{
	READ_LOCALS(MultiAssignRef);

	READ_NODE_FIELD(source);
	READ_INT_FIELD(colno);
	READ_INT_FIELD(ncolumns);

	READ_DONE();
}

static SortBy *
_readSortBy(void)
{
	READ_LOCALS(SortBy);

	READ_NODE_FIELD(node);
	READ_ENUM_FIELD(sortby_dir, SortByDir);
	READ_ENUM_FIELD(sortby_nulls, SortByNulls);
	READ_NODE_FIELD(useOp);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static WindowDef *
_readWindowDef(void)
{
	READ_LOCALS(WindowDef);

	READ_STRING_FIELD(name);
	READ_STRING_FIELD(refname);
	READ_NODE_FIELD(partitionClause);
	READ_NODE_FIELD(orderClause);
	READ_INT_FIELD(frameOptions);
	READ_NODE_FIELD(startOffset);
	READ_NODE_FIELD(endOffset);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static RangeSubselect *
_readRangeSubselect(void)
{
	READ_LOCALS(RangeSubselect);

	READ_BOOL_FIELD(lateral);
	READ_NODE_FIELD(subquery);
	READ_NODE_FIELD(alias);

	READ_DONE();
}

static RangeFunction *
_readRangeFunction(void)
{
	READ_LOCALS(RangeFunction);

	READ_BOOL_FIELD(lateral);
	READ_BOOL_FIELD(ordinality);
	READ_BOOL_FIELD(is_rowsfrom);
	READ_NODE_FIELD(functions);
	READ_NODE_FIELD(alias);
	READ_NODE_FIELD(coldeflist);

	READ_DONE();
}

static RangeTableFunc *
_readRangeTableFunc(void)
{
	READ_LOCALS(RangeTableFunc);

	READ_BOOL_FIELD(lateral);
	READ_NODE_FIELD(docexpr);
	READ_NODE_FIELD(rowexpr);
	READ_NODE_FIELD(namespaces);
	READ_NODE_FIELD(columns);
	READ_NODE_FIELD(alias);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static RangeTableFuncCol *
_readRangeTableFuncCol(void)
{
	READ_LOCALS(RangeTableFuncCol);

	READ_STRING_FIELD(colname);
	READ_NODE_FIELD(typeName);
	READ_BOOL_FIELD(for_ordinality);
	READ_BOOL_FIELD(is_not_null);
	READ_NODE_FIELD(colexpr);
	READ_NODE_FIELD(coldefexpr);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static RangeTableSample *
_readRangeTableSample(void)
{
	READ_LOCALS(RangeTableSample);

	READ_NODE_FIELD(relation);
	READ_NODE_FIELD(method);
	READ_NODE_FIELD(args);
	READ_NODE_FIELD(repeatable);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static ColumnDef *
_readColumnDef(void)
{
	READ_LOCALS(ColumnDef);

	READ_STRING_FIELD(colname);
	READ_NODE_FIELD(typeName);
	READ_STRING_FIELD(compression);
	READ_INT_FIELD(inhcount);
	READ_BOOL_FIELD(is_local);
	READ_BOOL_FIELD(is_not_null);
	READ_BOOL_FIELD(is_from_type);
	READ_CHAR_FIELD(storage);
	READ_STRING_FIELD(storage_name);
	READ_NODE_FIELD(raw_default);
	READ_NODE_FIELD(cooked_default);
	READ_CHAR_FIELD(identity);
	READ_NODE_FIELD(identitySequence);
	READ_CHAR_FIELD(generated);
	READ_NODE_FIELD(collClause);
	READ_OID_FIELD(collOid);
	READ_NODE_FIELD(constraints);
	READ_NODE_FIELD(fdwoptions);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static TableLikeClause *
_readTableLikeClause(void)
{
	READ_LOCALS(TableLikeClause);

	READ_NODE_FIELD(relation);
	READ_UINT_FIELD(options);
	READ_OID_FIELD(relationOid);

	READ_DONE();
}

static IndexElem *
_readIndexElem(void)
{
	READ_LOCALS(IndexElem);

	READ_STRING_FIELD(name);
	READ_NODE_FIELD(expr);
	READ_STRING_FIELD(indexcolname);
	READ_NODE_FIELD(collation);
	READ_NODE_FIELD(opclass);
	READ_NODE_FIELD(opclassopts);
	READ_ENUM_FIELD(ordering, SortByDir);
	READ_ENUM_FIELD(nulls_ordering, SortByNulls);

	READ_DONE();
}

static DefElem *
_readDefElem(void)
{
	READ_LOCALS(DefElem);

	READ_STRING_FIELD(defnamespace);
	READ_STRING_FIELD(defname);
	READ_NODE_FIELD(arg);
	READ_ENUM_FIELD(defaction, DefElemAction);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static LockingClause *
_readLockingClause(void)
{
	READ_LOCALS(LockingClause);

	READ_NODE_FIELD(lockedRels);
	READ_ENUM_FIELD(strength, LockClauseStrength);
	READ_ENUM_FIELD(waitPolicy, LockWaitPolicy);

	READ_DONE();
}

static XmlSerialize *
_readXmlSerialize(void)
{
	READ_LOCALS(XmlSerialize);

	READ_ENUM_FIELD(xmloption, XmlOptionType);
	READ_NODE_FIELD(expr);
	READ_NODE_FIELD(typeName);
	READ_BOOL_FIELD(indent);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static PartitionElem *
_readPartitionElem(void)
{
	READ_LOCALS(PartitionElem);

	READ_STRING_FIELD(name);
	READ_NODE_FIELD(expr);
	READ_NODE_FIELD(collation);
	READ_NODE_FIELD(opclass);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static PartitionSpec *
_readPartitionSpec(void)
{
	READ_LOCALS(PartitionSpec);

	READ_ENUM_FIELD(strategy, PartitionStrategy);
	READ_NODE_FIELD(partParams);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static PartitionBoundSpec *
_readPartitionBoundSpec(void)
{
	READ_LOCALS(PartitionBoundSpec);

	READ_CHAR_FIELD(strategy);
	READ_BOOL_FIELD(is_default);
	READ_INT_FIELD(modulus);
	READ_INT_FIELD(remainder);
	READ_NODE_FIELD(listdatums);
	READ_NODE_FIELD(lowerdatums);
	READ_NODE_FIELD(upperdatums);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static PartitionRangeDatum *
_readPartitionRangeDatum(void)
{
	READ_LOCALS(PartitionRangeDatum);

	READ_ENUM_FIELD(kind, PartitionRangeDatumKind);
	READ_NODE_FIELD(value);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static SinglePartitionSpec *
_readSinglePartitionSpec(void)
{
	READ_LOCALS_NO_FIELDS(SinglePartitionSpec);


	READ_DONE();
}

static PartitionCmd *
_readPartitionCmd(void)
{
	READ_LOCALS(PartitionCmd);

	READ_NODE_FIELD(name);
	READ_NODE_FIELD(bound);
	READ_BOOL_FIELD(concurrent);

	READ_DONE();
}

static RTEPermissionInfo *
_readRTEPermissionInfo(void)
{
	READ_LOCALS(RTEPermissionInfo);

	READ_OID_FIELD(relid);
	READ_BOOL_FIELD(inh);
	READ_UINT64_FIELD(requiredPerms);
	READ_OID_FIELD(checkAsUser);
	READ_BITMAPSET_FIELD(selectedCols);
	READ_BITMAPSET_FIELD(insertedCols);
	READ_BITMAPSET_FIELD(updatedCols);

	READ_DONE();
}

static RangeTblFunction *
_readRangeTblFunction(void)
{
	READ_LOCALS(RangeTblFunction);

	READ_NODE_FIELD(funcexpr);
	READ_INT_FIELD(funccolcount);
	READ_NODE_FIELD(funccolnames);
	READ_NODE_FIELD(funccoltypes);
	READ_NODE_FIELD(funccoltypmods);
	READ_NODE_FIELD(funccolcollations);
	READ_BITMAPSET_FIELD(funcparams);

	READ_DONE();
}

static TableSampleClause *
_readTableSampleClause(void)
{
	READ_LOCALS(TableSampleClause);

	READ_OID_FIELD(tsmhandler);
	READ_NODE_FIELD(args);
	READ_NODE_FIELD(repeatable);

	READ_DONE();
}

static WithCheckOption *
_readWithCheckOption(void)
{
	READ_LOCALS(WithCheckOption);

	READ_ENUM_FIELD(kind, WCOKind);
	READ_STRING_FIELD(relname);
	READ_STRING_FIELD(polname);
	READ_NODE_FIELD(qual);
	READ_BOOL_FIELD(cascaded);

	READ_DONE();
}

static SortGroupClause *
_readSortGroupClause(void)
{
	READ_LOCALS(SortGroupClause);

	READ_UINT_FIELD(tleSortGroupRef);
	READ_OID_FIELD(eqop);
	READ_OID_FIELD(sortop);
	READ_BOOL_FIELD(nulls_first);
	READ_BOOL_FIELD(hashable);

	READ_DONE();
}

static GroupingSet *
_readGroupingSet(void)
{
	READ_LOCALS(GroupingSet);

	READ_ENUM_FIELD(kind, GroupingSetKind);
	READ_NODE_FIELD(content);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static WindowClause *
_readWindowClause(void)
{
	READ_LOCALS(WindowClause);

	READ_STRING_FIELD(name);
	READ_STRING_FIELD(refname);
	READ_NODE_FIELD(partitionClause);
	READ_NODE_FIELD(orderClause);
	READ_INT_FIELD(frameOptions);
	READ_NODE_FIELD(startOffset);
	READ_NODE_FIELD(endOffset);
	READ_OID_FIELD(startInRangeFunc);
	READ_OID_FIELD(endInRangeFunc);
	READ_OID_FIELD(inRangeColl);
	READ_BOOL_FIELD(inRangeAsc);
	READ_BOOL_FIELD(inRangeNullsFirst);
	READ_UINT_FIELD(winref);
	READ_BOOL_FIELD(copiedOrder);

	READ_DONE();
}

static RowMarkClause *
_readRowMarkClause(void)
{
	READ_LOCALS(RowMarkClause);

	READ_UINT_FIELD(rti);
	READ_ENUM_FIELD(strength, LockClauseStrength);
	READ_ENUM_FIELD(waitPolicy, LockWaitPolicy);
	READ_BOOL_FIELD(pushedDown);

	READ_DONE();
}

static WithClause *
_readWithClause(void)
{
	READ_LOCALS(WithClause);

	READ_NODE_FIELD(ctes);
	READ_BOOL_FIELD(recursive);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static InferClause *
_readInferClause(void)
{
	READ_LOCALS(InferClause);

	READ_NODE_FIELD(indexElems);
	READ_NODE_FIELD(whereClause);
	READ_STRING_FIELD(conname);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static OnConflictClause *
_readOnConflictClause(void)
{
	READ_LOCALS(OnConflictClause);

	READ_ENUM_FIELD(action, OnConflictAction);
	READ_NODE_FIELD(infer);
	READ_NODE_FIELD(targetList);
	READ_NODE_FIELD(whereClause);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static CTESearchClause *
_readCTESearchClause(void)
{
	READ_LOCALS(CTESearchClause);

	READ_NODE_FIELD(search_col_list);
	READ_BOOL_FIELD(search_breadth_first);
	READ_STRING_FIELD(search_seq_column);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static CTECycleClause *
_readCTECycleClause(void)
{
	READ_LOCALS(CTECycleClause);

	READ_NODE_FIELD(cycle_col_list);
	READ_STRING_FIELD(cycle_mark_column);
	READ_NODE_FIELD(cycle_mark_value);
	READ_NODE_FIELD(cycle_mark_default);
	READ_STRING_FIELD(cycle_path_column);
	READ_LOCATION_FIELD(location);
	READ_OID_FIELD(cycle_mark_type);
	READ_INT_FIELD(cycle_mark_typmod);
	READ_OID_FIELD(cycle_mark_collation);
	READ_OID_FIELD(cycle_mark_neop);

	READ_DONE();
}

static CommonTableExpr *
_readCommonTableExpr(void)
{
	READ_LOCALS(CommonTableExpr);

	READ_STRING_FIELD(ctename);
	READ_NODE_FIELD(aliascolnames);
	READ_ENUM_FIELD(ctematerialized, CTEMaterialize);
	READ_NODE_FIELD(ctequery);
	READ_NODE_FIELD(search_clause);
	READ_NODE_FIELD(cycle_clause);
	READ_LOCATION_FIELD(location);
	READ_BOOL_FIELD(cterecursive);
	READ_INT_FIELD(cterefcount);
	READ_NODE_FIELD(ctecolnames);
	READ_NODE_FIELD(ctecoltypes);
	READ_NODE_FIELD(ctecoltypmods);
	READ_NODE_FIELD(ctecolcollations);

	READ_DONE();
}

static MergeWhenClause *
_readMergeWhenClause(void)
{
	READ_LOCALS(MergeWhenClause);

	READ_ENUM_FIELD(matchKind, MergeMatchKind);
	READ_ENUM_FIELD(commandType, CmdType);
	READ_ENUM_FIELD(override, OverridingKind);
	READ_NODE_FIELD(condition);
	READ_NODE_FIELD(targetList);
	READ_NODE_FIELD(values);

	READ_DONE();
}

static TriggerTransition *
_readTriggerTransition(void)
{
	READ_LOCALS(TriggerTransition);

	READ_STRING_FIELD(name);
	READ_BOOL_FIELD(isNew);
	READ_BOOL_FIELD(isTable);

	READ_DONE();
}

static JsonOutput *
_readJsonOutput(void)
{
	READ_LOCALS(JsonOutput);

	READ_NODE_FIELD(typeName);
	READ_NODE_FIELD(returning);

	READ_DONE();
}

static JsonArgument *
_readJsonArgument(void)
{
	READ_LOCALS(JsonArgument);

	READ_NODE_FIELD(val);
	READ_STRING_FIELD(name);

	READ_DONE();
}

static JsonFuncExpr *
_readJsonFuncExpr(void)
{
	READ_LOCALS(JsonFuncExpr);

	READ_ENUM_FIELD(op, JsonExprOp);
	READ_STRING_FIELD(column_name);
	READ_NODE_FIELD(context_item);
	READ_NODE_FIELD(pathspec);
	READ_NODE_FIELD(passing);
	READ_NODE_FIELD(output);
	READ_NODE_FIELD(on_empty);
	READ_NODE_FIELD(on_error);
	READ_ENUM_FIELD(wrapper, JsonWrapper);
	READ_ENUM_FIELD(quotes, JsonQuotes);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonTablePathSpec *
_readJsonTablePathSpec(void)
{
	READ_LOCALS(JsonTablePathSpec);

	READ_NODE_FIELD(string);
	READ_STRING_FIELD(name);
	READ_LOCATION_FIELD(name_location);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonTable *
_readJsonTable(void)
{
	READ_LOCALS(JsonTable);

	READ_NODE_FIELD(context_item);
	READ_NODE_FIELD(pathspec);
	READ_NODE_FIELD(passing);
	READ_NODE_FIELD(columns);
	READ_NODE_FIELD(on_error);
	READ_NODE_FIELD(alias);
	READ_BOOL_FIELD(lateral);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonTableColumn *
_readJsonTableColumn(void)
{
	READ_LOCALS(JsonTableColumn);

	READ_ENUM_FIELD(coltype, JsonTableColumnType);
	READ_STRING_FIELD(name);
	READ_NODE_FIELD(typeName);
	READ_NODE_FIELD(pathspec);
	READ_NODE_FIELD(format);
	READ_ENUM_FIELD(wrapper, JsonWrapper);
	READ_ENUM_FIELD(quotes, JsonQuotes);
	READ_NODE_FIELD(columns);
	READ_NODE_FIELD(on_empty);
	READ_NODE_FIELD(on_error);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonKeyValue *
_readJsonKeyValue(void)
{
	READ_LOCALS(JsonKeyValue);

	READ_NODE_FIELD(key);
	READ_NODE_FIELD(value);

	READ_DONE();
}

static JsonParseExpr *
_readJsonParseExpr(void)
{
	READ_LOCALS(JsonParseExpr);

	READ_NODE_FIELD(expr);
	READ_NODE_FIELD(output);
	READ_BOOL_FIELD(unique_keys);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonScalarExpr *
_readJsonScalarExpr(void)
{
	READ_LOCALS(JsonScalarExpr);

	READ_NODE_FIELD(expr);
	READ_NODE_FIELD(output);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonSerializeExpr *
_readJsonSerializeExpr(void)
{
	READ_LOCALS(JsonSerializeExpr);

	READ_NODE_FIELD(expr);
	READ_NODE_FIELD(output);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonObjectConstructor *
_readJsonObjectConstructor(void)
{
	READ_LOCALS(JsonObjectConstructor);

	READ_NODE_FIELD(exprs);
	READ_NODE_FIELD(output);
	READ_BOOL_FIELD(absent_on_null);
	READ_BOOL_FIELD(unique);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonArrayConstructor *
_readJsonArrayConstructor(void)
{
	READ_LOCALS(JsonArrayConstructor);

	READ_NODE_FIELD(exprs);
	READ_NODE_FIELD(output);
	READ_BOOL_FIELD(absent_on_null);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonArrayQueryConstructor *
_readJsonArrayQueryConstructor(void)
{
	READ_LOCALS(JsonArrayQueryConstructor);

	READ_NODE_FIELD(query);
	READ_NODE_FIELD(output);
	READ_NODE_FIELD(format);
	READ_BOOL_FIELD(absent_on_null);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonAggConstructor *
_readJsonAggConstructor(void)
{
	READ_LOCALS(JsonAggConstructor);

	READ_NODE_FIELD(output);
	READ_NODE_FIELD(agg_filter);
	READ_NODE_FIELD(agg_order);
	READ_NODE_FIELD(over);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static JsonObjectAgg *
_readJsonObjectAgg(void)
{
	READ_LOCALS(JsonObjectAgg);

	READ_NODE_FIELD(constructor);
	READ_NODE_FIELD(arg);
	READ_BOOL_FIELD(absent_on_null);
	READ_BOOL_FIELD(unique);

	READ_DONE();
}

static JsonArrayAgg *
_readJsonArrayAgg(void)
{
	READ_LOCALS(JsonArrayAgg);

	READ_NODE_FIELD(constructor);
	READ_NODE_FIELD(arg);
	READ_BOOL_FIELD(absent_on_null);

	READ_DONE();
}

static RawStmt *
_readRawStmt(void)
{
	READ_LOCALS(RawStmt);

	READ_NODE_FIELD(stmt);
	READ_LOCATION_FIELD(stmt_location);
	READ_LOCATION_FIELD(stmt_len);

	READ_DONE();
}

static InsertStmt *
_readInsertStmt(void)
{
	READ_LOCALS(InsertStmt);

	READ_NODE_FIELD(relation);
	READ_NODE_FIELD(cols);
	READ_NODE_FIELD(selectStmt);
	READ_NODE_FIELD(onConflictClause);
	READ_NODE_FIELD(returningList);
	READ_NODE_FIELD(withClause);
	READ_ENUM_FIELD(override, OverridingKind);

	READ_DONE();
}

static DeleteStmt *
_readDeleteStmt(void)
{
	READ_LOCALS(DeleteStmt);

	READ_NODE_FIELD(relation);
	READ_NODE_FIELD(usingClause);
	READ_NODE_FIELD(whereClause);
	READ_NODE_FIELD(returningList);
	READ_NODE_FIELD(withClause);

	READ_DONE();
}

static UpdateStmt *
_readUpdateStmt(void)
{
	READ_LOCALS(UpdateStmt);

	READ_NODE_FIELD(relation);
	READ_NODE_FIELD(targetList);
	READ_NODE_FIELD(whereClause);
	READ_NODE_FIELD(fromClause);
	READ_NODE_FIELD(returningList);
	READ_NODE_FIELD(withClause);

	READ_DONE();
}

static MergeStmt *
_readMergeStmt(void)
{
	READ_LOCALS(MergeStmt);

	READ_NODE_FIELD(relation);
	READ_NODE_FIELD(sourceRelation);
	READ_NODE_FIELD(joinCondition);
	READ_NODE_FIELD(mergeWhenClauses);
	READ_NODE_FIELD(returningList);
	READ_NODE_FIELD(withClause);

	READ_DONE();
}

static SelectStmt *
_readSelectStmt(void)
{
	READ_LOCALS(SelectStmt);

	READ_NODE_FIELD(distinctClause);
	READ_NODE_FIELD(intoClause);
	READ_NODE_FIELD(targetList);
	READ_NODE_FIELD(fromClause);
	READ_NODE_FIELD(whereClause);
	READ_NODE_FIELD(groupClause);
	READ_BOOL_FIELD(groupDistinct);
	READ_NODE_FIELD(havingClause);
	READ_NODE_FIELD(windowClause);
	READ_NODE_FIELD(valuesLists);
	READ_NODE_FIELD(sortClause);
	READ_NODE_FIELD(limitOffset);
	READ_NODE_FIELD(limitCount);
	READ_ENUM_FIELD(limitOption, LimitOption);
	READ_NODE_FIELD(lockingClause);
	READ_NODE_FIELD(withClause);
	READ_ENUM_FIELD(op, SetOperation);
	READ_BOOL_FIELD(all);
	READ_NODE_FIELD(larg);
	READ_NODE_FIELD(rarg);

	READ_DONE();
}

static SetOperationStmt *
_readSetOperationStmt(void)
{
	READ_LOCALS(SetOperationStmt);

	READ_ENUM_FIELD(op, SetOperation);
	READ_BOOL_FIELD(all);
	READ_NODE_FIELD(larg);
	READ_NODE_FIELD(rarg);
	READ_NODE_FIELD(colTypes);
	READ_NODE_FIELD(colTypmods);
	READ_NODE_FIELD(colCollations);
	READ_NODE_FIELD(groupClauses);

	READ_DONE();
}

static ReturnStmt *
_readReturnStmt(void)
{
	READ_LOCALS(ReturnStmt);

	READ_NODE_FIELD(returnval);

	READ_DONE();
}

static PLAssignStmt *
_readPLAssignStmt(void)
{
	READ_LOCALS(PLAssignStmt);

	READ_STRING_FIELD(name);
	READ_NODE_FIELD(indirection);
	READ_INT_FIELD(nnames);
	READ_NODE_FIELD(val);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static CreateSchemaStmt *
_readCreateSchemaStmt(void)
{
	READ_LOCALS(CreateSchemaStmt);

	READ_STRING_FIELD(schemaname);
	READ_NODE_FIELD(authrole);
	READ_NODE_FIELD(schemaElts);
	READ_BOOL_FIELD(if_not_exists);

	READ_DONE();
}

static AlterTableStmt *
_readAlterTableStmt(void)
{
	READ_LOCALS(AlterTableStmt);

	READ_NODE_FIELD(relation);
	READ_NODE_FIELD(cmds);
	READ_ENUM_FIELD(objtype, ObjectType);
	READ_BOOL_FIELD(missing_ok);

	READ_DONE();
}

static ReplicaIdentityStmt *
_readReplicaIdentityStmt(void)
{
	READ_LOCALS(ReplicaIdentityStmt);

	READ_CHAR_FIELD(identity_type);
	READ_STRING_FIELD(name);

	READ_DONE();
}

static AlterTableCmd *
_readAlterTableCmd(void)
{
	READ_LOCALS(AlterTableCmd);

	READ_ENUM_FIELD(subtype, AlterTableType);
	READ_STRING_FIELD(name);
	READ_INT_FIELD(num);
	READ_NODE_FIELD(newowner);
	READ_NODE_FIELD(def);
	READ_ENUM_FIELD(behavior, DropBehavior);
	READ_BOOL_FIELD(missing_ok);
	READ_BOOL_FIELD(recurse);

	READ_DONE();
}

static AlterCollationStmt *
_readAlterCollationStmt(void)
{
	READ_LOCALS(AlterCollationStmt);

	READ_NODE_FIELD(collname);

	READ_DONE();
}

static AlterDomainStmt *
_readAlterDomainStmt(void)
{
	READ_LOCALS(AlterDomainStmt);

	READ_CHAR_FIELD(subtype);
	READ_NODE_FIELD(typeName);
	READ_STRING_FIELD(name);
	READ_NODE_FIELD(def);
	READ_ENUM_FIELD(behavior, DropBehavior);
	READ_BOOL_FIELD(missing_ok);

	READ_DONE();
}

static GrantStmt *
_readGrantStmt(void)
{
	READ_LOCALS(GrantStmt);

	READ_BOOL_FIELD(is_grant);
	READ_ENUM_FIELD(targtype, GrantTargetType);
	READ_ENUM_FIELD(objtype, ObjectType);
	READ_NODE_FIELD(objects);
	READ_NODE_FIELD(privileges);
	READ_NODE_FIELD(grantees);
	READ_BOOL_FIELD(grant_option);
	READ_NODE_FIELD(grantor);
	READ_ENUM_FIELD(behavior, DropBehavior);

	READ_DONE();
}

static ObjectWithArgs *
_readObjectWithArgs(void)
{
	READ_LOCALS(ObjectWithArgs);

	READ_NODE_FIELD(objname);
	READ_NODE_FIELD(objargs);
	READ_NODE_FIELD(objfuncargs);
	READ_BOOL_FIELD(args_unspecified);

	READ_DONE();
}

static AccessPriv *
_readAccessPriv(void)
{
	READ_LOCALS(AccessPriv);

	READ_STRING_FIELD(priv_name);
	READ_NODE_FIELD(cols);

	READ_DONE();
}

static GrantRoleStmt *
_readGrantRoleStmt(void)
{
	READ_LOCALS(GrantRoleStmt);

	READ_NODE_FIELD(granted_roles);
	READ_NODE_FIELD(grantee_roles);
	READ_BOOL_FIELD(is_grant);
	READ_NODE_FIELD(opt);
	READ_NODE_FIELD(grantor);
	READ_ENUM_FIELD(behavior, DropBehavior);

	READ_DONE();
}

static AlterDefaultPrivilegesStmt *
_readAlterDefaultPrivilegesStmt(void)
{
	READ_LOCALS(AlterDefaultPrivilegesStmt);

	READ_NODE_FIELD(options);
	READ_NODE_FIELD(action);

	READ_DONE();
}

static CopyStmt *
_readCopyStmt(void)
{
	READ_LOCALS(CopyStmt);

	READ_NODE_FIELD(relation);
	READ_NODE_FIELD(query);
	READ_NODE_FIELD(attlist);
	READ_BOOL_FIELD(is_from);
	READ_BOOL_FIELD(is_program);
	READ_STRING_FIELD(filename);
	READ_NODE_FIELD(options);
	READ_NODE_FIELD(whereClause);

	READ_DONE();
}

static VariableSetStmt *
_readVariableSetStmt(void)
{
	READ_LOCALS(VariableSetStmt);

	READ_ENUM_FIELD(kind, VariableSetKind);
	READ_STRING_FIELD(name);
	READ_NODE_FIELD(args);
	READ_BOOL_FIELD(is_local);

	READ_DONE();
}

static VariableShowStmt *
_readVariableShowStmt(void)
{
	READ_LOCALS(VariableShowStmt);

	READ_STRING_FIELD(name);

	READ_DONE();
}

static CreateStmt *
_readCreateStmt(void)
{
	READ_LOCALS(CreateStmt);

	READ_NODE_FIELD(relation);
	READ_NODE_FIELD(tableElts);
	READ_NODE_FIELD(inhRelations);
	READ_NODE_FIELD(partbound);
	READ_NODE_FIELD(partspec);
	READ_NODE_FIELD(ofTypename);
	READ_NODE_FIELD(constraints);
	READ_NODE_FIELD(options);
	READ_ENUM_FIELD(oncommit, OnCommitAction);
	READ_STRING_FIELD(tablespacename);
	READ_STRING_FIELD(accessMethod);
	READ_BOOL_FIELD(if_not_exists);

	READ_DONE();
}

static Constraint *
_readConstraint(void)
{
	READ_LOCALS(Constraint);

	READ_ENUM_FIELD(contype, ConstrType);
	READ_STRING_FIELD(conname);
	READ_BOOL_FIELD(deferrable);
	READ_BOOL_FIELD(initdeferred);
	READ_BOOL_FIELD(skip_validation);
	READ_BOOL_FIELD(initially_valid);
	READ_BOOL_FIELD(is_no_inherit);
	READ_NODE_FIELD(raw_expr);
	READ_STRING_FIELD(cooked_expr);
	READ_CHAR_FIELD(generated_when);
	READ_INT_FIELD(inhcount);
	READ_BOOL_FIELD(nulls_not_distinct);
	READ_NODE_FIELD(keys);
	READ_NODE_FIELD(including);
	READ_NODE_FIELD(exclusions);
	READ_NODE_FIELD(options);
	READ_STRING_FIELD(indexname);
	READ_STRING_FIELD(indexspace);
	READ_BOOL_FIELD(reset_default_tblspc);
	READ_STRING_FIELD(access_method);
	READ_NODE_FIELD(where_clause);
	READ_NODE_FIELD(pktable);
	READ_NODE_FIELD(fk_attrs);
	READ_NODE_FIELD(pk_attrs);
	READ_CHAR_FIELD(fk_matchtype);
	READ_CHAR_FIELD(fk_upd_action);
	READ_CHAR_FIELD(fk_del_action);
	READ_NODE_FIELD(fk_del_set_cols);
	READ_NODE_FIELD(old_conpfeqop);
	READ_OID_FIELD(old_pktable_oid);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static CreateTableSpaceStmt *
_readCreateTableSpaceStmt(void)
{
	READ_LOCALS(CreateTableSpaceStmt);

	READ_STRING_FIELD(tablespacename);
	READ_NODE_FIELD(owner);
	READ_STRING_FIELD(location);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static DropTableSpaceStmt *
_readDropTableSpaceStmt(void)
{
	READ_LOCALS(DropTableSpaceStmt);

	READ_STRING_FIELD(tablespacename);
	READ_BOOL_FIELD(missing_ok);

	READ_DONE();
}

static AlterTableSpaceOptionsStmt *
_readAlterTableSpaceOptionsStmt(void)
{
	READ_LOCALS(AlterTableSpaceOptionsStmt);

	READ_STRING_FIELD(tablespacename);
	READ_NODE_FIELD(options);
	READ_BOOL_FIELD(isReset);

	READ_DONE();
}

static AlterTableMoveAllStmt *
_readAlterTableMoveAllStmt(void)
{
	READ_LOCALS(AlterTableMoveAllStmt);

	READ_STRING_FIELD(orig_tablespacename);
	READ_ENUM_FIELD(objtype, ObjectType);
	READ_NODE_FIELD(roles);
	READ_STRING_FIELD(new_tablespacename);
	READ_BOOL_FIELD(nowait);

	READ_DONE();
}

static CreateExtensionStmt *
_readCreateExtensionStmt(void)
{
	READ_LOCALS(CreateExtensionStmt);

	READ_STRING_FIELD(extname);
	READ_BOOL_FIELD(if_not_exists);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static AlterExtensionStmt *
_readAlterExtensionStmt(void)
{
	READ_LOCALS(AlterExtensionStmt);

	READ_STRING_FIELD(extname);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static AlterExtensionContentsStmt *
_readAlterExtensionContentsStmt(void)
{
	READ_LOCALS(AlterExtensionContentsStmt);

	READ_STRING_FIELD(extname);
	READ_INT_FIELD(action);
	READ_ENUM_FIELD(objtype, ObjectType);
	READ_NODE_FIELD(object);

	READ_DONE();
}

static CreateFdwStmt *
_readCreateFdwStmt(void)
{
	READ_LOCALS(CreateFdwStmt);

	READ_STRING_FIELD(fdwname);
	READ_NODE_FIELD(func_options);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static AlterFdwStmt *
_readAlterFdwStmt(void)
{
	READ_LOCALS(AlterFdwStmt);

	READ_STRING_FIELD(fdwname);
	READ_NODE_FIELD(func_options);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static CreateForeignServerStmt *
_readCreateForeignServerStmt(void)
{
	READ_LOCALS(CreateForeignServerStmt);

	READ_STRING_FIELD(servername);
	READ_STRING_FIELD(servertype);
	READ_STRING_FIELD(version);
	READ_STRING_FIELD(fdwname);
	READ_BOOL_FIELD(if_not_exists);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static AlterForeignServerStmt *
_readAlterForeignServerStmt(void)
{
	READ_LOCALS(AlterForeignServerStmt);

	READ_STRING_FIELD(servername);
	READ_STRING_FIELD(version);
	READ_NODE_FIELD(options);
	READ_BOOL_FIELD(has_version);

	READ_DONE();
}

static CreateForeignTableStmt *
_readCreateForeignTableStmt(void)
{
	READ_LOCALS(CreateForeignTableStmt);

	READ_NODE_FIELD(base.relation);
	READ_NODE_FIELD(base.tableElts);
	READ_NODE_FIELD(base.inhRelations);
	READ_NODE_FIELD(base.partbound);
	READ_NODE_FIELD(base.partspec);
	READ_NODE_FIELD(base.ofTypename);
	READ_NODE_FIELD(base.constraints);
	READ_NODE_FIELD(base.options);
	READ_ENUM_FIELD(base.oncommit, OnCommitAction);
	READ_STRING_FIELD(base.tablespacename);
	READ_STRING_FIELD(base.accessMethod);
	READ_BOOL_FIELD(base.if_not_exists);
	READ_STRING_FIELD(servername);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static CreateUserMappingStmt *
_readCreateUserMappingStmt(void)
{
	READ_LOCALS(CreateUserMappingStmt);

	READ_NODE_FIELD(user);
	READ_STRING_FIELD(servername);
	READ_BOOL_FIELD(if_not_exists);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static AlterUserMappingStmt *
_readAlterUserMappingStmt(void)
{
	READ_LOCALS(AlterUserMappingStmt);

	READ_NODE_FIELD(user);
	READ_STRING_FIELD(servername);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static DropUserMappingStmt *
_readDropUserMappingStmt(void)
{
	READ_LOCALS(DropUserMappingStmt);

	READ_NODE_FIELD(user);
	READ_STRING_FIELD(servername);
	READ_BOOL_FIELD(missing_ok);

	READ_DONE();
}

static ImportForeignSchemaStmt *
_readImportForeignSchemaStmt(void)
{
	READ_LOCALS(ImportForeignSchemaStmt);

	READ_STRING_FIELD(server_name);
	READ_STRING_FIELD(remote_schema);
	READ_STRING_FIELD(local_schema);
	READ_ENUM_FIELD(list_type, ImportForeignSchemaType);
	READ_NODE_FIELD(table_list);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static CreatePolicyStmt *
_readCreatePolicyStmt(void)
{
	READ_LOCALS(CreatePolicyStmt);

	READ_STRING_FIELD(policy_name);
	READ_NODE_FIELD(table);
	READ_STRING_FIELD(cmd_name);
	READ_BOOL_FIELD(permissive);
	READ_NODE_FIELD(roles);
	READ_NODE_FIELD(qual);
	READ_NODE_FIELD(with_check);

	READ_DONE();
}

static AlterPolicyStmt *
_readAlterPolicyStmt(void)
{
	READ_LOCALS(AlterPolicyStmt);

	READ_STRING_FIELD(policy_name);
	READ_NODE_FIELD(table);
	READ_NODE_FIELD(roles);
	READ_NODE_FIELD(qual);
	READ_NODE_FIELD(with_check);

	READ_DONE();
}

static CreateAmStmt *
_readCreateAmStmt(void)
{
	READ_LOCALS(CreateAmStmt);

	READ_STRING_FIELD(amname);
	READ_NODE_FIELD(handler_name);
	READ_CHAR_FIELD(amtype);

	READ_DONE();
}

static CreateTrigStmt *
_readCreateTrigStmt(void)
{
	READ_LOCALS(CreateTrigStmt);

	READ_BOOL_FIELD(replace);
	READ_BOOL_FIELD(isconstraint);
	READ_STRING_FIELD(trigname);
	READ_NODE_FIELD(relation);
	READ_NODE_FIELD(funcname);
	READ_NODE_FIELD(args);
	READ_BOOL_FIELD(row);
	READ_INT_FIELD(timing);
	READ_INT_FIELD(events);
	READ_NODE_FIELD(columns);
	READ_NODE_FIELD(whenClause);
	READ_NODE_FIELD(transitionRels);
	READ_BOOL_FIELD(deferrable);
	READ_BOOL_FIELD(initdeferred);
	READ_NODE_FIELD(constrrel);

	READ_DONE();
}

static CreateEventTrigStmt *
_readCreateEventTrigStmt(void)
{
	READ_LOCALS(CreateEventTrigStmt);

	READ_STRING_FIELD(trigname);
	READ_STRING_FIELD(eventname);
	READ_NODE_FIELD(whenclause);
	READ_NODE_FIELD(funcname);

	READ_DONE();
}

static AlterEventTrigStmt *
_readAlterEventTrigStmt(void)
{
	READ_LOCALS(AlterEventTrigStmt);

	READ_STRING_FIELD(trigname);
	READ_CHAR_FIELD(tgenabled);

	READ_DONE();
}

static CreatePLangStmt *
_readCreatePLangStmt(void)
{
	READ_LOCALS(CreatePLangStmt);

	READ_BOOL_FIELD(replace);
	READ_STRING_FIELD(plname);
	READ_NODE_FIELD(plhandler);
	READ_NODE_FIELD(plinline);
	READ_NODE_FIELD(plvalidator);
	READ_BOOL_FIELD(pltrusted);

	READ_DONE();
}

static CreateRoleStmt *
_readCreateRoleStmt(void)
{
	READ_LOCALS(CreateRoleStmt);

	READ_ENUM_FIELD(stmt_type, RoleStmtType);
	READ_STRING_FIELD(role);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static AlterRoleStmt *
_readAlterRoleStmt(void)
{
	READ_LOCALS(AlterRoleStmt);

	READ_NODE_FIELD(role);
	READ_NODE_FIELD(options);
	READ_INT_FIELD(action);

	READ_DONE();
}

static AlterRoleSetStmt *
_readAlterRoleSetStmt(void)
{
	READ_LOCALS(AlterRoleSetStmt);

	READ_NODE_FIELD(role);
	READ_STRING_FIELD(database);
	READ_NODE_FIELD(setstmt);

	READ_DONE();
}

static DropRoleStmt *
_readDropRoleStmt(void)
{
	READ_LOCALS(DropRoleStmt);

	READ_NODE_FIELD(roles);
	READ_BOOL_FIELD(missing_ok);

	READ_DONE();
}

static CreateSeqStmt *
_readCreateSeqStmt(void)
{
	READ_LOCALS(CreateSeqStmt);

	READ_NODE_FIELD(sequence);
	READ_NODE_FIELD(options);
	READ_OID_FIELD(ownerId);
	READ_BOOL_FIELD(for_identity);
	READ_BOOL_FIELD(if_not_exists);

	READ_DONE();
}

static AlterSeqStmt *
_readAlterSeqStmt(void)
{
	READ_LOCALS(AlterSeqStmt);

	READ_NODE_FIELD(sequence);
	READ_NODE_FIELD(options);
	READ_BOOL_FIELD(for_identity);
	READ_BOOL_FIELD(missing_ok);

	READ_DONE();
}

static DefineStmt *
_readDefineStmt(void)
{
	READ_LOCALS(DefineStmt);

	READ_ENUM_FIELD(kind, ObjectType);
	READ_BOOL_FIELD(oldstyle);
	READ_NODE_FIELD(defnames);
	READ_NODE_FIELD(args);
	READ_NODE_FIELD(definition);
	READ_BOOL_FIELD(if_not_exists);
	READ_BOOL_FIELD(replace);

	READ_DONE();
}

static CreateDomainStmt *
_readCreateDomainStmt(void)
{
	READ_LOCALS(CreateDomainStmt);

	READ_NODE_FIELD(domainname);
	READ_NODE_FIELD(typeName);
	READ_NODE_FIELD(collClause);
	READ_NODE_FIELD(constraints);

	READ_DONE();
}

static CreateOpClassStmt *
_readCreateOpClassStmt(void)
{
	READ_LOCALS(CreateOpClassStmt);

	READ_NODE_FIELD(opclassname);
	READ_NODE_FIELD(opfamilyname);
	READ_STRING_FIELD(amname);
	READ_NODE_FIELD(datatype);
	READ_NODE_FIELD(items);
	READ_BOOL_FIELD(isDefault);

	READ_DONE();
}

static CreateOpClassItem *
_readCreateOpClassItem(void)
{
	READ_LOCALS(CreateOpClassItem);

	READ_INT_FIELD(itemtype);
	READ_NODE_FIELD(name);
	READ_INT_FIELD(number);
	READ_NODE_FIELD(order_family);
	READ_NODE_FIELD(class_args);
	READ_NODE_FIELD(storedtype);

	READ_DONE();
}

static CreateOpFamilyStmt *
_readCreateOpFamilyStmt(void)
{
	READ_LOCALS(CreateOpFamilyStmt);

	READ_NODE_FIELD(opfamilyname);
	READ_STRING_FIELD(amname);

	READ_DONE();
}

static AlterOpFamilyStmt *
_readAlterOpFamilyStmt(void)
{
	READ_LOCALS(AlterOpFamilyStmt);

	READ_NODE_FIELD(opfamilyname);
	READ_STRING_FIELD(amname);
	READ_BOOL_FIELD(isDrop);
	READ_NODE_FIELD(items);

	READ_DONE();
}

static DropStmt *
_readDropStmt(void)
{
	READ_LOCALS(DropStmt);

	READ_NODE_FIELD(objects);
	READ_ENUM_FIELD(removeType, ObjectType);
	READ_ENUM_FIELD(behavior, DropBehavior);
	READ_BOOL_FIELD(missing_ok);
	READ_BOOL_FIELD(concurrent);

	READ_DONE();
}

static TruncateStmt *
_readTruncateStmt(void)
{
	READ_LOCALS(TruncateStmt);

	READ_NODE_FIELD(relations);
	READ_BOOL_FIELD(restart_seqs);
	READ_ENUM_FIELD(behavior, DropBehavior);

	READ_DONE();
}

static CommentStmt *
_readCommentStmt(void)
{
	READ_LOCALS(CommentStmt);

	READ_ENUM_FIELD(objtype, ObjectType);
	READ_NODE_FIELD(object);
	READ_STRING_FIELD(comment);

	READ_DONE();
}

static SecLabelStmt *
_readSecLabelStmt(void)
{
	READ_LOCALS(SecLabelStmt);

	READ_ENUM_FIELD(objtype, ObjectType);
	READ_NODE_FIELD(object);
	READ_STRING_FIELD(provider);
	READ_STRING_FIELD(label);

	READ_DONE();
}

static DeclareCursorStmt *
_readDeclareCursorStmt(void)
{
	READ_LOCALS(DeclareCursorStmt);

	READ_STRING_FIELD(portalname);
	READ_INT_FIELD(options);
	READ_NODE_FIELD(query);

	READ_DONE();
}

static ClosePortalStmt *
_readClosePortalStmt(void)
{
	READ_LOCALS(ClosePortalStmt);

	READ_STRING_FIELD(portalname);

	READ_DONE();
}

static FetchStmt *
_readFetchStmt(void)
{
	READ_LOCALS(FetchStmt);

	READ_ENUM_FIELD(direction, FetchDirection);
	READ_LONG_FIELD(howMany);
	READ_STRING_FIELD(portalname);
	READ_BOOL_FIELD(ismove);

	READ_DONE();
}

static IndexStmt *
_readIndexStmt(void)
{
	READ_LOCALS(IndexStmt);

	READ_STRING_FIELD(idxname);
	READ_NODE_FIELD(relation);
	READ_STRING_FIELD(accessMethod);
	READ_STRING_FIELD(tableSpace);
	READ_NODE_FIELD(indexParams);
	READ_NODE_FIELD(indexIncludingParams);
	READ_NODE_FIELD(options);
	READ_NODE_FIELD(whereClause);
	READ_NODE_FIELD(excludeOpNames);
	READ_STRING_FIELD(idxcomment);
	READ_OID_FIELD(indexOid);
	READ_OID_FIELD(oldNumber);
	READ_UINT_FIELD(oldCreateSubid);
	READ_UINT_FIELD(oldFirstRelfilelocatorSubid);
	READ_BOOL_FIELD(unique);
	READ_BOOL_FIELD(nulls_not_distinct);
	READ_BOOL_FIELD(primary);
	READ_BOOL_FIELD(isconstraint);
	READ_BOOL_FIELD(deferrable);
	READ_BOOL_FIELD(initdeferred);
	READ_BOOL_FIELD(transformed);
	READ_BOOL_FIELD(concurrent);
	READ_BOOL_FIELD(if_not_exists);
	READ_BOOL_FIELD(reset_default_tblspc);

	READ_DONE();
}

static CreateStatsStmt *
_readCreateStatsStmt(void)
{
	READ_LOCALS(CreateStatsStmt);

	READ_NODE_FIELD(defnames);
	READ_NODE_FIELD(stat_types);
	READ_NODE_FIELD(exprs);
	READ_NODE_FIELD(relations);
	READ_STRING_FIELD(stxcomment);
	READ_BOOL_FIELD(transformed);
	READ_BOOL_FIELD(if_not_exists);

	READ_DONE();
}

static StatsElem *
_readStatsElem(void)
{
	READ_LOCALS(StatsElem);

	READ_STRING_FIELD(name);
	READ_NODE_FIELD(expr);

	READ_DONE();
}

static AlterStatsStmt *
_readAlterStatsStmt(void)
{
	READ_LOCALS(AlterStatsStmt);

	READ_NODE_FIELD(defnames);
	READ_NODE_FIELD(stxstattarget);
	READ_BOOL_FIELD(missing_ok);

	READ_DONE();
}

static CreateFunctionStmt *
_readCreateFunctionStmt(void)
{
	READ_LOCALS(CreateFunctionStmt);

	READ_BOOL_FIELD(is_procedure);
	READ_BOOL_FIELD(replace);
	READ_NODE_FIELD(funcname);
	READ_NODE_FIELD(parameters);
	READ_NODE_FIELD(returnType);
	READ_NODE_FIELD(options);
	READ_NODE_FIELD(sql_body);

	READ_DONE();
}

static FunctionParameter *
_readFunctionParameter(void)
{
	READ_LOCALS(FunctionParameter);

	READ_STRING_FIELD(name);
	READ_NODE_FIELD(argType);
	READ_ENUM_FIELD(mode, FunctionParameterMode);
	READ_NODE_FIELD(defexpr);

	READ_DONE();
}

static AlterFunctionStmt *
_readAlterFunctionStmt(void)
{
	READ_LOCALS(AlterFunctionStmt);

	READ_ENUM_FIELD(objtype, ObjectType);
	READ_NODE_FIELD(func);
	READ_NODE_FIELD(actions);

	READ_DONE();
}

static DoStmt *
_readDoStmt(void)
{
	READ_LOCALS(DoStmt);

	READ_NODE_FIELD(args);

	READ_DONE();
}

static CallStmt *
_readCallStmt(void)
{
	READ_LOCALS(CallStmt);

	READ_NODE_FIELD(funccall);
	READ_NODE_FIELD(funcexpr);
	READ_NODE_FIELD(outargs);

	READ_DONE();
}

static RenameStmt *
_readRenameStmt(void)
{
	READ_LOCALS(RenameStmt);

	READ_ENUM_FIELD(renameType, ObjectType);
	READ_ENUM_FIELD(relationType, ObjectType);
	READ_NODE_FIELD(relation);
	READ_NODE_FIELD(object);
	READ_STRING_FIELD(subname);
	READ_STRING_FIELD(newname);
	READ_ENUM_FIELD(behavior, DropBehavior);
	READ_BOOL_FIELD(missing_ok);

	READ_DONE();
}

static AlterObjectDependsStmt *
_readAlterObjectDependsStmt(void)
{
	READ_LOCALS(AlterObjectDependsStmt);

	READ_ENUM_FIELD(objectType, ObjectType);
	READ_NODE_FIELD(relation);
	READ_NODE_FIELD(object);
	READ_NODE_FIELD(extname);
	READ_BOOL_FIELD(remove);

	READ_DONE();
}

static AlterObjectSchemaStmt *
_readAlterObjectSchemaStmt(void)
{
	READ_LOCALS(AlterObjectSchemaStmt);

	READ_ENUM_FIELD(objectType, ObjectType);
	READ_NODE_FIELD(relation);
	READ_NODE_FIELD(object);
	READ_STRING_FIELD(newschema);
	READ_BOOL_FIELD(missing_ok);

	READ_DONE();
}

static AlterOwnerStmt *
_readAlterOwnerStmt(void)
{
	READ_LOCALS(AlterOwnerStmt);

	READ_ENUM_FIELD(objectType, ObjectType);
	READ_NODE_FIELD(relation);
	READ_NODE_FIELD(object);
	READ_NODE_FIELD(newowner);

	READ_DONE();
}

static AlterOperatorStmt *
_readAlterOperatorStmt(void)
{
	READ_LOCALS(AlterOperatorStmt);

	READ_NODE_FIELD(opername);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static AlterTypeStmt *
_readAlterTypeStmt(void)
{
	READ_LOCALS(AlterTypeStmt);

	READ_NODE_FIELD(typeName);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static RuleStmt *
_readRuleStmt(void)
{
	READ_LOCALS(RuleStmt);

	READ_NODE_FIELD(relation);
	READ_STRING_FIELD(rulename);
	READ_NODE_FIELD(whereClause);
	READ_ENUM_FIELD(event, CmdType);
	READ_BOOL_FIELD(instead);
	READ_NODE_FIELD(actions);
	READ_BOOL_FIELD(replace);

	READ_DONE();
}

static NotifyStmt *
_readNotifyStmt(void)
{
	READ_LOCALS(NotifyStmt);

	READ_STRING_FIELD(conditionname);
	READ_STRING_FIELD(payload);

	READ_DONE();
}

static ListenStmt *
_readListenStmt(void)
{
	READ_LOCALS(ListenStmt);

	READ_STRING_FIELD(conditionname);

	READ_DONE();
}

static UnlistenStmt *
_readUnlistenStmt(void)
{
	READ_LOCALS(UnlistenStmt);

	READ_STRING_FIELD(conditionname);

	READ_DONE();
}

static TransactionStmt *
_readTransactionStmt(void)
{
	READ_LOCALS(TransactionStmt);

	READ_ENUM_FIELD(kind, TransactionStmtKind);
	READ_NODE_FIELD(options);
	READ_STRING_FIELD(savepoint_name);
	READ_STRING_FIELD(gid);
	READ_BOOL_FIELD(chain);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static CompositeTypeStmt *
_readCompositeTypeStmt(void)
{
	READ_LOCALS(CompositeTypeStmt);

	READ_NODE_FIELD(typevar);
	READ_NODE_FIELD(coldeflist);

	READ_DONE();
}

static CreateEnumStmt *
_readCreateEnumStmt(void)
{
	READ_LOCALS(CreateEnumStmt);

	READ_NODE_FIELD(typeName);
	READ_NODE_FIELD(vals);

	READ_DONE();
}

static CreateRangeStmt *
_readCreateRangeStmt(void)
{
	READ_LOCALS(CreateRangeStmt);

	READ_NODE_FIELD(typeName);
	READ_NODE_FIELD(params);

	READ_DONE();
}

static AlterEnumStmt *
_readAlterEnumStmt(void)
{
	READ_LOCALS(AlterEnumStmt);

	READ_NODE_FIELD(typeName);
	READ_STRING_FIELD(oldVal);
	READ_STRING_FIELD(newVal);
	READ_STRING_FIELD(newValNeighbor);
	READ_BOOL_FIELD(newValIsAfter);
	READ_BOOL_FIELD(skipIfNewValExists);

	READ_DONE();
}

static ViewStmt *
_readViewStmt(void)
{
	READ_LOCALS(ViewStmt);

	READ_NODE_FIELD(view);
	READ_NODE_FIELD(aliases);
	READ_NODE_FIELD(query);
	READ_BOOL_FIELD(replace);
	READ_NODE_FIELD(options);
	READ_ENUM_FIELD(withCheckOption, ViewCheckOption);

	READ_DONE();
}

static LoadStmt *
_readLoadStmt(void)
{
	READ_LOCALS(LoadStmt);

	READ_STRING_FIELD(filename);

	READ_DONE();
}

static CreatedbStmt *
_readCreatedbStmt(void)
{
	READ_LOCALS(CreatedbStmt);

	READ_STRING_FIELD(dbname);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static AlterDatabaseStmt *
_readAlterDatabaseStmt(void)
{
	READ_LOCALS(AlterDatabaseStmt);

	READ_STRING_FIELD(dbname);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static AlterDatabaseRefreshCollStmt *
_readAlterDatabaseRefreshCollStmt(void)
{
	READ_LOCALS(AlterDatabaseRefreshCollStmt);

	READ_STRING_FIELD(dbname);

	READ_DONE();
}

static AlterDatabaseSetStmt *
_readAlterDatabaseSetStmt(void)
{
	READ_LOCALS(AlterDatabaseSetStmt);

	READ_STRING_FIELD(dbname);
	READ_NODE_FIELD(setstmt);

	READ_DONE();
}

static DropdbStmt *
_readDropdbStmt(void)
{
	READ_LOCALS(DropdbStmt);

	READ_STRING_FIELD(dbname);
	READ_BOOL_FIELD(missing_ok);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static AlterSystemStmt *
_readAlterSystemStmt(void)
{
	READ_LOCALS(AlterSystemStmt);

	READ_NODE_FIELD(setstmt);

	READ_DONE();
}

static ClusterStmt *
_readClusterStmt(void)
{
	READ_LOCALS(ClusterStmt);

	READ_NODE_FIELD(relation);
	READ_STRING_FIELD(indexname);
	READ_NODE_FIELD(params);

	READ_DONE();
}

static VacuumStmt *
_readVacuumStmt(void)
{
	READ_LOCALS(VacuumStmt);

	READ_NODE_FIELD(options);
	READ_NODE_FIELD(rels);
	READ_BOOL_FIELD(is_vacuumcmd);

	READ_DONE();
}

static VacuumRelation *
_readVacuumRelation(void)
{
	READ_LOCALS(VacuumRelation);

	READ_NODE_FIELD(relation);
	READ_OID_FIELD(oid);
	READ_NODE_FIELD(va_cols);

	READ_DONE();
}

static ExplainStmt *
_readExplainStmt(void)
{
	READ_LOCALS(ExplainStmt);

	READ_NODE_FIELD(query);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static CreateTableAsStmt *
_readCreateTableAsStmt(void)
{
	READ_LOCALS(CreateTableAsStmt);

	READ_NODE_FIELD(query);
	READ_NODE_FIELD(into);
	READ_ENUM_FIELD(objtype, ObjectType);
	READ_BOOL_FIELD(is_select_into);
	READ_BOOL_FIELD(if_not_exists);

	READ_DONE();
}

static RefreshMatViewStmt *
_readRefreshMatViewStmt(void)
{
	READ_LOCALS(RefreshMatViewStmt);

	READ_BOOL_FIELD(concurrent);
	READ_BOOL_FIELD(skipData);
	READ_NODE_FIELD(relation);

	READ_DONE();
}

static CheckPointStmt *
_readCheckPointStmt(void)
{
	READ_LOCALS_NO_FIELDS(CheckPointStmt);


	READ_DONE();
}

static DiscardStmt *
_readDiscardStmt(void)
{
	READ_LOCALS(DiscardStmt);

	READ_ENUM_FIELD(target, DiscardMode);

	READ_DONE();
}

static LockStmt *
_readLockStmt(void)
{
	READ_LOCALS(LockStmt);

	READ_NODE_FIELD(relations);
	READ_INT_FIELD(mode);
	READ_BOOL_FIELD(nowait);

	READ_DONE();
}

static ConstraintsSetStmt *
_readConstraintsSetStmt(void)
{
	READ_LOCALS(ConstraintsSetStmt);

	READ_NODE_FIELD(constraints);
	READ_BOOL_FIELD(deferred);

	READ_DONE();
}

static ReindexStmt *
_readReindexStmt(void)
{
	READ_LOCALS(ReindexStmt);

	READ_ENUM_FIELD(kind, ReindexObjectType);
	READ_NODE_FIELD(relation);
	READ_STRING_FIELD(name);
	READ_NODE_FIELD(params);

	READ_DONE();
}

static CreateConversionStmt *
_readCreateConversionStmt(void)
{
	READ_LOCALS(CreateConversionStmt);

	READ_NODE_FIELD(conversion_name);
	READ_STRING_FIELD(for_encoding_name);
	READ_STRING_FIELD(to_encoding_name);
	READ_NODE_FIELD(func_name);
	READ_BOOL_FIELD(def);

	READ_DONE();
}

static CreateCastStmt *
_readCreateCastStmt(void)
{
	READ_LOCALS(CreateCastStmt);

	READ_NODE_FIELD(sourcetype);
	READ_NODE_FIELD(targettype);
	READ_NODE_FIELD(func);
	READ_ENUM_FIELD(context, CoercionContext);
	READ_BOOL_FIELD(inout);

	READ_DONE();
}

static CreateTransformStmt *
_readCreateTransformStmt(void)
{
	READ_LOCALS(CreateTransformStmt);

	READ_BOOL_FIELD(replace);
	READ_NODE_FIELD(type_name);
	READ_STRING_FIELD(lang);
	READ_NODE_FIELD(fromsql);
	READ_NODE_FIELD(tosql);

	READ_DONE();
}

static PrepareStmt *
_readPrepareStmt(void)
{
	READ_LOCALS(PrepareStmt);

	READ_STRING_FIELD(name);
	READ_NODE_FIELD(argtypes);
	READ_NODE_FIELD(query);

	READ_DONE();
}

static ExecuteStmt *
_readExecuteStmt(void)
{
	READ_LOCALS(ExecuteStmt);

	READ_STRING_FIELD(name);
	READ_NODE_FIELD(params);

	READ_DONE();
}

static DeallocateStmt *
_readDeallocateStmt(void)
{
	READ_LOCALS(DeallocateStmt);

	READ_STRING_FIELD(name);
	READ_BOOL_FIELD(isall);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static DropOwnedStmt *
_readDropOwnedStmt(void)
{
	READ_LOCALS(DropOwnedStmt);

	READ_NODE_FIELD(roles);
	READ_ENUM_FIELD(behavior, DropBehavior);

	READ_DONE();
}

static ReassignOwnedStmt *
_readReassignOwnedStmt(void)
{
	READ_LOCALS(ReassignOwnedStmt);

	READ_NODE_FIELD(roles);
	READ_NODE_FIELD(newrole);

	READ_DONE();
}

static AlterTSDictionaryStmt *
_readAlterTSDictionaryStmt(void)
{
	READ_LOCALS(AlterTSDictionaryStmt);

	READ_NODE_FIELD(dictname);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static AlterTSConfigurationStmt *
_readAlterTSConfigurationStmt(void)
{
	READ_LOCALS(AlterTSConfigurationStmt);

	READ_ENUM_FIELD(kind, AlterTSConfigType);
	READ_NODE_FIELD(cfgname);
	READ_NODE_FIELD(tokentype);
	READ_NODE_FIELD(dicts);
	READ_BOOL_FIELD(override);
	READ_BOOL_FIELD(replace);
	READ_BOOL_FIELD(missing_ok);

	READ_DONE();
}

static PublicationTable *
_readPublicationTable(void)
{
	READ_LOCALS(PublicationTable);

	READ_NODE_FIELD(relation);
	READ_NODE_FIELD(whereClause);
	READ_NODE_FIELD(columns);

	READ_DONE();
}

static PublicationObjSpec *
_readPublicationObjSpec(void)
{
	READ_LOCALS(PublicationObjSpec);

	READ_ENUM_FIELD(pubobjtype, PublicationObjSpecType);
	READ_STRING_FIELD(name);
	READ_NODE_FIELD(pubtable);
	READ_LOCATION_FIELD(location);

	READ_DONE();
}

static CreatePublicationStmt *
_readCreatePublicationStmt(void)
{
	READ_LOCALS(CreatePublicationStmt);

	READ_STRING_FIELD(pubname);
	READ_NODE_FIELD(options);
	READ_NODE_FIELD(pubobjects);
	READ_BOOL_FIELD(for_all_tables);

	READ_DONE();
}

static AlterPublicationStmt *
_readAlterPublicationStmt(void)
{
	READ_LOCALS(AlterPublicationStmt);

	READ_STRING_FIELD(pubname);
	READ_NODE_FIELD(options);
	READ_NODE_FIELD(pubobjects);
	READ_BOOL_FIELD(for_all_tables);
	READ_ENUM_FIELD(action, AlterPublicationAction);

	READ_DONE();
}

static CreateSubscriptionStmt *
_readCreateSubscriptionStmt(void)
{
	READ_LOCALS(CreateSubscriptionStmt);

	READ_STRING_FIELD(subname);
	READ_STRING_FIELD(conninfo);
	READ_NODE_FIELD(publication);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static AlterSubscriptionStmt *
_readAlterSubscriptionStmt(void)
{
	READ_LOCALS(AlterSubscriptionStmt);

	READ_ENUM_FIELD(kind, AlterSubscriptionType);
	READ_STRING_FIELD(subname);
	READ_STRING_FIELD(conninfo);
	READ_NODE_FIELD(publication);
	READ_NODE_FIELD(options);

	READ_DONE();
}

static DropSubscriptionStmt *
_readDropSubscriptionStmt(void)
{
	READ_LOCALS(DropSubscriptionStmt);

	READ_STRING_FIELD(subname);
	READ_BOOL_FIELD(missing_ok);
	READ_ENUM_FIELD(behavior, DropBehavior);

	READ_DONE();
}

static GroupByOrdering *
_readGroupByOrdering(void)
{
	READ_LOCALS(GroupByOrdering);

	READ_NODE_FIELD(pathkeys);
	READ_NODE_FIELD(clauses);

	READ_DONE();
}

static PlaceHolderVar *
_readPlaceHolderVar(void)
{
	READ_LOCALS(PlaceHolderVar);

	READ_NODE_FIELD(phexpr);
	READ_BITMAPSET_FIELD(phrels);
	READ_BITMAPSET_FIELD(phnullingrels);
	READ_UINT_FIELD(phid);
	READ_UINT_FIELD(phlevelsup);

	READ_DONE();
}

static AppendRelInfo *
_readAppendRelInfo(void)
{
	READ_LOCALS(AppendRelInfo);

	READ_UINT_FIELD(parent_relid);
	READ_UINT_FIELD(child_relid);
	READ_OID_FIELD(parent_reltype);
	READ_OID_FIELD(child_reltype);
	READ_NODE_FIELD(translated_vars);
	READ_INT_FIELD(num_child_cols);
	READ_ATTRNUMBER_ARRAY(parent_colnos, local_node->num_child_cols);
	READ_OID_FIELD(parent_reloid);

	READ_DONE();
}

static PlannedStmt *
_readPlannedStmt(void)
{
	READ_LOCALS(PlannedStmt);

	READ_ENUM_FIELD(commandType, CmdType);
	READ_UINT64_FIELD(queryId);
	READ_BOOL_FIELD(hasReturning);
	READ_BOOL_FIELD(hasModifyingCTE);
	READ_BOOL_FIELD(canSetTag);
	READ_BOOL_FIELD(transientPlan);
	READ_BOOL_FIELD(dependsOnRole);
	READ_BOOL_FIELD(parallelModeNeeded);
	READ_INT_FIELD(jitFlags);
	READ_NODE_FIELD(planTree);
	READ_NODE_FIELD(rtable);
	READ_NODE_FIELD(permInfos);
	READ_NODE_FIELD(resultRelations);
	READ_NODE_FIELD(appendRelations);
	READ_NODE_FIELD(subplans);
	READ_BITMAPSET_FIELD(rewindPlanIDs);
	READ_NODE_FIELD(rowMarks);
	READ_NODE_FIELD(relationOids);
	READ_NODE_FIELD(invalItems);
	READ_NODE_FIELD(paramExecTypes);
	READ_NODE_FIELD(utilityStmt);
	READ_LOCATION_FIELD(stmt_location);
	READ_LOCATION_FIELD(stmt_len);

	READ_DONE();
}

static Result *
_readResult(void)
{
	READ_LOCALS(Result);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_NODE_FIELD(resconstantqual);

	READ_DONE();
}

static ProjectSet *
_readProjectSet(void)
{
	READ_LOCALS(ProjectSet);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);

	READ_DONE();
}

static ModifyTable *
_readModifyTable(void)
{
	READ_LOCALS(ModifyTable);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_ENUM_FIELD(operation, CmdType);
	READ_BOOL_FIELD(canSetTag);
	READ_UINT_FIELD(nominalRelation);
	READ_UINT_FIELD(rootRelation);
	READ_BOOL_FIELD(partColsUpdated);
	READ_NODE_FIELD(resultRelations);
	READ_NODE_FIELD(updateColnosLists);
	READ_NODE_FIELD(withCheckOptionLists);
	READ_NODE_FIELD(returningLists);
	READ_NODE_FIELD(fdwPrivLists);
	READ_BITMAPSET_FIELD(fdwDirectModifyPlans);
	READ_NODE_FIELD(rowMarks);
	READ_INT_FIELD(epqParam);
	READ_ENUM_FIELD(onConflictAction, OnConflictAction);
	READ_NODE_FIELD(arbiterIndexes);
	READ_NODE_FIELD(onConflictSet);
	READ_NODE_FIELD(onConflictCols);
	READ_NODE_FIELD(onConflictWhere);
	READ_UINT_FIELD(exclRelRTI);
	READ_NODE_FIELD(exclRelTlist);
	READ_NODE_FIELD(mergeActionLists);
	READ_NODE_FIELD(mergeJoinConditions);

	READ_DONE();
}

static Append *
_readAppend(void)
{
	READ_LOCALS(Append);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_BITMAPSET_FIELD(apprelids);
	READ_NODE_FIELD(appendplans);
	READ_INT_FIELD(nasyncplans);
	READ_INT_FIELD(first_partial_plan);
	READ_NODE_FIELD(part_prune_info);

	READ_DONE();
}

static MergeAppend *
_readMergeAppend(void)
{
	READ_LOCALS(MergeAppend);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_BITMAPSET_FIELD(apprelids);
	READ_NODE_FIELD(mergeplans);
	READ_INT_FIELD(numCols);
	READ_ATTRNUMBER_ARRAY(sortColIdx, local_node->numCols);
	READ_OID_ARRAY(sortOperators, local_node->numCols);
	READ_OID_ARRAY(collations, local_node->numCols);
	READ_BOOL_ARRAY(nullsFirst, local_node->numCols);
	READ_NODE_FIELD(part_prune_info);

	READ_DONE();
}

static RecursiveUnion *
_readRecursiveUnion(void)
{
	READ_LOCALS(RecursiveUnion);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_INT_FIELD(wtParam);
	READ_INT_FIELD(numCols);
	READ_ATTRNUMBER_ARRAY(dupColIdx, local_node->numCols);
	READ_OID_ARRAY(dupOperators, local_node->numCols);
	READ_OID_ARRAY(dupCollations, local_node->numCols);
	READ_LONG_FIELD(numGroups);

	READ_DONE();
}

static BitmapAnd *
_readBitmapAnd(void)
{
	READ_LOCALS(BitmapAnd);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_NODE_FIELD(bitmapplans);

	READ_DONE();
}

static BitmapOr *
_readBitmapOr(void)
{
	READ_LOCALS(BitmapOr);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_BOOL_FIELD(isshared);
	READ_NODE_FIELD(bitmapplans);

	READ_DONE();
}

static SeqScan *
_readSeqScan(void)
{
	READ_LOCALS(SeqScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);

	READ_DONE();
}

static SampleScan *
_readSampleScan(void)
{
	READ_LOCALS(SampleScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);
	READ_NODE_FIELD(tablesample);

	READ_DONE();
}

static IndexScan *
_readIndexScan(void)
{
	READ_LOCALS(IndexScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);
	READ_OID_FIELD(indexid);
	READ_NODE_FIELD(indexqual);
	READ_NODE_FIELD(indexqualorig);
	READ_NODE_FIELD(indexorderby);
	READ_NODE_FIELD(indexorderbyorig);
	READ_NODE_FIELD(indexorderbyops);
	READ_ENUM_FIELD(indexorderdir, ScanDirection);

	READ_DONE();
}

static IndexOnlyScan *
_readIndexOnlyScan(void)
{
	READ_LOCALS(IndexOnlyScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);
	READ_OID_FIELD(indexid);
	READ_NODE_FIELD(indexqual);
	READ_NODE_FIELD(recheckqual);
	READ_NODE_FIELD(indexorderby);
	READ_NODE_FIELD(indextlist);
	READ_ENUM_FIELD(indexorderdir, ScanDirection);

	READ_DONE();
}

static BitmapIndexScan *
_readBitmapIndexScan(void)
{
	READ_LOCALS(BitmapIndexScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);
	READ_OID_FIELD(indexid);
	READ_BOOL_FIELD(isshared);
	READ_NODE_FIELD(indexqual);
	READ_NODE_FIELD(indexqualorig);

	READ_DONE();
}

static BitmapHeapScan *
_readBitmapHeapScan(void)
{
	READ_LOCALS(BitmapHeapScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);
	READ_NODE_FIELD(bitmapqualorig);

	READ_DONE();
}

static TidScan *
_readTidScan(void)
{
	READ_LOCALS(TidScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);
	READ_NODE_FIELD(tidquals);

	READ_DONE();
}

static TidRangeScan *
_readTidRangeScan(void)
{
	READ_LOCALS(TidRangeScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);
	READ_NODE_FIELD(tidrangequals);

	READ_DONE();
}

static SubqueryScan *
_readSubqueryScan(void)
{
	READ_LOCALS(SubqueryScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);
	READ_NODE_FIELD(subplan);
	READ_ENUM_FIELD(scanstatus, SubqueryScanStatus);

	READ_DONE();
}

static FunctionScan *
_readFunctionScan(void)
{
	READ_LOCALS(FunctionScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);
	READ_NODE_FIELD(functions);
	READ_BOOL_FIELD(funcordinality);

	READ_DONE();
}

static ValuesScan *
_readValuesScan(void)
{
	READ_LOCALS(ValuesScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);
	READ_NODE_FIELD(values_lists);

	READ_DONE();
}

static TableFuncScan *
_readTableFuncScan(void)
{
	READ_LOCALS(TableFuncScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);
	READ_NODE_FIELD(tablefunc);

	READ_DONE();
}

static CteScan *
_readCteScan(void)
{
	READ_LOCALS(CteScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);
	READ_INT_FIELD(ctePlanId);
	READ_INT_FIELD(cteParam);

	READ_DONE();
}

static NamedTuplestoreScan *
_readNamedTuplestoreScan(void)
{
	READ_LOCALS(NamedTuplestoreScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);
	READ_STRING_FIELD(enrname);

	READ_DONE();
}

static WorkTableScan *
_readWorkTableScan(void)
{
	READ_LOCALS(WorkTableScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);
	READ_INT_FIELD(wtParam);

	READ_DONE();
}

static ForeignScan *
_readForeignScan(void)
{
	READ_LOCALS(ForeignScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);
	READ_ENUM_FIELD(operation, CmdType);
	READ_UINT_FIELD(resultRelation);
	READ_OID_FIELD(checkAsUser);
	READ_OID_FIELD(fs_server);
	READ_NODE_FIELD(fdw_exprs);
	READ_NODE_FIELD(fdw_private);
	READ_NODE_FIELD(fdw_scan_tlist);
	READ_NODE_FIELD(fdw_recheck_quals);
	READ_BITMAPSET_FIELD(fs_relids);
	READ_BITMAPSET_FIELD(fs_base_relids);
	READ_BOOL_FIELD(fsSystemCol);

	READ_DONE();
}

static CustomScan *
_readCustomScan(void)
{
	READ_LOCALS(CustomScan);

	READ_FLOAT_FIELD(scan.plan.startup_cost);
	READ_FLOAT_FIELD(scan.plan.total_cost);
	READ_FLOAT_FIELD(scan.plan.plan_rows);
	READ_INT_FIELD(scan.plan.plan_width);
	READ_BOOL_FIELD(scan.plan.parallel_aware);
	READ_BOOL_FIELD(scan.plan.parallel_safe);
	READ_BOOL_FIELD(scan.plan.async_capable);
	READ_INT_FIELD(scan.plan.plan_node_id);
	READ_NODE_FIELD(scan.plan.targetlist);
	READ_NODE_FIELD(scan.plan.qual);
	READ_NODE_FIELD(scan.plan.lefttree);
	READ_NODE_FIELD(scan.plan.righttree);
	READ_NODE_FIELD(scan.plan.initPlan);
	READ_BITMAPSET_FIELD(scan.plan.extParam);
	READ_BITMAPSET_FIELD(scan.plan.allParam);
	READ_UINT_FIELD(scan.scanrelid);
	READ_UINT_FIELD(flags);
	READ_NODE_FIELD(custom_plans);
	READ_NODE_FIELD(custom_exprs);
	READ_NODE_FIELD(custom_private);
	READ_NODE_FIELD(custom_scan_tlist);
	READ_BITMAPSET_FIELD(custom_relids);

	{
		/* Lookup CustomScanMethods by CustomName */
		char	   *custom_name;
		const CustomScanMethods *methods;
		token = pg_strtok(&length); /* skip methods: */
		token = pg_strtok(&length); /* CustomName */
		custom_name = nullable_string(token, length);
		methods = GetCustomScanMethods(custom_name, false);
		local_node->methods = methods;
	}

	READ_DONE();
}

static NestLoop *
_readNestLoop(void)
{
	READ_LOCALS(NestLoop);

	READ_FLOAT_FIELD(join.plan.startup_cost);
	READ_FLOAT_FIELD(join.plan.total_cost);
	READ_FLOAT_FIELD(join.plan.plan_rows);
	READ_INT_FIELD(join.plan.plan_width);
	READ_BOOL_FIELD(join.plan.parallel_aware);
	READ_BOOL_FIELD(join.plan.parallel_safe);
	READ_BOOL_FIELD(join.plan.async_capable);
	READ_INT_FIELD(join.plan.plan_node_id);
	READ_NODE_FIELD(join.plan.targetlist);
	READ_NODE_FIELD(join.plan.qual);
	READ_NODE_FIELD(join.plan.lefttree);
	READ_NODE_FIELD(join.plan.righttree);
	READ_NODE_FIELD(join.plan.initPlan);
	READ_BITMAPSET_FIELD(join.plan.extParam);
	READ_BITMAPSET_FIELD(join.plan.allParam);
	READ_ENUM_FIELD(join.jointype, JoinType);
	READ_BOOL_FIELD(join.inner_unique);
	READ_NODE_FIELD(join.joinqual);
	READ_NODE_FIELD(nestParams);

	READ_DONE();
}

static NestLoopParam *
_readNestLoopParam(void)
{
	READ_LOCALS(NestLoopParam);

	READ_INT_FIELD(paramno);
	READ_NODE_FIELD(paramval);

	READ_DONE();
}

static MergeJoin *
_readMergeJoin(void)
{
	READ_LOCALS(MergeJoin);

	READ_FLOAT_FIELD(join.plan.startup_cost);
	READ_FLOAT_FIELD(join.plan.total_cost);
	READ_FLOAT_FIELD(join.plan.plan_rows);
	READ_INT_FIELD(join.plan.plan_width);
	READ_BOOL_FIELD(join.plan.parallel_aware);
	READ_BOOL_FIELD(join.plan.parallel_safe);
	READ_BOOL_FIELD(join.plan.async_capable);
	READ_INT_FIELD(join.plan.plan_node_id);
	READ_NODE_FIELD(join.plan.targetlist);
	READ_NODE_FIELD(join.plan.qual);
	READ_NODE_FIELD(join.plan.lefttree);
	READ_NODE_FIELD(join.plan.righttree);
	READ_NODE_FIELD(join.plan.initPlan);
	READ_BITMAPSET_FIELD(join.plan.extParam);
	READ_BITMAPSET_FIELD(join.plan.allParam);
	READ_ENUM_FIELD(join.jointype, JoinType);
	READ_BOOL_FIELD(join.inner_unique);
	READ_NODE_FIELD(join.joinqual);
	READ_BOOL_FIELD(skip_mark_restore);
	READ_NODE_FIELD(mergeclauses);
	READ_OID_ARRAY(mergeFamilies, list_length(local_node->mergeclauses));
	READ_OID_ARRAY(mergeCollations, list_length(local_node->mergeclauses));
	READ_INT_ARRAY(mergeStrategies, list_length(local_node->mergeclauses));
	READ_BOOL_ARRAY(mergeNullsFirst, list_length(local_node->mergeclauses));

	READ_DONE();
}

static HashJoin *
_readHashJoin(void)
{
	READ_LOCALS(HashJoin);

	READ_FLOAT_FIELD(join.plan.startup_cost);
	READ_FLOAT_FIELD(join.plan.total_cost);
	READ_FLOAT_FIELD(join.plan.plan_rows);
	READ_INT_FIELD(join.plan.plan_width);
	READ_BOOL_FIELD(join.plan.parallel_aware);
	READ_BOOL_FIELD(join.plan.parallel_safe);
	READ_BOOL_FIELD(join.plan.async_capable);
	READ_INT_FIELD(join.plan.plan_node_id);
	READ_NODE_FIELD(join.plan.targetlist);
	READ_NODE_FIELD(join.plan.qual);
	READ_NODE_FIELD(join.plan.lefttree);
	READ_NODE_FIELD(join.plan.righttree);
	READ_NODE_FIELD(join.plan.initPlan);
	READ_BITMAPSET_FIELD(join.plan.extParam);
	READ_BITMAPSET_FIELD(join.plan.allParam);
	READ_ENUM_FIELD(join.jointype, JoinType);
	READ_BOOL_FIELD(join.inner_unique);
	READ_NODE_FIELD(join.joinqual);
	READ_NODE_FIELD(hashclauses);
	READ_NODE_FIELD(hashoperators);
	READ_NODE_FIELD(hashcollations);
	READ_NODE_FIELD(hashkeys);

	READ_DONE();
}

static Material *
_readMaterial(void)
{
	READ_LOCALS(Material);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);

	READ_DONE();
}

static Memoize *
_readMemoize(void)
{
	READ_LOCALS(Memoize);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_INT_FIELD(numKeys);
	READ_OID_ARRAY(hashOperators, local_node->numKeys);
	READ_OID_ARRAY(collations, local_node->numKeys);
	READ_NODE_FIELD(param_exprs);
	READ_BOOL_FIELD(singlerow);
	READ_BOOL_FIELD(binary_mode);
	READ_UINT_FIELD(est_entries);
	READ_BITMAPSET_FIELD(keyparamids);

	READ_DONE();
}

static Sort *
_readSort(void)
{
	READ_LOCALS(Sort);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_INT_FIELD(numCols);
	READ_ATTRNUMBER_ARRAY(sortColIdx, local_node->numCols);
	READ_OID_ARRAY(sortOperators, local_node->numCols);
	READ_OID_ARRAY(collations, local_node->numCols);
	READ_BOOL_ARRAY(nullsFirst, local_node->numCols);

	READ_DONE();
}

static IncrementalSort *
_readIncrementalSort(void)
{
	READ_LOCALS(IncrementalSort);

	READ_FLOAT_FIELD(sort.plan.startup_cost);
	READ_FLOAT_FIELD(sort.plan.total_cost);
	READ_FLOAT_FIELD(sort.plan.plan_rows);
	READ_INT_FIELD(sort.plan.plan_width);
	READ_BOOL_FIELD(sort.plan.parallel_aware);
	READ_BOOL_FIELD(sort.plan.parallel_safe);
	READ_BOOL_FIELD(sort.plan.async_capable);
	READ_INT_FIELD(sort.plan.plan_node_id);
	READ_NODE_FIELD(sort.plan.targetlist);
	READ_NODE_FIELD(sort.plan.qual);
	READ_NODE_FIELD(sort.plan.lefttree);
	READ_NODE_FIELD(sort.plan.righttree);
	READ_NODE_FIELD(sort.plan.initPlan);
	READ_BITMAPSET_FIELD(sort.plan.extParam);
	READ_BITMAPSET_FIELD(sort.plan.allParam);
	READ_INT_FIELD(sort.numCols);
	READ_ATTRNUMBER_ARRAY(sort.sortColIdx, local_node->sort.numCols);
	READ_OID_ARRAY(sort.sortOperators, local_node->sort.numCols);
	READ_OID_ARRAY(sort.collations, local_node->sort.numCols);
	READ_BOOL_ARRAY(sort.nullsFirst, local_node->sort.numCols);
	READ_INT_FIELD(nPresortedCols);

	READ_DONE();
}

static Group *
_readGroup(void)
{
	READ_LOCALS(Group);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_INT_FIELD(numCols);
	READ_ATTRNUMBER_ARRAY(grpColIdx, local_node->numCols);
	READ_OID_ARRAY(grpOperators, local_node->numCols);
	READ_OID_ARRAY(grpCollations, local_node->numCols);

	READ_DONE();
}

static Agg *
_readAgg(void)
{
	READ_LOCALS(Agg);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_ENUM_FIELD(aggstrategy, AggStrategy);
	READ_ENUM_FIELD(aggsplit, AggSplit);
	READ_INT_FIELD(numCols);
	READ_ATTRNUMBER_ARRAY(grpColIdx, local_node->numCols);
	READ_OID_ARRAY(grpOperators, local_node->numCols);
	READ_OID_ARRAY(grpCollations, local_node->numCols);
	READ_LONG_FIELD(numGroups);
	READ_UINT64_FIELD(transitionSpace);
	READ_BITMAPSET_FIELD(aggParams);
	READ_NODE_FIELD(groupingSets);
	READ_NODE_FIELD(chain);

	READ_DONE();
}

static WindowAgg *
_readWindowAgg(void)
{
	READ_LOCALS(WindowAgg);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_UINT_FIELD(winref);
	READ_INT_FIELD(partNumCols);
	READ_ATTRNUMBER_ARRAY(partColIdx, local_node->partNumCols);
	READ_OID_ARRAY(partOperators, local_node->partNumCols);
	READ_OID_ARRAY(partCollations, local_node->partNumCols);
	READ_INT_FIELD(ordNumCols);
	READ_ATTRNUMBER_ARRAY(ordColIdx, local_node->ordNumCols);
	READ_OID_ARRAY(ordOperators, local_node->ordNumCols);
	READ_OID_ARRAY(ordCollations, local_node->ordNumCols);
	READ_INT_FIELD(frameOptions);
	READ_NODE_FIELD(startOffset);
	READ_NODE_FIELD(endOffset);
	READ_NODE_FIELD(runCondition);
	READ_NODE_FIELD(runConditionOrig);
	READ_OID_FIELD(startInRangeFunc);
	READ_OID_FIELD(endInRangeFunc);
	READ_OID_FIELD(inRangeColl);
	READ_BOOL_FIELD(inRangeAsc);
	READ_BOOL_FIELD(inRangeNullsFirst);
	READ_BOOL_FIELD(topWindow);

	READ_DONE();
}

static Unique *
_readUnique(void)
{
	READ_LOCALS(Unique);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_INT_FIELD(numCols);
	READ_ATTRNUMBER_ARRAY(uniqColIdx, local_node->numCols);
	READ_OID_ARRAY(uniqOperators, local_node->numCols);
	READ_OID_ARRAY(uniqCollations, local_node->numCols);

	READ_DONE();
}

static Gather *
_readGather(void)
{
	READ_LOCALS(Gather);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_INT_FIELD(num_workers);
	READ_INT_FIELD(rescan_param);
	READ_BOOL_FIELD(single_copy);
	READ_BOOL_FIELD(invisible);
	READ_BITMAPSET_FIELD(initParam);

	READ_DONE();
}

static GatherMerge *
_readGatherMerge(void)
{
	READ_LOCALS(GatherMerge);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_INT_FIELD(num_workers);
	READ_INT_FIELD(rescan_param);
	READ_INT_FIELD(numCols);
	READ_ATTRNUMBER_ARRAY(sortColIdx, local_node->numCols);
	READ_OID_ARRAY(sortOperators, local_node->numCols);
	READ_OID_ARRAY(collations, local_node->numCols);
	READ_BOOL_ARRAY(nullsFirst, local_node->numCols);
	READ_BITMAPSET_FIELD(initParam);

	READ_DONE();
}

static Hash *
_readHash(void)
{
	READ_LOCALS(Hash);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_NODE_FIELD(hashkeys);
	READ_OID_FIELD(skewTable);
	READ_INT_FIELD(skewColumn);
	READ_BOOL_FIELD(skewInherit);
	READ_FLOAT_FIELD(rows_total);

	READ_DONE();
}

static SetOp *
_readSetOp(void)
{
	READ_LOCALS(SetOp);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_ENUM_FIELD(cmd, SetOpCmd);
	READ_ENUM_FIELD(strategy, SetOpStrategy);
	READ_INT_FIELD(numCols);
	READ_ATTRNUMBER_ARRAY(dupColIdx, local_node->numCols);
	READ_OID_ARRAY(dupOperators, local_node->numCols);
	READ_OID_ARRAY(dupCollations, local_node->numCols);
	READ_INT_FIELD(flagColIdx);
	READ_INT_FIELD(firstFlag);
	READ_LONG_FIELD(numGroups);

	READ_DONE();
}

static LockRows *
_readLockRows(void)
{
	READ_LOCALS(LockRows);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_NODE_FIELD(rowMarks);
	READ_INT_FIELD(epqParam);

	READ_DONE();
}

static Limit *
_readLimit(void)
{
	READ_LOCALS(Limit);

	READ_FLOAT_FIELD(plan.startup_cost);
	READ_FLOAT_FIELD(plan.total_cost);
	READ_FLOAT_FIELD(plan.plan_rows);
	READ_INT_FIELD(plan.plan_width);
	READ_BOOL_FIELD(plan.parallel_aware);
	READ_BOOL_FIELD(plan.parallel_safe);
	READ_BOOL_FIELD(plan.async_capable);
	READ_INT_FIELD(plan.plan_node_id);
	READ_NODE_FIELD(plan.targetlist);
	READ_NODE_FIELD(plan.qual);
	READ_NODE_FIELD(plan.lefttree);
	READ_NODE_FIELD(plan.righttree);
	READ_NODE_FIELD(plan.initPlan);
	READ_BITMAPSET_FIELD(plan.extParam);
	READ_BITMAPSET_FIELD(plan.allParam);
	READ_NODE_FIELD(limitOffset);
	READ_NODE_FIELD(limitCount);
	READ_ENUM_FIELD(limitOption, LimitOption);
	READ_INT_FIELD(uniqNumCols);
	READ_ATTRNUMBER_ARRAY(uniqColIdx, local_node->uniqNumCols);
	READ_OID_ARRAY(uniqOperators, local_node->uniqNumCols);
	READ_OID_ARRAY(uniqCollations, local_node->uniqNumCols);

	READ_DONE();
}

static PlanRowMark *
_readPlanRowMark(void)
{
	READ_LOCALS(PlanRowMark);

	READ_UINT_FIELD(rti);
	READ_UINT_FIELD(prti);
	READ_UINT_FIELD(rowmarkId);
	READ_ENUM_FIELD(markType, RowMarkType);
	READ_INT_FIELD(allMarkTypes);
	READ_ENUM_FIELD(strength, LockClauseStrength);
	READ_ENUM_FIELD(waitPolicy, LockWaitPolicy);
	READ_BOOL_FIELD(isParent);

	READ_DONE();
}

static PartitionPruneInfo *
_readPartitionPruneInfo(void)
{
	READ_LOCALS(PartitionPruneInfo);

	READ_NODE_FIELD(prune_infos);
	READ_BITMAPSET_FIELD(other_subplans);

	READ_DONE();
}

static PartitionedRelPruneInfo *
_readPartitionedRelPruneInfo(void)
{
	READ_LOCALS(PartitionedRelPruneInfo);

	READ_UINT_FIELD(rtindex);
	READ_BITMAPSET_FIELD(present_parts);
	READ_INT_FIELD(nparts);
	READ_INT_ARRAY(subplan_map, local_node->nparts);
	READ_INT_ARRAY(subpart_map, local_node->nparts);
	READ_OID_ARRAY(relid_map, local_node->nparts);
	READ_NODE_FIELD(initial_pruning_steps);
	READ_NODE_FIELD(exec_pruning_steps);
	READ_BITMAPSET_FIELD(execparamids);

	READ_DONE();
}

static PartitionPruneStepOp *
_readPartitionPruneStepOp(void)
{
	READ_LOCALS(PartitionPruneStepOp);

	READ_INT_FIELD(step.step_id);
	READ_INT_FIELD(opstrategy);
	READ_NODE_FIELD(exprs);
	READ_NODE_FIELD(cmpfns);
	READ_BITMAPSET_FIELD(nullkeys);

	READ_DONE();
}

static PartitionPruneStepCombine *
_readPartitionPruneStepCombine(void)
{
	READ_LOCALS(PartitionPruneStepCombine);

	READ_INT_FIELD(step.step_id);
	READ_ENUM_FIELD(combineOp, PartitionPruneCombineOp);
	READ_NODE_FIELD(source_stepids);

	READ_DONE();
}

static PlanInvalItem *
_readPlanInvalItem(void)
{
	READ_LOCALS(PlanInvalItem);

	READ_INT_FIELD(cacheId);
	READ_UINT_FIELD(hashValue);

	READ_DONE();
}
