// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Window;
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "AdwAboutWindow")]
    pub struct AboutWindow(Object<ffi::AdwAboutWindow, ffi::AdwAboutWindowClass>) @extends Window, gtk::Window, gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget, gtk::Native, gtk::Root, gtk::ShortcutManager;

    match fn {
        type_ => || ffi::adw_about_window_get_type(),
    }
}

impl AboutWindow {
    #[doc(alias = "adw_about_window_new")]
    pub fn new() -> AboutWindow {
        assert_initialized_main_thread!();
        unsafe { gtk::Widget::from_glib_none(ffi::adw_about_window_new()).unsafe_cast() }
    }

    #[cfg(feature = "v1_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_4")))]
    #[doc(alias = "adw_about_window_new_from_appdata")]
    #[doc(alias = "new_from_appdata")]
    pub fn from_appdata(resource_path: &str, release_notes_version: Option<&str>) -> AboutWindow {
        assert_initialized_main_thread!();
        unsafe {
            gtk::Widget::from_glib_none(ffi::adw_about_window_new_from_appdata(
                resource_path.to_glib_none().0,
                release_notes_version.to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`AboutWindow`] objects.
    ///
    /// This method returns an instance of [`AboutWindowBuilder`](crate::builders::AboutWindowBuilder) which can be used to create [`AboutWindow`] objects.
    pub fn builder() -> AboutWindowBuilder {
        AboutWindowBuilder::new()
    }

    #[doc(alias = "adw_about_window_add_acknowledgement_section")]
    pub fn add_acknowledgement_section(&self, name: Option<&str>, people: &[&str]) {
        unsafe {
            ffi::adw_about_window_add_acknowledgement_section(
                self.to_glib_none().0,
                name.to_glib_none().0,
                people.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_window_add_credit_section")]
    pub fn add_credit_section(&self, name: Option<&str>, people: &[&str]) {
        unsafe {
            ffi::adw_about_window_add_credit_section(
                self.to_glib_none().0,
                name.to_glib_none().0,
                people.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_window_add_legal_section")]
    pub fn add_legal_section(
        &self,
        title: &str,
        copyright: Option<&str>,
        license_type: gtk::License,
        license: Option<&str>,
    ) {
        unsafe {
            ffi::adw_about_window_add_legal_section(
                self.to_glib_none().0,
                title.to_glib_none().0,
                copyright.to_glib_none().0,
                license_type.into_glib(),
                license.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_window_add_link")]
    pub fn add_link(&self, title: &str, url: &str) {
        unsafe {
            ffi::adw_about_window_add_link(
                self.to_glib_none().0,
                title.to_glib_none().0,
                url.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_window_get_application_icon")]
    #[doc(alias = "get_application_icon")]
    pub fn application_icon(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_about_window_get_application_icon(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_window_get_application_name")]
    #[doc(alias = "get_application_name")]
    pub fn application_name(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_about_window_get_application_name(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_window_get_artists")]
    #[doc(alias = "get_artists")]
    pub fn artists(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::adw_about_window_get_artists(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_window_get_comments")]
    #[doc(alias = "get_comments")]
    pub fn comments(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::adw_about_window_get_comments(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_about_window_get_copyright")]
    #[doc(alias = "get_copyright")]
    pub fn copyright(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::adw_about_window_get_copyright(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_about_window_get_debug_info")]
    #[doc(alias = "get_debug_info")]
    pub fn debug_info(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::adw_about_window_get_debug_info(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_about_window_get_debug_info_filename")]
    #[doc(alias = "get_debug_info_filename")]
    pub fn debug_info_filename(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_about_window_get_debug_info_filename(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_window_get_designers")]
    #[doc(alias = "get_designers")]
    pub fn designers(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::adw_about_window_get_designers(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_window_get_developer_name")]
    #[doc(alias = "get_developer_name")]
    pub fn developer_name(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_about_window_get_developer_name(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_window_get_developers")]
    #[doc(alias = "get_developers")]
    pub fn developers(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::adw_about_window_get_developers(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_window_get_documenters")]
    #[doc(alias = "get_documenters")]
    pub fn documenters(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::adw_about_window_get_documenters(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_window_get_issue_url")]
    #[doc(alias = "get_issue_url")]
    pub fn issue_url(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::adw_about_window_get_issue_url(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_about_window_get_license")]
    #[doc(alias = "get_license")]
    pub fn license(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::adw_about_window_get_license(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_about_window_get_license_type")]
    #[doc(alias = "get_license_type")]
    pub fn license_type(&self) -> gtk::License {
        unsafe {
            from_glib(ffi::adw_about_window_get_license_type(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_window_get_release_notes")]
    #[doc(alias = "get_release_notes")]
    pub fn release_notes(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_about_window_get_release_notes(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_window_get_release_notes_version")]
    #[doc(alias = "get_release_notes_version")]
    pub fn release_notes_version(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_about_window_get_release_notes_version(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_window_get_support_url")]
    #[doc(alias = "get_support_url")]
    pub fn support_url(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::adw_about_window_get_support_url(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_about_window_get_translator_credits")]
    #[doc(alias = "get_translator_credits")]
    pub fn translator_credits(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_about_window_get_translator_credits(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_window_get_version")]
    #[doc(alias = "get_version")]
    pub fn version(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::adw_about_window_get_version(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_about_window_get_website")]
    #[doc(alias = "get_website")]
    pub fn website(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::adw_about_window_get_website(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_about_window_set_application_icon")]
    pub fn set_application_icon(&self, application_icon: &str) {
        unsafe {
            ffi::adw_about_window_set_application_icon(
                self.to_glib_none().0,
                application_icon.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_window_set_application_name")]
    pub fn set_application_name(&self, application_name: &str) {
        unsafe {
            ffi::adw_about_window_set_application_name(
                self.to_glib_none().0,
                application_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_window_set_artists")]
    pub fn set_artists(&self, artists: &[&str]) {
        unsafe {
            ffi::adw_about_window_set_artists(self.to_glib_none().0, artists.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_about_window_set_comments")]
    pub fn set_comments(&self, comments: &str) {
        unsafe {
            ffi::adw_about_window_set_comments(self.to_glib_none().0, comments.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_about_window_set_copyright")]
    pub fn set_copyright(&self, copyright: &str) {
        unsafe {
            ffi::adw_about_window_set_copyright(self.to_glib_none().0, copyright.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_about_window_set_debug_info")]
    pub fn set_debug_info(&self, debug_info: &str) {
        unsafe {
            ffi::adw_about_window_set_debug_info(
                self.to_glib_none().0,
                debug_info.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_window_set_debug_info_filename")]
    pub fn set_debug_info_filename(&self, filename: &str) {
        unsafe {
            ffi::adw_about_window_set_debug_info_filename(
                self.to_glib_none().0,
                filename.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_window_set_designers")]
    pub fn set_designers(&self, designers: &[&str]) {
        unsafe {
            ffi::adw_about_window_set_designers(self.to_glib_none().0, designers.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_about_window_set_developer_name")]
    pub fn set_developer_name(&self, developer_name: &str) {
        unsafe {
            ffi::adw_about_window_set_developer_name(
                self.to_glib_none().0,
                developer_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_window_set_developers")]
    pub fn set_developers(&self, developers: &[&str]) {
        unsafe {
            ffi::adw_about_window_set_developers(
                self.to_glib_none().0,
                developers.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_window_set_documenters")]
    pub fn set_documenters(&self, documenters: &[&str]) {
        unsafe {
            ffi::adw_about_window_set_documenters(
                self.to_glib_none().0,
                documenters.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_window_set_issue_url")]
    pub fn set_issue_url(&self, issue_url: &str) {
        unsafe {
            ffi::adw_about_window_set_issue_url(self.to_glib_none().0, issue_url.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_about_window_set_license")]
    pub fn set_license(&self, license: &str) {
        unsafe {
            ffi::adw_about_window_set_license(self.to_glib_none().0, license.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_about_window_set_license_type")]
    pub fn set_license_type(&self, license_type: gtk::License) {
        unsafe {
            ffi::adw_about_window_set_license_type(self.to_glib_none().0, license_type.into_glib());
        }
    }

    #[doc(alias = "adw_about_window_set_release_notes")]
    pub fn set_release_notes(&self, release_notes: &str) {
        unsafe {
            ffi::adw_about_window_set_release_notes(
                self.to_glib_none().0,
                release_notes.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_window_set_release_notes_version")]
    pub fn set_release_notes_version(&self, version: &str) {
        unsafe {
            ffi::adw_about_window_set_release_notes_version(
                self.to_glib_none().0,
                version.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_window_set_support_url")]
    pub fn set_support_url(&self, support_url: &str) {
        unsafe {
            ffi::adw_about_window_set_support_url(
                self.to_glib_none().0,
                support_url.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_window_set_translator_credits")]
    pub fn set_translator_credits(&self, translator_credits: &str) {
        unsafe {
            ffi::adw_about_window_set_translator_credits(
                self.to_glib_none().0,
                translator_credits.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_window_set_version")]
    pub fn set_version(&self, version: &str) {
        unsafe {
            ffi::adw_about_window_set_version(self.to_glib_none().0, version.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_about_window_set_website")]
    pub fn set_website(&self, website: &str) {
        unsafe {
            ffi::adw_about_window_set_website(self.to_glib_none().0, website.to_glib_none().0);
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "activate-link")]
    pub fn connect_activate_link<F: Fn(&Self, &str) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn activate_link_trampoline<
            F: Fn(&AboutWindow, &str) -> bool + 'static,
        >(
            this: *mut ffi::AdwAboutWindow,
            uri: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &glib::GString::from_glib_borrow(uri),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-link\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    activate_link_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "application-icon")]
    pub fn connect_application_icon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_application_icon_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::application-icon\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_application_icon_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "application-name")]
    pub fn connect_application_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_application_name_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::application-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_application_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "artists")]
    pub fn connect_artists_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_artists_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::artists\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_artists_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "comments")]
    pub fn connect_comments_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_comments_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::comments\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_comments_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "copyright")]
    pub fn connect_copyright_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_copyright_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::copyright\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_copyright_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "debug-info")]
    pub fn connect_debug_info_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_debug_info_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::debug-info\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_debug_info_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "debug-info-filename")]
    pub fn connect_debug_info_filename_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_debug_info_filename_trampoline<
            F: Fn(&AboutWindow) + 'static,
        >(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::debug-info-filename\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_debug_info_filename_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "designers")]
    pub fn connect_designers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_designers_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::designers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_designers_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "developer-name")]
    pub fn connect_developer_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_developer_name_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::developer-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_developer_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "developers")]
    pub fn connect_developers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_developers_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::developers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_developers_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "documenters")]
    pub fn connect_documenters_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_documenters_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::documenters\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_documenters_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "issue-url")]
    pub fn connect_issue_url_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_issue_url_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::issue-url\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_issue_url_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "license")]
    pub fn connect_license_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_license_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::license\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_license_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "license-type")]
    pub fn connect_license_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_license_type_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::license-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_license_type_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "release-notes")]
    pub fn connect_release_notes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_release_notes_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::release-notes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_release_notes_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "release-notes-version")]
    pub fn connect_release_notes_version_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_release_notes_version_trampoline<
            F: Fn(&AboutWindow) + 'static,
        >(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::release-notes-version\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_release_notes_version_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "support-url")]
    pub fn connect_support_url_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_support_url_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::support-url\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_support_url_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "translator-credits")]
    pub fn connect_translator_credits_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_translator_credits_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::translator-credits\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_translator_credits_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "version")]
    pub fn connect_version_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_version_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::version\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_version_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    #[doc(alias = "website")]
    pub fn connect_website_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_website_trampoline<F: Fn(&AboutWindow) + 'static>(
            this: *mut ffi::AdwAboutWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::website\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_website_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[cfg(feature = "v1_2")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
impl Default for AboutWindow {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`AboutWindow`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct AboutWindowBuilder {
    builder: glib::object::ObjectBuilder<'static, AboutWindow>,
}

impl AboutWindowBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn application_icon(self, application_icon: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("application-icon", application_icon.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn application_name(self, application_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("application-name", application_name.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn artists(self, artists: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("artists", artists.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn comments(self, comments: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("comments", comments.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn copyright(self, copyright: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("copyright", copyright.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn debug_info(self, debug_info: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("debug-info", debug_info.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn debug_info_filename(self, debug_info_filename: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("debug-info-filename", debug_info_filename.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn designers(self, designers: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("designers", designers.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn developer_name(self, developer_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("developer-name", developer_name.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn developers(self, developers: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("developers", developers.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn documenters(self, documenters: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("documenters", documenters.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn issue_url(self, issue_url: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("issue-url", issue_url.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn license(self, license: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("license", license.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn license_type(self, license_type: gtk::License) -> Self {
        Self {
            builder: self.builder.property("license-type", license_type),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn release_notes(self, release_notes: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("release-notes", release_notes.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn release_notes_version(self, release_notes_version: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("release-notes-version", release_notes_version.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn support_url(self, support_url: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("support-url", support_url.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn translator_credits(self, translator_credits: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("translator-credits", translator_credits.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn version(self, version: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("version", version.into()),
        }
    }

    #[cfg(feature = "v1_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_2")))]
    pub fn website(self, website: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("website", website.into()),
        }
    }

    pub fn content(self, content: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self.builder.property("content", content.clone().upcast()),
        }
    }

    pub fn application(self, application: &impl IsA<gtk::Application>) -> Self {
        Self {
            builder: self
                .builder
                .property("application", application.clone().upcast()),
        }
    }

    pub fn decorated(self, decorated: bool) -> Self {
        Self {
            builder: self.builder.property("decorated", decorated),
        }
    }

    pub fn default_height(self, default_height: i32) -> Self {
        Self {
            builder: self.builder.property("default-height", default_height),
        }
    }

    pub fn default_widget(self, default_widget: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("default-widget", default_widget.clone().upcast()),
        }
    }

    pub fn default_width(self, default_width: i32) -> Self {
        Self {
            builder: self.builder.property("default-width", default_width),
        }
    }

    pub fn deletable(self, deletable: bool) -> Self {
        Self {
            builder: self.builder.property("deletable", deletable),
        }
    }

    pub fn destroy_with_parent(self, destroy_with_parent: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("destroy-with-parent", destroy_with_parent),
        }
    }

    pub fn display(self, display: &gdk::Display) -> Self {
        Self {
            builder: self.builder.property("display", display.clone()),
        }
    }

    pub fn focus_visible(self, focus_visible: bool) -> Self {
        Self {
            builder: self.builder.property("focus-visible", focus_visible),
        }
    }

    pub fn focus_widget(self, focus_widget: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("focus-widget", focus_widget.clone().upcast()),
        }
    }

    pub fn fullscreened(self, fullscreened: bool) -> Self {
        Self {
            builder: self.builder.property("fullscreened", fullscreened),
        }
    }

    #[cfg(feature = "gtk_v4_2")]
    #[cfg_attr(docsrs, doc(cfg(feature = "gtk_v4_2")))]
    pub fn handle_menubar_accel(self, handle_menubar_accel: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("handle-menubar-accel", handle_menubar_accel),
        }
    }

    pub fn hide_on_close(self, hide_on_close: bool) -> Self {
        Self {
            builder: self.builder.property("hide-on-close", hide_on_close),
        }
    }

    pub fn icon_name(self, icon_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("icon-name", icon_name.into()),
        }
    }

    pub fn maximized(self, maximized: bool) -> Self {
        Self {
            builder: self.builder.property("maximized", maximized),
        }
    }

    pub fn mnemonics_visible(self, mnemonics_visible: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("mnemonics-visible", mnemonics_visible),
        }
    }

    pub fn modal(self, modal: bool) -> Self {
        Self {
            builder: self.builder.property("modal", modal),
        }
    }

    pub fn resizable(self, resizable: bool) -> Self {
        Self {
            builder: self.builder.property("resizable", resizable),
        }
    }

    pub fn startup_id(self, startup_id: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("startup-id", startup_id.into()),
        }
    }

    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    #[cfg(feature = "gtk_v4_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "gtk_v4_6")))]
    pub fn titlebar(self, titlebar: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self.builder.property("titlebar", titlebar.clone().upcast()),
        }
    }

    pub fn transient_for(self, transient_for: &impl IsA<gtk::Window>) -> Self {
        Self {
            builder: self
                .builder
                .property("transient-for", transient_for.clone().upcast()),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`AboutWindow`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> AboutWindow {
        self.builder.build()
    }
}

impl fmt::Display for AboutWindow {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("AboutWindow")
    }
}
