// python wrapper for vtkPVTransform
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVTransform.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVTransform(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVTransform_ClassNew(); }


static PyObject *
PyvtkPVTransform_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVTransform::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransform_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransform *op = static_cast<vtkPVTransform *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVTransform::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransform_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVTransform *tempr = vtkPVTransform::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransform_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransform *op = static_cast<vtkPVTransform *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVTransform *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVTransform::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransform_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVTransform::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransform_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransform *op = static_cast<vtkPVTransform *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVTransform::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransform_SetAbsolutePosition_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAbsolutePosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransform *op = static_cast<vtkPVTransform *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  double save0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetAbsolutePosition(temp0);
    }
    else
    {
      op->vtkPVTransform::SetAbsolutePosition(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransform_SetAbsolutePosition_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAbsolutePosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransform *op = static_cast<vtkPVTransform *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetAbsolutePosition(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVTransform::SetAbsolutePosition(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransform_SetAbsolutePosition(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkPVTransform_SetAbsolutePosition_s1(self, args);
    case 3:
      return PyvtkPVTransform_SetAbsolutePosition_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetAbsolutePosition");
  return nullptr;
}


static PyObject *
PyvtkPVTransform_GetAbsolutePosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAbsolutePosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransform *op = static_cast<vtkPVTransform *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetAbsolutePosition() :
      op->vtkPVTransform::GetAbsolutePosition());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransform_SetAbsoluteRotation_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAbsoluteRotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransform *op = static_cast<vtkPVTransform *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  double save0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetAbsoluteRotation(temp0);
    }
    else
    {
      op->vtkPVTransform::SetAbsoluteRotation(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransform_SetAbsoluteRotation_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAbsoluteRotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransform *op = static_cast<vtkPVTransform *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetAbsoluteRotation(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVTransform::SetAbsoluteRotation(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransform_SetAbsoluteRotation(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkPVTransform_SetAbsoluteRotation_s1(self, args);
    case 3:
      return PyvtkPVTransform_SetAbsoluteRotation_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetAbsoluteRotation");
  return nullptr;
}


static PyObject *
PyvtkPVTransform_GetAbsoluteRotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAbsoluteRotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransform *op = static_cast<vtkPVTransform *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetAbsoluteRotation() :
      op->vtkPVTransform::GetAbsoluteRotation());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVTransform_SetAbsoluteScale_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAbsoluteScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransform *op = static_cast<vtkPVTransform *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  double save0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetAbsoluteScale(temp0);
    }
    else
    {
      op->vtkPVTransform::SetAbsoluteScale(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransform_SetAbsoluteScale_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAbsoluteScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransform *op = static_cast<vtkPVTransform *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetAbsoluteScale(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVTransform::SetAbsoluteScale(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVTransform_SetAbsoluteScale(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkPVTransform_SetAbsoluteScale_s1(self, args);
    case 3:
      return PyvtkPVTransform_SetAbsoluteScale_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetAbsoluteScale");
  return nullptr;
}


static PyObject *
PyvtkPVTransform_GetAbsoluteScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAbsoluteScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVTransform *op = static_cast<vtkPVTransform *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetAbsoluteScale() :
      op->vtkPVTransform::GetAbsoluteScale());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVTransform_Methods[] = {
  {"IsTypeOf", PyvtkPVTransform_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVTransform_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVTransform_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVTransform\nC++: static vtkPVTransform *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVTransform_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVTransform\nC++: vtkPVTransform *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVTransform_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVTransform_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetAbsolutePosition", PyvtkPVTransform_SetAbsolutePosition, METH_VARARGS,
   "SetAbsolutePosition(self, xyz:[float, float, float]) -> None\nC++: void SetAbsolutePosition(double xyz[3])\nSetAbsolutePosition(self, x:float, y:float, z:float) -> None\nC++: void SetAbsolutePosition(double x, double y, double z)\n\nGet/Set Position of the transform.\n"},
  {"GetAbsolutePosition", PyvtkPVTransform_GetAbsolutePosition, METH_VARARGS,
   "GetAbsolutePosition(self) -> (float, float, float)\nC++: virtual double *GetAbsolutePosition()\n\n"},
  {"SetAbsoluteRotation", PyvtkPVTransform_SetAbsoluteRotation, METH_VARARGS,
   "SetAbsoluteRotation(self, xyz:[float, float, float]) -> None\nC++: void SetAbsoluteRotation(double xyz[3])\nSetAbsoluteRotation(self, x:float, y:float, z:float) -> None\nC++: void SetAbsoluteRotation(double x, double y, double z)\n\nGet/Set Rotation for the transform.\n"},
  {"GetAbsoluteRotation", PyvtkPVTransform_GetAbsoluteRotation, METH_VARARGS,
   "GetAbsoluteRotation(self) -> (float, float, float)\nC++: virtual double *GetAbsoluteRotation()\n\n"},
  {"SetAbsoluteScale", PyvtkPVTransform_SetAbsoluteScale, METH_VARARGS,
   "SetAbsoluteScale(self, xyz:[float, float, float]) -> None\nC++: void SetAbsoluteScale(double xyz[3])\nSetAbsoluteScale(self, x:float, y:float, z:float) -> None\nC++: void SetAbsoluteScale(double x, double y, double z)\n\nGet/Set Scale for the transform.\n"},
  {"GetAbsoluteScale", PyvtkPVTransform_GetAbsoluteScale, METH_VARARGS,
   "GetAbsoluteScale(self) -> (float, float, float)\nC++: virtual double *GetAbsoluteScale()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVTransform_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("absolute_position"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVTransform_GetAbsolutePosition(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVTransform_SetAbsolutePosition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVTransform_SetAbsolutePosition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAbsolutePosition/SetAbsolutePosition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("absolute_rotation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVTransform_GetAbsoluteRotation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVTransform_SetAbsoluteRotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVTransform_SetAbsoluteRotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAbsoluteRotation/SetAbsoluteRotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("absolute_scale"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVTransform_GetAbsoluteScale(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVTransform_SetAbsoluteScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVTransform_SetAbsoluteScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAbsoluteScale/SetAbsoluteScale\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVTransform_Doc =
  "vtkPVTransform - baseclass for all ParaView vtkTransform class.\n\n"
  "Superclass: vtkTransform\n\n"
  "vtkPVTransform extend vtkTransform in the sens that it extend the\n"
  "vtkTransform API with absolute position/rotation/scale change and not\n"
  "incremental one like the vtkTransform does.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVTransform_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsMisc.vtkPVTransform", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVTransform_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVTransform_StaticNew()
{
  return vtkPVTransform::New();
}

PyObject *PyvtkPVTransform_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVTransform_Type, PyvtkPVTransform_Methods,
    "vtkPVTransform",
 &PyvtkPVTransform_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkTransform");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVTransform_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVTransform(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVTransform_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVTransform", o) != 0)
  {
    Py_DECREF(o);
  }

}

