// python wrapper for vtkGenericPropertyDecorator
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkGenericPropertyDecorator.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkGenericPropertyDecorator(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkGenericPropertyDecorator_ClassNew(); }

#ifndef DECLARED_PyvtkPropertyDecorator_ClassNew
extern "C" { PyObject *PyvtkPropertyDecorator_ClassNew(); }
#define DECLARED_PyvtkPropertyDecorator_ClassNew
#endif

static PyObject *
PyvtkGenericPropertyDecorator_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkGenericPropertyDecorator::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericPropertyDecorator_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericPropertyDecorator *op = static_cast<vtkGenericPropertyDecorator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkGenericPropertyDecorator::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericPropertyDecorator_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkGenericPropertyDecorator *tempr = vtkGenericPropertyDecorator::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericPropertyDecorator_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericPropertyDecorator *op = static_cast<vtkGenericPropertyDecorator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGenericPropertyDecorator *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkGenericPropertyDecorator::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericPropertyDecorator_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkGenericPropertyDecorator::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericPropertyDecorator_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericPropertyDecorator *op = static_cast<vtkGenericPropertyDecorator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkGenericPropertyDecorator::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericPropertyDecorator_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericPropertyDecorator *op = static_cast<vtkGenericPropertyDecorator *>(vp);

  vtkPVXMLElement *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkPVXMLElement") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    if (ap.IsBound())
    {
      op->Initialize(temp0, temp1);
    }
    else
    {
      op->vtkGenericPropertyDecorator::Initialize(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGenericPropertyDecorator_CanShow(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CanShow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericPropertyDecorator *op = static_cast<vtkGenericPropertyDecorator *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->CanShow(temp0) :
      op->vtkGenericPropertyDecorator::CanShow(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericPropertyDecorator_Enable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Enable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericPropertyDecorator *op = static_cast<vtkGenericPropertyDecorator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->Enable() :
      op->vtkGenericPropertyDecorator::Enable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGenericPropertyDecorator_UpdateState(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGenericPropertyDecorator *op = static_cast<vtkGenericPropertyDecorator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UpdateState();
    }
    else
    {
      op->vtkGenericPropertyDecorator::UpdateState();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGenericPropertyDecorator_Methods[] = {
  {"IsTypeOf", PyvtkGenericPropertyDecorator_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkGenericPropertyDecorator_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkGenericPropertyDecorator_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkGenericPropertyDecorator\nC++: static vtkGenericPropertyDecorator *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkGenericPropertyDecorator_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkGenericPropertyDecorator\nC++: vtkGenericPropertyDecorator *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkGenericPropertyDecorator_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkGenericPropertyDecorator_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Initialize", PyvtkGenericPropertyDecorator_Initialize, METH_VARARGS,
   "Initialize(self, config:vtkPVXMLElement, proxy:vtkSMProxy) -> None\nC++: void Initialize(vtkPVXMLElement *config, vtkSMProxy *proxy)\n    override;\n\nConstructor.\n\n@param xml The XML element from the `<Hints/>` section for the\n    proxy/property that\nresulted in the creation of the decorator. Decorators can be\nprovided configuration parameters from the XML.\n\n@param proxy The proxy that owns the property of this decorator\n"},
  {"CanShow", PyvtkGenericPropertyDecorator_CanShow, METH_VARARGS,
   "CanShow(self, show_advanced:bool) -> bool\nC++: bool CanShow(bool show_advanced) override;\n\nMethods overridden from vtkPropertyDecorator.\n"},
  {"Enable", PyvtkGenericPropertyDecorator_Enable, METH_VARARGS,
   "Enable(self) -> bool\nC++: bool Enable() override;\n\nOverride this method to override the enable state of the widget\nin the panel. This is called after the generic tests for advanced\nand text filtering are passed. Since there can be multiple\ndecorators, the first decorator that returns 'false' wins.\nDefault implementation returns true. Thus subclasses typically\noverride this method only to force the widget disabled given the\ncurrent state.\n"},
  {"UpdateState", PyvtkGenericPropertyDecorator_UpdateState, METH_VARARGS,
   "UpdateState(self) -> None\nC++: void UpdateState()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkGenericPropertyDecorator_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkGenericPropertyDecorator_Doc =
  "vtkGenericPropertyDecorator - vtkGenericPropertyDecorator is a\nvtkPropertyDecorator that supports multiple common use cases from a\nvtkPropertyDecorator.\n\n"
  "Superclass: vtkPropertyDecorator\n\n"
  "The use cases supported are as follows:\n"
  "\\li 1. enabling the vtkPropertyWidget when the value of another\n"
  "  property element matches a specific value (disabling otherwise).\n"
  "\\li 2. similar to 1, except instead of enabling/disabling the widget\n"
  "    is made\n"
  "  \"default\" when the values match and \"advanced\" otherwise.\n"
  "\\li 3. enabling the vtkPropertyWidget when the array named in the\n"
  "    property\n"
  "  has a specified number of components.\n"
  "\\li 4. as well as \"inverse\" of all the above i.e. when the value\n"
  "    doesn't\n"
  "  match the specified value. Example usages:\n"
  "\\li VectorScaleMode, Stride, Seed, MaximumNumberOfSamplePoints\n"
  "    properties on the Glyph proxy.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkGenericPropertyDecorator_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingApplicationComponents.vtkGenericPropertyDecorator", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkGenericPropertyDecorator_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkGenericPropertyDecorator_StaticNew()
{
  return vtkGenericPropertyDecorator::New();
}

PyObject *PyvtkGenericPropertyDecorator_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkGenericPropertyDecorator_Type, PyvtkGenericPropertyDecorator_Methods,
    "vtkGenericPropertyDecorator",
 &PyvtkGenericPropertyDecorator_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPropertyDecorator_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkGenericPropertyDecorator_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkGenericPropertyDecorator(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkGenericPropertyDecorator_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkGenericPropertyDecorator", o) != 0)
  {
    Py_DECREF(o);
  }

}

