// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

// Object factories should never have deprecation warnings.
// NOLINTNEXTLINE(modernize-macro-to-enum)
#define VTK_DEPRECATION_LEVEL 0

#include "vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory.h"
#include "vtkVersion.h"

// Include all of the classes we want to create overrides for.
#include "vtkPCGNSWriter.h"


VTK_ABI_NAMESPACE_BEGIN

vtkStandardNewMacro(vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory);

// Now create the functions to create overrides with.
VTK_CREATE_CREATE_FUNCTION(vtkPCGNSWriter)


vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory::vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory()
{
this->RegisterOverride("vtkCGNSWriter", "vtkPCGNSWriter", "Override for ParaView::VTKExtensionsIOParallelCGNSWriter module", 1, vtkObjectFactoryCreatevtkPCGNSWriter);

}

const char * vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory::GetVTKSourceVersion() VTK_FUTURE_CONST
{
  return VTK_SOURCE_VERSION;
}

void vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory::PrintSelf(ostream &os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}

// Registration of object factories.
static unsigned int vtkPVVTKExtensionsIOParallelCGNSWriterCount = 0;

VTKPVVTKEXTENSIONSIOPARALLELCGNSWRITER_EXPORT void vtkPVVTKExtensionsIOParallelCGNSWriter_AutoInit_Construct()
{
  if(++vtkPVVTKExtensionsIOParallelCGNSWriterCount == 1)
  {


    vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory* factory = vtkPVVTKExtensionsIOParallelCGNSWriterObjectFactory::New();
    if (factory)
    {
      // vtkObjectFactory keeps a reference to the "factory",
      vtkObjectFactory::RegisterFactory(factory);
      factory->Delete();
    }
  }
}
VTK_ABI_NAMESPACE_END
