#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkDataMineBlockReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDataMineDrillHoleReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDataMineDummyReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDataMinePerimeterReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDataMinePointReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDataMineReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDataMineWireFrameReader_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkDatamineReadersCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkDataMineBlockReader_Init(csi);
  vtkDataMineDrillHoleReader_Init(csi);
  vtkDataMineDummyReader_Init(csi);
  vtkDataMinePerimeterReader_Init(csi);
  vtkDataMinePointReader_Init(csi);
  vtkDataMineReader_Init(csi);
  vtkDataMineWireFrameReader_Init(csi);
}
