// python wrapper for vtkSMTransferFunctionPresets
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMTransferFunctionPresets.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMTransferFunctionPresets(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMTransferFunctionPresets_ClassNew(); }


static PyObject *
PyvtkSMTransferFunctionPresets_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMTransferFunctionPresets::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionPresets *op = static_cast<vtkSMTransferFunctionPresets *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMTransferFunctionPresets::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMTransferFunctionPresets *tempr = vtkSMTransferFunctionPresets::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionPresets *op = static_cast<vtkSMTransferFunctionPresets *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMTransferFunctionPresets *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMTransferFunctionPresets::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMTransferFunctionPresets::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionPresets *op = static_cast<vtkSMTransferFunctionPresets *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMTransferFunctionPresets::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_GetInstance(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetInstance");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkSMTransferFunctionPresets *tempr = vtkSMTransferFunctionPresets::GetInstance();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_GetNumberOfPresets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfPresets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionPresets *op = static_cast<vtkSMTransferFunctionPresets *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfPresets() :
      op->vtkSMTransferFunctionPresets::GetNumberOfPresets());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_GetPresetAsString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPresetAsString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionPresets *op = static_cast<vtkSMTransferFunctionPresets *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetPresetAsString(temp0) :
      op->vtkSMTransferFunctionPresets::GetPresetAsString(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_AddPreset(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddPreset");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionPresets *op = static_cast<vtkSMTransferFunctionPresets *>(vp);

  const char *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->AddPreset(temp0, temp1) :
      op->vtkSMTransferFunctionPresets::AddPreset(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_RemovePreset(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemovePreset");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionPresets *op = static_cast<vtkSMTransferFunctionPresets *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->RemovePreset(temp0) :
      op->vtkSMTransferFunctionPresets::RemovePreset(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_GetPresetName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPresetName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionPresets *op = static_cast<vtkSMTransferFunctionPresets *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetPresetName(temp0) :
      op->vtkSMTransferFunctionPresets::GetPresetName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_HasPreset(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasPreset");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionPresets *op = static_cast<vtkSMTransferFunctionPresets *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasPreset(temp0) :
      op->vtkSMTransferFunctionPresets::HasPreset(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_GetPresetHasOpacities(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPresetHasOpacities");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionPresets *op = static_cast<vtkSMTransferFunctionPresets *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPresetHasOpacities(temp0) :
      op->vtkSMTransferFunctionPresets::GetPresetHasOpacities(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_GetPresetHasIndexedColors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPresetHasIndexedColors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionPresets *op = static_cast<vtkSMTransferFunctionPresets *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPresetHasIndexedColors(temp0) :
      op->vtkSMTransferFunctionPresets::GetPresetHasIndexedColors(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_GetPresetHasAnnotations(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPresetHasAnnotations");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionPresets *op = static_cast<vtkSMTransferFunctionPresets *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPresetHasAnnotations(temp0) :
      op->vtkSMTransferFunctionPresets::GetPresetHasAnnotations(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_IsPresetBuiltin(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsPresetBuiltin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionPresets *op = static_cast<vtkSMTransferFunctionPresets *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsPresetBuiltin(temp0) :
      op->vtkSMTransferFunctionPresets::IsPresetBuiltin(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_RenamePreset(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RenamePreset");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionPresets *op = static_cast<vtkSMTransferFunctionPresets *>(vp);

  unsigned int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->RenamePreset(temp0, temp1) :
      op->vtkSMTransferFunctionPresets::RenamePreset(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_ImportPresets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ImportPresets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionPresets *op = static_cast<vtkSMTransferFunctionPresets *>(vp);

  const char *temp0 = nullptr;
  unsigned int temp1 = 0x10;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    bool tempr = (ap.IsBound() ?
      op->ImportPresets(temp0, temp1) :
      op->vtkSMTransferFunctionPresets::ImportPresets(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMTransferFunctionPresets_ReloadPresets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReloadPresets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMTransferFunctionPresets *op = static_cast<vtkSMTransferFunctionPresets *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ReloadPresets();
    }
    else
    {
      op->vtkSMTransferFunctionPresets::ReloadPresets();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMTransferFunctionPresets_Methods[] = {
  {"IsTypeOf", PyvtkSMTransferFunctionPresets_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMTransferFunctionPresets_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMTransferFunctionPresets_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMTransferFunctionPresets\nC++: static vtkSMTransferFunctionPresets *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMTransferFunctionPresets_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMTransferFunctionPresets\nC++: vtkSMTransferFunctionPresets *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMTransferFunctionPresets_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMTransferFunctionPresets_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetInstance", PyvtkSMTransferFunctionPresets_GetInstance, METH_VARARGS,
   "GetInstance() -> vtkSMTransferFunctionPresets\nC++: static vtkSMTransferFunctionPresets *GetInstance()\n\nGet singleton instance.\n"},
  {"GetNumberOfPresets", PyvtkSMTransferFunctionPresets_GetNumberOfPresets, METH_VARARGS,
   "GetNumberOfPresets(self) -> int\nC++: unsigned int GetNumberOfPresets()\n\nReturns the number of presets current available (including\nbuiltin and custom).\n"},
  {"GetPresetAsString", PyvtkSMTransferFunctionPresets_GetPresetAsString, METH_VARARGS,
   "GetPresetAsString(self, index:int) -> str\nC++: std::string GetPresetAsString(unsigned int index)\n\nGets the raw text for a preset given its index. The preset is\nprovided as a JSON string. Returns an empty string when not\navailable.\n"},
  {"AddPreset", PyvtkSMTransferFunctionPresets_AddPreset, METH_VARARGS,
   "AddPreset(self, name:str, preset:str) -> bool\nC++: bool AddPreset(const char *name, const std::string &preset)\n\nAdd a new preset. This will get saved across sessions using\nvtkSMSettings, as appropriate. If name provided already exists,\nthis will override the existing preset (even for builtin\npresets).preset must be a valid JSON string. If not, this will\nreturn failure.\n"},
  {"RemovePreset", PyvtkSMTransferFunctionPresets_RemovePreset, METH_VARARGS,
   "RemovePreset(self, index:int) -> bool\nC++: bool RemovePreset(unsigned int index)\n\nRemove a preset. This has no effect for builtin presets.\n"},
  {"GetPresetName", PyvtkSMTransferFunctionPresets_GetPresetName, METH_VARARGS,
   "GetPresetName(self, index:int) -> str\nC++: std::string GetPresetName(unsigned int index)\n\nReturns the name for a preset at the given index.\n"},
  {"HasPreset", PyvtkSMTransferFunctionPresets_HasPreset, METH_VARARGS,
   "HasPreset(self, name:str) -> bool\nC++: bool HasPreset(const char *name)\n\nReturns true if a present with given name exists.\n"},
  {"GetPresetHasOpacities", PyvtkSMTransferFunctionPresets_GetPresetHasOpacities, METH_VARARGS,
   "GetPresetHasOpacities(self, index:int) -> bool\nC++: bool GetPresetHasOpacities(unsigned int index)\n\n"},
  {"GetPresetHasIndexedColors", PyvtkSMTransferFunctionPresets_GetPresetHasIndexedColors, METH_VARARGS,
   "GetPresetHasIndexedColors(self, index:int) -> bool\nC++: bool GetPresetHasIndexedColors(unsigned int index)\n\n"},
  {"GetPresetHasAnnotations", PyvtkSMTransferFunctionPresets_GetPresetHasAnnotations, METH_VARARGS,
   "GetPresetHasAnnotations(self, index:int) -> bool\nC++: bool GetPresetHasAnnotations(unsigned int index)\n\n"},
  {"IsPresetBuiltin", PyvtkSMTransferFunctionPresets_IsPresetBuiltin, METH_VARARGS,
   "IsPresetBuiltin(self, index:int) -> bool\nC++: bool IsPresetBuiltin(unsigned int index)\n\nReturns true if the preset is a builtin preset. The preset is\nidentified by its index.\n"},
  {"RenamePreset", PyvtkSMTransferFunctionPresets_RenamePreset, METH_VARARGS,
   "RenamePreset(self, index:int, newname:str) -> bool\nC++: bool RenamePreset(unsigned int index, const char *newname)\n\nRename a preset.\n"},
  {"ImportPresets", PyvtkSMTransferFunctionPresets_ImportPresets, METH_VARARGS,
   "ImportPresets(self, filename:str, location:int=0x10) -> bool\nC++: bool ImportPresets(const char *filename,\n    vtkTypeUInt32 location=0x10)\n\nLoad presets from a file. All presets are added to \"custom\"\npresets list and are considered as non-builtin. If the filename\nends with a .xml, it's assumed to be a legacy color map XML and\nwill be converted to the new format before processing.\n"},
  {"ReloadPresets", PyvtkSMTransferFunctionPresets_ReloadPresets, METH_VARARGS,
   "ReloadPresets(self) -> None\nC++: void ReloadPresets()\n\nReload the presets from the configuration file.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMTransferFunctionPresets_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("instance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMTransferFunctionPresets_GetInstance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInstance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_presets"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMTransferFunctionPresets_GetNumberOfPresets(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfPresets\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMTransferFunctionPresets_Doc =
  "vtkSMTransferFunctionPresets - manages presets for color, opacity,\nand annotation presets.\n\n"
  "Superclass: vtkSMObject\n\n"
  "vtkSMTransferFunctionPresets is a manager to manage all color,\n"
  "opacity, and annotation presets. It also uses vtkSMSettings to\n"
  "support persistent customizations besides hard-coded/builtin presets.\n\n"
  "vtkSMTransferFunctionPresets is designed as a singleton, accessible\n"
  "through the `GetInstance()` static method. Public API ensure that\n"
  "presets are loaded, but a reload can be explictly asked (see\n"
  "`ReloadPresets()`).\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMTransferFunctionPresets_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMTransferFunctionPresets", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMTransferFunctionPresets_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMTransferFunctionPresets_StaticNew()
{
  return vtkSMTransferFunctionPresets::New();
}

PyObject *PyvtkSMTransferFunctionPresets_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMTransferFunctionPresets_Type, PyvtkSMTransferFunctionPresets_Methods,
    "vtkSMTransferFunctionPresets",
 &PyvtkSMTransferFunctionPresets_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSMObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMTransferFunctionPresets_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMTransferFunctionPresets(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMTransferFunctionPresets_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMTransferFunctionPresets", o) != 0)
  {
    Py_DECREF(o);
  }

}

