// python wrapper for vtkPVCAVEConfigInformation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkTuple.h"
#include "vtkPVCAVEConfigInformation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVCAVEConfigInformation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVCAVEConfigInformation_ClassNew(); }

#ifndef DECLARED_PyvtkPVInformation_ClassNew
extern "C" { PyObject *PyvtkPVInformation_ClassNew(); }
#define DECLARED_PyvtkPVInformation_ClassNew
#endif

static PyObject *
PyvtkPVCAVEConfigInformation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVCAVEConfigInformation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCAVEConfigInformation *op = static_cast<vtkPVCAVEConfigInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVCAVEConfigInformation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVCAVEConfigInformation *tempr = vtkPVCAVEConfigInformation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCAVEConfigInformation *op = static_cast<vtkPVCAVEConfigInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVCAVEConfigInformation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVCAVEConfigInformation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVCAVEConfigInformation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCAVEConfigInformation *op = static_cast<vtkPVCAVEConfigInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVCAVEConfigInformation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_CopyFromObject(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CopyFromObject");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCAVEConfigInformation *op = static_cast<vtkPVCAVEConfigInformation *>(vp);

  vtkObject *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObject"))
  {
    if (ap.IsBound())
    {
      op->CopyFromObject(temp0);
    }
    else
    {
      op->vtkPVCAVEConfigInformation::CopyFromObject(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_AddInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCAVEConfigInformation *op = static_cast<vtkPVCAVEConfigInformation *>(vp);

  vtkPVInformation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVInformation"))
  {
    if (ap.IsBound())
    {
      op->AddInformation(temp0);
    }
    else
    {
      op->vtkPVCAVEConfigInformation::AddInformation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_GetIsInCAVE(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsInCAVE");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCAVEConfigInformation *op = static_cast<vtkPVCAVEConfigInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIsInCAVE() :
      op->vtkPVCAVEConfigInformation::GetIsInCAVE());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_GetEyeSeparation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEyeSeparation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCAVEConfigInformation *op = static_cast<vtkPVCAVEConfigInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetEyeSeparation() :
      op->vtkPVCAVEConfigInformation::GetEyeSeparation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_GetNumberOfDisplays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfDisplays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCAVEConfigInformation *op = static_cast<vtkPVCAVEConfigInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfDisplays() :
      op->vtkPVCAVEConfigInformation::GetNumberOfDisplays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_GetShowBorders(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetShowBorders");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCAVEConfigInformation *op = static_cast<vtkPVCAVEConfigInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetShowBorders() :
      op->vtkPVCAVEConfigInformation::GetShowBorders());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_GetFullScreen(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFullScreen");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCAVEConfigInformation *op = static_cast<vtkPVCAVEConfigInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetFullScreen() :
      op->vtkPVCAVEConfigInformation::GetFullScreen());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_GetGeometry(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGeometry");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCAVEConfigInformation *op = static_cast<vtkPVCAVEConfigInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkTuple<int, 4> tempr = (ap.IsBound() ?
      op->GetGeometry(temp0) :
      op->vtkPVCAVEConfigInformation::GetGeometry(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkTuple_IiLi4EE");
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_GetHasCorners(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHasCorners");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCAVEConfigInformation *op = static_cast<vtkPVCAVEConfigInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetHasCorners(temp0) :
      op->vtkPVCAVEConfigInformation::GetHasCorners(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_GetLowerLeft(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLowerLeft");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCAVEConfigInformation *op = static_cast<vtkPVCAVEConfigInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkTuple<double, 3> tempr = (ap.IsBound() ?
      op->GetLowerLeft(temp0) :
      op->vtkPVCAVEConfigInformation::GetLowerLeft(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkTuple_IdLi3EE");
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_GetLowerRight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLowerRight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCAVEConfigInformation *op = static_cast<vtkPVCAVEConfigInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkTuple<double, 3> tempr = (ap.IsBound() ?
      op->GetLowerRight(temp0) :
      op->vtkPVCAVEConfigInformation::GetLowerRight(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkTuple_IdLi3EE");
    }
  }

  return result;
}


static PyObject *
PyvtkPVCAVEConfigInformation_GetUpperRight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUpperRight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVCAVEConfigInformation *op = static_cast<vtkPVCAVEConfigInformation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkTuple<double, 3> tempr = (ap.IsBound() ?
      op->GetUpperRight(temp0) :
      op->vtkPVCAVEConfigInformation::GetUpperRight(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkTuple_IdLi3EE");
    }
  }

  return result;
}

static PyMethodDef PyvtkPVCAVEConfigInformation_Methods[] = {
  {"IsTypeOf", PyvtkPVCAVEConfigInformation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVCAVEConfigInformation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVCAVEConfigInformation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVCAVEConfigInformation\nC++: static vtkPVCAVEConfigInformation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVCAVEConfigInformation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVCAVEConfigInformation\nC++: vtkPVCAVEConfigInformation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVCAVEConfigInformation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVCAVEConfigInformation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"CopyFromObject", PyvtkPVCAVEConfigInformation_CopyFromObject, METH_VARARGS,
   "CopyFromObject(self, __a:vtkObject) -> None\nC++: void CopyFromObject(vtkObject *) override;\n\nTransfer information about a single object into this object.\n"},
  {"AddInformation", PyvtkPVCAVEConfigInformation_AddInformation, METH_VARARGS,
   "AddInformation(self, __a:vtkPVInformation) -> None\nC++: void AddInformation(vtkPVInformation *) override;\n\nMerge another information object.\n"},
  {"GetIsInCAVE", PyvtkPVCAVEConfigInformation_GetIsInCAVE, METH_VARARGS,
   "GetIsInCAVE(self) -> bool\nC++: virtual bool GetIsInCAVE()\n\nReturn the whether the system is in CAVE mode\n"},
  {"GetEyeSeparation", PyvtkPVCAVEConfigInformation_GetEyeSeparation, METH_VARARGS,
   "GetEyeSeparation(self) -> float\nC++: virtual double GetEyeSeparation()\n\nReturn the eye separation.\n"},
  {"GetNumberOfDisplays", PyvtkPVCAVEConfigInformation_GetNumberOfDisplays, METH_VARARGS,
   "GetNumberOfDisplays(self) -> int\nC++: virtual int GetNumberOfDisplays()\n\nReturn the number of displays.\n"},
  {"GetShowBorders", PyvtkPVCAVEConfigInformation_GetShowBorders, METH_VARARGS,
   "GetShowBorders(self) -> bool\nC++: virtual bool GetShowBorders()\n\nReturn whether or not borders are shown.\n"},
  {"GetFullScreen", PyvtkPVCAVEConfigInformation_GetFullScreen, METH_VARARGS,
   "GetFullScreen(self) -> bool\nC++: virtual bool GetFullScreen()\n\nReturn whether or not displays are fullscreen.\n"},
  {"GetGeometry", PyvtkPVCAVEConfigInformation_GetGeometry, METH_VARARGS,
   "GetGeometry(self, index:int) -> vtkTuple_IiLi4EE\nC++: virtual vtkTuple<int, 4> GetGeometry(int index)\n\nReturn the geometry of the indexed display.\n"},
  {"GetHasCorners", PyvtkPVCAVEConfigInformation_GetHasCorners, METH_VARARGS,
   "GetHasCorners(self, index:int) -> bool\nC++: virtual bool GetHasCorners(int index)\n\nReturn whether or not the indexed display has screen corners.\n"},
  {"GetLowerLeft", PyvtkPVCAVEConfigInformation_GetLowerLeft, METH_VARARGS,
   "GetLowerLeft(self, index:int) -> vtkTuple_IdLi3EE\nC++: virtual vtkTuple<double, 3> GetLowerLeft(int index)\n\nReturn the lower left corner of the indexed display.\n"},
  {"GetLowerRight", PyvtkPVCAVEConfigInformation_GetLowerRight, METH_VARARGS,
   "GetLowerRight(self, index:int) -> vtkTuple_IdLi3EE\nC++: virtual vtkTuple<double, 3> GetLowerRight(int index)\n\nReturn the lower right corner of the indexed display.\n"},
  {"GetUpperRight", PyvtkPVCAVEConfigInformation_GetUpperRight, METH_VARARGS,
   "GetUpperRight(self, index:int) -> vtkTuple_IdLi3EE\nC++: virtual vtkTuple<double, 3> GetUpperRight(int index)\n\nReturn the upper right corner of the indexed display.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVCAVEConfigInformation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("is_in_cave"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVCAVEConfigInformation_GetIsInCAVE(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIsInCAVE\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("eye_separation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVCAVEConfigInformation_GetEyeSeparation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEyeSeparation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("show_borders"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVCAVEConfigInformation_GetShowBorders(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetShowBorders\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("full_screen"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVCAVEConfigInformation_GetFullScreen(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFullScreen\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_displays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVCAVEConfigInformation_GetNumberOfDisplays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfDisplays\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVCAVEConfigInformation_Doc =
  "vtkPVCAVEConfigInformation - A vtkClientServerStream serializable\ncontainer intended to expose the api and information presented by\nvtkDisplayConfiguration.\n\n"
  "Superclass: vtkPVInformation\n\n"
  "The same pvx file is read on all server processes, so merging info\n"
  "from other servers is simply a matter of overwriting the current\n"
  "state with the one read from the stream or other object.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVCAVEConfigInformation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVCAVEConfigInformation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVCAVEConfigInformation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVCAVEConfigInformation_StaticNew()
{
  return vtkPVCAVEConfigInformation::New();
}

PyObject *PyvtkPVCAVEConfigInformation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVCAVEConfigInformation_Type, PyvtkPVCAVEConfigInformation_Methods,
    "vtkPVCAVEConfigInformation",
 &PyvtkPVCAVEConfigInformation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVInformation_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVCAVEConfigInformation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVCAVEConfigInformation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVCAVEConfigInformation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVCAVEConfigInformation", o) != 0)
  {
    Py_DECREF(o);
  }

}

