#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkAppendReduceFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAppendRectilinearGrid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAttributeDataReductionFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCompleteArrays_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkEnvironmentAnnotationFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMinMax_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPExtractHistogram_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVExtractHistogram2D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVBox_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVChangeOfBasisHelper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVCone_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVCylinder_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVFrustum_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVMergeTables_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVMergeTablesMultiBlock_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVPlane_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVRotateAroundOriginTransform_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkReductionFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSelectionSerializer_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkPVVTKExtensionsMiscCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkAppendReduceFilter_Init(csi);
  vtkAppendRectilinearGrid_Init(csi);
  vtkAttributeDataReductionFilter_Init(csi);
  vtkCompleteArrays_Init(csi);
  vtkEnvironmentAnnotationFilter_Init(csi);
  vtkMinMax_Init(csi);
  vtkPExtractHistogram_Init(csi);
  vtkPVExtractHistogram2D_Init(csi);
  vtkPVBox_Init(csi);
  vtkPVChangeOfBasisHelper_Init(csi);
  vtkPVCone_Init(csi);
  vtkPVCylinder_Init(csi);
  vtkPVFrustum_Init(csi);
  vtkPVMergeTables_Init(csi);
  vtkPVMergeTablesMultiBlock_Init(csi);
  vtkPVPlane_Init(csi);
  vtkPVTransform_Init(csi);
  vtkPVRotateAroundOriginTransform_Init(csi);
  vtkReductionFilter_Init(csi);
  vtkSelectionSerializer_Init(csi);
}
