// python wrapper for vtkBlockDeliveryPreprocessor
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkBlockDeliveryPreprocessor.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkBlockDeliveryPreprocessor(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkBlockDeliveryPreprocessor_ClassNew(); }


static PyObject *
PyvtkBlockDeliveryPreprocessor_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkBlockDeliveryPreprocessor::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkBlockDeliveryPreprocessor::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkBlockDeliveryPreprocessor *tempr = vtkBlockDeliveryPreprocessor::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkBlockDeliveryPreprocessor *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkBlockDeliveryPreprocessor::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkBlockDeliveryPreprocessor::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkBlockDeliveryPreprocessor::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_AddCompositeDataSetIndex(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddCompositeDataSetIndex");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AddCompositeDataSetIndex(temp0);
    }
    else
    {
      op->vtkBlockDeliveryPreprocessor::AddCompositeDataSetIndex(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_RemoveAllCompositeDataSetIndices(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllCompositeDataSetIndices");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllCompositeDataSetIndices();
    }
    else
    {
      op->vtkBlockDeliveryPreprocessor::RemoveAllCompositeDataSetIndices();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_SetGenerateCellConnectivity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateCellConnectivity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateCellConnectivity(temp0);
    }
    else
    {
      op->vtkBlockDeliveryPreprocessor::SetGenerateCellConnectivity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_GetGenerateCellConnectivity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateCellConnectivity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGenerateCellConnectivity() :
      op->vtkBlockDeliveryPreprocessor::GetGenerateCellConnectivity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_SetFieldAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFieldAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFieldAssociation(temp0);
    }
    else
    {
      op->vtkBlockDeliveryPreprocessor::SetFieldAssociation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_GetFieldAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFieldAssociation() :
      op->vtkBlockDeliveryPreprocessor::GetFieldAssociation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_SetFlattenTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFlattenTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFlattenTable(temp0);
    }
    else
    {
      op->vtkBlockDeliveryPreprocessor::SetFlattenTable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_GetFlattenTable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFlattenTable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFlattenTable() :
      op->vtkBlockDeliveryPreprocessor::GetFlattenTable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_SetSplitComponentsNamingMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSplitComponentsNamingMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSplitComponentsNamingMode(temp0);
    }
    else
    {
      op->vtkBlockDeliveryPreprocessor::SetSplitComponentsNamingMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_GetSplitComponentsNamingModeMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSplitComponentsNamingModeMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSplitComponentsNamingModeMinValue() :
      op->vtkBlockDeliveryPreprocessor::GetSplitComponentsNamingModeMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_GetSplitComponentsNamingModeMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSplitComponentsNamingModeMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSplitComponentsNamingModeMaxValue() :
      op->vtkBlockDeliveryPreprocessor::GetSplitComponentsNamingModeMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_GetSplitComponentsNamingMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSplitComponentsNamingMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSplitComponentsNamingMode() :
      op->vtkBlockDeliveryPreprocessor::GetSplitComponentsNamingMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_SetGenerateOriginalIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateOriginalIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateOriginalIds(temp0);
    }
    else
    {
      op->vtkBlockDeliveryPreprocessor::SetGenerateOriginalIds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBlockDeliveryPreprocessor_GetGenerateOriginalIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateOriginalIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBlockDeliveryPreprocessor *op = static_cast<vtkBlockDeliveryPreprocessor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGenerateOriginalIds() :
      op->vtkBlockDeliveryPreprocessor::GetGenerateOriginalIds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkBlockDeliveryPreprocessor_Methods[] = {
  {"IsTypeOf", PyvtkBlockDeliveryPreprocessor_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkBlockDeliveryPreprocessor_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkBlockDeliveryPreprocessor_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkBlockDeliveryPreprocessor\nC++: static vtkBlockDeliveryPreprocessor *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkBlockDeliveryPreprocessor_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkBlockDeliveryPreprocessor\nC++: vtkBlockDeliveryPreprocessor *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkBlockDeliveryPreprocessor_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkBlockDeliveryPreprocessor_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"AddCompositeDataSetIndex", PyvtkBlockDeliveryPreprocessor_AddCompositeDataSetIndex, METH_VARARGS,
   "AddCompositeDataSetIndex(self, index:int) -> None\nC++: void AddCompositeDataSetIndex(unsigned int index)\n\nIn case of Composite datasets, set the flat index of the subtree\nto pass. Default or empty results in passing the entire composite\ntree.\n"},
  {"RemoveAllCompositeDataSetIndices", PyvtkBlockDeliveryPreprocessor_RemoveAllCompositeDataSetIndices, METH_VARARGS,
   "RemoveAllCompositeDataSetIndices(self) -> None\nC++: void RemoveAllCompositeDataSetIndices()\n\n"},
  {"SetGenerateCellConnectivity", PyvtkBlockDeliveryPreprocessor_SetGenerateCellConnectivity, METH_VARARGS,
   "SetGenerateCellConnectivity(self, _arg:bool) -> None\nC++: virtual void SetGenerateCellConnectivity(bool _arg)\n\nAllow user to enable/disable cell connectivity generation in the\ndatamodel\n"},
  {"GetGenerateCellConnectivity", PyvtkBlockDeliveryPreprocessor_GetGenerateCellConnectivity, METH_VARARGS,
   "GetGenerateCellConnectivity(self) -> bool\nC++: virtual bool GetGenerateCellConnectivity()\n\n"},
  {"SetFieldAssociation", PyvtkBlockDeliveryPreprocessor_SetFieldAssociation, METH_VARARGS,
   "SetFieldAssociation(self, _arg:int) -> None\nC++: virtual void SetFieldAssociation(int _arg)\n\nSelect the attribute type. Accepted values are\n\\li vtkDataObject::FIELD_ASSOCIATION_POINTS,\n\\li vtkDataObject::FIELD_ASSOCIATION_CELLS,\n\\li vtkDataObject::FIELD_ASSOCIATION_NONE,\n\\li vtkDataObject::FIELD_ASSOCIATION_VERTICES,\n\\li vtkDataObject::FIELD_ASSOCIATION_EDGES,\n\\li vtkDataObject::FIELD_ASSOCIATION_ROWS\nIf value is vtkDataObject::FIELD_ASSOCIATION_NONE, then FieldData\nassociated with the input dataobject is extracted.\n"},
  {"GetFieldAssociation", PyvtkBlockDeliveryPreprocessor_GetFieldAssociation, METH_VARARGS,
   "GetFieldAssociation(self) -> int\nC++: virtual int GetFieldAssociation()\n\n"},
  {"SetFlattenTable", PyvtkBlockDeliveryPreprocessor_SetFlattenTable, METH_VARARGS,
   "SetFlattenTable(self, _arg:int) -> None\nC++: virtual void SetFlattenTable(int _arg)\n\nFlatten the table, i.e. split any multicomponent columns into\nseparate components, internally the vtkSplitColumnComponents\nfilter is used.\n"},
  {"GetFlattenTable", PyvtkBlockDeliveryPreprocessor_GetFlattenTable, METH_VARARGS,
   "GetFlattenTable(self) -> int\nC++: virtual int GetFlattenTable()\n\n"},
  {"SetSplitComponentsNamingMode", PyvtkBlockDeliveryPreprocessor_SetSplitComponentsNamingMode, METH_VARARGS,
   "SetSplitComponentsNamingMode(self, _arg:int) -> None\nC++: virtual void SetSplitComponentsNamingMode(int _arg)\n\nCorresponds to `vtkSplitColumnComponents::NamingMode`. Pick which\nmode to use to name arrays when `FlattenTable` is true. Default\nis `vtkSplitColumnComponents::NAMES_WITH_UNDERSCORES`.\n"},
  {"GetSplitComponentsNamingModeMinValue", PyvtkBlockDeliveryPreprocessor_GetSplitComponentsNamingModeMinValue, METH_VARARGS,
   "GetSplitComponentsNamingModeMinValue(self) -> int\nC++: virtual int GetSplitComponentsNamingModeMinValue()\n\n"},
  {"GetSplitComponentsNamingModeMaxValue", PyvtkBlockDeliveryPreprocessor_GetSplitComponentsNamingModeMaxValue, METH_VARARGS,
   "GetSplitComponentsNamingModeMaxValue(self) -> int\nC++: virtual int GetSplitComponentsNamingModeMaxValue()\n\n"},
  {"GetSplitComponentsNamingMode", PyvtkBlockDeliveryPreprocessor_GetSplitComponentsNamingMode, METH_VARARGS,
   "GetSplitComponentsNamingMode(self) -> int\nC++: virtual int GetSplitComponentsNamingMode()\n\n"},
  {"SetGenerateOriginalIds", PyvtkBlockDeliveryPreprocessor_SetGenerateOriginalIds, METH_VARARGS,
   "SetGenerateOriginalIds(self, _arg:bool) -> None\nC++: virtual void SetGenerateOriginalIds(bool _arg)\n\nWhen set (default) the vtkOriginalIndices array will be added to\nthe output. Can be overridden by setting this flag to 0. This is\nonly respected when AddMetaData is true.\n"},
  {"GetGenerateOriginalIds", PyvtkBlockDeliveryPreprocessor_GetGenerateOriginalIds, METH_VARARGS,
   "GetGenerateOriginalIds(self) -> bool\nC++: virtual bool GetGenerateOriginalIds()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkBlockDeliveryPreprocessor_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("generate_cell_connectivity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBlockDeliveryPreprocessor_GetGenerateCellConnectivity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBlockDeliveryPreprocessor_SetGenerateCellConnectivity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBlockDeliveryPreprocessor_SetGenerateCellConnectivity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateCellConnectivity/SetGenerateCellConnectivity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("field_association"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBlockDeliveryPreprocessor_GetFieldAssociation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBlockDeliveryPreprocessor_SetFieldAssociation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBlockDeliveryPreprocessor_SetFieldAssociation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFieldAssociation/SetFieldAssociation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("flatten_table"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBlockDeliveryPreprocessor_GetFlattenTable(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBlockDeliveryPreprocessor_SetFlattenTable(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBlockDeliveryPreprocessor_SetFlattenTable(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFlattenTable/SetFlattenTable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("split_components_naming_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBlockDeliveryPreprocessor_GetSplitComponentsNamingMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBlockDeliveryPreprocessor_SetSplitComponentsNamingMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBlockDeliveryPreprocessor_SetSplitComponentsNamingMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSplitComponentsNamingMode/SetSplitComponentsNamingMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_original_ids"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBlockDeliveryPreprocessor_GetGenerateOriginalIds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBlockDeliveryPreprocessor_SetGenerateOriginalIds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBlockDeliveryPreprocessor_SetGenerateOriginalIds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateOriginalIds/SetGenerateOriginalIds\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkBlockDeliveryPreprocessor_Doc =
  "vtkBlockDeliveryPreprocessor - prepares data for certain table-based\nrepresentations\n\n"
  "Superclass: vtkDataObjectAlgorithm\n\n"
  "Despite its name, vtkBlockDeliveryPreprocessor is simply a filter\n"
  "that prepares an input data for certain representations that work\n"
  "with tables alone e.g. vtkSpreadSheetView, vtkChartRepresentation.\n"
  "Using vtkAttributeDataToTableFilter this convert any input data to a\n"
  "vtkTable (or composite of vtkTables). If FlattenTable, it uses\n"
  "`vtkSplitColumnComponents` to split multicomponent arrays into single\n"
  "component arrays with special names.\n\n"
  "When dealing with composite datasets, it uses `vtkExtractBlock` to\n"
  "pass only the selected blocks.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkBlockDeliveryPreprocessor_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersRendering.vtkBlockDeliveryPreprocessor", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkBlockDeliveryPreprocessor_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkBlockDeliveryPreprocessor_StaticNew()
{
  return vtkBlockDeliveryPreprocessor::New();
}

PyObject *PyvtkBlockDeliveryPreprocessor_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkBlockDeliveryPreprocessor_Type, PyvtkBlockDeliveryPreprocessor_Methods,
    "vtkBlockDeliveryPreprocessor",
 &PyvtkBlockDeliveryPreprocessor_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDataObjectAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkBlockDeliveryPreprocessor_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkBlockDeliveryPreprocessor(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkBlockDeliveryPreprocessor_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkBlockDeliveryPreprocessor", o) != 0)
  {
    Py_DECREF(o);
  }

}

