#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkCriticalTime_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkForceStaticMesh_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDataObjectMeshCache_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTemporalSmoothing_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkFiltersTemporalCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkCriticalTime_Init(csi);
  vtkForceStaticMesh_Init(csi);
  vtkDataObjectMeshCache_Init(csi);
  vtkTemporalSmoothing_Init(csi);
}
