// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtGTCFileFormat.h                             //
// ************************************************************************* //

#ifndef AVT_GTC_FILE_FORMAT_H
#define AVT_GTC_FILE_FORMAT_H

#include <avtSTMDFileFormat.h>

#include <vtk_hdf5.h>

#include <visit-hdf5.h>

#include <string>

class parallelBuffer;

// ****************************************************************************
//  Class: avtGTCFileFormat
//
//  Purpose:
//      Reads in GTC files as a plugin to VisIt.
//
//  Programmer: dpn -- generated by xml2avt
//  Creation:   Tue Nov 20 14:08:56 PST 2007
//
// ****************************************************************************

class avtGTCFileFormat : public avtSTMDFileFormat
{
  public:
                       avtGTCFileFormat(const char *filename);
    virtual           ~avtGTCFileFormat() {;};

    virtual const char    *GetType(void)   { return "GTC"; };
    virtual void           FreeUpResources(void);

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar( int, const char *);
    virtual vtkDataArray  *GetVectorVar( int, const char *);

  protected:
    // DATA MEMBERS
    void                   Initialize();
    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);
    void                   ReadVariable( int domain, int varIdx, int varDim, float **ptrVar );
    
    std::string            IndexToVarName( int idx ) const;
    int                    VarNameToIndex( const std::string &var ) const;

    int                    nVars, nTotalPoints, nPoints;
    bool                   initialized;
    hsize_t                startOffset;                    

#if PARALLEL
    int                    nProcs, rank;

    void                   ParallelReadVariable( int domain, int varDim, float *var, float *ids );
    void                   ParallelReadParticles( int domain, float *pts, float *ids );
    void                   BinData( int dim, parallelBuffer **array, float *vars, float *ids,
                                    float **myVars, float **myIds );
    int *                  GetDataShareMatrix( parallelBuffer **array );
    void                   CommunicateData( int dim, int *dataShare, parallelBuffer **array,
                                            float **myPts, float **myIds );
#endif
    
};

#ifdef PARALLEL

// ****************************************************************************
//  Class: parallelBuffer
//
//  Purpose:
//      Dynamic array.
//
//  Programmer: Dave Pugmire
//  Creation:   Tue Nov 20 14:08:56 PST 2007
//
// ****************************************************************************

class parallelBuffer
{
public:
    parallelBuffer( int elemSz );
    ~parallelBuffer();

    int ElemSize() const { return elemSize; }
    int Size() const { return size; }
    float* Get( int i ) { return &(pArray[i*elemSize]); }
    void Add( float *data ) { AddElement( data ); }
    
protected:
    void AddElement( float *data );
    
    float *pArray;
    int size, buffSize, elemSize;
};

#endif

#endif
