// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtFLASHOptions.C                              //
// ************************************************************************* //

#include <avtFLASHOptions.h>

#include <DBOptionsAttributes.h>

#include <string>


// ****************************************************************************
//  Function: GetFLASHReadOptions
//
//  Purpose:
//      Creates the options for FLASH readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: hrchilds -- generated by xml2avt
//  Creation:   Thu Dec 17 14:06:38 PST 2009
//
// ****************************************************************************

DBOptionsAttributes *
GetFLASHReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    rv->SetBool("Show generating processor instead of refinement level", false);
    rv->SetBool("Use new style curve generation", true);
    rv->SetBool("Set up patch abutment information", true);
    return rv;
}


// ****************************************************************************
//  Function: GetFLASHWriteOptions
//
//  Purpose:
//      Creates the options for FLASH writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: hrchilds -- generated by xml2avt
//  Creation:   Thu Dec 17 14:06:38 PST 2009
//
// ****************************************************************************

DBOptionsAttributes *
GetFLASHWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
