// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <CompactSILRestrictionAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::CompactSILRestrictionAttributes
//
// Purpose:
//   Init utility for the CompactSILRestrictionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void CompactSILRestrictionAttributes::Init()
{
    topSetIsAllOn = false;

    CompactSILRestrictionAttributes::SelectAll();
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::CompactSILRestrictionAttributes
//
// Purpose:
//   Copy utility for the CompactSILRestrictionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void CompactSILRestrictionAttributes::Copy(const CompactSILRestrictionAttributes &obj)
{
    useSet = obj.useSet;
    topSet = obj.topSet;
    topSetIsAllOn = obj.topSetIsAllOn;

    CompactSILRestrictionAttributes::SelectAll();
}

// Type map format string
const char *CompactSILRestrictionAttributes::TypeMapFormatString = COMPACTSILRESTRICTIONATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t CompactSILRestrictionAttributes::TmfsStruct = {COMPACTSILRESTRICTIONATTRIBUTES_TMFS};


// ****************************************************************************
// Method: CompactSILRestrictionAttributes::CompactSILRestrictionAttributes
//
// Purpose:
//   Default constructor for the CompactSILRestrictionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

CompactSILRestrictionAttributes::CompactSILRestrictionAttributes() :
    AttributeSubject(CompactSILRestrictionAttributes::TypeMapFormatString)
{
    CompactSILRestrictionAttributes::Init();
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::CompactSILRestrictionAttributes
//
// Purpose:
//   Constructor for the derived classes of CompactSILRestrictionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

CompactSILRestrictionAttributes::CompactSILRestrictionAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    CompactSILRestrictionAttributes::Init();
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::CompactSILRestrictionAttributes
//
// Purpose:
//   Copy constructor for the CompactSILRestrictionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

CompactSILRestrictionAttributes::CompactSILRestrictionAttributes(const CompactSILRestrictionAttributes &obj) :
    AttributeSubject(CompactSILRestrictionAttributes::TypeMapFormatString)
{
    CompactSILRestrictionAttributes::Copy(obj);
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::CompactSILRestrictionAttributes
//
// Purpose:
//   Copy constructor for derived classes of the CompactSILRestrictionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

CompactSILRestrictionAttributes::CompactSILRestrictionAttributes(const CompactSILRestrictionAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    CompactSILRestrictionAttributes::Copy(obj);
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::~CompactSILRestrictionAttributes
//
// Purpose:
//   Destructor for the CompactSILRestrictionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

CompactSILRestrictionAttributes::~CompactSILRestrictionAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::operator =
//
// Purpose:
//   Assignment operator for the CompactSILRestrictionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

CompactSILRestrictionAttributes&
CompactSILRestrictionAttributes::operator = (const CompactSILRestrictionAttributes &obj)
{
    if (this == &obj) return *this;

    CompactSILRestrictionAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the CompactSILRestrictionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
CompactSILRestrictionAttributes::operator == (const CompactSILRestrictionAttributes &obj) const
{
    // Create the return value
    return ((useSet == obj.useSet) &&
            (topSet == obj.topSet) &&
            (topSetIsAllOn == obj.topSetIsAllOn));
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the CompactSILRestrictionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
CompactSILRestrictionAttributes::operator != (const CompactSILRestrictionAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::TypeName
//
// Purpose:
//   Type name method for the CompactSILRestrictionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
CompactSILRestrictionAttributes::TypeName() const
{
    return "CompactSILRestrictionAttributes";
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the CompactSILRestrictionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
CompactSILRestrictionAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const CompactSILRestrictionAttributes *tmp = (const CompactSILRestrictionAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the CompactSILRestrictionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
CompactSILRestrictionAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new CompactSILRestrictionAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the CompactSILRestrictionAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
CompactSILRestrictionAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new CompactSILRestrictionAttributes(*this);
    else
        retval = new CompactSILRestrictionAttributes;

    return retval;
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
CompactSILRestrictionAttributes::SelectAll()
{
    Select(ID_useSet,        (void *)&useSet);
    Select(ID_topSet,        (void *)&topSet);
    Select(ID_topSetIsAllOn, (void *)&topSetIsAllOn);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
CompactSILRestrictionAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    CompactSILRestrictionAttributes defaultObject;
    bool addToParent = false;
    // Create a node for CompactSILRestrictionAttributes.
    DataNode *node = new DataNode("CompactSILRestrictionAttributes");

    if(completeSave || !FieldsEqual(ID_useSet, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useSet", useSet));
    }

    if(completeSave || !FieldsEqual(ID_topSet, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("topSet", topSet));
    }

    if(completeSave || !FieldsEqual(ID_topSetIsAllOn, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("topSetIsAllOn", topSetIsAllOn));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
CompactSILRestrictionAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("CompactSILRestrictionAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("useSet")) != 0)
        SetUseSet(node->AsUnsignedCharVector());
    if((node = searchNode->GetNode("topSet")) != 0)
        SetTopSet(node->AsString());
    if((node = searchNode->GetNode("topSetIsAllOn")) != 0)
        SetTopSetIsAllOn(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
CompactSILRestrictionAttributes::SetUseSet(const unsignedCharVector &useSet_)
{
    useSet = useSet_;
    Select(ID_useSet, (void *)&useSet);
}

void
CompactSILRestrictionAttributes::SetTopSet(const std::string &topSet_)
{
    topSet = topSet_;
    Select(ID_topSet, (void *)&topSet);
}

void
CompactSILRestrictionAttributes::SetTopSetIsAllOn(bool topSetIsAllOn_)
{
    topSetIsAllOn = topSetIsAllOn_;
    Select(ID_topSetIsAllOn, (void *)&topSetIsAllOn);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const unsignedCharVector &
CompactSILRestrictionAttributes::GetUseSet() const
{
    return useSet;
}

unsignedCharVector &
CompactSILRestrictionAttributes::GetUseSet()
{
    return useSet;
}

const std::string &
CompactSILRestrictionAttributes::GetTopSet() const
{
    return topSet;
}

std::string &
CompactSILRestrictionAttributes::GetTopSet()
{
    return topSet;
}

bool
CompactSILRestrictionAttributes::GetTopSetIsAllOn() const
{
    return topSetIsAllOn;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
CompactSILRestrictionAttributes::SelectUseSet()
{
    Select(ID_useSet, (void *)&useSet);
}

void
CompactSILRestrictionAttributes::SelectTopSet()
{
    Select(ID_topSet, (void *)&topSet);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
CompactSILRestrictionAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_useSet:        return "useSet";
    case ID_topSet:        return "topSet";
    case ID_topSetIsAllOn: return "topSetIsAllOn";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
CompactSILRestrictionAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_useSet:        return FieldType_ucharVector;
    case ID_topSet:        return FieldType_string;
    case ID_topSetIsAllOn: return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
CompactSILRestrictionAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_useSet:        return "ucharVector";
    case ID_topSet:        return "string";
    case ID_topSetIsAllOn: return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: CompactSILRestrictionAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
CompactSILRestrictionAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const CompactSILRestrictionAttributes &obj = *((const CompactSILRestrictionAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_useSet:
        {  // new scope
        retval = (useSet == obj.useSet);
        }
        break;
    case ID_topSet:
        {  // new scope
        retval = (topSet == obj.topSet);
        }
        break;
    case ID_topSetIsAllOn:
        {  // new scope
        retval = (topSetIsAllOn == obj.topSetIsAllOn);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

