/* HierarchicalTagUtilities.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from HierarchicalTagUtilities.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "io.elementary.photos.h"
#include <gee.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_HIERARCHICAL_TAG_UTILITIES (hierarchical_tag_utilities_get_type ())
#define HIERARCHICAL_TAG_UTILITIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_TAG_UTILITIES, HierarchicalTagUtilities))
#define HIERARCHICAL_TAG_UTILITIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_TAG_UTILITIES, HierarchicalTagUtilitiesClass))
#define IS_HIERARCHICAL_TAG_UTILITIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_TAG_UTILITIES))
#define IS_HIERARCHICAL_TAG_UTILITIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_TAG_UTILITIES))
#define HIERARCHICAL_TAG_UTILITIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_TAG_UTILITIES, HierarchicalTagUtilitiesClass))

typedef struct _HierarchicalTagUtilities HierarchicalTagUtilities;
typedef struct _HierarchicalTagUtilitiesClass HierarchicalTagUtilitiesClass;
typedef struct _HierarchicalTagUtilitiesPrivate HierarchicalTagUtilitiesPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _ParamSpecHierarchicalTagUtilities ParamSpecHierarchicalTagUtilities;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _HierarchicalTagUtilities {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HierarchicalTagUtilitiesPrivate * priv;
};

struct _HierarchicalTagUtilitiesClass {
	GTypeClass parent_class;
	void (*finalize) (HierarchicalTagUtilities *self);
};

struct _ParamSpecHierarchicalTagUtilities {
	GParamSpec parent_instance;
};

static gpointer hierarchical_tag_utilities_parent_class = NULL;

VALA_EXTERN gpointer hierarchical_tag_utilities_ref (gpointer instance);
VALA_EXTERN void hierarchical_tag_utilities_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_hierarchical_tag_utilities (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
VALA_EXTERN void value_set_hierarchical_tag_utilities (GValue* value,
                                           gpointer v_object);
VALA_EXTERN void value_take_hierarchical_tag_utilities (GValue* value,
                                            gpointer v_object);
VALA_EXTERN gpointer value_get_hierarchical_tag_utilities (const GValue* value);
VALA_EXTERN GType hierarchical_tag_utilities_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* hierarchical_tag_utilities_flat_to_hierarchical (const gchar* name);
VALA_EXTERN gchar* hierarchical_tag_utilities_hierarchical_to_flat (const gchar* path);
VALA_EXTERN GeeList* hierarchical_tag_utilities_enumerate_path_components (const gchar* in_path);
VALA_EXTERN GeeList* hierarchical_tag_utilities_enumerate_parent_paths (const gchar* in_path);
VALA_EXTERN gchar* hierarchical_tag_utilities_get_basename (const gchar* in_path);
VALA_EXTERN gchar* hierarchical_tag_utilities_canonicalize (const gchar* in_tag,
                                                const gchar* foreign_separator);
VALA_EXTERN gchar* hierarchical_tag_utilities_make_flat_tag_safe (const gchar* in_tag);
VALA_EXTERN HierarchicalTagIndex* hierarchical_tag_utilities_process_hierarchical_import_keywords (GeeCollection* h_keywords);
VALA_EXTERN gchar* hierarchical_tag_utilities_get_root_path_form (const gchar* client_path);
VALA_EXTERN void hierarchical_tag_utilities_cleanup_root_path (const gchar* path);
VALA_EXTERN HierarchicalTagUtilities* hierarchical_tag_utilities_new (void);
VALA_EXTERN HierarchicalTagUtilities* hierarchical_tag_utilities_construct (GType object_type);
static void hierarchical_tag_utilities_finalize (HierarchicalTagUtilities * obj);
static GType hierarchical_tag_utilities_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
     * converts a flat tag name 'name' (e.g., "Animals") to a tag path compatible with the
     * hierarchical tag data model (e.g., "/Animals"). if 'name' is already a path compatible with
     * the hierarchical data model, 'name' is returned untouched
     */
gchar*
hierarchical_tag_utilities_flat_to_hierarchical (const gchar* name)
{
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	if (!g_str_has_prefix (name, TAG_PATH_SEPARATOR_STRING)) {
		gchar* _tmp0_;
		_tmp0_ = g_strconcat (TAG_PATH_SEPARATOR_STRING, name, NULL);
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (name);
		result = _tmp1_;
		return result;
	}
}

/**
     * converts a hierarchical tag path 'path' (e.g., "/Animals") to a flat tag name
     * (e.g., "Animals"); if 'path' is already a flat tag name, 'path' is returned untouched; note
     * that 'path' must be a top-level path (i.e., "/Animals" not "/Animals/Mammals/...") with
     * only one path component; invoking this method with a 'path' argument other than a top-level
     * path will cause an assertion failure.
     */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
hierarchical_tag_utilities_hierarchical_to_flat (const gchar* path)
{
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	if (g_str_has_prefix (path, TAG_PATH_SEPARATOR_STRING)) {
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = hierarchical_tag_utilities_enumerate_path_components (path);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_vala_assert (_tmp3_ == 1, "enumerate_path_components (path).size == 1");
		_g_object_unref0 (_tmp1_);
		_tmp4_ = string_substring (path, (glong) 1, (glong) -1);
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (path);
		result = _tmp5_;
		return result;
	}
}

/**
     * given a path 'path', generate all parent paths of 'path' and return them in sorted order,
     * from most basic to most derived. For example, if 'path' == "/Animals/Mammals/Elephant",
     * the list { "/Animals", "/Animals/Mammals" } is returned
     */
GeeList*
hierarchical_tag_utilities_enumerate_parent_paths (const gchar* in_path)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	GeeList* _result_ = NULL;
	GeeArrayList* _tmp1_;
	gchar* accumulator = NULL;
	gchar* _tmp2_;
	GeeList* result;
	g_return_val_if_fail (in_path != NULL, NULL);
	_tmp0_ = hierarchical_tag_utilities_flat_to_hierarchical (in_path);
	path = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_result_ = (GeeList*) _tmp1_;
	_tmp2_ = g_strdup ("");
	accumulator = _tmp2_;
	{
		GeeList* _component_list = NULL;
		const gchar* _tmp3_;
		GeeList* _tmp4_;
		gint _component_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _component_index = 0;
		_tmp3_ = path;
		_tmp4_ = hierarchical_tag_utilities_enumerate_path_components (_tmp3_);
		_component_list = _tmp4_;
		_tmp5_ = _component_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_component_size = _tmp7_;
		_component_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gchar* component = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			_component_index = _component_index + 1;
			_tmp8_ = _component_index;
			_tmp9_ = _component_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _component_list;
			_tmp11_ = gee_list_get (_tmp10_, _component_index);
			component = (gchar*) _tmp11_;
			_tmp12_ = accumulator;
			_tmp13_ = component;
			_tmp14_ = g_strconcat (TAG_PATH_SEPARATOR_STRING, _tmp13_, NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat (_tmp12_, _tmp15_, NULL);
			_g_free0 (accumulator);
			accumulator = _tmp16_;
			_g_free0 (_tmp15_);
			_tmp17_ = accumulator;
			_tmp18_ = path;
			if (g_strcmp0 (_tmp17_, _tmp18_) != 0) {
				GeeList* _tmp19_;
				const gchar* _tmp20_;
				_tmp19_ = _result_;
				_tmp20_ = accumulator;
				gee_collection_add ((GeeCollection*) _tmp19_, _tmp20_);
			}
			_g_free0 (component);
		}
		_g_object_unref0 (_component_list);
	}
	result = _result_;
	_g_free0 (accumulator);
	_g_free0 (path);
	return result;
}

/**
     * given a path 'path', enumerate all of the components of 'path' and return them in
     * order, excluding the path component separator. For example if
     * 'path' == "/Animals/Mammals/Elephant" the list { "Animals",  "Mammals", "Elephant" } will
     * be returned
     */
GeeList*
hierarchical_tag_utilities_enumerate_path_components (const gchar* in_path)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	GeeArrayList* components = NULL;
	GeeArrayList* _tmp1_;
	gchar** raw_components = NULL;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint raw_components_length1;
	gint _raw_components_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GeeList* result;
	g_return_val_if_fail (in_path != NULL, NULL);
	_tmp0_ = hierarchical_tag_utilities_flat_to_hierarchical (in_path);
	path = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	components = _tmp1_;
	_tmp2_ = path;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, TAG_PATH_SEPARATOR_STRING, 0);
	raw_components = _tmp4_;
	raw_components_length1 = _vala_array_length (_tmp3_);
	_raw_components_size_ = raw_components_length1;
	_tmp5_ = raw_components;
	_tmp5__length1 = raw_components_length1;
	{
		gchar** component_collection = NULL;
		gint component_collection_length1 = 0;
		gint _component_collection_size_ = 0;
		gint component_it = 0;
		component_collection = _tmp5_;
		component_collection_length1 = _tmp5__length1;
		for (component_it = 0; component_it < component_collection_length1; component_it = component_it + 1) {
			gchar* _tmp6_;
			gchar* component = NULL;
			_tmp6_ = g_strdup (component_collection[component_it]);
			component = _tmp6_;
			{
				const gchar* _tmp7_;
				_tmp7_ = component;
				if (g_strcmp0 (_tmp7_, "") != 0) {
					GeeArrayList* _tmp8_;
					const gchar* _tmp9_;
					_tmp8_ = components;
					_tmp9_ = component;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
				}
				_g_free0 (component);
			}
		}
	}
	_tmp10_ = components;
	_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	_vala_assert (_tmp12_ > 0, "components.size > 0");
	result = (GeeList*) components;
	raw_components = (_vala_array_free (raw_components, raw_components_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (path);
	return result;
}

gchar*
hierarchical_tag_utilities_get_basename (const gchar* in_path)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	GeeList* components = NULL;
	GeeList* _tmp1_;
	gchar* basename = NULL;
	gint _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_;
	gchar* result;
	g_return_val_if_fail (in_path != NULL, NULL);
	_tmp0_ = hierarchical_tag_utilities_flat_to_hierarchical (in_path);
	path = _tmp0_;
	_tmp1_ = hierarchical_tag_utilities_enumerate_path_components (path);
	components = _tmp1_;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) components);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_list_get (components, _tmp3_ - 1);
	basename = (gchar*) _tmp4_;
	result = basename;
	_g_object_unref0 (components);
	_g_free0 (path);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gchar*
hierarchical_tag_utilities_canonicalize (const gchar* in_tag,
                                         const gchar* foreign_separator)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean is_valid = FALSE;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (in_tag != NULL, NULL);
	g_return_val_if_fail (foreign_separator != NULL, NULL);
	_tmp0_ = string_replace (in_tag, foreign_separator, TAG_PATH_SEPARATOR_STRING);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (!g_str_has_prefix (_tmp1_, TAG_PATH_SEPARATOR_STRING)) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = _result_;
		_tmp3_ = g_strconcat (TAG_PATH_SEPARATOR_STRING, _tmp2_, NULL);
		_g_free0 (_result_);
		_result_ = _tmp3_;
	}
	is_valid = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				const gchar* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				const gchar* _tmp9_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = _result_;
				_tmp7_ = strlen (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(i < _tmp8_)) {
					break;
				}
				_tmp9_ = _result_;
				if (string_get (_tmp9_, (glong) i) != string_get (TAG_PATH_SEPARATOR_STRING, (glong) 0)) {
					is_valid = TRUE;
					break;
				}
			}
		}
	}
	if (is_valid) {
		const gchar* _tmp11_;
		_tmp11_ = _result_;
		_tmp10_ = _tmp11_;
	} else {
		_tmp10_ = NULL;
	}
	_tmp12_ = g_strdup (_tmp10_);
	result = _tmp12_;
	_g_free0 (_result_);
	return result;
}

gchar*
hierarchical_tag_utilities_make_flat_tag_safe (const gchar* in_tag)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (in_tag != NULL, NULL);
	_tmp0_ = string_replace (in_tag, TAG_PATH_SEPARATOR_STRING, "-");
	result = _tmp0_;
	return result;
}

HierarchicalTagIndex*
hierarchical_tag_utilities_process_hierarchical_import_keywords (GeeCollection* h_keywords)
{
	HierarchicalTagIndex* index = NULL;
	HierarchicalTagIndex* _tmp0_;
	HierarchicalTagIndex* result;
	g_return_val_if_fail (h_keywords != NULL, NULL);
	_tmp0_ = hierarchical_tag_index_new ();
	index = _tmp0_;
	{
		GeeIterator* _keyword_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) h_keywords);
		_keyword_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gchar* keyword = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeList* parent_paths = NULL;
			const gchar* _tmp5_;
			GeeList* _tmp6_;
			GeeList* path_components = NULL;
			const gchar* _tmp7_;
			GeeList* _tmp8_;
			GeeList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			HierarchicalTagIndex* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp2_ = _keyword_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _keyword_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			keyword = (gchar*) _tmp4_;
			_tmp5_ = keyword;
			_tmp6_ = hierarchical_tag_utilities_enumerate_parent_paths (_tmp5_);
			parent_paths = _tmp6_;
			_tmp7_ = keyword;
			_tmp8_ = hierarchical_tag_utilities_enumerate_path_components (_tmp7_);
			path_components = _tmp8_;
			_tmp9_ = parent_paths;
			_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = path_components;
			_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_vala_assert (_tmp11_ <= _tmp14_, "parent_paths.size <= path_components.size");
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp15_ = FALSE;
					_tmp15_ = TRUE;
					while (TRUE) {
						GeeList* _tmp17_;
						gint _tmp18_;
						gint _tmp19_;
						HierarchicalTagIndex* _tmp20_;
						GeeList* _tmp21_;
						gpointer _tmp22_;
						gchar* _tmp23_;
						gboolean _tmp24_;
						if (!_tmp15_) {
							gint _tmp16_;
							_tmp16_ = i;
							i = _tmp16_ + 1;
						}
						_tmp15_ = FALSE;
						_tmp17_ = parent_paths;
						_tmp18_ = gee_collection_get_size ((GeeCollection*) _tmp17_);
						_tmp19_ = _tmp18_;
						if (!(i < _tmp19_)) {
							break;
						}
						_tmp20_ = index;
						_tmp21_ = path_components;
						_tmp22_ = gee_list_get (_tmp21_, i);
						_tmp23_ = (gchar*) _tmp22_;
						_tmp24_ = !hierarchical_tag_index_is_path_known (_tmp20_, _tmp23_);
						_g_free0 (_tmp23_);
						if (_tmp24_) {
							HierarchicalTagIndex* _tmp25_;
							GeeList* _tmp26_;
							gpointer _tmp27_;
							gchar* _tmp28_;
							GeeList* _tmp29_;
							gpointer _tmp30_;
							gchar* _tmp31_;
							_tmp25_ = index;
							_tmp26_ = path_components;
							_tmp27_ = gee_list_get (_tmp26_, i);
							_tmp28_ = (gchar*) _tmp27_;
							_tmp29_ = parent_paths;
							_tmp30_ = gee_list_get (_tmp29_, i);
							_tmp31_ = (gchar*) _tmp30_;
							hierarchical_tag_index_add_path (_tmp25_, _tmp28_, _tmp31_);
							_g_free0 (_tmp31_);
							_g_free0 (_tmp28_);
						}
					}
				}
			}
			_tmp32_ = index;
			_tmp33_ = keyword;
			_tmp34_ = hierarchical_tag_utilities_get_basename (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = keyword;
			hierarchical_tag_index_add_path (_tmp32_, _tmp35_, _tmp36_);
			_g_free0 (_tmp35_);
			_g_object_unref0 (path_components);
			_g_object_unref0 (parent_paths);
			_g_free0 (keyword);
		}
		_g_object_unref0 (_keyword_it);
	}
	result = index;
	return result;
}

gchar*
hierarchical_tag_utilities_get_root_path_form (const gchar* client_path)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	gchar* path = NULL;
	gchar* _tmp6_;
	TagSourceCollection* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp14_ = NULL;
	TagSourceCollection* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp18_;
	gchar* result;
	if (client_path == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = hierarchical_tag_utilities_enumerate_parent_paths (client_path);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != 0;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (client_path);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = g_strdup (client_path);
	path = _tmp6_;
	_tmp7_ = tag_global;
	_tmp8_ = path;
	if (!tag_source_collection_exists (_tmp7_, _tmp8_, FALSE)) {
		const gchar* _tmp9_;
		_tmp9_ = path;
		if (g_str_has_prefix (_tmp9_, TAG_PATH_SEPARATOR_STRING)) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = path;
			_tmp11_ = hierarchical_tag_utilities_hierarchical_to_flat (_tmp10_);
			_g_free0 (path);
			path = _tmp11_;
		} else {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = path;
			_tmp13_ = hierarchical_tag_utilities_flat_to_hierarchical (_tmp12_);
			_g_free0 (path);
			path = _tmp13_;
		}
	}
	_tmp15_ = tag_global;
	_tmp16_ = path;
	if (tag_source_collection_exists (_tmp15_, _tmp16_, FALSE)) {
		const gchar* _tmp17_;
		_tmp17_ = path;
		_tmp14_ = _tmp17_;
	} else {
		_tmp14_ = NULL;
	}
	_tmp18_ = g_strdup (_tmp14_);
	result = _tmp18_;
	_g_free0 (path);
	return result;
}

void
hierarchical_tag_utilities_cleanup_root_path (const gchar* path)
{
	GeeList* paths = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (path != NULL);
	_tmp0_ = hierarchical_tag_utilities_enumerate_parent_paths (path);
	paths = _tmp0_;
	_tmp1_ = paths;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		gchar* actual_path = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		Tag* t = NULL;
		TagSourceCollection* _tmp6_;
		const gchar* _tmp7_;
		gboolean _tmp10_ = FALSE;
		Tag* _tmp11_;
		_tmp4_ = hierarchical_tag_utilities_get_root_path_form (path);
		actual_path = _tmp4_;
		_tmp5_ = actual_path;
		if (_tmp5_ == NULL) {
			_g_free0 (actual_path);
			_g_object_unref0 (paths);
			return;
		}
		t = NULL;
		_tmp6_ = tag_global;
		_tmp7_ = actual_path;
		if (tag_source_collection_exists (_tmp6_, _tmp7_, FALSE)) {
			const gchar* _tmp8_;
			Tag* _tmp9_;
			_tmp8_ = actual_path;
			_tmp9_ = tag_for_path (_tmp8_);
			_g_object_unref0 (t);
			t = _tmp9_;
		}
		_tmp11_ = t;
		if (_tmp11_ != NULL) {
			Tag* _tmp12_;
			GeeList* _tmp13_;
			GeeList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			_tmp12_ = t;
			_tmp13_ = tag_get_hierarchical_children (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp10_ = _tmp16_ == 0;
			_g_object_unref0 (_tmp14_);
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			Tag* _tmp17_;
			_tmp17_ = t;
			tag_flatten (_tmp17_);
		}
		_g_object_unref0 (t);
		_g_free0 (actual_path);
	}
	_g_object_unref0 (paths);
}

HierarchicalTagUtilities*
hierarchical_tag_utilities_construct (GType object_type)
{
	HierarchicalTagUtilities* self = NULL;
	self = (HierarchicalTagUtilities*) g_type_create_instance (object_type);
	return self;
}

HierarchicalTagUtilities*
hierarchical_tag_utilities_new (void)
{
	return hierarchical_tag_utilities_construct (TYPE_HIERARCHICAL_TAG_UTILITIES);
}

static void
value_hierarchical_tag_utilities_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_hierarchical_tag_utilities_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		hierarchical_tag_utilities_unref (value->data[0].v_pointer);
	}
}

static void
value_hierarchical_tag_utilities_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = hierarchical_tag_utilities_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_hierarchical_tag_utilities_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_hierarchical_tag_utilities_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		HierarchicalTagUtilities * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = hierarchical_tag_utilities_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_hierarchical_tag_utilities_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	HierarchicalTagUtilities ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = hierarchical_tag_utilities_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_hierarchical_tag_utilities (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	ParamSpecHierarchicalTagUtilities* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HIERARCHICAL_TAG_UTILITIES), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_hierarchical_tag_utilities (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_TAG_UTILITIES), NULL);
	return value->data[0].v_pointer;
}

void
value_set_hierarchical_tag_utilities (GValue* value,
                                      gpointer v_object)
{
	HierarchicalTagUtilities * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_TAG_UTILITIES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HIERARCHICAL_TAG_UTILITIES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		hierarchical_tag_utilities_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		hierarchical_tag_utilities_unref (old);
	}
}

void
value_take_hierarchical_tag_utilities (GValue* value,
                                       gpointer v_object)
{
	HierarchicalTagUtilities * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_TAG_UTILITIES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HIERARCHICAL_TAG_UTILITIES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		hierarchical_tag_utilities_unref (old);
	}
}

static void
hierarchical_tag_utilities_class_init (HierarchicalTagUtilitiesClass * klass,
                                       gpointer klass_data)
{
	hierarchical_tag_utilities_parent_class = g_type_class_peek_parent (klass);
	((HierarchicalTagUtilitiesClass *) klass)->finalize = hierarchical_tag_utilities_finalize;
}

static void
hierarchical_tag_utilities_instance_init (HierarchicalTagUtilities * self,
                                          gpointer klass)
{
	self->ref_count = 1;
}

static void
hierarchical_tag_utilities_finalize (HierarchicalTagUtilities * obj)
{
	HierarchicalTagUtilities * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HIERARCHICAL_TAG_UTILITIES, HierarchicalTagUtilities);
	g_signal_handlers_destroy (self);
}

static GType
hierarchical_tag_utilities_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_hierarchical_tag_utilities_init, value_hierarchical_tag_utilities_free_value, value_hierarchical_tag_utilities_copy_value, value_hierarchical_tag_utilities_peek_pointer, "p", value_hierarchical_tag_utilities_collect_value, "p", value_hierarchical_tag_utilities_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (HierarchicalTagUtilitiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hierarchical_tag_utilities_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HierarchicalTagUtilities), 0, (GInstanceInitFunc) hierarchical_tag_utilities_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType hierarchical_tag_utilities_type_id;
	hierarchical_tag_utilities_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HierarchicalTagUtilities", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return hierarchical_tag_utilities_type_id;
}

GType
hierarchical_tag_utilities_get_type (void)
{
	static volatile gsize hierarchical_tag_utilities_type_id__once = 0;
	if (g_once_init_enter (&hierarchical_tag_utilities_type_id__once)) {
		GType hierarchical_tag_utilities_type_id;
		hierarchical_tag_utilities_type_id = hierarchical_tag_utilities_get_type_once ();
		g_once_init_leave (&hierarchical_tag_utilities_type_id__once, hierarchical_tag_utilities_type_id);
	}
	return hierarchical_tag_utilities_type_id__once;
}

gpointer
hierarchical_tag_utilities_ref (gpointer instance)
{
	HierarchicalTagUtilities * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
hierarchical_tag_utilities_unref (gpointer instance)
{
	HierarchicalTagUtilities * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HIERARCHICAL_TAG_UTILITIES_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

