/* PhotoFileAdapter.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PhotoFileAdapter.vala, do not modify */

/*
* Copyright (c) 2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/**/
/* PhotoFileAdapter*/
/**/
/* PhotoFileAdapter (and its immediate children, PhotoFileReader and PhotoFileWriter) are drivers*/
/* hiding details of reading and writing image files and their metadata.  They should keep*/
/* minimal state beyond the filename, if any stat at all.  In particular, they should avoid caching*/
/* values, especially the readers, as writers may be created at any time and invalidate that*/
/* information, unless the readers monitor the file for these changes.*/
/**/
/* PhotoFileAdapters should be entirely thread-safe.  They are not, however, responsible for*/
/* atomicity on the filesystem.*/
/**/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecPhotoFileAdapter ParamSpecPhotoFileAdapter;
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))

struct _PhotoFileAdapterPrivate {
	gchar* filepath;
	PhotoFileFormat file_format;
	GFile* file;
	GRecMutex __lock_file;
};

struct _ParamSpecPhotoFileAdapter {
	GParamSpec parent_instance;
};

static gint PhotoFileAdapter_private_offset;
static gpointer photo_file_adapter_parent_class = NULL;
static gpointer photo_file_reader_parent_class = NULL;
static gpointer photo_file_writer_parent_class = NULL;
static gpointer photo_file_metadata_writer_parent_class = NULL;

static void photo_file_adapter_finalize (PhotoFileAdapter * obj);
static GType photo_file_adapter_get_type_once (void);
static PhotoMetadata* photo_file_reader_real_read_metadata (PhotoFileReader* self,
                                                     GError** error);
static GdkPixbuf* photo_file_reader_real_unscaled_read (PhotoFileReader* self,
                                                 GError** error);
static GdkPixbuf* photo_file_reader_real_scaled_read (PhotoFileReader* self,
                                               Dimensions* full,
                                               Dimensions* scaled,
                                               GError** error);
VALA_EXTERN GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf,
                          Dimensions* resized,
                          GdkInterpType interp);
static GType photo_file_reader_get_type_once (void);
static void photo_file_writer_real_write (PhotoFileWriter* self,
                                   GdkPixbuf* pixbuf,
                                   JpegQuality quality,
                                   GError** error);
static GType photo_file_writer_get_type_once (void);
static void photo_file_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* self,
                                                     PhotoMetadata* metadata,
                                                     GError** error);
static GType photo_file_metadata_writer_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
photo_file_adapter_get_instance_private (PhotoFileAdapter* self)
{
	return G_STRUCT_MEMBER_P (self, PhotoFileAdapter_private_offset);
}

PhotoFileAdapter*
photo_file_adapter_construct (GType object_type,
                              const gchar* filepath,
                              PhotoFileFormat file_format)
{
	PhotoFileAdapter* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (PhotoFileAdapter*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (filepath);
	_g_free0 (self->priv->filepath);
	self->priv->filepath = _tmp0_;
	self->priv->file_format = file_format;
	return self;
}

gboolean
photo_file_adapter_file_exists (PhotoFileAdapter* self)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->filepath;
	result = g_file_test (_tmp0_, G_FILE_TEST_IS_REGULAR);
	return result;
}

gchar*
photo_file_adapter_get_filepath (PhotoFileAdapter* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->filepath;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GFile*
photo_file_adapter_get_file (PhotoFileAdapter* self)
{
	GFile* _result_ = NULL;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GFile* _tmp0_;
		_tmp0_ = self->priv->file;
		g_rec_mutex_lock (&self->priv->__lock_file);
		{
			GFile* _tmp1_;
			GFile* _tmp4_;
			GFile* _tmp5_;
			_tmp1_ = self->priv->file;
			if (_tmp1_ == NULL) {
				const gchar* _tmp2_;
				GFile* _tmp3_;
				_tmp2_ = self->priv->filepath;
				_tmp3_ = g_file_new_for_path (_tmp2_);
				_g_object_unref0 (self->priv->file);
				self->priv->file = _tmp3_;
			}
			_tmp4_ = self->priv->file;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			_g_object_unref0 (_result_);
			_result_ = _tmp5_;
		}
		__finally0:
		{
			GFile* _tmp6_;
			_tmp6_ = self->priv->file;
			g_rec_mutex_unlock (&self->priv->__lock_file);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = _result_;
	return result;
}

PhotoFileFormat
photo_file_adapter_get_file_format (PhotoFileAdapter* self)
{
	PhotoFileFormat result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->file_format;
	return result;
}

static void
value_photo_file_adapter_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_photo_file_adapter_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_file_adapter_unref (value->data[0].v_pointer);
	}
}

static void
value_photo_file_adapter_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_file_adapter_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_photo_file_adapter_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_photo_file_adapter_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoFileAdapter * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_file_adapter_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_photo_file_adapter_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	PhotoFileAdapter ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_file_adapter_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_photo_file_adapter (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ParamSpecPhotoFileAdapter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_FILE_ADAPTER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_photo_file_adapter (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_ADAPTER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_photo_file_adapter (GValue* value,
                              gpointer v_object)
{
	PhotoFileAdapter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_ADAPTER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_ADAPTER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_file_adapter_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_file_adapter_unref (old);
	}
}

void
value_take_photo_file_adapter (GValue* value,
                               gpointer v_object)
{
	PhotoFileAdapter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_ADAPTER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_ADAPTER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_file_adapter_unref (old);
	}
}

static void
photo_file_adapter_class_init (PhotoFileAdapterClass * klass,
                               gpointer klass_data)
{
	photo_file_adapter_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileAdapterClass *) klass)->finalize = photo_file_adapter_finalize;
	g_type_class_adjust_private_offset (klass, &PhotoFileAdapter_private_offset);
}

static void
photo_file_adapter_instance_init (PhotoFileAdapter * self,
                                  gpointer klass)
{
	self->priv = photo_file_adapter_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_file);
	self->priv->file = NULL;
	self->ref_count = 1;
}

static void
photo_file_adapter_finalize (PhotoFileAdapter * obj)
{
	PhotoFileAdapter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->filepath);
	g_rec_mutex_clear (&self->priv->__lock_file);
	_g_object_unref0 (self->priv->file);
}

static GType
photo_file_adapter_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_photo_file_adapter_init, value_photo_file_adapter_free_value, value_photo_file_adapter_copy_value, value_photo_file_adapter_peek_pointer, "p", value_photo_file_adapter_collect_value, "p", value_photo_file_adapter_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoFileAdapterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_adapter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileAdapter), 0, (GInstanceInitFunc) photo_file_adapter_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_file_adapter_type_id;
	photo_file_adapter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoFileAdapter", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	PhotoFileAdapter_private_offset = g_type_add_instance_private (photo_file_adapter_type_id, sizeof (PhotoFileAdapterPrivate));
	return photo_file_adapter_type_id;
}

GType
photo_file_adapter_get_type (void)
{
	static volatile gsize photo_file_adapter_type_id__once = 0;
	if (g_once_init_enter (&photo_file_adapter_type_id__once)) {
		GType photo_file_adapter_type_id;
		photo_file_adapter_type_id = photo_file_adapter_get_type_once ();
		g_once_init_leave (&photo_file_adapter_type_id__once, photo_file_adapter_type_id);
	}
	return photo_file_adapter_type_id__once;
}

gpointer
photo_file_adapter_ref (gpointer instance)
{
	PhotoFileAdapter * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_file_adapter_unref (gpointer instance)
{
	PhotoFileAdapter * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_FILE_ADAPTER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

PhotoFileReader*
photo_file_reader_construct (GType object_type,
                             const gchar* filepath,
                             PhotoFileFormat file_format)
{
	PhotoFileReader* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (PhotoFileReader*) photo_file_adapter_construct (object_type, filepath, file_format);
	return self;
}

PhotoFileWriter*
photo_file_reader_create_writer (PhotoFileReader* self,
                                 GError** error)
{
	PhotoFileWriter* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	PhotoFileWriter* _tmp3_;
	PhotoFileWriter* _tmp4_;
	PhotoFileWriter* _tmp5_;
	GError* _inner_error0_ = NULL;
	PhotoFileWriter* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = photo_file_format_create_writer (photo_file_adapter_get_file_format ((PhotoFileAdapter*) self), _tmp2_, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == PHOTO_FORMAT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_photo_file_adapter_unref0 (_tmp0_);
	return result;
}

PhotoFileMetadataWriter*
photo_file_reader_create_metadata_writer (PhotoFileReader* self,
                                          GError** error)
{
	PhotoFileMetadataWriter* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	PhotoFileMetadataWriter* _tmp3_;
	PhotoFileMetadataWriter* _tmp4_;
	PhotoFileMetadataWriter* _tmp5_;
	GError* _inner_error0_ = NULL;
	PhotoFileMetadataWriter* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = photo_file_format_create_metadata_writer (photo_file_adapter_get_file_format ((PhotoFileAdapter*) self), _tmp2_, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == PHOTO_FORMAT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_photo_file_adapter_unref0 (_tmp0_);
	return result;
}

static PhotoMetadata*
photo_file_reader_real_read_metadata (PhotoFileReader* self,
                                      GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_reader_read_metadata'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

PhotoMetadata*
photo_file_reader_read_metadata (PhotoFileReader* self,
                                 GError** error)
{
	PhotoFileReaderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PHOTO_FILE_READER_GET_CLASS (self);
	if (_klass_->read_metadata) {
		return _klass_->read_metadata (self, error);
	}
	return NULL;
}

static GdkPixbuf*
photo_file_reader_real_unscaled_read (PhotoFileReader* self,
                                      GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_reader_unscaled_read'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GdkPixbuf*
photo_file_reader_unscaled_read (PhotoFileReader* self,
                                 GError** error)
{
	PhotoFileReaderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PHOTO_FILE_READER_GET_CLASS (self);
	if (_klass_->unscaled_read) {
		return _klass_->unscaled_read (self, error);
	}
	return NULL;
}

static GdkPixbuf*
photo_file_reader_real_scaled_read (PhotoFileReader* self,
                                    Dimensions* full,
                                    Dimensions* scaled,
                                    GError** error)
{
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	Dimensions _tmp2_;
	GdkPixbuf* _tmp3_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (full != NULL, NULL);
	g_return_val_if_fail (scaled != NULL, NULL);
	_tmp1_ = photo_file_reader_unscaled_read (self, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = *scaled;
	_tmp3_ = resize_pixbuf (_tmp0_, &_tmp2_, GDK_INTERP_BILINEAR);
	result = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return result;
}

GdkPixbuf*
photo_file_reader_scaled_read (PhotoFileReader* self,
                               Dimensions* full,
                               Dimensions* scaled,
                               GError** error)
{
	PhotoFileReaderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PHOTO_FILE_READER_GET_CLASS (self);
	if (_klass_->scaled_read) {
		return _klass_->scaled_read (self, full, scaled, error);
	}
	return NULL;
}

static void
photo_file_reader_class_init (PhotoFileReaderClass * klass,
                              gpointer klass_data)
{
	photo_file_reader_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileReaderClass *) klass)->read_metadata = (PhotoMetadata* (*) (PhotoFileReader*, GError**)) photo_file_reader_real_read_metadata;
	((PhotoFileReaderClass *) klass)->unscaled_read = (GdkPixbuf* (*) (PhotoFileReader*, GError**)) photo_file_reader_real_unscaled_read;
	((PhotoFileReaderClass *) klass)->scaled_read = (GdkPixbuf* (*) (PhotoFileReader*, Dimensions*, Dimensions*, GError**)) photo_file_reader_real_scaled_read;
}

static void
photo_file_reader_instance_init (PhotoFileReader * self,
                                 gpointer klass)
{
}

static GType
photo_file_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoFileReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileReader), 0, (GInstanceInitFunc) photo_file_reader_instance_init, NULL };
	GType photo_file_reader_type_id;
	photo_file_reader_type_id = g_type_register_static (TYPE_PHOTO_FILE_ADAPTER, "PhotoFileReader", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return photo_file_reader_type_id;
}

GType
photo_file_reader_get_type (void)
{
	static volatile gsize photo_file_reader_type_id__once = 0;
	if (g_once_init_enter (&photo_file_reader_type_id__once)) {
		GType photo_file_reader_type_id;
		photo_file_reader_type_id = photo_file_reader_get_type_once ();
		g_once_init_leave (&photo_file_reader_type_id__once, photo_file_reader_type_id);
	}
	return photo_file_reader_type_id__once;
}

PhotoFileWriter*
photo_file_writer_construct (GType object_type,
                             const gchar* filepath,
                             PhotoFileFormat file_format)
{
	PhotoFileWriter* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (PhotoFileWriter*) photo_file_adapter_construct (object_type, filepath, file_format);
	return self;
}

PhotoFileReader*
photo_file_writer_create_reader (PhotoFileWriter* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	PhotoFileReader* _tmp2_;
	PhotoFileReader* _tmp3_;
	PhotoFileReader* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_create_reader (photo_file_adapter_get_file_format ((PhotoFileAdapter*) self), _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static void
photo_file_writer_real_write (PhotoFileWriter* self,
                              GdkPixbuf* pixbuf,
                              JpegQuality quality,
                              GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_writer_write'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
photo_file_writer_write (PhotoFileWriter* self,
                         GdkPixbuf* pixbuf,
                         JpegQuality quality,
                         GError** error)
{
	PhotoFileWriterClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PHOTO_FILE_WRITER_GET_CLASS (self);
	if (_klass_->write) {
		_klass_->write (self, pixbuf, quality, error);
	}
}

static void
photo_file_writer_class_init (PhotoFileWriterClass * klass,
                              gpointer klass_data)
{
	photo_file_writer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileWriterClass *) klass)->write = (void (*) (PhotoFileWriter*, GdkPixbuf*, JpegQuality, GError**)) photo_file_writer_real_write;
}

static void
photo_file_writer_instance_init (PhotoFileWriter * self,
                                 gpointer klass)
{
}

static GType
photo_file_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoFileWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileWriter), 0, (GInstanceInitFunc) photo_file_writer_instance_init, NULL };
	GType photo_file_writer_type_id;
	photo_file_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_ADAPTER, "PhotoFileWriter", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return photo_file_writer_type_id;
}

GType
photo_file_writer_get_type (void)
{
	static volatile gsize photo_file_writer_type_id__once = 0;
	if (g_once_init_enter (&photo_file_writer_type_id__once)) {
		GType photo_file_writer_type_id;
		photo_file_writer_type_id = photo_file_writer_get_type_once ();
		g_once_init_leave (&photo_file_writer_type_id__once, photo_file_writer_type_id);
	}
	return photo_file_writer_type_id__once;
}

PhotoFileMetadataWriter*
photo_file_metadata_writer_construct (GType object_type,
                                      const gchar* filepath,
                                      PhotoFileFormat file_format)
{
	PhotoFileMetadataWriter* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (PhotoFileMetadataWriter*) photo_file_adapter_construct (object_type, filepath, file_format);
	return self;
}

PhotoFileReader*
photo_file_metadata_writer_create_reader (PhotoFileMetadataWriter* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	PhotoFileReader* _tmp2_;
	PhotoFileReader* _tmp3_;
	PhotoFileReader* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_create_reader (photo_file_adapter_get_file_format ((PhotoFileAdapter*) self), _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static void
photo_file_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* self,
                                                PhotoMetadata* metadata,
                                                GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `photo_file_metadata_writer_write_metadata'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
photo_file_metadata_writer_write_metadata (PhotoFileMetadataWriter* self,
                                           PhotoMetadata* metadata,
                                           GError** error)
{
	PhotoFileMetadataWriterClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PHOTO_FILE_METADATA_WRITER_GET_CLASS (self);
	if (_klass_->write_metadata) {
		_klass_->write_metadata (self, metadata, error);
	}
}

static void
photo_file_metadata_writer_class_init (PhotoFileMetadataWriterClass * klass,
                                       gpointer klass_data)
{
	photo_file_metadata_writer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileMetadataWriterClass *) klass)->write_metadata = (void (*) (PhotoFileMetadataWriter*, PhotoMetadata*, GError**)) photo_file_metadata_writer_real_write_metadata;
}

static void
photo_file_metadata_writer_instance_init (PhotoFileMetadataWriter * self,
                                          gpointer klass)
{
}

static GType
photo_file_metadata_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoFileMetadataWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_metadata_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileMetadataWriter), 0, (GInstanceInitFunc) photo_file_metadata_writer_instance_init, NULL };
	GType photo_file_metadata_writer_type_id;
	photo_file_metadata_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_ADAPTER, "PhotoFileMetadataWriter", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return photo_file_metadata_writer_type_id;
}

GType
photo_file_metadata_writer_get_type (void)
{
	static volatile gsize photo_file_metadata_writer_type_id__once = 0;
	if (g_once_init_enter (&photo_file_metadata_writer_type_id__once)) {
		GType photo_file_metadata_writer_type_id;
		photo_file_metadata_writer_type_id = photo_file_metadata_writer_get_type_once ();
		g_once_init_leave (&photo_file_metadata_writer_type_id__once, photo_file_metadata_writer_type_id);
	}
	return photo_file_metadata_writer_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

