/*
 * Copyright (c) 2018 Cisco Systems, Inc.  All rights reserved.
 * $COPYRIGHT$
 *
 * Additional copyrights may follow
 *
 * $HEADER$
 */

#include "opal_config.h"

#include <assert.h>

#include "opal/util/string_copy.h"

void opal_string_copy(char *dest, const char *src, size_t dest_len)
{
    size_t i;
    char *new_dest = dest;

    // Open MPI does not do *giant* string copies.  Hence, we use the
    // heuristic: if "dest_len" is too large, this is a programmer
    // error.  We pseudo-arbitrarily pick a large value to be the max
    // allowable dest_len: 128K.  If we ever need to increase this
    // value someday (because something has a legit reason to
    // opal_string_copy() more than 128K), the core dumps that are
    // generated by the assert() failure should make this fairly
    // obvious.
    assert(dest_len <= OPAL_MAX_SIZE_ALLOWED_BY_OPAL_STRING_COPY);

    for (i = 0; i < dest_len; ++i, ++src, ++new_dest) {
        *new_dest = *src;
        if ('\0' == *src) {
            return;
        }
    }

    dest[i - 1] = '\0';
}
