/*
 * Copyright (c) 2015 Cisco Systems, Inc.  All rights reserved.
 * $COPYRIGHT$
 *
 * Additional copyrights may follow
 *
 * $HEADER$
 */

#ifndef OPAL_DL_DLOPEN
#define OPAL_DL_DLOPEN

#include "opal_config.h"

#include "opal/mca/dl/dl.h"

OPAL_DECLSPEC extern opal_dl_base_module_t opal_dl_dlopen_module;

/*
 * Dynamic library handles generated by this component.
 *
 * If we're debugging, keep a copy of the name of the file we've opened.
 */
struct opal_dl_handle_t {
    void *dlopen_handle;
#if OPAL_ENABLE_DEBUG
    void *filename;
#endif
};

typedef struct {
    opal_dl_base_component_t base;

    char *filename_suffixes_mca_storage;
    char **filename_suffixes;
} opal_dl_dlopen_component_t;

OPAL_DECLSPEC extern opal_dl_dlopen_component_t mca_dl_dlopen_component;

#endif /* OPAL_DL_DLOPEN */
