// IWYU pragma: private, include "nvim/autocmd.h"
#define DEFINE_FUNC_ATTRIBUTES
#include "nvim/func_attr.h"
#undef DEFINE_FUNC_ATTRIBUTES
#ifndef DLLEXPORT
#  ifdef MSWIN
#    define DLLEXPORT __declspec(dllexport)
#  else
#    define DLLEXPORT
#  endif
#endif
DLLEXPORT void aucmd_del_for_event_and_group(event_T event, int group);
DLLEXPORT AutoCmdVec *au_get_autocmds_for_event(event_T event) FUNC_ATTR_PURE;
DLLEXPORT void aubuflocal_remove(buf_T *buf);
DLLEXPORT int augroup_add(const char *name);
DLLEXPORT void augroup_del(char *name, bool stupid_legacy_mode);
DLLEXPORT int augroup_find(const char *name) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT char *augroup_name(int group);
DLLEXPORT bool augroup_exists(const char *name) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT void do_augroup(char *arg, bool del_group);
DLLEXPORT bool is_aucmd_win(win_T *win);
DLLEXPORT event_T event_name2nr(const char *start, char **end);
DLLEXPORT event_T event_name2nr_str(String str);
DLLEXPORT const char *event_nr2name(event_T event) FUNC_ATTR_NONNULL_RET FUNC_ATTR_WARN_UNUSED_RESULT FUNC_ATTR_CONST;
DLLEXPORT bool event_ignored(event_T event, char *ei) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT int check_ei(char *ei);
DLLEXPORT char *au_event_disable(char *what);
DLLEXPORT void au_event_restore(char *old_ei);
DLLEXPORT void do_autocmd(exarg_T *eap, char *arg_in, int forceit);
DLLEXPORT void do_all_autocmd_events(const char *pat, bool once, int nested, char *cmd, bool del, int group);
DLLEXPORT int do_autocmd_event(event_T event, const char *pat, bool once, int nested, const char *cmd, bool del, int group) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT int autocmd_register(int64_t id, event_T event, const char *pat, int patlen, int group, bool once, bool nested, char *desc, const char *handler_cmd, Callback *handler_fn);
DLLEXPORT size_t aucmd_pattern_length(const char *pat) FUNC_ATTR_PURE;
DLLEXPORT const char *aucmd_next_pattern(const char *pat, size_t patlen) FUNC_ATTR_PURE;
DLLEXPORT int do_doautocmd(char *arg_start, bool do_msg, bool *did_something);
DLLEXPORT void ex_doautoall(exarg_T *eap);
DLLEXPORT bool check_nomodeline(char **argp) FUNC_ATTR_NONNULL_ALL FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT void aucmd_prepbuf(aco_save_T *aco, buf_T *buf);
DLLEXPORT void aucmd_restbuf(aco_save_T *aco);
DLLEXPORT bool apply_autocmds(event_T event, char *fname, char *fname_io, bool force, buf_T *buf);
DLLEXPORT bool apply_autocmds_exarg(event_T event, char *fname, char *fname_io, bool force, buf_T *buf, exarg_T *eap);
DLLEXPORT bool apply_autocmds_retval(event_T event, char *fname, char *fname_io, bool force, buf_T *buf, int *retval);
DLLEXPORT bool has_event(event_T event) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool has_cursorhold(void) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool trigger_cursorhold(void) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool apply_autocmds_group(event_T event, char *fname, char *fname_io, bool force, int group, buf_T *buf, exarg_T *eap, Object *data);
DLLEXPORT void block_autocmds(void);
DLLEXPORT void unblock_autocmds(void);
DLLEXPORT bool is_autocmd_blocked(void) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT char *getnextac(int c, void *cookie, int indent, bool do_concat);
DLLEXPORT bool has_autocmd(event_T event, char *sfname, buf_T *buf) FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT char *expand_get_augroup_name(expand_T *xp, int idx);
DLLEXPORT char *set_context_in_autocmd(expand_T *xp, char *arg, bool doautocmd);
DLLEXPORT char *expand_get_event_name(expand_T *xp, int idx);
DLLEXPORT char *get_event_name_no_group(expand_T *xp FUNC_ATTR_UNUSED, int idx, bool win);
DLLEXPORT bool autocmd_supported(const char *const event) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool au_exists(const char *const arg) FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool aupat_is_buflocal(const char *pat, int patlen) FUNC_ATTR_PURE;
DLLEXPORT int aupat_get_buflocal_nr(const char *pat, int patlen);
DLLEXPORT void aupat_normalize_buflocal_pat(char *dest, const char *pat, int patlen, int buflocal_nr);
DLLEXPORT int autocmd_delete_event(int group, event_T event, const char *pat) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT bool autocmd_delete_id(int64_t id);
DLLEXPORT char *aucmd_handler_to_string(AutoCmd *ac) FUNC_ATTR_PURE;
DLLEXPORT bool au_event_is_empty(event_T event) FUNC_ATTR_PURE;
DLLEXPORT void may_trigger_vim_suspend_resume(bool suspend);
DLLEXPORT void do_autocmd_uienter(uint64_t chanid, bool attached);
DLLEXPORT void do_autocmd_focusgained(bool gained);
DLLEXPORT void do_filetype_autocmd(buf_T *buf, bool force);
#include "nvim/func_attr.h"
