#include "ParseName.hxx"
#include "Type.hxx"

#include <assert.h>
#include <string.h>

TagType
tag_name_parse(const char *name) noexcept
{
  assert(name != nullptr);

  switch (*name) {
  case 'A':
    if (strcmp(name + 1, "lbum") == 0) return TagType(2);
    if (strcmp(name + 1, "lbumArtist") == 0) return TagType(4);
    if (strcmp(name + 1, "lbumArtistSort") == 0) return TagType(5);
    if (strcmp(name + 1, "lbumSort") == 0) return TagType(3);
    if (strcmp(name + 1, "rtist") == 0) return TagType(0);
    if (strcmp(name + 1, "rtistSort") == 0) return TagType(1);
    break;

  case 'C':
    if (strcmp(name + 1, "omment") == 0) return TagType(25);
    if (strcmp(name + 1, "omposer") == 0) return TagType(14);
    if (strcmp(name + 1, "omposerSort") == 0) return TagType(15);
    if (strcmp(name + 1, "onductor") == 0) return TagType(17);
    break;

  case 'D':
    if (strcmp(name + 1, "ate") == 0) return TagType(12);
    if (strcmp(name + 1, "isc") == 0) return TagType(26);
    break;

  case 'E':
    if (strcmp(name + 1, "nsemble") == 0) return TagType(22);
    break;

  case 'G':
    if (strcmp(name + 1, "enre") == 0) return TagType(10);
    if (strcmp(name + 1, "rouping") == 0) return TagType(24);
    break;

  case 'L':
    if (strcmp(name + 1, "abel") == 0) return TagType(27);
    if (strcmp(name + 1, "ocation") == 0) return TagType(23);
    break;

  case 'M':
    if (strcmp(name + 1, "USICBRAINZ_ALBUMARTISTID") == 0) return TagType(30);
    if (strcmp(name + 1, "USICBRAINZ_ALBUMID") == 0) return TagType(29);
    if (strcmp(name + 1, "USICBRAINZ_ARTISTID") == 0) return TagType(28);
    if (strcmp(name + 1, "USICBRAINZ_RELEASEGROUPID") == 0) return TagType(34);
    if (strcmp(name + 1, "USICBRAINZ_RELEASETRACKID") == 0) return TagType(32);
    if (strcmp(name + 1, "USICBRAINZ_TRACKID") == 0) return TagType(31);
    if (strcmp(name + 1, "USICBRAINZ_WORKID") == 0) return TagType(33);
    if (strcmp(name + 1, "ood") == 0) return TagType(11);
    if (strcmp(name + 1, "ovement") == 0) return TagType(19);
    if (strcmp(name + 1, "ovementNumber") == 0) return TagType(20);
    break;

  case 'N':
    if (strcmp(name + 1, "ame") == 0) return TagType(9);
    break;

  case 'O':
    if (strcmp(name + 1, "riginalDate") == 0) return TagType(13);
    break;

  case 'P':
    if (strcmp(name + 1, "erformer") == 0) return TagType(16);
    break;

  case 'S':
    if (strcmp(name + 1, "howMovement") == 0) return TagType(21);
    break;

  case 'T':
    if (strcmp(name + 1, "itle") == 0) return TagType(6);
    if (strcmp(name + 1, "itleSort") == 0) return TagType(7);
    if (strcmp(name + 1, "rack") == 0) return TagType(8);
    break;

  case 'W':
    if (strcmp(name + 1, "ork") == 0) return TagType(18);
    break;

  }

  return TAG_NUM_OF_ITEM_TYPES;
}
