// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func CopyOrigExponentialHistogramDataPointSlice(dest, src []*otlpmetrics.ExponentialHistogramDataPoint) []*otlpmetrics.ExponentialHistogramDataPoint {
	var newDest []*otlpmetrics.ExponentialHistogramDataPoint
	if cap(dest) < len(src) {
		newDest = make([]*otlpmetrics.ExponentialHistogramDataPoint, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigExponentialHistogramDataPoint()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigExponentialHistogramDataPoint(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigExponentialHistogramDataPoint()
		}
	}
	for i := range src {
		CopyOrigExponentialHistogramDataPoint(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestExponentialHistogramDataPointSlice() []*otlpmetrics.ExponentialHistogramDataPoint {
	orig := make([]*otlpmetrics.ExponentialHistogramDataPoint, 5)
	orig[0] = NewOrigExponentialHistogramDataPoint()
	orig[1] = GenTestOrigExponentialHistogramDataPoint()
	orig[2] = NewOrigExponentialHistogramDataPoint()
	orig[3] = GenTestOrigExponentialHistogramDataPoint()
	orig[4] = NewOrigExponentialHistogramDataPoint()
	return orig
}
