/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Interface Declarations                                                     *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace rock {
/// Interface to abstract away gemm+gemm-wrapping operators in the rock dialect,
///     which mainly include attention and gemm+gemm and friends that can be implemented
///     with flash attention.
/// 
///     This should include functions to get common attributes.
class RockGemmGemmWrapperInterface;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Interface to abstract away gemm+gemm-wrapping operators in the rock dialect,
///     which mainly include attention and gemm+gemm and friends that can be implemented
///     with flash attention.
/// 
///     This should include functions to get common attributes.
namespace detail {
struct RockGemmGemmWrapperInterfaceInterfaceTraits {
  struct Concept {
    /// The methods defined by the interface.
    ::mlir::rock::KernelType (*getKernelType)(const Concept *impl, ::mlir::Operation *);
    OpOperand *(*getOutArgument)(const Concept *impl, ::mlir::Operation *);
    ::mlir::rock::GemmGemmSize (*getGemmGemmSize)(const Concept *impl, ::mlir::Operation *);
    ::mlir::Type (*getAType)(const Concept *impl, ::mlir::Operation *);
    ::mlir::Type (*getBType)(const Concept *impl, ::mlir::Operation *);
    ::mlir::Type (*getCType)(const Concept *impl, ::mlir::Operation *);
    ::mlir::Type (*getOutType)(const Concept *impl, ::mlir::Operation *);
    bool (*getTransposedA)(const Concept *impl, ::mlir::Operation *);
    bool (*getTransposedB)(const Concept *impl, ::mlir::Operation *);
    bool (*getTransposedC)(const Concept *impl, ::mlir::Operation *);
    bool (*getTransposedOut)(const Concept *impl, ::mlir::Operation *);
    std::optional<::mlir::rock::GemmFeatures> (*getGemmFeatures)(const Concept *impl, ::mlir::Operation *);
    ::mlir::rock::GemmFeaturesAttr (*getGemmFeaturesAttr)(const Concept *impl, ::mlir::Operation *);
    void (*setGemm0ParamsAttr)(const Concept *impl, ::mlir::Operation *, ::mlir::Attribute);
    void (*setGemm1ParamsAttr)(const Concept *impl, ::mlir::Operation *, ::mlir::Attribute);
    std::optional<RockTuningParamAttrInterface> (*getGemm0Params)(const Concept *impl, ::mlir::Operation *);
    std::optional<RockTuningParamAttrInterface> (*getGemm1Params)(const Concept *impl, ::mlir::Operation *);
    ArrayRef<int64_t> (*getFirstGemmIndices)(const Concept *impl, ::mlir::Operation *);
    void (*setFirstGemmIndices)(const Concept *impl, ::mlir::Operation *, ArrayRef<int64_t>);
    rock::StoreMethodAttr (*getStoreMethodAttr)(const Concept *impl, ::mlir::Operation *);
    void (*setStoreMethodAttr)(const Concept *impl, ::mlir::Operation *, rock::StoreMethodAttr);
    Region&(*getPreSecondGemmRegion)(const Concept *impl, ::mlir::Operation *);
  };
  template<typename ConcreteOp>
  class Model : public Concept {
  public:
    using Interface = ::mlir::rock::RockGemmGemmWrapperInterface;
    Model() : Concept{getKernelType, getOutArgument, getGemmGemmSize, getAType, getBType, getCType, getOutType, getTransposedA, getTransposedB, getTransposedC, getTransposedOut, getGemmFeatures, getGemmFeaturesAttr, setGemm0ParamsAttr, setGemm1ParamsAttr, getGemm0Params, getGemm1Params, getFirstGemmIndices, setFirstGemmIndices, getStoreMethodAttr, setStoreMethodAttr, getPreSecondGemmRegion} {}

    static inline ::mlir::rock::KernelType getKernelType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline OpOperand *getOutArgument(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::rock::GemmGemmSize getGemmGemmSize(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::Type getAType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::Type getBType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::Type getCType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::Type getOutType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline bool getTransposedA(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline bool getTransposedB(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline bool getTransposedC(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline bool getTransposedOut(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline std::optional<::mlir::rock::GemmFeatures> getGemmFeatures(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::rock::GemmFeaturesAttr getGemmFeaturesAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setGemm0ParamsAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params);
    static inline void setGemm1ParamsAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params);
    static inline std::optional<RockTuningParamAttrInterface> getGemm0Params(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline std::optional<RockTuningParamAttrInterface> getGemm1Params(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ArrayRef<int64_t> getFirstGemmIndices(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setFirstGemmIndices(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ArrayRef<int64_t> indices);
    static inline rock::StoreMethodAttr getStoreMethodAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setStoreMethodAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, rock::StoreMethodAttr storeMethod);
    static inline Region&getPreSecondGemmRegion(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteOp>
  class FallbackModel : public Concept {
  public:
    using Interface = ::mlir::rock::RockGemmGemmWrapperInterface;
    FallbackModel() : Concept{getKernelType, getOutArgument, getGemmGemmSize, getAType, getBType, getCType, getOutType, getTransposedA, getTransposedB, getTransposedC, getTransposedOut, getGemmFeatures, getGemmFeaturesAttr, setGemm0ParamsAttr, setGemm1ParamsAttr, getGemm0Params, getGemm1Params, getFirstGemmIndices, setFirstGemmIndices, getStoreMethodAttr, setStoreMethodAttr, getPreSecondGemmRegion} {}

    static inline ::mlir::rock::KernelType getKernelType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline OpOperand *getOutArgument(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::rock::GemmGemmSize getGemmGemmSize(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::Type getAType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::Type getBType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::Type getCType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::Type getOutType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline bool getTransposedA(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline bool getTransposedB(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline bool getTransposedC(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline bool getTransposedOut(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline std::optional<::mlir::rock::GemmFeatures> getGemmFeatures(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ::mlir::rock::GemmFeaturesAttr getGemmFeaturesAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setGemm0ParamsAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params);
    static inline void setGemm1ParamsAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params);
    static inline std::optional<RockTuningParamAttrInterface> getGemm0Params(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline std::optional<RockTuningParamAttrInterface> getGemm1Params(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline ArrayRef<int64_t> getFirstGemmIndices(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setFirstGemmIndices(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ArrayRef<int64_t> indices);
    static inline rock::StoreMethodAttr getStoreMethodAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
    static inline void setStoreMethodAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, rock::StoreMethodAttr storeMethod);
    static inline Region&getPreSecondGemmRegion(const Concept *impl, ::mlir::Operation *tablegen_opaque_val);
  };
  template<typename ConcreteModel, typename ConcreteOp>
  class ExternalModel : public FallbackModel<ConcreteModel> {
  public:
    using ConcreteEntity = ConcreteOp;
    std::optional<::mlir::rock::GemmFeatures> getGemmFeatures(::mlir::Operation *tablegen_opaque_val) const;
    ::mlir::rock::GemmFeaturesAttr getGemmFeaturesAttr(::mlir::Operation *tablegen_opaque_val) const;
    void setGemm0ParamsAttr(::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params) const;
    void setGemm1ParamsAttr(::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params) const;
    std::optional<RockTuningParamAttrInterface> getGemm0Params(::mlir::Operation *tablegen_opaque_val) const;
    std::optional<RockTuningParamAttrInterface> getGemm1Params(::mlir::Operation *tablegen_opaque_val) const;
    ArrayRef<int64_t> getFirstGemmIndices(::mlir::Operation *tablegen_opaque_val) const;
    void setFirstGemmIndices(::mlir::Operation *tablegen_opaque_val, ArrayRef<int64_t> indices) const;
    rock::StoreMethodAttr getStoreMethodAttr(::mlir::Operation *tablegen_opaque_val) const;
    void setStoreMethodAttr(::mlir::Operation *tablegen_opaque_val, rock::StoreMethodAttr storeMethod) const;
  };
};
template <typename ConcreteOp>
struct RockGemmGemmWrapperInterfaceTrait;

} // namespace detail
class RockGemmGemmWrapperInterface : public ::mlir::OpInterface<RockGemmGemmWrapperInterface, detail::RockGemmGemmWrapperInterfaceInterfaceTraits> {
public:
  using ::mlir::OpInterface<RockGemmGemmWrapperInterface, detail::RockGemmGemmWrapperInterfaceInterfaceTraits>::OpInterface;
  template <typename ConcreteOp>
  struct Trait : public detail::RockGemmGemmWrapperInterfaceTrait<ConcreteOp> {};

  /// Return the KernelType of this op
  ::mlir::rock::KernelType getKernelType();

  /// Return the OpOperand that corresponds to the operand argument
  /// that corresponds to the output result of the operation.
  OpOperand *getOutArgument();

  /// Return the size of the matrix multiplication that this op will eventually
  /// perform.
  ::mlir::rock::GemmGemmSize getGemmGemmSize();

  /// Return the element type of [what will become] matrix A for this operation.
  ::mlir::Type getAType();

  /// Return the element type of [what will become] matrix B for this operation.
  ::mlir::Type getBType();

  /// Return the element type of [what will become] matrix C for this operation.
  ::mlir::Type getCType();

  /// Return the element type of [what will become] output matrix for this operation.
  ::mlir::Type getOutType();

  /// Return the whether matrix A is transposed.
  bool getTransposedA();

  /// Return the whether matrix B is transposed.
  bool getTransposedB();

  /// Return the whether matrix C is transposed.
  bool getTransposedC();

  /// Return the whether output matrix is transposed.
  bool getTransposedOut();

  /// Return the optional features attribute of this op.
  std::optional<::mlir::rock::GemmFeatures> getGemmFeatures();

  /// Return the features attribute of this op.
  ::mlir::rock::GemmFeaturesAttr getGemmFeaturesAttr();

  /// Set the tuning parameters attribute of the first GEMM
  void setGemm0ParamsAttr(::mlir::Attribute params);

  /// Set the tuning parameters attribute of the second GEMM
  void setGemm1ParamsAttr(::mlir::Attribute params);

  /// Get the tuning parameters attribute of the first GEMM
  std::optional<RockTuningParamAttrInterface> getGemm0Params();

  /// Get the tuning parameters attribute of the second GEMM
  std::optional<RockTuningParamAttrInterface> getGemm1Params();

  /// Output of the first GEMM feeds into elementwise region that comes after it. 
  /// Those elementwise regions can have one argument that is dependent on the first GEMM.
  /// This method returns the indices of that argument for each elementwise region in the order 
  /// they appear after the first GEMM.
  ArrayRef<int64_t> getFirstGemmIndices();

  /// Set the indices of the first GEMM dependent arguments for the elementwise regions that come after it.
  void setFirstGemmIndices(ArrayRef<int64_t> indices);

  /// Return the store method attribute of this op.
  rock::StoreMethodAttr getStoreMethodAttr();

  /// Set the store method attribute of this op.
  void setStoreMethodAttr(rock::StoreMethodAttr storeMethod);

  /// Return the region corresponding to the fusion between first and second GEMM.
  Region&getPreSecondGemmRegion();
};
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
namespace detail {
  template <typename ConcreteOp>
  struct RockGemmGemmWrapperInterfaceTrait : public ::mlir::OpInterface<RockGemmGemmWrapperInterface, detail::RockGemmGemmWrapperInterfaceInterfaceTraits>::Trait<ConcreteOp> {

    /// Return the optional features attribute of this op.
    std::optional<::mlir::rock::GemmFeatures> getGemmFeatures() {
      return (*static_cast<ConcreteOp *>(this)).getFeatures();
    }

    /// Return the features attribute of this op.
    ::mlir::rock::GemmFeaturesAttr getGemmFeaturesAttr() {
      return (*static_cast<ConcreteOp *>(this)).getFeaturesAttr();
    }

    /// Set the tuning parameters attribute of the first GEMM
    void setGemm0ParamsAttr(::mlir::Attribute params) {
      (*static_cast<ConcreteOp *>(this))->setAttr((*static_cast<ConcreteOp *>(this)).getParams0AttrName(), params);
    }

    /// Set the tuning parameters attribute of the second GEMM
    void setGemm1ParamsAttr(::mlir::Attribute params) {
      (*static_cast<ConcreteOp *>(this))->setAttr((*static_cast<ConcreteOp *>(this)).getParams1AttrName(), params);
    }

    /// Get the tuning parameters attribute of the first GEMM
    std::optional<RockTuningParamAttrInterface> getGemm0Params() {
      return (*static_cast<ConcreteOp *>(this)).getParams0();
    }

    /// Get the tuning parameters attribute of the second GEMM
    std::optional<RockTuningParamAttrInterface> getGemm1Params() {
      return (*static_cast<ConcreteOp *>(this)).getParams1();
    }

    /// Output of the first GEMM feeds into elementwise region that comes after it. 
    /// Those elementwise regions can have one argument that is dependent on the first GEMM.
    /// This method returns the indices of that argument for each elementwise region in the order 
    /// they appear after the first GEMM.
    ArrayRef<int64_t> getFirstGemmIndices() {
      return (*static_cast<ConcreteOp *>(this)).getFirstGemmIndices();
    }

    /// Set the indices of the first GEMM dependent arguments for the elementwise regions that come after it.
    void setFirstGemmIndices(ArrayRef<int64_t> indices) {
      (*static_cast<ConcreteOp *>(this)).setFirstGemmIndices(indices);
    }

    /// Return the store method attribute of this op.
    rock::StoreMethodAttr getStoreMethodAttr() {
      return (*static_cast<ConcreteOp *>(this)).getStoreMethodAttr();
    }

    /// Set the store method attribute of this op.
    void setStoreMethodAttr(rock::StoreMethodAttr storeMethod) {
      (*static_cast<ConcreteOp *>(this)).setStoreMethodAttr(storeMethod);
    }
    static ::llvm::LogicalResult verifyTrait(::mlir::Operation *op) {
      auto concreteOp = ::mlir::cast<ConcreteOp>(op);
    if (op->getNumResults() == 1) {
      if (op->getResult(0).getType() !=
          concreteOp.getOutArgument()->get().getType()) {
        return op->emitOpError("result type must match output argument type");
      }
    }
    return ::mlir::success();
    }
  };
}// namespace detail
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
template<typename ConcreteOp>
::mlir::rock::KernelType detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getKernelType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getKernelType();
}
template<typename ConcreteOp>
OpOperand *detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getOutArgument(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getOutArgument();
}
template<typename ConcreteOp>
::mlir::rock::GemmGemmSize detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getGemmGemmSize(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getGemmGemmSize();
}
template<typename ConcreteOp>
::mlir::Type detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getAType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getAType();
}
template<typename ConcreteOp>
::mlir::Type detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getBType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getBType();
}
template<typename ConcreteOp>
::mlir::Type detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getCType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getCType();
}
template<typename ConcreteOp>
::mlir::Type detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getOutType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getOutType();
}
template<typename ConcreteOp>
bool detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getTransposedA(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getTransposedA();
}
template<typename ConcreteOp>
bool detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getTransposedB(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getTransposedB();
}
template<typename ConcreteOp>
bool detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getTransposedC(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getTransposedC();
}
template<typename ConcreteOp>
bool detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getTransposedOut(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getTransposedOut();
}
template<typename ConcreteOp>
std::optional<::mlir::rock::GemmFeatures> detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getGemmFeatures(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getGemmFeatures();
}
template<typename ConcreteOp>
::mlir::rock::GemmFeaturesAttr detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getGemmFeaturesAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getGemmFeaturesAttr();
}
template<typename ConcreteOp>
void detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::setGemm0ParamsAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).setGemm0ParamsAttr(params);
}
template<typename ConcreteOp>
void detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::setGemm1ParamsAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).setGemm1ParamsAttr(params);
}
template<typename ConcreteOp>
std::optional<RockTuningParamAttrInterface> detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getGemm0Params(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getGemm0Params();
}
template<typename ConcreteOp>
std::optional<RockTuningParamAttrInterface> detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getGemm1Params(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getGemm1Params();
}
template<typename ConcreteOp>
ArrayRef<int64_t> detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getFirstGemmIndices(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getFirstGemmIndices();
}
template<typename ConcreteOp>
void detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::setFirstGemmIndices(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ArrayRef<int64_t> indices) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).setFirstGemmIndices(indices);
}
template<typename ConcreteOp>
rock::StoreMethodAttr detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getStoreMethodAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getStoreMethodAttr();
}
template<typename ConcreteOp>
void detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::setStoreMethodAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, rock::StoreMethodAttr storeMethod) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).setStoreMethodAttr(storeMethod);
}
template<typename ConcreteOp>
Region&detail::RockGemmGemmWrapperInterfaceInterfaceTraits::Model<ConcreteOp>::getPreSecondGemmRegion(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getPreSecondGemmRegion();
}
template<typename ConcreteOp>
::mlir::rock::KernelType detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getKernelType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getKernelType(tablegen_opaque_val);
}
template<typename ConcreteOp>
OpOperand *detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getOutArgument(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getOutArgument(tablegen_opaque_val);
}
template<typename ConcreteOp>
::mlir::rock::GemmGemmSize detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getGemmGemmSize(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getGemmGemmSize(tablegen_opaque_val);
}
template<typename ConcreteOp>
::mlir::Type detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getAType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getAType(tablegen_opaque_val);
}
template<typename ConcreteOp>
::mlir::Type detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getBType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getBType(tablegen_opaque_val);
}
template<typename ConcreteOp>
::mlir::Type detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getCType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getCType(tablegen_opaque_val);
}
template<typename ConcreteOp>
::mlir::Type detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getOutType(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getOutType(tablegen_opaque_val);
}
template<typename ConcreteOp>
bool detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getTransposedA(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getTransposedA(tablegen_opaque_val);
}
template<typename ConcreteOp>
bool detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getTransposedB(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getTransposedB(tablegen_opaque_val);
}
template<typename ConcreteOp>
bool detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getTransposedC(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getTransposedC(tablegen_opaque_val);
}
template<typename ConcreteOp>
bool detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getTransposedOut(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getTransposedOut(tablegen_opaque_val);
}
template<typename ConcreteOp>
std::optional<::mlir::rock::GemmFeatures> detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getGemmFeatures(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getGemmFeatures(tablegen_opaque_val);
}
template<typename ConcreteOp>
::mlir::rock::GemmFeaturesAttr detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getGemmFeaturesAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getGemmFeaturesAttr(tablegen_opaque_val);
}
template<typename ConcreteOp>
void detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::setGemm0ParamsAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params) {
  return static_cast<const ConcreteOp *>(impl)->setGemm0ParamsAttr(tablegen_opaque_val, params);
}
template<typename ConcreteOp>
void detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::setGemm1ParamsAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params) {
  return static_cast<const ConcreteOp *>(impl)->setGemm1ParamsAttr(tablegen_opaque_val, params);
}
template<typename ConcreteOp>
std::optional<RockTuningParamAttrInterface> detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getGemm0Params(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getGemm0Params(tablegen_opaque_val);
}
template<typename ConcreteOp>
std::optional<RockTuningParamAttrInterface> detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getGemm1Params(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getGemm1Params(tablegen_opaque_val);
}
template<typename ConcreteOp>
ArrayRef<int64_t> detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getFirstGemmIndices(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getFirstGemmIndices(tablegen_opaque_val);
}
template<typename ConcreteOp>
void detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::setFirstGemmIndices(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, ArrayRef<int64_t> indices) {
  return static_cast<const ConcreteOp *>(impl)->setFirstGemmIndices(tablegen_opaque_val, indices);
}
template<typename ConcreteOp>
rock::StoreMethodAttr detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getStoreMethodAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getStoreMethodAttr(tablegen_opaque_val);
}
template<typename ConcreteOp>
void detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::setStoreMethodAttr(const Concept *impl, ::mlir::Operation *tablegen_opaque_val, rock::StoreMethodAttr storeMethod) {
  return static_cast<const ConcreteOp *>(impl)->setStoreMethodAttr(tablegen_opaque_val, storeMethod);
}
template<typename ConcreteOp>
Region&detail::RockGemmGemmWrapperInterfaceInterfaceTraits::FallbackModel<ConcreteOp>::getPreSecondGemmRegion(const Concept *impl, ::mlir::Operation *tablegen_opaque_val) {
  return static_cast<const ConcreteOp *>(impl)->getPreSecondGemmRegion(tablegen_opaque_val);
}
template<typename ConcreteModel, typename ConcreteOp>
std::optional<::mlir::rock::GemmFeatures> detail::RockGemmGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getGemmFeatures(::mlir::Operation *tablegen_opaque_val) const {
return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getFeatures();
}
template<typename ConcreteModel, typename ConcreteOp>
::mlir::rock::GemmFeaturesAttr detail::RockGemmGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getGemmFeaturesAttr(::mlir::Operation *tablegen_opaque_val) const {
return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getFeaturesAttr();
}
template<typename ConcreteModel, typename ConcreteOp>
void detail::RockGemmGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::setGemm0ParamsAttr(::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params) const {
(llvm::cast<ConcreteOp>(tablegen_opaque_val))->setAttr((llvm::cast<ConcreteOp>(tablegen_opaque_val)).getParams0AttrName(), params);
}
template<typename ConcreteModel, typename ConcreteOp>
void detail::RockGemmGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::setGemm1ParamsAttr(::mlir::Operation *tablegen_opaque_val, ::mlir::Attribute params) const {
(llvm::cast<ConcreteOp>(tablegen_opaque_val))->setAttr((llvm::cast<ConcreteOp>(tablegen_opaque_val)).getParams1AttrName(), params);
}
template<typename ConcreteModel, typename ConcreteOp>
std::optional<RockTuningParamAttrInterface> detail::RockGemmGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getGemm0Params(::mlir::Operation *tablegen_opaque_val) const {
return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getParams0();
}
template<typename ConcreteModel, typename ConcreteOp>
std::optional<RockTuningParamAttrInterface> detail::RockGemmGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getGemm1Params(::mlir::Operation *tablegen_opaque_val) const {
return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getParams1();
}
template<typename ConcreteModel, typename ConcreteOp>
ArrayRef<int64_t> detail::RockGemmGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getFirstGemmIndices(::mlir::Operation *tablegen_opaque_val) const {
return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getFirstGemmIndices();
}
template<typename ConcreteModel, typename ConcreteOp>
void detail::RockGemmGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::setFirstGemmIndices(::mlir::Operation *tablegen_opaque_val, ArrayRef<int64_t> indices) const {
(llvm::cast<ConcreteOp>(tablegen_opaque_val)).setFirstGemmIndices(indices);
}
template<typename ConcreteModel, typename ConcreteOp>
rock::StoreMethodAttr detail::RockGemmGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::getStoreMethodAttr(::mlir::Operation *tablegen_opaque_val) const {
return (llvm::cast<ConcreteOp>(tablegen_opaque_val)).getStoreMethodAttr();
}
template<typename ConcreteModel, typename ConcreteOp>
void detail::RockGemmGemmWrapperInterfaceInterfaceTraits::ExternalModel<ConcreteModel, ConcreteOp>::setStoreMethodAttr(::mlir::Operation *tablegen_opaque_val, rock::StoreMethodAttr storeMethod) const {
(llvm::cast<ConcreteOp>(tablegen_opaque_val)).setStoreMethodAttr(storeMethod);
}
} // namespace rock
} // namespace mlir
