#include "nv_push_clcab5.h"

#include <stdio.h>





const char *P_PARSE_NVC9B5_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVC9B5_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVCAB5_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NVC9B5_MTHD(idx);

                                                        case NVCAB5_LAUNCH_DMA:
        return "NVCAB5_LAUNCH_DMA";
                                                                                case NVCAB5_SET_DST_BLOCK_SIZE:
        return "NVCAB5_SET_DST_BLOCK_SIZE";
                        case NVCAB5_SET_SRC_BLOCK_SIZE:
        return "NVCAB5_SET_SRC_BLOCK_SIZE";
                                        
    }
}

void
P_DUMP_NVCAB5_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NVC9B5_MTHD_DATA(fp, idx, data, prefix);
    break;

                                                      
    case NVCAB5_LAUNCH_DMA:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.DATA_TRANSFER_TYPE = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVCAB5_LAUNCH_DMA_DATA_TRANSFER_TYPE_PIPELINED:
            fprintf(fp, "PIPELINED\n");
            break;
        case NVCAB5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NON_PIPELINED:
            fprintf(fp, "NON_PIPELINED\n");
            break;
        case NVCAB5_LAUNCH_DMA_DATA_TRANSFER_TYPE_PREFETCH:
            fprintf(fp, "PREFETCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_ENABLE = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_FLUSH_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCAB5_LAUNCH_DMA_FLUSH_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 25) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_TYPE = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_FLUSH_TYPE_SYS:
            fprintf(fp, "SYS\n");
            break;
        case NVCAB5_LAUNCH_DMA_FLUSH_TYPE_GL:
            fprintf(fp, "GL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 3) & ((1u << 2) - 1);
        fprintf(fp, "%s.SEMAPHORE_TYPE = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_SEMAPHORE_NO_TIMESTAMP:
            fprintf(fp, "RELEASE_SEMAPHORE_NO_TIMESTAMP\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_SEMAPHORE_WITH_TIMESTAMP:
            fprintf(fp, "RELEASE_SEMAPHORE_WITH_TIMESTAMP\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_CONDITIONAL_INTR_SEMAPHORE:
            fprintf(fp, "RELEASE_CONDITIONAL_INTR_SEMAPHORE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 5) & ((1u << 2) - 1);
        fprintf(fp, "%s.INTERRUPT_TYPE = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_INTERRUPT_TYPE_NONE:
            fprintf(fp, "NONE\n");
            break;
        case NVCAB5_LAUNCH_DMA_INTERRUPT_TYPE_BLOCKING:
            fprintf(fp, "BLOCKING\n");
            break;
        case NVCAB5_LAUNCH_DMA_INTERRUPT_TYPE_NON_BLOCKING:
            fprintf(fp, "NON_BLOCKING\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 7) & ((1u << 1) - 1);
        fprintf(fp, "%s.SRC_MEMORY_LAYOUT = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_BLOCKLINEAR:
            fprintf(fp, "BLOCKLINEAR\n");
            break;
        case NVCAB5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_PITCH:
            fprintf(fp, "PITCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.DST_MEMORY_LAYOUT = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR:
            fprintf(fp, "BLOCKLINEAR\n");
            break;
        case NVCAB5_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH:
            fprintf(fp, "PITCH\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.MULTI_LINE_ENABLE = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_MULTI_LINE_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCAB5_LAUNCH_DMA_MULTI_LINE_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.REMAP_ENABLE = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_REMAP_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCAB5_LAUNCH_DMA_REMAP_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.SRC_TYPE = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_SRC_TYPE_VIRTUAL:
            fprintf(fp, "VIRTUAL\n");
            break;
        case NVCAB5_LAUNCH_DMA_SRC_TYPE_PHYSICAL:
            fprintf(fp, "PHYSICAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 13) & ((1u << 1) - 1);
        fprintf(fp, "%s.DST_TYPE = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_DST_TYPE_VIRTUAL:
            fprintf(fp, "VIRTUAL\n");
            break;
        case NVCAB5_LAUNCH_DMA_DST_TYPE_PHYSICAL:
            fprintf(fp, "PHYSICAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 14) & ((1u << 4) - 1);
        fprintf(fp, "%s.SEMAPHORE_REDUCTION = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMIN:
            fprintf(fp, "IMIN\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMAX:
            fprintf(fp, "IMAX\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IXOR:
            fprintf(fp, "IXOR\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IAND:
            fprintf(fp, "IAND\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IOR:
            fprintf(fp, "IOR\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IADD:
            fprintf(fp, "IADD\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_INC:
            fprintf(fp, "INC\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_DEC:
            fprintf(fp, "DEC\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_INVALIDA:
            fprintf(fp, "INVALIDA\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_INVALIDB:
            fprintf(fp, "INVALIDB\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FADD:
            fprintf(fp, "FADD\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FMIN:
            fprintf(fp, "FMIN\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FMAX:
            fprintf(fp, "FMAX\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_INVALIDC:
            fprintf(fp, "INVALIDC\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_INVALIDD:
            fprintf(fp, "INVALIDD\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_INVALIDE:
            fprintf(fp, "INVALIDE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 18) & ((1u << 1) - 1);
        fprintf(fp, "%s.SEMAPHORE_REDUCTION_SIGN = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN_SIGNED:
            fprintf(fp, "SIGNED\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN_UNSIGNED:
            fprintf(fp, "UNSIGNED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 19) & ((1u << 1) - 1);
        fprintf(fp, "%s.SEMAPHORE_REDUCTION_ENABLE = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 2) - 1);
        fprintf(fp, "%s.COPY_TYPE = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_COPY_TYPE_PROT2PROT:
            fprintf(fp, "PROT2PROT\n");
            break;
        case NVCAB5_LAUNCH_DMA_COPY_TYPE_SECURE:
            fprintf(fp, "SECURE\n");
            break;
        case NVCAB5_LAUNCH_DMA_COPY_TYPE_NONPROT2NONPROT:
            fprintf(fp, "NONPROT2NONPROT\n");
            break;
        case NVCAB5_LAUNCH_DMA_COPY_TYPE_RESERVED:
            fprintf(fp, "RESERVED\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 22) & ((1u << 1) - 1);
        fprintf(fp, "%s.VPRMODE = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_VPRMODE_VPR_NONE:
            fprintf(fp, "VPR_NONE\n");
            break;
        case NVCAB5_LAUNCH_DMA_VPRMODE_VPR_VID2VID:
            fprintf(fp, "VPR_VID2VID\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 23) & ((1u << 1) - 1);
        fprintf(fp, "%s.MEMORY_SCRUB_ENABLE = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_MEMORY_SCRUB_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCAB5_LAUNCH_DMA_MEMORY_SCRUB_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 24) & ((1u << 1) - 1);
        fprintf(fp, "%s.RESERVED_START_OF_COPY = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 26) & ((1u << 1) - 1);
        fprintf(fp, "%s.DISABLE_PLC = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_DISABLE_PLC_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NVCAB5_LAUNCH_DMA_DISABLE_PLC_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 27) & ((1u << 1) - 1);
        fprintf(fp, "%s.SEMAPHORE_PAYLOAD_SIZE = ", prefix);
        switch (parsed) {
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_PAYLOAD_SIZE_ONE_WORD:
            fprintf(fp, "ONE_WORD\n");
            break;
        case NVCAB5_LAUNCH_DMA_SEMAPHORE_PAYLOAD_SIZE_TWO_WORD:
            fprintf(fp, "TWO_WORD\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.RESERVED_ERR_CODE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                              
    case NVCAB5_SET_DST_BLOCK_SIZE:

    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NVCAB5_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NVCAB5_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVCAB5_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVCAB5_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVCAB5_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVCAB5_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVCAB5_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NVCAB5_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVCAB5_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVCAB5_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVCAB5_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVCAB5_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVCAB5_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.GOB_HEIGHT = ", prefix);
        switch (parsed) {
        case NVCAB5_SET_DST_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_FERMI_8:
            fprintf(fp, "GOB_HEIGHT_FERMI_8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 2) - 1);
        fprintf(fp, "%s.KIND_BPP = ", prefix);
        switch (parsed) {
        case NVCAB5_SET_DST_BLOCK_SIZE_KIND_BPP_BL_32:
            fprintf(fp, "BL_32\n");
            break;
        case NVCAB5_SET_DST_BLOCK_SIZE_KIND_BPP_BL_8:
            fprintf(fp, "BL_8\n");
            break;
        case NVCAB5_SET_DST_BLOCK_SIZE_KIND_BPP_BL_16:
            fprintf(fp, "BL_16\n");
            break;
        case NVCAB5_SET_DST_BLOCK_SIZE_KIND_BPP_BL_24:
            fprintf(fp, "BL_24\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                      
    case NVCAB5_SET_SRC_BLOCK_SIZE:

    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.WIDTH = ", prefix);
        switch (parsed) {
        case NVCAB5_SET_SRC_BLOCK_SIZE_WIDTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.HEIGHT = ", prefix);
        switch (parsed) {
        case NVCAB5_SET_SRC_BLOCK_SIZE_HEIGHT_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVCAB5_SET_SRC_BLOCK_SIZE_HEIGHT_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVCAB5_SET_SRC_BLOCK_SIZE_HEIGHT_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVCAB5_SET_SRC_BLOCK_SIZE_HEIGHT_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVCAB5_SET_SRC_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVCAB5_SET_SRC_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        switch (parsed) {
        case NVCAB5_SET_SRC_BLOCK_SIZE_DEPTH_ONE_GOB:
            fprintf(fp, "ONE_GOB\n");
            break;
        case NVCAB5_SET_SRC_BLOCK_SIZE_DEPTH_TWO_GOBS:
            fprintf(fp, "TWO_GOBS\n");
            break;
        case NVCAB5_SET_SRC_BLOCK_SIZE_DEPTH_FOUR_GOBS:
            fprintf(fp, "FOUR_GOBS\n");
            break;
        case NVCAB5_SET_SRC_BLOCK_SIZE_DEPTH_EIGHT_GOBS:
            fprintf(fp, "EIGHT_GOBS\n");
            break;
        case NVCAB5_SET_SRC_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS:
            fprintf(fp, "SIXTEEN_GOBS\n");
            break;
        case NVCAB5_SET_SRC_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS:
            fprintf(fp, "THIRTYTWO_GOBS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 4) - 1);
        fprintf(fp, "%s.GOB_HEIGHT = ", prefix);
        switch (parsed) {
        case NVCAB5_SET_SRC_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_FERMI_8:
            fprintf(fp, "GOB_HEIGHT_FERMI_8\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 2) - 1);
        fprintf(fp, "%s.KIND_BPP = ", prefix);
        switch (parsed) {
        case NVCAB5_SET_SRC_BLOCK_SIZE_KIND_BPP_BL_32:
            fprintf(fp, "BL_32\n");
            break;
        case NVCAB5_SET_SRC_BLOCK_SIZE_KIND_BPP_BL_8:
            fprintf(fp, "BL_8\n");
            break;
        case NVCAB5_SET_SRC_BLOCK_SIZE_KIND_BPP_BL_16:
            fprintf(fp, "BL_16\n");
            break;
        case NVCAB5_SET_SRC_BLOCK_SIZE_KIND_BPP_BL_24:
            fprintf(fp, "BL_24\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                            }
}
