/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Subtarget Enumeration Source Fragment                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_SUBTARGETINFO_ENUM
#undef GET_SUBTARGETINFO_ENUM

namespace llvm {
namespace X86 {
enum {
  Feature3DNow = 0,
  Feature3DNowA = 1,
  FeatureADX = 2,
  FeatureAES = 3,
  FeatureAMXBF16 = 4,
  FeatureAMXCOMPLEX = 5,
  FeatureAMXFP16 = 6,
  FeatureAMXINT8 = 7,
  FeatureAMXTILE = 8,
  FeatureAVX = 9,
  FeatureAVX2 = 10,
  FeatureAVX10_1 = 11,
  FeatureAVX10_1_512 = 12,
  FeatureAVX512 = 13,
  FeatureAVXIFMA = 14,
  FeatureAVXNECONVERT = 15,
  FeatureAVXVNNI = 16,
  FeatureAVXVNNIINT8 = 17,
  FeatureAVXVNNIINT16 = 18,
  FeatureBF16 = 19,
  FeatureBITALG = 20,
  FeatureBMI = 21,
  FeatureBMI2 = 22,
  FeatureBWI = 23,
  FeatureCCMP = 24,
  FeatureCDI = 25,
  FeatureCF = 26,
  FeatureCLDEMOTE = 27,
  FeatureCLFLUSHOPT = 28,
  FeatureCLWB = 29,
  FeatureCLZERO = 30,
  FeatureCMOV = 31,
  FeatureCMPCCXADD = 32,
  FeatureCRC32 = 33,
  FeatureCX8 = 34,
  FeatureCX16 = 35,
  FeatureDQI = 36,
  FeatureEGPR = 37,
  FeatureENQCMD = 38,
  FeatureERI = 39,
  FeatureERMSB = 40,
  FeatureEVEX512 = 41,
  FeatureF16C = 42,
  FeatureFMA = 43,
  FeatureFMA4 = 44,
  FeatureFP16 = 45,
  FeatureFSGSBase = 46,
  FeatureFSRM = 47,
  FeatureFXSR = 48,
  FeatureGFNI = 49,
  FeatureHRESET = 50,
  FeatureHardenSlsIJmp = 51,
  FeatureHardenSlsRet = 52,
  FeatureIFMA = 53,
  FeatureINVPCID = 54,
  FeatureKL = 55,
  FeatureLAHFSAHF64 = 56,
  FeatureLVIControlFlowIntegrity = 57,
  FeatureLVILoadHardening = 58,
  FeatureLWP = 59,
  FeatureLZCNT = 60,
  FeatureMMX = 61,
  FeatureMOVBE = 62,
  FeatureMOVDIR64B = 63,
  FeatureMOVDIRI = 64,
  FeatureMWAITX = 65,
  FeatureNDD = 66,
  FeatureNOPL = 67,
  FeaturePCLMUL = 68,
  FeaturePCONFIG = 69,
  FeaturePFI = 70,
  FeaturePKU = 71,
  FeaturePOPCNT = 72,
  FeaturePPX = 73,
  FeaturePREFETCHI = 74,
  FeaturePREFETCHWT1 = 75,
  FeaturePRFCHW = 76,
  FeaturePTWRITE = 77,
  FeaturePush2Pop2 = 78,
  FeatureRAOINT = 79,
  FeatureRDPID = 80,
  FeatureRDPRU = 81,
  FeatureRDRAND = 82,
  FeatureRDSEED = 83,
  FeatureRTM = 84,
  FeatureRetpoline = 85,
  FeatureRetpolineExternalThunk = 86,
  FeatureRetpolineIndirectBranches = 87,
  FeatureRetpolineIndirectCalls = 88,
  FeatureSERIALIZE = 89,
  FeatureSGX = 90,
  FeatureSHA = 91,
  FeatureSHA512 = 92,
  FeatureSHSTK = 93,
  FeatureSM3 = 94,
  FeatureSM4 = 95,
  FeatureSSE1 = 96,
  FeatureSSE2 = 97,
  FeatureSSE3 = 98,
  FeatureSSE4A = 99,
  FeatureSSE41 = 100,
  FeatureSSE42 = 101,
  FeatureSSEUnalignedMem = 102,
  FeatureSSSE3 = 103,
  FeatureSoftFloat = 104,
  FeatureSpeculativeExecutionSideEffectSuppression = 105,
  FeatureTBM = 106,
  FeatureTSXLDTRK = 107,
  FeatureTaggedGlobals = 108,
  FeatureUINTR = 109,
  FeatureUSERMSR = 110,
  FeatureVAES = 111,
  FeatureVBMI = 112,
  FeatureVBMI2 = 113,
  FeatureVLX = 114,
  FeatureVNNI = 115,
  FeatureVP2INTERSECT = 116,
  FeatureVPCLMULQDQ = 117,
  FeatureVPOPCNTDQ = 118,
  FeatureWAITPKG = 119,
  FeatureWBNOINVD = 120,
  FeatureWIDEKL = 121,
  FeatureX86_64 = 122,
  FeatureX87 = 123,
  FeatureXOP = 124,
  FeatureXSAVE = 125,
  FeatureXSAVEC = 126,
  FeatureXSAVEOPT = 127,
  FeatureXSAVES = 128,
  Is16Bit = 129,
  Is32Bit = 130,
  Is64Bit = 131,
  ProcIntelAtom = 132,
  TuningAllowLight256Bit = 133,
  TuningBranchFusion = 134,
  TuningFast7ByteNOP = 135,
  TuningFast11ByteNOP = 136,
  TuningFast15ByteNOP = 137,
  TuningFastBEXTR = 138,
  TuningFastGather = 139,
  TuningFastHorizontalOps = 140,
  TuningFastImmVectorShift = 141,
  TuningFastLZCNT = 142,
  TuningFastMOVBE = 143,
  TuningFastSHLDRotate = 144,
  TuningFastScalarFSQRT = 145,
  TuningFastScalarShiftMasks = 146,
  TuningFastVariableCrossLaneShuffle = 147,
  TuningFastVariablePerLaneShuffle = 148,
  TuningFastVectorFSQRT = 149,
  TuningFastVectorShiftMasks = 150,
  TuningGETMANTFalseDeps = 151,
  TuningInsertVZEROUPPER = 152,
  TuningLEAForSP = 153,
  TuningLEAUsesAG = 154,
  TuningLZCNTFalseDeps = 155,
  TuningMULCFalseDeps = 156,
  TuningMULLQFalseDeps = 157,
  TuningMacroFusion = 158,
  TuningNoDomainDelay = 159,
  TuningNoDomainDelayBlend = 160,
  TuningNoDomainDelayMov = 161,
  TuningNoDomainDelayShuffle = 162,
  TuningPERMFalseDeps = 163,
  TuningPOPCNTFalseDeps = 164,
  TuningPadShortFunctions = 165,
  TuningPrefer128Bit = 166,
  TuningPrefer256Bit = 167,
  TuningPreferMaskRegisters = 168,
  TuningPreferMovmskOverVTest = 169,
  TuningPreferNoGather = 170,
  TuningPreferNoScatter = 171,
  TuningPreferShiftShuffle = 172,
  TuningRANGEFalseDeps = 173,
  TuningSBBDepBreaking = 174,
  TuningSlow3OpsLEA = 175,
  TuningSlowDivide32 = 176,
  TuningSlowDivide64 = 177,
  TuningSlowIncDec = 178,
  TuningSlowLEA = 179,
  TuningSlowPMADDWD = 180,
  TuningSlowPMULLD = 181,
  TuningSlowSHLD = 182,
  TuningSlowTwoMemOps = 183,
  TuningSlowUAMem16 = 184,
  TuningSlowUAMem32 = 185,
  TuningUseGLMDivSqrtCosts = 186,
  TuningUseSLMArithCosts = 187,
  NumSubtargetFeatures = 188
};
} // end namespace X86
} // end namespace llvm

#endif // GET_SUBTARGETINFO_ENUM


#ifdef GET_SUBTARGETINFO_MACRO
GET_SUBTARGETINFO_MACRO(AllowLight256Bit, false, allowLight256Bit)
GET_SUBTARGETINFO_MACRO(AllowTaggedGlobals, false, allowTaggedGlobals)
GET_SUBTARGETINFO_MACRO(DeprecatedUseRetpoline, false, deprecatedUseRetpoline)
GET_SUBTARGETINFO_MACRO(FastImmVectorShift, false, fastImmVectorShift)
GET_SUBTARGETINFO_MACRO(HardenSlsIJmp, false, hardenSlsIJmp)
GET_SUBTARGETINFO_MACRO(HardenSlsRet, false, hardenSlsRet)
GET_SUBTARGETINFO_MACRO(HasADX, false, hasADX)
GET_SUBTARGETINFO_MACRO(HasAES, false, hasAES)
GET_SUBTARGETINFO_MACRO(HasAMXBF16, false, hasAMXBF16)
GET_SUBTARGETINFO_MACRO(HasAMXCOMPLEX, false, hasAMXCOMPLEX)
GET_SUBTARGETINFO_MACRO(HasAMXFP16, false, hasAMXFP16)
GET_SUBTARGETINFO_MACRO(HasAMXINT8, false, hasAMXINT8)
GET_SUBTARGETINFO_MACRO(HasAMXTILE, false, hasAMXTILE)
GET_SUBTARGETINFO_MACRO(HasAVX10_1, false, hasAVX10_1)
GET_SUBTARGETINFO_MACRO(HasAVX10_1_512, false, hasAVX10_1_512)
GET_SUBTARGETINFO_MACRO(HasAVXIFMA, false, hasAVXIFMA)
GET_SUBTARGETINFO_MACRO(HasAVXNECONVERT, false, hasAVXNECONVERT)
GET_SUBTARGETINFO_MACRO(HasAVXVNNI, false, hasAVXVNNI)
GET_SUBTARGETINFO_MACRO(HasAVXVNNIINT16, false, hasAVXVNNIINT16)
GET_SUBTARGETINFO_MACRO(HasAVXVNNIINT8, false, hasAVXVNNIINT8)
GET_SUBTARGETINFO_MACRO(HasBF16, false, hasBF16)
GET_SUBTARGETINFO_MACRO(HasBITALG, false, hasBITALG)
GET_SUBTARGETINFO_MACRO(HasBMI, false, hasBMI)
GET_SUBTARGETINFO_MACRO(HasBMI2, false, hasBMI2)
GET_SUBTARGETINFO_MACRO(HasBWI, false, hasBWI)
GET_SUBTARGETINFO_MACRO(HasBranchFusion, false, hasBranchFusion)
GET_SUBTARGETINFO_MACRO(HasCCMP, false, hasCCMP)
GET_SUBTARGETINFO_MACRO(HasCDI, false, hasCDI)
GET_SUBTARGETINFO_MACRO(HasCF, false, hasCF)
GET_SUBTARGETINFO_MACRO(HasCLDEMOTE, false, hasCLDEMOTE)
GET_SUBTARGETINFO_MACRO(HasCLFLUSHOPT, false, hasCLFLUSHOPT)
GET_SUBTARGETINFO_MACRO(HasCLWB, false, hasCLWB)
GET_SUBTARGETINFO_MACRO(HasCLZERO, false, hasCLZERO)
GET_SUBTARGETINFO_MACRO(HasCMOV, false, hasCMOV)
GET_SUBTARGETINFO_MACRO(HasCMPCCXADD, false, hasCMPCCXADD)
GET_SUBTARGETINFO_MACRO(HasCRC32, false, hasCRC32)
GET_SUBTARGETINFO_MACRO(HasCX16, false, hasCX16)
GET_SUBTARGETINFO_MACRO(HasCX8, false, hasCX8)
GET_SUBTARGETINFO_MACRO(HasDQI, false, hasDQI)
GET_SUBTARGETINFO_MACRO(HasEGPR, false, hasEGPR)
GET_SUBTARGETINFO_MACRO(HasENQCMD, false, hasENQCMD)
GET_SUBTARGETINFO_MACRO(HasERI, false, hasERI)
GET_SUBTARGETINFO_MACRO(HasERMSB, false, hasERMSB)
GET_SUBTARGETINFO_MACRO(HasEVEX512, false, hasEVEX512)
GET_SUBTARGETINFO_MACRO(HasF16C, false, hasF16C)
GET_SUBTARGETINFO_MACRO(HasFMA, false, hasFMA)
GET_SUBTARGETINFO_MACRO(HasFMA4, false, hasFMA4)
GET_SUBTARGETINFO_MACRO(HasFP16, false, hasFP16)
GET_SUBTARGETINFO_MACRO(HasFSGSBase, false, hasFSGSBase)
GET_SUBTARGETINFO_MACRO(HasFSRM, false, hasFSRM)
GET_SUBTARGETINFO_MACRO(HasFXSR, false, hasFXSR)
GET_SUBTARGETINFO_MACRO(HasFast11ByteNOP, false, hasFast11ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFast15ByteNOP, false, hasFast15ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFast7ByteNOP, false, hasFast7ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFastBEXTR, false, hasFastBEXTR)
GET_SUBTARGETINFO_MACRO(HasFastGather, false, hasFastGather)
GET_SUBTARGETINFO_MACRO(HasFastHorizontalOps, false, hasFastHorizontalOps)
GET_SUBTARGETINFO_MACRO(HasFastLZCNT, false, hasFastLZCNT)
GET_SUBTARGETINFO_MACRO(HasFastMOVBE, false, hasFastMOVBE)
GET_SUBTARGETINFO_MACRO(HasFastSHLDRotate, false, hasFastSHLDRotate)
GET_SUBTARGETINFO_MACRO(HasFastScalarFSQRT, false, hasFastScalarFSQRT)
GET_SUBTARGETINFO_MACRO(HasFastScalarShiftMasks, false, hasFastScalarShiftMasks)
GET_SUBTARGETINFO_MACRO(HasFastVariableCrossLaneShuffle, false, hasFastVariableCrossLaneShuffle)
GET_SUBTARGETINFO_MACRO(HasFastVariablePerLaneShuffle, false, hasFastVariablePerLaneShuffle)
GET_SUBTARGETINFO_MACRO(HasFastVectorFSQRT, false, hasFastVectorFSQRT)
GET_SUBTARGETINFO_MACRO(HasFastVectorShiftMasks, false, hasFastVectorShiftMasks)
GET_SUBTARGETINFO_MACRO(HasGETMANTFalseDeps, false, hasGETMANTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasGFNI, false, hasGFNI)
GET_SUBTARGETINFO_MACRO(HasHRESET, false, hasHRESET)
GET_SUBTARGETINFO_MACRO(HasIFMA, false, hasIFMA)
GET_SUBTARGETINFO_MACRO(HasINVPCID, false, hasINVPCID)
GET_SUBTARGETINFO_MACRO(HasKL, false, hasKL)
GET_SUBTARGETINFO_MACRO(HasLAHFSAHF64, false, hasLAHFSAHF64)
GET_SUBTARGETINFO_MACRO(HasLWP, false, hasLWP)
GET_SUBTARGETINFO_MACRO(HasLZCNT, false, hasLZCNT)
GET_SUBTARGETINFO_MACRO(HasLZCNTFalseDeps, false, hasLZCNTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMOVBE, false, hasMOVBE)
GET_SUBTARGETINFO_MACRO(HasMOVDIR64B, false, hasMOVDIR64B)
GET_SUBTARGETINFO_MACRO(HasMOVDIRI, false, hasMOVDIRI)
GET_SUBTARGETINFO_MACRO(HasMULCFalseDeps, false, hasMULCFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMULLQFalseDeps, false, hasMULLQFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMWAITX, false, hasMWAITX)
GET_SUBTARGETINFO_MACRO(HasMacroFusion, false, hasMacroFusion)
GET_SUBTARGETINFO_MACRO(HasNDD, false, hasNDD)
GET_SUBTARGETINFO_MACRO(HasNOPL, false, hasNOPL)
GET_SUBTARGETINFO_MACRO(HasPCLMUL, false, hasPCLMUL)
GET_SUBTARGETINFO_MACRO(HasPCONFIG, false, hasPCONFIG)
GET_SUBTARGETINFO_MACRO(HasPERMFalseDeps, false, hasPERMFalseDeps)
GET_SUBTARGETINFO_MACRO(HasPFI, false, hasPFI)
GET_SUBTARGETINFO_MACRO(HasPKU, false, hasPKU)
GET_SUBTARGETINFO_MACRO(HasPOPCNT, false, hasPOPCNT)
GET_SUBTARGETINFO_MACRO(HasPOPCNTFalseDeps, false, hasPOPCNTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasPPX, false, hasPPX)
GET_SUBTARGETINFO_MACRO(HasPREFETCHI, false, hasPREFETCHI)
GET_SUBTARGETINFO_MACRO(HasPREFETCHWT1, false, hasPREFETCHWT1)
GET_SUBTARGETINFO_MACRO(HasPRFCHW, false, hasPRFCHW)
GET_SUBTARGETINFO_MACRO(HasPTWRITE, false, hasPTWRITE)
GET_SUBTARGETINFO_MACRO(HasPush2Pop2, false, hasPush2Pop2)
GET_SUBTARGETINFO_MACRO(HasRANGEFalseDeps, false, hasRANGEFalseDeps)
GET_SUBTARGETINFO_MACRO(HasRAOINT, false, hasRAOINT)
GET_SUBTARGETINFO_MACRO(HasRDPID, false, hasRDPID)
GET_SUBTARGETINFO_MACRO(HasRDPRU, false, hasRDPRU)
GET_SUBTARGETINFO_MACRO(HasRDRAND, false, hasRDRAND)
GET_SUBTARGETINFO_MACRO(HasRDSEED, false, hasRDSEED)
GET_SUBTARGETINFO_MACRO(HasRTM, false, hasRTM)
GET_SUBTARGETINFO_MACRO(HasSBBDepBreaking, false, hasSBBDepBreaking)
GET_SUBTARGETINFO_MACRO(HasSERIALIZE, false, hasSERIALIZE)
GET_SUBTARGETINFO_MACRO(HasSGX, false, hasSGX)
GET_SUBTARGETINFO_MACRO(HasSHA, false, hasSHA)
GET_SUBTARGETINFO_MACRO(HasSHA512, false, hasSHA512)
GET_SUBTARGETINFO_MACRO(HasSHSTK, false, hasSHSTK)
GET_SUBTARGETINFO_MACRO(HasSM3, false, hasSM3)
GET_SUBTARGETINFO_MACRO(HasSM4, false, hasSM4)
GET_SUBTARGETINFO_MACRO(HasSSE4A, false, hasSSE4A)
GET_SUBTARGETINFO_MACRO(HasSSEUnalignedMem, false, hasSSEUnalignedMem)
GET_SUBTARGETINFO_MACRO(HasSlowDivide32, false, hasSlowDivide32)
GET_SUBTARGETINFO_MACRO(HasSlowDivide64, false, hasSlowDivide64)
GET_SUBTARGETINFO_MACRO(HasTBM, false, hasTBM)
GET_SUBTARGETINFO_MACRO(HasTSXLDTRK, false, hasTSXLDTRK)
GET_SUBTARGETINFO_MACRO(HasUINTR, false, hasUINTR)
GET_SUBTARGETINFO_MACRO(HasUSERMSR, false, hasUSERMSR)
GET_SUBTARGETINFO_MACRO(HasVAES, false, hasVAES)
GET_SUBTARGETINFO_MACRO(HasVBMI, false, hasVBMI)
GET_SUBTARGETINFO_MACRO(HasVBMI2, false, hasVBMI2)
GET_SUBTARGETINFO_MACRO(HasVLX, false, hasVLX)
GET_SUBTARGETINFO_MACRO(HasVNNI, false, hasVNNI)
GET_SUBTARGETINFO_MACRO(HasVP2INTERSECT, false, hasVP2INTERSECT)
GET_SUBTARGETINFO_MACRO(HasVPCLMULQDQ, false, hasVPCLMULQDQ)
GET_SUBTARGETINFO_MACRO(HasVPOPCNTDQ, false, hasVPOPCNTDQ)
GET_SUBTARGETINFO_MACRO(HasWAITPKG, false, hasWAITPKG)
GET_SUBTARGETINFO_MACRO(HasWBNOINVD, false, hasWBNOINVD)
GET_SUBTARGETINFO_MACRO(HasWIDEKL, false, hasWIDEKL)
GET_SUBTARGETINFO_MACRO(HasX86_64, false, hasX86_64)
GET_SUBTARGETINFO_MACRO(HasX87, false, hasX87)
GET_SUBTARGETINFO_MACRO(HasXOP, false, hasXOP)
GET_SUBTARGETINFO_MACRO(HasXSAVE, false, hasXSAVE)
GET_SUBTARGETINFO_MACRO(HasXSAVEC, false, hasXSAVEC)
GET_SUBTARGETINFO_MACRO(HasXSAVEOPT, false, hasXSAVEOPT)
GET_SUBTARGETINFO_MACRO(HasXSAVES, false, hasXSAVES)
GET_SUBTARGETINFO_MACRO(InsertVZEROUPPER, false, insertVZEROUPPER)
GET_SUBTARGETINFO_MACRO(Is16Bit, false, is16Bit)
GET_SUBTARGETINFO_MACRO(Is32Bit, false, is32Bit)
GET_SUBTARGETINFO_MACRO(Is64Bit, false, is64Bit)
GET_SUBTARGETINFO_MACRO(IsAtom, false, isAtom)
GET_SUBTARGETINFO_MACRO(IsPMADDWDSlow, false, isPMADDWDSlow)
GET_SUBTARGETINFO_MACRO(IsPMULLDSlow, false, isPMULLDSlow)
GET_SUBTARGETINFO_MACRO(IsSHLDSlow, false, isSHLDSlow)
GET_SUBTARGETINFO_MACRO(IsUnalignedMem16Slow, false, isUnalignedMem16Slow)
GET_SUBTARGETINFO_MACRO(IsUnalignedMem32Slow, false, isUnalignedMem32Slow)
GET_SUBTARGETINFO_MACRO(LeaUsesAG, false, leaUsesAG)
GET_SUBTARGETINFO_MACRO(NoDomainDelay, false, noDomainDelay)
GET_SUBTARGETINFO_MACRO(NoDomainDelayBlend, false, noDomainDelayBlend)
GET_SUBTARGETINFO_MACRO(NoDomainDelayMov, false, noDomainDelayMov)
GET_SUBTARGETINFO_MACRO(NoDomainDelayShuffle, false, noDomainDelayShuffle)
GET_SUBTARGETINFO_MACRO(PadShortFunctions, false, padShortFunctions)
GET_SUBTARGETINFO_MACRO(Prefer128Bit, false, prefer128Bit)
GET_SUBTARGETINFO_MACRO(Prefer256Bit, false, prefer256Bit)
GET_SUBTARGETINFO_MACRO(PreferGather, true, preferGather)
GET_SUBTARGETINFO_MACRO(PreferLowerShuffleAsShift, false, preferLowerShuffleAsShift)
GET_SUBTARGETINFO_MACRO(PreferMaskRegisters, false, preferMaskRegisters)
GET_SUBTARGETINFO_MACRO(PreferMovmskOverVTest, false, preferMovmskOverVTest)
GET_SUBTARGETINFO_MACRO(PreferScatter, true, preferScatter)
GET_SUBTARGETINFO_MACRO(Slow3OpsLEA, false, slow3OpsLEA)
GET_SUBTARGETINFO_MACRO(SlowIncDec, false, slowIncDec)
GET_SUBTARGETINFO_MACRO(SlowLEA, false, slowLEA)
GET_SUBTARGETINFO_MACRO(SlowTwoMemOps, false, slowTwoMemOps)
GET_SUBTARGETINFO_MACRO(UseGLMDivSqrtCosts, false, useGLMDivSqrtCosts)
GET_SUBTARGETINFO_MACRO(UseLVIControlFlowIntegrity, false, useLVIControlFlowIntegrity)
GET_SUBTARGETINFO_MACRO(UseLVILoadHardening, false, useLVILoadHardening)
GET_SUBTARGETINFO_MACRO(UseLeaForSP, false, useLeaForSP)
GET_SUBTARGETINFO_MACRO(UseRetpolineExternalThunk, false, useRetpolineExternalThunk)
GET_SUBTARGETINFO_MACRO(UseRetpolineIndirectBranches, false, useRetpolineIndirectBranches)
GET_SUBTARGETINFO_MACRO(UseRetpolineIndirectCalls, false, useRetpolineIndirectCalls)
GET_SUBTARGETINFO_MACRO(UseSLMArithCosts, false, useSLMArithCosts)
GET_SUBTARGETINFO_MACRO(UseSoftFloat, false, useSoftFloat)
GET_SUBTARGETINFO_MACRO(UseSpeculativeExecutionSideEffectSuppression, false, useSpeculativeExecutionSideEffectSuppression)
#undef GET_SUBTARGETINFO_MACRO
#endif // GET_SUBTARGETINFO_MACRO


#ifdef GET_SUBTARGETINFO_MC_DESC
#undef GET_SUBTARGETINFO_MC_DESC

namespace llvm {
// Sorted (by key) array of values for CPU features.
extern const llvm::SubtargetFeatureKV X86FeatureKV[] = {
  { "16bit-mode", "16-bit mode (i8086)", X86::Is16Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "32bit-mode", "32-bit mode (80386)", X86::Is32Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "3dnow", "Enable 3DNow! instructions", X86::Feature3DNow, { { { 0x2000000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "3dnowa", "Enable 3DNow! Athlon instructions", X86::Feature3DNowA, { { { 0x1ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit", "Support 64-bit instructions", X86::FeatureX86_64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit-mode", "64-bit mode (x86_64)", X86::Is64Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "adx", "Support ADX instructions", X86::FeatureADX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "aes", "Enable AES instructions", X86::FeatureAES, { { { 0x0ULL, 0x200000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "allow-light-256-bit", "Enable generation of 256-bit load/stores even if we prefer 128-bit", X86::TuningAllowLight256Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-bf16", "Support AMX-BF16 instructions", X86::FeatureAMXBF16, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-complex", "Support AMX-COMPLEX instructions", X86::FeatureAMXCOMPLEX, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-fp16", "Support AMX amx-fp16 instructions", X86::FeatureAMXFP16, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-int8", "Support AMX-INT8 instructions", X86::FeatureAMXINT8, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-tile", "Support AMX-TILE instructions", X86::FeatureAMXTILE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx", "Enable AVX instructions", X86::FeatureAVX, { { { 0x0ULL, 0x2000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx10.1-256", "Support AVX10.1 up to 256-bit instruction", X86::FeatureAVX10_1, { { { 0x20200002180000ULL, 0x6b800000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx10.1-512", "Support AVX10.1 up to 512-bit instruction", X86::FeatureAVX10_1_512, { { { 0x20000000800ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx2", "Enable AVX2 instructions", X86::FeatureAVX2, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bf16", "Support bfloat16 floating point", X86::FeatureBF16, { { { 0x800000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bitalg", "Enable AVX-512 Bit Algorithms", X86::FeatureBITALG, { { { 0x800000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bw", "Enable AVX-512 Byte and Word Instructions", X86::FeatureBWI, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512cd", "Enable AVX-512 Conflict Detection Instructions", X86::FeatureCDI, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512dq", "Enable AVX-512 Doubleword and Quadword Instructions", X86::FeatureDQI, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512er", "Enable AVX-512 Exponential and Reciprocal Instructions", X86::FeatureERI, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512f", "Enable AVX-512 instructions", X86::FeatureAVX512, { { { 0xc0000000400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512fp16", "Support 16-bit floating point", X86::FeatureFP16, { { { 0x1000800000ULL, 0x4000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512ifma", "Enable AVX-512 Integer Fused Multiple-Add", X86::FeatureIFMA, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512pf", "Enable AVX-512 PreFetch Instructions", X86::FeaturePFI, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi", "Enable AVX-512 Vector Byte Manipulation Instructions", X86::FeatureVBMI, { { { 0x800000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi2", "Enable AVX-512 further Vector Byte Manipulation Instructions", X86::FeatureVBMI2, { { { 0x800000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vl", "Enable AVX-512 Vector Length eXtensions", X86::FeatureVLX, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vnni", "Enable AVX-512 Vector Neural Network Instructions", X86::FeatureVNNI, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vp2intersect", "Enable AVX-512 vp2intersect", X86::FeatureVP2INTERSECT, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vpopcntdq", "Enable AVX-512 Population Count Instructions", X86::FeatureVPOPCNTDQ, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxifma", "Enable AVX-IFMA", X86::FeatureAVXIFMA, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxneconvert", "Support AVX-NE-CONVERT instructions", X86::FeatureAVXNECONVERT, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnni", "Support AVX_VNNI encoding", X86::FeatureAVXVNNI, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnniint16", "Enable AVX-VNNI-INT16", X86::FeatureAVXVNNIINT16, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnniint8", "Enable AVX-VNNI-INT8", X86::FeatureAVXVNNIINT8, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi", "Support BMI instructions", X86::FeatureBMI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi2", "Support BMI2 instructions", X86::FeatureBMI2, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "branchfusion", "CMP/TEST can be fused with conditional branches", X86::TuningBranchFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ccmp", "Support conditional cmp & test instructions", X86::FeatureCCMP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cf", "Support conditional faulting", X86::FeatureCF, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cldemote", "Enable Cache Line Demote", X86::FeatureCLDEMOTE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clflushopt", "Flush A Cache Line Optimized", X86::FeatureCLFLUSHOPT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clwb", "Cache Line Write Back", X86::FeatureCLWB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clzero", "Enable Cache Line Zero", X86::FeatureCLZERO, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cmov", "Enable conditional move instructions", X86::FeatureCMOV, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cmpccxadd", "Support CMPCCXADD instructions", X86::FeatureCMPCCXADD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "crc32", "Enable SSE 4.2 CRC32 instruction (used when SSE4.2 is supported but function is GPR only)", X86::FeatureCRC32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx16", "64-bit with cmpxchg16b (this is true for most x86-64 chips, but not the first AMD chips)", X86::FeatureCX16, { { { 0x400000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx8", "Support CMPXCHG8B instructions", X86::FeatureCX8, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "egpr", "Support extended general purpose register", X86::FeatureEGPR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "enqcmd", "Has ENQCMD instructions", X86::FeatureENQCMD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ermsb", "REP MOVS/STOS are fast", X86::FeatureERMSB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "evex512", "Support ZMM and 64-bit mask instructions", X86::FeatureEVEX512, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "f16c", "Support 16-bit floating point conversion instructions", X86::FeatureF16C, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-getmant", "VGETMANTSS/SD/SH and VGETMANDPS/PD(memory version) has a false dependency on dest register", X86::TuningGETMANTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-lzcnt-tzcnt", "LZCNT/TZCNT have a false dependency on dest register", X86::TuningLZCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-mulc", "VF[C]MULCPH/SH has a false dependency on dest register", X86::TuningMULCFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-mullq", "VPMULLQ has a false dependency on dest register", X86::TuningMULLQFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-perm", "VPERMD/Q/PS/PD has a false dependency on dest register", X86::TuningPERMFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-popcnt", "POPCNT has a false dependency on dest register", X86::TuningPOPCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-range", "VRANGEPD/PS/SD/SS has a false dependency on dest register", X86::TuningRANGEFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-11bytenop", "Target can quickly decode up to 11 byte NOPs", X86::TuningFast11ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-15bytenop", "Target can quickly decode up to 15 byte NOPs", X86::TuningFast15ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-7bytenop", "Target can quickly decode up to 7 byte NOPs", X86::TuningFast7ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-bextr", "Indicates that the BEXTR instruction is implemented as a single uop with good throughput", X86::TuningFastBEXTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-gather", "Indicates if gather is reasonably fast (this is true for Skylake client and all AVX-512 CPUs)", X86::TuningFastGather, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-hops", "Prefer horizontal vector math instructions (haddp, phsub, etc.) over normal vector instructions with shuffles", X86::TuningFastHorizontalOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-lzcnt", "LZCNT instructions are as fast as most simple integer ops", X86::TuningFastLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-movbe", "Prefer a movbe over a single-use load + bswap / single-use bswap + store", X86::TuningFastMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-fsqrt", "Scalar SQRT is fast (disable Newton-Raphson)", X86::TuningFastScalarFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-shift-masks", "Prefer a left/right scalar logical shift pair over a shift+and pair", X86::TuningFastScalarShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-shld-rotate", "SHLD can be used as a faster rotate", X86::TuningFastSHLDRotate, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-crosslane-shuffle", "Cross-lane shuffles with variable masks are fast", X86::TuningFastVariableCrossLaneShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-perlane-shuffle", "Per-lane shuffles with variable masks are fast", X86::TuningFastVariablePerLaneShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-fsqrt", "Vector SQRT is fast (disable Newton-Raphson)", X86::TuningFastVectorFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-shift-masks", "Prefer a left/right vector logical shift pair over a shift+and pair", X86::TuningFastVectorShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "faster-shift-than-shuffle", "Shifts are faster (or as fast) as shuffle", X86::TuningPreferShiftShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma", "Enable three-operand fused multiple-add", X86::FeatureFMA, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma4", "Enable four-operand fused multiple-add", X86::FeatureFMA4, { { { 0x200ULL, 0x800000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsgsbase", "Support FS/GS Base instructions", X86::FeatureFSGSBase, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsrm", "REP MOVSB of short lengths is faster", X86::FeatureFSRM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fxsr", "Support fxsave/fxrestore instructions", X86::FeatureFXSR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "gfni", "Enable Galois Field Arithmetic Instructions", X86::FeatureGFNI, { { { 0x0ULL, 0x200000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "harden-sls-ijmp", "Harden against straight line speculation across indirect JMP instructions.", X86::FeatureHardenSlsIJmp, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "harden-sls-ret", "Harden against straight line speculation across RET instructions.", X86::FeatureHardenSlsRet, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "hreset", "Has hreset instruction", X86::FeatureHRESET, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivl-to-divb", "Use 8-bit divide for positive values less than 256", X86::TuningSlowDivide32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivq-to-divl", "Use 32-bit divide for positive values less than 2^32", X86::TuningSlowDivide64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "invpcid", "Invalidate Process-Context Identifier", X86::FeatureINVPCID, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "kl", "Support Key Locker kl Instructions", X86::FeatureKL, { { { 0x0ULL, 0x200000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-sp", "Use LEA for adjusting the stack pointer (this is an optimization for Intel Atom processors)", X86::TuningLEAForSP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-uses-ag", "LEA instruction needs inputs at AG stage", X86::TuningLEAUsesAG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lvi-cfi", "Prevent indirect calls/branches from using a memory operand, and precede all indirect calls/branches from a register with an LFENCE instruction to serialize control flow. Also decompose RET instructions into a POP+LFENCE+JMP sequence.", X86::FeatureLVIControlFlowIntegrity, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lvi-load-hardening", "Insert LFENCE instructions to prevent data speculatively injected into loads from being used maliciously.", X86::FeatureLVILoadHardening, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lwp", "Enable LWP instructions", X86::FeatureLWP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lzcnt", "Support LZCNT instruction", X86::FeatureLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "macrofusion", "Various instructions can be fused with conditional branches", X86::TuningMacroFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mmx", "Enable MMX instructions", X86::FeatureMMX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movbe", "Support MOVBE instruction", X86::FeatureMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdir64b", "Support movdir64b instruction (direct store 64 bytes)", X86::FeatureMOVDIR64B, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdiri", "Support movdiri instruction (direct store integer)", X86::FeatureMOVDIRI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mwaitx", "Enable MONITORX/MWAITX timer functionality", X86::FeatureMWAITX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ndd", "Support non-destructive destination", X86::FeatureNDD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay", "Has no bypass delay when using the 'wrong' domain", X86::TuningNoDomainDelay, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay-blend", "Has no bypass delay when using the 'wrong' blend type", X86::TuningNoDomainDelayBlend, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay-mov", "Has no bypass delay when using the 'wrong' mov type", X86::TuningNoDomainDelayMov, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay-shuffle", "Has no bypass delay when using the 'wrong' shuffle type", X86::TuningNoDomainDelayShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "nopl", "Enable NOPL instruction (generally pentium pro+)", X86::FeatureNOPL, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pad-short-functions", "Pad short functions (to prevent a stall when returning too early)", X86::TuningPadShortFunctions, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pclmul", "Enable packed carry-less multiplication instructions", X86::FeaturePCLMUL, { { { 0x0ULL, 0x200000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pconfig", "platform configuration instruction", X86::FeaturePCONFIG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pku", "Enable protection keys", X86::FeaturePKU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "popcnt", "Support POPCNT instruction", X86::FeaturePOPCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ppx", "Support Push-Pop Acceleration", X86::FeaturePPX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-128-bit", "Prefer 128-bit AVX instructions", X86::TuningPrefer128Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-256-bit", "Prefer 256-bit AVX instructions", X86::TuningPrefer256Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-mask-registers", "Prefer AVX512 mask registers over PTEST/MOVMSK", X86::TuningPreferMaskRegisters, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-movmsk-over-vtest", "Prefer movmsk over vtest instruction", X86::TuningPreferMovmskOverVTest, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-no-gather", "Prefer no gather instructions", X86::TuningPreferNoGather, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-no-scatter", "Prefer no scatter instructions", X86::TuningPreferNoScatter, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefetchi", "Prefetch instruction with T0 or T1 Hint", X86::FeaturePREFETCHI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefetchwt1", "Prefetch with Intent to Write and T1 Hint", X86::FeaturePREFETCHWT1, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prfchw", "Support PRFCHW instructions", X86::FeaturePRFCHW, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ptwrite", "Support ptwrite instruction", X86::FeaturePTWRITE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "push2pop2", "Support PUSH2/POP2 instructions", X86::FeaturePush2Pop2, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "raoint", "Support RAO-INT instructions", X86::FeatureRAOINT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdpid", "Support RDPID instructions", X86::FeatureRDPID, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdpru", "Support RDPRU instructions", X86::FeatureRDPRU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdrnd", "Support RDRAND instruction", X86::FeatureRDRAND, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdseed", "Support RDSEED instruction", X86::FeatureRDSEED, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline", "Remove speculation of indirect branches from the generated code, either by avoiding them entirely or lowering them with a speculation blocking construct", X86::FeatureRetpoline, { { { 0x0ULL, 0x1800000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-external-thunk", "When lowering an indirect call or branch using a `retpoline`, rely on the specified user provided thunk rather than emitting one ourselves. Only has effect when combined with some other retpoline feature", X86::FeatureRetpolineExternalThunk, { { { 0x0ULL, 0x1000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-branches", "Remove speculation of indirect branches from the generated code", X86::FeatureRetpolineIndirectBranches, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-calls", "Remove speculation of indirect calls from the generated code", X86::FeatureRetpolineIndirectCalls, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rtm", "Support RTM instructions", X86::FeatureRTM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sahf", "Support LAHF and SAHF instructions in 64-bit mode", X86::FeatureLAHFSAHF64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sbb-dep-breaking", "SBB with same register has no source dependency", X86::TuningSBBDepBreaking, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "serialize", "Has serialize instruction", X86::FeatureSERIALIZE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "seses", "Prevent speculative execution side channel timing attacks by inserting a speculation barrier before memory reads, memory writes, and conditional branches. Implies LVI Control Flow integrity.", X86::FeatureSpeculativeExecutionSideEffectSuppression, { { { 0x200000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sgx", "Enable Software Guard Extensions", X86::FeatureSGX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sha", "Enable SHA instructions", X86::FeatureSHA, { { { 0x0ULL, 0x200000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sha512", "Support SHA512 instructions", X86::FeatureSHA512, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "shstk", "Support CET Shadow-Stack instructions", X86::FeatureSHSTK, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-3ops-lea", "LEA instruction with 3 ops or certain registers is slow", X86::TuningSlow3OpsLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-incdec", "INC and DEC instructions are slower than ADD and SUB", X86::TuningSlowIncDec, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-lea", "LEA instruction with certain arguments is slow", X86::TuningSlowLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmaddwd", "PMADDWD is slower than PMULLD", X86::TuningSlowPMADDWD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmulld", "PMULLD instruction is slow (compared to PMULLW/PMULHW and PMULUDQ)", X86::TuningSlowPMULLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-shld", "SHLD instruction is slow", X86::TuningSlowSHLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-two-mem-ops", "Two memory operand instructions are slow", X86::TuningSlowTwoMemOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-16", "Slow unaligned 16-byte memory access", X86::TuningSlowUAMem16, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-32", "Slow unaligned 32-byte memory access", X86::TuningSlowUAMem32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sm3", "Support SM3 instructions", X86::FeatureSM3, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sm4", "Support SM4 instructions", X86::FeatureSM4, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "soft-float", "Use software floating point features", X86::FeatureSoftFloat, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse", "Enable SSE instructions", X86::FeatureSSE1, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse-unaligned-mem", "Allow unaligned memory operands with SSE instructions (this may require setting a configuration bit in the processor)", X86::FeatureSSEUnalignedMem, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse2", "Enable SSE2 instructions", X86::FeatureSSE2, { { { 0x0ULL, 0x100000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse3", "Enable SSE3 instructions", X86::FeatureSSE3, { { { 0x0ULL, 0x200000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4.1", "Enable SSE 4.1 instructions", X86::FeatureSSE41, { { { 0x0ULL, 0x8000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4.2", "Enable SSE 4.2 instructions", X86::FeatureSSE42, { { { 0x0ULL, 0x1000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4a", "Support SSE 4a instructions", X86::FeatureSSE4A, { { { 0x0ULL, 0x400000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ssse3", "Enable SSSE3 instructions", X86::FeatureSSSE3, { { { 0x0ULL, 0x400000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tagged-globals", "Use an instruction sequence for taking the address of a global that allows a memory tag in the upper address bits.", X86::FeatureTaggedGlobals, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tbm", "Enable TBM instructions", X86::FeatureTBM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tsxldtrk", "Support TSXLDTRK instructions", X86::FeatureTSXLDTRK, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tuning-fast-imm-vector-shift", "Vector shifts are fast (2/cycle) as opposed to slow (1/cycle)", X86::TuningFastImmVectorShift, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "uintr", "Has UINTR Instructions", X86::FeatureUINTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-glm-div-sqrt-costs", "Use Goldmont specific floating point div/sqrt costs", X86::TuningUseGLMDivSqrtCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-slm-arith-costs", "Use Silvermont specific arithmetic costs", X86::TuningUseSLMArithCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "usermsr", "Support USERMSR instructions", X86::FeatureUSERMSR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vaes", "Promote selected AES instructions to AVX512/AVX registers", X86::FeatureVAES, { { { 0x408ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vpclmulqdq", "Enable vpclmulqdq instructions", X86::FeatureVPCLMULQDQ, { { { 0x200ULL, 0x10ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vzeroupper", "Should insert vzeroupper instructions", X86::TuningInsertVZEROUPPER, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "waitpkg", "Wait and pause enhancements", X86::FeatureWAITPKG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "wbnoinvd", "Write Back No Invalidate", X86::FeatureWBNOINVD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "widekl", "Support Key Locker wide Instructions", X86::FeatureWIDEKL, { { { 0x80000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "x87", "Enable X87 float instructions", X86::FeatureX87, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xop", "Enable XOP instructions", X86::FeatureXOP, { { { 0x100000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsave", "Support xsave instructions", X86::FeatureXSAVE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsavec", "Support xsavec instructions", X86::FeatureXSAVEC, { { { 0x0ULL, 0x2000000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaveopt", "Support xsaveopt instructions", X86::FeatureXSAVEOPT, { { { 0x0ULL, 0x2000000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaves", "Support xsaves instructions", X86::FeatureXSAVES, { { { 0x0ULL, 0x2000000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
};

#ifdef DBGFIELD
#error "<target>GenSubtargetInfo.inc requires a DBGFIELD macro"
#endif
#if !defined(NDEBUG) || defined(LLVM_ENABLE_DUMP)
#define DBGFIELD(x) x,
#else
#define DBGFIELD(x)
#endif

// ===============================================================
// Data tables for the new per-operand machine model.

// {ProcResourceIdx, ReleaseAtCycle, AcquireAtCycle}
extern const llvm::MCWriteProcResEntry X86WriteProcResTable[] = {
  { 0,  0,  0 }, // Invalid
  { 5,  1,   0}, // #1
  { 1,  1,   0}, // #2
  { 2,  1,   0}, // #3
  { 3,  1,   0}, // #4
  { 4,  1,   0}, // #5
  { 5,  1,   0}, // #6
  { 6,  1,   0}, // #7
  { 7,  1,   0}, // #8
  { 8,  1,   0}, // #9
  { 4,  1,   0}, // #10
  { 5,  1,   0}, // #11
  { 7,  1,   0}, // #12
  { 8,  1,   0}, // #13
  { 4,  2,   0}, // #14
  { 5,  3,   0}, // #15
  { 7,  2,   0}, // #16
  { 8,  2,   0}, // #17
  {15,  2,   0}, // #18
  {16,  1,   0}, // #19
  {19,  1,   0}, // #20
  {23,  1,   0}, // #21
  { 4,  1,   0}, // #22
  { 5,  1,   0}, // #23
  { 7,  1,   0}, // #24
  { 8,  1,   0}, // #25
  {13,  1,   0}, // #26
  {14,  1,   0}, // #27
  {15,  1,   0}, // #28
  {16,  1,   0}, // #29
  { 2,  1,   0}, // #30
  { 3,  1,   0}, // #31
  { 4,  1,   0}, // #32
  { 5,  1,   0}, // #33
  { 9,  1,   0}, // #34
  {10,  1,   0}, // #35
  {11,  1,   0}, // #36
  {15,  1,   0}, // #37
  {19,  1,   0}, // #38
  {23,  1,   0}, // #39
  { 5,  1,   0}, // #40
  {15,  2,   0}, // #41
  {16,  1,   0}, // #42
  {19,  1,   0}, // #43
  {23,  1,   0}, // #44
  { 4,  1,   0}, // #45
  { 5,  2,   0}, // #46
  { 7,  1,   0}, // #47
  { 8,  1,   0}, // #48
  {15,  2,   0}, // #49
  {16,  1,   0}, // #50
  {19,  1,   0}, // #51
  {23,  1,   0}, // #52
  { 3,  1,   0}, // #53
  { 4,  1,   0}, // #54
  { 5,  1,   0}, // #55
  {10,  1,   0}, // #56
  {11,  1,   0}, // #57
  {15,  1,   0}, // #58
  {16,  1,   0}, // #59
  { 3,  1,   0}, // #60
  { 4,  1,   0}, // #61
  { 5,  1,   0}, // #62
  { 6,  1,   0}, // #63
  { 7,  1,   0}, // #64
  {10,  1,   0}, // #65
  {11,  1,   0}, // #66
  {20,  1,   0}, // #67
  { 2,  1,   0}, // #68
  { 3,  1,   0}, // #69
  { 4,  1,   0}, // #70
  { 5,  1,   0}, // #71
  {15,  1,   0}, // #72
  {16,  1,   0}, // #73
  { 2,  2,   0}, // #74
  { 3,  2,   0}, // #75
  { 4,  2,   0}, // #76
  { 5,  2,   0}, // #77
  {15,  1,   0}, // #78
  {16,  1,   0}, // #79
  { 1,  4,   0}, // #80
  { 2,  5,   0}, // #81
  { 3, 11,   0}, // #82
  { 4, 13,   0}, // #83
  { 5, 13,   0}, // #84
  { 6,  7,   0}, // #85
  { 7,  9,   0}, // #86
  { 8,  6,   0}, // #87
  {10,  6,   0}, // #88
  {11,  6,   0}, // #89
  {15,  1,   0}, // #90
  {16,  1,   0}, // #91
  {20,  3,   0}, // #92
  { 1,  4,   0}, // #93
  { 2,  5,   0}, // #94
  { 3, 12,   0}, // #95
  { 4, 14,   0}, // #96
  { 5, 14,   0}, // #97
  { 6,  7,   0}, // #98
  { 7,  9,   0}, // #99
  { 8,  6,   0}, // #100
  {10,  6,   0}, // #101
  {11,  6,   0}, // #102
  {20,  3,   0}, // #103
  { 2,  1,   0}, // #104
  { 3,  1,   0}, // #105
  { 4,  2,   0}, // #106
  { 5,  2,   0}, // #107
  { 7,  1,   0}, // #108
  { 8,  1,   0}, // #109
  { 9,  1,   0}, // #110
  {10,  1,   0}, // #111
  {11,  1,   0}, // #112
  {15,  1,   0}, // #113
  {16,  1,   0}, // #114
  { 5,  1,   0}, // #115
  {11,  1,   0}, // #116
  {15,  1,   0}, // #117
  {16,  1,   0}, // #118
  { 2,  1,   0}, // #119
  { 3,  1,   0}, // #120
  { 4,  1,   0}, // #121
  { 5,  1,   0}, // #122
  { 9,  1,   0}, // #123
  {10,  1,   0}, // #124
  {11,  1,   0}, // #125
  {15,  1,   0}, // #126
  {16,  1,   0}, // #127
  { 2,  1,   0}, // #128
  { 3,  1,   0}, // #129
  { 4,  3,   0}, // #130
  { 5,  9,   0}, // #131
  { 7,  2,   0}, // #132
  { 8,  2,   0}, // #133
  { 9,  1,   0}, // #134
  {10,  1,   0}, // #135
  {11,  3,   0}, // #136
  {15,  1,   0}, // #137
  {16,  1,   0}, // #138
  { 2,  1,   0}, // #139
  { 3,  1,   0}, // #140
  { 4,  1,   0}, // #141
  { 5,  1,   0}, // #142
  { 9,  1,   0}, // #143
  {10,  1,   0}, // #144
  {11,  1,   0}, // #145
  {15,  2,   0}, // #146
  {16,  1,   0}, // #147
  {19,  1,   0}, // #148
  {23,  1,   0}, // #149
  { 2,  1,   0}, // #150
  { 3,  1,   0}, // #151
  { 4,  3,   0}, // #152
  { 5,  8,   0}, // #153
  { 7,  2,   0}, // #154
  { 8,  2,   0}, // #155
  { 9,  1,   0}, // #156
  {10,  1,   0}, // #157
  {11,  3,   0}, // #158
  {15,  2,   0}, // #159
  {16,  1,   0}, // #160
  {19,  1,   0}, // #161
  {23,  1,   0}, // #162
  { 4,  1,   0}, // #163
  { 5,  1,   0}, // #164
  { 7,  1,   0}, // #165
  { 8,  1,   0}, // #166
  {15,  1,   0}, // #167
  {16,  1,   0}, // #168
  { 4,  2,   0}, // #169
  { 5,  5,   0}, // #170
  { 7,  2,   0}, // #171
  { 8,  2,   0}, // #172
  { 1,  1,   0}, // #173
  { 2,  1,   0}, // #174
  { 3,  1,   0}, // #175
  { 4,  1,   0}, // #176
  { 5,  1,   0}, // #177
  { 6,  1,   0}, // #178
  { 7,  1,   0}, // #179
  { 8,  1,   0}, // #180
  {15,  1,   0}, // #181
  {16,  1,   0}, // #182
  { 2,  1,   0}, // #183
  { 3,  2,   0}, // #184
  { 4,  2,   0}, // #185
  { 5,  2,   0}, // #186
  { 6,  1,   0}, // #187
  { 7,  1,   0}, // #188
  {10,  1,   0}, // #189
  {11,  1,   0}, // #190
  {20,  1,   0}, // #191
  { 2,  1,   0}, // #192
  { 3,  2,   0}, // #193
  { 4,  2,   0}, // #194
  { 5,  2,   0}, // #195
  { 6,  1,   0}, // #196
  { 7,  1,   0}, // #197
  {10,  1,   0}, // #198
  {11,  1,   0}, // #199
  {15,  1,   0}, // #200
  {16,  1,   0}, // #201
  {20,  1,   0}, // #202
  { 1,  1,   0}, // #203
  { 2,  2,   0}, // #204
  { 3,  2,   0}, // #205
  { 4,  2,   0}, // #206
  { 5,  2,   0}, // #207
  { 6,  1,   0}, // #208
  { 7,  1,   0}, // #209
  { 8,  1,   0}, // #210
  {15,  1,   0}, // #211
  {16,  1,   0}, // #212
  { 2,  3,   0}, // #213
  { 3,  3,   0}, // #214
  { 4,  3,   0}, // #215
  { 5,  4,   0}, // #216
  { 9,  3,   0}, // #217
  {10,  3,   0}, // #218
  {11,  3,   0}, // #219
  {15,  1,   0}, // #220
  {16,  1,   0}, // #221
  { 2,  3,   0}, // #222
  { 3,  3,   0}, // #223
  { 4,  3,   0}, // #224
  { 5,  3,   0}, // #225
  { 9,  3,   0}, // #226
  {10,  3,   0}, // #227
  {11,  3,   0}, // #228
  {15,  1,   0}, // #229
  {16,  1,   0}, // #230
  { 2,  2,   0}, // #231
  { 3,  3,   0}, // #232
  { 4,  3,   0}, // #233
  { 5,  3,   0}, // #234
  {10,  1,   0}, // #235
  {11,  1,   0}, // #236
  {15,  1,   0}, // #237
  {16,  1,   0}, // #238
  { 2,  2,   0}, // #239
  { 3,  5,   0}, // #240
  { 4,  6,   0}, // #241
  { 5,  6,   0}, // #242
  { 6,  1,   0}, // #243
  { 7,  2,   0}, // #244
  { 8,  1,   0}, // #245
  {10,  3,   0}, // #246
  {11,  3,   0}, // #247
  {15,  1,   0}, // #248
  {16,  1,   0}, // #249
  {20,  1,   0}, // #250
  { 2,  2,   0}, // #251
  { 3,  5,   0}, // #252
  { 4,  6,   0}, // #253
  { 5,  6,   0}, // #254
  { 6,  1,   0}, // #255
  { 7,  2,   0}, // #256
  { 8,  1,   0}, // #257
  {10,  3,   0}, // #258
  {11,  3,   0}, // #259
  {20,  1,   0}, // #260
  { 3,  1,   0}, // #261
  { 4,  1,   0}, // #262
  { 5,  1,   0}, // #263
  {10,  1,   0}, // #264
  {11,  1,   0}, // #265
  {15,  1,   0}, // #266
  {19,  1,   0}, // #267
  {23,  1,   0}, // #268
  { 1,  1,   0}, // #269
  { 2,  1,   0}, // #270
  { 3,  2,   0}, // #271
  { 4,  2,   0}, // #272
  { 5,  2,   0}, // #273
  { 6,  1,   0}, // #274
  { 7,  1,   0}, // #275
  { 8,  1,   0}, // #276
  {10,  1,   0}, // #277
  {11,  1,   0}, // #278
  { 3,  1,   0}, // #279
  { 4,  1,   0}, // #280
  { 5,  1,   0}, // #281
  { 6,  1,   0}, // #282
  { 7,  1,   0}, // #283
  {10,  1,   0}, // #284
  {11,  1,   0}, // #285
  {13,  1,   0}, // #286
  {14,  1,   0}, // #287
  {15,  1,   0}, // #288
  {16,  1,   0}, // #289
  {20,  1,   0}, // #290
  { 1,  1,   0}, // #291
  { 2,  1,   0}, // #292
  { 3,  9,   0}, // #293
  { 4, 10,   0}, // #294
  { 5, 10,   0}, // #295
  { 6,  9,   0}, // #296
  { 7, 10,   0}, // #297
  { 8,  2,   0}, // #298
  { 3,  2,   0}, // #299
  { 4,  2,   0}, // #300
  { 5,  2,   0}, // #301
  { 6,  2,   0}, // #302
  { 7,  2,   0}, // #303
  { 3,  3,   0}, // #304
  { 4,  3,   0}, // #305
  { 5,  3,   0}, // #306
  { 6,  2,   0}, // #307
  { 7,  2,   0}, // #308
  {10,  3,   0}, // #309
  {11,  3,   0}, // #310
  {15,  1,   0}, // #311
  {16,  1,   0}, // #312
  {20,  2,   0}, // #313
  { 3,  3,   0}, // #314
  { 4,  3,   0}, // #315
  { 5,  3,   0}, // #316
  { 6,  2,   0}, // #317
  { 7,  2,   0}, // #318
  {10,  3,   0}, // #319
  {11,  3,   0}, // #320
  {20,  2,   0}, // #321
  { 2,  1,   0}, // #322
  { 3,  1,   0}, // #323
  { 4,  2,   0}, // #324
  { 5,  4,   0}, // #325
  { 7,  1,   0}, // #326
  { 8,  1,   0}, // #327
  { 9,  1,   0}, // #328
  {10,  1,   0}, // #329
  {11,  1,   0}, // #330
  {15,  1,   0}, // #331
  {16,  1,   0}, // #332
  { 2,  1,   0}, // #333
  { 3,  1,   0}, // #334
  { 4,  1,   0}, // #335
  { 5,  2,   0}, // #336
  { 9,  1,   0}, // #337
  {10,  1,   0}, // #338
  {11,  1,   0}, // #339
  {15,  1,   0}, // #340
  {16,  1,   0}, // #341
  { 2,  1,   0}, // #342
  { 3,  1,   0}, // #343
  { 4,  2,   0}, // #344
  { 5,  3,   0}, // #345
  { 7,  1,   0}, // #346
  { 8,  1,   0}, // #347
  { 9,  1,   0}, // #348
  {10,  1,   0}, // #349
  {11,  1,   0}, // #350
  {15,  1,   0}, // #351
  {16,  1,   0}, // #352
  { 2,  1,   0}, // #353
  { 3,  2,   0}, // #354
  { 4,  2,   0}, // #355
  { 5,  2,   0}, // #356
  { 6,  1,   0}, // #357
  { 7,  1,   0}, // #358
  { 9,  1,   0}, // #359
  {10,  2,   0}, // #360
  {11,  2,   0}, // #361
  {15,  1,   0}, // #362
  {16,  1,   0}, // #363
  {20,  1,   0}, // #364
  { 2,  1,   0}, // #365
  { 3,  2,   0}, // #366
  { 4,  2,   0}, // #367
  { 5,  2,   0}, // #368
  { 6,  1,   0}, // #369
  { 7,  1,   0}, // #370
  { 9,  1,   0}, // #371
  {10,  2,   0}, // #372
  {11,  2,   0}, // #373
  {20,  1,   0}, // #374
  { 3,  1,   0}, // #375
  { 4,  1,   0}, // #376
  { 5,  1,   0}, // #377
  { 6,  1,   0}, // #378
  { 7,  1,   0}, // #379
  {10,  1,   0}, // #380
  {11,  1,   0}, // #381
  {15,  1,   0}, // #382
  {16,  1,   0}, // #383
  {20,  1,   0}, // #384
  { 1,  1,   0}, // #385
  { 2,  1,   0}, // #386
  { 3,  2,   0}, // #387
  { 4,  3,   0}, // #388
  { 5,  3,   0}, // #389
  { 6,  1,   0}, // #390
  { 7,  2,   0}, // #391
  { 8,  2,   0}, // #392
  {15,  1,   0}, // #393
  {16,  1,   0}, // #394
  { 3,  1,   0}, // #395
  { 4,  1,   0}, // #396
  { 5,  1,   0}, // #397
  { 6,  1,   0}, // #398
  { 7,  1,   0}, // #399
  {15,  1,   0}, // #400
  {16,  1,   0}, // #401
  { 3,  3,   0}, // #402
  { 4,  3,   0}, // #403
  { 5,  3,   0}, // #404
  { 6,  3,   0}, // #405
  { 7,  3,   0}, // #406
  {10,  2,   0}, // #407
  {11,  2,   0}, // #408
  {15,  1,   0}, // #409
  {16,  1,   0}, // #410
  {20,  2,   0}, // #411
  { 3,  3,   0}, // #412
  { 4,  3,   0}, // #413
  { 5,  3,   0}, // #414
  { 6,  3,   0}, // #415
  { 7,  3,   0}, // #416
  {10,  2,   0}, // #417
  {11,  2,   0}, // #418
  {20,  2,   0}, // #419
  { 3,  2,   0}, // #420
  { 4,  2,   0}, // #421
  { 5,  2,   0}, // #422
  { 6,  1,   0}, // #423
  { 7,  1,   0}, // #424
  {10,  2,   0}, // #425
  {11,  2,   0}, // #426
  {20,  1,   0}, // #427
  { 1,  1,   0}, // #428
  { 2,  1,   0}, // #429
  { 3,  2,   0}, // #430
  { 4,  2,   0}, // #431
  { 5,  2,   0}, // #432
  { 6,  2,   0}, // #433
  { 7,  2,   0}, // #434
  { 8,  1,   0}, // #435
  {10,  1,   0}, // #436
  {11,  1,   0}, // #437
  {15,  1,   0}, // #438
  {16,  1,   0}, // #439
  {20,  1,   0}, // #440
  { 1,  1,   0}, // #441
  { 2,  1,   0}, // #442
  { 3,  2,   0}, // #443
  { 4,  2,   0}, // #444
  { 5,  2,   0}, // #445
  { 6,  2,   0}, // #446
  { 7,  2,   0}, // #447
  { 8,  1,   0}, // #448
  {10,  1,   0}, // #449
  {11,  1,   0}, // #450
  {20,  1,   0}, // #451
  { 3,  2,   0}, // #452
  { 4,  2,   0}, // #453
  { 5,  2,   0}, // #454
  { 6,  1,   0}, // #455
  { 7,  1,   0}, // #456
  {10,  2,   0}, // #457
  {11,  2,   0}, // #458
  {15,  1,   0}, // #459
  {16,  1,   0}, // #460
  {20,  1,   0}, // #461
  { 1,  3,   0}, // #462
  { 2,  4,   0}, // #463
  { 3,  6,   0}, // #464
  { 4,  7,   0}, // #465
  { 5,  7,   0}, // #466
  { 6,  4,   0}, // #467
  { 7,  5,   0}, // #468
  { 8,  4,   0}, // #469
  { 9,  1,   0}, // #470
  {10,  2,   0}, // #471
  {11,  2,   0}, // #472
  {15,  1,   0}, // #473
  {16,  1,   0}, // #474
  {20,  1,   0}, // #475
  { 1,  3,   0}, // #476
  { 2,  4,   0}, // #477
  { 3,  7,   0}, // #478
  { 4,  8,   0}, // #479
  { 5,  8,   0}, // #480
  { 6,  4,   0}, // #481
  { 7,  5,   0}, // #482
  { 8,  4,   0}, // #483
  { 9,  1,   0}, // #484
  {10,  2,   0}, // #485
  {11,  2,   0}, // #486
  {20,  1,   0}, // #487
  { 1,  3,   0}, // #488
  { 2,  4,   0}, // #489
  { 3,  7,   0}, // #490
  { 4,  8,   0}, // #491
  { 5,  8,   0}, // #492
  { 6,  4,   0}, // #493
  { 7,  5,   0}, // #494
  { 8,  4,   0}, // #495
  { 9,  1,   0}, // #496
  {10,  2,   0}, // #497
  {11,  2,   0}, // #498
  {15,  1,   0}, // #499
  {16,  1,   0}, // #500
  {20,  1,   0}, // #501
  { 1,  3,   0}, // #502
  { 2,  4,   0}, // #503
  { 3,  8,   0}, // #504
  { 4,  9,   0}, // #505
  { 5,  9,   0}, // #506
  { 6,  4,   0}, // #507
  { 7,  5,   0}, // #508
  { 8,  4,   0}, // #509
  { 9,  1,   0}, // #510
  {10,  2,   0}, // #511
  {11,  2,   0}, // #512
  {20,  1,   0}, // #513
  { 1,  3,   0}, // #514
  { 2,  3,   0}, // #515
  { 3,  3,   0}, // #516
  { 4,  3,   0}, // #517
  { 5,  3,   0}, // #518
  { 6,  3,   0}, // #519
  { 7,  3,   0}, // #520
  { 8,  3,   0}, // #521
  {15,  1,   0}, // #522
  {16,  1,   0}, // #523
  { 3,  3,   0}, // #524
  { 4,  3,   0}, // #525
  { 5,  3,   0}, // #526
  {10,  2,   0}, // #527
  {11,  2,   0}, // #528
  {15,  1,   0}, // #529
  {16,  1,   0}, // #530
  { 2,  1,   0}, // #531
  { 3,  2,   0}, // #532
  { 4,  2,   0}, // #533
  { 5,  2,   0}, // #534
  {10,  1,   0}, // #535
  {11,  1,   0}, // #536
  { 4,  4,   0}, // #537
  { 5,  6,   0}, // #538
  { 7,  4,   0}, // #539
  { 8,  4,   0}, // #540
  { 2,  2,   0}, // #541
  { 3,  2,   0}, // #542
  { 4,  5,   0}, // #543
  { 5,  7,   0}, // #544
  { 7,  3,   0}, // #545
  { 8,  3,   0}, // #546
  { 9,  2,   0}, // #547
  {10,  2,   0}, // #548
  {11,  2,   0}, // #549
  {15,  2,   0}, // #550
  {16,  1,   0}, // #551
  {19,  1,   0}, // #552
  {23,  1,   0}, // #553
  { 2,  2,   0}, // #554
  { 3,  2,   0}, // #555
  { 4,  7,   0}, // #556
  { 5,  9,   0}, // #557
  { 7,  5,   0}, // #558
  { 8,  5,   0}, // #559
  { 9,  2,   0}, // #560
  {10,  2,   0}, // #561
  {11,  2,   0}, // #562
  { 4,  2,   0}, // #563
  { 5,  2,   0}, // #564
  { 7,  2,   0}, // #565
  { 8,  2,   0}, // #566
  { 4,  1,   0}, // #567
  { 5,  1,   0}, // #568
  { 7,  1,   0}, // #569
  { 8,  1,   0}, // #570
  {15,  2,   0}, // #571
  {16,  1,   0}, // #572
  {19,  1,   0}, // #573
  {23,  1,   0}, // #574
  { 4,  2,   0}, // #575
  { 5,  2,   0}, // #576
  { 7,  2,   0}, // #577
  { 8,  2,   0}, // #578
  {15,  2,   0}, // #579
  {16,  1,   0}, // #580
  {19,  1,   0}, // #581
  {23,  1,   0}, // #582
  { 4,  4,   0}, // #583
  { 5,  4,   0}, // #584
  { 7,  4,   0}, // #585
  { 8,  4,   0}, // #586
  { 4,  2,   0}, // #587
  { 5,  2,   0}, // #588
  { 7,  2,   0}, // #589
  { 8,  2,   0}, // #590
  {15,  1,   0}, // #591
  {19,  1,   0}, // #592
  {23,  1,   0}, // #593
  { 2,  1,   0}, // #594
  { 3,  1,   0}, // #595
  { 4,  2,   0}, // #596
  { 5,  3,   0}, // #597
  { 7,  1,   0}, // #598
  { 8,  1,   0}, // #599
  { 9,  1,   0}, // #600
  {10,  1,   0}, // #601
  {11,  1,   0}, // #602
  {15,  2,   0}, // #603
  {16,  1,   0}, // #604
  {19,  1,   0}, // #605
  {23,  1,   0}, // #606
  { 2,  1,   0}, // #607
  { 3,  1,   0}, // #608
  { 4,  1,   0}, // #609
  { 5,  2,   0}, // #610
  { 9,  1,   0}, // #611
  {10,  1,   0}, // #612
  {11,  1,   0}, // #613
  {15,  2,   0}, // #614
  {16,  1,   0}, // #615
  {19,  1,   0}, // #616
  {23,  1,   0}, // #617
  { 1,  1,   0}, // #618
  { 2,  1,   0}, // #619
  { 3,  1,   0}, // #620
  { 4,  1,   0}, // #621
  { 5,  1,   0}, // #622
  { 6,  1,   0}, // #623
  { 7,  1,   0}, // #624
  { 8,  1,   0}, // #625
  {28,  7,   0}, // #626
  { 1,  1,   0}, // #627
  { 2,  1,   0}, // #628
  { 3,  1,   0}, // #629
  { 4,  2,   0}, // #630
  { 5,  2,   0}, // #631
  { 6,  1,   0}, // #632
  { 7,  2,   0}, // #633
  { 8,  2,   0}, // #634
  {15,  1,   0}, // #635
  {19,  1,   0}, // #636
  {23,  1,   0}, // #637
  { 3,  3,   0}, // #638
  { 4,  3,   0}, // #639
  { 5,  3,   0}, // #640
  {15,  1,   0}, // #641
  {16,  1,   0}, // #642
  { 2,  1,   0}, // #643
  { 3,  1,   0}, // #644
  { 4,  1,   0}, // #645
  { 5,  1,   0}, // #646
  {15,  1,   0}, // #647
  {19,  1,   0}, // #648
  {23,  1,   0}, // #649
  { 1,  1,   0}, // #650
  { 2,  1,   0}, // #651
  { 3,  1,   0}, // #652
  { 4,  1,   0}, // #653
  { 5,  1,   0}, // #654
  { 6,  1,   0}, // #655
  { 7,  1,   0}, // #656
  { 8,  1,   0}, // #657
  {15,  1,   0}, // #658
  {19,  1,   0}, // #659
  {23,  1,   0}, // #660
  { 1,  2,   0}, // #661
  { 2,  3,   0}, // #662
  { 3,  7,   0}, // #663
  { 4, 15,   0}, // #664
  { 5, 15,   0}, // #665
  { 6,  6,   0}, // #666
  { 7, 10,   0}, // #667
  { 8,  6,   0}, // #668
  { 9,  1,   0}, // #669
  {10,  3,   0}, // #670
  {11,  3,   0}, // #671
  {20,  2,   0}, // #672
  {21,  4,   0}, // #673
  { 2,  1,   0}, // #674
  { 3,  3,   0}, // #675
  { 4,  3,   0}, // #676
  { 5,  3,   0}, // #677
  { 6,  2,   0}, // #678
  { 7,  2,   0}, // #679
  {10,  2,   0}, // #680
  {11,  2,   0}, // #681
  {20,  2,   0}, // #682
  { 1,  1,   0}, // #683
  { 2,  2,   0}, // #684
  { 3,  3,   0}, // #685
  { 4,  3,   0}, // #686
  { 5,  3,   0}, // #687
  { 6,  2,   0}, // #688
  { 7,  2,   0}, // #689
  { 8,  1,   0}, // #690
  {10,  1,   0}, // #691
  {11,  1,   0}, // #692
  {20,  1,   0}, // #693
  {14,  1,   0}, // #694
  {15,  1,   0}, // #695
  {18,  1,   0}, // #696
  {19,  1,   0}, // #697
  { 5,  4,   0}, // #698
  {15,  2,   0}, // #699
  {16,  1,   0}, // #700
  {19,  1,   0}, // #701
  {23,  1,   0}, // #702
  { 4,  1,   0}, // #703
  { 5,  6,   0}, // #704
  { 7,  1,   0}, // #705
  { 8,  1,   0}, // #706
  {15,  2,   0}, // #707
  {16,  1,   0}, // #708
  {19,  1,   0}, // #709
  {23,  1,   0}, // #710
  { 1,  1,   0}, // #711
  { 2,  1,   0}, // #712
  { 3,  2,   0}, // #713
  { 4,  2,   0}, // #714
  { 5,  2,   0}, // #715
  { 6,  2,   0}, // #716
  { 7,  2,   0}, // #717
  { 8,  1,   0}, // #718
  {13,  1,   0}, // #719
  {14,  1,   0}, // #720
  {15,  1,   0}, // #721
  {16,  1,   0}, // #722
  { 3,  1,   0}, // #723
  { 4,  1,   0}, // #724
  { 5,  1,   0}, // #725
  { 6,  1,   0}, // #726
  { 7,  1,   0}, // #727
  {10,  1,   0}, // #728
  {11,  1,   0}, // #729
  {14,  1,   0}, // #730
  {15,  1,   0}, // #731
  {18,  1,   0}, // #732
  {19,  1,   0}, // #733
  {20,  1,   0}, // #734
  { 2,  1,   0}, // #735
  { 3,  1,   0}, // #736
  { 4,  7,   0}, // #737
  { 5, 11,   0}, // #738
  { 7,  6,   0}, // #739
  { 8,  6,   0}, // #740
  { 9,  1,   0}, // #741
  {10,  1,   0}, // #742
  {11,  1,   0}, // #743
  { 4,  1,   0}, // #744
  { 5,  1,   0}, // #745
  { 7,  1,   0}, // #746
  { 8,  1,   0}, // #747
  {14,  1,   0}, // #748
  {15,  1,   0}, // #749
  {18,  1,   0}, // #750
  {19,  1,   0}, // #751
  {21,  1,   0}, // #752
  { 3,  1,   0}, // #753
  { 4,  2,   0}, // #754
  { 5,  2,   0}, // #755
  { 6,  1,   0}, // #756
  { 7,  2,   0}, // #757
  { 8,  1,   0}, // #758
  {10,  1,   0}, // #759
  {11,  1,   0}, // #760
  {20,  1,   0}, // #761
  { 2,  2,   0}, // #762
  { 3,  2,   0}, // #763
  { 4,  9,   0}, // #764
  { 5, 13,   0}, // #765
  { 7,  7,   0}, // #766
  { 8,  7,   0}, // #767
  { 9,  2,   0}, // #768
  {10,  2,   0}, // #769
  {11,  2,   0}, // #770
  {15,  2,   0}, // #771
  {16,  1,   0}, // #772
  {19,  1,   0}, // #773
  {23,  1,   0}, // #774
  { 2,  1,   0}, // #775
  { 3,  1,   0}, // #776
  { 4,  5,   0}, // #777
  { 5,  7,   0}, // #778
  { 7,  4,   0}, // #779
  { 8,  4,   0}, // #780
  { 9,  1,   0}, // #781
  {10,  1,   0}, // #782
  {11,  1,   0}, // #783
  { 1,  2,   0}, // #784
  { 2,  2,   0}, // #785
  { 3,  6,   0}, // #786
  { 4, 12,   0}, // #787
  { 5, 19,   0}, // #788
  { 6,  4,   0}, // #789
  { 7, 10,   0}, // #790
  { 8,  8,   0}, // #791
  {10,  4,   0}, // #792
  {11,  4,   0}, // #793
  {15,  2,   0}, // #794
  {16,  1,   0}, // #795
  {19,  1,   0}, // #796
  {20,  2,   0}, // #797
  {23,  1,   0}, // #798
  { 1,  2,   0}, // #799
  { 2,  8,   0}, // #800
  { 3, 12,   0}, // #801
  { 4, 21,   0}, // #802
  { 5, 21,   0}, // #803
  { 6,  5,   0}, // #804
  { 7, 14,   0}, // #805
  { 8,  9,   0}, // #806
  { 9,  4,   0}, // #807
  {10,  7,   0}, // #808
  {11,  7,   0}, // #809
  {20,  3,   0}, // #810
  { 1,  2,   0}, // #811
  { 2,  4,   0}, // #812
  { 3, 13,   0}, // #813
  { 4, 34,   0}, // #814
  { 5, 34,   0}, // #815
  { 6, 11,   0}, // #816
  { 7, 32,   0}, // #817
  { 8, 23,   0}, // #818
  { 9,  2,   0}, // #819
  {10, 11,   0}, // #820
  {11, 11,   0}, // #821
  {15, 19,   0}, // #822
  {16, 14,   0}, // #823
  {19,  4,   0}, // #824
  {20,  9,   0}, // #825
  {23,  5,   0}, // #826
  { 2,  1,   0}, // #827
  { 3,  1,   0}, // #828
  { 4,  3,   0}, // #829
  { 5,  9,   0}, // #830
  { 7,  2,   0}, // #831
  { 8,  2,   0}, // #832
  { 9,  1,   0}, // #833
  {10,  1,   0}, // #834
  {11,  1,   0}, // #835
  {15,  1,   0}, // #836
  {16,  1,   0}, // #837
  { 3,  1,   0}, // #838
  { 4, 10,   0}, // #839
  { 5, 10,   0}, // #840
  { 6,  1,   0}, // #841
  { 7,  3,   0}, // #842
  { 8,  2,   0}, // #843
  {10,  1,   0}, // #844
  {11,  1,   0}, // #845
  {20,  1,   0}, // #846
  {21,  2,   0}, // #847
  { 1,  7,   0}, // #848
  { 2, 24,   0}, // #849
  { 3, 44,   0}, // #850
  { 4, 70,   0}, // #851
  { 5, 75,   0}, // #852
  { 6, 26,   0}, // #853
  { 7, 52,   0}, // #854
  { 8, 32,   0}, // #855
  { 9, 17,   0}, // #856
  {10, 36,   0}, // #857
  {11, 37,   0}, // #858
  {15, 10,   0}, // #859
  {16,  9,   0}, // #860
  {19,  1,   0}, // #861
  {20, 19,   0}, // #862
  {23,  1,   0}, // #863
  { 3,  9,   0}, // #864
  { 4, 15,   0}, // #865
  { 5, 15,   0}, // #866
  { 6,  9,   0}, // #867
  { 7,  9,   0}, // #868
  {10,  6,   0}, // #869
  {11,  6,   0}, // #870
  {20,  6,   0}, // #871
  { 1,  5,   0}, // #872
  { 2, 20,   0}, // #873
  { 3, 35,   0}, // #874
  { 4, 61,   0}, // #875
  { 5, 66,   0}, // #876
  { 6, 20,   0}, // #877
  { 7, 46,   0}, // #878
  { 8, 31,   0}, // #879
  { 9, 15,   0}, // #880
  {10, 30,   0}, // #881
  {11, 30,   0}, // #882
  {15,  6,   0}, // #883
  {16,  5,   0}, // #884
  {19,  1,   0}, // #885
  {20, 15,   0}, // #886
  {23,  1,   0}, // #887
  { 1,  5,   0}, // #888
  { 2, 20,   0}, // #889
  { 3, 36,   0}, // #890
  { 4, 61,   0}, // #891
  { 5, 66,   0}, // #892
  { 6, 21,   0}, // #893
  { 7, 46,   0}, // #894
  { 8, 30,   0}, // #895
  { 9, 15,   0}, // #896
  {10, 30,   0}, // #897
  {11, 30,   0}, // #898
  {15,  6,   0}, // #899
  {16,  5,   0}, // #900
  {19,  1,   0}, // #901
  {20, 15,   0}, // #902
  {23,  1,   0}, // #903
  { 1,  6,   0}, // #904
  { 2, 23,   0}, // #905
  { 3, 41,   0}, // #906
  { 4, 68,   0}, // #907
  { 5, 73,   0}, // #908
  { 6, 24,   0}, // #909
  { 7, 51,   0}, // #910
  { 8, 33,   0}, // #911
  { 9, 16,   0}, // #912
  {10, 34,   0}, // #913
  {11, 34,   0}, // #914
  {15,  9,   0}, // #915
  {16,  8,   0}, // #916
  {19,  1,   0}, // #917
  {20, 18,   0}, // #918
  {23,  1,   0}, // #919
  { 2,  9,   0}, // #920
  { 3, 23,   0}, // #921
  { 4, 53,   0}, // #922
  { 5, 54,   0}, // #923
  { 6,  3,   0}, // #924
  { 7, 33,   0}, // #925
  { 8, 20,   0}, // #926
  { 9,  8,   0}, // #927
  {10, 15,   0}, // #928
  {11, 16,   0}, // #929
  {20,  2,   0}, // #930
  { 1,  7,   0}, // #931
  { 2, 26,   0}, // #932
  { 3, 46,   0}, // #933
  { 4, 71,   0}, // #934
  { 5, 79,   0}, // #935
  { 6, 27,   0}, // #936
  { 7, 52,   0}, // #937
  { 8, 32,   0}, // #938
  { 9, 19,   0}, // #939
  {10, 39,   0}, // #940
  {11, 41,   0}, // #941
  {15,  8,   0}, // #942
  {16,  8,   0}, // #943
  {20, 20,   0}, // #944
  { 1,  7,   0}, // #945
  { 2, 26,   0}, // #946
  { 3, 46,   0}, // #947
  { 4, 71,   0}, // #948
  { 5, 79,   0}, // #949
  { 6, 27,   0}, // #950
  { 7, 52,   0}, // #951
  { 8, 32,   0}, // #952
  { 9, 19,   0}, // #953
  {10, 39,   0}, // #954
  {11, 41,   0}, // #955
  {15,  7,   0}, // #956
  {16,  7,   0}, // #957
  {20, 20,   0}, // #958
  { 1,  2,   0}, // #959
  { 2,  9,   0}, // #960
  { 3, 14,   0}, // #961
  { 4, 24,   0}, // #962
  { 5, 24,   0}, // #963
  { 6,  7,   0}, // #964
  { 7, 17,   0}, // #965
  { 8, 12,   0}, // #966
  { 9,  6,   0}, // #967
  {10, 11,   0}, // #968
  {11, 11,   0}, // #969
  {15,  1,   0}, // #970
  {19,  1,   0}, // #971
  {20,  5,   0}, // #972
  {23,  1,   0}, // #973
  { 1,  2,   0}, // #974
  { 2, 12,   0}, // #975
  { 3, 17,   0}, // #976
  { 4, 27,   0}, // #977
  { 5, 32,   0}, // #978
  { 6,  7,   0}, // #979
  { 7, 17,   0}, // #980
  { 8, 12,   0}, // #981
  { 9, 10,   0}, // #982
  {10, 15,   0}, // #983
  {11, 15,   0}, // #984
  {15, 40,   0}, // #985
  {16,  2,   0}, // #986
  {19, 38,   0}, // #987
  {20,  5,   0}, // #988
  {23, 38,   0}, // #989
  { 1,  4,   0}, // #990
  { 2,  4,   0}, // #991
  { 3,  6,   0}, // #992
  { 4, 57,   0}, // #993
  { 5, 57,   0}, // #994
  { 6,  5,   0}, // #995
  { 7,  9,   0}, // #996
  { 8,  8,   0}, // #997
  {10,  1,   0}, // #998
  {11,  1,   0}, // #999
  {13, 33,   0}, // #1000
  {14, 33,   0}, // #1001
  {15, 33,   0}, // #1002
  {16, 33,   0}, // #1003
  {21,  2,   0}, // #1004
  { 1,  8,   0}, // #1005
  { 2, 35,   0}, // #1006
  { 3, 79,   0}, // #1007
  { 4, 142,   0}, // #1008
  { 5, 142,   0}, // #1009
  { 6, 37,   0}, // #1010
  { 7, 100,   0}, // #1011
  { 8, 71,   0}, // #1012
  { 9, 21,   0}, // #1013
  {10, 46,   0}, // #1014
  {11, 46,   0}, // #1015
  {15,  1,   0}, // #1016
  {19,  1,   0}, // #1017
  {20, 10,   0}, // #1018
  {23,  1,   0}, // #1019
  { 1,  1,   0}, // #1020
  { 2,  1,   0}, // #1021
  { 3,  1,   0}, // #1022
  { 4,  2,   0}, // #1023
  { 5,  2,   0}, // #1024
  { 6,  1,   0}, // #1025
  { 7,  1,   0}, // #1026
  { 8,  1,   0}, // #1027
  { 2,  1,   0}, // #1028
  { 3,  1,   0}, // #1029
  { 4,  3,   0}, // #1030
  { 5,  3,   0}, // #1031
  { 7,  2,   0}, // #1032
  { 8,  2,   0}, // #1033
  { 9,  1,   0}, // #1034
  {10,  1,   0}, // #1035
  {11,  1,   0}, // #1036
  { 3,  1,   0}, // #1037
  { 4,  1,   0}, // #1038
  { 5,  1,   0}, // #1039
  { 6,  1,   0}, // #1040
  { 7,  1,   0}, // #1041
  {10,  1,   0}, // #1042
  {11,  1,   0}, // #1043
  {15,  1,   0}, // #1044
  {19,  1,   0}, // #1045
  {20,  1,   0}, // #1046
  {23,  1,   0}, // #1047
  { 5,  2,   0}, // #1048
  {15,  1,   0}, // #1049
  {19,  1,   0}, // #1050
  {23,  1,   0}, // #1051
  { 2,  1,   0}, // #1052
  { 3,  1,   0}, // #1053
  { 4,  2,   0}, // #1054
  { 5,  2,   0}, // #1055
  { 7,  1,   0}, // #1056
  { 8,  1,   0}, // #1057
  { 9,  1,   0}, // #1058
  {10,  1,   0}, // #1059
  {11,  1,   0}, // #1060
  {15,  1,   0}, // #1061
  {19,  1,   0}, // #1062
  {23,  1,   0}, // #1063
  { 1,  5,   0}, // #1064
  { 2, 13,   0}, // #1065
  { 3, 13,   0}, // #1066
  { 4, 13,   0}, // #1067
  { 5, 13,   0}, // #1068
  { 6,  5,   0}, // #1069
  { 7,  5,   0}, // #1070
  { 8,  5,   0}, // #1071
  { 9,  8,   0}, // #1072
  {10,  8,   0}, // #1073
  {11,  8,   0}, // #1074
  {15, 21,   0}, // #1075
  {16, 21,   0}, // #1076
  { 4,  1,   0}, // #1077
  { 5,  1,   0}, // #1078
  { 7,  1,   0}, // #1079
  { 8,  1,   0}, // #1080
  {13,  1,   0}, // #1081
  {14,  1,   0}, // #1082
  {15,  1,   0}, // #1083
  {16,  1,   0}, // #1084
  {21,  1,   0}, // #1085
  { 1,  1,   0}, // #1086
  { 2,  1,   0}, // #1087
  { 3,  1,   0}, // #1088
  { 4,  1,   0}, // #1089
  { 5,  1,   0}, // #1090
  { 6,  1,   0}, // #1091
  { 7,  1,   0}, // #1092
  { 8,  1,   0}, // #1093
  {14,  1,   0}, // #1094
  {15,  1,   0}, // #1095
  {18,  1,   0}, // #1096
  {19,  1,   0}, // #1097
  { 5,  5,   0}, // #1098
  {15,  2,   0}, // #1099
  {16,  2,   0}, // #1100
  { 5,  2,   0}, // #1101
  {15,  2,   0}, // #1102
  {16,  1,   0}, // #1103
  {19,  1,   0}, // #1104
  {23,  1,   0}, // #1105
  { 4,  2,   0}, // #1106
  { 5,  2,   0}, // #1107
  { 7,  1,   0}, // #1108
  { 8,  1,   0}, // #1109
  {13,  1,   0}, // #1110
  {14,  2,   0}, // #1111
  {15,  2,   0}, // #1112
  {16,  1,   0}, // #1113
  {18,  1,   0}, // #1114
  {19,  1,   0}, // #1115
  {21,  1,   0}, // #1116
  { 4,  1,   0}, // #1117
  { 5,  3,   0}, // #1118
  { 7,  1,   0}, // #1119
  { 8,  1,   0}, // #1120
  {15,  2,   0}, // #1121
  {16,  1,   0}, // #1122
  {19,  1,   0}, // #1123
  {23,  1,   0}, // #1124
  { 3,  2,   0}, // #1125
  { 4,  2,   0}, // #1126
  { 5,  2,   0}, // #1127
  { 6,  2,   0}, // #1128
  { 7,  2,   0}, // #1129
  {10,  2,   0}, // #1130
  {11,  2,   0}, // #1131
  {13,  1,   0}, // #1132
  {14,  1,   0}, // #1133
  {15,  1,   0}, // #1134
  {16,  1,   0}, // #1135
  {20,  2,   0}, // #1136
  { 1,  1,   0}, // #1137
  { 2,  1,   0}, // #1138
  { 3,  1,   0}, // #1139
  { 4,  1,   0}, // #1140
  { 5,  1,   0}, // #1141
  { 6,  1,   0}, // #1142
  { 7,  1,   0}, // #1143
  { 8,  1,   0}, // #1144
  {13,  1,   0}, // #1145
  {14,  1,   0}, // #1146
  {15,  1,   0}, // #1147
  {16,  1,   0}, // #1148
  { 1,  1,   0}, // #1149
  { 2,  1,   0}, // #1150
  { 3,  2,   0}, // #1151
  { 4,  2,   0}, // #1152
  { 5,  2,   0}, // #1153
  { 6,  2,   0}, // #1154
  { 7,  2,   0}, // #1155
  { 8,  1,   0}, // #1156
  {10,  1,   0}, // #1157
  {11,  1,   0}, // #1158
  {13,  1,   0}, // #1159
  {14,  1,   0}, // #1160
  {15,  1,   0}, // #1161
  {16,  1,   0}, // #1162
  {20,  1,   0}, // #1163
  { 2,  3,   0}, // #1164
  { 3,  4,   0}, // #1165
  { 4,  7,   0}, // #1166
  { 5, 10,   0}, // #1167
  { 7,  3,   0}, // #1168
  { 8,  3,   0}, // #1169
  { 9,  3,   0}, // #1170
  {10,  3,   0}, // #1171
  {11,  4,   0}, // #1172
  { 4,  2,   0}, // #1173
  { 5,  2,   0}, // #1174
  { 7,  2,   0}, // #1175
  { 8,  2,   0}, // #1176
  {15,  1,   0}, // #1177
  {16,  1,   0}, // #1178
  { 2,  2,   0}, // #1179
  { 3,  3,   0}, // #1180
  { 4,  9,   0}, // #1181
  { 5, 18,   0}, // #1182
  { 6,  1,   0}, // #1183
  { 7,  7,   0}, // #1184
  { 8,  6,   0}, // #1185
  { 9,  2,   0}, // #1186
  {10,  3,   0}, // #1187
  {11,  3,   0}, // #1188
  {20,  1,   0}, // #1189
  { 1,  2,   0}, // #1190
  { 2,  9,   0}, // #1191
  { 3, 14,   0}, // #1192
  { 4, 21,   0}, // #1193
  { 5, 24,   0}, // #1194
  { 6,  4,   0}, // #1195
  { 7, 11,   0}, // #1196
  { 8,  7,   0}, // #1197
  { 9,  7,   0}, // #1198
  {10, 12,   0}, // #1199
  {11, 12,   0}, // #1200
  {15,  1,   0}, // #1201
  {16,  1,   0}, // #1202
  {20,  2,   0}, // #1203
  { 2,  2,   0}, // #1204
  { 3,  2,   0}, // #1205
  { 4,  2,   0}, // #1206
  { 5,  3,   0}, // #1207
  { 9,  2,   0}, // #1208
  {10,  2,   0}, // #1209
  {11,  2,   0}, // #1210
  {15,  2,   0}, // #1211
  {19,  2,   0}, // #1212
  {23,  2,   0}, // #1213
  { 4,  1,   0}, // #1214
  { 5,  1,   0}, // #1215
  { 7,  1,   0}, // #1216
  { 8,  1,   0}, // #1217
  {15,  1,   0}, // #1218
  {19,  1,   0}, // #1219
  {23,  1,   0}, // #1220
  { 2,  5,   0}, // #1221
  { 3,  5,   0}, // #1222
  { 4, 16,   0}, // #1223
  { 5, 23,   0}, // #1224
  { 7, 11,   0}, // #1225
  { 8,  8,   0}, // #1226
  { 9,  5,   0}, // #1227
  {10,  5,   0}, // #1228
  {11,  5,   0}, // #1229
  { 3,  2,   0}, // #1230
  { 4,  2,   0}, // #1231
  { 5,  2,   0}, // #1232
  { 6,  2,   0}, // #1233
  { 7,  2,   0}, // #1234
  {10,  2,   0}, // #1235
  {11,  2,   0}, // #1236
  {15,  1,   0}, // #1237
  {16,  1,   0}, // #1238
  {20,  2,   0}, // #1239
  { 3,  2,   0}, // #1240
  { 4,  2,   0}, // #1241
  { 5,  2,   0}, // #1242
  { 6,  2,   0}, // #1243
  { 7,  2,   0}, // #1244
  {10,  2,   0}, // #1245
  {11,  2,   0}, // #1246
  {20,  2,   0}, // #1247
  { 1,  1,   0}, // #1248
  { 2,  6,   0}, // #1249
  { 3,  8,   0}, // #1250
  { 4, 17,   0}, // #1251
  { 5, 20,   0}, // #1252
  { 6,  2,   0}, // #1253
  { 7, 11,   0}, // #1254
  { 8,  9,   0}, // #1255
  { 9,  5,   0}, // #1256
  {10,  7,   0}, // #1257
  {11,  7,   0}, // #1258
  {15,  2,   0}, // #1259
  {16,  2,   0}, // #1260
  {20,  1,   0}, // #1261
  { 1,  1,   0}, // #1262
  { 2,  4,   0}, // #1263
  { 3,  5,   0}, // #1264
  { 4, 10,   0}, // #1265
  { 5, 10,   0}, // #1266
  { 6,  2,   0}, // #1267
  { 7,  7,   0}, // #1268
  { 8,  6,   0}, // #1269
  { 9,  3,   0}, // #1270
  {10,  4,   0}, // #1271
  {11,  4,   0}, // #1272
  {15,  3,   0}, // #1273
  {16,  3,   0}, // #1274
  {20,  1,   0}, // #1275
  { 2,  8,   0}, // #1276
  { 3, 14,   0}, // #1277
  { 4, 30,   0}, // #1278
  { 5, 54,   0}, // #1279
  { 6,  2,   0}, // #1280
  { 7, 18,   0}, // #1281
  { 8, 14,   0}, // #1282
  { 9,  8,   0}, // #1283
  {10, 10,   0}, // #1284
  {11, 11,   0}, // #1285
  {20,  2,   0}, // #1286
  { 2,  3,   0}, // #1287
  { 3,  3,   0}, // #1288
  { 4,  7,   0}, // #1289
  { 5, 10,   0}, // #1290
  { 7,  4,   0}, // #1291
  { 8,  4,   0}, // #1292
  { 9,  3,   0}, // #1293
  {10,  3,   0}, // #1294
  {11,  3,   0}, // #1295
  { 2,  3,   0}, // #1296
  { 3,  4,   0}, // #1297
  { 4, 10,   0}, // #1298
  { 5, 15,   0}, // #1299
  { 6,  1,   0}, // #1300
  { 7,  7,   0}, // #1301
  { 8,  6,   0}, // #1302
  { 9,  3,   0}, // #1303
  {10,  4,   0}, // #1304
  {11,  4,   0}, // #1305
  {20,  1,   0}, // #1306
  { 2,  1,   0}, // #1307
  { 3,  1,   0}, // #1308
  { 4, 30,   0}, // #1309
  { 5, 30,   0}, // #1310
  { 7,  8,   0}, // #1311
  { 8,  8,   0}, // #1312
  { 9,  1,   0}, // #1313
  {10,  1,   0}, // #1314
  {11,  1,   0}, // #1315
  {13,  1,   0}, // #1316
  {14,  1,   0}, // #1317
  {15,  1,   0}, // #1318
  {16,  1,   0}, // #1319
  {21,  8,   0}, // #1320
  { 2, 35,   0}, // #1321
  { 3, 90,   0}, // #1322
  { 4, 134,   0}, // #1323
  { 5, 134,   0}, // #1324
  { 6, 34,   0}, // #1325
  { 7, 78,   0}, // #1326
  { 8, 44,   0}, // #1327
  { 9, 21,   0}, // #1328
  {10, 51,   0}, // #1329
  {11, 51,   0}, // #1330
  {15,  5,   0}, // #1331
  {16,  4,   0}, // #1332
  {19,  1,   0}, // #1333
  {20,  9,   0}, // #1334
  {23,  1,   0}, // #1335
  { 2, 52,   0}, // #1336
  { 3, 97,   0}, // #1337
  { 4, 150,   0}, // #1338
  { 5, 150,   0}, // #1339
  { 6, 45,   0}, // #1340
  { 7, 98,   0}, // #1341
  { 8, 53,   0}, // #1342
  { 9, 27,   0}, // #1343
  {10, 37,   0}, // #1344
  {11, 37,   0}, // #1345
  {15,  5,   0}, // #1346
  {16,  4,   0}, // #1347
  {19,  1,   0}, // #1348
  {20, 10,   0}, // #1349
  {23,  1,   0}, // #1350
  { 2,  1,   0}, // #1351
  { 3,  4,   0}, // #1352
  { 4, 15,   0}, // #1353
  { 5, 15,   0}, // #1354
  { 6,  2,   0}, // #1355
  { 7,  5,   0}, // #1356
  { 8,  3,   0}, // #1357
  { 9,  1,   0}, // #1358
  {10,  4,   0}, // #1359
  {11,  4,   0}, // #1360
  {13,  1,   0}, // #1361
  {14,  2,   0}, // #1362
  {15,  2,   0}, // #1363
  {16,  1,   0}, // #1364
  {18,  1,   0}, // #1365
  {19,  1,   0}, // #1366
  {20,  2,   0}, // #1367
  {21,  3,   0}, // #1368
  { 1,  2,   0}, // #1369
  { 2,  2,   0}, // #1370
  { 3,  7,   0}, // #1371
  { 4, 56,   0}, // #1372
  { 5, 56,   0}, // #1373
  { 6,  7,   0}, // #1374
  { 7, 17,   0}, // #1375
  { 8, 12,   0}, // #1376
  {13,  8,   0}, // #1377
  {14,  8,   0}, // #1378
  {15,  8,   0}, // #1379
  {16,  8,   0}, // #1380
  { 1,  4,   0}, // #1381
  { 2,  4,   0}, // #1382
  { 3,  6,   0}, // #1383
  { 4, 57,   0}, // #1384
  { 5, 57,   0}, // #1385
  { 6,  5,   0}, // #1386
  { 7, 11,   0}, // #1387
  { 8, 10,   0}, // #1388
  {10,  1,   0}, // #1389
  {11,  1,   0}, // #1390
  {13, 31,   0}, // #1391
  {14, 31,   0}, // #1392
  {15, 31,   0}, // #1393
  {16, 31,   0}, // #1394
  {21,  4,   0}, // #1395
  { 1,  9,   0}, // #1396
  { 2, 10,   0}, // #1397
  { 3, 26,   0}, // #1398
  { 4, 78,   0}, // #1399
  { 5, 78,   0}, // #1400
  { 6, 25,   0}, // #1401
  { 7, 47,   0}, // #1402
  { 8, 31,   0}, // #1403
  { 9,  1,   0}, // #1404
  {10, 17,   0}, // #1405
  {11, 17,   0}, // #1406
  {14, 11,   0}, // #1407
  {15, 11,   0}, // #1408
  {18, 11,   0}, // #1409
  {19, 11,   0}, // #1410
  {20, 16,   0}, // #1411
  {21,  1,   0}, // #1412
  { 1,  1,   0}, // #1413
  { 2,  1,   0}, // #1414
  { 3,  3,   0}, // #1415
  { 4,  3,   0}, // #1416
  { 5,  3,   0}, // #1417
  { 6,  1,   0}, // #1418
  { 7,  1,   0}, // #1419
  { 8,  1,   0}, // #1420
  {10,  1,   0}, // #1421
  {11,  1,   0}, // #1422
  {15,  2,   0}, // #1423
  {16,  2,   0}, // #1424
  { 1,  1,   0}, // #1425
  { 2,  1,   0}, // #1426
  { 3,  4,   0}, // #1427
  { 4,  4,   0}, // #1428
  { 5,  4,   0}, // #1429
  { 6,  1,   0}, // #1430
  { 7,  1,   0}, // #1431
  { 8,  1,   0}, // #1432
  {10,  2,   0}, // #1433
  {11,  2,   0}, // #1434
  {15,  4,   0}, // #1435
  {16,  4,   0}, // #1436
  { 1,  1,   0}, // #1437
  { 2,  1,   0}, // #1438
  { 3,  4,   0}, // #1439
  { 4,  4,   0}, // #1440
  { 5,  4,   0}, // #1441
  { 6,  1,   0}, // #1442
  { 7,  1,   0}, // #1443
  { 8,  1,   0}, // #1444
  {10,  2,   0}, // #1445
  {11,  2,   0}, // #1446
  {15,  8,   0}, // #1447
  {16,  8,   0}, // #1448
  { 4,  2,   0}, // #1449
  { 5,  2,   0}, // #1450
  { 7,  1,   0}, // #1451
  { 8,  1,   0}, // #1452
  {13,  1,   0}, // #1453
  {14,  1,   0}, // #1454
  {15,  1,   0}, // #1455
  {16,  1,   0}, // #1456
  {21,  1,   0}, // #1457
  { 2,  1,   0}, // #1458
  { 3,  1,   0}, // #1459
  { 4,  3,   0}, // #1460
  { 5,  3,   0}, // #1461
  { 7,  2,   0}, // #1462
  { 8,  2,   0}, // #1463
  { 9,  1,   0}, // #1464
  {10,  1,   0}, // #1465
  {11,  1,   0}, // #1466
  {15,  1,   0}, // #1467
  {16,  1,   0}, // #1468
  { 1,  2,   0}, // #1469
  { 2,  2,   0}, // #1470
  { 3,  2,   0}, // #1471
  { 4,  2,   0}, // #1472
  { 5,  2,   0}, // #1473
  { 6,  2,   0}, // #1474
  { 7,  2,   0}, // #1475
  { 8,  2,   0}, // #1476
  {15,  1,   0}, // #1477
  {19,  1,   0}, // #1478
  {23,  1,   0}, // #1479
  { 2,  2,   0}, // #1480
  { 3,  6,   0}, // #1481
  { 4,  7,   0}, // #1482
  { 5,  7,   0}, // #1483
  { 7,  1,   0}, // #1484
  { 8,  1,   0}, // #1485
  {10,  2,   0}, // #1486
  {11,  2,   0}, // #1487
  { 2,  2,   0}, // #1488
  { 3,  6,   0}, // #1489
  { 4,  7,   0}, // #1490
  { 5,  7,   0}, // #1491
  { 7,  1,   0}, // #1492
  { 8,  1,   0}, // #1493
  {10,  2,   0}, // #1494
  {11,  2,   0}, // #1495
  {15,  1,   0}, // #1496
  {16,  1,   0}, // #1497
  { 2,  1,   0}, // #1498
  { 3,  3,   0}, // #1499
  { 4,  3,   0}, // #1500
  { 5,  3,   0}, // #1501
  {10,  1,   0}, // #1502
  {11,  1,   0}, // #1503
  { 2,  1,   0}, // #1504
  { 3,  3,   0}, // #1505
  { 4,  3,   0}, // #1506
  { 5,  3,   0}, // #1507
  {10,  1,   0}, // #1508
  {11,  1,   0}, // #1509
  {15,  1,   0}, // #1510
  {16,  1,   0}, // #1511
  { 4,  1,   0}, // #1512
  { 5,  2,   0}, // #1513
  { 7,  1,   0}, // #1514
  { 8,  1,   0}, // #1515
  {15,  1,   0}, // #1516
  {16,  1,   0}, // #1517
  { 4,  1,   0}, // #1518
  { 5,  5,   0}, // #1519
  { 7,  1,   0}, // #1520
  { 8,  1,   0}, // #1521
  {15,  2,   0}, // #1522
  {16,  1,   0}, // #1523
  {19,  1,   0}, // #1524
  {23,  1,   0}, // #1525
  { 2,  3,   0}, // #1526
  { 3,  6,   0}, // #1527
  { 4,  7,   0}, // #1528
  { 5,  7,   0}, // #1529
  { 6,  1,   0}, // #1530
  { 7,  2,   0}, // #1531
  { 8,  1,   0}, // #1532
  {10,  1,   0}, // #1533
  {11,  1,   0}, // #1534
  {20,  1,   0}, // #1535
  { 2,  3,   0}, // #1536
  { 3,  6,   0}, // #1537
  { 4,  7,   0}, // #1538
  { 5,  7,   0}, // #1539
  { 6,  1,   0}, // #1540
  { 7,  2,   0}, // #1541
  { 8,  1,   0}, // #1542
  {10,  1,   0}, // #1543
  {11,  1,   0}, // #1544
  {15,  1,   0}, // #1545
  {16,  1,   0}, // #1546
  {20,  1,   0}, // #1547
  { 1,  1,   0}, // #1548
  { 2,  4,   0}, // #1549
  { 3,  5,   0}, // #1550
  { 4,  9,   0}, // #1551
  { 5, 13,   0}, // #1552
  { 6,  2,   0}, // #1553
  { 7,  6,   0}, // #1554
  { 8,  5,   0}, // #1555
  { 9,  3,   0}, // #1556
  {10,  4,   0}, // #1557
  {11,  4,   0}, // #1558
  {15,  2,   0}, // #1559
  {16,  2,   0}, // #1560
  {20,  1,   0}, // #1561
  { 1,  1,   0}, // #1562
  { 2,  1,   0}, // #1563
  { 3,  3,   0}, // #1564
  { 4,  3,   0}, // #1565
  { 5,  3,   0}, // #1566
  { 6,  3,   0}, // #1567
  { 7,  3,   0}, // #1568
  { 8,  1,   0}, // #1569
  {10,  2,   0}, // #1570
  {11,  2,   0}, // #1571
  {20,  2,   0}, // #1572
  { 2,  1,   0}, // #1573
  { 3,  3,   0}, // #1574
  { 4,  3,   0}, // #1575
  { 5,  3,   0}, // #1576
  {10,  2,   0}, // #1577
  {11,  2,   0}, // #1578
  { 1,  1,   0}, // #1579
  { 2,  1,   0}, // #1580
  { 3,  3,   0}, // #1581
  { 4,  3,   0}, // #1582
  { 5,  3,   0}, // #1583
  { 6,  3,   0}, // #1584
  { 7,  3,   0}, // #1585
  { 8,  1,   0}, // #1586
  {10,  2,   0}, // #1587
  {11,  2,   0}, // #1588
  {15,  1,   0}, // #1589
  {16,  1,   0}, // #1590
  {20,  2,   0}, // #1591
  { 2,  1,   0}, // #1592
  { 3,  3,   0}, // #1593
  { 4,  3,   0}, // #1594
  { 5,  3,   0}, // #1595
  {10,  2,   0}, // #1596
  {11,  2,   0}, // #1597
  {15,  1,   0}, // #1598
  {16,  1,   0}, // #1599
  { 2, 52,   0}, // #1600
  { 3, 125,   0}, // #1601
  { 4, 178,   0}, // #1602
  { 5, 178,   0}, // #1603
  { 6, 41,   0}, // #1604
  { 7, 94,   0}, // #1605
  { 8, 53,   0}, // #1606
  { 9, 29,   0}, // #1607
  {10, 69,   0}, // #1608
  {11, 69,   0}, // #1609
  {15,  6,   0}, // #1610
  {16,  4,   0}, // #1611
  {19,  2,   0}, // #1612
  {20,  8,   0}, // #1613
  {23,  2,   0}, // #1614
  { 4,  1,   0}, // #1615
  { 5,  1,   0}, // #1616
  {13,  1,   0}, // #1617
  {14,  2,   0}, // #1618
  {15,  2,   0}, // #1619
  {16,  1,   0}, // #1620
  {18,  1,   0}, // #1621
  {19,  1,   0}, // #1622
  { 2,  1,   0}, // #1623
  { 3,  1,   0}, // #1624
  { 4,  3,   0}, // #1625
  { 5,  8,   0}, // #1626
  { 7,  2,   0}, // #1627
  { 8,  2,   0}, // #1628
  { 9,  1,   0}, // #1629
  {10,  1,   0}, // #1630
  {11,  1,   0}, // #1631
  {15,  1,   0}, // #1632
  {16,  1,   0}, // #1633
  { 2,  1,   0}, // #1634
  { 3,  1,   0}, // #1635
  { 4,  3,   0}, // #1636
  { 5,  7,   0}, // #1637
  { 7,  2,   0}, // #1638
  { 8,  2,   0}, // #1639
  { 9,  1,   0}, // #1640
  {10,  1,   0}, // #1641
  {11,  1,   0}, // #1642
  {15,  2,   0}, // #1643
  {16,  1,   0}, // #1644
  {19,  1,   0}, // #1645
  {23,  1,   0}, // #1646
  { 4,  1,   0}, // #1647
  { 5,  2,   0}, // #1648
  { 7,  1,   0}, // #1649
  { 8,  1,   0}, // #1650
  {15,  1,   0}, // #1651
  {19,  1,   0}, // #1652
  {23,  1,   0}, // #1653
  { 2,  1,   0}, // #1654
  { 3,  4,   0}, // #1655
  { 4, 10,   0}, // #1656
  { 5, 10,   0}, // #1657
  { 6,  3,   0}, // #1658
  { 7,  9,   0}, // #1659
  { 8,  6,   0}, // #1660
  { 9,  1,   0}, // #1661
  {10,  4,   0}, // #1662
  {11,  4,   0}, // #1663
  {20,  3,   0}, // #1664
  { 1,  7,   0}, // #1665
  { 2, 26,   0}, // #1666
  { 3, 47,   0}, // #1667
  { 4, 73,   0}, // #1668
  { 5, 80,   0}, // #1669
  { 6, 28,   0}, // #1670
  { 7, 54,   0}, // #1671
  { 8, 33,   0}, // #1672
  { 9, 19,   0}, // #1673
  {10, 40,   0}, // #1674
  {11, 42,   0}, // #1675
  {15,  7,   0}, // #1676
  {16,  7,   0}, // #1677
  {20, 21,   0}, // #1678
  { 1,  7,   0}, // #1679
  { 2, 27,   0}, // #1680
  { 3, 47,   0}, // #1681
  { 4, 73,   0}, // #1682
  { 5, 80,   0}, // #1683
  { 6, 27,   0}, // #1684
  { 7, 53,   0}, // #1685
  { 8, 33,   0}, // #1686
  { 9, 19,   0}, // #1687
  {10, 39,   0}, // #1688
  {11, 42,   0}, // #1689
  {15,  7,   0}, // #1690
  {16,  7,   0}, // #1691
  {20, 20,   0}, // #1692
  { 1,  7,   0}, // #1693
  { 2, 28,   0}, // #1694
  { 3, 48,   0}, // #1695
  { 4, 76,   0}, // #1696
  { 5, 84,   0}, // #1697
  { 6, 27,   0}, // #1698
  { 7, 55,   0}, // #1699
  { 8, 35,   0}, // #1700
  { 9, 21,   0}, // #1701
  {10, 41,   0}, // #1702
  {11, 43,   0}, // #1703
  {15, 10,   0}, // #1704
  {16, 10,   0}, // #1705
  {20, 20,   0}, // #1706
  { 1,  7,   0}, // #1707
  { 2, 28,   0}, // #1708
  { 3, 49,   0}, // #1709
  { 4, 77,   0}, // #1710
  { 5, 88,   0}, // #1711
  { 6, 28,   0}, // #1712
  { 7, 56,   0}, // #1713
  { 8, 35,   0}, // #1714
  { 9, 21,   0}, // #1715
  {10, 42,   0}, // #1716
  {11, 44,   0}, // #1717
  {15, 11,   0}, // #1718
  {16, 11,   0}, // #1719
  {20, 21,   0}, // #1720
  { 1,  7,   0}, // #1721
  { 2, 24,   0}, // #1722
  { 3, 43,   0}, // #1723
  { 4, 67,   0}, // #1724
  { 5, 73,   0}, // #1725
  { 6, 26,   0}, // #1726
  { 7, 50,   0}, // #1727
  { 8, 31,   0}, // #1728
  { 9, 17,   0}, // #1729
  {10, 36,   0}, // #1730
  {11, 36,   0}, // #1731
  {15,  9,   0}, // #1732
  {16,  8,   0}, // #1733
  {19,  1,   0}, // #1734
  {20, 19,   0}, // #1735
  {23,  1,   0}, // #1736
  { 1,  7,   0}, // #1737
  { 2, 24,   0}, // #1738
  { 3, 46,   0}, // #1739
  { 4, 74,   0}, // #1740
  { 5, 79,   0}, // #1741
  { 6, 28,   0}, // #1742
  { 7, 56,   0}, // #1743
  { 8, 34,   0}, // #1744
  { 9, 17,   0}, // #1745
  {10, 38,   0}, // #1746
  {11, 38,   0}, // #1747
  {15, 12,   0}, // #1748
  {16, 11,   0}, // #1749
  {19,  1,   0}, // #1750
  {20, 21,   0}, // #1751
  {23,  1,   0}, // #1752
  { 1,  5,   0}, // #1753
  { 2, 11,   0}, // #1754
  { 3, 18,   0}, // #1755
  { 4, 26,   0}, // #1756
  { 5, 32,   0}, // #1757
  { 6, 12,   0}, // #1758
  { 7, 20,   0}, // #1759
  { 8, 13,   0}, // #1760
  { 9,  6,   0}, // #1761
  {10, 13,   0}, // #1762
  {11, 15,   0}, // #1763
  {15,  5,   0}, // #1764
  {19,  5,   0}, // #1765
  {20,  7,   0}, // #1766
  {23,  5,   0}, // #1767
  { 4,  1,   0}, // #1768
  { 5,  1,   0}, // #1769
  { 7,  1,   0}, // #1770
  { 8,  1,   0}, // #1771
  {21,  1,   0}, // #1772
  { 1,  8,   0}, // #1773
  { 2, 22,   0}, // #1774
  { 3, 23,   0}, // #1775
  { 4, 25,   0}, // #1776
  { 5, 25,   0}, // #1777
  { 6,  9,   0}, // #1778
  { 7, 11,   0}, // #1779
  { 8, 10,   0}, // #1780
  { 9, 14,   0}, // #1781
  {10, 15,   0}, // #1782
  {11, 15,   0}, // #1783
  {15,  3,   0}, // #1784
  {16,  3,   0}, // #1785
  {20,  1,   0}, // #1786
  { 1,  1,   0}, // #1787
  { 2,  6,   0}, // #1788
  { 3,  9,   0}, // #1789
  { 4, 18,   0}, // #1790
  { 5, 20,   0}, // #1791
  { 6,  4,   0}, // #1792
  { 7, 13,   0}, // #1793
  { 8, 10,   0}, // #1794
  { 9,  5,   0}, // #1795
  {10,  6,   0}, // #1796
  {11,  6,   0}, // #1797
  {15,  3,   0}, // #1798
  {16,  3,   0}, // #1799
  {20,  1,   0}, // #1800
  { 1,  1,   0}, // #1801
  { 2,  4,   0}, // #1802
  { 3,  4,   0}, // #1803
  { 4,  8,   0}, // #1804
  { 5, 10,   0}, // #1805
  { 6,  1,   0}, // #1806
  { 7,  5,   0}, // #1807
  { 8,  5,   0}, // #1808
  { 9,  3,   0}, // #1809
  {10,  3,   0}, // #1810
  {11,  3,   0}, // #1811
  {15,  3,   0}, // #1812
  {16,  2,   0}, // #1813
  {19,  1,   0}, // #1814
  {23,  1,   0}, // #1815
  { 2,  3,   0}, // #1816
  { 3,  4,   0}, // #1817
  { 4,  9,   0}, // #1818
  { 5, 10,   0}, // #1819
  { 6,  1,   0}, // #1820
  { 7,  6,   0}, // #1821
  { 8,  5,   0}, // #1822
  { 9,  3,   0}, // #1823
  {10,  3,   0}, // #1824
  {11,  3,   0}, // #1825
  {15,  3,   0}, // #1826
  {16,  2,   0}, // #1827
  {19,  1,   0}, // #1828
  {23,  1,   0}, // #1829
  { 2,  3,   0}, // #1830
  { 3,  3,   0}, // #1831
  { 4,  8,   0}, // #1832
  { 5,  8,   0}, // #1833
  { 7,  5,   0}, // #1834
  { 8,  5,   0}, // #1835
  { 9,  3,   0}, // #1836
  {10,  3,   0}, // #1837
  {11,  3,   0}, // #1838
  {15,  3,   0}, // #1839
  {16,  2,   0}, // #1840
  {19,  1,   0}, // #1841
  {23,  1,   0}, // #1842
  { 2,  3,   0}, // #1843
  { 3,  3,   0}, // #1844
  { 4,  7,   0}, // #1845
  { 5,  8,   0}, // #1846
  { 7,  4,   0}, // #1847
  { 8,  4,   0}, // #1848
  { 9,  3,   0}, // #1849
  {10,  3,   0}, // #1850
  {11,  3,   0}, // #1851
  {15,  2,   0}, // #1852
  {16,  1,   0}, // #1853
  {19,  1,   0}, // #1854
  {23,  1,   0}, // #1855
  { 1,  1,   0}, // #1856
  { 2,  4,   0}, // #1857
  { 3, 12,   0}, // #1858
  { 4, 20,   0}, // #1859
  { 5, 22,   0}, // #1860
  { 6,  8,   0}, // #1861
  { 7, 16,   0}, // #1862
  { 8,  9,   0}, // #1863
  { 9,  3,   0}, // #1864
  {10, 10,   0}, // #1865
  {11, 10,   0}, // #1866
  {15,  3,   0}, // #1867
  {16,  1,   0}, // #1868
  {19,  2,   0}, // #1869
  {20,  7,   0}, // #1870
  {23,  2,   0}, // #1871
  { 2,  1,   0}, // #1872
  { 3,  6,   0}, // #1873
  { 4, 13,   0}, // #1874
  { 5, 18,   0}, // #1875
  { 6,  5,   0}, // #1876
  { 7, 12,   0}, // #1877
  { 8,  7,   0}, // #1878
  { 9,  1,   0}, // #1879
  {10,  6,   0}, // #1880
  {11,  6,   0}, // #1881
  {15,  2,   0}, // #1882
  {19,  2,   0}, // #1883
  {20,  5,   0}, // #1884
  {23,  2,   0}, // #1885
  { 2,  8,   0}, // #1886
  { 3, 22,   0}, // #1887
  { 4, 38,   0}, // #1888
  { 5, 44,   0}, // #1889
  { 6, 12,   0}, // #1890
  { 7, 28,   0}, // #1891
  { 8, 16,   0}, // #1892
  { 9,  7,   0}, // #1893
  {10, 19,   0}, // #1894
  {11, 21,   0}, // #1895
  {15,  2,   0}, // #1896
  {19,  2,   0}, // #1897
  {20, 12,   0}, // #1898
  {23,  2,   0}, // #1899
  { 3,  1,   0}, // #1900
  { 4,  2,   0}, // #1901
  { 5,  3,   0}, // #1902
  { 6,  1,   0}, // #1903
  { 7,  2,   0}, // #1904
  { 8,  1,   0}, // #1905
  {10,  1,   0}, // #1906
  {11,  1,   0}, // #1907
  {20,  1,   0}, // #1908
  { 2,  4,   0}, // #1909
  { 3, 10,   0}, // #1910
  { 4, 18,   0}, // #1911
  { 5, 24,   0}, // #1912
  { 6,  3,   0}, // #1913
  { 7, 11,   0}, // #1914
  { 8,  8,   0}, // #1915
  { 9,  4,   0}, // #1916
  {10,  7,   0}, // #1917
  {11,  9,   0}, // #1918
  {20,  3,   0}, // #1919
  { 1,  6,   0}, // #1920
  { 2, 21,   0}, // #1921
  { 3, 38,   0}, // #1922
  { 4, 66,   0}, // #1923
  { 5, 70,   0}, // #1924
  { 6, 23,   0}, // #1925
  { 7, 51,   0}, // #1926
  { 8, 34,   0}, // #1927
  { 9, 15,   0}, // #1928
  {10, 31,   0}, // #1929
  {11, 31,   0}, // #1930
  {15,  8,   0}, // #1931
  {16,  7,   0}, // #1932
  {19,  1,   0}, // #1933
  {20, 16,   0}, // #1934
  {23,  1,   0}, // #1935
  { 1,  6,   0}, // #1936
  { 2, 21,   0}, // #1937
  { 3, 37,   0}, // #1938
  { 4, 64,   0}, // #1939
  { 5, 70,   0}, // #1940
  { 6, 22,   0}, // #1941
  { 7, 49,   0}, // #1942
  { 8, 33,   0}, // #1943
  { 9, 15,   0}, // #1944
  {10, 31,   0}, // #1945
  {11, 31,   0}, // #1946
  {15,  8,   0}, // #1947
  {16,  7,   0}, // #1948
  {19,  1,   0}, // #1949
  {20, 16,   0}, // #1950
  {23,  1,   0}, // #1951
  { 1,  6,   0}, // #1952
  { 2, 21,   0}, // #1953
  { 3, 40,   0}, // #1954
  { 4, 70,   0}, // #1955
  { 5, 74,   0}, // #1956
  { 6, 25,   0}, // #1957
  { 7, 55,   0}, // #1958
  { 8, 36,   0}, // #1959
  { 9, 15,   0}, // #1960
  {10, 33,   0}, // #1961
  {11, 33,   0}, // #1962
  {15, 10,   0}, // #1963
  {16,  9,   0}, // #1964
  {19,  1,   0}, // #1965
  {20, 18,   0}, // #1966
  {23,  1,   0}, // #1967
  { 1,  6,   0}, // #1968
  { 2, 21,   0}, // #1969
  { 3, 39,   0}, // #1970
  { 4, 68,   0}, // #1971
  { 5, 74,   0}, // #1972
  { 6, 24,   0}, // #1973
  { 7, 53,   0}, // #1974
  { 8, 35,   0}, // #1975
  { 9, 15,   0}, // #1976
  {10, 33,   0}, // #1977
  {11, 33,   0}, // #1978
  {15, 10,   0}, // #1979
  {16,  9,   0}, // #1980
  {19,  1,   0}, // #1981
  {20, 18,   0}, // #1982
  {23,  1,   0}, // #1983
  { 1,  7,   0}, // #1984
  { 2, 23,   0}, // #1985
  { 3, 40,   0}, // #1986
  { 4, 65,   0}, // #1987
  { 5, 71,   0}, // #1988
  { 6, 24,   0}, // #1989
  { 7, 49,   0}, // #1990
  { 8, 32,   0}, // #1991
  { 9, 16,   0}, // #1992
  {10, 33,   0}, // #1993
  {11, 33,   0}, // #1994
  {15,  8,   0}, // #1995
  {16,  7,   0}, // #1996
  {19,  1,   0}, // #1997
  {20, 17,   0}, // #1998
  {23,  1,   0}, // #1999
  { 1,  7,   0}, // #2000
  { 2, 23,   0}, // #2001
  { 3, 43,   0}, // #2002
  { 4, 71,   0}, // #2003
  { 5, 77,   0}, // #2004
  { 6, 27,   0}, // #2005
  { 7, 55,   0}, // #2006
  { 8, 35,   0}, // #2007
  { 9, 16,   0}, // #2008
  {10, 36,   0}, // #2009
  {11, 36,   0}, // #2010
  {15, 11,   0}, // #2011
  {16, 10,   0}, // #2012
  {19,  1,   0}, // #2013
  {20, 20,   0}, // #2014
  {23,  1,   0}, // #2015
  { 4,  2,   0}, // #2016
  { 5,  3,   0}, // #2017
  { 7,  2,   0}, // #2018
  { 8,  2,   0}, // #2019
  {15,  1,   0}, // #2020
  {16,  1,   0}, // #2021
  {21,  2,   0}, // #2022
  { 4,  2,   0}, // #2023
  { 5,  3,   0}, // #2024
  { 7,  2,   0}, // #2025
  { 8,  2,   0}, // #2026
  {21,  2,   0}, // #2027
  { 4,  2,   0}, // #2028
  { 5,  4,   0}, // #2029
  { 7,  2,   0}, // #2030
  { 8,  2,   0}, // #2031
  {21,  2,   0}, // #2032
  { 2,  2,   0}, // #2033
  { 3,  2,   0}, // #2034
  { 4,  7,   0}, // #2035
  { 5,  8,   0}, // #2036
  { 7,  5,   0}, // #2037
  { 8,  5,   0}, // #2038
  { 9,  2,   0}, // #2039
  {10,  2,   0}, // #2040
  {11,  2,   0}, // #2041
  {15,  2,   0}, // #2042
  {16,  1,   0}, // #2043
  {19,  1,   0}, // #2044
  {23,  1,   0}, // #2045
  { 2,  3,   0}, // #2046
  { 3,  3,   0}, // #2047
  { 4,  7,   0}, // #2048
  { 5,  9,   0}, // #2049
  { 7,  4,   0}, // #2050
  { 8,  4,   0}, // #2051
  { 9,  3,   0}, // #2052
  {10,  3,   0}, // #2053
  {11,  3,   0}, // #2054
  {15,  2,   0}, // #2055
  {16,  1,   0}, // #2056
  {19,  1,   0}, // #2057
  {23,  1,   0}, // #2058
  { 1,  2,   0}, // #2059
  { 2,  9,   0}, // #2060
  { 3, 16,   0}, // #2061
  { 4, 24,   0}, // #2062
  { 5, 24,   0}, // #2063
  { 6,  6,   0}, // #2064
  { 7, 14,   0}, // #2065
  { 8,  7,   0}, // #2066
  { 9,  7,   0}, // #2067
  {10, 11,   0}, // #2068
  {11, 11,   0}, // #2069
  {15,  1,   0}, // #2070
  {16,  1,   0}, // #2071
  {20,  4,   0}, // #2072
  { 2,  1,   0}, // #2073
  { 3,  1,   0}, // #2074
  { 4,  3,   0}, // #2075
  { 5,  5,   0}, // #2076
  { 7,  2,   0}, // #2077
  { 8,  2,   0}, // #2078
  { 9,  1,   0}, // #2079
  {10,  1,   0}, // #2080
  {11,  1,   0}, // #2081
  {15,  1,   0}, // #2082
  {19,  1,   0}, // #2083
  {23,  1,   0}, // #2084
  { 3,  1,   0}, // #2085
  { 4,  1,   0}, // #2086
  { 5,  2,   0}, // #2087
  { 6,  1,   0}, // #2088
  { 7,  1,   0}, // #2089
  {10,  1,   0}, // #2090
  {11,  1,   0}, // #2091
  {20,  1,   0}, // #2092
  { 2,  1,   0}, // #2093
  { 3,  1,   0}, // #2094
  { 4,  5,   0}, // #2095
  { 5,  6,   0}, // #2096
  { 7,  4,   0}, // #2097
  { 8,  4,   0}, // #2098
  { 9,  1,   0}, // #2099
  {10,  1,   0}, // #2100
  {11,  1,   0}, // #2101
  { 1,  6,   0}, // #2102
  { 2, 13,   0}, // #2103
  { 3, 13,   0}, // #2104
  { 4, 13,   0}, // #2105
  { 5, 13,   0}, // #2106
  { 6,  6,   0}, // #2107
  { 7,  6,   0}, // #2108
  { 8,  6,   0}, // #2109
  { 9,  7,   0}, // #2110
  {10,  7,   0}, // #2111
  {11,  7,   0}, // #2112
  {15, 18,   0}, // #2113
  {16, 18,   0}, // #2114
  { 1,  6,   0}, // #2115
  { 2, 13,   0}, // #2116
  { 3, 13,   0}, // #2117
  { 4, 13,   0}, // #2118
  { 5, 13,   0}, // #2119
  { 6,  6,   0}, // #2120
  { 7,  6,   0}, // #2121
  { 8,  6,   0}, // #2122
  { 9,  7,   0}, // #2123
  {10,  7,   0}, // #2124
  {11,  7,   0}, // #2125
  {15, 17,   0}, // #2126
  {16, 17,   0}, // #2127
  { 1,  5,   0}, // #2128
  { 2, 13,   0}, // #2129
  { 3, 13,   0}, // #2130
  { 4, 13,   0}, // #2131
  { 5, 13,   0}, // #2132
  { 6,  5,   0}, // #2133
  { 7,  5,   0}, // #2134
  { 8,  5,   0}, // #2135
  { 9,  8,   0}, // #2136
  {10,  8,   0}, // #2137
  {11,  8,   0}, // #2138
  {15, 20,   0}, // #2139
  {16, 20,   0}, // #2140
  { 1,  1,   0}, // #2141
  { 2,  1,   0}, // #2142
  { 3,  1,   0}, // #2143
  { 4,  2,   0}, // #2144
  { 5,  2,   0}, // #2145
  { 6,  1,   0}, // #2146
  { 7,  2,   0}, // #2147
  { 8,  2,   0}, // #2148
  {15,  1,   0}, // #2149
  {16,  1,   0}, // #2150
  { 2,  4,   0}, // #2151
  { 3,  5,   0}, // #2152
  { 4,  6,   0}, // #2153
  { 5,  8,   0}, // #2154
  { 6,  1,   0}, // #2155
  { 7,  2,   0}, // #2156
  { 8,  1,   0}, // #2157
  { 9,  4,   0}, // #2158
  {10,  5,   0}, // #2159
  {11,  5,   0}, // #2160
  {20,  1,   0}, // #2161
  { 1,  1,   0}, // #2162
  { 2, 43,   0}, // #2163
  { 3, 91,   0}, // #2164
  { 4, 143,   0}, // #2165
  { 5, 143,   0}, // #2166
  { 6, 49,   0}, // #2167
  { 7, 101,   0}, // #2168
  { 8, 53,   0}, // #2169
  { 9, 23,   0}, // #2170
  {10, 35,   0}, // #2171
  {11, 35,   0}, // #2172
  {15,  6,   0}, // #2173
  {16,  4,   0}, // #2174
  {19,  2,   0}, // #2175
  {20, 12,   0}, // #2176
  {23,  2,   0}, // #2177
  { 1,  1,   0}, // #2178
  { 2, 43,   0}, // #2179
  { 3, 91,   0}, // #2180
  { 4, 144,   0}, // #2181
  { 5, 144,   0}, // #2182
  { 6, 49,   0}, // #2183
  { 7, 102,   0}, // #2184
  { 8, 54,   0}, // #2185
  { 9, 23,   0}, // #2186
  {10, 35,   0}, // #2187
  {11, 35,   0}, // #2188
  {15,  6,   0}, // #2189
  {16,  4,   0}, // #2190
  {19,  2,   0}, // #2191
  {20, 12,   0}, // #2192
  {23,  2,   0}, // #2193
  { 2, 52,   0}, // #2194
  { 3, 97,   0}, // #2195
  { 4, 149,   0}, // #2196
  { 5, 149,   0}, // #2197
  { 6, 45,   0}, // #2198
  { 7, 97,   0}, // #2199
  { 8, 52,   0}, // #2200
  { 9, 27,   0}, // #2201
  {10, 37,   0}, // #2202
  {11, 37,   0}, // #2203
  {15,  5,   0}, // #2204
  {16,  4,   0}, // #2205
  {19,  1,   0}, // #2206
  {20, 10,   0}, // #2207
  {23,  1,   0}, // #2208
  { 2, 52,   0}, // #2209
  { 3, 123,   0}, // #2210
  { 4, 176,   0}, // #2211
  { 5, 176,   0}, // #2212
  { 6, 41,   0}, // #2213
  { 7, 94,   0}, // #2214
  { 8, 53,   0}, // #2215
  { 9, 29,   0}, // #2216
  {10, 68,   0}, // #2217
  {11, 68,   0}, // #2218
  {15,  6,   0}, // #2219
  {16,  4,   0}, // #2220
  {19,  2,   0}, // #2221
  {20,  9,   0}, // #2222
  {23,  2,   0}, // #2223
  { 1,  1,   0}, // #2224
  { 3,  2,   0}, // #2225
  { 1,  1,   0}, // #2226
  { 3,  1,   0}, // #2227
  { 1,  6,   0}, // #2228
  { 2,  6,   0}, // #2229
  { 3, 12,   0}, // #2230
  { 1,  5,   0}, // #2231
  { 2,  5,   0}, // #2232
  { 3, 10,   0}, // #2233
  { 1, 16,   0}, // #2234
  { 2, 16,   0}, // #2235
  { 3, 32,   0}, // #2236
  { 3, 15,   0}, // #2237
  { 1, 10,   0}, // #2238
  { 2, 10,   0}, // #2239
  { 3, 20,   0}, // #2240
  { 1,  9,   0}, // #2241
  { 2,  9,   0}, // #2242
  { 3, 18,   0}, // #2243
  { 1,  5,   0}, // #2244
  { 3,  5,   0}, // #2245
  { 1,  7,   0}, // #2246
  { 2,  7,   0}, // #2247
  { 3, 14,   0}, // #2248
  { 1,  8,   0}, // #2249
  { 2,  8,   0}, // #2250
  { 3, 16,   0}, // #2251
  { 1, 12,   0}, // #2252
  { 2, 12,   0}, // #2253
  { 3, 24,   0}, // #2254
  { 1, 11,   0}, // #2255
  { 2, 11,   0}, // #2256
  { 3, 22,   0}, // #2257
  { 1, 50,   0}, // #2258
  { 2, 50,   0}, // #2259
  { 3, 100,   0}, // #2260
  { 1, 130,   0}, // #2261
  { 2, 130,   0}, // #2262
  { 3, 260,   0}, // #2263
  { 1, 68,   0}, // #2264
  { 2, 68,   0}, // #2265
  { 3, 136,   0}, // #2266
  { 1, 125,   0}, // #2267
  { 2, 125,   0}, // #2268
  { 3, 250,   0}, // #2269
  { 1, 70,   0}, // #2270
  { 2, 70,   0}, // #2271
  { 3, 140,   0}, // #2272
  { 1, 34,   0}, // #2273
  { 2, 34,   0}, // #2274
  { 3, 68,   0}, // #2275
  { 1, 62,   0}, // #2276
  { 2, 62,   0}, // #2277
  { 3, 124,   0}, // #2278
  { 1,  2,   0}, // #2279
  { 3,  2,   0}, // #2280
  { 1, 14,   0}, // #2281
  { 2, 14,   0}, // #2282
  { 3, 28,   0}, // #2283
  { 1,  3,   0}, // #2284
  { 3,  3,   0}, // #2285
  { 1,  4,   0}, // #2286
  { 2,  4,   0}, // #2287
  { 3,  8,   0}, // #2288
  { 1,  3,   0}, // #2289
  { 2,  3,   0}, // #2290
  { 3,  6,   0}, // #2291
  { 1,  2,   0}, // #2292
  { 2,  2,   0}, // #2293
  { 3,  4,   0}, // #2294
  { 1,  4,   0}, // #2295
  { 3,  4,   0}, // #2296
  { 1, 71,   0}, // #2297
  { 3, 71,   0}, // #2298
  { 1, 15,   0}, // #2299
  { 2, 15,   0}, // #2300
  { 3, 30,   0}, // #2301
  { 3, 21,   0}, // #2302
  { 3, 25,   0}, // #2303
  { 3, 29,   0}, // #2304
  { 3, 45,   0}, // #2305
  { 3, 55,   0}, // #2306
  { 3, 59,   0}, // #2307
  { 3, 63,   0}, // #2308
  { 3, 72,   0}, // #2309
  { 3, 74,   0}, // #2310
  { 3, 77,   0}, // #2311
  { 3, 78,   0}, // #2312
  { 3, 92,   0}, // #2313
  { 3, 94,   0}, // #2314
  { 3, 99,   0}, // #2315
  { 3, 121,   0}, // #2316
  { 3, 127,   0}, // #2317
  { 3, 130,   0}, // #2318
  { 3, 141,   0}, // #2319
  { 3, 146,   0}, // #2320
  { 3, 147,   0}, // #2321
  { 3, 168,   0}, // #2322
  { 3, 174,   0}, // #2323
  { 3, 183,   0}, // #2324
  { 3, 202,   0}, // #2325
  { 9,  6,   0}, // #2326
  {10,  2,   0}, // #2327
  { 4,  1,   0}, // #2328
  { 6,  1,   0}, // #2329
  { 5,  2,   0}, // #2330
  { 6,  2,   0}, // #2331
  {10,  1,   0}, // #2332
  { 5,  1,   0}, // #2333
  { 6,  1,   0}, // #2334
  {10,  1,   0}, // #2335
  { 4,  5,   0}, // #2336
  { 6,  5,   0}, // #2337
  {10,  1,   0}, // #2338
  { 4,  4,   0}, // #2339
  { 6,  4,   0}, // #2340
  {10,  1,   0}, // #2341
  { 4,  1,   0}, // #2342
  { 6,  1,   0}, // #2343
  {10,  1,   0}, // #2344
  { 7, 10,   0}, // #2345
  { 8, 10,   0}, // #2346
  { 9, 20,   0}, // #2347
  {10,  1,   0}, // #2348
  { 7,  1,   0}, // #2349
  { 8,  1,   0}, // #2350
  { 9,  2,   0}, // #2351
  {10,  1,   0}, // #2352
  { 7,  1,   0}, // #2353
  { 8,  1,   0}, // #2354
  { 9,  2,   0}, // #2355
  {10,  2,   0}, // #2356
  { 4,  2,   0}, // #2357
  { 6,  2,   0}, // #2358
  {10,  1,   0}, // #2359
  { 1, 25,   0}, // #2360
  { 9,  1,   0}, // #2361
  {10,  1,   0}, // #2362
  { 2, 69,   0}, // #2363
  { 4,  1,   0}, // #2364
  { 6,  1,   0}, // #2365
  {10,  1,   0}, // #2366
  { 2, 39,   0}, // #2367
  { 4,  1,   0}, // #2368
  { 6,  1,   0}, // #2369
  {10,  1,   0}, // #2370
  { 2, 17,   0}, // #2371
  { 4,  1,   0}, // #2372
  { 6,  1,   0}, // #2373
  {10,  1,   0}, // #2374
  { 2, 32,   0}, // #2375
  { 4,  1,   0}, // #2376
  { 6,  1,   0}, // #2377
  {10,  1,   0}, // #2378
  { 5,  8,   0}, // #2379
  { 6,  8,   0}, // #2380
  {10,  1,   0}, // #2381
  { 5, 12,   0}, // #2382
  { 6, 12,   0}, // #2383
  {10,  1,   0}, // #2384
  { 4,  1,   0}, // #2385
  { 6,  1,   0}, // #2386
  {10,  2,   0}, // #2387
  { 6, 10,   0}, // #2388
  { 5,  6,   0}, // #2389
  { 6,  6,   0}, // #2390
  {10,  1,   0}, // #2391
  { 8,  5,   0}, // #2392
  { 9,  5,   0}, // #2393
  {10,  1,   0}, // #2394
  { 8,  4,   0}, // #2395
  { 9,  4,   0}, // #2396
  {10,  1,   0}, // #2397
  { 8,  7,   0}, // #2398
  { 9,  7,   0}, // #2399
  {10,  1,   0}, // #2400
  { 8,  2,   0}, // #2401
  { 9,  2,   0}, // #2402
  {10,  1,   0}, // #2403
  { 7,  1,   0}, // #2404
  { 9,  1,   0}, // #2405
  {10,  1,   0}, // #2406
  { 3,  4,   0}, // #2407
  { 4,  1,   0}, // #2408
  { 6,  1,   0}, // #2409
  {10,  1,   0}, // #2410
  { 3,  2,   0}, // #2411
  { 4,  1,   0}, // #2412
  { 6,  1,   0}, // #2413
  {10,  1,   0}, // #2414
  { 4, 10,   0}, // #2415
  { 6, 10,   0}, // #2416
  {10,  1,   0}, // #2417
  { 4, 21,   0}, // #2418
  { 6, 21,   0}, // #2419
  {10,  1,   0}, // #2420
  { 4, 17,   0}, // #2421
  { 6, 17,   0}, // #2422
  {10,  1,   0}, // #2423
  { 4, 13,   0}, // #2424
  { 6, 13,   0}, // #2425
  {10,  1,   0}, // #2426
  { 4, 11,   0}, // #2427
  { 6, 11,   0}, // #2428
  {10,  1,   0}, // #2429
  { 7,  2,   0}, // #2430
  { 9,  2,   0}, // #2431
  {10,  1,   0}, // #2432
  { 4,  8,   0}, // #2433
  { 6,  8,   0}, // #2434
  {10,  1,   0}, // #2435
  { 2, 70,   0}, // #2436
  { 4,  1,   0}, // #2437
  { 6,  1,   0}, // #2438
  {10,  1,   0}, // #2439
  { 2, 40,   0}, // #2440
  { 4,  1,   0}, // #2441
  { 6,  1,   0}, // #2442
  {10,  1,   0}, // #2443
  { 2, 35,   0}, // #2444
  { 4,  1,   0}, // #2445
  { 6,  1,   0}, // #2446
  {10,  1,   0}, // #2447
  { 2, 20,   0}, // #2448
  { 4,  1,   0}, // #2449
  { 6,  1,   0}, // #2450
  {10,  1,   0}, // #2451
  { 5,  2,   0}, // #2452
  { 8,  2,   0}, // #2453
  {11,  1,   0}, // #2454
  {14,  1,   0}, // #2455
  {20,  1,   0}, // #2456
  { 2,  1,   0}, // #2457
  { 5,  1,   0}, // #2458
  { 7,  1,   0}, // #2459
  { 8,  1,   0}, // #2460
  { 1,  2,   0}, // #2461
  { 5, 44,   0}, // #2462
  { 7, 44,   0}, // #2463
  { 8, 44,   0}, // #2464
  {22,  1,   0}, // #2465
  {24,  1,   0}, // #2466
  { 1,  3,   0}, // #2467
  { 2,  1,   0}, // #2468
  { 5,  1,   0}, // #2469
  { 7,  1,   0}, // #2470
  { 8,  1,   0}, // #2471
  {22,  3,   0}, // #2472
  { 5,  1,   0}, // #2473
  { 8,  1,   0}, // #2474
  { 1,  1,   0}, // #2475
  {24,  1,   0}, // #2476
  { 5,  6,   0}, // #2477
  { 8,  6,   0}, // #2478
  { 1,  1,   0}, // #2479
  {13,  1,   0}, // #2480
  {14,  3,   0}, // #2481
  {20,  3,   0}, // #2482
  {24,  1,   0}, // #2483
  { 1,  3,   0}, // #2484
  {10,  3,   0}, // #2485
  {14,  1,   0}, // #2486
  {19,  1,   0}, // #2487
  {22,  3,   0}, // #2488
  { 1,  1,   0}, // #2489
  {13,  2,   0}, // #2490
  {14, 36,   0}, // #2491
  {20, 36,   0}, // #2492
  {24,  1,   0}, // #2493
  { 1,  4,   0}, // #2494
  { 5,  2,   0}, // #2495
  { 8,  2,   0}, // #2496
  {22,  3,   0}, // #2497
  {24,  1,   0}, // #2498
  {10,  4,   0}, // #2499
  {14,  1,   0}, // #2500
  {16,  1,   0}, // #2501
  {19,  1,   0}, // #2502
  { 1,  3,   0}, // #2503
  { 5,  2,   0}, // #2504
  { 8,  2,   0}, // #2505
  {22,  3,   0}, // #2506
  { 1,  3,   0}, // #2507
  {10,  1,   0}, // #2508
  {14,  1,   0}, // #2509
  {15,  1,   0}, // #2510
  {19,  1,   0}, // #2511
  {22,  3,   0}, // #2512
  { 1,  3,   0}, // #2513
  {12,  1,   0}, // #2514
  {14,  1,   0}, // #2515
  {15,  1,   0}, // #2516
  {19,  1,   0}, // #2517
  {22,  3,   0}, // #2518
  { 1,  3,   0}, // #2519
  {11,  1,   0}, // #2520
  {14,  1,   0}, // #2521
  {20,  1,   0}, // #2522
  {22,  3,   0}, // #2523
  { 1,  3,   0}, // #2524
  {14,  1,   0}, // #2525
  {16,  1,   0}, // #2526
  {19,  1,   0}, // #2527
  {21,  1,   0}, // #2528
  {22,  3,   0}, // #2529
  { 1,  3,   0}, // #2530
  { 5,  6,   0}, // #2531
  { 8,  6,   0}, // #2532
  {22,  3,   0}, // #2533
  { 1,  3,   0}, // #2534
  { 5,  8,   0}, // #2535
  { 8,  8,   0}, // #2536
  {22,  3,   0}, // #2537
  { 1,  2,   0}, // #2538
  { 5,  7,   0}, // #2539
  { 8,  7,   0}, // #2540
  {22,  2,   0}, // #2541
  { 1,  1,   0}, // #2542
  { 5, 42,   0}, // #2543
  { 8, 42,   0}, // #2544
  {22,  1,   0}, // #2545
  { 1,  1,   0}, // #2546
  { 5, 44,   0}, // #2547
  { 8, 44,   0}, // #2548
  {22,  1,   0}, // #2549
  { 1,  3,   0}, // #2550
  { 5,  1,   0}, // #2551
  { 8,  1,   0}, // #2552
  {22,  3,   0}, // #2553
  { 1,  2,   0}, // #2554
  {22,  2,   0}, // #2555
  { 5,  3,   0}, // #2556
  { 7,  3,   0}, // #2557
  { 8,  3,   0}, // #2558
  { 1,  3,   0}, // #2559
  { 5,  1,   0}, // #2560
  { 6,  1,   0}, // #2561
  { 8,  1,   0}, // #2562
  {10,  1,   0}, // #2563
  {14,  1,   0}, // #2564
  {15,  1,   0}, // #2565
  {19,  1,   0}, // #2566
  {22,  3,   0}, // #2567
  { 1,  3,   0}, // #2568
  { 5,  4,   0}, // #2569
  { 8,  4,   0}, // #2570
  {22,  3,   0}, // #2571
  { 1,  3,   0}, // #2572
  { 9,  1,   0}, // #2573
  {13,  1,   0}, // #2574
  {14,  1,   0}, // #2575
  {15,  1,   0}, // #2576
  {19,  1,   0}, // #2577
  {22,  3,   0}, // #2578
  { 1,  3,   0}, // #2579
  { 5,  1,   0}, // #2580
  { 6,  1,   0}, // #2581
  { 8,  1,   0}, // #2582
  { 9,  1,   0}, // #2583
  {10,  1,   0}, // #2584
  {13,  1,   0}, // #2585
  {14,  1,   0}, // #2586
  {15,  1,   0}, // #2587
  {19,  1,   0}, // #2588
  {22,  3,   0}, // #2589
  { 1,  3,   0}, // #2590
  { 9,  2,   0}, // #2591
  {13,  1,   0}, // #2592
  {14,  1,   0}, // #2593
  {15,  1,   0}, // #2594
  {19,  1,   0}, // #2595
  {22,  3,   0}, // #2596
  { 1,  3,   0}, // #2597
  { 4, 15,   0}, // #2598
  { 5,  1,   0}, // #2599
  { 7,  1,   0}, // #2600
  { 8,  1,   0}, // #2601
  {22,  3,   0}, // #2602
  { 1,  3,   0}, // #2603
  { 4, 14,   0}, // #2604
  { 5,  1,   0}, // #2605
  { 7,  1,   0}, // #2606
  { 8,  1,   0}, // #2607
  {22,  3,   0}, // #2608
  { 1,  3,   0}, // #2609
  { 4, 12,   0}, // #2610
  { 5,  1,   0}, // #2611
  { 7,  1,   0}, // #2612
  { 8,  1,   0}, // #2613
  {22,  3,   0}, // #2614
  { 1,  3,   0}, // #2615
  {10,  9,   0}, // #2616
  {14,  1,   0}, // #2617
  {16,  1,   0}, // #2618
  {19,  1,   0}, // #2619
  {22,  3,   0}, // #2620
  { 1,  3,   0}, // #2621
  {10, 10,   0}, // #2622
  {14,  1,   0}, // #2623
  {16,  1,   0}, // #2624
  {19,  1,   0}, // #2625
  {22,  3,   0}, // #2626
  { 1,  3,   0}, // #2627
  {10, 14,   0}, // #2628
  {14,  1,   0}, // #2629
  {16,  1,   0}, // #2630
  {19,  1,   0}, // #2631
  {22,  3,   0}, // #2632
  { 1,  1,   0}, // #2633
  {13,  1,   0}, // #2634
  {14,  2,   0}, // #2635
  {16,  2,   0}, // #2636
  {19,  2,   0}, // #2637
  {24,  1,   0}, // #2638
  { 5,  1,   0}, // #2639
  { 6,  1,   0}, // #2640
  { 8,  1,   0}, // #2641
  {10,  3,   0}, // #2642
  {14,  1,   0}, // #2643
  {15,  1,   0}, // #2644
  {19,  1,   0}, // #2645
  {10,  1,   0}, // #2646
  {14,  1,   0}, // #2647
  {19,  1,   0}, // #2648
  {13,  1,   0}, // #2649
  {14,  1,   0}, // #2650
  {16,  1,   0}, // #2651
  {19,  1,   0}, // #2652
  { 1,  3,   0}, // #2653
  {10,  5,   0}, // #2654
  {14,  1,   0}, // #2655
  {15,  1,   0}, // #2656
  {19,  1,   0}, // #2657
  {22,  3,   0}, // #2658
  { 1,  3,   0}, // #2659
  { 4, 17,   0}, // #2660
  { 5,  1,   0}, // #2661
  { 7,  1,   0}, // #2662
  { 8,  1,   0}, // #2663
  {22,  3,   0}, // #2664
  { 1,  3,   0}, // #2665
  { 4, 25,   0}, // #2666
  { 5,  1,   0}, // #2667
  { 7,  1,   0}, // #2668
  { 8,  1,   0}, // #2669
  {22,  3,   0}, // #2670
  { 1,  3,   0}, // #2671
  { 5,  1,   0}, // #2672
  { 7,  1,   0}, // #2673
  { 8,  1,   0}, // #2674
  {22,  3,   0}, // #2675
  {23,  5,   0}, // #2676
  { 5,  1,   0}, // #2677
  { 7,  1,   0}, // #2678
  { 8,  1,   0}, // #2679
  {23,  5,   0}, // #2680
  { 1,  3,   0}, // #2681
  { 5,  1,   0}, // #2682
  { 7,  1,   0}, // #2683
  { 8,  1,   0}, // #2684
  {22,  3,   0}, // #2685
  {23,  2,   0}, // #2686
  { 5,  1,   0}, // #2687
  { 7,  1,   0}, // #2688
  { 8,  1,   0}, // #2689
  {23,  2,   0}, // #2690
  { 1,  3,   0}, // #2691
  { 5,  1,   0}, // #2692
  { 7,  1,   0}, // #2693
  { 8,  1,   0}, // #2694
  {22,  3,   0}, // #2695
  {23,  4,   0}, // #2696
  { 5,  1,   0}, // #2697
  { 7,  1,   0}, // #2698
  { 8,  1,   0}, // #2699
  {23,  4,   0}, // #2700
  { 1,  3,   0}, // #2701
  { 5,  1,   0}, // #2702
  { 7,  1,   0}, // #2703
  { 8,  1,   0}, // #2704
  {22,  3,   0}, // #2705
  {23,  6,   0}, // #2706
  { 5,  1,   0}, // #2707
  { 7,  1,   0}, // #2708
  { 8,  1,   0}, // #2709
  {23,  6,   0}, // #2710
  { 1,  3,   0}, // #2711
  {10,  2,   0}, // #2712
  {14,  1,   0}, // #2713
  {19,  1,   0}, // #2714
  {22,  3,   0}, // #2715
  { 1,  3,   0}, // #2716
  {11,  3,   0}, // #2717
  {14,  1,   0}, // #2718
  {19,  1,   0}, // #2719
  {22,  3,   0}, // #2720
  { 1,  1,   0}, // #2721
  {22,  1,   0}, // #2722
  { 1,  3,   0}, // #2723
  { 5,  2,   0}, // #2724
  { 6,  2,   0}, // #2725
  { 8,  2,   0}, // #2726
  {22,  3,   0}, // #2727
  {11,  2,   0}, // #2728
  {14,  1,   0}, // #2729
  {19,  1,   0}, // #2730
  { 1,  1,   0}, // #2731
  {13,  1,   0}, // #2732
  {14,  1,   0}, // #2733
  {16,  1,   0}, // #2734
  {19,  1,   0}, // #2735
  {24,  1,   0}, // #2736
  {11,  1,   0}, // #2737
  {14,  1,   0}, // #2738
  {19,  1,   0}, // #2739
  { 1,  3,   0}, // #2740
  {11,  4,   0}, // #2741
  {14,  1,   0}, // #2742
  {19,  1,   0}, // #2743
  {22,  3,   0}, // #2744
  { 1,  3,   0}, // #2745
  {11,  2,   0}, // #2746
  {14,  1,   0}, // #2747
  {19,  1,   0}, // #2748
  {22,  3,   0}, // #2749
  { 1,  3,   0}, // #2750
  {12,  4,   0}, // #2751
  {14,  1,   0}, // #2752
  {15,  1,   0}, // #2753
  {19,  1,   0}, // #2754
  {22,  3,   0}, // #2755
  { 1,  3,   0}, // #2756
  {10,  1,   0}, // #2757
  {14,  1,   0}, // #2758
  {16,  1,   0}, // #2759
  {19,  1,   0}, // #2760
  {22,  3,   0}, // #2761
  { 1,  3,   0}, // #2762
  {12,  7,   0}, // #2763
  {14,  1,   0}, // #2764
  {15,  1,   0}, // #2765
  {19,  1,   0}, // #2766
  {22,  3,   0}, // #2767
  { 1, 23,   0}, // #2768
  { 5,  1,   0}, // #2769
  { 6,  1,   0}, // #2770
  { 8,  1,   0}, // #2771
  {10,  1,   0}, // #2772
  {11, 10,   0}, // #2773
  {14,  1,   0}, // #2774
  {16,  1,   0}, // #2775
  {19,  1,   0}, // #2776
  {22, 13,   0}, // #2777
  {24, 10,   0}, // #2778
  { 1, 20,   0}, // #2779
  { 5,  1,   0}, // #2780
  { 6,  1,   0}, // #2781
  { 8,  1,   0}, // #2782
  {10,  1,   0}, // #2783
  {11, 10,   0}, // #2784
  {14,  1,   0}, // #2785
  {16,  1,   0}, // #2786
  {19,  1,   0}, // #2787
  {22, 10,   0}, // #2788
  {24, 10,   0}, // #2789
  { 1,  3,   0}, // #2790
  { 5,  1,   0}, // #2791
  { 6,  1,   0}, // #2792
  { 8,  1,   0}, // #2793
  {10,  6,   0}, // #2794
  {14,  1,   0}, // #2795
  {16,  1,   0}, // #2796
  {19,  1,   0}, // #2797
  {22,  3,   0}, // #2798
  { 1,  3,   0}, // #2799
  { 5,  1,   0}, // #2800
  { 6,  1,   0}, // #2801
  { 8,  1,   0}, // #2802
  {10,  8,   0}, // #2803
  {14,  1,   0}, // #2804
  {16,  1,   0}, // #2805
  {19,  1,   0}, // #2806
  {22,  3,   0}, // #2807
  { 1,  3,   0}, // #2808
  {11,  1,   0}, // #2809
  {14,  1,   0}, // #2810
  {15,  1,   0}, // #2811
  {19,  1,   0}, // #2812
  {22,  3,   0}, // #2813
  { 1,  3,   0}, // #2814
  {11,  1,   0}, // #2815
  {12,  2,   0}, // #2816
  {14,  3,   0}, // #2817
  {15,  2,   0}, // #2818
  {19,  3,   0}, // #2819
  {22,  3,   0}, // #2820
  { 1,  3,   0}, // #2821
  {22,  2,   0}, // #2822
  {24,  1,   0}, // #2823
  { 1,  4,   0}, // #2824
  { 5,  1,   0}, // #2825
  { 8,  1,   0}, // #2826
  {22,  3,   0}, // #2827
  {24,  1,   0}, // #2828
  { 1,  3,   0}, // #2829
  {13,  1,   0}, // #2830
  {14,  1,   0}, // #2831
  {16,  1,   0}, // #2832
  {19,  1,   0}, // #2833
  {22,  3,   0}, // #2834
  { 1,  3,   0}, // #2835
  {10,  2,   0}, // #2836
  {14,  1,   0}, // #2837
  {16,  1,   0}, // #2838
  {19,  1,   0}, // #2839
  {22,  3,   0}, // #2840
  { 1,  1,   0}, // #2841
  { 5,  1,   0}, // #2842
  { 8,  1,   0}, // #2843
  {24,  1,   0}, // #2844
  { 1,  1,   0}, // #2845
  { 5, 22,   0}, // #2846
  { 8, 22,   0}, // #2847
  {22,  1,   0}, // #2848
  {10, 18,   0}, // #2849
  {14,  1,   0}, // #2850
  {16,  1,   0}, // #2851
  {19,  1,   0}, // #2852
  { 1, 18,   0}, // #2853
  {24, 18,   0}, // #2854
  { 1,  3,   0}, // #2855
  {10,  3,   0}, // #2856
  {14,  1,   0}, // #2857
  {22,  3,   0}, // #2858
  { 1,  3,   0}, // #2859
  {10,  2,   0}, // #2860
  {14,  1,   0}, // #2861
  {15,  1,   0}, // #2862
  {19,  1,   0}, // #2863
  {22,  3,   0}, // #2864
  { 1,  3,   0}, // #2865
  {14,  2,   0}, // #2866
  {16,  2,   0}, // #2867
  {19,  2,   0}, // #2868
  {21,  2,   0}, // #2869
  {22,  3,   0}, // #2870
  { 1,  3,   0}, // #2871
  {11,  2,   0}, // #2872
  {14,  2,   0}, // #2873
  {20,  2,   0}, // #2874
  {22,  3,   0}, // #2875
  { 1,  3,   0}, // #2876
  {11,  1,   0}, // #2877
  {14,  1,   0}, // #2878
  {19,  1,   0}, // #2879
  {22,  3,   0}, // #2880
  { 1,  3,   0}, // #2881
  { 9,  2,   0}, // #2882
  {10,  1,   0}, // #2883
  {13,  1,   0}, // #2884
  {14,  1,   0}, // #2885
  {15,  1,   0}, // #2886
  {19,  1,   0}, // #2887
  {22,  3,   0}, // #2888
  { 1,  1,   0}, // #2889
  { 9,  2,   0}, // #2890
  {10,  1,   0}, // #2891
  {13,  1,   0}, // #2892
  {14,  1,   0}, // #2893
  {15,  1,   0}, // #2894
  {19,  1,   0}, // #2895
  {24,  1,   0}, // #2896
  { 1,  1,   0}, // #2897
  { 9,  2,   0}, // #2898
  {13,  1,   0}, // #2899
  {14,  1,   0}, // #2900
  {15,  1,   0}, // #2901
  {19,  1,   0}, // #2902
  {24,  1,   0}, // #2903
  { 1,  3,   0}, // #2904
  {10, 18,   0}, // #2905
  {14,  2,   0}, // #2906
  {16,  2,   0}, // #2907
  {19,  2,   0}, // #2908
  {22,  3,   0}, // #2909
  { 1,  3,   0}, // #2910
  {10, 25,   0}, // #2911
  {14,  2,   0}, // #2912
  {16,  2,   0}, // #2913
  {19,  2,   0}, // #2914
  {22,  3,   0}, // #2915
  { 1,  3,   0}, // #2916
  {13,  1,   0}, // #2917
  {14,  2,   0}, // #2918
  {16,  2,   0}, // #2919
  {19,  2,   0}, // #2920
  {22,  3,   0}, // #2921
  { 1,  3,   0}, // #2922
  {10,  8,   0}, // #2923
  {14,  1,   0}, // #2924
  {15,  1,   0}, // #2925
  {19,  1,   0}, // #2926
  {22,  3,   0}, // #2927
  { 1,  3,   0}, // #2928
  {11,  3,   0}, // #2929
  {14,  2,   0}, // #2930
  {19,  2,   0}, // #2931
  {22,  3,   0}, // #2932
  { 1,  2,   0}, // #2933
  {10, 376,   0}, // #2934
  {14,  2,   0}, // #2935
  {19,  2,   0}, // #2936
  {24,  2,   0}, // #2937
  { 1,  3,   0}, // #2938
  {10,  4,   0}, // #2939
  {14,  2,   0}, // #2940
  {19,  2,   0}, // #2941
  {22,  3,   0}, // #2942
  { 1,  1,   0}, // #2943
  {10, 188,   0}, // #2944
  {14,  1,   0}, // #2945
  {19,  1,   0}, // #2946
  {24,  1,   0}, // #2947
  { 1,  3,   0}, // #2948
  {10,  4,   0}, // #2949
  {14,  1,   0}, // #2950
  {19,  1,   0}, // #2951
  {22,  3,   0}, // #2952
  {10,  2,   0}, // #2953
  {14,  2,   0}, // #2954
  {19,  2,   0}, // #2955
  { 1,  2,   0}, // #2956
  {13,  2,   0}, // #2957
  {14, 36,   0}, // #2958
  {20, 36,   0}, // #2959
  {24,  2,   0}, // #2960
  {11,  2,   0}, // #2961
  {14,  2,   0}, // #2962
  {19,  2,   0}, // #2963
  { 1,  3,   0}, // #2964
  {11,  4,   0}, // #2965
  {14,  2,   0}, // #2966
  {19,  2,   0}, // #2967
  {22,  3,   0}, // #2968
  { 1,  2,   0}, // #2969
  {13,  2,   0}, // #2970
  {14,  2,   0}, // #2971
  {16,  2,   0}, // #2972
  {19,  2,   0}, // #2973
  {24,  2,   0}, // #2974
  { 1,  3,   0}, // #2975
  { 5,  1,   0}, // #2976
  { 6,  1,   0}, // #2977
  { 8,  1,   0}, // #2978
  {10,  4,   0}, // #2979
  {14,  2,   0}, // #2980
  {19,  2,   0}, // #2981
  {22,  3,   0}, // #2982
  { 1,  3,   0}, // #2983
  {10,  1,   0}, // #2984
  {14,  2,   0}, // #2985
  {16,  2,   0}, // #2986
  {19,  2,   0}, // #2987
  {22,  3,   0}, // #2988
  { 1,  3,   0}, // #2989
  {10,  2,   0}, // #2990
  {14,  2,   0}, // #2991
  {16,  2,   0}, // #2992
  {19,  2,   0}, // #2993
  {22,  3,   0}, // #2994
  { 1,  3,   0}, // #2995
  { 5,  1,   0}, // #2996
  { 6,  1,   0}, // #2997
  { 8,  1,   0}, // #2998
  {10,  4,   0}, // #2999
  {14,  4,   0}, // #3000
  {19,  4,   0}, // #3001
  {22,  3,   0}, // #3002
  { 9,  3,   0}, // #3003
  {13,  1,   0}, // #3004
  {14,  1,   0}, // #3005
  {15,  1,   0}, // #3006
  {19,  1,   0}, // #3007
  { 5, 23,   0}, // #3008
  { 7, 23,   0}, // #3009
  { 8, 23,   0}, // #3010
  { 5, 21,   0}, // #3011
  { 7, 21,   0}, // #3012
  { 8, 21,   0}, // #3013
  { 5, 26,   0}, // #3014
  { 7, 26,   0}, // #3015
  { 8, 26,   0}, // #3016
  { 5, 69,   0}, // #3017
  { 7, 69,   0}, // #3018
  { 8, 69,   0}, // #3019
  { 5, 14,   0}, // #3020
  { 8, 14,   0}, // #3021
  { 5, 25,   0}, // #3022
  { 8, 25,   0}, // #3023
  { 5, 20,   0}, // #3024
  { 7, 20,   0}, // #3025
  { 8, 20,   0}, // #3026
  { 1,  3,   0}, // #3027
  {10, 10,   0}, // #3028
  {14,  1,   0}, // #3029
  {15,  1,   0}, // #3030
  {19,  1,   0}, // #3031
  {22,  3,   0}, // #3032
  { 1,  3,   0}, // #3033
  {10, 18,   0}, // #3034
  {14,  1,   0}, // #3035
  {15,  1,   0}, // #3036
  {19,  1,   0}, // #3037
  {22,  3,   0}, // #3038
  { 1,  1,   0}, // #3039
  {10,  4,   0}, // #3040
  {14,  2,   0}, // #3041
  {19,  2,   0}, // #3042
  {22,  1,   0}, // #3043
  { 5, 375,   0}, // #3044
  { 8, 375,   0}, // #3045
  { 5, 24,   0}, // #3046
  { 8, 24,   0}, // #3047
  {10,  6,   0}, // #3048
  {14,  1,   0}, // #3049
  {19,  1,   0}, // #3050
  {10,  8,   0}, // #3051
  {14,  1,   0}, // #3052
  {19,  1,   0}, // #3053
  { 5,  3,   0}, // #3054
  { 8,  3,   0}, // #3055
  { 5, 18,   0}, // #3056
  { 8, 18,   0}, // #3057
  { 5, 88,   0}, // #3058
  { 8, 88,   0}, // #3059
  { 1,  3,   0}, // #3060
  { 5,  3,   0}, // #3061
  { 8,  3,   0}, // #3062
  {22,  3,   0}, // #3063
  { 5, 10,   0}, // #3064
  { 8, 10,   0}, // #3065
  { 5, 12,   0}, // #3066
  { 8, 12,   0}, // #3067
  { 5, 17,   0}, // #3068
  { 8, 17,   0}, // #3069
  { 5,  5,   0}, // #3070
  { 8,  5,   0}, // #3071
  { 5, 23,   0}, // #3072
  { 8, 23,   0}, // #3073
  { 5, 20,   0}, // #3074
  { 8, 20,   0}, // #3075
  { 5, 19,   0}, // #3076
  { 8, 19,   0}, // #3077
  { 5, 13,   0}, // #3078
  { 8, 13,   0}, // #3079
  { 5, 21,   0}, // #3080
  { 8, 21,   0}, // #3081
  { 5, 15,   0}, // #3082
  { 8, 15,   0}, // #3083
  {13,  1,   0}, // #3084
  {14, 10,   0}, // #3085
  {16, 10,   0}, // #3086
  {19, 10,   0}, // #3087
  {13,  1,   0}, // #3088
  {14,  3,   0}, // #3089
  {16,  3,   0}, // #3090
  {19,  3,   0}, // #3091
  {13,  1,   0}, // #3092
  {14,  4,   0}, // #3093
  {16,  4,   0}, // #3094
  {19,  4,   0}, // #3095
  {11,  1,   0}, // #3096
  {12,  1,   0}, // #3097
  {14,  1,   0}, // #3098
  {15,  1,   0}, // #3099
  {19,  1,   0}, // #3100
  {22,  1,   0}, // #3101
  {23,  1,   0}, // #3102
  {14,  1,   0}, // #3103
  {20,  1,   0}, // #3104
  {22,  1,   0}, // #3105
  {23,  1,   0}, // #3106
  { 7,  1,   0}, // #3107
  {12,  1,   0}, // #3108
  {14,  2,   0}, // #3109
  {17,  1,   0}, // #3110
  {20,  2,   0}, // #3111
  {21,  2,   0}, // #3112
  {22,  3,   0}, // #3113
  {23,  6,   0}, // #3114
  {14,  1,   0}, // #3115
  {17,  1,   0}, // #3116
  {20,  1,   0}, // #3117
  {21,  1,   0}, // #3118
  {22,  1,   0}, // #3119
  {23,  2,   0}, // #3120
  { 7,  1,   0}, // #3121
  {12,  1,   0}, // #3122
  {21,  1,   0}, // #3123
  {23,  2,   0}, // #3124
  { 4,  1,   0}, // #3125
  {11,  1,   0}, // #3126
  {15,  1,   0}, // #3127
  {16,  1,   0}, // #3128
  {19,  1,   0}, // #3129
  {22,  1,   0}, // #3130
  {23,  1,   0}, // #3131
  {17,  1,   0}, // #3132
  {21,  1,   0}, // #3133
  {23,  1,   0}, // #3134
  { 7,  1,   0}, // #3135
  {12,  1,   0}, // #3136
  {17,  1,   0}, // #3137
  {21,  2,   0}, // #3138
  {22,  1,   0}, // #3139
  {23,  4,   0}, // #3140
  { 8,  1,   0}, // #3141
  {13,  1,   0}, // #3142
  {15,  1,   0}, // #3143
  {18,  1,   0}, // #3144
  {19,  1,   0}, // #3145
  {20,  1,   0}, // #3146
  {22,  1,   0}, // #3147
  {23,  1,   0}, // #3148
  {17,  1,   0}, // #3149
  {21,  1,   0}, // #3150
  {22,  1,   0}, // #3151
  {23,  2,   0}, // #3152
  { 4,  1,   0}, // #3153
  {11,  1,   0}, // #3154
  {15,  1,   0}, // #3155
  {16,  1,   0}, // #3156
  {17,  1,   0}, // #3157
  {19,  1,   0}, // #3158
  {21,  1,   0}, // #3159
  {22,  1,   0}, // #3160
  {23,  2,   0}, // #3161
  { 8,  1,   0}, // #3162
  {13,  1,   0}, // #3163
  {15,  1,   0}, // #3164
  {17,  1,   0}, // #3165
  {18,  1,   0}, // #3166
  {19,  1,   0}, // #3167
  {20,  1,   0}, // #3168
  {21,  1,   0}, // #3169
  {22,  1,   0}, // #3170
  {23,  2,   0}, // #3171
  { 8,  2,   0}, // #3172
  {13,  2,   0}, // #3173
  {15,  2,   0}, // #3174
  {17,  1,   0}, // #3175
  {18,  2,   0}, // #3176
  {19,  2,   0}, // #3177
  {20,  2,   0}, // #3178
  {21,  1,   0}, // #3179
  {22,  2,   0}, // #3180
  {23,  3,   0}, // #3181
  { 8,  2,   0}, // #3182
  {13,  2,   0}, // #3183
  {15,  2,   0}, // #3184
  {18,  2,   0}, // #3185
  {19,  2,   0}, // #3186
  {20,  2,   0}, // #3187
  {22,  2,   0}, // #3188
  {23,  2,   0}, // #3189
  { 3,  2,   0}, // #3190
  { 8,  7,   0}, // #3191
  {11,  2,   0}, // #3192
  {12,  2,   0}, // #3193
  {13,  9,   0}, // #3194
  {14,  2,   0}, // #3195
  {15,  7,   0}, // #3196
  {17,  1,   0}, // #3197
  {18,  7,   0}, // #3198
  {19, 10,   0}, // #3199
  {20,  9,   0}, // #3200
  {21,  1,   0}, // #3201
  {22, 10,   0}, // #3202
  {23, 11,   0}, // #3203
  { 3,  2,   0}, // #3204
  { 8,  7,   0}, // #3205
  {11,  2,   0}, // #3206
  {12,  2,   0}, // #3207
  {13,  9,   0}, // #3208
  {14,  2,   0}, // #3209
  {15,  7,   0}, // #3210
  {18,  7,   0}, // #3211
  {19, 11,   0}, // #3212
  {20,  9,   0}, // #3213
  {22, 11,   0}, // #3214
  {23, 11,   0}, // #3215
  {14,  1,   0}, // #3216
  {15,  1,   0}, // #3217
  {17,  1,   0}, // #3218
  {19,  1,   0}, // #3219
  {20,  1,   0}, // #3220
  {21,  1,   0}, // #3221
  {22,  2,   0}, // #3222
  {23,  3,   0}, // #3223
  {14,  1,   0}, // #3224
  {15,  1,   0}, // #3225
  {19,  1,   0}, // #3226
  {20,  1,   0}, // #3227
  {22,  2,   0}, // #3228
  {23,  2,   0}, // #3229
  {15,  1,   0}, // #3230
  {17,  1,   0}, // #3231
  {19,  1,   0}, // #3232
  {21,  1,   0}, // #3233
  {22,  1,   0}, // #3234
  {23,  2,   0}, // #3235
  { 7,  1,   0}, // #3236
  {12,  1,   0}, // #3237
  {14,  1,   0}, // #3238
  {17,  1,   0}, // #3239
  {20,  1,   0}, // #3240
  {21,  2,   0}, // #3241
  {22,  1,   0}, // #3242
  {23,  4,   0}, // #3243
  {22,  3,   0}, // #3244
  {23,  3,   0}, // #3245
  {14,  2,   0}, // #3246
  {20,  2,   0}, // #3247
  {22,  5,   0}, // #3248
  {23,  5,   0}, // #3249
  { 4,  1,   0}, // #3250
  { 8,  1,   0}, // #3251
  {11,  1,   0}, // #3252
  {13,  1,   0}, // #3253
  {15,  2,   0}, // #3254
  {16,  1,   0}, // #3255
  {17,  1,   0}, // #3256
  {18,  1,   0}, // #3257
  {19,  2,   0}, // #3258
  {20,  1,   0}, // #3259
  {21,  1,   0}, // #3260
  {22,  2,   0}, // #3261
  {23,  3,   0}, // #3262
  { 4,  1,   0}, // #3263
  { 8,  1,   0}, // #3264
  {11,  1,   0}, // #3265
  {13,  1,   0}, // #3266
  {15,  2,   0}, // #3267
  {16,  1,   0}, // #3268
  {18,  1,   0}, // #3269
  {19,  2,   0}, // #3270
  {20,  1,   0}, // #3271
  {22,  2,   0}, // #3272
  {23,  2,   0}, // #3273
  { 3,  1,   0}, // #3274
  {11,  1,   0}, // #3275
  {12,  1,   0}, // #3276
  {13,  1,   0}, // #3277
  {14,  1,   0}, // #3278
  {17,  1,   0}, // #3279
  {19,  1,   0}, // #3280
  {20,  1,   0}, // #3281
  {21,  1,   0}, // #3282
  {22,  1,   0}, // #3283
  {23,  2,   0}, // #3284
  { 3,  1,   0}, // #3285
  { 8,  1,   0}, // #3286
  {11,  1,   0}, // #3287
  {12,  1,   0}, // #3288
  {13,  2,   0}, // #3289
  {14,  1,   0}, // #3290
  {15,  1,   0}, // #3291
  {18,  1,   0}, // #3292
  {19,  2,   0}, // #3293
  {20,  2,   0}, // #3294
  {22,  2,   0}, // #3295
  {23,  2,   0}, // #3296
  { 3,  1,   0}, // #3297
  { 4,  1,   0}, // #3298
  {11,  2,   0}, // #3299
  {12,  1,   0}, // #3300
  {13,  1,   0}, // #3301
  {14,  1,   0}, // #3302
  {15,  1,   0}, // #3303
  {16,  1,   0}, // #3304
  {17,  1,   0}, // #3305
  {19,  2,   0}, // #3306
  {20,  1,   0}, // #3307
  {21,  1,   0}, // #3308
  {22,  2,   0}, // #3309
  {23,  3,   0}, // #3310
  { 3,  1,   0}, // #3311
  { 4,  1,   0}, // #3312
  {11,  2,   0}, // #3313
  {12,  1,   0}, // #3314
  {13,  1,   0}, // #3315
  {14,  1,   0}, // #3316
  {15,  1,   0}, // #3317
  {16,  1,   0}, // #3318
  {19,  2,   0}, // #3319
  {20,  1,   0}, // #3320
  {22,  2,   0}, // #3321
  {23,  2,   0}, // #3322
  { 3,  2,   0}, // #3323
  { 4,  2,   0}, // #3324
  { 8,  2,   0}, // #3325
  {11,  4,   0}, // #3326
  {12,  2,   0}, // #3327
  {13,  4,   0}, // #3328
  {14,  2,   0}, // #3329
  {15,  4,   0}, // #3330
  {16,  2,   0}, // #3331
  {17,  1,   0}, // #3332
  {18,  2,   0}, // #3333
  {19,  6,   0}, // #3334
  {20,  4,   0}, // #3335
  {21,  1,   0}, // #3336
  {22,  7,   0}, // #3337
  {23,  8,   0}, // #3338
  { 3,  7,   0}, // #3339
  { 4,  7,   0}, // #3340
  { 8,  3,   0}, // #3341
  { 9,  3,   0}, // #3342
  {11, 15,   0}, // #3343
  {12,  7,   0}, // #3344
  {13, 10,   0}, // #3345
  {14, 10,   0}, // #3346
  {15, 10,   0}, // #3347
  {16, 10,   0}, // #3348
  {18,  6,   0}, // #3349
  {19, 18,   0}, // #3350
  {20, 13,   0}, // #3351
  {22, 32,   0}, // #3352
  {23, 32,   0}, // #3353
  { 1, 10,   0}, // #3354
  { 3,  1,   0}, // #3355
  {11,  1,   0}, // #3356
  {12,  1,   0}, // #3357
  {13,  1,   0}, // #3358
  {14,  1,   0}, // #3359
  {19,  1,   0}, // #3360
  {20,  1,   0}, // #3361
  {22,  1,   0}, // #3362
  {23,  1,   0}, // #3363
  { 2,  8,   0}, // #3364
  { 3,  1,   0}, // #3365
  {11,  1,   0}, // #3366
  {12,  1,   0}, // #3367
  {13,  1,   0}, // #3368
  {14,  1,   0}, // #3369
  {17,  1,   0}, // #3370
  {19,  1,   0}, // #3371
  {20,  1,   0}, // #3372
  {21,  1,   0}, // #3373
  {22,  1,   0}, // #3374
  {23,  2,   0}, // #3375
  { 2,  8,   0}, // #3376
  { 3,  1,   0}, // #3377
  {11,  1,   0}, // #3378
  {12,  1,   0}, // #3379
  {13,  1,   0}, // #3380
  {14,  1,   0}, // #3381
  {19,  1,   0}, // #3382
  {20,  1,   0}, // #3383
  {22,  1,   0}, // #3384
  {23,  1,   0}, // #3385
  { 2,  5,   0}, // #3386
  { 3,  1,   0}, // #3387
  {11,  1,   0}, // #3388
  {12,  1,   0}, // #3389
  {13,  1,   0}, // #3390
  {14,  1,   0}, // #3391
  {17,  1,   0}, // #3392
  {19,  1,   0}, // #3393
  {20,  1,   0}, // #3394
  {21,  1,   0}, // #3395
  {22,  1,   0}, // #3396
  {23,  2,   0}, // #3397
  { 2,  5,   0}, // #3398
  { 3,  1,   0}, // #3399
  {11,  1,   0}, // #3400
  {12,  1,   0}, // #3401
  {13,  1,   0}, // #3402
  {14,  1,   0}, // #3403
  {19,  1,   0}, // #3404
  {20,  1,   0}, // #3405
  {22,  1,   0}, // #3406
  {23,  1,   0}, // #3407
  { 2,  3,   0}, // #3408
  { 3,  1,   0}, // #3409
  {11,  1,   0}, // #3410
  {12,  1,   0}, // #3411
  {13,  1,   0}, // #3412
  {14,  1,   0}, // #3413
  {19,  1,   0}, // #3414
  {20,  1,   0}, // #3415
  {22,  1,   0}, // #3416
  {23,  1,   0}, // #3417
  { 2,  4,   0}, // #3418
  { 3,  1,   0}, // #3419
  {11,  1,   0}, // #3420
  {12,  1,   0}, // #3421
  {13,  1,   0}, // #3422
  {14,  1,   0}, // #3423
  {19,  1,   0}, // #3424
  {20,  1,   0}, // #3425
  {22,  1,   0}, // #3426
  {23,  1,   0}, // #3427
  { 3,  1,   0}, // #3428
  { 4,  1,   0}, // #3429
  { 8,  1,   0}, // #3430
  {11,  2,   0}, // #3431
  {12,  1,   0}, // #3432
  {13,  2,   0}, // #3433
  {14,  1,   0}, // #3434
  {15,  2,   0}, // #3435
  {16,  1,   0}, // #3436
  {17,  1,   0}, // #3437
  {18,  1,   0}, // #3438
  {19,  3,   0}, // #3439
  {20,  2,   0}, // #3440
  {21,  1,   0}, // #3441
  {22,  3,   0}, // #3442
  {23,  4,   0}, // #3443
  { 3,  1,   0}, // #3444
  { 4,  1,   0}, // #3445
  { 8,  1,   0}, // #3446
  {11,  2,   0}, // #3447
  {12,  1,   0}, // #3448
  {13,  2,   0}, // #3449
  {14,  1,   0}, // #3450
  {15,  2,   0}, // #3451
  {16,  1,   0}, // #3452
  {18,  1,   0}, // #3453
  {19,  3,   0}, // #3454
  {20,  2,   0}, // #3455
  {22,  3,   0}, // #3456
  {23,  3,   0}, // #3457
  { 3,  2,   0}, // #3458
  { 4,  1,   0}, // #3459
  { 8,  1,   0}, // #3460
  {11,  3,   0}, // #3461
  {12,  2,   0}, // #3462
  {13,  3,   0}, // #3463
  {14,  2,   0}, // #3464
  {15,  2,   0}, // #3465
  {16,  1,   0}, // #3466
  {17,  1,   0}, // #3467
  {18,  1,   0}, // #3468
  {19,  4,   0}, // #3469
  {20,  3,   0}, // #3470
  {21,  1,   0}, // #3471
  {22,  4,   0}, // #3472
  {23,  5,   0}, // #3473
  { 3,  2,   0}, // #3474
  { 4,  1,   0}, // #3475
  { 8,  1,   0}, // #3476
  {11,  3,   0}, // #3477
  {12,  2,   0}, // #3478
  {13,  3,   0}, // #3479
  {14,  2,   0}, // #3480
  {15,  2,   0}, // #3481
  {16,  1,   0}, // #3482
  {18,  1,   0}, // #3483
  {19,  4,   0}, // #3484
  {20,  3,   0}, // #3485
  {22,  4,   0}, // #3486
  {23,  4,   0}, // #3487
  { 7,  1,   0}, // #3488
  { 8,  1,   0}, // #3489
  {12,  1,   0}, // #3490
  {13,  1,   0}, // #3491
  {15,  1,   0}, // #3492
  {18,  1,   0}, // #3493
  {19,  1,   0}, // #3494
  {20,  1,   0}, // #3495
  {21,  1,   0}, // #3496
  {22,  1,   0}, // #3497
  {23,  3,   0}, // #3498
  {11,  8,   0}, // #3499
  {15,  1,   0}, // #3500
  {19, 30,   0}, // #3501
  {22, 31,   0}, // #3502
  {23, 31,   0}, // #3503
  {11,  2,   0}, // #3504
  {19,  2,   0}, // #3505
  {22,  2,   0}, // #3506
  {23,  2,   0}, // #3507
  { 4,  1,   0}, // #3508
  { 8,  2,   0}, // #3509
  {11,  1,   0}, // #3510
  {13,  2,   0}, // #3511
  {15,  3,   0}, // #3512
  {16,  1,   0}, // #3513
  {17,  1,   0}, // #3514
  {18,  2,   0}, // #3515
  {19,  3,   0}, // #3516
  {20,  2,   0}, // #3517
  {21,  1,   0}, // #3518
  {22,  3,   0}, // #3519
  {23,  4,   0}, // #3520
  { 4,  1,   0}, // #3521
  { 8,  2,   0}, // #3522
  {11,  1,   0}, // #3523
  {13,  2,   0}, // #3524
  {15,  3,   0}, // #3525
  {16,  1,   0}, // #3526
  {18,  2,   0}, // #3527
  {19,  3,   0}, // #3528
  {20,  2,   0}, // #3529
  {22,  3,   0}, // #3530
  {23,  3,   0}, // #3531
  { 4,  1,   0}, // #3532
  {11,  1,   0}, // #3533
  {14,  1,   0}, // #3534
  {15,  1,   0}, // #3535
  {16,  1,   0}, // #3536
  {17,  1,   0}, // #3537
  {19,  1,   0}, // #3538
  {20,  1,   0}, // #3539
  {21,  1,   0}, // #3540
  {22,  4,   0}, // #3541
  {23,  5,   0}, // #3542
  { 4,  1,   0}, // #3543
  {11,  1,   0}, // #3544
  {14,  1,   0}, // #3545
  {15,  1,   0}, // #3546
  {16,  1,   0}, // #3547
  {19,  1,   0}, // #3548
  {20,  1,   0}, // #3549
  {22,  4,   0}, // #3550
  {23,  4,   0}, // #3551
  { 4,  1,   0}, // #3552
  {11,  1,   0}, // #3553
  {15,  1,   0}, // #3554
  {16,  1,   0}, // #3555
  {17,  1,   0}, // #3556
  {19,  1,   0}, // #3557
  {21,  1,   0}, // #3558
  {22,  2,   0}, // #3559
  {23,  3,   0}, // #3560
  { 4,  1,   0}, // #3561
  {11,  1,   0}, // #3562
  {15,  1,   0}, // #3563
  {16,  1,   0}, // #3564
  {19,  1,   0}, // #3565
  {22,  2,   0}, // #3566
  {23,  2,   0}, // #3567
  { 4,  1,   0}, // #3568
  {11,  1,   0}, // #3569
  {14,  1,   0}, // #3570
  {15,  1,   0}, // #3571
  {16,  1,   0}, // #3572
  {17,  1,   0}, // #3573
  {19,  1,   0}, // #3574
  {20,  1,   0}, // #3575
  {21,  1,   0}, // #3576
  {22,  3,   0}, // #3577
  {23,  4,   0}, // #3578
  { 4,  1,   0}, // #3579
  {11,  1,   0}, // #3580
  {14,  1,   0}, // #3581
  {15,  1,   0}, // #3582
  {16,  1,   0}, // #3583
  {19,  1,   0}, // #3584
  {20,  1,   0}, // #3585
  {22,  3,   0}, // #3586
  {23,  3,   0}, // #3587
  { 3,  1,   0}, // #3588
  {11,  1,   0}, // #3589
  {12,  1,   0}, // #3590
  {13,  1,   0}, // #3591
  {14,  1,   0}, // #3592
  {17,  1,   0}, // #3593
  {19,  1,   0}, // #3594
  {20,  1,   0}, // #3595
  {21,  1,   0}, // #3596
  {22,  2,   0}, // #3597
  {23,  3,   0}, // #3598
  {11,  1,   0}, // #3599
  {19,  1,   0}, // #3600
  {22,  1,   0}, // #3601
  {23,  1,   0}, // #3602
  { 7,  1,   0}, // #3603
  {12,  1,   0}, // #3604
  {17,  1,   0}, // #3605
  {21,  1,   0}, // #3606
  {23,  2,   0}, // #3607
  { 8,  2,   0}, // #3608
  {13,  2,   0}, // #3609
  {15,  3,   0}, // #3610
  {17,  1,   0}, // #3611
  {18,  2,   0}, // #3612
  {19,  3,   0}, // #3613
  {20,  2,   0}, // #3614
  {21,  1,   0}, // #3615
  {22,  3,   0}, // #3616
  {23,  4,   0}, // #3617
  { 8,  2,   0}, // #3618
  {13,  2,   0}, // #3619
  {15,  3,   0}, // #3620
  {18,  2,   0}, // #3621
  {19,  3,   0}, // #3622
  {20,  2,   0}, // #3623
  {22,  3,   0}, // #3624
  {23,  3,   0}, // #3625
  { 3,  1,   0}, // #3626
  { 8,  2,   0}, // #3627
  {11,  1,   0}, // #3628
  {12,  1,   0}, // #3629
  {13,  3,   0}, // #3630
  {14,  1,   0}, // #3631
  {15,  2,   0}, // #3632
  {17,  1,   0}, // #3633
  {18,  2,   0}, // #3634
  {19,  3,   0}, // #3635
  {20,  3,   0}, // #3636
  {21,  1,   0}, // #3637
  {22,  3,   0}, // #3638
  {23,  4,   0}, // #3639
  { 3,  1,   0}, // #3640
  { 8,  2,   0}, // #3641
  {11,  1,   0}, // #3642
  {12,  1,   0}, // #3643
  {13,  3,   0}, // #3644
  {14,  1,   0}, // #3645
  {15,  2,   0}, // #3646
  {18,  2,   0}, // #3647
  {19,  3,   0}, // #3648
  {20,  3,   0}, // #3649
  {22,  3,   0}, // #3650
  {23,  3,   0}, // #3651
  {11,  1,   0}, // #3652
  {17,  1,   0}, // #3653
  {19,  1,   0}, // #3654
  {21,  1,   0}, // #3655
  {22,  1,   0}, // #3656
  {23,  2,   0}, // #3657
  { 3,  4,   0}, // #3658
  { 8,  3,   0}, // #3659
  {11,  4,   0}, // #3660
  {12,  4,   0}, // #3661
  {13,  7,   0}, // #3662
  {14,  4,   0}, // #3663
  {15,  3,   0}, // #3664
  {17,  1,   0}, // #3665
  {18,  3,   0}, // #3666
  {19,  7,   0}, // #3667
  {20,  7,   0}, // #3668
  {21,  1,   0}, // #3669
  {22,  8,   0}, // #3670
  {23,  9,   0}, // #3671
  { 3,  4,   0}, // #3672
  { 8,  3,   0}, // #3673
  {11,  4,   0}, // #3674
  {12,  4,   0}, // #3675
  {13,  7,   0}, // #3676
  {14,  4,   0}, // #3677
  {15,  3,   0}, // #3678
  {18,  3,   0}, // #3679
  {19,  7,   0}, // #3680
  {20,  7,   0}, // #3681
  {22,  8,   0}, // #3682
  {23,  8,   0}, // #3683
  { 3,  4,   0}, // #3684
  { 8,  3,   0}, // #3685
  {11,  4,   0}, // #3686
  {12,  4,   0}, // #3687
  {13,  7,   0}, // #3688
  {14,  4,   0}, // #3689
  {15,  3,   0}, // #3690
  {17,  1,   0}, // #3691
  {18,  3,   0}, // #3692
  {19,  8,   0}, // #3693
  {20,  7,   0}, // #3694
  {21,  1,   0}, // #3695
  {22,  9,   0}, // #3696
  {23, 10,   0}, // #3697
  { 3,  4,   0}, // #3698
  { 8,  3,   0}, // #3699
  {11,  4,   0}, // #3700
  {12,  4,   0}, // #3701
  {13,  7,   0}, // #3702
  {14,  4,   0}, // #3703
  {15,  3,   0}, // #3704
  {18,  3,   0}, // #3705
  {19,  8,   0}, // #3706
  {20,  7,   0}, // #3707
  {22,  9,   0}, // #3708
  {23,  9,   0}, // #3709
  { 3,  3,   0}, // #3710
  {11,  3,   0}, // #3711
  {12,  3,   0}, // #3712
  {13,  3,   0}, // #3713
  {14,  3,   0}, // #3714
  {17,  1,   0}, // #3715
  {19,  3,   0}, // #3716
  {20,  3,   0}, // #3717
  {21,  1,   0}, // #3718
  {22,  3,   0}, // #3719
  {23,  4,   0}, // #3720
  { 3,  3,   0}, // #3721
  {11,  3,   0}, // #3722
  {12,  3,   0}, // #3723
  {13,  3,   0}, // #3724
  {14,  3,   0}, // #3725
  {19,  3,   0}, // #3726
  {20,  3,   0}, // #3727
  {22,  3,   0}, // #3728
  {23,  3,   0}, // #3729
  { 3,  2,   0}, // #3730
  {11,  2,   0}, // #3731
  {12,  2,   0}, // #3732
  {13,  2,   0}, // #3733
  {14,  2,   0}, // #3734
  {17,  1,   0}, // #3735
  {19,  2,   0}, // #3736
  {20,  2,   0}, // #3737
  {21,  1,   0}, // #3738
  {22,  2,   0}, // #3739
  {23,  3,   0}, // #3740
  { 3,  2,   0}, // #3741
  {11,  2,   0}, // #3742
  {12,  2,   0}, // #3743
  {13,  2,   0}, // #3744
  {14,  2,   0}, // #3745
  {19,  2,   0}, // #3746
  {20,  2,   0}, // #3747
  {22,  2,   0}, // #3748
  {23,  2,   0}, // #3749
  { 7,  1,   0}, // #3750
  {12,  1,   0}, // #3751
  {17,  1,   0}, // #3752
  {21,  2,   0}, // #3753
  {23,  3,   0}, // #3754
  { 3,  1,   0}, // #3755
  { 8,  1,   0}, // #3756
  {11,  1,   0}, // #3757
  {12,  1,   0}, // #3758
  {13,  2,   0}, // #3759
  {14,  1,   0}, // #3760
  {15,  1,   0}, // #3761
  {17,  1,   0}, // #3762
  {18,  1,   0}, // #3763
  {19,  2,   0}, // #3764
  {20,  2,   0}, // #3765
  {21,  1,   0}, // #3766
  {22,  2,   0}, // #3767
  {23,  3,   0}, // #3768
  {14,  2,   0}, // #3769
  {17,  1,   0}, // #3770
  {20,  2,   0}, // #3771
  {21,  1,   0}, // #3772
  {22,  2,   0}, // #3773
  {23,  3,   0}, // #3774
  {14,  4,   0}, // #3775
  {17,  1,   0}, // #3776
  {20,  4,   0}, // #3777
  {21,  1,   0}, // #3778
  {22,  6,   0}, // #3779
  {23,  7,   0}, // #3780
  {14,  2,   0}, // #3781
  {20,  2,   0}, // #3782
  {22,  3,   0}, // #3783
  {23,  3,   0}, // #3784
  { 4,  2,   0}, // #3785
  {11,  2,   0}, // #3786
  {15,  2,   0}, // #3787
  {16,  2,   0}, // #3788
  {17,  1,   0}, // #3789
  {19,  2,   0}, // #3790
  {21,  1,   0}, // #3791
  {22,  2,   0}, // #3792
  {23,  3,   0}, // #3793
  { 7,  1,   0}, // #3794
  {12,  1,   0}, // #3795
  {14,  1,   0}, // #3796
  {20,  1,   0}, // #3797
  {21,  1,   0}, // #3798
  {22,  1,   0}, // #3799
  {23,  3,   0}, // #3800
  { 4,  1,   0}, // #3801
  {11,  1,   0}, // #3802
  {14,  1,   0}, // #3803
  {15,  1,   0}, // #3804
  {16,  1,   0}, // #3805
  {17,  1,   0}, // #3806
  {19,  1,   0}, // #3807
  {20,  1,   0}, // #3808
  {21,  2,   0}, // #3809
  {22,  4,   0}, // #3810
  {23,  6,   0}, // #3811
  { 4,  1,   0}, // #3812
  {11,  1,   0}, // #3813
  {15,  1,   0}, // #3814
  {16,  1,   0}, // #3815
  {17,  1,   0}, // #3816
  {19,  1,   0}, // #3817
  {21,  2,   0}, // #3818
  {22,  2,   0}, // #3819
  {23,  4,   0}, // #3820
  { 2, 14,   0}, // #3821
  { 3,  1,   0}, // #3822
  {11,  1,   0}, // #3823
  {12,  1,   0}, // #3824
  {13,  1,   0}, // #3825
  {14,  1,   0}, // #3826
  {17,  1,   0}, // #3827
  {19,  1,   0}, // #3828
  {20,  1,   0}, // #3829
  {21,  1,   0}, // #3830
  {22,  1,   0}, // #3831
  {23,  2,   0}, // #3832
  { 2, 14,   0}, // #3833
  { 3,  1,   0}, // #3834
  {11,  1,   0}, // #3835
  {12,  1,   0}, // #3836
  {13,  1,   0}, // #3837
  {14,  1,   0}, // #3838
  {19,  1,   0}, // #3839
  {20,  1,   0}, // #3840
  {22,  1,   0}, // #3841
  {23,  1,   0}, // #3842
  { 2,  7,   0}, // #3843
  { 3,  1,   0}, // #3844
  {11,  1,   0}, // #3845
  {12,  1,   0}, // #3846
  {13,  1,   0}, // #3847
  {14,  1,   0}, // #3848
  {17,  1,   0}, // #3849
  {19,  1,   0}, // #3850
  {20,  1,   0}, // #3851
  {21,  1,   0}, // #3852
  {22,  1,   0}, // #3853
  {23,  2,   0}, // #3854
  { 2,  7,   0}, // #3855
  { 3,  1,   0}, // #3856
  {11,  1,   0}, // #3857
  {12,  1,   0}, // #3858
  {13,  1,   0}, // #3859
  {14,  1,   0}, // #3860
  {19,  1,   0}, // #3861
  {20,  1,   0}, // #3862
  {22,  1,   0}, // #3863
  {23,  1,   0}, // #3864
  { 2,  9,   0}, // #3865
  { 3,  1,   0}, // #3866
  {11,  1,   0}, // #3867
  {12,  1,   0}, // #3868
  {13,  1,   0}, // #3869
  {14,  1,   0}, // #3870
  {19,  1,   0}, // #3871
  {20,  1,   0}, // #3872
  {22,  1,   0}, // #3873
  {23,  1,   0}, // #3874
  { 4,  1,   0}, // #3875
  { 7,  1,   0}, // #3876
  {11,  1,   0}, // #3877
  {12,  1,   0}, // #3878
  {15,  1,   0}, // #3879
  {16,  1,   0}, // #3880
  {19,  1,   0}, // #3881
  {21,  1,   0}, // #3882
  {22,  1,   0}, // #3883
  {23,  3,   0}, // #3884
  { 2, 16,   0}, // #3885
  { 3,  2,   0}, // #3886
  {11,  2,   0}, // #3887
  {12,  2,   0}, // #3888
  {13,  2,   0}, // #3889
  {14,  2,   0}, // #3890
  {17,  1,   0}, // #3891
  {19,  3,   0}, // #3892
  {20,  2,   0}, // #3893
  {21,  1,   0}, // #3894
  {22,  3,   0}, // #3895
  {23,  4,   0}, // #3896
  { 2, 16,   0}, // #3897
  { 3,  2,   0}, // #3898
  {11,  2,   0}, // #3899
  {12,  2,   0}, // #3900
  {13,  2,   0}, // #3901
  {14,  2,   0}, // #3902
  {19,  3,   0}, // #3903
  {20,  2,   0}, // #3904
  {22,  3,   0}, // #3905
  {23,  3,   0}, // #3906
  { 2, 10,   0}, // #3907
  { 3,  2,   0}, // #3908
  {11,  2,   0}, // #3909
  {12,  2,   0}, // #3910
  {13,  2,   0}, // #3911
  {14,  2,   0}, // #3912
  {17,  1,   0}, // #3913
  {19,  3,   0}, // #3914
  {20,  2,   0}, // #3915
  {21,  1,   0}, // #3916
  {22,  3,   0}, // #3917
  {23,  4,   0}, // #3918
  { 2, 10,   0}, // #3919
  { 3,  2,   0}, // #3920
  {11,  2,   0}, // #3921
  {12,  2,   0}, // #3922
  {13,  2,   0}, // #3923
  {14,  2,   0}, // #3924
  {19,  3,   0}, // #3925
  {20,  2,   0}, // #3926
  {22,  3,   0}, // #3927
  {23,  3,   0}, // #3928
  { 3,  1,   0}, // #3929
  { 7,  1,   0}, // #3930
  {11,  1,   0}, // #3931
  {12,  2,   0}, // #3932
  {13,  1,   0}, // #3933
  {14,  1,   0}, // #3934
  {15,  1,   0}, // #3935
  {19,  2,   0}, // #3936
  {20,  1,   0}, // #3937
  {21,  1,   0}, // #3938
  {22,  2,   0}, // #3939
  {23,  4,   0}, // #3940
  { 3,  2,   0}, // #3941
  { 8,  1,   0}, // #3942
  {11,  2,   0}, // #3943
  {12,  2,   0}, // #3944
  {13,  3,   0}, // #3945
  {14,  2,   0}, // #3946
  {15,  1,   0}, // #3947
  {17,  1,   0}, // #3948
  {18,  1,   0}, // #3949
  {19,  3,   0}, // #3950
  {20,  3,   0}, // #3951
  {21,  1,   0}, // #3952
  {22,  3,   0}, // #3953
  {23,  4,   0}, // #3954
  { 3,  2,   0}, // #3955
  { 8,  1,   0}, // #3956
  {11,  2,   0}, // #3957
  {12,  2,   0}, // #3958
  {13,  3,   0}, // #3959
  {14,  2,   0}, // #3960
  {15,  1,   0}, // #3961
  {18,  1,   0}, // #3962
  {19,  3,   0}, // #3963
  {20,  3,   0}, // #3964
  {22,  3,   0}, // #3965
  {23,  3,   0}, // #3966
  { 2, 28,   0}, // #3967
  { 3,  2,   0}, // #3968
  {11,  2,   0}, // #3969
  {12,  2,   0}, // #3970
  {13,  2,   0}, // #3971
  {14,  2,   0}, // #3972
  {17,  1,   0}, // #3973
  {19,  3,   0}, // #3974
  {20,  2,   0}, // #3975
  {21,  1,   0}, // #3976
  {22,  3,   0}, // #3977
  {23,  4,   0}, // #3978
  { 2, 28,   0}, // #3979
  { 3,  2,   0}, // #3980
  {11,  2,   0}, // #3981
  {12,  2,   0}, // #3982
  {13,  2,   0}, // #3983
  {14,  2,   0}, // #3984
  {19,  3,   0}, // #3985
  {20,  2,   0}, // #3986
  {22,  3,   0}, // #3987
  {23,  3,   0}, // #3988
  { 2, 14,   0}, // #3989
  { 3,  2,   0}, // #3990
  {11,  2,   0}, // #3991
  {12,  2,   0}, // #3992
  {13,  2,   0}, // #3993
  {14,  2,   0}, // #3994
  {17,  1,   0}, // #3995
  {19,  3,   0}, // #3996
  {20,  2,   0}, // #3997
  {21,  1,   0}, // #3998
  {22,  3,   0}, // #3999
  {23,  4,   0}, // #4000
  { 2, 14,   0}, // #4001
  { 3,  2,   0}, // #4002
  {11,  2,   0}, // #4003
  {12,  2,   0}, // #4004
  {13,  2,   0}, // #4005
  {14,  2,   0}, // #4006
  {19,  3,   0}, // #4007
  {20,  2,   0}, // #4008
  {22,  3,   0}, // #4009
  {23,  3,   0}, // #4010
  {14,  1,   0}, // #4011
  {17,  1,   0}, // #4012
  {20,  1,   0}, // #4013
  {21,  2,   0}, // #4014
  {22,  3,   0}, // #4015
  {23,  5,   0}, // #4016
  { 4,  2,   0}, // #4017
  {11,  2,   0}, // #4018
  {14,  3,   0}, // #4019
  {15,  3,   0}, // #4020
  {16,  2,   0}, // #4021
  {17,  1,   0}, // #4022
  {19,  3,   0}, // #4023
  {20,  3,   0}, // #4024
  {21,  2,   0}, // #4025
  {22,  9,   0}, // #4026
  {23, 11,   0}, // #4027
  { 3,  2,   0}, // #4028
  { 4,  1,   0}, // #4029
  { 9,  4,   0}, // #4030
  {11,  3,   0}, // #4031
  {12,  2,   0}, // #4032
  {13,  2,   0}, // #4033
  {14,  6,   0}, // #4034
  {15,  1,   0}, // #4035
  {16,  5,   0}, // #4036
  {18,  4,   0}, // #4037
  {19,  3,   0}, // #4038
  {20,  6,   0}, // #4039
  {22, 12,   0}, // #4040
  {23, 12,   0}, // #4041
  {17,  1,   0}, // #4042
  {21,  1,   0}, // #4043
  {22,  2,   0}, // #4044
  {23,  3,   0}, // #4045
  { 9,  1,   0}, // #4046
  {14,  1,   0}, // #4047
  {16,  1,   0}, // #4048
  {18,  1,   0}, // #4049
  {20,  1,   0}, // #4050
  {22,  3,   0}, // #4051
  {23,  3,   0}, // #4052
  { 7,  1,   0}, // #4053
  {12,  1,   0}, // #4054
  {17,  1,   0}, // #4055
  {21,  2,   0}, // #4056
  {22,  3,   0}, // #4057
  {23,  6,   0}, // #4058
  {14,  1,   0}, // #4059
  {20,  1,   0}, // #4060
  {22,  2,   0}, // #4061
  {23,  2,   0}, // #4062
  { 3,  1,   0}, // #4063
  {11,  2,   0}, // #4064
  {12,  1,   0}, // #4065
  {13,  1,   0}, // #4066
  {14,  1,   0}, // #4067
  {17,  1,   0}, // #4068
  {19,  2,   0}, // #4069
  {20,  1,   0}, // #4070
  {21,  1,   0}, // #4071
  {22,  2,   0}, // #4072
  {23,  3,   0}, // #4073
  {14,  2,   0}, // #4074
  {20,  2,   0}, // #4075
  {22, 11,   0}, // #4076
  {23, 11,   0}, // #4077
  { 7,  1,   0}, // #4078
  { 9,  1,   0}, // #4079
  {12,  1,   0}, // #4080
  {14,  1,   0}, // #4081
  {16,  1,   0}, // #4082
  {18,  1,   0}, // #4083
  {20,  1,   0}, // #4084
  {21,  1,   0}, // #4085
  {22,  1,   0}, // #4086
  {23,  3,   0}, // #4087
  { 9,  1,   0}, // #4088
  {14,  1,   0}, // #4089
  {16,  1,   0}, // #4090
  {18,  1,   0}, // #4091
  {20,  1,   0}, // #4092
  {22,  5,   0}, // #4093
  {23,  5,   0}, // #4094
  { 7,  1,   0}, // #4095
  {12,  1,   0}, // #4096
  {14,  4,   0}, // #4097
  {15,  2,   0}, // #4098
  {17,  1,   0}, // #4099
  {19,  2,   0}, // #4100
  {20,  4,   0}, // #4101
  {21,  2,   0}, // #4102
  {22, 11,   0}, // #4103
  {23, 14,   0}, // #4104
  { 9,  2,   0}, // #4105
  {14,  4,   0}, // #4106
  {15,  1,   0}, // #4107
  {16,  2,   0}, // #4108
  {18,  2,   0}, // #4109
  {19,  1,   0}, // #4110
  {20,  4,   0}, // #4111
  {22,  7,   0}, // #4112
  {23,  7,   0}, // #4113
  { 9,  1,   0}, // #4114
  {14,  1,   0}, // #4115
  {16,  1,   0}, // #4116
  {18,  1,   0}, // #4117
  {20,  1,   0}, // #4118
  {22,  6,   0}, // #4119
  {23,  6,   0}, // #4120
  { 3,  2,   0}, // #4121
  { 7,  1,   0}, // #4122
  { 8,  4,   0}, // #4123
  {11,  2,   0}, // #4124
  {12,  3,   0}, // #4125
  {13,  6,   0}, // #4126
  {14,  6,   0}, // #4127
  {15,  4,   0}, // #4128
  {17,  1,   0}, // #4129
  {18,  4,   0}, // #4130
  {19,  6,   0}, // #4131
  {20, 10,   0}, // #4132
  {21,  2,   0}, // #4133
  {22, 16,   0}, // #4134
  {23, 19,   0}, // #4135
  { 8,  2,   0}, // #4136
  {13,  2,   0}, // #4137
  {15,  2,   0}, // #4138
  {18,  2,   0}, // #4139
  {19,  2,   0}, // #4140
  {20,  2,   0}, // #4141
  {22, 22,   0}, // #4142
  {23, 22,   0}, // #4143
  { 7,  1,   0}, // #4144
  { 8,  1,   0}, // #4145
  { 9,  1,   0}, // #4146
  {12,  1,   0}, // #4147
  {13,  1,   0}, // #4148
  {14,  2,   0}, // #4149
  {15,  1,   0}, // #4150
  {16,  1,   0}, // #4151
  {17,  1,   0}, // #4152
  {18,  2,   0}, // #4153
  {19,  1,   0}, // #4154
  {20,  3,   0}, // #4155
  {21,  2,   0}, // #4156
  {22,  5,   0}, // #4157
  {23,  8,   0}, // #4158
  { 8,  6,   0}, // #4159
  {11,  3,   0}, // #4160
  {13,  6,   0}, // #4161
  {15,  6,   0}, // #4162
  {18,  6,   0}, // #4163
  {19,  9,   0}, // #4164
  {20,  6,   0}, // #4165
  {22, 15,   0}, // #4166
  {23, 15,   0}, // #4167
  { 8,  1,   0}, // #4168
  { 9,  5,   0}, // #4169
  {13,  1,   0}, // #4170
  {14,  9,   0}, // #4171
  {15,  1,   0}, // #4172
  {16,  5,   0}, // #4173
  {17,  2,   0}, // #4174
  {18,  6,   0}, // #4175
  {19,  1,   0}, // #4176
  {20, 10,   0}, // #4177
  {21,  3,   0}, // #4178
  {22, 20,   0}, // #4179
  {23, 23,   0}, // #4180
  { 8,  1,   0}, // #4181
  { 9,  5,   0}, // #4182
  {13,  1,   0}, // #4183
  {14,  9,   0}, // #4184
  {15,  1,   0}, // #4185
  {16,  5,   0}, // #4186
  {17,  3,   0}, // #4187
  {18,  6,   0}, // #4188
  {19,  1,   0}, // #4189
  {20, 10,   0}, // #4190
  {21,  3,   0}, // #4191
  {22, 20,   0}, // #4192
  {23, 23,   0}, // #4193
  { 8,  1,   0}, // #4194
  { 9,  1,   0}, // #4195
  {13,  1,   0}, // #4196
  {14,  2,   0}, // #4197
  {15,  1,   0}, // #4198
  {16,  1,   0}, // #4199
  {18,  2,   0}, // #4200
  {19,  1,   0}, // #4201
  {20,  3,   0}, // #4202
  {22,  8,   0}, // #4203
  {23,  8,   0}, // #4204
  { 3,  4,   0}, // #4205
  { 9,  2,   0}, // #4206
  {11,  4,   0}, // #4207
  {12,  4,   0}, // #4208
  {13,  5,   0}, // #4209
  {14,  8,   0}, // #4210
  {15,  1,   0}, // #4211
  {16,  2,   0}, // #4212
  {17, 33,   0}, // #4213
  {18,  2,   0}, // #4214
  {19,  6,   0}, // #4215
  {20,  9,   0}, // #4216
  {21, 33,   0}, // #4217
  {22, 57,   0}, // #4218
  {23, 90,   0}, // #4219
  { 9,  1,   0}, // #4220
  {14,  1,   0}, // #4221
  {16,  1,   0}, // #4222
  {17,  1,   0}, // #4223
  {18,  1,   0}, // #4224
  {20,  1,   0}, // #4225
  {21,  1,   0}, // #4226
  {22,  2,   0}, // #4227
  {23,  3,   0}, // #4228
  { 3,  1,   0}, // #4229
  {11,  1,   0}, // #4230
  {12,  1,   0}, // #4231
  {13,  1,   0}, // #4232
  {14,  1,   0}, // #4233
  {19,  1,   0}, // #4234
  {20,  1,   0}, // #4235
  {22,  2,   0}, // #4236
  {23,  2,   0}, // #4237
  {11,  1,   0}, // #4238
  {19,  2,   0}, // #4239
  {22,  2,   0}, // #4240
  {23,  2,   0}, // #4241
  {14,  1,   0}, // #4242
  {20,  1,   0}, // #4243
  {22,  3,   0}, // #4244
  {23,  3,   0}, // #4245
  { 4,  2,   0}, // #4246
  {11,  2,   0}, // #4247
  {14,  4,   0}, // #4248
  {15,  2,   0}, // #4249
  {16,  2,   0}, // #4250
  {19,  2,   0}, // #4251
  {20,  4,   0}, // #4252
  {22,  8,   0}, // #4253
  {23,  8,   0}, // #4254
  { 7,  1,   0}, // #4255
  {12,  1,   0}, // #4256
  {21,  1,   0}, // #4257
  {22,  1,   0}, // #4258
  {23,  3,   0}, // #4259
  { 7,  1,   0}, // #4260
  {12,  1,   0}, // #4261
  {14,  1,   0}, // #4262
  {20,  1,   0}, // #4263
  {21,  1,   0}, // #4264
  {22,  2,   0}, // #4265
  {23,  4,   0}, // #4266
  { 7,  1,   0}, // #4267
  { 9,  1,   0}, // #4268
  {12,  1,   0}, // #4269
  {14,  1,   0}, // #4270
  {16,  1,   0}, // #4271
  {18,  1,   0}, // #4272
  {20,  1,   0}, // #4273
  {21,  1,   0}, // #4274
  {22,  2,   0}, // #4275
  {23,  4,   0}, // #4276
  { 7,  1,   0}, // #4277
  {12,  1,   0}, // #4278
  {21,  1,   0}, // #4279
  {22,  4,   0}, // #4280
  {23,  6,   0}, // #4281
  { 9,  1,   0}, // #4282
  {14,  1,   0}, // #4283
  {16,  1,   0}, // #4284
  {18,  1,   0}, // #4285
  {20,  1,   0}, // #4286
  {22,  2,   0}, // #4287
  {23,  2,   0}, // #4288
  { 9,  1,   0}, // #4289
  {14,  1,   0}, // #4290
  {16,  1,   0}, // #4291
  {17,  1,   0}, // #4292
  {18,  1,   0}, // #4293
  {20,  1,   0}, // #4294
  {21,  1,   0}, // #4295
  {22,  1,   0}, // #4296
  {23,  2,   0}, // #4297
  { 3,  1,   0}, // #4298
  { 7,  1,   0}, // #4299
  {11,  1,   0}, // #4300
  {12,  2,   0}, // #4301
  {13,  1,   0}, // #4302
  {14,  1,   0}, // #4303
  {19,  1,   0}, // #4304
  {20,  1,   0}, // #4305
  {21,  1,   0}, // #4306
  {22,  1,   0}, // #4307
  {23,  3,   0}, // #4308
  { 4,  1,   0}, // #4309
  { 9,  1,   0}, // #4310
  {11,  1,   0}, // #4311
  {14,  2,   0}, // #4312
  {15,  1,   0}, // #4313
  {16,  2,   0}, // #4314
  {18,  1,   0}, // #4315
  {19,  1,   0}, // #4316
  {20,  2,   0}, // #4317
  {22,  4,   0}, // #4318
  {23,  4,   0}, // #4319
  { 7,  1,   0}, // #4320
  { 9,  1,   0}, // #4321
  {12,  1,   0}, // #4322
  {14,  1,   0}, // #4323
  {16,  1,   0}, // #4324
  {17,  1,   0}, // #4325
  {18,  1,   0}, // #4326
  {20,  1,   0}, // #4327
  {21,  2,   0}, // #4328
  {22,  2,   0}, // #4329
  {23,  5,   0}, // #4330
  { 7,  1,   0}, // #4331
  {12,  1,   0}, // #4332
  {14,  2,   0}, // #4333
  {17,  1,   0}, // #4334
  {20,  2,   0}, // #4335
  {21,  2,   0}, // #4336
  {22,  2,   0}, // #4337
  {23,  5,   0}, // #4338
  { 7,  1,   0}, // #4339
  {12,  1,   0}, // #4340
  {17,  1,   0}, // #4341
  {21,  2,   0}, // #4342
  {22,  2,   0}, // #4343
  {23,  5,   0}, // #4344
  { 8,  1,   0}, // #4345
  { 9,  1,   0}, // #4346
  {13,  1,   0}, // #4347
  {14,  1,   0}, // #4348
  {15,  1,   0}, // #4349
  {16,  1,   0}, // #4350
  {18,  2,   0}, // #4351
  {19,  1,   0}, // #4352
  {20,  2,   0}, // #4353
  {22,  2,   0}, // #4354
  {23,  2,   0}, // #4355
  {14,  1,   0}, // #4356
  {17,  1,   0}, // #4357
  {20,  1,   0}, // #4358
  {21,  1,   0}, // #4359
  {22,  4,   0}, // #4360
  {23,  5,   0}, // #4361
  { 9,  1,   0}, // #4362
  {14,  1,   0}, // #4363
  {16,  1,   0}, // #4364
  {18,  1,   0}, // #4365
  {20,  1,   0}, // #4366
  {22,  1,   0}, // #4367
  {23,  1,   0}, // #4368
  { 7,  1,   0}, // #4369
  {12,  1,   0}, // #4370
  {15,  1,   0}, // #4371
  {19,  1,   0}, // #4372
  {21,  1,   0}, // #4373
  {22,  1,   0}, // #4374
  {23,  3,   0}, // #4375
  {14,  2,   0}, // #4376
  {20,  2,   0}, // #4377
  {22,  2,   0}, // #4378
  {23,  2,   0}, // #4379
  { 8,  2,   0}, // #4380
  {13,  2,   0}, // #4381
  {15,  2,   0}, // #4382
  {18,  2,   0}, // #4383
  {19,  2,   0}, // #4384
  {20,  2,   0}, // #4385
  {22,  3,   0}, // #4386
  {23,  3,   0}, // #4387
  { 8,  1,   0}, // #4388
  {13,  1,   0}, // #4389
  {15,  1,   0}, // #4390
  {17,  1,   0}, // #4391
  {18,  1,   0}, // #4392
  {19,  2,   0}, // #4393
  {20,  1,   0}, // #4394
  {21,  1,   0}, // #4395
  {22,  2,   0}, // #4396
  {23,  3,   0}, // #4397
  { 4,  2,   0}, // #4398
  { 9,  2,   0}, // #4399
  {11,  2,   0}, // #4400
  {14,  2,   0}, // #4401
  {15,  2,   0}, // #4402
  {16,  4,   0}, // #4403
  {17,  1,   0}, // #4404
  {18,  2,   0}, // #4405
  {19,  2,   0}, // #4406
  {20,  2,   0}, // #4407
  {21,  1,   0}, // #4408
  {22,  7,   0}, // #4409
  {23,  8,   0}, // #4410
  { 4,  1,   0}, // #4411
  { 9,  2,   0}, // #4412
  {11,  1,   0}, // #4413
  {14,  2,   0}, // #4414
  {15,  1,   0}, // #4415
  {16,  3,   0}, // #4416
  {17,  1,   0}, // #4417
  {18,  2,   0}, // #4418
  {19,  1,   0}, // #4419
  {20,  2,   0}, // #4420
  {21,  1,   0}, // #4421
  {22,  4,   0}, // #4422
  {23,  5,   0}, // #4423
  { 4,  1,   0}, // #4424
  { 9,  1,   0}, // #4425
  {11,  1,   0}, // #4426
  {14,  2,   0}, // #4427
  {15,  1,   0}, // #4428
  {16,  2,   0}, // #4429
  {18,  1,   0}, // #4430
  {19,  1,   0}, // #4431
  {20,  2,   0}, // #4432
  {22,  3,   0}, // #4433
  {23,  3,   0}, // #4434
  {14,  1,   0}, // #4435
  {20,  1,   0}, // #4436
  {22,  5,   0}, // #4437
  {23,  5,   0}, // #4438
  { 4,  1,   0}, // #4439
  {11,  1,   0}, // #4440
  {14,  4,   0}, // #4441
  {15,  2,   0}, // #4442
  {16,  1,   0}, // #4443
  {17,  1,   0}, // #4444
  {19,  2,   0}, // #4445
  {20,  4,   0}, // #4446
  {21,  2,   0}, // #4447
  {22,  8,   0}, // #4448
  {23, 10,   0}, // #4449
  { 4,  2,   0}, // #4450
  {11,  2,   0}, // #4451
  {14,  2,   0}, // #4452
  {15,  2,   0}, // #4453
  {16,  2,   0}, // #4454
  {19,  2,   0}, // #4455
  {20,  2,   0}, // #4456
  {22,  7,   0}, // #4457
  {23,  7,   0}, // #4458
  { 4,  1,   0}, // #4459
  {11,  1,   0}, // #4460
  {14,  4,   0}, // #4461
  {15,  2,   0}, // #4462
  {16,  1,   0}, // #4463
  {19,  2,   0}, // #4464
  {20,  4,   0}, // #4465
  {22,  9,   0}, // #4466
  {23,  9,   0}, // #4467
  { 4,  2,   0}, // #4468
  {11,  2,   0}, // #4469
  {14,  3,   0}, // #4470
  {15,  3,   0}, // #4471
  {16,  2,   0}, // #4472
  {19,  3,   0}, // #4473
  {20,  3,   0}, // #4474
  {22, 10,   0}, // #4475
  {23, 10,   0}, // #4476
  { 9,  3,   0}, // #4477
  {14,  3,   0}, // #4478
  {16,  3,   0}, // #4479
  {17,  1,   0}, // #4480
  {18,  3,   0}, // #4481
  {20,  3,   0}, // #4482
  {21,  1,   0}, // #4483
  {22, 18,   0}, // #4484
  {23, 19,   0}, // #4485
  { 7,  1,   0}, // #4486
  { 9,  5,   0}, // #4487
  {12,  1,   0}, // #4488
  {14,  5,   0}, // #4489
  {16,  5,   0}, // #4490
  {17,  1,   0}, // #4491
  {18,  5,   0}, // #4492
  {20,  5,   0}, // #4493
  {21,  2,   0}, // #4494
  {22, 24,   0}, // #4495
  {23, 27,   0}, // #4496
  { 7,  1,   0}, // #4497
  { 9,  6,   0}, // #4498
  {12,  1,   0}, // #4499
  {14,  6,   0}, // #4500
  {16,  6,   0}, // #4501
  {17,  1,   0}, // #4502
  {18,  6,   0}, // #4503
  {20,  6,   0}, // #4504
  {21,  2,   0}, // #4505
  {22, 25,   0}, // #4506
  {23, 28,   0}, // #4507
  { 3,  2,   0}, // #4508
  {11,  4,   0}, // #4509
  {12,  2,   0}, // #4510
  {13,  3,   0}, // #4511
  {14, 12,   0}, // #4512
  {17,  8,   0}, // #4513
  {19,  7,   0}, // #4514
  {20, 13,   0}, // #4515
  {21,  8,   0}, // #4516
  {22, 56,   0}, // #4517
  {23, 64,   0}, // #4518
  { 3,  4,   0}, // #4519
  { 9,  4,   0}, // #4520
  {11,  4,   0}, // #4521
  {12,  4,   0}, // #4522
  {13,  5,   0}, // #4523
  {14, 10,   0}, // #4524
  {15,  1,   0}, // #4525
  {16,  4,   0}, // #4526
  {17, 31,   0}, // #4527
  {18,  4,   0}, // #4528
  {19,  6,   0}, // #4529
  {20, 11,   0}, // #4530
  {21, 31,   0}, // #4531
  {22, 57,   0}, // #4532
  {23, 88,   0}, // #4533
  { 3,  9,   0}, // #4534
  { 4,  9,   0}, // #4535
  { 7, 11,   0}, // #4536
  { 8,  8,   0}, // #4537
  { 9,  1,   0}, // #4538
  {11, 18,   0}, // #4539
  {12, 20,   0}, // #4540
  {13, 17,   0}, // #4541
  {14, 31,   0}, // #4542
  {15, 17,   0}, // #4543
  {16, 10,   0}, // #4544
  {18,  9,   0}, // #4545
  {19, 26,   0}, // #4546
  {20, 39,   0}, // #4547
  {21, 11,   0}, // #4548
  {22, 78,   0}, // #4549
  {23, 100,   0}, // #4550
  { 7,  1,   0}, // #4551
  { 8,  3,   0}, // #4552
  {12,  1,   0}, // #4553
  {13,  3,   0}, // #4554
  {15,  3,   0}, // #4555
  {17,  2,   0}, // #4556
  {18,  3,   0}, // #4557
  {19,  3,   0}, // #4558
  {20,  3,   0}, // #4559
  {21,  2,   0}, // #4560
  {22,  4,   0}, // #4561
  {23,  7,   0}, // #4562
  { 7,  1,   0}, // #4563
  { 8,  3,   0}, // #4564
  {12,  1,   0}, // #4565
  {13,  3,   0}, // #4566
  {15,  3,   0}, // #4567
  {17,  4,   0}, // #4568
  {18,  3,   0}, // #4569
  {19,  3,   0}, // #4570
  {20,  3,   0}, // #4571
  {21,  4,   0}, // #4572
  {22,  4,   0}, // #4573
  {23,  9,   0}, // #4574
  { 7,  1,   0}, // #4575
  { 8,  4,   0}, // #4576
  {12,  1,   0}, // #4577
  {13,  4,   0}, // #4578
  {15,  4,   0}, // #4579
  {17,  4,   0}, // #4580
  {18,  4,   0}, // #4581
  {19,  4,   0}, // #4582
  {20,  4,   0}, // #4583
  {21,  4,   0}, // #4584
  {22,  5,   0}, // #4585
  {23, 10,   0}, // #4586
  { 7,  1,   0}, // #4587
  { 8,  4,   0}, // #4588
  {12,  1,   0}, // #4589
  {13,  4,   0}, // #4590
  {15,  4,   0}, // #4591
  {17,  8,   0}, // #4592
  {18,  4,   0}, // #4593
  {19,  4,   0}, // #4594
  {20,  4,   0}, // #4595
  {21,  8,   0}, // #4596
  {22,  5,   0}, // #4597
  {23, 14,   0}, // #4598
  { 7,  1,   0}, // #4599
  { 8,  5,   0}, // #4600
  {12,  1,   0}, // #4601
  {13,  5,   0}, // #4602
  {15,  5,   0}, // #4603
  {17,  2,   0}, // #4604
  {18,  5,   0}, // #4605
  {19,  5,   0}, // #4606
  {20,  5,   0}, // #4607
  {21,  2,   0}, // #4608
  {22,  6,   0}, // #4609
  {23,  9,   0}, // #4610
  { 9,  1,   0}, // #4611
  {14,  1,   0}, // #4612
  {16,  1,   0}, // #4613
  {17,  1,   0}, // #4614
  {18,  1,   0}, // #4615
  {20,  1,   0}, // #4616
  {21,  1,   0}, // #4617
  {22, 17,   0}, // #4618
  {23, 18,   0}, // #4619
  {14,  1,   0}, // #4620
  {17,  1,   0}, // #4621
  {20,  1,   0}, // #4622
  {21,  1,   0}, // #4623
  {22,  2,   0}, // #4624
  {23,  3,   0}, // #4625
  { 9,  1,   0}, // #4626
  {16,  1,   0}, // #4627
  { 3,  3,   0}, // #4628
  {11,  1,   0}, // #4629
  {12,  2,   0}, // #4630
  {14,  1,   0}, // #4631
  { 8,  1,   0}, // #4632
  { 9,  1,   0}, // #4633
  {12,  1,   0}, // #4634
  {14,  1,   0}, // #4635
  {15,  1,   0}, // #4636
  { 8,  2,   0}, // #4637
  { 9,  2,   0}, // #4638
  {12,  2,   0}, // #4639
  {14,  2,   0}, // #4640
  {15,  2,   0}, // #4641
  { 3,  1,   0}, // #4642
  {11,  1,   0}, // #4643
  {12,  2,   0}, // #4644
  {14,  1,   0}, // #4645
  { 3,  2,   0}, // #4646
  {11,  1,   0}, // #4647
  {12,  2,   0}, // #4648
  {14,  1,   0}, // #4649
  { 3,  2,   0}, // #4650
  {11,  1,   0}, // #4651
  {12,  1,   0}, // #4652
  { 5,  1,   0}, // #4653
  { 7,  1,   0}, // #4654
  { 9,  1,   0}, // #4655
  {10,  1,   0}, // #4656
  {11,  1,   0}, // #4657
  {12,  1,   0}, // #4658
  { 7,  1,   0}, // #4659
  { 9,  2,   0}, // #4660
  {11,  1,   0}, // #4661
  {12,  1,   0}, // #4662
  {16,  1,   0}, // #4663
  {19,  1,   0}, // #4664
  { 7,  1,   0}, // #4665
  { 9,  2,   0}, // #4666
  {16,  1,   0}, // #4667
  {19,  1,   0}, // #4668
  { 7,  1,   0}, // #4669
  { 9,  1,   0}, // #4670
  {11,  1,   0}, // #4671
  {12,  1,   0}, // #4672
  {19,  1,   0}, // #4673
  { 7,  1,   0}, // #4674
  { 9,  1,   0}, // #4675
  {19,  1,   0}, // #4676
  { 9,  4,   0}, // #4677
  {10,  4,   0}, // #4678
  {11,  1,   0}, // #4679
  {12,  1,   0}, // #4680
  { 3,  8,   0}, // #4681
  {11,  1,   0}, // #4682
  {12,  1,   0}, // #4683
  { 1,  1,   0}, // #4684
  { 3,  1,   0}, // #4685
  { 5,  1,   0}, // #4686
  { 7,  1,   0}, // #4687
  { 9,  1,   0}, // #4688
  {10,  1,   0}, // #4689
  {11,  1,   0}, // #4690
  {12,  1,   0}, // #4691
  { 3,  4,   0}, // #4692
  {11,  1,   0}, // #4693
  {12,  1,   0}, // #4694
  { 8,  1,   0}, // #4695
  { 9,  1,   0}, // #4696
  {11,  1,   0}, // #4697
  {12,  1,   0}, // #4698
  {15,  1,   0}, // #4699
  { 8,  1,   0}, // #4700
  { 9,  1,   0}, // #4701
  {15,  1,   0}, // #4702
  { 1,  1,   0}, // #4703
  { 3,  1,   0}, // #4704
  { 5,  1,   0}, // #4705
  { 7,  1,   0}, // #4706
  { 8,  1,   0}, // #4707
  { 9,  2,   0}, // #4708
  {10,  1,   0}, // #4709
  {11,  1,   0}, // #4710
  {12,  1,   0}, // #4711
  {15,  1,   0}, // #4712
  { 1,  1,   0}, // #4713
  { 3,  1,   0}, // #4714
  { 5,  1,   0}, // #4715
  { 7,  1,   0}, // #4716
  { 8,  1,   0}, // #4717
  { 9,  2,   0}, // #4718
  {10,  1,   0}, // #4719
  {15,  1,   0}, // #4720
  { 8,  1,   0}, // #4721
  { 9,  1,   0}, // #4722
  {11,  1,   0}, // #4723
  {12,  1,   0}, // #4724
  {15,  2,   0}, // #4725
  { 8,  1,   0}, // #4726
  { 9,  1,   0}, // #4727
  {15,  2,   0}, // #4728
  { 2,  1,   0}, // #4729
  { 3,  1,   0}, // #4730
  { 4, 17,   0}, // #4731
  {11,  1,   0}, // #4732
  {12,  1,   0}, // #4733
  { 2,  1,   0}, // #4734
  { 3,  1,   0}, // #4735
  { 4, 25,   0}, // #4736
  {11,  1,   0}, // #4737
  {12,  1,   0}, // #4738
  { 2,  1,   0}, // #4739
  { 3,  1,   0}, // #4740
  { 4, 41,   0}, // #4741
  {11,  1,   0}, // #4742
  {12,  1,   0}, // #4743
  { 2,  1,   0}, // #4744
  { 3,  1,   0}, // #4745
  { 4, 12,   0}, // #4746
  {11,  1,   0}, // #4747
  {12,  1,   0}, // #4748
  { 6, 19,   0}, // #4749
  { 8,  1,   0}, // #4750
  { 9,  1,   0}, // #4751
  {10, 19,   0}, // #4752
  {11,  1,   0}, // #4753
  {12,  1,   0}, // #4754
  { 5,  3,   0}, // #4755
  { 6,  3,   0}, // #4756
  { 8,  1,   0}, // #4757
  { 9,  1,   0}, // #4758
  {10,  6,   0}, // #4759
  {11,  1,   0}, // #4760
  {12,  1,   0}, // #4761
  { 9,  1,   0}, // #4762
  {11,  1,   0}, // #4763
  {12,  1,   0}, // #4764
  {16,  1,   0}, // #4765
  { 2,  1,   0}, // #4766
  { 3,  1,   0}, // #4767
  {11,  1,   0}, // #4768
  {12,  1,   0}, // #4769
  {13,  3,   0}, // #4770
  { 2,  1,   0}, // #4771
  { 3,  1,   0}, // #4772
  {13,  3,   0}, // #4773
  { 2,  1,   0}, // #4774
  { 3,  1,   0}, // #4775
  {11,  1,   0}, // #4776
  {12,  1,   0}, // #4777
  {13,  1,   0}, // #4778
  { 2,  1,   0}, // #4779
  { 3,  1,   0}, // #4780
  {11,  1,   0}, // #4781
  {12,  1,   0}, // #4782
  {13,  2,   0}, // #4783
  { 2,  1,   0}, // #4784
  { 3,  1,   0}, // #4785
  {13,  1,   0}, // #4786
  { 2,  1,   0}, // #4787
  { 3,  1,   0}, // #4788
  {13,  2,   0}, // #4789
  { 2,  1,   0}, // #4790
  { 3,  1,   0}, // #4791
  {11,  1,   0}, // #4792
  {12,  1,   0}, // #4793
  {13,  4,   0}, // #4794
  { 2,  1,   0}, // #4795
  { 3,  1,   0}, // #4796
  {13,  4,   0}, // #4797
  { 7,  1,   0}, // #4798
  { 9,  1,   0}, // #4799
  {11,  1,   0}, // #4800
  {12,  1,   0}, // #4801
  {19,  2,   0}, // #4802
  { 7,  1,   0}, // #4803
  { 9,  1,   0}, // #4804
  {19,  2,   0}, // #4805
  { 6,  2,   0}, // #4806
  { 8,  1,   0}, // #4807
  { 9,  1,   0}, // #4808
  {10,  2,   0}, // #4809
  {11,  1,   0}, // #4810
  {12,  1,   0}, // #4811
  { 6,  1,   0}, // #4812
  { 8,  1,   0}, // #4813
  { 9,  1,   0}, // #4814
  {10,  1,   0}, // #4815
  {11,  1,   0}, // #4816
  {12,  1,   0}, // #4817
  { 9,  4,   0}, // #4818
  {11,  1,   0}, // #4819
  {12,  1,   0}, // #4820
  {16,  4,   0}, // #4821
  { 9,  4,   0}, // #4822
  {16,  4,   0}, // #4823
  { 1,  1,   0}, // #4824
  { 3,  1,   0}, // #4825
  { 5,  1,   0}, // #4826
  { 8,  1,   0}, // #4827
  { 9,  1,   0}, // #4828
  {10,  1,   0}, // #4829
  {11,  3,   0}, // #4830
  {12,  5,   0}, // #4831
  {14,  2,   0}, // #4832
  {16, 10,   0}, // #4833
  {18,  4,   0}, // #4834
  { 1,  1,   0}, // #4835
  { 3,  1,   0}, // #4836
  { 5,  1,   0}, // #4837
  { 8,  1,   0}, // #4838
  { 9,  1,   0}, // #4839
  {10,  1,   0}, // #4840
  {11,  2,   0}, // #4841
  {12,  4,   0}, // #4842
  {14,  2,   0}, // #4843
  {16, 10,   0}, // #4844
  {18,  4,   0}, // #4845
  { 1,  1,   0}, // #4846
  { 3,  1,   0}, // #4847
  { 5,  1,   0}, // #4848
  { 7,  1,   0}, // #4849
  { 8,  2,   0}, // #4850
  { 9,  3,   0}, // #4851
  {10,  1,   0}, // #4852
  {11,  1,   0}, // #4853
  {12,  1,   0}, // #4854
  {16,  2,   0}, // #4855
  {18,  2,   0}, // #4856
  { 1,  1,   0}, // #4857
  { 3,  1,   0}, // #4858
  { 5,  1,   0}, // #4859
  { 7,  1,   0}, // #4860
  { 8,  2,   0}, // #4861
  { 9,  3,   0}, // #4862
  {10,  1,   0}, // #4863
  {16,  2,   0}, // #4864
  {18,  2,   0}, // #4865
  { 7,  2,   0}, // #4866
  { 9,  3,   0}, // #4867
  {11,  1,   0}, // #4868
  {12,  1,   0}, // #4869
  {16,  1,   0}, // #4870
  {19,  2,   0}, // #4871
  { 7,  2,   0}, // #4872
  { 9,  3,   0}, // #4873
  {16,  1,   0}, // #4874
  {19,  2,   0}, // #4875
  { 9,  1,   0}, // #4876
  {11,  1,   0}, // #4877
  {12,  1,   0}, // #4878
  {16,  4,   0}, // #4879
  { 9,  1,   0}, // #4880
  {16,  4,   0}, // #4881
  { 3,  1,   0}, // #4882
  {12,  1,   0}, // #4883
  {14,  1,   0}, // #4884
  { 3, 22,   0}, // #4885
  {11,  1,   0}, // #4886
  {12,  1,   0}, // #4887
  { 6, 27,   0}, // #4888
  { 8,  1,   0}, // #4889
  { 9,  1,   0}, // #4890
  {10, 27,   0}, // #4891
  {11,  1,   0}, // #4892
  {12,  1,   0}, // #4893
  { 6, 21,   0}, // #4894
  { 8,  1,   0}, // #4895
  { 9,  1,   0}, // #4896
  {10, 21,   0}, // #4897
  {11,  1,   0}, // #4898
  {12,  1,   0}, // #4899
  { 6, 35,   0}, // #4900
  { 8,  1,   0}, // #4901
  { 9,  1,   0}, // #4902
  {10, 35,   0}, // #4903
  { 5,  2,   0}, // #4904
  { 7,  2,   0}, // #4905
  { 9,  2,   0}, // #4906
  {10,  2,   0}, // #4907
  {11,  2,   0}, // #4908
  {12,  2,   0}, // #4909
  { 8,  2,   0}, // #4910
  { 9,  2,   0}, // #4911
  {15,  2,   0}, // #4912
  { 9,  6,   0}, // #4913
  {10,  6,   0}, // #4914
  {11,  2,   0}, // #4915
  {12,  2,   0}, // #4916
  { 9,  2,   0}, // #4917
  {10,  2,   0}, // #4918
  {11,  1,   0}, // #4919
  {12,  1,   0}, // #4920
  { 8,  2,   0}, // #4921
  { 9,  2,   0}, // #4922
  {11,  2,   0}, // #4923
  {12,  2,   0}, // #4924
  {15,  2,   0}, // #4925
  { 8,  2,   0}, // #4926
  { 9,  2,   0}, // #4927
  {10,  4,   0}, // #4928
  {11,  2,   0}, // #4929
  {12,  2,   0}, // #4930
  {15,  2,   0}, // #4931
  { 8,  2,   0}, // #4932
  { 9,  2,   0}, // #4933
  {10,  4,   0}, // #4934
  {15,  2,   0}, // #4935
  { 8,  2,   0}, // #4936
  { 9,  2,   0}, // #4937
  {10,  2,   0}, // #4938
  {12,  1,   0}, // #4939
  {14,  1,   0}, // #4940
  {15,  2,   0}, // #4941
  { 8,  2,   0}, // #4942
  { 9,  2,   0}, // #4943
  {10,  2,   0}, // #4944
  {15,  2,   0}, // #4945
  { 6, 38,   0}, // #4946
  { 8,  2,   0}, // #4947
  { 9,  2,   0}, // #4948
  {10, 38,   0}, // #4949
  {11,  2,   0}, // #4950
  {12,  2,   0}, // #4951
  { 5,  6,   0}, // #4952
  { 6,  6,   0}, // #4953
  { 8,  2,   0}, // #4954
  { 9,  2,   0}, // #4955
  {10, 12,   0}, // #4956
  {11,  2,   0}, // #4957
  {12,  2,   0}, // #4958
  { 3,  4,   0}, // #4959
  { 5,  1,   0}, // #4960
  { 7,  1,   0}, // #4961
  { 8,  4,   0}, // #4962
  { 9,  5,   0}, // #4963
  {10,  1,   0}, // #4964
  {11,  4,   0}, // #4965
  {12,  8,   0}, // #4966
  {14,  4,   0}, // #4967
  {15,  4,   0}, // #4968
  { 9,  4,   0}, // #4969
  {10,  4,   0}, // #4970
  {11,  2,   0}, // #4971
  {12,  2,   0}, // #4972
  { 3,  2,   0}, // #4973
  { 5,  1,   0}, // #4974
  { 7,  1,   0}, // #4975
  { 8,  2,   0}, // #4976
  { 9,  3,   0}, // #4977
  {10,  1,   0}, // #4978
  {11,  2,   0}, // #4979
  {12,  4,   0}, // #4980
  {14,  2,   0}, // #4981
  {15,  2,   0}, // #4982
  { 3,  8,   0}, // #4983
  { 5,  1,   0}, // #4984
  { 7,  1,   0}, // #4985
  { 8, 10,   0}, // #4986
  { 9, 11,   0}, // #4987
  {10,  1,   0}, // #4988
  {11,  8,   0}, // #4989
  {12, 16,   0}, // #4990
  {14,  8,   0}, // #4991
  {15, 10,   0}, // #4992
  { 3,  4,   0}, // #4993
  { 5,  1,   0}, // #4994
  { 7,  1,   0}, // #4995
  { 8,  5,   0}, // #4996
  { 9,  6,   0}, // #4997
  {10,  1,   0}, // #4998
  {11,  4,   0}, // #4999
  {12,  8,   0}, // #5000
  {14,  4,   0}, // #5001
  {15,  5,   0}, // #5002
  { 9,  2,   0}, // #5003
  {16,  2,   0}, // #5004
  { 6,  4,   0}, // #5005
  { 8,  2,   0}, // #5006
  { 9,  2,   0}, // #5007
  {10,  4,   0}, // #5008
  {11,  2,   0}, // #5009
  {12,  2,   0}, // #5010
  { 6,  2,   0}, // #5011
  { 8,  2,   0}, // #5012
  { 9,  2,   0}, // #5013
  {10,  2,   0}, // #5014
  {11,  2,   0}, // #5015
  {12,  2,   0}, // #5016
  { 9,  2,   0}, // #5017
  {10,  6,   0}, // #5018
  {11,  2,   0}, // #5019
  {12,  2,   0}, // #5020
  { 9,  1,   0}, // #5021
  {10,  4,   0}, // #5022
  {11,  1,   0}, // #5023
  {12,  1,   0}, // #5024
  { 9,  4,   0}, // #5025
  {11,  2,   0}, // #5026
  {12,  2,   0}, // #5027
  {16,  4,   0}, // #5028
  { 9,  2,   0}, // #5029
  {11,  1,   0}, // #5030
  {12,  1,   0}, // #5031
  {16,  2,   0}, // #5032
  { 1,  1,   0}, // #5033
  { 3,  1,   0}, // #5034
  { 5,  2,   0}, // #5035
  { 9,  2,   0}, // #5036
  {10,  4,   0}, // #5037
  {11,  2,   0}, // #5038
  {12,  2,   0}, // #5039
  { 6, 54,   0}, // #5040
  { 8,  2,   0}, // #5041
  { 9,  2,   0}, // #5042
  {10, 54,   0}, // #5043
  {11,  2,   0}, // #5044
  {12,  2,   0}, // #5045
  { 6, 42,   0}, // #5046
  { 8,  2,   0}, // #5047
  { 9,  2,   0}, // #5048
  {10, 42,   0}, // #5049
  {11,  2,   0}, // #5050
  {12,  2,   0}, // #5051
  { 3,  2,   0}, // #5052
  {11, 16,   0}, // #5053
  {12, 32,   0}, // #5054
  {14, 16,   0}, // #5055
  { 9,  2,   0}, // #5056
  {10,  4,   0}, // #5057
  {11,  1,   0}, // #5058
  {12,  1,   0}, // #5059
  { 3, 42,   0}, // #5060
  { 5,  1,   0}, // #5061
  { 7,  1,   0}, // #5062
  { 8,  2,   0}, // #5063
  { 9,  3,   0}, // #5064
  {10,  1,   0}, // #5065
  {11,  2,   0}, // #5066
  {12, 18,   0}, // #5067
  {14, 16,   0}, // #5068
  {15,  2,   0}, // #5069
  { 3,  3,   0}, // #5070
  {11, 19,   0}, // #5071
  {12, 38,   0}, // #5072
  {14, 19,   0}, // #5073
  { 3,  6,   0}, // #5074
  {11, 38,   0}, // #5075
  {12, 76,   0}, // #5076
  {14, 38,   0}, // #5077
  { 3,  3,   0}, // #5078
  {11, 16,   0}, // #5079
  {12, 32,   0}, // #5080
  {14, 16,   0}, // #5081
  { 3,  3,   0}, // #5082
  {11, 17,   0}, // #5083
  {12, 34,   0}, // #5084
  {14, 17,   0}, // #5085
  { 3,  6,   0}, // #5086
  {11,  1,   0}, // #5087
  {12,  2,   0}, // #5088
  {14,  1,   0}, // #5089
  { 2,  1,   0}, // #5090
  { 3,  1,   0}, // #5091
  {12,  1,   0}, // #5092
  {14,  1,   0}, // #5093
  { 3,  1,   0}, // #5094
  {11, 19,   0}, // #5095
  {12, 38,   0}, // #5096
  {14, 19,   0}, // #5097
  {13,  1,   0}, // #5098
  {19,  1,   0}, // #5099
  {20,  1,   0}, // #5100
  {22,  1,   0}, // #5101
  {23,  1,   0}, // #5102
  { 3,  3,   0}, // #5103
  { 8,  6,   0}, // #5104
  {11,  3,   0}, // #5105
  {12,  3,   0}, // #5106
  {13,  9,   0}, // #5107
  {14,  3,   0}, // #5108
  {15,  6,   0}, // #5109
  {17,  1,   0}, // #5110
  {18,  6,   0}, // #5111
  {19, 10,   0}, // #5112
  {20,  9,   0}, // #5113
  {21,  1,   0}, // #5114
  {22, 10,   0}, // #5115
  {23, 11,   0}, // #5116
  { 3,  3,   0}, // #5117
  { 8,  6,   0}, // #5118
  {11,  3,   0}, // #5119
  {12,  3,   0}, // #5120
  {13,  9,   0}, // #5121
  {14,  3,   0}, // #5122
  {15,  6,   0}, // #5123
  {18,  6,   0}, // #5124
  {19, 11,   0}, // #5125
  {20,  9,   0}, // #5126
  {22, 11,   0}, // #5127
  {23, 11,   0}, // #5128
  { 8,  1,   0}, // #5129
  {11,  1,   0}, // #5130
  {13,  1,   0}, // #5131
  {15,  1,   0}, // #5132
  {17,  1,   0}, // #5133
  {18,  1,   0}, // #5134
  {19,  2,   0}, // #5135
  {20,  1,   0}, // #5136
  {21,  1,   0}, // #5137
  {22,  2,   0}, // #5138
  {23,  3,   0}, // #5139
  { 8,  1,   0}, // #5140
  {11,  1,   0}, // #5141
  {13,  1,   0}, // #5142
  {15,  1,   0}, // #5143
  {18,  1,   0}, // #5144
  {19,  2,   0}, // #5145
  {20,  1,   0}, // #5146
  {22,  2,   0}, // #5147
  {23,  2,   0}, // #5148
  {11,  2,   0}, // #5149
  {17,  1,   0}, // #5150
  {19,  2,   0}, // #5151
  {21,  1,   0}, // #5152
  {22,  2,   0}, // #5153
  {23,  3,   0}, // #5154
  { 1, 10,   0}, // #5155
  { 3,  1,   0}, // #5156
  {11,  1,   0}, // #5157
  {12,  1,   0}, // #5158
  {13,  1,   0}, // #5159
  {14,  1,   0}, // #5160
  {17,  1,   0}, // #5161
  {19,  1,   0}, // #5162
  {20,  1,   0}, // #5163
  {21,  1,   0}, // #5164
  {22,  1,   0}, // #5165
  {23,  2,   0}, // #5166
  { 3,  7,   0}, // #5167
  { 4,  2,   0}, // #5168
  { 8,  8,   0}, // #5169
  { 9,  3,   0}, // #5170
  {11,  9,   0}, // #5171
  {12,  7,   0}, // #5172
  {13, 16,   0}, // #5173
  {14, 10,   0}, // #5174
  {15, 10,   0}, // #5175
  {16,  5,   0}, // #5176
  {18, 11,   0}, // #5177
  {19, 18,   0}, // #5178
  {20, 19,   0}, // #5179
  {22, 32,   0}, // #5180
  {23, 32,   0}, // #5181
  { 2,  4,   0}, // #5182
  { 3,  1,   0}, // #5183
  {11,  1,   0}, // #5184
  {12,  1,   0}, // #5185
  {13,  1,   0}, // #5186
  {14,  1,   0}, // #5187
  {17,  1,   0}, // #5188
  {19,  1,   0}, // #5189
  {20,  1,   0}, // #5190
  {21,  1,   0}, // #5191
  {22,  1,   0}, // #5192
  {23,  2,   0}, // #5193
  { 2,  3,   0}, // #5194
  { 3,  1,   0}, // #5195
  {11,  1,   0}, // #5196
  {12,  1,   0}, // #5197
  {13,  1,   0}, // #5198
  {14,  1,   0}, // #5199
  {17,  1,   0}, // #5200
  {19,  1,   0}, // #5201
  {20,  1,   0}, // #5202
  {21,  1,   0}, // #5203
  {22,  1,   0}, // #5204
  {23,  2,   0}, // #5205
  { 8,  1,   0}, // #5206
  {13,  1,   0}, // #5207
  {15,  1,   0}, // #5208
  {17,  1,   0}, // #5209
  {18,  1,   0}, // #5210
  {19,  3,   0}, // #5211
  {20,  1,   0}, // #5212
  {21,  1,   0}, // #5213
  {22,  3,   0}, // #5214
  {23,  4,   0}, // #5215
  { 8,  1,   0}, // #5216
  {13,  1,   0}, // #5217
  {15,  1,   0}, // #5218
  {18,  1,   0}, // #5219
  {19,  3,   0}, // #5220
  {20,  1,   0}, // #5221
  {22,  3,   0}, // #5222
  {23,  3,   0}, // #5223
  { 8,  1,   0}, // #5224
  {13,  1,   0}, // #5225
  {15,  1,   0}, // #5226
  {17,  1,   0}, // #5227
  {18,  1,   0}, // #5228
  {19,  4,   0}, // #5229
  {20,  1,   0}, // #5230
  {21,  1,   0}, // #5231
  {22,  4,   0}, // #5232
  {23,  5,   0}, // #5233
  { 8,  1,   0}, // #5234
  {13,  1,   0}, // #5235
  {15,  1,   0}, // #5236
  {18,  1,   0}, // #5237
  {19,  4,   0}, // #5238
  {20,  1,   0}, // #5239
  {22,  4,   0}, // #5240
  {23,  4,   0}, // #5241
  {13,  9,   0}, // #5242
  {19,  9,   0}, // #5243
  {20,  9,   0}, // #5244
  {22, 10,   0}, // #5245
  {23, 10,   0}, // #5246
  {13,  2,   0}, // #5247
  {19,  2,   0}, // #5248
  {20,  2,   0}, // #5249
  {22,  2,   0}, // #5250
  {23,  2,   0}, // #5251
  { 8,  2,   0}, // #5252
  {13,  2,   0}, // #5253
  {15,  2,   0}, // #5254
  {17,  1,   0}, // #5255
  {18,  2,   0}, // #5256
  {19,  3,   0}, // #5257
  {20,  2,   0}, // #5258
  {21,  1,   0}, // #5259
  {22,  3,   0}, // #5260
  {23,  4,   0}, // #5261
  { 8,  2,   0}, // #5262
  {13,  2,   0}, // #5263
  {15,  2,   0}, // #5264
  {18,  2,   0}, // #5265
  {19,  3,   0}, // #5266
  {20,  2,   0}, // #5267
  {22,  3,   0}, // #5268
  {23,  3,   0}, // #5269
  { 3,  2,   0}, // #5270
  { 8,  4,   0}, // #5271
  {11,  2,   0}, // #5272
  {12,  2,   0}, // #5273
  {13,  6,   0}, // #5274
  {14,  2,   0}, // #5275
  {15,  4,   0}, // #5276
  {17,  1,   0}, // #5277
  {18,  4,   0}, // #5278
  {19,  6,   0}, // #5279
  {20,  6,   0}, // #5280
  {21,  1,   0}, // #5281
  {22,  7,   0}, // #5282
  {23,  8,   0}, // #5283
  { 3,  4,   0}, // #5284
  { 4,  2,   0}, // #5285
  { 8,  4,   0}, // #5286
  { 9,  8,   0}, // #5287
  {11,  6,   0}, // #5288
  {12,  4,   0}, // #5289
  {13,  8,   0}, // #5290
  {14, 26,   0}, // #5291
  {15,  6,   0}, // #5292
  {16, 10,   0}, // #5293
  {18, 12,   0}, // #5294
  {19, 10,   0}, // #5295
  {20, 30,   0}, // #5296
  {22, 66,   0}, // #5297
  {23, 66,   0}, // #5298
  {13,  1,   0}, // #5299
  {17,  1,   0}, // #5300
  {19,  1,   0}, // #5301
  {20,  1,   0}, // #5302
  {21,  1,   0}, // #5303
  {22,  1,   0}, // #5304
  {23,  2,   0}, // #5305
  { 8,  2,   0}, // #5306
  {13,  3,   0}, // #5307
  {15,  2,   0}, // #5308
  {17,  1,   0}, // #5309
  {18,  2,   0}, // #5310
  {19,  3,   0}, // #5311
  {20,  3,   0}, // #5312
  {21,  1,   0}, // #5313
  {22,  3,   0}, // #5314
  {23,  4,   0}, // #5315
  { 8,  2,   0}, // #5316
  {13,  3,   0}, // #5317
  {15,  2,   0}, // #5318
  {18,  2,   0}, // #5319
  {19,  3,   0}, // #5320
  {20,  3,   0}, // #5321
  {22,  3,   0}, // #5322
  {23,  3,   0}, // #5323
  { 7,  1,   0}, // #5324
  {12,  1,   0}, // #5325
  {14,  3,   0}, // #5326
  {17,  1,   0}, // #5327
  {20,  3,   0}, // #5328
  {21,  2,   0}, // #5329
  {22,  3,   0}, // #5330
  {23,  6,   0}, // #5331
  {14,  6,   0}, // #5332
  {17,  1,   0}, // #5333
  {20,  6,   0}, // #5334
  {21,  1,   0}, // #5335
  {22,  6,   0}, // #5336
  {23,  7,   0}, // #5337
  {14,  3,   0}, // #5338
  {20,  3,   0}, // #5339
  {22,  3,   0}, // #5340
  {23,  3,   0}, // #5341
  { 4,  1,   0}, // #5342
  {11,  1,   0}, // #5343
  {14,  2,   0}, // #5344
  {15,  1,   0}, // #5345
  {16,  1,   0}, // #5346
  {17,  1,   0}, // #5347
  {19,  1,   0}, // #5348
  {20,  2,   0}, // #5349
  {21,  2,   0}, // #5350
  {22,  4,   0}, // #5351
  {23,  6,   0}, // #5352
  { 4,  1,   0}, // #5353
  {11,  1,   0}, // #5354
  {14,  2,   0}, // #5355
  {15,  1,   0}, // #5356
  {16,  1,   0}, // #5357
  {19,  1,   0}, // #5358
  {20,  2,   0}, // #5359
  {22,  4,   0}, // #5360
  {23,  4,   0}, // #5361
  { 2,  6,   0}, // #5362
  { 3,  1,   0}, // #5363
  {11,  1,   0}, // #5364
  {12,  1,   0}, // #5365
  {13,  1,   0}, // #5366
  {14,  1,   0}, // #5367
  {17,  1,   0}, // #5368
  {19,  1,   0}, // #5369
  {20,  1,   0}, // #5370
  {21,  1,   0}, // #5371
  {22,  1,   0}, // #5372
  {23,  2,   0}, // #5373
  { 2,  6,   0}, // #5374
  { 3,  1,   0}, // #5375
  {11,  1,   0}, // #5376
  {12,  1,   0}, // #5377
  {13,  1,   0}, // #5378
  {14,  1,   0}, // #5379
  {19,  1,   0}, // #5380
  {20,  1,   0}, // #5381
  {22,  1,   0}, // #5382
  {23,  1,   0}, // #5383
  { 8,  1,   0}, // #5384
  {13,  2,   0}, // #5385
  {15,  1,   0}, // #5386
  {17,  1,   0}, // #5387
  {18,  1,   0}, // #5388
  {19,  2,   0}, // #5389
  {20,  2,   0}, // #5390
  {21,  1,   0}, // #5391
  {22,  2,   0}, // #5392
  {23,  3,   0}, // #5393
  { 8,  1,   0}, // #5394
  {13,  2,   0}, // #5395
  {15,  1,   0}, // #5396
  {18,  1,   0}, // #5397
  {19,  2,   0}, // #5398
  {20,  2,   0}, // #5399
  {22,  2,   0}, // #5400
  {23,  2,   0}, // #5401
  {13,  2,   0}, // #5402
  {17,  1,   0}, // #5403
  {19,  2,   0}, // #5404
  {20,  2,   0}, // #5405
  {21,  1,   0}, // #5406
  {22,  2,   0}, // #5407
  {23,  3,   0}, // #5408
  { 7,  1,   0}, // #5409
  { 8,  1,   0}, // #5410
  {11,  1,   0}, // #5411
  {12,  1,   0}, // #5412
  {13,  1,   0}, // #5413
  {15,  1,   0}, // #5414
  {18,  1,   0}, // #5415
  {19,  2,   0}, // #5416
  {20,  1,   0}, // #5417
  {21,  1,   0}, // #5418
  {22,  2,   0}, // #5419
  {23,  4,   0}, // #5420
  { 7,  1,   0}, // #5421
  { 8,  1,   0}, // #5422
  {12,  1,   0}, // #5423
  {13,  2,   0}, // #5424
  {15,  1,   0}, // #5425
  {18,  1,   0}, // #5426
  {19,  2,   0}, // #5427
  {20,  2,   0}, // #5428
  {21,  1,   0}, // #5429
  {22,  2,   0}, // #5430
  {23,  4,   0}, // #5431
  { 2, 16,   0}, // #5432
  { 3,  2,   0}, // #5433
  { 8,  1,   0}, // #5434
  {11,  2,   0}, // #5435
  {12,  2,   0}, // #5436
  {13,  3,   0}, // #5437
  {14,  2,   0}, // #5438
  {15,  1,   0}, // #5439
  {17,  1,   0}, // #5440
  {18,  1,   0}, // #5441
  {19,  3,   0}, // #5442
  {20,  3,   0}, // #5443
  {21,  1,   0}, // #5444
  {22,  3,   0}, // #5445
  {23,  4,   0}, // #5446
  { 2, 16,   0}, // #5447
  { 3,  2,   0}, // #5448
  { 8,  1,   0}, // #5449
  {11,  2,   0}, // #5450
  {12,  2,   0}, // #5451
  {13,  3,   0}, // #5452
  {14,  2,   0}, // #5453
  {15,  1,   0}, // #5454
  {18,  1,   0}, // #5455
  {19,  3,   0}, // #5456
  {20,  3,   0}, // #5457
  {22,  3,   0}, // #5458
  {23,  3,   0}, // #5459
  { 2, 10,   0}, // #5460
  { 3,  2,   0}, // #5461
  { 8,  1,   0}, // #5462
  {11,  2,   0}, // #5463
  {12,  2,   0}, // #5464
  {13,  3,   0}, // #5465
  {14,  2,   0}, // #5466
  {15,  1,   0}, // #5467
  {17,  1,   0}, // #5468
  {18,  1,   0}, // #5469
  {19,  3,   0}, // #5470
  {20,  3,   0}, // #5471
  {21,  1,   0}, // #5472
  {22,  3,   0}, // #5473
  {23,  4,   0}, // #5474
  { 2, 10,   0}, // #5475
  { 3,  2,   0}, // #5476
  { 8,  1,   0}, // #5477
  {11,  2,   0}, // #5478
  {12,  2,   0}, // #5479
  {13,  3,   0}, // #5480
  {14,  2,   0}, // #5481
  {15,  1,   0}, // #5482
  {18,  1,   0}, // #5483
  {19,  3,   0}, // #5484
  {20,  3,   0}, // #5485
  {22,  3,   0}, // #5486
  {23,  3,   0}, // #5487
  { 3,  1,   0}, // #5488
  { 7,  1,   0}, // #5489
  {11,  1,   0}, // #5490
  {12,  2,   0}, // #5491
  {13,  1,   0}, // #5492
  {14,  1,   0}, // #5493
  {17,  1,   0}, // #5494
  {19,  1,   0}, // #5495
  {20,  1,   0}, // #5496
  {21,  1,   0}, // #5497
  {22,  1,   0}, // #5498
  {23,  3,   0}, // #5499
  { 2, 12,   0}, // #5500
  { 3,  1,   0}, // #5501
  {11,  1,   0}, // #5502
  {12,  1,   0}, // #5503
  {13,  1,   0}, // #5504
  {14,  1,   0}, // #5505
  {17,  1,   0}, // #5506
  {19,  1,   0}, // #5507
  {20,  1,   0}, // #5508
  {21,  1,   0}, // #5509
  {22,  1,   0}, // #5510
  {23,  2,   0}, // #5511
  { 2, 12,   0}, // #5512
  { 3,  1,   0}, // #5513
  {11,  1,   0}, // #5514
  {12,  1,   0}, // #5515
  {13,  1,   0}, // #5516
  {14,  1,   0}, // #5517
  {19,  1,   0}, // #5518
  {20,  1,   0}, // #5519
  {22,  1,   0}, // #5520
  {23,  1,   0}, // #5521
  { 2, 24,   0}, // #5522
  { 3,  2,   0}, // #5523
  { 8,  1,   0}, // #5524
  {11,  2,   0}, // #5525
  {12,  2,   0}, // #5526
  {13,  3,   0}, // #5527
  {14,  2,   0}, // #5528
  {15,  1,   0}, // #5529
  {17,  1,   0}, // #5530
  {18,  1,   0}, // #5531
  {19,  3,   0}, // #5532
  {20,  3,   0}, // #5533
  {21,  1,   0}, // #5534
  {22,  3,   0}, // #5535
  {23,  4,   0}, // #5536
  { 2, 24,   0}, // #5537
  { 3,  2,   0}, // #5538
  { 8,  1,   0}, // #5539
  {11,  2,   0}, // #5540
  {12,  2,   0}, // #5541
  {13,  3,   0}, // #5542
  {14,  2,   0}, // #5543
  {15,  1,   0}, // #5544
  {18,  1,   0}, // #5545
  {19,  3,   0}, // #5546
  {20,  3,   0}, // #5547
  {22,  3,   0}, // #5548
  {23,  3,   0}, // #5549
  { 2, 12,   0}, // #5550
  { 3,  2,   0}, // #5551
  { 8,  1,   0}, // #5552
  {11,  2,   0}, // #5553
  {12,  2,   0}, // #5554
  {13,  3,   0}, // #5555
  {14,  2,   0}, // #5556
  {15,  1,   0}, // #5557
  {17,  1,   0}, // #5558
  {18,  1,   0}, // #5559
  {19,  3,   0}, // #5560
  {20,  3,   0}, // #5561
  {21,  1,   0}, // #5562
  {22,  3,   0}, // #5563
  {23,  4,   0}, // #5564
  { 2, 12,   0}, // #5565
  { 3,  2,   0}, // #5566
  { 8,  1,   0}, // #5567
  {11,  2,   0}, // #5568
  {12,  2,   0}, // #5569
  {13,  3,   0}, // #5570
  {14,  2,   0}, // #5571
  {15,  1,   0}, // #5572
  {18,  1,   0}, // #5573
  {19,  3,   0}, // #5574
  {20,  3,   0}, // #5575
  {22,  3,   0}, // #5576
  {23,  3,   0}, // #5577
  { 4,  2,   0}, // #5578
  {11,  2,   0}, // #5579
  {14,  4,   0}, // #5580
  {15,  3,   0}, // #5581
  {16,  2,   0}, // #5582
  {17,  1,   0}, // #5583
  {19,  3,   0}, // #5584
  {20,  4,   0}, // #5585
  {21,  2,   0}, // #5586
  {22,  9,   0}, // #5587
  {23, 11,   0}, // #5588
  { 3,  2,   0}, // #5589
  { 4,  1,   0}, // #5590
  { 8,  2,   0}, // #5591
  { 9,  4,   0}, // #5592
  {11,  3,   0}, // #5593
  {12,  2,   0}, // #5594
  {13,  6,   0}, // #5595
  {14,  6,   0}, // #5596
  {15,  3,   0}, // #5597
  {16,  5,   0}, // #5598
  {18,  6,   0}, // #5599
  {19,  7,   0}, // #5600
  {20, 10,   0}, // #5601
  {22, 15,   0}, // #5602
  {23, 15,   0}, // #5603
  { 8,  2,   0}, // #5604
  {11,  1,   0}, // #5605
  {13,  2,   0}, // #5606
  {15,  2,   0}, // #5607
  {18,  2,   0}, // #5608
  {19,  3,   0}, // #5609
  {20,  2,   0}, // #5610
  {22,  3,   0}, // #5611
  {23,  3,   0}, // #5612
  { 3,  1,   0}, // #5613
  { 8,  1,   0}, // #5614
  {11,  2,   0}, // #5615
  {12,  1,   0}, // #5616
  {13,  2,   0}, // #5617
  {14,  1,   0}, // #5618
  {15,  1,   0}, // #5619
  {18,  1,   0}, // #5620
  {19,  3,   0}, // #5621
  {20,  2,   0}, // #5622
  {22,  3,   0}, // #5623
  {23,  3,   0}, // #5624
  { 7,  1,   0}, // #5625
  { 9,  1,   0}, // #5626
  {12,  1,   0}, // #5627
  {14,  2,   0}, // #5628
  {16,  1,   0}, // #5629
  {17,  1,   0}, // #5630
  {18,  1,   0}, // #5631
  {20,  2,   0}, // #5632
  {21,  2,   0}, // #5633
  {22,  5,   0}, // #5634
  {23,  8,   0}, // #5635
  { 3,  1,   0}, // #5636
  {11,  1,   0}, // #5637
  {12,  1,   0}, // #5638
  {13,  2,   0}, // #5639
  {14,  1,   0}, // #5640
  {17,  1,   0}, // #5641
  {19,  2,   0}, // #5642
  {20,  2,   0}, // #5643
  {21,  1,   0}, // #5644
  {22,  2,   0}, // #5645
  {23,  3,   0}, // #5646
  { 9,  1,   0}, // #5647
  {14,  1,   0}, // #5648
  {16,  1,   0}, // #5649
  {18,  1,   0}, // #5650
  {20,  1,   0}, // #5651
  {22,  4,   0}, // #5652
  {23,  4,   0}, // #5653
  { 9,  1,   0}, // #5654
  {14,  4,   0}, // #5655
  {15,  1,   0}, // #5656
  {16,  1,   0}, // #5657
  {18,  1,   0}, // #5658
  {19,  1,   0}, // #5659
  {20,  4,   0}, // #5660
  {22,  7,   0}, // #5661
  {23,  7,   0}, // #5662
  { 8,  1,   0}, // #5663
  { 9,  2,   0}, // #5664
  {13,  1,   0}, // #5665
  {14,  2,   0}, // #5666
  {15,  1,   0}, // #5667
  {16,  2,   0}, // #5668
  {18,  3,   0}, // #5669
  {19,  1,   0}, // #5670
  {20,  3,   0}, // #5671
  {22, 10,   0}, // #5672
  {23, 10,   0}, // #5673
  { 8,  6,   0}, // #5674
  {13,  9,   0}, // #5675
  {15,  6,   0}, // #5676
  {18,  6,   0}, // #5677
  {19,  9,   0}, // #5678
  {20,  9,   0}, // #5679
  {22, 15,   0}, // #5680
  {23, 15,   0}, // #5681
  { 4,  1,   0}, // #5682
  { 9,  5,   0}, // #5683
  {11,  1,   0}, // #5684
  {13,  4,   0}, // #5685
  {14,  5,   0}, // #5686
  {15,  1,   0}, // #5687
  {16,  6,   0}, // #5688
  {18,  5,   0}, // #5689
  {19,  5,   0}, // #5690
  {20,  9,   0}, // #5691
  {22, 10,   0}, // #5692
  {23, 10,   0}, // #5693
  { 4,  1,   0}, // #5694
  { 9,  1,   0}, // #5695
  {11,  1,   0}, // #5696
  {14,  1,   0}, // #5697
  {15,  1,   0}, // #5698
  {16,  2,   0}, // #5699
  {18,  1,   0}, // #5700
  {19,  1,   0}, // #5701
  {20,  1,   0}, // #5702
  {22,  4,   0}, // #5703
  {23,  4,   0}, // #5704
  { 4,  1,   0}, // #5705
  {11,  1,   0}, // #5706
  {14,  5,   0}, // #5707
  {15,  2,   0}, // #5708
  {16,  1,   0}, // #5709
  {17,  1,   0}, // #5710
  {19,  2,   0}, // #5711
  {20,  5,   0}, // #5712
  {21,  2,   0}, // #5713
  {22,  8,   0}, // #5714
  {23, 10,   0}, // #5715
  { 4,  2,   0}, // #5716
  {11,  2,   0}, // #5717
  {14,  3,   0}, // #5718
  {15,  2,   0}, // #5719
  {16,  2,   0}, // #5720
  {19,  2,   0}, // #5721
  {20,  3,   0}, // #5722
  {22,  7,   0}, // #5723
  {23,  7,   0}, // #5724
  { 4,  1,   0}, // #5725
  {11,  1,   0}, // #5726
  {14,  5,   0}, // #5727
  {15,  2,   0}, // #5728
  {16,  1,   0}, // #5729
  {19,  2,   0}, // #5730
  {20,  5,   0}, // #5731
  {22,  9,   0}, // #5732
  {23,  9,   0}, // #5733
  { 4,  2,   0}, // #5734
  {11,  2,   0}, // #5735
  {14,  4,   0}, // #5736
  {15,  3,   0}, // #5737
  {16,  2,   0}, // #5738
  {19,  3,   0}, // #5739
  {20,  4,   0}, // #5740
  {22, 10,   0}, // #5741
  {23, 10,   0}, // #5742
  { 4,  1,   0}, // #5743
  { 9,  8,   0}, // #5744
  {11,  1,   0}, // #5745
  {14,  8,   0}, // #5746
  {15,  1,   0}, // #5747
  {16,  9,   0}, // #5748
  {17,  1,   0}, // #5749
  {18,  8,   0}, // #5750
  {19,  1,   0}, // #5751
  {20,  8,   0}, // #5752
  {21,  1,   0}, // #5753
  {22, 30,   0}, // #5754
  {23, 31,   0}, // #5755
  { 7,  1,   0}, // #5756
  { 9, 10,   0}, // #5757
  {12,  1,   0}, // #5758
  {14, 10,   0}, // #5759
  {16, 10,   0}, // #5760
  {17,  1,   0}, // #5761
  {18, 10,   0}, // #5762
  {20, 10,   0}, // #5763
  {21,  2,   0}, // #5764
  {22, 36,   0}, // #5765
  {23, 39,   0}, // #5766
  { 7,  1,   0}, // #5767
  { 9, 11,   0}, // #5768
  {12,  1,   0}, // #5769
  {14, 11,   0}, // #5770
  {16, 11,   0}, // #5771
  {17,  1,   0}, // #5772
  {18, 11,   0}, // #5773
  {20, 11,   0}, // #5774
  {21,  2,   0}, // #5775
  {22, 37,   0}, // #5776
  {23, 40,   0}, // #5777
  { 4,  1,   0}, // #5778
  { 7,  1,   0}, // #5779
  { 8,  2,   0}, // #5780
  { 9,  3,   0}, // #5781
  {11,  1,   0}, // #5782
  {12,  1,   0}, // #5783
  {13,  2,   0}, // #5784
  {14,  3,   0}, // #5785
  {15,  4,   0}, // #5786
  {16,  4,   0}, // #5787
  {17,  1,   0}, // #5788
  {18,  5,   0}, // #5789
  {19,  4,   0}, // #5790
  {20,  5,   0}, // #5791
  {21,  2,   0}, // #5792
  {22, 15,   0}, // #5793
  {23, 18,   0}, // #5794
  { 3,  2,   0}, // #5795
  {11,  2,   0}, // #5796
  {12,  2,   0}, // #5797
  {13,  7,   0}, // #5798
  {14, 12,   0}, // #5799
  {17,  8,   0}, // #5800
  {19,  7,   0}, // #5801
  {20, 17,   0}, // #5802
  {21,  8,   0}, // #5803
  {22, 56,   0}, // #5804
  {23, 64,   0}, // #5805
  { 3,  9,   0}, // #5806
  { 4,  1,   0}, // #5807
  { 7, 11,   0}, // #5808
  { 8, 16,   0}, // #5809
  { 9,  1,   0}, // #5810
  {11, 10,   0}, // #5811
  {12, 20,   0}, // #5812
  {13, 25,   0}, // #5813
  {14, 31,   0}, // #5814
  {15, 17,   0}, // #5815
  {16,  2,   0}, // #5816
  {18, 17,   0}, // #5817
  {19, 26,   0}, // #5818
  {20, 47,   0}, // #5819
  {21, 11,   0}, // #5820
  {22, 78,   0}, // #5821
  {23, 100,   0}, // #5822
  { 3,  1,   0}, // #5823
  { 8,  1,   0}, // #5824
  {11,  1,   0}, // #5825
  {12,  1,   0}, // #5826
  {13,  2,   0}, // #5827
  {14,  1,   0}, // #5828
  {15,  1,   0}, // #5829
  {17,  2,   0}, // #5830
  {18,  1,   0}, // #5831
  {19,  3,   0}, // #5832
  {20,  2,   0}, // #5833
  {21,  2,   0}, // #5834
  {22,  3,   0}, // #5835
  {23,  5,   0}, // #5836
  { 3,  1,   0}, // #5837
  { 8,  1,   0}, // #5838
  {11,  1,   0}, // #5839
  {12,  1,   0}, // #5840
  {13,  2,   0}, // #5841
  {14,  1,   0}, // #5842
  {15,  1,   0}, // #5843
  {17,  4,   0}, // #5844
  {18,  1,   0}, // #5845
  {19,  3,   0}, // #5846
  {20,  2,   0}, // #5847
  {21,  4,   0}, // #5848
  {22,  3,   0}, // #5849
  {23,  7,   0}, // #5850
  { 3,  1,   0}, // #5851
  { 8,  1,   0}, // #5852
  {11,  1,   0}, // #5853
  {12,  1,   0}, // #5854
  {13,  2,   0}, // #5855
  {14,  1,   0}, // #5856
  {15,  1,   0}, // #5857
  {17,  8,   0}, // #5858
  {18,  1,   0}, // #5859
  {19,  3,   0}, // #5860
  {20,  2,   0}, // #5861
  {21,  8,   0}, // #5862
  {22,  3,   0}, // #5863
  {23, 11,   0}, // #5864
  { 8,  5,   0}, // #5865
  {11,  5,   0}, // #5866
  {13,  5,   0}, // #5867
  {15,  5,   0}, // #5868
  {18,  5,   0}, // #5869
  {19, 14,   0}, // #5870
  {20,  5,   0}, // #5871
  {22, 14,   0}, // #5872
  {23, 14,   0}, // #5873
  { 8,  9,   0}, // #5874
  {11,  7,   0}, // #5875
  {13,  9,   0}, // #5876
  {15,  9,   0}, // #5877
  {18,  9,   0}, // #5878
  {19, 21,   0}, // #5879
  {20,  9,   0}, // #5880
  {22, 21,   0}, // #5881
  {23, 21,   0}, // #5882
  { 8, 17,   0}, // #5883
  {11, 11,   0}, // #5884
  {13, 17,   0}, // #5885
  {15, 17,   0}, // #5886
  {18, 17,   0}, // #5887
  {19, 35,   0}, // #5888
  {20, 17,   0}, // #5889
  {22, 35,   0}, // #5890
  {23, 35,   0}, // #5891
  { 8,  2,   0}, // #5892
  {11,  1,   0}, // #5893
  {13,  2,   0}, // #5894
  {15,  2,   0}, // #5895
  {17,  1,   0}, // #5896
  {18,  2,   0}, // #5897
  {19,  3,   0}, // #5898
  {20,  2,   0}, // #5899
  {21,  1,   0}, // #5900
  {22,  3,   0}, // #5901
  {23,  4,   0}, // #5902
  { 7,  2,   0}, // #5903
  {12,  2,   0}, // #5904
  {15,  1,   0}, // #5905
  {19,  1,   0}, // #5906
  {21,  2,   0}, // #5907
  {22,  1,   0}, // #5908
  {23,  5,   0}, // #5909
  { 7,  1,   0}, // #5910
  {11,  1,   0}, // #5911
  {12,  1,   0}, // #5912
  {19,  1,   0}, // #5913
  {21,  1,   0}, // #5914
  {22,  1,   0}, // #5915
  {23,  3,   0}, // #5916
  { 7,  1,   0}, // #5917
  { 8,  2,   0}, // #5918
  {12,  1,   0}, // #5919
  {13,  2,   0}, // #5920
  {15,  2,   0}, // #5921
  {18,  2,   0}, // #5922
  {19,  2,   0}, // #5923
  {20,  2,   0}, // #5924
  {21,  1,   0}, // #5925
  {22,  2,   0}, // #5926
  {23,  4,   0}, // #5927
  { 8,  1,   0}, // #5928
  {13,  1,   0}, // #5929
  {15,  1,   0}, // #5930
  {17,  1,   0}, // #5931
  {18,  1,   0}, // #5932
  {19,  1,   0}, // #5933
  {20,  1,   0}, // #5934
  {21,  1,   0}, // #5935
  {22,  2,   0}, // #5936
  {23,  3,   0}, // #5937
  { 3,  1,   0}, // #5938
  { 7,  2,   0}, // #5939
  {11,  1,   0}, // #5940
  {12,  3,   0}, // #5941
  {13,  1,   0}, // #5942
  {14,  1,   0}, // #5943
  {19,  1,   0}, // #5944
  {20,  1,   0}, // #5945
  {21,  2,   0}, // #5946
  {22,  3,   0}, // #5947
  {23,  7,   0}, // #5948
  { 3,  1,   0}, // #5949
  { 7,  4,   0}, // #5950
  {11,  1,   0}, // #5951
  {12,  5,   0}, // #5952
  {13,  1,   0}, // #5953
  {14,  1,   0}, // #5954
  {19,  1,   0}, // #5955
  {20,  1,   0}, // #5956
  {21,  4,   0}, // #5957
  {22,  3,   0}, // #5958
  {23, 11,   0}, // #5959
  { 3,  1,   0}, // #5960
  { 7,  8,   0}, // #5961
  {11,  1,   0}, // #5962
  {12,  9,   0}, // #5963
  {13,  1,   0}, // #5964
  {14,  1,   0}, // #5965
  {19,  1,   0}, // #5966
  {20,  1,   0}, // #5967
  {21,  8,   0}, // #5968
  {22,  3,   0}, // #5969
  {23, 19,   0}, // #5970
  { 3,  1,   0}, // #5971
  { 7, 16,   0}, // #5972
  { 8,  1,   0}, // #5973
  {11,  1,   0}, // #5974
  {12, 17,   0}, // #5975
  {13,  2,   0}, // #5976
  {14,  1,   0}, // #5977
  {15,  1,   0}, // #5978
  {18,  1,   0}, // #5979
  {19,  2,   0}, // #5980
  {20,  2,   0}, // #5981
  {21, 16,   0}, // #5982
  {22,  4,   0}, // #5983
  {23, 36,   0}, // #5984
  { 3,  1,   0}, // #5985
  { 7,  2,   0}, // #5986
  { 8,  1,   0}, // #5987
  {11,  1,   0}, // #5988
  {12,  3,   0}, // #5989
  {13,  2,   0}, // #5990
  {14,  1,   0}, // #5991
  {15,  1,   0}, // #5992
  {18,  1,   0}, // #5993
  {19,  2,   0}, // #5994
  {20,  2,   0}, // #5995
  {21,  2,   0}, // #5996
  {22,  4,   0}, // #5997
  {23,  8,   0}, // #5998
  { 3,  1,   0}, // #5999
  { 7,  4,   0}, // #6000
  { 8,  1,   0}, // #6001
  {11,  1,   0}, // #6002
  {12,  5,   0}, // #6003
  {13,  2,   0}, // #6004
  {14,  1,   0}, // #6005
  {15,  1,   0}, // #6006
  {18,  1,   0}, // #6007
  {19,  2,   0}, // #6008
  {20,  2,   0}, // #6009
  {21,  4,   0}, // #6010
  {22,  4,   0}, // #6011
  {23, 12,   0}, // #6012
  { 3,  1,   0}, // #6013
  { 7,  8,   0}, // #6014
  { 8,  1,   0}, // #6015
  {11,  1,   0}, // #6016
  {12,  9,   0}, // #6017
  {13,  2,   0}, // #6018
  {14,  1,   0}, // #6019
  {15,  1,   0}, // #6020
  {18,  1,   0}, // #6021
  {19,  2,   0}, // #6022
  {20,  2,   0}, // #6023
  {21,  8,   0}, // #6024
  {22,  4,   0}, // #6025
  {23, 20,   0}, // #6026
  {11,  3,   0}, // #6027
  {19,  3,   0}, // #6028
  {22,  3,   0}, // #6029
  {23,  3,   0}, // #6030
  {13,  3,   0}, // #6031
  {19,  3,   0}, // #6032
  {20,  3,   0}, // #6033
  {22,  3,   0}, // #6034
  {23,  3,   0}, // #6035
  { 4,  1,   0}, // #6036
  { 8,  2,   0}, // #6037
  {11,  3,   0}, // #6038
  {13,  2,   0}, // #6039
  {15,  3,   0}, // #6040
  {16,  1,   0}, // #6041
  {17,  1,   0}, // #6042
  {18,  2,   0}, // #6043
  {19,  7,   0}, // #6044
  {20,  2,   0}, // #6045
  {21,  1,   0}, // #6046
  {22,  7,   0}, // #6047
  {23,  8,   0}, // #6048
  {11,  3,   0}, // #6049
  {17,  1,   0}, // #6050
  {19,  3,   0}, // #6051
  {21,  1,   0}, // #6052
  {22,  3,   0}, // #6053
  {23,  4,   0}, // #6054
  {13,  3,   0}, // #6055
  {17,  1,   0}, // #6056
  {19,  3,   0}, // #6057
  {20,  3,   0}, // #6058
  {21,  1,   0}, // #6059
  {22,  3,   0}, // #6060
  {23,  4,   0}, // #6061
  { 3,  1,   0}, // #6062
  {11,  1,   0}, // #6063
  {12,  1,   0}, // #6064
  {13,  1,   0}, // #6065
  {14,  1,   0}, // #6066
  {17,  2,   0}, // #6067
  {19,  2,   0}, // #6068
  {20,  1,   0}, // #6069
  {21,  2,   0}, // #6070
  {22,  3,   0}, // #6071
  {23,  5,   0}, // #6072
  { 3,  1,   0}, // #6073
  {11,  1,   0}, // #6074
  {12,  1,   0}, // #6075
  {13,  1,   0}, // #6076
  {14,  1,   0}, // #6077
  {17,  4,   0}, // #6078
  {19,  2,   0}, // #6079
  {20,  1,   0}, // #6080
  {21,  4,   0}, // #6081
  {22,  3,   0}, // #6082
  {23,  7,   0}, // #6083
  { 3,  1,   0}, // #6084
  {11,  1,   0}, // #6085
  {12,  1,   0}, // #6086
  {13,  1,   0}, // #6087
  {14,  1,   0}, // #6088
  {17,  8,   0}, // #6089
  {19,  2,   0}, // #6090
  {20,  1,   0}, // #6091
  {21,  8,   0}, // #6092
  {22,  3,   0}, // #6093
  {23, 11,   0}, // #6094
  { 3,  1,   0}, // #6095
  {11,  1,   0}, // #6096
  {12,  1,   0}, // #6097
  {13,  1,   0}, // #6098
  {14,  1,   0}, // #6099
  {17, 16,   0}, // #6100
  {19,  2,   0}, // #6101
  {20,  1,   0}, // #6102
  {21, 16,   0}, // #6103
  {22,  3,   0}, // #6104
  {23, 19,   0}, // #6105
  { 8,  5,   0}, // #6106
  {11,  5,   0}, // #6107
  {13,  5,   0}, // #6108
  {15,  5,   0}, // #6109
  {17,  1,   0}, // #6110
  {18,  5,   0}, // #6111
  {19, 14,   0}, // #6112
  {20,  5,   0}, // #6113
  {21,  1,   0}, // #6114
  {22, 14,   0}, // #6115
  {23, 15,   0}, // #6116
  { 8,  9,   0}, // #6117
  {11,  7,   0}, // #6118
  {13,  9,   0}, // #6119
  {15,  9,   0}, // #6120
  {17,  1,   0}, // #6121
  {18,  9,   0}, // #6122
  {19, 21,   0}, // #6123
  {20,  9,   0}, // #6124
  {21,  1,   0}, // #6125
  {22, 21,   0}, // #6126
  {23, 22,   0}, // #6127
  { 8, 17,   0}, // #6128
  {11, 11,   0}, // #6129
  {13, 17,   0}, // #6130
  {15, 17,   0}, // #6131
  {17,  1,   0}, // #6132
  {18, 17,   0}, // #6133
  {19, 35,   0}, // #6134
  {20, 17,   0}, // #6135
  {21,  1,   0}, // #6136
  {22, 35,   0}, // #6137
  {23, 36,   0}, // #6138
  { 7,  1,   0}, // #6139
  {12,  1,   0}, // #6140
  {14,  2,   0}, // #6141
  {20,  2,   0}, // #6142
  {21,  1,   0}, // #6143
  {22,  2,   0}, // #6144
  {23,  4,   0}, // #6145
  { 4,  1,   0}, // #6146
  { 7,  1,   0}, // #6147
  { 9,  1,   0}, // #6148
  {11,  1,   0}, // #6149
  {12,  1,   0}, // #6150
  { 6,  1,   0}, // #6151
  { 8,  1,   0}, // #6152
  { 9,  1,   0}, // #6153
  {11,  1,   0}, // #6154
  {12,  1,   0}, // #6155
  { 5,  1,   0}, // #6156
  { 6,  2,   0}, // #6157
  { 8,  2,   0}, // #6158
  { 9,  2,   0}, // #6159
  {10,  2,   0}, // #6160
  {11,  3,   0}, // #6161
  {12,  6,   0}, // #6162
  { 6,  1,   0}, // #6163
  { 8,  1,   0}, // #6164
  { 9,  1,   0}, // #6165
  {10,  1,   0}, // #6166
  {11,  1,   0}, // #6167
  {12,  2,   0}, // #6168
  { 5,  1,   0}, // #6169
  {10,  1,   0}, // #6170
  {12,  2,   0}, // #6171
  {10,  1,   0}, // #6172
  {12,  1,   0}, // #6173
  { 5,  1,   0}, // #6174
  {10,  2,   0}, // #6175
  {11,  1,   0}, // #6176
  {12,  4,   0}, // #6177
  { 5,  1,   0}, // #6178
  {10,  2,   0}, // #6179
  {11,  3,   0}, // #6180
  {12,  6,   0}, // #6181
  { 8,  1,   0}, // #6182
  {10,  1,   0}, // #6183
  {11,  2,   0}, // #6184
  {12,  3,   0}, // #6185
  { 4,  1,   0}, // #6186
  { 7,  1,   0}, // #6187
  { 9,  1,   0}, // #6188
  {10,  1,   0}, // #6189
  {11,  1,   0}, // #6190
  {12,  2,   0}, // #6191
  { 6,  1,   0}, // #6192
  { 8,  1,   0}, // #6193
  { 9,  1,   0}, // #6194
  {10,  1,   0}, // #6195
  {11,  2,   0}, // #6196
  {12,  3,   0}, // #6197
  { 6,  1,   0}, // #6198
  { 8,  1,   0}, // #6199
  { 9,  1,   0}, // #6200
  {11,  2,   0}, // #6201
  {12,  2,   0}, // #6202
  { 6,  2,   0}, // #6203
  { 8,  2,   0}, // #6204
  { 9,  2,   0}, // #6205
  {10,  1,   0}, // #6206
  {11,  2,   0}, // #6207
  {12,  3,   0}, // #6208
  { 6,  2,   0}, // #6209
  { 8,  2,   0}, // #6210
  { 9,  2,   0}, // #6211
  {11,  2,   0}, // #6212
  {12,  2,   0}, // #6213
  {10,  1,   0}, // #6214
  {11, 10,   0}, // #6215
  {12, 11,   0}, // #6216
  {11, 11,   0}, // #6217
  {12, 11,   0}, // #6218
  { 4,  1,   0}, // #6219
  { 7,  1,   0}, // #6220
  { 8,  1,   0}, // #6221
  { 9,  1,   0}, // #6222
  {10,  1,   0}, // #6223
  {11,  2,   0}, // #6224
  {12,  3,   0}, // #6225
  { 4,  1,   0}, // #6226
  { 7,  1,   0}, // #6227
  { 8,  1,   0}, // #6228
  { 9,  1,   0}, // #6229
  {11,  2,   0}, // #6230
  {12,  2,   0}, // #6231
  { 8,  1,   0}, // #6232
  {10,  1,   0}, // #6233
  {11,  1,   0}, // #6234
  {12,  2,   0}, // #6235
  { 8,  2,   0}, // #6236
  {10,  1,   0}, // #6237
  {11,  2,   0}, // #6238
  {12,  3,   0}, // #6239
  { 8,  2,   0}, // #6240
  {11,  2,   0}, // #6241
  {12,  2,   0}, // #6242
  { 5,  1,   0}, // #6243
  { 6,  1,   0}, // #6244
  { 8,  2,   0}, // #6245
  { 9,  1,   0}, // #6246
  {10,  2,   0}, // #6247
  {11,  3,   0}, // #6248
  {12,  6,   0}, // #6249
  { 5,  1,   0}, // #6250
  { 8,  1,   0}, // #6251
  {10,  2,   0}, // #6252
  {11,  1,   0}, // #6253
  {12,  4,   0}, // #6254
  { 6,  2,   0}, // #6255
  { 8,  3,   0}, // #6256
  { 9,  2,   0}, // #6257
  {11,  3,   0}, // #6258
  {12,  3,   0}, // #6259
  { 8,  1,   0}, // #6260
  {11,  4,   0}, // #6261
  {12,  4,   0}, // #6262
  { 4,  1,   0}, // #6263
  { 6,  1,   0}, // #6264
  { 7,  1,   0}, // #6265
  { 8,  1,   0}, // #6266
  { 9,  2,   0}, // #6267
  {10,  1,   0}, // #6268
  {11,  2,   0}, // #6269
  {12,  3,   0}, // #6270
  { 4,  1,   0}, // #6271
  { 6,  1,   0}, // #6272
  { 7,  1,   0}, // #6273
  { 8,  1,   0}, // #6274
  { 9,  2,   0}, // #6275
  {11,  2,   0}, // #6276
  {12,  2,   0}, // #6277
  { 3,  1,   0}, // #6278
  { 7,  1,   0}, // #6279
  { 8,  1,   0}, // #6280
  {10,  1,   0}, // #6281
  {11,  1,   0}, // #6282
  {12,  2,   0}, // #6283
  { 3,  1,   0}, // #6284
  { 6,  1,   0}, // #6285
  { 7,  1,   0}, // #6286
  { 8,  2,   0}, // #6287
  { 9,  1,   0}, // #6288
  {11,  2,   0}, // #6289
  {12,  2,   0}, // #6290
  { 3,  1,   0}, // #6291
  { 4,  1,   0}, // #6292
  { 7,  2,   0}, // #6293
  { 8,  1,   0}, // #6294
  { 9,  1,   0}, // #6295
  {10,  1,   0}, // #6296
  {11,  2,   0}, // #6297
  {12,  3,   0}, // #6298
  { 3,  1,   0}, // #6299
  { 4,  1,   0}, // #6300
  { 7,  2,   0}, // #6301
  { 8,  1,   0}, // #6302
  { 9,  1,   0}, // #6303
  {11,  2,   0}, // #6304
  {12,  2,   0}, // #6305
  { 4,  1,   0}, // #6306
  { 6,  2,   0}, // #6307
  { 7,  1,   0}, // #6308
  { 8,  2,   0}, // #6309
  { 9,  3,   0}, // #6310
  {11,  3,   0}, // #6311
  {12,  3,   0}, // #6312
  { 3,  1,   0}, // #6313
  { 7,  1,   0}, // #6314
  { 8,  1,   0}, // #6315
  {11,  1,   0}, // #6316
  {12,  1,   0}, // #6317
  { 1, 10,   0}, // #6318
  { 3,  1,   0}, // #6319
  { 7,  1,   0}, // #6320
  { 8,  1,   0}, // #6321
  {10,  1,   0}, // #6322
  {11,  1,   0}, // #6323
  {12,  2,   0}, // #6324
  { 1, 10,   0}, // #6325
  { 3,  1,   0}, // #6326
  { 7,  1,   0}, // #6327
  { 8,  1,   0}, // #6328
  {11,  1,   0}, // #6329
  {12,  1,   0}, // #6330
  { 2, 22,   0}, // #6331
  { 3,  1,   0}, // #6332
  { 7,  1,   0}, // #6333
  { 8,  1,   0}, // #6334
  {10,  1,   0}, // #6335
  {11,  1,   0}, // #6336
  {12,  2,   0}, // #6337
  { 2, 22,   0}, // #6338
  { 3,  1,   0}, // #6339
  { 7,  1,   0}, // #6340
  { 8,  1,   0}, // #6341
  {11,  1,   0}, // #6342
  {12,  1,   0}, // #6343
  { 2, 14,   0}, // #6344
  { 3,  1,   0}, // #6345
  { 7,  1,   0}, // #6346
  { 8,  1,   0}, // #6347
  {10,  1,   0}, // #6348
  {11,  1,   0}, // #6349
  {12,  2,   0}, // #6350
  { 2, 14,   0}, // #6351
  { 3,  1,   0}, // #6352
  { 7,  1,   0}, // #6353
  { 8,  1,   0}, // #6354
  {11,  1,   0}, // #6355
  {12,  1,   0}, // #6356
  { 3,  1,   0}, // #6357
  { 4,  1,   0}, // #6358
  { 6,  1,   0}, // #6359
  { 7,  2,   0}, // #6360
  { 8,  2,   0}, // #6361
  { 9,  2,   0}, // #6362
  {10,  1,   0}, // #6363
  {11,  3,   0}, // #6364
  {12,  4,   0}, // #6365
  { 3,  1,   0}, // #6366
  { 4,  1,   0}, // #6367
  { 6,  1,   0}, // #6368
  { 7,  2,   0}, // #6369
  { 8,  2,   0}, // #6370
  { 9,  2,   0}, // #6371
  {11,  3,   0}, // #6372
  {12,  3,   0}, // #6373
  { 3,  1,   0}, // #6374
  { 4,  2,   0}, // #6375
  { 6,  2,   0}, // #6376
  { 7,  3,   0}, // #6377
  { 8,  3,   0}, // #6378
  { 9,  4,   0}, // #6379
  {10,  1,   0}, // #6380
  {11,  5,   0}, // #6381
  {12,  6,   0}, // #6382
  { 3,  1,   0}, // #6383
  { 4,  2,   0}, // #6384
  { 6,  1,   0}, // #6385
  { 7,  3,   0}, // #6386
  { 8,  2,   0}, // #6387
  { 9,  3,   0}, // #6388
  {11,  4,   0}, // #6389
  {12,  4,   0}, // #6390
  { 5,  1,   0}, // #6391
  { 9,  1,   0}, // #6392
  {10,  1,   0}, // #6393
  {11,  1,   0}, // #6394
  {12,  3,   0}, // #6395
  { 3,  1,   0}, // #6396
  { 7,  1,   0}, // #6397
  { 8,  1,   0}, // #6398
  { 9,  1,   0}, // #6399
  {11,  2,   0}, // #6400
  {12,  2,   0}, // #6401
  {11, 31,   0}, // #6402
  {12, 31,   0}, // #6403
  { 4,  1,   0}, // #6404
  { 6,  2,   0}, // #6405
  { 7,  1,   0}, // #6406
  { 8,  2,   0}, // #6407
  { 9,  3,   0}, // #6408
  {10,  1,   0}, // #6409
  {11,  3,   0}, // #6410
  {12,  4,   0}, // #6411
  { 4,  1,   0}, // #6412
  { 7,  1,   0}, // #6413
  { 8,  1,   0}, // #6414
  { 9,  1,   0}, // #6415
  {10,  1,   0}, // #6416
  {11,  4,   0}, // #6417
  {12,  5,   0}, // #6418
  { 4,  1,   0}, // #6419
  { 7,  1,   0}, // #6420
  { 8,  1,   0}, // #6421
  { 9,  1,   0}, // #6422
  {11,  4,   0}, // #6423
  {12,  4,   0}, // #6424
  { 4,  1,   0}, // #6425
  { 7,  1,   0}, // #6426
  { 9,  1,   0}, // #6427
  {10,  1,   0}, // #6428
  {11,  2,   0}, // #6429
  {12,  3,   0}, // #6430
  { 4,  1,   0}, // #6431
  { 7,  1,   0}, // #6432
  { 9,  1,   0}, // #6433
  {11,  2,   0}, // #6434
  {12,  2,   0}, // #6435
  { 4,  1,   0}, // #6436
  { 7,  1,   0}, // #6437
  { 8,  1,   0}, // #6438
  { 9,  1,   0}, // #6439
  {10,  1,   0}, // #6440
  {11,  3,   0}, // #6441
  {12,  4,   0}, // #6442
  { 4,  1,   0}, // #6443
  { 7,  1,   0}, // #6444
  { 8,  1,   0}, // #6445
  { 9,  1,   0}, // #6446
  {11,  3,   0}, // #6447
  {12,  3,   0}, // #6448
  { 3,  1,   0}, // #6449
  { 5,  1,   0}, // #6450
  { 6,  1,   0}, // #6451
  { 7,  1,   0}, // #6452
  { 8,  2,   0}, // #6453
  { 9,  1,   0}, // #6454
  {10,  1,   0}, // #6455
  {11,  2,   0}, // #6456
  {12,  4,   0}, // #6457
  { 6,  1,   0}, // #6458
  { 8,  1,   0}, // #6459
  { 9,  2,   0}, // #6460
  {11,  2,   0}, // #6461
  {12,  2,   0}, // #6462
  { 3,  1,   0}, // #6463
  { 7,  1,   0}, // #6464
  { 8,  1,   0}, // #6465
  { 9,  2,   0}, // #6466
  {10,  1,   0}, // #6467
  {11,  3,   0}, // #6468
  {12,  4,   0}, // #6469
  { 3,  1,   0}, // #6470
  { 7,  1,   0}, // #6471
  { 8,  1,   0}, // #6472
  { 9,  2,   0}, // #6473
  {11,  3,   0}, // #6474
  {12,  3,   0}, // #6475
  {10,  1,   0}, // #6476
  {11, 17,   0}, // #6477
  {12, 18,   0}, // #6478
  {11, 18,   0}, // #6479
  {12, 18,   0}, // #6480
  {10,  1,   0}, // #6481
  {11,  7,   0}, // #6482
  {12,  8,   0}, // #6483
  {11,  8,   0}, // #6484
  {12,  8,   0}, // #6485
  { 3,  3,   0}, // #6486
  { 7,  3,   0}, // #6487
  { 8,  3,   0}, // #6488
  {10,  1,   0}, // #6489
  {11,  3,   0}, // #6490
  {12,  4,   0}, // #6491
  { 3,  3,   0}, // #6492
  { 7,  3,   0}, // #6493
  { 8,  3,   0}, // #6494
  {11,  3,   0}, // #6495
  {12,  3,   0}, // #6496
  { 5,  1,   0}, // #6497
  {10,  2,   0}, // #6498
  {12,  3,   0}, // #6499
  { 3,  1,   0}, // #6500
  { 7,  1,   0}, // #6501
  { 8,  1,   0}, // #6502
  { 9,  1,   0}, // #6503
  {10,  1,   0}, // #6504
  {11,  2,   0}, // #6505
  {12,  3,   0}, // #6506
  { 3,  1,   0}, // #6507
  { 6,  1,   0}, // #6508
  { 7,  1,   0}, // #6509
  { 8,  2,   0}, // #6510
  { 9,  1,   0}, // #6511
  {10,  1,   0}, // #6512
  {11,  2,   0}, // #6513
  {12,  3,   0}, // #6514
  { 5,  1,   0}, // #6515
  { 8,  2,   0}, // #6516
  {10,  2,   0}, // #6517
  {11,  2,   0}, // #6518
  {12,  5,   0}, // #6519
  { 8,  4,   0}, // #6520
  {10,  1,   0}, // #6521
  {11,  4,   0}, // #6522
  {12,  5,   0}, // #6523
  { 5,  1,   0}, // #6524
  { 8,  3,   0}, // #6525
  {10,  2,   0}, // #6526
  {11,  3,   0}, // #6527
  {12,  6,   0}, // #6528
  { 8,  6,   0}, // #6529
  {10,  1,   0}, // #6530
  {11,  6,   0}, // #6531
  {12,  7,   0}, // #6532
  { 5,  1,   0}, // #6533
  { 8,  1,   0}, // #6534
  {10,  1,   0}, // #6535
  {11,  1,   0}, // #6536
  {12,  3,   0}, // #6537
  { 5,  1,   0}, // #6538
  { 8,  3,   0}, // #6539
  {10,  2,   0}, // #6540
  {11,  4,   0}, // #6541
  {12,  7,   0}, // #6542
  { 5,  1,   0}, // #6543
  { 8,  1,   0}, // #6544
  {10,  2,   0}, // #6545
  {11,  2,   0}, // #6546
  {12,  5,   0}, // #6547
  { 2, 21,   0}, // #6548
  { 3,  1,   0}, // #6549
  { 7,  1,   0}, // #6550
  { 8,  1,   0}, // #6551
  {10,  1,   0}, // #6552
  {11,  1,   0}, // #6553
  {12,  2,   0}, // #6554
  { 2, 21,   0}, // #6555
  { 3,  1,   0}, // #6556
  { 7,  1,   0}, // #6557
  { 8,  1,   0}, // #6558
  {11,  1,   0}, // #6559
  {12,  1,   0}, // #6560
  { 2, 24,   0}, // #6561
  { 3,  1,   0}, // #6562
  { 7,  1,   0}, // #6563
  { 8,  1,   0}, // #6564
  {11,  1,   0}, // #6565
  {12,  1,   0}, // #6566
  { 7,  1,   0}, // #6567
  {10,  1,   0}, // #6568
  {11,  1,   0}, // #6569
  {12,  2,   0}, // #6570
  { 4,  1,   0}, // #6571
  { 5,  1,   0}, // #6572
  { 7,  1,   0}, // #6573
  { 9,  1,   0}, // #6574
  {10,  1,   0}, // #6575
  {11,  1,   0}, // #6576
  {12,  3,   0}, // #6577
  { 2, 44,   0}, // #6578
  { 3,  2,   0}, // #6579
  { 7,  2,   0}, // #6580
  { 8,  3,   0}, // #6581
  {10,  1,   0}, // #6582
  {11,  3,   0}, // #6583
  {12,  4,   0}, // #6584
  { 2, 44,   0}, // #6585
  { 3,  2,   0}, // #6586
  { 7,  2,   0}, // #6587
  { 8,  3,   0}, // #6588
  {11,  3,   0}, // #6589
  {12,  3,   0}, // #6590
  { 2, 28,   0}, // #6591
  { 3,  2,   0}, // #6592
  { 7,  2,   0}, // #6593
  { 8,  3,   0}, // #6594
  {10,  1,   0}, // #6595
  {11,  3,   0}, // #6596
  {12,  4,   0}, // #6597
  { 2, 28,   0}, // #6598
  { 3,  2,   0}, // #6599
  { 7,  2,   0}, // #6600
  { 8,  3,   0}, // #6601
  {11,  3,   0}, // #6602
  {12,  3,   0}, // #6603
  { 5,  1,   0}, // #6604
  { 7,  2,   0}, // #6605
  {10,  1,   0}, // #6606
  {11,  2,   0}, // #6607
  {12,  4,   0}, // #6608
  { 8,  7,   0}, // #6609
  {10,  4,   0}, // #6610
  {11,  7,   0}, // #6611
  {12, 11,   0}, // #6612
  { 5,  1,   0}, // #6613
  {10,  2,   0}, // #6614
  {11,  2,   0}, // #6615
  {12,  5,   0}, // #6616
  { 6,  1,   0}, // #6617
  { 7,  1,   0}, // #6618
  { 8,  1,   0}, // #6619
  { 9,  1,   0}, // #6620
  {10,  1,   0}, // #6621
  {11,  2,   0}, // #6622
  {12,  3,   0}, // #6623
  { 5,  1,   0}, // #6624
  { 6,  2,   0}, // #6625
  { 8,  2,   0}, // #6626
  { 9,  2,   0}, // #6627
  {10,  2,   0}, // #6628
  {11,  2,   0}, // #6629
  {12,  5,   0}, // #6630
  { 4,  1,   0}, // #6631
  { 5,  1,   0}, // #6632
  { 7,  1,   0}, // #6633
  { 9,  1,   0}, // #6634
  {10,  2,   0}, // #6635
  {11,  1,   0}, // #6636
  {12,  4,   0}, // #6637
  { 4,  1,   0}, // #6638
  { 6,  3,   0}, // #6639
  { 7,  1,   0}, // #6640
  { 8,  5,   0}, // #6641
  { 9,  4,   0}, // #6642
  {11, 12,   0}, // #6643
  {12, 12,   0}, // #6644
  { 5,  1,   0}, // #6645
  { 6,  1,   0}, // #6646
  { 8,  1,   0}, // #6647
  { 9,  1,   0}, // #6648
  {10,  2,   0}, // #6649
  {11,  1,   0}, // #6650
  {12,  4,   0}, // #6651
  { 6,  1,   0}, // #6652
  { 8,  1,   0}, // #6653
  { 9,  1,   0}, // #6654
  {11,  4,   0}, // #6655
  {12,  4,   0}, // #6656
  { 4,  1,   0}, // #6657
  { 6,  3,   0}, // #6658
  { 7,  1,   0}, // #6659
  { 8,  3,   0}, // #6660
  { 9,  4,   0}, // #6661
  {11,  8,   0}, // #6662
  {12,  8,   0}, // #6663
  { 5,  1,   0}, // #6664
  { 6,  2,   0}, // #6665
  { 7,  1,   0}, // #6666
  { 8,  2,   0}, // #6667
  { 9,  2,   0}, // #6668
  {10,  1,   0}, // #6669
  {11,  3,   0}, // #6670
  {12,  5,   0}, // #6671
  { 3,  1,   0}, // #6672
  { 7,  1,   0}, // #6673
  { 8,  1,   0}, // #6674
  {11,  2,   0}, // #6675
  {12,  2,   0}, // #6676
  { 8,  2,   0}, // #6677
  {11,  3,   0}, // #6678
  {12,  3,   0}, // #6679
  { 4,  1,   0}, // #6680
  { 6,  1,   0}, // #6681
  { 7,  1,   0}, // #6682
  { 8,  5,   0}, // #6683
  { 9,  2,   0}, // #6684
  {11,  8,   0}, // #6685
  {12,  8,   0}, // #6686
  { 8,  8,   0}, // #6687
  {11,  8,   0}, // #6688
  {12,  8,   0}, // #6689
  { 5,  1,   0}, // #6690
  { 6,  1,   0}, // #6691
  { 8,  1,   0}, // #6692
  { 9,  1,   0}, // #6693
  {10,  1,   0}, // #6694
  {11,  1,   0}, // #6695
  {12,  3,   0}, // #6696
  { 5,  1,   0}, // #6697
  {10,  1,   0}, // #6698
  {11,  1,   0}, // #6699
  {12,  3,   0}, // #6700
  { 3,  1,   0}, // #6701
  { 5,  1,   0}, // #6702
  { 7,  1,   0}, // #6703
  { 8,  1,   0}, // #6704
  { 9,  1,   0}, // #6705
  {10,  1,   0}, // #6706
  {11,  2,   0}, // #6707
  {12,  4,   0}, // #6708
  { 5,  1,   0}, // #6709
  { 6,  1,   0}, // #6710
  { 7,  1,   0}, // #6711
  { 8,  1,   0}, // #6712
  { 9,  1,   0}, // #6713
  {10,  1,   0}, // #6714
  {11,  2,   0}, // #6715
  {12,  4,   0}, // #6716
  { 3,  1,   0}, // #6717
  { 5,  1,   0}, // #6718
  { 7,  1,   0}, // #6719
  { 8,  1,   0}, // #6720
  {10,  2,   0}, // #6721
  {11,  1,   0}, // #6722
  {12,  4,   0}, // #6723
  { 4,  1,   0}, // #6724
  { 6,  2,   0}, // #6725
  { 7,  1,   0}, // #6726
  { 8,  2,   0}, // #6727
  { 9,  3,   0}, // #6728
  {11,  4,   0}, // #6729
  {12,  4,   0}, // #6730
  {10,  2,   0}, // #6731
  {11,  3,   0}, // #6732
  {12,  5,   0}, // #6733
  { 5,  1,   0}, // #6734
  { 6,  1,   0}, // #6735
  { 7,  1,   0}, // #6736
  { 8,  1,   0}, // #6737
  { 9,  1,   0}, // #6738
  {10,  2,   0}, // #6739
  {11,  2,   0}, // #6740
  {12,  5,   0}, // #6741
  { 5,  1,   0}, // #6742
  { 8,  2,   0}, // #6743
  {10,  2,   0}, // #6744
  {11,  3,   0}, // #6745
  {12,  6,   0}, // #6746
  { 4,  2,   0}, // #6747
  { 7,  2,   0}, // #6748
  { 9,  2,   0}, // #6749
  {10,  1,   0}, // #6750
  {11,  2,   0}, // #6751
  {12,  3,   0}, // #6752
  { 8,  2,   0}, // #6753
  {10,  1,   0}, // #6754
  {11,  3,   0}, // #6755
  {12,  4,   0}, // #6756
  { 5,  1,   0}, // #6757
  { 8,  2,   0}, // #6758
  {10,  1,   0}, // #6759
  {11,  2,   0}, // #6760
  {12,  4,   0}, // #6761
  { 3,  1,   0}, // #6762
  { 4,  1,   0}, // #6763
  { 8,  1,   0}, // #6764
  { 9,  1,   0}, // #6765
  {11,  2,   0}, // #6766
  {12,  1,   0}, // #6767
  {13,  2,   0}, // #6768
  {14,  2,   0}, // #6769
  {15,  2,   0}, // #6770
  {16,  2,   0}, // #6771
  {18,  2,   0}, // #6772
  {19,  3,   0}, // #6773
  {20,  3,   0}, // #6774
  {22,  4,   0}, // #6775
  {23,  4,   0}, // #6776
  { 4,  1,   0}, // #6777
  { 9,  1,   0}, // #6778
  {11,  1,   0}, // #6779
  {14,  1,   0}, // #6780
  {15,  1,   0}, // #6781
  {16,  2,   0}, // #6782
  {17,  1,   0}, // #6783
  {18,  1,   0}, // #6784
  {19,  1,   0}, // #6785
  {20,  1,   0}, // #6786
  {21,  1,   0}, // #6787
  {22,  2,   0}, // #6788
  {23,  3,   0}, // #6789
  { 4,  1,   0}, // #6790
  { 9,  1,   0}, // #6791
  {11,  1,   0}, // #6792
  {14,  1,   0}, // #6793
  {15,  1,   0}, // #6794
  {16,  2,   0}, // #6795
  {18,  1,   0}, // #6796
  {19,  1,   0}, // #6797
  {20,  1,   0}, // #6798
  {22,  2,   0}, // #6799
  {23,  2,   0}, // #6800
  { 2, 17,   0}, // #6801
  { 3,  1,   0}, // #6802
  {11,  1,   0}, // #6803
  {12,  1,   0}, // #6804
  {13,  1,   0}, // #6805
  {14,  1,   0}, // #6806
  {19,  1,   0}, // #6807
  {20,  1,   0}, // #6808
  {22,  1,   0}, // #6809
  {23,  1,   0}, // #6810
  { 4,  1,   0}, // #6811
  { 7,  1,   0}, // #6812
  { 8,  1,   0}, // #6813
  {11,  1,   0}, // #6814
  {12,  1,   0}, // #6815
  {13,  1,   0}, // #6816
  {15,  2,   0}, // #6817
  {16,  1,   0}, // #6818
  {18,  1,   0}, // #6819
  {19,  2,   0}, // #6820
  {20,  1,   0}, // #6821
  {21,  1,   0}, // #6822
  {22,  2,   0}, // #6823
  {23,  4,   0}, // #6824
  { 2, 28,   0}, // #6825
  { 3,  2,   0}, // #6826
  {11,  2,   0}, // #6827
  {12,  2,   0}, // #6828
  {13,  2,   0}, // #6829
  {14,  2,   0}, // #6830
  {15,  1,   0}, // #6831
  {17,  1,   0}, // #6832
  {19,  3,   0}, // #6833
  {20,  2,   0}, // #6834
  {21,  1,   0}, // #6835
  {22,  3,   0}, // #6836
  {23,  4,   0}, // #6837
  { 2, 28,   0}, // #6838
  { 3,  2,   0}, // #6839
  {11,  2,   0}, // #6840
  {12,  2,   0}, // #6841
  {13,  2,   0}, // #6842
  {14,  2,   0}, // #6843
  {15,  1,   0}, // #6844
  {19,  3,   0}, // #6845
  {20,  2,   0}, // #6846
  {22,  3,   0}, // #6847
  {23,  3,   0}, // #6848
  { 2, 14,   0}, // #6849
  { 3,  2,   0}, // #6850
  {11,  2,   0}, // #6851
  {12,  2,   0}, // #6852
  {13,  2,   0}, // #6853
  {14,  2,   0}, // #6854
  {15,  1,   0}, // #6855
  {17,  1,   0}, // #6856
  {19,  3,   0}, // #6857
  {20,  2,   0}, // #6858
  {21,  1,   0}, // #6859
  {22,  3,   0}, // #6860
  {23,  4,   0}, // #6861
  { 2, 14,   0}, // #6862
  { 3,  2,   0}, // #6863
  {11,  2,   0}, // #6864
  {12,  2,   0}, // #6865
  {13,  2,   0}, // #6866
  {14,  2,   0}, // #6867
  {15,  1,   0}, // #6868
  {19,  3,   0}, // #6869
  {20,  2,   0}, // #6870
  {22,  3,   0}, // #6871
  {23,  3,   0}, // #6872
  { 4,  2,   0}, // #6873
  {11,  2,   0}, // #6874
  {15,  2,   0}, // #6875
  {16,  2,   0}, // #6876
  {19,  2,   0}, // #6877
  {22,  2,   0}, // #6878
  {23,  2,   0}, // #6879
  { 3,  2,   0}, // #6880
  { 4,  1,   0}, // #6881
  { 8,  2,   0}, // #6882
  { 9,  4,   0}, // #6883
  {11,  5,   0}, // #6884
  {12,  2,   0}, // #6885
  {13,  4,   0}, // #6886
  {14,  6,   0}, // #6887
  {15,  3,   0}, // #6888
  {16,  5,   0}, // #6889
  {18,  6,   0}, // #6890
  {19,  7,   0}, // #6891
  {20,  8,   0}, // #6892
  {22, 15,   0}, // #6893
  {23, 15,   0}, // #6894
  { 7,  1,   0}, // #6895
  {12,  1,   0}, // #6896
  {17,  2,   0}, // #6897
  {21,  2,   0}, // #6898
  {22,  2,   0}, // #6899
  {23,  5,   0}, // #6900
  {17,  1,   0}, // #6901
  {21,  1,   0}, // #6902
  {22, 14,   0}, // #6903
  {23, 15,   0}, // #6904
  {17,  2,   0}, // #6905
  {21,  2,   0}, // #6906
  {22,  3,   0}, // #6907
  {23,  5,   0}, // #6908
  { 9,  2,   0}, // #6909
  {14,  2,   0}, // #6910
  {16,  2,   0}, // #6911
  {17,  1,   0}, // #6912
  {18,  2,   0}, // #6913
  {19,  1,   0}, // #6914
  {20,  2,   0}, // #6915
  {21,  1,   0}, // #6916
  {22,  3,   0}, // #6917
  {23,  4,   0}, // #6918
  {17,  1,   0}, // #6919
  {19, 16,   0}, // #6920
  {21,  1,   0}, // #6921
  {22, 16,   0}, // #6922
  {23, 17,   0}, // #6923
  { 3,  2,   0}, // #6924
  { 8,  2,   0}, // #6925
  {11,  2,   0}, // #6926
  {12,  2,   0}, // #6927
  {13,  4,   0}, // #6928
  {14,  4,   0}, // #6929
  {15,  3,   0}, // #6930
  {17,  2,   0}, // #6931
  {18,  2,   0}, // #6932
  {19,  8,   0}, // #6933
  {20,  6,   0}, // #6934
  {21,  2,   0}, // #6935
  {22, 10,   0}, // #6936
  {23, 12,   0}, // #6937
  { 3,  3,   0}, // #6938
  { 8,  3,   0}, // #6939
  {11,  3,   0}, // #6940
  {12,  3,   0}, // #6941
  {13,  6,   0}, // #6942
  {14,  7,   0}, // #6943
  {15,  4,   0}, // #6944
  {17,  4,   0}, // #6945
  {18,  3,   0}, // #6946
  {19, 12,   0}, // #6947
  {20, 10,   0}, // #6948
  {21,  4,   0}, // #6949
  {22, 16,   0}, // #6950
  {23, 20,   0}, // #6951
  { 3,  5,   0}, // #6952
  { 8,  3,   0}, // #6953
  {11,  5,   0}, // #6954
  {12,  5,   0}, // #6955
  {13,  8,   0}, // #6956
  {14, 13,   0}, // #6957
  {15,  4,   0}, // #6958
  {17,  8,   0}, // #6959
  {18,  3,   0}, // #6960
  {19, 18,   0}, // #6961
  {20, 16,   0}, // #6962
  {21,  8,   0}, // #6963
  {22, 26,   0}, // #6964
  {23, 34,   0}, // #6965
  { 3,  3,   0}, // #6966
  { 8,  3,   0}, // #6967
  {11,  3,   0}, // #6968
  {12,  3,   0}, // #6969
  {13,  6,   0}, // #6970
  {14,  5,   0}, // #6971
  {15,  4,   0}, // #6972
  {17,  2,   0}, // #6973
  {18,  3,   0}, // #6974
  {19, 10,   0}, // #6975
  {20,  8,   0}, // #6976
  {21,  2,   0}, // #6977
  {22, 12,   0}, // #6978
  {23, 14,   0}, // #6979
  { 3,  5,   0}, // #6980
  { 8,  3,   0}, // #6981
  {11,  5,   0}, // #6982
  {12,  5,   0}, // #6983
  {13,  8,   0}, // #6984
  {14,  9,   0}, // #6985
  {15,  4,   0}, // #6986
  {17,  4,   0}, // #6987
  {18,  3,   0}, // #6988
  {19, 14,   0}, // #6989
  {20, 12,   0}, // #6990
  {21,  4,   0}, // #6991
  {22, 18,   0}, // #6992
  {23, 22,   0}, // #6993
  { 3,  3,   0}, // #6994
  { 8,  3,   0}, // #6995
  {11,  3,   0}, // #6996
  {12,  3,   0}, // #6997
  {13,  6,   0}, // #6998
  {14,  5,   0}, // #6999
  {15,  4,   0}, // #7000
  {17,  2,   0}, // #7001
  {18,  3,   0}, // #7002
  {19, 11,   0}, // #7003
  {20,  8,   0}, // #7004
  {21,  2,   0}, // #7005
  {22, 13,   0}, // #7006
  {23, 15,   0}, // #7007
  {14,  1,   0}, // #7008
  {17,  1,   0}, // #7009
  {20,  1,   0}, // #7010
  {21,  1,   0}, // #7011
  {22,  3,   0}, // #7012
  {23,  4,   0}, // #7013
  { 4,  2,   0}, // #7014
  { 5,  3,   0}, // #7015
  { 7,  2,   0}, // #7016
  { 8,  2,   0}, // #7017
  {14,  2,   0}, // #7018
  {15,  1,   0}, // #7019
  {18,  1,   0}, // #7020
  {22,  1,   0}, // #7021
  {14,  1,   0}, // #7022
  {18,  1,   0}, // #7023
  {22,  1,   0}, // #7024
  { 5,  1,   0}, // #7025
  {14,  2,   0}, // #7026
  {15,  1,   0}, // #7027
  {18,  1,   0}, // #7028
  {22,  1,   0}, // #7029
  { 4,  1,   0}, // #7030
  { 5,  2,   0}, // #7031
  { 7,  1,   0}, // #7032
  { 8,  1,   0}, // #7033
  {14,  2,   0}, // #7034
  {15,  1,   0}, // #7035
  {18,  1,   0}, // #7036
  {22,  1,   0}, // #7037
  { 3,  1,   0}, // #7038
  { 4,  1,   0}, // #7039
  { 5,  1,   0}, // #7040
  {10,  1,   0}, // #7041
  {11,  1,   0}, // #7042
  {14,  1,   0}, // #7043
  {15,  1,   0}, // #7044
  { 2,  1,   0}, // #7045
  { 3,  1,   0}, // #7046
  { 4,  1,   0}, // #7047
  { 5,  1,   0}, // #7048
  {14,  1,   0}, // #7049
  {15,  1,   0}, // #7050
  { 2,  2,   0}, // #7051
  { 3,  2,   0}, // #7052
  { 4,  2,   0}, // #7053
  { 5,  2,   0}, // #7054
  {14,  1,   0}, // #7055
  {15,  1,   0}, // #7056
  { 1,  4,   0}, // #7057
  { 2,  5,   0}, // #7058
  { 3, 11,   0}, // #7059
  { 4, 13,   0}, // #7060
  { 5, 13,   0}, // #7061
  { 6,  7,   0}, // #7062
  { 7,  9,   0}, // #7063
  { 8,  6,   0}, // #7064
  {10,  6,   0}, // #7065
  {11,  6,   0}, // #7066
  {14,  1,   0}, // #7067
  {15,  1,   0}, // #7068
  {19,  3,   0}, // #7069
  { 1,  4,   0}, // #7070
  { 2,  5,   0}, // #7071
  { 3, 12,   0}, // #7072
  { 4, 14,   0}, // #7073
  { 5, 14,   0}, // #7074
  { 6,  7,   0}, // #7075
  { 7,  9,   0}, // #7076
  { 8,  6,   0}, // #7077
  {10,  6,   0}, // #7078
  {11,  6,   0}, // #7079
  {19,  3,   0}, // #7080
  { 2,  1,   0}, // #7081
  { 3,  1,   0}, // #7082
  { 4,  2,   0}, // #7083
  { 5,  2,   0}, // #7084
  { 7,  1,   0}, // #7085
  { 8,  1,   0}, // #7086
  { 9,  1,   0}, // #7087
  {10,  1,   0}, // #7088
  {11,  1,   0}, // #7089
  {14,  1,   0}, // #7090
  {15,  1,   0}, // #7091
  { 5,  1,   0}, // #7092
  {11,  1,   0}, // #7093
  {14,  1,   0}, // #7094
  {15,  1,   0}, // #7095
  { 2,  1,   0}, // #7096
  { 3,  1,   0}, // #7097
  { 4,  1,   0}, // #7098
  { 5,  1,   0}, // #7099
  { 9,  1,   0}, // #7100
  {10,  1,   0}, // #7101
  {11,  1,   0}, // #7102
  {14,  1,   0}, // #7103
  {15,  1,   0}, // #7104
  { 2,  1,   0}, // #7105
  { 3,  1,   0}, // #7106
  { 4,  3,   0}, // #7107
  { 5,  9,   0}, // #7108
  { 7,  2,   0}, // #7109
  { 8,  2,   0}, // #7110
  { 9,  1,   0}, // #7111
  {10,  1,   0}, // #7112
  {11,  3,   0}, // #7113
  {14,  1,   0}, // #7114
  {15,  1,   0}, // #7115
  { 2,  1,   0}, // #7116
  { 3,  1,   0}, // #7117
  { 4,  1,   0}, // #7118
  { 5,  1,   0}, // #7119
  { 9,  1,   0}, // #7120
  {10,  1,   0}, // #7121
  {11,  1,   0}, // #7122
  {14,  2,   0}, // #7123
  {15,  1,   0}, // #7124
  {18,  1,   0}, // #7125
  {22,  1,   0}, // #7126
  { 2,  1,   0}, // #7127
  { 3,  1,   0}, // #7128
  { 4,  3,   0}, // #7129
  { 5,  8,   0}, // #7130
  { 7,  2,   0}, // #7131
  { 8,  2,   0}, // #7132
  { 9,  1,   0}, // #7133
  {10,  1,   0}, // #7134
  {11,  3,   0}, // #7135
  {14,  2,   0}, // #7136
  {15,  1,   0}, // #7137
  {18,  1,   0}, // #7138
  {22,  1,   0}, // #7139
  { 3,  1,   0}, // #7140
  { 4,  1,   0}, // #7141
  { 5,  1,   0}, // #7142
  { 6,  1,   0}, // #7143
  { 7,  1,   0}, // #7144
  {10,  1,   0}, // #7145
  {11,  1,   0}, // #7146
  {19,  1,   0}, // #7147
  { 2,  1,   0}, // #7148
  { 3,  2,   0}, // #7149
  { 4,  2,   0}, // #7150
  { 5,  2,   0}, // #7151
  { 6,  1,   0}, // #7152
  { 7,  1,   0}, // #7153
  {10,  1,   0}, // #7154
  {11,  1,   0}, // #7155
  {19,  1,   0}, // #7156
  { 2,  1,   0}, // #7157
  { 3,  2,   0}, // #7158
  { 4,  2,   0}, // #7159
  { 5,  2,   0}, // #7160
  { 6,  1,   0}, // #7161
  { 7,  1,   0}, // #7162
  {10,  1,   0}, // #7163
  {11,  1,   0}, // #7164
  {14,  1,   0}, // #7165
  {15,  1,   0}, // #7166
  {19,  1,   0}, // #7167
  { 1,  1,   0}, // #7168
  { 2,  2,   0}, // #7169
  { 3,  2,   0}, // #7170
  { 4,  2,   0}, // #7171
  { 5,  2,   0}, // #7172
  { 6,  1,   0}, // #7173
  { 7,  1,   0}, // #7174
  { 8,  1,   0}, // #7175
  {14,  1,   0}, // #7176
  {15,  1,   0}, // #7177
  { 2,  1,   0}, // #7178
  { 3,  3,   0}, // #7179
  { 4,  3,   0}, // #7180
  { 5,  3,   0}, // #7181
  { 6,  1,   0}, // #7182
  { 7,  1,   0}, // #7183
  {10,  1,   0}, // #7184
  {11,  1,   0}, // #7185
  {19,  1,   0}, // #7186
  { 2,  3,   0}, // #7187
  { 3,  3,   0}, // #7188
  { 4,  3,   0}, // #7189
  { 5,  4,   0}, // #7190
  { 9,  3,   0}, // #7191
  {10,  3,   0}, // #7192
  {11,  3,   0}, // #7193
  {14,  1,   0}, // #7194
  {15,  1,   0}, // #7195
  { 2,  3,   0}, // #7196
  { 3,  3,   0}, // #7197
  { 4,  3,   0}, // #7198
  { 5,  3,   0}, // #7199
  { 9,  3,   0}, // #7200
  {10,  3,   0}, // #7201
  {11,  3,   0}, // #7202
  {14,  1,   0}, // #7203
  {15,  1,   0}, // #7204
  { 2,  2,   0}, // #7205
  { 3,  3,   0}, // #7206
  { 4,  3,   0}, // #7207
  { 5,  3,   0}, // #7208
  {10,  1,   0}, // #7209
  {11,  1,   0}, // #7210
  {14,  1,   0}, // #7211
  {15,  1,   0}, // #7212
  { 2,  2,   0}, // #7213
  { 3,  5,   0}, // #7214
  { 4,  6,   0}, // #7215
  { 5,  6,   0}, // #7216
  { 6,  1,   0}, // #7217
  { 7,  2,   0}, // #7218
  { 8,  1,   0}, // #7219
  {10,  3,   0}, // #7220
  {11,  3,   0}, // #7221
  {14,  1,   0}, // #7222
  {15,  1,   0}, // #7223
  {19,  1,   0}, // #7224
  { 2,  2,   0}, // #7225
  { 3,  5,   0}, // #7226
  { 4,  6,   0}, // #7227
  { 5,  6,   0}, // #7228
  { 6,  1,   0}, // #7229
  { 7,  2,   0}, // #7230
  { 8,  1,   0}, // #7231
  {10,  3,   0}, // #7232
  {11,  3,   0}, // #7233
  {19,  1,   0}, // #7234
  { 3,  1,   0}, // #7235
  { 4,  1,   0}, // #7236
  { 5,  1,   0}, // #7237
  {10,  1,   0}, // #7238
  {11,  1,   0}, // #7239
  {14,  1,   0}, // #7240
  {18,  1,   0}, // #7241
  {22,  1,   0}, // #7242
  { 3,  1,   0}, // #7243
  { 4,  1,   0}, // #7244
  { 5,  1,   0}, // #7245
  { 6,  1,   0}, // #7246
  { 7,  1,   0}, // #7247
  {10,  1,   0}, // #7248
  {11,  1,   0}, // #7249
  {14,  1,   0}, // #7250
  {15,  1,   0}, // #7251
  {19,  1,   0}, // #7252
  { 3,  3,   0}, // #7253
  { 4,  3,   0}, // #7254
  { 5,  3,   0}, // #7255
  { 6,  2,   0}, // #7256
  { 7,  2,   0}, // #7257
  {10,  3,   0}, // #7258
  {11,  3,   0}, // #7259
  {14,  1,   0}, // #7260
  {15,  1,   0}, // #7261
  {19,  2,   0}, // #7262
  { 3,  3,   0}, // #7263
  { 4,  3,   0}, // #7264
  { 5,  3,   0}, // #7265
  { 6,  2,   0}, // #7266
  { 7,  2,   0}, // #7267
  {10,  3,   0}, // #7268
  {11,  3,   0}, // #7269
  {19,  2,   0}, // #7270
  { 2,  1,   0}, // #7271
  { 3,  1,   0}, // #7272
  { 4,  2,   0}, // #7273
  { 5,  4,   0}, // #7274
  { 7,  1,   0}, // #7275
  { 8,  1,   0}, // #7276
  { 9,  1,   0}, // #7277
  {10,  1,   0}, // #7278
  {11,  1,   0}, // #7279
  {14,  1,   0}, // #7280
  {15,  1,   0}, // #7281
  { 2,  1,   0}, // #7282
  { 3,  1,   0}, // #7283
  { 4,  1,   0}, // #7284
  { 5,  2,   0}, // #7285
  { 9,  1,   0}, // #7286
  {10,  1,   0}, // #7287
  {11,  1,   0}, // #7288
  {14,  1,   0}, // #7289
  {15,  1,   0}, // #7290
  { 2,  1,   0}, // #7291
  { 3,  1,   0}, // #7292
  { 4,  2,   0}, // #7293
  { 5,  3,   0}, // #7294
  { 7,  1,   0}, // #7295
  { 8,  1,   0}, // #7296
  { 9,  1,   0}, // #7297
  {10,  1,   0}, // #7298
  {11,  1,   0}, // #7299
  {14,  1,   0}, // #7300
  {15,  1,   0}, // #7301
  { 2,  1,   0}, // #7302
  { 3,  2,   0}, // #7303
  { 4,  2,   0}, // #7304
  { 5,  2,   0}, // #7305
  { 6,  1,   0}, // #7306
  { 7,  1,   0}, // #7307
  { 9,  1,   0}, // #7308
  {10,  2,   0}, // #7309
  {11,  2,   0}, // #7310
  {14,  1,   0}, // #7311
  {15,  1,   0}, // #7312
  {19,  1,   0}, // #7313
  { 2,  1,   0}, // #7314
  { 3,  2,   0}, // #7315
  { 4,  2,   0}, // #7316
  { 5,  2,   0}, // #7317
  { 6,  1,   0}, // #7318
  { 7,  1,   0}, // #7319
  { 9,  1,   0}, // #7320
  {10,  2,   0}, // #7321
  {11,  2,   0}, // #7322
  {19,  1,   0}, // #7323
  { 1,  1,   0}, // #7324
  { 2,  1,   0}, // #7325
  { 3,  2,   0}, // #7326
  { 4,  3,   0}, // #7327
  { 5,  3,   0}, // #7328
  { 6,  1,   0}, // #7329
  { 7,  2,   0}, // #7330
  { 8,  2,   0}, // #7331
  {14,  1,   0}, // #7332
  {15,  1,   0}, // #7333
  { 3,  1,   0}, // #7334
  { 4,  1,   0}, // #7335
  { 5,  1,   0}, // #7336
  { 6,  1,   0}, // #7337
  { 7,  1,   0}, // #7338
  {14,  1,   0}, // #7339
  {15,  1,   0}, // #7340
  { 3,  3,   0}, // #7341
  { 4,  3,   0}, // #7342
  { 5,  3,   0}, // #7343
  { 6,  3,   0}, // #7344
  { 7,  3,   0}, // #7345
  {10,  2,   0}, // #7346
  {11,  2,   0}, // #7347
  {14,  1,   0}, // #7348
  {15,  1,   0}, // #7349
  {19,  2,   0}, // #7350
  { 3,  3,   0}, // #7351
  { 4,  3,   0}, // #7352
  { 5,  3,   0}, // #7353
  { 6,  3,   0}, // #7354
  { 7,  3,   0}, // #7355
  {10,  2,   0}, // #7356
  {11,  2,   0}, // #7357
  {19,  2,   0}, // #7358
  { 3,  2,   0}, // #7359
  { 4,  2,   0}, // #7360
  { 5,  2,   0}, // #7361
  { 6,  1,   0}, // #7362
  { 7,  1,   0}, // #7363
  {10,  2,   0}, // #7364
  {11,  2,   0}, // #7365
  {19,  1,   0}, // #7366
  { 1,  1,   0}, // #7367
  { 2,  1,   0}, // #7368
  { 3,  2,   0}, // #7369
  { 4,  2,   0}, // #7370
  { 5,  2,   0}, // #7371
  { 6,  2,   0}, // #7372
  { 7,  2,   0}, // #7373
  { 8,  1,   0}, // #7374
  {10,  1,   0}, // #7375
  {11,  1,   0}, // #7376
  {14,  1,   0}, // #7377
  {15,  1,   0}, // #7378
  {19,  1,   0}, // #7379
  { 1,  1,   0}, // #7380
  { 2,  1,   0}, // #7381
  { 3,  2,   0}, // #7382
  { 4,  2,   0}, // #7383
  { 5,  2,   0}, // #7384
  { 6,  2,   0}, // #7385
  { 7,  2,   0}, // #7386
  { 8,  1,   0}, // #7387
  {10,  1,   0}, // #7388
  {11,  1,   0}, // #7389
  {19,  1,   0}, // #7390
  { 3,  2,   0}, // #7391
  { 4,  2,   0}, // #7392
  { 5,  2,   0}, // #7393
  { 6,  1,   0}, // #7394
  { 7,  1,   0}, // #7395
  {10,  2,   0}, // #7396
  {11,  2,   0}, // #7397
  {14,  1,   0}, // #7398
  {15,  1,   0}, // #7399
  {19,  1,   0}, // #7400
  { 1,  3,   0}, // #7401
  { 2,  4,   0}, // #7402
  { 3,  6,   0}, // #7403
  { 4,  7,   0}, // #7404
  { 5,  7,   0}, // #7405
  { 6,  4,   0}, // #7406
  { 7,  5,   0}, // #7407
  { 8,  4,   0}, // #7408
  { 9,  1,   0}, // #7409
  {10,  2,   0}, // #7410
  {11,  2,   0}, // #7411
  {14,  1,   0}, // #7412
  {15,  1,   0}, // #7413
  {19,  1,   0}, // #7414
  { 1,  3,   0}, // #7415
  { 2,  4,   0}, // #7416
  { 3,  7,   0}, // #7417
  { 4,  8,   0}, // #7418
  { 5,  8,   0}, // #7419
  { 6,  4,   0}, // #7420
  { 7,  5,   0}, // #7421
  { 8,  4,   0}, // #7422
  { 9,  1,   0}, // #7423
  {10,  2,   0}, // #7424
  {11,  2,   0}, // #7425
  {19,  1,   0}, // #7426
  { 1,  3,   0}, // #7427
  { 2,  4,   0}, // #7428
  { 3,  7,   0}, // #7429
  { 4,  8,   0}, // #7430
  { 5,  8,   0}, // #7431
  { 6,  4,   0}, // #7432
  { 7,  5,   0}, // #7433
  { 8,  4,   0}, // #7434
  { 9,  1,   0}, // #7435
  {10,  2,   0}, // #7436
  {11,  2,   0}, // #7437
  {14,  1,   0}, // #7438
  {15,  1,   0}, // #7439
  {19,  1,   0}, // #7440
  { 1,  3,   0}, // #7441
  { 2,  4,   0}, // #7442
  { 3,  8,   0}, // #7443
  { 4,  9,   0}, // #7444
  { 5,  9,   0}, // #7445
  { 6,  4,   0}, // #7446
  { 7,  5,   0}, // #7447
  { 8,  4,   0}, // #7448
  { 9,  1,   0}, // #7449
  {10,  2,   0}, // #7450
  {11,  2,   0}, // #7451
  {19,  1,   0}, // #7452
  { 1,  3,   0}, // #7453
  { 2,  3,   0}, // #7454
  { 3,  3,   0}, // #7455
  { 4,  3,   0}, // #7456
  { 5,  3,   0}, // #7457
  { 6,  3,   0}, // #7458
  { 7,  3,   0}, // #7459
  { 8,  3,   0}, // #7460
  {14,  1,   0}, // #7461
  {15,  1,   0}, // #7462
  { 3,  3,   0}, // #7463
  { 4,  3,   0}, // #7464
  { 5,  3,   0}, // #7465
  {10,  2,   0}, // #7466
  {11,  2,   0}, // #7467
  {14,  1,   0}, // #7468
  {15,  1,   0}, // #7469
  { 2,  2,   0}, // #7470
  { 3,  2,   0}, // #7471
  { 4,  5,   0}, // #7472
  { 5,  7,   0}, // #7473
  { 7,  3,   0}, // #7474
  { 8,  3,   0}, // #7475
  { 9,  2,   0}, // #7476
  {10,  2,   0}, // #7477
  {11,  2,   0}, // #7478
  {14,  2,   0}, // #7479
  {15,  1,   0}, // #7480
  {18,  1,   0}, // #7481
  {22,  1,   0}, // #7482
  { 4,  1,   0}, // #7483
  { 5,  1,   0}, // #7484
  { 7,  1,   0}, // #7485
  { 8,  1,   0}, // #7486
  {14,  2,   0}, // #7487
  {15,  1,   0}, // #7488
  {18,  1,   0}, // #7489
  {22,  1,   0}, // #7490
  { 4,  2,   0}, // #7491
  { 5,  2,   0}, // #7492
  { 7,  2,   0}, // #7493
  { 8,  2,   0}, // #7494
  {14,  2,   0}, // #7495
  {15,  1,   0}, // #7496
  {18,  1,   0}, // #7497
  {22,  1,   0}, // #7498
  { 4,  2,   0}, // #7499
  { 5,  2,   0}, // #7500
  { 7,  2,   0}, // #7501
  { 8,  2,   0}, // #7502
  {14,  1,   0}, // #7503
  {18,  1,   0}, // #7504
  {22,  1,   0}, // #7505
  { 2,  1,   0}, // #7506
  { 3,  1,   0}, // #7507
  { 4,  2,   0}, // #7508
  { 5,  3,   0}, // #7509
  { 7,  1,   0}, // #7510
  { 8,  1,   0}, // #7511
  { 9,  1,   0}, // #7512
  {10,  1,   0}, // #7513
  {11,  1,   0}, // #7514
  {14,  2,   0}, // #7515
  {15,  1,   0}, // #7516
  {18,  1,   0}, // #7517
  {22,  1,   0}, // #7518
  { 2,  1,   0}, // #7519
  { 3,  1,   0}, // #7520
  { 4,  1,   0}, // #7521
  { 5,  2,   0}, // #7522
  { 9,  1,   0}, // #7523
  {10,  1,   0}, // #7524
  {11,  1,   0}, // #7525
  {14,  2,   0}, // #7526
  {15,  1,   0}, // #7527
  {18,  1,   0}, // #7528
  {22,  1,   0}, // #7529
  { 1,  1,   0}, // #7530
  { 2,  1,   0}, // #7531
  { 3,  1,   0}, // #7532
  { 4,  1,   0}, // #7533
  { 5,  1,   0}, // #7534
  { 6,  1,   0}, // #7535
  { 7,  1,   0}, // #7536
  { 8,  1,   0}, // #7537
  {27,  7,   0}, // #7538
  { 1,  1,   0}, // #7539
  { 2,  1,   0}, // #7540
  { 3,  1,   0}, // #7541
  { 4,  2,   0}, // #7542
  { 5,  2,   0}, // #7543
  { 6,  1,   0}, // #7544
  { 7,  2,   0}, // #7545
  { 8,  2,   0}, // #7546
  {14,  1,   0}, // #7547
  {18,  1,   0}, // #7548
  {22,  1,   0}, // #7549
  { 3,  2,   0}, // #7550
  { 4,  2,   0}, // #7551
  { 5,  2,   0}, // #7552
  { 6,  2,   0}, // #7553
  { 7,  2,   0}, // #7554
  {10,  2,   0}, // #7555
  {11,  2,   0}, // #7556
  {19,  2,   0}, // #7557
  { 1,  1,   0}, // #7558
  { 2,  1,   0}, // #7559
  { 3,  4,   0}, // #7560
  { 4,  5,   0}, // #7561
  { 5,  5,   0}, // #7562
  { 6,  4,   0}, // #7563
  { 7,  5,   0}, // #7564
  { 8,  2,   0}, // #7565
  {10,  1,   0}, // #7566
  {11,  1,   0}, // #7567
  {14,  1,   0}, // #7568
  {15,  1,   0}, // #7569
  {19,  1,   0}, // #7570
  { 1,  1,   0}, // #7571
  { 2,  1,   0}, // #7572
  { 3,  4,   0}, // #7573
  { 4,  4,   0}, // #7574
  { 5,  4,   0}, // #7575
  { 6,  4,   0}, // #7576
  { 7,  4,   0}, // #7577
  { 8,  1,   0}, // #7578
  {10,  1,   0}, // #7579
  {11,  1,   0}, // #7580
  {19,  1,   0}, // #7581
  { 2,  1,   0}, // #7582
  { 3,  1,   0}, // #7583
  { 4,  1,   0}, // #7584
  { 5,  1,   0}, // #7585
  {14,  1,   0}, // #7586
  {18,  1,   0}, // #7587
  {22,  1,   0}, // #7588
  { 1,  1,   0}, // #7589
  { 2,  1,   0}, // #7590
  { 3,  1,   0}, // #7591
  { 4,  1,   0}, // #7592
  { 5,  1,   0}, // #7593
  { 6,  1,   0}, // #7594
  { 7,  1,   0}, // #7595
  { 8,  1,   0}, // #7596
  {14,  1,   0}, // #7597
  {18,  1,   0}, // #7598
  {22,  1,   0}, // #7599
  { 1,  2,   0}, // #7600
  { 2,  2,   0}, // #7601
  { 3,  3,   0}, // #7602
  { 4,  3,   0}, // #7603
  { 5,  3,   0}, // #7604
  { 6,  3,   0}, // #7605
  { 7,  3,   0}, // #7606
  { 8,  2,   0}, // #7607
  {14,  1,   0}, // #7608
  {15,  1,   0}, // #7609
  { 1,  2,   0}, // #7610
  { 2,  2,   0}, // #7611
  { 3,  2,   0}, // #7612
  { 4,  2,   0}, // #7613
  { 5,  2,   0}, // #7614
  { 6,  2,   0}, // #7615
  { 7,  2,   0}, // #7616
  { 8,  2,   0}, // #7617
  {14,  1,   0}, // #7618
  {15,  1,   0}, // #7619
  { 1,  2,   0}, // #7620
  { 2,  3,   0}, // #7621
  { 3,  7,   0}, // #7622
  { 4, 15,   0}, // #7623
  { 5, 15,   0}, // #7624
  { 6,  6,   0}, // #7625
  { 7, 10,   0}, // #7626
  { 8,  6,   0}, // #7627
  { 9,  1,   0}, // #7628
  {10,  3,   0}, // #7629
  {11,  3,   0}, // #7630
  {19,  2,   0}, // #7631
  {20,  4,   0}, // #7632
  { 2,  1,   0}, // #7633
  { 3,  3,   0}, // #7634
  { 4,  3,   0}, // #7635
  { 5,  3,   0}, // #7636
  { 6,  2,   0}, // #7637
  { 7,  2,   0}, // #7638
  {10,  2,   0}, // #7639
  {11,  2,   0}, // #7640
  {19,  2,   0}, // #7641
  { 1,  1,   0}, // #7642
  { 2,  2,   0}, // #7643
  { 3,  3,   0}, // #7644
  { 4,  3,   0}, // #7645
  { 5,  3,   0}, // #7646
  { 6,  2,   0}, // #7647
  { 7,  2,   0}, // #7648
  { 8,  1,   0}, // #7649
  {10,  1,   0}, // #7650
  {11,  1,   0}, // #7651
  {19,  1,   0}, // #7652
  { 5,  3,   0}, // #7653
  {14,  1,   0}, // #7654
  {15,  1,   0}, // #7655
  { 5,  4,   0}, // #7656
  {14,  2,   0}, // #7657
  {15,  1,   0}, // #7658
  {18,  1,   0}, // #7659
  {22,  1,   0}, // #7660
  { 4,  1,   0}, // #7661
  { 5,  6,   0}, // #7662
  { 7,  1,   0}, // #7663
  { 8,  1,   0}, // #7664
  {14,  2,   0}, // #7665
  {15,  1,   0}, // #7666
  {18,  1,   0}, // #7667
  {22,  1,   0}, // #7668
  { 1,  1,   0}, // #7669
  { 2,  1,   0}, // #7670
  { 3,  2,   0}, // #7671
  { 4,  2,   0}, // #7672
  { 5,  2,   0}, // #7673
  { 6,  2,   0}, // #7674
  { 7,  2,   0}, // #7675
  { 8,  1,   0}, // #7676
  {14,  1,   0}, // #7677
  {15,  1,   0}, // #7678
  { 3,  1,   0}, // #7679
  { 4,  1,   0}, // #7680
  { 5,  1,   0}, // #7681
  { 6,  1,   0}, // #7682
  { 7,  1,   0}, // #7683
  {10,  1,   0}, // #7684
  {11,  1,   0}, // #7685
  {17,  1,   0}, // #7686
  {18,  2,   0}, // #7687
  {19,  1,   0}, // #7688
  { 4,  1,   0}, // #7689
  { 5,  1,   0}, // #7690
  { 7,  1,   0}, // #7691
  { 8,  1,   0}, // #7692
  {17,  1,   0}, // #7693
  {18,  2,   0}, // #7694
  {20,  1,   0}, // #7695
  { 3,  1,   0}, // #7696
  { 4,  2,   0}, // #7697
  { 5,  2,   0}, // #7698
  { 6,  1,   0}, // #7699
  { 7,  2,   0}, // #7700
  { 8,  1,   0}, // #7701
  {10,  1,   0}, // #7702
  {11,  1,   0}, // #7703
  {19,  1,   0}, // #7704
  { 2,  2,   0}, // #7705
  { 3,  2,   0}, // #7706
  { 4,  9,   0}, // #7707
  { 5, 13,   0}, // #7708
  { 7,  7,   0}, // #7709
  { 8,  7,   0}, // #7710
  { 9,  2,   0}, // #7711
  {10,  2,   0}, // #7712
  {11,  2,   0}, // #7713
  {14,  2,   0}, // #7714
  {15,  1,   0}, // #7715
  {18,  1,   0}, // #7716
  {22,  1,   0}, // #7717
  { 1,  2,   0}, // #7718
  { 2,  2,   0}, // #7719
  { 3,  6,   0}, // #7720
  { 4, 12,   0}, // #7721
  { 5, 19,   0}, // #7722
  { 6,  4,   0}, // #7723
  { 7, 10,   0}, // #7724
  { 8,  8,   0}, // #7725
  {10,  4,   0}, // #7726
  {11,  4,   0}, // #7727
  {14,  2,   0}, // #7728
  {15,  1,   0}, // #7729
  {18,  1,   0}, // #7730
  {19,  2,   0}, // #7731
  {22,  1,   0}, // #7732
  { 1,  2,   0}, // #7733
  { 2,  8,   0}, // #7734
  { 3, 12,   0}, // #7735
  { 4, 21,   0}, // #7736
  { 5, 21,   0}, // #7737
  { 6,  5,   0}, // #7738
  { 7, 14,   0}, // #7739
  { 8,  9,   0}, // #7740
  { 9,  4,   0}, // #7741
  {10,  7,   0}, // #7742
  {11,  7,   0}, // #7743
  {19,  3,   0}, // #7744
  { 1,  2,   0}, // #7745
  { 2,  4,   0}, // #7746
  { 3, 13,   0}, // #7747
  { 4, 34,   0}, // #7748
  { 5, 34,   0}, // #7749
  { 6, 11,   0}, // #7750
  { 7, 32,   0}, // #7751
  { 8, 23,   0}, // #7752
  { 9,  2,   0}, // #7753
  {10, 11,   0}, // #7754
  {11, 11,   0}, // #7755
  {14, 19,   0}, // #7756
  {15, 14,   0}, // #7757
  {18,  4,   0}, // #7758
  {19,  9,   0}, // #7759
  {22,  5,   0}, // #7760
  { 2,  1,   0}, // #7761
  { 3,  1,   0}, // #7762
  { 4,  3,   0}, // #7763
  { 5,  9,   0}, // #7764
  { 7,  2,   0}, // #7765
  { 8,  2,   0}, // #7766
  { 9,  1,   0}, // #7767
  {10,  1,   0}, // #7768
  {11,  1,   0}, // #7769
  {14,  1,   0}, // #7770
  {15,  1,   0}, // #7771
  { 3,  1,   0}, // #7772
  { 4, 10,   0}, // #7773
  { 5, 10,   0}, // #7774
  { 6,  1,   0}, // #7775
  { 7,  3,   0}, // #7776
  { 8,  2,   0}, // #7777
  {10,  1,   0}, // #7778
  {11,  1,   0}, // #7779
  {19,  1,   0}, // #7780
  {20,  2,   0}, // #7781
  { 1,  7,   0}, // #7782
  { 2, 24,   0}, // #7783
  { 3, 44,   0}, // #7784
  { 4, 70,   0}, // #7785
  { 5, 75,   0}, // #7786
  { 6, 26,   0}, // #7787
  { 7, 52,   0}, // #7788
  { 8, 32,   0}, // #7789
  { 9, 17,   0}, // #7790
  {10, 36,   0}, // #7791
  {11, 37,   0}, // #7792
  {14, 10,   0}, // #7793
  {15,  9,   0}, // #7794
  {18,  1,   0}, // #7795
  {19, 19,   0}, // #7796
  {22,  1,   0}, // #7797
  { 3,  9,   0}, // #7798
  { 4, 15,   0}, // #7799
  { 5, 15,   0}, // #7800
  { 6,  9,   0}, // #7801
  { 7,  9,   0}, // #7802
  {10,  6,   0}, // #7803
  {11,  6,   0}, // #7804
  {19,  6,   0}, // #7805
  { 1,  5,   0}, // #7806
  { 2, 20,   0}, // #7807
  { 3, 35,   0}, // #7808
  { 4, 61,   0}, // #7809
  { 5, 66,   0}, // #7810
  { 6, 20,   0}, // #7811
  { 7, 46,   0}, // #7812
  { 8, 31,   0}, // #7813
  { 9, 15,   0}, // #7814
  {10, 30,   0}, // #7815
  {11, 30,   0}, // #7816
  {14,  6,   0}, // #7817
  {15,  5,   0}, // #7818
  {18,  1,   0}, // #7819
  {19, 15,   0}, // #7820
  {22,  1,   0}, // #7821
  { 1,  5,   0}, // #7822
  { 2, 20,   0}, // #7823
  { 3, 36,   0}, // #7824
  { 4, 61,   0}, // #7825
  { 5, 66,   0}, // #7826
  { 6, 21,   0}, // #7827
  { 7, 46,   0}, // #7828
  { 8, 30,   0}, // #7829
  { 9, 15,   0}, // #7830
  {10, 30,   0}, // #7831
  {11, 30,   0}, // #7832
  {14,  6,   0}, // #7833
  {15,  5,   0}, // #7834
  {18,  1,   0}, // #7835
  {19, 15,   0}, // #7836
  {22,  1,   0}, // #7837
  { 1,  6,   0}, // #7838
  { 2, 23,   0}, // #7839
  { 3, 41,   0}, // #7840
  { 4, 68,   0}, // #7841
  { 5, 73,   0}, // #7842
  { 6, 24,   0}, // #7843
  { 7, 51,   0}, // #7844
  { 8, 33,   0}, // #7845
  { 9, 16,   0}, // #7846
  {10, 34,   0}, // #7847
  {11, 34,   0}, // #7848
  {14,  9,   0}, // #7849
  {15,  8,   0}, // #7850
  {18,  1,   0}, // #7851
  {19, 18,   0}, // #7852
  {22,  1,   0}, // #7853
  { 2,  9,   0}, // #7854
  { 3, 23,   0}, // #7855
  { 4, 53,   0}, // #7856
  { 5, 54,   0}, // #7857
  { 6,  3,   0}, // #7858
  { 7, 33,   0}, // #7859
  { 8, 20,   0}, // #7860
  { 9,  8,   0}, // #7861
  {10, 15,   0}, // #7862
  {11, 16,   0}, // #7863
  {19,  2,   0}, // #7864
  { 1,  7,   0}, // #7865
  { 2, 26,   0}, // #7866
  { 3, 46,   0}, // #7867
  { 4, 71,   0}, // #7868
  { 5, 79,   0}, // #7869
  { 6, 27,   0}, // #7870
  { 7, 52,   0}, // #7871
  { 8, 32,   0}, // #7872
  { 9, 19,   0}, // #7873
  {10, 39,   0}, // #7874
  {11, 41,   0}, // #7875
  {14,  8,   0}, // #7876
  {15,  8,   0}, // #7877
  {19, 20,   0}, // #7878
  { 1,  7,   0}, // #7879
  { 2, 26,   0}, // #7880
  { 3, 46,   0}, // #7881
  { 4, 71,   0}, // #7882
  { 5, 79,   0}, // #7883
  { 6, 27,   0}, // #7884
  { 7, 52,   0}, // #7885
  { 8, 32,   0}, // #7886
  { 9, 19,   0}, // #7887
  {10, 39,   0}, // #7888
  {11, 41,   0}, // #7889
  {14,  7,   0}, // #7890
  {15,  7,   0}, // #7891
  {19, 20,   0}, // #7892
  { 1,  2,   0}, // #7893
  { 2,  9,   0}, // #7894
  { 3, 14,   0}, // #7895
  { 4, 24,   0}, // #7896
  { 5, 24,   0}, // #7897
  { 6,  7,   0}, // #7898
  { 7, 17,   0}, // #7899
  { 8, 12,   0}, // #7900
  { 9,  6,   0}, // #7901
  {10, 11,   0}, // #7902
  {11, 11,   0}, // #7903
  {14,  1,   0}, // #7904
  {18,  1,   0}, // #7905
  {19,  5,   0}, // #7906
  {22,  1,   0}, // #7907
  { 1,  2,   0}, // #7908
  { 2, 12,   0}, // #7909
  { 3, 17,   0}, // #7910
  { 4, 27,   0}, // #7911
  { 5, 32,   0}, // #7912
  { 6,  7,   0}, // #7913
  { 7, 17,   0}, // #7914
  { 8, 12,   0}, // #7915
  { 9, 10,   0}, // #7916
  {10, 15,   0}, // #7917
  {11, 15,   0}, // #7918
  {14, 40,   0}, // #7919
  {15,  2,   0}, // #7920
  {18, 38,   0}, // #7921
  {19,  5,   0}, // #7922
  {22, 38,   0}, // #7923
  { 1,  4,   0}, // #7924
  { 2,  4,   0}, // #7925
  { 3,  6,   0}, // #7926
  { 4, 10,   0}, // #7927
  { 5, 10,   0}, // #7928
  { 6,  5,   0}, // #7929
  { 7,  9,   0}, // #7930
  { 8,  8,   0}, // #7931
  {10,  1,   0}, // #7932
  {11,  1,   0}, // #7933
  {13, 47,   0}, // #7934
  {14, 80,   0}, // #7935
  {15, 80,   0}, // #7936
  {20,  2,   0}, // #7937
  { 1,  8,   0}, // #7938
  { 2, 35,   0}, // #7939
  { 3, 79,   0}, // #7940
  { 4, 142,   0}, // #7941
  { 5, 142,   0}, // #7942
  { 6, 37,   0}, // #7943
  { 7, 100,   0}, // #7944
  { 8, 71,   0}, // #7945
  { 9, 21,   0}, // #7946
  {10, 46,   0}, // #7947
  {11, 46,   0}, // #7948
  {14,  1,   0}, // #7949
  {18,  1,   0}, // #7950
  {19, 10,   0}, // #7951
  {22,  1,   0}, // #7952
  { 2,  1,   0}, // #7953
  { 3,  1,   0}, // #7954
  { 4,  1,   0}, // #7955
  { 5,  1,   0}, // #7956
  { 9,  1,   0}, // #7957
  {10,  1,   0}, // #7958
  {11,  1,   0}, // #7959
  {14,  1,   0}, // #7960
  {18,  1,   0}, // #7961
  {22,  1,   0}, // #7962
  { 3,  1,   0}, // #7963
  { 4,  1,   0}, // #7964
  { 5,  1,   0}, // #7965
  { 6,  1,   0}, // #7966
  { 7,  1,   0}, // #7967
  {10,  1,   0}, // #7968
  {11,  1,   0}, // #7969
  {14,  1,   0}, // #7970
  {18,  1,   0}, // #7971
  {19,  1,   0}, // #7972
  {22,  1,   0}, // #7973
  { 5,  2,   0}, // #7974
  {14,  1,   0}, // #7975
  {18,  1,   0}, // #7976
  {22,  1,   0}, // #7977
  { 2,  1,   0}, // #7978
  { 3,  1,   0}, // #7979
  { 4,  2,   0}, // #7980
  { 5,  2,   0}, // #7981
  { 7,  1,   0}, // #7982
  { 8,  1,   0}, // #7983
  { 9,  1,   0}, // #7984
  {10,  1,   0}, // #7985
  {11,  1,   0}, // #7986
  {14,  1,   0}, // #7987
  {18,  1,   0}, // #7988
  {22,  1,   0}, // #7989
  { 1,  5,   0}, // #7990
  { 2, 13,   0}, // #7991
  { 3, 13,   0}, // #7992
  { 4, 13,   0}, // #7993
  { 5, 13,   0}, // #7994
  { 6,  5,   0}, // #7995
  { 7,  5,   0}, // #7996
  { 8,  5,   0}, // #7997
  { 9,  8,   0}, // #7998
  {10,  8,   0}, // #7999
  {11,  8,   0}, // #8000
  {14, 21,   0}, // #8001
  {15, 21,   0}, // #8002
  { 4,  1,   0}, // #8003
  { 5,  1,   0}, // #8004
  { 7,  1,   0}, // #8005
  { 8,  1,   0}, // #8006
  {14,  1,   0}, // #8007
  {15,  1,   0}, // #8008
  {20,  1,   0}, // #8009
  { 1,  1,   0}, // #8010
  { 2,  1,   0}, // #8011
  { 3,  1,   0}, // #8012
  { 4,  1,   0}, // #8013
  { 5,  1,   0}, // #8014
  { 6,  1,   0}, // #8015
  { 7,  1,   0}, // #8016
  { 8,  1,   0}, // #8017
  {17,  1,   0}, // #8018
  {18,  2,   0}, // #8019
  { 5,  5,   0}, // #8020
  {14,  2,   0}, // #8021
  {15,  2,   0}, // #8022
  { 5,  2,   0}, // #8023
  {14,  2,   0}, // #8024
  {15,  1,   0}, // #8025
  {18,  1,   0}, // #8026
  {22,  1,   0}, // #8027
  { 4,  1,   0}, // #8028
  { 5,  1,   0}, // #8029
  { 7,  1,   0}, // #8030
  { 8,  1,   0}, // #8031
  {13,  1,   0}, // #8032
  {14,  2,   0}, // #8033
  {15,  2,   0}, // #8034
  {17,  1,   0}, // #8035
  {18,  2,   0}, // #8036
  {20,  1,   0}, // #8037
  { 4,  1,   0}, // #8038
  { 5,  3,   0}, // #8039
  { 7,  1,   0}, // #8040
  { 8,  1,   0}, // #8041
  {14,  2,   0}, // #8042
  {15,  1,   0}, // #8043
  {18,  1,   0}, // #8044
  {22,  1,   0}, // #8045
  { 3,  2,   0}, // #8046
  { 4,  2,   0}, // #8047
  { 5,  2,   0}, // #8048
  { 6,  2,   0}, // #8049
  { 7,  2,   0}, // #8050
  {10,  2,   0}, // #8051
  {11,  2,   0}, // #8052
  {14,  1,   0}, // #8053
  {15,  1,   0}, // #8054
  {19,  2,   0}, // #8055
  { 4,  2,   0}, // #8056
  { 5,  2,   0}, // #8057
  { 7,  2,   0}, // #8058
  { 8,  2,   0}, // #8059
  {14,  1,   0}, // #8060
  {15,  1,   0}, // #8061
  { 2,  2,   0}, // #8062
  { 3,  3,   0}, // #8063
  { 4,  9,   0}, // #8064
  { 5, 18,   0}, // #8065
  { 6,  1,   0}, // #8066
  { 7,  7,   0}, // #8067
  { 8,  6,   0}, // #8068
  { 9,  2,   0}, // #8069
  {10,  3,   0}, // #8070
  {11,  3,   0}, // #8071
  {19,  1,   0}, // #8072
  { 1,  2,   0}, // #8073
  { 2,  9,   0}, // #8074
  { 3, 14,   0}, // #8075
  { 4, 21,   0}, // #8076
  { 5, 24,   0}, // #8077
  { 6,  4,   0}, // #8078
  { 7, 11,   0}, // #8079
  { 8,  7,   0}, // #8080
  { 9,  7,   0}, // #8081
  {10, 12,   0}, // #8082
  {11, 12,   0}, // #8083
  {14,  1,   0}, // #8084
  {15,  1,   0}, // #8085
  {19,  2,   0}, // #8086
  { 2,  2,   0}, // #8087
  { 3,  2,   0}, // #8088
  { 4,  2,   0}, // #8089
  { 5,  3,   0}, // #8090
  { 9,  2,   0}, // #8091
  {10,  2,   0}, // #8092
  {11,  2,   0}, // #8093
  {14,  2,   0}, // #8094
  {18,  2,   0}, // #8095
  {22,  2,   0}, // #8096
  { 4,  1,   0}, // #8097
  { 5,  1,   0}, // #8098
  { 7,  1,   0}, // #8099
  { 8,  1,   0}, // #8100
  {14,  1,   0}, // #8101
  {18,  1,   0}, // #8102
  {22,  1,   0}, // #8103
  { 1,  1,   0}, // #8104
  { 2,  6,   0}, // #8105
  { 3,  8,   0}, // #8106
  { 4, 17,   0}, // #8107
  { 5, 20,   0}, // #8108
  { 6,  2,   0}, // #8109
  { 7, 11,   0}, // #8110
  { 8,  9,   0}, // #8111
  { 9,  5,   0}, // #8112
  {10,  7,   0}, // #8113
  {11,  7,   0}, // #8114
  {14,  2,   0}, // #8115
  {15,  2,   0}, // #8116
  {19,  1,   0}, // #8117
  { 1,  1,   0}, // #8118
  { 2,  4,   0}, // #8119
  { 3,  5,   0}, // #8120
  { 4, 10,   0}, // #8121
  { 5, 10,   0}, // #8122
  { 6,  2,   0}, // #8123
  { 7,  7,   0}, // #8124
  { 8,  6,   0}, // #8125
  { 9,  3,   0}, // #8126
  {10,  4,   0}, // #8127
  {11,  4,   0}, // #8128
  {14,  3,   0}, // #8129
  {15,  3,   0}, // #8130
  {19,  1,   0}, // #8131
  { 2,  8,   0}, // #8132
  { 3, 14,   0}, // #8133
  { 4, 30,   0}, // #8134
  { 5, 54,   0}, // #8135
  { 6,  2,   0}, // #8136
  { 7, 18,   0}, // #8137
  { 8, 14,   0}, // #8138
  { 9,  8,   0}, // #8139
  {10, 10,   0}, // #8140
  {11, 11,   0}, // #8141
  {19,  2,   0}, // #8142
  { 2,  3,   0}, // #8143
  { 3,  4,   0}, // #8144
  { 4, 10,   0}, // #8145
  { 5, 15,   0}, // #8146
  { 6,  1,   0}, // #8147
  { 7,  7,   0}, // #8148
  { 8,  6,   0}, // #8149
  { 9,  3,   0}, // #8150
  {10,  4,   0}, // #8151
  {11,  4,   0}, // #8152
  {19,  1,   0}, // #8153
  { 2,  1,   0}, // #8154
  { 3,  1,   0}, // #8155
  { 4,  9,   0}, // #8156
  { 5,  9,   0}, // #8157
  { 7,  8,   0}, // #8158
  { 8,  8,   0}, // #8159
  { 9,  1,   0}, // #8160
  {10,  1,   0}, // #8161
  {11,  1,   0}, // #8162
  {13, 21,   0}, // #8163
  {14, 22,   0}, // #8164
  {15, 22,   0}, // #8165
  {20,  8,   0}, // #8166
  { 2, 35,   0}, // #8167
  { 3, 90,   0}, // #8168
  { 4, 134,   0}, // #8169
  { 5, 134,   0}, // #8170
  { 6, 34,   0}, // #8171
  { 7, 78,   0}, // #8172
  { 8, 44,   0}, // #8173
  { 9, 21,   0}, // #8174
  {10, 51,   0}, // #8175
  {11, 51,   0}, // #8176
  {14,  5,   0}, // #8177
  {15,  4,   0}, // #8178
  {18,  1,   0}, // #8179
  {19,  9,   0}, // #8180
  {22,  1,   0}, // #8181
  { 2, 52,   0}, // #8182
  { 3, 97,   0}, // #8183
  { 4, 150,   0}, // #8184
  { 5, 150,   0}, // #8185
  { 6, 45,   0}, // #8186
  { 7, 98,   0}, // #8187
  { 8, 53,   0}, // #8188
  { 9, 27,   0}, // #8189
  {10, 37,   0}, // #8190
  {11, 37,   0}, // #8191
  {14,  5,   0}, // #8192
  {15,  4,   0}, // #8193
  {18,  1,   0}, // #8194
  {19, 10,   0}, // #8195
  {22,  1,   0}, // #8196
  { 2,  1,   0}, // #8197
  { 3,  4,   0}, // #8198
  { 4,  7,   0}, // #8199
  { 5,  7,   0}, // #8200
  { 6,  2,   0}, // #8201
  { 7,  5,   0}, // #8202
  { 8,  3,   0}, // #8203
  { 9,  1,   0}, // #8204
  {10,  4,   0}, // #8205
  {11,  4,   0}, // #8206
  {13,  1,   0}, // #8207
  {14,  9,   0}, // #8208
  {15,  9,   0}, // #8209
  {17,  1,   0}, // #8210
  {18,  2,   0}, // #8211
  {19,  2,   0}, // #8212
  {20,  3,   0}, // #8213
  { 1,  2,   0}, // #8214
  { 2,  2,   0}, // #8215
  { 3,  7,   0}, // #8216
  { 4, 17,   0}, // #8217
  { 5, 17,   0}, // #8218
  { 6,  7,   0}, // #8219
  { 7, 17,   0}, // #8220
  { 8, 12,   0}, // #8221
  {13, 39,   0}, // #8222
  {14, 47,   0}, // #8223
  {15, 47,   0}, // #8224
  { 1,  4,   0}, // #8225
  { 2,  4,   0}, // #8226
  { 3,  6,   0}, // #8227
  { 4, 12,   0}, // #8228
  { 5, 12,   0}, // #8229
  { 6,  5,   0}, // #8230
  { 7, 11,   0}, // #8231
  { 8, 10,   0}, // #8232
  {10,  1,   0}, // #8233
  {11,  1,   0}, // #8234
  {13, 45,   0}, // #8235
  {14, 76,   0}, // #8236
  {15, 76,   0}, // #8237
  {20,  4,   0}, // #8238
  { 1,  9,   0}, // #8239
  { 2, 10,   0}, // #8240
  { 3, 26,   0}, // #8241
  { 4, 59,   0}, // #8242
  { 5, 59,   0}, // #8243
  { 6, 25,   0}, // #8244
  { 7, 47,   0}, // #8245
  { 8, 31,   0}, // #8246
  { 9,  1,   0}, // #8247
  {10, 17,   0}, // #8248
  {11, 17,   0}, // #8249
  {17, 30,   0}, // #8250
  {18, 41,   0}, // #8251
  {19, 16,   0}, // #8252
  {20,  1,   0}, // #8253
  { 1,  1,   0}, // #8254
  { 2,  1,   0}, // #8255
  { 3,  3,   0}, // #8256
  { 4,  3,   0}, // #8257
  { 5,  3,   0}, // #8258
  { 6,  1,   0}, // #8259
  { 7,  1,   0}, // #8260
  { 8,  1,   0}, // #8261
  {10,  1,   0}, // #8262
  {11,  1,   0}, // #8263
  {14,  2,   0}, // #8264
  {15,  2,   0}, // #8265
  { 1,  1,   0}, // #8266
  { 2,  1,   0}, // #8267
  { 3,  4,   0}, // #8268
  { 4,  4,   0}, // #8269
  { 5,  4,   0}, // #8270
  { 6,  1,   0}, // #8271
  { 7,  1,   0}, // #8272
  { 8,  1,   0}, // #8273
  {10,  2,   0}, // #8274
  {11,  2,   0}, // #8275
  {14,  4,   0}, // #8276
  {15,  4,   0}, // #8277
  { 1,  1,   0}, // #8278
  { 2,  1,   0}, // #8279
  { 3,  4,   0}, // #8280
  { 4,  4,   0}, // #8281
  { 5,  4,   0}, // #8282
  { 6,  1,   0}, // #8283
  { 7,  1,   0}, // #8284
  { 8,  1,   0}, // #8285
  {10,  2,   0}, // #8286
  {11,  2,   0}, // #8287
  {14,  8,   0}, // #8288
  {15,  8,   0}, // #8289
  { 4,  1,   0}, // #8290
  { 5,  1,   0}, // #8291
  { 7,  1,   0}, // #8292
  { 8,  1,   0}, // #8293
  {13,  1,   0}, // #8294
  {14,  2,   0}, // #8295
  {15,  2,   0}, // #8296
  {20,  1,   0}, // #8297
  { 2,  1,   0}, // #8298
  { 3,  1,   0}, // #8299
  { 4,  3,   0}, // #8300
  { 5,  3,   0}, // #8301
  { 7,  2,   0}, // #8302
  { 8,  2,   0}, // #8303
  { 9,  1,   0}, // #8304
  {10,  1,   0}, // #8305
  {11,  1,   0}, // #8306
  {14,  1,   0}, // #8307
  {15,  1,   0}, // #8308
  { 1,  2,   0}, // #8309
  { 2,  2,   0}, // #8310
  { 3,  2,   0}, // #8311
  { 4,  2,   0}, // #8312
  { 5,  2,   0}, // #8313
  { 6,  2,   0}, // #8314
  { 7,  2,   0}, // #8315
  { 8,  2,   0}, // #8316
  {14,  1,   0}, // #8317
  {18,  1,   0}, // #8318
  {22,  1,   0}, // #8319
  { 2,  2,   0}, // #8320
  { 3,  6,   0}, // #8321
  { 4,  7,   0}, // #8322
  { 5,  7,   0}, // #8323
  { 7,  1,   0}, // #8324
  { 8,  1,   0}, // #8325
  {10,  2,   0}, // #8326
  {11,  2,   0}, // #8327
  {14,  1,   0}, // #8328
  {15,  1,   0}, // #8329
  { 2,  1,   0}, // #8330
  { 3,  3,   0}, // #8331
  { 4,  3,   0}, // #8332
  { 5,  3,   0}, // #8333
  {10,  1,   0}, // #8334
  {11,  1,   0}, // #8335
  {14,  1,   0}, // #8336
  {15,  1,   0}, // #8337
  { 4,  1,   0}, // #8338
  { 5,  2,   0}, // #8339
  { 7,  1,   0}, // #8340
  { 8,  1,   0}, // #8341
  {14,  1,   0}, // #8342
  {15,  1,   0}, // #8343
  { 4,  1,   0}, // #8344
  { 5,  5,   0}, // #8345
  { 7,  1,   0}, // #8346
  { 8,  1,   0}, // #8347
  {14,  2,   0}, // #8348
  {15,  1,   0}, // #8349
  {18,  1,   0}, // #8350
  {22,  1,   0}, // #8351
  { 2,  3,   0}, // #8352
  { 3,  6,   0}, // #8353
  { 4,  7,   0}, // #8354
  { 5,  7,   0}, // #8355
  { 6,  1,   0}, // #8356
  { 7,  2,   0}, // #8357
  { 8,  1,   0}, // #8358
  {10,  1,   0}, // #8359
  {11,  1,   0}, // #8360
  {19,  1,   0}, // #8361
  { 2,  3,   0}, // #8362
  { 3,  6,   0}, // #8363
  { 4,  7,   0}, // #8364
  { 5,  7,   0}, // #8365
  { 6,  1,   0}, // #8366
  { 7,  2,   0}, // #8367
  { 8,  1,   0}, // #8368
  {10,  1,   0}, // #8369
  {11,  1,   0}, // #8370
  {14,  1,   0}, // #8371
  {15,  1,   0}, // #8372
  {19,  1,   0}, // #8373
  { 2,  2,   0}, // #8374
  { 3,  4,   0}, // #8375
  { 4,  4,   0}, // #8376
  { 5,  4,   0}, // #8377
  { 6,  2,   0}, // #8378
  { 7,  2,   0}, // #8379
  {10,  2,   0}, // #8380
  {11,  2,   0}, // #8381
  {19,  2,   0}, // #8382
  { 1,  2,   0}, // #8383
  { 2,  2,   0}, // #8384
  { 3,  4,   0}, // #8385
  { 4,  4,   0}, // #8386
  { 5,  4,   0}, // #8387
  { 6,  4,   0}, // #8388
  { 7,  4,   0}, // #8389
  { 8,  2,   0}, // #8390
  {10,  2,   0}, // #8391
  {11,  2,   0}, // #8392
  {19,  2,   0}, // #8393
  { 2,  5,   0}, // #8394
  { 3, 15,   0}, // #8395
  { 4, 15,   0}, // #8396
  { 5, 15,   0}, // #8397
  { 6,  5,   0}, // #8398
  { 7,  5,   0}, // #8399
  {10,  5,   0}, // #8400
  {11,  5,   0}, // #8401
  {19,  5,   0}, // #8402
  { 2,  7,   0}, // #8403
  { 3, 22,   0}, // #8404
  { 4, 23,   0}, // #8405
  { 5, 23,   0}, // #8406
  { 6,  9,   0}, // #8407
  { 7, 10,   0}, // #8408
  { 8,  1,   0}, // #8409
  {10,  9,   0}, // #8410
  {11,  9,   0}, // #8411
  {19,  9,   0}, // #8412
  { 1, 11,   0}, // #8413
  { 2, 11,   0}, // #8414
  { 3, 37,   0}, // #8415
  { 4, 37,   0}, // #8416
  { 5, 37,   0}, // #8417
  { 6, 37,   0}, // #8418
  { 7, 37,   0}, // #8419
  { 8, 11,   0}, // #8420
  {10, 17,   0}, // #8421
  {11, 17,   0}, // #8422
  {19, 17,   0}, // #8423
  { 1,  1,   0}, // #8424
  { 2,  4,   0}, // #8425
  { 3,  5,   0}, // #8426
  { 4,  9,   0}, // #8427
  { 5, 13,   0}, // #8428
  { 6,  2,   0}, // #8429
  { 7,  6,   0}, // #8430
  { 8,  5,   0}, // #8431
  { 9,  3,   0}, // #8432
  {10,  4,   0}, // #8433
  {11,  4,   0}, // #8434
  {14,  2,   0}, // #8435
  {15,  2,   0}, // #8436
  {19,  1,   0}, // #8437
  { 1,  1,   0}, // #8438
  { 2,  1,   0}, // #8439
  { 3,  3,   0}, // #8440
  { 4,  3,   0}, // #8441
  { 5,  3,   0}, // #8442
  { 6,  3,   0}, // #8443
  { 7,  3,   0}, // #8444
  { 8,  1,   0}, // #8445
  {10,  2,   0}, // #8446
  {11,  2,   0}, // #8447
  {19,  2,   0}, // #8448
  { 1,  1,   0}, // #8449
  { 2,  1,   0}, // #8450
  { 3,  3,   0}, // #8451
  { 4,  3,   0}, // #8452
  { 5,  3,   0}, // #8453
  { 6,  3,   0}, // #8454
  { 7,  3,   0}, // #8455
  { 8,  1,   0}, // #8456
  {10,  2,   0}, // #8457
  {11,  2,   0}, // #8458
  {14,  1,   0}, // #8459
  {15,  1,   0}, // #8460
  {19,  2,   0}, // #8461
  { 2,  1,   0}, // #8462
  { 3,  3,   0}, // #8463
  { 4,  3,   0}, // #8464
  { 5,  3,   0}, // #8465
  {10,  2,   0}, // #8466
  {11,  2,   0}, // #8467
  {14,  1,   0}, // #8468
  {15,  1,   0}, // #8469
  { 2, 52,   0}, // #8470
  { 3, 125,   0}, // #8471
  { 4, 178,   0}, // #8472
  { 5, 178,   0}, // #8473
  { 6, 41,   0}, // #8474
  { 7, 94,   0}, // #8475
  { 8, 53,   0}, // #8476
  { 9, 29,   0}, // #8477
  {10, 69,   0}, // #8478
  {11, 69,   0}, // #8479
  {14,  6,   0}, // #8480
  {15,  4,   0}, // #8481
  {18,  2,   0}, // #8482
  {19,  8,   0}, // #8483
  {22,  2,   0}, // #8484
  { 3,  2,   0}, // #8485
  { 4,  2,   0}, // #8486
  { 5,  2,   0}, // #8487
  { 6,  1,   0}, // #8488
  { 7,  1,   0}, // #8489
  {10,  2,   0}, // #8490
  {11,  2,   0}, // #8491
  {14,  1,   0}, // #8492
  {18,  1,   0}, // #8493
  {19,  1,   0}, // #8494
  {22,  1,   0}, // #8495
  { 3,  2,   0}, // #8496
  { 4,  2,   0}, // #8497
  { 5,  2,   0}, // #8498
  { 6,  2,   0}, // #8499
  { 7,  2,   0}, // #8500
  {10,  2,   0}, // #8501
  {11,  2,   0}, // #8502
  {14,  1,   0}, // #8503
  {18,  1,   0}, // #8504
  {19,  2,   0}, // #8505
  {22,  1,   0}, // #8506
  { 1,  1,   0}, // #8507
  { 2,  2,   0}, // #8508
  { 3,  2,   0}, // #8509
  { 4,  2,   0}, // #8510
  { 5,  3,   0}, // #8511
  { 6,  1,   0}, // #8512
  { 7,  1,   0}, // #8513
  { 8,  1,   0}, // #8514
  {14,  2,   0}, // #8515
  {18,  2,   0}, // #8516
  {22,  2,   0}, // #8517
  { 1,  1,   0}, // #8518
  { 2,  2,   0}, // #8519
  { 3,  2,   0}, // #8520
  { 4,  2,   0}, // #8521
  { 5,  3,   0}, // #8522
  { 6,  1,   0}, // #8523
  { 7,  1,   0}, // #8524
  { 8,  1,   0}, // #8525
  {14,  4,   0}, // #8526
  {18,  4,   0}, // #8527
  {22,  4,   0}, // #8528
  { 1,  2,   0}, // #8529
  { 2,  2,   0}, // #8530
  { 3,  2,   0}, // #8531
  { 4,  2,   0}, // #8532
  { 5,  3,   0}, // #8533
  { 6,  2,   0}, // #8534
  { 7,  2,   0}, // #8535
  { 8,  2,   0}, // #8536
  {14,  8,   0}, // #8537
  {18,  8,   0}, // #8538
  {22,  8,   0}, // #8539
  { 1,  2,   0}, // #8540
  { 2,  2,   0}, // #8541
  { 3,  2,   0}, // #8542
  { 4,  2,   0}, // #8543
  { 5,  3,   0}, // #8544
  { 6,  2,   0}, // #8545
  { 7,  2,   0}, // #8546
  { 8,  2,   0}, // #8547
  {14, 16,   0}, // #8548
  {18, 16,   0}, // #8549
  {22, 16,   0}, // #8550
  { 1,  1,   0}, // #8551
  { 2,  2,   0}, // #8552
  { 3,  2,   0}, // #8553
  { 4,  2,   0}, // #8554
  { 5,  3,   0}, // #8555
  { 6,  1,   0}, // #8556
  { 7,  1,   0}, // #8557
  { 8,  1,   0}, // #8558
  {14,  8,   0}, // #8559
  {18,  8,   0}, // #8560
  {22,  8,   0}, // #8561
  { 3,  3,   0}, // #8562
  { 4,  3,   0}, // #8563
  { 5,  3,   0}, // #8564
  { 6,  2,   0}, // #8565
  { 7,  2,   0}, // #8566
  {10,  2,   0}, // #8567
  {11,  2,   0}, // #8568
  {14,  1,   0}, // #8569
  {15,  1,   0}, // #8570
  {19,  2,   0}, // #8571
  { 2,  5,   0}, // #8572
  { 3, 14,   0}, // #8573
  { 4, 14,   0}, // #8574
  { 5, 14,   0}, // #8575
  { 6,  5,   0}, // #8576
  { 7,  5,   0}, // #8577
  {10,  5,   0}, // #8578
  {11,  5,   0}, // #8579
  {14,  1,   0}, // #8580
  {15,  1,   0}, // #8581
  {19,  5,   0}, // #8582
  { 2,  3,   0}, // #8583
  { 3,  3,   0}, // #8584
  { 4,  3,   0}, // #8585
  { 5,  3,   0}, // #8586
  {14,  1,   0}, // #8587
  {15,  1,   0}, // #8588
  { 1,  1,   0}, // #8589
  { 2,  1,   0}, // #8590
  { 3,  2,   0}, // #8591
  { 4,  2,   0}, // #8592
  { 5,  2,   0}, // #8593
  { 6,  1,   0}, // #8594
  { 7,  1,   0}, // #8595
  { 8,  1,   0}, // #8596
  {10,  1,   0}, // #8597
  {11,  1,   0}, // #8598
  {14,  2,   0}, // #8599
  {15,  2,   0}, // #8600
  { 1,  1,   0}, // #8601
  { 2,  1,   0}, // #8602
  { 3,  3,   0}, // #8603
  { 4,  3,   0}, // #8604
  { 5,  3,   0}, // #8605
  { 6,  1,   0}, // #8606
  { 7,  1,   0}, // #8607
  { 8,  1,   0}, // #8608
  {10,  2,   0}, // #8609
  {11,  2,   0}, // #8610
  {14,  4,   0}, // #8611
  {15,  4,   0}, // #8612
  { 1,  1,   0}, // #8613
  { 2,  1,   0}, // #8614
  { 3,  3,   0}, // #8615
  { 4,  3,   0}, // #8616
  { 5,  3,   0}, // #8617
  { 6,  1,   0}, // #8618
  { 7,  1,   0}, // #8619
  { 8,  1,   0}, // #8620
  {10,  2,   0}, // #8621
  {11,  2,   0}, // #8622
  {14,  8,   0}, // #8623
  {15,  8,   0}, // #8624
  { 1,  1,   0}, // #8625
  { 2,  1,   0}, // #8626
  { 3,  3,   0}, // #8627
  { 4,  3,   0}, // #8628
  { 5,  3,   0}, // #8629
  { 6,  3,   0}, // #8630
  { 7,  3,   0}, // #8631
  { 8,  1,   0}, // #8632
  {10,  2,   0}, // #8633
  {11,  2,   0}, // #8634
  {14, 16,   0}, // #8635
  {15, 16,   0}, // #8636
  {19,  2,   0}, // #8637
  { 1,  7,   0}, // #8638
  { 2,  7,   0}, // #8639
  { 3, 22,   0}, // #8640
  { 4, 22,   0}, // #8641
  { 5, 22,   0}, // #8642
  { 6, 22,   0}, // #8643
  { 7, 22,   0}, // #8644
  { 8,  7,   0}, // #8645
  {10,  9,   0}, // #8646
  {11,  9,   0}, // #8647
  {19,  9,   0}, // #8648
  { 2,  7,   0}, // #8649
  { 3, 21,   0}, // #8650
  { 4, 22,   0}, // #8651
  { 5, 22,   0}, // #8652
  { 6,  9,   0}, // #8653
  { 7, 10,   0}, // #8654
  { 8,  1,   0}, // #8655
  {10,  9,   0}, // #8656
  {11,  9,   0}, // #8657
  {14,  1,   0}, // #8658
  {15,  1,   0}, // #8659
  {19,  9,   0}, // #8660
  { 1,  7,   0}, // #8661
  { 2,  7,   0}, // #8662
  { 3, 21,   0}, // #8663
  { 4, 21,   0}, // #8664
  { 5, 21,   0}, // #8665
  { 6, 21,   0}, // #8666
  { 7, 21,   0}, // #8667
  { 8,  7,   0}, // #8668
  {10,  9,   0}, // #8669
  {11,  9,   0}, // #8670
  {14,  1,   0}, // #8671
  {15,  1,   0}, // #8672
  {19,  9,   0}, // #8673
  { 1, 11,   0}, // #8674
  { 2, 11,   0}, // #8675
  { 3, 36,   0}, // #8676
  { 4, 36,   0}, // #8677
  { 5, 36,   0}, // #8678
  { 6, 36,   0}, // #8679
  { 7, 36,   0}, // #8680
  { 8, 11,   0}, // #8681
  {10, 17,   0}, // #8682
  {11, 17,   0}, // #8683
  {14,  1,   0}, // #8684
  {15,  1,   0}, // #8685
  {19, 17,   0}, // #8686
  { 2,  1,   0}, // #8687
  { 3,  1,   0}, // #8688
  { 4,  3,   0}, // #8689
  { 5,  8,   0}, // #8690
  { 7,  2,   0}, // #8691
  { 8,  2,   0}, // #8692
  { 9,  1,   0}, // #8693
  {10,  1,   0}, // #8694
  {11,  1,   0}, // #8695
  {14,  1,   0}, // #8696
  {15,  1,   0}, // #8697
  { 2,  1,   0}, // #8698
  { 3,  1,   0}, // #8699
  { 4,  3,   0}, // #8700
  { 5,  7,   0}, // #8701
  { 7,  2,   0}, // #8702
  { 8,  2,   0}, // #8703
  { 9,  1,   0}, // #8704
  {10,  1,   0}, // #8705
  {11,  1,   0}, // #8706
  {14,  2,   0}, // #8707
  {15,  1,   0}, // #8708
  {18,  1,   0}, // #8709
  {22,  1,   0}, // #8710
  { 4,  1,   0}, // #8711
  { 5,  2,   0}, // #8712
  { 7,  1,   0}, // #8713
  { 8,  1,   0}, // #8714
  {14,  1,   0}, // #8715
  {18,  1,   0}, // #8716
  {22,  1,   0}, // #8717
  { 2,  1,   0}, // #8718
  { 3,  4,   0}, // #8719
  { 4, 10,   0}, // #8720
  { 5, 10,   0}, // #8721
  { 6,  3,   0}, // #8722
  { 7,  9,   0}, // #8723
  { 8,  6,   0}, // #8724
  { 9,  1,   0}, // #8725
  {10,  4,   0}, // #8726
  {11,  4,   0}, // #8727
  {19,  3,   0}, // #8728
  { 1,  7,   0}, // #8729
  { 2, 26,   0}, // #8730
  { 3, 47,   0}, // #8731
  { 4, 73,   0}, // #8732
  { 5, 80,   0}, // #8733
  { 6, 28,   0}, // #8734
  { 7, 54,   0}, // #8735
  { 8, 33,   0}, // #8736
  { 9, 19,   0}, // #8737
  {10, 40,   0}, // #8738
  {11, 42,   0}, // #8739
  {14,  7,   0}, // #8740
  {15,  7,   0}, // #8741
  {19, 21,   0}, // #8742
  { 1,  7,   0}, // #8743
  { 2, 27,   0}, // #8744
  { 3, 47,   0}, // #8745
  { 4, 73,   0}, // #8746
  { 5, 80,   0}, // #8747
  { 6, 27,   0}, // #8748
  { 7, 53,   0}, // #8749
  { 8, 33,   0}, // #8750
  { 9, 19,   0}, // #8751
  {10, 39,   0}, // #8752
  {11, 42,   0}, // #8753
  {14,  7,   0}, // #8754
  {15,  7,   0}, // #8755
  {19, 20,   0}, // #8756
  { 1,  7,   0}, // #8757
  { 2, 28,   0}, // #8758
  { 3, 48,   0}, // #8759
  { 4, 76,   0}, // #8760
  { 5, 84,   0}, // #8761
  { 6, 27,   0}, // #8762
  { 7, 55,   0}, // #8763
  { 8, 35,   0}, // #8764
  { 9, 21,   0}, // #8765
  {10, 41,   0}, // #8766
  {11, 43,   0}, // #8767
  {14, 10,   0}, // #8768
  {15, 10,   0}, // #8769
  {19, 20,   0}, // #8770
  { 1,  7,   0}, // #8771
  { 2, 28,   0}, // #8772
  { 3, 49,   0}, // #8773
  { 4, 77,   0}, // #8774
  { 5, 88,   0}, // #8775
  { 6, 28,   0}, // #8776
  { 7, 56,   0}, // #8777
  { 8, 35,   0}, // #8778
  { 9, 21,   0}, // #8779
  {10, 42,   0}, // #8780
  {11, 44,   0}, // #8781
  {14, 11,   0}, // #8782
  {15, 11,   0}, // #8783
  {19, 21,   0}, // #8784
  { 1,  7,   0}, // #8785
  { 2, 24,   0}, // #8786
  { 3, 43,   0}, // #8787
  { 4, 67,   0}, // #8788
  { 5, 73,   0}, // #8789
  { 6, 26,   0}, // #8790
  { 7, 50,   0}, // #8791
  { 8, 31,   0}, // #8792
  { 9, 17,   0}, // #8793
  {10, 36,   0}, // #8794
  {11, 36,   0}, // #8795
  {14,  9,   0}, // #8796
  {15,  8,   0}, // #8797
  {18,  1,   0}, // #8798
  {19, 19,   0}, // #8799
  {22,  1,   0}, // #8800
  { 1,  7,   0}, // #8801
  { 2, 24,   0}, // #8802
  { 3, 46,   0}, // #8803
  { 4, 74,   0}, // #8804
  { 5, 79,   0}, // #8805
  { 6, 28,   0}, // #8806
  { 7, 56,   0}, // #8807
  { 8, 34,   0}, // #8808
  { 9, 17,   0}, // #8809
  {10, 38,   0}, // #8810
  {11, 38,   0}, // #8811
  {14, 12,   0}, // #8812
  {15, 11,   0}, // #8813
  {18,  1,   0}, // #8814
  {19, 21,   0}, // #8815
  {22,  1,   0}, // #8816
  { 1,  5,   0}, // #8817
  { 2, 11,   0}, // #8818
  { 3, 18,   0}, // #8819
  { 4, 26,   0}, // #8820
  { 5, 32,   0}, // #8821
  { 6, 12,   0}, // #8822
  { 7, 20,   0}, // #8823
  { 8, 13,   0}, // #8824
  { 9,  6,   0}, // #8825
  {10, 13,   0}, // #8826
  {11, 15,   0}, // #8827
  {14,  5,   0}, // #8828
  {18,  5,   0}, // #8829
  {19,  7,   0}, // #8830
  {22,  5,   0}, // #8831
  { 4,  1,   0}, // #8832
  { 5,  1,   0}, // #8833
  { 7,  1,   0}, // #8834
  { 8,  1,   0}, // #8835
  {20,  1,   0}, // #8836
  { 1,  8,   0}, // #8837
  { 2, 22,   0}, // #8838
  { 3, 23,   0}, // #8839
  { 4, 25,   0}, // #8840
  { 5, 25,   0}, // #8841
  { 6,  9,   0}, // #8842
  { 7, 11,   0}, // #8843
  { 8, 10,   0}, // #8844
  { 9, 14,   0}, // #8845
  {10, 15,   0}, // #8846
  {11, 15,   0}, // #8847
  {14,  3,   0}, // #8848
  {15,  3,   0}, // #8849
  {19,  1,   0}, // #8850
  { 1,  1,   0}, // #8851
  { 2,  6,   0}, // #8852
  { 3,  9,   0}, // #8853
  { 4, 18,   0}, // #8854
  { 5, 20,   0}, // #8855
  { 6,  4,   0}, // #8856
  { 7, 13,   0}, // #8857
  { 8, 10,   0}, // #8858
  { 9,  5,   0}, // #8859
  {10,  6,   0}, // #8860
  {11,  6,   0}, // #8861
  {14,  3,   0}, // #8862
  {15,  3,   0}, // #8863
  {19,  1,   0}, // #8864
  { 1,  1,   0}, // #8865
  { 2,  4,   0}, // #8866
  { 3,  4,   0}, // #8867
  { 4,  8,   0}, // #8868
  { 5, 10,   0}, // #8869
  { 6,  1,   0}, // #8870
  { 7,  5,   0}, // #8871
  { 8,  5,   0}, // #8872
  { 9,  3,   0}, // #8873
  {10,  3,   0}, // #8874
  {11,  3,   0}, // #8875
  {14,  3,   0}, // #8876
  {15,  2,   0}, // #8877
  {18,  1,   0}, // #8878
  {22,  1,   0}, // #8879
  { 2,  3,   0}, // #8880
  { 3,  4,   0}, // #8881
  { 4,  9,   0}, // #8882
  { 5, 10,   0}, // #8883
  { 6,  1,   0}, // #8884
  { 7,  6,   0}, // #8885
  { 8,  5,   0}, // #8886
  { 9,  3,   0}, // #8887
  {10,  3,   0}, // #8888
  {11,  3,   0}, // #8889
  {14,  3,   0}, // #8890
  {15,  2,   0}, // #8891
  {18,  1,   0}, // #8892
  {22,  1,   0}, // #8893
  { 2,  3,   0}, // #8894
  { 3,  3,   0}, // #8895
  { 4,  8,   0}, // #8896
  { 5,  8,   0}, // #8897
  { 7,  5,   0}, // #8898
  { 8,  5,   0}, // #8899
  { 9,  3,   0}, // #8900
  {10,  3,   0}, // #8901
  {11,  3,   0}, // #8902
  {14,  3,   0}, // #8903
  {15,  2,   0}, // #8904
  {18,  1,   0}, // #8905
  {22,  1,   0}, // #8906
  { 2,  3,   0}, // #8907
  { 3,  3,   0}, // #8908
  { 4,  7,   0}, // #8909
  { 5,  8,   0}, // #8910
  { 7,  4,   0}, // #8911
  { 8,  4,   0}, // #8912
  { 9,  3,   0}, // #8913
  {10,  3,   0}, // #8914
  {11,  3,   0}, // #8915
  {14,  2,   0}, // #8916
  {15,  1,   0}, // #8917
  {18,  1,   0}, // #8918
  {22,  1,   0}, // #8919
  { 1,  1,   0}, // #8920
  { 2,  4,   0}, // #8921
  { 3, 12,   0}, // #8922
  { 4, 20,   0}, // #8923
  { 5, 22,   0}, // #8924
  { 6,  8,   0}, // #8925
  { 7, 16,   0}, // #8926
  { 8,  9,   0}, // #8927
  { 9,  3,   0}, // #8928
  {10, 10,   0}, // #8929
  {11, 10,   0}, // #8930
  {14,  3,   0}, // #8931
  {15,  1,   0}, // #8932
  {18,  2,   0}, // #8933
  {19,  7,   0}, // #8934
  {22,  2,   0}, // #8935
  { 2,  1,   0}, // #8936
  { 3,  6,   0}, // #8937
  { 4, 13,   0}, // #8938
  { 5, 18,   0}, // #8939
  { 6,  5,   0}, // #8940
  { 7, 12,   0}, // #8941
  { 8,  7,   0}, // #8942
  { 9,  1,   0}, // #8943
  {10,  6,   0}, // #8944
  {11,  6,   0}, // #8945
  {14,  2,   0}, // #8946
  {18,  2,   0}, // #8947
  {19,  5,   0}, // #8948
  {22,  2,   0}, // #8949
  { 2,  8,   0}, // #8950
  { 3, 22,   0}, // #8951
  { 4, 38,   0}, // #8952
  { 5, 44,   0}, // #8953
  { 6, 12,   0}, // #8954
  { 7, 28,   0}, // #8955
  { 8, 16,   0}, // #8956
  { 9,  7,   0}, // #8957
  {10, 19,   0}, // #8958
  {11, 21,   0}, // #8959
  {14,  2,   0}, // #8960
  {18,  2,   0}, // #8961
  {19, 12,   0}, // #8962
  {22,  2,   0}, // #8963
  { 3,  1,   0}, // #8964
  { 4,  2,   0}, // #8965
  { 5,  3,   0}, // #8966
  { 6,  1,   0}, // #8967
  { 7,  2,   0}, // #8968
  { 8,  1,   0}, // #8969
  {10,  1,   0}, // #8970
  {11,  1,   0}, // #8971
  {19,  1,   0}, // #8972
  { 2,  4,   0}, // #8973
  { 3, 10,   0}, // #8974
  { 4, 18,   0}, // #8975
  { 5, 24,   0}, // #8976
  { 6,  3,   0}, // #8977
  { 7, 11,   0}, // #8978
  { 8,  8,   0}, // #8979
  { 9,  4,   0}, // #8980
  {10,  7,   0}, // #8981
  {11,  9,   0}, // #8982
  {19,  3,   0}, // #8983
  { 1,  6,   0}, // #8984
  { 2, 21,   0}, // #8985
  { 3, 38,   0}, // #8986
  { 4, 66,   0}, // #8987
  { 5, 70,   0}, // #8988
  { 6, 23,   0}, // #8989
  { 7, 51,   0}, // #8990
  { 8, 34,   0}, // #8991
  { 9, 15,   0}, // #8992
  {10, 31,   0}, // #8993
  {11, 31,   0}, // #8994
  {14,  8,   0}, // #8995
  {15,  7,   0}, // #8996
  {18,  1,   0}, // #8997
  {19, 16,   0}, // #8998
  {22,  1,   0}, // #8999
  { 1,  6,   0}, // #9000
  { 2, 21,   0}, // #9001
  { 3, 37,   0}, // #9002
  { 4, 64,   0}, // #9003
  { 5, 70,   0}, // #9004
  { 6, 22,   0}, // #9005
  { 7, 49,   0}, // #9006
  { 8, 33,   0}, // #9007
  { 9, 15,   0}, // #9008
  {10, 31,   0}, // #9009
  {11, 31,   0}, // #9010
  {14,  8,   0}, // #9011
  {15,  7,   0}, // #9012
  {18,  1,   0}, // #9013
  {19, 16,   0}, // #9014
  {22,  1,   0}, // #9015
  { 1,  6,   0}, // #9016
  { 2, 21,   0}, // #9017
  { 3, 40,   0}, // #9018
  { 4, 70,   0}, // #9019
  { 5, 74,   0}, // #9020
  { 6, 25,   0}, // #9021
  { 7, 55,   0}, // #9022
  { 8, 36,   0}, // #9023
  { 9, 15,   0}, // #9024
  {10, 33,   0}, // #9025
  {11, 33,   0}, // #9026
  {14, 10,   0}, // #9027
  {15,  9,   0}, // #9028
  {18,  1,   0}, // #9029
  {19, 18,   0}, // #9030
  {22,  1,   0}, // #9031
  { 1,  6,   0}, // #9032
  { 2, 21,   0}, // #9033
  { 3, 39,   0}, // #9034
  { 4, 68,   0}, // #9035
  { 5, 74,   0}, // #9036
  { 6, 24,   0}, // #9037
  { 7, 53,   0}, // #9038
  { 8, 35,   0}, // #9039
  { 9, 15,   0}, // #9040
  {10, 33,   0}, // #9041
  {11, 33,   0}, // #9042
  {14, 10,   0}, // #9043
  {15,  9,   0}, // #9044
  {18,  1,   0}, // #9045
  {19, 18,   0}, // #9046
  {22,  1,   0}, // #9047
  { 1,  7,   0}, // #9048
  { 2, 23,   0}, // #9049
  { 3, 40,   0}, // #9050
  { 4, 65,   0}, // #9051
  { 5, 71,   0}, // #9052
  { 6, 24,   0}, // #9053
  { 7, 49,   0}, // #9054
  { 8, 32,   0}, // #9055
  { 9, 16,   0}, // #9056
  {10, 33,   0}, // #9057
  {11, 33,   0}, // #9058
  {14,  8,   0}, // #9059
  {15,  7,   0}, // #9060
  {18,  1,   0}, // #9061
  {19, 17,   0}, // #9062
  {22,  1,   0}, // #9063
  { 1,  7,   0}, // #9064
  { 2, 23,   0}, // #9065
  { 3, 43,   0}, // #9066
  { 4, 71,   0}, // #9067
  { 5, 77,   0}, // #9068
  { 6, 27,   0}, // #9069
  { 7, 55,   0}, // #9070
  { 8, 35,   0}, // #9071
  { 9, 16,   0}, // #9072
  {10, 36,   0}, // #9073
  {11, 36,   0}, // #9074
  {14, 11,   0}, // #9075
  {15, 10,   0}, // #9076
  {18,  1,   0}, // #9077
  {19, 20,   0}, // #9078
  {22,  1,   0}, // #9079
  { 4,  2,   0}, // #9080
  { 5,  3,   0}, // #9081
  { 7,  2,   0}, // #9082
  { 8,  2,   0}, // #9083
  {14,  1,   0}, // #9084
  {15,  1,   0}, // #9085
  {20,  2,   0}, // #9086
  { 4,  2,   0}, // #9087
  { 5,  3,   0}, // #9088
  { 7,  2,   0}, // #9089
  { 8,  2,   0}, // #9090
  {20,  2,   0}, // #9091
  { 4,  2,   0}, // #9092
  { 5,  4,   0}, // #9093
  { 7,  2,   0}, // #9094
  { 8,  2,   0}, // #9095
  {20,  2,   0}, // #9096
  { 2,  2,   0}, // #9097
  { 3,  2,   0}, // #9098
  { 4,  7,   0}, // #9099
  { 5,  8,   0}, // #9100
  { 7,  5,   0}, // #9101
  { 8,  5,   0}, // #9102
  { 9,  2,   0}, // #9103
  {10,  2,   0}, // #9104
  {11,  2,   0}, // #9105
  {14,  2,   0}, // #9106
  {15,  1,   0}, // #9107
  {18,  1,   0}, // #9108
  {22,  1,   0}, // #9109
  { 2,  3,   0}, // #9110
  { 3,  3,   0}, // #9111
  { 4,  7,   0}, // #9112
  { 5,  9,   0}, // #9113
  { 7,  4,   0}, // #9114
  { 8,  4,   0}, // #9115
  { 9,  3,   0}, // #9116
  {10,  3,   0}, // #9117
  {11,  3,   0}, // #9118
  {14,  2,   0}, // #9119
  {15,  1,   0}, // #9120
  {18,  1,   0}, // #9121
  {22,  1,   0}, // #9122
  { 1,  2,   0}, // #9123
  { 2,  9,   0}, // #9124
  { 3, 16,   0}, // #9125
  { 4, 24,   0}, // #9126
  { 5, 24,   0}, // #9127
  { 6,  6,   0}, // #9128
  { 7, 14,   0}, // #9129
  { 8,  7,   0}, // #9130
  { 9,  7,   0}, // #9131
  {10, 11,   0}, // #9132
  {11, 11,   0}, // #9133
  {14,  1,   0}, // #9134
  {15,  1,   0}, // #9135
  {19,  4,   0}, // #9136
  { 2,  1,   0}, // #9137
  { 3,  1,   0}, // #9138
  { 4,  3,   0}, // #9139
  { 5,  5,   0}, // #9140
  { 7,  2,   0}, // #9141
  { 8,  2,   0}, // #9142
  { 9,  1,   0}, // #9143
  {10,  1,   0}, // #9144
  {11,  1,   0}, // #9145
  {14,  1,   0}, // #9146
  {18,  1,   0}, // #9147
  {22,  1,   0}, // #9148
  { 3,  1,   0}, // #9149
  { 4,  1,   0}, // #9150
  { 5,  2,   0}, // #9151
  { 6,  1,   0}, // #9152
  { 7,  1,   0}, // #9153
  {10,  1,   0}, // #9154
  {11,  1,   0}, // #9155
  {19,  1,   0}, // #9156
  { 1,  6,   0}, // #9157
  { 2, 13,   0}, // #9158
  { 3, 13,   0}, // #9159
  { 4, 13,   0}, // #9160
  { 5, 13,   0}, // #9161
  { 6,  6,   0}, // #9162
  { 7,  6,   0}, // #9163
  { 8,  6,   0}, // #9164
  { 9,  7,   0}, // #9165
  {10,  7,   0}, // #9166
  {11,  7,   0}, // #9167
  {14, 18,   0}, // #9168
  {15, 18,   0}, // #9169
  { 1,  6,   0}, // #9170
  { 2, 13,   0}, // #9171
  { 3, 13,   0}, // #9172
  { 4, 13,   0}, // #9173
  { 5, 13,   0}, // #9174
  { 6,  6,   0}, // #9175
  { 7,  6,   0}, // #9176
  { 8,  6,   0}, // #9177
  { 9,  7,   0}, // #9178
  {10,  7,   0}, // #9179
  {11,  7,   0}, // #9180
  {14, 17,   0}, // #9181
  {15, 17,   0}, // #9182
  { 1,  5,   0}, // #9183
  { 2, 13,   0}, // #9184
  { 3, 13,   0}, // #9185
  { 4, 13,   0}, // #9186
  { 5, 13,   0}, // #9187
  { 6,  5,   0}, // #9188
  { 7,  5,   0}, // #9189
  { 8,  5,   0}, // #9190
  { 9,  8,   0}, // #9191
  {10,  8,   0}, // #9192
  {11,  8,   0}, // #9193
  {14, 20,   0}, // #9194
  {15, 20,   0}, // #9195
  { 1,  1,   0}, // #9196
  { 2,  1,   0}, // #9197
  { 3,  1,   0}, // #9198
  { 4,  2,   0}, // #9199
  { 5,  2,   0}, // #9200
  { 6,  1,   0}, // #9201
  { 7,  2,   0}, // #9202
  { 8,  2,   0}, // #9203
  {14,  1,   0}, // #9204
  {15,  1,   0}, // #9205
  { 2,  4,   0}, // #9206
  { 3,  5,   0}, // #9207
  { 4,  6,   0}, // #9208
  { 5,  8,   0}, // #9209
  { 6,  1,   0}, // #9210
  { 7,  2,   0}, // #9211
  { 8,  1,   0}, // #9212
  { 9,  4,   0}, // #9213
  {10,  5,   0}, // #9214
  {11,  5,   0}, // #9215
  {19,  1,   0}, // #9216
  { 1,  1,   0}, // #9217
  { 2, 43,   0}, // #9218
  { 3, 91,   0}, // #9219
  { 4, 143,   0}, // #9220
  { 5, 143,   0}, // #9221
  { 6, 49,   0}, // #9222
  { 7, 101,   0}, // #9223
  { 8, 53,   0}, // #9224
  { 9, 23,   0}, // #9225
  {10, 35,   0}, // #9226
  {11, 35,   0}, // #9227
  {14,  6,   0}, // #9228
  {15,  4,   0}, // #9229
  {18,  2,   0}, // #9230
  {19, 12,   0}, // #9231
  {22,  2,   0}, // #9232
  { 1,  1,   0}, // #9233
  { 2, 43,   0}, // #9234
  { 3, 91,   0}, // #9235
  { 4, 144,   0}, // #9236
  { 5, 144,   0}, // #9237
  { 6, 49,   0}, // #9238
  { 7, 102,   0}, // #9239
  { 8, 54,   0}, // #9240
  { 9, 23,   0}, // #9241
  {10, 35,   0}, // #9242
  {11, 35,   0}, // #9243
  {14,  6,   0}, // #9244
  {15,  4,   0}, // #9245
  {18,  2,   0}, // #9246
  {19, 12,   0}, // #9247
  {22,  2,   0}, // #9248
  { 2, 52,   0}, // #9249
  { 3, 97,   0}, // #9250
  { 4, 149,   0}, // #9251
  { 5, 149,   0}, // #9252
  { 6, 45,   0}, // #9253
  { 7, 97,   0}, // #9254
  { 8, 52,   0}, // #9255
  { 9, 27,   0}, // #9256
  {10, 37,   0}, // #9257
  {11, 37,   0}, // #9258
  {14,  5,   0}, // #9259
  {15,  4,   0}, // #9260
  {18,  1,   0}, // #9261
  {19, 10,   0}, // #9262
  {22,  1,   0}, // #9263
  { 2, 52,   0}, // #9264
  { 3, 123,   0}, // #9265
  { 4, 176,   0}, // #9266
  { 5, 176,   0}, // #9267
  { 6, 41,   0}, // #9268
  { 7, 94,   0}, // #9269
  { 8, 53,   0}, // #9270
  { 9, 29,   0}, // #9271
  {10, 68,   0}, // #9272
  {11, 68,   0}, // #9273
  {14,  6,   0}, // #9274
  {15,  4,   0}, // #9275
  {18,  2,   0}, // #9276
  {19,  9,   0}, // #9277
  {22,  2,   0}, // #9278
  { 2,  1,   0}, // #9279
  { 3,  3,   0}, // #9280
  { 4,  3,   0}, // #9281
  { 5,  3,   0}, // #9282
  { 6,  1,   0}, // #9283
  { 7,  1,   0}, // #9284
  {10,  2,   0}, // #9285
  {11,  2,   0}, // #9286
  {14,  1,   0}, // #9287
  {15,  1,   0}, // #9288
  {19,  1,   0}, // #9289
  { 2,  1,   0}, // #9290
  { 3,  3,   0}, // #9291
  { 4,  3,   0}, // #9292
  { 5,  3,   0}, // #9293
  { 6,  1,   0}, // #9294
  { 7,  1,   0}, // #9295
  {10,  2,   0}, // #9296
  {11,  2,   0}, // #9297
  {19,  1,   0}, // #9298
  { 2,  2,   0}, // #9299
  { 3,  4,   0}, // #9300
  { 4,  4,   0}, // #9301
  { 5,  4,   0}, // #9302
  { 6,  1,   0}, // #9303
  { 7,  1,   0}, // #9304
  {10,  2,   0}, // #9305
  {11,  2,   0}, // #9306
  {14,  1,   0}, // #9307
  {15,  1,   0}, // #9308
  {19,  1,   0}, // #9309
  { 2,  2,   0}, // #9310
  { 3,  4,   0}, // #9311
  { 4,  4,   0}, // #9312
  { 5,  4,   0}, // #9313
  { 6,  1,   0}, // #9314
  { 7,  1,   0}, // #9315
  {10,  2,   0}, // #9316
  {11,  2,   0}, // #9317
  {19,  1,   0}, // #9318
  { 1,  2,   0}, // #9319
  { 2,  2,   0}, // #9320
  { 3,  4,   0}, // #9321
  { 4,  4,   0}, // #9322
  { 5,  4,   0}, // #9323
  { 6,  4,   0}, // #9324
  { 7,  4,   0}, // #9325
  { 8,  2,   0}, // #9326
  {10,  2,   0}, // #9327
  {11,  2,   0}, // #9328
  {14,  1,   0}, // #9329
  {15,  1,   0}, // #9330
  {19,  2,   0}, // #9331
  { 2,  2,   0}, // #9332
  { 3,  5,   0}, // #9333
  { 4,  6,   0}, // #9334
  { 5,  6,   0}, // #9335
  { 6,  2,   0}, // #9336
  { 7,  3,   0}, // #9337
  { 8,  1,   0}, // #9338
  {10,  2,   0}, // #9339
  {11,  2,   0}, // #9340
  {14,  1,   0}, // #9341
  {15,  1,   0}, // #9342
  {19,  2,   0}, // #9343
  { 2,  2,   0}, // #9344
  { 3,  5,   0}, // #9345
  { 4,  5,   0}, // #9346
  { 5,  5,   0}, // #9347
  { 6,  2,   0}, // #9348
  { 7,  2,   0}, // #9349
  {10,  2,   0}, // #9350
  {11,  2,   0}, // #9351
  {19,  2,   0}, // #9352
  { 2,  2,   0}, // #9353
  { 3,  4,   0}, // #9354
  { 4,  5,   0}, // #9355
  { 5,  5,   0}, // #9356
  { 6,  2,   0}, // #9357
  { 7,  3,   0}, // #9358
  { 8,  1,   0}, // #9359
  {10,  2,   0}, // #9360
  {11,  2,   0}, // #9361
  {14,  1,   0}, // #9362
  {15,  1,   0}, // #9363
  {19,  2,   0}, // #9364
  { 1,  2,   0}, // #9365
  { 2,  2,   0}, // #9366
  { 3,  4,   0}, // #9367
  { 4,  5,   0}, // #9368
  { 5,  5,   0}, // #9369
  { 6,  4,   0}, // #9370
  { 7,  5,   0}, // #9371
  { 8,  3,   0}, // #9372
  {10,  2,   0}, // #9373
  {11,  2,   0}, // #9374
  {14,  1,   0}, // #9375
  {15,  1,   0}, // #9376
  {19,  2,   0}, // #9377
  { 2,  2,   0}, // #9378
  { 3,  5,   0}, // #9379
  { 4,  6,   0}, // #9380
  { 5,  6,   0}, // #9381
  { 6,  2,   0}, // #9382
  { 7,  3,   0}, // #9383
  { 8,  1,   0}, // #9384
  {10,  2,   0}, // #9385
  {11,  2,   0}, // #9386
  {19,  2,   0}, // #9387
  { 2,  2,   0}, // #9388
  { 3,  4,   0}, // #9389
  { 4,  4,   0}, // #9390
  { 5,  4,   0}, // #9391
  { 6,  2,   0}, // #9392
  { 7,  2,   0}, // #9393
  {10,  2,   0}, // #9394
  {11,  2,   0}, // #9395
  {14,  1,   0}, // #9396
  {15,  1,   0}, // #9397
  {19,  2,   0}, // #9398
  { 2,  1,   0}, // #9399
  { 3,  4,   0}, // #9400
  { 4,  5,   0}, // #9401
  { 5,  5,   0}, // #9402
  { 6,  1,   0}, // #9403
  { 7,  2,   0}, // #9404
  { 8,  1,   0}, // #9405
  {10,  1,   0}, // #9406
  {11,  1,   0}, // #9407
  {14,  1,   0}, // #9408
  {15,  1,   0}, // #9409
  {19,  1,   0}, // #9410
  { 2,  1,   0}, // #9411
  { 3,  4,   0}, // #9412
  { 4,  4,   0}, // #9413
  { 5,  4,   0}, // #9414
  { 6,  1,   0}, // #9415
  { 7,  1,   0}, // #9416
  {10,  1,   0}, // #9417
  {11,  1,   0}, // #9418
  {19,  1,   0}, // #9419
  { 2,  1,   0}, // #9420
  { 3,  4,   0}, // #9421
  { 4,  4,   0}, // #9422
  { 5,  4,   0}, // #9423
  { 6,  1,   0}, // #9424
  { 7,  1,   0}, // #9425
  {10,  2,   0}, // #9426
  {11,  2,   0}, // #9427
  {14,  1,   0}, // #9428
  {15,  1,   0}, // #9429
  {19,  1,   0}, // #9430
  { 2,  1,   0}, // #9431
  { 3,  4,   0}, // #9432
  { 4,  4,   0}, // #9433
  { 5,  4,   0}, // #9434
  { 6,  1,   0}, // #9435
  { 7,  1,   0}, // #9436
  {10,  2,   0}, // #9437
  {11,  2,   0}, // #9438
  {19,  1,   0}, // #9439
  { 1,  1,   0}, // #9440
  { 2,  1,   0}, // #9441
  { 3,  4,   0}, // #9442
  { 4,  4,   0}, // #9443
  { 5,  4,   0}, // #9444
  { 6,  4,   0}, // #9445
  { 7,  4,   0}, // #9446
  { 8,  1,   0}, // #9447
  {10,  2,   0}, // #9448
  {11,  2,   0}, // #9449
  {14,  1,   0}, // #9450
  {15,  1,   0}, // #9451
  {19,  2,   0}, // #9452
  { 1,  1,   0}, // #9453
  { 2,  1,   0}, // #9454
  { 3,  4,   0}, // #9455
  { 4,  4,   0}, // #9456
  { 5,  4,   0}, // #9457
  { 6,  4,   0}, // #9458
  { 7,  4,   0}, // #9459
  { 8,  1,   0}, // #9460
  {10,  2,   0}, // #9461
  {11,  2,   0}, // #9462
  {19,  2,   0}, // #9463
  { 2,  2,   0}, // #9464
  { 3,  5,   0}, // #9465
  { 4,  6,   0}, // #9466
  { 5,  6,   0}, // #9467
  { 6,  1,   0}, // #9468
  { 7,  2,   0}, // #9469
  { 8,  1,   0}, // #9470
  {10,  1,   0}, // #9471
  {11,  1,   0}, // #9472
  {14,  1,   0}, // #9473
  {15,  1,   0}, // #9474
  {19,  1,   0}, // #9475
  { 2,  2,   0}, // #9476
  { 3,  4,   0}, // #9477
  { 4,  4,   0}, // #9478
  { 5,  4,   0}, // #9479
  { 6,  1,   0}, // #9480
  { 7,  1,   0}, // #9481
  {10,  1,   0}, // #9482
  {11,  1,   0}, // #9483
  {19,  1,   0}, // #9484
  { 2,  2,   0}, // #9485
  { 3,  3,   0}, // #9486
  { 4,  3,   0}, // #9487
  { 5,  3,   0}, // #9488
  { 6,  1,   0}, // #9489
  { 7,  1,   0}, // #9490
  {10,  1,   0}, // #9491
  {11,  1,   0}, // #9492
  {14,  1,   0}, // #9493
  {15,  1,   0}, // #9494
  {19,  1,   0}, // #9495
  { 2,  2,   0}, // #9496
  { 3,  3,   0}, // #9497
  { 4,  3,   0}, // #9498
  { 5,  3,   0}, // #9499
  { 6,  1,   0}, // #9500
  { 7,  1,   0}, // #9501
  {10,  1,   0}, // #9502
  {11,  1,   0}, // #9503
  {19,  1,   0}, // #9504
  { 1,  1,   0}, // #9505
  { 2,  2,   0}, // #9506
  { 3,  3,   0}, // #9507
  { 4,  3,   0}, // #9508
  { 5,  3,   0}, // #9509
  { 6,  1,   0}, // #9510
  { 7,  1,   0}, // #9511
  { 8,  1,   0}, // #9512
  { 2,  1,   0}, // #9513
  { 3,  2,   0}, // #9514
  { 4,  2,   0}, // #9515
  { 5,  2,   0}, // #9516
  {14,  1,   0}, // #9517
  {15,  1,   0}, // #9518
  { 1,  2,   0}, // #9519
  { 2,  2,   0}, // #9520
  { 3,  3,   0}, // #9521
  { 4,  3,   0}, // #9522
  { 5,  3,   0}, // #9523
  { 6,  2,   0}, // #9524
  { 7,  2,   0}, // #9525
  { 8,  2,   0}, // #9526
  {14,  1,   0}, // #9527
  {15,  1,   0}, // #9528
  { 1,  4,   0}, // #9529
  { 2,  4,   0}, // #9530
  { 3,  7,   0}, // #9531
  { 4,  8,   0}, // #9532
  { 5,  8,   0}, // #9533
  { 6,  7,   0}, // #9534
  { 7,  8,   0}, // #9535
  { 8,  5,   0}, // #9536
  {10,  1,   0}, // #9537
  {11,  1,   0}, // #9538
  {14,  1,   0}, // #9539
  {15,  1,   0}, // #9540
  {19,  1,   0}, // #9541
  { 1,  4,   0}, // #9542
  { 2,  4,   0}, // #9543
  { 3,  5,   0}, // #9544
  { 4,  6,   0}, // #9545
  { 5,  6,   0}, // #9546
  { 6,  5,   0}, // #9547
  { 7,  6,   0}, // #9548
  { 8,  5,   0}, // #9549
  {10,  1,   0}, // #9550
  {11,  1,   0}, // #9551
  {19,  1,   0}, // #9552
  { 1,  1,   0}, // #9553
  { 2,  1,   0}, // #9554
  { 3,  3,   0}, // #9555
  { 4,  3,   0}, // #9556
  { 5,  3,   0}, // #9557
  { 6,  3,   0}, // #9558
  { 7,  3,   0}, // #9559
  { 8,  1,   0}, // #9560
  {10,  2,   0}, // #9561
  {11,  2,   0}, // #9562
  {14,  8,   0}, // #9563
  {15,  8,   0}, // #9564
  {19,  2,   0}, // #9565
  { 5,  1,   0}, // #9566
  {14,  2,   0}, // #9567
  {18,  2,   0}, // #9568
  {22,  2,   0}, // #9569
  { 3, 11,   0}, // #9570
  { 4, 11,   0}, // #9571
  { 5, 11,   0}, // #9572
  { 6,  8,   0}, // #9573
  { 7,  8,   0}, // #9574
  {10,  8,   0}, // #9575
  {11,  8,   0}, // #9576
  {14,  1,   0}, // #9577
  {15,  1,   0}, // #9578
  {19,  8,   0}, // #9579
  { 3, 12,   0}, // #9580
  { 4, 12,   0}, // #9581
  { 5, 12,   0}, // #9582
  { 6,  8,   0}, // #9583
  { 7,  8,   0}, // #9584
  {10,  8,   0}, // #9585
  {11,  8,   0}, // #9586
  {19,  8,   0}, // #9587
  { 1,  1,   0}, // #9588
  { 2,  9,   0}, // #9589
  { 3, 29,   0}, // #9590
  { 4, 29,   0}, // #9591
  { 5, 29,   0}, // #9592
  { 6, 12,   0}, // #9593
  { 7, 12,   0}, // #9594
  { 8,  1,   0}, // #9595
  {10, 13,   0}, // #9596
  {11, 13,   0}, // #9597
  {14,  1,   0}, // #9598
  {15,  1,   0}, // #9599
  {19, 11,   0}, // #9600
  { 1,  1,   0}, // #9601
  { 2,  9,   0}, // #9602
  { 3, 30,   0}, // #9603
  { 4, 30,   0}, // #9604
  { 5, 30,   0}, // #9605
  { 6, 12,   0}, // #9606
  { 7, 12,   0}, // #9607
  { 8,  1,   0}, // #9608
  {10, 13,   0}, // #9609
  {11, 13,   0}, // #9610
  {19, 11,   0}, // #9611
  { 1, 13,   0}, // #9612
  { 2, 13,   0}, // #9613
  { 3, 45,   0}, // #9614
  { 4, 45,   0}, // #9615
  { 5, 45,   0}, // #9616
  { 6, 45,   0}, // #9617
  { 7, 45,   0}, // #9618
  { 8, 13,   0}, // #9619
  {10, 23,   0}, // #9620
  {11, 23,   0}, // #9621
  {14,  1,   0}, // #9622
  {15,  1,   0}, // #9623
  {19, 23,   0}, // #9624
  { 1, 13,   0}, // #9625
  { 2, 13,   0}, // #9626
  { 3, 46,   0}, // #9627
  { 4, 46,   0}, // #9628
  { 5, 46,   0}, // #9629
  { 6, 46,   0}, // #9630
  { 7, 46,   0}, // #9631
  { 8, 13,   0}, // #9632
  {10, 23,   0}, // #9633
  {11, 23,   0}, // #9634
  {19, 23,   0}, // #9635
  { 3,  4,   0}, // #9636
  { 4,  4,   0}, // #9637
  { 5,  4,   0}, // #9638
  { 6,  4,   0}, // #9639
  { 7,  4,   0}, // #9640
  {10,  4,   0}, // #9641
  {11,  4,   0}, // #9642
  {14,  1,   0}, // #9643
  {15,  1,   0}, // #9644
  {19,  4,   0}, // #9645
  { 3,  4,   0}, // #9646
  { 4,  4,   0}, // #9647
  { 5,  4,   0}, // #9648
  { 6,  4,   0}, // #9649
  { 7,  4,   0}, // #9650
  {10,  4,   0}, // #9651
  {11,  4,   0}, // #9652
  {19,  4,   0}, // #9653
  { 1,  8,   0}, // #9654
  { 2,  8,   0}, // #9655
  { 3, 29,   0}, // #9656
  { 4, 29,   0}, // #9657
  { 5, 29,   0}, // #9658
  { 6, 29,   0}, // #9659
  { 7, 29,   0}, // #9660
  { 8,  8,   0}, // #9661
  {10, 14,   0}, // #9662
  {11, 14,   0}, // #9663
  {14,  1,   0}, // #9664
  {15,  1,   0}, // #9665
  {19, 14,   0}, // #9666
  { 1,  8,   0}, // #9667
  { 2,  8,   0}, // #9668
  { 3, 30,   0}, // #9669
  { 4, 30,   0}, // #9670
  { 5, 30,   0}, // #9671
  { 6, 30,   0}, // #9672
  { 7, 30,   0}, // #9673
  { 8,  8,   0}, // #9674
  {10, 14,   0}, // #9675
  {11, 14,   0}, // #9676
  {19, 14,   0}, // #9677
  { 1,  1,   0}, // #9678
  { 2,  1,   0}, // #9679
  { 3,  3,   0}, // #9680
  { 4,  4,   0}, // #9681
  { 5,  4,   0}, // #9682
  { 6,  3,   0}, // #9683
  { 7,  4,   0}, // #9684
  { 8,  2,   0}, // #9685
  {10,  2,   0}, // #9686
  {11,  2,   0}, // #9687
  {14,  1,   0}, // #9688
  {18,  1,   0}, // #9689
  {19,  2,   0}, // #9690
  {22,  1,   0}, // #9691
  { 1,  1,   0}, // #9692
  { 2,  1,   0}, // #9693
  { 3,  3,   0}, // #9694
  { 4,  3,   0}, // #9695
  { 5,  4,   0}, // #9696
  { 6,  3,   0}, // #9697
  { 7,  3,   0}, // #9698
  { 8,  1,   0}, // #9699
  {10,  2,   0}, // #9700
  {11,  2,   0}, // #9701
  {14,  2,   0}, // #9702
  {18,  2,   0}, // #9703
  {19,  2,   0}, // #9704
  {22,  2,   0}, // #9705
  {25,  1,   0}, // #9706
  {26,  1,   0}, // #9707
  {15,  1,   0}, // #9708
  {23,  1,   0}, // #9709
  {24,  1,   0}, // #9710
  {25,  1,   0}, // #9711
  {26,  1,   0}, // #9712
  {16,  1,   0}, // #9713
  {24,  1,   0}, // #9714
  {25,  1,   0}, // #9715
  {26,  1,   0}, // #9716
  {16,  2,   0}, // #9717
  {19,  1,   0}, // #9718
  {20,  1,   0}, // #9719
  {22,  1,   0}, // #9720
  {24,  2,   0}, // #9721
  {25,  3,   0}, // #9722
  {26,  6,   0}, // #9723
  {16,  1,   0}, // #9724
  {19,  1,   0}, // #9725
  {24,  1,   0}, // #9726
  {25,  1,   0}, // #9727
  {26,  2,   0}, // #9728
  {17,  1,   0}, // #9729
  {23,  1,   0}, // #9730
  {25,  1,   0}, // #9731
  {26,  1,   0}, // #9732
  {20,  1,   0}, // #9733
  {22,  1,   0}, // #9734
  {26,  2,   0}, // #9735
  { 4,  1,   0}, // #9736
  {13,  1,   0}, // #9737
  {17,  1,   0}, // #9738
  {18,  1,   0}, // #9739
  {23,  1,   0}, // #9740
  {25,  1,   0}, // #9741
  {26,  1,   0}, // #9742
  {19,  1,   0}, // #9743
  {26,  1,   0}, // #9744
  {19,  1,   0}, // #9745
  {20,  1,   0}, // #9746
  {22,  1,   0}, // #9747
  {25,  1,   0}, // #9748
  {26,  4,   0}, // #9749
  { 3,  1,   0}, // #9750
  {13,  1,   0}, // #9751
  {14,  1,   0}, // #9752
  {15,  1,   0}, // #9753
  {16,  1,   0}, // #9754
  {23,  1,   0}, // #9755
  {24,  1,   0}, // #9756
  {25,  1,   0}, // #9757
  {26,  1,   0}, // #9758
  {19,  1,   0}, // #9759
  {25,  1,   0}, // #9760
  {26,  2,   0}, // #9761
  {13,  1,   0}, // #9762
  {19,  1,   0}, // #9763
  {23,  1,   0}, // #9764
  {25,  1,   0}, // #9765
  {26,  2,   0}, // #9766
  {13,  1,   0}, // #9767
  {23,  1,   0}, // #9768
  {25,  1,   0}, // #9769
  {26,  1,   0}, // #9770
  { 3,  1,   0}, // #9771
  {13,  1,   0}, // #9772
  {14,  1,   0}, // #9773
  {15,  1,   0}, // #9774
  {16,  1,   0}, // #9775
  {19,  1,   0}, // #9776
  {23,  1,   0}, // #9777
  {24,  1,   0}, // #9778
  {25,  1,   0}, // #9779
  {26,  2,   0}, // #9780
  { 3,  2,   0}, // #9781
  {13,  2,   0}, // #9782
  {14,  2,   0}, // #9783
  {15,  2,   0}, // #9784
  {16,  2,   0}, // #9785
  {19,  1,   0}, // #9786
  {23,  2,   0}, // #9787
  {24,  2,   0}, // #9788
  {25,  2,   0}, // #9789
  {26,  3,   0}, // #9790
  { 3,  2,   0}, // #9791
  {13,  2,   0}, // #9792
  {14,  2,   0}, // #9793
  {15,  2,   0}, // #9794
  {16,  2,   0}, // #9795
  {23,  2,   0}, // #9796
  {24,  2,   0}, // #9797
  {25,  2,   0}, // #9798
  {26,  2,   0}, // #9799
  { 3,  3,   0}, // #9800
  { 8,  6,   0}, // #9801
  {13,  3,   0}, // #9802
  {14,  3,   0}, // #9803
  {15,  9,   0}, // #9804
  {16,  3,   0}, // #9805
  {17,  6,   0}, // #9806
  {19,  1,   0}, // #9807
  {21,  6,   0}, // #9808
  {23, 10,   0}, // #9809
  {24,  9,   0}, // #9810
  {25, 10,   0}, // #9811
  {26, 11,   0}, // #9812
  { 3,  3,   0}, // #9813
  { 8,  6,   0}, // #9814
  {13,  3,   0}, // #9815
  {14,  3,   0}, // #9816
  {15,  9,   0}, // #9817
  {16,  3,   0}, // #9818
  {17,  6,   0}, // #9819
  {21,  6,   0}, // #9820
  {23, 11,   0}, // #9821
  {24,  9,   0}, // #9822
  {25, 11,   0}, // #9823
  {26, 11,   0}, // #9824
  {16,  1,   0}, // #9825
  {17,  1,   0}, // #9826
  {19,  1,   0}, // #9827
  {23,  1,   0}, // #9828
  {24,  1,   0}, // #9829
  {25,  2,   0}, // #9830
  {26,  3,   0}, // #9831
  {16,  1,   0}, // #9832
  {17,  1,   0}, // #9833
  {23,  1,   0}, // #9834
  {24,  1,   0}, // #9835
  {25,  2,   0}, // #9836
  {26,  2,   0}, // #9837
  {19,  1,   0}, // #9838
  {23,  2,   0}, // #9839
  {25,  2,   0}, // #9840
  {26,  3,   0}, // #9841
  {23,  2,   0}, // #9842
  {25,  2,   0}, // #9843
  {26,  2,   0}, // #9844
  {17,  1,   0}, // #9845
  {19,  1,   0}, // #9846
  {23,  1,   0}, // #9847
  {25,  1,   0}, // #9848
  {26,  2,   0}, // #9849
  { 4,  1,   0}, // #9850
  {13,  1,   0}, // #9851
  {17,  1,   0}, // #9852
  {18,  1,   0}, // #9853
  {19,  1,   0}, // #9854
  {23,  1,   0}, // #9855
  {25,  1,   0}, // #9856
  {26,  2,   0}, // #9857
  {16,  1,   0}, // #9858
  {19,  1,   0}, // #9859
  {20,  1,   0}, // #9860
  {22,  1,   0}, // #9861
  {24,  1,   0}, // #9862
  {25,  1,   0}, // #9863
  {26,  4,   0}, // #9864
  {25,  3,   0}, // #9865
  {26,  3,   0}, // #9866
  {16,  2,   0}, // #9867
  {24,  2,   0}, // #9868
  {25,  5,   0}, // #9869
  {26,  5,   0}, // #9870
  { 8,  1,   0}, // #9871
  {13,  1,   0}, // #9872
  {15,  1,   0}, // #9873
  {17,  1,   0}, // #9874
  {19,  1,   0}, // #9875
  {21,  1,   0}, // #9876
  {23,  2,   0}, // #9877
  {24,  1,   0}, // #9878
  {25,  2,   0}, // #9879
  {26,  3,   0}, // #9880
  { 8,  1,   0}, // #9881
  {13,  1,   0}, // #9882
  {15,  1,   0}, // #9883
  {17,  1,   0}, // #9884
  {21,  1,   0}, // #9885
  {23,  2,   0}, // #9886
  {24,  1,   0}, // #9887
  {25,  2,   0}, // #9888
  {26,  2,   0}, // #9889
  {13,  2,   0}, // #9890
  {19,  1,   0}, // #9891
  {23,  2,   0}, // #9892
  {25,  2,   0}, // #9893
  {26,  3,   0}, // #9894
  {13,  2,   0}, // #9895
  {23,  2,   0}, // #9896
  {25,  2,   0}, // #9897
  {26,  2,   0}, // #9898
  { 1, 10,   0}, // #9899
  { 3,  1,   0}, // #9900
  {13,  1,   0}, // #9901
  {14,  1,   0}, // #9902
  {15,  1,   0}, // #9903
  {16,  1,   0}, // #9904
  {19,  1,   0}, // #9905
  {23,  1,   0}, // #9906
  {24,  1,   0}, // #9907
  {25,  1,   0}, // #9908
  {26,  2,   0}, // #9909
  { 3,  7,   0}, // #9910
  { 4,  2,   0}, // #9911
  { 8,  8,   0}, // #9912
  { 9,  3,   0}, // #9913
  {13,  9,   0}, // #9914
  {14,  7,   0}, // #9915
  {15, 16,   0}, // #9916
  {16, 10,   0}, // #9917
  {17, 10,   0}, // #9918
  {18,  5,   0}, // #9919
  {21, 11,   0}, // #9920
  {23, 18,   0}, // #9921
  {24, 19,   0}, // #9922
  {25, 32,   0}, // #9923
  {26, 32,   0}, // #9924
  { 1, 10,   0}, // #9925
  { 3,  1,   0}, // #9926
  {13,  1,   0}, // #9927
  {14,  1,   0}, // #9928
  {15,  1,   0}, // #9929
  {16,  1,   0}, // #9930
  {23,  1,   0}, // #9931
  {24,  1,   0}, // #9932
  {25,  1,   0}, // #9933
  {26,  1,   0}, // #9934
  { 2,  4,   0}, // #9935
  { 3,  1,   0}, // #9936
  {13,  1,   0}, // #9937
  {14,  1,   0}, // #9938
  {15,  1,   0}, // #9939
  {16,  1,   0}, // #9940
  {19,  1,   0}, // #9941
  {23,  1,   0}, // #9942
  {24,  1,   0}, // #9943
  {25,  1,   0}, // #9944
  {26,  2,   0}, // #9945
  { 2,  4,   0}, // #9946
  { 3,  1,   0}, // #9947
  {13,  1,   0}, // #9948
  {14,  1,   0}, // #9949
  {15,  1,   0}, // #9950
  {16,  1,   0}, // #9951
  {23,  1,   0}, // #9952
  {24,  1,   0}, // #9953
  {25,  1,   0}, // #9954
  {26,  1,   0}, // #9955
  { 2,  3,   0}, // #9956
  { 3,  1,   0}, // #9957
  {13,  1,   0}, // #9958
  {14,  1,   0}, // #9959
  {15,  1,   0}, // #9960
  {16,  1,   0}, // #9961
  {19,  1,   0}, // #9962
  {23,  1,   0}, // #9963
  {24,  1,   0}, // #9964
  {25,  1,   0}, // #9965
  {26,  2,   0}, // #9966
  { 2,  3,   0}, // #9967
  { 3,  1,   0}, // #9968
  {13,  1,   0}, // #9969
  {14,  1,   0}, // #9970
  {15,  1,   0}, // #9971
  {16,  1,   0}, // #9972
  {23,  1,   0}, // #9973
  {24,  1,   0}, // #9974
  {25,  1,   0}, // #9975
  {26,  1,   0}, // #9976
  { 8,  1,   0}, // #9977
  {15,  1,   0}, // #9978
  {17,  1,   0}, // #9979
  {19,  1,   0}, // #9980
  {21,  1,   0}, // #9981
  {23,  3,   0}, // #9982
  {24,  1,   0}, // #9983
  {25,  3,   0}, // #9984
  {26,  4,   0}, // #9985
  { 8,  1,   0}, // #9986
  {15,  1,   0}, // #9987
  {17,  1,   0}, // #9988
  {21,  1,   0}, // #9989
  {23,  3,   0}, // #9990
  {24,  1,   0}, // #9991
  {25,  3,   0}, // #9992
  {26,  3,   0}, // #9993
  { 8,  1,   0}, // #9994
  {15,  1,   0}, // #9995
  {17,  1,   0}, // #9996
  {19,  1,   0}, // #9997
  {21,  1,   0}, // #9998
  {23,  4,   0}, // #9999
  {24,  1,   0}, // #10000
  {25,  4,   0}, // #10001
  {26,  5,   0}, // #10002
  { 8,  1,   0}, // #10003
  {15,  1,   0}, // #10004
  {17,  1,   0}, // #10005
  {21,  1,   0}, // #10006
  {23,  4,   0}, // #10007
  {24,  1,   0}, // #10008
  {25,  4,   0}, // #10009
  {26,  4,   0}, // #10010
  { 8,  1,   0}, // #10011
  {15,  1,   0}, // #10012
  {17,  1,   0}, // #10013
  {20,  1,   0}, // #10014
  {21,  1,   0}, // #10015
  {22,  1,   0}, // #10016
  {23,  1,   0}, // #10017
  {24,  1,   0}, // #10018
  {25,  1,   0}, // #10019
  {26,  3,   0}, // #10020
  { 3,  1,   0}, // #10021
  { 8,  1,   0}, // #10022
  {13,  1,   0}, // #10023
  {14,  1,   0}, // #10024
  {15,  2,   0}, // #10025
  {16,  1,   0}, // #10026
  {17,  1,   0}, // #10027
  {21,  1,   0}, // #10028
  {23,  2,   0}, // #10029
  {24,  2,   0}, // #10030
  {25,  2,   0}, // #10031
  {26,  2,   0}, // #10032
  {15,  9,   0}, // #10033
  {23,  9,   0}, // #10034
  {24,  9,   0}, // #10035
  {25, 10,   0}, // #10036
  {26, 10,   0}, // #10037
  {15,  2,   0}, // #10038
  {23,  2,   0}, // #10039
  {24,  2,   0}, // #10040
  {25,  2,   0}, // #10041
  {26,  2,   0}, // #10042
  { 8,  2,   0}, // #10043
  {15,  2,   0}, // #10044
  {17,  2,   0}, // #10045
  {19,  1,   0}, // #10046
  {21,  2,   0}, // #10047
  {23,  3,   0}, // #10048
  {24,  2,   0}, // #10049
  {25,  3,   0}, // #10050
  {26,  4,   0}, // #10051
  { 8,  2,   0}, // #10052
  {15,  2,   0}, // #10053
  {17,  2,   0}, // #10054
  {21,  2,   0}, // #10055
  {23,  3,   0}, // #10056
  {24,  2,   0}, // #10057
  {25,  3,   0}, // #10058
  {26,  3,   0}, // #10059
  { 3,  2,   0}, // #10060
  { 8,  4,   0}, // #10061
  {13,  2,   0}, // #10062
  {14,  2,   0}, // #10063
  {15,  6,   0}, // #10064
  {16,  2,   0}, // #10065
  {17,  4,   0}, // #10066
  {19,  1,   0}, // #10067
  {21,  4,   0}, // #10068
  {23,  6,   0}, // #10069
  {24,  6,   0}, // #10070
  {25,  7,   0}, // #10071
  {26,  8,   0}, // #10072
  { 3,  4,   0}, // #10073
  { 4,  2,   0}, // #10074
  { 8,  4,   0}, // #10075
  { 9,  8,   0}, // #10076
  {13,  6,   0}, // #10077
  {14,  4,   0}, // #10078
  {15,  8,   0}, // #10079
  {16, 26,   0}, // #10080
  {17,  6,   0}, // #10081
  {18, 10,   0}, // #10082
  {21, 12,   0}, // #10083
  {23, 10,   0}, // #10084
  {24, 30,   0}, // #10085
  {25, 66,   0}, // #10086
  {26, 66,   0}, // #10087
  { 4,  1,   0}, // #10088
  {13,  1,   0}, // #10089
  {16,  1,   0}, // #10090
  {17,  1,   0}, // #10091
  {18,  1,   0}, // #10092
  {19,  1,   0}, // #10093
  {23,  1,   0}, // #10094
  {24,  1,   0}, // #10095
  {25,  4,   0}, // #10096
  {26,  5,   0}, // #10097
  { 4,  1,   0}, // #10098
  {13,  1,   0}, // #10099
  {16,  1,   0}, // #10100
  {17,  1,   0}, // #10101
  {18,  1,   0}, // #10102
  {23,  1,   0}, // #10103
  {24,  1,   0}, // #10104
  {25,  4,   0}, // #10105
  {26,  4,   0}, // #10106
  { 4,  1,   0}, // #10107
  {13,  1,   0}, // #10108
  {17,  1,   0}, // #10109
  {18,  1,   0}, // #10110
  {19,  1,   0}, // #10111
  {23,  1,   0}, // #10112
  {25,  2,   0}, // #10113
  {26,  3,   0}, // #10114
  { 4,  1,   0}, // #10115
  {13,  1,   0}, // #10116
  {17,  1,   0}, // #10117
  {18,  1,   0}, // #10118
  {23,  1,   0}, // #10119
  {25,  2,   0}, // #10120
  {26,  2,   0}, // #10121
  { 4,  1,   0}, // #10122
  {13,  1,   0}, // #10123
  {16,  1,   0}, // #10124
  {17,  1,   0}, // #10125
  {18,  1,   0}, // #10126
  {19,  1,   0}, // #10127
  {23,  1,   0}, // #10128
  {24,  1,   0}, // #10129
  {25,  3,   0}, // #10130
  {26,  4,   0}, // #10131
  { 4,  1,   0}, // #10132
  {13,  1,   0}, // #10133
  {16,  1,   0}, // #10134
  {17,  1,   0}, // #10135
  {18,  1,   0}, // #10136
  {23,  1,   0}, // #10137
  {24,  1,   0}, // #10138
  {25,  3,   0}, // #10139
  {26,  3,   0}, // #10140
  { 4,  1,   0}, // #10141
  { 8,  1,   0}, // #10142
  {13,  1,   0}, // #10143
  {15,  1,   0}, // #10144
  {17,  2,   0}, // #10145
  {18,  1,   0}, // #10146
  {19,  1,   0}, // #10147
  {21,  1,   0}, // #10148
  {23,  2,   0}, // #10149
  {24,  1,   0}, // #10150
  {25,  2,   0}, // #10151
  {26,  3,   0}, // #10152
  { 4,  1,   0}, // #10153
  { 8,  1,   0}, // #10154
  {13,  1,   0}, // #10155
  {15,  1,   0}, // #10156
  {17,  2,   0}, // #10157
  {18,  1,   0}, // #10158
  {21,  1,   0}, // #10159
  {23,  2,   0}, // #10160
  {24,  1,   0}, // #10161
  {25,  2,   0}, // #10162
  {26,  2,   0}, // #10163
  { 8,  1,   0}, // #10164
  {15,  1,   0}, // #10165
  {17,  1,   0}, // #10166
  {21,  1,   0}, // #10167
  {23,  1,   0}, // #10168
  {24,  1,   0}, // #10169
  {25,  1,   0}, // #10170
  {26,  1,   0}, // #10171
  { 3,  1,   0}, // #10172
  {13,  1,   0}, // #10173
  {14,  1,   0}, // #10174
  {15,  1,   0}, // #10175
  {16,  1,   0}, // #10176
  {19,  1,   0}, // #10177
  {23,  1,   0}, // #10178
  {24,  1,   0}, // #10179
  {25,  2,   0}, // #10180
  {26,  3,   0}, // #10181
  {15,  1,   0}, // #10182
  {19,  1,   0}, // #10183
  {23,  1,   0}, // #10184
  {24,  1,   0}, // #10185
  {25,  1,   0}, // #10186
  {26,  2,   0}, // #10187
  { 8,  1,   0}, // #10188
  {15,  1,   0}, // #10189
  {17,  1,   0}, // #10190
  {19,  1,   0}, // #10191
  {21,  1,   0}, // #10192
  {23,  1,   0}, // #10193
  {24,  1,   0}, // #10194
  {25,  1,   0}, // #10195
  {26,  2,   0}, // #10196
  { 8,  2,   0}, // #10197
  {15,  3,   0}, // #10198
  {17,  2,   0}, // #10199
  {19,  1,   0}, // #10200
  {21,  2,   0}, // #10201
  {23,  3,   0}, // #10202
  {24,  3,   0}, // #10203
  {25,  3,   0}, // #10204
  {26,  4,   0}, // #10205
  { 8,  2,   0}, // #10206
  {15,  3,   0}, // #10207
  {17,  2,   0}, // #10208
  {21,  2,   0}, // #10209
  {23,  3,   0}, // #10210
  {24,  3,   0}, // #10211
  {25,  3,   0}, // #10212
  {26,  3,   0}, // #10213
  { 8,  2,   0}, // #10214
  {15,  2,   0}, // #10215
  {17,  2,   0}, // #10216
  {21,  2,   0}, // #10217
  {23,  2,   0}, // #10218
  {24,  2,   0}, // #10219
  {25,  2,   0}, // #10220
  {26,  2,   0}, // #10221
  { 8,  2,   0}, // #10222
  {15,  2,   0}, // #10223
  {17,  2,   0}, // #10224
  {19,  1,   0}, // #10225
  {21,  2,   0}, // #10226
  {23,  2,   0}, // #10227
  {24,  2,   0}, // #10228
  {25,  2,   0}, // #10229
  {26,  3,   0}, // #10230
  { 3,  4,   0}, // #10231
  { 8,  3,   0}, // #10232
  {13,  4,   0}, // #10233
  {14,  4,   0}, // #10234
  {15,  7,   0}, // #10235
  {16,  4,   0}, // #10236
  {17,  3,   0}, // #10237
  {19,  1,   0}, // #10238
  {21,  3,   0}, // #10239
  {23,  7,   0}, // #10240
  {24,  7,   0}, // #10241
  {25,  8,   0}, // #10242
  {26,  9,   0}, // #10243
  { 3,  4,   0}, // #10244
  { 8,  3,   0}, // #10245
  {13,  4,   0}, // #10246
  {14,  4,   0}, // #10247
  {15,  7,   0}, // #10248
  {16,  4,   0}, // #10249
  {17,  3,   0}, // #10250
  {21,  3,   0}, // #10251
  {23,  7,   0}, // #10252
  {24,  7,   0}, // #10253
  {25,  8,   0}, // #10254
  {26,  8,   0}, // #10255
  { 3,  4,   0}, // #10256
  { 8,  3,   0}, // #10257
  {13,  4,   0}, // #10258
  {14,  4,   0}, // #10259
  {15,  7,   0}, // #10260
  {16,  4,   0}, // #10261
  {17,  3,   0}, // #10262
  {19,  1,   0}, // #10263
  {21,  3,   0}, // #10264
  {23,  8,   0}, // #10265
  {24,  7,   0}, // #10266
  {25,  9,   0}, // #10267
  {26, 10,   0}, // #10268
  { 3,  4,   0}, // #10269
  { 8,  3,   0}, // #10270
  {13,  4,   0}, // #10271
  {14,  4,   0}, // #10272
  {15,  7,   0}, // #10273
  {16,  4,   0}, // #10274
  {17,  3,   0}, // #10275
  {21,  3,   0}, // #10276
  {23,  8,   0}, // #10277
  {24,  7,   0}, // #10278
  {25,  9,   0}, // #10279
  {26,  9,   0}, // #10280
  { 3,  3,   0}, // #10281
  {13,  3,   0}, // #10282
  {14,  3,   0}, // #10283
  {15,  3,   0}, // #10284
  {16,  3,   0}, // #10285
  {19,  1,   0}, // #10286
  {23,  3,   0}, // #10287
  {24,  3,   0}, // #10288
  {25,  3,   0}, // #10289
  {26,  4,   0}, // #10290
  { 3,  3,   0}, // #10291
  {13,  3,   0}, // #10292
  {14,  3,   0}, // #10293
  {15,  3,   0}, // #10294
  {16,  3,   0}, // #10295
  {23,  3,   0}, // #10296
  {24,  3,   0}, // #10297
  {25,  3,   0}, // #10298
  {26,  3,   0}, // #10299
  {19,  1,   0}, // #10300
  {20,  1,   0}, // #10301
  {22,  1,   0}, // #10302
  {26,  3,   0}, // #10303
  { 3,  1,   0}, // #10304
  { 8,  1,   0}, // #10305
  {13,  1,   0}, // #10306
  {14,  1,   0}, // #10307
  {15,  2,   0}, // #10308
  {16,  1,   0}, // #10309
  {17,  1,   0}, // #10310
  {19,  1,   0}, // #10311
  {21,  1,   0}, // #10312
  {23,  2,   0}, // #10313
  {24,  2,   0}, // #10314
  {25,  2,   0}, // #10315
  {26,  3,   0}, // #10316
  {16,  2,   0}, // #10317
  {19,  1,   0}, // #10318
  {24,  2,   0}, // #10319
  {25,  2,   0}, // #10320
  {26,  3,   0}, // #10321
  {16,  3,   0}, // #10322
  {19,  1,   0}, // #10323
  {20,  1,   0}, // #10324
  {22,  1,   0}, // #10325
  {24,  3,   0}, // #10326
  {25,  3,   0}, // #10327
  {26,  6,   0}, // #10328
  {16,  6,   0}, // #10329
  {19,  1,   0}, // #10330
  {24,  6,   0}, // #10331
  {25,  6,   0}, // #10332
  {26,  7,   0}, // #10333
  {16,  3,   0}, // #10334
  {24,  3,   0}, // #10335
  {25,  3,   0}, // #10336
  {26,  3,   0}, // #10337
  {16,  1,   0}, // #10338
  {20,  1,   0}, // #10339
  {22,  1,   0}, // #10340
  {24,  1,   0}, // #10341
  {25,  1,   0}, // #10342
  {26,  3,   0}, // #10343
  { 4,  1,   0}, // #10344
  {13,  1,   0}, // #10345
  {16,  2,   0}, // #10346
  {17,  1,   0}, // #10347
  {18,  1,   0}, // #10348
  {19,  1,   0}, // #10349
  {22,  1,   0}, // #10350
  {23,  1,   0}, // #10351
  {24,  2,   0}, // #10352
  {25,  4,   0}, // #10353
  {26,  6,   0}, // #10354
  { 4,  1,   0}, // #10355
  {13,  1,   0}, // #10356
  {17,  1,   0}, // #10357
  {18,  1,   0}, // #10358
  {19,  1,   0}, // #10359
  {22,  1,   0}, // #10360
  {23,  1,   0}, // #10361
  {25,  2,   0}, // #10362
  {26,  4,   0}, // #10363
  { 4,  1,   0}, // #10364
  {13,  1,   0}, // #10365
  {16,  2,   0}, // #10366
  {17,  1,   0}, // #10367
  {18,  1,   0}, // #10368
  {23,  1,   0}, // #10369
  {24,  2,   0}, // #10370
  {25,  4,   0}, // #10371
  {26,  4,   0}, // #10372
  { 2,  6,   0}, // #10373
  { 3,  1,   0}, // #10374
  {13,  1,   0}, // #10375
  {14,  1,   0}, // #10376
  {15,  1,   0}, // #10377
  {16,  1,   0}, // #10378
  {19,  1,   0}, // #10379
  {23,  1,   0}, // #10380
  {24,  1,   0}, // #10381
  {25,  1,   0}, // #10382
  {26,  2,   0}, // #10383
  { 2,  6,   0}, // #10384
  { 3,  1,   0}, // #10385
  {13,  1,   0}, // #10386
  {14,  1,   0}, // #10387
  {15,  1,   0}, // #10388
  {16,  1,   0}, // #10389
  {23,  1,   0}, // #10390
  {24,  1,   0}, // #10391
  {25,  1,   0}, // #10392
  {26,  1,   0}, // #10393
  { 2,  7,   0}, // #10394
  { 3,  1,   0}, // #10395
  {13,  1,   0}, // #10396
  {14,  1,   0}, // #10397
  {15,  1,   0}, // #10398
  {16,  1,   0}, // #10399
  {23,  1,   0}, // #10400
  {24,  1,   0}, // #10401
  {25,  1,   0}, // #10402
  {26,  1,   0}, // #10403
  {15,  2,   0}, // #10404
  {19,  1,   0}, // #10405
  {23,  2,   0}, // #10406
  {24,  2,   0}, // #10407
  {25,  2,   0}, // #10408
  {26,  3,   0}, // #10409
  { 8,  1,   0}, // #10410
  {13,  1,   0}, // #10411
  {15,  1,   0}, // #10412
  {17,  1,   0}, // #10413
  {20,  1,   0}, // #10414
  {21,  1,   0}, // #10415
  {22,  1,   0}, // #10416
  {23,  2,   0}, // #10417
  {24,  1,   0}, // #10418
  {25,  2,   0}, // #10419
  {26,  4,   0}, // #10420
  { 8,  1,   0}, // #10421
  {15,  2,   0}, // #10422
  {17,  1,   0}, // #10423
  {20,  1,   0}, // #10424
  {21,  1,   0}, // #10425
  {22,  1,   0}, // #10426
  {23,  2,   0}, // #10427
  {24,  2,   0}, // #10428
  {25,  2,   0}, // #10429
  {26,  4,   0}, // #10430
  { 8,  1,   0}, // #10431
  {15,  2,   0}, // #10432
  {17,  1,   0}, // #10433
  {21,  1,   0}, // #10434
  {23,  2,   0}, // #10435
  {24,  2,   0}, // #10436
  {25,  2,   0}, // #10437
  {26,  2,   0}, // #10438
  { 2,  8,   0}, // #10439
  { 3,  1,   0}, // #10440
  {13,  1,   0}, // #10441
  {14,  1,   0}, // #10442
  {15,  1,   0}, // #10443
  {16,  1,   0}, // #10444
  {19,  1,   0}, // #10445
  {23,  1,   0}, // #10446
  {24,  1,   0}, // #10447
  {25,  1,   0}, // #10448
  {26,  2,   0}, // #10449
  { 2,  8,   0}, // #10450
  { 3,  1,   0}, // #10451
  {13,  1,   0}, // #10452
  {14,  1,   0}, // #10453
  {15,  1,   0}, // #10454
  {16,  1,   0}, // #10455
  {23,  1,   0}, // #10456
  {24,  1,   0}, // #10457
  {25,  1,   0}, // #10458
  {26,  1,   0}, // #10459
  { 2, 16,   0}, // #10460
  { 3,  2,   0}, // #10461
  { 8,  1,   0}, // #10462
  {13,  2,   0}, // #10463
  {14,  2,   0}, // #10464
  {15,  3,   0}, // #10465
  {16,  2,   0}, // #10466
  {17,  1,   0}, // #10467
  {19,  1,   0}, // #10468
  {21,  1,   0}, // #10469
  {23,  3,   0}, // #10470
  {24,  3,   0}, // #10471
  {25,  3,   0}, // #10472
  {26,  4,   0}, // #10473
  { 2, 16,   0}, // #10474
  { 3,  2,   0}, // #10475
  { 8,  1,   0}, // #10476
  {13,  2,   0}, // #10477
  {14,  2,   0}, // #10478
  {15,  3,   0}, // #10479
  {16,  2,   0}, // #10480
  {17,  1,   0}, // #10481
  {21,  1,   0}, // #10482
  {23,  3,   0}, // #10483
  {24,  3,   0}, // #10484
  {25,  3,   0}, // #10485
  {26,  3,   0}, // #10486
  { 2,  5,   0}, // #10487
  { 3,  1,   0}, // #10488
  {13,  1,   0}, // #10489
  {14,  1,   0}, // #10490
  {15,  1,   0}, // #10491
  {16,  1,   0}, // #10492
  {19,  1,   0}, // #10493
  {23,  1,   0}, // #10494
  {24,  1,   0}, // #10495
  {25,  1,   0}, // #10496
  {26,  2,   0}, // #10497
  { 2,  5,   0}, // #10498
  { 3,  1,   0}, // #10499
  {13,  1,   0}, // #10500
  {14,  1,   0}, // #10501
  {15,  1,   0}, // #10502
  {16,  1,   0}, // #10503
  {23,  1,   0}, // #10504
  {24,  1,   0}, // #10505
  {25,  1,   0}, // #10506
  {26,  1,   0}, // #10507
  { 2, 10,   0}, // #10508
  { 3,  2,   0}, // #10509
  { 8,  1,   0}, // #10510
  {13,  2,   0}, // #10511
  {14,  2,   0}, // #10512
  {15,  3,   0}, // #10513
  {16,  2,   0}, // #10514
  {17,  1,   0}, // #10515
  {19,  1,   0}, // #10516
  {21,  1,   0}, // #10517
  {23,  3,   0}, // #10518
  {24,  3,   0}, // #10519
  {25,  3,   0}, // #10520
  {26,  4,   0}, // #10521
  { 2, 10,   0}, // #10522
  { 3,  2,   0}, // #10523
  { 8,  1,   0}, // #10524
  {13,  2,   0}, // #10525
  {14,  2,   0}, // #10526
  {15,  3,   0}, // #10527
  {16,  2,   0}, // #10528
  {17,  1,   0}, // #10529
  {21,  1,   0}, // #10530
  {23,  3,   0}, // #10531
  {24,  3,   0}, // #10532
  {25,  3,   0}, // #10533
  {26,  3,   0}, // #10534
  { 3,  1,   0}, // #10535
  {13,  1,   0}, // #10536
  {14,  1,   0}, // #10537
  {15,  1,   0}, // #10538
  {16,  1,   0}, // #10539
  {20,  1,   0}, // #10540
  {22,  1,   0}, // #10541
  {23,  1,   0}, // #10542
  {24,  1,   0}, // #10543
  {25,  1,   0}, // #10544
  {26,  3,   0}, // #10545
  { 2, 12,   0}, // #10546
  { 3,  1,   0}, // #10547
  {13,  1,   0}, // #10548
  {14,  1,   0}, // #10549
  {15,  1,   0}, // #10550
  {16,  1,   0}, // #10551
  {19,  1,   0}, // #10552
  {23,  1,   0}, // #10553
  {24,  1,   0}, // #10554
  {25,  1,   0}, // #10555
  {26,  2,   0}, // #10556
  { 2, 12,   0}, // #10557
  { 3,  1,   0}, // #10558
  {13,  1,   0}, // #10559
  {14,  1,   0}, // #10560
  {15,  1,   0}, // #10561
  {16,  1,   0}, // #10562
  {23,  1,   0}, // #10563
  {24,  1,   0}, // #10564
  {25,  1,   0}, // #10565
  {26,  1,   0}, // #10566
  { 2, 24,   0}, // #10567
  { 3,  2,   0}, // #10568
  { 8,  1,   0}, // #10569
  {13,  2,   0}, // #10570
  {14,  2,   0}, // #10571
  {15,  3,   0}, // #10572
  {16,  2,   0}, // #10573
  {17,  1,   0}, // #10574
  {19,  1,   0}, // #10575
  {21,  1,   0}, // #10576
  {23,  3,   0}, // #10577
  {24,  3,   0}, // #10578
  {25,  3,   0}, // #10579
  {26,  4,   0}, // #10580
  { 2, 24,   0}, // #10581
  { 3,  2,   0}, // #10582
  { 8,  1,   0}, // #10583
  {13,  2,   0}, // #10584
  {14,  2,   0}, // #10585
  {15,  3,   0}, // #10586
  {16,  2,   0}, // #10587
  {17,  1,   0}, // #10588
  {21,  1,   0}, // #10589
  {23,  3,   0}, // #10590
  {24,  3,   0}, // #10591
  {25,  3,   0}, // #10592
  {26,  3,   0}, // #10593
  { 2, 12,   0}, // #10594
  { 3,  2,   0}, // #10595
  { 8,  1,   0}, // #10596
  {13,  2,   0}, // #10597
  {14,  2,   0}, // #10598
  {15,  3,   0}, // #10599
  {16,  2,   0}, // #10600
  {17,  1,   0}, // #10601
  {19,  1,   0}, // #10602
  {21,  1,   0}, // #10603
  {23,  3,   0}, // #10604
  {24,  3,   0}, // #10605
  {25,  3,   0}, // #10606
  {26,  4,   0}, // #10607
  { 2, 12,   0}, // #10608
  { 3,  2,   0}, // #10609
  { 8,  1,   0}, // #10610
  {13,  2,   0}, // #10611
  {14,  2,   0}, // #10612
  {15,  3,   0}, // #10613
  {16,  2,   0}, // #10614
  {17,  1,   0}, // #10615
  {21,  1,   0}, // #10616
  {23,  3,   0}, // #10617
  {24,  3,   0}, // #10618
  {25,  3,   0}, // #10619
  {26,  3,   0}, // #10620
  {16,  1,   0}, // #10621
  {19,  1,   0}, // #10622
  {22,  1,   0}, // #10623
  {24,  1,   0}, // #10624
  {25,  3,   0}, // #10625
  {26,  5,   0}, // #10626
  { 4,  2,   0}, // #10627
  {13,  2,   0}, // #10628
  {16,  4,   0}, // #10629
  {17,  3,   0}, // #10630
  {18,  2,   0}, // #10631
  {19,  1,   0}, // #10632
  {22,  1,   0}, // #10633
  {23,  3,   0}, // #10634
  {24,  4,   0}, // #10635
  {25,  9,   0}, // #10636
  {26, 11,   0}, // #10637
  { 3,  2,   0}, // #10638
  { 4,  1,   0}, // #10639
  { 8,  2,   0}, // #10640
  { 9,  4,   0}, // #10641
  {13,  3,   0}, // #10642
  {14,  2,   0}, // #10643
  {15,  6,   0}, // #10644
  {16,  6,   0}, // #10645
  {17,  3,   0}, // #10646
  {18,  5,   0}, // #10647
  {21,  6,   0}, // #10648
  {23,  7,   0}, // #10649
  {24, 10,   0}, // #10650
  {25, 15,   0}, // #10651
  {26, 15,   0}, // #10652
  { 8,  2,   0}, // #10653
  {13,  1,   0}, // #10654
  {15,  2,   0}, // #10655
  {17,  2,   0}, // #10656
  {21,  2,   0}, // #10657
  {23,  3,   0}, // #10658
  {24,  2,   0}, // #10659
  {25,  3,   0}, // #10660
  {26,  3,   0}, // #10661
  { 3,  1,   0}, // #10662
  { 8,  1,   0}, // #10663
  {13,  2,   0}, // #10664
  {14,  1,   0}, // #10665
  {15,  2,   0}, // #10666
  {16,  1,   0}, // #10667
  {17,  1,   0}, // #10668
  {21,  1,   0}, // #10669
  {23,  3,   0}, // #10670
  {24,  2,   0}, // #10671
  {25,  3,   0}, // #10672
  {26,  3,   0}, // #10673
  {19,  1,   0}, // #10674
  {25,  2,   0}, // #10675
  {26,  3,   0}, // #10676
  { 9,  1,   0}, // #10677
  {16,  1,   0}, // #10678
  {18,  1,   0}, // #10679
  {21,  1,   0}, // #10680
  {24,  1,   0}, // #10681
  {25,  3,   0}, // #10682
  {26,  3,   0}, // #10683
  { 9,  1,   0}, // #10684
  {16,  2,   0}, // #10685
  {18,  1,   0}, // #10686
  {19,  1,   0}, // #10687
  {20,  1,   0}, // #10688
  {21,  1,   0}, // #10689
  {22,  1,   0}, // #10690
  {24,  2,   0}, // #10691
  {25,  5,   0}, // #10692
  {26,  8,   0}, // #10693
  {16,  1,   0}, // #10694
  {24,  1,   0}, // #10695
  {25,  2,   0}, // #10696
  {26,  2,   0}, // #10697
  { 3,  1,   0}, // #10698
  {13,  1,   0}, // #10699
  {14,  1,   0}, // #10700
  {15,  2,   0}, // #10701
  {16,  1,   0}, // #10702
  {19,  1,   0}, // #10703
  {23,  2,   0}, // #10704
  {24,  2,   0}, // #10705
  {25,  2,   0}, // #10706
  {26,  3,   0}, // #10707
  {16,  2,   0}, // #10708
  {24,  2,   0}, // #10709
  {25, 11,   0}, // #10710
  {26, 11,   0}, // #10711
  { 9,  1,   0}, // #10712
  {16,  1,   0}, // #10713
  {18,  1,   0}, // #10714
  {20,  1,   0}, // #10715
  {21,  1,   0}, // #10716
  {22,  1,   0}, // #10717
  {24,  1,   0}, // #10718
  {25,  1,   0}, // #10719
  {26,  3,   0}, // #10720
  { 9,  1,   0}, // #10721
  {16,  1,   0}, // #10722
  {18,  1,   0}, // #10723
  {21,  1,   0}, // #10724
  {24,  1,   0}, // #10725
  {25,  4,   0}, // #10726
  {26,  4,   0}, // #10727
  {16,  4,   0}, // #10728
  {17,  2,   0}, // #10729
  {19,  1,   0}, // #10730
  {20,  1,   0}, // #10731
  {22,  1,   0}, // #10732
  {23,  2,   0}, // #10733
  {24,  4,   0}, // #10734
  {25, 11,   0}, // #10735
  {26, 14,   0}, // #10736
  { 9,  1,   0}, // #10737
  {16,  4,   0}, // #10738
  {17,  1,   0}, // #10739
  {18,  1,   0}, // #10740
  {21,  1,   0}, // #10741
  {23,  1,   0}, // #10742
  {24,  4,   0}, // #10743
  {25,  7,   0}, // #10744
  {26,  7,   0}, // #10745
  { 9,  1,   0}, // #10746
  {16,  1,   0}, // #10747
  {18,  1,   0}, // #10748
  {21,  1,   0}, // #10749
  {24,  1,   0}, // #10750
  {25,  6,   0}, // #10751
  {26,  6,   0}, // #10752
  { 3,  2,   0}, // #10753
  { 8,  4,   0}, // #10754
  {13,  2,   0}, // #10755
  {14,  2,   0}, // #10756
  {15,  6,   0}, // #10757
  {16,  6,   0}, // #10758
  {17,  4,   0}, // #10759
  {19,  1,   0}, // #10760
  {20,  1,   0}, // #10761
  {21,  4,   0}, // #10762
  {22,  1,   0}, // #10763
  {23,  6,   0}, // #10764
  {24, 10,   0}, // #10765
  {25, 16,   0}, // #10766
  {26, 19,   0}, // #10767
  { 8,  2,   0}, // #10768
  {15,  2,   0}, // #10769
  {17,  2,   0}, // #10770
  {21,  2,   0}, // #10771
  {23,  2,   0}, // #10772
  {24,  2,   0}, // #10773
  {25, 22,   0}, // #10774
  {26, 22,   0}, // #10775
  { 8,  1,   0}, // #10776
  { 9,  2,   0}, // #10777
  {15,  1,   0}, // #10778
  {16,  2,   0}, // #10779
  {17,  1,   0}, // #10780
  {18,  2,   0}, // #10781
  {21,  3,   0}, // #10782
  {23,  1,   0}, // #10783
  {24,  3,   0}, // #10784
  {25, 10,   0}, // #10785
  {26, 10,   0}, // #10786
  { 8,  1,   0}, // #10787
  { 9,  1,   0}, // #10788
  {15,  1,   0}, // #10789
  {16,  2,   0}, // #10790
  {17,  1,   0}, // #10791
  {18,  1,   0}, // #10792
  {19,  1,   0}, // #10793
  {20,  1,   0}, // #10794
  {21,  2,   0}, // #10795
  {22,  1,   0}, // #10796
  {23,  1,   0}, // #10797
  {24,  3,   0}, // #10798
  {25,  5,   0}, // #10799
  {26,  8,   0}, // #10800
  { 8,  6,   0}, // #10801
  {15,  9,   0}, // #10802
  {17,  6,   0}, // #10803
  {21,  6,   0}, // #10804
  {23,  9,   0}, // #10805
  {24,  9,   0}, // #10806
  {25, 15,   0}, // #10807
  {26, 15,   0}, // #10808
  { 8,  1,   0}, // #10809
  { 9,  5,   0}, // #10810
  {15,  1,   0}, // #10811
  {16,  9,   0}, // #10812
  {17,  1,   0}, // #10813
  {18,  5,   0}, // #10814
  {19,  2,   0}, // #10815
  {21,  6,   0}, // #10816
  {22,  1,   0}, // #10817
  {23,  1,   0}, // #10818
  {24, 10,   0}, // #10819
  {25, 20,   0}, // #10820
  {26, 23,   0}, // #10821
  { 8,  1,   0}, // #10822
  { 9,  5,   0}, // #10823
  {15,  1,   0}, // #10824
  {16,  9,   0}, // #10825
  {17,  1,   0}, // #10826
  {18,  5,   0}, // #10827
  {19,  3,   0}, // #10828
  {21,  6,   0}, // #10829
  {23,  1,   0}, // #10830
  {24, 10,   0}, // #10831
  {25, 20,   0}, // #10832
  {26, 23,   0}, // #10833
  { 8,  1,   0}, // #10834
  { 9,  1,   0}, // #10835
  {15,  1,   0}, // #10836
  {16,  2,   0}, // #10837
  {17,  1,   0}, // #10838
  {18,  1,   0}, // #10839
  {21,  2,   0}, // #10840
  {23,  1,   0}, // #10841
  {24,  3,   0}, // #10842
  {25,  8,   0}, // #10843
  {26,  8,   0}, // #10844
  { 3,  4,   0}, // #10845
  { 9,  2,   0}, // #10846
  {13,  4,   0}, // #10847
  {14,  4,   0}, // #10848
  {15,  5,   0}, // #10849
  {16,  8,   0}, // #10850
  {17,  1,   0}, // #10851
  {18,  2,   0}, // #10852
  {19, 33,   0}, // #10853
  {21,  2,   0}, // #10854
  {23,  6,   0}, // #10855
  {24,  9,   0}, // #10856
  {25, 57,   0}, // #10857
  {26, 90,   0}, // #10858
  { 9,  1,   0}, // #10859
  {16,  1,   0}, // #10860
  {18,  1,   0}, // #10861
  {19,  1,   0}, // #10862
  {21,  1,   0}, // #10863
  {24,  1,   0}, // #10864
  {25,  2,   0}, // #10865
  {26,  3,   0}, // #10866
  { 3,  1,   0}, // #10867
  {13,  1,   0}, // #10868
  {14,  1,   0}, // #10869
  {15,  1,   0}, // #10870
  {16,  1,   0}, // #10871
  {23,  1,   0}, // #10872
  {24,  1,   0}, // #10873
  {25,  2,   0}, // #10874
  {26,  2,   0}, // #10875
  {16,  1,   0}, // #10876
  {24,  1,   0}, // #10877
  {25,  3,   0}, // #10878
  {26,  3,   0}, // #10879
  { 4,  2,   0}, // #10880
  {13,  2,   0}, // #10881
  {16,  3,   0}, // #10882
  {17,  2,   0}, // #10883
  {18,  2,   0}, // #10884
  {23,  2,   0}, // #10885
  {24,  3,   0}, // #10886
  {25,  7,   0}, // #10887
  {26,  7,   0}, // #10888
  {20,  1,   0}, // #10889
  {22,  1,   0}, // #10890
  {25,  1,   0}, // #10891
  {26,  3,   0}, // #10892
  {16,  1,   0}, // #10893
  {20,  1,   0}, // #10894
  {22,  1,   0}, // #10895
  {24,  1,   0}, // #10896
  {25,  2,   0}, // #10897
  {26,  4,   0}, // #10898
  { 9,  1,   0}, // #10899
  {16,  1,   0}, // #10900
  {18,  1,   0}, // #10901
  {20,  1,   0}, // #10902
  {21,  1,   0}, // #10903
  {22,  1,   0}, // #10904
  {24,  1,   0}, // #10905
  {25,  2,   0}, // #10906
  {26,  4,   0}, // #10907
  {20,  1,   0}, // #10908
  {22,  1,   0}, // #10909
  {25,  4,   0}, // #10910
  {26,  6,   0}, // #10911
  { 9,  1,   0}, // #10912
  {16,  1,   0}, // #10913
  {18,  1,   0}, // #10914
  {21,  1,   0}, // #10915
  {24,  1,   0}, // #10916
  {25,  2,   0}, // #10917
  {26,  2,   0}, // #10918
  { 9,  1,   0}, // #10919
  {16,  1,   0}, // #10920
  {18,  1,   0}, // #10921
  {19,  1,   0}, // #10922
  {21,  1,   0}, // #10923
  {24,  1,   0}, // #10924
  {25,  1,   0}, // #10925
  {26,  2,   0}, // #10926
  { 4,  1,   0}, // #10927
  { 9,  1,   0}, // #10928
  {13,  1,   0}, // #10929
  {16,  2,   0}, // #10930
  {17,  1,   0}, // #10931
  {18,  2,   0}, // #10932
  {21,  1,   0}, // #10933
  {23,  1,   0}, // #10934
  {24,  2,   0}, // #10935
  {25,  4,   0}, // #10936
  {26,  4,   0}, // #10937
  { 9,  1,   0}, // #10938
  {16,  1,   0}, // #10939
  {18,  1,   0}, // #10940
  {19,  1,   0}, // #10941
  {20,  1,   0}, // #10942
  {21,  1,   0}, // #10943
  {22,  1,   0}, // #10944
  {24,  1,   0}, // #10945
  {25,  2,   0}, // #10946
  {26,  5,   0}, // #10947
  {16,  2,   0}, // #10948
  {19,  1,   0}, // #10949
  {20,  1,   0}, // #10950
  {22,  1,   0}, // #10951
  {24,  2,   0}, // #10952
  {25,  2,   0}, // #10953
  {26,  5,   0}, // #10954
  {19,  1,   0}, // #10955
  {20,  1,   0}, // #10956
  {22,  1,   0}, // #10957
  {25,  2,   0}, // #10958
  {26,  5,   0}, // #10959
  { 4,  1,   0}, // #10960
  { 9,  5,   0}, // #10961
  {13,  1,   0}, // #10962
  {15,  4,   0}, // #10963
  {16,  5,   0}, // #10964
  {17,  1,   0}, // #10965
  {18,  6,   0}, // #10966
  {21,  5,   0}, // #10967
  {23,  5,   0}, // #10968
  {24,  9,   0}, // #10969
  {25, 10,   0}, // #10970
  {26, 10,   0}, // #10971
  { 9,  1,   0}, // #10972
  {16,  1,   0}, // #10973
  {18,  1,   0}, // #10974
  {21,  1,   0}, // #10975
  {24,  1,   0}, // #10976
  {25,  1,   0}, // #10977
  {26,  1,   0}, // #10978
  {17,  1,   0}, // #10979
  {20,  1,   0}, // #10980
  {22,  1,   0}, // #10981
  {23,  1,   0}, // #10982
  {25,  1,   0}, // #10983
  {26,  3,   0}, // #10984
  {20,  1,   0}, // #10985
  {22,  2,   0}, // #10986
  {26,  3,   0}, // #10987
  {16,  2,   0}, // #10988
  {24,  2,   0}, // #10989
  {25,  2,   0}, // #10990
  {26,  2,   0}, // #10991
  { 8,  2,   0}, // #10992
  {15,  2,   0}, // #10993
  {17,  2,   0}, // #10994
  {21,  2,   0}, // #10995
  {23,  2,   0}, // #10996
  {24,  2,   0}, // #10997
  {25,  3,   0}, // #10998
  {26,  3,   0}, // #10999
  { 4,  1,   0}, // #11000
  { 9,  1,   0}, // #11001
  {13,  1,   0}, // #11002
  {16,  1,   0}, // #11003
  {17,  1,   0}, // #11004
  {18,  2,   0}, // #11005
  {21,  1,   0}, // #11006
  {23,  1,   0}, // #11007
  {24,  1,   0}, // #11008
  {25,  4,   0}, // #11009
  {26,  4,   0}, // #11010
  { 4,  1,   0}, // #11011
  { 9,  2,   0}, // #11012
  {13,  1,   0}, // #11013
  {16,  2,   0}, // #11014
  {17,  1,   0}, // #11015
  {18,  3,   0}, // #11016
  {19,  1,   0}, // #11017
  {21,  2,   0}, // #11018
  {23,  1,   0}, // #11019
  {24,  2,   0}, // #11020
  {25,  4,   0}, // #11021
  {26,  5,   0}, // #11022
  { 4,  1,   0}, // #11023
  { 9,  1,   0}, // #11024
  {13,  1,   0}, // #11025
  {16,  2,   0}, // #11026
  {17,  1,   0}, // #11027
  {18,  2,   0}, // #11028
  {21,  1,   0}, // #11029
  {23,  1,   0}, // #11030
  {24,  2,   0}, // #11031
  {25,  3,   0}, // #11032
  {26,  3,   0}, // #11033
  {16,  1,   0}, // #11034
  {24,  1,   0}, // #11035
  {25,  5,   0}, // #11036
  {26,  5,   0}, // #11037
  { 4,  1,   0}, // #11038
  {13,  1,   0}, // #11039
  {16,  5,   0}, // #11040
  {17,  2,   0}, // #11041
  {18,  1,   0}, // #11042
  {19,  1,   0}, // #11043
  {22,  1,   0}, // #11044
  {23,  2,   0}, // #11045
  {24,  5,   0}, // #11046
  {25,  8,   0}, // #11047
  {26, 10,   0}, // #11048
  { 4,  1,   0}, // #11049
  {13,  1,   0}, // #11050
  {16,  5,   0}, // #11051
  {17,  2,   0}, // #11052
  {18,  1,   0}, // #11053
  {23,  2,   0}, // #11054
  {24,  5,   0}, // #11055
  {25,  9,   0}, // #11056
  {26,  9,   0}, // #11057
  { 4,  2,   0}, // #11058
  {13,  2,   0}, // #11059
  {16,  4,   0}, // #11060
  {17,  3,   0}, // #11061
  {18,  2,   0}, // #11062
  {23,  3,   0}, // #11063
  {24,  4,   0}, // #11064
  {25, 10,   0}, // #11065
  {26, 10,   0}, // #11066
  { 4,  1,   0}, // #11067
  { 9,  8,   0}, // #11068
  {13,  1,   0}, // #11069
  {16,  8,   0}, // #11070
  {17,  1,   0}, // #11071
  {18,  9,   0}, // #11072
  {19,  1,   0}, // #11073
  {21,  8,   0}, // #11074
  {23,  1,   0}, // #11075
  {24,  8,   0}, // #11076
  {25, 30,   0}, // #11077
  {26, 31,   0}, // #11078
  { 9, 10,   0}, // #11079
  {16, 10,   0}, // #11080
  {18, 10,   0}, // #11081
  {19,  1,   0}, // #11082
  {20,  1,   0}, // #11083
  {21, 10,   0}, // #11084
  {22,  1,   0}, // #11085
  {24, 10,   0}, // #11086
  {25, 36,   0}, // #11087
  {26, 39,   0}, // #11088
  { 9, 11,   0}, // #11089
  {16, 11,   0}, // #11090
  {18, 11,   0}, // #11091
  {19,  1,   0}, // #11092
  {20,  1,   0}, // #11093
  {21, 11,   0}, // #11094
  {22,  1,   0}, // #11095
  {24, 11,   0}, // #11096
  {25, 37,   0}, // #11097
  {26, 40,   0}, // #11098
  { 4,  1,   0}, // #11099
  { 8,  2,   0}, // #11100
  { 9,  3,   0}, // #11101
  {13,  1,   0}, // #11102
  {15,  2,   0}, // #11103
  {16,  3,   0}, // #11104
  {17,  4,   0}, // #11105
  {18,  4,   0}, // #11106
  {19,  1,   0}, // #11107
  {20,  1,   0}, // #11108
  {21,  5,   0}, // #11109
  {22,  1,   0}, // #11110
  {23,  4,   0}, // #11111
  {24,  5,   0}, // #11112
  {25, 15,   0}, // #11113
  {26, 18,   0}, // #11114
  { 3,  2,   0}, // #11115
  {13,  2,   0}, // #11116
  {14,  2,   0}, // #11117
  {15,  7,   0}, // #11118
  {16, 12,   0}, // #11119
  {19,  8,   0}, // #11120
  {23,  7,   0}, // #11121
  {24, 17,   0}, // #11122
  {25, 56,   0}, // #11123
  {26, 64,   0}, // #11124
  { 3,  4,   0}, // #11125
  { 9,  4,   0}, // #11126
  {13,  4,   0}, // #11127
  {14,  4,   0}, // #11128
  {15,  5,   0}, // #11129
  {16, 10,   0}, // #11130
  {17,  1,   0}, // #11131
  {18,  4,   0}, // #11132
  {19, 31,   0}, // #11133
  {21,  4,   0}, // #11134
  {23,  6,   0}, // #11135
  {24, 11,   0}, // #11136
  {25, 57,   0}, // #11137
  {26, 88,   0}, // #11138
  { 3,  9,   0}, // #11139
  { 4,  1,   0}, // #11140
  { 8, 16,   0}, // #11141
  { 9,  1,   0}, // #11142
  {13, 10,   0}, // #11143
  {14,  9,   0}, // #11144
  {15, 25,   0}, // #11145
  {16, 31,   0}, // #11146
  {17, 17,   0}, // #11147
  {18,  2,   0}, // #11148
  {20, 11,   0}, // #11149
  {21, 17,   0}, // #11150
  {22, 11,   0}, // #11151
  {23, 26,   0}, // #11152
  {24, 47,   0}, // #11153
  {25, 78,   0}, // #11154
  {26, 100,   0}, // #11155
  { 3,  1,   0}, // #11156
  { 8,  1,   0}, // #11157
  {13,  1,   0}, // #11158
  {14,  1,   0}, // #11159
  {15,  2,   0}, // #11160
  {16,  1,   0}, // #11161
  {17,  1,   0}, // #11162
  {19,  2,   0}, // #11163
  {21,  1,   0}, // #11164
  {23,  3,   0}, // #11165
  {24,  2,   0}, // #11166
  {25,  3,   0}, // #11167
  {26,  5,   0}, // #11168
  { 3,  1,   0}, // #11169
  { 8,  1,   0}, // #11170
  {13,  1,   0}, // #11171
  {14,  1,   0}, // #11172
  {15,  2,   0}, // #11173
  {16,  1,   0}, // #11174
  {17,  1,   0}, // #11175
  {19,  4,   0}, // #11176
  {21,  1,   0}, // #11177
  {23,  3,   0}, // #11178
  {24,  2,   0}, // #11179
  {25,  3,   0}, // #11180
  {26,  7,   0}, // #11181
  { 3,  1,   0}, // #11182
  { 8,  1,   0}, // #11183
  {13,  1,   0}, // #11184
  {14,  1,   0}, // #11185
  {15,  2,   0}, // #11186
  {16,  1,   0}, // #11187
  {17,  1,   0}, // #11188
  {19,  8,   0}, // #11189
  {21,  1,   0}, // #11190
  {23,  3,   0}, // #11191
  {24,  2,   0}, // #11192
  {25,  3,   0}, // #11193
  {26, 11,   0}, // #11194
  { 8,  5,   0}, // #11195
  {13,  5,   0}, // #11196
  {15,  5,   0}, // #11197
  {17,  5,   0}, // #11198
  {21,  5,   0}, // #11199
  {23, 14,   0}, // #11200
  {24,  5,   0}, // #11201
  {25, 14,   0}, // #11202
  {26, 14,   0}, // #11203
  { 8,  9,   0}, // #11204
  {13,  7,   0}, // #11205
  {15,  9,   0}, // #11206
  {17,  9,   0}, // #11207
  {21,  9,   0}, // #11208
  {23, 21,   0}, // #11209
  {24,  9,   0}, // #11210
  {25, 21,   0}, // #11211
  {26, 21,   0}, // #11212
  { 8, 17,   0}, // #11213
  {13, 11,   0}, // #11214
  {15, 17,   0}, // #11215
  {17, 17,   0}, // #11216
  {21, 17,   0}, // #11217
  {23, 35,   0}, // #11218
  {24, 17,   0}, // #11219
  {25, 35,   0}, // #11220
  {26, 35,   0}, // #11221
  { 3,  1,   0}, // #11222
  { 8,  2,   0}, // #11223
  {13,  1,   0}, // #11224
  {14,  1,   0}, // #11225
  {15,  3,   0}, // #11226
  {16,  1,   0}, // #11227
  {17,  2,   0}, // #11228
  {21,  2,   0}, // #11229
  {23,  3,   0}, // #11230
  {24,  3,   0}, // #11231
  {25,  3,   0}, // #11232
  {26,  3,   0}, // #11233
  { 3,  1,   0}, // #11234
  { 8,  2,   0}, // #11235
  {13,  1,   0}, // #11236
  {14,  1,   0}, // #11237
  {15,  3,   0}, // #11238
  {16,  1,   0}, // #11239
  {17,  2,   0}, // #11240
  {19,  1,   0}, // #11241
  {21,  2,   0}, // #11242
  {23,  3,   0}, // #11243
  {24,  3,   0}, // #11244
  {25,  3,   0}, // #11245
  {26,  4,   0}, // #11246
  { 8,  2,   0}, // #11247
  {13,  1,   0}, // #11248
  {15,  2,   0}, // #11249
  {17,  2,   0}, // #11250
  {19,  1,   0}, // #11251
  {21,  2,   0}, // #11252
  {23,  3,   0}, // #11253
  {24,  2,   0}, // #11254
  {25,  3,   0}, // #11255
  {26,  4,   0}, // #11256
  {17,  1,   0}, // #11257
  {20,  2,   0}, // #11258
  {22,  2,   0}, // #11259
  {23,  1,   0}, // #11260
  {25,  1,   0}, // #11261
  {26,  5,   0}, // #11262
  {13,  1,   0}, // #11263
  {20,  1,   0}, // #11264
  {22,  1,   0}, // #11265
  {23,  1,   0}, // #11266
  {25,  1,   0}, // #11267
  {26,  3,   0}, // #11268
  { 8,  2,   0}, // #11269
  {15,  2,   0}, // #11270
  {17,  2,   0}, // #11271
  {20,  1,   0}, // #11272
  {21,  2,   0}, // #11273
  {22,  1,   0}, // #11274
  {23,  2,   0}, // #11275
  {24,  2,   0}, // #11276
  {25,  2,   0}, // #11277
  {26,  4,   0}, // #11278
  { 8,  1,   0}, // #11279
  {15,  1,   0}, // #11280
  {17,  1,   0}, // #11281
  {19,  1,   0}, // #11282
  {21,  1,   0}, // #11283
  {23,  1,   0}, // #11284
  {24,  1,   0}, // #11285
  {25,  2,   0}, // #11286
  {26,  3,   0}, // #11287
  { 3,  1,   0}, // #11288
  {13,  1,   0}, // #11289
  {14,  1,   0}, // #11290
  {15,  1,   0}, // #11291
  {16,  1,   0}, // #11292
  {20,  2,   0}, // #11293
  {22,  2,   0}, // #11294
  {23,  1,   0}, // #11295
  {24,  1,   0}, // #11296
  {25,  3,   0}, // #11297
  {26,  7,   0}, // #11298
  { 3,  1,   0}, // #11299
  {13,  1,   0}, // #11300
  {14,  1,   0}, // #11301
  {15,  1,   0}, // #11302
  {16,  1,   0}, // #11303
  {20,  4,   0}, // #11304
  {22,  4,   0}, // #11305
  {23,  1,   0}, // #11306
  {24,  1,   0}, // #11307
  {25,  3,   0}, // #11308
  {26, 11,   0}, // #11309
  { 3,  1,   0}, // #11310
  {13,  1,   0}, // #11311
  {14,  1,   0}, // #11312
  {15,  1,   0}, // #11313
  {16,  1,   0}, // #11314
  {20,  8,   0}, // #11315
  {22,  8,   0}, // #11316
  {23,  1,   0}, // #11317
  {24,  1,   0}, // #11318
  {25,  3,   0}, // #11319
  {26, 19,   0}, // #11320
  { 3,  1,   0}, // #11321
  { 8,  1,   0}, // #11322
  {13,  1,   0}, // #11323
  {14,  1,   0}, // #11324
  {15,  2,   0}, // #11325
  {16,  1,   0}, // #11326
  {17,  1,   0}, // #11327
  {20, 16,   0}, // #11328
  {21,  1,   0}, // #11329
  {22, 16,   0}, // #11330
  {23,  2,   0}, // #11331
  {24,  2,   0}, // #11332
  {25,  4,   0}, // #11333
  {26, 36,   0}, // #11334
  { 3,  1,   0}, // #11335
  { 8,  1,   0}, // #11336
  {13,  1,   0}, // #11337
  {14,  1,   0}, // #11338
  {15,  2,   0}, // #11339
  {16,  1,   0}, // #11340
  {17,  1,   0}, // #11341
  {20,  2,   0}, // #11342
  {21,  1,   0}, // #11343
  {22,  2,   0}, // #11344
  {23,  2,   0}, // #11345
  {24,  2,   0}, // #11346
  {25,  4,   0}, // #11347
  {26,  8,   0}, // #11348
  { 3,  1,   0}, // #11349
  { 8,  1,   0}, // #11350
  {13,  1,   0}, // #11351
  {14,  1,   0}, // #11352
  {15,  2,   0}, // #11353
  {16,  1,   0}, // #11354
  {17,  1,   0}, // #11355
  {20,  4,   0}, // #11356
  {21,  1,   0}, // #11357
  {22,  4,   0}, // #11358
  {23,  2,   0}, // #11359
  {24,  2,   0}, // #11360
  {25,  4,   0}, // #11361
  {26, 12,   0}, // #11362
  { 3,  1,   0}, // #11363
  { 8,  1,   0}, // #11364
  {13,  1,   0}, // #11365
  {14,  1,   0}, // #11366
  {15,  2,   0}, // #11367
  {16,  1,   0}, // #11368
  {17,  1,   0}, // #11369
  {20,  8,   0}, // #11370
  {21,  1,   0}, // #11371
  {22,  8,   0}, // #11372
  {23,  2,   0}, // #11373
  {24,  2,   0}, // #11374
  {25,  4,   0}, // #11375
  {26, 20,   0}, // #11376
  {13,  3,   0}, // #11377
  {23,  3,   0}, // #11378
  {25,  3,   0}, // #11379
  {26,  3,   0}, // #11380
  { 3,  1,   0}, // #11381
  {13,  2,   0}, // #11382
  {14,  1,   0}, // #11383
  {15,  1,   0}, // #11384
  {16,  1,   0}, // #11385
  {19,  1,   0}, // #11386
  {23,  2,   0}, // #11387
  {24,  1,   0}, // #11388
  {25,  2,   0}, // #11389
  {26,  3,   0}, // #11390
  { 4,  1,   0}, // #11391
  { 8,  2,   0}, // #11392
  {13,  3,   0}, // #11393
  {15,  2,   0}, // #11394
  {17,  3,   0}, // #11395
  {18,  1,   0}, // #11396
  {19,  1,   0}, // #11397
  {21,  2,   0}, // #11398
  {23,  7,   0}, // #11399
  {24,  2,   0}, // #11400
  {25,  7,   0}, // #11401
  {26,  8,   0}, // #11402
  {13,  3,   0}, // #11403
  {19,  1,   0}, // #11404
  {23,  3,   0}, // #11405
  {25,  3,   0}, // #11406
  {26,  4,   0}, // #11407
  { 3,  1,   0}, // #11408
  {13,  1,   0}, // #11409
  {14,  1,   0}, // #11410
  {15,  1,   0}, // #11411
  {16,  1,   0}, // #11412
  {19,  2,   0}, // #11413
  {23,  2,   0}, // #11414
  {24,  1,   0}, // #11415
  {25,  3,   0}, // #11416
  {26,  5,   0}, // #11417
  { 3,  1,   0}, // #11418
  {13,  1,   0}, // #11419
  {14,  1,   0}, // #11420
  {15,  1,   0}, // #11421
  {16,  1,   0}, // #11422
  {19,  4,   0}, // #11423
  {23,  2,   0}, // #11424
  {24,  1,   0}, // #11425
  {25,  3,   0}, // #11426
  {26,  7,   0}, // #11427
  { 3,  1,   0}, // #11428
  {13,  1,   0}, // #11429
  {14,  1,   0}, // #11430
  {15,  1,   0}, // #11431
  {16,  1,   0}, // #11432
  {19,  8,   0}, // #11433
  {23,  2,   0}, // #11434
  {24,  1,   0}, // #11435
  {25,  3,   0}, // #11436
  {26, 11,   0}, // #11437
  { 3,  1,   0}, // #11438
  {13,  1,   0}, // #11439
  {14,  1,   0}, // #11440
  {15,  1,   0}, // #11441
  {16,  1,   0}, // #11442
  {19, 16,   0}, // #11443
  {23,  2,   0}, // #11444
  {24,  1,   0}, // #11445
  {25,  3,   0}, // #11446
  {26, 19,   0}, // #11447
  { 8,  5,   0}, // #11448
  {13,  5,   0}, // #11449
  {15,  5,   0}, // #11450
  {17,  5,   0}, // #11451
  {19,  1,   0}, // #11452
  {21,  5,   0}, // #11453
  {23, 14,   0}, // #11454
  {24,  5,   0}, // #11455
  {25, 14,   0}, // #11456
  {26, 15,   0}, // #11457
  { 8,  9,   0}, // #11458
  {13,  7,   0}, // #11459
  {15,  9,   0}, // #11460
  {17,  9,   0}, // #11461
  {19,  1,   0}, // #11462
  {21,  9,   0}, // #11463
  {23, 21,   0}, // #11464
  {24,  9,   0}, // #11465
  {25, 21,   0}, // #11466
  {26, 22,   0}, // #11467
  { 8, 17,   0}, // #11468
  {13, 11,   0}, // #11469
  {15, 17,   0}, // #11470
  {17, 17,   0}, // #11471
  {19,  1,   0}, // #11472
  {21, 17,   0}, // #11473
  {23, 35,   0}, // #11474
  {24, 17,   0}, // #11475
  {25, 35,   0}, // #11476
  {26, 36,   0}, // #11477
  {16,  2,   0}, // #11478
  {20,  1,   0}, // #11479
  {22,  1,   0}, // #11480
  {24,  2,   0}, // #11481
  {25,  2,   0}, // #11482
  {26,  4,   0}, // #11483
  { 3,  1,   0}, // #11484
  {11,  2,   0}, // #11485
  {12,  1,   0}, // #11486
  {13,  1,   0}, // #11487
  {14,  1,   0}, // #11488
  {19,  2,   0}, // #11489
  {20,  1,   0}, // #11490
  {22,  2,   0}, // #11491
  {23,  2,   0}, // #11492
  { 8,  1,   0}, // #11493
  {11,  2,   0}, // #11494
  {13,  1,   0}, // #11495
  {15,  1,   0}, // #11496
  {17,  1,   0}, // #11497
  {18,  1,   0}, // #11498
  {19,  3,   0}, // #11499
  {20,  1,   0}, // #11500
  {21,  1,   0}, // #11501
  {22,  3,   0}, // #11502
  {23,  4,   0}, // #11503
  { 8,  1,   0}, // #11504
  {11,  2,   0}, // #11505
  {13,  1,   0}, // #11506
  {15,  1,   0}, // #11507
  {18,  1,   0}, // #11508
  {19,  3,   0}, // #11509
  {20,  1,   0}, // #11510
  {22,  3,   0}, // #11511
  {23,  3,   0}, // #11512
  { 8,  1,   0}, // #11513
  {11,  3,   0}, // #11514
  {13,  1,   0}, // #11515
  {15,  1,   0}, // #11516
  {17,  1,   0}, // #11517
  {18,  1,   0}, // #11518
  {19,  4,   0}, // #11519
  {20,  1,   0}, // #11520
  {21,  1,   0}, // #11521
  {22,  4,   0}, // #11522
  {23,  5,   0}, // #11523
  { 8,  1,   0}, // #11524
  {11,  3,   0}, // #11525
  {13,  1,   0}, // #11526
  {15,  1,   0}, // #11527
  {18,  1,   0}, // #11528
  {19,  4,   0}, // #11529
  {20,  1,   0}, // #11530
  {22,  4,   0}, // #11531
  {23,  4,   0}, // #11532
  {22, 16,   0}, // #11533
  {23, 16,   0}, // #11534
  { 7,  1,   0}, // #11535
  { 9, 11,   0}, // #11536
  {12,  1,   0}, // #11537
  {14, 11,   0}, // #11538
  {16, 11,   0}, // #11539
  {17,  1,   0}, // #11540
  {18, 11,   0}, // #11541
  {20, 11,   0}, // #11542
  {21,  2,   0}, // #11543
  {22, 41,   0}, // #11544
  {23, 44,   0}, // #11545
  {11,  1,   0}, // #11546
  {22,  1,   0}, // #11547
  { 1,  1,   0}, // #11548
  { 4,  1,   0}, // #11549
  { 1,  2,   0}, // #11550
  { 4,  1,   0}, // #11551
  {11,  1,   0}, // #11552
  {15,  1,   0}, // #11553
  {18,  1,   0}, // #11554
  {20,  1,   0}, // #11555
  {21,  1,   0}, // #11556
  {22,  1,   0}, // #11557
  { 1,  1,   0}, // #11558
  {11,  1,   0}, // #11559
  {21,  1,   0}, // #11560
  { 1,  1,   0}, // #11561
  {11,  1,   0}, // #11562
  {16,  1,   0}, // #11563
  {22,  1,   0}, // #11564
  { 1,  1,   0}, // #11565
  { 4,  2,   0}, // #11566
  { 1,  1,   0}, // #11567
  { 4, 12,   0}, // #11568
  { 1,  1,   0}, // #11569
  { 4, 16,   0}, // #11570
  { 1,  1,   0}, // #11571
  {11,  2,   0}, // #11572
  {14,  1,   0}, // #11573
  {16,  1,   0}, // #11574
  {17,  1,   0}, // #11575
  {19,  1,   0}, // #11576
  {21,  1,   0}, // #11577
  {22,  1,   0}, // #11578
  { 1,  1,   0}, // #11579
  {11,  1,   0}, // #11580
  {12,  1,   0}, // #11581
  {16,  1,   0}, // #11582
  {17,  1,   0}, // #11583
  {18,  1,   0}, // #11584
  {22,  1,   0}, // #11585
  { 1,  1,   0}, // #11586
  {11,  1,   0}, // #11587
  {15,  1,   0}, // #11588
  {18,  1,   0}, // #11589
  {20,  1,   0}, // #11590
  {21,  1,   0}, // #11591
  {22,  1,   0}, // #11592
  { 1,  1,   0}, // #11593
  {11,  2,   0}, // #11594
  {15,  2,   0}, // #11595
  {18,  2,   0}, // #11596
  {20,  2,   0}, // #11597
  {21,  2,   0}, // #11598
  {22,  2,   0}, // #11599
  { 1,  1,   0}, // #11600
  { 4,  1,   0}, // #11601
  { 7,  1,   0}, // #11602
  {10, 17,   0}, // #11603
  { 1,  1,   0}, // #11604
  { 4,  1,   0}, // #11605
  { 7,  1,   0}, // #11606
  {10, 25,   0}, // #11607
  { 1,  1,   0}, // #11608
  { 4,  1,   0}, // #11609
  { 7,  1,   0}, // #11610
  {10, 41,   0}, // #11611
  { 1,  1,   0}, // #11612
  { 4,  1,   0}, // #11613
  { 7,  1,   0}, // #11614
  {10, 15,   0}, // #11615
  { 1,  1,   0}, // #11616
  {11,  5,   0}, // #11617
  {15,  5,   0}, // #11618
  {18,  5,   0}, // #11619
  {20,  5,   0}, // #11620
  {21,  5,   0}, // #11621
  {22,  5,   0}, // #11622
  { 1,  1,   0}, // #11623
  {11,  3,   0}, // #11624
  {15,  3,   0}, // #11625
  {18,  3,   0}, // #11626
  {20,  3,   0}, // #11627
  {21,  3,   0}, // #11628
  {22,  3,   0}, // #11629
  { 1,  1,   0}, // #11630
  {11,  5,   0}, // #11631
  {14,  3,   0}, // #11632
  {17,  3,   0}, // #11633
  {19,  5,   0}, // #11634
  {21,  3,   0}, // #11635
  {11,  3,   0}, // #11636
  {14,  2,   0}, // #11637
  {17,  2,   0}, // #11638
  {19,  3,   0}, // #11639
  {21,  2,   0}, // #11640
  { 1,  1,   0}, // #11641
  {11,  1,   0}, // #11642
  {22,  1,   0}, // #11643
  { 1,  1,   0}, // #11644
  { 4,  1,   0}, // #11645
  { 6,  1,   0}, // #11646
  {23,  1,   0}, // #11647
  { 1,  1,   0}, // #11648
  {11,  1,   0}, // #11649
  {19,  1,   0}, // #11650
  { 1,  1,   0}, // #11651
  {11,  1,   0}, // #11652
  {20,  1,   0}, // #11653
  {22,  1,   0}, // #11654
  {11,  1,   0}, // #11655
  {14,  1,   0}, // #11656
  {17,  1,   0}, // #11657
  {19,  1,   0}, // #11658
  {21,  1,   0}, // #11659
  { 1,  1,   0}, // #11660
  {11,  1,   0}, // #11661
  {14,  1,   0}, // #11662
  {17,  1,   0}, // #11663
  {19,  1,   0}, // #11664
  {21,  1,   0}, // #11665
  { 1,  1,   0}, // #11666
  { 4,  1,   0}, // #11667
  { 6,  1,   0}, // #11668
  {23,  2,   0}, // #11669
  { 1,  1,   0}, // #11670
  {11,  2,   0}, // #11671
  {12,  2,   0}, // #11672
  {16,  2,   0}, // #11673
  {17,  2,   0}, // #11674
  {18,  2,   0}, // #11675
  {22,  2,   0}, // #11676
  { 1,  1,   0}, // #11677
  {11,  2,   0}, // #11678
  {19,  2,   0}, // #11679
  { 1,  1,   0}, // #11680
  {11,  8,   0}, // #11681
  {15,  8,   0}, // #11682
  {18,  8,   0}, // #11683
  {20,  8,   0}, // #11684
  {21,  8,   0}, // #11685
  {22,  8,   0}, // #11686
  {11, 20,   0}, // #11687
  {15, 20,   0}, // #11688
  {18, 20,   0}, // #11689
  {20, 20,   0}, // #11690
  {21, 20,   0}, // #11691
  {22, 20,   0}, // #11692
  { 1,  1,   0}, // #11693
  {11,  2,   0}, // #11694
  {21,  2,   0}, // #11695
  { 1,  1,   0}, // #11696
  {11,  2,   0}, // #11697
  {16,  2,   0}, // #11698
  {22,  2,   0}, // #11699
  { 1,  1,   0}, // #11700
  {11,  9,   0}, // #11701
  {15,  9,   0}, // #11702
  {18,  9,   0}, // #11703
  {20,  9,   0}, // #11704
  {21,  9,   0}, // #11705
  {22,  9,   0}, // #11706
  { 1,  1,   0}, // #11707
  {11,  6,   0}, // #11708
  {15,  6,   0}, // #11709
  {18,  6,   0}, // #11710
  {20,  6,   0}, // #11711
  {21,  6,   0}, // #11712
  {22,  6,   0}, // #11713
  { 1,  1,   0}, // #11714
  {11,  2,   0}, // #11715
  {22,  2,   0}, // #11716
  { 1,  1,   0}, // #11717
  {11,  3,   0}, // #11718
  {16,  3,   0}, // #11719
  {22,  3,   0}, // #11720
  { 1,  1,   0}, // #11721
  {11,  4,   0}, // #11722
  {19,  4,   0}, // #11723
  {11,  2,   0}, // #11724
  {14,  2,   0}, // #11725
  {17,  2,   0}, // #11726
  {19,  2,   0}, // #11727
  {21,  2,   0}, // #11728
  { 1,  1,   0}, // #11729
  {11,  4,   0}, // #11730
  {12,  4,   0}, // #11731
  {16,  4,   0}, // #11732
  {17,  4,   0}, // #11733
  {18,  4,   0}, // #11734
  {22,  4,   0}, // #11735
  { 1,  1,   0}, // #11736
  {11,  2,   0}, // #11737
  {14,  2,   0}, // #11738
  {17,  2,   0}, // #11739
  {19,  2,   0}, // #11740
  {21,  2,   0}, // #11741
  { 1,  1,   0}, // #11742
  {11,  2,   0}, // #11743
  {13,  2,   0}, // #11744
  {16,  2,   0}, // #11745
  {19,  2,   0}, // #11746
  {20,  2,   0}, // #11747
  {22,  2,   0}, // #11748
  { 1,  1,   0}, // #11749
  {11,  4,   0}, // #11750
  {13,  4,   0}, // #11751
  {16,  4,   0}, // #11752
  {19,  4,   0}, // #11753
  {20,  4,   0}, // #11754
  {22,  4,   0}, // #11755
  { 1,  1,   0}, // #11756
  {11, 16,   0}, // #11757
  {15, 16,   0}, // #11758
  {18, 16,   0}, // #11759
  {20, 16,   0}, // #11760
  {21, 16,   0}, // #11761
  {22, 16,   0}, // #11762
  { 1,  1,   0}, // #11763
  {11, 10,   0}, // #11764
  {15, 10,   0}, // #11765
  {18, 10,   0}, // #11766
  {20, 10,   0}, // #11767
  {21, 10,   0}, // #11768
  {22, 10,   0}, // #11769
  {11,  2,   0}, // #11770
  {15,  1,   0}, // #11771
  {18,  1,   0}, // #11772
  {19,  1,   0}, // #11773
  {20,  1,   0}, // #11774
  {21,  1,   0}, // #11775
  {22,  1,   0}, // #11776
  { 1,  1,   0}, // #11777
  {11,  2,   0}, // #11778
  {15,  1,   0}, // #11779
  {18,  1,   0}, // #11780
  {19,  1,   0}, // #11781
  {20,  1,   0}, // #11782
  {21,  1,   0}, // #11783
  {22,  1,   0}, // #11784
  { 1,  1,   0}, // #11785
  {11,  1,   0}, // #11786
  {17,  1,   0}, // #11787
  { 1,  5,   0}, // #11788
  {11,  3,   0}, // #11789
  {14,  2,   0}, // #11790
  {17,  2,   0}, // #11791
  {19,  3,   0}, // #11792
  {21,  2,   0}, // #11793
  { 1,  1,   0}, // #11794
  {11,  1,   0}, // #11795
  {18,  1,   0}, // #11796
  {22,  1,   0}, // #11797
  { 1,  1,   0}, // #11798
  {11,  3,   0}, // #11799
  {18,  3,   0}, // #11800
  {22,  3,   0}, // #11801
  { 1,  1,   0}, // #11802
  {11,  2,   0}, // #11803
  {18,  2,   0}, // #11804
  {22,  2,   0}, // #11805
  { 1,  1,   0}, // #11806
  { 4,  1,   0}, // #11807
  { 9,  1,   0}, // #11808
  {11,  2,   0}, // #11809
  {15,  1,   0}, // #11810
  {18,  1,   0}, // #11811
  {20,  1,   0}, // #11812
  {21,  1,   0}, // #11813
  {22,  2,   0}, // #11814
  {11,  2,   0}, // #11815
  {14,  1,   0}, // #11816
  {15,  1,   0}, // #11817
  {17,  1,   0}, // #11818
  {18,  1,   0}, // #11819
  {19,  1,   0}, // #11820
  {20,  1,   0}, // #11821
  {21,  2,   0}, // #11822
  {22,  1,   0}, // #11823
  { 1,  1,   0}, // #11824
  {11,  2,   0}, // #11825
  {14,  1,   0}, // #11826
  {15,  1,   0}, // #11827
  {17,  1,   0}, // #11828
  {18,  1,   0}, // #11829
  {19,  1,   0}, // #11830
  {20,  1,   0}, // #11831
  {21,  2,   0}, // #11832
  {22,  1,   0}, // #11833
  {11,  2,   0}, // #11834
  {14,  1,   0}, // #11835
  {17,  1,   0}, // #11836
  {19,  2,   0}, // #11837
  {21,  1,   0}, // #11838
  {11,  2,   0}, // #11839
  {13,  1,   0}, // #11840
  {16,  1,   0}, // #11841
  {18,  1,   0}, // #11842
  {19,  1,   0}, // #11843
  {20,  1,   0}, // #11844
  {22,  2,   0}, // #11845
  {11,  1,   0}, // #11846
  {13,  1,   0}, // #11847
  {16,  1,   0}, // #11848
  {19,  1,   0}, // #11849
  {20,  1,   0}, // #11850
  {22,  1,   0}, // #11851
  { 1,  1,   0}, // #11852
  {11,  1,   0}, // #11853
  {13,  1,   0}, // #11854
  {16,  1,   0}, // #11855
  {19,  1,   0}, // #11856
  {20,  1,   0}, // #11857
  {22,  1,   0}, // #11858
  {12,  1,   0}, // #11859
  {23,  1,   0}, // #11860
  { 1,  2,   0}, // #11861
  { 5,  1,   0}, // #11862
  {12,  1,   0}, // #11863
  {16,  1,   0}, // #11864
  {19,  1,   0}, // #11865
  {21,  1,   0}, // #11866
  {22,  1,   0}, // #11867
  {23,  1,   0}, // #11868
  { 1,  1,   0}, // #11869
  {12,  1,   0}, // #11870
  {22,  1,   0}, // #11871
  { 1,  1,   0}, // #11872
  {12,  1,   0}, // #11873
  {17,  1,   0}, // #11874
  {23,  1,   0}, // #11875
  { 1,  1,   0}, // #11876
  { 5,  2,   0}, // #11877
  { 1,  1,   0}, // #11878
  { 5, 12,   0}, // #11879
  { 1,  1,   0}, // #11880
  { 5, 16,   0}, // #11881
  { 1,  1,   0}, // #11882
  {12,  2,   0}, // #11883
  {15,  1,   0}, // #11884
  {17,  1,   0}, // #11885
  {18,  1,   0}, // #11886
  {20,  1,   0}, // #11887
  {22,  1,   0}, // #11888
  {23,  1,   0}, // #11889
  { 1,  1,   0}, // #11890
  {12,  1,   0}, // #11891
  {13,  1,   0}, // #11892
  {17,  1,   0}, // #11893
  {18,  1,   0}, // #11894
  {19,  1,   0}, // #11895
  {23,  1,   0}, // #11896
  { 1,  1,   0}, // #11897
  {12,  1,   0}, // #11898
  {16,  1,   0}, // #11899
  {19,  1,   0}, // #11900
  {21,  1,   0}, // #11901
  {22,  1,   0}, // #11902
  {23,  1,   0}, // #11903
  { 1,  1,   0}, // #11904
  {12,  2,   0}, // #11905
  {16,  2,   0}, // #11906
  {19,  2,   0}, // #11907
  {21,  2,   0}, // #11908
  {22,  2,   0}, // #11909
  {23,  2,   0}, // #11910
  { 1,  1,   0}, // #11911
  { 5,  1,   0}, // #11912
  { 8,  1,   0}, // #11913
  {11, 17,   0}, // #11914
  { 1,  1,   0}, // #11915
  { 5,  1,   0}, // #11916
  { 8,  1,   0}, // #11917
  {11, 25,   0}, // #11918
  { 1,  1,   0}, // #11919
  { 5,  1,   0}, // #11920
  { 8,  1,   0}, // #11921
  {11, 41,   0}, // #11922
  { 1,  1,   0}, // #11923
  { 5,  1,   0}, // #11924
  { 8,  1,   0}, // #11925
  {11, 15,   0}, // #11926
  { 1,  1,   0}, // #11927
  {12,  6,   0}, // #11928
  {16,  6,   0}, // #11929
  {19,  6,   0}, // #11930
  {21,  6,   0}, // #11931
  {22,  6,   0}, // #11932
  {23,  6,   0}, // #11933
  { 1,  1,   0}, // #11934
  {12,  5,   0}, // #11935
  {16,  5,   0}, // #11936
  {19,  5,   0}, // #11937
  {21,  5,   0}, // #11938
  {22,  5,   0}, // #11939
  {23,  5,   0}, // #11940
  { 1,  1,   0}, // #11941
  {12,  5,   0}, // #11942
  {15,  3,   0}, // #11943
  {18,  3,   0}, // #11944
  {20,  5,   0}, // #11945
  {22,  3,   0}, // #11946
  {12,  3,   0}, // #11947
  {15,  2,   0}, // #11948
  {18,  2,   0}, // #11949
  {20,  3,   0}, // #11950
  {22,  2,   0}, // #11951
  { 1,  1,   0}, // #11952
  {12,  1,   0}, // #11953
  {23,  1,   0}, // #11954
  { 1,  1,   0}, // #11955
  { 5,  1,   0}, // #11956
  { 7,  1,   0}, // #11957
  {24,  1,   0}, // #11958
  { 1,  1,   0}, // #11959
  {12,  1,   0}, // #11960
  {20,  1,   0}, // #11961
  { 1,  1,   0}, // #11962
  {12,  1,   0}, // #11963
  {21,  1,   0}, // #11964
  {23,  1,   0}, // #11965
  {12,  1,   0}, // #11966
  {15,  1,   0}, // #11967
  {18,  1,   0}, // #11968
  {20,  1,   0}, // #11969
  {22,  1,   0}, // #11970
  { 1,  1,   0}, // #11971
  {12,  1,   0}, // #11972
  {15,  1,   0}, // #11973
  {18,  1,   0}, // #11974
  {20,  1,   0}, // #11975
  {22,  1,   0}, // #11976
  { 1,  1,   0}, // #11977
  { 5,  1,   0}, // #11978
  { 7,  1,   0}, // #11979
  {24,  2,   0}, // #11980
  { 1,  1,   0}, // #11981
  {12,  2,   0}, // #11982
  {13,  2,   0}, // #11983
  {17,  2,   0}, // #11984
  {18,  2,   0}, // #11985
  {19,  2,   0}, // #11986
  {23,  2,   0}, // #11987
  { 1,  1,   0}, // #11988
  {12,  2,   0}, // #11989
  {20,  2,   0}, // #11990
  { 1,  1,   0}, // #11991
  {12, 10,   0}, // #11992
  {16, 10,   0}, // #11993
  {19, 10,   0}, // #11994
  {21, 10,   0}, // #11995
  {22, 10,   0}, // #11996
  {23, 10,   0}, // #11997
  { 1,  1,   0}, // #11998
  {12,  7,   0}, // #11999
  {16,  7,   0}, // #12000
  {19,  7,   0}, // #12001
  {21,  7,   0}, // #12002
  {22,  7,   0}, // #12003
  {23,  7,   0}, // #12004
  {12, 20,   0}, // #12005
  {16, 20,   0}, // #12006
  {19, 20,   0}, // #12007
  {21, 20,   0}, // #12008
  {22, 20,   0}, // #12009
  {23, 20,   0}, // #12010
  { 1,  1,   0}, // #12011
  {12,  2,   0}, // #12012
  {17,  2,   0}, // #12013
  {23,  2,   0}, // #12014
  {12,  2,   0}, // #12015
  {15,  2,   0}, // #12016
  {18,  2,   0}, // #12017
  {20,  2,   0}, // #12018
  {22,  2,   0}, // #12019
  { 1,  1,   0}, // #12020
  {12,  2,   0}, // #12021
  {14,  2,   0}, // #12022
  {17,  2,   0}, // #12023
  {20,  2,   0}, // #12024
  {21,  2,   0}, // #12025
  {23,  2,   0}, // #12026
  {12,  2,   0}, // #12027
  {16,  1,   0}, // #12028
  {19,  1,   0}, // #12029
  {20,  1,   0}, // #12030
  {21,  1,   0}, // #12031
  {22,  1,   0}, // #12032
  {23,  1,   0}, // #12033
  { 1,  1,   0}, // #12034
  {12,  2,   0}, // #12035
  {16,  1,   0}, // #12036
  {19,  1,   0}, // #12037
  {20,  1,   0}, // #12038
  {21,  1,   0}, // #12039
  {22,  1,   0}, // #12040
  {23,  1,   0}, // #12041
  { 1,  1,   0}, // #12042
  {12,  1,   0}, // #12043
  {18,  1,   0}, // #12044
  { 1,  5,   0}, // #12045
  {12,  3,   0}, // #12046
  {15,  2,   0}, // #12047
  {18,  2,   0}, // #12048
  {20,  3,   0}, // #12049
  {22,  2,   0}, // #12050
  { 1,  1,   0}, // #12051
  {12,  1,   0}, // #12052
  {19,  1,   0}, // #12053
  {23,  1,   0}, // #12054
  { 1,  1,   0}, // #12055
  {12,  3,   0}, // #12056
  {19,  3,   0}, // #12057
  {23,  3,   0}, // #12058
  { 1,  1,   0}, // #12059
  {12,  3,   0}, // #12060
  {17,  3,   0}, // #12061
  {23,  3,   0}, // #12062
  { 1,  1,   0}, // #12063
  { 5,  1,   0}, // #12064
  {10,  1,   0}, // #12065
  {12,  2,   0}, // #12066
  {16,  1,   0}, // #12067
  {19,  1,   0}, // #12068
  {21,  1,   0}, // #12069
  {22,  1,   0}, // #12070
  {23,  2,   0}, // #12071
  {12,  2,   0}, // #12072
  {15,  1,   0}, // #12073
  {16,  1,   0}, // #12074
  {18,  1,   0}, // #12075
  {19,  1,   0}, // #12076
  {20,  1,   0}, // #12077
  {21,  1,   0}, // #12078
  {22,  2,   0}, // #12079
  {23,  1,   0}, // #12080
  { 1,  1,   0}, // #12081
  {12,  2,   0}, // #12082
  {15,  1,   0}, // #12083
  {16,  1,   0}, // #12084
  {18,  1,   0}, // #12085
  {19,  1,   0}, // #12086
  {20,  1,   0}, // #12087
  {21,  1,   0}, // #12088
  {22,  2,   0}, // #12089
  {23,  1,   0}, // #12090
  {12,  2,   0}, // #12091
  {15,  1,   0}, // #12092
  {18,  1,   0}, // #12093
  {20,  2,   0}, // #12094
  {22,  1,   0}, // #12095
  {12,  2,   0}, // #12096
  {14,  1,   0}, // #12097
  {17,  1,   0}, // #12098
  {19,  1,   0}, // #12099
  {20,  1,   0}, // #12100
  {21,  1,   0}, // #12101
  {23,  2,   0}, // #12102
  {12,  1,   0}, // #12103
  {14,  1,   0}, // #12104
  {17,  1,   0}, // #12105
  {20,  1,   0}, // #12106
  {21,  1,   0}, // #12107
  {23,  1,   0}, // #12108
  { 1,  1,   0}, // #12109
  {12,  1,   0}, // #12110
  {14,  1,   0}, // #12111
  {17,  1,   0}, // #12112
  {20,  1,   0}, // #12113
  {21,  1,   0}, // #12114
  {23,  1,   0}, // #12115
  {11,  1,   0}, // #12116
  {36,  1,   0}, // #12117
  {11,  0,   0}, // #12118
  {36,  0,   0}, // #12119
  {14,  1,   0}, // #12120
  {20,  1,   0}, // #12121
  {28,  1,   0}, // #12122
  {31,  1,   0}, // #12123
  {32,  1,   0}, // #12124
  {13,  1,   0}, // #12125
  {36,  1,   0}, // #12126
  {11, 12,   0}, // #12127
  {36, 12,   0}, // #12128
  { 4,  1,   0}, // #12129
  {13,  1,   0}, // #12130
  {36,  2,   0}, // #12131
  {37,  1,   0}, // #12132
  {38,  1,   0}, // #12133
  {11,  4,   0}, // #12134
  {36,  4,   0}, // #12135
  {11, 100,   0}, // #12136
  {36, 100,   0}, // #12137
  { 4,  1,   0}, // #12138
  {36,  1,   0}, // #12139
  { 4,  1,   0}, // #12140
  {36,  1,   0}, // #12141
  {37,  1,   0}, // #12142
  {39,  1,   0}, // #12143
  {10,  3,   0}, // #12144
  {11,  3,   0}, // #12145
  {36,  3,   0}, // #12146
  {26,  1,   0}, // #12147
  {27,  1,   0}, // #12148
  {37,  1,   0}, // #12149
  {39,  1,   0}, // #12150
  {14,  1,   0}, // #12151
  {26,  1,   0}, // #12152
  {37,  1,   0}, // #12153
  {38,  1,   0}, // #12154
  { 4,  2,   0}, // #12155
  {11,  1,   0}, // #12156
  {36,  3,   0}, // #12157
  {37,  2,   0}, // #12158
  {38,  1,   0}, // #12159
  {39,  1,   0}, // #12160
  {14,  2,   0}, // #12161
  {15,  2,   0}, // #12162
  {16,  2,   0}, // #12163
  {20,  2,   0}, // #12164
  {21,  2,   0}, // #12165
  {28,  2,   0}, // #12166
  {29,  2,   0}, // #12167
  {31,  2,   0}, // #12168
  {32,  2,   0}, // #12169
  { 4,  2,   0}, // #12170
  {11,  4,   0}, // #12171
  {36,  6,   0}, // #12172
  {37,  2,   0}, // #12173
  {38,  1,   0}, // #12174
  {39,  1,   0}, // #12175
  { 4,  1,   0}, // #12176
  {11,  4,   0}, // #12177
  {36,  5,   0}, // #12178
  {37,  1,   0}, // #12179
  {38,  1,   0}, // #12180
  { 4,  1,   0}, // #12181
  {11,  1,   0}, // #12182
  {36,  2,   0}, // #12183
  {37,  1,   0}, // #12184
  {38,  1,   0}, // #12185
  {14,  2,   0}, // #12186
  {17,  1,   0}, // #12187
  {18,  1,   0}, // #12188
  {20,  1,   0}, // #12189
  {26,  1,   0}, // #12190
  {28,  1,   0}, // #12191
  {31,  1,   0}, // #12192
  {32,  1,   0}, // #12193
  {37,  1,   0}, // #12194
  {38,  1,   0}, // #12195
  {14,  1,   0}, // #12196
  {17,  1,   0}, // #12197
  {18,  1,   0}, // #12198
  {20,  1,   0}, // #12199
  {28,  1,   0}, // #12200
  {31,  1,   0}, // #12201
  {32,  1,   0}, // #12202
  {14,  2,   0}, // #12203
  {15,  1,   0}, // #12204
  {16,  1,   0}, // #12205
  {20,  1,   0}, // #12206
  {21,  1,   0}, // #12207
  {26,  1,   0}, // #12208
  {28,  1,   0}, // #12209
  {29,  1,   0}, // #12210
  {31,  1,   0}, // #12211
  {32,  1,   0}, // #12212
  {37,  1,   0}, // #12213
  {38,  1,   0}, // #12214
  {14,  1,   0}, // #12215
  {15,  1,   0}, // #12216
  {16,  1,   0}, // #12217
  {20,  1,   0}, // #12218
  {21,  1,   0}, // #12219
  {28,  1,   0}, // #12220
  {29,  1,   0}, // #12221
  {31,  1,   0}, // #12222
  {32,  1,   0}, // #12223
  {14,  2,   0}, // #12224
  {20,  1,   0}, // #12225
  {26,  1,   0}, // #12226
  {28,  1,   0}, // #12227
  {31,  1,   0}, // #12228
  {32,  1,   0}, // #12229
  {37,  1,   0}, // #12230
  {38,  1,   0}, // #12231
  { 4,  1,   0}, // #12232
  {10,  1,   0}, // #12233
  {11,  1,   0}, // #12234
  {36,  2,   0}, // #12235
  {37,  1,   0}, // #12236
  {38,  1,   0}, // #12237
  {10,  1,   0}, // #12238
  {11,  1,   0}, // #12239
  {36,  1,   0}, // #12240
  { 4,  1,   0}, // #12241
  {11,  2,   0}, // #12242
  {36,  3,   0}, // #12243
  {37,  1,   0}, // #12244
  {38,  1,   0}, // #12245
  {11,  2,   0}, // #12246
  {36,  2,   0}, // #12247
  { 4,  1,   0}, // #12248
  { 6,  3,   0}, // #12249
  {10,  3,   0}, // #12250
  {11,  3,   0}, // #12251
  {36,  4,   0}, // #12252
  {37,  1,   0}, // #12253
  {38,  1,   0}, // #12254
  { 6,  3,   0}, // #12255
  {10,  3,   0}, // #12256
  {11,  3,   0}, // #12257
  {36,  3,   0}, // #12258
  { 4,  1,   0}, // #12259
  { 6,  4,   0}, // #12260
  {10,  4,   0}, // #12261
  {11,  4,   0}, // #12262
  {36,  5,   0}, // #12263
  {37,  1,   0}, // #12264
  {38,  1,   0}, // #12265
  { 6,  4,   0}, // #12266
  {10,  4,   0}, // #12267
  {11,  4,   0}, // #12268
  {36,  4,   0}, // #12269
  { 4,  2,   0}, // #12270
  {10,  1,   0}, // #12271
  {11,  1,   0}, // #12272
  {36,  3,   0}, // #12273
  {37,  2,   0}, // #12274
  {38,  1,   0}, // #12275
  {39,  1,   0}, // #12276
  {10,  2,   0}, // #12277
  {11,  2,   0}, // #12278
  {36,  2,   0}, // #12279
  { 4,  1,   0}, // #12280
  {36,  1,   0}, // #12281
  {37,  1,   0}, // #12282
  {38,  1,   0}, // #12283
  { 4,  1,   0}, // #12284
  { 9,  1,   0}, // #12285
  {11,  1,   0}, // #12286
  {36,  2,   0}, // #12287
  {37,  1,   0}, // #12288
  {38,  1,   0}, // #12289
  { 9,  1,   0}, // #12290
  {11,  1,   0}, // #12291
  {36,  1,   0}, // #12292
  {11, 28,   0}, // #12293
  {36, 28,   0}, // #12294
  {11,  8,   0}, // #12295
  {36,  8,   0}, // #12296
  {14,  3,   0}, // #12297
  {15,  2,   0}, // #12298
  {16,  2,   0}, // #12299
  {20,  2,   0}, // #12300
  {21,  2,   0}, // #12301
  {26,  1,   0}, // #12302
  {28,  2,   0}, // #12303
  {29,  2,   0}, // #12304
  {31,  2,   0}, // #12305
  {32,  2,   0}, // #12306
  {37,  1,   0}, // #12307
  {38,  1,   0}, // #12308
  { 4,  1,   0}, // #12309
  { 6,  1,   0}, // #12310
  {10,  1,   0}, // #12311
  {11,  1,   0}, // #12312
  {36,  2,   0}, // #12313
  {37,  1,   0}, // #12314
  {38,  1,   0}, // #12315
  { 6,  1,   0}, // #12316
  {10,  1,   0}, // #12317
  {11,  1,   0}, // #12318
  {36,  1,   0}, // #12319
  {14,  3,   0}, // #12320
  {17,  2,   0}, // #12321
  {18,  2,   0}, // #12322
  {20,  2,   0}, // #12323
  {26,  1,   0}, // #12324
  {28,  2,   0}, // #12325
  {31,  2,   0}, // #12326
  {32,  2,   0}, // #12327
  {37,  1,   0}, // #12328
  {38,  1,   0}, // #12329
  {14,  2,   0}, // #12330
  {17,  2,   0}, // #12331
  {18,  2,   0}, // #12332
  {20,  2,   0}, // #12333
  {28,  2,   0}, // #12334
  {31,  2,   0}, // #12335
  {32,  2,   0}, // #12336
  { 4,  1,   0}, // #12337
  { 5, 11,   0}, // #12338
  { 9, 11,   0}, // #12339
  {11, 11,   0}, // #12340
  {13, 11,   0}, // #12341
  {36, 12,   0}, // #12342
  {37,  1,   0}, // #12343
  {38,  1,   0}, // #12344
  { 5, 11,   0}, // #12345
  { 9, 11,   0}, // #12346
  {11, 11,   0}, // #12347
  {13, 11,   0}, // #12348
  {36, 11,   0}, // #12349
  { 4,  1,   0}, // #12350
  { 5, 13,   0}, // #12351
  { 9, 13,   0}, // #12352
  {11, 13,   0}, // #12353
  {13, 13,   0}, // #12354
  {36, 14,   0}, // #12355
  {37,  1,   0}, // #12356
  {38,  1,   0}, // #12357
  { 5, 13,   0}, // #12358
  { 9, 13,   0}, // #12359
  {11, 13,   0}, // #12360
  {13, 13,   0}, // #12361
  {36, 13,   0}, // #12362
  { 4,  1,   0}, // #12363
  { 5, 17,   0}, // #12364
  { 9, 17,   0}, // #12365
  {11, 17,   0}, // #12366
  {13, 17,   0}, // #12367
  {36, 18,   0}, // #12368
  {37,  1,   0}, // #12369
  {38,  1,   0}, // #12370
  { 5, 17,   0}, // #12371
  { 9, 17,   0}, // #12372
  {11, 17,   0}, // #12373
  {13, 17,   0}, // #12374
  {36, 17,   0}, // #12375
  { 4,  1,   0}, // #12376
  { 5, 10,   0}, // #12377
  { 9, 10,   0}, // #12378
  {11, 10,   0}, // #12379
  {13, 10,   0}, // #12380
  {36, 11,   0}, // #12381
  {37,  1,   0}, // #12382
  {38,  1,   0}, // #12383
  { 5, 10,   0}, // #12384
  { 9, 10,   0}, // #12385
  {11, 10,   0}, // #12386
  {13, 10,   0}, // #12387
  {36, 10,   0}, // #12388
  {14,  6,   0}, // #12389
  {15,  5,   0}, // #12390
  {16,  5,   0}, // #12391
  {19,  5,   0}, // #12392
  {20,  5,   0}, // #12393
  {21,  5,   0}, // #12394
  {23,  5,   0}, // #12395
  {26,  1,   0}, // #12396
  {28,  5,   0}, // #12397
  {29,  5,   0}, // #12398
  {30,  5,   0}, // #12399
  {31,  5,   0}, // #12400
  {32,  5,   0}, // #12401
  {34,  5,   0}, // #12402
  {35,  5,   0}, // #12403
  {37,  1,   0}, // #12404
  {38,  1,   0}, // #12405
  {14,  5,   0}, // #12406
  {15,  5,   0}, // #12407
  {16,  5,   0}, // #12408
  {19,  5,   0}, // #12409
  {20,  5,   0}, // #12410
  {21,  5,   0}, // #12411
  {23,  5,   0}, // #12412
  {28,  5,   0}, // #12413
  {29,  5,   0}, // #12414
  {30,  5,   0}, // #12415
  {31,  5,   0}, // #12416
  {32,  5,   0}, // #12417
  {34,  5,   0}, // #12418
  {35,  5,   0}, // #12419
  {14,  4,   0}, // #12420
  {15,  3,   0}, // #12421
  {16,  3,   0}, // #12422
  {19,  3,   0}, // #12423
  {20,  3,   0}, // #12424
  {21,  3,   0}, // #12425
  {23,  3,   0}, // #12426
  {26,  1,   0}, // #12427
  {28,  3,   0}, // #12428
  {29,  3,   0}, // #12429
  {30,  3,   0}, // #12430
  {31,  3,   0}, // #12431
  {32,  3,   0}, // #12432
  {34,  3,   0}, // #12433
  {35,  3,   0}, // #12434
  {37,  1,   0}, // #12435
  {38,  1,   0}, // #12436
  {14,  3,   0}, // #12437
  {15,  3,   0}, // #12438
  {16,  3,   0}, // #12439
  {19,  3,   0}, // #12440
  {20,  3,   0}, // #12441
  {21,  3,   0}, // #12442
  {23,  3,   0}, // #12443
  {28,  3,   0}, // #12444
  {29,  3,   0}, // #12445
  {30,  3,   0}, // #12446
  {31,  3,   0}, // #12447
  {32,  3,   0}, // #12448
  {34,  3,   0}, // #12449
  {35,  3,   0}, // #12450
  {14,  7,   0}, // #12451
  {15,  6,   0}, // #12452
  {16,  6,   0}, // #12453
  {20,  6,   0}, // #12454
  {21,  6,   0}, // #12455
  {26,  1,   0}, // #12456
  {28,  6,   0}, // #12457
  {29,  6,   0}, // #12458
  {31,  6,   0}, // #12459
  {32,  6,   0}, // #12460
  {37,  1,   0}, // #12461
  {38,  1,   0}, // #12462
  {14,  6,   0}, // #12463
  {15,  6,   0}, // #12464
  {16,  6,   0}, // #12465
  {20,  6,   0}, // #12466
  {21,  6,   0}, // #12467
  {28,  6,   0}, // #12468
  {29,  6,   0}, // #12469
  {31,  6,   0}, // #12470
  {32,  6,   0}, // #12471
  {14,  9,   0}, // #12472
  {15,  8,   0}, // #12473
  {16,  8,   0}, // #12474
  {20,  8,   0}, // #12475
  {21,  8,   0}, // #12476
  {26,  1,   0}, // #12477
  {28,  8,   0}, // #12478
  {29,  8,   0}, // #12479
  {31,  8,   0}, // #12480
  {32,  8,   0}, // #12481
  {37,  1,   0}, // #12482
  {38,  1,   0}, // #12483
  {14,  8,   0}, // #12484
  {15,  8,   0}, // #12485
  {16,  8,   0}, // #12486
  {20,  8,   0}, // #12487
  {21,  8,   0}, // #12488
  {28,  8,   0}, // #12489
  {29,  8,   0}, // #12490
  {31,  8,   0}, // #12491
  {32,  8,   0}, // #12492
  { 4,  1,   0}, // #12493
  {36,  1,   0}, // #12494
  {37,  2,   0}, // #12495
  {39,  2,   0}, // #12496
  {14,  2,   0}, // #12497
  {26,  2,   0}, // #12498
  {14,  2,   0}, // #12499
  {15,  1,   0}, // #12500
  {16,  1,   0}, // #12501
  {19,  1,   0}, // #12502
  {20,  1,   0}, // #12503
  {21,  1,   0}, // #12504
  {23,  1,   0}, // #12505
  {26,  1,   0}, // #12506
  {28,  1,   0}, // #12507
  {29,  1,   0}, // #12508
  {30,  1,   0}, // #12509
  {31,  1,   0}, // #12510
  {32,  1,   0}, // #12511
  {34,  1,   0}, // #12512
  {35,  1,   0}, // #12513
  {37,  1,   0}, // #12514
  {38,  1,   0}, // #12515
  {14,  2,   0}, // #12516
  {20,  1,   0}, // #12517
  {26,  1,   0}, // #12518
  {28,  1,   0}, // #12519
  {31,  1,   0}, // #12520
  {32,  1,   0}, // #12521
  {33,  1,   0}, // #12522
  {37,  1,   0}, // #12523
  {38,  1,   0}, // #12524
  {14,  1,   0}, // #12525
  {20,  1,   0}, // #12526
  {28,  1,   0}, // #12527
  {31,  1,   0}, // #12528
  {32,  1,   0}, // #12529
  {33,  1,   0}, // #12530
  {14,  3,   0}, // #12531
  {17,  2,   0}, // #12532
  {18,  2,   0}, // #12533
  {19,  2,   0}, // #12534
  {20,  2,   0}, // #12535
  {24,  2,   0}, // #12536
  {26,  1,   0}, // #12537
  {28,  2,   0}, // #12538
  {30,  2,   0}, // #12539
  {31,  2,   0}, // #12540
  {32,  2,   0}, // #12541
  {34,  2,   0}, // #12542
  {35,  2,   0}, // #12543
  {37,  1,   0}, // #12544
  {38,  1,   0}, // #12545
  {14,  2,   0}, // #12546
  {17,  2,   0}, // #12547
  {18,  2,   0}, // #12548
  {19,  2,   0}, // #12549
  {20,  2,   0}, // #12550
  {24,  2,   0}, // #12551
  {28,  2,   0}, // #12552
  {30,  2,   0}, // #12553
  {31,  2,   0}, // #12554
  {32,  2,   0}, // #12555
  {34,  2,   0}, // #12556
  {35,  2,   0}, // #12557
  {14,  2,   0}, // #12558
  {19,  1,   0}, // #12559
  {20,  1,   0}, // #12560
  {26,  1,   0}, // #12561
  {28,  1,   0}, // #12562
  {30,  1,   0}, // #12563
  {31,  1,   0}, // #12564
  {32,  1,   0}, // #12565
  {34,  1,   0}, // #12566
  {35,  1,   0}, // #12567
  {37,  1,   0}, // #12568
  {38,  1,   0}, // #12569
  {14,  1,   0}, // #12570
  {19,  1,   0}, // #12571
  {20,  1,   0}, // #12572
  {28,  1,   0}, // #12573
  {30,  1,   0}, // #12574
  {31,  1,   0}, // #12575
  {32,  1,   0}, // #12576
  {34,  1,   0}, // #12577
  {35,  1,   0}, // #12578
  { 8,  1,   0}, // #12579
  { 9,  1,   0}, // #12580
  {11,  1,   0}, // #12581
  {36,  1,   0}, // #12582
  { 4,  1,   0}, // #12583
  {11,  6,   0}, // #12584
  {36,  7,   0}, // #12585
  {37,  1,   0}, // #12586
  {38,  1,   0}, // #12587
  {14,  3,   0}, // #12588
  {15,  2,   0}, // #12589
  {16,  2,   0}, // #12590
  {20,  2,   0}, // #12591
  {21,  2,   0}, // #12592
  {22,  2,   0}, // #12593
  {26,  1,   0}, // #12594
  {28,  2,   0}, // #12595
  {29,  2,   0}, // #12596
  {31,  2,   0}, // #12597
  {32,  2,   0}, // #12598
  {33,  2,   0}, // #12599
  {37,  1,   0}, // #12600
  {38,  1,   0}, // #12601
  {14,  2,   0}, // #12602
  {15,  2,   0}, // #12603
  {16,  2,   0}, // #12604
  {20,  2,   0}, // #12605
  {21,  2,   0}, // #12606
  {22,  2,   0}, // #12607
  {28,  2,   0}, // #12608
  {29,  2,   0}, // #12609
  {31,  2,   0}, // #12610
  {32,  2,   0}, // #12611
  {33,  2,   0}, // #12612
  {14,  3,   0}, // #12613
  {26,  3,   0}, // #12614
  {37,  1,   0}, // #12615
  {38,  1,   0}, // #12616
  {14,  1,   0}, // #12617
  {17,  1,   0}, // #12618
  {18,  1,   0}, // #12619
  {19,  1,   0}, // #12620
  {20,  1,   0}, // #12621
  {24,  1,   0}, // #12622
  {28,  1,   0}, // #12623
  {30,  1,   0}, // #12624
  {31,  1,   0}, // #12625
  {32,  1,   0}, // #12626
  {34,  1,   0}, // #12627
  {35,  1,   0}, // #12628
  {14,  3,   0}, // #12629
  {20,  2,   0}, // #12630
  {26,  1,   0}, // #12631
  {28,  2,   0}, // #12632
  {31,  2,   0}, // #12633
  {32,  2,   0}, // #12634
  {37,  1,   0}, // #12635
  {38,  1,   0}, // #12636
  {14,  2,   0}, // #12637
  {20,  2,   0}, // #12638
  {28,  2,   0}, // #12639
  {31,  2,   0}, // #12640
  {32,  2,   0}, // #12641
  {14,  9,   0}, // #12642
  {20,  8,   0}, // #12643
  {26,  1,   0}, // #12644
  {28,  8,   0}, // #12645
  {31,  8,   0}, // #12646
  {32,  8,   0}, // #12647
  {37,  1,   0}, // #12648
  {38,  1,   0}, // #12649
  {14,  8,   0}, // #12650
  {20,  8,   0}, // #12651
  {28,  8,   0}, // #12652
  {31,  8,   0}, // #12653
  {32,  8,   0}, // #12654
  {14,  5,   0}, // #12655
  {15,  4,   0}, // #12656
  {16,  4,   0}, // #12657
  {20,  4,   0}, // #12658
  {21,  4,   0}, // #12659
  {26,  1,   0}, // #12660
  {28,  4,   0}, // #12661
  {29,  4,   0}, // #12662
  {31,  4,   0}, // #12663
  {32,  4,   0}, // #12664
  {37,  1,   0}, // #12665
  {38,  1,   0}, // #12666
  {14,  4,   0}, // #12667
  {15,  4,   0}, // #12668
  {16,  4,   0}, // #12669
  {20,  4,   0}, // #12670
  {21,  4,   0}, // #12671
  {28,  4,   0}, // #12672
  {29,  4,   0}, // #12673
  {31,  4,   0}, // #12674
  {32,  4,   0}, // #12675
  {14, 13,   0}, // #12676
  {20, 12,   0}, // #12677
  {26,  1,   0}, // #12678
  {28, 12,   0}, // #12679
  {31, 12,   0}, // #12680
  {32, 12,   0}, // #12681
  {37,  1,   0}, // #12682
  {38,  1,   0}, // #12683
  {14, 12,   0}, // #12684
  {20, 12,   0}, // #12685
  {28, 12,   0}, // #12686
  {31, 12,   0}, // #12687
  {32, 12,   0}, // #12688
  { 4,  2,   0}, // #12689
  {36,  2,   0}, // #12690
  {37,  3,   0}, // #12691
  {38,  1,   0}, // #12692
  {39,  2,   0}, // #12693
  {14,  2,   0}, // #12694
  {19,  1,   0}, // #12695
  {20,  1,   0}, // #12696
  {26,  2,   0}, // #12697
  {27,  1,   0}, // #12698
  {28,  1,   0}, // #12699
  {30,  1,   0}, // #12700
  {31,  1,   0}, // #12701
  {32,  1,   0}, // #12702
  {34,  1,   0}, // #12703
  {35,  1,   0}, // #12704
  {37,  1,   0}, // #12705
  {38,  1,   0}, // #12706
  {14,  1,   0}, // #12707
  {19,  1,   0}, // #12708
  {20,  1,   0}, // #12709
  {26,  1,   0}, // #12710
  {27,  1,   0}, // #12711
  {28,  1,   0}, // #12712
  {30,  1,   0}, // #12713
  {31,  1,   0}, // #12714
  {32,  1,   0}, // #12715
  {34,  1,   0}, // #12716
  {35,  1,   0}, // #12717
  { 4,  1,   0}, // #12718
  {10,  2,   0}, // #12719
  {11,  2,   0}, // #12720
  {36,  3,   0}, // #12721
  {37,  1,   0}, // #12722
  {38,  1,   0}, // #12723
  {14,  1,   0}, // #12724
  {15,  1,   0}, // #12725
  {16,  1,   0}, // #12726
  {19,  1,   0}, // #12727
  {20,  1,   0}, // #12728
  {21,  1,   0}, // #12729
  {23,  1,   0}, // #12730
  {28,  1,   0}, // #12731
  {29,  1,   0}, // #12732
  {30,  1,   0}, // #12733
  {31,  1,   0}, // #12734
  {32,  1,   0}, // #12735
  {34,  1,   0}, // #12736
  {35,  1,   0}, // #12737
  { 4,  1,   0}, // #12738
  { 9,  2,   0}, // #12739
  {11,  2,   0}, // #12740
  {36,  3,   0}, // #12741
  {37,  1,   0}, // #12742
  {39,  1,   0}, // #12743
  { 9,  2,   0}, // #12744
  {11,  2,   0}, // #12745
  {36,  2,   0}, // #12746
  { 4,  1,   0}, // #12747
  {10,  4,   0}, // #12748
  {11,  4,   0}, // #12749
  {36,  5,   0}, // #12750
  {37,  1,   0}, // #12751
  {38,  1,   0}, // #12752
  {14, 10,   0}, // #12753
  {15,  9,   0}, // #12754
  {16,  9,   0}, // #12755
  {19,  9,   0}, // #12756
  {20,  9,   0}, // #12757
  {21,  9,   0}, // #12758
  {23,  9,   0}, // #12759
  {26,  1,   0}, // #12760
  {28,  9,   0}, // #12761
  {29,  9,   0}, // #12762
  {30,  9,   0}, // #12763
  {31,  9,   0}, // #12764
  {32,  9,   0}, // #12765
  {34,  9,   0}, // #12766
  {35,  9,   0}, // #12767
  {37,  1,   0}, // #12768
  {38,  1,   0}, // #12769
  {14,  9,   0}, // #12770
  {15,  9,   0}, // #12771
  {16,  9,   0}, // #12772
  {19,  9,   0}, // #12773
  {20,  9,   0}, // #12774
  {21,  9,   0}, // #12775
  {23,  9,   0}, // #12776
  {28,  9,   0}, // #12777
  {29,  9,   0}, // #12778
  {30,  9,   0}, // #12779
  {31,  9,   0}, // #12780
  {32,  9,   0}, // #12781
  {34,  9,   0}, // #12782
  {35,  9,   0}, // #12783
  {14, 23,   0}, // #12784
  {15, 23,   0}, // #12785
  {16, 23,   0}, // #12786
  {19, 23,   0}, // #12787
  {20, 23,   0}, // #12788
  {21, 23,   0}, // #12789
  {23, 23,   0}, // #12790
  {28, 23,   0}, // #12791
  {29, 23,   0}, // #12792
  {30, 23,   0}, // #12793
  {31, 23,   0}, // #12794
  {32, 23,   0}, // #12795
  {34, 23,   0}, // #12796
  {35, 23,   0}, // #12797
  { 4,  1,   0}, // #12798
  {11, 60,   0}, // #12799
  {36, 61,   0}, // #12800
  {37,  1,   0}, // #12801
  {39,  1,   0}, // #12802
  {14,  2,   0}, // #12803
  {17,  2,   0}, // #12804
  {18,  2,   0}, // #12805
  {20,  2,   0}, // #12806
  {26,  1,   0}, // #12807
  {27,  1,   0}, // #12808
  {28,  2,   0}, // #12809
  {31,  2,   0}, // #12810
  {32,  2,   0}, // #12811
  {37,  1,   0}, // #12812
  {39,  1,   0}, // #12813
  {14,  1,   0}, // #12814
  {17,  1,   0}, // #12815
  {18,  1,   0}, // #12816
  {20,  1,   0}, // #12817
  {26,  1,   0}, // #12818
  {27,  1,   0}, // #12819
  {28,  1,   0}, // #12820
  {31,  1,   0}, // #12821
  {32,  1,   0}, // #12822
  {37,  1,   0}, // #12823
  {39,  1,   0}, // #12824
  {26,  6,   0}, // #12825
  {27,  6,   0}, // #12826
  {37,  1,   0}, // #12827
  {39,  1,   0}, // #12828
  {26,  4,   0}, // #12829
  {27,  4,   0}, // #12830
  {37,  1,   0}, // #12831
  {39,  1,   0}, // #12832
  {26, 12,   0}, // #12833
  {27, 12,   0}, // #12834
  {37,  1,   0}, // #12835
  {39,  1,   0}, // #12836
  {14,  4,   0}, // #12837
  {19,  3,   0}, // #12838
  {20,  3,   0}, // #12839
  {26,  1,   0}, // #12840
  {28,  3,   0}, // #12841
  {30,  3,   0}, // #12842
  {31,  3,   0}, // #12843
  {32,  3,   0}, // #12844
  {34,  3,   0}, // #12845
  {35,  3,   0}, // #12846
  {37,  1,   0}, // #12847
  {38,  1,   0}, // #12848
  {14,  3,   0}, // #12849
  {19,  3,   0}, // #12850
  {20,  3,   0}, // #12851
  {28,  3,   0}, // #12852
  {30,  3,   0}, // #12853
  {31,  3,   0}, // #12854
  {32,  3,   0}, // #12855
  {34,  3,   0}, // #12856
  {35,  3,   0}, // #12857
  {14,  3,   0}, // #12858
  {19,  2,   0}, // #12859
  {20,  2,   0}, // #12860
  {26,  1,   0}, // #12861
  {28,  2,   0}, // #12862
  {30,  2,   0}, // #12863
  {31,  2,   0}, // #12864
  {32,  2,   0}, // #12865
  {34,  2,   0}, // #12866
  {35,  2,   0}, // #12867
  {37,  1,   0}, // #12868
  {38,  1,   0}, // #12869
  {14,  2,   0}, // #12870
  {19,  2,   0}, // #12871
  {20,  2,   0}, // #12872
  {28,  2,   0}, // #12873
  {30,  2,   0}, // #12874
  {31,  2,   0}, // #12875
  {32,  2,   0}, // #12876
  {34,  2,   0}, // #12877
  {35,  2,   0}, // #12878
  {37, 30,   0}, // #12879
  { 4,  3,   0}, // #12880
  {36,  3,   0}, // #12881
  {37,  1,   0}, // #12882
  {38,  1,   0}, // #12883
  { 4,  1,   0}, // #12884
  {11, 12,   0}, // #12885
  {36, 13,   0}, // #12886
  {37,  1,   0}, // #12887
  {38,  1,   0}, // #12888
  {11, 24,   0}, // #12889
  {36, 24,   0}, // #12890
  {11, 59,   0}, // #12891
  {36, 59,   0}, // #12892
  {10,  6,   0}, // #12893
  {11,  6,   0}, // #12894
  {36,  6,   0}, // #12895
  {10,  8,   0}, // #12896
  {11,  8,   0}, // #12897
  {36,  8,   0}, // #12898
  { 4,  1,   0}, // #12899
  {14,  1,   0}, // #12900
  {15,  1,   0}, // #12901
  {16,  1,   0}, // #12902
  {20,  1,   0}, // #12903
  {21,  1,   0}, // #12904
  {22,  1,   0}, // #12905
  {28,  1,   0}, // #12906
  {29,  1,   0}, // #12907
  {31,  1,   0}, // #12908
  {32,  1,   0}, // #12909
  {33,  1,   0}, // #12910
  {36,  1,   0}, // #12911
  {37,  1,   0}, // #12912
  {38,  1,   0}, // #12913
  { 4,  1,   0}, // #12914
  {14, 24,   0}, // #12915
  {20, 24,   0}, // #12916
  {28, 24,   0}, // #12917
  {31, 24,   0}, // #12918
  {32, 24,   0}, // #12919
  {36,  1,   0}, // #12920
  {37,  1,   0}, // #12921
  {38,  1,   0}, // #12922
  { 4,  1,   0}, // #12923
  {14, 62,   0}, // #12924
  {20, 62,   0}, // #12925
  {28, 62,   0}, // #12926
  {31, 62,   0}, // #12927
  {32, 62,   0}, // #12928
  {36,  1,   0}, // #12929
  {37,  1,   0}, // #12930
  {38,  1,   0}, // #12931
  { 4,  1,   0}, // #12932
  {11,  4,   0}, // #12933
  {36,  5,   0}, // #12934
  {37,  1,   0}, // #12935
  {39,  1,   0}, // #12936
  {14,  6,   0}, // #12937
  {17,  6,   0}, // #12938
  {18,  6,   0}, // #12939
  {20,  6,   0}, // #12940
  {28,  6,   0}, // #12941
  {31,  6,   0}, // #12942
  {32,  6,   0}, // #12943
  { 4,  1,   0}, // #12944
  {14,  1,   0}, // #12945
  {15,  1,   0}, // #12946
  {16,  1,   0}, // #12947
  {19,  1,   0}, // #12948
  {20,  1,   0}, // #12949
  {21,  1,   0}, // #12950
  {23,  1,   0}, // #12951
  {28,  1,   0}, // #12952
  {29,  1,   0}, // #12953
  {30,  1,   0}, // #12954
  {31,  1,   0}, // #12955
  {32,  1,   0}, // #12956
  {34,  1,   0}, // #12957
  {35,  1,   0}, // #12958
  {36,  1,   0}, // #12959
  {37,  1,   0}, // #12960
  {38,  1,   0}, // #12961
  {14,  1,   0}, // #12962
  {15,  1,   0}, // #12963
  {16,  1,   0}, // #12964
  {20,  1,   0}, // #12965
  {21,  1,   0}, // #12966
  {22,  1,   0}, // #12967
  {26,  1,   0}, // #12968
  {27,  1,   0}, // #12969
  {28,  1,   0}, // #12970
  {29,  1,   0}, // #12971
  {31,  1,   0}, // #12972
  {32,  1,   0}, // #12973
  {33,  1,   0}, // #12974
  {37,  1,   0}, // #12975
  {39,  1,   0}, // #12976
  { 4,  1,   0}, // #12977
  {14,  2,   0}, // #12978
  {20,  2,   0}, // #12979
  {28,  2,   0}, // #12980
  {31,  2,   0}, // #12981
  {32,  2,   0}, // #12982
  {36,  1,   0}, // #12983
  {37,  1,   0}, // #12984
  {38,  1,   0}, // #12985
  { 4,  1,   0}, // #12986
  {11,  7,   0}, // #12987
  {36,  8,   0}, // #12988
  {37,  2,   0}, // #12989
  {38,  1,   0}, // #12990
  {39,  1,   0}, // #12991
  { 4,  1,   0}, // #12992
  {10,  8,   0}, // #12993
  {11,  8,   0}, // #12994
  {36,  9,   0}, // #12995
  {37,  1,   0}, // #12996
  {38,  1,   0}, // #12997
  {14,  5,   0}, // #12998
  {20,  4,   0}, // #12999
  {26,  1,   0}, // #13000
  {28,  4,   0}, // #13001
  {31,  4,   0}, // #13002
  {32,  4,   0}, // #13003
  {14,  3,   0}, // #13004
  {20,  3,   0}, // #13005
  {28,  3,   0}, // #13006
  {31,  3,   0}, // #13007
  {32,  3,   0}, // #13008
  { 4,  1,   0}, // #13009
  {14,  3,   0}, // #13010
  {20,  3,   0}, // #13011
  {28,  3,   0}, // #13012
  {31,  3,   0}, // #13013
  {32,  3,   0}, // #13014
  {36,  1,   0}, // #13015
  {37,  1,   0}, // #13016
  {38,  1,   0}, // #13017
  { 4,  1,   0}, // #13018
  {14,  8,   0}, // #13019
  {20,  8,   0}, // #13020
  {28,  8,   0}, // #13021
  {31,  8,   0}, // #13022
  {32,  8,   0}, // #13023
  {36,  1,   0}, // #13024
  {37,  1,   0}, // #13025
  {38,  1,   0}, // #13026
  { 4,  1,   0}, // #13027
  {14,  2,   0}, // #13028
  {15,  2,   0}, // #13029
  {16,  2,   0}, // #13030
  {19,  2,   0}, // #13031
  {20,  2,   0}, // #13032
  {21,  2,   0}, // #13033
  {23,  2,   0}, // #13034
  {28,  2,   0}, // #13035
  {29,  2,   0}, // #13036
  {30,  2,   0}, // #13037
  {31,  2,   0}, // #13038
  {32,  2,   0}, // #13039
  {34,  2,   0}, // #13040
  {35,  2,   0}, // #13041
  {36,  1,   0}, // #13042
  {37,  1,   0}, // #13043
  {38,  1,   0}, // #13044
  {11,  1,   0}, // #13045
  {41,  1,   0}, // #13046
  {11,  0,   0}, // #13047
  {41,  0,   0}, // #13048
  {14,  1,   0}, // #13049
  {28,  1,   0}, // #13050
  {33,  1,   0}, // #13051
  {36,  1,   0}, // #13052
  {37,  1,   0}, // #13053
  {13,  1,   0}, // #13054
  {41,  1,   0}, // #13055
  {11, 12,   0}, // #13056
  {41, 12,   0}, // #13057
  { 4,  1,   0}, // #13058
  {13,  1,   0}, // #13059
  {41,  2,   0}, // #13060
  {42,  1,   0}, // #13061
  {43,  1,   0}, // #13062
  {11,  4,   0}, // #13063
  {41,  4,   0}, // #13064
  {11, 100,   0}, // #13065
  {41, 100,   0}, // #13066
  { 4,  1,   0}, // #13067
  {41,  1,   0}, // #13068
  { 4,  1,   0}, // #13069
  {41,  1,   0}, // #13070
  {42,  1,   0}, // #13071
  {44,  1,   0}, // #13072
  {10,  3,   0}, // #13073
  {11,  3,   0}, // #13074
  {41,  3,   0}, // #13075
  {19,  1,   0}, // #13076
  {32,  1,   0}, // #13077
  {42,  1,   0}, // #13078
  {44,  1,   0}, // #13079
  {14,  1,   0}, // #13080
  {19,  1,   0}, // #13081
  {30,  1,   0}, // #13082
  {42,  1,   0}, // #13083
  {43,  1,   0}, // #13084
  { 4,  2,   0}, // #13085
  {11,  1,   0}, // #13086
  {41,  3,   0}, // #13087
  {42,  2,   0}, // #13088
  {43,  1,   0}, // #13089
  {44,  1,   0}, // #13090
  {14,  2,   0}, // #13091
  {20,  2,   0}, // #13092
  {21,  2,   0}, // #13093
  {24,  2,   0}, // #13094
  {28,  2,   0}, // #13095
  {29,  2,   0}, // #13096
  {33,  2,   0}, // #13097
  {34,  2,   0}, // #13098
  {36,  2,   0}, // #13099
  {37,  2,   0}, // #13100
  { 4,  2,   0}, // #13101
  {11,  4,   0}, // #13102
  {41,  6,   0}, // #13103
  {42,  2,   0}, // #13104
  {43,  1,   0}, // #13105
  {44,  1,   0}, // #13106
  { 4,  1,   0}, // #13107
  {11,  4,   0}, // #13108
  {41,  5,   0}, // #13109
  {42,  1,   0}, // #13110
  {43,  1,   0}, // #13111
  { 4,  1,   0}, // #13112
  {11,  1,   0}, // #13113
  {41,  2,   0}, // #13114
  {42,  1,   0}, // #13115
  {43,  1,   0}, // #13116
  {14,  2,   0}, // #13117
  {19,  1,   0}, // #13118
  {22,  1,   0}, // #13119
  {23,  1,   0}, // #13120
  {26,  1,   0}, // #13121
  {27,  1,   0}, // #13122
  {28,  1,   0}, // #13123
  {30,  1,   0}, // #13124
  {31,  1,   0}, // #13125
  {33,  1,   0}, // #13126
  {36,  1,   0}, // #13127
  {37,  1,   0}, // #13128
  {42,  1,   0}, // #13129
  {43,  1,   0}, // #13130
  {14,  1,   0}, // #13131
  {22,  1,   0}, // #13132
  {23,  1,   0}, // #13133
  {26,  1,   0}, // #13134
  {27,  1,   0}, // #13135
  {28,  1,   0}, // #13136
  {31,  1,   0}, // #13137
  {33,  1,   0}, // #13138
  {36,  1,   0}, // #13139
  {37,  1,   0}, // #13140
  {14,  2,   0}, // #13141
  {19,  1,   0}, // #13142
  {20,  1,   0}, // #13143
  {21,  1,   0}, // #13144
  {24,  1,   0}, // #13145
  {28,  1,   0}, // #13146
  {29,  1,   0}, // #13147
  {30,  1,   0}, // #13148
  {33,  1,   0}, // #13149
  {34,  1,   0}, // #13150
  {36,  1,   0}, // #13151
  {37,  1,   0}, // #13152
  {42,  1,   0}, // #13153
  {43,  1,   0}, // #13154
  {14,  1,   0}, // #13155
  {20,  1,   0}, // #13156
  {21,  1,   0}, // #13157
  {24,  1,   0}, // #13158
  {28,  1,   0}, // #13159
  {29,  1,   0}, // #13160
  {33,  1,   0}, // #13161
  {34,  1,   0}, // #13162
  {36,  1,   0}, // #13163
  {37,  1,   0}, // #13164
  {14,  2,   0}, // #13165
  {19,  1,   0}, // #13166
  {28,  1,   0}, // #13167
  {30,  1,   0}, // #13168
  {33,  1,   0}, // #13169
  {36,  1,   0}, // #13170
  {37,  1,   0}, // #13171
  {42,  1,   0}, // #13172
  {43,  1,   0}, // #13173
  { 4,  1,   0}, // #13174
  {10,  1,   0}, // #13175
  {11,  1,   0}, // #13176
  {41,  2,   0}, // #13177
  {42,  1,   0}, // #13178
  {43,  1,   0}, // #13179
  {10,  1,   0}, // #13180
  {11,  1,   0}, // #13181
  {41,  1,   0}, // #13182
  { 4,  1,   0}, // #13183
  { 6,  1,   0}, // #13184
  {10,  1,   0}, // #13185
  {11,  1,   0}, // #13186
  {41,  2,   0}, // #13187
  {42,  1,   0}, // #13188
  {43,  1,   0}, // #13189
  { 6,  1,   0}, // #13190
  {10,  1,   0}, // #13191
  {11,  1,   0}, // #13192
  {41,  1,   0}, // #13193
  { 4,  2,   0}, // #13194
  {10,  1,   0}, // #13195
  {11,  1,   0}, // #13196
  {41,  3,   0}, // #13197
  {42,  2,   0}, // #13198
  {43,  1,   0}, // #13199
  {44,  1,   0}, // #13200
  {10,  2,   0}, // #13201
  {11,  2,   0}, // #13202
  {41,  2,   0}, // #13203
  { 4,  1,   0}, // #13204
  {41,  1,   0}, // #13205
  {42,  1,   0}, // #13206
  {43,  1,   0}, // #13207
  { 4,  1,   0}, // #13208
  { 9,  1,   0}, // #13209
  {11,  1,   0}, // #13210
  {41,  2,   0}, // #13211
  {42,  1,   0}, // #13212
  {43,  1,   0}, // #13213
  { 9,  1,   0}, // #13214
  {11,  1,   0}, // #13215
  {41,  1,   0}, // #13216
  {11, 28,   0}, // #13217
  {41, 28,   0}, // #13218
  {11,  8,   0}, // #13219
  {41,  8,   0}, // #13220
  {14,  3,   0}, // #13221
  {19,  1,   0}, // #13222
  {20,  2,   0}, // #13223
  {21,  2,   0}, // #13224
  {24,  2,   0}, // #13225
  {28,  2,   0}, // #13226
  {29,  2,   0}, // #13227
  {30,  1,   0}, // #13228
  {33,  2,   0}, // #13229
  {34,  2,   0}, // #13230
  {36,  2,   0}, // #13231
  {37,  2,   0}, // #13232
  {42,  1,   0}, // #13233
  {43,  1,   0}, // #13234
  {14,  3,   0}, // #13235
  {19,  1,   0}, // #13236
  {22,  2,   0}, // #13237
  {23,  2,   0}, // #13238
  {26,  2,   0}, // #13239
  {27,  2,   0}, // #13240
  {28,  2,   0}, // #13241
  {30,  1,   0}, // #13242
  {31,  2,   0}, // #13243
  {33,  2,   0}, // #13244
  {36,  2,   0}, // #13245
  {37,  2,   0}, // #13246
  {42,  1,   0}, // #13247
  {43,  1,   0}, // #13248
  {14,  2,   0}, // #13249
  {22,  2,   0}, // #13250
  {23,  2,   0}, // #13251
  {26,  2,   0}, // #13252
  {27,  2,   0}, // #13253
  {28,  2,   0}, // #13254
  {31,  2,   0}, // #13255
  {33,  2,   0}, // #13256
  {36,  2,   0}, // #13257
  {37,  2,   0}, // #13258
  {14,  6,   0}, // #13259
  {19,  1,   0}, // #13260
  {22,  5,   0}, // #13261
  {23,  5,   0}, // #13262
  {26,  5,   0}, // #13263
  {27,  5,   0}, // #13264
  {28,  5,   0}, // #13265
  {30,  1,   0}, // #13266
  {31,  5,   0}, // #13267
  {33,  5,   0}, // #13268
  {36,  5,   0}, // #13269
  {37,  5,   0}, // #13270
  {42,  1,   0}, // #13271
  {43,  1,   0}, // #13272
  {14,  5,   0}, // #13273
  {22,  5,   0}, // #13274
  {23,  5,   0}, // #13275
  {26,  5,   0}, // #13276
  {27,  5,   0}, // #13277
  {28,  5,   0}, // #13278
  {31,  5,   0}, // #13279
  {33,  5,   0}, // #13280
  {36,  5,   0}, // #13281
  {37,  5,   0}, // #13282
  { 4,  1,   0}, // #13283
  { 5, 11,   0}, // #13284
  { 9, 11,   0}, // #13285
  {11, 11,   0}, // #13286
  {13, 11,   0}, // #13287
  {41, 12,   0}, // #13288
  {42,  1,   0}, // #13289
  {43,  1,   0}, // #13290
  { 5, 11,   0}, // #13291
  { 9, 11,   0}, // #13292
  {11, 11,   0}, // #13293
  {13, 11,   0}, // #13294
  {41, 11,   0}, // #13295
  { 4,  1,   0}, // #13296
  { 5, 13,   0}, // #13297
  { 9, 13,   0}, // #13298
  {11, 13,   0}, // #13299
  {13, 13,   0}, // #13300
  {41, 14,   0}, // #13301
  {42,  1,   0}, // #13302
  {43,  1,   0}, // #13303
  { 5, 13,   0}, // #13304
  { 9, 13,   0}, // #13305
  {11, 13,   0}, // #13306
  {13, 13,   0}, // #13307
  {41, 13,   0}, // #13308
  { 4,  1,   0}, // #13309
  { 5, 17,   0}, // #13310
  { 9, 17,   0}, // #13311
  {11, 17,   0}, // #13312
  {13, 17,   0}, // #13313
  {41, 18,   0}, // #13314
  {42,  1,   0}, // #13315
  {43,  1,   0}, // #13316
  { 5, 17,   0}, // #13317
  { 9, 17,   0}, // #13318
  {11, 17,   0}, // #13319
  {13, 17,   0}, // #13320
  {41, 17,   0}, // #13321
  { 4,  1,   0}, // #13322
  { 5, 10,   0}, // #13323
  { 9, 10,   0}, // #13324
  {11, 10,   0}, // #13325
  {13, 10,   0}, // #13326
  {41, 11,   0}, // #13327
  {42,  1,   0}, // #13328
  {43,  1,   0}, // #13329
  { 5, 10,   0}, // #13330
  { 9, 10,   0}, // #13331
  {11, 10,   0}, // #13332
  {13, 10,   0}, // #13333
  {41, 10,   0}, // #13334
  {14,  6,   0}, // #13335
  {16,  5,   0}, // #13336
  {19,  1,   0}, // #13337
  {20,  5,   0}, // #13338
  {21,  5,   0}, // #13339
  {24,  5,   0}, // #13340
  {25,  5,   0}, // #13341
  {27,  5,   0}, // #13342
  {28,  5,   0}, // #13343
  {29,  5,   0}, // #13344
  {30,  1,   0}, // #13345
  {33,  5,   0}, // #13346
  {34,  5,   0}, // #13347
  {35,  5,   0}, // #13348
  {36,  5,   0}, // #13349
  {37,  5,   0}, // #13350
  {39,  5,   0}, // #13351
  {40,  5,   0}, // #13352
  {42,  1,   0}, // #13353
  {43,  1,   0}, // #13354
  {14,  5,   0}, // #13355
  {16,  5,   0}, // #13356
  {20,  5,   0}, // #13357
  {21,  5,   0}, // #13358
  {24,  5,   0}, // #13359
  {25,  5,   0}, // #13360
  {27,  5,   0}, // #13361
  {28,  5,   0}, // #13362
  {29,  5,   0}, // #13363
  {33,  5,   0}, // #13364
  {34,  5,   0}, // #13365
  {35,  5,   0}, // #13366
  {36,  5,   0}, // #13367
  {37,  5,   0}, // #13368
  {39,  5,   0}, // #13369
  {40,  5,   0}, // #13370
  {14,  4,   0}, // #13371
  {16,  3,   0}, // #13372
  {19,  1,   0}, // #13373
  {20,  3,   0}, // #13374
  {21,  3,   0}, // #13375
  {24,  3,   0}, // #13376
  {25,  3,   0}, // #13377
  {27,  3,   0}, // #13378
  {28,  3,   0}, // #13379
  {29,  3,   0}, // #13380
  {30,  1,   0}, // #13381
  {33,  3,   0}, // #13382
  {34,  3,   0}, // #13383
  {35,  3,   0}, // #13384
  {36,  3,   0}, // #13385
  {37,  3,   0}, // #13386
  {39,  3,   0}, // #13387
  {40,  3,   0}, // #13388
  {42,  1,   0}, // #13389
  {43,  1,   0}, // #13390
  {14,  3,   0}, // #13391
  {16,  3,   0}, // #13392
  {20,  3,   0}, // #13393
  {21,  3,   0}, // #13394
  {24,  3,   0}, // #13395
  {25,  3,   0}, // #13396
  {27,  3,   0}, // #13397
  {28,  3,   0}, // #13398
  {29,  3,   0}, // #13399
  {33,  3,   0}, // #13400
  {34,  3,   0}, // #13401
  {35,  3,   0}, // #13402
  {36,  3,   0}, // #13403
  {37,  3,   0}, // #13404
  {39,  3,   0}, // #13405
  {40,  3,   0}, // #13406
  {14,  7,   0}, // #13407
  {19,  1,   0}, // #13408
  {20,  6,   0}, // #13409
  {21,  6,   0}, // #13410
  {24,  6,   0}, // #13411
  {28,  6,   0}, // #13412
  {29,  6,   0}, // #13413
  {30,  1,   0}, // #13414
  {33,  6,   0}, // #13415
  {34,  6,   0}, // #13416
  {36,  6,   0}, // #13417
  {37,  6,   0}, // #13418
  {42,  1,   0}, // #13419
  {43,  1,   0}, // #13420
  {14,  6,   0}, // #13421
  {20,  6,   0}, // #13422
  {21,  6,   0}, // #13423
  {24,  6,   0}, // #13424
  {28,  6,   0}, // #13425
  {29,  6,   0}, // #13426
  {33,  6,   0}, // #13427
  {34,  6,   0}, // #13428
  {36,  6,   0}, // #13429
  {37,  6,   0}, // #13430
  {14,  9,   0}, // #13431
  {19,  1,   0}, // #13432
  {20,  8,   0}, // #13433
  {21,  8,   0}, // #13434
  {24,  8,   0}, // #13435
  {28,  8,   0}, // #13436
  {29,  8,   0}, // #13437
  {30,  1,   0}, // #13438
  {33,  8,   0}, // #13439
  {34,  8,   0}, // #13440
  {36,  8,   0}, // #13441
  {37,  8,   0}, // #13442
  {42,  1,   0}, // #13443
  {43,  1,   0}, // #13444
  {14,  8,   0}, // #13445
  {20,  8,   0}, // #13446
  {21,  8,   0}, // #13447
  {24,  8,   0}, // #13448
  {28,  8,   0}, // #13449
  {29,  8,   0}, // #13450
  {33,  8,   0}, // #13451
  {34,  8,   0}, // #13452
  {36,  8,   0}, // #13453
  {37,  8,   0}, // #13454
  { 4,  1,   0}, // #13455
  {41,  1,   0}, // #13456
  {42,  2,   0}, // #13457
  {44,  2,   0}, // #13458
  {14,  2,   0}, // #13459
  {19,  2,   0}, // #13460
  {30,  2,   0}, // #13461
  {14,  2,   0}, // #13462
  {16,  1,   0}, // #13463
  {19,  1,   0}, // #13464
  {20,  1,   0}, // #13465
  {21,  1,   0}, // #13466
  {24,  1,   0}, // #13467
  {25,  1,   0}, // #13468
  {27,  1,   0}, // #13469
  {28,  1,   0}, // #13470
  {29,  1,   0}, // #13471
  {30,  1,   0}, // #13472
  {33,  1,   0}, // #13473
  {34,  1,   0}, // #13474
  {35,  1,   0}, // #13475
  {36,  1,   0}, // #13476
  {37,  1,   0}, // #13477
  {39,  1,   0}, // #13478
  {40,  1,   0}, // #13479
  {42,  1,   0}, // #13480
  {43,  1,   0}, // #13481
  {14,  2,   0}, // #13482
  {19,  1,   0}, // #13483
  {28,  1,   0}, // #13484
  {30,  1,   0}, // #13485
  {33,  1,   0}, // #13486
  {36,  1,   0}, // #13487
  {37,  1,   0}, // #13488
  {38,  1,   0}, // #13489
  {42,  1,   0}, // #13490
  {43,  1,   0}, // #13491
  {14,  1,   0}, // #13492
  {28,  1,   0}, // #13493
  {33,  1,   0}, // #13494
  {36,  1,   0}, // #13495
  {37,  1,   0}, // #13496
  {38,  1,   0}, // #13497
  {14,  3,   0}, // #13498
  {17,  2,   0}, // #13499
  {19,  1,   0}, // #13500
  {22,  2,   0}, // #13501
  {23,  2,   0}, // #13502
  {25,  2,   0}, // #13503
  {26,  2,   0}, // #13504
  {27,  2,   0}, // #13505
  {28,  2,   0}, // #13506
  {30,  1,   0}, // #13507
  {31,  2,   0}, // #13508
  {33,  2,   0}, // #13509
  {35,  2,   0}, // #13510
  {36,  2,   0}, // #13511
  {37,  2,   0}, // #13512
  {39,  2,   0}, // #13513
  {40,  2,   0}, // #13514
  {42,  1,   0}, // #13515
  {43,  1,   0}, // #13516
  {14,  2,   0}, // #13517
  {17,  2,   0}, // #13518
  {22,  2,   0}, // #13519
  {23,  2,   0}, // #13520
  {25,  2,   0}, // #13521
  {26,  2,   0}, // #13522
  {27,  2,   0}, // #13523
  {28,  2,   0}, // #13524
  {31,  2,   0}, // #13525
  {33,  2,   0}, // #13526
  {35,  2,   0}, // #13527
  {36,  2,   0}, // #13528
  {37,  2,   0}, // #13529
  {39,  2,   0}, // #13530
  {40,  2,   0}, // #13531
  { 4,  1,   0}, // #13532
  { 6,  3,   0}, // #13533
  {10,  3,   0}, // #13534
  {11,  3,   0}, // #13535
  {41,  4,   0}, // #13536
  {42,  1,   0}, // #13537
  {43,  1,   0}, // #13538
  { 6,  3,   0}, // #13539
  {10,  3,   0}, // #13540
  {11,  3,   0}, // #13541
  {41,  3,   0}, // #13542
  { 4,  1,   0}, // #13543
  { 6,  4,   0}, // #13544
  {10,  4,   0}, // #13545
  {11,  4,   0}, // #13546
  {41,  5,   0}, // #13547
  {42,  1,   0}, // #13548
  {43,  1,   0}, // #13549
  { 6,  4,   0}, // #13550
  {10,  4,   0}, // #13551
  {11,  4,   0}, // #13552
  {41,  4,   0}, // #13553
  {14,  2,   0}, // #13554
  {19,  1,   0}, // #13555
  {25,  1,   0}, // #13556
  {27,  1,   0}, // #13557
  {28,  1,   0}, // #13558
  {30,  1,   0}, // #13559
  {33,  1,   0}, // #13560
  {35,  1,   0}, // #13561
  {36,  1,   0}, // #13562
  {37,  1,   0}, // #13563
  {39,  1,   0}, // #13564
  {40,  1,   0}, // #13565
  {42,  1,   0}, // #13566
  {43,  1,   0}, // #13567
  {14,  1,   0}, // #13568
  {25,  1,   0}, // #13569
  {27,  1,   0}, // #13570
  {28,  1,   0}, // #13571
  {33,  1,   0}, // #13572
  {35,  1,   0}, // #13573
  {36,  1,   0}, // #13574
  {37,  1,   0}, // #13575
  {39,  1,   0}, // #13576
  {40,  1,   0}, // #13577
  { 8,  1,   0}, // #13578
  { 9,  1,   0}, // #13579
  {11,  1,   0}, // #13580
  {41,  1,   0}, // #13581
  { 4,  1,   0}, // #13582
  {11,  6,   0}, // #13583
  {41,  7,   0}, // #13584
  {42,  1,   0}, // #13585
  {43,  1,   0}, // #13586
  {14,  3,   0}, // #13587
  {15,  2,   0}, // #13588
  {19,  1,   0}, // #13589
  {20,  2,   0}, // #13590
  {21,  2,   0}, // #13591
  {24,  2,   0}, // #13592
  {28,  2,   0}, // #13593
  {29,  2,   0}, // #13594
  {30,  1,   0}, // #13595
  {33,  2,   0}, // #13596
  {34,  2,   0}, // #13597
  {36,  2,   0}, // #13598
  {37,  2,   0}, // #13599
  {38,  2,   0}, // #13600
  {42,  1,   0}, // #13601
  {43,  1,   0}, // #13602
  {14,  2,   0}, // #13603
  {15,  2,   0}, // #13604
  {20,  2,   0}, // #13605
  {21,  2,   0}, // #13606
  {24,  2,   0}, // #13607
  {28,  2,   0}, // #13608
  {29,  2,   0}, // #13609
  {33,  2,   0}, // #13610
  {34,  2,   0}, // #13611
  {36,  2,   0}, // #13612
  {37,  2,   0}, // #13613
  {38,  2,   0}, // #13614
  {14,  3,   0}, // #13615
  {19,  3,   0}, // #13616
  {30,  3,   0}, // #13617
  {42,  1,   0}, // #13618
  {43,  1,   0}, // #13619
  {14,  1,   0}, // #13620
  {17,  1,   0}, // #13621
  {22,  1,   0}, // #13622
  {23,  1,   0}, // #13623
  {25,  1,   0}, // #13624
  {26,  1,   0}, // #13625
  {27,  1,   0}, // #13626
  {28,  1,   0}, // #13627
  {31,  1,   0}, // #13628
  {33,  1,   0}, // #13629
  {35,  1,   0}, // #13630
  {36,  1,   0}, // #13631
  {37,  1,   0}, // #13632
  {39,  1,   0}, // #13633
  {40,  1,   0}, // #13634
  {14,  3,   0}, // #13635
  {19,  1,   0}, // #13636
  {28,  2,   0}, // #13637
  {30,  1,   0}, // #13638
  {33,  2,   0}, // #13639
  {36,  2,   0}, // #13640
  {37,  2,   0}, // #13641
  {42,  1,   0}, // #13642
  {43,  1,   0}, // #13643
  {14,  2,   0}, // #13644
  {28,  2,   0}, // #13645
  {33,  2,   0}, // #13646
  {36,  2,   0}, // #13647
  {37,  2,   0}, // #13648
  {14,  9,   0}, // #13649
  {19,  1,   0}, // #13650
  {28,  8,   0}, // #13651
  {30,  1,   0}, // #13652
  {33,  8,   0}, // #13653
  {36,  8,   0}, // #13654
  {37,  8,   0}, // #13655
  {42,  1,   0}, // #13656
  {43,  1,   0}, // #13657
  {14,  8,   0}, // #13658
  {28,  8,   0}, // #13659
  {33,  8,   0}, // #13660
  {36,  8,   0}, // #13661
  {37,  8,   0}, // #13662
  {14,  5,   0}, // #13663
  {19,  1,   0}, // #13664
  {20,  4,   0}, // #13665
  {21,  4,   0}, // #13666
  {24,  4,   0}, // #13667
  {28,  4,   0}, // #13668
  {29,  4,   0}, // #13669
  {30,  1,   0}, // #13670
  {33,  4,   0}, // #13671
  {34,  4,   0}, // #13672
  {36,  4,   0}, // #13673
  {37,  4,   0}, // #13674
  {42,  1,   0}, // #13675
  {43,  1,   0}, // #13676
  {14,  4,   0}, // #13677
  {20,  4,   0}, // #13678
  {21,  4,   0}, // #13679
  {24,  4,   0}, // #13680
  {28,  4,   0}, // #13681
  {29,  4,   0}, // #13682
  {33,  4,   0}, // #13683
  {34,  4,   0}, // #13684
  {36,  4,   0}, // #13685
  {37,  4,   0}, // #13686
  {14, 13,   0}, // #13687
  {19,  1,   0}, // #13688
  {28, 12,   0}, // #13689
  {30,  1,   0}, // #13690
  {33, 12,   0}, // #13691
  {36, 12,   0}, // #13692
  {37, 12,   0}, // #13693
  {42,  1,   0}, // #13694
  {43,  1,   0}, // #13695
  {14, 12,   0}, // #13696
  {28, 12,   0}, // #13697
  {33, 12,   0}, // #13698
  {36, 12,   0}, // #13699
  {37, 12,   0}, // #13700
  { 4,  2,   0}, // #13701
  {41,  2,   0}, // #13702
  {42,  3,   0}, // #13703
  {43,  1,   0}, // #13704
  {44,  2,   0}, // #13705
  {14,  3,   0}, // #13706
  {19,  1,   0}, // #13707
  {25,  2,   0}, // #13708
  {27,  2,   0}, // #13709
  {28,  2,   0}, // #13710
  {30,  1,   0}, // #13711
  {33,  2,   0}, // #13712
  {35,  2,   0}, // #13713
  {36,  2,   0}, // #13714
  {37,  2,   0}, // #13715
  {39,  2,   0}, // #13716
  {40,  2,   0}, // #13717
  {42,  1,   0}, // #13718
  {43,  1,   0}, // #13719
  {14,  2,   0}, // #13720
  {25,  2,   0}, // #13721
  {27,  2,   0}, // #13722
  {28,  2,   0}, // #13723
  {33,  2,   0}, // #13724
  {35,  2,   0}, // #13725
  {36,  2,   0}, // #13726
  {37,  2,   0}, // #13727
  {39,  2,   0}, // #13728
  {40,  2,   0}, // #13729
  {14,  2,   0}, // #13730
  {19,  2,   0}, // #13731
  {25,  1,   0}, // #13732
  {27,  1,   0}, // #13733
  {28,  1,   0}, // #13734
  {30,  1,   0}, // #13735
  {32,  1,   0}, // #13736
  {33,  1,   0}, // #13737
  {35,  1,   0}, // #13738
  {36,  1,   0}, // #13739
  {37,  1,   0}, // #13740
  {39,  1,   0}, // #13741
  {40,  1,   0}, // #13742
  {42,  1,   0}, // #13743
  {43,  1,   0}, // #13744
  {14,  1,   0}, // #13745
  {19,  1,   0}, // #13746
  {25,  1,   0}, // #13747
  {27,  1,   0}, // #13748
  {28,  1,   0}, // #13749
  {32,  1,   0}, // #13750
  {33,  1,   0}, // #13751
  {35,  1,   0}, // #13752
  {36,  1,   0}, // #13753
  {37,  1,   0}, // #13754
  {39,  1,   0}, // #13755
  {40,  1,   0}, // #13756
  { 4,  1,   0}, // #13757
  {10,  2,   0}, // #13758
  {11,  2,   0}, // #13759
  {41,  3,   0}, // #13760
  {42,  1,   0}, // #13761
  {43,  1,   0}, // #13762
  {14,  1,   0}, // #13763
  {16,  1,   0}, // #13764
  {20,  1,   0}, // #13765
  {21,  1,   0}, // #13766
  {24,  1,   0}, // #13767
  {25,  1,   0}, // #13768
  {27,  1,   0}, // #13769
  {28,  1,   0}, // #13770
  {29,  1,   0}, // #13771
  {33,  1,   0}, // #13772
  {34,  1,   0}, // #13773
  {35,  1,   0}, // #13774
  {36,  1,   0}, // #13775
  {37,  1,   0}, // #13776
  {39,  1,   0}, // #13777
  {40,  1,   0}, // #13778
  { 4,  1,   0}, // #13779
  { 9,  2,   0}, // #13780
  {11,  2,   0}, // #13781
  {41,  3,   0}, // #13782
  {42,  1,   0}, // #13783
  {44,  1,   0}, // #13784
  { 9,  2,   0}, // #13785
  {11,  2,   0}, // #13786
  {41,  2,   0}, // #13787
  { 4,  1,   0}, // #13788
  {10,  4,   0}, // #13789
  {11,  4,   0}, // #13790
  {41,  5,   0}, // #13791
  {42,  1,   0}, // #13792
  {43,  1,   0}, // #13793
  {14, 10,   0}, // #13794
  {16,  9,   0}, // #13795
  {19,  1,   0}, // #13796
  {20,  9,   0}, // #13797
  {21,  9,   0}, // #13798
  {24,  9,   0}, // #13799
  {25,  9,   0}, // #13800
  {27,  9,   0}, // #13801
  {28,  9,   0}, // #13802
  {29,  9,   0}, // #13803
  {30,  1,   0}, // #13804
  {33,  9,   0}, // #13805
  {34,  9,   0}, // #13806
  {35,  9,   0}, // #13807
  {36,  9,   0}, // #13808
  {37,  9,   0}, // #13809
  {39,  9,   0}, // #13810
  {40,  9,   0}, // #13811
  {42,  1,   0}, // #13812
  {43,  1,   0}, // #13813
  {14,  9,   0}, // #13814
  {16,  9,   0}, // #13815
  {20,  9,   0}, // #13816
  {21,  9,   0}, // #13817
  {24,  9,   0}, // #13818
  {25,  9,   0}, // #13819
  {27,  9,   0}, // #13820
  {28,  9,   0}, // #13821
  {29,  9,   0}, // #13822
  {33,  9,   0}, // #13823
  {34,  9,   0}, // #13824
  {35,  9,   0}, // #13825
  {36,  9,   0}, // #13826
  {37,  9,   0}, // #13827
  {39,  9,   0}, // #13828
  {40,  9,   0}, // #13829
  {14, 23,   0}, // #13830
  {16, 23,   0}, // #13831
  {20, 23,   0}, // #13832
  {21, 23,   0}, // #13833
  {24, 23,   0}, // #13834
  {25, 23,   0}, // #13835
  {27, 23,   0}, // #13836
  {28, 23,   0}, // #13837
  {29, 23,   0}, // #13838
  {33, 23,   0}, // #13839
  {34, 23,   0}, // #13840
  {35, 23,   0}, // #13841
  {36, 23,   0}, // #13842
  {37, 23,   0}, // #13843
  {39, 23,   0}, // #13844
  {40, 23,   0}, // #13845
  { 4,  1,   0}, // #13846
  {11, 60,   0}, // #13847
  {41, 61,   0}, // #13848
  {42,  1,   0}, // #13849
  {44,  1,   0}, // #13850
  {14,  5,   0}, // #13851
  {19,  1,   0}, // #13852
  {22,  4,   0}, // #13853
  {23,  4,   0}, // #13854
  {26,  4,   0}, // #13855
  {27,  4,   0}, // #13856
  {28,  4,   0}, // #13857
  {30,  1,   0}, // #13858
  {31,  4,   0}, // #13859
  {33,  4,   0}, // #13860
  {36,  4,   0}, // #13861
  {37,  4,   0}, // #13862
  {42,  1,   0}, // #13863
  {43,  1,   0}, // #13864
  {14,  4,   0}, // #13865
  {22,  4,   0}, // #13866
  {23,  4,   0}, // #13867
  {26,  4,   0}, // #13868
  {27,  4,   0}, // #13869
  {28,  4,   0}, // #13870
  {31,  4,   0}, // #13871
  {33,  4,   0}, // #13872
  {36,  4,   0}, // #13873
  {37,  4,   0}, // #13874
  {14,  2,   0}, // #13875
  {19,  1,   0}, // #13876
  {22,  2,   0}, // #13877
  {23,  2,   0}, // #13878
  {26,  2,   0}, // #13879
  {27,  2,   0}, // #13880
  {28,  2,   0}, // #13881
  {31,  2,   0}, // #13882
  {32,  1,   0}, // #13883
  {33,  2,   0}, // #13884
  {36,  2,   0}, // #13885
  {37,  2,   0}, // #13886
  {42,  1,   0}, // #13887
  {44,  1,   0}, // #13888
  {14,  1,   0}, // #13889
  {19,  1,   0}, // #13890
  {22,  1,   0}, // #13891
  {23,  1,   0}, // #13892
  {26,  1,   0}, // #13893
  {27,  1,   0}, // #13894
  {28,  1,   0}, // #13895
  {31,  1,   0}, // #13896
  {32,  1,   0}, // #13897
  {33,  1,   0}, // #13898
  {36,  1,   0}, // #13899
  {37,  1,   0}, // #13900
  {42,  1,   0}, // #13901
  {44,  1,   0}, // #13902
  {14,  5,   0}, // #13903
  {19,  1,   0}, // #13904
  {28,  4,   0}, // #13905
  {30,  1,   0}, // #13906
  {33,  4,   0}, // #13907
  {36,  4,   0}, // #13908
  {37,  4,   0}, // #13909
  {42,  1,   0}, // #13910
  {43,  1,   0}, // #13911
  {14,  4,   0}, // #13912
  {28,  4,   0}, // #13913
  {33,  4,   0}, // #13914
  {36,  4,   0}, // #13915
  {37,  4,   0}, // #13916
  {14, 11,   0}, // #13917
  {16, 10,   0}, // #13918
  {19,  1,   0}, // #13919
  {20, 10,   0}, // #13920
  {21, 10,   0}, // #13921
  {24, 10,   0}, // #13922
  {25, 10,   0}, // #13923
  {27, 10,   0}, // #13924
  {28, 10,   0}, // #13925
  {29, 10,   0}, // #13926
  {30,  1,   0}, // #13927
  {33, 10,   0}, // #13928
  {34, 10,   0}, // #13929
  {35, 10,   0}, // #13930
  {36, 10,   0}, // #13931
  {37, 10,   0}, // #13932
  {39, 10,   0}, // #13933
  {40, 10,   0}, // #13934
  {42,  1,   0}, // #13935
  {43,  1,   0}, // #13936
  {14, 10,   0}, // #13937
  {16, 10,   0}, // #13938
  {20, 10,   0}, // #13939
  {21, 10,   0}, // #13940
  {24, 10,   0}, // #13941
  {25, 10,   0}, // #13942
  {27, 10,   0}, // #13943
  {28, 10,   0}, // #13944
  {29, 10,   0}, // #13945
  {33, 10,   0}, // #13946
  {34, 10,   0}, // #13947
  {35, 10,   0}, // #13948
  {36, 10,   0}, // #13949
  {37, 10,   0}, // #13950
  {39, 10,   0}, // #13951
  {40, 10,   0}, // #13952
  {14,  7,   0}, // #13953
  {16,  6,   0}, // #13954
  {19,  1,   0}, // #13955
  {20,  6,   0}, // #13956
  {21,  6,   0}, // #13957
  {24,  6,   0}, // #13958
  {25,  6,   0}, // #13959
  {27,  6,   0}, // #13960
  {28,  6,   0}, // #13961
  {29,  6,   0}, // #13962
  {30,  1,   0}, // #13963
  {33,  6,   0}, // #13964
  {34,  6,   0}, // #13965
  {35,  6,   0}, // #13966
  {36,  6,   0}, // #13967
  {37,  6,   0}, // #13968
  {39,  6,   0}, // #13969
  {40,  6,   0}, // #13970
  {42,  1,   0}, // #13971
  {43,  1,   0}, // #13972
  {14,  6,   0}, // #13973
  {16,  6,   0}, // #13974
  {20,  6,   0}, // #13975
  {21,  6,   0}, // #13976
  {24,  6,   0}, // #13977
  {25,  6,   0}, // #13978
  {27,  6,   0}, // #13979
  {28,  6,   0}, // #13980
  {29,  6,   0}, // #13981
  {33,  6,   0}, // #13982
  {34,  6,   0}, // #13983
  {35,  6,   0}, // #13984
  {36,  6,   0}, // #13985
  {37,  6,   0}, // #13986
  {39,  6,   0}, // #13987
  {40,  6,   0}, // #13988
  {14,  3,   0}, // #13989
  {19,  1,   0}, // #13990
  {28,  2,   0}, // #13991
  {30,  1,   0}, // #13992
  {33,  2,   0}, // #13993
  {36,  2,   0}, // #13994
  {37,  2,   0}, // #13995
  {38,  2,   0}, // #13996
  {42,  1,   0}, // #13997
  {43,  1,   0}, // #13998
  {14,  2,   0}, // #13999
  {28,  2,   0}, // #14000
  {33,  2,   0}, // #14001
  {36,  2,   0}, // #14002
  {37,  2,   0}, // #14003
  {38,  2,   0}, // #14004
  {19,  6,   0}, // #14005
  {32,  6,   0}, // #14006
  {42,  1,   0}, // #14007
  {44,  1,   0}, // #14008
  {19,  4,   0}, // #14009
  {32,  4,   0}, // #14010
  {42,  1,   0}, // #14011
  {44,  1,   0}, // #14012
  {19, 12,   0}, // #14013
  {32, 12,   0}, // #14014
  {42,  1,   0}, // #14015
  {44,  1,   0}, // #14016
  {14,  4,   0}, // #14017
  {15,  3,   0}, // #14018
  {19,  1,   0}, // #14019
  {20,  3,   0}, // #14020
  {21,  3,   0}, // #14021
  {24,  3,   0}, // #14022
  {28,  3,   0}, // #14023
  {29,  3,   0}, // #14024
  {30,  1,   0}, // #14025
  {33,  3,   0}, // #14026
  {34,  3,   0}, // #14027
  {36,  3,   0}, // #14028
  {37,  3,   0}, // #14029
  {38,  3,   0}, // #14030
  {42,  1,   0}, // #14031
  {43,  1,   0}, // #14032
  {14,  3,   0}, // #14033
  {15,  3,   0}, // #14034
  {20,  3,   0}, // #14035
  {21,  3,   0}, // #14036
  {24,  3,   0}, // #14037
  {28,  3,   0}, // #14038
  {29,  3,   0}, // #14039
  {33,  3,   0}, // #14040
  {34,  3,   0}, // #14041
  {36,  3,   0}, // #14042
  {37,  3,   0}, // #14043
  {38,  3,   0}, // #14044
  {14,  4,   0}, // #14045
  {19,  1,   0}, // #14046
  {25,  3,   0}, // #14047
  {27,  3,   0}, // #14048
  {28,  3,   0}, // #14049
  {30,  1,   0}, // #14050
  {33,  3,   0}, // #14051
  {35,  3,   0}, // #14052
  {36,  3,   0}, // #14053
  {37,  3,   0}, // #14054
  {39,  3,   0}, // #14055
  {40,  3,   0}, // #14056
  {42,  1,   0}, // #14057
  {43,  1,   0}, // #14058
  {14,  3,   0}, // #14059
  {25,  3,   0}, // #14060
  {27,  3,   0}, // #14061
  {28,  3,   0}, // #14062
  {33,  3,   0}, // #14063
  {35,  3,   0}, // #14064
  {36,  3,   0}, // #14065
  {37,  3,   0}, // #14066
  {39,  3,   0}, // #14067
  {40,  3,   0}, // #14068
  {14,  3,   0}, // #14069
  {16,  2,   0}, // #14070
  {19,  1,   0}, // #14071
  {20,  2,   0}, // #14072
  {21,  2,   0}, // #14073
  {24,  2,   0}, // #14074
  {25,  2,   0}, // #14075
  {27,  2,   0}, // #14076
  {28,  2,   0}, // #14077
  {29,  2,   0}, // #14078
  {30,  1,   0}, // #14079
  {33,  2,   0}, // #14080
  {34,  2,   0}, // #14081
  {35,  2,   0}, // #14082
  {36,  2,   0}, // #14083
  {37,  2,   0}, // #14084
  {39,  2,   0}, // #14085
  {40,  2,   0}, // #14086
  {42,  1,   0}, // #14087
  {43,  1,   0}, // #14088
  {14,  2,   0}, // #14089
  {16,  2,   0}, // #14090
  {20,  2,   0}, // #14091
  {21,  2,   0}, // #14092
  {24,  2,   0}, // #14093
  {25,  2,   0}, // #14094
  {27,  2,   0}, // #14095
  {28,  2,   0}, // #14096
  {29,  2,   0}, // #14097
  {33,  2,   0}, // #14098
  {34,  2,   0}, // #14099
  {35,  2,   0}, // #14100
  {36,  2,   0}, // #14101
  {37,  2,   0}, // #14102
  {39,  2,   0}, // #14103
  {40,  2,   0}, // #14104
  {14, 19,   0}, // #14105
  {16, 18,   0}, // #14106
  {19,  1,   0}, // #14107
  {20, 18,   0}, // #14108
  {21, 18,   0}, // #14109
  {24, 18,   0}, // #14110
  {25, 18,   0}, // #14111
  {27, 18,   0}, // #14112
  {28, 18,   0}, // #14113
  {29, 18,   0}, // #14114
  {30,  1,   0}, // #14115
  {33, 18,   0}, // #14116
  {34, 18,   0}, // #14117
  {35, 18,   0}, // #14118
  {36, 18,   0}, // #14119
  {37, 18,   0}, // #14120
  {39, 18,   0}, // #14121
  {40, 18,   0}, // #14122
  {42,  1,   0}, // #14123
  {43,  1,   0}, // #14124
  {14, 18,   0}, // #14125
  {16, 18,   0}, // #14126
  {20, 18,   0}, // #14127
  {21, 18,   0}, // #14128
  {24, 18,   0}, // #14129
  {25, 18,   0}, // #14130
  {27, 18,   0}, // #14131
  {28, 18,   0}, // #14132
  {29, 18,   0}, // #14133
  {33, 18,   0}, // #14134
  {34, 18,   0}, // #14135
  {35, 18,   0}, // #14136
  {36, 18,   0}, // #14137
  {37, 18,   0}, // #14138
  {39, 18,   0}, // #14139
  {40, 18,   0}, // #14140
  {42, 30,   0}, // #14141
  { 4,  1,   0}, // #14142
  {11,  2,   0}, // #14143
  {41,  3,   0}, // #14144
  {42,  1,   0}, // #14145
  {43,  1,   0}, // #14146
  { 4,  3,   0}, // #14147
  {41,  3,   0}, // #14148
  {42,  1,   0}, // #14149
  {43,  1,   0}, // #14150
  { 4,  1,   0}, // #14151
  {11, 12,   0}, // #14152
  {41, 13,   0}, // #14153
  {42,  1,   0}, // #14154
  {43,  1,   0}, // #14155
  {11, 24,   0}, // #14156
  {41, 24,   0}, // #14157
  {11, 59,   0}, // #14158
  {41, 59,   0}, // #14159
  {10,  6,   0}, // #14160
  {11,  6,   0}, // #14161
  {41,  6,   0}, // #14162
  {10,  8,   0}, // #14163
  {11,  8,   0}, // #14164
  {41,  8,   0}, // #14165
  { 4,  1,   0}, // #14166
  {14,  1,   0}, // #14167
  {15,  1,   0}, // #14168
  {20,  1,   0}, // #14169
  {21,  1,   0}, // #14170
  {24,  1,   0}, // #14171
  {28,  1,   0}, // #14172
  {29,  1,   0}, // #14173
  {33,  1,   0}, // #14174
  {34,  1,   0}, // #14175
  {36,  1,   0}, // #14176
  {37,  1,   0}, // #14177
  {38,  1,   0}, // #14178
  {41,  1,   0}, // #14179
  {42,  1,   0}, // #14180
  {43,  1,   0}, // #14181
  { 4,  1,   0}, // #14182
  {14, 24,   0}, // #14183
  {28, 24,   0}, // #14184
  {33, 24,   0}, // #14185
  {36, 24,   0}, // #14186
  {37, 24,   0}, // #14187
  {41,  1,   0}, // #14188
  {42,  1,   0}, // #14189
  {43,  1,   0}, // #14190
  { 4,  1,   0}, // #14191
  {14, 62,   0}, // #14192
  {28, 62,   0}, // #14193
  {33, 62,   0}, // #14194
  {36, 62,   0}, // #14195
  {37, 62,   0}, // #14196
  {41,  1,   0}, // #14197
  {42,  1,   0}, // #14198
  {43,  1,   0}, // #14199
  { 4,  1,   0}, // #14200
  {11,  4,   0}, // #14201
  {41,  5,   0}, // #14202
  {42,  1,   0}, // #14203
  {44,  1,   0}, // #14204
  { 4,  1,   0}, // #14205
  {14,  1,   0}, // #14206
  {16,  1,   0}, // #14207
  {20,  1,   0}, // #14208
  {21,  1,   0}, // #14209
  {24,  1,   0}, // #14210
  {25,  1,   0}, // #14211
  {27,  1,   0}, // #14212
  {28,  1,   0}, // #14213
  {29,  1,   0}, // #14214
  {33,  1,   0}, // #14215
  {34,  1,   0}, // #14216
  {35,  1,   0}, // #14217
  {36,  1,   0}, // #14218
  {37,  1,   0}, // #14219
  {39,  1,   0}, // #14220
  {40,  1,   0}, // #14221
  {41,  1,   0}, // #14222
  {42,  1,   0}, // #14223
  {43,  1,   0}, // #14224
  {14,  1,   0}, // #14225
  {15,  1,   0}, // #14226
  {19,  1,   0}, // #14227
  {20,  1,   0}, // #14228
  {21,  1,   0}, // #14229
  {24,  1,   0}, // #14230
  {28,  1,   0}, // #14231
  {29,  1,   0}, // #14232
  {32,  1,   0}, // #14233
  {33,  1,   0}, // #14234
  {34,  1,   0}, // #14235
  {36,  1,   0}, // #14236
  {37,  1,   0}, // #14237
  {38,  1,   0}, // #14238
  {42,  1,   0}, // #14239
  {44,  1,   0}, // #14240
  { 4,  1,   0}, // #14241
  {14,  2,   0}, // #14242
  {28,  2,   0}, // #14243
  {33,  2,   0}, // #14244
  {36,  2,   0}, // #14245
  {37,  2,   0}, // #14246
  {41,  1,   0}, // #14247
  {42,  1,   0}, // #14248
  {43,  1,   0}, // #14249
  { 4,  1,   0}, // #14250
  {11,  7,   0}, // #14251
  {41,  8,   0}, // #14252
  {42,  2,   0}, // #14253
  {43,  1,   0}, // #14254
  {44,  1,   0}, // #14255
  { 4,  1,   0}, // #14256
  {10,  8,   0}, // #14257
  {11,  8,   0}, // #14258
  {41,  9,   0}, // #14259
  {42,  1,   0}, // #14260
  {43,  1,   0}, // #14261
  {14,  3,   0}, // #14262
  {28,  3,   0}, // #14263
  {33,  3,   0}, // #14264
  {36,  3,   0}, // #14265
  {37,  3,   0}, // #14266
  { 4,  1,   0}, // #14267
  {14,  3,   0}, // #14268
  {28,  3,   0}, // #14269
  {33,  3,   0}, // #14270
  {36,  3,   0}, // #14271
  {37,  3,   0}, // #14272
  {41,  1,   0}, // #14273
  {42,  1,   0}, // #14274
  {43,  1,   0}, // #14275
  { 4,  1,   0}, // #14276
  {14,  8,   0}, // #14277
  {28,  8,   0}, // #14278
  {33,  8,   0}, // #14279
  {36,  8,   0}, // #14280
  {37,  8,   0}, // #14281
  {41,  1,   0}, // #14282
  {42,  1,   0}, // #14283
  {43,  1,   0}, // #14284
  { 4,  1,   0}, // #14285
  {14,  2,   0}, // #14286
  {16,  2,   0}, // #14287
  {20,  2,   0}, // #14288
  {21,  2,   0}, // #14289
  {24,  2,   0}, // #14290
  {25,  2,   0}, // #14291
  {27,  2,   0}, // #14292
  {28,  2,   0}, // #14293
  {29,  2,   0}, // #14294
  {33,  2,   0}, // #14295
  {34,  2,   0}, // #14296
  {35,  2,   0}, // #14297
  {36,  2,   0}, // #14298
  {37,  2,   0}, // #14299
  {39,  2,   0}, // #14300
  {40,  2,   0}, // #14301
  {41,  1,   0}, // #14302
  {42,  1,   0}, // #14303
  {43,  1,   0}, // #14304
  {14,  1,   0}, // #14305
  {30,  1,   0}, // #14306
  {14,  6,   0}, // #14307
  {22,  6,   0}, // #14308
  {23,  6,   0}, // #14309
  {26,  6,   0}, // #14310
  {27,  6,   0}, // #14311
  {28,  6,   0}, // #14312
  {31,  6,   0}, // #14313
  {33,  6,   0}, // #14314
  {36,  6,   0}, // #14315
  {37,  6,   0}, // #14316
  {14,  4,   0}, // #14317
  {25,  4,   0}, // #14318
  {27,  4,   0}, // #14319
  {28,  4,   0}, // #14320
  {33,  4,   0}, // #14321
  {35,  4,   0}, // #14322
  {36,  4,   0}, // #14323
  {37,  4,   0}, // #14324
  {39,  4,   0}, // #14325
  {40,  4,   0}, // #14326
  {14,  5,   0}, // #14327
  {25,  5,   0}, // #14328
  {27,  5,   0}, // #14329
  {28,  5,   0}, // #14330
  {33,  5,   0}, // #14331
  {35,  5,   0}, // #14332
  {36,  5,   0}, // #14333
  {37,  5,   0}, // #14334
  {39,  5,   0}, // #14335
  {40,  5,   0}, // #14336
  {14,  3,   0}, // #14337
  {20,  3,   0}, // #14338
  {21,  3,   0}, // #14339
  {24,  3,   0}, // #14340
  {28,  3,   0}, // #14341
  {29,  3,   0}, // #14342
  {33,  3,   0}, // #14343
  {34,  3,   0}, // #14344
  {36,  3,   0}, // #14345
  {37,  3,   0}, // #14346
  {14,  5,   0}, // #14347
  {20,  5,   0}, // #14348
  {21,  5,   0}, // #14349
  {24,  5,   0}, // #14350
  {28,  5,   0}, // #14351
  {29,  5,   0}, // #14352
  {33,  5,   0}, // #14353
  {34,  5,   0}, // #14354
  {36,  5,   0}, // #14355
  {37,  5,   0}, // #14356
  {14,  6,   0}, // #14357
  {20,  2,   0}, // #14358
  {21,  2,   0}, // #14359
  {22,  2,   0}, // #14360
  {23,  2,   0}, // #14361
  {24,  2,   0}, // #14362
  {25,  2,   0}, // #14363
  {26,  2,   0}, // #14364
  {27,  4,   0}, // #14365
  {28,  6,   0}, // #14366
  {29,  2,   0}, // #14367
  {31,  2,   0}, // #14368
  {33,  6,   0}, // #14369
  {34,  2,   0}, // #14370
  {35,  2,   0}, // #14371
  {36,  6,   0}, // #14372
  {37,  6,   0}, // #14373
  {39,  2,   0}, // #14374
  {40,  2,   0}, // #14375
  {14,  2,   0}, // #14376
  {27,  2,   0}, // #14377
  {28,  2,   0}, // #14378
  {33,  2,   0}, // #14379
  {36,  2,   0}, // #14380
  {37,  2,   0} // #14381
}; // X86WriteProcResTable

// {Cycles, WriteResourceID}
extern const llvm::MCWriteLatencyEntry X86WriteLatencyTable[] = {
  { 0,  0}, // Invalid
  { 1,  0}, // #1 WriteALU_WriteZero_WriteVecALU_WriteJump_WriteMove_WriteLEA_WriteRMW_WriteADC_WriteFSign_WriteNop_WriteFLogic_WriteFBlend_WriteFVarBlend_WriteBSWAP32_WriteBitTest_WriteBitTestSet_WriteCMOV_WriteFCom_WriteVecALUX_WriteFLDC_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteFLD0_WriteFLD1_WriteVecMoveX_WriteVecShiftImm_WriteFMoveX_WriteShuffleX_WriteVarBlend_WriteBlend_WriteVarShuffleX_WriteVecShiftImmX_WriteShift_WriteShuffleY_WriteFLogicY_WriteFBlendY_WriteVecALUY_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecLogicY_WriteBlendY_WriteFVarShuffleY_WriteVecShiftImmY_WriteVarVecShift_WriteVarVecShiftY_WriteVarShuffleY_ADLPWriteResGroup40_ADLPWriteResGroup155_ADLPWriteResGroup151_ADLPWriteResGroup188_ADLPWriteResGroup189_ADLPWriteResGroup57_ADLPWriteResGroup21_ADLPWriteResGroup54_ADLPWriteResGroup22_ADLPWriteResGroup191_ADLPWriteResGroup6_ADLPWriteResGroup212_ADLPWriteResGroup173_ADLPWriteResGroup74_ADLPWriteResGroup77_ADLPWriteResGroup85_ADLPWriteResGroup128_ADLPWriteResGroup129_ADLPWriteResGroup130_ADLPWriteResGroup137_ADLPWriteResGroup144_ADLPWriteResGroup187_ADLPWriteResGroup210_ADLPWriteResGroup235_WriteCMPXCHGRMW_WriteJumpLd_WriteFStoreX_WriteFLoadX_AtomWrite0_1_WriteADCLd_WriteALULd_WriteFLogicLd_WriteBSWAP64_WriteBitTestImmLd_WriteLoad_WriteCMOVLd_WriteStore_WriteVecExtractSt_WriteVecALUXLd_WriteFShuffleLd_WriteVecLoadX_WriteFence_WriteVecStoreX_WriteVecMoveFromGpr_WriteVecStoreNT_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVarShuffleLd_WriteVecLoadNT_WriteStoreNT_WriteFStoreNTX_WriteShuffleXLd_WriteVecLogicXLd_WriteRotate_WriteRotateCL_WriteShiftLd_WriteShiftCL_WriteSETCC_WriteVecShiftImmXLd_WriteFTestLd_AtomWrite1_1_AtomWrite0_1_1_AtomWrite01_1_WriteSHDrri_WriteLAHFSAHF_WriteVecMoveToGpr_WriteVecTest_WriteSETCCStore_WriteSHDrrcl_WriteFMaskedStore64_WriteFMaskedStore32_WriteVecMaskedStore32_WriteVecMaskedStore64_WriteFStoreY_WriteBZHI_WriteFCMOV_WriteXCHG_WriteFComX_WriteFSqrt80_WriteSTMXCSR_WriteShuffle256_WriteVarShuffle256_WriteVecStoreY_WriteVPMOV256_WriteVecTestY_WriteFTestY_PdWriteTST_F_UCOM_FPPr_PdWriteLEA16r_PdWriteADCSBB64ri32_PdWriteVMOVUPDYmrVMOVUPSYmr_PdWriteVMOVDQUYmr_PdWriteMOVDQArr_PdWriteSETGEmSETGmSETLEmSETLm_WriteBLS_WriteMMXMOVMSK_WriteVecStoreNTY_WriteFStoreNTY_BWWriteResGroup10_BWWriteResGroup2_BWWriteResGroup5_BWWriteResGroup6_BWWriteResGroup3_BWWriteResGroup4_BWWriteResGroup7_BWWriteResGroup8_BWWriteResGroup9_WriteBEXTR_WriteLZCNT_WritePHAdd_WritePOPCNT_WriteFShuffle256_JWriteVecExtractF128_JWriteZeroIdiomYmm_WriteShuffleZ_WriteFLogicZ_WriteVecALUZ_WriteFMoveZ_WriteFShuffleZ_WriteVecMoveZ_WriteVecLogicZ_WriteFVarShuffleZ_WriteVecShiftImmZ_WriteVarVecShiftZ_WriteVarShuffleZ_SKXWriteResGroup9_SKXWriteResGroup11_SKXWriteResGroup3_SKXWriteResGroup6_SKXWriteResGroup7_SKXWriteResGroup4_SKXWriteResGroup8_SKXWriteResGroup10_SKXWritePSUB_WriteCvtSS2SD_WriteFVarShuffle256_SBWriteResGroup2_SBWriteResGroup1_SBWriteResGroup4_SBWriteResGroup5_SBWriteResGroupVzeroupper_WriteBitTestRegLd_HWWriteBTRSCmr_HWWrite2P1_HWWriteP01_HWWrite2P01_HWWrite2P0156_P23_HWWriteResGroup1_HWWriteINTO_HWWritePushA_HWWritePopA_HWWriteP1_HWWriteBOUND_HWWriteResGroup3_HWWriteResGroup6_HWWriteResGroup7_HWWrite3P01_HWWriteP0156_P23_HWWriteRETI_HWWriteRDPMC_HWWriteRDRAND_HWWriteFNSAVE_HWWriteFRSTOR_HWWriteResGroup2_HWWriteResGroup4_HWWriteResGroup5_HWWriteResGroup8_HWWriteResGroup9_HWWriteResGroup10_HWWriteADC0_WriteFVarBlendY_WriteFVarBlendZ_WriteVarBlendY_WriteVarBlendZ_SPRWriteResGroup43_SPRWriteResGroup164_SPRWriteResGroup160_SPRWriteResGroup193_SPRWriteResGroup52_SPRWriteResGroup61_SPRWriteResGroup23_SPRWriteResGroup58_SPRWriteResGroup24_SPRWriteResGroup195_SPRWriteResGroup216_SPRWriteResGroup95_SPRWriteResGroup137_SPRWriteResGroup92_SPRWriteResGroup78_SPRWriteResGroup81_SPRWriteResGroup89_SPRWriteResGroup138_SPRWriteResGroup139_SPRWriteResGroup140_SPRWriteResGroup147_SPRWriteResGroup153_SPRWriteResGroup192_SPRWriteResGroup214_SPRWriteResGroup240_SPRWriteResGroup508_ICXWriteResGroup9_ICXWriteResGroup11_ICXWriteResGroup3_ICXWriteResGroup6_ICXWriteResGroup7_ICXWriteResGroup4_ICXWriteResGroup8_ICXWriteResGroup10_ICXWritePSUB_SKLWriteResGroup9_SKLWriteResGroup11_SKLWriteResGroup3_SKLWriteResGroup6_SKLWriteResGroup7_SKLWriteResGroup4_SKLWriteResGroup8_SKLWriteResGroup10_SKLWritePSUB_WriteFCmp64X_WriteFCmpX_WriteFMOVMSK_WriteVecMOVMSK_WriteVecShiftX_WriteFCmp64Y_WriteFCmpY_WriteVecShiftY_ZnWriteFPU3Lat1_ZnWriteFLDr_ZnWriteFPU0Lat1_ZnWriteFXCH_ZnWriteJCXZ_ZnWriteLD_F80m_ZnWriteLOOPE_ZnWriteCMPXCHG8B_ZnWriteRET_ZnWritePCMPGTQr_ZnWriteFPU01Y_ZnWriteCALLr_ZnXADD_ZnWriteFPU013_ZnWriteSHA1MSG2r_ZnWriteSHA1NEXTEr_Zn2WriteFPU3Lat1_Zn2WriteFLDr_Zn2WriteFPU0Lat1_Zn2WriteFXCH_Zn2WriteJCXZ_Zn2WriteLD_F80m_Zn2WriteLOOPE_Zn2WriteCMPXCHG8B_Zn2WriteRET_Zn2WritePCMPGTQr_Zn2WriteFPU01Y_Zn2WriteCALLr_Zn2XADD_Zn2WriteFPU013_Zn2WriteSHA1MSG2r_Zn2WriteSHA1NEXTEr_Zn2WriteXCHG_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_WriteVecMOVMSKY_Zn3WriteLFENCE_Zn3WriteMoveExtend_Zn3WriteVecALUXMMX_Zn3WriteRotateR1_Zn3WriteMOVMMX_Zn3WriteSFENCE_Zn3WriteMOVBEmr_Zn3WriteCvtPD2IMMX_Zn3WriteSHA1MSG2rr_SHA1NEXTErr_Zn3WriteALUSlow_Zn3WriteMaterialize32bitImm_Zn3WriteADC8mr_SBB8mr_Zn3WriteWriteXCHGUnrenameable_Zn3WritePOPCNT16rr_Zn3WriteLZCNT16rr_Zn3WriteMOVMMXSlow_Zn3WriteVecALUXSlow_Zn3WriteVecALUYSlow_WriteBSF_WriteBSR_WriteCvtSD2I_WriteVecShiftZ_Zn4WriteLFENCE_Zn4WriteMoveExtend_Zn4WriteRotateR1_Zn4WriteMOVMMX_Zn4WriteSFENCE_Zn4WriteMOVBEmr_Zn4WriteSHA1MSG2rr_SHA1NEXTErr_Zn4WriteALUSlow_Zn4WriteMaterialize32bitImm_Zn4WriteADC8mr_SBB8mr_Zn4WriteWriteXCHGUnrenameable_Zn4WritePOPCNT16rr_Zn4WriteLZCNT16rr_Zn4WriteMOVMMXSlow_Zn4WriteVecALUYSlow_Zn4WriteVecOpMask_Zn4WriteVecOpMaskMemMov_Zn4WriteVecOpMaskKRMov_Zn4WriteSHIFTri
  {12,  0}, // #2 WriteCMPXCHGRMW_WriteFStoreX_WriteFStoreY_WriteRMW_WriteAESDecEncLd_WriteAESKeyGenLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtSS2ILd_WriteStore_WriteFHAddLd_WriteVecStoreX_WriteShiftLd_WriteSHDmrcl_WriteSHDmri_WriteFSqrtX_WriteSTMXCSR_WriteFCmp64YLd_WriteFCmpYLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteFMAYLd_WriteVecStoreY_WriteMPSADYLd_WriteFMul64YLd_WriteFMulYLd_WriteVecTestYLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteFSqrtY_ADLPWriteResGroup36_ADLPWriteResGroup179_ADLPWriteResGroup50_ADLPWriteResGroup176_ADLPWriteResGroup142_ADLPWriteResGroup139_ADLPWriteResGroup120_ADLPWriteResGroup115_ADLPWriteResGroup229_ADLPWriteResGroup69_ADLPWriteResGroup127_ADLPWriteResGroup134_WriteIMul64Ld_WriteIMul64RegLd_WriteDPPD_WriteFRcpXLd_WriteFRsqrtXLd_WriteDiv8_WriteVecExtract_WriteIDiv8_WriteFMOVMSK_WriteCLMul_WritePCmpIStrMLd_WriteVecMOVMSK_PdWriteRCL8rCL_PdWriteRCR8ri_PdWriteVPCLMULQDQrr_WriteMPSADLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_WriteFRndYLd_BWWriteResGroup135_WriteCvtSS2SDLd_WritePCmpIStrILd_WriteDPPSY_WriteCLMulLd_WriteVecIMulYLd_WriteVecIMulZLd_SKXWriteResGroup200_SKXWriteResGroup175_SKXWriteResGroup176_SKXWriteResGroup177_WriteAESIMC_WritePSADBWYLd_WritePSADBWZLd_WriteFHAddYLd_WriteFMul64ZLd_WriteFMulZLd_WritePMULLDYLd_WritePMULLDZLd_SBWriteResGroup111_WriteFRndLd_WriteFMAZLd_WriteCvtI2PDZLd_WriteCvtPD2IZLd_HWWriteResGroup91_3_WriteFAddYLd_WriteFAddZLd_WriteFCmpZLd_WriteCvtI2PSZLd_WriteCvtPS2PHZSt_WriteFRndZLd_WriteFCmp64ZLd_SPRWriteResGroup37_SPRWriteResGroup185_SPRWriteResGroup54_SPRWriteResGroup182_SPRWriteResGroup554_SPRWriteResGroup151_SPRWriteResGroup148_SPRWriteResGroup129_SPRWriteResGroup124_SPRWriteResGroup235_SPRWriteResGroup449_SPRWriteResGroup504_SPRWriteResGroup501_SPRWriteResGroup505_SPRWriteResGroup502_SPRWriteResGroup257_SPRWriteResGroup73_SPRWriteResGroup136_SPRWriteResGroup144_SPRWriteResGroup265_SPRWriteResGroup272_SPRWriteResGroup303_SPRWriteResGroup347_SPRWriteResGroup351_SPRWriteResGroup419_SPRWriteResGroup444_SPRWriteResGroup446_SPRWriteResGroup465_SPRWriteResGroup467_SPRWriteResGroup489_SPRWriteResGroup517_SPRWriteResGroup518_SPRWriteResGroup546_ICXWriteResGroup200_ICXWriteResGroup175_ICXWriteResGroup176_ICXWriteResGroup177_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFMAXLd_ZnWriteCVTPD2DQLd_ZnWriteFIST_ZnWriteFPU03_ZnWriteCVSTSI2SILd_Zn2WriteFIST_Zn2WriteFPU03_WriteVarShuffle256Ld_WriteFRcpZLd_WriteFRsqrtZLd
  { 6,  0}, // #3 WriteJumpLd_WriteBEXTR_WriteBitTestImmLd_WriteFHAdd_WriteCvtPH2PS_WriteCvtPS2PH_WriteVecTestY_ADLPWriteResGroup95_ADLPWriteResGroup5_ADLPWriteResGroup94_ADLPWriteResGroup154_ADLPWriteResGroup238_ADLPWriteResGroup53_ADLPWriteResGroup234_ADLPWriteResGroup30_ADLPWriteResGroup209_ADLPWriteResGroup111_ADLPWriteResGroup224_ADLPWriteResGroup228_ADLPWriteResGroup232_ADLPWriteResGroup141_ADLPWriteResGroup153_WriteFAdd64X_WriteFCmp64X_WriteFCmpX_WriteCvtI2PS_WriteCvtPS2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2SD_WriteIMul16Reg_WriteIMul16Imm_WriteIMul32_WriteFLD1_AtomWrite01_6_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteCMPXCHG_WriteFComXLd_WriteCRC32Ld_WriteFComLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteLZCNTLd_WritePHAdd_WritePHAddX_WritePOPCNTLd_WriteFRndLd_WriteTZCNTLd_PdWriteALURMW_WriteRMW_WriteBEXTRLd_WriteBLSLd_WriteIMul64_WriteIMul64Reg_WriteIMul64Imm_WriteVecInsertLd_WriteStore_WriteVecTestLd_WriteShuffle256Ld_WriteVarShuffle256Ld_WriteFMaskedStore64Y_WriteFMaskedLoadY_WriteFMaskedStore32Y_WriteVecMaskedLoadY_WriteVPMOV256Ld_WriteVecTestYLd_WriteFTestYLd_WriteFTestLd_PdWriteXLAT_PdWriteXADDm_PdWriteVBROADCASTYLd_PdWriteFCOMPm_PdWriteMMX_CVTPD2PIrrMMX_CVTPI2PDrr_PdWriteLXADD_PdWriteBMI1m_PdWriteCRC32r32r32_PdWriteMMX_CVTTPD2PIrr_WriteFLoadY_WriteADCLd_WriteALULd_WriteFLogicLd_WriteFBlendLd_WriteBitTestRegLd_WriteBZHILd_WriteCMOVLd_WriteCvtPS2PDLd_WriteCvtSS2SDLd_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVarShuffleLd_WriteVecShiftLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVarShuffleXLd_WriteShiftLd_WriteSHDrrcl_WriteCvtI2PDY_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecShiftImmXLd_BWWriteResGroup69_BWWriteResGroup66_BWWriteResGroup70_BWWriteResGroup58_BWWriteResGroup71_BWWriteResGroup36b_BWWriteResGroup65_BWWriteResGroup62_BWWriteResGroup68_BWWriteResGroup59_BWWriteResGroup64_WriteIMul16Ld_WriteIMul16RegLd_WriteIMul32Ld_WriteIMul8Ld_WritePHAddLd_WriteFLogicYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteFShuffleYLd_JWriteVBROADCASTYLd_WriteFLoadX_WriteCvtSD2I_WriteCvtSS2I_WriteVecLoadX_WriteCLMul_WriteCvtPS2PHSt_WriteFHAddY_SKXWriteResGroup86_SKXWriteResGroup72_SKXWriteResGroup81_SKXWriteResGroup82_SKXWriteResGroup87_SKXWriteResGroup88_SKXWriteResGroup44c_SKXWriteResGroup71_SKXWriteResGroup76_SKXWriteResGroup84_SKXWriteResGroup92a_SKXWriteResGroup79_SKXWriteResGroup73_SKXWriteResGroup80_SBWriteResGroup48_SBWriteResGroup53_SBWriteResGroup81_SBWriteResGroup49_SBWriteResGroup51_SBWriteResGroup52_WriteCvtI2PDZ_WriteCvtPD2IZ_WriteCvtPS2PHZ_WriteFRndZ_HWWriteResGroup18_HWWriteResGroup108_HWWriteResGroup60b_HWWriteResGroup0_HWWriteResGroup14_HWWriteResGroup107_HWWriteResGroup13_HWWriteResGroup16_SPRWriteResGroup104_SPRWriteResGroup5_SPRWriteResGroup103_SPRWriteResGroup163_SPRWriteResGroup243_SPRWriteResGroup57_SPRWriteResGroup239_SPRWriteResGroup32_SPRWriteResGroup213_SPRWriteResGroup120_SPRWriteResGroup230_SPRWriteResGroup234_SPRWriteResGroup237_SPRWriteResGroup494_SPRWriteResGroup150_SPRWriteResGroup162_SPRWriteResGroup251_SPRWriteResGroup253_SPRWriteResGroup365_SPRWriteResGroup437_SPRWriteResGroup438_SPRWriteResGroup443_SPRWriteResGroup520_SPRWriteResGroup538_ICXWriteResGroup86_ICXWriteResGroup72_ICXWriteResGroup81_ICXWriteResGroup82_ICXWriteResGroup87_ICXWriteResGroup88_ICXWriteResGroup44c_ICXWriteResGroup71_ICXWriteResGroup76_ICXWriteResGroup84_ICXWriteResGroup79_ICXWriteResGroup73_ICXWriteResGroup80_SKLWriteResGroup82_SKLWriteResGroup68_SKLWriteResGroup76_SKLWriteResGroup78_SKLWriteResGroup83_SKLWriteResGroup84_SKLWriteResGroup42c_SKLWriteResGroup67_SKLWriteResGroup72_SKLWriteResGroup80_SKLWriteResGroup88_SKLWriteResGroup75_SKLWriteResGroup69_ZnWriteBTRSCm_ZnWriteSHA1RNDS4r_Zn2WriteBTRSCm_Zn2WriteSHA1RNDS4r_WritePCmpEStrI_WritePCmpEStrM_WritePCmpIStrM_WriteSHDmrcl_WriteSHDmri_Zn3WriteXCHG32rm_XCHG64rm_Zn3WriteSHA1RNDS4rri_Zn3WriteSHA1MSG1rm_Zn3Writerm_SHA256MSG1rm_Zn3WriteVPERMYri_WriteCvtPD2PSZ_WriteCvtPS2PDZ_Zn4WriteXCHG32rm_XCHG64rm_Zn4WriteSHA1RNDS4rri_Zn4WriteSHA1MSG1rm_Zn4Writerm_SHA256MSG1rm_Zn4WriteVPERMYri_Zn4WriteSCALErr_Zn4WriteBF16_Zn4CONFLICTrr
  {100,  0}, // #4 WriteSystem_WriteMicrocoded_ADLPWriteResGroup168_ADLPWriteResGroup198_ADLPWriteResGroup68_ADLPWriteResGroup269_ADLPWriteResGroup27_ADLPWriteResGroup201_ADLPWriteResGroup203_ADLPWriteResGroup28_ADLPWriteResGroup82_ADLPWriteResGroup96_ADLPWriteResGroup97_ADLPWriteResGroup98_ADLPWriteResGroup99_ADLPWriteResGroup100_ADLPWriteResGroup101_ADLPWriteResGroup135_ADLPWriteResGroup166_ADLPWriteResGroup167_ADLPWriteResGroup184_ADLPWriteResGroup185_ADLPWriteResGroup186_ADLPWriteResGroup199_ADLPWriteResGroup200_ADLPWriteResGroup205_ADLPWriteResGroup218_ADLPWriteResGroup236_ADLPWriteResGroup239_ADLPWriteResGroup270_SPRWriteResGroup177_SPRWriteResGroup202_SPRWriteResGroup72_SPRWriteResGroup556_SPRWriteResGroup29_SPRWriteResGroup205_SPRWriteResGroup207_SPRWriteResGroup30_SPRWriteResGroup86_SPRWriteResGroup105_SPRWriteResGroup106_SPRWriteResGroup107_SPRWriteResGroup108_SPRWriteResGroup109_SPRWriteResGroup110_SPRWriteResGroup145_SPRWriteResGroup175_SPRWriteResGroup176_SPRWriteResGroup189_SPRWriteResGroup190_SPRWriteResGroup191_SPRWriteResGroup203_SPRWriteResGroup204_SPRWriteResGroup209_SPRWriteResGroup224_SPRWriteResGroup241_SPRWriteResGroup244_SPRWriteResGroup557_SPRWriteResGroup576_ZnWriteMicrocoded_Zn2WriteMicrocoded
  { 3,  0}, // #5 WriteSHDrri_WriteFAdd64X_WriteFAddX_WriteBSF_WriteBSR_WriteBZHI_WriteFCMOV_WriteCMPXCHG_WriteFComX_WriteCRC32_WriteIMul16Reg_WriteIMul32Reg_WriteIMul32Imm_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteLAHFSAHF_WriteLZCNT_WriteVecMoveToGpr_WriteVecMoveFromGpr_WritePHAdd_WriteMMXMOVMSK_WritePSADBW_WriteVarShuffle_WriteFMOVMSK_WriteCLMul_WriteVecMOVMSK_WritePOPCNT_WritePSADBWX_WriteTZCNT_WriteFAdd64Y_WriteFAddY_WriteFVarBlendY_WriteShuffle256_WriteFShuffle256_WriteVarShuffle256_WritePSADBWY_WriteVarBlendY_WriteFVarShuffle256_WriteVPMOV256_WriteFTest_ADLPWriteResGroup23_ADLPWriteResGroup104_ADLPWriteResGroup103_ADLPWriteResGroup63_ADLPWriteResGroup118_ADLPWriteResGroup20_ADLPWriteResGroup64_ADLPWriteResGroup170_ADLPWriteResGroup119_ADLPWriteResGroup24_ADLPWriteResGroup19_ADLPWriteResGroup226_ADLPWriteResGroup16_ADLPWriteResGroup124_ADLPWriteResGroup8_ADLPWriteResGroup217_ADLPWriteResGroup245_WriteVecShiftLd_WriteVecShiftXLd_AtomWrite01_3_WriteFLoadX_WriteLoad_WriteXCHG_WriteFCmp64X_WriteFCmpX_WriteVecLoadX_WriteVecLoadNT_WriteFRnd_WriteFMaskedLoad_WriteVecMaskedLoad_WriteCMPXCHGRMW_WriteFLDC_WriteFLD0_WriteFLD1_WriteFStoreNTX_WriteVarShuffleX_WriteSHDrrcl_WriteFStoreNTY_WriteFVarShuffleY_WriteVarVecShift_PdWriteCMPXCHG8rm_PdWriteCMPXCHG8rr_PdWriteCMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm_PdWriteCMPXCHG8B_PdWriteCMPXCHG16B_PdWriteEXTRQ_PdWriteINSERTQI_PdWriteSHLD16rrCLSHLD32rrCLSHRD32rrCL_WriteCvtI2PS_WriteCvtPS2I_WriteFMul64X_WriteFMulX_WriteMULX32_WriteMULX64_WritePHAddX_WriteRotateCL_WriteShiftCL_WriteFCmp64Y_WriteFCmpY_WriteCvtI2PSY_WriteCvtPS2IY_WriteFMul64Y_WriteFMulY_WritePHAddY_WriteVecMOVMSKY_WriteVarVecShiftY_BWWriteResGroup34_BWWriteResGroup38_BWWriteResGroup37_BWWriteResGroup27_BWWriteResGroup28_BWWriteResGroup33_BWWriteSETA_SETBEm_WriteAESDecEnc_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteVecExtractSt_WriteLDMXCSR_WriteMPSAD_WriteVecTest_WriteCvtPH2PSY_WriteCvtI2PDY_WriteCvtPS2PH_WriteFRndY_JSlowLEA16r_JWriteCMPXCHG8rr_WriteCvtPS2PD_WriteCvtSS2SD_WriteCvtPD2IY_WriteCvtPD2IZ_WriteCvtPS2IZ_WriteCvtPS2PDY_WriteCvtPS2PDZ_WritePSADBWZ_WriteVecTestY_SKXWriteResGroup42_SKXWriteResGroup34_SKXWriteResGroup48_SKXWriteResGroup47_SKXWriteResGroup45_SKXWriteResGroup43_SKXWriteResGroup31_SKXWriteResGroup32_SKXWriteResGroup41_SKXWriteResGroup30_SKXWriteResGroup37_SKXWriteResGroup38_SKXWritePCMPGTQ_SKXWriteSETA_SETBEm_WriteVecALU_WriteFAdd64Z_WriteFAddZ_WriteFCmpZ_WriteCvtI2PSZ_WriteCvtPH2PSZ_WriteCvtPS2PHY_WriteCvtPS2PHZ_WriteFRndZ_WriteFCmp64Z_SBWriteResGroup30_SBWriteResGroup21_SBWriteResGroup22_SBWriteResGroup24_SBWriteResGroup26_2_SBWriteCMOVA_CMOVBErr_SBWriteSETA_SETBEm_WriteVarVecShiftZ_HWWriteResGroup58_HWWriteResGroup45_HWWriteResGroup44_HWWriteResGroup50_HWWriteResGroup51_HWWriteResGroup57_HWWriteCMOVA_CMOVBErr_HWWriteSETA_SETBEm_WriteMove_WriteShuffleZ_WriteVecALUZ_WriteVarShuffleZ_SPRWriteResGroup25_SPRWriteResGroup113_SPRWriteResGroup112_SPRWriteResGroup67_SPRWriteResGroup127_SPRWriteResGroup22_SPRWriteResGroup68_SPRWriteResGroup128_SPRWriteResGroup26_SPRWriteResGroup21_SPRWriteResGroup232_SPRWriteResGroup18_SPRWriteResGroup133_SPRWriteResGroup418_SPRWriteResGroup250_SPRWriteResGroup96_SPRWriteResGroup263_SPRWriteResGroup223_SPRWriteResGroup260_SPRWriteResGroup267_SPRWriteResGroup441_ICXWriteResGroup42_ICXWriteResGroup34_ICXWriteResGroup48_ICXWriteResGroup47_ICXWriteResGroup45_ICXWriteResGroup43_ICXWriteResGroup31_ICXWriteResGroup32_ICXWriteResGroup41_ICXWriteResGroup30_ICXWriteResGroup37_ICXWriteResGroup38_ICXWritePCMPGTQ_ICXWriteSETA_SETBEm_SKLWriteResGroup40_SKLWriteResGroup32_SKLWriteResGroup46_SKLWriteResGroup45_SKLWriteResGroup43_SKLWriteResGroup41_SKLWriteResGroup29_SKLWriteResGroup30_SKLWriteResGroup39_SKLWriteResGroup35_SKLWriteResGroup36_SKLWritePCMPGTQ_SKLWriteSETA_SETBEm_ZnWriteCVTPS2PDr_ZnWriteMul16_ZnWriteMul32_ZnWriteVCVTPS2PDY_Zn2WriteCVTPD2PSr_Zn2WriteCVTPS2PDr_Zn2WriteCVTSS2SDr_Zn2WriteMul16_Zn2WriteMul32_Zn2WriteCVTPD2PSYr_Zn2WriteVCVTPS2PDY_WriteFTestY_Zn2WriteCVTPD2DQr_Zn2WriteCVTDQ2PDr_Zn2WriteCVSTSI2SDr_Zn2WriteEXTRQ_WriteCvtSD2SS_WriteCvtI2SD_WriteCvtI2SS_WriteVecIMulX_WritePHMINPOS_WritePMULLD_WriteFRcpX_WriteFRsqrtX_WriteVecIMulY_WritePMULLDY_WriteFRcpY_WriteFRsqrtY_Zn3WriteCvtI2PSMMX_Zn3WriteCMPXCHG8rr_Zn3WriteCMPXCHG8B_Zn3WriteRotateRightRI_Zn3WriteRotateRightRCL_Zn3WriteVPERM2I128rr_VPERM2F128rr_Zn3WriteEXTRQI_INSERTQI_Zn3WritePDEP_PEXT_Zn3WriteEXTRQ_INSERTQ_Zn3WriteSHA256MSG2rr_WriteVecIMulZ_WriteFMul64Z_WriteFMulZ_WriteFVarShuffleZ_WritePMULLDZ_Zn4WriteCMPXCHG8rr_Zn4WriteCMPXCHG8B_Zn4WriteRotateRightRI_Zn4WriteRotateRightRCL_Zn4WriteVPERM2I128rr_VPERM2F128rr_Zn4WriteEXTRQI_INSERTQI_Zn4WritePDEP_PEXT_Zn4WriteEXTRQ_INSERTQ_Zn4WriteSHA256MSG2rr_Zn4VPTESTZ128_Zn4PERMIT2_128
  { 7,  0}, // #6 WriteFLoadX_WriteAESKeyGen_WriteBLSLd_WriteCMOVLd_WriteCvtSD2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2I_WriteVecLoadX_WriteLDMXCSR_WriteVecLoadNT_WriteCvtI2PDY_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPS2PDY_ADLPWriteResGroup112_ADLPWriteResGroup152_ADLPWriteResGroup92_ADLPWriteResGroup58_ADLPWriteResGroup278_ADLPWriteResGroup208_ADLPWriteResGroup241_ADLPWriteResGroup78_ADLPWriteResGroup18_ADLPWriteResGroup52_ADLPWriteResGroup143_ADLPWriteResGroup195_ADLPWriteResGroup106_ADLPWriteResGroup140_ADLPWriteResGroup0_ADLPWriteResGroup12_ADLPWriteResGroup13_ADLPWriteResGroup41_ADLPWriteResGroup256_WriteFAdd64XLd_WriteFCmp64XLd_WriteFCmpXLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteIMul16_WriteIMul16RegLd_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul8Ld_WritePHAddX_AtomWrite0_1_7_AtomWrite0_1_7_4_AtomWrite01_7_WriteFVarBlendLd_WriteCvtSD2SSLd_WriteIMul64_WriteVecIMulLd_WritePSADBWLd_WriteMPSAD_WriteFMul64X_WriteVarBlendLd_WritePHMINPOSLd_WriteFRcpLd_WriteFRsqrtLd_SLMWriteResGroup1rm_WriteFLogicLd_WriteFBlendLd_WriteBSFLd_PdWriteBTSIm_PdWriteBTSRm_WriteFCmp64Ld_WriteFCmpLd_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WritePCmpIStrM_WritePHAddXLd_WriteShuffleYLd_WriteFLogicYLd_WriteFVarBlendYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteFShuffleYLd_WriteVecShiftImmXLd_PdWriteRCR32riRCR64ri_PdWriteVBROADCASTF128_PdWriteVEXTRACTF128mr_PdWriteRCL3264rCL_PdWriteRCR3264rCL_PdWriteVPPERMLd_WriteRMW_WriteAESDecEnc_WriteBEXTRLd_WriteVecShiftXLd_WriteVecTestLd_WriteCvtPS2PHYSt_WriteVecALUYLd_WriteFMaskedLoad_WriteMPSADY_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoad_WriteVecShiftImmYLd_WriteVarShuffleYLd_WriteVecShiftYLd_WriteFTestYLd_BWWriteResGroup80_BWWriteResGroup82_BWWriteResGroup90_BWWriteResGroup84_BWWriteResGroup89_BWWriteResGroup87_BWWriteResGroup88_BWWriteResGroup73_BWWriteResGroup77_BWWriteResGroup79_BWWriteResGroup74_BWWriteCMOVA_CMOVBErm_WriteAESIMCLd_WriteAESKeyGenLd_WriteCvtPS2PDLd_WriteVecIMulXLd_WriteVarShuffleLd_WriteFMulXLd_WriteFMulLd_WriteCLMulLd_WritePCmpIStrI_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRcpXLd_WriteFRsqrtXLd_WriteCvtPS2PDYLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteFLoadY_WriteFComXLd_WriteFComLd_WriteCvtPH2PSY_WriteCvtPD2PSZ_WriteCvtPH2PSZ_WriteCvtPS2PHZ_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVarVecShiftLd_SKXWriteResGroup100_SKXWriteResGroup99_SKXWriteResGroup95_SKXWriteResGroup89_SKXWriteResGroup101_SKXWriteResGroup111_SKXWriteResGroup104_SKXWriteResGroup109_SKXWriteResGroup107_SKXWriteResGroup108_SKXWriteResGroup96_SKXWriteResGroup90_SKXWriteResGroup93_SKXWriteResGroup92_SKXWriteResGroup93z_SKXWriteResGroup97_SKXWriteResGroup103_SKXWriteResGroup106_SKXWriteResGroup110_SKXWriteResGroup112_SKXWriteResGroup113_SKXWriteResGroup114_SKXWriteCMOVA_CMOVBErm_WriteADCLd_WriteVecInsertLd_WriteCvtPS2PDZLd_WriteFRcpZ_WriteFRsqrtZ_WriteFTestLd_SBWriteResGroup69_SBWriteResGroup25_1_SBWriteResGroup63_SBWriteResGroup68_SBWriteResGroup54_SBWriteResGroup58_SBWriteResGroup59_SBWriteResGroup62_SBWriteResGroup64_SBWriteResGroup66_SBWriteResGroup67_WriteCvtPH2PSYLd_WriteCvtPH2PSZLd_WriteCvtPS2PHZSt_HWWriteResGroup25_HWWriteResGroup37_HWWriteResGroup26_HWWriteResGroup0_1_HWWriteResGroup39_HWWriteXLAT_HWWriteResGroup114_HWWriteResGroup41_HWWriteResGroup17_HWWriteResGroup11_1_HWWriteResGroup36_2_WriteCvtPD2IZ_SPRWriteResGroup121_SPRWriteResGroup161_SPRWriteResGroup82_SPRWriteResGroup62_SPRWriteResGroup565_SPRWriteResGroup212_SPRWriteResGroup246_SPRWriteResGroup20_SPRWriteResGroup152_SPRWriteResGroup199_SPRWriteResGroup115_SPRWriteResGroup149_SPRWriteResGroup464_SPRWriteResGroup39_SPRWriteResGroup268_SPRWriteResGroup0_SPRWriteResGroup44_SPRWriteResGroup415_SPRWriteResGroup93_SPRWriteResGroup271_SPRWriteResGroup470_SPRWriteResGroup486_SPRWriteResGroup488_ICXWriteResGroup100_ICXWriteResGroup99_ICXWriteResGroup95_ICXWriteResGroup89_ICXWriteResGroup101_ICXWriteResGroup111_ICXWriteResGroup104_ICXWriteResGroup109_ICXWriteResGroup107_ICXWriteResGroup108_ICXWriteResGroup96_ICXWriteResGroup92_ICXWriteResGroup90_ICXWriteResGroup93_ICXWriteResGroup93z_ICXWriteResGroup97_ICXWriteResGroup103_ICXWriteResGroup106_ICXWriteResGroup110_ICXWriteResGroup112_ICXWriteResGroup113_ICXWriteResGroup114_ICXWriteCMOVA_CMOVBErm_SKLWriteResGroup95_SKLWriteResGroup94_SKLWriteResGroup91_SKLWriteResGroup85_SKLWriteResGroup96_SKLWriteResGroup103_SKLWriteResGroup98_SKLWriteResGroup102_SKLWriteResGroup100_SKLWriteResGroup101_SKLWriteResGroup92_SKLWriteCMOVA_CMOVBErm_WriteFHAdd_WriteIMulHLd_WriteFHAddY_Zn2WriteMul16Ld_Zn2WriteMul32Ld_WriteMULX32Ld_WriteMULX64Ld_WriteFCMOV_WriteCRC32Ld_WriteIMul16Ld_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul64Ld_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFVarShuffle256_Zn3WriteCMPXCHG8rm_LCMPXCHG8_Zn3WriteVPERM2F128rm_Zn3WriteXCHG8rm_XCHG16rm_Zn3WriteRotateRightMI_Zn3WriteRotateRightMCL_Zn3WriteSHA256MSG2rm_WriteDPPD_Zn4WriteCMPXCHG8rm_LCMPXCHG8_Zn4WriteVPERM2F128rm_Zn4WriteXCHG8rm_XCHG16rm_Zn4WriteRotateRightMI_Zn4WriteRotateRightMCL_Zn4WriteSHA256MSG2rm_Zn4WriteVPERMPSYrr
  { 8,  0}, // #7 WriteFLoadY_WriteAESIMC_WriteFLogicLd_WriteFBlendLd_WriteFVarBlendLd_WriteBSFLd_WriteBSRLd_WriteBZHILd_WriteFComXLd_WriteCRC32Ld_WriteFComLd_WriteVecALUXLd_WriteIMul16RegLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul64RegLd_WriteIMul64ImmLd_WriteIMul8Ld_WriteFShuffleLd_WriteLZCNTLd_WriteVecInsertLd_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlendLd_WriteBlendLd_WritePOPCNTLd_WriteVarShuffleXLd_WriteVecShiftXLd_WriteFRnd_WriteTZCNTLd_WriteCvtPH2PSY_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteFMaskedLoad_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecMaskedLoad_WriteVarVecShiftLd_WriteFTestLd_ADLPWriteResGroup37_ADLPWriteResGroup38_ADLPWriteResGroup171_ADLPWriteResGroup117_ADLPWriteResGroup172_ADLPWriteResGroup110_ADLPWriteResGroup225_ADLPWriteResGroup192_ADLPWriteResGroup147_ADLPWriteResGroup150_ADLPWriteResGroup175_ADLPWriteResGroup216_ADLPWriteResGroup240_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteFHAdd_WriteIMul16Ld_WritePHAddXLd_AtomWrite01_8_WriteAESDecEnc_WriteAESKeyGen_WriteCvtI2PSLd_WriteCvtPD2PSLd_WriteCvtPS2ILd_WriteCvtSD2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2ILd_WriteVecIMulXLd_WriteIMul32Ld_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePSADBWXLd_SLMWriteResGroup2rm_WriteVarShuffleLd_WriteVecShiftLd_WriteMPSAD_WriteCvtI2PDY_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPS2PDY_WriteFVarShuffleYLd_PdWriteVPERM2F128rm_PdWriteRCL3264ri_WriteCMPXCHGRMW_BWWriteResGroup100_WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteIMul16ImmLd_WritePHAddLd_WriteFMul64XLd_WriteMULX32Ld_WriteMULX64Ld_WriteFVarBlendYLd_WriteFMaskedLoadY_WriteVarBlendYLd_WriteVecMaskedLoadY_BWWriteResGroup97_BWWriteResGroup99_BWWriteResGroup154_BWWriteResGroup91_BWWriteResGroup92_WriteAESDecEncLd_WriteVecMoveFromGpr_WriteMPSADLd_WritePCmpIStrM_WriteVecTestLd_WriteFRndLd_WriteFAdd64YLd_WriteFAddYLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteFRndYLd_SKXWriteResGroup130_WriteCvtSS2SDLd_WritePSADBWLd_WriteShuffleYLd_WriteShuffleZLd_WriteFLogicYLd_WriteFLogicZLd_WriteFBlendYLd_WriteCvtPD2IYLd_WriteCvtPD2IZLd_WriteCvtPS2IZLd_WriteCvtPS2PDYLd_WriteCvtPS2PDZLd_WriteCvtPS2PHYSt_WriteCvtPS2PHZSt_WriteFRndZ_WriteVecALUYLd_WriteVecALUZLd_WriteFShuffleYLd_WriteFShuffleZLd_WriteVecLogicYLd_WriteVecLogicZLd_WriteBlendYLd_WriteVarBlendZLd_WriteFVarShuffleZLd_WriteVecShiftImmYLd_WriteVecShiftImmZLd_WriteVarVecShiftYLd_WriteVarVecShiftZLd_WriteVarShuffleYLd_WriteVarShuffleZLd_WriteVecShiftYLd_WriteVecShiftZLd_SKXWriteResGroup127_SKXWriteResGroup128_SKXWriteResGroup118_SKXWriteResGroup119_SKXWriteResGroup121_SKXWriteResGroup123_SKXWriteResGroup131_SKXWriteResGroup132_SKXWriteResGroup133_SKXWriteResGroup134_WriteVecALULd_WriteSHDmri_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSZLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WriteFTestYLd_SBWriteResGroup86_SBWriteResGroup84_SBWriteResGroup77_SBWriteResGroup83_SBWriteResGroup85_SBWriteResGroup87_SBWriteCMOVA_CMOVBErm_HWWriteResGroup12_HWWriteResGroup48_HWWriteResGroup46_HWWriteResGroup47_HWWriteResGroup145_HWWriteResGroup11_2_HWWriteResGroup13_1_HWWriteResGroup17_2_HWWriteCMOVA_CMOVBErm_WriteVecShiftImmXLd_SPRWriteResGroup40_SPRWriteResGroup41_SPRWriteResGroup178_SPRWriteResGroup126_SPRWriteResGroup179_SPRWriteResGroup119_SPRWriteResGroup231_SPRWriteResGroup196_SPRWriteResGroup383_SPRWriteResGroup289_SPRWriteResGroup156_SPRWriteResGroup159_SPRWriteResGroup181_SPRWriteResGroup222_SPRWriteResGroup245_SPRWriteResGroup219_SPRWriteResGroup283_SPRWriteResGroup291_SPRWriteResGroup297_SPRWriteResGroup320_SPRWriteResGroup343_SPRWriteResGroup361_SPRWriteResGroup362_SPRWriteResGroup484_SPRWriteResGroup506_SPRWriteResGroup521_SPRWriteResGroup533_ICXWriteResGroup130_ICXWriteResGroup127_ICXWriteResGroup128_ICXWriteResGroup118_ICXWriteResGroup119_ICXWriteResGroup121_ICXWriteResGroup123_ICXWriteResGroup131_ICXWriteResGroup132_ICXWriteResGroup133_ICXWriteResGroup134_SKLWriteResGroup119_SKLWriteResGroup116_SKLWriteResGroup117_SKLWriteResGroup107_SKLWriteResGroup108_SKLWriteResGroup110_SKLWriteResGroup112_WriteFLoadX_ZnWriteMul16Ld_ZnWriteMul32Ld_WriteVecLoadX_ZnWriteFPU13_WriteShuffleLd_WriteVecLogicLd_WriteFStoreNT_WriteFCmp64YLd_WriteFCmpYLd_ZnWriteLEAVE_ZnWritePushA_ZnWritePCMPGTQm_ZnWriteBROADCAST_ZnWriteFPU01Op2_ZnWriteVPBROADCAST256Ld_ZnWritePCMPGTQYm_ZnWriteFPU0Lat1Ld_ZnWriteVPBROADCAST128Ld_ZnWriteFPU013m_ZnWriteSHA1MSG2Ld_ZnWriteSHA1NEXTELd_Zn2WriteMul64Ld_Zn2WriteFPU13_Zn2WriteLEAVE_Zn2WritePushA_Zn2WritePCMPGTQm_Zn2WriteBROADCAST_Zn2WriteFPU01Op2_Zn2WriteVPBROADCAST256Ld_Zn2WritePCMPGTQYm_Zn2WriteFPU0Lat1Ld_Zn2WriteVPBROADCAST128Ld_Zn2WriteFPU013m_Zn2WriteSHA1MSG2Ld_Zn2WriteSHA1NEXTELd_WriteFLD0_WriteVecTestYLd_Zn3WriteVINSERTF128rmr_Zn3WriteVEXTRACTI128mr_Zn3WriteRotateLeftMI_Zn3WriteRotateLeftMCL_WriteFVarBlendZLd_Zn4WriteVINSERTF128rmr_Zn4WriteVEXTRACTI128mr_Zn4WriteRotateLeftMI_Zn4WriteRotateLeftMCL
  {11,  0}, // #8 WriteADCLd_WriteALULd_WriteBEXTRLd_WriteBitTestRegLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtPS2PDLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteFDivX_WritePHAddLd_WritePSADBWLd_WriteVarShuffleLd_WriteMPSADLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpIStrI_WritePCmpIStrM_WritePHMINPOSLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteFMALd_WriteFAdd64YLd_WriteFAddYLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WritePSADBWYLd_WriteFDivY_WriteFMAXLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WriteFTestYLd_ADLPWriteResGroup56_ADLPWriteResGroup156_ADLPWriteResGroup263_ADLPWriteResGroup123_AtomWrite01_11_WriteCvtPD2PS_WriteCvtSD2SSLd_WriteAESDecEncLd_WriteAESIMCLd_WriteAESKeyGenLd_WritePMULLD_WriteFHAdd_WriteVecMoveToGpr_WriteVecMoveFromGpr_WriteFHAddY_PdWriteRCR8rCL_PdWriteRCL16ri_BWWriteResGroup122_1_WriteFRndLd_WriteSHDmrcl_WriteFSqrtX_WriteCvtI2PDYLd_WriteFMAYLd_WriteVecIMulYLd_WriteFHAddYLd_WriteFRcpY_WriteFRsqrtY_BWWriteResGroup133_BWWriteResGroup123_BWWriteResGroup131_BWWriteResGroup132_WriteCMPXCHGRMW_WriteDPPS_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_JWriteCMPXCHG8B_JWriteCMPXCHG8rm_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteVecIMulXLd_WriteFMAZLd_WriteFAdd64ZLd_WriteFAddZLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFCmpZLd_WriteFCmp64ZLd_WriteMPSADYLd_WriteFMul64YLd_WriteFMul64ZLd_WriteFMulYLd_WriteFMulZLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_SKXWriteResGroup171_SKXWriteResGroup162_SKXWriteResGroup160_SKXWriteResGroup169_SKXWriteResGroup170_SKXWriteResGroup166_SKXWriteResGroup148_2_SKXWriteResGroup161_SKXWriteResGroup164_SKXWriteResGroup167_WriteFHAddLd_WritePCmpEStrM_WritePMULLDLd_WritePSADBWXLd_WriteCvtPD2PSZLd_WriteCvtPD2IZLd_WriteVecShiftYLd_WriteVecShiftZLd_SBWriteResGroup108_SBWriteResGroup104_SBWriteResGroup106_WriteCLMul_WriteVecTestYLd_WriteFRsqrtZ_HWWriteResGroup131_HWWriteFRNDINT_HWWriteResGroup91_2_HWWriteResGroup75_HWWriteResGroup129_HWWriteResGroup130_WriteFAddXLd_WriteCvtPH2PSZ_WriteCvtPS2PHZ_WritePSADBWZLd_WriteVarShuffleZLd_SPRWriteResGroup60_SPRWriteResGroup165_SPRWriteResGroup258_SPRWriteResGroup132_SPRWriteResGroup417_SPRWriteResGroup255_SPRWriteResGroup313_SPRWriteResGroup455_SPRWriteResGroup483_SPRWriteResGroup254_SPRWriteResGroup317_SPRWriteResGroup321_SPRWriteResGroup354_SPRWriteResGroup374_SPRWriteResGroup482_SPRWriteResGroup515_SPRWriteResGroup535_SPRWriteResGroup537_WriteCvtPD2PSLd_ICXWriteResGroup171_ICXWriteResGroup162_ICXWriteResGroup160_ICXWriteResGroup169_ICXWriteResGroup170_ICXWriteResGroup166_ICXWriteResGroup148_2_ICXWriteResGroup161_ICXWriteResGroup164_ICXWriteResGroup167_WriteCvtPD2ILd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_SKLWriteResGroup156_SKLWriteResGroup149_SKLWriteResGroup146_SKLWriteResGroup154_SKLWriteResGroup155_ZnWriteCVTPD2PSLd_ZnWriteCVTSS2SDLd_ZnWriteFPU3_WriteVecIMulLd_ZnWriteCVTPD2PSYLd_WriteFRndYLd_WritePMULLDYLd_ZnWriteFILD_ZnWriteSHA256RNDS2Ld_Zn2WriteFPU3_Zn2WriteFILD_Zn2WriteCVSTSI2SILd_Zn2WriteSHA256RNDS2Ld_WriteFComXLd_WriteDiv16_WriteFLDC_WriteIDiv16_WriteFLD1_WriteCLMulLd_WriteCvtPH2PSYLd_Zn3WriteVPERMPSYrm_WriteCvtI2PDZLd_WriteCvtPS2IZLd_WriteCvtPH2PSZLd_WriteFDivZ_WriteDPPSY_Zn4WriteVPERMPSYrm
  {10,  0}, // #9 WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteEMMS_WriteIMul16Ld_WriteCLMulLd_WritePMULLD_WritePSADBWXLd_WriteFVarBlendYLd_WriteVarBlendYLd_WritePHAddYLd_WritePMULLDY_ADLPWriteResGroup9_ADLPWriteResGroup169_ADLPWriteResGroup266_ADLPWriteResGroup15_WriteFComXLd_WriteCvtSD2SS_AtomWrite01_10_WriteFMul64XLd_WriteFRcpXLd_WriteFRsqrtXLd_AtomWrite0_1_10_WriteCMPXCHGRMW_WriteBSF_WriteBSR_WriteIMul64Ld_WriteLDMXCSR_WriteMPSADLd_WriteAESIMCLd_WriteAESKeyGenLd_WriteIMul64RegLd_WriteIMul64ImmLd_WritePHAddLd_WriteMMXMOVMSK_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpEStrM_WritePMULLDLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFAdd64YLd_WriteFAddYLd_WriteFMAXLd_WriteFMAYLd_WriteFMul64YLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_PdWriteCRC32r64r64_PdWriteRCL16rCL_PdWriteRCR16ri_PdWriteVFRCZP_PdWriteVFRCZS_PdWriteVFRCZY_WriteVecIMulXLd_WriteFHAddLd_WriteVecIMulLd_WritePSADBWLd_WritePHMINPOSLd_WriteVecTestYLd_BWWriteResGroup115_BWWriteResGroup117_WriteAESDecEncLd_WriteFCmp64XLd_WriteFCmpXLd_WriteCvtSD2SSLd_WritePCmpIStrI_WritePCmpIStrM_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSYLd_WriteCvtPH2PSZLd_WritePSADBWYLd_WritePSADBWZLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WritePMULLDZ_SKXWriteResGroup148_SKXWriteResGroup157_SKXWriteResGroup154_SKXWriteResGroup136_2_SKXWriteResGroup149_SKXWriteResGroup151_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtI2SSLd_WriteCvtSS2ILd_WritePCmpEStrILd_WriteSHDmrcl_WriteFMAZLd_WriteFAdd64ZLd_WriteFAddZLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFCmpZLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSYLd_WriteCvtI2PSZLd_WriteCvtPS2IYLd_WriteCvtPS2IZLd_WriteFRndYLd_WriteFRndZLd_WriteFCmp64ZLd_SBWriteResGroup101_WriteSHDmri_WriteCvtPD2PSZLd_WriteCvtPS2PDYLd_WriteCvtPS2PDZLd_WriteVarVecShiftYLd_WriteVarVecShiftZLd_HWWriteResGroup52_1_SPRWriteResGroup10_SPRWriteResGroup485_SPRWriteResGroup389_SPRWriteResGroup17_SPRWriteResGroup8_SPRWriteResGroup259_SPRWriteResGroup264_SPRWriteResGroup284_SPRWriteResGroup290_SPRWriteResGroup292_SPRWriteResGroup298_SPRWriteResGroup334_SPRWriteResGroup344_SPRWriteResGroup350_SPRWriteResGroup358_SPRWriteResGroup410_SPRWriteResGroup413_SPRWriteResGroup431_SPRWriteResGroup432_SPRWriteResGroup479_SPRWriteResGroup511_SPRWriteResGroup513_ICXWriteResGroup148_ICXWriteResGroup157_ICXWriteResGroup154_ICXWriteResGroup136_2_ICXWriteResGroup149_ICXWriteResGroup151_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtSS2SDLd_SKLWriteResGroup133_SKLWriteResGroup143_SKLWriteResGroup138_SKLWriteResGroup140_WriteCRC32Ld_ZnWriteCVTPS2PDLd_WriteFDivX_WriteFComLd_WritePHAddXLd_WriteFDivY_WriteVarVecShiftLd_Zn2WriteCVTPD2PSLd_Zn2WriteCVTPS2PDLd_Zn2WriteCVTSS2SDLd_WriteVecTestLd_WriteFRndLd_Zn2WriteCVTPD2PSYLd_WriteFVarShuffleYLd_WriteFVarShuffleLd_WriteFTestYLd_WriteFTestLd_Zn2WriteCVTPD2DQLd_WriteCvtPS2PDLd_WriteDiv8_WriteIDiv8_WriteCvtPH2PSLd_WriteVecIMulYLd_WritePMULLDYLd_Zn3WriteVZEROALL_Zn3WriteVPERMPDYmi_WriteCvtPD2IYLd_WriteCvtPD2IZLd_WriteVecIMulZLd_WriteFMul64ZLd_WriteFMulZLd_WriteFVarShuffleZLd_WritePMULLDZLd_Zn4WriteVZEROALL_Zn4WriteVPERMPDYmi
  { 5,  0}, // #10 WriteAESDecEnc_WriteLoad_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtPS2PD_WriteCvtSD2SS_WriteCvtSS2SD_WriteVecIMulX_WriteIMul16_WriteSHDrrcl_WriteVecIMulY_WriteFHAddY_WriteFTestY_ADLPWriteResGroup180_ADLPWriteResGroup181_ADLPWriteResGroup102_ADLPWriteResGroup242_ADLPWriteResGroup288_ADLPWriteResGroup182_ADLPWriteResGroup230_ADLPWriteResGroup29_ADLPWriteResGroup70_ADLPWriteResGroup126_ADLPWriteResGroup132_ADLPWriteResGroup254_ADLPWriteResGroup258_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFCom_WriteFComLd_WriteEMMS_WriteVecIMulXLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteLDMXCSR_WriteFMulXLd_WriteFMul64Ld_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRndLd_AtomWrite1_5_AtomWrite0_1_5_AtomWrite01_5_WriteRMW_WriteCMOVLd_WriteCvtI2PS_WriteCvtPS2I_WriteCvtSD2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2I_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteVecShiftLd_WriteVecShiftXLd_SLMWriteResGroup2rr_WriteJumpLd_WriteFLoadX_WriteFLoadY_WriteADCLd_WriteALULd_WriteFAdd64X_WriteAESIMC_WriteAESKeyGen_WriteBitTestImmLd_WriteBitTestRegLd_WriteBZHILd_WriteIMul16Imm_WriteVecLoadX_WritePHAdd_WriteVecLoadNT_WriteFMul64X_WritePMULLD_WriteFRcpX_WriteShiftLd_WriteFRsqrtX_WriteFAdd64Y_WriteFAddY_WriteFMAX_WriteFMAY_WriteVecLoadY_WriteVecLoadNTY_WriteFMul64Y_WriteFMulY_WriteFRcpY_WriteFRsqrtY_PdWriteX87Add_PdWriteX87Mul_PdWriteCRC32r32r16_PdWriteCMOVm_WriteCMPXCHG_WriteCLMul_WritePHMINPOS_WriteCvtPS2PHSt_WritePSADBWY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_BWWriteResGroup50_BWWriteResGroup54_BWWriteResGroup36_BWWriteResGroup57_BWWriteResGroup49_BWWriteResGroup47_BWWriteResGroup51_BWWriteResGroup55_BWWritePCMPGTQ_WriteBLSLd_WriteBSR_WriteTZCNTLd_WriteCvtPH2PS_WriteVecIMulZ_SKXWriteResGroup61_SKXWriteResGroup44b_SKXWriteResGroup69_SKXWriteResGroup63_SKXWriteResGroup67_SKXWriteResGroup62_SKXWriteResGroup65_SKXWriteResGroup66_WriteVecExtractSt_WriteSTMXCSR_WritePSADBWZ_WriteFMAZ_WriteFMul64Z_WriteFMulZ_WritePMULLDY_WritePMULLDZ_SBWriteResGroup33_SBWriteResGroup41_SBWriteResGroup47_SBWriteResGroup76_SBWriteResGroup35_SBWriteResGroup35_2_SBWriteResGroup36_SBWriteResGroup40_SBWriteResGroup45_SBWriteResGroup46_SBWritePCMPGTQ_HWWriteResGroup93_HWWriteResGroup99_HWWriteResGroup60_HWWriteResGroup88_HWWriteResGroup89_HWWriteResGroup94_HWWriteResGroup100_HWWritePCMPGTQ_SPRWriteResGroup186_SPRWriteResGroup111_SPRWriteResGroup247_SPRWriteResGroup575_SPRWriteResGroup187_SPRWriteResGroup236_SPRWriteResGroup367_SPRWriteResGroup340_SPRWriteResGroup31_SPRWriteResGroup74_SPRWriteResGroup135_SPRWriteResGroup142_SPRWriteResGroup414_SPRWriteResGroup252_SPRWriteResGroup463_SPRWriteResGroup469_ICXWriteResGroup61_ICXWriteResGroup44b_ICXWriteResGroup69_ICXWriteResGroup63_ICXWriteResGroup67_ICXWriteResGroup62_ICXWriteResGroup65_ICXWriteResGroup66_SKLWriteResGroup60_SKLWriteResGroup42b_SKLWriteResGroup65_SKLWriteResGroup61_SKLWriteResGroup63_WriteBEXTRLd_WriteStore_WritePOPCNTLd_WriteCvtI2PDY_WriteCvtI2PSY_ZnWriteCVTPD2PSYr_WriteCvtPD2IY_WriteCvtPS2IY_ZnWriteCVTPD2DQr_ZnWriteSTr_ZnWriteXCHGrm_ZnWriteST_FP80m_ZnWriteEXTRACTPSm_ZnWriteMOVBE_ZnWritePop16r_ZnWriteCVTDQ2PDr_ZnWriteCVSTSI2SDr_ZnWriteCVSTSI2SIr_WriteLZCNTLd_Zn2WriteSTr_Zn2WriteXCHGrm_Zn2WriteST_FP80m_Zn2WriteEXTRACTPSm_Zn2WriteMOVBE_Zn2WritePop16r_WriteVarShuffle256_Zn3WriteMOVSlow_Zn3WriteX87Arith_Zn3WriteX87Div_Zn3Writerm_SHA1MSG2rm_SHA1NEXTErm_Zn3WriteRotateM1_WriteBSFLd_WriteBSRLd_WriteFRcpZ_WriteFRsqrtZ_Zn4WriteMOVSlow_Zn4WriteX87Arith_Zn4WriteX87Div_Zn4Writerm_SHA1MSG2rm_SHA1NEXTErm_Zn4WriteRotateM1_Zn4WriteVPERMDYrr_Zn4MOVSrr_Zn4VPTESTZ_Zn4VRSQRT14PDZ256_Zn4PERMIT2Z
  {15,  0}, // #11 WriteAESIMCLd_WriteDiv32_WriteIDiv32_WriteFRndLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_ADLPWriteResGroup44_WriteCMPXCHG_WriteSTMXCSR_WriteDPPDLd_WriteDPPS_WriteDiv16_WriteIDiv16_WritePCmpEStrMLd_PdWriteVFRCZm_PdWriteVFRCZYm_WritePMULLDLd_BWWriteResGroup149_BWWriteResGroup147_WriteDiv8Ld_WriteIDiv8Ld_WriteFRndYLd_WriteFRndZLd_SKXWriteResGroup195_SKXWriteResGroup191_SKXWriteResGroup174_SKXWriteResGroup174z_SKXWriteResGroup194_SBWriteResGroup119_HWWriteResGroup115_HWWriteFXTRACT_HWWriteResGroup188_WriteCvtPD2PSZLd_SPRWriteResGroup47_SPRWriteResGroup299_SPRWriteResGroup266_SPRWriteResGroup498_SPRWriteResGroup500_SPRWriteResGroup473_SPRWriteResGroup300_SPRWriteResGroup218_SPRWriteResGroup269_SPRWriteResGroup281_SPRWriteResGroup304_SPRWriteResGroup311_SPRWriteResGroup328_SPRWriteResGroup341_SPRWriteResGroup382_SPRWriteResGroup393_SPRWriteResGroup397_SPRWriteResGroup408_SPRWriteResGroup411_SPRWriteResGroup475_SPRWriteResGroup493_ICXWriteResGroup195_ICXWriteResGroup191_ICXWriteResGroup174_ICXWriteResGroup174z_ICXWriteResGroup194_SKLWriteResGroup174_SKLWriteResGroup171_WriteFDiv64Y_WriteDiv16Ld_WriteIDiv16Ld_WriteFSqrtX_WriteDPPSY_WriteFSqrtY_WriteFSqrtZ
  { 2,  0}, // #12 WriteBLS_WriteBSWAP64_WriteXCHG_WriteFence_WritePHAddX_WriteVecShiftX_WriteRotate_WriteRotateCL_WriteShiftCL_WriteSETCC_WritePHAddY_ADLPWriteResGroup243_ADLPWriteResGroup268_ADLPWriteResGroup84_ADLPWriteResGroup62_ADLPWriteResGroup105_ADLPWriteResGroup55_ADLPWriteResGroup39_ADLPWriteResGroup219_ADLPWriteResGroup93_ADLPWriteResGroup222_ADLPWriteResGroup178_ADLPWriteResGroup11_ADLPWriteResGroup14_ADLPWriteResGroup25_WriteSHDrri_AtomWrite01_2_WriteLAHFSAHF_WriteStore_WriteSETCCStore_WriteSHDrrcl_WriteCMOV_WriteVecALU_WriteFLogic_WriteBEXTR_WriteFBlend_WriteFVarBlend_WriteBitTestSet_WriteFCmp64X_WriteFCmpX_WriteCRC32_WriteVecALUX_WriteEMMS_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteLZCNT_WriteVecStore_WriteVecStoreNT_WriteVecMove_WriteVecInsert_WriteVecShiftImm_WriteFStore_WriteShuffleX_WriteVarBlend_WriteBlend_WriteVecShiftImmX_WriteTZCNT_WriteShuffleY_WriteFLogicY_WriteFVarBlendY_WriteFBlendY_WriteFShuffle256_WriteFCmp64Y_WriteFCmpY_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecStoreNTY_PdWriteLAHF_PdWriteVEXTRACTF128rr_PdWriteMOVHPm_PdWriteBMI1_PdWriteSAHF_PdWriteBEXTRI_PdWriteBEXTRIm_PdWriteVPPERM_PdWrite3OpsLEA_WriteCvtPS2PD_WriteCvtSS2SD_WriteVecExtractSt_WriteVecTest_WriteSTMXCSR_WriteCvtPH2PSY_WriteVarBlendY_BWWriteResGroup14_BWWriteResGroup20_BWWriteResGroup22_BWWriteResGroup12_BWWriteResGroup17_BWWriteResGroup35_BWWriteResGroup25_BWWriteResGroup16_BWWriteResGroup18_BWWriteResGroup24_BWWriteResGroup87_1_BWWriteCMOVA_CMOVBErr_BWWriteSETA_SETBEr_WriteRMW_WriteFSign_WriteAESIMC_WriteAESKeyGen_WriteVecIMulX_WritePSADBW_WriteVarShuffle_WriteFMulX_WriteCLMul_WritePHMINPOS_WritePSADBWX_WriteVarShuffleX_WriteFRcpX_WriteFRsqrtX_WriteCvtPS2PDY_WriteFMulY_WriteFRcpY_WriteFRsqrtY_JWriteXCHG8rr_XADDrr_JWriteINSERTQ_JWrite3OpsLEA_WriteFComX_WriteVecMoveToGpr_WriteMMXMOVMSK_WriteFMOVMSK_WriteVecMOVMSK_WriteFVarBlendZ_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVarBlendZ_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_WriteVecMOVMSKY_WriteFTestY_SKXWriteResGroup17_SKXWriteResGroup23_SKXWriteResGroup25_SKXWriteResGroup14_SKXWriteResGroup44_SKXWriteResGroup28_SKXWriteResGroup20_SKXWriteResGroup13_SKXWriteResGroup21_SKXWriteResGroup27_SKXWriteResGroup107_1_SKXWriteResGroup29_SKXWriteCMOVA_CMOVBErr_SKXWriteSETA_SETBEr_WriteADC_WriteCvtPS2PDZ_WriteVecTestY_SBWriteResGroup18_SBWriteResGroup11_SBWriteResGroup12_SBWriteResGroup15_SBWriteResGroup23_SBWriteSETA_SETBEr_WriteCvtPH2PSZ_HWWriteResGroup30_HWWriteResGroup35_HWWriteResGroup21_HWWriteResGroup28_HWWriteResGroup33_HWWriteResGroup59_HWWriteResGroup24_HWWriteResGroup32_HWWriteResGroup19_HWWriteResGroup23_HWWriteResGroup23_16_HWWriteResGroup46_1_HWWriteSETA_SETBEr_SPRWriteResGroup248_SPRWriteResGroup555_SPRWriteResGroup88_SPRWriteResGroup66_SPRWriteResGroup114_SPRWriteResGroup59_SPRWriteResGroup42_SPRWriteResGroup28_SPRWriteResGroup225_SPRWriteResGroup102_SPRWriteResGroup228_SPRWriteResGroup184_SPRWriteResGroup13_SPRWriteResGroup16_SPRWriteResGroup27_SPRWriteResGroup491_SPRWriteResGroup509_SPRWriteResGroup514_ICXWriteResGroup17_ICXWriteResGroup23_ICXWriteResGroup25_ICXWriteResGroup14_ICXWriteResGroup44_ICXWriteResGroup28_ICXWriteResGroup20_ICXWriteResGroup13_ICXWriteResGroup21_ICXWriteResGroup27_ICXWriteResGroup107_1_ICXWriteResGroup29_ICXWriteCMOVA_CMOVBErr_ICXWriteSETA_SETBEr_SKLWriteResGroup17_SKLWriteResGroup23_SKLWriteResGroup25_SKLWriteResGroup14_SKLWriteResGroup42_SKLWriteResGroup28_SKLWriteResGroup20_SKLWriteResGroup13_SKLWriteResGroup21_SKLWriteResGroup27_SKLWriteResGroup100_1_SKLWriteCMOVA_CMOVBErr_SKLWriteSETA_SETBEr_WriteShuffle256_WriteVarShuffle256_WriteFVarShuffle256_ZnWriteEXTRACTPSr_ZnWriteVINSERT128r_ZnWriteEXTRQ_ZnWriteSHA1MSG1r_Zn2WriteEXTRACTPSr_Zn2WriteVINSERT128r_Zn2WriteSHA1MSG1r_WriteCvtSD2I_WriteCvtSS2I_WritePCmpIStrI_Zn3WriteCvtI2PDMMX_Zn3SlowLEA16r_Zn3WriteTZCNT16rr_Zn3WriteWriteFStoreMMX_Zn3WriteSHA1MSG1rr_Zn3WriteSHA256MSG1rr_Zn3Write3OpsLEA_WriteFCmpZ_WriteFCmp64Z_Zn4SlowLEA16r_Zn4WriteTZCNT16rr_Zn4WriteWriteFStoreMMX_Zn4WriteVecALUXSlow_Zn4WriteSHA1MSG1rr_Zn4WriteSHA256MSG1rr_Zn4WriteVFIXUPIMMPDZrr_VRANGESDrr_Zn4WriteSHIFTrr_Zn4WriteALIGN_Zn4WritePACK_Zn4WriteFCmp64_Zn4MOVS_Zn4CONFLICTZ128_Zn4PERMILP_Zn4PERMIT2_128rr_Zn4VecALUZSlow_Zn4Write3OpsLEA
  {18,  0}, // #13 WriteRMW_WriteDiv64_WriteFDivXLd_WriteFDivLd_WriteIDiv64_WritePMULLDLd_WriteFSqrt64X_WritePMULLDYLd_WriteFSqrt64Y_ADLPWriteResGroup34_ADLPWriteResGroup206_ADLPWriteResGroup116_AtomWrite01_18_WriteDPPSLd_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteDiv32Ld_WriteDiv64Ld_WriteIDiv32Ld_WriteIDiv64Ld_WritePCmpEStrI_BWWriteResGroup160_BWWriteResGroup159_BWWriteResGroup183_2_WriteFSqrtXLd_WriteFDivYLd_WriteFDivZ_SKXWriteResGroup208_SKXWriteResGroup207_SKXWriteResGroupVEX2_WriteAESIMCLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup149_WriteCvtPS2IZLd_WritePMULLDZLd_SPRWriteResGroup36_SPRWriteResGroup210_SPRWriteResGroup125_SPRWriteResGroup286_SPRWriteResGroup288_SPRWriteResGroup294_SPRWriteResGroup296_SPRWriteResGroup312_SPRWriteResGroup318_SPRWriteResGroup319_SPRWriteResGroup329_SPRWriteResGroup335_SPRWriteResGroup345_SPRWriteResGroup348_SPRWriteResGroup352_SPRWriteResGroup356_ICXWriteResGroup208_ICXWriteResGroup207_ICXWriteResGroupVEX2_SKLWriteResGroup185_SKLWriteResGroup184_SKLWriteResGroupVEX2_WriteFDivZLd_WriteDPPSYLd
  { 4,  0}, // #14 WriteFCmp64X_WriteFCmpX_WriteCvtI2PS_WriteCvtPS2I_WriteVecExtract_WriteIMul16Imm_WriteIMul32_WriteIMul64_WriteVecInsert_WriteMPSAD_WriteFMul64X_WriteFMulX_WriteMULX32_WriteMULX64_WritePHMINPOS_WriteVecTest_WriteFRcpX_WriteFRsqrtX_WriteFCmp64Y_WriteFCmpY_WriteCvtI2PSY_WriteCvtPS2IY_WriteFMAX_WriteFMAY_WriteMPSADY_WriteFMul64Y_WriteFMulY_WriteVecMOVMSKY_WriteVecShiftY_WriteFRcpY_WriteFRsqrtY_ADLPWriteResGroup83_ADLPWriteResGroup174_ADLPWriteResGroup60_ADLPWriteResGroup51_ADLPWriteResGroup190_ADLPWriteResGroup277_ADLPWriteResGroup121_ADLPWriteResGroup158_ADLPWriteResGroup214_WritePHAddLd_WriteVecIMulLd_WritePSADBWLd_WriteFMulLd_WriteVarShuffleX_WriteFRcpLd_WriteFRsqrtLd_WriteSHDmrcl_WriteSHDmri_AtomWrite01_4_WriteJumpLd_WriteADCLd_WriteALULd_WriteFAdd64X_WriteFLogicLd_WriteFBlendLd_WriteFVarBlend_WriteBitTestImmLd_WriteBitTestRegLd_WriteRMW_WriteCvtSD2SS_WriteCvtSS2SD_WriteVecExtractSt_WriteVecALUXLd_WriteIMul16Reg_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteMMXMOVMSK_WriteVarShuffleLd_WriteFMOVMSK_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlend_WriteBlendLd_WriteStore_WriteVecTestLd_WriteShiftLd_WriteFVarShuffleLd_WriteVecShiftImmXLd_WriteFTestLd_SLMWriteResGroup1rr_WriteBSR_WriteCvtI2SD_WriteCvtI2SS_WriteVecIMulX_WriteIMul32Reg_WriteIMul32Imm_WriteIMul8_WritePOPCNT_WritePSADBWX_WriteFRnd_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteFRndY_PdWriteMMX_CVTPI2PSrr_PdWriteMOVQ2DQrr_PdWriteVPERM2F128rr_PdWriteVPMACS_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtSD2I_WriteCvtSS2I_WriteCvtPS2PDY_WriteVecTestY_BWWriteResGroup42_BWWriteResGroup44_BWWriteResGroup45_BWWriteResGroup41_BWWriteResGroup43_WriteBEXTRLd_WriteBSF_WriteCMOVLd_WriteFHAdd_WriteLZCNTLd_WriteVecMoveToGpr_WritePMULLD_WritePOPCNTLd_WriteSHDrrcl_WriteFHAddY_WriteFVarShuffleY_WriteFTestY_WriteFAddX_WriteAESDecEnc_WriteFAdd64Y_WriteFAdd64Z_WriteFAddY_WriteFAddZ_WriteFCmpZ_WriteCvtI2PDY_WriteCvtI2PDZ_WriteCvtI2PSZ_WriteFMAZ_WriteFCmp64Z_WriteFMul64Z_WriteFMulZ_WriteVecShiftZ_WriteFRcpZ_SKXWriteResGroup54_SKXWriteResGroup55_SKXWriteResGroup57_SKXWriteResGroup49_SKXWriteResGroup50_SKXWriteResGroup33_SKXWriteResGroup50z_SKXWriteResGroup51_WritePCmpEStrI_WriteCvtPD2PSY_WriteCvtPD2PSZ_WriteCvtPD2IY_WriteCvtPD2IZ_WriteCvtPS2PHZSt_SBWriteResGroup31_SBWriteResGroup29_2_SBWriteResGroup24b_WriteCvtPS2PDZ_HWWriteResGroup73_HWWriteMOVS_HWWriteResGroup62_HWWriteResGroup81_HWWriteResGroup72_HWWriteResGroup61_HWWriteCMPS_HWWriteResGroup83_WriteFRndZ_SPRWriteResGroup87_SPRWriteResGroup64_SPRWriteResGroup55_SPRWriteResGroup194_SPRWriteResGroup564_SPRWriteResGroup130_SPRWriteResGroup167_SPRWriteResGroup91_SPRWriteResGroup314_SPRWriteResGroup516_SPRWriteResGroup519_SPRWriteResGroup220_SPRWriteResGroup492_SPRWriteResGroup456_SPRWriteResGroup249_SPRWriteResGroup256_SPRWriteResGroup481_SPRWriteResGroup522_ICXWriteResGroup54_ICXWriteResGroup55_ICXWriteResGroup57_ICXWriteResGroup49_ICXWriteResGroup50_ICXWriteResGroup33_ICXWriteResGroup50z_ICXWriteResGroup51_SKLWriteResGroup53_SKLWriteResGroup55_SKLWriteResGroup54_SKLWriteResGroup57_SKLWriteResGroup47_WriteAESIMC_WriteAESKeyGen_WriteLoad_ZnWriteCVTPD2PSr_ZnWriteCVTSS2SDr_ZnWriteMul64_WriteVecIMulY_WriteFMaskedStore64_WriteFMaskedStore32_WriteVecMaskedStore32_WriteVecMaskedStore64_WritePMULLDY_ZnWriteCVTPS2PIr_ZnWritePUSH_ZnWriteINSERTQ_ZnWriteSHA256RNDS2r_Zn2WriteMul16Imm_Zn2WriteMul64_WriteVPMOV256_Zn2WriteCVTPS2PIr_Zn2WritePUSH_Zn2WriteCVSTSI2SIr_Zn2WriteINSERTQ_Zn2WriteSHA256RNDS2r_WriteFComX_WriteCLMul_WriteCvtPH2PSY_Zn3WriteCMPXCHG16B_LCMPXCHG16B_Zn3WriteRotateLeftRI_Zn3WriteRotateLeftRCL_Zn3WriteVEXTRACTF128rr_VEXTRACTI128rr_Zn3WriteSHA256RNDS2rr_Zn3WriteMOVBE16rm_WriteCvtPS2IZ_WriteCvtPH2PSZ_WritePSADBWZ_Zn4WriteCMPXCHG16B_LCMPXCHG16B_Zn4WriteRotateLeftRI_Zn4WriteRotateLeftRCL_Zn4WriteVEXTRACTF128rr_VEXTRACTI128rr_Zn4WriteSHA256RNDS2rr_Zn4WriteMOVBE16rm_Zn4WriteVecALU2Slow_Zn4WriteBUSDr_VPMADDr_Zn4MOVSZ_Zn4VPTESTZ256_Zn4PERMIT2_256
  {20,  0}, // #15 WriteDiv16Ld_WriteFDiv64XLd_WriteIDiv16Ld_WriteFSqrtYLd_ADLPWriteResGroup159_ADLPWriteResGroup81_ADLPWriteResGroup48_ADLPWriteResGroup45_ADLPWriteResGroup79_ADLPWriteResGroup80_AtomWrite01_20_WritePCmpEStrMLd_WritePCmpIStrILd_WriteDPPDLd_WriteDPPSYLd_BWWriteResGroup167_BWWriteResGroup165_WriteAESKeyGen_WriteFSqrtZ_SKXWriteResGroup220_SKXWriteResGroup219_SKXWriteResGroup215_SKXWriteResGroupVEX4_WriteFDivXLd_WriteFDivLd_WriteCLMulLd_WriteFSqrtXLd_WriteFSqrtLd_WriteAESIMCLd_WriteDPPSLd_HWWriteResGroup156_HWWriteResGroup154_WriteFDiv64Ld_SPRWriteResGroup168_SPRWriteResGroup85_SPRWriteResGroup51_SPRWriteResGroup495_SPRWriteResGroup457_SPRWriteResGroup83_SPRWriteResGroup84_SPRWriteResGroup346_SPRWriteResGroup349_SPRWriteResGroup357_SPRWriteResGroup525_SPRWriteResGroup529_SPRWriteResGroup540_ICXWriteResGroup220_ICXWriteResGroup219_ICXWriteResGroup215_ICXWriteResGroupVEX4_SKLWriteResGroup193_SKLWriteResGroup192_SKLWriteResGroup189_SKLWriteResGroupVEX4_WriteFSqrt64X_WriteFSqrt80_WriteFSqrt64Y_WriteFDiv64YLd_WriteFDiv64ZLd
  {16,  0}, // #16 WriteDiv16_WriteDPPDLd_WriteIDiv16_WritePCmpEStrI_WritePCmpEStrM_WritePCmpIStrMLd_WriteFRndYLd_ADLPWriteResGroup267_WriteBSFLd_WriteBSRLd_WriteDiv8Ld_WriteFHAddLd_WriteIDiv8Ld_WritePCmpIStrILd_WriteFHAddYLd_WriteFDivXLd_BWWriteResGroup150_WriteFSqrt64X_WriteFSqrtXLd_WriteFSqrtLd_WritePMULLDYLd_BWWriteResGroup153_WriteDPPSLd_WriteFMaskedStore64Y_WriteFMaskedStore32_JWriteLOCK_CMPXCHG8rm_WriteFDivLd_WritePMULLDLd_WriteFRsqrtZLd_SKXWriteResGroup199_HWWriteResGroup120_HWWriteResGroup186_HWWriteResGroup190_WriteCvtPH2PSZLd_SPRWriteResGroup478_SPRWriteResGroup461_SPRWriteResGroup285_SPRWriteResGroup287_SPRWriteResGroup293_SPRWriteResGroup295_SPRWriteResGroup308_SPRWriteResGroup324_SPRWriteResGroup336_SPRWriteResGroup337_SPRWriteResGroup338_SPRWriteResGroup339_SPRWriteResGroup364_SPRWriteResGroup384_SPRWriteResGroup390_SPRWriteResGroup394_SPRWriteResGroup471_SPRWriteResGroup523_SPRWriteResGroup528_SPRWriteResGroup532_ICXWriteResGroup199_SKLWriteResGroup177_SKLWriteResGroup178
  {19,  0}, // #17 WriteDiv32Ld_WriteFDiv64Ld_WriteVecExtractSt_WriteIDiv32Ld_WriteFSqrtXLd_WriteFSqrtLd_WriteFDivYLd_WriteDiv16Ld_WriteIDiv16Ld_WritePCmpEStrILd_WriteAESIMCLd_WriteFDiv64XLd_BWWriteResGroup161_WriteDPPSLd_WritePCmpEStrM_BWWriteResGroup183_4_BWWriteResGroup183_3_WriteFDivX_WritePCmpEStrMLd_JWriteLOCK_CMPXCHG8B_JWriteLOCK_ALURMW_WriteFSqrtYLd_SKXWriteGatherEVEX4_WriteDPPSYLd_WriteFDivXLd_HWWriteResGroup135_HWWriteResGroup143_HWWriteFPREM_SPRWriteResGroup503_SPRWriteResGroup48_SPRWriteResGroup270_SPRWriteResGroup301_SPRWriteResGroup325_SPRWriteResGroup553_ICXWriteGatherEVEX4_WriteDiv8Ld_WriteIDiv8Ld
  {23,  0}, // #18 WriteDiv64Ld_WriteIDiv64Ld_WriteFSqrt64Ld_AtomWrite01_23_WriteFSqrtLd_WritePCmpEStrILd_WriteFSqrt80_WriteFDiv64Y_WriteFDivYLd_BWWriteResGroup176_WriteFDiv64Z_SKXWriteResGroup228_WriteIDiv8_HWWriteResGroup151_SPRWriteResGroup497_SPRWriteResGroup499_SPRWriteResGroup459_SPRWriteResGroup309_SPRWriteResGroup322_ICXWriteResGroup228_SKLWriteResGroup198
  {22,  0}, // #19 WriteDiv8Ld_WriteIDiv8Ld_WriteDPPSYLd_ADLPWriteResGroup46_AtomWrite01_22_WriteFDivLd_BWWriteResGroup172_WriteFMaskedStore32Y_SKXWriteResGroup223_SKXWriteResGroupVEX8_SKXWriteResGroup225_SKXWriteResGroup211_SKXWriteResGroup211_1_WriteFDiv64X_WriteFSqrt64XLd_HWWriteResGroup146_HWWriteResGroup187_SPRWriteResGroup49_SPRWriteResGroup302_SPRWriteResGroup326_SPRWriteResGroup526_SPRWriteResGroup530_ICXWriteResGroup223_ICXWriteResGroupVEX8_ICXWriteResGroup225_ICXWriteResGroup211_ICXWriteResGroup211_1_SKLWriteResGroup196_SKLWriteResGroupVEX8_WriteFDiv64YLd_WriteDPPSLd_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrt80_WriteFSqrtYLd_WriteFSqrtZLd
  {17,  0}, // #20 WriteDiv8_WriteIDiv8_WritePCmpEStrMLd_WriteStore_ADLPWriteResGroup276_ADLPWriteResGroup17_AtomWrite01_17_WritePCmpIStrI_WriteCLMulLd_WriteFDivY_WriteFRcpYLd_WriteFRsqrtYLd_BWWriteResGroup183_1_WriteDiv16_WriteIDiv16_WriteDPPSYLd_JWriteLOCK_CMPXCHGrm_WriteFDivXLd_WriteFSqrtLd_WritePMULLDYLd_WritePMULLDZLd_SKXWriteResGroup202_SKXWriteGatherEVEX2_WritePCmpIStrILd_WritePCmpIStrMLd_WriteFSqrtXLd_HWWriteResGroup147_HWWriteResGroup132_HWWriteResGroup185_HWWriteResGroup189_SPRWriteResGroup563_SPRWriteResGroup451_SPRWriteResGroup448_SPRWriteResGroup19_SPRWriteResGroup273_SPRWriteResGroup277_SPRWriteResGroup282_SPRWriteResGroup316_SPRWriteResGroup333_SPRWriteResGroup342_SPRWriteResGroup379_SPRWriteResGroup460_SPRWriteResGroup474_SPRWriteResGroup476_SPRWriteResGroup534_SPRWriteResGroup536_ICXWriteResGroup202_ICXWriteGatherEVEX2_SKLWriteResGroup180_WriteFDivLd_WriteFDivYLd_WriteDiv32Ld_WriteDiv64_WriteIDiv32Ld_WriteIDiv64
  {14,  0}, // #21 WriteFDiv64X_WriteDPPS_WriteFDiv64Y_WriteDPPSY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_ADLPWriteResGroup157_WriteIMul64ImmLd_AtomWrite01_14_WritePMULLDLd_WriteAESDecEncLd_WriteDiv32_WriteDiv64_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteIDiv32_WriteIDiv64_WriteMPSADLd_WritePCmpEStrI_WriteFSqrt64XLd_WriteFSqrtXLd_WriteFSqrt64Ld_WriteFSqrtLd_WriteFDiv64YLd_WriteFDivYLd_WriteFSqrt64YLd_WriteFSqrtYLd_WriteAESIMC_BWWriteResGroup139_1_WriteDPPDLd_BWWriteResGroup146_BWWriteResGroup141_BWWriteResGroup144_BWWriteResGroup145_WritePCmpEStrM_WriteAESIMCLd_WriteFRndLd_WriteCvtPD2PSYLd_WriteCvtPD2PSZLd_SKXWriteResGroup187_SKXWriteResGroup190_SKXWriteResGroup188_SKXWriteResGroup189_WriteAESKeyGenLd_WriteCLMul_WriteMPSADYLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup142_HWWriteResGroup184_SPRWriteResGroup166_SPRWriteResGroup496_SPRWriteResGroup276_SPRWriteResGroup280_SPRWriteResGroup315_SPRWriteResGroup331_SPRWriteResGroup355_SPRWriteResGroup363_SPRWriteResGroup381_SPRWriteResGroup445_SPRWriteResGroup447_SPRWriteResGroup466_SPRWriteResGroup468_SPRWriteResGroup487_ICXWriteResGroup187_ICXWriteResGroup190_ICXWriteResGroup188_ICXWriteResGroup189_SKLWriteResGroup169_SKLWriteResGroup170_WriteFHAddLd_WriteFHAddYLd_WriteDiv8Ld_WriteIDiv8Ld_WriteFVarShuffle256Ld
  { 9,  0}, // #22 WriteDPPD_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul64Ld_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecShiftLd_WriteMULX32Ld_WriteMULX64Ld_WritePHAddXLd_WriteVecTestLd_WriteShuffleYLd_WriteFLogicYLd_WriteFBlendYLd_WriteVecALUYLd_WriteFMaskedLoadY_WriteFShuffleYLd_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoadY_WriteVarVecShiftYLd_WriteVarShuffleYLd_WriteVecShiftYLd_ADLPWriteResGroup114_ADLPWriteResGroup122_ADLPWriteResGroup255_ADLPWriteResGroup125_ADLPWriteResGroup197_ADLPWriteResGroup221_ADLPWriteResGroup177_ADLPWriteResGroup244_ADLPWriteResGroup264_WriteBitTestRegLd_WriteFCMOV_WriteFComX_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteFHAddLd_WriteFMul64X_WriteFRcpX_WriteFRsqrtX_AtomWrite0_1_9_AtomWrite01_9_WritePHAddLd_WriteAESDecEnc_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtSD2SSLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteFDiv64X_WriteFDivX_WriteVecIMulXLd_WriteVecIMulLd_WritePSADBWLd_WritePHMINPOSLd_WritePSADBWXLd_WriteFRndLd_WriteFSqrt64X_WriteFSqrtX_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteFDiv64Y_WriteFDivY_WriteFRndYLd_WriteFSqrt64Y_WriteFSqrtY_PdWriteX87Div_PdWriteRCR16rCL_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteIMul16Ld_WriteSHDmri_WriteFAdd64YLd_WriteFAddYLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteVarShuffle256Ld_WriteCvtPS2PDYLd_WriteFMul64YLd_WriteFMulYLd_WriteFVarShuffle256Ld_WritePHAddYLd_WriteVPMOV256Ld_BWWriteResGroup101_BWWriteResGroup112_BWWriteResGroup108_BWWriteResGroup113_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFMul64XLd_WriteFMul64Ld_WritePMULLDLd_WriteSHDmrcl_WriteFHAddYLd_WriteVecTestYLd_WriteFTestYLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFMulLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFVarBlendYLd_WriteFVarBlendZLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSZLd_WriteCvtPH2PSLd_WriteFRsqrtZ_SKXWriteResGroup135_SKXWriteResGroup137_SKXWriteResGroup136_SKXWriteResGroup146_SKXWriteResGroup143_SBWriteResGroup98_WriteFAdd64XLd_WriteFAddXLd_SBWriteResGroup100_WriteRMW_WriteFCmp64XLd_WriteFCmpXLd_WritePOPCNTLd_WriteVarBlendYLd_WriteVarBlendZLd_SBWriteResGroup97_2_SBWriteResGroup95_SBWriteResGroup99_SBWriteResGroupVzeroall_WriteCMPXCHGRMW_HWWriteResGroup69_WriteVarVecShiftLd_HWWriteResGroup66_HWWriteResGroup68_HWWriteResGroup53_1_HWWriteResGroup78_1_HWWriteResGroup80_HWWriteResGroup87_WriteShuffleZLd_WriteFLogicZLd_WriteVecALUZLd_WriteFShuffleZLd_WriteVecLogicZLd_WriteFVarShuffleZLd_WriteVecShiftImmYLd_WriteVecShiftImmZLd_WriteVarVecShiftZLd_WriteVecShiftZLd_SPRWriteResGroup123_SPRWriteResGroup131_SPRWriteResGroup262_SPRWriteResGroup134_SPRWriteResGroup201_SPRWriteResGroup227_SPRWriteResGroup183_SPRWriteResGroup472_SPRWriteResGroup477_SPRWriteResGroup261_SPRWriteResGroup442_SPRWriteResGroup275_SPRWriteResGroup279_SPRWriteResGroup330_SPRWriteResGroup366_SPRWriteResGroup392_SPRWriteResGroup396_SPRWriteResGroup409_SPRWriteResGroup412_SPRWriteResGroup507_SPRWriteResGroup510_SPRWriteResGroup512_SPRWriteResGroup524_ICXWriteResGroup135_ICXWriteResGroup137_ICXWriteResGroup136_ICXWriteResGroup146_ICXWriteResGroup143_WriteCvtPS2PDLd_SKLWriteResGroup120_SKLWriteResGroup123_SKLWriteResGroup121_SKLWriteResGroup131_SKLWriteResGroup128_ZnWriteMul64Ld_WriteFTestLd_ZnWriteFPU02_ZnWriteVINSERT128Ld_ZnWriteFPU01Op2Y_ZnWriteSHA1MSG1Ld_Zn2WriteFPU02_Zn2WriteVINSERT128Ld_Zn2WriteFPU01Op2Y_Zn2WriteSHA1MSG1Ld_WritePCmpIStrILd_Zn3WriteVPERMDYm_WriteVecShiftXLd_WriteFCmpZLd_WriteFCmp64ZLd_Zn4WriteVPERMYm
  {21,  0}, // #23 WriteDPPSLd_WriteFSqrt80_WriteFDiv64YLd_ADLPWriteResGroup220_AtomWrite01_21_WritePCmpEStrI_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrtY_BWWriteResGroup171_BWWriteResGroup169_BWWriteResGroup183_5_WriteFSqrtX_SKXWriteResGroup205_SKXWriteGatherEVEX8_WriteFDivY_WriteFDivZ_WriteDPPSYLd_WriteFSqrtZ_HWWriteResGroup144_WriteFSqrt64YLd_SPRWriteResGroup226_SPRWriteResGroup274_SPRWriteResGroup278_SPRWriteResGroup305_SPRWriteResGroup353_SPRWriteResGroup380_SPRWriteResGroup391_SPRWriteResGroup395_ICXWriteResGroup205_ICXWriteGatherEVEX8_WriteDiv16Ld_WriteIDiv16Ld_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrtYLd_WriteDiv64Ld_WriteIDiv64Ld_WriteFSqrt64Z
  {13,  0}, // #24 WriteVecIMulXLd_WriteVecIMulLd_WriteSETCCStore_WriteVecIMulYLd_WriteFHAddYLd_ADLPWriteResGroup113_ADLPWriteResGroup33_ADLPWriteResGroup10_ADLPWriteResGroup223_ADLPWriteResGroup227_ADLPWriteResGroup4_ADLPWriteResGroup231_ADLPWriteResGroup7_ADLPWriteResGroup138_ADLPWriteResGroup233_AtomWrite01_13_WriteBSFLd_WriteBSRLd_WriteCLMulLd_WritePCmpIStrM_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteVecExtractSt_WriteCvtI2PDYLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_PdWriteCVTSI642SDrr_CVTSI642SSrr_CVTSI2SDr_CVTSI2SSrr_PdWriteRCL8ri_WriteMPSADYLd_WritePCmpIStrMLd_WriteFMaskedStore64_WriteDPPS_WriteDPPSY_SKXWriteResGroup180_SKXWriteResGroup181_SKXWriteResGroup183_WriteAESDecEncLd_WriteMPSADLd_SBWriteResGroup114_WriteFDivX_WriteFRndYLd_WriteFRndZLd_HWWriteResGroup103_WriteCvtPS2PDZLd_WriteVecIMulZLd_SPRWriteResGroup122_SPRWriteResGroup35_SPRWriteResGroup11_SPRWriteResGroup229_SPRWriteResGroup233_SPRWriteResGroup4_SPRWriteResGroup480_SPRWriteResGroup332_SPRWriteResGroup458_SPRWriteResGroup7_SPRWriteResGroup94_SPRWriteResGroup238_SPRWriteResGroup307_SPRWriteResGroup359_SPRWriteResGroup360_SPRWriteResGroup462_SPRWriteResGroup490_SPRWriteResGroup527_SPRWriteResGroup531_ICXWriteResGroup180_ICXWriteResGroup181_ICXWriteResGroup183_SKLWriteResGroup162_WriteFDiv64X_ZnWriteSHA1RNDS4Ld_WriteFDiv64Y_Zn2WriteSHA1RNDS4Ld_WriteDiv32_WriteFHAddLd_WriteIDiv32_WritePCmpEStrILd_WritePCmpEStrMLd_WriteCvtPD2PSZLd_WriteFDiv64Z
  {511,  0}, // #25 WriteVecStoreNT_ADLPWriteResGroup145_SPRWriteResGroup154
  {512,  0}, // #26 WriteStoreNT_ADLPWriteResGroup148_SPRWriteResGroup157
  {518,  0}, // #27 WriteFStoreNTX_ADLPWriteResGroup149_SPRWriteResGroup158
  { 3,  0}, // #28 WriteIMulHLd
  { 9,  0}, // #29 WriteMULX32Ld_WriteMULX64Ld
  { 3,  0}, // #30 WriteIMulH
  { 4,  0}, // #31 WriteMULX32_WriteMULX64
  {31,  0}, // #32 WritePCmpEStrILd_WritePCmpIStrILd_WriteEMMS_SBWriteResGroup130_HWWriteResGroup163_HWWriteResGroup165_WriteFSqrt64ZLd_SPRWriteResGroup370_SPRWriteResGroup543
  {12,  0}, // #33 WriteRotateLd_WriteShiftLd_WriteShiftCLLd_ADLPWriteResGroup211_ADLPWriteResGroup271_SPRWriteResGroup215_SPRWriteResGroup558
  { 1,  0}, // #34 WriteRMW_WriteShift
  {12,  0}, // #35 WriteRotateLd_WriteShiftCLLd
  { 2,  0}, // #36 WriteRotate_WriteShiftCL
  {19,  0}, // #37 WriteRotateCLLd
  { 1,  0}, // #38 WriteRMW
  {19,  0}, // #39 WriteRotateCLLd
  { 2,  0}, // #40 WriteRotateCL
  {24,  0}, // #41 WriteFSqrt64XLd_ADLPWriteResGroup109_ADLPWriteResGroup237_WritePCmpEStrILd_WritePCmpEStrMLd_BWWriteResGroup177_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteFSqrt80_HWWriteResGroup162_SPRWriteResGroup118_SPRWriteResGroup450_SPRWriteResGroup242_SPRWriteResGroup306
  { 5,  0}, // #42 WriteLoad
  { 5,  0}, // #43 WriteVecMaskedGatherWriteback
  {507,  0}, // #44 WriteVecStoreNTY
  {542,  0}, // #45 WriteFStoreNTY
  {25,  0}, // #46 WriteFSqrt64YLd_ADLPWriteResGroup32_ADLPWriteResGroup47_AtomWrite01_25_WriteDiv16_WriteDiv32_WriteDiv64_WriteDiv8_WriteIDiv16_WriteIDiv32_WriteIDiv64_WriteIDiv8_WriteDPPS_WriteAESKeyGenLd_WritePCmpEStrMLd_WriteFDivZLd_SKXWriteResGroup233_SKXWriteGatherEVEX16_WriteFDiv64Ld_SPRWriteResGroup34_SPRWriteResGroup50_SPRWriteResGroup454_SPRWriteResGroup327_SPRWriteResGroup539_ICXWriteResGroup233_ICXWriteGatherEVEX16_SKLWriteResGroup202
  {11,  0}, // #47 WriteALULd
  { 1,  0}, // #48 WriteRMW
  {39,  0}, // #49 ADLPWriteResGroup274_ADLPWriteResGroup273_WriteFDivX_WriteFSqrt64ZLd_SPRWriteResGroup561_SPRWriteResGroup560_SPRWriteResGroup373_SPRWriteResGroup542
  { 1,  0}, // #50 WriteRMW
  {32,  0}, // #51 ADLPWriteResGroup31_AtomWrite01_32_WriteDPPSYLd_WriteFSqrt64XLd_WriteFSqrt64Ld_JWriteCMPXCHG16B_WriteFSqrt64Z_SPRWriteResGroup33
  {42,  0}, // #52 ADLPWriteResGroup207_ADLPWriteResGroup280_ADLPWriteResGroup287_ADLPWriteResGroup282_ADLPWriteResGroup283_ADLPWriteResGroup286_WriteFDivXLd_BWWriteResGroup196_WriteFSqrtY_SKXWriteResGroup254_SKXWriteResGroup255_WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd_HWWriteResGroup176_SPRWriteResGroup211_SPRWriteResGroup567_SPRWriteResGroup572_SPRWriteResGroup574_SPRWriteResGroup569_SPRWriteResGroup570_SPRWriteResGroup571_SPRWriteResGroup573_SPRWriteResGroup548_ICXWriteResGroup254_ICXWriteResGroup255_SKLWriteResGroup214_SKLWriteResGroup215
  {126,  0}, // #53 ADLPWriteResGroup49_SPRWriteResGroup53
  {75,  0}, // #54 ADLPWriteResGroup61_BWWriteResGroup200_SKXWriteResGroup263_HWWriteResGroup180_HWWriteFSCALE_SPRWriteResGroup65_ICXWriteResGroup263_SKLWriteResGroup220
  {35,  0}, // #55 ADLPWriteResGroup165_ADLPWriteResGroup164_ADLPWriteResGroup75_ADLPWriteResGroup76_ADLPWriteResGroup71_ADLPWriteResGroup72_ADLPWriteResGroup73_ADLPWriteResGroup160_ADLPWriteResGroup161_ADLPWriteResGroup162_ADLPWriteResGroup163_WriteFSqrt64_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFSqrt64YLd_BWWriteResGroup194_WriteFSqrt80_SKXWriteResGroup248_SKXWriteResGroup247_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Z_HWWriteResGroup170_SPRWriteResGroup174_SPRWriteResGroup173_SPRWriteResGroup79_SPRWriteResGroup80_SPRWriteResGroup75_SPRWriteResGroup76_SPRWriteResGroup77_SPRWriteResGroup169_SPRWriteResGroup170_SPRWriteResGroup171_SPRWriteResGroup172_SPRWriteResGroup545_ICXWriteResGroup248_ICXWriteResGroup247_SKLWriteResGroup210_SKLWriteResGroup209
  {63,  0}, // #56 ADLPWriteResGroup66_ADLPWriteResGroup67_ADLPWriteResGroup108_AtomWrite01_63_BWWriteResGroup199_BWWriteResGroup198_SKXWriteResGroup260_SKXWriteResGroup259_SPRWriteResGroup70_SPRWriteResGroup71_SPRWriteResGroup117_ICXWriteResGroup260_ICXWriteResGroup259_SKLWriteResGroup219_SKLWriteResGroup218
  {81,  0}, // #57 ADLPWriteResGroup248_ADLPWriteResGroup246_SPRWriteResGroup387_SPRWriteResGroup385
  {13,  0}, // #58 ADLPWriteResGroup272_ADLPWriteResGroup193_ADLPWriteResGroup213_ADLPWriteResGroup215_SPRWriteResGroup559_SPRWriteResGroup197_SPRWriteResGroup217_SPRWriteResGroup221
  { 1,  0}, // #59 WriteRMW
  {65,  0}, // #60 ADLPWriteResGroup90_SPRWriteResGroup100
  {70,  0}, // #61 ADLPWriteResGroup107_WriteFDivXLd_WriteFSqrtXLd_SPRWriteResGroup116
  {37,  0}, // #62 ADLPWriteResGroup279_WriteFDiv64Ld_SKXWriteResGroup250_SKXWriteResGroup249_SPRWriteResGroup566_SPRWriteResGroup372_ICXWriteResGroup250_ICXWriteResGroup249_SKLWriteResGroup211
  {27,  0}, // #63 ADLPWriteResGroup42_WriteDPPSY_PdWriteVDPPSrri_WriteFSqrtYLd_WriteFSqrt64X_WriteFSqrtZLd_SKXWriteResGroup239_WriteFSqrt64XLd_WriteFSqrt64Ld_HWWriteFPREM1_HWWriteResGroup155_SPRWriteResGroup45_SPRWriteResGroup433_SPRWriteResGroup434_ICXWriteResGroup239_SKLWriteResGroup206_WriteFSqrt64YLd
  {30,  0}, // #64 ADLPWriteResGroup43_AtomWrite01_30_WriteDPPSLd_BWWriteResGroup186_WriteFDiv64ZLd_SKXWriteResGroup243_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_HWWriteResGroup161_HWWriteResGroup164_SPRWriteResGroup46_SPRWriteResGroup440_ICXWriteResGroup243_SKLWriteResGroup208
  {41,  0}, // #65 ADLPWriteResGroup281_WriteFSqrtX_WriteDiv64_WriteIDiv64_SKXWriteResGroup253_HWWriteResGroup175_SPRWriteResGroup568_SPRWriteResGroup377_SPRWriteResGroup544_ICXWriteResGroup253_SKLWriteResGroup213
  {46,  0}, // #66 ADLPWriteResGroup285_ADLPWriteResGroup284_AtomWrite01_46_PdWriteVZEROUPPER_JWriteJVZEROUPPER_SKLWriteResGroup216
  {40,  0}, // #67 ADLPWriteResGroup257_WriteFSqrt80_SKXWriteResGroup252_SPRWriteResGroup416_SPRWriteResGroup435_SPRWriteResGroup436_SPRWriteResGroup547_ICXWriteResGroup252_SKLWriteResGroup212
  {62,  0}, // #68 ADLPWriteResGroup59_WriteFDiv64Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv8Ld_WriteFSqrt64Ld_SKXWriteResGroup258_SPRWriteResGroup63_ICXWriteResGroup258_SKLWriteResGroup217
  {106,  0}, // #69 ADLPWriteResGroup65_SKXWriteResGroup266_SPRWriteResGroup69_ICXWriteResGroup266_SKLWriteResGroup223
  {20,  0}, // #70 ADLPWriteResGroup251_SPRWriteResGroup402_SPRWriteResGroup399
  { 5,  0}, // #71 WriteVecMaskedGatherWriteback
  {29,  0}, // #72 ADLPWriteResGroup250_AtomWrite01_29_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteAESKeyGen_WriteFDiv64YLd_WriteFSqrt64Y_BWWriteResGroup182_BWWriteResGroup185_SKXWriteResGroup242_WriteFDivY_WriteFDivZ_WriteFSqrtY_WriteFSqrtZ_SPRWriteResGroup398_SPRWriteResGroup405_SPRWriteResGroup439_ICXWriteResGroup242
  { 5,  0}, // #73 WriteVecMaskedGatherWriteback
  {28,  0}, // #74 ADLPWriteResGroup253_WriteDiv32Ld_WriteIDiv32Ld_WriteIDiv16Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFDiv64XLd_WriteFDiv64Ld_WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_SPRWriteResGroup407_SPRWriteResGroup400_SPRWriteResGroup401_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrt64YLd_WriteFSqrt64ZLd
  { 5,  0}, // #75 WriteVecMaskedGatherWriteback
  {30,  0}, // #76 ADLPWriteResGroup252_SPRWriteResGroup403_SPRWriteResGroup406
  { 5,  0}, // #77 WriteVecMaskedGatherWriteback
  {40,  0}, // #78 ADLPWriteResGroup275_SPRWriteResGroup562
  { 1,  0}, // #79 WriteRMW
  {26,  0}, // #80 ADLPWriteResGroup35_AtomWrite01_26_BWWriteResGroup180_WriteFSqrtXLd_WriteFSqrtLd_WriteFDiv64XLd_SPRWriteResGroup38_SPRWriteResGroup310_SPRWriteResGroup323_SPRWriteResGroup453
  {198,  0}, // #81 ADLPWriteResGroup87_SPRWriteResGroup97
  {66,  0}, // #82 ADLPWriteResGroup88_SPRWriteResGroup98
  {71,  0}, // #83 ADLPWriteResGroup89_ADLPWriteResGroup91_WriteFSqrt80_AtomWrite01_71_WriteFSqrt64X_SPRWriteResGroup99_SPRWriteResGroup101
  {217,  0}, // #84 ADLPWriteResGroup133_SPRWriteResGroup143
  {181,  0}, // #85 ADLPWriteResGroup136_SPRWriteResGroup146
  {514,  0}, // #86 ADLPWriteResGroup146_SPRWriteResGroup155
  {20,  0}, // #87 ADLPWriteResGroup194_ADLPWriteResGroup196_SPRWriteResGroup198_SPRWriteResGroup200
  { 1,  0}, // #88 WriteRMW
  {1386,  0}, // #89 ADLPWriteResGroup202_SPRWriteResGroup206
  {1381,  0}, // #90 ADLPWriteResGroup204_SPRWriteResGroup208
  {74,  0}, // #91 ADLPWriteResGroup247_ADLPWriteResGroup249_AtomWrite01_74_WriteFSqrt64XLd_SKXWriteResGroup262_SPRWriteResGroup386_SPRWriteResGroup388_ICXWriteResGroup262
  {521,  0}, // #92 ADLPWriteResGroup259_SPRWriteResGroup423
  {473,  0}, // #93 ADLPWriteResGroup260_SPRWriteResGroup422
  {494,  0}, // #94 ADLPWriteResGroup261_SPRWriteResGroup427
  {470,  0}, // #95 ADLPWriteResGroup262_SPRWriteResGroup421
  {50,  0}, // #96 WriteDiv16Ld_WriteDiv32Ld_WriteDiv8
  {130,  0}, // #97 WriteDiv64Ld_WriteIDiv64Ld_AtomWrite01_130
  {68,  0}, // #98 WriteDiv8Ld_AtomWrite01_68
  {125,  0}, // #99 WriteFDiv64XLd_WriteFSqrt64XLd
  {34,  0}, // #100 WriteFDivLd_WriteFSqrtLd_WriteFDiv64_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_BWWriteResGroup191_JWriteMASKMOVDQU_SBWriteResGroup131_WriteAESKeyGenLd_HWWriteResGroup166
  { 1,  0}, // #101 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #102 WriteRMW_WriteRotate_WriteRotateCL_WriteShift_WriteShiftCL
  {45,  0}, // #103 AtomWrite01_45_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Y_WriteFSqrt64Z_SPRWriteResGroup551_WriteDiv64Ld_WriteIDiv64Ld
  {48,  0}, // #104 AtomWrite01_48
  {55,  0}, // #105 AtomWrite01_55_SPRWriteResGroup550
  {59,  0}, // #106 AtomWrite01_59_WriteFSqrt64YLd
  {72,  0}, // #107 AtomWrite01_72_WriteFDiv64XLd
  {77,  0}, // #108 AtomWrite01_77
  {78,  0}, // #109 AtomWrite01_78
  {79,  0}, // #110 AtomWrite01_79
  {92,  0}, // #111 AtomWrite01_92
  {94,  0}, // #112 AtomWrite01_94
  {99,  0}, // #113 AtomWrite01_99
  {121,  0}, // #114 AtomWrite01_121
  {127,  0}, // #115 AtomWrite01_127
  {140,  0}, // #116 AtomWrite01_140_SKXWriteResGroup267_SPRWriteResGroup180_ICXWriteResGroup267
  {141,  0}, // #117 AtomWrite01_141
  {146,  0}, // #118 AtomWrite01_146
  {147,  0}, // #119 AtomWrite01_147
  {168,  0}, // #120 AtomWrite01_168
  {174,  0}, // #121 AtomWrite01_174
  {183,  0}, // #122 AtomWrite01_183
  {202,  0}, // #123 AtomWrite01_202
  {69,  0}, // #124 WriteFDiv64X
  { 4,  0}, // #125 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #126 WriteRMW_WriteRotate_WriteRotateCL_WriteShift_WriteShiftCL
  {44,  0}, // #127 WriteFSqrtXLd_WriteDiv64Ld_WriteIDiv64Ld_SKXWriteResGroup256_ICXWriteResGroup256
  {38,  0}, // #128 WriteFSqrt64Ld_WriteFDiv64Y_WriteFDivY_JWriteLOCK_CMPXCHG16B_SPRWriteResGroup369_SPRWriteResGroup541
  { 5,  0}, // #129 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #130 WriteRMW_WriteRotate_WriteRotateCL_WriteShift_WriteShiftCL
  {90,  0}, // #131 PdWriteVZEROALL_JWriteJVZEROALL
  {184,  0}, // #132 PdWriteLARrr
  {33,  0}, // #133 WriteAESKeyGenLd_SPRWriteResGroup452_SPRWriteResGroup371
  {80,  0}, // #134 WriteDiv16_WriteDiv32_WriteDiv64
  { 9,  0}, // #135 WriteIMulHLd
  { 8,  0}, // #136 WriteMULX32Ld_WriteMULX64Ld
  { 4,  0}, // #137 WriteIMulH
  { 3,  0}, // #138 WriteMULX32_WriteMULX64
  { 6,  0}, // #139 WriteRotateLd_WriteShiftLd_WriteALULd
  { 1,  0}, // #140 WriteRMW_WriteRotate_WriteShift
  { 8,  0}, // #141 WriteRotateCLLd_WriteShiftCLLd
  { 1,  0}, // #142 WriteRMW
  { 8,  0}, // #143 WriteRotateCLLd_WriteShiftCLLd
  { 3,  0}, // #144 WriteRotateCL_WriteShiftCL
  {60,  0}, // #145 BWWriteResGroup197
  {115,  0}, // #146 BWWriteResGroup202_HWWriteResGroup183
  { 4,  0}, // #147 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 2,  0}, // #148 WriteRMW
  {43,  0}, // #149 WriteFDiv64YLd_WriteFDivYLd_SPRWriteResGroup378
  {54,  0}, // #150 WriteFSqrt64Y
  {47,  0}, // #151 WriteFSqrtYLd_HWWriteFBLD_SPRWriteResGroup552
  {11,  0}, // #152 JWriteXCHGrm_XCHG_Part_JWriteLOCK_XADDrm_XCHG_Part
  {16,  0}, // #153 JWriteXCHGrm_LdSt_Part
  { 3,  0}, // #154 JWriteXADDrm_XCHG_Part
  {11,  0}, // #155 JWriteXADDrm_LdSt_Part
  {76,  0}, // #156 WriteDiv16_WriteDiv32_WriteDiv64
  {102,  0}, // #157 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {67,  0}, // #158 SKXWriteResGroup261_ICXWriteResGroup261
  { 7,  0}, // #159 WriteRotateLd
  { 1,  0}, // #160 WriteRMW
  { 7,  0}, // #161 WriteRotateLd
  { 2,  0}, // #162 WriteRotate
  {52,  0}, // #163 WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd
  {36,  0}, // #164 WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_HWWriteResGroup171_SPRWriteResGroup368
  {98,  0}, // #165 WriteDiv16_WriteDiv32_WriteDiv64
  {112,  0}, // #166 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {64,  0}, // #167 HWWriteResGroup179_HWWriteResGroup178
  {61,  0}, // #168 HWWriteResGroup177
  {27,  0}, // #169 SPRWriteResGroup404
  { 5,  0}, // #170 WriteVecMaskedGatherWriteback
  {49,  0}, // #171 SPRWriteResGroup375
  {51,  0}, // #172 SPRWriteResGroup376
  {477,  0}, // #173 SPRWriteResGroup420
  {550,  0}, // #174 SPRWriteResGroup424
  {474,  0}, // #175 SPRWriteResGroup425
  {464,  0}, // #176 SPRWriteResGroup426
  {475,  0}, // #177 SPRWriteResGroup428
  {476,  0}, // #178 SPRWriteResGroup429
  {471,  0}, // #179 SPRWriteResGroup430
  {53,  0}, // #180 SPRWriteResGroup549
  { 3,  0}, // #181 WriteIMulH
  { 3,  0}, // #182 WriteMULX32_WriteMULX64
  { 4,  0}, // #183 WriteLoad
  { 8,  0}, // #184 WriteVecMaskedGatherWriteback_WriteIMulHLd
  { 7,  0}, // #185 WriteIMulHLd_WriteMULX32Ld_WriteMULX64Ld
  { 7,  0} // #186 WriteMULX32Ld_WriteMULX64Ld
}; // X86WriteLatencyTable

// {UseIdx, WriteResourceID, Cycles}
extern const llvm::MCReadAdvanceEntry X86ReadAdvanceTable[] = {
  {0,  0,  0}, // Invalid
  {0,  0,  5}, // #1
  {5,  0,  5}, // #2
  {6,  0,  5}, // #3
  {0,  0,  5}, // #4
  {6,  0,  5}, // #5
  {0,  0,  6}, // #6
  {1,  0,  0}, // #7
  {0,  0,  6}, // #8
  {6,  0,  6}, // #9
  {0,  0,  6}, // #10
  {1,  0,  6}, // #11
  {0,  0,  5}, // #12
  {1,  0,  5}, // #13
  {0,  0,  3}, // #14
  {5,  0,  3}, // #15
  {6,  0,  3}, // #16
  {0,  0,  3}, // #17
  {6,  0,  3}, // #18
  {0,  0,  3}, // #19
  {1,  0,  3}, // #20
  {0,  0,  4}, // #21
  {5,  0,  4}, // #22
  {6,  0,  4}, // #23
  {0,  0,  4}, // #24
  {6,  0,  4}, // #25
  {0,  0, -10}, // #26
  {1,  0, -10}, // #27
  {0,  0, -6}, // #28
  {1,  0, -6}, // #29
  {5,  0,  3}, // #30
  {6,  0,  3}, // #31
  {7,  0,  3}, // #32
  {8,  0,  3}, // #33
  {0,  0,  7}, // #34
  {0,  0,  7}, // #35
  {6,  0,  7}, // #36
  {0,  0,  7}, // #37
  {1,  0,  7}, // #38
  {0,  0,  8}, // #39
  {0,  0,  8}, // #40
  {6,  0,  8}, // #41
  {0,  0,  8}, // #42
  {1,  0,  8}, // #43
  {0,  0, -1}, // #44
  {1,  0, -1} // #45
}; // X86ReadAdvanceTable

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AlderlakePModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false,  2, 8,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false, 10, 4,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    6, false, false, false, 14, 8,  2, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        2, false, false, false, 22, 8,  3, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false,  1, 1,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false,  5, 2,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteLEA")           1, false, false, false, 30, 7,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteRMW")           3, false, false, false, 18, 4,  1, 1,  0, 0}, // #10
  {DBGFIELD("WriteADC")           1, false, false, false, 10, 4,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteSHDrri")        1, false, false, false, 30, 7,  5, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreX")       2, false, false, false, 37, 3,  2, 1,  0, 0}, // #13
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 28, 2,  6, 1,  0, 0}, // #14
  {DBGFIELD("WriteFStoreY")       2, false, false, false, 37, 3,  2, 1,  0, 0}, // #15
  {DBGFIELD("WriteFLoadY")        1, false, false, false, 28, 2,  7, 1,  0, 0}, // #16
  {DBGFIELD("WriteMicrocoded")    1, false, false, false,  5, 2,  4, 1,  0, 0}, // #17
  {DBGFIELD("WriteALURMW")        4, false, false, false, 40, 5,  2, 1,  0, 0}, // #18
  {DBGFIELD("WriteFSign")         1, false, false, false,  2, 8,  1, 1,  0, 0}, // #19
  {DBGFIELD("WriteADCRMW")        5, false, false, false, 45, 8,  2, 1,  0, 0}, // #20
  {DBGFIELD("WriteADCLd_ReadAfterLd") 2, false, false, false, 45, 4,  8, 1,  1, 1}, // #21
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 45, 8,  2, 1,  2, 2}, // #22
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 45, 4,  8, 1,  4, 2}, // #23
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, false,  1, 1,  8, 1,  1, 1}, // #24
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 4, false, false, false, 40, 5,  2, 1,  2, 1}, // #25
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault") 4, false, false, false, 40, 5,  2, 1,  0, 0}, // #26
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  9, 1,  6, 1}, // #27
  {DBGFIELD("WriteFAdd64X")       1, false, false, false, 53, 5,  5, 1,  0, 0}, // #28
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  9, 1,  6, 1}, // #29
  {DBGFIELD("WriteFAddX")         1, false, false, false, 53, 5,  5, 1,  0, 0}, // #30
  {DBGFIELD("WriteNop")           0, false, false, false,  0, 0,  1, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 2, false, false, false, 53, 7,  9, 1,  6, 1}, // #32
  {DBGFIELD("WriteFAdd64")        1, false, false, false, 53, 5,  5, 1,  0, 0}, // #33
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 2, false, false, false, 53, 7,  9, 1,  6, 1}, // #34
  {DBGFIELD("WriteFAdd")          1, false, false, false, 60, 8,  5, 1,  0, 0}, // #35
  {DBGFIELD("WriteFAddLd")        2, false, false, false, 53, 7,  9, 1,  0, 0}, // #36
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #37
  {DBGFIELD("WriteAESDecEnc")     1, false, false, false,  3, 4, 10, 1,  0, 0}, // #38
  {DBGFIELD("WriteAESIMCLd")      3, false, false, false, 74, 6, 11, 1,  0, 0}, // #39
  {DBGFIELD("WriteAESIMC")        2, false, false, false, 74, 4,  7, 1,  0, 0}, // #40
  {DBGFIELD("WriteAESKeyGenLd")   14, false, false, false, 80, 13,  2, 1,  0, 0}, // #41
  {DBGFIELD("WriteAESKeyGen")     14, false, false, false, 93, 11,  6, 1,  0, 0}, // #42
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  6, 1}, // #43
  {DBGFIELD("WriteFLogic")        1, false, false, false,  4, 3,  1, 1,  0, 0}, // #44
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 104, 11,  8, 1,  2, 1}, // #45
  {DBGFIELD("WriteBEXTR")         2, false, false, false, 104, 9,  3, 1,  0, 0}, // #46
  {DBGFIELD("WriteBEXTRLd")       3, false, false, false, 104, 11,  8, 1,  0, 0}, // #47
  {DBGFIELD("WriteALULd")         1, false, false, false,  1, 1,  8, 1,  0, 0}, // #48
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  6, 1}, // #49
  {DBGFIELD("WriteFBlend")        1, false, false, false,  4, 3,  1, 1,  0, 0}, // #50
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  6, 1}, // #51
  {DBGFIELD("WriteFVarBlend")     1, false, false, false,  4, 3,  1, 1,  0, 0}, // #52
  {DBGFIELD("WriteBLSLd")         2, false, false, false, 115, 4,  6, 1,  0, 0}, // #53
  {DBGFIELD("WriteBLS")           1, false, false, false, 115, 2, 12, 1,  0, 0}, // #54
  {DBGFIELD("WriteBSFLd")         2, false, false, false, 119, 9,  7, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSF")           1, false, false, false, 30, 7,  5, 1,  0, 0}, // #56
  {DBGFIELD("WriteBSRLd")         2, false, false, false, 119, 9,  7, 1,  0, 0}, // #57
  {DBGFIELD("WriteBSR")           1, false, false, false, 30, 7,  5, 1,  0, 0}, // #58
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 30, 7,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBSWAP64")       2, false, false, false, 104, 9, 12, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestImmLd")  2, false, false, false, 119, 9,  3, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestRegLd")  10, false, false, false, 128, 11,  8, 1,  0, 0}, // #62
  {DBGFIELD("WriteBitTest")       1, false, false, false, 30, 7,  1, 1,  0, 0}, // #63
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, false, 139, 11,  2, 1,  0, 0}, // #64
  {DBGFIELD("WriteBitTestSetRegRMW") 11, false, false, false, 150, 13, 13, 1,  0, 0}, // #65
  {DBGFIELD("WriteBitTestSet")    1, false, false, false, 30, 7,  1, 1,  0, 0}, // #66
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  2, 1}, // #67
  {DBGFIELD("WriteBZHI")          1, false, false, false, 30, 7,  5, 1,  0, 0}, // #68
  {DBGFIELD("WriteLoad")          1, false, false, false, 28, 2, 10, 1,  0, 0}, // #69
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 2, false, false, false, 163, 6,  6, 1,  1, 1}, // #70
  {DBGFIELD("WriteCMOV")          1, false, false, false, 10, 4,  1, 1,  0, 0}, // #71
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #72
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false,  1, 1,  8, 1,  2, 1}, // #73
  {DBGFIELD("WriteXCHG")          3, false, false, false, 15, 1, 12, 1,  0, 0}, // #74
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #75
  {DBGFIELD("WriteFCmp64X")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #76
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #77
  {DBGFIELD("WriteFCmpX")         1, false, false, false,  3, 4, 14, 1,  0, 0}, // #78
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #79
  {DBGFIELD("WriteFCmp64")        1, false, false, false,  3, 4, 14, 1,  0, 0}, // #80
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #81
  {DBGFIELD("WriteFCmp")          1, false, false, false,  3, 4, 14, 1,  0, 0}, // #82
  {DBGFIELD("WriteCMPXCHG")       5, false, false, false, 169, 4,  5, 1,  0, 0}, // #83
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 2, false, false, false, 173, 10,  7, 1,  6, 1}, // #84
  {DBGFIELD("WriteFComX")         1, false, false, false,  2, 8,  5, 1,  0, 0}, // #85
  {DBGFIELD("WriteFCom")          1, false, false, false, 60, 8,  1, 1,  0, 0}, // #86
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  1, 1}, // #87
  {DBGFIELD("WriteCRC32")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtI2PD")       2, false, false, false, 183, 9, 10, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtI2PS")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPD2ILd")     3, false, false, false, 192, 11,  2, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPD2I")       2, false, false, false, 183, 9, 10, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPD2PSLd")    3, false, false, false, 192, 11,  2, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtPD2PS")      2, false, false, false, 183, 9, 10, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtPS2I")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, false, 68, 6,  8, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtPS2PD")      2, false, false, false, 183, 9, 10, 1,  0, 0}, // #100
  {DBGFIELD("WriteCvtSD2ILd")     3, false, false, false, 203, 10,  2, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtSD2I")       2, false, false, false, 203, 8,  6, 1,  0, 0}, // #103
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 3, false, false, false, 192, 11,  2, 1,  6, 1}, // #104
  {DBGFIELD("WriteCvtSD2SS")      2, false, false, false, 183, 9, 10, 1,  0, 0}, // #105
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #107
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 2, false, false, false, 183, 9,  6, 1,  0, 1}, // #108
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 2, false, false, false, 183, 9,  6, 1,  7, 1}, // #109
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #110
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #111
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 2, false, false, false, 183, 9,  6, 1,  0, 1}, // #112
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 2, false, false, false, 183, 9,  6, 1,  7, 1}, // #113
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #114
  {DBGFIELD("WriteCvtSS2SD")      2, false, false, false, 183, 9, 10, 1,  0, 0}, // #115
  {DBGFIELD("WriteCvtSS2ILd")     3, false, false, false, 203, 10,  2, 1,  0, 0}, // #116
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #117
  {DBGFIELD("WriteCvtSS2I")       2, false, false, false, 203, 8,  6, 1,  0, 0}, // #118
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 213, 9, 15, 1,  2, 2}, // #119
  {DBGFIELD("WriteDiv16")         4, false, false, false, 213, 7, 16, 1,  0, 0}, // #120
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 213, 9, 17, 1,  2, 2}, // #121
  {DBGFIELD("WriteDiv32")         4, false, false, false, 213, 7, 11, 1,  0, 0}, // #122
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 222, 9, 18, 1,  2, 2}, // #123
  {DBGFIELD("WriteDiv64")         3, false, false, false, 222, 7, 13, 1,  0, 0}, // #124
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 222, 7, 19, 1,  2, 2}, // #125
  {DBGFIELD("WriteDiv8")          3, false, false, false, 222, 7, 20, 1,  0, 0}, // #126
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 2, false, false, false, 173, 10, 15, 1,  6, 1}, // #127
  {DBGFIELD("WriteFDiv64X")       1, false, false, false,  2, 8, 21, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 2, false, false, false, 173, 10, 13, 1,  6, 1}, // #129
  {DBGFIELD("WriteFDivX")         1, false, false, false,  2, 8,  8, 1,  0, 0}, // #130
  {DBGFIELD("WriteFDivLd")        2, false, false, false, 173, 10, 13, 1,  0, 0}, // #131
  {DBGFIELD("WriteFDiv")          1, false, false, false,  2, 8,  8, 1,  0, 0}, // #132
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 2, false, false, false, 173, 10, 17, 1,  6, 1}, // #133
  {DBGFIELD("WriteFDiv64")        1, false, false, false,  2, 8, 21, 1,  0, 0}, // #134
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 2, false, false, false, 173, 10, 13, 1,  6, 1}, // #135
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 4, false, false, false, 231, 8, 16, 1,  6, 1}, // #136
  {DBGFIELD("WriteDPPD")          3, false, false, false, 231, 6, 22, 1,  0, 0}, // #137
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 7, false, false, false, 239, 12, 23, 1,  6, 1}, // #138
  {DBGFIELD("WriteDPPS")          6, false, false, false, 251, 10, 21, 1,  0, 0}, // #139
  {DBGFIELD("WriteStore")         2, false, false, false, 37, 3,  2, 1,  0, 0}, // #140
  {DBGFIELD("WriteVecExtractSt")  3, false, false, false, 261, 8, 17, 1,  0, 0}, // #141
  {DBGFIELD("WriteVecExtract")    2, false, false, false, 269, 10, 14, 1,  0, 0}, // #142
  {DBGFIELD("WriteVecALUX")       1, false, false, false,  3, 4,  1, 1,  0, 0}, // #143
  {DBGFIELD("WriteFComLd")        2, false, false, false, 279, 12,  7, 1,  0, 0}, // #144
  {DBGFIELD("WriteEMMS")          10, false, false, false, 291, 8,  9, 1,  0, 0}, // #145
  {DBGFIELD("WriteFLDC")          2, false, false, false, 299, 5,  1, 1,  0, 0}, // #146
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #147
  {DBGFIELD("WriteVecIMulX")      1, false, false, false,  3, 4, 10, 1,  0, 0}, // #148
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  7, 1,  6, 1}, // #149
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, false, 304, 10,  2, 1,  6, 1}, // #150
  {DBGFIELD("WriteFHAdd")         3, false, false, false, 314, 8,  3, 1,  0, 0}, // #151
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 213, 9, 15, 1,  2, 2}, // #152
  {DBGFIELD("WriteIDiv16")        4, false, false, false, 213, 7, 16, 1,  0, 0}, // #153
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 213, 9, 17, 1,  2, 2}, // #154
  {DBGFIELD("WriteIDiv32")        4, false, false, false, 213, 7, 11, 1,  0, 0}, // #155
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 222, 9, 18, 1,  2, 2}, // #156
  {DBGFIELD("WriteIDiv64")        3, false, false, false, 222, 7, 13, 1,  0, 0}, // #157
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 222, 7, 19, 1,  2, 2}, // #158
  {DBGFIELD("WriteIDiv8")         3, false, false, false, 222, 7, 20, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 322, 11,  9, 1,  2, 2}, // #160
  {DBGFIELD("WriteIMul16")        4, false, false, false, 322, 9, 10, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  1, 1}, // #162
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, false, 333, 9, 22, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul16Reg")     1, false, false, false, 30, 7,  5, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 333, 7, 14, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 342, 11, 22, 1,  2, 2}, // #166
  {DBGFIELD("WriteIMul32")        3, false, false, false, 342, 9, 14, 1,  0, 0}, // #167
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  1, 1}, // #168
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, false, 119, 9,  7, 1,  0, 0}, // #169
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 30, 7,  5, 1,  0, 0}, // #170
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 30, 7,  5, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 353, 12, 22, 1,  2, 2}, // #172
  {DBGFIELD("WriteIMul64")        2, false, false, false, 365, 10, 14, 1,  0, 0}, // #173
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  1, 1}, // #174
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, false, 119, 9,  7, 1,  0, 0}, // #175
  {DBGFIELD("WriteIMul64Reg")     1, false, false, false, 30, 7,  5, 1,  0, 0}, // #176
  {DBGFIELD("WriteIMul64Imm")     1, false, false, false, 30, 7,  5, 1,  0, 0}, // #177
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  2, 2}, // #178
  {DBGFIELD("WriteIMul8")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #179
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 2, false, false, false, 375, 10,  7, 1,  6, 1}, // #180
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 60, 8,  1, 1,  0, 0}, // #181
  {DBGFIELD("WriteVecLogicX")     1, false, false, false,  4, 3,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteShuffle")       1, false, false, false, 60, 8,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, false, 10, 4,  5, 1,  0, 0}, // #184
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 28, 2,  6, 1,  0, 0}, // #185
  {DBGFIELD("WriteLDMXCSR")       4, false, false, false, 385, 10,  6, 1,  0, 0}, // #186
  {DBGFIELD("WriteFLD0")          1, false, false, false,  4, 5,  1, 1,  0, 0}, // #187
  {DBGFIELD("WriteFLD1")          2, false, false, false, 299, 5,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteFence")         1, false, false, false, 10, 4, 12, 1,  0, 0}, // #189
  {DBGFIELD("WriteLZCNTLd")       2, false, false, false, 119, 9,  7, 1,  0, 0}, // #190
  {DBGFIELD("WriteLZCNT")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecStoreX")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecStore")      2, false, false, false, 37, 3,  2, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false,  2, 8,  5, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 28, 2,  6, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecMoveX")      0, false, false, false,  0, 0,  1, 1,  0, 0}, // #197
  {DBGFIELD("WriteVecStoreNT")    2, false, false, false, 37, 3, 25, 1,  0, 0}, // #198
  {DBGFIELD("WriteVecMove")       1, false, false, false,  4, 5,  1, 1,  0, 0}, // #199
  {DBGFIELD("WriteVecALULd")      2, false, false, false, 173, 10, 22, 1,  0, 0}, // #200
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 2, false, false, false, 375, 10, 22, 1,  6, 1}, // #201
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 2, false, false, false, 173, 10, 22, 1,  6, 1}, // #202
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 2, false, false, false, 395, 7, 22, 1,  6, 1}, // #203
  {DBGFIELD("WriteVecLogic")      1, false, false, false,  4, 5,  1, 1,  0, 0}, // #204
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 402, 10,  8, 1,  6, 1}, // #205
  {DBGFIELD("WritePHAdd")         3, false, false, false, 412, 8,  5, 1,  0, 0}, // #206
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, false, 53, 7,  7, 1,  1, 1}, // #207
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 2, false, false, false, 420, 8, 14, 1,  7, 1}, // #208
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 2, false, false, false, 173, 10, 24, 1,  6, 1}, // #209
  {DBGFIELD("WriteVecIMul")       1, false, false, false,  2, 8, 10, 1,  0, 0}, // #210
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, false,  2, 8,  5, 1,  0, 0}, // #211
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #212
  {DBGFIELD("WritePSADBW")        1, false, false, false, 60, 8,  5, 1,  0, 0}, // #213
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 3, false, false, false, 428, 13,  8, 1,  6, 1}, // #214
  {DBGFIELD("WriteVarShuffle")    2, false, false, false, 441, 11,  5, 1,  0, 0}, // #215
  {DBGFIELD("WriteShuffleLd")     2, false, false, false, 375, 10, 22, 1,  0, 0}, // #216
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false,  2, 8,  1, 1,  0, 0}, // #217
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 2, false, false, false, 173, 10, 22, 1,  6, 1}, // #218
  {DBGFIELD("WriteVecShift")      1, false, false, false,  2, 8,  1, 1,  0, 0}, // #219
  {DBGFIELD("WriteFMoveX")        0, false, false, false,  0, 0,  1, 1,  0, 0}, // #220
  {DBGFIELD("WriteFShuffleLd")    2, false, false, false, 375, 10,  7, 1,  0, 0}, // #221
  {DBGFIELD("WriteFStore")        2, false, false, false, 37, 3,  2, 1,  0, 0}, // #222
  {DBGFIELD("WriteFMOVMSK")       1, false, false, false,  2, 8,  5, 1,  0, 0}, // #223
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 28, 2,  6, 1,  0, 0}, // #224
  {DBGFIELD("WriteStoreNT")       2, false, false, false, 37, 3, 26, 1,  0, 0}, // #225
  {DBGFIELD("WriteFStoreNTX")     2, false, false, false, 37, 3, 27, 1,  0, 0}, // #226
  {DBGFIELD("WriteFStoreNT")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #227
  {DBGFIELD("WriteFLoad")         1, false, false, false, 28, 2,  6, 1,  0, 0}, // #228
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 3, false, false, false, 452, 10,  8, 1,  6, 1}, // #229
  {DBGFIELD("WriteMPSAD")         2, false, false, false, 420, 8, 14, 1,  0, 0}, // #230
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #231
  {DBGFIELD("WriteFMul64X")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #232
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #233
  {DBGFIELD("WriteFMulX")         1, false, false, false,  3, 4, 14, 1,  0, 0}, // #234
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #235
  {DBGFIELD("WriteFMul64")        1, false, false, false,  3, 4, 14, 1,  0, 0}, // #236
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #237
  {DBGFIELD("WriteFMul")          1, false, false, false,  3, 4, 14, 1,  0, 0}, // #238
  {DBGFIELD("WriteMULX32Ld")      3, false, false, false, 342, 11, 22, 1,  0, 0}, // #239
  {DBGFIELD("WriteMULX32")        2, false, false, false, 342, 9, 14, 1,  0, 0}, // #240
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 4, false, false, false, 342, 11, 28, 2,  2, 1}, // #241
  {DBGFIELD("WriteIMulH_WriteMULX32") 3, false, false, false, 342, 9, 30, 2,  0, 0}, // #242
  {DBGFIELD("WriteMULX64Ld")      2, false, false, false, 353, 12, 22, 1,  0, 0}, // #243
  {DBGFIELD("WriteMULX64")        1, false, false, false, 365, 10, 14, 1,  0, 0}, // #244
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 353, 12, 28, 2,  2, 1}, // #245
  {DBGFIELD("WriteIMulH_WriteMULX64") 2, false, false, false, 365, 10, 30, 2,  0, 0}, // #246
  {DBGFIELD("WriteFMulLd")        2, false, false, false, 68, 6,  8, 1,  0, 0}, // #247
  {DBGFIELD("WriteVecALUXLd")     2, false, false, false, 68, 6,  7, 1,  0, 0}, // #248
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  6, 1}, // #249
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 53, 5,  1, 1,  0, 0}, // #250
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  6, 1}, // #251
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  6, 1}, // #252
  {DBGFIELD("WriteVarBlend")      1, false, false, false,  4, 3,  1, 1,  0, 0}, // #253
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  6, 1}, // #254
  {DBGFIELD("WriteBlend")         1, false, false, false, 53, 5,  1, 1,  0, 0}, // #255
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 2, false, false, false, 375, 10,  9, 1,  6, 1}, // #256
  {DBGFIELD("WriteCLMul")         1, false, false, false, 60, 8,  5, 1,  0, 0}, // #257
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 8, false, false, false, 462, 14, 32, 1,  6, 1}, // #258
  {DBGFIELD("WritePCmpEStrI")     8, false, false, false, 476, 12, 16, 1,  0, 0}, // #259
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 9, false, false, false, 488, 14, 20, 1,  6, 1}, // #260
  {DBGFIELD("WritePCmpEStrM")     9, false, false, false, 502, 12, 16, 1,  0, 0}, // #261
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 4, false, false, false, 514, 10, 32, 1,  6, 1}, // #262
  {DBGFIELD("WritePCmpIStrI")     3, false, false, false, 514, 8,  8, 1,  0, 0}, // #263
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 4, false, false, false, 514, 10, 16, 1,  6, 1}, // #264
  {DBGFIELD("WritePCmpIStrM")     3, false, false, false, 514, 8,  8, 1,  0, 0}, // #265
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #266
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, false, 524, 7, 22, 1,  6, 1}, // #267
  {DBGFIELD("WritePHAddX")        3, false, false, false, 524, 5, 12, 1,  0, 0}, // #268
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, false, 173, 10,  8, 1,  0, 0}, // #269
  {DBGFIELD("WritePHMINPOS")      1, false, false, false,  2, 8, 14, 1,  0, 0}, // #270
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #271
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, false,  2, 8,  5, 1,  0, 0}, // #272
  {DBGFIELD("WriteShuffleXLd")    2, false, false, false, 53, 7,  7, 1,  0, 0}, // #273
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 3, false, false, false, 74, 6, 13, 1,  6, 1}, // #274
  {DBGFIELD("WritePMULLD")        2, false, false, false, 74, 4,  9, 1,  0, 0}, // #275
  {DBGFIELD("WriteCopy")          3, false, false, false, 18, 4, 20, 1,  0, 0}, // #276
  {DBGFIELD("WritePOPCNTLd")      2, false, false, false, 119, 9,  7, 1,  0, 0}, // #277
  {DBGFIELD("WritePOPCNT")        1, false, false, false, 30, 7,  5, 1,  0, 0}, // #278
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, false, 375, 10,  9, 1,  6, 1}, // #279
  {DBGFIELD("WritePSADBWX")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #280
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  6, 1}, // #281
  {DBGFIELD("WriteVarShuffleX")   1, false, false, false, 53, 5,  1, 1,  0, 0}, // #282
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false,  3, 4,  1, 1,  0, 0}, // #283
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  7, 1,  6, 1}, // #284
  {DBGFIELD("WriteVecShiftX")     2, false, false, false, 531, 6, 12, 1,  0, 0}, // #285
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 3, false, false, false, 428, 13, 22, 1,  6, 1}, // #286
  {DBGFIELD("WriteVecTest")       2, false, false, false, 441, 11, 14, 1,  0, 0}, // #287
  {DBGFIELD("WriteRotateLd_WriteRMW") 6, false, false, false, 14, 8, 33, 2,  0, 0}, // #288
  {DBGFIELD("WriteRotateLd_WriteRotate") 6, false, false, false, 537, 4, 35, 2,  0, 0}, // #289
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 10, false, false, false, 541, 13, 37, 2,  0, 0}, // #290
  {DBGFIELD("WriteRotateCLLd_WriteRotateCL") 9, false, false, false, 554, 9, 39, 2,  0, 0}, // #291
  {DBGFIELD("WriteRotate")        3, false, false, false, 14, 4, 12, 1,  0, 0}, // #292
  {DBGFIELD("WriteRotateCL")      2, false, false, false, 563, 4, 12, 1,  0, 0}, // #293
  {DBGFIELD("WriteFRcpXLd")       2, false, false, false, 173, 10,  8, 1,  0, 0}, // #294
  {DBGFIELD("WriteFRcpX")         1, false, false, false,  2, 8, 14, 1,  0, 0}, // #295
  {DBGFIELD("WriteFRcpLd")        2, false, false, false, 173, 10,  8, 1,  0, 0}, // #296
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 2, false, false, false, 173, 10,  8, 1,  6, 1}, // #297
  {DBGFIELD("WriteFRcp")          1, false, false, false,  2, 8, 14, 1,  0, 0}, // #298
  {DBGFIELD("WriteShiftLd")       1, false, false, false, 10, 4,  2, 1,  0, 0}, // #299
  {DBGFIELD("WriteShift")         1, false, false, false, 10, 4,  1, 1,  0, 0}, // #300
  {DBGFIELD("WriteFRndLd")        3, false, false, false, 74, 6, 11, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRnd")          2, false, false, false, 74, 4,  7, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 3, false, false, false, 74, 6, 11, 1,  6, 1}, // #303
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, false, 173, 10,  8, 1,  0, 0}, // #304
  {DBGFIELD("WriteFRsqrtX")       1, false, false, false,  2, 8, 14, 1,  0, 0}, // #305
  {DBGFIELD("WriteFRsqrtLd")      2, false, false, false, 173, 10,  8, 1,  0, 0}, // #306
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 2, false, false, false, 173, 10,  8, 1,  6, 1}, // #307
  {DBGFIELD("WriteFRsqrt")        1, false, false, false,  2, 8, 14, 1,  0, 0}, // #308
  {DBGFIELD("WriteShiftLd_WriteRMW") 4, false, false, false, 567, 8, 33, 2,  0, 0}, // #309
  {DBGFIELD("WriteShiftLd_WriteShift") 2, false, false, false, 563, 4, 33, 2,  0, 0}, // #310
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 5, false, false, false, 575, 8, 33, 2,  0, 0}, // #311
  {DBGFIELD("WriteShiftCLLd_WriteShiftCL") 4, false, false, false, 583, 4, 35, 2,  0, 0}, // #312
  {DBGFIELD("WriteShiftCL")       2, false, false, false, 563, 4, 12, 1,  0, 0}, // #313
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 10, 4,  2, 1,  2, 1}, // #314
  {DBGFIELD("WriteSETCCStore")    4, false, false, false, 587, 7, 24, 1,  0, 0}, // #315
  {DBGFIELD("WriteSETCC")         2, false, false, false, 563, 4, 12, 1,  0, 0}, // #316
  {DBGFIELD("WriteSHDmrcl")       6, false, false, false, 594, 13,  2, 1,  0, 0}, // #317
  {DBGFIELD("WriteSHDmri")        5, false, false, false, 607, 11,  2, 1,  0, 0}, // #318
  {DBGFIELD("WriteSHDrrcl")       3, false, false, false, 342, 9, 10, 1,  0, 0}, // #319
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, false, 173, 10, 41, 1,  0, 0}, // #320
  {DBGFIELD("WriteFSqrt64X")      1, false, false, false,  2, 8, 13, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, false, 173, 10, 17, 1,  0, 0}, // #322
  {DBGFIELD("WriteFSqrtX")        1, false, false, false,  2, 8,  2, 1,  0, 0}, // #323
  {DBGFIELD("WriteFSqrt64Ld")     2, false, false, false, 173, 10, 18, 1,  0, 0}, // #324
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 2, false, false, false, 173, 10, 18, 1,  6, 1}, // #325
  {DBGFIELD("WriteFSqrt64")       1, false, false, false,  2, 8, 13, 1,  0, 0}, // #326
  {DBGFIELD("WriteFSqrtLd")       2, false, false, false, 173, 10, 17, 1,  0, 0}, // #327
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 2, false, false, false, 173, 10, 17, 1,  6, 1}, // #328
  {DBGFIELD("WriteFSqrt")         1, false, false, false,  2, 8,  2, 1,  0, 0}, // #329
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 618, 9, 23, 1,  0, 0}, // #330
  {DBGFIELD("WriteSTMXCSR")       4, false, false, false, 627, 11,  2, 1,  0, 0}, // #331
  {DBGFIELD("WriteTZCNTLd")       2, false, false, false, 119, 9,  7, 1,  0, 0}, // #332
  {DBGFIELD("WriteTZCNT")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #333
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteFMALd")         2, false, false, false, 68, 6,  8, 1,  0, 0}, // #335
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, false, 53, 7,  8, 1,  6, 1}, // #336
  {DBGFIELD("WriteFAdd64Y")       1, false, false, false, 53, 5,  5, 1,  0, 0}, // #337
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, false, 53, 7,  8, 1,  6, 1}, // #340
  {DBGFIELD("WriteFAddY")         1, false, false, false, 53, 5,  5, 1,  0, 0}, // #341
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 53, 7, 22, 1,  6, 1}, // #344
  {DBGFIELD("WriteShuffleY")      1, false, false, false, 53, 5,  1, 1,  0, 0}, // #345
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, false, 69, 5, 22, 1,  6, 1}, // #348
  {DBGFIELD("WriteFLogicY")       1, false, false, false,  4, 3,  1, 1,  0, 0}, // #349
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, false, 183, 9,  7, 1,  0, 0}, // #352
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, false, 183, 9,  3, 1,  0, 0}, // #353
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 4, false, false, false, 638, 5,  9, 1,  6, 1}, // #354
  {DBGFIELD("WriteFVarBlendY")    3, false, false, false, 223, 3,  5, 1,  0, 0}, // #355
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, false, 69, 5, 22, 1,  6, 1}, // #358
  {DBGFIELD("WriteFBlendY")       1, false, false, false,  4, 3,  1, 1,  0, 0}, // #359
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 4, false, false, false, 638, 5,  9, 1,  8, 2}, // #360
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  8, 2}, // #361
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, false, 375, 10,  8, 1,  0, 0}, // #362
  {DBGFIELD("WriteShuffle256")    1, false, false, false, 60, 8,  5, 1,  0, 0}, // #363
  {DBGFIELD("WriteShuffleYLd")    2, false, false, false, 53, 7, 22, 1,  0, 0}, // #364
  {DBGFIELD("WriteFShuffle256")   1, false, false, false, 60, 8,  5, 1,  0, 0}, // #365
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #366
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #367
  {DBGFIELD("WriteFCmp64Y")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #368
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #369
  {DBGFIELD("WriteFCmpY")         1, false, false, false,  3, 4, 14, 1,  0, 0}, // #370
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #373
  {DBGFIELD("WriteVarShuffle256") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #374
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, false, 68, 6,  2, 1,  0, 0}, // #375
  {DBGFIELD("WriteCvtI2PDY")      2, false, false, false, 183, 9,  6, 1,  0, 0}, // #376
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #377
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #378
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, false, 68, 6,  2, 1,  0, 0}, // #379
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, false,  3, 4, 14, 1,  0, 0}, // #380
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #381
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 3, false, false, false, 192, 11,  2, 1,  6, 1}, // #383
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 3, false, false, false, 192, 11, 11, 1,  6, 1}, // #384
  {DBGFIELD("WriteCvtPD2PSY")     2, false, false, false, 183, 9,  6, 1,  0, 0}, // #385
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtPD2PSYLd")   3, false, false, false, 192, 11, 11, 1,  0, 0}, // #388
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPD2IYLd")    3, false, false, false, 192, 11, 11, 1,  0, 0}, // #390
  {DBGFIELD("WriteCvtPD2IY")      2, false, false, false, 183, 9,  6, 1,  0, 0}, // #391
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, false, 68, 6,  2, 1,  0, 0}, // #394
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, false,  3, 4, 14, 1,  0, 0}, // #395
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #396
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #397
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, false, 68, 6,  2, 1,  0, 0}, // #398
  {DBGFIELD("WriteCvtPS2PDY")     2, false, false, false, 183, 9,  6, 1,  0, 0}, // #399
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #401
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, false, 68, 6,  2, 1,  0, 0}, // #402
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, false, 68, 6,  2, 1,  0, 0}, // #403
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtPS2PHYSt")   3, false, false, false, 643, 7,  2, 1,  0, 0}, // #406
  {DBGFIELD("WriteCvtPS2PHY")     2, false, false, false, 183, 9,  7, 1,  0, 0}, // #407
  {DBGFIELD("WriteCvtPS2PHSt")    3, false, false, false, 643, 7,  2, 1,  0, 0}, // #408
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, false, 183, 9,  3, 1,  0, 0}, // #409
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 3, false, false, false, 203, 10,  2, 1,  6, 1}, // #412
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 3, false, false, false, 203, 10,  2, 1,  6, 1}, // #413
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #414
  {DBGFIELD("WritePSADBWY")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #415
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 2, false, false, false, 173, 10, 23, 1,  6, 1}, // #418
  {DBGFIELD("WriteFDiv64Y")       1, false, false, false,  2, 8, 21, 1,  0, 0}, // #419
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 2, false, false, false, 173, 10, 17, 1,  6, 1}, // #422
  {DBGFIELD("WriteFDivY")         1, false, false, false,  2, 8,  8, 1,  0, 0}, // #423
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #426
  {DBGFIELD("WriteFMAX")          1, false, false, false,  3, 4, 14, 1,  0, 0}, // #427
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #428
  {DBGFIELD("WriteFMAY")          1, false, false, false,  3, 4, 14, 1,  0, 0}, // #429
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #430
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #431
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 7, false, false, false, 239, 12, 19, 1,  6, 1}, // #432
  {DBGFIELD("WriteDPPSY")         6, false, false, false, 251, 10, 21, 1,  0, 0}, // #433
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #434
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1, 10, 2}, // #435
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1, 10, 2}, // #436
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1, 10, 2}, // #438
  {DBGFIELD("WriteFMA")           1, false, false, false,  3, 4, 14, 1,  0, 0}, // #439
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  8, 2}, // #440
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  8, 2}, // #441
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  8, 2}, // #442
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 3, false, false, false, 74, 6, 16, 1,  6, 1}, // #443
  {DBGFIELD("WriteFRndY")         2, false, false, false, 74, 4,  7, 1,  0, 0}, // #444
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 1, false, false, false, 28, 2, 42, 2,  0, 0}, // #445
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #448
  {DBGFIELD("WriteVecIMulY")      1, false, false, false,  3, 4, 10, 1,  0, 0}, // #449
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6, 22, 1,  6, 1}, // #452
  {DBGFIELD("WriteVecALUY")       1, false, false, false,  3, 4,  1, 1,  0, 0}, // #453
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #454
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 4, false, false, false, 304, 10, 24, 1,  6, 1}, // #456
  {DBGFIELD("WriteFHAddY")        3, false, false, false, 314, 8, 10, 1,  0, 0}, // #457
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #458
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #459
  {DBGFIELD("WriteVecLoadY")      1, false, false, false, 28, 2,  7, 1,  0, 0}, // #460
  {DBGFIELD("WriteFMaskedStore64Y") 3, false, false, false, 650, 11, 21, 1,  0, 0}, // #461
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, false, 69, 5, 22, 1,  0, 0}, // #462
  {DBGFIELD("WriteFMaskedStore64") 3, false, false, false, 650, 11, 21, 1,  0, 0}, // #463
  {DBGFIELD("WriteFMaskedLoad")   2, false, false, false, 69, 5,  7, 1,  0, 0}, // #464
  {DBGFIELD("WriteFMaskedStore32Y") 3, false, false, false, 650, 11, 21, 1,  0, 0}, // #465
  {DBGFIELD("WriteFMaskedStore32") 3, false, false, false, 650, 11, 21, 1,  0, 0}, // #466
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteFMoveY")        0, false, false, false,  0, 0,  1, 1,  0, 0}, // #469
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, false, 375, 10, 22, 1,  0, 0}, // #471
  {DBGFIELD("WriteFShuffleY")     1, false, false, false, 60, 8,  1, 1,  0, 0}, // #472
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #473
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteVecStoreY")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #475
  {DBGFIELD("WriteVecMoveY")      0, false, false, false,  0, 0,  1, 1,  0, 0}, // #476
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, false, 28, 2,  7, 1,  0, 0}, // #478
  {DBGFIELD("WriteVecStoreNTY")   2, false, false, false, 37, 3, 44, 1,  0, 0}, // #479
  {DBGFIELD("WriteFStoreNTY")     2, false, false, false, 37, 3, 45, 1,  0, 0}, // #480
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 3, false, false, false, 452, 10,  2, 1,  6, 1}, // #481
  {DBGFIELD("WriteMPSADY")        2, false, false, false, 420, 8, 14, 1,  0, 0}, // #482
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #483
  {DBGFIELD("WriteFMul64Y")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #484
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #487
  {DBGFIELD("WriteFMulY")         1, false, false, false,  3, 4, 14, 1,  0, 0}, // #488
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteVecALUYLd")     2, false, false, false, 68, 6, 22, 1,  0, 0}, // #491
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #492
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 2, false, false, false, 69, 5, 22, 1,  6, 1}, // #493
  {DBGFIELD("WriteVecLogicY")     1, false, false, false,  4, 3,  1, 1,  0, 0}, // #494
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 2, false, false, false, 69, 5, 22, 1,  6, 1}, // #497
  {DBGFIELD("WriteBlendY")        1, false, false, false,  4, 3,  1, 1,  0, 0}, // #498
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 4, false, false, false, 638, 5,  9, 1,  6, 1}, // #499
  {DBGFIELD("WriteVarBlendY")     3, false, false, false, 223, 3,  5, 1,  0, 0}, // #500
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #501
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #502
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 4, false, false, false, 638, 5,  9, 1,  8, 2}, // #503
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  8, 2}, // #504
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 53, 7, 22, 1,  8, 2}, // #505
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 53, 7, 22, 1, 10, 2}, // #506
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  8, 2}, // #507
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1, 10, 2}, // #508
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6, 24, 1, 10, 2}, // #509
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6, 24, 1, 10, 2}, // #510
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #512
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #513
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 375, 10, 22, 1,  8, 2}, // #514
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 375, 10, 22, 1, 10, 2}, // #515
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, false, 60, 8,  1, 1,  0, 0}, // #516
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 375, 10,  7, 1,  8, 2}, // #517
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 375, 10,  7, 1, 10, 2}, // #518
  {DBGFIELD("WriteFVarShuffle")   1, false, false, false, 60, 8,  1, 1,  0, 0}, // #519
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 375, 10, 22, 1,  6, 1}, // #520
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 2, false, false, false, 375, 10,  7, 1,  6, 1}, // #521
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #522
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 4, false, false, false, 524, 7,  9, 1,  6, 1}, // #524
  {DBGFIELD("WritePHAddY")        3, false, false, false, 524, 5, 12, 1,  0, 0}, // #525
  {DBGFIELD("WriteVecInsert")     2, false, false, false, 420, 8, 14, 1,  0, 0}, // #526
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, false, 68, 6, 24, 1,  0, 0}, // #527
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, false, 68, 6, 24, 1,  0, 0}, // #528
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("WriteVecMaskedStore32Y") 3, false, false, false, 650, 11, 21, 1,  0, 0}, // #530
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, false, 69, 5, 22, 1,  0, 0}, // #531
  {DBGFIELD("WriteVecMaskedStore32") 3, false, false, false, 650, 11, 21, 1,  0, 0}, // #532
  {DBGFIELD("WriteVecMaskedLoad") 2, false, false, false, 69, 5,  7, 1,  0, 0}, // #533
  {DBGFIELD("WriteVecMaskedStore64Y") 3, false, false, false, 650, 11, 21, 1,  0, 0}, // #534
  {DBGFIELD("WriteVecMaskedStore64") 3, false, false, false, 650, 11, 21, 1,  0, 0}, // #535
  {DBGFIELD("WriteVPMOV256Ld")    2, false, false, false, 375, 10,  8, 1,  0, 0}, // #536
  {DBGFIELD("WriteVPMOV256")      1, false, false, false, 60, 8,  5, 1,  0, 0}, // #537
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, false,  2, 8, 14, 1,  0, 0}, // #538
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 3, false, false, false, 74, 6, 13, 1,  6, 1}, // #539
  {DBGFIELD("WritePMULLDY")       2, false, false, false, 74, 4,  9, 1,  0, 0}, // #540
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  8, 2}, // #543
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1, 10, 2}, // #544
  {DBGFIELD("WriteVecShiftImmXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #545
  {DBGFIELD("WriteVecShiftImmYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, false,  3, 4,  1, 1,  0, 0}, // #547
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #548
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  7, 1,  6, 1}, // #550
  {DBGFIELD("WriteVarVecShift")   1, false, false, false,  3, 4,  1, 1,  0, 0}, // #551
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6, 22, 1,  6, 1}, // #552
  {DBGFIELD("WriteVarVecShiftY")  1, false, false, false,  3, 4,  1, 1,  0, 0}, // #553
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #554
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 53, 7, 22, 1,  6, 1}, // #557
  {DBGFIELD("WriteVarShuffleY")   1, false, false, false, 53, 5,  1, 1,  0, 0}, // #558
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #559
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #560
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #561
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6, 22, 1,  6, 1}, // #562
  {DBGFIELD("WriteVecShiftY")     2, false, false, false, 183, 9, 14, 1,  0, 0}, // #563
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 3, false, false, false, 428, 13,  2, 1,  6, 1}, // #566
  {DBGFIELD("WriteVecTestY")      2, false, false, false, 441, 11,  3, 1,  0, 0}, // #567
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 2, false, false, false, 173, 10,  8, 1,  6, 1}, // #568
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 2, false, false, false, 173, 10,  2, 1,  6, 1}, // #569
  {DBGFIELD("WriteFRcpY")         1, false, false, false,  2, 8, 14, 1,  0, 0}, // #570
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #572
  {DBGFIELD("WriteFRcpYLd")       2, false, false, false, 173, 10,  2, 1,  0, 0}, // #573
  {DBGFIELD("WriteFRndYLd")       3, false, false, false, 74, 6, 16, 1,  0, 0}, // #574
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 2, false, false, false, 173, 10,  8, 1,  6, 1}, // #575
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 2, false, false, false, 173, 10,  2, 1,  6, 1}, // #576
  {DBGFIELD("WriteFRsqrtY")       1, false, false, false,  2, 8, 14, 1,  0, 0}, // #577
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #578
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, false, 173, 10,  2, 1,  0, 0}, // #580
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 375, 10, 22, 1,  6, 1}, // #581
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #582
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, false, 173, 10, 46, 1,  0, 0}, // #583
  {DBGFIELD("WriteFSqrt64Y")      1, false, false, false,  2, 8, 13, 1,  0, 0}, // #584
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 2, false, false, false, 173, 10, 41, 1,  6, 1}, // #585
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 2, false, false, false, 173, 10, 46, 1,  6, 1}, // #586
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #587
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #588
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 2, false, false, false, 173, 10, 17, 1,  6, 1}, // #589
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 2, false, false, false, 173, 10, 15, 1,  6, 1}, // #590
  {DBGFIELD("WriteFSqrtY")        1, false, false, false,  2, 8,  2, 1,  0, 0}, // #591
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #592
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #593
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, false, 173, 10, 15, 1,  0, 0}, // #594
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 2, false, false, false, 173, 10,  8, 1,  6, 1}, // #595
  {DBGFIELD("WriteFTestY")        1, false, false, false,  2, 8, 10, 1,  0, 0}, // #596
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, false, 173, 10,  7, 1,  6, 1}, // #597
  {DBGFIELD("WriteFTest")         1, false, false, false,  2, 8,  5, 1,  0, 0}, // #598
  {DBGFIELD("WriteALULd_WriteRMW") 4, false, false, false, 40, 5, 47, 2,  0, 0}, // #599
  {DBGFIELD("COPY")               8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #600
  {DBGFIELD("XAM_F")              1, false, false, false,  2, 8, 12, 1,  0, 0}, // #601
  {DBGFIELD("LD_Frr")             1, false, false, false,  5, 2,  1, 1,  0, 0}, // #602
  {DBGFIELD("MOVSX64rr32")        1, false, false, false, 115, 2,  1, 1,  0, 0}, // #603
  {DBGFIELD("RCL16m1_RCL16m1_EVEX_RCL16mi_RCL16mi_EVEX_RCL32m1_RCL32m1_EVEX_RCL32mi_RCL32mi_EVEX_RCL64m1_RCL64m1_EVEX_RCL64mi_RCL64mi_EVEX_RCL8m1_RCL8m1_EVEX_RCL8mi_RCL8mi_EVEX_RCR16m1_RCR16m1_EVEX_RCR16mi_RCR16mi_EVEX_RCR32m1_RCR32m1_EVEX_RCR32mi_RCR32mi_EVEX_RCR64m1_RCR64m1_EVEX_RCR64mi_RCR64mi_EVEX_RCR8m1_RCR8m1_EVEX_RCR8mi_RCR8mi_EVEX_ROL16m1_ROL16m1_EVEX_ROL16m1_NF_ROL16mi_ROL16mi_EVEX_ROL16mi_NF_ROL32m1_ROL32m1_EVEX_ROL32m1_NF_ROL32mi_ROL32mi_EVEX_ROL32mi_NF_ROL64m1_ROL64m1_EVEX_ROL64m1_NF_ROL64mi_ROL64mi_EVEX_ROL64mi_NF_ROL8m1_ROL8m1_EVEX_ROL8m1_NF_ROL8mi_ROL8mi_EVEX_ROL8mi_NF_ROR16m1_ROR16m1_EVEX_ROR16m1_NF_ROR16mi_ROR16mi_EVEX_ROR16mi_NF_ROR32m1_ROR32m1_EVEX_ROR32m1_NF_ROR32mi_ROR32mi_EVEX_ROR32mi_NF_ROR64m1_ROR64m1_EVEX_ROR64m1_NF_ROR64mi_ROR64mi_EVEX_ROR64mi_NF_ROR8m1_ROR8m1_EVEX_ROR8m1_NF_ROR8mi_ROR8mi_EVEX_ROR8mi_NF") 6, false, false, false, 14, 8, 33, 2,  0, 0}, // #604
  {DBGFIELD("RCL16m1_ND_RCL16mi_ND_RCL32m1_ND_RCL32mi_ND_RCL64m1_ND_RCL64mi_ND_RCL8m1_ND_RCL8mi_ND_RCR16m1_ND_RCR16mi_ND_RCR32m1_ND_RCR32mi_ND_RCR64m1_ND_RCR64mi_ND_RCR8m1_ND_RCR8mi_ND_ROL16m1_ND_ROL16m1_NF_ND_ROL16mi_ND_ROL16mi_NF_ND_ROL32m1_ND_ROL32m1_NF_ND_ROL32mi_ND_ROL32mi_NF_ND_ROL64m1_ND_ROL64m1_NF_ND_ROL64mi_ND_ROL64mi_NF_ND_ROL8m1_ND_ROL8m1_NF_ND_ROL8mi_ND_ROL8mi_NF_ND_ROR16m1_ND_ROR16m1_NF_ND_ROR16mi_ND_ROR16mi_NF_ND_ROR32m1_ND_ROR32m1_NF_ND_ROR32mi_ND_ROR32mi_NF_ND_ROR64m1_ND_ROR64m1_NF_ND_ROR64mi_ND_ROR64mi_NF_ND_ROR8m1_ND_ROR8m1_NF_ND_ROR8mi_ND_ROR8mi_NF_ND") 6, false, false, false, 537, 4, 35, 2,  0, 0}, // #605
  {DBGFIELD("RCL16mCL_RCL16mCL_EVEX_RCL32mCL_RCL32mCL_EVEX_RCL64mCL_RCL64mCL_EVEX_RCL8mCL_RCL8mCL_EVEX_RCR16mCL_RCR16mCL_EVEX_RCR32mCL_RCR32mCL_EVEX_RCR64mCL_RCR64mCL_EVEX_RCR8mCL_RCR8mCL_EVEX_ROL16mCL_ROL16mCL_EVEX_ROL16mCL_NF_ROL32mCL_ROL32mCL_EVEX_ROL32mCL_NF_ROL64mCL_ROL64mCL_EVEX_ROL64mCL_NF_ROL8mCL_ROL8mCL_EVEX_ROL8mCL_NF_ROR16mCL_ROR16mCL_EVEX_ROR16mCL_NF_ROR32mCL_ROR32mCL_EVEX_ROR32mCL_NF_ROR64mCL_ROR64mCL_EVEX_ROR64mCL_NF_ROR8mCL_ROR8mCL_EVEX_ROR8mCL_NF") 10, false, false, false, 541, 13, 37, 2,  0, 0}, // #606
  {DBGFIELD("RCL16mCL_ND_RCL32mCL_ND_RCL64mCL_ND_RCL8mCL_ND_RCR16mCL_ND_RCR32mCL_ND_RCR64mCL_ND_RCR8mCL_ND_ROL16mCL_ND_ROL16mCL_NF_ND_ROL32mCL_ND_ROL32mCL_NF_ND_ROL64mCL_ND_ROL64mCL_NF_ND_ROL8mCL_ND_ROL8mCL_NF_ND_ROR16mCL_ND_ROR16mCL_NF_ND_ROR32mCL_ND_ROR32mCL_NF_ND_ROR64mCL_ND_ROR64mCL_NF_ND_ROR8mCL_ND_ROR8mCL_NF_ND") 9, false, false, false, 554, 9, 39, 2,  0, 0}, // #607
  {DBGFIELD("SAR16m1_SAR16m1_EVEX_SAR16m1_NF_SAR16mi_SAR16mi_EVEX_SAR16mi_NF_SAR32m1_SAR32m1_EVEX_SAR32m1_NF_SAR32mi_SAR32mi_EVEX_SAR32mi_NF_SAR64m1_SAR64m1_EVEX_SAR64m1_NF_SAR64mi_SAR64mi_EVEX_SAR64mi_NF_SAR8m1_SAR8m1_EVEX_SAR8m1_NF_SAR8mi_SAR8mi_EVEX_SAR8mi_NF_SHL16m1_SHL16m1_EVEX_SHL16m1_NF_SHL16mi_SHL16mi_EVEX_SHL16mi_NF_SHL32m1_SHL32m1_EVEX_SHL32m1_NF_SHL32mi_SHL32mi_EVEX_SHL32mi_NF_SHL64m1_SHL64m1_EVEX_SHL64m1_NF_SHL64mi_SHL64mi_EVEX_SHL64mi_NF_SHL8m1_SHL8m1_EVEX_SHL8m1_NF_SHL8mi_SHL8mi_EVEX_SHL8mi_NF_SHR16m1_SHR16m1_EVEX_SHR16m1_NF_SHR16mi_SHR16mi_EVEX_SHR16mi_NF_SHR32m1_SHR32m1_EVEX_SHR32m1_NF_SHR32mi_SHR32mi_EVEX_SHR32mi_NF_SHR64m1_SHR64m1_EVEX_SHR64m1_NF_SHR64mi_SHR64mi_EVEX_SHR64mi_NF_SHR8m1_SHR8m1_EVEX_SHR8m1_NF_SHR8mi_SHR8mi_EVEX_SHR8mi_NF") 4, false, false, false, 567, 8, 33, 2,  0, 0}, // #608
  {DBGFIELD("SAR16m1_ND_SAR16m1_NF_ND_SAR16mi_ND_SAR16mi_NF_ND_SAR32m1_ND_SAR32m1_NF_ND_SAR32mi_ND_SAR32mi_NF_ND_SAR64m1_ND_SAR64m1_NF_ND_SAR64mi_ND_SAR64mi_NF_ND_SAR8m1_ND_SAR8m1_NF_ND_SAR8mi_ND_SAR8mi_NF_ND_SHL16m1_ND_SHL16m1_NF_ND_SHL16mi_ND_SHL16mi_NF_ND_SHL32m1_ND_SHL32m1_NF_ND_SHL32mi_ND_SHL32mi_NF_ND_SHL64m1_ND_SHL64m1_NF_ND_SHL64mi_ND_SHL64mi_NF_ND_SHL8m1_ND_SHL8m1_NF_ND_SHL8mi_ND_SHL8mi_NF_ND_SHR16m1_ND_SHR16m1_NF_ND_SHR16mi_ND_SHR16mi_NF_ND_SHR32m1_ND_SHR32m1_NF_ND_SHR32mi_ND_SHR32mi_NF_ND_SHR64m1_ND_SHR64m1_NF_ND_SHR64mi_ND_SHR64mi_NF_ND_SHR8m1_ND_SHR8m1_NF_ND_SHR8mi_ND_SHR8mi_NF_ND") 2, false, false, false, 563, 4, 33, 2,  0, 0}, // #609
  {DBGFIELD("SAR16mCL_SAR16mCL_EVEX_SAR16mCL_NF_SAR32mCL_SAR32mCL_EVEX_SAR32mCL_NF_SAR64mCL_SAR64mCL_EVEX_SAR64mCL_NF_SAR8mCL_SAR8mCL_EVEX_SAR8mCL_NF_SHL16mCL_SHL16mCL_EVEX_SHL16mCL_NF_SHL32mCL_SHL32mCL_EVEX_SHL32mCL_NF_SHL64mCL_SHL64mCL_EVEX_SHL64mCL_NF_SHL8mCL_SHL8mCL_EVEX_SHL8mCL_NF_SHR16mCL_SHR16mCL_EVEX_SHR16mCL_NF_SHR32mCL_SHR32mCL_EVEX_SHR32mCL_NF_SHR64mCL_SHR64mCL_EVEX_SHR64mCL_NF_SHR8mCL_SHR8mCL_EVEX_SHR8mCL_NF") 5, false, false, false, 575, 8, 33, 2,  0, 0}, // #610
  {DBGFIELD("SAR16mCL_ND_SAR16mCL_NF_ND_SAR32mCL_ND_SAR32mCL_NF_ND_SAR64mCL_ND_SAR64mCL_NF_ND_SAR8mCL_ND_SAR8mCL_NF_ND_SHL16mCL_ND_SHL16mCL_NF_ND_SHL32mCL_ND_SHL32mCL_NF_ND_SHL64mCL_ND_SHL64mCL_NF_ND_SHL8mCL_ND_SHL8mCL_NF_ND_SHR16mCL_ND_SHR16mCL_NF_ND_SHR32mCL_ND_SHR32mCL_NF_ND_SHR64mCL_ND_SHR64mCL_NF_ND_SHR8mCL_ND_SHR8mCL_NF_ND") 4, false, false, false, 583, 4, 35, 2,  0, 0}, // #611
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #612
  {DBGFIELD("FCOMPP")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #613
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false,  2, 8, 12, 1,  0, 0}, // #614
  {DBGFIELD("MMX_CVTPI2PSrr")     2, false, false, false, 203, 8,  6, 1,  0, 0}, // #615
  {DBGFIELD("MMX_CVTPI2PSrm")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #616
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 2, false, false, false, 269, 8, 22, 1,  0, 0}, // #617
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, false, 28, 2, 10, 1,  0, 0}, // #618
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH16i_PUSH32i_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #619
  {DBGFIELD("XCH_F")              15, false, false, false, 661, 13, 20, 1,  0, 0}, // #620
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 2, false, false, false, 22, 8,  3, 1,  0, 0}, // #621
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 2, false, false, false, 173, 10, 24, 1,  0, 0}, // #622
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, false, 279, 12,  9, 1,  0, 0}, // #623
  {DBGFIELD("CVTSI642SDrm")       2, false, false, false, 68, 6,  8, 1,  0, 0}, // #624
  {DBGFIELD("CVTSI642SDrm_Int")   2, false, false, false, 68, 6,  8, 1,  6, 1}, // #625
  {DBGFIELD("CVTSI642SSrr")       3, false, false, false, 674, 9,  7, 1,  0, 1}, // #626
  {DBGFIELD("CVTSI642SSrr_Int")   3, false, false, false, 674, 9,  7, 1,  7, 1}, // #627
  {DBGFIELD("CVTSI642SSrm")       3, false, false, false, 192, 11,  2, 1,  0, 0}, // #628
  {DBGFIELD("CVTSI642SSrm_Int")   3, false, false, false, 192, 11,  2, 1,  6, 1}, // #629
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 3, false, false, false, 683, 11,  7, 1,  0, 0}, // #630
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 3, false, false, false, 683, 11,  7, 1,  0, 0}, // #631
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 3, false, false, false, 203, 10,  2, 1,  0, 0}, // #632
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 2, false, false, false, 76, 2, 12, 1,  0, 0}, // #633
  {DBGFIELD("LFENCE")             1, false, false, false, 10, 4, 12, 1,  0, 0}, // #634
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #635
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, false, 77, 3,  3, 1,  0, 0}, // #636
  {DBGFIELD("POP16r")             2, false, false, false, 71, 3,  3, 1,  0, 0}, // #637
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 3, false, false, false, 18, 4,  1, 1,  0, 0}, // #638
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 4, false, false, false, 640, 3,  3, 1,  0, 0}, // #639
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false,  5, 2,  4, 1,  0, 0}, // #640
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 694, 4,  1, 1,  0, 0}, // #641
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false,  5, 2,  1, 1,  0, 0}, // #642
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 1, false, false, false,  4, 5,  1, 1,  0, 0}, // #643
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #644
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #645
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  2, false, false, false, 37, 3,  2, 1,  0, 0}, // #646
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false,  4, 3,  1, 1,  0, 0}, // #647
  {DBGFIELD("CLD")                2, false, false, false, 45, 4,  5, 1,  0, 0}, // #648
  {DBGFIELD("LDDQUrm")            1, false, false, false, 28, 2,  6, 1,  0, 0}, // #649
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 7, false, false, false, 698, 5,  6, 1,  0, 0}, // #650
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 3, false, false, false, 18, 4,  2, 1,  0, 0}, // #651
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 9, false, false, false, 703, 8, 49, 2,  0, 0}, // #652
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, false, 524, 5, 12, 1,  0, 0}, // #653
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 2, false, false, false, 115, 4,  3, 1,  0, 0}, // #654
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 2, false, false, false, 395, 7, 22, 1,  6, 1}, // #655
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 28, 2,  6, 1,  0, 0}, // #656
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 28, 2,  6, 1,  0, 0}, // #657
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, false, 69, 5,  7, 1,  6, 1}, // #658
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #659
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, false, 106, 4, 12, 1,  0, 0}, // #660
  {DBGFIELD("LD_F80m")            1, false, false, false, 26, 4,  6, 1,  0, 0}, // #661
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, false, 524, 7, 22, 1,  6, 1}, // #662
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, false, 269, 10, 14, 1,  0, 0}, // #663
  {DBGFIELD("FLDCW16m")           3, false, false, false, 711, 12,  6, 1,  0, 0}, // #664
  {DBGFIELD("ST_FP80m")           2, false, false, false, 694, 4,  1, 1,  0, 0}, // #665
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, false, 412, 8,  5, 1,  0, 0}, // #666
  {DBGFIELD("CMPXCHG8rm")         6, false, false, false, 14, 8, 24, 1,  0, 0}, // #667
  {DBGFIELD("INTO")               1, false, false, false,  5, 2,  4, 1,  0, 0}, // #668
  {DBGFIELD("XLAT")               3, false, false, false, 77, 3,  6, 1,  0, 0}, // #669
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 3, false, false, false, 342, 9, 10, 1,  0, 0}, // #670
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, false, 30, 7,  5, 1,  0, 0}, // #671
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 6, false, false, false, 594, 13,  2, 1,  0, 0}, // #672
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 5, false, false, false, 607, 11,  2, 1,  0, 0}, // #673
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 3, false, false, false, 723, 12, 14, 1,  0, 0}, // #674
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, false, 402, 10,  8, 1,  6, 1}, // #675
  {DBGFIELD("AAD8i8")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #676
  {DBGFIELD("LOOPE")              11, false, false, false, 735, 9,  5, 1,  0, 0}, // #677
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 694, 4,  1, 1,  0, 0}, // #678
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 3, false, false, false, 342, 9, 10, 1,  0, 0}, // #679
  {DBGFIELD("FNSTCW16m")          3, false, false, false, 744, 9, 12, 1,  0, 0}, // #680
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 26, 4, 10, 1,  0, 0}, // #681
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 694, 4,  1, 1,  0, 0}, // #682
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 6, false, false, false, 594, 13,  2, 1,  0, 0}, // #683
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 5, false, false, false, 607, 11,  2, 1,  0, 0}, // #684
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, false, 30, 7,  5, 1,  0, 0}, // #685
  {DBGFIELD("CMPXCHG8rr")         5, false, false, false, 169, 4,  5, 1,  0, 0}, // #686
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #687
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false,  5, 2,  4, 1,  0, 0}, // #688
  {DBGFIELD("AAA_AAS")            1, false, false, false,  5, 2,  4, 1,  0, 0}, // #689
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, false, 14, 8,  2, 1,  0, 0}, // #690
  {DBGFIELD("LOOPNE")             11, false, false, false, 735, 9, 12, 1,  0, 0}, // #691
  {DBGFIELD("PAUSE")              2, false, false, false, 753, 9, 14, 1,  0, 0}, // #692
  {DBGFIELD("CMPXCHG8B")          16, false, false, false, 762, 13, 46, 1,  0, 0}, // #693
  {DBGFIELD("DAA")                1, false, false, false,  5, 2,  4, 1,  0, 0}, // #694
  {DBGFIELD("LOOP")               7, false, false, false, 775, 9,  5, 1,  0, 0}, // #695
  {DBGFIELD("DAS")                1, false, false, false,  5, 2,  4, 1,  0, 0}, // #696
  {DBGFIELD("AAM8i8")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #697
  {DBGFIELD("STD")                2, false, false, false, 45, 4,  3, 1,  0, 0}, // #698
  {DBGFIELD("CMPXCHG16B")         22, false, false, false, 784, 15, 51, 1,  0, 0}, // #699
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false,  5, 2,  4, 1,  0, 0}, // #700
  {DBGFIELD("FNCLEX_FXTRACT")     4, false, false, false, 583, 2, 14, 1,  0, 0}, // #701
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 26, 4, 10, 1,  0, 0}, // #702
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false,  5, 2,  4, 1,  0, 0}, // #703
  {DBGFIELD("RDTSC_RDTSCP")       21, false, false, false, 799, 12, 52, 1,  0, 0}, // #704
  {DBGFIELD("ENTER")              57, false, false, false, 811, 16, 53, 1,  0, 0}, // #705
  {DBGFIELD("POPF16")             10, false, false, false, 827, 11, 10, 1,  0, 0}, // #706
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false,  5, 2,  4, 1,  0, 0}, // #707
  {DBGFIELD("FRNDINT")            1, false, false, false,  5, 2,  4, 1,  0, 0}, // #708
  {DBGFIELD("MWAITrr_RDPMC")      10, false, false, false, 838, 10, 15, 1,  0, 0}, // #709
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false,  5, 2,  4, 1,  0, 0}, // #710
  {DBGFIELD("FPREM")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #711
  {DBGFIELD("INSB_INSL_INSW")     86, false, false, false, 848, 16, 15, 1,  0, 0}, // #712
  {DBGFIELD("FNINIT")             15, false, false, false, 864, 8, 54, 1,  0, 0}, // #713
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 73, false, false, false, 872, 16, 55, 1,  0, 0}, // #714
  {DBGFIELD("FPREM1")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #715
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false,  5, 2,  4, 1,  0, 0}, // #716
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 73, false, false, false, 888, 16, 55, 1,  0, 0}, // #717
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  83, false, false, false, 904, 16,  4, 1,  0, 0}, // #718
  {DBGFIELD("FSCALE")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #719
  {DBGFIELD("RDMSR")              54, false, false, false, 920, 11,  4, 1,  0, 0}, // #720
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 2, false, false, false, 22, 8,  3, 1,  0, 0}, // #721
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 87, false, false, false, 931, 14, 55, 1,  0, 0}, // #722
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 86, false, false, false, 945, 14, 55, 1,  0, 0}, // #723
  {DBGFIELD("F2XM1")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #724
  {DBGFIELD("CPUID")              26, false, false, false, 959, 15, 13, 1,  0, 0}, // #725
  {DBGFIELD("INT")                1, false, false, false,  5, 2,  4, 1,  0, 0}, // #726
  {DBGFIELD("INT3")               1, false, false, false,  5, 2,  4, 1,  0, 0}, // #727
  {DBGFIELD("FXSAVE_FXSAVE64")    110, false, false, false, 974, 16,  4, 1,  0, 0}, // #728
  {DBGFIELD("FXRSTOR_FXRSTOR64")  90, false, false, false, 990, 15, 56, 1,  0, 0}, // #729
  {DBGFIELD("FYL2X")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #730
  {DBGFIELD("FYL2XP1")            1, false, false, false,  5, 2,  4, 1,  0, 0}, // #731
  {DBGFIELD("FPTAN")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #732
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false,  5, 2,  4, 1,  0, 0}, // #733
  {DBGFIELD("FPATAN")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #734
  {DBGFIELD("WRMSR")              144, false, false, false, 1005, 15,  4, 1,  0, 0}, // #735
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #736
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, false, 60, 8,  1, 1,  0, 0}, // #737
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 2, false, false, false, 299, 5, 12, 1,  0, 0}, // #738
  {DBGFIELD("FNOP")               1, false, false, false,  4, 5,  1, 1,  0, 0}, // #739
  {DBGFIELD("RET64")              2, false, false, false, 163, 6,  6, 1,  0, 0}, // #740
  {DBGFIELD("CDQ_CQO")            1, false, false, false, 10, 4,  1, 1,  0, 0}, // #741
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #742
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false,  4, 5,  1, 1,  0, 0}, // #743
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 60, 8,  1, 1,  0, 0}, // #744
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 4, false, false, false, 640, 3,  3, 1,  0, 0}, // #745
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, false,  2, 8,  5, 1,  0, 0}, // #746
  {DBGFIELD("CWD")                2, false, false, false, 45, 4, 12, 1,  0, 0}, // #747
  {DBGFIELD("FNSTSW16r")          2, false, false, false, 1020, 8,  5, 1,  0, 0}, // #748
  {DBGFIELD("MMX_MOVDQ2Qrr")      2, false, false, false, 184, 5,  5, 1,  0, 0}, // #749
  {DBGFIELD("PUSHFS64")           3, false, false, false, 30, 10,  1, 1,  0, 0}, // #750
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, false, 441, 11, 14, 1,  0, 0}, // #751
  {DBGFIELD("RCL8r1_RCL16r1_RCL32r1_RCL64r1_RCR8r1_RCR16r1_RCR32r1_RCR64r1") 3, false, false, false, 14, 4, 12, 1,  0, 0}, // #752
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 3, false, false, false, 14, 4, 12, 1,  0, 0}, // #753
  {DBGFIELD("RCL8ri_RCL16ri_RCL32ri_RCL64ri") 3, false, false, false, 14, 4, 12, 1,  0, 0}, // #754
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #755
  {DBGFIELD("MOV64sr")            1, false, false, false,  5, 2,  1, 1,  0, 0}, // #756
  {DBGFIELD("RCL16rCL_RCL16rCL_EVEX_RCL16rCL_ND_RCL32rCL_RCL32rCL_EVEX_RCL32rCL_ND_RCL64rCL_RCL64rCL_EVEX_RCL64rCL_ND_RCL8rCL_RCL8rCL_EVEX_RCL8rCL_ND_RCR16rCL_RCR16rCL_EVEX_RCR16rCL_ND_RCR32rCL_RCR32rCL_EVEX_RCR32rCL_ND_RCR64rCL_RCR64rCL_EVEX_RCR64rCL_ND_RCR8rCL_RCR8rCL_EVEX_RCR8rCL_ND") 2, false, false, false, 563, 4, 12, 1,  0, 0}, // #757
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #758
  {DBGFIELD("CLI")                3, false, false, false, 1028, 9,  4, 1,  0, 0}, // #759
  {DBGFIELD("PUSHGS64")           3, false, false, false, 30, 10,  1, 1,  0, 0}, // #760
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 3, false, false, false, 723, 12, 14, 1,  0, 0}, // #761
  {DBGFIELD("CALL64pcrel32")      2, false, false, false, 37, 3,  5, 1,  0, 0}, // #762
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #763
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 3, false, false, false, 1037, 11,  2, 1,  0, 0}, // #764
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 4, false, false, false, 1048, 4,  6, 1,  0, 0}, // #765
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 3, false, false, false, 261, 8,  2, 1,  0, 0}, // #766
  {DBGFIELD("PUSHF16_PUSHF64")    4, false, false, false, 1052, 12, 14, 1,  0, 0}, // #767
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 3, false, false, false, 646, 4, 12, 1,  0, 0}, // #768
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 28, 2,  6, 1,  0, 0}, // #769
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #770
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #771
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #772
  {DBGFIELD("MOV16sm")            1, false, false, false,  5, 2,  1, 1,  0, 0}, // #773
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 2, false, false, false, 173, 10, 22, 1,  0, 0}, // #774
  {DBGFIELD("MMX_PALIGNRrmi")     2, false, false, false, 375, 10, 22, 1,  6, 1}, // #775
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 2, false, false, false, 173, 10, 22, 1,  6, 1}, // #776
  {DBGFIELD("LODSL_LODSQ")        3, false, false, false, 77, 3, 10, 1,  0, 0}, // #777
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #778
  {DBGFIELD("VINSERTF128rm")      2, false, false, false, 69, 5, 22, 1,  6, 1}, // #779
  {DBGFIELD("MMX_PADDQrm")        2, false, false, false, 395, 7, 22, 1,  6, 1}, // #780
  {DBGFIELD("VERRm_VERWm")        34, false, false, false, 1064, 13, 57, 1,  0, 0}, // #781
  {DBGFIELD("FARJMP64m")          2, false, false, false, 1077, 9,  3, 1,  0, 0}, // #782
  {DBGFIELD("FNSTSWm")            3, false, false, false, 1086, 12,  5, 1,  0, 0}, // #783
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 2, false, false, false, 333, 7,  3, 1,  0, 0}, // #784
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #785
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 5, false, false, false, 45, 8,  6, 1,  0, 0}, // #786
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, false, 173, 10,  7, 1,  6, 1}, // #787
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 7, false, false, false, 1098, 3,  3, 1,  0, 0}, // #788
  {DBGFIELD("ROL16m1_ROL16m1_EVEX_ROL16m1_NF_ROL16mi_ROL16mi_EVEX_ROL16mi_NF_ROL32m1_ROL32m1_EVEX_ROL32m1_NF_ROL32mi_ROL32mi_EVEX_ROL32mi_NF_ROL64m1_ROL64m1_EVEX_ROL64m1_NF_ROL64mi_ROL64mi_EVEX_ROL64mi_NF_ROL8m1_ROL8m1_EVEX_ROL8m1_NF_ROL8mi_ROL8mi_EVEX_ROL8mi_NF_ROR16m1_ROR16m1_EVEX_ROR16m1_NF_ROR16mi_ROR16mi_EVEX_ROR16mi_NF_ROR32m1_ROR32m1_EVEX_ROR32m1_NF_ROR32mi_ROR32mi_EVEX_ROR32mi_NF_ROR64m1_ROR64m1_EVEX_ROR64m1_NF_ROR64mi_ROR64mi_EVEX_ROR64mi_NF_ROR8m1_ROR8m1_EVEX_ROR8m1_NF_ROR8mi_ROR8mi_EVEX_ROR8mi_NF") 6, false, false, false, 14, 8, 33, 2,  0, 0}, // #789
  {DBGFIELD("ROL16m1_ND_ROL16m1_NF_ND_ROL16mi_ND_ROL16mi_NF_ND_ROL32m1_ND_ROL32m1_NF_ND_ROL32mi_ND_ROL32mi_NF_ND_ROL64m1_ND_ROL64m1_NF_ND_ROL64mi_ND_ROL64mi_NF_ND_ROL8m1_ND_ROL8m1_NF_ND_ROL8mi_ND_ROL8mi_NF_ND_ROR16m1_ND_ROR16m1_NF_ND_ROR16mi_ND_ROR16mi_NF_ND_ROR32m1_ND_ROR32m1_NF_ND_ROR32mi_ND_ROR32mi_NF_ND_ROR64m1_ND_ROR64m1_NF_ND_ROR64mi_ND_ROR64mi_NF_ND_ROR8m1_ND_ROR8m1_NF_ND_ROR8mi_ND_ROR8mi_NF_ND") 6, false, false, false, 537, 4, 35, 2,  0, 0}, // #790
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 5, false, false, false, 1101, 5, 58, 2,  0, 0}, // #791
  {DBGFIELD("FARCALL64m")         5, false, false, false, 1106, 11,  6, 1,  0, 0}, // #792
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 26, 4,  6, 1,  0, 0}, // #793
  {DBGFIELD("ROL16mCL_ROL16mCL_EVEX_ROL16mCL_NF_ROL32mCL_ROL32mCL_EVEX_ROL32mCL_NF_ROL64mCL_ROL64mCL_EVEX_ROL64mCL_NF_ROL8mCL_ROL8mCL_EVEX_ROL8mCL_NF_ROR16mCL_ROR16mCL_EVEX_ROR16mCL_NF_ROR32mCL_ROR32mCL_EVEX_ROR32mCL_NF_ROR64mCL_ROR64mCL_EVEX_ROR64mCL_NF_ROR8mCL_ROR8mCL_EVEX_ROR8mCL_NF") 10, false, false, false, 541, 13, 37, 2,  0, 0}, // #794
  {DBGFIELD("ROL16mCL_ND_ROL16mCL_NF_ND_ROL32mCL_ND_ROL32mCL_NF_ND_ROL64mCL_ND_ROL64mCL_NF_ND_ROL8mCL_ND_ROL8mCL_NF_ND_ROR16mCL_ND_ROR16mCL_NF_ND_ROR32mCL_ND_ROR32mCL_NF_ND_ROR64mCL_ND_ROR64mCL_NF_ND_ROR8mCL_ND_ROR8mCL_NF_ND") 9, false, false, false, 554, 9, 39, 2,  0, 0}, // #795
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 6, false, false, false, 1117, 8,  2, 1, 12, 2}, // #796
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 2, false, false, false, 279, 12,  9, 1,  0, 0}, // #797
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 2, false, false, false, 375, 10,  9, 1,  6, 1}, // #798
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 3, false, false, false, 1125, 12,  8, 1,  0, 0}, // #799
  {DBGFIELD("MUL_F32m_MUL_F64m")  2, false, false, false, 1137, 12,  8, 1,  0, 0}, // #800
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 3, false, false, false, 1125, 12, 24, 1,  0, 0}, // #801
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 3, false, false, false, 1149, 15, 21, 1,  0, 0}, // #802
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 2, false, false, false, 1137, 12, 19, 1,  0, 0}, // #803
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 3, false, false, false, 1149, 15, 46, 1,  0, 0}, // #804
  {DBGFIELD("VZEROALL")           10, false, false, false, 1164, 9, 16, 1,  0, 0}, // #805
  {DBGFIELD("VZEROUPPER")         0, false, false, false,  0, 0,  0, 1,  0, 0}, // #806
  {DBGFIELD("CLC")                0, false, false, false,  0, 0,  1, 1,  0, 0}, // #807
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #808
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #809
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #810
  {DBGFIELD("PXORrr_VPXORrr")     1, false, false, false,  4, 3,  1, 1,  0, 0}, // #811
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #812
  {DBGFIELD("PSUBQrr")            1, false, false, false,  4, 3,  1, 1,  0, 0}, // #813
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #814
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #815
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 2, false, false, false, 163, 6,  6, 1,  1, 1}, // #816
  {DBGFIELD("SETCCr")             2, false, false, false, 563, 4, 12, 1,  0, 0}, // #817
  {DBGFIELD("SETCCm")             4, false, false, false, 587, 7, 24, 1,  0, 0}, // #818
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, false, 375, 10,  7, 1,  6, 1}, // #819
  {DBGFIELD("RETI16_RETI32_RETI64") 3, false, false, false, 1173, 6,  3, 1,  0, 0}, // #820
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 2, false, false, false, 22, 8,  3, 1,  0, 0}, // #821
  {DBGFIELD("RDPMC")              18, false, false, false, 1179, 11,  4, 1,  0, 0}, // #822
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 25, false, false, false, 1190, 14,  4, 1,  0, 0}, // #823
  {DBGFIELD("FBLDm")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #824
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false,  5, 2,  4, 1,  0, 0}, // #825
  {DBGFIELD("FSAVEm")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #826
  {DBGFIELD("FRSTORm")            1, false, false, false,  5, 2,  4, 1,  0, 0}, // #827
  {DBGFIELD("FXTRACT")            1, false, false, false,  5, 2,  4, 1,  0, 0}, // #828
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #829
  {DBGFIELD("VBROADCASTF128rm_VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #830
  {DBGFIELD("VBROADCASTI128rm")   1, false, false, false, 28, 2,  7, 1,  0, 0}, // #831
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #832
  {DBGFIELD("FBSTPm")             2, false, false, false, 694, 4,  1, 1,  0, 0}, // #833
  {DBGFIELD("VMPTRSTm")           2, false, false, false, 694, 4,  1, 1,  0, 0}, // #834
  {DBGFIELD("ST_FP32m_ST_FP64m")  2, false, false, false, 694, 4,  1, 1,  0, 0}, // #835
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #836
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #837
  {DBGFIELD("MMX_MOVQ2DQrr")      2, false, false, false, 269, 8,  5, 1,  0, 0}, // #838
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #839
  {DBGFIELD("FINCSTP")            1, false, false, false,  4, 5,  1, 1,  0, 0}, // #840
  {DBGFIELD("ANDN32rr_ANDN32rr_EVEX_ANDN64rr_ANDN64rr_EVEX") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #841
  {DBGFIELD("VPBLENDDYrri")       1, false, false, false,  4, 3,  1, 1,  0, 0}, // #842
  {DBGFIELD("VPBLENDDrri")        1, false, false, false,  4, 3,  1, 1,  0, 0}, // #843
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 7, false, false, false, 1204, 10, 23, 1,  0, 0}, // #844
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 2, false, false, false, 68, 6,  7, 1,  6, 1}, // #845
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 2, false, false, false, 68, 6, 22, 1,  6, 1}, // #846
  {DBGFIELD("PDEP32rm_PDEP32rm_EVEX_PDEP64rm_PDEP64rm_EVEX_PEXT32rm_PEXT32rm_EVEX_PEXT64rm_PEXT64rm_EVEX") 1, false, false, false,  1, 1,  8, 1,  1, 1}, // #847
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #848
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #849
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 2, false, false, false, 1077, 9,  3, 1,  0, 0}, // #850
  {DBGFIELD("ANDN32rm_ANDN32rm_EVEX_ANDN64rm_ANDN64rm_EVEX") 1, false, false, false,  1, 1,  8, 1,  1, 1}, // #851
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 3, false, false, false, 104, 11,  6, 1,  0, 0}, // #852
  {DBGFIELD("VINSERTI128rm")      2, false, false, false, 69, 5, 22, 1,  6, 1}, // #853
  {DBGFIELD("VPBLENDDrmi")        2, false, false, false, 69, 5,  7, 1,  6, 1}, // #854
  {DBGFIELD("VPBLENDDYrmi")       2, false, false, false, 69, 5, 22, 1,  6, 1}, // #855
  {DBGFIELD("POP32r_POP64r")      1, false, false, false, 28, 2, 10, 1,  0, 0}, // #856
  {DBGFIELD("SFENCE")             2, false, false, false, 37, 3, 12, 1,  0, 0}, // #857
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 4, false, false, false, 1052, 12,  2, 1,  0, 0}, // #858
  {DBGFIELD("MOVBE16mr")          3, false, false, false, 1214, 7,  2, 1,  0, 0}, // #859
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #860
  {DBGFIELD("MFENCE")             2, false, false, false, 37, 3,  5, 1,  0, 0}, // #861
  {DBGFIELD("XGETBV")             23, false, false, false, 1221, 9, 14, 1,  0, 0}, // #862
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 3, false, false, false, 1230, 10,  2, 1,  6, 1}, // #863
  {DBGFIELD("LRET64_RET32")       2, false, false, false, 163, 6,  3, 1,  0, 0}, // #864
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 2, false, false, false, 563, 4,  1, 1,  0, 0}, // #865
  {DBGFIELD("PDEP32rr_PDEP32rr_EVEX_PDEP64rr_PDEP64rr_EVEX_PEXT32rr_PEXT32rr_EVEX_PEXT64rr_PEXT64rr_EVEX") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #866
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #867
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #868
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 2, false, false, false, 1240, 8, 14, 1,  0, 0}, // #869
  {DBGFIELD("CLDEMOTE")           3, false, false, false, 646, 4,  5, 1,  0, 0}, // #870
  {DBGFIELD("MMX_CVTPI2PDrm")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #871
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 2, false, false, false, 375, 10, 22, 1,  0, 0}, // #872
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 22, false, false, false, 1248, 14, 60, 1,  0, 0}, // #873
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 13, false, false, false, 1262, 14, 61, 1,  0, 0}, // #874
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false,  2, 8, 14, 1,  0, 0}, // #875
  {DBGFIELD("VPCMPGTQYrm")        2, false, false, false, 375, 10,  8, 1,  6, 1}, // #876
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, false, 674, 9,  7, 1,  7, 1}, // #877
  {DBGFIELD("STR16r_STR32r_STR64r") 2, false, false, false, 333, 7, 10, 1,  0, 0}, // #878
  {DBGFIELD("XSETBV")             54, false, false, false, 1276, 11, 10, 1,  0, 0}, // #879
  {DBGFIELD("RCL16mCL_RCL16mCL_EVEX_RCL32mCL_RCL32mCL_EVEX_RCL64mCL_RCL64mCL_EVEX_RCL8mCL_RCL8mCL_EVEX") 10, false, false, false, 541, 13, 37, 2,  0, 0}, // #880
  {DBGFIELD("RCL16mCL_ND_RCL32mCL_ND_RCL64mCL_ND_RCL8mCL_ND") 9, false, false, false, 554, 9, 39, 2,  0, 0}, // #881
  {DBGFIELD("RCL16rCL_RCL16rCL_EVEX_RCL16rCL_ND_RCL32rCL_RCL32rCL_EVEX_RCL32rCL_ND_RCL64rCL_RCL64rCL_EVEX_RCL64rCL_ND_RCR16rCL_RCR16rCL_EVEX_RCR16rCL_ND_RCR32rCL_RCR32rCL_EVEX_RCR32rCL_ND_RCR64rCL_RCR64rCL_EVEX_RCR64rCL_ND") 2, false, false, false, 563, 4, 12, 1,  0, 0}, // #882
  {DBGFIELD("RCL8rCL")            9, false, false, false, 554, 9,  6, 1,  0, 0}, // #883
  {DBGFIELD("RCR8rCL")            10, false, false, false, 1287, 9, 22, 1,  0, 0}, // #884
  {DBGFIELD("RDTSC")              15, false, false, false, 1296, 11, 13, 1,  0, 0}, // #885
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 31, false, false, false, 1307, 14, 62, 1,  0, 0}, // #886
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, false,  2, 8, 15, 1,  0, 0}, // #887
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 2, false, false, false, 1137, 12, 63, 1,  0, 0}, // #888
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 3, false, false, false, 1149, 15, 64, 1,  0, 0}, // #889
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, false,  2, 8, 11, 1,  0, 0}, // #890
  {DBGFIELD("XSAVE64")            140, false, false, false, 1321, 15, 65, 1,  0, 0}, // #891
  {DBGFIELD("XSAVE")              140, false, false, false, 1321, 15, 52, 1,  0, 0}, // #892
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 156, false, false, false, 1336, 15, 66, 1,  0, 0}, // #893
  {DBGFIELD("VMCLEARm")           18, false, false, false, 1351, 18, 67, 1,  0, 0}, // #894
  {DBGFIELD("FLDENVm")            64, false, false, false, 1369, 12, 68, 1,  0, 0}, // #895
  {DBGFIELD("FXRSTOR64")          88, false, false, false, 1381, 15, 56, 1,  0, 0}, // #896
  {DBGFIELD("FSTENVm")            100, false, false, false, 1396, 17, 69, 1,  0, 0}, // #897
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 5, false, false, false, 1413, 12, 70, 2,  0, 0}, // #898
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 8, false, false, false, 1425, 12, 72, 2,  0, 0}, // #899
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 8, false, false, false, 1425, 12, 74, 2,  0, 0}, // #900
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 12, false, false, false, 1437, 12, 76, 2,  0, 0}, // #901
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 5, false, false, false, 1413, 12, 70, 2,  0, 0}, // #902
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 8, false, false, false, 1425, 12, 72, 2,  0, 0}, // #903
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 5, false, false, false, 1413, 12, 70, 2,  0, 0}, // #904
  {DBGFIELD("VPXORYrr")           1, false, false, false,  4, 3,  1, 1,  0, 0}, // #905
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #906
  {DBGFIELD("VPCMPGTQYrr")        1, false, false, false, 60, 8,  5, 1,  0, 0}, // #907
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #908
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #909
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 2, false, false, false, 279, 12,  7, 1,  0, 0}, // #910
  {DBGFIELD("LRET64")             3, false, false, false, 1449, 9,  6, 1,  0, 0}, // #911
  {DBGFIELD("POPF64")             7, false, false, false, 1458, 11, 10, 1,  0, 0}, // #912
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 8, false, false, false, 1425, 12, 72, 2,  0, 0}, // #913
  {DBGFIELD("PCMPEQQrr")          1, false, false, false,  3, 4,  1, 1,  0, 0}, // #914
  {DBGFIELD("PCMPGTQrr")          1, false, false, false, 60, 8,  5, 1,  0, 0}, // #915
  {DBGFIELD("PCMPEQQrm")          2, false, false, false, 68, 6,  7, 1,  6, 1}, // #916
  {DBGFIELD("PCMPGTQrm")          2, false, false, false, 375, 10,  9, 1,  6, 1}, // #917
  {DBGFIELD("MOV16rm")            2, false, false, false, 71, 3,  3, 1,  0, 0}, // #918
  {DBGFIELD("POP16rmm")           3, false, false, false, 18, 4,  2, 1,  0, 0}, // #919
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 3, false, false, false, 18, 4,  2, 1,  0, 0}, // #920
  {DBGFIELD("PUSHF16")            4, false, false, false, 1052, 12,  2, 1,  0, 0}, // #921
  {DBGFIELD("LAHF")               1, false, false, false, 10, 4,  5, 1,  0, 0}, // #922
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mi8_EVEX_ADD16mi8_NF_ADD16mi_EVEX_ADD16mi_NF_ADD32mi_ADD32mi8_ADD32mi8_EVEX_ADD32mi8_NF_ADD32mi_EVEX_ADD32mi_NF_ADD64mi32_ADD64mi32_EVEX_ADD64mi32_NF_ADD64mi8_ADD64mi8_EVEX_ADD64mi8_NF_ADD8mi_ADD8mi8_ADD8mi_EVEX_ADD8mi_NF_SUB16mi_SUB16mi8_SUB16mi8_EVEX_SUB16mi8_NF_SUB16mi_EVEX_SUB16mi_NF_SUB32mi_SUB32mi8_SUB32mi8_EVEX_SUB32mi8_NF_SUB32mi_EVEX_SUB32mi_NF_SUB64mi32_SUB64mi32_EVEX_SUB64mi32_NF_SUB64mi8_SUB64mi8_EVEX_SUB64mi8_NF_SUB8mi_SUB8mi8_SUB8mi_EVEX_SUB8mi_NF") 4, false, false, false, 40, 5,  2, 1,  0, 0}, // #923
  {DBGFIELD("ADD16mi8_ND_ADD16mi8_NF_ND_ADD16mi_ND_ADD16mi_NF_ND_ADD16mr_ND_ADD16mr_NF_ND_ADD32mi8_ND_ADD32mi8_NF_ND_ADD32mi_ND_ADD32mi_NF_ND_ADD32mr_ND_ADD32mr_NF_ND_ADD64mi32_ND_ADD64mi32_NF_ND_ADD64mi8_ND_ADD64mi8_NF_ND_ADD64mr_ND_ADD64mr_NF_ND_ADD8mi_ND_ADD8mi_NF_ND_ADD8mr_ND_ADD8mr_NF_ND_SUB16mi8_ND_SUB16mi8_NF_ND_SUB16mi_ND_SUB16mi_NF_ND_SUB16mr_ND_SUB16mr_NF_ND_SUB32mi8_ND_SUB32mi8_NF_ND_SUB32mi_ND_SUB32mi_NF_ND_SUB32mr_ND_SUB32mr_NF_ND_SUB64mi32_ND_SUB64mi32_NF_ND_SUB64mi8_ND_SUB64mi8_NF_ND_SUB64mr_ND_SUB64mr_NF_ND_SUB8mi_ND_SUB8mi_NF_ND_SUB8mr_ND_SUB8mr_NF_ND") 1, false, false, false,  1, 1,  8, 1,  1, 1}, // #924
  {DBGFIELD("ADD16mr_ADD16mr_EVEX_ADD32mr_ADD32mr_EVEX_ADD64mr_ADD64mr_EVEX_ADD8mr_ADD8mr_EVEX_SUB16mr_SUB16mr_EVEX_SUB32mr_SUB32mr_EVEX_SUB64mr_SUB64mr_EVEX_SUB8mr_SUB8mr_EVEX") 4, false, false, false, 40, 5,  2, 1,  2, 1}, // #925
  {DBGFIELD("ADD16mr_NF_ADD32mr_NF_ADD64mr_NF_ADD8mr_NF_SUB16mr_NF_SUB32mr_NF_SUB64mr_NF_SUB8mr_NF") 4, false, false, false, 40, 5,  2, 1,  0, 0}, // #926
  {DBGFIELD("ADC16mi_ADC16mi8_ADC16mi8_EVEX_ADC16mi_EVEX_ADC32mi_ADC32mi8_ADC32mi8_EVEX_ADC32mi_EVEX_ADC64mi32_ADC64mi32_EVEX_ADC64mi8_ADC64mi8_EVEX_ADC8mi_ADC8mi8_ADC8mi_EVEX_SBB16mi_SBB16mi8_SBB16mi8_EVEX_SBB16mi_EVEX_SBB32mi_SBB32mi8_SBB32mi8_EVEX_SBB32mi_EVEX_SBB64mi32_SBB64mi32_EVEX_SBB64mi8_SBB64mi8_EVEX_SBB8mi_SBB8mi8_SBB8mi_EVEX") 5, false, false, false, 45, 8,  2, 1,  0, 0}, // #927
  {DBGFIELD("ADC16mi8_ND_ADC16mi_ND_ADC16mr_ND_ADC32mi8_ND_ADC32mi_ND_ADC32mr_ND_ADC64mi32_ND_ADC64mi8_ND_ADC64mr_ND_ADC8mi_ND_ADC8mr_ND_SBB16mi8_ND_SBB16mi_ND_SBB16mr_ND_SBB32mi8_ND_SBB32mi_ND_SBB32mr_ND_SBB64mi32_ND_SBB64mi8_ND_SBB64mr_ND_SBB8mi_ND_SBB8mr_ND") 2, false, false, false, 45, 4,  8, 1,  1, 1}, // #928
  {DBGFIELD("ADC16mr_EVEX_ADC32mr_EVEX_ADC64mr_EVEX_ADC8mr_EVEX_SBB16mr_EVEX_SBB32mr_EVEX_SBB64mr_EVEX_SBB8mr_EVEX") 5, false, false, false, 45, 8,  2, 1,  2, 2}, // #929
  {DBGFIELD("DEC16m_DEC16m_EVEX_DEC16m_NF_DEC32m_DEC32m_EVEX_DEC32m_NF_DEC64m_DEC64m_EVEX_DEC64m_NF_DEC8m_DEC8m_EVEX_DEC8m_NF_INC16m_INC16m_EVEX_INC16m_NF_INC32m_INC32m_EVEX_INC32m_NF_INC64m_INC64m_EVEX_INC64m_NF_INC8m_INC8m_EVEX_INC8m_NF_NEG16m_NEG16m_EVEX_NEG16m_NF_NEG32m_NEG32m_EVEX_NEG32m_NF_NEG64m_NEG64m_EVEX_NEG64m_NF_NEG8m_NEG8m_EVEX_NEG8m_NF_NOT16m_NOT16m_EVEX_NOT32m_NOT32m_EVEX_NOT64m_NOT64m_EVEX_NOT8m_NOT8m_EVEX") 4, false, false, false, 40, 5,  2, 1,  0, 0}, // #930
  {DBGFIELD("DEC16m_ND_DEC16m_NF_ND_DEC32m_ND_DEC32m_NF_ND_DEC64m_ND_DEC64m_NF_ND_DEC8m_ND_DEC8m_NF_ND_INC16m_ND_INC16m_NF_ND_INC32m_ND_INC32m_NF_ND_INC64m_ND_INC64m_NF_ND_INC8m_ND_INC8m_NF_ND_NEG16m_ND_NEG16m_NF_ND_NEG32m_ND_NEG32m_NF_ND_NEG64m_ND_NEG64m_NF_ND_NEG8m_ND_NEG8m_NF_ND_NOT16m_ND_NOT32m_ND_NOT64m_ND_NOT8m_ND") 1, false, false, false,  1, 1,  8, 1,  1, 1}, // #931
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 3, false, false, false, 1214, 7,  5, 1,  0, 0}, // #932
  {DBGFIELD("RET16_LRET16_LRET32") 2, false, false, false, 22, 8,  3, 1,  0, 0}, // #933
  {DBGFIELD("IRET16_IRET32_IRET64") 2, false, false, false, 22, 8,  3, 1,  0, 0}, // #934
  {DBGFIELD("AND16mi_AND16mi8_AND16mi8_EVEX_AND16mi8_NF_AND16mi_EVEX_AND16mi_NF_AND32mi_AND32mi8_AND32mi8_EVEX_AND32mi8_NF_AND32mi_EVEX_AND32mi_NF_AND64mi32_AND64mi32_EVEX_AND64mi32_NF_AND64mi8_AND64mi8_EVEX_AND64mi8_NF_AND8mi_AND8mi8_AND8mi_EVEX_AND8mi_NF_OR16mi_OR16mi8_OR16mi8_EVEX_OR16mi8_NF_OR16mi_EVEX_OR16mi_NF_OR32mi_OR32mi8_OR32mi8Locked_OR32mi8_EVEX_OR32mi8_NF_OR32mi_EVEX_OR32mi_NF_OR64mi32_OR64mi32_EVEX_OR64mi32_NF_OR64mi8_OR64mi8_EVEX_OR64mi8_NF_OR8mi_OR8mi8_OR8mi_EVEX_OR8mi_NF_XOR16mi_XOR16mi8_XOR16mi8_EVEX_XOR16mi8_NF_XOR16mi_EVEX_XOR16mi_NF_XOR32mi_XOR32mi8_XOR32mi8_EVEX_XOR32mi8_NF_XOR32mi_EVEX_XOR32mi_NF_XOR64mi32_XOR64mi32_EVEX_XOR64mi32_NF_XOR64mi8_XOR64mi8_EVEX_XOR64mi8_NF_XOR8mi_XOR8mi8_XOR8mi_EVEX_XOR8mi_NF") 4, false, false, false, 40, 5,  2, 1,  0, 0}, // #935
  {DBGFIELD("AND16mi8_ND_AND16mi8_NF_ND_AND16mi_ND_AND16mi_NF_ND_AND16mr_ND_AND16mr_NF_ND_AND32mi8_ND_AND32mi8_NF_ND_AND32mi_ND_AND32mi_NF_ND_AND32mr_ND_AND32mr_NF_ND_AND64mi32_ND_AND64mi32_NF_ND_AND64mi8_ND_AND64mi8_NF_ND_AND64mr_ND_AND64mr_NF_ND_AND8mi_ND_AND8mi_NF_ND_AND8mr_ND_AND8mr_NF_ND_OR16mi8_ND_OR16mi8_NF_ND_OR16mi_ND_OR16mi_NF_ND_OR16mr_ND_OR16mr_NF_ND_OR32mi8_ND_OR32mi8_NF_ND_OR32mi_ND_OR32mi_NF_ND_OR32mr_ND_OR32mr_NF_ND_OR64mi32_ND_OR64mi32_NF_ND_OR64mi8_ND_OR64mi8_NF_ND_OR64mr_ND_OR64mr_NF_ND_OR8mi_ND_OR8mi_NF_ND_OR8mr_ND_OR8mr_NF_ND_XOR16mi8_ND_XOR16mi8_NF_ND_XOR16mi_ND_XOR16mi_NF_ND_XOR16mr_ND_XOR16mr_NF_ND_XOR32mi8_ND_XOR32mi8_NF_ND_XOR32mi_ND_XOR32mi_NF_ND_XOR32mr_ND_XOR32mr_NF_ND_XOR64mi32_ND_XOR64mi32_NF_ND_XOR64mi8_ND_XOR64mi8_NF_ND_XOR64mr_ND_XOR64mr_NF_ND_XOR8mi_ND_XOR8mi_NF_ND_XOR8mr_ND_XOR8mr_NF_ND") 1, false, false, false,  1, 1,  8, 1,  1, 1}, // #936
  {DBGFIELD("AND16mr_AND16mr_EVEX_AND32mr_AND32mr_EVEX_AND64mr_AND64mr_EVEX_AND8mr_AND8mr_EVEX_OR16mr_OR16mr_EVEX_OR32mr_OR32mr_EVEX_OR64mr_OR64mr_EVEX_OR8mr_OR8mr_EVEX_XOR16mr_XOR16mr_EVEX_XOR32mr_XOR32mr_EVEX_XOR64mr_XOR64mr_EVEX_XOR8mr_XOR8mr_EVEX") 4, false, false, false, 40, 5,  2, 1,  2, 1}, // #937
  {DBGFIELD("AND16mr_NF_AND32mr_NF_AND64mr_NF_AND8mr_NF_OR16mr_NF_OR32mr_NF_OR64mr_NF_OR8mr_NF_XOR16mr_NF_XOR32mr_NF_XOR64mr_NF_XOR8mr_NF") 4, false, false, false, 40, 5,  2, 1,  0, 0}, // #938
  {DBGFIELD("SHLD16mri8_EVEX_SHLD16mri8_ND_SHLD16mri8_NF_SHLD16mri8_NF_ND_SHLD32mri8_SHLD32mri8_EVEX_SHLD32mri8_ND_SHLD32mri8_NF_SHLD32mri8_NF_ND_SHLD64mri8_EVEX_SHLD64mri8_ND_SHLD64mri8_NF_SHLD64mri8_NF_ND_SHRD16mri8_EVEX_SHRD16mri8_ND_SHRD16mri8_NF_SHRD16mri8_NF_ND_SHRD32mri8_SHRD32mri8_EVEX_SHRD32mri8_ND_SHRD32mri8_NF_SHRD32mri8_NF_ND_SHRD64mri8_EVEX_SHRD64mri8_ND_SHRD64mri8_NF_SHRD64mri8_NF_ND") 5, false, false, false, 607, 11,  2, 1,  0, 0}, // #939
  {DBGFIELD("SHLD16rrCL_EVEX_SHLD16rrCL_ND_SHLD16rrCL_NF_SHLD16rrCL_NF_ND_SHLD32rrCL_SHLD32rrCL_EVEX_SHLD32rrCL_ND_SHLD32rrCL_NF_SHLD32rrCL_NF_ND_SHLD64rrCL_EVEX_SHLD64rrCL_ND_SHLD64rrCL_NF_SHLD64rrCL_NF_ND_SHRD16rrCL_EVEX_SHRD16rrCL_ND_SHRD16rrCL_NF_SHRD16rrCL_NF_ND_SHRD32rrCL_SHRD32rrCL_EVEX_SHRD32rrCL_ND_SHRD32rrCL_NF_SHRD32rrCL_NF_ND_SHRD64rrCL_EVEX_SHRD64rrCL_ND_SHRD64rrCL_NF_SHRD64rrCL_NF_ND") 3, false, false, false, 342, 9, 10, 1,  0, 0}, // #940
  {DBGFIELD("SHLD16mrCL_EVEX_SHLD16mrCL_ND_SHLD16mrCL_NF_SHLD16mrCL_NF_ND_SHLD32mrCL_SHLD32mrCL_EVEX_SHLD32mrCL_ND_SHLD32mrCL_NF_SHLD32mrCL_NF_ND_SHLD64mrCL_EVEX_SHLD64mrCL_ND_SHLD64mrCL_NF_SHLD64mrCL_NF_ND_SHRD16mrCL_EVEX_SHRD16mrCL_ND_SHRD16mrCL_NF_SHRD16mrCL_NF_ND_SHRD32mrCL_SHRD32mrCL_EVEX_SHRD32mrCL_ND_SHRD32mrCL_NF_SHRD32mrCL_NF_ND_SHRD64mrCL_EVEX_SHRD64mrCL_ND_SHRD64mrCL_NF_SHRD64mrCL_NF_ND") 6, false, false, false, 594, 13,  2, 1,  0, 0}, // #941
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 3, false, false, false, 15, 1, 12, 1,  0, 0}, // #942
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #943
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 4, false, false, false, 1469, 11,  2, 1,  0, 0}, // #944
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 2, false, false, false, 694, 4,  1, 1,  0, 0}, // #945
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 2, false, false, false, 694, 4,  1, 1,  0, 0}, // #946
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, false, 69, 5, 22, 1,  0, 0}, // #947
  {DBGFIELD("VPMASKMOVDrm")       2, false, false, false, 69, 5,  7, 1,  0, 0}, // #948
  {DBGFIELD("VPMASKMOVDYmr")      3, false, false, false, 650, 11, 21, 1,  0, 0}, // #949
  {DBGFIELD("VPMASKMOVDmr")       3, false, false, false, 650, 11, 21, 1,  0, 0}, // #950
  {DBGFIELD("VPMASKMOVQYmr")      3, false, false, false, 650, 11, 21, 1,  0, 0}, // #951
  {DBGFIELD("VPMASKMOVQmr")       3, false, false, false, 650, 11, 21, 1,  0, 0}, // #952
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 2, false, false, false, 375, 10,  7, 1,  0, 0}, // #953
  {DBGFIELD("VPGATHERDDYrm")      12, false, false, false, 1437, 12, 76, 2,  0, 0}, // #954
  {DBGFIELD("VPGATHERDDrm")       8, false, false, false, 1425, 12, 74, 2,  0, 0}, // #955
  {DBGFIELD("VPGATHERDQYrm")      8, false, false, false, 1425, 12, 72, 2,  0, 0}, // #956
  {DBGFIELD("VPGATHERDQrm")       5, false, false, false, 1413, 12, 70, 2,  0, 0}, // #957
  {DBGFIELD("VPGATHERQDYrm")      8, false, false, false, 1425, 12, 72, 2,  0, 0}, // #958
  {DBGFIELD("VPGATHERQDrm")       5, false, false, false, 1413, 12, 70, 2,  0, 0}, // #959
  {DBGFIELD("VPGATHERQQYrm")      8, false, false, false, 1425, 12, 72, 2,  0, 0}, // #960
  {DBGFIELD("VPGATHERQQrm")       5, false, false, false, 1413, 12, 70, 2,  0, 0}, // #961
  {DBGFIELD("VPERM2F128rr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #962
  {DBGFIELD("VPERM2I128rr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #963
  {DBGFIELD("VPERM2F128rm")       2, false, false, false, 375, 10,  8, 1,  6, 1}, // #964
  {DBGFIELD("VPERM2I128rm")       2, false, false, false, 375, 10,  8, 1,  6, 1}, // #965
  {DBGFIELD("VBROADCASTF128rm")   1, false, false, false, 28, 2,  7, 1,  0, 0}, // #966
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, false, 60, 8,  5, 1,  0, 0}, // #967
  {DBGFIELD("VEXTRACTI128rr")     1, false, false, false, 60, 8,  5, 1,  0, 0}, // #968
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #969
  {DBGFIELD("VEXTRACTI128mr")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #970
  {DBGFIELD("VINSERTF128rr")      1, false, false, false, 60, 8,  5, 1,  0, 0}, // #971
  {DBGFIELD("VINSERTI128rr")      1, false, false, false, 60, 8,  5, 1,  0, 0}, // #972
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #973
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, false, 183, 9,  6, 1,  0, 0}, // #974
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #975
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_VCVTPD2DQrm_VCVTTPD2DQrm") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #976
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #977
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #978
  {DBGFIELD("MMX_CVTPI2PDrr")     2, false, false, false, 183, 9,  3, 1,  0, 0}, // #979
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 2, false, false, false, 183, 9,  7, 1,  0, 0}, // #980
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #981
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #982
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int_VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, false, 203, 10,  2, 1,  0, 0}, // #983
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 2, false, false, false, 183, 9,  6, 1,  0, 1}, // #984
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, false, 183, 9,  6, 1,  7, 1}, // #985
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #986
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #987
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #988
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 3, false, false, false, 203, 10,  2, 1,  0, 0}, // #989
  {DBGFIELD("VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int") 3, false, false, false, 203, 10,  2, 1,  0, 0}, // #990
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false,  3, 4,  1, 1,  0, 0}, // #991
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false,  3, 4,  1, 1,  0, 0}, // #992
  {DBGFIELD("SHA256MSG2rm_SHA256MSG2rm_EVEX") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #993
  {DBGFIELD("SHA256MSG2rr_SHA256MSG2rr_EVEX") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #994
  {DBGFIELD("SHA1MSG1rr_SHA1MSG1rr_EVEX_SHA256MSG1rr_SHA256MSG1rr_EVEX") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #995
  {DBGFIELD("SHA1MSG1rm_SHA1MSG1rm_EVEX_SHA256MSG1rm_SHA256MSG1rm_EVEX") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #996
  {DBGFIELD("SHA1MSG2rr")         7, false, false, false, 1480, 8,  3, 1,  0, 0}, // #997
  {DBGFIELD("SHA1MSG2rm")         8, false, false, false, 1488, 10, 24, 1,  6, 1}, // #998
  {DBGFIELD("SHA1NEXTErr")        3, false, false, false, 1498, 6,  5, 1,  0, 0}, // #999
  {DBGFIELD("SHA1NEXTErm")        4, false, false, false, 1504, 8,  7, 1,  6, 1}, // #1000
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 60, 8,  3, 1,  0, 0}, // #1001
  {DBGFIELD("SHA1RNDS4rmi")       2, false, false, false, 375, 10, 24, 1,  6, 1}, // #1002
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 60, 8,  3, 1,  0, 0}, // #1003
  {DBGFIELD("SHA256RNDS2rm")      2, false, false, false, 375, 10, 24, 1,  6, 1}, // #1004
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, false, 15, 1, 12, 1,  0, 0}, // #1005
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1006
  {DBGFIELD("VCVTDQ2PSYrr")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1007
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1008
  {DBGFIELD("MOV8rm_MOV8rm_NOREX_MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 28, 2, 10, 1,  0, 0}, // #1009
  {DBGFIELD("MOVBE16rm")          3, false, false, false, 1512, 6,  6, 1,  0, 0}, // #1010
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1011
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1012
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1013
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1014
  {DBGFIELD("ADC8mr_SBB8mr")      6, false, false, false, 1117, 8, 24, 1, 12, 2}, // #1015
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, false, 30, 7,  1, 1,  0, 0}, // #1016
  {DBGFIELD("LEA16r")             2, false, false, false, 333, 7, 12, 1,  0, 0}, // #1017
  {DBGFIELD("LCMPXCHG8")          6, false, false, false, 14, 8,  2, 1,  0, 0}, // #1018
  {DBGFIELD("LCMPXCHG16B")        6, false, false, false, 14, 8,  2, 1,  0, 0}, // #1019
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 3, false, false, false, 15, 1, 12, 1,  0, 0}, // #1020
  {DBGFIELD("XCHG8rm_XCHG16rm")   8, false, false, false, 1518, 8, 78, 2,  0, 0}, // #1021
  {DBGFIELD("POPCNT16rr")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1022
  {DBGFIELD("LZCNT16rr")          1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1023
  {DBGFIELD("TZCNT16rr")          1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1024
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 6, false, false, false, 14, 8, 33, 2,  0, 0}, // #1025
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 6, false, false, false, 14, 8, 33, 2,  0, 0}, // #1026
  {DBGFIELD("RCL8mi_RCL16mi_RCL32mi_RCL64mi") 6, false, false, false, 14, 8, 33, 2,  0, 0}, // #1027
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, false, 541, 9,  7, 1,  0, 0}, // #1028
  {DBGFIELD("RCR8mCL_RCR16mCL_RCR32mCL_RCR64mCL") 10, false, false, false, 541, 13, 37, 2,  0, 0}, // #1029
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL") 7, false, false, false, 541, 9,  7, 1,  0, 0}, // #1030
  {DBGFIELD("RCL8mCL_RCL16mCL_RCL32mCL_RCL64mCL") 10, false, false, false, 541, 13, 37, 2,  0, 0}, // #1031
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1032
  {DBGFIELD("MMX_MOVQ2FR64rr")    2, false, false, false, 269, 8,  5, 1,  0, 0}, // #1033
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1034
  {DBGFIELD("EXTRQ")              1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1035
  {DBGFIELD("INSERTQ")            1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1036
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1037
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #1038
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1039
  {DBGFIELD("MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 3, false, false, false, 192, 11, 41, 1,  0, 0}, // #1040
  {DBGFIELD("SHA1MSG1rr")         2, false, false, false, 184, 8, 12, 1,  0, 0}, // #1041
  {DBGFIELD("SHA1MSG1rm")         3, false, false, false, 193, 10, 22, 1,  6, 1}, // #1042
  {DBGFIELD("SHA256MSG1rr")       7, false, false, false, 1526, 10, 10, 1,  0, 0}, // #1043
  {DBGFIELD("SHA256MSG1rm")       8, false, false, false, 1536, 12,  2, 1,  6, 1}, // #1044
  {DBGFIELD("SHA256MSG2rr")       2, false, false, false, 1240, 8,  3, 1,  0, 0}, // #1045
  {DBGFIELD("SHA256MSG2rm")       3, false, false, false, 1230, 10, 24, 1,  6, 1}, // #1046
  {DBGFIELD("VPERMPSYrm")         2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1047
  {DBGFIELD("VPERMPDYri")         1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1048
  {DBGFIELD("VPERMQYri")          1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1049
  {DBGFIELD("VPERMPDYmi")         2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1050
  {DBGFIELD("VPERMQYmi")          2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1051
  {DBGFIELD("VPERMDYrm")          2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1052
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false,  1, 1,  0, 1,  0, 0}, // #1053
  {DBGFIELD("MOVSX32rr32")        1, false, false, false, 115, 2,  1, 1,  0, 0}, // #1054
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1055
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1056
  {DBGFIELD("VXORPSrr_VXORPDrr")  1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1057
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1058
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1059
  {DBGFIELD("VPXORrr")            1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1060
  {DBGFIELD("VPANDNrr")           1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1061
  {DBGFIELD("VPANDNYrr")          1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1062
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1063
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1064
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1065
  {DBGFIELD("KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1066
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1067
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1068
  {DBGFIELD("VALIGNDZrri_VALIGNQZrri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1069
  {DBGFIELD("VALIGNDZ128rri_VALIGNQZ128rri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1070
  {DBGFIELD("VALIGNDZ256rri_VALIGNQZ256rri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1071
  {DBGFIELD("VPERMPSYrr")         1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1072
  {DBGFIELD("VPERMDYrr")          1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1073
  {DBGFIELD("VFIXUPIMMPDZ128rrik_VFIXUPIMMPDZ128rrikz_VFIXUPIMMPSZ128rrik_VFIXUPIMMPSZ128rrikz_VFIXUPIMMPDZ128rri_VFIXUPIMMPSZ128rri_VRANGEPDZ128rri_VRANGEPDZ128rrik_VRANGEPDZ128rrikz_VRANGEPSZ128rri_VRANGEPSZ128rrik_VRANGEPSZ128rrikz_VRANGESDZrri_VRANGESDZrrib_VRANGESDZrribk_VRANGESDZrribkz_VRANGESDZrrik_VRANGESDZrrikz_VRANGESSZrri_VRANGESSZrrib_VRANGESSZrribk_VRANGESSZrribkz_VRANGESSZrrik_VRANGESSZrrikz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1074
  {DBGFIELD("VFIXUPIMMPDZ256rrik_VFIXUPIMMPDZ256rrikz_VFIXUPIMMPSZ256rrik_VFIXUPIMMPSZ256rrikz_VFIXUPIMMPDZ256rri_VFIXUPIMMPSZ256rri_VRANGEPDZ256rri_VRANGEPDZ256rrik_VRANGEPDZ256rrikz_VRANGEPSZ256rri_VRANGEPSZ256rrik_VRANGEPSZ256rrikz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1075
  {DBGFIELD("VFIXUPIMMPDZrrik_VFIXUPIMMPDZrrikz_VFIXUPIMMPSZrrik_VFIXUPIMMPSZrrikz_VRANGEPDZrri_VRANGEPDZrrib_VRANGEPDZrribk_VRANGEPDZrribkz_VRANGEPDZrrik_VRANGEPDZrrikz_VRANGEPSZrri_VRANGEPSZrrib_VRANGEPSZrribk_VRANGEPSZrribkz_VRANGEPSZrrik_VRANGEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1076
  {DBGFIELD("VFIXUPIMMSDZrrik_VFIXUPIMMSDZrrikz_VFIXUPIMMSSZrrik_VFIXUPIMMSSZrrikz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1077
  {DBGFIELD("VSCALEFSDZrrb_Int_VSCALEFSDZrrb_Intk_VSCALEFSDZrrb_Intkz_VSCALEFSSZrrb_Int_VSCALEFSSZrrb_Intk_VSCALEFSSZrrb_Intkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1078
  {DBGFIELD("VREDUCEPDZ128rri_VREDUCEPDZ128rrik_VREDUCEPDZ128rrikz_VREDUCEPSZ128rri_VREDUCEPSZ128rrik_VREDUCEPSZ128rrikz_VREDUCESDZrri_VREDUCESDZrrib_VREDUCESDZrribk_VREDUCESDZrribkz_VREDUCESDZrrik_VREDUCESDZrrikz_VREDUCESSZrri_VREDUCESSZrrib_VREDUCESSZrribk_VREDUCESSZrribkz_VREDUCESSZrrik_VREDUCESSZrrikz") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1079
  {DBGFIELD("VREDUCEPDZrri_VREDUCEPDZrrib_VREDUCEPDZrribk_VREDUCEPDZrribkz_VREDUCEPDZrrik_VREDUCEPDZrrikz_VREDUCEPSZrri_VREDUCEPSZrrib_VREDUCEPSZrribk_VREDUCEPSZrribkz_VREDUCEPSZrrik_VREDUCEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1080
  {DBGFIELD("VDPBF16PSZ128r_VDPBF16PSZ128rk_VDPBF16PSZ128rkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1081
  {DBGFIELD("VDPBF16PSZ256r_VDPBF16PSZ256rk_VDPBF16PSZ256rkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1082
  {DBGFIELD("VDPBF16PSZr_VDPBF16PSZrk_VDPBF16PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1083
  {DBGFIELD("VPDPBUSDSZ128r_VPDPBUSDSZ128rk_VPDPBUSDSZ128rkz_VPDPBUSDZ128r_VPDPBUSDZ128rk_VPDPBUSDZ128rkz_VPDPWSSDSZ128r_VPDPWSSDSZ128rk_VPDPWSSDSZ128rkz_VPDPWSSDZ128r_VPDPWSSDZ128rk_VPDPWSSDZ128rkz_VPMADD52HUQZ128r_VPMADD52HUQZ128rk_VPMADD52HUQZ128rkz_VPMADD52LUQZ128r_VPMADD52LUQZ128rk_VPMADD52LUQZ128rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1084
  {DBGFIELD("VPDPBUSDSZ256r_VPDPBUSDSZ256rk_VPDPBUSDSZ256rkz_VPDPBUSDZ256r_VPDPBUSDZ256rk_VPDPBUSDZ256rkz_VPDPWSSDSZ256r_VPDPWSSDSZ256rk_VPDPWSSDSZ256rkz_VPDPWSSDZ256r_VPDPWSSDZ256rk_VPDPWSSDZ256rkz_VPMADD52HUQZ256r_VPMADD52HUQZ256rk_VPMADD52HUQZ256rkz_VPMADD52LUQZ256r_VPMADD52LUQZ256rk_VPMADD52LUQZ256rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1085
  {DBGFIELD("VPDPBUSDSZr_VPDPBUSDSZrk_VPDPBUSDSZrkz_VPDPBUSDZr_VPDPBUSDZrk_VPDPBUSDZrkz_VPDPWSSDSZr_VPDPWSSDSZrk_VPDPWSSDSZrkz_VPDPWSSDZr_VPDPWSSDZrk_VPDPWSSDZrkz_VPMADD52HUQZr_VPMADD52HUQZrk_VPMADD52HUQZrkz_VPMADD52LUQZr_VPMADD52LUQZrk_VPMADD52LUQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1086
  {DBGFIELD("VPLZCNTDZ128rr_VPLZCNTDZ128rrk_VPLZCNTDZ128rrkz_VPLZCNTQZ128rr_VPLZCNTQZ128rrk_VPLZCNTQZ128rrkz_VPSHLDDZ128rri_VPSHLDDZ128rrik_VPSHLDDZ128rrikz_VPSHLDQZ128rri_VPSHLDQZ128rrik_VPSHLDQZ128rrikz_VPSHLDVDZ128rk_VPSHLDVDZ128rkz_VPSHLDVQZ128rk_VPSHLDVQZ128rkz_VPSHLDVWZ128rk_VPSHLDVWZ128rkz_VPSHLDWZ128rri_VPSHLDWZ128rrik_VPSHLDWZ128rrikz_VPSHRDDZ128rri_VPSHRDDZ128rrik_VPSHRDDZ128rrikz_VPSHRDQZ128rri_VPSHRDQZ128rrik_VPSHRDQZ128rrikz_VPSHRDVDZ128rk_VPSHRDVDZ128rkz_VPSHRDVQZ128rk_VPSHRDVQZ128rkz_VPSHRDVWZ128rk_VPSHRDVWZ128rkz_VPSHRDWZ128rri_VPSHRDWZ128rrik_VPSHRDWZ128rrikz_VPSHUFBITQMBZ128rr_VPSHUFBITQMBZ128rrk") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1087
  {DBGFIELD("VPLZCNTDZ256rr_VPLZCNTDZ256rrk_VPLZCNTDZ256rrkz_VPLZCNTQZ256rr_VPLZCNTQZ256rrk_VPLZCNTQZ256rrkz_VPSHLDDZ256rri_VPSHLDDZ256rrik_VPSHLDDZ256rrikz_VPSHLDQZ256rri_VPSHLDQZ256rrik_VPSHLDQZ256rrikz_VPSHLDVDZ256rk_VPSHLDVDZ256rkz_VPSHLDVQZ256rk_VPSHLDVQZ256rkz_VPSHLDVWZ256rk_VPSHLDVWZ256rkz_VPSHLDWZ256rri_VPSHLDWZ256rrik_VPSHLDWZ256rrikz_VPSHRDDZ256rri_VPSHRDDZ256rrik_VPSHRDDZ256rrikz_VPSHRDQZ256rri_VPSHRDQZ256rrik_VPSHRDQZ256rrikz_VPSHRDVDZ256rk_VPSHRDVDZ256rkz_VPSHRDVQZ256rk_VPSHRDVQZ256rkz_VPSHRDVWZ256rk_VPSHRDVWZ256rkz_VPSHRDWZ256rri_VPSHRDWZ256rrik_VPSHRDWZ256rrikz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1088
  {DBGFIELD("VPLZCNTDZrr_VPLZCNTDZrrk_VPLZCNTDZrrkz_VPLZCNTQZrr_VPLZCNTQZrrk_VPLZCNTQZrrkz_VPSHLDDZrri_VPSHLDDZrrik_VPSHLDDZrrikz_VPSHLDQZrri_VPSHLDQZrrik_VPSHLDQZrrikz_VPSHLDVDZrk_VPSHLDVDZrkz_VPSHLDVQZrk_VPSHLDVQZrkz_VPSHLDVWZrk_VPSHLDVWZrkz_VPSHLDWZrri_VPSHLDWZrrik_VPSHLDWZrrikz_VPSHRDDZrri_VPSHRDDZrrik_VPSHRDDZrrikz_VPSHRDQZrri_VPSHRDQZrrik_VPSHRDQZrrikz_VPSHRDVDZrk_VPSHRDVDZrkz_VPSHRDVQZrk_VPSHRDVQZrkz_VPSHRDVWZrk_VPSHRDVWZrkz_VPSHRDWZrri_VPSHRDWZrrik_VPSHRDWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1089
  {DBGFIELD("PSLLDrr_PSLLQrr_PSLLWrr_PSRADrr_PSRAWrr_PSRLDrr_PSRLQrr_PSRLWrr_VPSLLDZ128rr_VPSLLDZ128rrk_VPSLLDZ128rrkz_VPSLLDrr_VPSLLQZ128rr_VPSLLQZ128rrk_VPSLLQZ128rrkz_VPSLLQrr_VPSLLWZ128rr_VPSLLWZ128rrk_VPSLLWZ128rrkz_VPSLLWrr_VPSRADZ128rr_VPSRADZ128rrk_VPSRADZ128rrkz_VPSRADrr_VPSRAQZ128rr_VPSRAQZ128rrk_VPSRAQZ128rrkz_VPSRAWZ128rr_VPSRAWZ128rrk_VPSRAWZ128rrkz_VPSRAWrr_VPSRLDZ128rr_VPSRLDZ128rrk_VPSRLDZ128rrkz_VPSRLDrr_VPSRLQZ128rr_VPSRLQZ128rrk_VPSRLQZ128rrkz_VPSRLQrr_VPSRLWZ128rr_VPSRLWZ128rrk_VPSRLWZ128rrkz_VPSRLWrr") 2, false, false, false, 531, 6, 12, 1,  0, 0}, // #1090
  {DBGFIELD("VPSLLDYrr_VPSLLDZ256rr_VPSLLDZ256rrk_VPSLLDZ256rrkz_VPSLLQYrr_VPSLLQZ256rr_VPSLLQZ256rrk_VPSLLQZ256rrkz_VPSLLWYrr_VPSLLWZ256rr_VPSLLWZ256rrk_VPSLLWZ256rrkz_VPSRADYrr_VPSRADZ256rr_VPSRADZ256rrk_VPSRADZ256rrkz_VPSRAQZ256rr_VPSRAQZ256rrk_VPSRAQZ256rrkz_VPSRAWYrr_VPSRAWZ256rr_VPSRAWZ256rrk_VPSRAWZ256rrkz_VPSRLDYrr_VPSRLDZ256rr_VPSRLDZ256rrk_VPSRLDZ256rrkz_VPSRLQYrr_VPSRLQZ256rr_VPSRLQZ256rrk_VPSRLQZ256rrkz_VPSRLWYrr_VPSRLWZ256rr_VPSRLWZ256rrk_VPSRLWZ256rrkz") 2, false, false, false, 183, 9, 14, 1,  0, 0}, // #1091
  {DBGFIELD("VPSLLDZrr_VPSLLDZrrk_VPSLLDZrrkz_VPSLLQZrr_VPSLLQZrrk_VPSLLQZrrkz_VPSLLWZrr_VPSLLWZrrk_VPSLLWZrrkz_VPSRADZrr_VPSRADZrrk_VPSRADZrrkz_VPSRAQZrr_VPSRAQZrrk_VPSRAQZrrkz_VPSRAWZrr_VPSRAWZrrk_VPSRAWZrrkz_VPSRLDZrr_VPSRLDZrrk_VPSRLDZrrkz_VPSRLQZrr_VPSRLQZrrk_VPSRLQZrrkz_VPSRLWZrr_VPSRLWZrrk_VPSRLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1092
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri_VPSLLDQZ256ri_VPSRLDQZ256ri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1093
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1094
  {DBGFIELD("VPSLLDQZri_VPSRLDQZri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1095
  {DBGFIELD("VPSHUFBYrr_VPSHUFBZ256rr_VPSHUFBZ256rrk_VPSHUFBZ256rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1096
  {DBGFIELD("VPSHUFBZ128rr_VPSHUFBZ128rrk_VPSHUFBZ128rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1097
  {DBGFIELD("VPSHUFBZrr_VPSHUFBZrrk_VPSHUFBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1098
  {DBGFIELD("VPROLVDZ128rr_VPROLVDZ128rrk_VPROLVDZ128rrkz_VPROLVQZ128rr_VPROLVQZ128rrk_VPROLVQZ128rrkz_VPRORVDZ128rr_VPRORVDZ128rrk_VPRORVDZ128rrkz_VPRORVQZ128rr_VPRORVQZ128rrk_VPRORVQZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1099
  {DBGFIELD("VPROLVDZ256rr_VPROLVDZ256rrk_VPROLVDZ256rrkz_VPROLVQZ256rr_VPROLVQZ256rrk_VPROLVQZ256rrkz_VPRORVDZ256rr_VPRORVDZ256rrk_VPRORVDZ256rrkz_VPRORVQZ256rr_VPRORVQZ256rrk_VPRORVQZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1100
  {DBGFIELD("VPROLVDZrr_VPROLVDZrrk_VPROLVDZrrkz_VPROLVQZrr_VPROLVQZrrk_VPROLVQZrrkz_VPRORVDZrr_VPRORVDZrrk_VPRORVDZrrkz_VPRORVQZrr_VPRORVQZrrk_VPRORVQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1101
  {DBGFIELD("VPROLDZ256ri_VPROLDZ256rik_VPROLDZ256rikz_VPROLQZ256ri_VPROLQZ256rik_VPROLQZ256rikz_VPRORDZ256ri_VPRORDZ256rik_VPRORDZ256rikz_VPRORQZ256ri_VPRORQZ256rik_VPRORQZ256rikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1102
  {DBGFIELD("VPROLDZ128ri_VPROLDZ128rik_VPROLDZ128rikz_VPROLQZ128ri_VPROLQZ128rik_VPROLQZ128rikz_VPRORDZ128ri_VPRORDZ128rik_VPRORDZ128rikz_VPRORQZ128ri_VPRORQZ128rik_VPRORQZ128rikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1103
  {DBGFIELD("VPROLDZri_VPROLDZrik_VPROLDZrikz_VPROLQZri_VPROLQZrik_VPROLQZrikz_VPRORDZri_VPRORDZrik_VPRORDZrikz_VPRORQZri_VPRORQZrik_VPRORQZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1104
  {DBGFIELD("VFMSUB231SSZr_Intkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1105
  {DBGFIELD("VPSLLDZ128ri_VPSLLDZ128rik_VPSLLDZ128rikz_VPSLLQZ128ri_VPSLLQZ128rik_VPSLLQZ128rikz_VPSLLWZ128ri_VPSLLWZ128rik_VPSLLWZ128rikz_VPSRADZ128ri_VPSRADZ128rik_VPSRADZ128rikz_VPSRAQZ128ri_VPSRAQZ128rik_VPSRAQZ128rikz_VPSRAWZ128ri_VPSRAWZ128rik_VPSRAWZ128rikz_VPSRLDZ128ri_VPSRLDZ128rik_VPSRLDZ128rikz_VPSRLQZ128ri_VPSRLQZ128rik_VPSRLQZ128rikz_VPSRLWZ128ri_VPSRLWZ128rik_VPSRLWZ128rikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1106
  {DBGFIELD("VPSLLDZ256ri_VPSLLDZ256rik_VPSLLDZ256rikz_VPSLLQZ256ri_VPSLLQZ256rik_VPSLLQZ256rikz_VPSLLWZ256ri_VPSLLWZ256rik_VPSLLWZ256rikz_VPSRADZ256ri_VPSRADZ256rik_VPSRADZ256rikz_VPSRAQZ256ri_VPSRAQZ256rik_VPSRAQZ256rikz_VPSRAWZ256ri_VPSRAWZ256rik_VPSRAWZ256rikz_VPSRLDZ256ri_VPSRLDZ256rik_VPSRLDZ256rikz_VPSRLQZ256ri_VPSRLQZ256rik_VPSRLQZ256rikz_VPSRLWZ256ri_VPSRLWZ256rik_VPSRLWZ256rikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1107
  {DBGFIELD("VPSLLDZri_VPSLLDZrik_VPSLLDZrikz_VPSLLQZri_VPSLLQZrik_VPSLLQZrikz_VPSLLWZri_VPSLLWZrik_VPSLLWZrikz_VPSRADZri_VPSRADZrik_VPSRADZrikz_VPSRAQZri_VPSRAQZrik_VPSRAQZrikz_VPSRAWZri_VPSRAWZrik_VPSRAWZrikz_VPSRLDZri_VPSRLDZrik_VPSRLDZrikz_VPSRLQZri_VPSRLQZrik_VPSRLQZrikz_VPSRLWZri_VPSRLWZrik_VPSRLWZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1108
  {DBGFIELD("PALIGNRrri_VPALIGNRZ128rri_VPALIGNRZ128rrik_VPALIGNRZ128rrikz_VPALIGNRrri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1109
  {DBGFIELD("VPALIGNRZ256rri_VPALIGNRZ256rrik_VPALIGNRZ256rrikz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1110
  {DBGFIELD("VPALIGNRZrri_VPALIGNRZrrik_VPALIGNRZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1111
  {DBGFIELD("PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWZ128rr_VPACKSSDWZ128rrk_VPACKSSDWZ128rrkz_VPACKSSDWrr_VPACKSSWBZ128rr_VPACKSSWBZ128rrk_VPACKSSWBZ128rrkz_VPACKSSWBrr_VPACKUSDWZ128rr_VPACKUSDWZ128rrk_VPACKUSDWZ128rrkz_VPACKUSDWrr_VPACKUSWBZ128rr_VPACKUSWBZ128rrk_VPACKUSWBZ128rrkz_VPACKUSWBrr") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1112
  {DBGFIELD("VPACKSSDWZ256rr_VPACKSSDWZ256rrk_VPACKSSDWZ256rrkz_VPACKSSWBZ256rr_VPACKSSWBZ256rrk_VPACKSSWBZ256rrkz_VPACKUSDWZ256rr_VPACKUSDWZ256rrk_VPACKUSDWZ256rrkz_VPACKUSWBZ256rr_VPACKUSWBZ256rrk_VPACKUSWBZ256rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1113
  {DBGFIELD("VPACKSSDWZrr_VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrr_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrr_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrr_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1114
  {DBGFIELD("CMPPDrri_VCMPPDrri_VMAXCPDZ128rr_VMAXCPDZ128rrk_VMAXCPDZ128rrkz_VMAXPDZ128rr_VMAXPDZ128rrk_VMAXPDZ128rrkz_VMINCPDZ128rr_VMINCPDZ128rrk_VMINCPDZ128rrkz_VMINPDZ128rr_VMINPDZ128rrk_VMINPDZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1115
  {DBGFIELD("CMPPSrri_VCMPPSrri") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1116
  {DBGFIELD("CMPSDrr_CMPSDrr_Int_VCMPSDrr_VCMPSDrr_Int_MAXSDrr_Int_MINSDrr_Int_VMAXSDZrr_Int_VMAXSDZrr_Intk_VMAXSDZrr_Intkz_VMAXSDrr_Int_VMINSDZrr_Int_VMINSDZrr_Intk_VMINSDZrr_Intkz_VMINSDrr_Int") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1117
  {DBGFIELD("CMPSSrr_CMPSSrr_Int_VCMPSSrr_VCMPSSrr_Int_MAXSSrr_Int_MINSSrr_Int_VMAXSSZrr_Int_VMAXSSZrr_Intk_VMAXSSZrr_Intkz_VMAXSSrr_Int_VMINSSZrr_Int_VMINSSZrr_Intk_VMINSSZrr_Intkz_VMINSSrr_Int") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1118
  {DBGFIELD("VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1119
  {DBGFIELD("VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1120
  {DBGFIELD("VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1121
  {DBGFIELD("VMAXCPDZ256rr_VMAXCPDZ256rrk_VMAXCPDZ256rrkz_VMAXPDZ256rr_VMAXPDZ256rrk_VMAXPDZ256rrkz_VMINCPDZ256rr_VMINCPDZ256rrk_VMINCPDZ256rrkz_VMINPDZ256rr_VMINPDZ256rrk_VMINPDZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1122
  {DBGFIELD("VMAXCPDZrr_VMAXCPDZrrk_VMAXCPDZrrkz_VMAXPDZrr_VMAXPDZrrb_VMAXPDZrrbk_VMAXPDZrrbkz_VMAXPDZrrk_VMAXPDZrrkz_VMINCPDZrr_VMINCPDZrrk_VMINCPDZrrkz_VMINPDZrr_VMINPDZrrb_VMINPDZrrbk_VMINPDZrrbkz_VMINPDZrrk_VMINPDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1123
  {DBGFIELD("VPMOVSXBDZ128rr_VPMOVSXBDZ128rrk_VPMOVSXBDZ128rrkz_VPMOVSXBQZ128rr_VPMOVSXBQZ128rrk_VPMOVSXBQZ128rrkz_VPMOVSXBWZ128rr_VPMOVSXBWZ128rrk_VPMOVSXBWZ128rrkz_VPMOVSXDQZ128rr_VPMOVSXDQZ128rrk_VPMOVSXDQZ128rrkz_VPMOVSXWDZ128rr_VPMOVSXWDZ128rrk_VPMOVSXWDZ128rrkz_VPMOVSXWQZ128rr_VPMOVSXWQZ128rrk_VPMOVSXWQZ128rrkz_VPMOVZXBDZ128rr_VPMOVZXBDZ128rrk_VPMOVZXBDZ128rrkz_VPMOVZXBQZ128rr_VPMOVZXBQZ128rrk_VPMOVZXBQZ128rrkz_VPMOVZXBWZ128rr_VPMOVZXBWZ128rrk_VPMOVZXBWZ128rrkz_VPMOVZXDQZ128rr_VPMOVZXDQZ128rrk_VPMOVZXDQZ128rrkz_VPMOVZXWDZ128rr_VPMOVZXWDZ128rrk_VPMOVZXWDZ128rrkz_VPMOVZXWQZ128rr_VPMOVZXWQZ128rrk_VPMOVZXWQZ128rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1124
  {DBGFIELD("VPMOVSXBDZ256rr_VPMOVSXBDZ256rrk_VPMOVSXBDZ256rrkz_VPMOVSXBQZ256rr_VPMOVSXBQZ256rrk_VPMOVSXBQZ256rrkz_VPMOVSXBWZ256rr_VPMOVSXBWZ256rrk_VPMOVSXBWZ256rrkz_VPMOVSXDQZ256rr_VPMOVSXDQZ256rrk_VPMOVSXDQZ256rrkz_VPMOVSXWDZ256rr_VPMOVSXWDZ256rrk_VPMOVSXWDZ256rrkz_VPMOVSXWQZ256rr_VPMOVSXWQZ256rrk_VPMOVSXWQZ256rrkz_VPMOVZXBDZ256rr_VPMOVZXBDZ256rrk_VPMOVZXBDZ256rrkz_VPMOVZXBQZ256rr_VPMOVZXBQZ256rrk_VPMOVZXBQZ256rrkz_VPMOVZXBWZ256rr_VPMOVZXBWZ256rrk_VPMOVZXBWZ256rrkz_VPMOVZXDQZ256rr_VPMOVZXDQZ256rrk_VPMOVZXDQZ256rrkz_VPMOVZXWDZ256rr_VPMOVZXWDZ256rrk_VPMOVZXWDZ256rrkz_VPMOVZXWQZ256rr_VPMOVZXWQZ256rrk_VPMOVZXWQZ256rrkz_VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVUSQWZ128rr_VPMOVUSQWZ128rrk_VPMOVUSQWZ128rrkz_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr_VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQDZ128rr_VPMOVQDZ128rrk_VPMOVQDZ128rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1125
  {DBGFIELD("VMOVDDUPZ128rr_VMOVDDUPZ128rrk_VMOVDDUPZ128rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1126
  {DBGFIELD("VMOVDDUPZ256rr_VMOVDDUPZ256rrk_VMOVDDUPZ256rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1127
  {DBGFIELD("VMOVDDUPZrr_VMOVDDUPZrrk_VMOVDDUPZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1128
  {DBGFIELD("PMOVSXBDrr_PMOVSXBQrr_PMOVSXBWrr_PMOVSXDQrr_PMOVSXWDrr_PMOVSXWQrr_PMOVZXBDrr_PMOVZXBQrr_PMOVZXBWrr_PMOVZXDQrr_PMOVZXWDrr_PMOVZXWQrr_VPMOVSXBDrr_VPMOVSXBQrr_VPMOVSXBWrr_VPMOVSXDQrr_VPMOVSXWDrr_VPMOVSXWQrr_VPMOVZXBDrr_VPMOVZXBQrr_VPMOVZXBWrr_VPMOVZXDQrr_VPMOVZXWDrr_VPMOVZXWQrr") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1129
  {DBGFIELD("VPMOVSXBDZrr_VPMOVSXBDZrrk_VPMOVSXBDZrrkz_VPMOVSXBQZrr_VPMOVSXBQZrrk_VPMOVSXBQZrrkz_VPMOVSXBWZrr_VPMOVSXBWZrrk_VPMOVSXBWZrrkz_VPMOVSXDQZrr_VPMOVSXDQZrrk_VPMOVSXDQZrrkz_VPMOVSXWDZrr_VPMOVSXWDZrrk_VPMOVSXWDZrrkz_VPMOVSXWQZrr_VPMOVSXWQZrrk_VPMOVSXWQZrrkz_VPMOVZXBDZrr_VPMOVZXBDZrrk_VPMOVZXBDZrrkz_VPMOVZXBQZrr_VPMOVZXBQZrrk_VPMOVZXBQZrrkz_VPMOVZXBWZrr_VPMOVZXBWZrrk_VPMOVZXBWZrrkz_VPMOVZXDQZrr_VPMOVZXDQZrrk_VPMOVZXDQZrrkz_VPMOVZXWDZrr_VPMOVZXWDZrrk_VPMOVZXWDZrrkz_VPMOVZXWQZrr_VPMOVZXWQZrrk_VPMOVZXWQZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1130
  {DBGFIELD("VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQWZrr_VPMOVUSQWZrrk_VPMOVUSQWZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1131
  {DBGFIELD("VPTESTMBZ128rrk_VPTESTMDZ128rrk_VPTESTMQZ128rrk_VPTESTMWZ128rrk_VPTESTNMBZ128rrk_VPTESTNMDZ128rrk_VPTESTNMQZ128rrk_VPTESTNMWZ128rrk") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1132
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1133
  {DBGFIELD("VPTESTMBZrrk_VPTESTMDZrrk_VPTESTMQZrrk_VPTESTMWZrrk_VPTESTNMBZrrk_VPTESTNMDZrrk_VPTESTNMQZrrk_VPTESTNMWZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1134
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz_VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1135
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz_VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1136
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz_VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1137
  {DBGFIELD("VRSQRT14PDZ128r_VRSQRT14PDZ128rk_VRSQRT14PDZ128rkz_VRSQRT14PSZ128r_VRSQRT14PSZ128rk_VRSQRT14PSZ128rkz") 1, false, false, false,  2, 8, 14, 1,  0, 0}, // #1138
  {DBGFIELD("VRSQRT14PDZ256r_VRSQRT14PDZ256rk_VRSQRT14PDZ256rkz_VRSQRT14PSZ256r_VRSQRT14PSZ256rk_VRSQRT14PSZ256rkz") 1, false, false, false,  2, 8, 14, 1,  0, 0}, // #1139
  {DBGFIELD("VRSQRT14PDZr_VRSQRT14PDZrk_VRSQRT14PDZrkz_VRSQRT14PSZr_VRSQRT14PSZrk_VRSQRT14PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1140
  {DBGFIELD("VPERMILPDYrr_VPERMILPDZ256rr_VPERMILPDZ256rrk_VPERMILPDZ256rrkz_VPERMILPSYrr_VPERMILPSZ256rr_VPERMILPSZ256rrk_VPERMILPSZ256rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1141
  {DBGFIELD("VPERMILPDZ128rr_VPERMILPDZ128rrk_VPERMILPDZ128rrkz_VPERMILPSZ128rr_VPERMILPSZ128rrk_VPERMILPSZ128rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1142
  {DBGFIELD("VPERMILPDZrr_VPERMILPDZrrk_VPERMILPDZrrkz_VPERMILPSZrr_VPERMILPSZrrk_VPERMILPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1143
  {DBGFIELD("VPERMI2PDZ128rr_VPERMI2PDZ128rrk_VPERMI2PDZ128rrkz_VPERMI2PSZ128rr_VPERMI2PSZ128rrk_VPERMI2PSZ128rrkz_VPERMT2PDZ128rr_VPERMT2PDZ128rrk_VPERMT2PDZ128rrkz_VPERMT2PSZ128rr_VPERMT2PSZ128rrk_VPERMT2PSZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1144
  {DBGFIELD("VPERMI2WZ128rr_VPERMI2WZ128rrk_VPERMI2WZ128rrkz_VPERMT2WZ128rr_VPERMT2WZ128rrk_VPERMT2WZ128rrkz_VPERMI2BZ128rr_VPERMI2BZ128rrk_VPERMI2BZ128rrkz_VPERMI2DZ128rr_VPERMI2DZ128rrk_VPERMI2DZ128rrkz_VPERMI2QZ128rr_VPERMI2QZ128rrk_VPERMI2QZ128rrkz_VPERMT2BZ128rr_VPERMT2BZ128rrk_VPERMT2BZ128rrkz_VPERMT2DZ128rr_VPERMT2DZ128rrk_VPERMT2DZ128rrkz_VPERMT2QZ128rr_VPERMT2QZ128rrk_VPERMT2QZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1145
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSBZ128rr_VPCOMPRESSBZ128rrk_VPCOMPRESSBZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSWZ128rr_VPCOMPRESSWZ128rrk_VPCOMPRESSWZ128rrkz_VPERMBZ128rr_VPERMBZ128rrk_VPERMBZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1146
  {DBGFIELD("VPERMI2PDZ256rr_VPERMI2PDZ256rrk_VPERMI2PDZ256rrkz_VPERMI2PSZ256rr_VPERMI2PSZ256rrk_VPERMI2PSZ256rrkz_VPERMT2PDZ256rr_VPERMT2PDZ256rrk_VPERMT2PDZ256rrkz_VPERMT2PSZ256rr_VPERMT2PSZ256rrk_VPERMT2PSZ256rrkz_VPERMPDZ256rr_VPERMPDZ256rrk_VPERMPDZ256rrkz_VPERMPSZ256rr_VPERMPSZ256rrk_VPERMPSZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1147
  {DBGFIELD("VPERMI2WZ256rr_VPERMI2WZ256rrk_VPERMI2WZ256rrkz_VPERMT2WZ256rr_VPERMT2WZ256rrk_VPERMT2WZ256rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSBZ256rr_VPCOMPRESSBZ256rrk_VPCOMPRESSBZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSWZ256rr_VPCOMPRESSWZ256rrk_VPCOMPRESSWZ256rrkz_VPERMBZ256rr_VPERMBZ256rrk_VPERMBZ256rrkz_VPERMDZ256rr_VPERMDZ256rrk_VPERMDZ256rrkz_VPERMQZ256rr_VPERMQZ256rrk_VPERMQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMI2BZ256rr_VPERMI2BZ256rrk_VPERMI2BZ256rrkz_VPERMI2DZ256rr_VPERMI2DZ256rrk_VPERMI2DZ256rrkz_VPERMI2QZ256rr_VPERMI2QZ256rrk_VPERMI2QZ256rrkz_VPERMT2BZ256rr_VPERMT2BZ256rrk_VPERMT2BZ256rrkz_VPERMT2DZ256rr_VPERMT2DZ256rrk_VPERMT2DZ256rrkz_VPERMT2QZ256rr_VPERMT2QZ256rrk_VPERMT2QZ256rrkz_VPEXPANDBZ256rr_VPEXPANDBZ256rrk_VPEXPANDBZ256rrkz_VPEXPANDWZ256rr_VPEXPANDWZ256rrk_VPEXPANDWZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1148
  {DBGFIELD("VPERMI2PDZrr_VPERMI2PDZrrk_VPERMI2PDZrrkz_VPERMI2PSZrr_VPERMI2PSZrrk_VPERMI2PSZrrkz_VPERMT2PDZrr_VPERMT2PDZrrk_VPERMT2PDZrrkz_VPERMT2PSZrr_VPERMT2PSZrrk_VPERMT2PSZrrkz_VPERMPDZrr_VPERMPDZrrk_VPERMPDZrrkz_VPERMPSZrr_VPERMPSZrrk_VPERMPSZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1149
  {DBGFIELD("VPERMI2WZrr_VPERMI2WZrrk_VPERMI2WZrrkz_VPERMT2WZrr_VPERMT2WZrrk_VPERMT2WZrrkz_VPERMBZrr_VPERMBZrrk_VPERMBZrrkz_VPERMDZrr_VPERMDZrrk_VPERMDZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz_VPERMI2BZrr_VPERMI2BZrrk_VPERMI2BZrrkz_VPERMI2DZrr_VPERMI2DZrrk_VPERMI2DZrrkz_VPERMI2QZrr_VPERMI2QZrrk_VPERMI2QZrrkz_VPERMT2BZrr_VPERMT2BZrrk_VPERMT2BZrrkz_VPERMT2DZrr_VPERMT2DZrrk_VPERMT2DZrrkz_VPERMT2QZrr_VPERMT2QZrrk_VPERMT2QZrrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSBZrr_VPCOMPRESSBZrrk_VPCOMPRESSBZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPCOMPRESSWZrr_VPCOMPRESSWZrrk_VPCOMPRESSWZrrkz_VPEXPANDBZrr_VPEXPANDBZrrk_VPEXPANDBZrrkz_VPEXPANDWZrr_VPEXPANDWZrrk_VPEXPANDWZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1150
  {DBGFIELD("VPABSBZ128rr_VPABSBZ128rrk_VPABSBZ128rrkz_VPABSDZ128rr_VPABSDZ128rrk_VPABSDZ128rrkz_VPABSQZ128rr_VPABSQZ128rrk_VPABSQZ128rrkz_VPABSWZ128rr_VPABSWZ128rrk_VPABSWZ128rrkz_VPADDSBZ128rr_VPADDSBZ128rrk_VPADDSBZ128rrkz_VPADDSWZ128rr_VPADDSWZ128rrk_VPADDSWZ128rrkz_VPADDUSBZ128rr_VPADDUSBZ128rrk_VPADDUSBZ128rrkz_VPADDUSWZ128rr_VPADDUSWZ128rrk_VPADDUSWZ128rrkz_VPAVGBZ128rr_VPAVGBZ128rrk_VPAVGBZ128rrkz_VPAVGWZ128rr_VPAVGWZ128rrk_VPAVGWZ128rrkz_VPOPCNTBZ128rr_VPOPCNTBZ128rrk_VPOPCNTBZ128rrkz_VPOPCNTDZ128rr_VPOPCNTDZ128rrk_VPOPCNTDZ128rrkz_VPOPCNTQZ128rr_VPOPCNTQZ128rrk_VPOPCNTQZ128rrkz_VPOPCNTWZ128rr_VPOPCNTWZ128rrk_VPOPCNTWZ128rrkz_VPSUBSBZ128rr_VPSUBSBZ128rrk_VPSUBSBZ128rrkz_VPSUBSWZ128rr_VPSUBSWZ128rrk_VPSUBSWZ128rrkz_VPSUBUSBZ128rr_VPSUBUSBZ128rrk_VPSUBUSBZ128rrkz_VPSUBUSWZ128rr_VPSUBUSWZ128rrk_VPSUBUSWZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1151
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 15, false, false, false, 1548, 14, 56, 1,  0, 0}, // #1152
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 4, false, false, false, 40, 5,  2, 1,  0, 0}, // #1153
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1154
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 1, false, false, false,  1, 1,  8, 1,  0, 0}, // #1155
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #1156
  {DBGFIELD("CRC32r32r16")        1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1157
  {DBGFIELD("CRC32r32r32")        1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1158
  {DBGFIELD("CRC32r64r64")        1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1159
  {DBGFIELD("SAHF")               2, false, false, false, 563, 4, 14, 1,  0, 0}, // #1160
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 2, false, false, false, 104, 9,  3, 1,  0, 0}, // #1161
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 3, false, false, false, 104, 11,  8, 1,  0, 0}, // #1162
  {DBGFIELD("RCR8ri")             3, false, false, false, 14, 4, 12, 1,  0, 0}, // #1163
  {DBGFIELD("RCL16rCL")           7, false, false, false, 541, 9,  7, 1,  0, 0}, // #1164
  {DBGFIELD("RCR16ri")            3, false, false, false, 14, 4, 12, 1,  0, 0}, // #1165
  {DBGFIELD("RCR32rCL_RCR64rCL")  7, false, false, false, 541, 9,  7, 1,  0, 0}, // #1166
  {DBGFIELD("RCL16ri")            3, false, false, false, 14, 4, 12, 1,  0, 0}, // #1167
  {DBGFIELD("RCL32ri_RCL64ri")    3, false, false, false, 14, 4, 12, 1,  0, 0}, // #1168
  {DBGFIELD("SHLD16rrCL")         3, false, false, false, 342, 9, 10, 1,  0, 0}, // #1169
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 3, false, false, false, 342, 9, 10, 1,  0, 0}, // #1170
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1171
  {DBGFIELD("TST_F")              1, false, false, false,  2, 8, 12, 1,  0, 0}, // #1172
  {DBGFIELD("VDPPSrri")           6, false, false, false, 251, 10, 21, 1,  0, 0}, // #1173
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1174
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1175
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, false, 74, 6, 11, 1,  6, 1}, // #1176
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1177
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 3, false, false, false, 74, 6, 16, 1,  6, 1}, // #1178
  {DBGFIELD("MMX_CVTTPD2PIrr")    2, false, false, false, 183, 9,  7, 1,  0, 0}, // #1179
  {DBGFIELD("CVTSI2SSrr")         2, false, false, false, 183, 9,  6, 1,  0, 1}, // #1180
  {DBGFIELD("VMOVDQUYmr")         2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1181
  {DBGFIELD("MOVDQArr")           0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1182
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 2, false, false, false, 74, 4,  9, 1,  0, 0}, // #1183
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1184
  {DBGFIELD("VPPERMrrm")          2, false, false, false, 53, 7,  7, 1, 10, 2}, // #1185
  {DBGFIELD("VPPERMrmr")          2, false, false, false, 53, 7,  7, 1,  8, 2}, // #1186
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, false, 524, 5, 12, 1,  0, 0}, // #1187
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, false, 524, 7, 22, 1,  6, 1}, // #1188
  {DBGFIELD("VPCLMULQDQrr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1189
  {DBGFIELD("ANDNPSrr_ANDNPDrr")  1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1190
  {DBGFIELD("MMX_PXORrr_MMX_PANDNrr") 1, false, false, false,  4, 5,  1, 1,  0, 0}, // #1191
  {DBGFIELD("PANDNrr")            1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1192
  {DBGFIELD("MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false,  4, 5,  1, 1,  0, 0}, // #1193
  {DBGFIELD("LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 6, false, false, false, 14, 8,  2, 1,  0, 0}, // #1194
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, false, 169, 4,  5, 1,  0, 0}, // #1195
  {DBGFIELD("LCMPXCHG8B")         6, false, false, false, 14, 8,  2, 1,  0, 0}, // #1196
  {DBGFIELD("INC8m_INC16m_INC32m_INC64m_DEC8m_DEC16m_DEC32m_DEC64m_NOT8m_NOT16m_NOT32m_NOT64m_NEG8m_NEG16m_NEG32m_NEG64m") 4, false, false, false, 40, 5,  2, 1,  0, 0}, // #1197
  {DBGFIELD("XCHG8rr")            3, false, false, false, 15, 1, 12, 1,  0, 0}, // #1198
  {DBGFIELD("MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #1199
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1200
  {DBGFIELD("MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #1201
  {DBGFIELD("MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #1202
  {DBGFIELD("CLAC_STAC")          1, false, false, false, 10, 4,  1, 1,  0, 0}, // #1203
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1204
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1205
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1206
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, false, 1562, 11,  5, 1,  0, 0}, // #1207
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, false, 1573, 6, 12, 1,  0, 0}, // #1208
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 3, false, false, false, 1573, 6, 12, 1,  0, 0}, // #1209
  {DBGFIELD("MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm") 2, false, false, false, 173, 10, 22, 1,  6, 1}, // #1210
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 2, false, false, false, 69, 5,  7, 1,  6, 1}, // #1211
  {DBGFIELD("VCVTSS2SI64rr_VCVTTSS2SI64rr") 3, false, false, false, 683, 11,  7, 1,  0, 0}, // #1212
  {DBGFIELD("VCVTSS2SI64rr_Int_VCVTTSS2SI64rr_Int") 3, false, false, false, 683, 11,  7, 1,  0, 0}, // #1213
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 2, false, false, false, 69, 5, 22, 1,  6, 1}, // #1214
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, false, 1579, 13,  8, 1,  6, 1}, // #1215
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, false, 1592, 8, 22, 1,  6, 1}, // #1216
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 4, false, false, false, 1592, 8,  9, 1,  6, 1}, // #1217
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 186, false, false, false, 1600, 15, 52, 1,  0, 0}, // #1218
  {DBGFIELD("PCMPGTBrr_PCMPGTDrr_PCMPGTWrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1219
  {DBGFIELD("VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1220
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1221
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1222
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1223
  {DBGFIELD("KMOVBkk_EVEX_KMOVDkk_EVEX_KMOVQkk_EVEX_KMOVWkk_EVEX_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1224
  {DBGFIELD("KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W") 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1225
  {DBGFIELD("KMOVBkr_EVEX_KMOVDkr_EVEX_KMOVQkr_EVEX_KMOVWkr_EVEX") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1226
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1227
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 3, false, false, false, 223, 3,  5, 1,  0, 0}, // #1228
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1229
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1230
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1231
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1232
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 3, false, false, false, 223, 3,  5, 1,  0, 0}, // #1233
  {DBGFIELD("KMOVBmk_EVEX_KMOVDmk_EVEX_KMOVQmk_EVEX_KMOVWmk_EVEX") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1234
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1235
  {DBGFIELD("KMOVBrk_EVEX_KMOVDrk_EVEX_KMOVQrk_EVEX_KMOVWrk_EVEX") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1236
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1237
  {DBGFIELD("VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1238
  {DBGFIELD("VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rrik_VALIGNQZ256rrikz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1239
  {DBGFIELD("VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrrik_VALIGNQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1240
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1241
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1242
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1243
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1244
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1245
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1246
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1247
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1248
  {DBGFIELD("VPTESTMBZ128rr_VPTESTMDZ128rr_VPTESTMQZ128rr_VPTESTMWZ128rr_VPTESTNMBZ128rr_VPTESTNMDZ128rr_VPTESTNMQZ128rr_VPTESTNMWZ128rr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1249
  {DBGFIELD("VPTESTMBZrr_VPTESTMDZrr_VPTESTMQZrr_VPTESTMWZrr_VPTESTNMBZrr_VPTESTNMDZrr_VPTESTNMQZrr_VPTESTNMWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1250
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1251
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1252
  {DBGFIELD("VCVTPS2DQYrr_VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1253
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1254
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1255
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1256
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1257
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1258
  {DBGFIELD("VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1259
  {DBGFIELD("VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1260
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1261
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1262
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1263
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz_CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1264
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1265
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1266
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, false, 183, 9,  6, 1,  7, 1}, // #1267
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, false, 183, 9,  6, 1,  7, 1}, // #1268
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz_CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1269
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1270
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, false, 643, 7,  2, 1,  0, 0}, // #1271
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 3, false, false, false, 643, 7,  2, 1,  0, 0}, // #1272
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1273
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1274
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1275
  {DBGFIELD("VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1276
  {DBGFIELD("VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1277
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1278
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1279
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 2, false, false, false, 183, 9,  6, 1,  7, 1}, // #1280
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1281
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1282
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1283
  {DBGFIELD("VCVTPS2PDYrr_VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1284
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1285
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1286
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1287
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1288
  {DBGFIELD("VCVTPS2PDZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1289
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1290
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1291
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1292
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 2, false, false, false, 69, 5,  7, 1,  6, 1}, // #1293
  {DBGFIELD("VBROADCASTI32X2Z128rm_VBROADCASTI32X2Z128rmk_VBROADCASTI32X2Z128rmkz_VPBROADCASTDZ128rm_VPBROADCASTDZ128rmk_VPBROADCASTDZ128rmkz_VPBROADCASTQZ128rm_VPBROADCASTQZ128rmk_VPBROADCASTQZ128rmkz") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #1294
  {DBGFIELD("VBROADCASTSSZ128rm_VBROADCASTSSZ128rmk_VBROADCASTSSZ128rmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1295
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1296
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 2, false, false, false, 375, 10,  7, 1,  0, 0}, // #1297
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1298
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 2, false, false, false, 68, 6,  7, 1,  6, 1}, // #1299
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 2, false, false, false, 69, 5,  7, 1,  6, 1}, // #1300
  {DBGFIELD("VPERMI2WZ128rr_VPERMI2WZ128rrk_VPERMI2WZ128rrkz_VPERMT2WZ128rr_VPERMT2WZ128rrk_VPERMT2WZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1301
  {DBGFIELD("VPERMI2WZ256rr_VPERMI2WZ256rrk_VPERMI2WZ256rrkz_VPERMT2WZ256rr_VPERMT2WZ256rrk_VPERMT2WZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1302
  {DBGFIELD("VPERMI2WZrr_VPERMI2WZrrk_VPERMI2WZrrkz_VPERMT2WZrr_VPERMT2WZrrk_VPERMT2WZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1303
  {DBGFIELD("VCVTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #1304
  {DBGFIELD("KMOVBkm_KMOVBkm_EVEX_KMOVDkm_KMOVDkm_EVEX_KMOVQkm_KMOVQkm_EVEX_KMOVWkm_KMOVWkm_EVEX") 1, false, false, false, 28, 2, 10, 1,  0, 0}, // #1305
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1306
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1307
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1308
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1309
  {DBGFIELD("VSCATTERDPSZmr")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1310
  {DBGFIELD("VPBROADCASTBZ256rm_VPBROADCASTBZ256rmk_VPBROADCASTBZ256rmkz_VPBROADCASTBZrm_VPBROADCASTBZrmk_VPBROADCASTBZrmkz_VPBROADCASTWZ256rm_VPBROADCASTWZ256rmk_VPBROADCASTWZ256rmkz_VPBROADCASTWZrm_VPBROADCASTWZrmk_VPBROADCASTWZrmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1311
  {DBGFIELD("VMOVNTDQAZ256rm")    1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1312
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 4, false, false, false, 638, 5,  9, 1,  6, 1}, // #1313
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1314
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTF32X2Z256rmk_VBROADCASTF32X2Z256rmkz_VBROADCASTF32X2Zrm_VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Z256rm_VBROADCASTI32X2Z256rmk_VBROADCASTI32X2Z256rmkz_VBROADCASTI32X2Zrm_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZ256rm_VPBROADCASTDZ256rmk_VPBROADCASTDZ256rmkz_VPBROADCASTDZrm_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZ256rm_VPBROADCASTQZ256rmk_VPBROADCASTQZ256rmkz_VPBROADCASTQZrm_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1315
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, false, 53, 7, 22, 1,  0, 0}, // #1316
  {DBGFIELD("VBROADCASTSDZ256rm_VBROADCASTSDZ256rmk_VBROADCASTSDZ256rmkz_VBROADCASTSDZrm_VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZ256rm_VBROADCASTSSZ256rmk_VBROADCASTSSZ256rmkz_VBROADCASTSSZrm_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1317
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1318
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1319
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1320
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, false, 375, 10, 22, 1,  0, 0}, // #1321
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1322
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1323
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 2, false, false, false, 68, 6, 22, 1,  6, 1}, // #1324
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1325
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 4, false, false, false, 638, 5,  9, 1,  6, 1}, // #1326
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1327
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1328
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1329
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1330
  {DBGFIELD("VPSCATTERDDZmr")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1331
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 2, false, false, false, 53, 7,  7, 1,  6, 1}, // #1332
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1333
  {DBGFIELD("VPERMI2DZ128rm_VPERMI2DZ128rmb_VPERMI2DZ128rmbk_VPERMI2DZ128rmbkz_VPERMI2DZ128rmk_VPERMI2DZ128rmkz_VPERMI2QZ128rm_VPERMI2QZ128rmb_VPERMI2QZ128rmbk_VPERMI2QZ128rmbkz_VPERMI2QZ128rmk_VPERMI2QZ128rmkz_VPERMT2DZ128rm_VPERMT2DZ128rmb_VPERMT2DZ128rmbk_VPERMT2DZ128rmbkz_VPERMT2DZ128rmk_VPERMT2DZ128rmkz_VPERMT2QZ128rm_VPERMT2QZ128rmb_VPERMT2QZ128rmbk_VPERMT2QZ128rmbkz_VPERMT2QZ128rmk_VPERMT2QZ128rmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1334
  {DBGFIELD("VPERMI2PDZ128rm_VPERMI2PDZ128rmb_VPERMI2PDZ128rmbk_VPERMI2PDZ128rmbkz_VPERMI2PDZ128rmk_VPERMI2PDZ128rmkz_VPERMI2PSZ128rm_VPERMI2PSZ128rmb_VPERMI2PSZ128rmbk_VPERMI2PSZ128rmbkz_VPERMI2PSZ128rmk_VPERMI2PSZ128rmkz_VPERMT2PDZ128rm_VPERMT2PDZ128rmb_VPERMT2PDZ128rmbk_VPERMT2PDZ128rmbkz_VPERMT2PDZ128rmk_VPERMT2PDZ128rmkz_VPERMT2PSZ128rm_VPERMT2PSZ128rmb_VPERMT2PSZ128rmbk_VPERMT2PSZ128rmbkz_VPERMT2PSZ128rmk_VPERMT2PSZ128rmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1335
  {DBGFIELD("VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  6, 1}, // #1336
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik_VFPCLASSPDZ128rm_VFPCLASSPDZ128rmb_VFPCLASSPDZ128rmbk_VFPCLASSPDZ128rmk_VFPCLASSPSZ128rm_VFPCLASSPSZ128rmb_VFPCLASSPSZ128rmbk_VFPCLASSPSZ128rmk") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1337
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1338
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik") 2, false, false, false, 68, 6,  7, 1,  6, 1}, // #1339
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 2, false, false, false, 69, 5,  7, 1,  6, 1}, // #1340
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1341
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, false, 53, 7, 22, 1,  6, 1}, // #1342
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1343
  {DBGFIELD("VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  6, 1}, // #1344
  {DBGFIELD("VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1345
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik_VFPCLASSPDZ256rm_VFPCLASSPDZ256rmb_VFPCLASSPDZ256rmbk_VFPCLASSPDZ256rmk_VFPCLASSPSZ256rm_VFPCLASSPSZ256rmb_VFPCLASSPSZ256rmbk_VFPCLASSPSZ256rmk") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #1346
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik_VFPCLASSPDZrm_VFPCLASSPDZrmb_VFPCLASSPDZrmbk_VFPCLASSPDZrmk_VFPCLASSPSZrm_VFPCLASSPSZrmb_VFPCLASSPSZrmbk_VFPCLASSPSZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1347
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik") 2, false, false, false, 68, 6, 22, 1,  6, 1}, // #1348
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1349
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 2, false, false, false, 69, 5, 22, 1,  6, 1}, // #1350
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1351
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1352
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_CVTDQ2PSrm_VCVTDQ2PSrm_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1353
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1354
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1355
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_CVTPS2DQrm_VCVTPS2DQrm_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_CVTTPS2DQrm_VCVTTPS2DQrm_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1356
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1357
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz_CVTSS2SDrm_CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1358
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1359
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1360
  {DBGFIELD("VCVTPS2PDYrm")       2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1361
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1362
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1363
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1364
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1365
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1366
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1367
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1368
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1369
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #1370
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1371
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm_VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1372
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1373
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1374
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1375
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1376
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  0, 0}, // #1377
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1378
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1379
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1380
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1381
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 3, false, false, false, 203, 10,  2, 1,  6, 1}, // #1382
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 3, false, false, false, 203, 10,  2, 1,  6, 1}, // #1383
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1384
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1385
  {DBGFIELD("VCVTDQ2PDYrm")       2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1386
  {DBGFIELD("VPERMI2WZ128rm_VPERMI2WZ128rmk_VPERMI2WZ128rmkz_VPERMT2WZ128rm_VPERMT2WZ128rmk_VPERMT2WZ128rmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1387
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1388
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1389
  {DBGFIELD("VPERMI2WZ256rm_VPERMI2WZ256rmk_VPERMI2WZ256rmkz_VPERMI2WZrm_VPERMI2WZrmk_VPERMI2WZrmkz_VPERMT2WZ256rm_VPERMT2WZ256rmk_VPERMT2WZ256rmkz_VPERMT2WZrm_VPERMT2WZrmk_VPERMT2WZrmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1390
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  0, 0}, // #1391
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #1392
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #1393
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1394
  {DBGFIELD("VGATHERQPSZ128rm_VPGATHERQDZ128rm_VGATHERDPDZ128rm_VPGATHERDQZ128rm_VGATHERQPDZ128rm_VPGATHERQQZ128rm") 1, false, false, false, 28, 2, 42, 2,  0, 0}, // #1395
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm_VGATHERQPDZ256rm_VPGATHERQQZ256rm_VGATHERDPSZ128rm_VPGATHERDDZ128rm_VGATHERDPDZ256rm_VPGATHERDQZ256rm") 1, false, false, false, 28, 2, 42, 2,  0, 0}, // #1396
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm_VGATHERDPDZrm_VPGATHERDQZrm_VGATHERQPDZrm_VPGATHERQQZrm_VGATHERQPSZrm_VPGATHERQDZrm") 1, false, false, false, 28, 2, 42, 2,  0, 0}, // #1397
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, false, 28, 2, 42, 2,  0, 0}, // #1398
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1399
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  0, 0}, // #1400
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1401
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  0, 0}, // #1402
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1403
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1404
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1405
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1406
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1407
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1408
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1409
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1410
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1411
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1412
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1413
  {DBGFIELD("VPBROADCASTDrr_VPBROADCASTQrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1414
  {DBGFIELD("INSERTPSrr_VINSERTPSZrr_VINSERTPSrr_MOVHLPSrr_MOVLHPSrr_VMOVHLPSZrr_VMOVHLPSrr_VMOVLHPSZrr_VMOVLHPSrr_MOVDDUPrr_VMOVDDUPrr_VPERMILPDZ128ri_VPERMILPDZ128rik_VPERMILPDZ128rikz_VPERMILPDri_VPERMILPSZ128ri_VPERMILPSZ128rik_VPERMILPSZ128rikz_VPERMILPSri_UNPCKHPDrr_UNPCKHPSrr_UNPCKLPDrr_UNPCKLPSrr_VUNPCKHPDZ128rr_VUNPCKHPDZ128rrk_VUNPCKHPDZ128rrkz_VUNPCKHPDrr_VUNPCKHPSZ128rr_VUNPCKHPSZ128rrk_VUNPCKHPSZ128rrkz_VUNPCKHPSrr_VUNPCKLPDZ128rr_VUNPCKLPDZ128rrk_VUNPCKLPDZ128rrkz_VUNPCKLPDrr_VUNPCKLPSZ128rr_VUNPCKLPSZ128rrk_VUNPCKLPSZ128rrkz_VUNPCKLPSrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1415
  {DBGFIELD("VMOVDDUPYrr_VPERMILPDYri_VPERMILPDZ256ri_VPERMILPDZ256rik_VPERMILPDZ256rikz_VPERMILPSYri_VPERMILPSZ256ri_VPERMILPSZ256rik_VPERMILPSZ256rikz_VUNPCKHPDYrr_VUNPCKHPDZ256rr_VUNPCKHPDZ256rrk_VUNPCKHPDZ256rrkz_VUNPCKHPSYrr_VUNPCKHPSZ256rr_VUNPCKHPSZ256rrk_VUNPCKHPSZ256rrkz_VUNPCKLPDYrr_VUNPCKLPDZ256rr_VUNPCKLPDZ256rrk_VUNPCKLPDZ256rrkz_VUNPCKLPSYrr_VUNPCKLPSZ256rr_VUNPCKLPSZ256rrk_VUNPCKLPSZ256rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1416
  {DBGFIELD("VPALIGNRYrri")       1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1417
  {DBGFIELD("VPERMILPDrr_VPERMILPSrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1418
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDZrr_VMOVSDZrr_REV_VMOVSDZrrk_VMOVSDZrrk_REV_VMOVSDZrrkz_VMOVSDZrrkz_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSZrr_VMOVSSZrr_REV_VMOVSSZrrk_VMOVSSZrrk_REV_VMOVSSZrrkz_VMOVSSZrrkz_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1419
  {DBGFIELD("VPACKSSDWYrr_VPACKSSWBYrr_VPACKUSDWYrr_VPACKUSWBYrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1420
  {DBGFIELD("VPBROADCASTBZ128rm_VPBROADCASTBZ128rmk_VPBROADCASTBZ128rmkz_VPBROADCASTWZ128rm_VPBROADCASTWZ128rmk_VPBROADCASTWZ128rmkz") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #1421
  {DBGFIELD("INSERTPSrm_VINSERTPSZrm_VINSERTPSrm_UNPCKHPDrm_UNPCKHPSrm_UNPCKLPDrm_UNPCKLPSrm_VUNPCKHPDZ128rm_VUNPCKHPDZ128rmb_VUNPCKHPDZ128rmbk_VUNPCKHPDZ128rmbkz_VUNPCKHPDZ128rmk_VUNPCKHPDZ128rmkz_VUNPCKHPDrm_VUNPCKHPSZ128rm_VUNPCKHPSZ128rmb_VUNPCKHPSZ128rmbk_VUNPCKHPSZ128rmbkz_VUNPCKHPSZ128rmk_VUNPCKHPSZ128rmkz_VUNPCKHPSrm_VUNPCKLPDZ128rm_VUNPCKLPDZ128rmb_VUNPCKLPDZ128rmbk_VUNPCKLPDZ128rmbkz_VUNPCKLPDZ128rmk_VUNPCKLPDZ128rmkz_VUNPCKLPDrm_VUNPCKLPSZ128rm_VUNPCKLPSZ128rmb_VUNPCKLPSZ128rmbk_VUNPCKLPSZ128rmbkz_VUNPCKLPSZ128rmk_VUNPCKLPSZ128rmkz_VUNPCKLPSrm") 2, false, false, false, 375, 10,  7, 1,  6, 1}, // #1422
  {DBGFIELD("PALIGNRrmi_VPALIGNRZ128rmi_VPALIGNRZ128rmik_VPALIGNRZ128rmikz_VPALIGNRrmi") 2, false, false, false, 53, 7,  7, 1,  6, 1}, // #1423
  {DBGFIELD("VPERMILPDZ128mbi_VPERMILPDZ128mbik_VPERMILPDZ128mbikz_VPERMILPDZ128mi_VPERMILPDZ128mik_VPERMILPDZ128mikz_VPERMILPDmi_VPERMILPSZ128mbi_VPERMILPSZ128mbik_VPERMILPSZ128mbikz_VPERMILPSZ128mi_VPERMILPSZ128mik_VPERMILPSZ128mikz_VPERMILPSmi") 2, false, false, false, 375, 10,  7, 1,  0, 0}, // #1424
  {DBGFIELD("VPERMILPDZ128rm_VPERMILPDZ128rmb_VPERMILPDZ128rmbk_VPERMILPDZ128rmbkz_VPERMILPDZ128rmk_VPERMILPDZ128rmkz_VPERMILPDrm_VPERMILPSZ128rm_VPERMILPSZ128rmb_VPERMILPSZ128rmbk_VPERMILPSZ128rmbkz_VPERMILPSZ128rmk_VPERMILPSZ128rmkz_VPERMILPSrm") 2, false, false, false, 375, 10,  7, 1,  6, 1}, // #1425
  {DBGFIELD("VPALIGNRYrmi_VPALIGNRZ256rmi_VPALIGNRZ256rmik_VPALIGNRZ256rmikz") 2, false, false, false, 53, 7, 22, 1,  6, 1}, // #1426
  {DBGFIELD("VPERMILPDYmi_VPERMILPDZ256mbi_VPERMILPDZ256mbik_VPERMILPDZ256mbikz_VPERMILPDZ256mi_VPERMILPDZ256mik_VPERMILPDZ256mikz_VPERMILPSYmi_VPERMILPSZ256mbi_VPERMILPSZ256mbik_VPERMILPSZ256mbikz_VPERMILPSZ256mi_VPERMILPSZ256mik_VPERMILPSZ256mikz") 2, false, false, false, 375, 10, 22, 1,  0, 0}, // #1427
  {DBGFIELD("VPERMILPDYrm_VPERMILPDZ256rm_VPERMILPDZ256rmb_VPERMILPDZ256rmbk_VPERMILPDZ256rmbkz_VPERMILPDZ256rmk_VPERMILPDZ256rmkz_VPERMILPSYrm_VPERMILPSZ256rm_VPERMILPSZ256rmb_VPERMILPSZ256rmbk_VPERMILPSZ256rmbkz_VPERMILPSZ256rmk_VPERMILPSZ256rmkz") 2, false, false, false, 375, 10, 22, 1,  6, 1}, // #1428
  {DBGFIELD("VUNPCKHPDYrm_VUNPCKHPDZ256rm_VUNPCKHPDZ256rmb_VUNPCKHPDZ256rmbk_VUNPCKHPDZ256rmbkz_VUNPCKHPDZ256rmk_VUNPCKHPDZ256rmkz_VUNPCKHPSYrm_VUNPCKHPSZ256rm_VUNPCKHPSZ256rmb_VUNPCKHPSZ256rmbk_VUNPCKHPSZ256rmbkz_VUNPCKHPSZ256rmk_VUNPCKHPSZ256rmkz_VUNPCKLPDYrm_VUNPCKLPDZ256rm_VUNPCKLPDZ256rmb_VUNPCKLPDZ256rmbk_VUNPCKLPDZ256rmbkz_VUNPCKLPDZ256rmk_VUNPCKLPDZ256rmkz_VUNPCKLPSYrm_VUNPCKLPSZ256rm_VUNPCKLPSZ256rmb_VUNPCKLPSZ256rmbk_VUNPCKLPSZ256rmbkz_VUNPCKLPSZ256rmk_VUNPCKLPSZ256rmkz") 2, false, false, false, 375, 10, 22, 1,  6, 1}, // #1429
  {DBGFIELD("PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWZ128rm_VPACKSSDWZ128rmb_VPACKSSDWZ128rmbk_VPACKSSDWZ128rmbkz_VPACKSSDWZ128rmk_VPACKSSDWZ128rmkz_VPACKSSDWrm_VPACKSSWBZ128rm_VPACKSSWBZ128rmk_VPACKSSWBZ128rmkz_VPACKSSWBrm_VPACKUSDWZ128rm_VPACKUSDWZ128rmb_VPACKUSDWZ128rmbk_VPACKUSDWZ128rmbkz_VPACKUSDWZ128rmk_VPACKUSDWZ128rmkz_VPACKUSDWrm_VPACKUSWBZ128rm_VPACKUSWBZ128rmk_VPACKUSWBZ128rmkz_VPACKUSWBrm") 2, false, false, false, 53, 7,  7, 1,  6, 1}, // #1430
  {DBGFIELD("VPACKSSDWYrm_VPACKSSDWZ256rm_VPACKSSDWZ256rmb_VPACKSSDWZ256rmbk_VPACKSSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSDWZ256rmkz_VPACKSSWBYrm_VPACKSSWBZ256rm_VPACKSSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSDWYrm_VPACKUSDWZ256rm_VPACKUSDWZ256rmb_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmbkz_VPACKUSDWZ256rmk_VPACKUSDWZ256rmkz_VPACKUSWBYrm_VPACKUSWBZ256rm_VPACKUSWBZ256rmk_VPACKUSWBZ256rmkz") 2, false, false, false, 53, 7, 22, 1,  6, 1}, // #1431
  {DBGFIELD("VPACKSSDWZrm_VPACKSSDWZrmb_VPACKSSDWZrmbk_VPACKSSDWZrmbkz_VPACKSSDWZrmk_VPACKSSDWZrmkz_VPACKSSWBZrm_VPACKSSWBZrmk_VPACKSSWBZrmkz_VPACKUSDWZrm_VPACKUSDWZrmb_VPACKUSDWZrmbk_VPACKUSDWZrmbkz_VPACKUSDWZrmk_VPACKUSDWZrmkz_VPACKUSWBZrm_VPACKUSWBZrmk_VPACKUSWBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1432
  {DBGFIELD("AADD64mr_AAND64mr_AOR64mr_AXOR64mr") 3, false, false, false, 1615, 8,  6, 1,  0, 0}, // #1433
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT") 2, false, false, false, 163, 6,  3, 1,  0, 0}, // #1434
  {DBGFIELD("RET16")              2, false, false, false, 163, 6,  3, 1,  0, 0}, // #1435
  {DBGFIELD("RORX32mi_RORX64mi")  2, false, false, false, 163, 6,  3, 1,  0, 0}, // #1436
  {DBGFIELD("ADC16rm_ADC32rm_ADC64rm_ADC8rm_SBB16rm_SBB32rm_SBB64rm_SBB8rm_ADCX32rm_ADCX64rm_ADOX32rm_ADOX64rm") 2, false, false, false, 163, 6,  3, 1, 12, 2}, // #1437
  {DBGFIELD("ADC8mi_ADC8mi8_SBB8mi_SBB8mi8") 5, false, false, false, 45, 8, 24, 1,  0, 0}, // #1438
  {DBGFIELD("CMP16mi_CMP32mi_CMP8mi_CMP16mi8_CMP32mi8_CMP64mi8_CMP8mi8") 2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1439
  {DBGFIELD("MOV8rm")             2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1440
  {DBGFIELD("POP16rmr_POP32rmr")  2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1441
  {DBGFIELD("POP32r")             2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1442
  {DBGFIELD("CMP64mi32")          2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1443
  {DBGFIELD("MOV8rm_NOREX")       2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1444
  {DBGFIELD("MOVZX16rm8")         2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1445
  {DBGFIELD("ADD16rm_ADD32rm_ADD64rm_ADD8rm_CMP16rm_CMP32rm_CMP64rm_CMP8rm_SUB16rm_SUB32rm_SUB64rm_SUB8rm_AND16rm_AND32rm_AND8rm_OR16rm_OR32rm_OR8rm_XOR16rm_XOR32rm_XOR8rm") 2, false, false, false, 71, 3,  3, 1,  1, 1}, // #1446
  {DBGFIELD("CMP16mr_CMP32mr_CMP64mr_CMP8mr") 2, false, false, false, 71, 3,  3, 1,  1, 1}, // #1447
  {DBGFIELD("ADD64ri8_SUB64ri8_DEC64r_INC64r") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1448
  {DBGFIELD("MOV64rr_MOV64rr_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1449
  {DBGFIELD("JMP_2")              0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1450
  {DBGFIELD("ADD8mi_ADD8mi8_SUB8mi_SUB8mi8") 4, false, false, false, 40, 5, 24, 1,  0, 0}, // #1451
  {DBGFIELD("AND8mi_AND8mi8_OR8mi_OR8mi8_XOR8mi_XOR8mi8") 4, false, false, false, 40, 5, 24, 1,  0, 0}, // #1452
  {DBGFIELD("DEC8m_INC8m_NEG8m_NOT8m") 4, false, false, false, 40, 5, 24, 1,  0, 0}, // #1453
  {DBGFIELD("ADD8mr")             4, false, false, false, 40, 5, 24, 1,  1, 1}, // #1454
  {DBGFIELD("AND8mr_OR8mr_XOR8mr") 4, false, false, false, 40, 5, 24, 1,  1, 1}, // #1455
  {DBGFIELD("SUB8mr")             4, false, false, false, 40, 5, 24, 1,  1, 1}, // #1456
  {DBGFIELD("ADDSSrr_ADDSSrr_Int_SUBSSrr_SUBSSrr_Int_VADDSSrr_VADDSSrr_Int_VSUBSSrr_VSUBSSrr_Int") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1457
  {DBGFIELD("AND16ri8_AND16rr_AND32ri8_AND32rr_AND64ri8_AND64rr_AND8ri8_AND8rr_AND16rr_REV_AND32rr_REV_AND64rr_REV_AND8rr_REV_TEST32i32_TEST64i32_AND32ri_AND8ri_TEST32ri_TEST8ri_AND64ri32_TEST64ri32_TEST8i8_OR16ri8_OR16rr_OR32ri8_OR32rr_OR64ri8_OR64rr_OR8ri8_OR8rr_XOR16ri8_XOR16rr_XOR32ri8_XOR64ri8_XOR8ri8_XOR8rr_OR16rr_REV_OR32rr_REV_OR64rr_REV_OR8rr_REV_XOR16rr_REV_XOR8rr_REV_OR32ri_OR8ri_XOR32ri_XOR8ri_OR64ri32_XOR64ri32_TEST16rr_TEST32rr_TEST64rr_TEST8rr") 1, false, false, false,  1, 1, 12, 1,  0, 0}, // #1458
  {DBGFIELD("AND32i32_AND64i32_AND8i8_OR32i32_OR64i32_XOR32i32_XOR64i32_OR8i8_XOR8i8") 1, false, false, false,  1, 1, 12, 1,  0, 0}, // #1459
  {DBGFIELD("XOR32rr_XOR64rr")    1, false, false, false,  1, 1, 12, 1,  0, 0}, // #1460
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV") 1, false, false, false,  1, 1, 12, 1,  0, 0}, // #1461
  {DBGFIELD("XOR8rr_NOREX")       1, false, false, false,  1, 1, 12, 1,  0, 0}, // #1462
  {DBGFIELD("TEST16mi_TEST32mi_TEST8mi") 2, false, false, false, 71, 3,  6, 1,  0, 0}, // #1463
  {DBGFIELD("TEST64mi32")         2, false, false, false, 71, 3,  6, 1,  0, 0}, // #1464
  {DBGFIELD("OR64rm_XOR64rm")     2, false, false, false, 71, 3,  6, 1,  1, 1}, // #1465
  {DBGFIELD("AND64rm")            2, false, false, false, 71, 3,  6, 1,  1, 1}, // #1466
  {DBGFIELD("TEST16mr_TEST32mr_TEST64mr_TEST8mr") 2, false, false, false, 71, 3,  6, 1,  1, 1}, // #1467
  {DBGFIELD("ANDN32rm_ANDN64rm")  2, false, false, false, 115, 4,  6, 1,  1, 1}, // #1468
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, false, 115, 2, 12, 1,  0, 0}, // #1469
  {DBGFIELD("BT64mr")             9, false, false, false, 1623, 11,  9, 1,  0, 0}, // #1470
  {DBGFIELD("BT64rr")             1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1471
  {DBGFIELD("BTC64rr_BTR64rr_BTS64rr") 1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1472
  {DBGFIELD("BTC64mr_BTR64mr_BTS64mr") 10, false, false, false, 1634, 13, 20, 1,  0, 0}, // #1473
  {DBGFIELD("CALL64m_CALL64m_NT") 5, false, false, false, 45, 8,  6, 1,  0, 0}, // #1474
  {DBGFIELD("CALL64r_CALL64r_NT") 3, false, false, false, 1214, 7,  5, 1,  0, 0}, // #1475
  {DBGFIELD("CDQE_CWDE")          1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1476
  {DBGFIELD("MOVSHDUPrr_MOVSLDUPrr_VMOVSHDUPrr_VMOVSLDUPrr_SHUFPDrri_SHUFPSrri_VSHUFPDrri_VSHUFPSrri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1477
  {DBGFIELD("VMOVSHDUPYrr_VMOVSLDUPYrr_VSHUFPDYrri_VSHUFPSYrri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1478
  {DBGFIELD("VPBLENDWYrri")       1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1479
  {DBGFIELD("CLFLUSH")            4, false, false, false, 1647, 7, 12, 1,  0, 0}, // #1480
  {DBGFIELD("CLTS")               10, false, false, false, 1654, 11,  4, 1,  0, 0}, // #1481
  {DBGFIELD("MOV16o16a_MOV16o32a_MOV16o64a") 3, false, false, false, 646, 4, 10, 1,  0, 0}, // #1482
  {DBGFIELD("CLWB")               3, false, false, false, 646, 4, 10, 1,  0, 0}, // #1483
  {DBGFIELD("CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SIrm") 3, false, false, false, 203, 10, 80, 1,  0, 0}, // #1484
  {DBGFIELD("VCVTTSD2SIrm_Int")   3, false, false, false, 203, 10, 80, 1,  0, 0}, // #1485
  {DBGFIELD("VCVTSI642SSrm_Int")  3, false, false, false, 192, 11,  2, 1,  6, 1}, // #1486
  {DBGFIELD("VCVTSI642SSrm")      3, false, false, false, 192, 11,  2, 1,  6, 1}, // #1487
  {DBGFIELD("VCVTSI642SSrr_Int")  3, false, false, false, 674, 9,  7, 1,  7, 1}, // #1488
  {DBGFIELD("JECXZ_JRCXZ")        2, false, false, false, 45, 4, 12, 1,  0, 0}, // #1489
  {DBGFIELD("ST_Frr")             1, false, false, false,  5, 2,  1, 1,  0, 0}, // #1490
  {DBGFIELD("MOV16sr_MOV32sr")    1, false, false, false,  5, 2,  1, 1,  0, 0}, // #1491
  {DBGFIELD("DEC16r_alt_SALC")    1, false, false, false,  5, 2,  1, 1,  0, 0}, // #1492
  {DBGFIELD("SYSCALL")            1, false, false, false,  5, 2,  1, 1,  0, 0}, // #1493
  {DBGFIELD("DEC32r_alt")         1, false, false, false, 567, 8,  6, 1,  0, 0}, // #1494
  {DBGFIELD("DIVR_FPrST0_DIVR_FrST0") 1, false, false, false,  2, 8, 11, 1,  0, 0}, // #1495
  {DBGFIELD("DIVSDrm_Int_VDIVSDrm_Int") 2, false, false, false, 173, 10, 15, 1,  6, 1}, // #1496
  {DBGFIELD("DIV_FPrST0_DIV_FrST0") 1, false, false, false,  2, 8, 15, 1,  0, 0}, // #1497
  {DBGFIELD("SMSW16m")            3, false, false, false, 1037, 11,  2, 1,  0, 0}, // #1498
  {DBGFIELD("MMX_PEXTRWrr")       2, false, false, false, 441, 11, 14, 1,  0, 0}, // #1499
  {DBGFIELD("MMX_PADDBrr_MMX_PADDDrr_MMX_PADDWrr") 1, false, false, false,  4, 5,  1, 1,  0, 0}, // #1500
  {DBGFIELD("GF2P8AFFINEINVQBrmi_GF2P8AFFINEQBrmi_VGF2P8AFFINEINVQBrmi_VGF2P8AFFINEQBrmi") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #1501
  {DBGFIELD("GF2P8MULBrm_VGF2P8MULBrm") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #1502
  {DBGFIELD("VGF2P8AFFINEINVQBYrmi_VGF2P8AFFINEQBYrmi") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #1503
  {DBGFIELD("VGF2P8MULBYrm")      2, false, false, false, 68, 6,  2, 1,  6, 1}, // #1504
  {DBGFIELD("GF2P8MULBrr_VGF2P8MULBrr") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1505
  {DBGFIELD("VGF2P8MULBYrr")      1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1506
  {DBGFIELD("IN16ri")             87, false, false, false, 1665, 14, 55, 1,  0, 0}, // #1507
  {DBGFIELD("IN16rr")             87, false, false, false, 1679, 14, 55, 1,  0, 0}, // #1508
  {DBGFIELD("IN32ri")             94, false, false, false, 1693, 14, 55, 1,  0, 0}, // #1509
  {DBGFIELD("IN32rr")             99, false, false, false, 1707, 14,  1, 1,  0, 0}, // #1510
  {DBGFIELD("INC16r_alt")         4, false, false, false, 10, 4,  1, 1,  0, 0}, // #1511
  {DBGFIELD("INC32r_alt")         1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1512
  {DBGFIELD("INSB")               83, false, false, false, 1721, 16, 15, 1,  0, 0}, // #1513
  {DBGFIELD("INSL")               92, false, false, false, 1737, 16, 15, 1,  0, 0}, // #1514
  {DBGFIELD("INVLPG")             42, false, false, false, 1753, 15,  4, 1,  0, 0}, // #1515
  {DBGFIELD("JMP64r_REX")         1, false, false, false, 1768, 5,  1, 1,  0, 0}, // #1516
  {DBGFIELD("JMP_1_JMP_4")        0, false, false, false,  0, 0,  0, 1,  0, 0}, // #1517
  {DBGFIELD("LAR16rm")            81, false, false, false, 1773, 14, 81, 1,  0, 0}, // #1518
  {DBGFIELD("LAR16rr")            22, false, false, false, 1248, 14, 82, 1,  0, 0}, // #1519
  {DBGFIELD("LAR32rm")            85, false, false, false, 1787, 14, 83, 1,  0, 0}, // #1520
  {DBGFIELD("LAR64rm")            87, false, false, false, 1787, 14, 83, 1,  0, 0}, // #1521
  {DBGFIELD("LEAVE")              4, false, false, false, 640, 3,  3, 1,  0, 0}, // #1522
  {DBGFIELD("LGDT64m")            14, false, false, false, 1801, 15,  4, 1,  0, 0}, // #1523
  {DBGFIELD("LIDT64m")            14, false, false, false, 1816, 14,  4, 1,  0, 0}, // #1524
  {DBGFIELD("LLDT16m")            12, false, false, false, 1830, 13,  4, 1,  0, 0}, // #1525
  {DBGFIELD("LLDT16r")            11, false, false, false, 1843, 13,  4, 1,  0, 0}, // #1526
  {DBGFIELD("LMSW16m")            27, false, false, false, 1856, 16,  4, 1,  0, 0}, // #1527
  {DBGFIELD("LMSW16r")            22, false, false, false, 1872, 14,  4, 1,  0, 0}, // #1528
  {DBGFIELD("MMX_MOVD64mr")       2, false, false, false, 37, 3, 13, 1,  0, 0}, // #1529
  {DBGFIELD("MMX_MOVD64rm_MMX_MOVQ64rm") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1530
  {DBGFIELD("MMX_MOVD64to64rm")   1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1531
  {DBGFIELD("MMX_MOVFR642Qrr")    2, false, false, false, 184, 5,  5, 1,  0, 0}, // #1532
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm") 3, false, false, false, 1230, 10,  2, 1,  6, 1}, // #1533
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr") 2, false, false, false, 1240, 8, 14, 1,  0, 0}, // #1534
  {DBGFIELD("MMX_PINSRWrr")       2, false, false, false, 1240, 8, 14, 1,  7, 1}, // #1535
  {DBGFIELD("MMX_PADDBrm_MMX_PADDDrm_MMX_PADDWrm_MMX_PSUBBrm_MMX_PSUBDrm_MMX_PSUBWrm") 2, false, false, false, 395, 7, 22, 1,  6, 1}, // #1536
  {DBGFIELD("MMX_PINSRWrm")       2, false, false, false, 375, 10, 22, 1,  1, 1}, // #1537
  {DBGFIELD("VPALIGNRYrmi")       2, false, false, false, 375, 10, 22, 1,  6, 1}, // #1538
  {DBGFIELD("MOV16ao16_MOV16ao32_MOV16ao64") 2, false, false, false, 71, 3, 10, 1,  0, 0}, // #1539
  {DBGFIELD("PUSHFS16_PUSHFS32_PUSHGS16_PUSHGS32") 3, false, false, false, 30, 10,  2, 1,  0, 0}, // #1540
  {DBGFIELD("MOV16ms")            3, false, false, false, 30, 10,  2, 1,  0, 0}, // #1541
  {DBGFIELD("MOVBE32mr")          3, false, false, false, 30, 10,  2, 1,  0, 0}, // #1542
  {DBGFIELD("MOV16rs_MOV32rs_MOV64rs") 2, false, false, false, 333, 7,  1, 1,  0, 0}, // #1543
  {DBGFIELD("SLDT16r")            2, false, false, false, 333, 7,  1, 1,  0, 0}, // #1544
  {DBGFIELD("STR16r")             2, false, false, false, 333, 7,  1, 1,  0, 0}, // #1545
  {DBGFIELD("MOV32ao16_MOV32ao32_MOV32ao64") 1, false, false, false, 28, 2,  1, 1,  0, 0}, // #1546
  {DBGFIELD("MOV64ao64")          1, false, false, false, 28, 2,  1, 1,  0, 0}, // #1547
  {DBGFIELD("MOV32o16a_MOV32o32a_MOV8o16a_MOV8o32a_MOV32o64a_MOV64o64a_MOV8o64a") 3, false, false, false, 646, 4,  1, 1,  0, 0}, // #1548
  {DBGFIELD("MOVZX32rr8_MOVZX64rr8") 1, false, false, false,  1, 1,  0, 1,  0, 0}, // #1549
  {DBGFIELD("MOVZX32rr8_NOREX")   1, false, false, false,  1, 1,  0, 1,  0, 0}, // #1550
  {DBGFIELD("MOV64ao32")          1, false, false, false, 28, 2, 10, 1,  0, 0}, // #1551
  {DBGFIELD("MOV64dr")            48, false, false, false, 1886, 14, 84, 1,  0, 0}, // #1552
  {DBGFIELD("MOV64o32a")          2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1553
  {DBGFIELD("MOV64rc")            3, false, false, false, 1900, 9,  4, 1,  0, 0}, // #1554
  {DBGFIELD("MOV64rd")            24, false, false, false, 1909, 11, 85, 1,  0, 0}, // #1555
  {DBGFIELD("MOV8ao16_MOV8ao32_MOV8ao64") 2, false, false, false, 71, 3,  1, 1,  0, 0}, // #1556
  {DBGFIELD("MOV8mi_MOV8mr")      2, false, false, false, 37, 3, 24, 1,  0, 0}, // #1557
  {DBGFIELD("MOV8mr_NOREX")       2, false, false, false, 37, 3, 24, 1,  0, 0}, // #1558
  {DBGFIELD("MOVBE32rm")          2, false, false, false, 119, 9,  3, 1,  0, 0}, // #1559
  {DBGFIELD("SLDT16m")            4, false, false, false, 1052, 12,  2, 1,  0, 0}, // #1560
  {DBGFIELD("STRm")               4, false, false, false, 1052, 12,  2, 1,  0, 0}, // #1561
  {DBGFIELD("MOVDIR64B16_MOVDIR64B32_MOVDIR64B64") 4, false, false, false, 567, 8,  1, 1,  0, 0}, // #1562
  {DBGFIELD("MOVDIRI32")          2, false, false, false, 37, 3, 25, 1,  0, 0}, // #1563
  {DBGFIELD("MOVDIRI64")          2, false, false, false, 37, 3, 86, 1,  0, 0}, // #1564
  {DBGFIELD("MOVLPDrm_MOVLPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, false, 53, 7,  7, 1,  6, 1}, // #1565
  {DBGFIELD("SHUFPDrmi_SHUFPSrmi_VSHUFPDrmi_VSHUFPSrmi") 2, false, false, false, 53, 7,  7, 1,  6, 1}, // #1566
  {DBGFIELD("MOVNTDQmr")          2, false, false, false, 37, 3, 26, 1,  0, 0}, // #1567
  {DBGFIELD("MOVNTImr")           2, false, false, false, 37, 3, 27, 1,  0, 0}, // #1568
  {DBGFIELD("MOVSB")              7, false, false, false, 698, 5,  7, 1,  0, 0}, // #1569
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1570
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32") 1, false, false, false, 28, 2,  3, 1,  0, 0}, // #1571
  {DBGFIELD("MOVSX32rm16_MOVSX32rm32_MOVSX64rm16_MOVSX64rm32_MOVSX32rm8_MOVSX64rm8") 1, false, false, false, 28, 2,  3, 1,  0, 0}, // #1572
  {DBGFIELD("MOVSX32rm8_NOREX")   1, false, false, false, 28, 2,  3, 1,  0, 0}, // #1573
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32") 1, false, false, false, 115, 2,  1, 1,  0, 0}, // #1574
  {DBGFIELD("MOVSX16rr8")         1, false, false, false, 115, 2,  1, 1,  0, 0}, // #1575
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX64rr16_MOVSX64rr8") 1, false, false, false, 115, 2,  1, 1,  0, 0}, // #1576
  {DBGFIELD("MOVSX32rr8_NOREX")   1, false, false, false, 115, 2,  1, 1,  0, 0}, // #1577
  {DBGFIELD("MUL_FPrST0_MUL_FrST0") 1, false, false, false,  2, 8, 14, 1,  0, 0}, // #1578
  {DBGFIELD("OUT16ir")            79, false, false, false, 1920, 16, 55, 1,  0, 0}, // #1579
  {DBGFIELD("OUT16rr")            79, false, false, false, 1936, 16, 55, 1,  0, 0}, // #1580
  {DBGFIELD("OUT32ir")            85, false, false, false, 1952, 16, 55, 1,  0, 0}, // #1581
  {DBGFIELD("OUT32rr")            85, false, false, false, 1968, 16, 55, 1,  0, 0}, // #1582
  {DBGFIELD("OUTSB")              80, false, false, false, 1984, 16,  4, 1,  0, 0}, // #1583
  {DBGFIELD("OUTSL")              89, false, false, false, 2000, 16,  4, 1,  0, 0}, // #1584
  {DBGFIELD("PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWrm_VPACKSSWBrm_VPACKUSDWrm_VPACKUSWBrm") 2, false, false, false, 375, 10,  9, 1,  6, 1}, // #1585
  {DBGFIELD("PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWrr_VPACKSSWBrr_VPACKUSDWrr_VPACKUSWBrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1586
  {DBGFIELD("PALIGNRrmi_VPALIGNRrmi") 2, false, false, false, 375, 10,  7, 1,  6, 1}, // #1587
  {DBGFIELD("PALIGNRrri_VPALIGNRrri") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1588
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 2, false, false, false, 119, 9,  7, 1,  1, 1}, // #1589
  {DBGFIELD("PREFETCHIT0_PREFETCHIT1") 1, false, false, false, 26, 4, 10, 1,  0, 0}, // #1590
  {DBGFIELD("PREFETCHT0_PREFETCHT1_PREFETCHT2") 1, false, false, false, 28, 2,  0, 1,  0, 0}, // #1591
  {DBGFIELD("PREFETCHNTA")        1, false, false, false, 28, 2,  0, 1,  0, 0}, // #1592
  {DBGFIELD("PTWRITE64m_PTWRITEm") 4, false, false, false, 2016, 7,  4, 1,  0, 0}, // #1593
  {DBGFIELD("PTWRITE64r")         3, false, false, false, 2023, 5,  4, 1,  0, 0}, // #1594
  {DBGFIELD("PTWRITEr")           4, false, false, false, 2028, 5,  4, 1,  0, 0}, // #1595
  {DBGFIELD("PUSH64r")            2, false, false, false, 37, 3,  1, 1,  0, 0}, // #1596
  {DBGFIELD("PUSH64rmr")          2, false, false, false, 37, 3,  1, 1,  0, 0}, // #1597
  {DBGFIELD("RCL8m1_RCR8m1")      6, false, false, false, 14, 8, 58, 2,  0, 0}, // #1598
  {DBGFIELD("RCL8mi")             6, false, false, false, 14, 8, 58, 2,  0, 0}, // #1599
  {DBGFIELD("RCR8mi")             6, false, false, false, 14, 8, 58, 2,  0, 0}, // #1600
  {DBGFIELD("RCL8mCL")            11, false, false, false, 2033, 13, 87, 2,  0, 0}, // #1601
  {DBGFIELD("RCR8mCL")            12, false, false, false, 2046, 13, 87, 2,  0, 0}, // #1602
  {DBGFIELD("RDPID64")            1, false, false, false, 30, 7,  4, 1,  0, 0}, // #1603
  {DBGFIELD("RDPKRUr")            3, false, false, false, 342, 9,  4, 1,  0, 0}, // #1604
  {DBGFIELD("RDRAND16r")          25, false, false, false, 1190, 14, 89, 1,  0, 0}, // #1605
  {DBGFIELD("RDSEED16r")          25, false, false, false, 2059, 14, 90, 1,  0, 0}, // #1606
  {DBGFIELD("RDSEED32r_RDSEED64r") 25, false, false, false, 2059, 14,  4, 1,  0, 0}, // #1607
  {DBGFIELD("REX64_PREFIX")       1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1608
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi") 5, false, false, false, 575, 8, 33, 2,  0, 0}, // #1609
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROR16mCL_ROR32mCL_ROR64mCL") 5, false, false, false, 575, 8, 33, 2,  0, 0}, // #1610
  {DBGFIELD("ROL16ri_ROL32ri_ROL64ri_ROL8ri_ROR16ri_ROR32ri_ROR64ri_ROR8ri") 2, false, false, false, 563, 4,  1, 1,  0, 0}, // #1611
  {DBGFIELD("ROL8m1_ROL8mi_ROR8m1_ROR8mi") 5, false, false, false, 575, 8, 58, 2,  0, 0}, // #1612
  {DBGFIELD("ROL8mCL_ROR8mCL")    5, false, false, false, 575, 8, 58, 2,  0, 0}, // #1613
  {DBGFIELD("SHL8mCL_SAR8mCL_SHR8mCL") 5, false, false, false, 575, 8, 58, 2,  0, 0}, // #1614
  {DBGFIELD("SAR8m1_SAR8mi_SHR8m1_SHR8mi_SHL8m1_SHL8mi") 4, false, false, false, 567, 8, 58, 2,  0, 0}, // #1615
  {DBGFIELD("SARX32rm_SARX64rm_SHRX32rm_SHRX64rm_SHLX32rm_SHLX64rm") 2, false, false, false, 163, 6,  7, 1,  1, 1}, // #1616
  {DBGFIELD("SARX32rr_SARX64rr_SHRX32rr_SHRX64rr_SHLX32rr_SHLX64rr") 1, false, false, false, 10, 4,  5, 1,  0, 0}, // #1617
  {DBGFIELD("SERIALIZE")          7, false, false, false, 2073, 12,  4, 1,  0, 0}, // #1618
  {DBGFIELD("SHRD16mri8")         5, false, false, false, 607, 11, 24, 1,  0, 0}, // #1619
  {DBGFIELD("SMSW16r")            2, false, false, false, 2085, 8,  1, 1,  0, 0}, // #1620
  {DBGFIELD("SMSW32r_SMSW64r")    2, false, false, false, 2085, 8,  4, 1,  0, 0}, // #1621
  {DBGFIELD("SQRTSDm_Int_VSQRTSDm_Int") 2, false, false, false, 173, 10, 41, 1,  6, 1}, // #1622
  {DBGFIELD("STI")                6, false, false, false, 2093, 9,  4, 1,  0, 0}, // #1623
  {DBGFIELD("STOSB")              4, false, false, false, 1048, 4,  7, 1,  0, 0}, // #1624
  {DBGFIELD("VBLENDVPDrm_VBLENDVPSrm") 4, false, false, false, 638, 5, 22, 1, 10, 2}, // #1625
  {DBGFIELD("VPBLENDVBrm")        4, false, false, false, 638, 5, 22, 1, 10, 2}, // #1626
  {DBGFIELD("VBLENDVPDrr_VBLENDVPSrr") 3, false, false, false, 223, 3,  5, 1,  0, 0}, // #1627
  {DBGFIELD("VPBLENDVBrr")        3, false, false, false, 223, 3,  5, 1,  0, 0}, // #1628
  {DBGFIELD("VERRm")              31, false, false, false, 2102, 13, 57, 1,  0, 0}, // #1629
  {DBGFIELD("VERRr")              30, false, false, false, 2115, 13, 91, 1,  0, 0}, // #1630
  {DBGFIELD("VERWr")              33, false, false, false, 2128, 13, 91, 1,  0, 0}, // #1631
  {DBGFIELD("VHADDPDrr_VHADDPSrr_VHSUBPDrr_VHSUBPSrr") 3, false, false, false, 314, 8, 10, 1,  0, 0}, // #1632
  {DBGFIELD("VLDMXCSR")           3, false, false, false, 2141, 10,  6, 1,  0, 0}, // #1633
  {DBGFIELD("VMOVMSKPDYrr_VMOVMSKPSYrr") 1, false, false, false,  2, 8, 10, 1,  0, 0}, // #1634
  {DBGFIELD("VMOVNTDQmr")         2, false, false, false, 37, 3, 92, 1,  0, 0}, // #1635
  {DBGFIELD("VMOVNTPDmr")         2, false, false, false, 37, 3, 93, 1,  0, 0}, // #1636
  {DBGFIELD("VMOVNTPSYmr")        2, false, false, false, 37, 3, 94, 1,  0, 0}, // #1637
  {DBGFIELD("VMOVNTPSmr")         2, false, false, false, 37, 3, 95, 1,  0, 0}, // #1638
  {DBGFIELD("VPACKSSDWYrm_VPACKSSWBYrm_VPACKUSDWYrm_VPACKUSWBYrm") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1639
  {DBGFIELD("VPCLMULQDQYrm")      2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1640
  {DBGFIELD("VSHUFPDYrmi_VSHUFPSYrmi") 2, false, false, false, 53, 7, 22, 1,  6, 1}, // #1641
  {DBGFIELD("VPBLENDWYrmi")       2, false, false, false, 53, 7, 22, 1,  6, 1}, // #1642
  {DBGFIELD("WRPKRUr")            8, false, false, false, 2151, 11,  4, 1,  0, 0}, // #1643
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm") 5, false, false, false, 1101, 5, 33, 2,  0, 0}, // #1644
  {DBGFIELD("XCHG16rm")           8, false, false, false, 1518, 8, 49, 2,  0, 0}, // #1645
  {DBGFIELD("XCHG32rm")           8, false, false, false, 1518, 8, 49, 2,  0, 0}, // #1646
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS") 31, false, false, false, 1307, 14, 62, 1,  0, 0}, // #1647
  {DBGFIELD("XSAVEC")             151, false, false, false, 2162, 16, 52, 1,  0, 0}, // #1648
  {DBGFIELD("XSAVEC64")           152, false, false, false, 2178, 16, 52, 1,  0, 0}, // #1649
  {DBGFIELD("XSAVEOPT")           155, false, false, false, 2194, 15, 66, 1,  0, 0}, // #1650
  {DBGFIELD("XSAVES")             184, false, false, false, 2209, 15, 52, 1,  0, 0}, // #1651
  {DBGFIELD("VMOVAPDZrr_VMOVAPDZrr_REV_VMOVAPSZrr_VMOVAPSZrr_REV_VMOVUPDZrr_VMOVUPDZrr_REV_VMOVUPSZrr_VMOVUPSZrr_REV") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1652
  {DBGFIELD("VMOVDQA32Z256rr_VMOVDQA32Z256rr_REV_VMOVDQA64Z256rr_VMOVDQA64Z256rr_REV_VMOVDQAYrr_VMOVDQAYrr_REV_VMOVDQUYrr_VMOVDQUYrr_REV_VMOVDQU16Z256rr_VMOVDQU16Z256rr_REV_VMOVDQU32Z256rr_VMOVDQU32Z256rr_REV_VMOVDQU64Z256rr_VMOVDQU64Z256rr_REV_VMOVDQU8Z256rr_VMOVDQU8Z256rr_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1653
  {DBGFIELD("VMOVDQA32Zrr_VMOVDQA32Zrr_REV_VMOVDQA64Zrr_VMOVDQA64Zrr_REV_VMOVDQU16Zrr_VMOVDQU16Zrr_REV_VMOVDQU32Zrr_VMOVDQU32Zrr_REV_VMOVDQU64Zrr_VMOVDQU64Zrr_REV_VMOVDQU8Zrr_VMOVDQU8Zrr_REV") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1654
  {DBGFIELD("ADDPSrm_SUBPSrm_VADDPSrm_VSUBPSrm_ADDSUBPSrm_VADDSUBPSrm_VADDPSZ128rm_VADDPSZ128rmb_VADDPSZ128rmbk_VADDPSZ128rmk_VADDPSZ128rmkz_VSUBPSZ128rm_VSUBPSZ128rmb_VSUBPSZ128rmbk_VSUBPSZ128rmk_VSUBPSZ128rmkz_VADDPSZ128rmbkz_VSUBPSZ128rmbkz") 2, false, false, false, 53, 7,  9, 1,  6, 1}, // #1655
  {DBGFIELD("ADDPSrr_SUBPSrr_VADDPSrr_VSUBPSrr_ADDSUBPSrr_VADDSUBPSrr_VADDPSZ128rr_VADDPSZ128rrk_VSUBPSZ128rr_VSUBPSZ128rrk") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1656
  {DBGFIELD("VADDPSYrr_VSUBPSYrr_VADDPSZ256rr_VADDPSZ256rrk_VSUBPSZ256rr_VSUBPSZ256rrk") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1657
  {DBGFIELD("VPMOVSXBWZ128rrk_VPMOVSXBWZ128rrkz_VPMOVZXBWZ128rrk_VPMOVZXBWZ128rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1658
  {DBGFIELD("VPSHUFBZ128rrk_VPSHUFBZ128rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1659
  {DBGFIELD("VPSHUFBZ256rrk_VPSHUFBZ256rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1660
  {DBGFIELD("VPSHUFHWZ128rik_VPSHUFHWZ128rikz_VPSHUFLWZ128rik_VPSHUFLWZ128rikz_VPUNPCKHBWZ128rrk_VPUNPCKHBWZ128rrkz_VPUNPCKHWDZ128rrk_VPUNPCKHWDZ128rrkz_VPUNPCKLBWZ128rrk_VPUNPCKLBWZ128rrkz_VPUNPCKLWDZ128rrk_VPUNPCKLWDZ128rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1661
  {DBGFIELD("VPSHUFHWZ256rik_VPSHUFHWZ256rikz_VPSHUFLWZ256rik_VPSHUFLWZ256rikz_VPUNPCKHBWZ256rrk_VPUNPCKHBWZ256rrkz_VPUNPCKHWDZ256rrk_VPUNPCKHWDZ256rrkz_VPUNPCKLBWZ256rrk_VPUNPCKLBWZ256rrkz_VPUNPCKLWDZ256rrk_VPUNPCKLWDZ256rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1662
  {DBGFIELD("VADDSUBPSYrr")       1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1663
  {DBGFIELD("VPOPCNTBZ128rm_VPOPCNTDZ128rm_VPOPCNTQZ128rm_VPOPCNTWZ128rm_VPOPCNTDZ128rmb_VPOPCNTDZ128rmk_VPOPCNTDZ128rmkz_VPOPCNTQZ128rmb_VPOPCNTQZ128rmk_VPOPCNTQZ128rmkz_VPOPCNTDZ128rmbk_VPOPCNTDZ128rmbkz_VPOPCNTQZ128rmbk_VPOPCNTQZ128rmbkz") 2, false, false, false, 68, 6,  7, 1,  0, 0}, // #1664
  {DBGFIELD("VFPCLASSPDZ128rmb_VFPCLASSPSZ128rmb") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1665
  {DBGFIELD("VFPCLASSPHZ128rmb")  2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1666
  {DBGFIELD("VPACKSSDWZ128rm_VPACKSSWBZ128rm_VPACKUSDWZ128rm_VPACKUSWBZ128rm_VPACKSSDWZ128rmb_VPACKUSDWZ128rmb") 2, false, false, false, 53, 7,  7, 1,  6, 1}, // #1667
  {DBGFIELD("VPMULTISHIFTQBZ128rm_VPMULTISHIFTQBZ128rmb") 2, false, false, false, 68, 6,  7, 1,  6, 1}, // #1668
  {DBGFIELD("VFPCLASSPHZ128rm")   2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1669
  {DBGFIELD("VFPCLASSPDZ256rm_VFPCLASSPSZ256rm") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #1670
  {DBGFIELD("VFPCLASSPDZrm_VFPCLASSPSZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1671
  {DBGFIELD("VFPCLASSPHZ256rm")   2, false, false, false, 68, 6,  2, 1,  6, 1}, // #1672
  {DBGFIELD("VFPCLASSPHZrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1673
  {DBGFIELD("VPERMBZ128rm")       2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1674
  {DBGFIELD("VPEXPANDBZ128rmk_VPEXPANDBZ128rmkz_VPEXPANDBZ256rmk_VPEXPANDBZ256rmkz_VPEXPANDWZ128rmk_VPEXPANDWZ128rmkz_VPEXPANDWZ256rmk_VPEXPANDWZ256rmkz_VPEXPANDBZrmk_VPEXPANDBZrmkz_VPEXPANDWZrmk_VPEXPANDWZrmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1675
  {DBGFIELD("ADD_FPrST0_ADD_FrST0_SUBR_FPrST0_SUBR_FrST0_SUB_FPrST0_SUB_FrST0_SUBR_FST0r_SUB_FST0r") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1676
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVWkr") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1677
  {DBGFIELD("VCMPPHZ128rri_VCMPPHZ128rrik_VFPCLASSPHZ128rr_VFPCLASSPHZ128rrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1678
  {DBGFIELD("VCMPPHZ256rri_VCMPPHZ256rrik_VFPCLASSPHZ256rr_VFPCLASSPHZ256rrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1679
  {DBGFIELD("VCMPSHZrr_VCMPSHZrr_Int_VCMPSHZrr_Intk_VCMPSHZrrb_Int_VCMPSHZrrb_Intk_VFPCLASSSHZrr_VFPCLASSSHZrrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1680
  {DBGFIELD("VPACKSSDWZ128rr_VPACKSSWBZ128rr_VPACKUSDWZ128rr_VPACKUSWBZ128rr") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1681
  {DBGFIELD("VPACKSSDWZ256rr_VPACKSSWBZ256rr_VPACKUSDWZ256rr_VPACKUSWBZ256rr") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1682
  {DBGFIELD("VPALIGNRZ128rrik_VPALIGNRZ128rrikz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1683
  {DBGFIELD("VPALIGNRZ256rrik_VPALIGNRZ256rrikz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1684
  {DBGFIELD("VPBROADCASTBZ128rrk_VPBROADCASTBZ128rrkz_VPBROADCASTWZ128rrk_VPBROADCASTWZ128rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1685
  {DBGFIELD("VPERMBZ128rr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1686
  {DBGFIELD("VPERMBZ256rr_VPERMDZ256rr_VPERMDZ256rrk_VPERMDZ256rrkz_VPERMQZ256rr_VPERMQZ256rrk_VPERMQZ256rrkz_VPERMI2DZ256rr_VPERMI2DZ256rrk_VPERMI2DZ256rrkz_VPERMI2QZ256rr_VPERMI2QZ256rrk_VPERMI2QZ256rrkz_VPERMT2DZ256rr_VPERMT2DZ256rrk_VPERMT2DZ256rrkz_VPERMT2QZ256rr_VPERMT2QZ256rrk_VPERMT2QZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1687
  {DBGFIELD("VPERMBZrr_VPERMDZrr_VPERMDZrrk_VPERMDZrrkz_VPERMI2DZrr_VPERMI2DZrrk_VPERMI2DZrrkz_VPERMI2QZrr_VPERMI2QZrrk_VPERMI2QZrrkz_VPERMT2DZrr_VPERMT2DZrrk_VPERMT2DZrrkz_VPERMT2QZrr_VPERMT2QZrrk_VPERMT2QZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1688
  {DBGFIELD("VPERMQZrr_VPERMQZrrk_VPERMQZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1689
  {DBGFIELD("VPERMI2DZ128rr_VPERMI2DZ128rrk_VPERMI2DZ128rrkz_VPERMI2QZ128rr_VPERMI2QZ128rrk_VPERMI2QZ128rrkz_VPERMT2DZ128rr_VPERMT2DZ128rrk_VPERMT2DZ128rrkz_VPERMT2QZ128rr_VPERMT2QZ128rrk_VPERMT2QZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1690
  {DBGFIELD("VPMULTISHIFTQBZ128rr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1691
  {DBGFIELD("VPMULTISHIFTQBZ256rr_VPOPCNTBZ256rr_VPOPCNTDZ256rr_VPOPCNTQZ256rr_VPOPCNTWZ256rr_VPOPCNTDZ256rrk_VPOPCNTDZ256rrkz_VPOPCNTQZ256rrk_VPOPCNTQZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1692
  {DBGFIELD("VPOPCNTBZ128rr_VPOPCNTDZ128rr_VPOPCNTQZ128rr_VPOPCNTWZ128rr_VPOPCNTDZ128rrk_VPOPCNTDZ128rrkz_VPOPCNTQZ128rrk_VPOPCNTQZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1693
  {DBGFIELD("VMOVSHDUPZ128rr_VMOVSHDUPZ128rrk_VMOVSHDUPZ128rrkz_VMOVSLDUPZ128rr_VMOVSLDUPZ128rrk_VMOVSLDUPZ128rrkz_VSHUFPDZ128rri_VSHUFPDZ128rrik_VSHUFPDZ128rrikz_VSHUFPSZ128rri_VSHUFPSZ128rrik_VSHUFPSZ128rrikz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1694
  {DBGFIELD("VMOVSHDUPZ256rr_VMOVSHDUPZ256rrk_VMOVSHDUPZ256rrkz_VMOVSLDUPZ256rr_VMOVSLDUPZ256rrk_VMOVSLDUPZ256rrkz_VSHUFPDZ256rri_VSHUFPDZ256rrik_VSHUFPDZ256rrikz_VSHUFPSZ256rri_VSHUFPSZ256rrik_VSHUFPSZ256rrikz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1695
  {DBGFIELD("VPMOVQDZ128rr_VPMOVQDZ128rrk_VPMOVQDZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1696
  {DBGFIELD("VCVTPD2DQZ128rm_VCVTPD2DQZ128rmb_VCVTPD2DQZ128rmbk_VCVTPD2DQZ128rmk_VCVTPD2DQZ128rmkz_VCVTPD2UDQZ128rm_VCVTPD2UDQZ128rmb_VCVTPD2UDQZ128rmbk_VCVTPD2UDQZ128rmk_VCVTPD2UDQZ128rmkz_VCVTTPD2DQZ128rm_VCVTTPD2DQZ128rmb_VCVTTPD2DQZ128rmbk_VCVTTPD2DQZ128rmk_VCVTTPD2DQZ128rmkz_VCVTTPD2UDQZ128rm_VCVTTPD2UDQZ128rmb_VCVTTPD2UDQZ128rmbk_VCVTTPD2UDQZ128rmk_VCVTTPD2UDQZ128rmkz_VCVTPD2DQZ128rmbkz_VCVTPD2UDQZ128rmbkz_VCVTTPD2DQZ128rmbkz_VCVTTPD2UDQZ128rmbkz") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1697
  {DBGFIELD("VCVTPH2PSXZ128rm_VCVTPH2PSXZ128rmb") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1698
  {DBGFIELD("VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz_VCVTQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmbkz") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1699
  {DBGFIELD("VCVTSI642SSZrm_VCVTSI642SSZrm_Int_VCVTUSI642SSZrm_VCVTUSI642SSZrm_Int") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1700
  {DBGFIELD("VCVTSD2SIZrm_VCVTTSD2SIZrm_VCVTSD2SIZrm_Int_VCVTTSD2SIZrm_Int") 3, false, false, false, 203, 10,  2, 1,  6, 1}, // #1701
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_Int") 3, false, false, false, 203, 10,  2, 1,  6, 1}, // #1702
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_Int_VCVTSI2SSZrr_VCVTUSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, false, 183, 9,  6, 1,  7, 1}, // #1703
  {DBGFIELD("VCVTSS2SI64Zrr_VCVTTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #1704
  {DBGFIELD("DIVSDrm_VDIVSDrm")   2, false, false, false, 173, 10, 17, 1,  6, 1}, // #1705
  {DBGFIELD("VDIVSDZrm")          2, false, false, false, 173, 10, 17, 1,  6, 1}, // #1706
  {DBGFIELD("VSQRTSHZm_Int_VSQRTSHZm_Intk_VSQRTSHZm_Intkz") 2, false, false, false, 173, 10, 17, 1,  6, 1}, // #1707
  {DBGFIELD("VSQRTSHZm")          2, false, false, false, 173, 10, 17, 1,  6, 1}, // #1708
  {DBGFIELD("ENQCMD16_ENQCMD32_ENQCMD64_ENQCMDS16_ENQCMDS32_ENQCMDS64") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1709
  {DBGFIELD("VPMOVQDZ256mr_VPMOVQDZmr") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1710
  {DBGFIELD("VEXTRACTPSZmr")      3, false, false, false, 261, 8, 17, 1,  0, 0}, // #1711
  {DBGFIELD("VEXTRACTPSZrr")      2, false, false, false, 269, 10, 14, 1,  0, 0}, // #1712
  {DBGFIELD("VPERMWZrr")          1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1713
  {DBGFIELD("VPEXPANDBZ256rm_VPEXPANDBZrm_VPEXPANDWZ256rm_VPEXPANDWZrm") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1714
  {DBGFIELD("VPADDBZrr_VPADDDZrr_VPADDQZrr_VPADDWZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrrk_VPADDQZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1715
  {DBGFIELD("VPLZCNTDZ256rm_VPLZCNTDZ256rmb_VPLZCNTDZ256rmbk_VPLZCNTDZ256rmk_VPLZCNTDZ256rmkz_VPLZCNTQZ256rm_VPLZCNTQZ256rmb_VPLZCNTQZ256rmbk_VPLZCNTQZ256rmk_VPLZCNTQZ256rmkz_VPLZCNTDZ256rmbkz_VPLZCNTQZ256rmbkz") 2, false, false, false, 68, 6, 24, 1,  0, 0}, // #1716
  {DBGFIELD("VADDPHZ128rm_VADDPHZ128rmb_VADDPHZ128rmbk_VADDPHZ128rmk_VADDPHZ128rmkz_VSUBPHZ128rm_VSUBPHZ128rmb_VSUBPHZ128rmbk_VSUBPHZ128rmk_VSUBPHZ128rmkz_VADDPHZ128rmbkz_VSUBPHZ128rmbkz") 2, false, false, false, 53, 7,  9, 1,  6, 1}, // #1717
  {DBGFIELD("VGETEXPPHZ128m_VGETEXPPHZ128mb_VGETEXPPHZ128mbk_VGETEXPPHZ128mk_VGETEXPPHZ128mkz_VGETEXPSHZm_VGETEXPSHZmk_VGETEXPSHZmkz_VGETMANTPHZ128rmbi_VGETMANTPHZ128rmik_VGETMANTPHZ128rmbik_VGETMANTPHZ128rmbikz_VGETMANTPHZ128rmi_VGETMANTPHZ128rmikz_VGETMANTSHZrmi_VGETMANTSHZrmik_VGETMANTSHZrmikz") 3, false, false, false, 74, 6, 11, 1,  6, 1}, // #1718
  {DBGFIELD("VGF2P8AFFINEINVQBZ128rmbi_VGF2P8AFFINEINVQBZ128rmi_VGF2P8AFFINEQBZ128rmbi_VGF2P8AFFINEQBZ128rmi") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #1719
  {DBGFIELD("VMAXCPHZ128rm_VMAXCPHZ128rmb_VMAXCPHZ128rmbk_VMAXCPHZ128rmk_VMAXCPHZ128rmkz_VMINCPHZ128rm_VMINCPHZ128rmb_VMINCPHZ128rmbk_VMINCPHZ128rmk_VMINCPHZ128rmkz_VMAXCPHZ128rmbkz_VMINCPHZ128rmbkz_VMAXPHZ128rm_VMAXPHZ128rmb_VMAXPHZ128rmbk_VMAXPHZ128rmk_VMAXPHZ128rmkz_VMINPHZ128rm_VMINPHZ128rmb_VMINPHZ128rmbk_VMINPHZ128rmk_VMINPHZ128rmkz_VMAXPHZ128rmbkz_VMINPHZ128rmbkz") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1720
  {DBGFIELD("VMULPHZ128rm_VMULPHZ128rmb_VMULPHZ128rmbk_VMULPHZ128rmk_VMULPHZ128rmkz_VMULPHZ128rmbkz") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1721
  {DBGFIELD("VGETEXPPHZ128mbkz")  3, false, false, false, 74, 6, 11, 1,  6, 1}, // #1722
  {DBGFIELD("VGF2P8MULBZ128rm")   2, false, false, false, 68, 6,  7, 1,  6, 1}, // #1723
  {DBGFIELD("VADDSHZrm_VSUBSHZrm_VADDSHZrm_Int_VADDSHZrm_Intk_VADDSHZrm_Intkz_VSUBSHZrm_Int_VSUBSHZrm_Intk_VSUBSHZrm_Intkz") 2, false, false, false, 53, 7,  9, 1,  6, 1}, // #1724
  {DBGFIELD("VCVTSH2SSZrm_VCVTSH2SSZrm_Int") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1725
  {DBGFIELD("VMAXCSHZrm_VMINCSHZrm_VMAXSHZrm_VMINSHZrm_VMAXSHZrm_Int_VMAXSHZrm_Intk_VMAXSHZrm_Intkz_VMINSHZrm_Int_VMINSHZrm_Intk_VMINSHZrm_Intkz") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1726
  {DBGFIELD("VMULSHZrm_VMULSHZrm_Int_VMULSHZrm_Intk_VMULSHZrm_Intkz") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1727
  {DBGFIELD("VGF2P8AFFINEINVQBZ256rmbi_VGF2P8AFFINEINVQBZ256rmi_VGF2P8AFFINEQBZ256rmbi_VGF2P8AFFINEQBZ256rmi") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #1728
  {DBGFIELD("VGF2P8MULBZ256rm")   2, false, false, false, 68, 6, 22, 1,  6, 1}, // #1729
  {DBGFIELD("VFMADD132PHZ128m_VFMADD132PHZ128mb_VFMADD132PHZ128mbk_VFMADD132PHZ128mk_VFMADD132PHZ128mkz_VFMADD213PHZ128m_VFMADD213PHZ128mb_VFMADD213PHZ128mbk_VFMADD213PHZ128mk_VFMADD213PHZ128mkz_VFMADD231PHZ128m_VFMADD231PHZ128mb_VFMADD231PHZ128mbk_VFMADD231PHZ128mk_VFMADD231PHZ128mkz_VFMSUB132PHZ128m_VFMSUB132PHZ128mb_VFMSUB132PHZ128mbk_VFMSUB132PHZ128mk_VFMSUB132PHZ128mkz_VFMSUB213PHZ128m_VFMSUB213PHZ128mb_VFMSUB213PHZ128mbk_VFMSUB213PHZ128mk_VFMSUB213PHZ128mkz_VFMSUB231PHZ128m_VFMSUB231PHZ128mb_VFMSUB231PHZ128mbk_VFMSUB231PHZ128mk_VFMSUB231PHZ128mkz_VFNMADD132PHZ128m_VFNMADD132PHZ128mb_VFNMADD132PHZ128mbk_VFNMADD132PHZ128mk_VFNMADD132PHZ128mkz_VFNMADD213PHZ128m_VFNMADD213PHZ128mb_VFNMADD213PHZ128mbk_VFNMADD213PHZ128mk_VFNMADD213PHZ128mkz_VFNMADD231PHZ128m_VFNMADD231PHZ128mb_VFNMADD231PHZ128mbk_VFNMADD231PHZ128mk_VFNMADD231PHZ128mkz_VFNMSUB132PHZ128m_VFNMSUB132PHZ128mb_VFNMSUB132PHZ128mbk_VFNMSUB132PHZ128mk_VFNMSUB132PHZ128mkz_VFNMSUB213PHZ128m_VFNMSUB213PHZ128mb_VFNMSUB213PHZ128mbk_VFNMSUB213PHZ128mk_VFNMSUB213PHZ128mkz_VFNMSUB231PHZ128m_VFNMSUB231PHZ128mb_VFNMSUB231PHZ128mbk_VFNMSUB231PHZ128mk_VFNMSUB231PHZ128mkz_VFMADD132PHZ128mbkz_VFMADD213PHZ128mbkz_VFMADD231PHZ128mbkz_VFMSUB132PHZ128mbkz_VFMSUB213PHZ128mbkz_VFMSUB231PHZ128mbkz_VFNMADD132PHZ128mbkz_VFNMADD213PHZ128mbkz_VFNMADD231PHZ128mbkz_VFNMSUB132PHZ128mbkz_VFNMSUB213PHZ128mbkz_VFNMSUB231PHZ128mbkz_VFMADDSUB132PHZ128m_VFMADDSUB132PHZ128mb_VFMADDSUB132PHZ128mbk_VFMADDSUB132PHZ128mk_VFMADDSUB132PHZ128mkz_VFMADDSUB213PHZ128m_VFMADDSUB213PHZ128mb_VFMADDSUB213PHZ128mbk_VFMADDSUB213PHZ128mk_VFMADDSUB213PHZ128mkz_VFMADDSUB231PHZ128m_VFMADDSUB231PHZ128mb_VFMADDSUB231PHZ128mbk_VFMADDSUB231PHZ128mk_VFMADDSUB231PHZ128mkz_VFMADDSUB132PHZ128mbkz_VFMADDSUB213PHZ128mbkz_VFMADDSUB231PHZ128mbkz_VFMSUBADD132PHZ128m_VFMSUBADD132PHZ128mb_VFMSUBADD132PHZ128mbk_VFMSUBADD132PHZ128mk_VFMSUBADD132PHZ128mkz_VFMSUBADD213PHZ128m_VFMSUBADD213PHZ128mb_VFMSUBADD213PHZ128mbk_VFMSUBADD213PHZ128mk_VFMSUBADD213PHZ128mkz_VFMSUBADD231PHZ128m_VFMSUBADD231PHZ128mb_VFMSUBADD231PHZ128mbk_VFMSUBADD231PHZ128mk_VFMSUBADD231PHZ128mkz_VFMSUBADD132PHZ128mbkz_VFMSUBADD213PHZ128mbkz_VFMSUBADD231PHZ128mbkz") 2, false, false, false, 68, 6,  8, 1, 10, 2}, // #1730
  {DBGFIELD("VFMADD132SHZm_VFMADD213SHZm_VFMADD231SHZm_VFMSUB132SHZm_VFMSUB213SHZm_VFMSUB231SHZm_VFNMADD132SHZm_VFNMADD213SHZm_VFNMADD231SHZm_VFNMSUB132SHZm_VFNMSUB213SHZm_VFNMSUB231SHZm_VFMADD132SHZm_Int_VFMADD132SHZm_Intk_VFMADD132SHZm_Intkz_VFMADD213SHZm_Int_VFMADD213SHZm_Intk_VFMADD213SHZm_Intkz_VFMADD231SHZm_Int_VFMADD231SHZm_Intk_VFMADD231SHZm_Intkz_VFMSUB132SHZm_Int_VFMSUB132SHZm_Intk_VFMSUB132SHZm_Intkz_VFMSUB213SHZm_Int_VFMSUB213SHZm_Intk_VFMSUB213SHZm_Intkz_VFMSUB231SHZm_Int_VFMSUB231SHZm_Intk_VFMSUB231SHZm_Intkz_VFNMADD132SHZm_Int_VFNMADD132SHZm_Intk_VFNMADD132SHZm_Intkz_VFNMADD213SHZm_Int_VFNMADD213SHZm_Intk_VFNMADD213SHZm_Intkz_VFNMADD231SHZm_Int_VFNMADD231SHZm_Intk_VFNMADD231SHZm_Intkz_VFNMSUB132SHZm_Int_VFNMSUB132SHZm_Intk_VFNMSUB132SHZm_Intkz_VFNMSUB213SHZm_Int_VFNMSUB213SHZm_Intk_VFNMSUB213SHZm_Intkz_VFNMSUB231SHZm_Int_VFNMSUB231SHZm_Intk_VFNMSUB231SHZm_Intkz") 2, false, false, false, 68, 6,  8, 1, 10, 2}, // #1731
  {DBGFIELD("VPMADD52HUQZ256m_VPMADD52HUQZ256mb_VPMADD52HUQZ256mbk_VPMADD52HUQZ256mk_VPMADD52HUQZ256mkz_VPMADD52LUQZ256m_VPMADD52LUQZ256mb_VPMADD52LUQZ256mbk_VPMADD52LUQZ256mk_VPMADD52LUQZ256mkz_VPMADD52HUQZ256mbkz_VPMADD52LUQZ256mbkz") 2, false, false, false, 68, 6, 24, 1, 10, 2}, // #1732
  {DBGFIELD("VADDPHZ128rr_VSUBPHZ128rr") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1733
  {DBGFIELD("VADDPHZ256rr_VSUBPHZ256rr") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1734
  {DBGFIELD("VADDSHZrr_VSUBSHZrr_VADDSHZrr_Int_VADDSHZrrb_Int_VSUBSHZrr_Int_VSUBSHZrrb_Int") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1735
  {DBGFIELD("VCVTPH2UWZ128rr_VCVTPH2WZ128rr_VCVTTPH2UWZ128rr_VCVTTPH2WZ128rr_VCVTUW2PHZ128rr_VCVTW2PHZ128rr") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1736
  {DBGFIELD("VCVTPH2UWZ256rr_VCVTPH2WZ256rr_VCVTTPH2UWZ256rr_VCVTTPH2WZ256rr_VCVTUW2PHZ256rr_VCVTW2PHZ256rr") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1737
  {DBGFIELD("VCVTSH2SSZrr_Int_VCVTSH2SSZrrb_Int") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1738
  {DBGFIELD("VFMADD132PHZ128r_VFMADD213PHZ128r_VFMADD231PHZ128r_VFMSUB132PHZ128r_VFMSUB213PHZ128r_VFMSUB231PHZ128r_VFNMADD132PHZ128r_VFNMADD213PHZ128r_VFNMADD231PHZ128r_VFNMSUB132PHZ128r_VFNMSUB213PHZ128r_VFNMSUB231PHZ128r_VFMADDSUB132PHZ128r_VFMADDSUB213PHZ128r_VFMADDSUB231PHZ128r_VFMSUBADD132PHZ128r_VFMSUBADD213PHZ128r_VFMSUBADD231PHZ128r") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1739
  {DBGFIELD("VFMADD132PHZ256r_VFMADD213PHZ256r_VFMADD231PHZ256r_VFMSUB132PHZ256r_VFMSUB213PHZ256r_VFMSUB231PHZ256r_VFNMADD132PHZ256r_VFNMADD213PHZ256r_VFNMADD231PHZ256r_VFNMSUB132PHZ256r_VFNMSUB213PHZ256r_VFNMSUB231PHZ256r_VFMADDSUB132PHZ256r_VFMADDSUB213PHZ256r_VFMADDSUB231PHZ256r_VFMSUBADD132PHZ256r_VFMSUBADD213PHZ256r_VFMSUBADD231PHZ256r") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1740
  {DBGFIELD("VFMADD132SHZr_VFMADD132SHZr_Int_VFMADD132SHZrb_VFMADD132SHZrb_Int_VFMADD213SHZr_VFMADD213SHZr_Int_VFMADD213SHZrb_VFMADD213SHZrb_Int_VFMADD231SHZr_VFMADD231SHZr_Int_VFMADD231SHZrb_VFMADD231SHZrb_Int_VFMSUB132SHZr_VFMSUB132SHZr_Int_VFMSUB132SHZrb_VFMSUB132SHZrb_Int_VFMSUB213SHZr_VFMSUB213SHZr_Int_VFMSUB213SHZrb_VFMSUB213SHZrb_Int_VFMSUB231SHZr_VFMSUB231SHZr_Int_VFMSUB231SHZrb_VFMSUB231SHZrb_Int_VFNMADD132SHZr_VFNMADD132SHZr_Int_VFNMADD132SHZrb_VFNMADD132SHZrb_Int_VFNMADD213SHZr_VFNMADD213SHZr_Int_VFNMADD213SHZrb_VFNMADD213SHZrb_Int_VFNMADD231SHZr_VFNMADD231SHZr_Int_VFNMADD231SHZrb_VFNMADD231SHZrb_Int_VFNMSUB132SHZr_VFNMSUB132SHZr_Int_VFNMSUB132SHZrb_VFNMSUB132SHZrb_Int_VFNMSUB213SHZr_VFNMSUB213SHZr_Int_VFNMSUB213SHZrb_VFNMSUB213SHZrb_Int_VFNMSUB231SHZr_VFNMSUB231SHZr_Int_VFNMSUB231SHZrb_VFNMSUB231SHZrb_Int") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1741
  {DBGFIELD("VGETEXPPHZ128r_VGETEXPSHZr_VGETEXPSHZrb_VGETMANTPHZ128rri_VGETMANTSHZrri_VGETMANTSHZrrib") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1742
  {DBGFIELD("VGETEXPPHZ256r_VGETMANTPHZ256rri") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1743
  {DBGFIELD("VGF2P8MULBZ128rr")   1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1744
  {DBGFIELD("VGF2P8MULBZ256rr")   1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1745
  {DBGFIELD("VMAXCPHZ128rr_VMINCPHZ128rr_VMAXPHZ128rr_VMINPHZ128rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1746
  {DBGFIELD("VMAXCPHZ256rr_VMINCPHZ256rr_VMAXPHZ256rr_VMINPHZ256rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1747
  {DBGFIELD("VMAXCSHZrr_VMINCSHZrr_VMAXSHZrr_VMINSHZrr_VMAXSHZrr_Int_VMAXSHZrrb_Int_VMINSHZrr_Int_VMINSHZrrb_Int") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1748
  {DBGFIELD("VMULPHZ128rr")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1749
  {DBGFIELD("VMULPHZ256rr")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1750
  {DBGFIELD("VMULSHZrr_VMULSHZrr_Int_VMULSHZrrb_Int") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1751
  {DBGFIELD("VCVTSH2SSZrr")       2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1752
  {DBGFIELD("VBROADCASTSSZ128rm") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1753
  {DBGFIELD("VMOVDDUPZ128rm_VMOVSHDUPZ128rm_VMOVSLDUPZ128rm") 2, false, false, false, 375, 10,  7, 1,  0, 0}, // #1754
  {DBGFIELD("VPBROADCASTDZ128rm_VPBROADCASTQZ128rm") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #1755
  {DBGFIELD("VBROADCASTI32X2Z128rm") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #1756
  {DBGFIELD("KANDBrr_KANDDrr_KANDNDrr_KANDNQrr_KANDNWrr_KANDQrr_KANDWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1757
  {DBGFIELD("VPABSBZrr_VPSUBSBZrr_VPABSDZrr_VPABSQZrr_VPABSWZrr_VPABSDZrrk_VPABSDZrrkz_VPABSQZrrk_VPABSQZrrkz_VPADDSBZrr_VPADDSWZrr_VPADDUSBZrr_VPADDUSWZrr_VPAVGBZrr_VPAVGWZrr_VPMAXSBZrr_VPMAXUDZrr_VPMAXUWZrr_VPMINSBZrr_VPMINUDZrr_VPMINUWZrr_VPMAXSDZrr_VPMAXUBZrr_VPMINSDZrr_VPMINUBZrr_VPMAXSDZrrk_VPMAXSDZrrkz_VPMAXUDZrrk_VPMAXUDZrrkz_VPMINSDZrrk_VPMINSDZrrkz_VPMINUDZrrk_VPMINUDZrrkz_VPMAXSWZrr_VPMINSWZrr_VPSUBSWZrr_VPSUBUSWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1758
  {DBGFIELD("VPSHLDDZrri_VPSHLDQZrri_VPSHLDWZrri_VPSHRDDZrri_VPSHRDQZrri_VPSHRDWZrri_VPSHLDVDZrk_VPSHLDVDZrkz_VPSHLDVQZrk_VPSHLDVQZrkz_VPSHRDVDZrk_VPSHRDVDZrkz_VPSHRDVQZrk_VPSHRDVQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1759
  {DBGFIELD("VPSHLDVDZr_VPSHLDVQZr_VPSHLDVWZr_VPSHRDVDZr_VPSHRDVQZr_VPSHRDVWZr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1760
  {DBGFIELD("VPSUBUSBZrr")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1761
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, false, 28, 2, 10, 1,  0, 0}, // #1762
  {DBGFIELD("KMOVBmk")            2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1763
  {DBGFIELD("VBROADCASTSSZ128rr_VBROADCASTSSZ128rrk_VBROADCASTSSZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1764
  {DBGFIELD("VPALIGNRZrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1765
  {DBGFIELD("VPSHUFDZri_VPSHUFHWZri_VPSHUFLWZri_VPSHUFDZrik_VPSHUFDZrikz_VPUNPCKHBWZrr_VPUNPCKHWDZrr_VPUNPCKLBWZrr_VPUNPCKLWDZrr_VPUNPCKHDQZrr_VPUNPCKHDQZrrk_VPUNPCKHDQZrrkz_VPUNPCKLDQZrr_VPUNPCKLDQZrrk_VPUNPCKLDQZrrkz_VPUNPCKLQDQZrr_VPUNPCKLQDQZrrk_VPUNPCKLQDQZrrkz_VPUNPCKHQDQZrr_VPUNPCKHQDQZrrk_VPUNPCKHQDQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1766
  {DBGFIELD("VPSHUFBZrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1767
  {DBGFIELD("VPABSBZrrk_VPABSBZrrkz_VPABSWZrrk_VPABSWZrrkz_VPSUBSBZrrk_VPSUBSBZrrkz_VPSUBSWZrrk_VPSUBSWZrrkz_VPADDSBZrrk_VPADDSBZrrkz_VPADDSWZrrk_VPADDSWZrrkz_VPADDUSBZrrk_VPADDUSBZrrkz_VPADDUSWZrrk_VPADDUSWZrrkz_VPAVGBZrrk_VPAVGBZrrkz_VPAVGWZrrk_VPAVGWZrrkz_VPMAXSBZrrk_VPMAXSBZrrkz_VPMAXUWZrrk_VPMAXUWZrrkz_VPMINSBZrrk_VPMINSBZrrkz_VPMINUWZrrk_VPMINUWZrrkz_VPMAXSWZrrk_VPMAXSWZrrkz_VPMAXUBZrrk_VPMAXUBZrrkz_VPMINSWZrrk_VPMINSWZrrkz_VPMINUBZrrk_VPMINUBZrrkz_VPSUBUSBZrrk_VPSUBUSBZrrkz_VPSUBUSWZrrk_VPSUBUSWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1768
  {DBGFIELD("VPSHLDVWZrk_VPSHLDVWZrkz_VPSHRDVWZrk_VPSHRDVWZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1769
  {DBGFIELD("VPSLLVWZrrk_VPSLLVWZrrkz_VPSRLVWZrrk_VPSRLVWZrrkz_VPSRAVWZrrk_VPSRAVWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1770
  {DBGFIELD("VPSLLWZrik_VPSLLWZrikz_VPSRLWZrik_VPSRLWZrikz_VPSRAWZrik_VPSRAWZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1771
  {DBGFIELD("VMOVSDto64Zrr")      1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1772
  {DBGFIELD("VCVTPH2DQZ128rr_VCVTPH2UDQZ128rr_VCVTTPH2DQZ128rr_VCVTTPH2UDQZ128rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1773
  {DBGFIELD("VCVTPH2DQZ256rr_VCVTPH2UDQZ256rr_VCVTTPH2DQZ256rr_VCVTTPH2UDQZ256rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1774
  {DBGFIELD("VCVTPH2PSXZ256rr")   2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1775
  {DBGFIELD("VCVTPS2PHXZ256rr")   2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1776
  {DBGFIELD("VCVTPH2PSXZ128rr")   2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1777
  {DBGFIELD("VCVTPS2PHXZ128rr")   2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1778
  {DBGFIELD("VPERMWZ128rrk_VPERMWZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1779
  {DBGFIELD("VPERMWZ256rrk_VPERMWZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1780
  {DBGFIELD("VPSLLWZ256rrk_VPSLLWZ256rrkz_VPSRLWZ256rrk_VPSRLWZ256rrkz_VPSRAWZ256rrk_VPSRAWZ256rrkz") 2, false, false, false, 183, 9, 14, 1,  0, 0}, // #1781
  {DBGFIELD("VMOVSHZmr_VMOVWmr")  2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1782
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTI32X2Z256rm_VBROADCASTF32X2Zrm_VBROADCASTI32X2Zrm_VPBROADCASTQZrm_VPBROADCASTDZ256rm_VPBROADCASTQZ256rm_VPBROADCASTDZrm") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1783
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTI32X4Z256rm_VBROADCASTF32X8rm_VBROADCASTI32X8rm_VBROADCASTF32X4rm_VBROADCASTF64X4rm_VBROADCASTI32X4rm_VBROADCASTI64X4rm_VBROADCASTF64X2Z128rm_VBROADCASTF64X2rm_VBROADCASTI64X2Z128rm_VBROADCASTI64X2rm") 2, false, false, false, 53, 7, 22, 1,  0, 0}, // #1784
  {DBGFIELD("VBROADCASTSSZrm_VBROADCASTSDZ256rm_VBROADCASTSSZ256rm_VBROADCASTSDZrm") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1785
  {DBGFIELD("VMOVDDUPZrm_VMOVSHDUPZrm_VMOVSLDUPZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1786
  {DBGFIELD("VMOVDDUPZ256rm_VMOVSHDUPZ256rm_VMOVSLDUPZ256rm") 2, false, false, false, 375, 10, 22, 1,  0, 0}, // #1787
  {DBGFIELD("VPMOVDBZrr_VPMOVQBZrr_VPMOVSQBZrr_VPMOVQWZrr_VPMOVSQWZrr_VPMOVSDBZrr_VPMOVUSDBZrr_VPMOVUSQBZrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1788
  {DBGFIELD("VPMOVSWBZrr_VPMOVWBZrr_VPMOVDWZrr_VPMOVSDWZrr_VPMOVUSDWZrr_VPMOVSQDZrr_VPMOVUSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1789
  {DBGFIELD("VPMOVUSQWZrr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1790
  {DBGFIELD("VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1791
  {DBGFIELD("VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz") 2, false, false, false, 53, 7, 22, 1,  0, 0}, // #1792
  {DBGFIELD("VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1793
  {DBGFIELD("VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1794
  {DBGFIELD("VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Zrmk_VMOVDQU64Zrmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1795
  {DBGFIELD("VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1796
  {DBGFIELD("VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1797
  {DBGFIELD("VPADDBZrm_VPADDDZrm_VPADDQZrm_VPADDWZrm_VPSUBBZrm_VPSUBDZrm_VPSUBQZrm_VPSUBWZrm_VPADDDZrmb_VPADDDZrmk_VPADDDZrmkz_VPADDQZrmb_VPADDQZrmk_VPADDQZrmkz_VPSUBDZrmb_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrmb_VPSUBQZrmk_VPSUBQZrmkz_VPADDDZrmbk_VPADDDZrmbkz_VPADDQZrmbk_VPADDQZrmbkz_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBQZrmbk_VPSUBQZrmbkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmik_VPTERNLOGQZrmbi_VPTERNLOGQZrmik_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmikz_VPTERNLOGQZrmi_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1798
  {DBGFIELD("VPBROADCASTWZrm_VPBROADCASTBZ256rm_VPBROADCASTWZ256rm_VPBROADCASTBZrm") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1799
  {DBGFIELD("VFPCLASSPDZ128rm_VFPCLASSPSZ128rm") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1800
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSSZrm") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1801
  {DBGFIELD("VFPCLASSSHZrm")      2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1802
  {DBGFIELD("VPALIGNRZ256rmi")    2, false, false, false, 53, 7, 22, 1,  6, 1}, // #1803
  {DBGFIELD("VPSHUFBZrm")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1804
  {DBGFIELD("MOV16ri_MOV64ri_MOV8ri_MOV16ri_alt_MOV8ri_alt_MOV16rr_MOV16rr_REV_MOV8rr_MOV8rr_REV") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1805
  {DBGFIELD("MOV32ri_MOV32ri_alt") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1806
  {DBGFIELD("MOV8rr_NOREX")       1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1807
  {DBGFIELD("VMOVLPDZ128rm_VMOVLPSZ128rm_VSHUFPDZ128rmbi_VSHUFPDZ128rmik_VSHUFPSZ128rmbi_VSHUFPSZ128rmik_VSHUFPDZ128rmbik_VSHUFPDZ128rmbikz_VSHUFPSZ128rmbik_VSHUFPSZ128rmbikz_VSHUFPDZ128rmi_VSHUFPDZ128rmikz_VSHUFPSZ128rmi_VSHUFPSZ128rmikz") 2, false, false, false, 375, 10,  7, 1,  6, 1}, // #1808
  {DBGFIELD("VMOVAPDZ128rrk_VMOVAPDZ128rrk_REV_VMOVAPDZ128rrkz_VMOVAPDZ128rrkz_REV_VMOVAPSZ128rrk_VMOVAPSZ128rrk_REV_VMOVAPSZ128rrkz_VMOVAPSZ128rrkz_REV_VMOVUPDZ128rrk_VMOVUPDZ128rrk_REV_VMOVUPDZ128rrkz_VMOVUPDZ128rrkz_REV_VMOVUPSZ128rrk_VMOVUPSZ128rrk_REV_VMOVUPSZ128rrkz_VMOVUPSZ128rrkz_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1809
  {DBGFIELD("VMOVAPDZ256rrk_VMOVAPDZ256rrk_REV_VMOVAPDZ256rrkz_VMOVAPDZ256rrkz_REV_VMOVAPSZ256rrk_VMOVAPSZ256rrk_REV_VMOVAPSZ256rrkz_VMOVAPSZ256rrkz_REV_VMOVUPDZ256rrk_VMOVUPDZ256rrk_REV_VMOVUPDZ256rrkz_VMOVUPDZ256rrkz_REV_VMOVUPSZ256rrk_VMOVUPSZ256rrk_REV_VMOVUPSZ256rrkz_VMOVUPSZ256rrkz_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1810
  {DBGFIELD("VMOVDQA32Z128rrk_VMOVDQA32Z128rrk_REV_VMOVDQA32Z128rrkz_VMOVDQA32Z128rrkz_REV_VMOVDQA64Z128rrk_VMOVDQA64Z128rrk_REV_VMOVDQA64Z128rrkz_VMOVDQA64Z128rrkz_REV_VMOVDQU32Z128rrk_VMOVDQU32Z128rrk_REV_VMOVDQU32Z128rrkz_VMOVDQU32Z128rrkz_REV_VMOVDQU64Z128rrk_VMOVDQU64Z128rrk_REV_VMOVDQU64Z128rrkz_VMOVDQU64Z128rrkz_REV_VPMOVM2DZ128rr_VPMOVM2QZ128rr") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1811
  {DBGFIELD("VMOVSHZrr_VMOVSHZrr_REV") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1812
  {DBGFIELD("VPADDBZ128rr_VPADDDZ128rr_VPADDQZ128rr_VPADDWZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rrk_VPADDQZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1813
  {DBGFIELD("VPADDBZ256rr_VPADDDZ256rr_VPADDQZ256rr_VPADDWZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rrk_VPADDQZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1814
  {DBGFIELD("VPABSBZrmk_VPABSBZrmkz_VPABSWZrmk_VPABSWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1815
  {DBGFIELD("VPSLLWZmik_VPSLLWZmikz_VPSRLWZmik_VPSRLWZmikz_VPSRAWZmik_VPSRAWZmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1816
  {DBGFIELD("VPADDSBZrmk_VPADDSBZrmkz_VPADDSWZrmk_VPADDSWZrmkz_VPADDUSBZrmk_VPADDUSBZrmkz_VPADDUSWZrmk_VPADDUSWZrmkz_VPSUBSBZrmk_VPSUBSBZrmkz_VPSUBSWZrmk_VPSUBSWZrmkz_VPSUBUSBZrmk_VPSUBUSBZrmkz_VPSUBUSWZrmk_VPSUBUSWZrmkz_VPAVGBZrmk_VPAVGBZrmkz_VPAVGWZrmk_VPAVGWZrmkz_VPMAXSBZrmk_VPMAXSBZrmkz_VPMAXUWZrmk_VPMAXUWZrmkz_VPMINSBZrmk_VPMINSBZrmkz_VPMINUWZrmk_VPMINUWZrmkz_VPMAXSWZrmk_VPMAXSWZrmkz_VPMAXUBZrmk_VPMAXUBZrmkz_VPMINSWZrmk_VPMINSWZrmkz_VPMINUBZrmk_VPMINUBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1817
  {DBGFIELD("VPSHLDVWZmk_VPSHLDVWZmkz_VPSHRDVWZmk_VPSHRDVWZmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1818
  {DBGFIELD("VPSLLVWZrmk_VPSLLVWZrmkz_VPSRLVWZrmk_VPSRLVWZrmkz_VPSRAVWZrmk_VPSRAVWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1819
  {DBGFIELD("VPSLLWZrmk_VPSLLWZrmkz_VPSRLWZrmk_VPSRLWZrmkz_VPSRAWZrmk_VPSRAWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1820
  {DBGFIELD("VCOMISHZrr_VCOMISHZrrb_VUCOMISHZrr_VUCOMISHZrrb_VCOMISHZrr_Int_VUCOMISHZrr_Int") 1, false, false, false,  2, 8,  5, 1,  0, 0}, // #1821
  {DBGFIELD("VCVTPD2QQZrrb_VCVTPD2QQZrrbk_VCVTPD2QQZrrk_VCVTPD2QQZrrkz_VCVTPD2UQQZrrb_VCVTPD2UQQZrrbk_VCVTPD2UQQZrrk_VCVTPD2UQQZrrkz_VCVTTPD2QQZrrb_VCVTTPD2QQZrrbk_VCVTTPD2QQZrrk_VCVTTPD2QQZrrkz_VCVTTPD2UQQZrrb_VCVTTPD2UQQZrrbk_VCVTTPD2UQQZrrk_VCVTTPD2UQQZrrkz_VCVTPD2QQZrrbkz_VCVTPD2UQQZrrbkz_VCVTTPD2QQZrrbkz_VCVTTPD2UQQZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1822
  {DBGFIELD("VCVTPS2DQZrrb_VCVTPS2DQZrrbk_VCVTPS2DQZrrk_VCVTPS2DQZrrkz_VCVTPS2UDQZrrb_VCVTPS2UDQZrrbk_VCVTPS2UDQZrrk_VCVTPS2UDQZrrkz_VCVTTPS2DQZrrb_VCVTTPS2DQZrrbk_VCVTTPS2DQZrrk_VCVTTPS2DQZrrkz_VCVTTPS2UDQZrrb_VCVTTPS2UDQZrrbk_VCVTTPS2UDQZrrk_VCVTTPS2UDQZrrkz_VCVTPS2DQZrrbkz_VCVTPS2UDQZrrbkz_VCVTTPS2DQZrrbkz_VCVTTPS2UDQZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1823
  {DBGFIELD("VMAXCPSZrr_VMAXCPSZrrk_VMAXCPSZrrkz_VMAXPSZrr_VMAXPSZrrk_VMAXPSZrrkz_VMINCPSZrr_VMINCPSZrrk_VMINCPSZrrkz_VMINPSZrr_VMINPSZrrk_VMINPSZrrkz_VMAXPSZrrb_VMAXPSZrrbk_VMAXPSZrrbkz_VMINPSZrrb_VMINPSZrrbk_VMINPSZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1824
  {DBGFIELD("VPLZCNTDZrr_VPLZCNTDZrrk_VPLZCNTDZrrkz_VPLZCNTQZrr_VPLZCNTQZrrk_VPLZCNTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1825
  {DBGFIELD("VPMADD52HUQZr_VPMADD52HUQZrk_VPMADD52HUQZrkz_VPMADD52LUQZr_VPMADD52LUQZrk_VPMADD52LUQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1826
  {DBGFIELD("VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1827
  {DBGFIELD("VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1828
  {DBGFIELD("VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1829
  {DBGFIELD("VPADDBZ128rm_VPADDDZ128rm_VPADDQZ128rm_VPADDWZ128rm_VPSUBBZ128rm_VPSUBDZ128rm_VPSUBQZ128rm_VPSUBWZ128rm_VPADDDZ128rmb_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rmb_VPADDQZ128rmk_VPADDQZ128rmkz_VPSUBDZ128rmb_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rmb_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmik_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmik_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmikz") 2, false, false, false, 68, 6,  7, 1,  6, 1}, // #1830
  {DBGFIELD("VPBROADCASTBZ128rm_VPBROADCASTWZ128rm") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #1831
  {DBGFIELD("VPALIGNRZ128rmi")    2, false, false, false, 53, 7,  7, 1,  6, 1}, // #1832
  {DBGFIELD("VPEXTRDZmr_VPEXTRQZmr") 3, false, false, false, 261, 8, 17, 1,  0, 0}, // #1833
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1834
  {DBGFIELD("ROUNDPDm_ROUNDPSm_VROUNDPDm_VROUNDPSm") 3, false, false, false, 74, 6, 11, 1,  0, 0}, // #1835
  {DBGFIELD("ROUNDSDm_ROUNDSDm_Int_ROUNDSSm_ROUNDSSm_Int_VROUNDSDm_VROUNDSDm_Int_VROUNDSSm_VROUNDSSm_Int_VRNDSCALEPDZ128rmbi_VRNDSCALEPDZ128rmik_VRNDSCALEPSZ128rmbi_VRNDSCALEPSZ128rmik_VRNDSCALEPDZ128rmbik_VRNDSCALEPDZ128rmbikz_VRNDSCALEPSZ128rmbik_VRNDSCALEPSZ128rmbikz_VRNDSCALEPDZ128rmi_VRNDSCALEPDZ128rmikz_VRNDSCALEPSZ128rmi_VRNDSCALEPSZ128rmikz_VRNDSCALESDZm_VRNDSCALESSZm_VRNDSCALESDZm_Int_VRNDSCALESDZm_Intk_VRNDSCALESDZm_Intkz_VRNDSCALESSZm_Int_VRNDSCALESSZm_Intk_VRNDSCALESSZm_Intkz") 3, false, false, false, 74, 6, 11, 1,  6, 1}, // #1836
  {DBGFIELD("ROUNDPDr_ROUNDSSr_VROUNDPDr_VROUNDSSr_ROUNDPSr_ROUNDSDr_VROUNDPSr_VROUNDSDr_ROUNDSDr_Int_ROUNDSSr_Int_VROUNDSDr_Int_VROUNDSSr_Int_VRNDSCALEPDZ128rri_VRNDSCALEPDZ128rrik_VRNDSCALEPDZ128rrikz_VRNDSCALEPSZ128rri_VRNDSCALEPSZ128rrik_VRNDSCALEPSZ128rrikz_VRNDSCALESDZr_VRNDSCALESSZr_VRNDSCALESDZr_Int_VRNDSCALESDZr_Intk_VRNDSCALESDZr_Intkz_VRNDSCALESDZrb_Int_VRNDSCALESDZrb_Intk_VRNDSCALESDZrb_Intkz_VRNDSCALESSZr_Int_VRNDSCALESSZr_Intk_VRNDSCALESSZr_Intkz_VRNDSCALESSZrb_Int_VRNDSCALESSZrb_Intk_VRNDSCALESSZrb_Intkz") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1837
  {DBGFIELD("VRNDSCALEPDZ256rri_VRNDSCALEPDZ256rrik_VRNDSCALEPDZ256rrikz_VRNDSCALEPSZ256rri_VRNDSCALEPSZ256rrik_VRNDSCALEPSZ256rrikz_VROUNDPDYr_VROUNDPSYr") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1838
  {DBGFIELD("VPMOVSXBWZ256rmk_VPMOVSXBWZ256rmkz_VPMOVSXBWZrmk_VPMOVSXBWZrmkz_VPMOVZXBWZ256rmk_VPMOVZXBWZ256rmkz_VPMOVZXBWZrmk_VPMOVZXBWZrmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1839
  {DBGFIELD("VPOPCNTBZ128rmk_VPOPCNTBZ128rmkz_VPOPCNTWZ128rmk_VPOPCNTWZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  0, 0}, // #1840
  {DBGFIELD("VPOPCNTBZ256rmk_VPOPCNTBZ256rmkz_VPOPCNTWZ256rmk_VPOPCNTWZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  0, 0}, // #1841
  {DBGFIELD("VPOPCNTBZrmk_VPOPCNTBZrmkz_VPOPCNTWZrmk_VPOPCNTWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1842
  {DBGFIELD("VDBPSADBWZ128rmik_VDBPSADBWZ128rmikz") 2, false, false, false, 375, 10,  9, 1,  6, 1}, // #1843
  {DBGFIELD("VPMULTISHIFTQBZ128rmbk_VPMULTISHIFTQBZ128rmkz_VPMULTISHIFTQBZ128rmbkz_VPMULTISHIFTQBZ128rmk") 2, false, false, false, 68, 6,  7, 1,  6, 1}, // #1844
  {DBGFIELD("VDBPSADBWZ256rmik_VDBPSADBWZ256rmikz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1845
  {DBGFIELD("VDBPSADBWZrmik_VDBPSADBWZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1846
  {DBGFIELD("VPACKSSDWZ256rmbk_VPACKSSDWZ256rmkz_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmkz_VPACKSSDWZ256rmbkz_VPACKUSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSWBZ256rmk_VPACKUSDWZ256rmk_VPACKUSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSWBZ256rmkz") 2, false, false, false, 53, 7, 22, 1,  6, 1}, // #1847
  {DBGFIELD("VPACKSSDWZrmbk_VPACKSSDWZrmkz_VPACKUSDWZrmbk_VPACKUSDWZrmkz_VPACKSSDWZrmbkz_VPACKUSDWZrmbkz_VPACKSSDWZrmk_VPACKSSWBZrmk_VPACKUSDWZrmk_VPACKUSWBZrmk_VPACKSSWBZrmkz_VPACKUSWBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1848
  {DBGFIELD("VPERMBZ128rmk_VPERMBZ128rmkz_VPERMBZ256rmk_VPERMBZ256rmkz_VPERMBZrmk_VPERMBZrmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #1849
  {DBGFIELD("VPMULTISHIFTQBZ256rmbk_VPMULTISHIFTQBZ256rmkz_VPMULTISHIFTQBZ256rmbkz_VPMULTISHIFTQBZ256rmk") 2, false, false, false, 68, 6, 22, 1,  6, 1}, // #1850
  {DBGFIELD("VPMULTISHIFTQBZrmbk_VPMULTISHIFTQBZrmkz_VPMULTISHIFTQBZrmbkz_VPMULTISHIFTQBZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1851
  {DBGFIELD("VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVWBZrrk_VPMOVWBZrrkz_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSWBZrrk_VPMOVUSWBZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1852
  {DBGFIELD("VSQRTSDZm_Int")      2, false, false, false, 173, 10, 18, 1,  6, 1}, // #1853
  {DBGFIELD("VADDPDZ128rrkz_VSUBPDZ128rrkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1854
  {DBGFIELD("VADDPDZ256rrkz_VSUBPDZ256rrkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1855
  {DBGFIELD("VADDPSZ128rrkz_VSUBPSZ128rrkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1856
  {DBGFIELD("VADDPSZ256rrkz_VSUBPSZ256rrkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1857
  {DBGFIELD("VADDSDZrr_Intkz_VADDSDZrrb_Intkz_VSUBSDZrr_Intkz_VSUBSDZrrb_Intkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1858
  {DBGFIELD("VADDSSZrr_Intkz_VADDSSZrrb_Intkz_VSUBSSZrr_Intkz_VSUBSSZrrb_Intkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1859
  {DBGFIELD("VADDPDZrr_VADDPDZrrb_VSUBPDZrr_VSUBPDZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1860
  {DBGFIELD("VADDPSZrr_VADDPSZrrb_VSUBPSZrr_VSUBPSZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1861
  {DBGFIELD("VMOVDQU16Zrrk_VMOVDQU16Zrrk_REV_VMOVDQU16Zrrkz_VMOVDQU16Zrrkz_REV_VMOVDQU8Zrrk_VMOVDQU8Zrrk_REV_VMOVDQU8Zrrkz_VMOVDQU8Zrrkz_REV_VPMOVM2BZrr_VPMOVM2WZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1862
  {DBGFIELD("VPBLENDMBZrrk_VPBLENDMBZrrkz_VPBLENDMWZrrk_VPBLENDMWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1863
  {DBGFIELD("VADDPHZ128rrk_VADDPHZ128rrkz_VSUBPHZ128rrk_VSUBPHZ128rrkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1864
  {DBGFIELD("VADDPHZ256rrk_VADDPHZ256rrkz_VSUBPHZ256rrk_VSUBPHZ256rrkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1865
  {DBGFIELD("VADDSHZrr_Intk_VADDSHZrr_Intkz_VADDSHZrrb_Intk_VADDSHZrrb_Intkz_VSUBSHZrr_Intk_VSUBSHZrr_Intkz_VSUBSHZrrb_Intk_VSUBSHZrrb_Intkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1866
  {DBGFIELD("VCVTPH2UWZ128rrk_VCVTPH2UWZ128rrkz_VCVTPH2WZ128rrk_VCVTPH2WZ128rrkz_VCVTTPH2UWZ128rrk_VCVTTPH2UWZ128rrkz_VCVTTPH2WZ128rrk_VCVTTPH2WZ128rrkz_VCVTUW2PHZ128rrk_VCVTUW2PHZ128rrkz_VCVTW2PHZ128rrk_VCVTW2PHZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1867
  {DBGFIELD("VCVTPH2UWZ256rrk_VCVTPH2UWZ256rrkz_VCVTPH2WZ256rrk_VCVTPH2WZ256rrkz_VCVTTPH2UWZ256rrk_VCVTTPH2UWZ256rrkz_VCVTTPH2WZ256rrk_VCVTTPH2WZ256rrkz_VCVTUW2PHZ256rrk_VCVTUW2PHZ256rrkz_VCVTW2PHZ256rrk_VCVTW2PHZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1868
  {DBGFIELD("VFMADD132PHZ128rk_VFMADD132PHZ128rkz_VFMADD213PHZ128rk_VFMADD213PHZ128rkz_VFMADD231PHZ128rk_VFMADD231PHZ128rkz_VFMSUB132PHZ128rk_VFMSUB132PHZ128rkz_VFMSUB213PHZ128rk_VFMSUB213PHZ128rkz_VFMSUB231PHZ128rk_VFMSUB231PHZ128rkz_VFNMADD132PHZ128rk_VFNMADD132PHZ128rkz_VFNMADD213PHZ128rk_VFNMADD213PHZ128rkz_VFNMADD231PHZ128rk_VFNMADD231PHZ128rkz_VFNMSUB132PHZ128rk_VFNMSUB132PHZ128rkz_VFNMSUB213PHZ128rk_VFNMSUB213PHZ128rkz_VFNMSUB231PHZ128rk_VFNMSUB231PHZ128rkz_VFMADDSUB132PHZ128rk_VFMADDSUB132PHZ128rkz_VFMADDSUB213PHZ128rk_VFMADDSUB213PHZ128rkz_VFMADDSUB231PHZ128rk_VFMADDSUB231PHZ128rkz_VFMSUBADD132PHZ128rk_VFMSUBADD132PHZ128rkz_VFMSUBADD213PHZ128rk_VFMSUBADD213PHZ128rkz_VFMSUBADD231PHZ128rk_VFMSUBADD231PHZ128rkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1869
  {DBGFIELD("VFMADD132PHZ256rk_VFMADD132PHZ256rkz_VFMADD213PHZ256rk_VFMADD213PHZ256rkz_VFMADD231PHZ256rk_VFMADD231PHZ256rkz_VFMSUB132PHZ256rk_VFMSUB132PHZ256rkz_VFMSUB213PHZ256rk_VFMSUB213PHZ256rkz_VFMSUB231PHZ256rk_VFMSUB231PHZ256rkz_VFNMADD132PHZ256rk_VFNMADD132PHZ256rkz_VFNMADD213PHZ256rk_VFNMADD213PHZ256rkz_VFNMADD231PHZ256rk_VFNMADD231PHZ256rkz_VFNMSUB132PHZ256rk_VFNMSUB132PHZ256rkz_VFNMSUB213PHZ256rk_VFNMSUB213PHZ256rkz_VFNMSUB231PHZ256rk_VFNMSUB231PHZ256rkz_VFMADDSUB132PHZ256rk_VFMADDSUB132PHZ256rkz_VFMADDSUB213PHZ256rk_VFMADDSUB213PHZ256rkz_VFMADDSUB231PHZ256rk_VFMADDSUB231PHZ256rkz_VFMSUBADD132PHZ256rk_VFMSUBADD132PHZ256rkz_VFMSUBADD213PHZ256rk_VFMSUBADD213PHZ256rkz_VFMSUBADD231PHZ256rk_VFMSUBADD231PHZ256rkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1870
  {DBGFIELD("VFMADD132SHZr_Intk_VFMADD132SHZr_Intkz_VFMADD132SHZrb_Intk_VFMADD132SHZrb_Intkz_VFMADD213SHZr_Intk_VFMADD213SHZr_Intkz_VFMADD213SHZrb_Intk_VFMADD213SHZrb_Intkz_VFMADD231SHZr_Intk_VFMADD231SHZr_Intkz_VFMADD231SHZrb_Intk_VFMADD231SHZrb_Intkz_VFMSUB132SHZr_Intk_VFMSUB132SHZr_Intkz_VFMSUB132SHZrb_Intk_VFMSUB132SHZrb_Intkz_VFMSUB213SHZr_Intk_VFMSUB213SHZr_Intkz_VFMSUB213SHZrb_Intk_VFMSUB213SHZrb_Intkz_VFMSUB231SHZr_Intk_VFMSUB231SHZr_Intkz_VFMSUB231SHZrb_Intk_VFMSUB231SHZrb_Intkz_VFNMADD132SHZr_Intk_VFNMADD132SHZr_Intkz_VFNMADD132SHZrb_Intk_VFNMADD132SHZrb_Intkz_VFNMADD213SHZr_Intk_VFNMADD213SHZr_Intkz_VFNMADD213SHZrb_Intk_VFNMADD213SHZrb_Intkz_VFNMADD231SHZr_Intk_VFNMADD231SHZr_Intkz_VFNMADD231SHZrb_Intk_VFNMADD231SHZrb_Intkz_VFNMSUB132SHZr_Intk_VFNMSUB132SHZr_Intkz_VFNMSUB132SHZrb_Intk_VFNMSUB132SHZrb_Intkz_VFNMSUB213SHZr_Intk_VFNMSUB213SHZr_Intkz_VFNMSUB213SHZrb_Intk_VFNMSUB213SHZrb_Intkz_VFNMSUB231SHZr_Intk_VFNMSUB231SHZr_Intkz_VFNMSUB231SHZrb_Intk_VFNMSUB231SHZrb_Intkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1871
  {DBGFIELD("VGETEXPPHZ128rk_VGETEXPPHZ128rkz_VGETEXPSHZrbk_VGETEXPSHZrkz_VGETEXPSHZrbkz_VGETEXPSHZrk_VGETMANTPHZ128rrik_VGETMANTPHZ128rrikz_VGETMANTSHZrribk_VGETMANTSHZrrikz_VGETMANTSHZrribkz_VGETMANTSHZrrik") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1872
  {DBGFIELD("VGETEXPPHZ256rk_VGETEXPPHZ256rkz_VGETMANTPHZ256rrik_VGETMANTPHZ256rrikz") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1873
  {DBGFIELD("VMAXCPHZ128rrk_VMAXCPHZ128rrkz_VMINCPHZ128rrk_VMINCPHZ128rrkz_VMAXPHZ128rrk_VMAXPHZ128rrkz_VMINPHZ128rrk_VMINPHZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1874
  {DBGFIELD("VMAXCPHZ256rrk_VMAXCPHZ256rrkz_VMINCPHZ256rrk_VMINCPHZ256rrkz_VMAXPHZ256rrk_VMAXPHZ256rrkz_VMINPHZ256rrk_VMINPHZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1875
  {DBGFIELD("VMULPHZ128rrk_VMULPHZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1876
  {DBGFIELD("VMULPHZ256rrk_VMULPHZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1877
  {DBGFIELD("VMAXSHZrr_Intk_VMAXSHZrr_Intkz_VMAXSHZrrb_Intk_VMAXSHZrrb_Intkz_VMINSHZrr_Intk_VMINSHZrr_Intkz_VMINSHZrrb_Intk_VMINSHZrrb_Intkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1878
  {DBGFIELD("VMULSHZrr_Intk_VMULSHZrr_Intkz_VMULSHZrrb_Intk_VMULSHZrrb_Intkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1879
  {DBGFIELD("VADDPHZrr_VADDPHZrrb_VSUBPHZrr_VSUBPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1880
  {DBGFIELD("VAESDECLASTZrr_VAESDECZrr_VAESENCLASTZrr_VAESENCZrr") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1881
  {DBGFIELD("VCVTPH2UWZrr_VCVTPH2UWZrrb_VCVTPH2WZrr_VCVTPH2WZrrb_VCVTTPH2UWZrr_VCVTTPH2UWZrrb_VCVTTPH2WZrr_VCVTTPH2WZrrb_VCVTUW2PHZrr_VCVTUW2PHZrrb_VCVTW2PHZrr_VCVTW2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1882
  {DBGFIELD("VFMADD132PHZr_VFMADD132PHZrb_VFMADD213PHZr_VFMADD213PHZrb_VFMADD231PHZr_VFMADD231PHZrb_VFMSUB132PHZr_VFMSUB132PHZrb_VFMSUB213PHZr_VFMSUB213PHZrb_VFMSUB231PHZr_VFMSUB231PHZrb_VFNMADD132PHZr_VFNMADD132PHZrb_VFNMADD213PHZr_VFNMADD213PHZrb_VFNMADD231PHZr_VFNMADD231PHZrb_VFNMSUB132PHZr_VFNMSUB132PHZrb_VFNMSUB213PHZr_VFNMSUB213PHZrb_VFNMSUB231PHZr_VFNMSUB231PHZrb_VFMADDSUB132PHZr_VFMADDSUB132PHZrb_VFMADDSUB213PHZr_VFMADDSUB213PHZrb_VFMADDSUB231PHZr_VFMADDSUB231PHZrb_VFMSUBADD132PHZr_VFMSUBADD132PHZrb_VFMSUBADD213PHZr_VFMSUBADD213PHZrb_VFMSUBADD231PHZr_VFMSUBADD231PHZrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1883
  {DBGFIELD("VGETEXPPHZr_VGETEXPPHZrb_VGETMANTPHZrri_VGETMANTPHZrrib") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1884
  {DBGFIELD("VMAXCPHZrr_VMINCPHZrr_VMAXPHZrr_VMAXPHZrrb_VMINPHZrr_VMINPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1885
  {DBGFIELD("VMULPHZrr_VMULPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1886
  {DBGFIELD("VGF2P8MULBZrr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1887
  {DBGFIELD("VADDPHZrrbk_VADDPHZrrkz_VSUBPHZrrbk_VSUBPHZrrkz_VADDPHZrrbkz_VADDPHZrrk_VSUBPHZrrbkz_VSUBPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1888
  {DBGFIELD("VCVTPH2UWZrrbk_VCVTPH2UWZrrkz_VCVTPH2WZrrbk_VCVTPH2WZrrkz_VCVTTPH2UWZrrbk_VCVTTPH2UWZrrkz_VCVTTPH2WZrrbk_VCVTTPH2WZrrkz_VCVTPH2UWZrrbkz_VCVTPH2UWZrrk_VCVTPH2WZrrbkz_VCVTPH2WZrrk_VCVTTPH2UWZrrbkz_VCVTTPH2UWZrrk_VCVTTPH2WZrrbkz_VCVTTPH2WZrrk_VCVTUW2PHZrrbk_VCVTUW2PHZrrkz_VCVTW2PHZrrbk_VCVTW2PHZrrkz_VCVTUW2PHZrrbkz_VCVTUW2PHZrrk_VCVTW2PHZrrbkz_VCVTW2PHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1889
  {DBGFIELD("VFMADD132PHZrbk_VFMADD132PHZrkz_VFMADD213PHZrbk_VFMADD213PHZrkz_VFMADD231PHZrbk_VFMADD231PHZrkz_VFMSUB132PHZrbk_VFMSUB132PHZrkz_VFMSUB213PHZrbk_VFMSUB213PHZrkz_VFMSUB231PHZrbk_VFMSUB231PHZrkz_VFNMADD132PHZrbk_VFNMADD132PHZrkz_VFNMADD213PHZrbk_VFNMADD213PHZrkz_VFNMADD231PHZrbk_VFNMADD231PHZrkz_VFNMSUB132PHZrbk_VFNMSUB132PHZrkz_VFNMSUB213PHZrbk_VFNMSUB213PHZrkz_VFNMSUB231PHZrbk_VFNMSUB231PHZrkz_VFMADD132PHZrbkz_VFMADD132PHZrk_VFMADD213PHZrbkz_VFMADD213PHZrk_VFMADD231PHZrbkz_VFMADD231PHZrk_VFMSUB132PHZrbkz_VFMSUB132PHZrk_VFMSUB213PHZrbkz_VFMSUB213PHZrk_VFMSUB231PHZrbkz_VFMSUB231PHZrk_VFNMADD132PHZrbkz_VFNMADD132PHZrk_VFNMADD213PHZrbkz_VFNMADD213PHZrk_VFNMADD231PHZrbkz_VFNMADD231PHZrk_VFNMSUB132PHZrbkz_VFNMSUB132PHZrk_VFNMSUB213PHZrbkz_VFNMSUB213PHZrk_VFNMSUB231PHZrbkz_VFNMSUB231PHZrk_VFMADDSUB132PHZrbk_VFMADDSUB132PHZrkz_VFMADDSUB213PHZrbk_VFMADDSUB213PHZrkz_VFMADDSUB231PHZrbk_VFMADDSUB231PHZrkz_VFMADDSUB132PHZrbkz_VFMADDSUB132PHZrk_VFMADDSUB213PHZrbkz_VFMADDSUB213PHZrk_VFMADDSUB231PHZrbkz_VFMADDSUB231PHZrk_VFMSUBADD132PHZrbk_VFMSUBADD132PHZrkz_VFMSUBADD213PHZrbk_VFMSUBADD213PHZrkz_VFMSUBADD231PHZrbk_VFMSUBADD231PHZrkz_VFMSUBADD132PHZrbkz_VFMSUBADD132PHZrk_VFMSUBADD213PHZrbkz_VFMSUBADD213PHZrk_VFMSUBADD231PHZrbkz_VFMSUBADD231PHZrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1890
  {DBGFIELD("VGETEXPPHZrbk_VGETEXPPHZrkz_VGETEXPPHZrbkz_VGETEXPPHZrk_VGETMANTPHZrribk_VGETMANTPHZrrikz_VGETMANTPHZrribkz_VGETMANTPHZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1891
  {DBGFIELD("VMAXCPHZrrk_VMAXCPHZrrkz_VMINCPHZrrk_VMINCPHZrrkz_VMAXPHZrrbk_VMAXPHZrrkz_VMINPHZrrbk_VMINPHZrrkz_VMAXPHZrrbkz_VMAXPHZrrk_VMINPHZrrbkz_VMINPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1892
  {DBGFIELD("VMULPHZrrbk_VMULPHZrrkz_VMULPHZrrbkz_VMULPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1893
  {DBGFIELD("VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPSHUFHWZ128mik_VPSHUFHWZ128mikz_VPSHUFLWZ128mik_VPSHUFLWZ128mikz") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #1894
  {DBGFIELD("VPSHUFHWZ256mik_VPSHUFHWZ256mikz_VPSHUFLWZ256mik_VPSHUFLWZ256mikz") 2, false, false, false, 53, 7, 22, 1,  0, 0}, // #1895
  {DBGFIELD("VADDPSYrm_VSUBPSYrm_VADDPSZ256rm_VADDPSZ256rmb_VADDPSZ256rmbk_VADDPSZ256rmk_VADDPSZ256rmkz_VSUBPSZ256rm_VSUBPSZ256rmb_VSUBPSZ256rmbk_VSUBPSZ256rmk_VSUBPSZ256rmkz_VADDPSZ256rmbkz_VSUBPSZ256rmbkz") 2, false, false, false, 53, 7,  8, 1,  6, 1}, // #1896
  {DBGFIELD("VPSHUFBZ256rmk_VPSHUFBZ256rmkz") 2, false, false, false, 53, 7, 22, 1,  6, 1}, // #1897
  {DBGFIELD("VPUNPCKHBWZ256rmk_VPUNPCKHBWZ256rmkz_VPUNPCKHWDZ256rmk_VPUNPCKHWDZ256rmkz_VPUNPCKLBWZ256rmk_VPUNPCKLBWZ256rmkz_VPUNPCKLWDZ256rmk_VPUNPCKLWDZ256rmkz") 2, false, false, false, 53, 7, 22, 1,  6, 1}, // #1898
  {DBGFIELD("VADDSUBPSYrm")       2, false, false, false, 53, 7,  8, 1,  6, 1}, // #1899
  {DBGFIELD("VPSHUFBZ128rmk_VPSHUFBZ128rmkz") 2, false, false, false, 53, 7,  7, 1,  6, 1}, // #1900
  {DBGFIELD("VPUNPCKHBWZ128rmk_VPUNPCKHBWZ128rmkz_VPUNPCKHWDZ128rmk_VPUNPCKHWDZ128rmkz_VPUNPCKLBWZ128rmk_VPUNPCKLBWZ128rmkz_VPUNPCKLWDZ128rmk_VPUNPCKLWDZ128rmkz") 2, false, false, false, 53, 7,  7, 1,  6, 1}, // #1901
  {DBGFIELD("VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1902
  {DBGFIELD("VADDPSZrm_VADDPSZrmb_VADDPSZrmbk_VADDPSZrmk_VADDPSZrmkz_VSUBPSZrm_VSUBPSZrmb_VSUBPSZrmbk_VSUBPSZrmk_VSUBPSZrmkz_VADDPSZrmbkz_VSUBPSZrmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1903
  {DBGFIELD("VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1904
  {DBGFIELD("VADDPSZrrbk_VADDPSZrrkz_VSUBPSZrrbk_VSUBPSZrrkz_VADDPSZrrbkz_VADDPSZrrk_VSUBPSZrrbkz_VSUBPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1905
  {DBGFIELD("VPLZCNTDZrm_VPLZCNTDZrmb_VPLZCNTDZrmbk_VPLZCNTDZrmk_VPLZCNTDZrmkz_VPLZCNTQZrm_VPLZCNTQZrmb_VPLZCNTQZrmbk_VPLZCNTQZrmk_VPLZCNTQZrmkz_VPLZCNTDZrmbkz_VPLZCNTQZrmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1906
  {DBGFIELD("VAESDECLASTZrm_VAESDECZrm_VAESENCLASTZrm_VAESENCZrm") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #1907
  {DBGFIELD("VGF2P8AFFINEINVQBZrmbi_VGF2P8AFFINEINVQBZrmi_VGF2P8AFFINEQBZrmbi_VGF2P8AFFINEQBZrmi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1908
  {DBGFIELD("VGF2P8MULBZrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1909
  {DBGFIELD("VPMADD52HUQZm_VPMADD52HUQZmb_VPMADD52HUQZmbk_VPMADD52HUQZmk_VPMADD52HUQZmkz_VPMADD52LUQZm_VPMADD52LUQZmb_VPMADD52LUQZmbk_VPMADD52LUQZmk_VPMADD52LUQZmkz_VPMADD52HUQZmbkz_VPMADD52LUQZmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1910
  {DBGFIELD("VPOPCNTBZ256rm_VPOPCNTDZ256rm_VPOPCNTQZ256rm_VPOPCNTWZ256rm_VPOPCNTDZ256rmb_VPOPCNTDZ256rmk_VPOPCNTDZ256rmkz_VPOPCNTQZ256rmb_VPOPCNTQZ256rmk_VPOPCNTQZ256rmkz_VPOPCNTDZ256rmbk_VPOPCNTDZ256rmbkz_VPOPCNTQZ256rmbk_VPOPCNTQZ256rmbkz") 2, false, false, false, 68, 6, 22, 1,  0, 0}, // #1911
  {DBGFIELD("VPOPCNTBZrm_VPOPCNTDZrm_VPOPCNTQZrm_VPOPCNTWZrm_VPOPCNTDZrmb_VPOPCNTDZrmk_VPOPCNTDZrmkz_VPOPCNTQZrmb_VPOPCNTQZrmk_VPOPCNTQZrmkz_VPOPCNTDZrmbk_VPOPCNTDZrmbkz_VPOPCNTQZrmbk_VPOPCNTQZrmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1912
  {DBGFIELD("VPSHUFHWZmik_VPSHUFHWZmikz_VPSHUFLWZmik_VPSHUFLWZmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1913
  {DBGFIELD("VFPCLASSPDZ256rmb_VFPCLASSPSZ256rmb") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #1914
  {DBGFIELD("VFPCLASSPDZrmb_VFPCLASSPSZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1915
  {DBGFIELD("VFPCLASSPHZ256rmb")  2, false, false, false, 68, 6,  2, 1,  6, 1}, // #1916
  {DBGFIELD("VFPCLASSPHZrmb")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1917
  {DBGFIELD("VPALIGNRZrmik_VPALIGNRZrmikz_VPUNPCKHBWZrmk_VPUNPCKHBWZrmkz_VPUNPCKHWDZrmk_VPUNPCKHWDZrmkz_VPUNPCKLBWZrmk_VPUNPCKLBWZrmkz_VPUNPCKLWDZrmk_VPUNPCKLWDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1918
  {DBGFIELD("VPMULTISHIFTQBZ256rm_VPMULTISHIFTQBZ256rmb") 2, false, false, false, 68, 6, 22, 1,  6, 1}, // #1919
  {DBGFIELD("VPMULTISHIFTQBZrm_VPMULTISHIFTQBZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1920
  {DBGFIELD("VPCLMULQDQZrm")      2, false, false, false, 375, 10,  9, 1,  6, 1}, // #1921
  {DBGFIELD("VPCLMULQDQZ256rm")   2, false, false, false, 375, 10,  9, 1,  6, 1}, // #1922
  {DBGFIELD("VBLENDVPDYrm_VBLENDVPSYrm") 4, false, false, false, 638, 5,  9, 1,  8, 2}, // #1923
  {DBGFIELD("VPBLENDVBYrm")       4, false, false, false, 638, 5,  9, 1,  8, 2}, // #1924
  {DBGFIELD("VBLENDVPDYrr_VBLENDVPSYrr") 3, false, false, false, 223, 3,  5, 1,  0, 0}, // #1925
  {DBGFIELD("VPBLENDVBYrr")       3, false, false, false, 223, 3,  5, 1,  0, 0}, // #1926
  {DBGFIELD("VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPSZ256rmk_VMOVUPSZ256rmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1927
  {DBGFIELD("VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1928
  {DBGFIELD("VPADDBZ256rm_VPADDDZ256rm_VPADDQZ256rm_VPADDWZ256rm_VPSUBBZ256rm_VPSUBDZ256rm_VPSUBQZ256rm_VPSUBWZ256rm_VPADDDZ256rmb_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rmb_VPADDQZ256rmk_VPADDQZ256rmkz_VPSUBDZ256rmb_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rmb_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmik_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmik_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmikz") 2, false, false, false, 68, 6, 22, 1,  6, 1}, // #1929
  {DBGFIELD("VCMPPHZ128rmbi_VCMPPHZ128rmik_VCMPPHZ128rmbik_VCMPPHZ128rmi_VFPCLASSPHZ128rmbk_VFPCLASSPHZ128rmk") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1930
  {DBGFIELD("VCMPPHZ256rmbi_VCMPPHZ256rmik_VCMPPHZ256rmbik_VCMPPHZ256rmi_VFPCLASSPHZ256rmbk_VFPCLASSPHZ256rmk") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #1931
  {DBGFIELD("VCMPPHZrmbi_VCMPPHZrmik_VCMPPHZrmbik_VCMPPHZrmi_VFPCLASSPHZrmbk_VFPCLASSPHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1932
  {DBGFIELD("VCMPSHZrm_VCMPSHZrm_Int_VCMPSHZrm_Intk_VFPCLASSSHZrmk") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #1933
  {DBGFIELD("VCOMISHZrm_VCOMISHZrm_Int_VUCOMISHZrm_VUCOMISHZrm_Int") 2, false, false, false, 173, 10,  7, 1,  6, 1}, // #1934
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ256mr_VCOMPRESSPSZ128mr_VCOMPRESSPSZ256mr_VCOMPRESSPDZmr_VCOMPRESSPSZmr_VPCOMPRESSDZ128mr_VPCOMPRESSDZ256mr_VPCOMPRESSQZ128mr_VPCOMPRESSQZ256mr_VPCOMPRESSDZmr_VPCOMPRESSQZmr") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1935
  {DBGFIELD("VPMOVDBZmr_VPMOVQBZmr_VPMOVSQBZmr_VPMOVSWBZmr_VPMOVWBZmr_VPMOVDWZmr_VPMOVQWZmr_VPMOVSDWZmr_VPMOVSQWZmr_VPMOVUSDWZmr_VPMOVUSQWZmr_VPMOVSDBZmr_VPMOVSQDZmr_VPMOVUSDBZmr_VPMOVUSQDZmr_VPMOVUSQBZmr_VPMOVUSWBZmr") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1936
  {DBGFIELD("VPMOVDBZmrk_VPMOVQBZmrk_VPMOVSQBZmrk_VPMOVSWBZmrk_VPMOVWBZmrk_VPMOVDWZmrk_VPMOVQWZmrk_VPMOVSDWZmrk_VPMOVSQWZmrk_VPMOVUSDWZmrk_VPMOVUSQWZmrk_VPMOVSDBZmrk_VPMOVSQDZmrk_VPMOVUSDBZmrk_VPMOVUSQDZmrk_VPMOVUSQBZmrk_VPMOVUSWBZmrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1937
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPSZ128rr_VPCOMPRESSDZ128rr_VPCOMPRESSQZ128rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1938
  {DBGFIELD("VCOMPRESSPDZ256rr_VCOMPRESSPSZ256rr_VPCOMPRESSDZ256rr_VPCOMPRESSQZ256rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1939
  {DBGFIELD("VCOMPRESSPDZrr_VCOMPRESSPSZrr_VPCOMPRESSDZrr_VPCOMPRESSQZrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1940
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ256rr_VEXPANDPSZ128rr_VEXPANDPSZ256rr_VEXPANDPDZrr_VEXPANDPSZrr_VPEXPANDDZ128rr_VPEXPANDDZ256rr_VPEXPANDQZ128rr_VPEXPANDQZ256rr_VPEXPANDDZrr_VPEXPANDQZrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1941
  {DBGFIELD("VPCOMPRESSBZ128rr_VPCOMPRESSWZ128rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1942
  {DBGFIELD("VPCOMPRESSBZ256rr_VPCOMPRESSWZ256rr_VPEXPANDBZ256rr_VPEXPANDWZ256rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1943
  {DBGFIELD("VPCOMPRESSBZrr_VPCOMPRESSWZrr_VPEXPANDBZrr_VPEXPANDWZrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1944
  {DBGFIELD("VPEXPANDBZ128rr_VPEXPANDWZ128rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1945
  {DBGFIELD("VCVTDQ2PDZrrk_VCVTDQ2PDZrrkz_VCVTUDQ2PDZrrk_VCVTUDQ2PDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1946
  {DBGFIELD("VCVTPS2QQZrrb_VCVTPS2QQZrrbk_VCVTPS2QQZrrk_VCVTPS2QQZrrkz_VCVTPS2UQQZrrb_VCVTPS2UQQZrrbk_VCVTPS2UQQZrrk_VCVTPS2UQQZrrkz_VCVTTPS2QQZrrb_VCVTTPS2QQZrrbk_VCVTTPS2QQZrrk_VCVTTPS2QQZrrkz_VCVTTPS2UQQZrrb_VCVTTPS2UQQZrrbk_VCVTTPS2UQQZrrk_VCVTTPS2UQQZrrkz_VCVTPS2QQZrrbkz_VCVTPS2UQQZrrbkz_VCVTTPS2QQZrrbkz_VCVTTPS2UQQZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1947
  {DBGFIELD("VCVTQQ2PSZrrb_VCVTQQ2PSZrrbk_VCVTQQ2PSZrrk_VCVTQQ2PSZrrkz_VCVTUQQ2PSZrrb_VCVTUQQ2PSZrrbk_VCVTUQQ2PSZrrk_VCVTUQQ2PSZrrkz_VCVTQQ2PSZrrbkz_VCVTUQQ2PSZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1948
  {DBGFIELD("VCVTDQ2PHZ128rm_VCVTDQ2PHZ128rmb_VCVTUDQ2PHZ128rm_VCVTUDQ2PHZ128rmb") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1949
  {DBGFIELD("VCVTNEPS2BF16Z128rm_VCVTNEPS2BF16Z128rmb") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1950
  {DBGFIELD("VCVTDQ2PHZ128rmbk_VCVTDQ2PHZ128rmkz_VCVTUDQ2PHZ128rmbk_VCVTUDQ2PHZ128rmkz_VCVTDQ2PHZ128rmbkz_VCVTDQ2PHZ128rmk_VCVTUDQ2PHZ128rmbkz_VCVTUDQ2PHZ128rmk") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1951
  {DBGFIELD("VCVTDQ2PHZ128rr_VCVTUDQ2PHZ128rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1952
  {DBGFIELD("VCVTDQ2PHZ128rrk_VCVTDQ2PHZ128rrkz_VCVTUDQ2PHZ128rrk_VCVTUDQ2PHZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1953
  {DBGFIELD("VCVTDQ2PHZ256rm_VCVTDQ2PHZ256rmb_VCVTUDQ2PHZ256rm_VCVTUDQ2PHZ256rmb") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1954
  {DBGFIELD("VCVTNEPS2BF16Z128rmbk_VCVTNEPS2BF16Z128rmkz_VCVTNEPS2BF16Z128rmbkz_VCVTNEPS2BF16Z128rmk") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1955
  {DBGFIELD("VCVTDQ2PHZ256rmbk_VCVTDQ2PHZ256rmkz_VCVTUDQ2PHZ256rmbk_VCVTUDQ2PHZ256rmkz_VCVTDQ2PHZ256rmbkz_VCVTDQ2PHZ256rmk_VCVTUDQ2PHZ256rmbkz_VCVTUDQ2PHZ256rmk") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1956
  {DBGFIELD("VCVTDQ2PHZ256rr_VCVTUDQ2PHZ256rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1957
  {DBGFIELD("VCVTDQ2PHZ256rrk_VCVTDQ2PHZ256rrkz_VCVTUDQ2PHZ256rrk_VCVTUDQ2PHZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1958
  {DBGFIELD("VCVTDQ2PHZrm_VCVTDQ2PHZrmb_VCVTUDQ2PHZrm_VCVTUDQ2PHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1959
  {DBGFIELD("VCVTDQ2PHZrmbk_VCVTDQ2PHZrmkz_VCVTUDQ2PHZrmbk_VCVTUDQ2PHZrmkz_VCVTDQ2PHZrmbkz_VCVTDQ2PHZrmk_VCVTUDQ2PHZrmbkz_VCVTUDQ2PHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1960
  {DBGFIELD("VCVTDQ2PHZrr_VCVTDQ2PHZrrb_VCVTUDQ2PHZrr_VCVTUDQ2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1961
  {DBGFIELD("VCVTDQ2PHZrrbk_VCVTDQ2PHZrrkz_VCVTUDQ2PHZrrbk_VCVTUDQ2PHZrrkz_VCVTDQ2PHZrrbkz_VCVTDQ2PHZrrk_VCVTUDQ2PHZrrbkz_VCVTUDQ2PHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1962
  {DBGFIELD("VCVTNE2PS2BF16Z128rm_VCVTNE2PS2BF16Z128rmb") 3, false, false, false, 192, 11,  2, 1,  6, 1}, // #1963
  {DBGFIELD("VCVTNE2PS2BF16Z128rmbk_VCVTNE2PS2BF16Z128rmkz_VCVTNE2PS2BF16Z128rmbkz_VCVTNE2PS2BF16Z128rmk") 3, false, false, false, 192, 11,  2, 1,  6, 1}, // #1964
  {DBGFIELD("VCVTNE2PS2BF16Z128rr") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1965
  {DBGFIELD("VCVTNE2PS2BF16Z256rr") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1966
  {DBGFIELD("VCVTNE2PS2BF16Z128rrk_VCVTNE2PS2BF16Z128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1967
  {DBGFIELD("VCVTNE2PS2BF16Z256rrk_VCVTNE2PS2BF16Z256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1968
  {DBGFIELD("VCVTNE2PS2BF16Z256rm_VCVTNE2PS2BF16Z256rmb") 3, false, false, false, 192, 11, 11, 1,  6, 1}, // #1969
  {DBGFIELD("VCVTNE2PS2BF16Z256rmbk_VCVTNE2PS2BF16Z256rmkz_VCVTNE2PS2BF16Z256rmbkz_VCVTNE2PS2BF16Z256rmk") 3, false, false, false, 192, 11, 11, 1,  6, 1}, // #1970
  {DBGFIELD("VCVTNE2PS2BF16Zrm_VCVTNE2PS2BF16Zrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1971
  {DBGFIELD("VDPBF16PSZm_VDPBF16PSZmb_VDPBF16PSZmbk_VDPBF16PSZmk_VDPBF16PSZmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1972
  {DBGFIELD("VDPBF16PSZmbkz")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1973
  {DBGFIELD("VCVTNE2PS2BF16Zrmbk_VCVTNE2PS2BF16Zrmkz_VCVTNE2PS2BF16Zrmbkz_VCVTNE2PS2BF16Zrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1974
  {DBGFIELD("VCVTNE2PS2BF16Zrr")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1975
  {DBGFIELD("VCVTNE2PS2BF16Zrrk_VCVTNE2PS2BF16Zrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1976
  {DBGFIELD("VCVTNEPS2BF16Z128rr") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1977
  {DBGFIELD("VCVTNEPS2BF16Z256rr") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1978
  {DBGFIELD("VCVTNEPS2BF16Z128rrk_VCVTNEPS2BF16Z128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1979
  {DBGFIELD("VCVTNEPS2BF16Z256rrk_VCVTNEPS2BF16Z256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1980
  {DBGFIELD("VCVTNEPS2BF16Z256rm_VCVTNEPS2BF16Z256rmb") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #1981
  {DBGFIELD("VCVTNEPS2BF16Z256rmbk_VCVTNEPS2BF16Z256rmkz_VCVTNEPS2BF16Z256rmbkz_VCVTNEPS2BF16Z256rmk") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #1982
  {DBGFIELD("VCVTNEPS2BF16Zrm_VCVTNEPS2BF16Zrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1983
  {DBGFIELD("VCVTNEPS2BF16Zrmbk_VCVTNEPS2BF16Zrmkz_VCVTNEPS2BF16Zrmbkz_VCVTNEPS2BF16Zrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1984
  {DBGFIELD("VCVTNEPS2BF16Zrr")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1985
  {DBGFIELD("VCVTNEPS2BF16Zrrk_VCVTNEPS2BF16Zrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1986
  {DBGFIELD("VCVTPD2DQZ256rm_VCVTPD2DQZ256rmb_VCVTPD2UDQZ256rm_VCVTPD2UDQZ256rmb_VCVTTPD2DQZ256rm_VCVTTPD2DQZ256rmb_VCVTTPD2UDQZ256rm_VCVTTPD2UDQZ256rmb_VCVTPD2DQZ256rmbk_VCVTPD2DQZ256rmkz_VCVTPD2UDQZ256rmbk_VCVTPD2UDQZ256rmkz_VCVTTPD2DQZ256rmbk_VCVTTPD2DQZ256rmkz_VCVTTPD2UDQZ256rmbk_VCVTTPD2UDQZ256rmkz_VCVTPD2DQZ256rmbkz_VCVTPD2DQZ256rmk_VCVTPD2UDQZ256rmbkz_VCVTPD2UDQZ256rmk_VCVTTPD2DQZ256rmbkz_VCVTTPD2DQZ256rmk_VCVTTPD2UDQZ256rmbkz_VCVTTPD2UDQZ256rmk") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #1987
  {DBGFIELD("VCVTPH2DQZ256rm_VCVTPH2DQZ256rmb_VCVTPH2UDQZ256rm_VCVTPH2UDQZ256rmb_VCVTTPH2DQZ256rm_VCVTTPH2DQZ256rmb_VCVTTPH2UDQZ256rm_VCVTTPH2UDQZ256rmb") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1988
  {DBGFIELD("VCVTPH2PSXZ128rmbk_VCVTPH2PSXZ128rmkz_VCVTPH2PSXZ128rmbkz_VCVTPH2PSXZ128rmk") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1989
  {DBGFIELD("VCVTPH2PSXZ256rm_VCVTPH2PSXZ256rmb") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1990
  {DBGFIELD("VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz_VCVTQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmbkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1991
  {DBGFIELD("VCVTPH2DQZrm_VCVTPH2DQZrmb_VCVTPH2UDQZrm_VCVTPH2UDQZrmb_VCVTTPH2DQZrm_VCVTTPH2DQZrmb_VCVTTPH2UDQZrm_VCVTTPH2UDQZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1992
  {DBGFIELD("VCVTPH2PSXZrm_VCVTPH2PSXZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1993
  {DBGFIELD("VCVTPD2PHZ128rm_VCVTPD2PHZ128rmb") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1994
  {DBGFIELD("VCVTPD2PHZ128rmbk_VCVTPD2PHZ128rmkz_VCVTPD2PHZ128rmbkz_VCVTPD2PHZ128rmk") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1995
  {DBGFIELD("VCVTPD2PHZ128rr")    2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1996
  {DBGFIELD("VCVTPD2PHZ128rrk_VCVTPD2PHZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1997
  {DBGFIELD("VCVTPD2PHZ256rm_VCVTPD2PHZ256rmb") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #1998
  {DBGFIELD("VCVTPD2PHZ256rmbk_VCVTPD2PHZ256rmkz_VCVTPD2PHZ256rmbkz_VCVTPD2PHZ256rmk") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #1999
  {DBGFIELD("VCVTPD2PHZ256rr")    2, false, false, false, 183, 9,  6, 1,  0, 0}, // #2000
  {DBGFIELD("VCVTPD2PHZ256rrk_VCVTPD2PHZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #2001
  {DBGFIELD("VCVTPD2PHZrm_VCVTPD2PHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2002
  {DBGFIELD("VCVTPH2PDZrm_VCVTPH2PDZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2003
  {DBGFIELD("VCVTPD2PHZrmbk_VCVTPD2PHZrmkz_VCVTPD2PHZrmbkz_VCVTPD2PHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2004
  {DBGFIELD("VCVTPH2PDZrmbk_VCVTPH2PDZrmkz_VCVTPH2PDZrmbkz_VCVTPH2PDZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2005
  {DBGFIELD("VCVTPD2PHZrr_VCVTPD2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2006
  {DBGFIELD("VCVTPH2PDZrr_VCVTPH2PDZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2007
  {DBGFIELD("VCVTPD2PHZrrbk_VCVTPD2PHZrrkz_VCVTPD2PHZrrbkz_VCVTPD2PHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2008
  {DBGFIELD("VCVTPH2PDZrrbk_VCVTPH2PDZrrkz_VCVTPH2PDZrrbkz_VCVTPH2PDZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2009
  {DBGFIELD("VPABSBZ128rmk_VPABSBZ128rmkz_VPABSWZ128rmk_VPABSWZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  0, 0}, // #2010
  {DBGFIELD("VPABSBZ256rmk_VPABSBZ256rmkz_VPABSWZ256rmk_VPABSWZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  0, 0}, // #2011
  {DBGFIELD("VPLZCNTDZ128rm_VPLZCNTDZ128rmb_VPLZCNTDZ128rmbk_VPLZCNTDZ128rmk_VPLZCNTDZ128rmkz_VPLZCNTQZ128rm_VPLZCNTQZ128rmb_VPLZCNTQZ128rmbk_VPLZCNTQZ128rmk_VPLZCNTQZ128rmkz_VPLZCNTDZ128rmbkz_VPLZCNTQZ128rmbkz") 2, false, false, false, 68, 6, 24, 1,  0, 0}, // #2012
  {DBGFIELD("VPSLLWZ128mik_VPSLLWZ128mikz_VPSRLWZ128mik_VPSRLWZ128mikz_VPSRAWZ128mik_VPSRAWZ128mikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2013
  {DBGFIELD("VPSLLWZ256mik_VPSLLWZ256mikz_VPSRLWZ256mik_VPSRLWZ256mikz_VPSRAWZ256mik_VPSRAWZ256mikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2014
  {DBGFIELD("VFIXUPIMMSDZrmi_VFIXUPIMMSDZrmik_VFIXUPIMMSDZrmikz_VFIXUPIMMSSZrmi_VFIXUPIMMSSZrmik_VFIXUPIMMSSZrmikz_VSCALEFSDZrm_VSCALEFSDZrmk_VSCALEFSDZrmkz_VSCALEFSSZrm_VSCALEFSSZrmk_VSCALEFSSZrmkz") 2, false, false, false, 53, 7,  9, 1,  6, 1}, // #2015
  {DBGFIELD("VPADDSBZ128rmk_VPADDSBZ128rmkz_VPADDSWZ128rmk_VPADDSWZ128rmkz_VPADDUSBZ128rmk_VPADDUSBZ128rmkz_VPADDUSWZ128rmk_VPADDUSWZ128rmkz_VPSUBSBZ128rmk_VPSUBSBZ128rmkz_VPSUBSWZ128rmk_VPSUBSWZ128rmkz_VPSUBUSBZ128rmk_VPSUBUSBZ128rmkz_VPSUBUSWZ128rmk_VPSUBUSWZ128rmkz_VPAVGBZ128rmk_VPAVGBZ128rmkz_VPAVGWZ128rmk_VPAVGWZ128rmkz_VPMAXSBZ128rmk_VPMAXSBZ128rmkz_VPMAXUWZ128rmk_VPMAXUWZ128rmkz_VPMINSBZ128rmk_VPMINSBZ128rmkz_VPMINUWZ128rmk_VPMINUWZ128rmkz_VPMAXSWZ128rmk_VPMAXSWZ128rmkz_VPMAXUBZ128rmk_VPMAXUBZ128rmkz_VPMINSWZ128rmk_VPMINSWZ128rmkz_VPMINUBZ128rmk_VPMINUBZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  6, 1}, // #2016
  {DBGFIELD("VPSHLDVWZ128mk_VPSHLDVWZ128mkz_VPSHRDVWZ128mk_VPSHRDVWZ128mkz") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2017
  {DBGFIELD("VPSLLVWZ128rmk_VPSLLVWZ128rmkz_VPSRLVWZ128rmk_VPSRLVWZ128rmkz_VPSRAVWZ128rmk_VPSRAVWZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  6, 1}, // #2018
  {DBGFIELD("VPSLLWZ128rmk_VPSLLWZ128rmkz_VPSRLWZ128rmk_VPSRLWZ128rmkz_VPSRAWZ128rmk_VPSRAWZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  6, 1}, // #2019
  {DBGFIELD("VPADDSBZ256rmk_VPADDSBZ256rmkz_VPADDSWZ256rmk_VPADDSWZ256rmkz_VPADDUSBZ256rmk_VPADDUSBZ256rmkz_VPADDUSWZ256rmk_VPADDUSWZ256rmkz_VPSUBSBZ256rmk_VPSUBSBZ256rmkz_VPSUBSWZ256rmk_VPSUBSWZ256rmkz_VPSUBUSBZ256rmk_VPSUBUSBZ256rmkz_VPSUBUSWZ256rmk_VPSUBUSWZ256rmkz_VPAVGBZ256rmk_VPAVGBZ256rmkz_VPAVGWZ256rmk_VPAVGWZ256rmkz_VPMAXSBZ256rmk_VPMAXSBZ256rmkz_VPMAXUWZ256rmk_VPMAXUWZ256rmkz_VPMINSBZ256rmk_VPMINSBZ256rmkz_VPMINUWZ256rmk_VPMINUWZ256rmkz_VPMAXSWZ256rmk_VPMAXSWZ256rmkz_VPMAXUBZ256rmk_VPMAXUBZ256rmkz_VPMINSWZ256rmk_VPMINSWZ256rmkz_VPMINUBZ256rmk_VPMINUBZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  6, 1}, // #2020
  {DBGFIELD("VPSHLDVWZ256mk_VPSHLDVWZ256mkz_VPSHRDVWZ256mk_VPSHRDVWZ256mkz") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2021
  {DBGFIELD("VPSLLVWZ256rmk_VPSLLVWZ256rmkz_VPSRLVWZ256rmk_VPSRLVWZ256rmkz_VPSRAVWZ256rmk_VPSRAVWZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  6, 1}, // #2022
  {DBGFIELD("VPSLLWZ256rmk_VPSLLWZ256rmkz_VPSRLWZ256rmk_VPSRLWZ256rmkz_VPSRAWZ256rmk_VPSRAWZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  6, 1}, // #2023
  {DBGFIELD("VPMADD52HUQZ128m_VPMADD52HUQZ128mb_VPMADD52HUQZ128mbk_VPMADD52HUQZ128mk_VPMADD52HUQZ128mkz_VPMADD52LUQZ128m_VPMADD52LUQZ128mb_VPMADD52LUQZ128mbk_VPMADD52LUQZ128mk_VPMADD52LUQZ128mkz_VPMADD52HUQZ128mbkz_VPMADD52LUQZ128mbkz") 2, false, false, false, 68, 6, 24, 1, 10, 2}, // #2024
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2025
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #2026
  {DBGFIELD("VFIXUPIMMSDZrri_VFIXUPIMMSSZrri_VSCALEFSDZrr_VSCALEFSDZrrk_VSCALEFSDZrrkz_VSCALEFSSZrr_VSCALEFSSZrrk_VSCALEFSSZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2027
  {DBGFIELD("VPLZCNTDZ128rr_VPLZCNTDZ128rrk_VPLZCNTDZ128rrkz_VPLZCNTQZ128rr_VPLZCNTQZ128rrk_VPLZCNTQZ128rrkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2028
  {DBGFIELD("VPLZCNTDZ256rr_VPLZCNTDZ256rrk_VPLZCNTDZ256rrkz_VPLZCNTQZ256rr_VPLZCNTQZ256rrk_VPLZCNTQZ256rrkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2029
  {DBGFIELD("VPMADD52HUQZ128r_VPMADD52HUQZ128rk_VPMADD52HUQZ128rkz_VPMADD52LUQZ128r_VPMADD52LUQZ128rk_VPMADD52LUQZ128rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2030
  {DBGFIELD("VPMADD52HUQZ256r_VPMADD52HUQZ256rk_VPMADD52HUQZ256rkz_VPMADD52LUQZ256r_VPMADD52LUQZ256rk_VPMADD52LUQZ256rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2031
  {DBGFIELD("VFIXUPIMMSDZrrib_VFIXUPIMMSDZrribk_VFIXUPIMMSDZrribkz_VFIXUPIMMSSZrrib_VFIXUPIMMSSZrribk_VFIXUPIMMSSZrribkz") 2, false, false, false, 53, 7,  9, 1,  6, 1}, // #2032
  {DBGFIELD("VCVTPH2DQZ128rm_VCVTPH2DQZ128rmb_VCVTPH2UDQZ128rm_VCVTPH2UDQZ128rmb_VCVTTPH2DQZ128rm_VCVTTPH2DQZ128rmb_VCVTTPH2UDQZ128rm_VCVTTPH2UDQZ128rmb") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #2033
  {DBGFIELD("VCVTPS2PHXZ128rm_VCVTPS2PHXZ128rmb") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #2034
  {DBGFIELD("VCVTPH2DQZ128rmbk_VCVTPH2DQZ128rmkz_VCVTPH2UDQZ128rmbk_VCVTPH2UDQZ128rmkz_VCVTTPH2DQZ128rmbk_VCVTTPH2DQZ128rmkz_VCVTTPH2UDQZ128rmbk_VCVTTPH2UDQZ128rmkz_VCVTPH2DQZ128rmbkz_VCVTPH2DQZ128rmk_VCVTPH2UDQZ128rmbkz_VCVTPH2UDQZ128rmk_VCVTTPH2DQZ128rmbkz_VCVTTPH2DQZ128rmk_VCVTTPH2UDQZ128rmbkz_VCVTTPH2UDQZ128rmk") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #2035
  {DBGFIELD("VCVTPH2DQZ128rrk_VCVTPH2DQZ128rrkz_VCVTPH2UDQZ128rrk_VCVTPH2UDQZ128rrkz_VCVTTPH2DQZ128rrk_VCVTTPH2DQZ128rrkz_VCVTTPH2UDQZ128rrk_VCVTTPH2UDQZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2036
  {DBGFIELD("VCVTPH2DQZ256rrk_VCVTPH2DQZ256rrkz_VCVTPH2UDQZ256rrk_VCVTPH2UDQZ256rrkz_VCVTTPH2DQZ256rrk_VCVTTPH2DQZ256rrkz_VCVTTPH2UDQZ256rrk_VCVTTPH2UDQZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2037
  {DBGFIELD("VCVTPH2PSXZ256rrk_VCVTPH2PSXZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #2038
  {DBGFIELD("VCVTPH2PSZ256rrk_VCVTPH2PSZ256rrkz") 2, false, false, false, 183, 9,  7, 1,  0, 0}, // #2039
  {DBGFIELD("VCVTPS2PHXZ256rrk_VCVTPS2PHXZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #2040
  {DBGFIELD("VCVTPS2PHZ256rrk_VCVTPS2PHZ256rrkz") 2, false, false, false, 183, 9,  7, 1,  0, 0}, // #2041
  {DBGFIELD("VCVTPH2DQZ256rmbk_VCVTPH2DQZ256rmkz_VCVTPH2UDQZ256rmbk_VCVTPH2UDQZ256rmkz_VCVTTPH2DQZ256rmbk_VCVTTPH2DQZ256rmkz_VCVTTPH2UDQZ256rmbk_VCVTTPH2UDQZ256rmkz_VCVTPH2DQZ256rmbkz_VCVTPH2DQZ256rmk_VCVTPH2UDQZ256rmbkz_VCVTPH2UDQZ256rmk_VCVTTPH2DQZ256rmbkz_VCVTTPH2DQZ256rmk_VCVTTPH2UDQZ256rmbkz_VCVTTPH2UDQZ256rmk") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2042
  {DBGFIELD("VCVTPH2PSXZ256rmbk_VCVTPH2PSXZ256rmkz_VCVTPH2PSXZ256rmbkz_VCVTPH2PSXZ256rmk") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2043
  {DBGFIELD("VCVTPS2PHXZ256rmbk_VCVTPS2PHXZ256rmkz_VCVTPS2PHXZ256rmbkz_VCVTPS2PHXZ256rmk") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #2044
  {DBGFIELD("VCVTPH2DQZrmbk_VCVTPH2DQZrmkz_VCVTPH2UDQZrmbk_VCVTPH2UDQZrmkz_VCVTTPH2DQZrmbk_VCVTTPH2DQZrmkz_VCVTTPH2UDQZrmbk_VCVTTPH2UDQZrmkz_VCVTPH2DQZrmbkz_VCVTPH2DQZrmk_VCVTPH2UDQZrmbkz_VCVTPH2UDQZrmk_VCVTTPH2DQZrmbkz_VCVTTPH2DQZrmk_VCVTTPH2UDQZrmbkz_VCVTTPH2UDQZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2045
  {DBGFIELD("VCVTPH2PSXZrmbk_VCVTPH2PSXZrmkz_VCVTPH2PSXZrmbkz_VCVTPH2PSXZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2046
  {DBGFIELD("VCVTPS2PHXZrmbk_VCVTPS2PHXZrmkz_VCVTPS2PHXZrmbkz_VCVTPS2PHXZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2047
  {DBGFIELD("VCVTPH2DQZrr_VCVTPH2DQZrrb_VCVTPH2UDQZrr_VCVTPH2UDQZrrb_VCVTTPH2DQZrr_VCVTTPH2DQZrrb_VCVTTPH2UDQZrr_VCVTTPH2UDQZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2048
  {DBGFIELD("VCVTPH2PSXZrr_VCVTPH2PSXZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2049
  {DBGFIELD("VCVTPH2PSZrr_VCVTPH2PSZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2050
  {DBGFIELD("VCVTPS2PHXZrr_VCVTPS2PHXZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2051
  {DBGFIELD("VCVTPS2PHZrr_VCVTPS2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2052
  {DBGFIELD("VPSHUFBITQMBZ128rrk") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2053
  {DBGFIELD("VPSHUFBITQMBZ256rrk") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2054
  {DBGFIELD("VPSHUFBITQMBZrrk")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2055
  {DBGFIELD("VCVTPH2DQZrrbk_VCVTPH2DQZrrkz_VCVTPH2UDQZrrbk_VCVTPH2UDQZrrkz_VCVTTPH2DQZrrbk_VCVTTPH2DQZrrkz_VCVTTPH2UDQZrrbk_VCVTTPH2UDQZrrkz_VCVTPH2DQZrrbkz_VCVTPH2DQZrrk_VCVTPH2UDQZrrbkz_VCVTPH2UDQZrrk_VCVTTPH2DQZrrbkz_VCVTTPH2DQZrrk_VCVTTPH2UDQZrrbkz_VCVTTPH2UDQZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2056
  {DBGFIELD("VCVTPH2PSXZrrbk_VCVTPH2PSXZrrkz_VCVTPH2PSXZrrbkz_VCVTPH2PSXZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2057
  {DBGFIELD("VCVTPS2PHXZrrbk_VCVTPS2PHXZrrkz_VCVTPS2PHXZrrbkz_VCVTPS2PHXZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2058
  {DBGFIELD("VCVTPH2PDZ128rm_VCVTPH2PDZ128rmb") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #2059
  {DBGFIELD("VCVTPH2PDZ128rmbk_VCVTPH2PDZ128rmkz_VCVTPH2PDZ128rmbkz_VCVTPH2PDZ128rmk") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #2060
  {DBGFIELD("VCVTPH2PDZ128rr")    2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2061
  {DBGFIELD("VCVTPH2PDZ128rrk_VCVTPH2PDZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2062
  {DBGFIELD("VCVTPH2PDZ256rm_VCVTPH2PDZ256rmb") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2063
  {DBGFIELD("VCVTPH2PDZ256rmbk_VCVTPH2PDZ256rmkz_VCVTPH2PDZ256rmbkz_VCVTPH2PDZ256rmk") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2064
  {DBGFIELD("VCVTPH2PDZ256rr")    2, false, false, false, 183, 9,  6, 1,  0, 0}, // #2065
  {DBGFIELD("VCVTPH2PDZ256rrk_VCVTPH2PDZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #2066
  {DBGFIELD("VCVTPH2PSXZ128rrk_VCVTPH2PSXZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2067
  {DBGFIELD("VCVTPH2PSZ128rrk_VCVTPH2PSZ128rrkz") 2, false, false, false, 183, 9,  3, 1,  0, 0}, // #2068
  {DBGFIELD("VCVTPS2PHXZ128rrk_VCVTPS2PHXZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2069
  {DBGFIELD("VCVTPS2PHZ128rrk_VCVTPS2PHZ128rrkz") 2, false, false, false, 183, 9,  3, 1,  0, 0}, // #2070
  {DBGFIELD("VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2071
  {DBGFIELD("VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2072
  {DBGFIELD("VCVTSH2SSZrm_Intk_VCVTSH2SSZrm_Intkz") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #2073
  {DBGFIELD("VPMADDUBSWZ128rmk_VPMADDUBSWZ128rmkz_VPMULHRSWZ128rmk_VPMULHRSWZ128rmkz_VPMULHUWZ128rmk_VPMULHUWZ128rmkz_VPMULHWZ128rmk_VPMULHWZ128rmkz_VPMULLWZ128rmk_VPMULLWZ128rmkz") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2074
  {DBGFIELD("VPMADDUBSWZ256rmk_VPMADDUBSWZ256rmkz_VPMULHRSWZ256rmk_VPMULHRSWZ256rmkz_VPMULHUWZ256rmk_VPMULHUWZ256rmkz_VPMULHWZ256rmk_VPMULHWZ256rmkz_VPMULLWZ256rmk_VPMULLWZ256rmkz") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2075
  {DBGFIELD("VCVTPH2PSZrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2076
  {DBGFIELD("VPERMWZrmk_VPERMWZrmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2077
  {DBGFIELD("VCVTPH2QQZ128rm_VCVTPH2QQZ128rmb_VCVTPH2QQZ128rmbk_VCVTPH2QQZ128rmk_VCVTPH2QQZ128rmkz_VCVTPH2UQQZ128rm_VCVTPH2UQQZ128rmb_VCVTPH2UQQZ128rmbk_VCVTPH2UQQZ128rmk_VCVTPH2UQQZ128rmkz_VCVTTPH2QQZ128rm_VCVTTPH2QQZ128rmb_VCVTTPH2QQZ128rmbk_VCVTTPH2QQZ128rmk_VCVTTPH2QQZ128rmkz_VCVTTPH2UQQZ128rm_VCVTTPH2UQQZ128rmb_VCVTTPH2UQQZ128rmbk_VCVTTPH2UQQZ128rmk_VCVTTPH2UQQZ128rmkz_VCVTPH2QQZ128rmbkz_VCVTPH2UQQZ128rmbkz_VCVTTPH2QQZ128rmbkz_VCVTTPH2UQQZ128rmbkz") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #2078
  {DBGFIELD("VCVTPH2QQZ128rr_VCVTPH2QQZ128rrk_VCVTPH2QQZ128rrkz_VCVTPH2UQQZ128rr_VCVTPH2UQQZ128rrk_VCVTPH2UQQZ128rrkz_VCVTTPH2QQZ128rr_VCVTTPH2QQZ128rrk_VCVTTPH2QQZ128rrkz_VCVTTPH2UQQZ128rr_VCVTTPH2UQQZ128rrk_VCVTTPH2UQQZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2079
  {DBGFIELD("VCVTPH2QQZ256rr_VCVTPH2QQZ256rrk_VCVTPH2QQZ256rrkz_VCVTPH2UQQZ256rr_VCVTPH2UQQZ256rrk_VCVTPH2UQQZ256rrkz_VCVTTPH2QQZ256rr_VCVTTPH2QQZ256rrk_VCVTTPH2QQZ256rrkz_VCVTTPH2UQQZ256rr_VCVTTPH2UQQZ256rrk_VCVTTPH2UQQZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2080
  {DBGFIELD("VCVTPH2QQZ256rm_VCVTPH2QQZ256rmb_VCVTPH2QQZ256rmbk_VCVTPH2QQZ256rmk_VCVTPH2QQZ256rmkz_VCVTPH2UQQZ256rm_VCVTPH2UQQZ256rmb_VCVTPH2UQQZ256rmbk_VCVTPH2UQQZ256rmk_VCVTPH2UQQZ256rmkz_VCVTTPH2QQZ256rm_VCVTTPH2QQZ256rmb_VCVTTPH2QQZ256rmbk_VCVTTPH2QQZ256rmk_VCVTTPH2QQZ256rmkz_VCVTTPH2UQQZ256rm_VCVTTPH2UQQZ256rmb_VCVTTPH2UQQZ256rmbk_VCVTTPH2UQQZ256rmk_VCVTTPH2UQQZ256rmkz_VCVTPH2QQZ256rmbkz_VCVTPH2UQQZ256rmbkz_VCVTTPH2QQZ256rmbkz_VCVTTPH2UQQZ256rmbkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2081
  {DBGFIELD("VCVTPS2PHXZ128rmbk_VCVTPS2PHXZ128rmkz_VCVTPS2PHXZ128rmbkz_VCVTPS2PHXZ128rmk") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #2082
  {DBGFIELD("VCVTPS2PHXZ256rm_VCVTPS2PHXZ256rmb") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #2083
  {DBGFIELD("VCVTPS2PHXZrm_VCVTPS2PHXZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2084
  {DBGFIELD("VCVTPS2PHZ128mrk")   3, false, false, false, 643, 7,  2, 1,  0, 0}, // #2085
  {DBGFIELD("VCVTPS2PHZ256mrk")   3, false, false, false, 643, 7,  2, 1,  0, 0}, // #2086
  {DBGFIELD("VCVTPS2PHZmrk")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2087
  {DBGFIELD("VCVTQQ2PHZ128rm_VCVTQQ2PHZ128rmb_VCVTUQQ2PHZ128rm_VCVTUQQ2PHZ128rmb") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #2088
  {DBGFIELD("VCVTQQ2PHZ128rmbk_VCVTQQ2PHZ128rmkz_VCVTUQQ2PHZ128rmbk_VCVTUQQ2PHZ128rmkz_VCVTQQ2PHZ128rmbkz_VCVTQQ2PHZ128rmk_VCVTUQQ2PHZ128rmbkz_VCVTUQQ2PHZ128rmk") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #2089
  {DBGFIELD("VCVTQQ2PHZ128rr_VCVTUQQ2PHZ128rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2090
  {DBGFIELD("VCVTQQ2PHZ128rrk_VCVTQQ2PHZ128rrkz_VCVTUQQ2PHZ128rrk_VCVTUQQ2PHZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2091
  {DBGFIELD("VCVTQQ2PHZ256rr_VCVTUQQ2PHZ256rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2092
  {DBGFIELD("VCVTQQ2PHZ256rm_VCVTQQ2PHZ256rmb_VCVTUQQ2PHZ256rm_VCVTUQQ2PHZ256rmb") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2093
  {DBGFIELD("VCVTQQ2PHZ256rmbk_VCVTQQ2PHZ256rmkz_VCVTUQQ2PHZ256rmbk_VCVTUQQ2PHZ256rmkz_VCVTQQ2PHZ256rmbkz_VCVTQQ2PHZ256rmk_VCVTUQQ2PHZ256rmbkz_VCVTUQQ2PHZ256rmk") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #2094
  {DBGFIELD("VCVTQQ2PHZ256rrk_VCVTQQ2PHZ256rrkz_VCVTUQQ2PHZ256rrk_VCVTUQQ2PHZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2095
  {DBGFIELD("VCVTQQ2PHZrm_VCVTQQ2PHZrmb_VCVTUQQ2PHZrm_VCVTUQQ2PHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2096
  {DBGFIELD("VCVTQQ2PHZrmbk_VCVTQQ2PHZrmkz_VCVTUQQ2PHZrmbk_VCVTUQQ2PHZrmkz_VCVTQQ2PHZrmbkz_VCVTQQ2PHZrmk_VCVTUQQ2PHZrmbkz_VCVTUQQ2PHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2097
  {DBGFIELD("VCVTQQ2PHZrr_VCVTQQ2PHZrrb_VCVTUQQ2PHZrr_VCVTUQQ2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2098
  {DBGFIELD("VCVTQQ2PHZrrbk_VCVTQQ2PHZrrkz_VCVTUQQ2PHZrrbk_VCVTUQQ2PHZrrkz_VCVTQQ2PHZrrbkz_VCVTQQ2PHZrrk_VCVTUQQ2PHZrrbkz_VCVTUQQ2PHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2099
  {DBGFIELD("VCVTSD2SHZrm_VCVTSD2SHZrm_Int") 3, false, false, false, 192, 11,  2, 1,  6, 1}, // #2100
  {DBGFIELD("VCVTSD2SHZrm_Intk_VCVTSD2SHZrm_Intkz") 3, false, false, false, 192, 11,  2, 1,  6, 1}, // #2101
  {DBGFIELD("VCVTSD2SHZrr_Int_VCVTSD2SHZrrb_Int") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2102
  {DBGFIELD("VCVTSD2SHZrr")       2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2103
  {DBGFIELD("VCVTSD2SHZrr_Intk_VCVTSD2SHZrr_Intkz_VCVTSD2SHZrrb_Intk_VCVTSD2SHZrrb_Intkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2104
  {DBGFIELD("VCVTSH2SDZrm_VCVTSH2SDZrm_Int") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #2105
  {DBGFIELD("VCVTSH2SDZrm_Intk_VCVTSH2SDZrm_Intkz") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #2106
  {DBGFIELD("VCVTSH2SDZrr_Int_VCVTSH2SDZrrb_Int") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2107
  {DBGFIELD("VCVTSH2SDZrr")       2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2108
  {DBGFIELD("VCVTSH2SDZrr_Intk_VCVTSH2SDZrr_Intkz_VCVTSH2SDZrrb_Intk_VCVTSH2SDZrrb_Intkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2109
  {DBGFIELD("VCVTSH2SI64Zrm_Int_VCVTSH2SIZrm_Int_VCVTSH2USI64Zrm_Int_VCVTSH2USIZrm_Int_VCVTTSH2SI64Zrm_Int_VCVTTSH2SIZrm_Int_VCVTTSH2USI64Zrm_Int_VCVTTSH2USIZrm_Int_VCVTTSH2SI64Zrm_VCVTTSH2SIZrm_VCVTTSH2USI64Zrm_VCVTTSH2USIZrm") 3, false, false, false, 203, 10,  2, 1,  6, 1}, // #2110
  {DBGFIELD("VCVTSH2SI64Zrr_Int_VCVTSH2SI64Zrrb_Int_VCVTSH2SIZrr_Int_VCVTSH2SIZrrb_Int_VCVTSH2USI64Zrr_Int_VCVTSH2USI64Zrrb_Int_VCVTSH2USIZrr_Int_VCVTSH2USIZrrb_Int_VCVTTSH2SI64Zrr_Int_VCVTTSH2SI64Zrrb_Int_VCVTTSH2SIZrr_Int_VCVTTSH2SIZrrb_Int_VCVTTSH2USI64Zrr_Int_VCVTTSH2USI64Zrrb_Int_VCVTTSH2USIZrr_Int_VCVTTSH2USIZrrb_Int_VCVTTSH2SI64Zrr_VCVTTSH2SIZrr_VCVTTSH2USI64Zrr_VCVTTSH2USIZrr") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #2111
  {DBGFIELD("VCVTSH2SSZrr_Intk_VCVTSH2SSZrr_Intkz_VCVTSH2SSZrrb_Intk_VCVTSH2SSZrrb_Intkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2112
  {DBGFIELD("VCVTSI2SHZrm_VCVTSI2SHZrm_Int_VCVTSI642SHZrm_VCVTSI642SHZrm_Int_VCVTUSI2SHZrm_VCVTUSI2SHZrm_Int_VCVTUSI642SHZrm_VCVTUSI642SHZrm_Int") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #2113
  {DBGFIELD("VCVTSS2SHZrm_VCVTSS2SHZrm_Int") 3, false, false, false, 192, 11,  2, 1,  6, 1}, // #2114
  {DBGFIELD("VCVTSS2SHZrm_Intk_VCVTSS2SHZrm_Intkz") 3, false, false, false, 192, 11,  2, 1,  6, 1}, // #2115
  {DBGFIELD("VCVTSS2SHZrr_Int_VCVTSS2SHZrrb_Int") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2116
  {DBGFIELD("VCVTSS2SHZrr")       2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2117
  {DBGFIELD("VCVTSS2SHZrr_Intk_VCVTSS2SHZrr_Intkz_VCVTSS2SHZrrb_Intk_VCVTSS2SHZrrb_Intkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #2118
  {DBGFIELD("VDBPSADBWZ128rrik_VDBPSADBWZ128rrikz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2119
  {DBGFIELD("VDBPSADBWZ256rrik_VDBPSADBWZ256rrikz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2120
  {DBGFIELD("VDBPSADBWZrrik_VDBPSADBWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2121
  {DBGFIELD("VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2122
  {DBGFIELD("VPBROADCASTBZ256rrk_VPBROADCASTBZ256rrkz_VPBROADCASTBZrrk_VPBROADCASTBZrrkz_VPBROADCASTDrZ256rrk_VPBROADCASTDrZ256rrkz_VPBROADCASTDrZrrk_VPBROADCASTDrZrrkz_VPBROADCASTQrZ256rrk_VPBROADCASTQrZ256rrkz_VPBROADCASTQrZrrk_VPBROADCASTQrZrrkz_VPBROADCASTWZ256rrk_VPBROADCASTWZ256rrkz_VPBROADCASTWZrrk_VPBROADCASTWZrrkz_VPBROADCASTWrZ256rrk_VPBROADCASTWrZ256rrkz_VPBROADCASTWrZrrk_VPBROADCASTWrZrrkz_VPBROADCASTBrZ256rr_VPBROADCASTDrZ256rr_VPBROADCASTQrZ256rr_VPBROADCASTWrZ256rr_VPBROADCASTBrZ256rrk_VPBROADCASTBrZ256rrkz_VPBROADCASTBrZrr_VPBROADCASTDrZrr_VPBROADCASTQrZrr_VPBROADCASTWrZrr_VPBROADCASTBrZrrk_VPBROADCASTBrZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2123
  {DBGFIELD("VPBROADCASTBrZ128rr_VPBROADCASTDrZ128rr_VPBROADCASTQrZ128rr_VPBROADCASTWrZ128rr_VPBROADCASTBrZ128rrk_VPBROADCASTBrZ128rrkz_VPBROADCASTDrZ128rrk_VPBROADCASTDrZ128rrkz_VPBROADCASTQrZ128rrk_VPBROADCASTQrZ128rrkz_VPBROADCASTWrZ128rrk_VPBROADCASTWrZ128rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #2124
  {DBGFIELD("VPERMBZ128rrk_VPERMBZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2125
  {DBGFIELD("VPERMBZ256rrk_VPERMBZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2126
  {DBGFIELD("VPERMBZrrk_VPERMBZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2127
  {DBGFIELD("VPMOVSXBWZ256rrk_VPMOVSXBWZ256rrkz_VPMOVZXBWZ256rrk_VPMOVZXBWZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2128
  {DBGFIELD("VPMOVSXBWZrrk_VPMOVSXBWZrrkz_VPMOVZXBWZrrk_VPMOVZXBWZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2129
  {DBGFIELD("VPMULTISHIFTQBZ128rrk_VPMULTISHIFTQBZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2130
  {DBGFIELD("VPMULTISHIFTQBZ256rrk_VPMULTISHIFTQBZ256rrkz_VPOPCNTBZ256rrk_VPOPCNTBZ256rrkz_VPOPCNTWZ256rrk_VPOPCNTWZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2131
  {DBGFIELD("VPMULTISHIFTQBZrrk_VPMULTISHIFTQBZrrkz_VPOPCNTBZrrk_VPOPCNTBZrrkz_VPOPCNTWZrrk_VPOPCNTWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2132
  {DBGFIELD("VPOPCNTBZ128rrk_VPOPCNTBZ128rrkz_VPOPCNTWZ128rrk_VPOPCNTWZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2133
  {DBGFIELD("VDIVPHZ128rm_VDIVPHZ128rmb") 2, false, false, false, 173, 10, 13, 1,  6, 1}, // #2134
  {DBGFIELD("VDIVPHZ128rmbk_VDIVPHZ128rmkz_VDIVPHZ128rmbkz_VDIVPHZ128rmk") 2, false, false, false, 173, 10, 13, 1,  6, 1}, // #2135
  {DBGFIELD("VDIVPHZ128rr")       1, false, false, false,  2, 8,  8, 1,  0, 0}, // #2136
  {DBGFIELD("VDIVPHZ256rr")       1, false, false, false,  2, 8,  8, 1,  0, 0}, // #2137
  {DBGFIELD("VDIVPHZ128rrk")      1, false, false, false,  2, 8,  8, 1,  0, 0}, // #2138
  {DBGFIELD("VDIVPHZ256rrk")      1, false, false, false,  2, 8,  8, 1,  0, 0}, // #2139
  {DBGFIELD("VSQRTPHZ128r")       1, false, false, false,  2, 8,  2, 1,  0, 0}, // #2140
  {DBGFIELD("VSQRTPHZ256r")       1, false, false, false,  2, 8,  2, 1,  0, 0}, // #2141
  {DBGFIELD("VDIVPHZ128rrkz")     1, false, false, false,  2, 8,  8, 1,  0, 0}, // #2142
  {DBGFIELD("VDIVPHZ256rm_VDIVPHZ256rmb") 2, false, false, false, 173, 10, 17, 1,  6, 1}, // #2143
  {DBGFIELD("VDIVPHZ256rmbk_VDIVPHZ256rmkz_VDIVPHZ256rmbkz_VDIVPHZ256rmk") 2, false, false, false, 173, 10, 17, 1,  6, 1}, // #2144
  {DBGFIELD("VSQRTPHZ128m_VSQRTPHZ128mb") 2, false, false, false, 173, 10, 17, 1,  6, 1}, // #2145
  {DBGFIELD("VDIVPHZ256rrkz")     1, false, false, false,  2, 8,  8, 1,  0, 0}, // #2146
  {DBGFIELD("VDIVPHZrm_VDIVPHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2147
  {DBGFIELD("VDIVPHZrmbk_VDIVPHZrmkz_VDIVPHZrmbkz_VDIVPHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2148
  {DBGFIELD("VDIVPHZrr_VDIVPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2149
  {DBGFIELD("VDIVPHZrrbk_VDIVPHZrrkz_VDIVPHZrrbkz_VDIVPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2150
  {DBGFIELD("VDIVPSZrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2151
  {DBGFIELD("VDIVSHZrm_Int_VDIVSHZrm_Intk_VDIVSHZrm_Intkz") 2, false, false, false, 173, 10, 13, 1,  6, 1}, // #2152
  {DBGFIELD("VDIVSHZrm")          2, false, false, false, 173, 10, 13, 1,  6, 1}, // #2153
  {DBGFIELD("VDIVSHZrr_Int")      1, false, false, false,  2, 8,  8, 1,  0, 0}, // #2154
  {DBGFIELD("VSQRTSHZr_Int")      1, false, false, false,  2, 8,  2, 1,  0, 0}, // #2155
  {DBGFIELD("VDPBF16PSZ128m_VDPBF16PSZ128mb_VDPBF16PSZ128mbk_VDPBF16PSZ128mk_VDPBF16PSZ128mkz") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #2156
  {DBGFIELD("VDPBF16PSZ128mbkz")  2, false, false, false, 68, 6,  8, 1,  6, 1}, // #2157
  {DBGFIELD("VDPBF16PSZ256m_VDPBF16PSZ256mb_VDPBF16PSZ256mbk_VDPBF16PSZ256mk_VDPBF16PSZ256mkz") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #2158
  {DBGFIELD("VDPBF16PSZ256mbkz")  2, false, false, false, 68, 6,  2, 1,  6, 1}, // #2159
  {DBGFIELD("VPEXPANDBZ128rm_VPEXPANDWZ128rm") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2160
  {DBGFIELD("VFCMADDCPHZ128m_VFCMADDCPHZ128mb_VFMADDCPHZ128m_VFMADDCPHZ128mb") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2161
  {DBGFIELD("VFCMADDCPHZ256m_VFCMADDCPHZ256mb_VFMADDCPHZ256m_VFMADDCPHZ256mb") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2162
  {DBGFIELD("VROUNDPDYm_VROUNDPSYm") 3, false, false, false, 74, 6, 16, 1,  0, 0}, // #2163
  {DBGFIELD("VFCMADDCSHZm_VFMADDCSHZm_VFCMULCPHZ128rm_VFCMULCPHZ128rmb_VFMULCPHZ128rm_VFMULCPHZ128rmb_VFCMULCSHZrm_VFMULCSHZrm") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #2164
  {DBGFIELD("VRNDSCALEPHZ128rmbi_VRNDSCALEPHZ128rmi_VRNDSCALESHZm_VRNDSCALESHZm_Int") 3, false, false, false, 74, 6, 11, 1,  6, 1}, // #2165
  {DBGFIELD("VSCALEFPHZ128rm_VSCALEFPHZ128rmb") 2, false, false, false, 53, 7,  9, 1,  6, 1}, // #2166
  {DBGFIELD("VFCMULCPHZ256rm_VFCMULCPHZ256rmb_VFMULCPHZ256rm_VFMULCPHZ256rmb") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #2167
  {DBGFIELD("VRNDSCALEPDZ256rmbi_VRNDSCALEPDZ256rmi_VRNDSCALEPHZ256rmbi_VRNDSCALEPHZ256rmi_VRNDSCALEPSZ256rmbi_VRNDSCALEPSZ256rmi_VRNDSCALEPDZ256rmbik_VRNDSCALEPDZ256rmbikz_VRNDSCALEPDZ256rmik_VRNDSCALEPDZ256rmikz_VRNDSCALEPSZ256rmbik_VRNDSCALEPSZ256rmbikz_VRNDSCALEPSZ256rmik_VRNDSCALEPSZ256rmikz") 3, false, false, false, 74, 6, 16, 1,  6, 1}, // #2168
  {DBGFIELD("VSCALEFPHZ256rm_VSCALEFPHZ256rmb") 2, false, false, false, 53, 7,  8, 1,  6, 1}, // #2169
  {DBGFIELD("VSCALEFSHZrm")       2, false, false, false, 53, 7,  9, 1,  6, 1}, // #2170
  {DBGFIELD("VFCMADDCPHZ128mbk_VFCMADDCPHZ128mkz_VFMADDCPHZ128mbk_VFMADDCPHZ128mkz_VFCMADDCPHZ128mbkz_VFCMADDCPHZ128mk_VFMADDCPHZ128mbkz_VFMADDCPHZ128mk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2171
  {DBGFIELD("VFCMADDCPHZ256mbk_VFCMADDCPHZ256mkz_VFMADDCPHZ256mbk_VFMADDCPHZ256mkz_VFCMADDCPHZ256mbkz_VFCMADDCPHZ256mk_VFMADDCPHZ256mbkz_VFMADDCPHZ256mk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2172
  {DBGFIELD("VFCMADDCSHZmk_VFCMADDCSHZmkz_VFMADDCSHZmk_VFMADDCSHZmkz_VFCMULCPHZ128rmbk_VFCMULCPHZ128rmkz_VFMULCPHZ128rmbk_VFMULCPHZ128rmkz_VFCMULCPHZ128rmbkz_VFCMULCPHZ128rmk_VFMULCPHZ128rmbkz_VFMULCPHZ128rmk_VFCMULCSHZrmk_VFCMULCSHZrmkz_VFMULCSHZrmk_VFMULCSHZrmkz") 2, false, false, false, 68, 6,  8, 1,  6, 1}, // #2173
  {DBGFIELD("VFCMULCPHZ256rmbk_VFCMULCPHZ256rmkz_VFMULCPHZ256rmbk_VFMULCPHZ256rmkz_VFCMULCPHZ256rmbkz_VFCMULCPHZ256rmk_VFMULCPHZ256rmbkz_VFMULCPHZ256rmk") 2, false, false, false, 68, 6,  2, 1,  6, 1}, // #2174
  {DBGFIELD("VFCMADDCPHZ128r_VFMADDCPHZ128r_VFCMADDCSHZr_VFCMADDCSHZrb_VFMADDCSHZr_VFMADDCSHZrb_VFCMULCPHZ128rr_VFMULCPHZ128rr_VFCMULCSHZrr_VFCMULCSHZrrb_VFMULCSHZrr_VFMULCSHZrrb") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2175
  {DBGFIELD("VFCMADDCPHZ256r_VFMADDCPHZ256r_VFCMULCPHZ256rr_VFMULCPHZ256rr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2176
  {DBGFIELD("VRNDSCALEPHZ128rri_VRNDSCALESHZr_Int_VRNDSCALESHZrb_Int") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2177
  {DBGFIELD("VRNDSCALEPHZ256rri") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2178
  {DBGFIELD("VSCALEFPHZ128rr")    1, false, false, false, 53, 5,  5, 1,  0, 0}, // #2179
  {DBGFIELD("VSCALEFPHZ256rr")    1, false, false, false, 53, 5,  5, 1,  0, 0}, // #2180
  {DBGFIELD("VRNDSCALESHZr")      2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2181
  {DBGFIELD("VSCALEFSHZrr_VSCALEFSHZrrb_Int") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2182
  {DBGFIELD("VFCMADDCPHZ128rk_VFCMADDCPHZ128rkz_VFMADDCPHZ128rk_VFMADDCPHZ128rkz_VFCMADDCSHZrbk_VFCMADDCSHZrkz_VFMADDCSHZrbk_VFMADDCSHZrkz_VFCMADDCSHZrbkz_VFCMADDCSHZrk_VFMADDCSHZrbkz_VFMADDCSHZrk_VFCMULCPHZ128rrk_VFCMULCPHZ128rrkz_VFMULCPHZ128rrk_VFMULCPHZ128rrkz_VFCMULCSHZrrbk_VFCMULCSHZrrkz_VFMULCSHZrrbk_VFMULCSHZrrkz_VFCMULCSHZrrbkz_VFCMULCSHZrrk_VFMULCSHZrrbkz_VFMULCSHZrrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2183
  {DBGFIELD("VFCMADDCPHZ256rk_VFCMADDCPHZ256rkz_VFMADDCPHZ256rk_VFMADDCPHZ256rkz_VFCMULCPHZ256rrk_VFCMULCPHZ256rrkz_VFMULCPHZ256rrk_VFMULCPHZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #2184
  {DBGFIELD("VFCMADDCPHZm_VFCMADDCPHZmb_VFMADDCPHZm_VFMADDCPHZmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2185
  {DBGFIELD("VFCMULCPHZrm_VFCMULCPHZrmb_VFMULCPHZrm_VFMULCPHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2186
  {DBGFIELD("VRNDSCALEPDZrmbi_VRNDSCALEPDZrmi_VRNDSCALEPHZrmbi_VRNDSCALEPHZrmi_VRNDSCALEPSZrmbi_VRNDSCALEPSZrmi_VRNDSCALEPDZrmbik_VRNDSCALEPDZrmbikz_VRNDSCALEPDZrmik_VRNDSCALEPDZrmikz_VRNDSCALEPSZrmbik_VRNDSCALEPSZrmbikz_VRNDSCALEPSZrmik_VRNDSCALEPSZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2187
  {DBGFIELD("VSCALEFPHZrm_VSCALEFPHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2188
  {DBGFIELD("VFCMADDCPHZmbk_VFCMADDCPHZmkz_VFMADDCPHZmbk_VFMADDCPHZmkz_VFCMADDCPHZmbkz_VFCMADDCPHZmk_VFMADDCPHZmbkz_VFMADDCPHZmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2189
  {DBGFIELD("VFCMULCPHZrmbk_VFCMULCPHZrmkz_VFMULCPHZrmbk_VFMULCPHZrmkz_VFCMULCPHZrmbkz_VFCMULCPHZrmk_VFMULCPHZrmbkz_VFMULCPHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2190
  {DBGFIELD("VFCMADDCPHZr_VFCMADDCPHZrb_VFMADDCPHZr_VFMADDCPHZrb_VFCMULCPHZrr_VFCMULCPHZrrb_VFMULCPHZrr_VFMULCPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2191
  {DBGFIELD("VRNDSCALEPHZrri_VRNDSCALEPHZrrib") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2192
  {DBGFIELD("VSCALEFPHZrr_VSCALEFPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2193
  {DBGFIELD("VFCMADDCPHZrbk_VFCMADDCPHZrkz_VFMADDCPHZrbk_VFMADDCPHZrkz_VFCMADDCPHZrbkz_VFCMADDCPHZrk_VFMADDCPHZrbkz_VFMADDCPHZrk_VFCMULCPHZrrbk_VFCMULCPHZrrkz_VFMULCPHZrrbk_VFMULCPHZrrkz_VFCMULCPHZrrbkz_VFCMULCPHZrrk_VFMULCPHZrrbkz_VFMULCPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2194
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 1, false, false, false, 28, 2, 42, 2,  0, 0}, // #2195
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQQZ256rm") 1, false, false, false, 28, 2, 42, 2,  0, 0}, // #2196
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm") 1, false, false, false, 28, 2, 42, 2,  0, 0}, // #2197
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 1, false, false, false, 28, 2, 42, 2,  0, 0}, // #2198
  {DBGFIELD("VGATHERQPSZrm_VPGATHERQDZrm") 1, false, false, false, 28, 2, 42, 2,  0, 0}, // #2199
  {DBGFIELD("VGF2P8AFFINEINVQBZ128rmbik_VGF2P8AFFINEINVQBZ128rmbikz_VGF2P8AFFINEINVQBZ128rmik_VGF2P8AFFINEINVQBZ128rmikz_VGF2P8AFFINEQBZ128rmbik_VGF2P8AFFINEQBZ128rmbikz_VGF2P8AFFINEQBZ128rmik_VGF2P8AFFINEQBZ128rmikz") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2200
  {DBGFIELD("VGF2P8MULBZ128rmk_VGF2P8MULBZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  6, 1}, // #2201
  {DBGFIELD("VGF2P8AFFINEINVQBZ256rmbik_VGF2P8AFFINEINVQBZ256rmbikz_VGF2P8AFFINEINVQBZ256rmik_VGF2P8AFFINEINVQBZ256rmikz_VGF2P8AFFINEQBZ256rmbik_VGF2P8AFFINEQBZ256rmbikz_VGF2P8AFFINEQBZ256rmik_VGF2P8AFFINEQBZ256rmikz") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2202
  {DBGFIELD("VGF2P8MULBZ256rmk_VGF2P8MULBZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  6, 1}, // #2203
  {DBGFIELD("VGF2P8AFFINEINVQBZ128rrik_VGF2P8AFFINEQBZ128rrik") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2204
  {DBGFIELD("VGF2P8AFFINEINVQBZ256rrik_VGF2P8AFFINEQBZ256rrik") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2205
  {DBGFIELD("VGF2P8MULBZ128rrk")  1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2206
  {DBGFIELD("VGF2P8MULBZ256rrk")  1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2207
  {DBGFIELD("VGF2P8AFFINEINVQBZ128rrikz_VGF2P8AFFINEQBZ128rrikz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2208
  {DBGFIELD("VGF2P8AFFINEINVQBZ256rrikz_VGF2P8AFFINEQBZ256rrikz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2209
  {DBGFIELD("VGF2P8MULBZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2210
  {DBGFIELD("VGF2P8MULBZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2211
  {DBGFIELD("VGF2P8AFFINEINVQBZrmbik_VGF2P8AFFINEINVQBZrmbikz_VGF2P8AFFINEINVQBZrmik_VGF2P8AFFINEINVQBZrmikz_VGF2P8AFFINEQBZrmbik_VGF2P8AFFINEQBZrmbikz_VGF2P8AFFINEQBZrmik_VGF2P8AFFINEQBZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2212
  {DBGFIELD("VGF2P8MULBZrmk_VGF2P8MULBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2213
  {DBGFIELD("VGF2P8AFFINEINVQBZrrik_VGF2P8AFFINEQBZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2214
  {DBGFIELD("VGF2P8MULBZrrk")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2215
  {DBGFIELD("VGF2P8AFFINEINVQBZrrikz_VGF2P8AFFINEQBZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2216
  {DBGFIELD("VGF2P8MULBZrrkz")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2217
  {DBGFIELD("VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #2218
  {DBGFIELD("VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #2219
  {DBGFIELD("VMOVSHZrmk_VMOVSHZrmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #2220
  {DBGFIELD("VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 2, false, false, false, 69, 5,  7, 1,  6, 1}, // #2221
  {DBGFIELD("VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 4, false, false, false, 638, 5,  9, 1,  6, 1}, // #2222
  {DBGFIELD("VMOVDQU16Z128rrk_VMOVDQU16Z128rrk_REV_VMOVDQU16Z128rrkz_VMOVDQU16Z128rrkz_REV_VMOVDQU8Z128rrk_VMOVDQU8Z128rrk_REV_VMOVDQU8Z128rrkz_VMOVDQU8Z128rrkz_REV_VPMOVM2BZ128rr_VPMOVM2WZ128rr") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #2223
  {DBGFIELD("VMOVDQU16Z256rrk_VMOVDQU16Z256rrk_REV_VMOVDQU16Z256rrkz_VMOVDQU16Z256rrkz_REV_VMOVDQU8Z256rrk_VMOVDQU8Z256rrk_REV_VMOVDQU8Z256rrkz_VMOVDQU8Z256rrkz_REV_VPMOVM2BZ256rr_VPMOVM2WZ256rr") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #2224
  {DBGFIELD("VMOVSHZrrk_VMOVSHZrrk_REV_VMOVSHZrrkz_VMOVSHZrrkz_REV") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #2225
  {DBGFIELD("VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #2226
  {DBGFIELD("VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 3, false, false, false, 223, 3,  5, 1,  0, 0}, // #2227
  {DBGFIELD("VMOVDQU8Zmrk")       2, false, false, false, 37, 3,  2, 1,  0, 0}, // #2228
  {DBGFIELD("VMOVNTDQZ128mr")     2, false, false, false, 37, 3, 25, 1,  0, 0}, // #2229
  {DBGFIELD("VMOVNTDQZ256mr")     2, false, false, false, 37, 3, 44, 1,  0, 0}, // #2230
  {DBGFIELD("VMOVNTDQZmr")        2, false, false, false, 37, 3, 44, 1,  0, 0}, // #2231
  {DBGFIELD("VMOVNTPDZ128mr")     2, false, false, false, 37, 3, 27, 1,  0, 0}, // #2232
  {DBGFIELD("VMOVNTPDZ256mr")     2, false, false, false, 37, 3, 45, 1,  0, 0}, // #2233
  {DBGFIELD("VMOVNTPDZmr")        2, false, false, false, 37, 3, 45, 1,  0, 0}, // #2234
  {DBGFIELD("VMOVNTPSZ128mr")     2, false, false, false, 37, 3, 27, 1,  0, 0}, // #2235
  {DBGFIELD("VMOVNTPSZ256mr")     2, false, false, false, 37, 3, 45, 1,  0, 0}, // #2236
  {DBGFIELD("VMOVNTPSZmr")        2, false, false, false, 37, 3, 45, 1,  0, 0}, // #2237
  {DBGFIELD("VP2INTERSECTDZ128rm_VP2INTERSECTDZ128rmb") 2, false, false, false, 68, 6,  7, 1,  6, 1}, // #2238
  {DBGFIELD("VP2INTERSECTQZ256rm_VP2INTERSECTQZ256rmb") 2, false, false, false, 68, 6, 22, 1,  6, 1}, // #2239
  {DBGFIELD("VP2INTERSECTDZ128rr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2240
  {DBGFIELD("VP2INTERSECTQZ256rr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2241
  {DBGFIELD("VP2INTERSECTDZ256rm_VP2INTERSECTDZ256rmb") 2, false, false, false, 68, 6, 22, 1,  6, 1}, // #2242
  {DBGFIELD("VP2INTERSECTDZ256rr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2243
  {DBGFIELD("VP2INTERSECTDZrm_VP2INTERSECTDZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2244
  {DBGFIELD("VP2INTERSECTDZrr")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2245
  {DBGFIELD("VP2INTERSECTQZ128rm_VP2INTERSECTQZ128rmb") 2, false, false, false, 68, 6,  7, 1,  6, 1}, // #2246
  {DBGFIELD("VP2INTERSECTQZ128rr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2247
  {DBGFIELD("VP2INTERSECTQZrm_VP2INTERSECTQZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2248
  {DBGFIELD("VP2INTERSECTQZrr")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2249
  {DBGFIELD("VPABSBZ128rrk_VPABSBZ128rrkz_VPABSWZ128rrk_VPABSWZ128rrkz_VPSUBSBZ128rrk_VPSUBSBZ128rrkz_VPSUBSWZ128rrk_VPSUBSWZ128rrkz_VPADDSBZ128rrk_VPADDSBZ128rrkz_VPADDSWZ128rrk_VPADDSWZ128rrkz_VPADDUSBZ128rrk_VPADDUSBZ128rrkz_VPADDUSWZ128rrk_VPADDUSWZ128rrkz_VPAVGBZ128rrk_VPAVGBZ128rrkz_VPAVGWZ128rrk_VPAVGWZ128rrkz_VPSUBUSBZ128rrk_VPSUBUSBZ128rrkz_VPSUBUSWZ128rrk_VPSUBUSWZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2250
  {DBGFIELD("VPABSBZ256rrk_VPABSBZ256rrkz_VPABSWZ256rrk_VPABSWZ256rrkz_VPSUBSBZ256rrk_VPSUBSBZ256rrkz_VPSUBSWZ256rrk_VPSUBSWZ256rrkz_VPADDSBZ256rrk_VPADDSBZ256rrkz_VPADDSWZ256rrk_VPADDSWZ256rrkz_VPADDUSBZ256rrk_VPADDUSBZ256rrkz_VPADDUSWZ256rrk_VPADDUSWZ256rrkz_VPAVGBZ256rrk_VPAVGBZ256rrkz_VPAVGWZ256rrk_VPAVGWZ256rrkz_VPMAXSBZ256rrk_VPMAXSBZ256rrkz_VPMAXUWZ256rrk_VPMAXUWZ256rrkz_VPMINSBZ256rrk_VPMINSBZ256rrkz_VPMINUWZ256rrk_VPMINUWZ256rrkz_VPMAXSWZ256rrk_VPMAXSWZ256rrkz_VPMAXUBZ256rrk_VPMAXUBZ256rrkz_VPMINSWZ256rrk_VPMINSWZ256rrkz_VPMINUBZ256rrk_VPMINUBZ256rrkz_VPSUBUSBZ256rrk_VPSUBUSBZ256rrkz_VPSUBUSWZ256rrk_VPSUBUSWZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2251
  {DBGFIELD("VPMAXSBZ128rrk_VPMAXSBZ128rrkz_VPMAXUWZ128rrk_VPMAXUWZ128rrkz_VPMINSBZ128rrk_VPMINSBZ128rrkz_VPMINUWZ128rrk_VPMINUWZ128rrkz_VPMAXSWZ128rrk_VPMAXSWZ128rrkz_VPMAXUBZ128rrk_VPMAXUBZ128rrkz_VPMINSWZ128rrk_VPMINSWZ128rrkz_VPMINUBZ128rrk_VPMINUBZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2252
  {DBGFIELD("VPSHLDVWZ128rk_VPSHLDVWZ128rkz_VPSHRDVWZ128rk_VPSHRDVWZ128rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2253
  {DBGFIELD("VPSHLDVWZ256rk_VPSHLDVWZ256rkz_VPSHRDVWZ256rk_VPSHRDVWZ256rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2254
  {DBGFIELD("VPSLLVWZ128rrk_VPSLLVWZ128rrkz_VPSRLVWZ128rrk_VPSRLVWZ128rrkz_VPSRAVWZ128rrk_VPSRAVWZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2255
  {DBGFIELD("VPSLLVWZ256rrk_VPSLLVWZ256rrkz_VPSRLVWZ256rrk_VPSRLVWZ256rrkz_VPSRAVWZ256rrk_VPSRAVWZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2256
  {DBGFIELD("VPSLLWZ128rik_VPSLLWZ128rikz_VPSRLWZ128rik_VPSRLWZ128rikz_VPSRAWZ128rik_VPSRAWZ128rikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2257
  {DBGFIELD("VPSLLWZ256rik_VPSLLWZ256rikz_VPSRLWZ256rik_VPSRLWZ256rikz_VPSRAWZ256rik_VPSRAWZ256rikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #2258
  {DBGFIELD("VSHUFPDZ256rmbi_VSHUFPDZ256rmik_VSHUFPSZ256rmbi_VSHUFPSZ256rmik_VSHUFPDZ256rmbik_VSHUFPDZ256rmbikz_VSHUFPSZ256rmbik_VSHUFPSZ256rmbikz_VSHUFPDZ256rmi_VSHUFPDZ256rmikz_VSHUFPSZ256rmi_VSHUFPSZ256rmikz") 2, false, false, false, 375, 10, 22, 1,  6, 1}, // #2259
  {DBGFIELD("VPBROADCASTMB2QZ128rr_VPBROADCASTMB2QZ256rr_VPBROADCASTMW2DZ128rr_VPBROADCASTMW2DZ256rr_VPBROADCASTMB2QZrr_VPBROADCASTMW2DZrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #2260
  {DBGFIELD("VPERMWZrrk_VPERMWZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2261
  {DBGFIELD("VPSRAWZrrk_VPSRAWZrrkz_VPSLLWZrrk_VPSLLWZrrkz_VPSRLWZrrk_VPSRLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2262
  {DBGFIELD("VPSHUFBITQMBZ128rr") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2263
  {DBGFIELD("VPSHUFBITQMBZ256rr") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2264
  {DBGFIELD("VPSHUFBITQMBZrr")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2265
  {DBGFIELD("VPCOMPRESSBZ128mr_VPCOMPRESSBZ256mr_VPCOMPRESSWZ128mr_VPCOMPRESSWZ256mr") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2266
  {DBGFIELD("VPCOMPRESSWZmr")     2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2267
  {DBGFIELD("VPCOMPRESSBZ128mrk_VPCOMPRESSBZ256mrk_VPCOMPRESSWZ128mrk_VPCOMPRESSWZ256mrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2268
  {DBGFIELD("VPCOMPRESSWZmrk")    2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2269
  {DBGFIELD("VPCOMPRESSBZmr")     2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2270
  {DBGFIELD("VPCOMPRESSBZmrk")    2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2271
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  0, 0}, // #2272
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  0, 0}, // #2273
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2274
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2275
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  0, 0}, // #2276
  {DBGFIELD("VPERMI2BZ128rm_VPERMT2BZ128rm") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2277
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  0, 0}, // #2278
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2279
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2280
  {DBGFIELD("VPERMI2BZ128rmk_VPERMI2BZ128rmkz_VPERMT2BZ128rmk_VPERMT2BZ128rmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2281
  {DBGFIELD("VPERMT2WZ128rm")     2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2282
  {DBGFIELD("VPERMI2BZ128rr_VPERMT2BZ128rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2283
  {DBGFIELD("VPERMI2BZ256rr_VPERMT2BZ256rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2284
  {DBGFIELD("VPERMI2BZ256rrk_VPERMI2BZ256rrkz_VPERMT2BZ256rrk_VPERMT2BZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2285
  {DBGFIELD("VPERMI2WZ128rr_VPERMT2WZ128rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2286
  {DBGFIELD("VPERMI2WZ256rr_VPERMT2WZ256rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2287
  {DBGFIELD("VPERMI2BZ256rm_VPERMT2BZ256rm") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2288
  {DBGFIELD("VPERMI2BZ256rmk_VPERMI2BZ256rmkz_VPERMT2BZ256rmk_VPERMT2BZ256rmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2289
  {DBGFIELD("VPERMI2WZ128rm")     2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2290
  {DBGFIELD("VPERMT2WZ256rm")     2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2291
  {DBGFIELD("VPERMI2BZrm_VPERMT2BZrm") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2292
  {DBGFIELD("VPERMI2BZrmk_VPERMI2BZrmkz_VPERMT2BZrmk_VPERMT2BZrmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2293
  {DBGFIELD("VPERMT2WZrm")        2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2294
  {DBGFIELD("VPERMI2BZrr_VPERMT2BZrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2295
  {DBGFIELD("VPERMI2BZrrk_VPERMI2BZrrkz_VPERMT2BZrrk_VPERMT2BZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2296
  {DBGFIELD("VPERMI2WZrr_VPERMT2WZrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2297
  {DBGFIELD("VPERMI2WZ128rmk_VPERMI2WZ128rmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2298
  {DBGFIELD("VPERMT2WZ256rmk_VPERMT2WZ256rmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2299
  {DBGFIELD("VPERMI2WZ256rm")     2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2300
  {DBGFIELD("VPERMI2WZ256rmk_VPERMI2WZ256rmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2301
  {DBGFIELD("VPERMI2WZrm")        2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2302
  {DBGFIELD("VPERMI2WZrmk_VPERMI2WZrmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2303
  {DBGFIELD("VPERMWZ128rm")       2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2304
  {DBGFIELD("VPERMWZ256rmk_VPERMWZ256rmkz") 2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2305
  {DBGFIELD("VPERMWZ128rr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2306
  {DBGFIELD("VPERMWZ256rr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2307
  {DBGFIELD("VPERMWZ256rm")       2, false, false, false, 375, 10,  8, 1,  6, 1}, // #2308
  {DBGFIELD("VPEXPANDBZ128rrk_VPEXPANDBZ128rrkz_VPEXPANDWZ128rrk_VPEXPANDWZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2309
  {DBGFIELD("VPEXPANDBZ256rrk_VPEXPANDBZ256rrkz_VPEXPANDWZ256rrk_VPEXPANDWZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2310
  {DBGFIELD("VPEXPANDBZrrk_VPEXPANDBZrrkz_VPEXPANDWZrrk_VPEXPANDWZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2311
  {DBGFIELD("VPMADDUBSWZ128rrk_VPMADDUBSWZ128rrkz_VPMULHRSWZ128rrk_VPMULHRSWZ128rrkz_VPMULHUWZ128rrk_VPMULHUWZ128rrkz_VPMULHWZ128rrk_VPMULHWZ128rrkz_VPMULLWZ128rrk_VPMULLWZ128rrkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2312
  {DBGFIELD("VPMADDUBSWZ256rrk_VPMADDUBSWZ256rrkz_VPMULHRSWZ256rrk_VPMULHRSWZ256rrkz_VPMULHUWZ256rrk_VPMULHUWZ256rrkz_VPMULHWZ256rrk_VPMULHWZ256rrkz_VPMULLWZ256rrk_VPMULLWZ256rrkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2313
  {DBGFIELD("VPMADDUBSWZrmk_VPMADDUBSWZrmkz_VPMULHRSWZrmk_VPMULHRSWZrmkz_VPMULHUWZrmk_VPMULHUWZrmkz_VPMULHWZrmk_VPMULHWZrmkz_VPMULLWZrmk_VPMULLWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2314
  {DBGFIELD("VPMADDUBSWZrrk_VPMADDUBSWZrrkz_VPMULHRSWZrrk_VPMULHRSWZrrkz_VPMULHUWZrrk_VPMULHUWZrrkz_VPMULHWZrrk_VPMULHWZrrkz_VPMULLWZrrk_VPMULLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2315
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ256mr_VPMOVUSDBZ128mr_VPMOVUSDBZ256mr_VPMOVDWZ128mr_VPMOVDWZ256mr_VPMOVQWZ128mr_VPMOVQWZ256mr_VPMOVSDWZ128mr_VPMOVSDWZ256mr_VPMOVSQWZ128mr_VPMOVSQWZ256mr_VPMOVUSDWZ128mr_VPMOVUSDWZ256mr_VPMOVUSQWZ128mr_VPMOVUSQWZ256mr_VPMOVQBZ256mr_VPMOVSDBZ256mr_VPMOVSWBZ256mr_VPMOVWBZ256mr_VPMOVSDBZ128mr_VPMOVWBZ128mr_VPMOVSQBZ256mr_VPMOVUSQBZ256mr_VPMOVSQDZ128mr_VPMOVSQDZ256mr_VPMOVUSQDZ128mr_VPMOVUSQDZ256mr_VPMOVSWBZ128mr_VPMOVUSWBZ128mr") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2316
  {DBGFIELD("VPMOVUSWBZ256mr")    2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2317
  {DBGFIELD("VPMOVDBZ128mrk_VPMOVQBZ128mrk_VPMOVSQBZ128mrk_VPMOVSWBZ128mrk_VPMOVWBZ128mrk_VPMOVDWZ128mrk_VPMOVQWZ128mrk_VPMOVSDWZ128mrk_VPMOVSQWZ128mrk_VPMOVUSDWZ128mrk_VPMOVUSQWZ128mrk_VPMOVSDBZ128mrk_VPMOVSQDZ128mrk_VPMOVUSDBZ128mrk_VPMOVUSQDZ128mrk_VPMOVUSQBZ128mrk_VPMOVUSWBZ128mrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2318
  {DBGFIELD("VPMOVDBZ128rr_VPMOVQBZ128rr_VPMOVSQBZ128rr_VPMOVSWBZ128rr_VPMOVWBZ128rr_VPMOVDWZ128rr_VPMOVQWZ128rr_VPMOVSDWZ128rr_VPMOVSQWZ128rr_VPMOVUSDWZ128rr_VPMOVSDBZ128rr_VPMOVSQDZ128rr_VPMOVUSDBZ128rr_VPMOVUSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSWBZ128rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2319
  {DBGFIELD("VPMOVUSQWZ128rr")    1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2320
  {DBGFIELD("VPMOVDBZ256rr_VPMOVQBZ256rr_VPMOVSQBZ256rr_VPMOVSWBZ256rr_VPMOVWBZ256rr_VPMOVDWZ256rr_VPMOVQWZ256rr_VPMOVSDWZ256rr_VPMOVSQWZ256rr_VPMOVUSDWZ256rr_VPMOVSDBZ256rr_VPMOVSQDZ256rr_VPMOVUSDBZ256rr_VPMOVUSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQBZ256rr_VPMOVUSWBZ256rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2321
  {DBGFIELD("VPMOVUSQWZ128rrk_VPMOVUSQWZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2322
  {DBGFIELD("VPMOVUSQWZ256rr")    1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2323
  {DBGFIELD("VPMOVDBZ256mrk_VPMOVQBZ256mrk_VPMOVSQBZ256mrk_VPMOVSWBZ256mrk_VPMOVWBZ256mrk_VPMOVDWZ256mrk_VPMOVQWZ256mrk_VPMOVSDWZ256mrk_VPMOVSQWZ256mrk_VPMOVUSDWZ256mrk_VPMOVUSQWZ256mrk_VPMOVSDBZ256mrk_VPMOVSQDZ256mrk_VPMOVUSDBZ256mrk_VPMOVUSQDZ256mrk_VPMOVUSQBZ256mrk_VPMOVUSWBZ256mrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #2324
  {DBGFIELD("VPMOVUSQWZ256rrk_VPMOVUSQWZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2325
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmk_VPMULLQZ128rmkz") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2326
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmk_VPMULLQZ256rmkz") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2327
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2328
  {DBGFIELD("VPSCATTERQDZ256mr_VSCATTERQPSZ256mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #2329
  {DBGFIELD("VPSCATTERQDZmr_VSCATTERQPSZmr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #2330
  {DBGFIELD("VPSHLDDZ128rmbi_VPSHLDQZ128rmbi_VPSHRDDZ128rmbi_VPSHRDQZ128rmbi_VPSHLDDZ128rmi_VPSHLDQZ128rmi_VPSHLDWZ128rmi_VPSHRDDZ128rmi_VPSHRDQZ128rmi_VPSHRDWZ128rmi_VPSHLDVDZ128m_VPSHLDVQZ128m_VPSHLDVWZ128m_VPSHRDVDZ128m_VPSHRDVQZ128m_VPSHRDVWZ128m_VPSHLDVDZ128mb_VPSHLDVDZ128mk_VPSHLDVDZ128mkz_VPSHLDVQZ128mb_VPSHLDVQZ128mk_VPSHLDVQZ128mkz_VPSHRDVDZ128mb_VPSHRDVDZ128mk_VPSHRDVDZ128mkz_VPSHRDVQZ128mb_VPSHRDVQZ128mk_VPSHRDVQZ128mkz_VPSHLDVDZ128mbk_VPSHLDVDZ128mbkz_VPSHLDVQZ128mbk_VPSHLDVQZ128mbkz_VPSHRDVDZ128mbk_VPSHRDVDZ128mbkz_VPSHRDVQZ128mbk_VPSHRDVQZ128mbkz") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2331
  {DBGFIELD("VPSHLDDZ128rmbik_VPSHLDDZ128rmbikz_VPSHLDDZ128rmik_VPSHLDDZ128rmikz_VPSHLDQZ128rmbik_VPSHLDQZ128rmbikz_VPSHLDQZ128rmik_VPSHLDQZ128rmikz_VPSHRDDZ128rmbik_VPSHRDDZ128rmbikz_VPSHRDDZ128rmik_VPSHRDDZ128rmikz_VPSHRDQZ128rmbik_VPSHRDQZ128rmbikz_VPSHRDQZ128rmik_VPSHRDQZ128rmikz") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2332
  {DBGFIELD("VPSHLDDZ128rri_VPSHLDQZ128rri_VPSHLDWZ128rri_VPSHRDDZ128rri_VPSHRDQZ128rri_VPSHRDWZ128rri_VPSHLDVDZ128rk_VPSHLDVDZ128rkz_VPSHLDVQZ128rk_VPSHLDVQZ128rkz_VPSHRDVDZ128rk_VPSHRDVDZ128rkz_VPSHRDVQZ128rk_VPSHRDVQZ128rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2333
  {DBGFIELD("VPSHLDDZ256rri_VPSHLDQZ256rri_VPSHLDWZ256rri_VPSHRDDZ256rri_VPSHRDQZ256rri_VPSHRDWZ256rri_VPSHLDVDZ256rk_VPSHLDVDZ256rkz_VPSHLDVQZ256rk_VPSHLDVQZ256rkz_VPSHRDVDZ256rk_VPSHRDVDZ256rkz_VPSHRDVQZ256rk_VPSHRDVQZ256rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2334
  {DBGFIELD("VPSHLDVDZ128r_VPSHLDVQZ128r_VPSHLDVWZ128r_VPSHRDVDZ128r_VPSHRDVQZ128r_VPSHRDVWZ128r") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2335
  {DBGFIELD("VPSHLDVDZ256r_VPSHLDVQZ256r_VPSHLDVWZ256r_VPSHRDVDZ256r_VPSHRDVQZ256r_VPSHRDVWZ256r") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2336
  {DBGFIELD("VPSHLDDZ128rrik_VPSHLDDZ128rrikz_VPSHLDQZ128rrik_VPSHLDQZ128rrikz_VPSHRDDZ128rrik_VPSHRDDZ128rrikz_VPSHRDQZ128rrik_VPSHRDQZ128rrikz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2337
  {DBGFIELD("VPSHLDDZ256rrik_VPSHLDDZ256rrikz_VPSHLDQZ256rrik_VPSHLDQZ256rrikz_VPSHRDDZ256rrik_VPSHRDDZ256rrikz_VPSHRDQZ256rrik_VPSHRDQZ256rrikz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #2338
  {DBGFIELD("VPSHLDDZ256rmbi_VPSHLDQZ256rmbi_VPSHRDDZ256rmbi_VPSHRDQZ256rmbi_VPSHLDDZ256rmi_VPSHLDQZ256rmi_VPSHLDWZ256rmi_VPSHRDDZ256rmi_VPSHRDQZ256rmi_VPSHRDWZ256rmi_VPSHLDVDZ256m_VPSHLDVQZ256m_VPSHLDVWZ256m_VPSHRDVDZ256m_VPSHRDVQZ256m_VPSHRDVWZ256m_VPSHLDVDZ256mb_VPSHLDVDZ256mk_VPSHLDVDZ256mkz_VPSHLDVQZ256mb_VPSHLDVQZ256mk_VPSHLDVQZ256mkz_VPSHRDVDZ256mb_VPSHRDVDZ256mk_VPSHRDVDZ256mkz_VPSHRDVQZ256mb_VPSHRDVQZ256mk_VPSHRDVQZ256mkz_VPSHLDVDZ256mbk_VPSHLDVDZ256mbkz_VPSHLDVQZ256mbk_VPSHLDVQZ256mbkz_VPSHRDVDZ256mbk_VPSHRDVDZ256mbkz_VPSHRDVQZ256mbk_VPSHRDVQZ256mbkz") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2339
  {DBGFIELD("VPSHLDDZ256rmbik_VPSHLDDZ256rmbikz_VPSHLDDZ256rmik_VPSHLDDZ256rmikz_VPSHLDQZ256rmbik_VPSHLDQZ256rmbikz_VPSHLDQZ256rmik_VPSHLDQZ256rmikz_VPSHRDDZ256rmbik_VPSHRDDZ256rmbikz_VPSHRDDZ256rmik_VPSHRDDZ256rmikz_VPSHRDQZ256rmbik_VPSHRDQZ256rmbikz_VPSHRDQZ256rmik_VPSHRDQZ256rmikz") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2340
  {DBGFIELD("VPSHLDDZrmbi_VPSHLDQZrmbi_VPSHRDDZrmbi_VPSHRDQZrmbi_VPSHLDDZrmi_VPSHLDQZrmi_VPSHLDWZrmi_VPSHRDDZrmi_VPSHRDQZrmi_VPSHRDWZrmi_VPSHLDVDZm_VPSHLDVQZm_VPSHLDVWZm_VPSHRDVDZm_VPSHRDVQZm_VPSHRDVWZm_VPSHLDVDZmb_VPSHLDVDZmk_VPSHLDVDZmkz_VPSHLDVQZmb_VPSHLDVQZmk_VPSHLDVQZmkz_VPSHRDVDZmb_VPSHRDVDZmk_VPSHRDVDZmkz_VPSHRDVQZmb_VPSHRDVQZmk_VPSHRDVQZmkz_VPSHLDVDZmbk_VPSHLDVDZmbkz_VPSHLDVQZmbk_VPSHLDVQZmbkz_VPSHRDVDZmbk_VPSHRDVDZmbkz_VPSHRDVQZmbk_VPSHRDVQZmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2341
  {DBGFIELD("VPSHLDDZrmbik_VPSHLDDZrmbikz_VPSHLDDZrmik_VPSHLDDZrmikz_VPSHLDQZrmbik_VPSHLDQZrmbikz_VPSHLDQZrmik_VPSHLDQZrmikz_VPSHRDDZrmbik_VPSHRDDZrmbikz_VPSHRDDZrmik_VPSHRDDZrmikz_VPSHRDQZrmbik_VPSHRDQZrmbikz_VPSHRDQZrmik_VPSHRDQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2342
  {DBGFIELD("VPSHLDDZrrik_VPSHLDDZrrikz_VPSHLDQZrrik_VPSHLDQZrrikz_VPSHRDDZrrik_VPSHRDDZrrikz_VPSHRDQZrrik_VPSHRDQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2343
  {DBGFIELD("VPSHLDWZ128rmik_VPSHLDWZ128rmikz_VPSHRDWZ128rmik_VPSHRDWZ128rmikz") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2344
  {DBGFIELD("VPSHLDWZ256rmik_VPSHLDWZ256rmikz_VPSHRDWZ256rmik_VPSHRDWZ256rmikz") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2345
  {DBGFIELD("VPSHLDWZrmik_VPSHLDWZrmikz_VPSHRDWZrmik_VPSHRDWZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2346
  {DBGFIELD("VPSHUFBITQMBZ128rm") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2347
  {DBGFIELD("VPSHUFBITQMBZ256rm") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2348
  {DBGFIELD("VPSHUFBITQMBZrm")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2349
  {DBGFIELD("VPSHUFBITQMBZ128rmk") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2350
  {DBGFIELD("VPSHUFBITQMBZ256rmk") 2, false, false, false, 68, 6, 24, 1,  6, 1}, // #2351
  {DBGFIELD("VPSHUFBITQMBZrmk")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2352
  {DBGFIELD("VPSLLWZ128rrk_VPSLLWZ128rrkz_VPSRLWZ128rrk_VPSRLWZ128rrkz_VPSRAWZ128rrk_VPSRAWZ128rrkz") 2, false, false, false, 531, 6, 12, 1,  0, 0}, // #2353
  {DBGFIELD("VRCPPHZmbk_VRCPPHZmkz_VRCPPHZmbkz_VRCPPHZmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2354
  {DBGFIELD("VRSQRTPHZmbk_VRSQRTPHZmkz_VRSQRTPHZmbkz_VRSQRTPHZmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2355
  {DBGFIELD("VRCPPHZrk_VRCPPHZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2356
  {DBGFIELD("VREDUCEPHZ128rmbi_VREDUCEPHZ128rmi") 3, false, false, false, 74, 6, 11, 1,  6, 1}, // #2357
  {DBGFIELD("VREDUCESHZrmi")      3, false, false, false, 74, 6, 11, 1,  6, 1}, // #2358
  {DBGFIELD("VREDUCEPHZ256rmbi_VREDUCEPHZ256rmi") 3, false, false, false, 74, 6, 16, 1,  6, 1}, // #2359
  {DBGFIELD("VREDUCEPHZ128rmbik_VREDUCEPHZ128rmbikz_VREDUCEPHZ128rmik_VREDUCEPHZ128rmikz_VREDUCESHZrmik_VREDUCESHZrmikz") 3, false, false, false, 74, 6, 11, 1,  6, 1}, // #2360
  {DBGFIELD("VREDUCEPHZ256rmbik_VREDUCEPHZ256rmbikz_VREDUCEPHZ256rmik_VREDUCEPHZ256rmikz") 3, false, false, false, 74, 6, 16, 1,  6, 1}, // #2361
  {DBGFIELD("VREDUCEPHZ128rri_VREDUCESHZrri_VREDUCESHZrrib") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2362
  {DBGFIELD("VREDUCEPHZ256rri")   2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2363
  {DBGFIELD("VREDUCEPHZ128rrik_VREDUCEPHZ128rrikz_VREDUCESHZrribk_VREDUCESHZrrikz_VREDUCESHZrribkz_VREDUCESHZrrik") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2364
  {DBGFIELD("VREDUCEPHZ256rrik_VREDUCEPHZ256rrikz") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2365
  {DBGFIELD("VREDUCEPHZrmbi_VREDUCEPHZrmi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2366
  {DBGFIELD("VREDUCEPHZrmbik_VREDUCEPHZrmbikz_VREDUCEPHZrmik_VREDUCEPHZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2367
  {DBGFIELD("VREDUCEPHZrri_VREDUCEPHZrrib") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2368
  {DBGFIELD("VREDUCEPHZrribk_VREDUCEPHZrrikz_VREDUCEPHZrribkz_VREDUCEPHZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2369
  {DBGFIELD("VRNDSCALEPDZrri_VRNDSCALEPDZrrib_VRNDSCALEPDZrribk_VRNDSCALEPDZrrik_VRNDSCALEPDZrrikz_VRNDSCALEPSZrri_VRNDSCALEPSZrrib_VRNDSCALEPSZrribk_VRNDSCALEPSZrrik_VRNDSCALEPSZrrikz_VRNDSCALEPDZrribkz_VRNDSCALEPSZrribkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2370
  {DBGFIELD("VRNDSCALEPHZ128rmbik_VRNDSCALEPHZ128rmbikz_VRNDSCALEPHZ128rmik_VRNDSCALEPHZ128rmikz_VRNDSCALESHZm_Intk_VRNDSCALESHZm_Intkz") 3, false, false, false, 74, 6, 11, 1,  6, 1}, // #2371
  {DBGFIELD("VSCALEFPHZ128rmbk_VSCALEFPHZ128rmkz_VSCALEFPHZ128rmbkz_VSCALEFPHZ128rmk") 2, false, false, false, 53, 7,  9, 1,  6, 1}, // #2372
  {DBGFIELD("VRNDSCALEPHZ256rmbik_VRNDSCALEPHZ256rmbikz_VRNDSCALEPHZ256rmik_VRNDSCALEPHZ256rmikz") 3, false, false, false, 74, 6, 16, 1,  6, 1}, // #2373
  {DBGFIELD("VSCALEFPHZ256rmbk_VSCALEFPHZ256rmkz_VSCALEFPHZ256rmbkz_VSCALEFPHZ256rmk") 2, false, false, false, 53, 7,  8, 1,  6, 1}, // #2374
  {DBGFIELD("VSCALEFSHZrmk_VSCALEFSHZrmkz") 2, false, false, false, 53, 7,  9, 1,  6, 1}, // #2375
  {DBGFIELD("VRNDSCALEPHZ128rrik_VRNDSCALEPHZ128rrikz_VRNDSCALESHZr_Intk_VRNDSCALESHZr_Intkz_VRNDSCALESHZrb_Intk_VRNDSCALESHZrb_Intkz") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2376
  {DBGFIELD("VRNDSCALEPHZ256rrik_VRNDSCALEPHZ256rrikz") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #2377
  {DBGFIELD("VSCALEFPHZ128rrk_VSCALEFPHZ128rrkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #2378
  {DBGFIELD("VSCALEFPHZ256rrk_VSCALEFPHZ256rrkz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #2379
  {DBGFIELD("VSCALEFSHZrrb_Intk_VSCALEFSHZrrb_Intkz_VSCALEFSHZrrk_VSCALEFSHZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #2380
  {DBGFIELD("VRNDSCALEPHZrmbik_VRNDSCALEPHZrmbikz_VRNDSCALEPHZrmik_VRNDSCALEPHZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2381
  {DBGFIELD("VSCALEFPHZrmbk_VSCALEFPHZrmkz_VSCALEFPHZrmbkz_VSCALEFPHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2382
  {DBGFIELD("VRNDSCALEPHZrribk_VRNDSCALEPHZrrikz_VRNDSCALEPHZrribkz_VRNDSCALEPHZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2383
  {DBGFIELD("VSCALEFPHZrrbk_VSCALEFPHZrrkz_VSCALEFPHZrrbkz_VSCALEFPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2384
  {DBGFIELD("VRSQRT14PDZr_VRSQRT14PSZr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2385
  {DBGFIELD("VRSQRT14PSZrk")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2386
  {DBGFIELD("VRSQRTPHZr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2387
  {DBGFIELD("VSQRTPDYm")          2, false, false, false, 173, 10, 46, 1,  0, 0}, // #2388
  {DBGFIELD("VSQRTPDZ256m_VSQRTPDZ256mb") 2, false, false, false, 173, 10, 46, 1,  6, 1}, // #2389
  {DBGFIELD("VSQRTPDZ128mbk_VSQRTPDZ128mkz_VSQRTPDZ128mbkz_VSQRTPDZ128mk") 2, false, false, false, 173, 10, 41, 1,  6, 1}, // #2390
  {DBGFIELD("VSQRTSDZm_Intk_VSQRTSDZm_Intkz") 2, false, false, false, 173, 10, 18, 1,  6, 1}, // #2391
  {DBGFIELD("VSQRTPDZm")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2392
  {DBGFIELD("VSQRTPDZmb")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2393
  {DBGFIELD("VSQRTPDZr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2394
  {DBGFIELD("VSQRTPHZ128mbk_VSQRTPHZ128mkz_VSQRTPHZ128mbkz_VSQRTPHZ128mk") 2, false, false, false, 173, 10, 17, 1,  6, 1}, // #2395
  {DBGFIELD("VSQRTPHZ128rk")      1, false, false, false,  2, 8,  2, 1,  0, 0}, // #2396
  {DBGFIELD("VSQRTPHZ256rk")      1, false, false, false,  2, 8,  2, 1,  0, 0}, // #2397
  {DBGFIELD("VSQRTPHZ256rkz")     1, false, false, false,  2, 8,  2, 1,  0, 0}, // #2398
  {DBGFIELD("VSQRTPHZ128rkz")     1, false, false, false,  2, 8,  2, 1,  0, 0}, // #2399
  {DBGFIELD("VSQRTPHZ256m_VSQRTPHZ256mb") 2, false, false, false, 173, 10, 15, 1,  6, 1}, // #2400
  {DBGFIELD("VSQRTPHZ256mbk_VSQRTPHZ256mkz_VSQRTPHZ256mbkz_VSQRTPHZ256mk") 2, false, false, false, 173, 10, 15, 1,  6, 1}, // #2401
  {DBGFIELD("VSQRTPHZm_VSQRTPHZmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2402
  {DBGFIELD("VSQRTPHZmbk_VSQRTPHZmkz_VSQRTPHZmbkz_VSQRTPHZmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2403
  {DBGFIELD("VSQRTPHZr_VSQRTPHZrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2404
  {DBGFIELD("VSQRTPHZrbk_VSQRTPHZrkz_VSQRTPHZrbkz_VSQRTPHZrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2405
  {DBGFIELD("VSQRTPSZr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2406
  {DBGFIELD("XTEST")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #2407
  {DBGFIELD("PdWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2408
  {DBGFIELD("WriteVecALU")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2409
  {DBGFIELD("JWriteZeroLatency")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2410
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2411
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2412
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2413
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2414
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2415
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2416
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2417
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2418
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2419
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2420
  {DBGFIELD("JWriteLOCK_CMPXCHG8B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2421
  {DBGFIELD("JWriteLOCK_CMPXCHG16B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2422
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2423
  {DBGFIELD("JWriteLOCK_CMPXCHGrm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2424
  {DBGFIELD("JWriteCMPXCHG8B")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2425
  {DBGFIELD("JWriteCMPXCHG16B")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2426
  {DBGFIELD("JWriteCMPXCHG8rm")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2427
  {DBGFIELD("WriteCMPXCHGRMW")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2428
  {DBGFIELD("JWriteCMPXCHG8rr")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2429
  {DBGFIELD("WriteCMPXCHG")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2430
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2431
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2432
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2433
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2434
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2435
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2436
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2437
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2438
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2439
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2440
  {DBGFIELD("JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2441
  {DBGFIELD("JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2442
  {DBGFIELD("SBWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2443
  {DBGFIELD("WriteALU")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2444
  {DBGFIELD("HWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2445
  {DBGFIELD("BWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2446
  {DBGFIELD("Zn3WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2447
  {DBGFIELD("Zn4WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2448
  {DBGFIELD("SKLWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2449
  {DBGFIELD("SKXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2450
  {DBGFIELD("ICXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2451
  {DBGFIELD("WriteFLogic")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2452
  {DBGFIELD("WriteFLogicY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2453
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2454
  {DBGFIELD("WriteVecLogicX")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2455
  {DBGFIELD("WriteVecALUX")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2456
  {DBGFIELD("SKLWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2457
  {DBGFIELD("SKXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2458
  {DBGFIELD("ICXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2459
  {DBGFIELD("SBWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2460
  {DBGFIELD("HWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2461
  {DBGFIELD("BWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2462
  {DBGFIELD("SKLWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2463
  {DBGFIELD("SKXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2464
  {DBGFIELD("ICXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2465
  {DBGFIELD("SBWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2466
  {DBGFIELD("WriteCMOV")          0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2467
  {DBGFIELD("HWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2468
  {DBGFIELD("BWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2469
  {DBGFIELD("SKLWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2470
  {DBGFIELD("SKXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2471
  {DBGFIELD("ICXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2472
  {DBGFIELD("SBWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2473
  {DBGFIELD("WriteCMOVLd")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2474
  {DBGFIELD("HWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2475
  {DBGFIELD("BWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2476
  {DBGFIELD("PdWriteCMOVm")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2477
  {DBGFIELD("SKLWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2478
  {DBGFIELD("SKXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2479
  {DBGFIELD("ICXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2480
  {DBGFIELD("SBWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2481
  {DBGFIELD("WriteSETCC")         0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2482
  {DBGFIELD("HWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2483
  {DBGFIELD("BWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2484
  {DBGFIELD("SKLWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2485
  {DBGFIELD("SKXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2486
  {DBGFIELD("ICXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2487
  {DBGFIELD("SBWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2488
  {DBGFIELD("WriteSETCCStore")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2489
  {DBGFIELD("HWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2490
  {DBGFIELD("BWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2491
  {DBGFIELD("PdWriteSETGEmSETGmSETLEmSETLm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2492
  {DBGFIELD("SKLWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2493
  {DBGFIELD("SKXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2494
  {DBGFIELD("ICXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2495
  {DBGFIELD("WriteVecLogicY")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2496
  {DBGFIELD("WriteVecALUY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2497
  {DBGFIELD("HWWriteADC0")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2498
  {DBGFIELD("WriteADC")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2499
  {DBGFIELD("WriteFShuffle256")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2500
  {DBGFIELD("Zn3Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2501
  {DBGFIELD("WriteLEA")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2502
  {DBGFIELD("Zn4Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2503
  {DBGFIELD("PdWrite3OpsLEA")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2504
  {DBGFIELD("JWrite3OpsLEA")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2505
  {DBGFIELD("WriteVecLogic")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2506
  {DBGFIELD("JWriteLOCK_ALURMW")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2507
  {DBGFIELD("WriteALURMW")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2508
  {DBGFIELD("WriteFLogicZ")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2509
  {DBGFIELD("WriteVecLogicZ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2510
}; // AlderlakePModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AtomModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false,  4, 1,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false,  3, 2,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    1, false, false, false, 2224, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        1, false, false, false,  3, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false,  4, 1,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteLEA")           1, false, false, false,  3, 2,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteRMW")           1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #10
  {DBGFIELD("WriteADC")           1, false, false, false,  4, 1,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteSHDrri")        1, false, false, false, 75, 1, 12, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreX")       1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #13
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #14
  {DBGFIELD("WriteFStoreY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #15
  {DBGFIELD("WriteFLoadY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #16
  {DBGFIELD("WriteMicrocoded")    1, false, false, false,  4, 1,  4, 1,  0, 0}, // #17
  {DBGFIELD("WriteALURMW")        1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #18
  {DBGFIELD("WriteFSign")         1, false, false, false,  3, 2,  1, 1,  0, 0}, // #19
  {DBGFIELD("WriteADCRMW")        1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #20
  {DBGFIELD("WriteADCLd_ReadAfterLd") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #21
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 2226, 2,  1, 1, 15, 2}, // #22
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2226, 2,  1, 1, 17, 2}, // #23
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #24
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2226, 2,  1, 1, 15, 1}, // #25
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #26
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 4, false, false, false, 2228, 3,  6, 1, 14, 1}, // #27
  {DBGFIELD("WriteFAdd64X")       3, false, false, false, 2231, 3,  3, 1,  0, 0}, // #28
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 1, false, false, false, 269, 3, 10, 1, 14, 1}, // #29
  {DBGFIELD("WriteFAddX")         1, false, false, false,  3, 2, 10, 1,  0, 0}, // #30
  {DBGFIELD("WriteNop")           1, false, false, false,  4, 1,  1, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 1, false, false, false, 269, 3, 10, 1, 14, 1}, // #32
  {DBGFIELD("WriteFAdd64")        1, false, false, false,  3, 2, 10, 1,  0, 0}, // #33
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 1, false, false, false, 269, 3, 10, 1, 14, 1}, // #34
  {DBGFIELD("WriteFAdd")          1, false, false, false,  3, 2, 10, 1,  0, 0}, // #35
  {DBGFIELD("WriteFAddLd")        1, false, false, false, 269, 3, 10, 1,  0, 0}, // #36
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #37
  {DBGFIELD("WriteAESDecEnc")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #38
  {DBGFIELD("WriteAESIMCLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #39
  {DBGFIELD("WriteAESIMC")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #40
  {DBGFIELD("WriteAESKeyGenLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #41
  {DBGFIELD("WriteAESKeyGen")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #42
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #43
  {DBGFIELD("WriteFLogic")        1, false, false, false,  4, 1,  1, 1,  0, 0}, // #44
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #45
  {DBGFIELD("WriteBEXTR")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #46
  {DBGFIELD("WriteBEXTRLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #47
  {DBGFIELD("WriteALULd")         1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #48
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #49
  {DBGFIELD("WriteFBlend")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #50
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #51
  {DBGFIELD("WriteFVarBlend")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #52
  {DBGFIELD("WriteBLSLd")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #53
  {DBGFIELD("WriteBLS")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #54
  {DBGFIELD("WriteBSFLd")         10, false, false, false, 2234, 3, 16, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSF")           10, false, false, false, 2234, 3, 16, 1,  0, 0}, // #56
  {DBGFIELD("WriteBSRLd")         10, false, false, false, 2234, 3, 16, 1,  0, 0}, // #57
  {DBGFIELD("WriteBSR")           10, false, false, false, 2234, 3, 16, 1,  0, 0}, // #58
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBSWAP64")       1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestImmLd")  1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestRegLd")  1, false, false, false, 293, 1, 22, 1,  0, 0}, // #62
  {DBGFIELD("WriteBitTest")       1, false, false, false,  3, 2,  1, 1,  0, 0}, // #63
  {DBGFIELD("WriteBitTestSetImmRMW") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #64
  {DBGFIELD("WriteBitTestSetRegRMW") 1, false, false, false, 82, 1,  8, 1,  0, 0}, // #65
  {DBGFIELD("WriteBitTestSet")    1, false, false, false,  3, 2,  1, 1,  0, 0}, // #66
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #67
  {DBGFIELD("WriteBZHI")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #68
  {DBGFIELD("WriteLoad")          1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #69
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #70
  {DBGFIELD("WriteCMOV")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #71
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 293, 1, 22, 1,  0, 0}, // #72
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2226, 2,  1, 1, 15, 1}, // #73
  {DBGFIELD("WriteXCHG")          1, false, false, false, 75, 1, 12, 1,  0, 0}, // #74
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 4, false, false, false, 2228, 3,  6, 1, 14, 1}, // #75
  {DBGFIELD("WriteFCmp64X")       3, false, false, false, 2231, 3,  3, 1,  0, 0}, // #76
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 4, false, false, false, 2228, 3,  6, 1, 14, 1}, // #77
  {DBGFIELD("WriteFCmpX")         3, false, false, false, 2231, 3,  3, 1,  0, 0}, // #78
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 1, false, false, false, 269, 3, 10, 1, 14, 1}, // #79
  {DBGFIELD("WriteFCmp64")        1, false, false, false,  3, 2, 10, 1,  0, 0}, // #80
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 1, false, false, false, 269, 3, 10, 1, 14, 1}, // #81
  {DBGFIELD("WriteFCmp")          1, false, false, false,  3, 2, 10, 1,  0, 0}, // #82
  {DBGFIELD("WriteCMPXCHG")       1, false, false, false, 2237, 1, 11, 1,  0, 0}, // #83
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 5, false, false, false, 2238, 3,  9, 1, 14, 1}, // #84
  {DBGFIELD("WriteFComX")         4, false, false, false, 2241, 3, 22, 1,  0, 0}, // #85
  {DBGFIELD("WriteFCom")          1, false, false, false, 2244, 2, 10, 1,  0, 0}, // #86
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #87
  {DBGFIELD("WriteCRC32")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #88
  {DBGFIELD("WriteCvtI2PDLd")     4, false, false, false, 2246, 3,  7, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtI2PD")       3, false, false, false, 2228, 3,  6, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtI2PSLd")     4, false, false, false, 2246, 3,  6, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtI2PS")       3, false, false, false, 2228, 3,  3, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPD2ILd")     5, false, false, false, 2249, 3,  7, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPD2I")       4, false, false, false, 2246, 3,  6, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPD2PSLd")    5, false, false, false, 2252, 3,  2, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtPD2PS")      4, false, false, false, 2255, 3,  8, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtPS2ILd")     4, false, false, false, 2246, 3,  6, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtPS2I")       3, false, false, false, 2228, 3,  3, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtPS2PDLd")    5, false, false, false, 2246, 3,  7, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtPS2PD")      4, false, false, false, 2228, 3,  6, 1,  0, 0}, // #100
  {DBGFIELD("WriteCvtSD2ILd")     4, false, false, false, 2238, 3, 22, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 3, false, false, false, 2249, 3,  7, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtSD2I")       3, false, false, false, 2249, 3,  7, 1,  0, 0}, // #103
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 4, false, false, false, 2252, 3,  8, 1, 14, 1}, // #104
  {DBGFIELD("WriteCvtSD2SS")      3, false, false, false, 2238, 3,  9, 1,  0, 0}, // #105
  {DBGFIELD("WriteCvtI2SDLd")     3, false, false, false, 2246, 3,  6, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 3, false, false, false, 2246, 3,  6, 1, 14, 1}, // #107
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 3, false, false, false, 2228, 3,  3, 1,  0, 1}, // #108
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 3, false, false, false, 2228, 3,  3, 1,  7, 1}, // #109
  {DBGFIELD("WriteCvtI2SSLd")     1, false, false, false, 2228, 3,  6, 1,  0, 0}, // #110
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 1, false, false, false, 2228, 3,  6, 1, 14, 1}, // #111
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 3, false, false, false, 2228, 3,  3, 1,  0, 1}, // #112
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 3, false, false, false, 2228, 3,  3, 1,  7, 1}, // #113
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 4, false, false, false, 2246, 3,  6, 1, 14, 1}, // #114
  {DBGFIELD("WriteCvtSS2SD")      3, false, false, false, 2228, 3,  3, 1,  0, 0}, // #115
  {DBGFIELD("WriteCvtSS2ILd")     4, false, false, false, 2241, 3, 22, 1,  0, 0}, // #116
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 3, false, false, false, 2249, 3,  7, 1,  0, 0}, // #117
  {DBGFIELD("WriteCvtSS2I")       3, false, false, false, 2249, 3,  7, 1,  0, 0}, // #118
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 12, false, false, false, 2258, 3, 96, 1, 15, 2}, // #119
  {DBGFIELD("WriteDiv16")         12, false, false, false, 2258, 3, 96, 1,  0, 0}, // #120
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 12, false, false, false, 2258, 3, 96, 1, 15, 2}, // #121
  {DBGFIELD("WriteDiv32")         12, false, false, false, 2258, 3, 96, 1,  0, 0}, // #122
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 38, false, false, false, 2261, 3, 97, 1, 15, 2}, // #123
  {DBGFIELD("WriteDiv64")         38, false, false, false, 2261, 3, 97, 1,  0, 0}, // #124
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 9, false, false, false, 2264, 3, 98, 1, 15, 2}, // #125
  {DBGFIELD("WriteDiv8")          9, false, false, false, 2258, 3, 96, 1,  0, 0}, // #126
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 7, false, false, false, 2267, 3, 99, 1, 14, 1}, // #127
  {DBGFIELD("WriteFDiv64X")       6, false, false, false, 2267, 3, 99, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 7, false, false, false, 2270, 3, 61, 1, 14, 1}, // #129
  {DBGFIELD("WriteFDivX")         6, false, false, false, 2270, 3, 61, 1,  0, 0}, // #130
  {DBGFIELD("WriteFDivLd")        4, false, false, false, 2273, 3, 100, 1,  0, 0}, // #131
  {DBGFIELD("WriteFDiv")          3, false, false, false, 2273, 3, 100, 1,  0, 0}, // #132
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 4, false, false, false, 2276, 3, 68, 1, 14, 1}, // #133
  {DBGFIELD("WriteFDiv64")        3, false, false, false, 2276, 3, 68, 1,  0, 0}, // #134
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 4, false, false, false, 2273, 3, 100, 1, 14, 1}, // #135
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #136
  {DBGFIELD("WriteDPPD")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #137
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #138
  {DBGFIELD("WriteDPPS")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #139
  {DBGFIELD("WriteStore")         1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #140
  {DBGFIELD("WriteVecExtractSt")  1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #141
  {DBGFIELD("WriteVecExtract")    1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #142
  {DBGFIELD("WriteVecALUX")       1, false, false, false,  4, 1,  1, 1,  0, 0}, // #143
  {DBGFIELD("WriteFComLd")        1, false, false, false, 2244, 2, 10, 1,  0, 0}, // #144
  {DBGFIELD("WriteEMMS")          1, false, false, false, 240, 1, 10, 1,  0, 0}, // #145
  {DBGFIELD("WriteFLDC")          1, false, false, false, 1910, 1,  9, 1,  0, 0}, // #146
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 1, false, false, false, 2279, 2, 10, 1, 14, 1}, // #147
  {DBGFIELD("WriteVecIMulX")      1, false, false, false, 2279, 2, 10, 1,  0, 0}, // #148
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #149
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 6, false, false, false, 2241, 3, 22, 1, 14, 1}, // #150
  {DBGFIELD("WriteFHAdd")         5, false, false, false, 2249, 3,  7, 1,  0, 0}, // #151
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 29, false, false, false, 2276, 3, 68, 1, 15, 2}, // #152
  {DBGFIELD("WriteIDiv16")        29, false, false, false, 2276, 3, 68, 1,  0, 0}, // #153
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 29, false, false, false, 2276, 3, 68, 1, 15, 2}, // #154
  {DBGFIELD("WriteIDiv32")        29, false, false, false, 2276, 3, 68, 1,  0, 0}, // #155
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 60, false, false, false, 2261, 3, 97, 1, 15, 2}, // #156
  {DBGFIELD("WriteIDiv64")        60, false, false, false, 2261, 3, 97, 1,  0, 0}, // #157
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 26, false, false, false, 2276, 3, 68, 1, 15, 2}, // #158
  {DBGFIELD("WriteIDiv8")         26, false, false, false, 2276, 3, 68, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 2249, 3,  7, 1, 15, 2}, // #160
  {DBGFIELD("WriteIMul16")        4, false, false, false, 2246, 3,  6, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 3, false, false, false, 2246, 3,  6, 1, 14, 1}, // #162
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, false, 2246, 3,  6, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul16Reg")     2, false, false, false, 2228, 3,  3, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 2228, 3,  3, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 2246, 3,  6, 1, 15, 2}, // #166
  {DBGFIELD("WriteIMul32")        3, false, false, false, 2228, 3,  3, 1,  0, 0}, // #167
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 1, false, false, false, 2244, 2, 10, 1, 14, 1}, // #168
  {DBGFIELD("WriteIMul32ImmLd")   1, false, false, false, 2244, 2, 10, 1,  0, 0}, // #169
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 2244, 2, 10, 1,  0, 0}, // #170
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 2244, 2, 10, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2252, 3,  2, 1, 15, 2}, // #172
  {DBGFIELD("WriteIMul64")        8, false, false, false, 2252, 3,  2, 1,  0, 0}, // #173
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 6, false, false, false, 2252, 3,  2, 1, 14, 1}, // #174
  {DBGFIELD("WriteIMul64ImmLd")   7, false, false, false, 2281, 3, 21, 1,  0, 0}, // #175
  {DBGFIELD("WriteIMul64Reg")     6, false, false, false, 2252, 3,  2, 1,  0, 0}, // #176
  {DBGFIELD("WriteIMul64Imm")     7, false, false, false, 2281, 3, 21, 1,  0, 0}, // #177
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 2246, 3,  6, 1, 15, 2}, // #178
  {DBGFIELD("WriteIMul8")         3, false, false, false, 2246, 3,  6, 1,  0, 0}, // #179
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #180
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #181
  {DBGFIELD("WriteVecLogicX")     1, false, false, false,  4, 1,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteShuffle")       1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, false, 75, 1, 12, 1,  0, 0}, // #184
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteLDMXCSR")       4, false, false, false, 2231, 3, 10, 1,  0, 0}, // #186
  {DBGFIELD("WriteFLD0")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #187
  {DBGFIELD("WriteFLD1")          1, false, false, false, 464, 1,  3, 1,  0, 0}, // #188
  {DBGFIELD("WriteFence")         1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteLZCNTLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #190
  {DBGFIELD("WriteLZCNT")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #191
  {DBGFIELD("WriteVecStoreX")     1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecStore")      1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false, 2284, 2,  5, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecMoveX")      1, false, false, false,  4, 1,  1, 1,  0, 0}, // #197
  {DBGFIELD("WriteVecStoreNT")    1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #198
  {DBGFIELD("WriteVecMove")       1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #199
  {DBGFIELD("WriteVecALULd")      1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #200
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #201
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #202
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #203
  {DBGFIELD("WriteVecLogic")      1, false, false, false,  4, 1,  1, 1,  0, 0}, // #204
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 2286, 3, 14, 1, 14, 1}, // #205
  {DBGFIELD("WritePHAdd")         3, false, false, false, 2289, 3,  5, 1,  0, 0}, // #206
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #207
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 1, false, false, false, 2226, 2,  1, 1,  7, 1}, // #208
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 1, false, false, false, 2226, 2, 14, 1, 14, 1}, // #209
  {DBGFIELD("WriteVecIMul")       1, false, false, false, 2226, 2, 14, 1,  0, 0}, // #210
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, false, 2284, 2,  5, 1,  0, 0}, // #211
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 1, false, false, false, 2226, 2, 14, 1, 14, 1}, // #212
  {DBGFIELD("WritePSADBW")        1, false, false, false, 2226, 2, 14, 1,  0, 0}, // #213
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #214
  {DBGFIELD("WriteVarShuffle")    1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #215
  {DBGFIELD("WriteShuffleLd")     1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #217
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 3, false, false, false, 2292, 3,  5, 1, 14, 1}, // #218
  {DBGFIELD("WriteVecShift")      2, false, false, false, 269, 3, 12, 1,  0, 0}, // #219
  {DBGFIELD("WriteFMoveX")        1, false, false, false,  4, 1,  1, 1,  0, 0}, // #220
  {DBGFIELD("WriteFShuffleLd")    1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteFStore")        1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #222
  {DBGFIELD("WriteFMOVMSK")       1, false, false, false, 2284, 2,  5, 1,  0, 0}, // #223
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #224
  {DBGFIELD("WriteStoreNT")       1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #225
  {DBGFIELD("WriteFStoreNTX")     1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #226
  {DBGFIELD("WriteFStoreNT")      1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #227
  {DBGFIELD("WriteFLoad")         1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #228
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #229
  {DBGFIELD("WriteMPSAD")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #230
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 7, false, false, false, 2238, 3,  9, 1, 14, 1}, // #231
  {DBGFIELD("WriteFMul64X")       6, false, false, false, 2241, 3, 22, 1,  0, 0}, // #232
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 1, false, false, false, 2279, 2, 10, 1, 14, 1}, // #233
  {DBGFIELD("WriteFMulX")         1, false, false, false, 2279, 2, 10, 1,  0, 0}, // #234
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 1, false, false, false, 2279, 2, 10, 1, 14, 1}, // #235
  {DBGFIELD("WriteFMul64")        1, false, false, false, 2279, 2, 10, 1,  0, 0}, // #236
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 1, false, false, false, 2279, 2, 14, 1, 14, 1}, // #237
  {DBGFIELD("WriteFMul")          1, false, false, false, 2279, 2, 14, 1,  0, 0}, // #238
  {DBGFIELD("WriteMULX32Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #239
  {DBGFIELD("WriteMULX32")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #240
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #241
  {DBGFIELD("WriteIMulH_WriteMULX32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #242
  {DBGFIELD("WriteMULX64Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #243
  {DBGFIELD("WriteMULX64")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #244
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #245
  {DBGFIELD("WriteIMulH_WriteMULX64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #246
  {DBGFIELD("WriteFMulLd")        1, false, false, false, 2279, 2, 14, 1,  0, 0}, // #247
  {DBGFIELD("WriteVecALUXLd")     1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #248
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #249
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #250
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #251
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #252
  {DBGFIELD("WriteVarBlend")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #253
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #254
  {DBGFIELD("WriteBlend")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #255
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #256
  {DBGFIELD("WriteCLMul")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #257
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #258
  {DBGFIELD("WritePCmpEStrI")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #259
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #260
  {DBGFIELD("WritePCmpEStrM")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #261
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #262
  {DBGFIELD("WritePCmpIStrI")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #263
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #264
  {DBGFIELD("WritePCmpIStrM")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #265
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 4, false, false, false, 2246, 3,  6, 1, 14, 1}, // #266
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, false, 2249, 3,  7, 1, 14, 1}, // #267
  {DBGFIELD("WritePHAddX")        3, false, false, false, 2246, 3,  6, 1,  0, 0}, // #268
  {DBGFIELD("WritePHMINPOSLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #269
  {DBGFIELD("WritePHMINPOS")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #270
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 4, false, false, false, 2246, 3,  6, 1, 14, 1}, // #271
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, false, 2284, 2,  5, 1,  0, 0}, // #272
  {DBGFIELD("WriteShuffleXLd")    1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #273
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #274
  {DBGFIELD("WritePMULLD")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #275
  {DBGFIELD("WriteCopy")          2, false, false, false, 2279, 2, 12, 1,  0, 0}, // #276
  {DBGFIELD("WritePOPCNTLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #277
  {DBGFIELD("WritePOPCNT")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #278
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 1, false, false, false, 2279, 2, 10, 1, 14, 1}, // #279
  {DBGFIELD("WritePSADBWX")       1, false, false, false, 2279, 2, 10, 1,  0, 0}, // #280
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 5, false, false, false, 2286, 3, 10, 1, 14, 1}, // #281
  {DBGFIELD("WriteVarShuffleX")   4, false, false, false, 2289, 3, 14, 1,  0, 0}, // #282
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #283
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 3, false, false, false, 2292, 3,  5, 1, 14, 1}, // #284
  {DBGFIELD("WriteVecShiftX")     2, false, false, false, 269, 3, 12, 1,  0, 0}, // #285
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #286
  {DBGFIELD("WriteVecTest")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #287
  {DBGFIELD("WriteRotateLd_WriteRMW") 2, false, false, false, 2279, 2, 101, 2,  0, 0}, // #288
  {DBGFIELD("WriteRotateLd_WriteRotate") 2, false, false, false, 2279, 2, 101, 2,  0, 0}, // #289
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 2, false, false, false, 2279, 2, 101, 2,  0, 0}, // #290
  {DBGFIELD("WriteRotateCLLd_WriteRotateCL") 2, false, false, false, 2279, 2, 101, 2,  0, 0}, // #291
  {DBGFIELD("WriteRotate")        1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #292
  {DBGFIELD("WriteRotateCL")      1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #293
  {DBGFIELD("WriteFRcpXLd")       6, false, false, false, 2238, 3,  9, 1,  0, 0}, // #294
  {DBGFIELD("WriteFRcpX")         5, false, false, false, 2241, 3, 22, 1,  0, 0}, // #295
  {DBGFIELD("WriteFRcpLd")        1, false, false, false, 2295, 2, 14, 1,  0, 0}, // #296
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 1, false, false, false, 2295, 2, 14, 1, 14, 1}, // #297
  {DBGFIELD("WriteFRcp")          1, false, false, false, 2295, 2, 14, 1,  0, 0}, // #298
  {DBGFIELD("WriteShiftLd")       1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #299
  {DBGFIELD("WriteShift")         1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #300
  {DBGFIELD("WriteFRndLd")        1, false, false, false, 2244, 2, 10, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRnd")          1, false, false, false, 2244, 2, 10, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 1, false, false, false, 2244, 2, 10, 1, 14, 1}, // #303
  {DBGFIELD("WriteFRsqrtXLd")     6, false, false, false, 2238, 3,  9, 1,  0, 0}, // #304
  {DBGFIELD("WriteFRsqrtX")       5, false, false, false, 2241, 3, 22, 1,  0, 0}, // #305
  {DBGFIELD("WriteFRsqrtLd")      1, false, false, false, 2295, 2, 14, 1,  0, 0}, // #306
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 1, false, false, false, 2295, 2, 14, 1, 14, 1}, // #307
  {DBGFIELD("WriteFRsqrt")        1, false, false, false, 2295, 2, 14, 1,  0, 0}, // #308
  {DBGFIELD("WriteShiftLd_WriteRMW") 2, false, false, false, 2279, 2, 101, 2,  0, 0}, // #309
  {DBGFIELD("WriteShiftLd_WriteShift") 2, false, false, false, 2279, 2, 101, 2,  0, 0}, // #310
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 2, false, false, false, 2279, 2, 101, 2,  0, 0}, // #311
  {DBGFIELD("WriteShiftCLLd_WriteShiftCL") 2, false, false, false, 2279, 2, 101, 2,  0, 0}, // #312
  {DBGFIELD("WriteShiftCL")       1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #313
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2226, 2,  1, 1, 15, 1}, // #314
  {DBGFIELD("WriteSETCCStore")    1, false, false, false, 75, 1, 12, 1,  0, 0}, // #315
  {DBGFIELD("WriteSETCC")         1, false, false, false,  4, 1,  1, 1,  0, 0}, // #316
  {DBGFIELD("WriteSHDmrcl")       1, false, false, false, 1165, 1, 14, 1,  0, 0}, // #317
  {DBGFIELD("WriteSHDmri")        1, false, false, false, 1165, 1, 14, 1,  0, 0}, // #318
  {DBGFIELD("WriteSHDrrcl")       1, false, false, false, 75, 1, 12, 1,  0, 0}, // #319
  {DBGFIELD("WriteFSqrt64XLd")    6, false, false, false, 2267, 3, 99, 1,  0, 0}, // #320
  {DBGFIELD("WriteFSqrt64X")      5, false, false, false, 2267, 3, 99, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrtXLd")      6, false, false, false, 2270, 3, 61, 1,  0, 0}, // #322
  {DBGFIELD("WriteFSqrtX")        5, false, false, false, 2270, 3, 61, 1,  0, 0}, // #323
  {DBGFIELD("WriteFSqrt64Ld")     4, false, false, false, 2276, 3, 68, 1,  0, 0}, // #324
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 4, false, false, false, 2276, 3, 68, 1, 14, 1}, // #325
  {DBGFIELD("WriteFSqrt64")       3, false, false, false, 2276, 3, 68, 1,  0, 0}, // #326
  {DBGFIELD("WriteFSqrtLd")       4, false, false, false, 2273, 3, 100, 1,  0, 0}, // #327
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 4, false, false, false, 2273, 3, 100, 1, 14, 1}, // #328
  {DBGFIELD("WriteFSqrt")         3, false, false, false, 2273, 3, 100, 1,  0, 0}, // #329
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 2297, 2, 83, 1,  0, 0}, // #330
  {DBGFIELD("WriteSTMXCSR")       4, false, false, false, 2299, 3, 11, 1,  0, 0}, // #331
  {DBGFIELD("WriteTZCNTLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #332
  {DBGFIELD("WriteTZCNT")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteFMALd")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD("WriteFAdd64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteFAddY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD("WriteShuffleY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD("WriteFLogicY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("WriteCvtPH2PSY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD("WriteCvtPH2PS")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #353
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #354
  {DBGFIELD("WriteFVarBlendY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #355
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("WriteFBlendY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #359
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #360
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #361
  {DBGFIELD("WriteShuffle256Ld")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #362
  {DBGFIELD("WriteShuffle256")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #363
  {DBGFIELD("WriteShuffleYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteFShuffle256")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteFShuffle256Ld") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #367
  {DBGFIELD("WriteFCmp64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #368
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #369
  {DBGFIELD("WriteFCmpY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteVarShuffle256Ld") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteCvtI2PDYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtI2PDY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #376
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #377
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #378
  {DBGFIELD("WriteCvtI2PSYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtI2PSY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #381
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 5, false, false, false, 2252, 3,  2, 1, 14, 1}, // #383
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteCvtPD2PSY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtPD2PSYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPD2IYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPD2IY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #391
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2IYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPS2IY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #395
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #396
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #397
  {DBGFIELD("WriteCvtPS2PDYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteCvtPS2PDY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #401
  {DBGFIELD("WriteCvtPH2PSYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #402
  {DBGFIELD("WriteCvtPH2PSLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtPS2PHYSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteCvtPS2PHY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #407
  {DBGFIELD("WriteCvtPS2PHSt")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #408
  {DBGFIELD("WriteCvtPS2PH")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #409
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 4, false, false, false, 2238, 3, 22, 1, 14, 1}, // #412
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 4, false, false, false, 2241, 3, 22, 1, 14, 1}, // #413
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #414
  {DBGFIELD("WritePSADBWY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFDiv64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("WriteFDivY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #423
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteFMAX")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #427
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #428
  {DBGFIELD("WriteFMAY")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #430
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #431
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("WriteDPPSY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #434
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #435
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #438
  {DBGFIELD("WriteFMA")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #439
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #443
  {DBGFIELD("WriteFRndY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #444
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteVecIMulY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("WriteVecALUY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #453
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #454
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #456
  {DBGFIELD("WriteFHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #457
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #458
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #459
  {DBGFIELD("WriteVecLoadY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #460
  {DBGFIELD("WriteFMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #461
  {DBGFIELD("WriteFMaskedLoadY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMaskedLoad")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("WriteFMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #465
  {DBGFIELD("WriteFMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #466
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteFMoveY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("WriteFShuffleYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteFShuffleY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #473
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteVecStoreY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteVecMoveY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteVecLoadNTY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WriteVecStoreNTY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteFStoreNTY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteMPSADY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #482
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #483
  {DBGFIELD("WriteFMul64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteFMulY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteVecALUYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #492
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("WriteVecLogicY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteBlendY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #499
  {DBGFIELD("WriteVarBlendY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #500
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #501
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #502
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #506
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 2226, 2,  1, 1, 17, 2}, // #507
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 2226, 2,  1, 1, 19, 2}, // #508
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #509
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 2279, 2, 10, 1, 19, 2}, // #510
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("WriteFVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #513
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("WriteFVarShuffleY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #518
  {DBGFIELD("WriteFVarShuffle")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #519
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #522
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WritePHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("WriteVecInsert")     1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #526
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, false, 2279, 2, 10, 1,  0, 0}, // #527
  {DBGFIELD("WriteVecIMulYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #528
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("WriteVecMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WriteVecMaskedLoadY") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WriteVecMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WriteVecMaskedLoad") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WriteVecMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WriteVecMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #535
  {DBGFIELD("WriteVPMOV256Ld")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #536
  {DBGFIELD("WriteVPMOV256")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #537
  {DBGFIELD("WriteVecMOVMSKY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #538
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #539
  {DBGFIELD("WritePMULLDY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 5, false, false, false, 2286, 3, 10, 1, 17, 2}, // #543
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 5, false, false, false, 2286, 3, 10, 1, 19, 2}, // #544
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #545
  {DBGFIELD("WriteVecShiftImmYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteVecShiftImmY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #548
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteVarVecShift")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteVarVecShiftY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #553
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #554
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #556
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteVarShuffleY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #558
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #559
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #560
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #561
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #562
  {DBGFIELD("WriteVecShiftY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #566
  {DBGFIELD("WriteVecTestY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #567
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 6, false, false, false, 2238, 3,  9, 1, 14, 1}, // #568
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #569
  {DBGFIELD("WriteFRcpY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #570
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #572
  {DBGFIELD("WriteFRcpYLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #573
  {DBGFIELD("WriteFRndYLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #574
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 6, false, false, false, 2238, 3,  9, 1, 14, 1}, // #575
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #576
  {DBGFIELD("WriteFRsqrtY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #577
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #578
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFRsqrtYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #580
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #581
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #582
  {DBGFIELD("WriteFSqrt64YLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #583
  {DBGFIELD("WriteFSqrt64Y")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #584
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 6, false, false, false, 2267, 3, 99, 1, 14, 1}, // #585
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #586
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #587
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #588
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 6, false, false, false, 2270, 3, 61, 1, 14, 1}, // #589
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #590
  {DBGFIELD("WriteFSqrtY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #591
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #592
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #593
  {DBGFIELD("WriteFSqrtYLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #594
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #595
  {DBGFIELD("WriteFTestY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #596
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #597
  {DBGFIELD("WriteFTest")         1, false, false, false,  4, 1,  1, 1,  0, 0}, // #598
  {DBGFIELD("WriteALULd_WriteRMW") 2, false, false, false, 2279, 2, 101, 2,  0, 0}, // #599
  {DBGFIELD("COPY")               1, false, false, false,  4, 1,  1, 1,  0, 0}, // #600
  {DBGFIELD("XAM_F")              1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #601
  {DBGFIELD("LD_Frr")             1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #602
  {DBGFIELD("MOVSX64rr32")        1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #603
  {DBGFIELD("RCL16m1_RCL16m1_EVEX_RCL16mi_RCL16mi_EVEX_RCL32m1_RCL32m1_EVEX_RCL32mi_RCL32mi_EVEX_RCL64m1_RCL64m1_EVEX_RCL64mi_RCL64mi_EVEX_RCL8m1_RCL8m1_EVEX_RCL8mi_RCL8mi_EVEX_RCR16m1_RCR16m1_EVEX_RCR16mi_RCR16mi_EVEX_RCR32m1_RCR32m1_EVEX_RCR32mi_RCR32mi_EVEX_RCR64m1_RCR64m1_EVEX_RCR64mi_RCR64mi_EVEX_RCR8m1_RCR8m1_EVEX_RCR8mi_RCR8mi_EVEX_ROL16m1_ROL16m1_EVEX_ROL16m1_NF_ROL16mi_ROL16mi_EVEX_ROL16mi_NF_ROL32m1_ROL32m1_EVEX_ROL32m1_NF_ROL32mi_ROL32mi_EVEX_ROL32mi_NF_ROL64m1_ROL64m1_EVEX_ROL64m1_NF_ROL64mi_ROL64mi_EVEX_ROL64mi_NF_ROL8m1_ROL8m1_EVEX_ROL8m1_NF_ROL8mi_ROL8mi_EVEX_ROL8mi_NF_ROR16m1_ROR16m1_EVEX_ROR16m1_NF_ROR16mi_ROR16mi_EVEX_ROR16mi_NF_ROR32m1_ROR32m1_EVEX_ROR32m1_NF_ROR32mi_ROR32mi_EVEX_ROR32mi_NF_ROR64m1_ROR64m1_EVEX_ROR64m1_NF_ROR64mi_ROR64mi_EVEX_ROR64mi_NF_ROR8m1_ROR8m1_EVEX_ROR8m1_NF_ROR8mi_ROR8mi_EVEX_ROR8mi_NF") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #604
  {DBGFIELD("RCL16m1_ND_RCL16mi_ND_RCL32m1_ND_RCL32mi_ND_RCL64m1_ND_RCL64mi_ND_RCL8m1_ND_RCL8mi_ND_RCR16m1_ND_RCR16mi_ND_RCR32m1_ND_RCR32mi_ND_RCR64m1_ND_RCR64mi_ND_RCR8m1_ND_RCR8mi_ND_ROL16m1_ND_ROL16m1_NF_ND_ROL16mi_ND_ROL16mi_NF_ND_ROL32m1_ND_ROL32m1_NF_ND_ROL32mi_ND_ROL32mi_NF_ND_ROL64m1_ND_ROL64m1_NF_ND_ROL64mi_ND_ROL64mi_NF_ND_ROL8m1_ND_ROL8m1_NF_ND_ROL8mi_ND_ROL8mi_NF_ND_ROR16m1_ND_ROR16m1_NF_ND_ROR16mi_ND_ROR16mi_NF_ND_ROR32m1_ND_ROR32m1_NF_ND_ROR32mi_ND_ROR32mi_NF_ND_ROR64m1_ND_ROR64m1_NF_ND_ROR64mi_ND_ROR64mi_NF_ND_ROR8m1_ND_ROR8m1_NF_ND_ROR8mi_ND_ROR8mi_NF_ND") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #605
  {DBGFIELD("RCL16mCL_RCL16mCL_EVEX_RCL32mCL_RCL32mCL_EVEX_RCL64mCL_RCL64mCL_EVEX_RCL8mCL_RCL8mCL_EVEX_RCR16mCL_RCR16mCL_EVEX_RCR32mCL_RCR32mCL_EVEX_RCR64mCL_RCR64mCL_EVEX_RCR8mCL_RCR8mCL_EVEX_ROL16mCL_ROL16mCL_EVEX_ROL16mCL_NF_ROL32mCL_ROL32mCL_EVEX_ROL32mCL_NF_ROL64mCL_ROL64mCL_EVEX_ROL64mCL_NF_ROL8mCL_ROL8mCL_EVEX_ROL8mCL_NF_ROR16mCL_ROR16mCL_EVEX_ROR16mCL_NF_ROR32mCL_ROR32mCL_EVEX_ROR32mCL_NF_ROR64mCL_ROR64mCL_EVEX_ROR64mCL_NF_ROR8mCL_ROR8mCL_EVEX_ROR8mCL_NF") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #606
  {DBGFIELD("RCL16mCL_ND_RCL32mCL_ND_RCL64mCL_ND_RCL8mCL_ND_RCR16mCL_ND_RCR32mCL_ND_RCR64mCL_ND_RCR8mCL_ND_ROL16mCL_ND_ROL16mCL_NF_ND_ROL32mCL_ND_ROL32mCL_NF_ND_ROL64mCL_ND_ROL64mCL_NF_ND_ROL8mCL_ND_ROL8mCL_NF_ND_ROR16mCL_ND_ROR16mCL_NF_ND_ROR32mCL_ND_ROR32mCL_NF_ND_ROR64mCL_ND_ROR64mCL_NF_ND_ROR8mCL_ND_ROR8mCL_NF_ND") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #607
  {DBGFIELD("SAR16m1_SAR16m1_EVEX_SAR16m1_NF_SAR16mi_SAR16mi_EVEX_SAR16mi_NF_SAR32m1_SAR32m1_EVEX_SAR32m1_NF_SAR32mi_SAR32mi_EVEX_SAR32mi_NF_SAR64m1_SAR64m1_EVEX_SAR64m1_NF_SAR64mi_SAR64mi_EVEX_SAR64mi_NF_SAR8m1_SAR8m1_EVEX_SAR8m1_NF_SAR8mi_SAR8mi_EVEX_SAR8mi_NF_SHL16m1_SHL16m1_EVEX_SHL16m1_NF_SHL16mi_SHL16mi_EVEX_SHL16mi_NF_SHL32m1_SHL32m1_EVEX_SHL32m1_NF_SHL32mi_SHL32mi_EVEX_SHL32mi_NF_SHL64m1_SHL64m1_EVEX_SHL64m1_NF_SHL64mi_SHL64mi_EVEX_SHL64mi_NF_SHL8m1_SHL8m1_EVEX_SHL8m1_NF_SHL8mi_SHL8mi_EVEX_SHL8mi_NF_SHR16m1_SHR16m1_EVEX_SHR16m1_NF_SHR16mi_SHR16mi_EVEX_SHR16mi_NF_SHR32m1_SHR32m1_EVEX_SHR32m1_NF_SHR32mi_SHR32mi_EVEX_SHR32mi_NF_SHR64m1_SHR64m1_EVEX_SHR64m1_NF_SHR64mi_SHR64mi_EVEX_SHR64mi_NF_SHR8m1_SHR8m1_EVEX_SHR8m1_NF_SHR8mi_SHR8mi_EVEX_SHR8mi_NF") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #608
  {DBGFIELD("SAR16m1_ND_SAR16m1_NF_ND_SAR16mi_ND_SAR16mi_NF_ND_SAR32m1_ND_SAR32m1_NF_ND_SAR32mi_ND_SAR32mi_NF_ND_SAR64m1_ND_SAR64m1_NF_ND_SAR64mi_ND_SAR64mi_NF_ND_SAR8m1_ND_SAR8m1_NF_ND_SAR8mi_ND_SAR8mi_NF_ND_SHL16m1_ND_SHL16m1_NF_ND_SHL16mi_ND_SHL16mi_NF_ND_SHL32m1_ND_SHL32m1_NF_ND_SHL32mi_ND_SHL32mi_NF_ND_SHL64m1_ND_SHL64m1_NF_ND_SHL64mi_ND_SHL64mi_NF_ND_SHL8m1_ND_SHL8m1_NF_ND_SHL8mi_ND_SHL8mi_NF_ND_SHR16m1_ND_SHR16m1_NF_ND_SHR16mi_ND_SHR16mi_NF_ND_SHR32m1_ND_SHR32m1_NF_ND_SHR32mi_ND_SHR32mi_NF_ND_SHR64m1_ND_SHR64m1_NF_ND_SHR64mi_ND_SHR64mi_NF_ND_SHR8m1_ND_SHR8m1_NF_ND_SHR8mi_ND_SHR8mi_NF_ND") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #609
  {DBGFIELD("SAR16mCL_SAR16mCL_EVEX_SAR16mCL_NF_SAR32mCL_SAR32mCL_EVEX_SAR32mCL_NF_SAR64mCL_SAR64mCL_EVEX_SAR64mCL_NF_SAR8mCL_SAR8mCL_EVEX_SAR8mCL_NF_SHL16mCL_SHL16mCL_EVEX_SHL16mCL_NF_SHL32mCL_SHL32mCL_EVEX_SHL32mCL_NF_SHL64mCL_SHL64mCL_EVEX_SHL64mCL_NF_SHL8mCL_SHL8mCL_EVEX_SHL8mCL_NF_SHR16mCL_SHR16mCL_EVEX_SHR16mCL_NF_SHR32mCL_SHR32mCL_EVEX_SHR32mCL_NF_SHR64mCL_SHR64mCL_EVEX_SHR64mCL_NF_SHR8mCL_SHR8mCL_EVEX_SHR8mCL_NF") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #610
  {DBGFIELD("SAR16mCL_ND_SAR16mCL_NF_ND_SAR32mCL_ND_SAR32mCL_NF_ND_SAR64mCL_ND_SAR64mCL_NF_ND_SAR8mCL_ND_SAR8mCL_NF_ND_SHL16mCL_ND_SHL16mCL_NF_ND_SHL32mCL_ND_SHL32mCL_NF_ND_SHL64mCL_ND_SHL64mCL_NF_ND_SHL8mCL_ND_SHL8mCL_NF_ND_SHR16mCL_ND_SHR16mCL_NF_ND_SHR32mCL_ND_SHR32mCL_NF_ND_SHR64mCL_ND_SHR64mCL_NF_ND_SHR8mCL_ND_SHR8mCL_NF_ND") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #611
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #612
  {DBGFIELD("FCOMPP")             1, false, false, false,  3, 2,  1, 1,  0, 0}, // #613
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #614
  {DBGFIELD("MMX_CVTPI2PSrr")     1, false, false, false, 1221, 2, 10, 1,  0, 0}, // #615
  {DBGFIELD("MMX_CVTPI2PSrm")     1, false, false, false, 1221, 2, 10, 1,  0, 0}, // #616
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 1, false, false, false, 1221, 2, 10, 1,  0, 0}, // #617
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #618
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH16i_PUSH32i_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #619
  {DBGFIELD("XCH_F")              1, false, false, false, 269, 3,  1, 1,  0, 0}, // #620
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #621
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 1, false, false, false, 2231, 3, 10, 1,  0, 0}, // #622
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, false, 2231, 3, 10, 1,  0, 0}, // #623
  {DBGFIELD("CVTSI642SDrm")       1, false, false, false, 2228, 3,  6, 1,  0, 0}, // #624
  {DBGFIELD("CVTSI642SDrm_Int")   1, false, false, false, 2228, 3,  6, 1,  0, 0}, // #625
  {DBGFIELD("CVTSI642SSrr")       4, false, false, false, 2249, 3,  6, 1,  0, 0}, // #626
  {DBGFIELD("CVTSI642SSrr_Int")   4, false, false, false, 2249, 3,  6, 1,  0, 0}, // #627
  {DBGFIELD("CVTSI642SSrm")       4, false, false, false, 2249, 3,  6, 1,  0, 0}, // #628
  {DBGFIELD("CVTSI642SSrm_Int")   4, false, false, false, 2249, 3,  6, 1,  0, 0}, // #629
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 4, false, false, false, 2241, 3, 22, 1,  0, 0}, // #630
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 4, false, false, false, 2241, 3, 22, 1,  0, 0}, // #631
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 5, false, false, false, 2255, 3,  9, 1,  0, 0}, // #632
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #633
  {DBGFIELD("LFENCE")             1, false, false, false,  4, 1,  1, 1,  0, 0}, // #634
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #635
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false, false, 75, 1, 12, 1,  0, 0}, // #636
  {DBGFIELD("POP16r")             1, false, false, false, 75, 1, 12, 1,  0, 0}, // #637
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #638
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #639
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #640
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #641
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false, 75, 1, 12, 1,  0, 0}, // #642
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #643
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #644
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #645
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false, false, 75, 1, 12, 1,  0, 0}, // #646
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false, 75, 1, 12, 1,  0, 0}, // #647
  {DBGFIELD("CLD")                1, false, false, false, 214, 1,  5, 1,  0, 0}, // #648
  {DBGFIELD("LDDQUrm")            1, false, false, false, 214, 1,  5, 1,  0, 0}, // #649
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #650
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #651
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #652
  {DBGFIELD("PHADDDrr_PHSUBDrr")  1, false, false, false, 214, 1,  5, 1,  0, 0}, // #653
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #654
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #655
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 214, 1,  5, 1,  0, 0}, // #656
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 214, 1,  5, 1,  0, 0}, // #657
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, false, 214, 1,  5, 1,  0, 0}, // #658
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false, 1165, 1, 14, 1,  0, 0}, // #659
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false, false, 1165, 1, 14, 1,  0, 0}, // #660
  {DBGFIELD("LD_F80m")            1, false, false, false, 1165, 1, 14, 1,  0, 0}, // #661
  {DBGFIELD("PHADDDrm_PHSUBDrm")  1, false, false, false, 1165, 1, 14, 1,  0, 0}, // #662
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 1, false, false, false, 1165, 1, 14, 1,  0, 0}, // #663
  {DBGFIELD("FLDCW16m")           1, false, false, false, 240, 1, 10, 1,  0, 0}, // #664
  {DBGFIELD("ST_FP80m")           1, false, false, false, 240, 1, 10, 1,  0, 0}, // #665
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 1, false, false, false, 240, 1, 10, 1,  0, 0}, // #666
  {DBGFIELD("CMPXCHG8rm")         1, false, false, false, 464, 1,  3, 1,  0, 0}, // #667
  {DBGFIELD("INTO")               1, false, false, false, 464, 1,  3, 1,  0, 0}, // #668
  {DBGFIELD("XLAT")               1, false, false, false, 464, 1,  3, 1,  0, 0}, // #669
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #670
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #671
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #672
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #673
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #674
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #675
  {DBGFIELD("AAD8i8")             1, false, false, false, 478, 1,  6, 1,  0, 0}, // #676
  {DBGFIELD("LOOPE")              1, false, false, false, 504, 1,  7, 1,  0, 0}, // #677
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 504, 1,  7, 1,  0, 0}, // #678
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 1, false, false, false, 504, 1,  7, 1,  0, 0}, // #679
  {DBGFIELD("FNSTCW16m")          1, false, false, false, 504, 1,  7, 1,  0, 0}, // #680
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 293, 1, 22, 1,  0, 0}, // #681
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #682
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #683
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #684
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #685
  {DBGFIELD("CMPXCHG8rr")         1, false, false, false, 293, 1, 22, 1,  0, 0}, // #686
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #687
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false, 82, 1,  8, 1,  0, 0}, // #688
  {DBGFIELD("AAA_AAS")            1, false, false, false, 813, 1, 24, 1,  0, 0}, // #689
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 1, false, false, false, 961, 1, 21, 1,  0, 0}, // #690
  {DBGFIELD("LOOPNE")             1, false, false, false, 976, 1, 20, 1,  0, 0}, // #691
  {DBGFIELD("PAUSE")              1, false, false, false, 976, 1, 20, 1,  0, 0}, // #692
  {DBGFIELD("CMPXCHG8B")          1, false, false, false, 1755, 1, 13, 1,  0, 0}, // #693
  {DBGFIELD("DAA")                1, false, false, false, 1755, 1, 13, 1,  0, 0}, // #694
  {DBGFIELD("LOOP")               1, false, false, false, 1755, 1, 13, 1,  0, 0}, // #695
  {DBGFIELD("DAS")                1, false, false, false, 2240, 1, 15, 1,  0, 0}, // #696
  {DBGFIELD("AAM8i8")             1, false, false, false, 2302, 1, 23, 1,  0, 0}, // #697
  {DBGFIELD("STD")                1, false, false, false, 2302, 1, 23, 1,  0, 0}, // #698
  {DBGFIELD("CMPXCHG16B")         1, false, false, false, 1887, 1, 19, 1,  0, 0}, // #699
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false, 921, 1, 18, 1,  0, 0}, // #700
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false, false, 2303, 1, 46, 1,  0, 0}, // #701
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 1398, 1, 80, 1,  0, 0}, // #702
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false, 2304, 1, 72, 1,  0, 0}, // #703
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false, false, 2301, 1, 64, 1,  0, 0}, // #704
  {DBGFIELD("ENTER")              1, false, false, false, 2236, 1, 51, 1,  0, 0}, // #705
  {DBGFIELD("POPF16")             1, false, false, false, 2236, 1, 51, 1,  0, 0}, // #706
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false, 2305, 1, 103, 1,  0, 0}, // #707
  {DBGFIELD("FRNDINT")            1, false, false, false, 933, 1, 66, 1,  0, 0}, // #708
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, false, 933, 1, 66, 1,  0, 0}, // #709
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false, 1695, 1, 104, 1,  0, 0}, // #710
  {DBGFIELD("FPREM")              1, false, false, false, 2306, 1, 105, 1,  0, 0}, // #711
  {DBGFIELD("INSB_INSL_INSW")     1, false, false, false, 2307, 1, 106, 1,  0, 0}, // #712
  {DBGFIELD("FNINIT")             1, false, false, false, 2308, 1, 56, 1,  0, 0}, // #713
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false, false, 2275, 1, 98, 1,  0, 0}, // #714
  {DBGFIELD("FPREM1")             1, false, false, false, 2298, 1, 83, 1,  0, 0}, // #715
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false, 2298, 1, 83, 1,  0, 0}, // #716
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false, false, 2309, 1, 107, 1,  0, 0}, // #717
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, false, 2310, 1, 91, 1,  0, 0}, // #718
  {DBGFIELD("FSCALE")             1, false, false, false, 2311, 1, 108, 1,  0, 0}, // #719
  {DBGFIELD("RDMSR")              1, false, false, false, 2312, 1, 109, 1,  0, 0}, // #720
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 1, false, false, false, 1007, 1, 110, 1,  0, 0}, // #721
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false, false, 2313, 1, 111, 1,  0, 0}, // #722
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false, false, 2314, 1, 112, 1,  0, 0}, // #723
  {DBGFIELD("F2XM1")              1, false, false, false, 2315, 1, 113, 1,  0, 0}, // #724
  {DBGFIELD("CPUID")              1, false, false, false, 2316, 1, 114, 1,  0, 0}, // #725
  {DBGFIELD("INT")                1, false, false, false, 2317, 1, 115, 1,  0, 0}, // #726
  {DBGFIELD("INT3")               1, false, false, false, 2318, 1, 97, 1,  0, 0}, // #727
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, false, 2272, 1, 116, 1,  0, 0}, // #728
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false, false, 2319, 1, 117, 1,  0, 0}, // #729
  {DBGFIELD("FYL2X")              1, false, false, false, 2320, 1, 118, 1,  0, 0}, // #730
  {DBGFIELD("FYL2XP1")            1, false, false, false, 2321, 1, 119, 1,  0, 0}, // #731
  {DBGFIELD("FPTAN")              1, false, false, false, 2322, 1, 120, 1,  0, 0}, // #732
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false, 2323, 1, 121, 1,  0, 0}, // #733
  {DBGFIELD("FPATAN")             1, false, false, false, 2324, 1, 122, 1,  0, 0}, // #734
  {DBGFIELD("WRMSR")              1, false, false, false, 2325, 1, 123, 1,  0, 0}, // #735
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, false, 2244, 2, 10, 1,  0, 0}, // #736
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, false,  3, 2,  1, 1,  0, 0}, // #737
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #738
  {DBGFIELD("FNOP")               1, false, false, false,  4, 1,  1, 1,  0, 0}, // #739
  {DBGFIELD("RET64")              1, false, false, false, 1007, 1, 110, 1,  0, 0}, // #740
  {DBGFIELD("CDQ_CQO")            1, false, false, false, 1165, 1, 14, 1,  0, 0}, // #741
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #742
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false, 75, 1, 12, 1,  0, 0}, // #743
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #744
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #745
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 4, false, false, false, 2241, 3, 22, 1,  0, 0}, // #746
  {DBGFIELD("CWD")                1, false, false, false, 1165, 1, 14, 1,  0, 0}, // #747
  {DBGFIELD("FNSTSW16r")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #748
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false, false,  4, 1,  1, 1,  0, 0}, // #749
  {DBGFIELD("PUSHFS64")           1, false, false, false, 75, 1, 12, 1,  0, 0}, // #750
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #751
  {DBGFIELD("RCL8r1_RCL16r1_RCL32r1_RCL64r1_RCR8r1_RCR16r1_RCR32r1_RCR64r1") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #752
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #753
  {DBGFIELD("RCL8ri_RCL16ri_RCL32ri_RCL64ri") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #754
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #755
  {DBGFIELD("MOV64sr")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #756
  {DBGFIELD("RCL16rCL_RCL16rCL_EVEX_RCL16rCL_ND_RCL32rCL_RCL32rCL_EVEX_RCL32rCL_ND_RCL64rCL_RCL64rCL_EVEX_RCL64rCL_ND_RCL8rCL_RCL8rCL_EVEX_RCL8rCL_ND_RCR16rCL_RCR16rCL_EVEX_RCR16rCL_ND_RCR32rCL_RCR32rCL_EVEX_RCR32rCL_ND_RCR64rCL_RCR64rCL_EVEX_RCR64rCL_ND_RCR8rCL_RCR8rCL_EVEX_RCR8rCL_ND") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #757
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #758
  {DBGFIELD("CLI")                1, false, false, false,  4, 1,  4, 1,  0, 0}, // #759
  {DBGFIELD("PUSHGS64")           1, false, false, false, 75, 1, 12, 1,  0, 0}, // #760
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #761
  {DBGFIELD("CALL64pcrel32")      1, false, false, false,  3, 2,  1, 1,  0, 0}, // #762
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #763
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #764
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #765
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #766
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, false, 293, 1, 22, 1,  0, 0}, // #767
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #768
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #769
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #770
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #771
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #772
  {DBGFIELD("MOV16sm")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #773
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #774
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #775
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #776
  {DBGFIELD("LODSL_LODSQ")        1, false, false, false, 75, 1, 12, 1,  0, 0}, // #777
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #778
  {DBGFIELD("VINSERTF128rm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #779
  {DBGFIELD("MMX_PADDQrm")        1, false, false, false, 214, 1,  5, 1,  0, 0}, // #780
  {DBGFIELD("VERRm_VERWm")        1, false, false, false,  4, 1,  4, 1,  0, 0}, // #781
  {DBGFIELD("FARJMP64m")          1, false, false, false,  3, 2,  1, 1,  0, 0}, // #782
  {DBGFIELD("FNSTSWm")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #783
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #784
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #785
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #786
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 5, false, false, false, 2238, 3,  9, 1, 14, 1}, // #787
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #788
  {DBGFIELD("ROL16m1_ROL16m1_EVEX_ROL16m1_NF_ROL16mi_ROL16mi_EVEX_ROL16mi_NF_ROL32m1_ROL32m1_EVEX_ROL32m1_NF_ROL32mi_ROL32mi_EVEX_ROL32mi_NF_ROL64m1_ROL64m1_EVEX_ROL64m1_NF_ROL64mi_ROL64mi_EVEX_ROL64mi_NF_ROL8m1_ROL8m1_EVEX_ROL8m1_NF_ROL8mi_ROL8mi_EVEX_ROL8mi_NF_ROR16m1_ROR16m1_EVEX_ROR16m1_NF_ROR16mi_ROR16mi_EVEX_ROR16mi_NF_ROR32m1_ROR32m1_EVEX_ROR32m1_NF_ROR32mi_ROR32mi_EVEX_ROR32mi_NF_ROR64m1_ROR64m1_EVEX_ROR64m1_NF_ROR64mi_ROR64mi_EVEX_ROR64mi_NF_ROR8m1_ROR8m1_EVEX_ROR8m1_NF_ROR8mi_ROR8mi_EVEX_ROR8mi_NF") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #789
  {DBGFIELD("ROL16m1_ND_ROL16m1_NF_ND_ROL16mi_ND_ROL16mi_NF_ND_ROL32m1_ND_ROL32m1_NF_ND_ROL32mi_ND_ROL32mi_NF_ND_ROL64m1_ND_ROL64m1_NF_ND_ROL64mi_ND_ROL64mi_NF_ND_ROL8m1_ND_ROL8m1_NF_ND_ROL8mi_ND_ROL8mi_NF_ND_ROR16m1_ND_ROR16m1_NF_ND_ROR16mi_ND_ROR16mi_NF_ND_ROR32m1_ND_ROR32m1_NF_ND_ROR32mi_ND_ROR32mi_NF_ND_ROR64m1_ND_ROR64m1_NF_ND_ROR64mi_ND_ROR64mi_NF_ND_ROR8m1_ND_ROR8m1_NF_ND_ROR8mi_ND_ROR8mi_NF_ND") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #790
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #791
  {DBGFIELD("FARCALL64m")         1, false, false, false,  3, 2,  1, 1,  0, 0}, // #792
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #793
  {DBGFIELD("ROL16mCL_ROL16mCL_EVEX_ROL16mCL_NF_ROL32mCL_ROL32mCL_EVEX_ROL32mCL_NF_ROL64mCL_ROL64mCL_EVEX_ROL64mCL_NF_ROL8mCL_ROL8mCL_EVEX_ROL8mCL_NF_ROR16mCL_ROR16mCL_EVEX_ROR16mCL_NF_ROR32mCL_ROR32mCL_EVEX_ROR32mCL_NF_ROR64mCL_ROR64mCL_EVEX_ROR64mCL_NF_ROR8mCL_ROR8mCL_EVEX_ROR8mCL_NF") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #794
  {DBGFIELD("ROL16mCL_ND_ROL16mCL_NF_ND_ROL32mCL_ND_ROL32mCL_NF_ND_ROL64mCL_ND_ROL64mCL_NF_ND_ROL8mCL_ND_ROL8mCL_NF_ND_ROR16mCL_ND_ROR16mCL_NF_ND_ROR32mCL_ND_ROR32mCL_NF_ND_ROR64mCL_ND_ROR64mCL_NF_ND_ROR8mCL_ND_ROR8mCL_NF_ND") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #795
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 1, false, false, false, 2226, 2,  1, 1, 15, 2}, // #796
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, false, 269, 3, 10, 1,  0, 0}, // #797
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #798
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 1, false, false, false, 2244, 2, 10, 1,  0, 0}, // #799
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, false, 2279, 2, 14, 1,  0, 0}, // #800
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, false, 269, 3, 10, 1,  0, 0}, // #801
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, false, 2279, 2, 14, 1,  0, 0}, // #802
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 4, false, false, false, 2273, 3, 100, 1,  0, 0}, // #803
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 4, false, false, false, 2273, 3, 100, 1,  0, 0}, // #804
  {DBGFIELD("VZEROALL")           1, false, false, false,  4, 1,  4, 1,  0, 0}, // #805
  {DBGFIELD("VZEROUPPER")         1, false, false, false,  4, 1,  4, 1,  0, 0}, // #806
  {DBGFIELD("CLC")                1, false, false, false,  4, 1,  1, 1,  0, 0}, // #807
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #808
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #809
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #810
  {DBGFIELD("PXORrr_VPXORrr")     1, false, false, false,  4, 1,  1, 1,  0, 0}, // #811
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #812
  {DBGFIELD("PSUBQrr")            1, false, false, false, 75, 1, 12, 1,  0, 0}, // #813
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #814
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #815
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #816
  {DBGFIELD("SETCCr")             1, false, false, false,  4, 1,  1, 1,  0, 0}, // #817
  {DBGFIELD("SETCCm")             1, false, false, false, 75, 1, 12, 1,  0, 0}, // #818
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #819
  {DBGFIELD("RETI16_RETI32_RETI64") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #820
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 1, false, false, false, 1007, 1, 110, 1,  0, 0}, // #821
  {DBGFIELD("RDPMC")              1, false, false, false, 933, 1, 66, 1,  0, 0}, // #822
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #823
  {DBGFIELD("FBLDm")              1, false, false, false,  4, 1,  4, 1,  0, 0}, // #824
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false,  4, 1,  1, 1,  0, 0}, // #825
  {DBGFIELD("FSAVEm")             1, false, false, false,  4, 1,  4, 1,  0, 0}, // #826
  {DBGFIELD("FRSTORm")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #827
  {DBGFIELD("FXTRACT")            1, false, false, false, 2303, 1, 46, 1,  0, 0}, // #828
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #829
  {DBGFIELD("VBROADCASTF128rm_VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #830
  {DBGFIELD("VBROADCASTI128rm")   1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #831
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #832
  {DBGFIELD("FBSTPm")             1, false, false, false,  4, 1,  4, 1,  0, 0}, // #833
  {DBGFIELD("VMPTRSTm")           1, false, false, false,  4, 1,  4, 1,  0, 0}, // #834
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false, false, 75, 1, 12, 1,  0, 0}, // #835
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #836
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #837
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, false,  4, 1,  1, 1,  0, 0}, // #838
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #839
  {DBGFIELD("FINCSTP")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #840
  {DBGFIELD("ANDN32rr_ANDN32rr_EVEX_ANDN64rr_ANDN64rr_EVEX") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #841
  {DBGFIELD("VPBLENDDYrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #842
  {DBGFIELD("VPBLENDDrri")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #843
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #844
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #845
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #846
  {DBGFIELD("PDEP32rm_PDEP32rm_EVEX_PDEP64rm_PDEP64rm_EVEX_PEXT32rm_PEXT32rm_EVEX_PEXT64rm_PEXT64rm_EVEX") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #847
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #848
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #849
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #850
  {DBGFIELD("ANDN32rm_ANDN32rm_EVEX_ANDN64rm_ANDN64rm_EVEX") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #851
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #852
  {DBGFIELD("VINSERTI128rm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #853
  {DBGFIELD("VPBLENDDrmi")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #854
  {DBGFIELD("VPBLENDDYrmi")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #855
  {DBGFIELD("POP32r_POP64r")      1, false, false, false, 269, 3,  1, 1,  0, 0}, // #856
  {DBGFIELD("SFENCE")             1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #857
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #858
  {DBGFIELD("MOVBE16mr")          1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #859
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #860
  {DBGFIELD("MFENCE")             1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #861
  {DBGFIELD("XGETBV")             1, false, false, false,  4, 1,  4, 1,  0, 0}, // #862
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #863
  {DBGFIELD("LRET64_RET32")       1, false, false, false, 1007, 1, 110, 1,  0, 0}, // #864
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #865
  {DBGFIELD("PDEP32rr_PDEP32rr_EVEX_PDEP64rr_PDEP64rr_EVEX_PEXT32rr_PEXT32rr_EVEX_PEXT64rr_PEXT64rr_EVEX") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #866
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #867
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #868
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #869
  {DBGFIELD("CLDEMOTE")           1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #870
  {DBGFIELD("MMX_CVTPI2PDrm")     4, false, false, false, 2246, 3,  7, 1,  0, 0}, // #871
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #872
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #873
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #874
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false, 2279, 2, 14, 1,  0, 0}, // #875
  {DBGFIELD("VPCMPGTQYrm")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #876
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, false, 2228, 3,  3, 1,  7, 1}, // #877
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #878
  {DBGFIELD("XSETBV")             1, false, false, false,  4, 1,  4, 1,  0, 0}, // #879
  {DBGFIELD("RCL16mCL_RCL16mCL_EVEX_RCL32mCL_RCL32mCL_EVEX_RCL64mCL_RCL64mCL_EVEX_RCL8mCL_RCL8mCL_EVEX") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #880
  {DBGFIELD("RCL16mCL_ND_RCL32mCL_ND_RCL64mCL_ND_RCL8mCL_ND") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #881
  {DBGFIELD("RCL16rCL_RCL16rCL_EVEX_RCL16rCL_ND_RCL32rCL_RCL32rCL_EVEX_RCL32rCL_ND_RCL64rCL_RCL64rCL_EVEX_RCL64rCL_ND_RCR16rCL_RCR16rCL_EVEX_RCR16rCL_ND_RCR32rCL_RCR32rCL_EVEX_RCR32rCL_ND_RCR64rCL_RCR64rCL_EVEX_RCR64rCL_ND") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #882
  {DBGFIELD("RCL8rCL")            1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #883
  {DBGFIELD("RCR8rCL")            1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #884
  {DBGFIELD("RDTSC")              1, false, false, false, 2301, 1, 64, 1,  0, 0}, // #885
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #886
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 3, false, false, false, 2273, 3, 100, 1,  0, 0}, // #887
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 4, false, false, false, 2273, 3, 100, 1,  0, 0}, // #888
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 4, false, false, false, 2273, 3, 100, 1,  0, 0}, // #889
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 3, false, false, false, 2273, 3, 100, 1,  0, 0}, // #890
  {DBGFIELD("XSAVE64")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #891
  {DBGFIELD("XSAVE")              1, false, false, false,  4, 1,  4, 1,  0, 0}, // #892
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #893
  {DBGFIELD("VMCLEARm")           1, false, false, false,  4, 1,  4, 1,  0, 0}, // #894
  {DBGFIELD("FLDENVm")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #895
  {DBGFIELD("FXRSTOR64")          1, false, false, false, 2319, 1, 117, 1,  0, 0}, // #896
  {DBGFIELD("FSTENVm")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #897
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #898
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #899
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #900
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #901
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #902
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #903
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #904
  {DBGFIELD("VPXORYrr")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #905
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #906
  {DBGFIELD("VPCMPGTQYrr")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #907
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #908
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #909
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, false, 2244, 2, 10, 1,  0, 0}, // #910
  {DBGFIELD("LRET64")             1, false, false, false, 1007, 1, 110, 1,  0, 0}, // #911
  {DBGFIELD("POPF64")             1, false, false, false, 1398, 1, 80, 1,  0, 0}, // #912
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #913
  {DBGFIELD("PCMPEQQrr")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #914
  {DBGFIELD("PCMPGTQrr")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #915
  {DBGFIELD("PCMPEQQrm")          1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #916
  {DBGFIELD("PCMPGTQrm")          1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #917
  {DBGFIELD("MOV16rm")            1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #918
  {DBGFIELD("POP16rmm")           1, false, false, false, 214, 1,  5, 1,  0, 0}, // #919
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #920
  {DBGFIELD("PUSHF16")            1, false, false, false, 293, 1, 22, 1,  0, 0}, // #921
  {DBGFIELD("LAHF")               1, false, false, false, 75, 1, 12, 1,  0, 0}, // #922
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mi8_EVEX_ADD16mi8_NF_ADD16mi_EVEX_ADD16mi_NF_ADD32mi_ADD32mi8_ADD32mi8_EVEX_ADD32mi8_NF_ADD32mi_EVEX_ADD32mi_NF_ADD64mi32_ADD64mi32_EVEX_ADD64mi32_NF_ADD64mi8_ADD64mi8_EVEX_ADD64mi8_NF_ADD8mi_ADD8mi8_ADD8mi_EVEX_ADD8mi_NF_SUB16mi_SUB16mi8_SUB16mi8_EVEX_SUB16mi8_NF_SUB16mi_EVEX_SUB16mi_NF_SUB32mi_SUB32mi8_SUB32mi8_EVEX_SUB32mi8_NF_SUB32mi_EVEX_SUB32mi_NF_SUB64mi32_SUB64mi32_EVEX_SUB64mi32_NF_SUB64mi8_SUB64mi8_EVEX_SUB64mi8_NF_SUB8mi_SUB8mi8_SUB8mi_EVEX_SUB8mi_NF") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #923
  {DBGFIELD("ADD16mi8_ND_ADD16mi8_NF_ND_ADD16mi_ND_ADD16mi_NF_ND_ADD16mr_ND_ADD16mr_NF_ND_ADD32mi8_ND_ADD32mi8_NF_ND_ADD32mi_ND_ADD32mi_NF_ND_ADD32mr_ND_ADD32mr_NF_ND_ADD64mi32_ND_ADD64mi32_NF_ND_ADD64mi8_ND_ADD64mi8_NF_ND_ADD64mr_ND_ADD64mr_NF_ND_ADD8mi_ND_ADD8mi_NF_ND_ADD8mr_ND_ADD8mr_NF_ND_SUB16mi8_ND_SUB16mi8_NF_ND_SUB16mi_ND_SUB16mi_NF_ND_SUB16mr_ND_SUB16mr_NF_ND_SUB32mi8_ND_SUB32mi8_NF_ND_SUB32mi_ND_SUB32mi_NF_ND_SUB32mr_ND_SUB32mr_NF_ND_SUB64mi32_ND_SUB64mi32_NF_ND_SUB64mi8_ND_SUB64mi8_NF_ND_SUB64mr_ND_SUB64mr_NF_ND_SUB8mi_ND_SUB8mi_NF_ND_SUB8mr_ND_SUB8mr_NF_ND") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #924
  {DBGFIELD("ADD16mr_ADD16mr_EVEX_ADD32mr_ADD32mr_EVEX_ADD64mr_ADD64mr_EVEX_ADD8mr_ADD8mr_EVEX_SUB16mr_SUB16mr_EVEX_SUB32mr_SUB32mr_EVEX_SUB64mr_SUB64mr_EVEX_SUB8mr_SUB8mr_EVEX") 1, false, false, false, 2226, 2,  1, 1, 15, 1}, // #925
  {DBGFIELD("ADD16mr_NF_ADD32mr_NF_ADD64mr_NF_ADD8mr_NF_SUB16mr_NF_SUB32mr_NF_SUB64mr_NF_SUB8mr_NF") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #926
  {DBGFIELD("ADC16mi_ADC16mi8_ADC16mi8_EVEX_ADC16mi_EVEX_ADC32mi_ADC32mi8_ADC32mi8_EVEX_ADC32mi_EVEX_ADC64mi32_ADC64mi32_EVEX_ADC64mi8_ADC64mi8_EVEX_ADC8mi_ADC8mi8_ADC8mi_EVEX_SBB16mi_SBB16mi8_SBB16mi8_EVEX_SBB16mi_EVEX_SBB32mi_SBB32mi8_SBB32mi8_EVEX_SBB32mi_EVEX_SBB64mi32_SBB64mi32_EVEX_SBB64mi8_SBB64mi8_EVEX_SBB8mi_SBB8mi8_SBB8mi_EVEX") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #927
  {DBGFIELD("ADC16mi8_ND_ADC16mi_ND_ADC16mr_ND_ADC32mi8_ND_ADC32mi_ND_ADC32mr_ND_ADC64mi32_ND_ADC64mi8_ND_ADC64mr_ND_ADC8mi_ND_ADC8mr_ND_SBB16mi8_ND_SBB16mi_ND_SBB16mr_ND_SBB32mi8_ND_SBB32mi_ND_SBB32mr_ND_SBB64mi32_ND_SBB64mi8_ND_SBB64mr_ND_SBB8mi_ND_SBB8mr_ND") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #928
  {DBGFIELD("ADC16mr_EVEX_ADC32mr_EVEX_ADC64mr_EVEX_ADC8mr_EVEX_SBB16mr_EVEX_SBB32mr_EVEX_SBB64mr_EVEX_SBB8mr_EVEX") 1, false, false, false, 2226, 2,  1, 1, 15, 2}, // #929
  {DBGFIELD("DEC16m_DEC16m_EVEX_DEC16m_NF_DEC32m_DEC32m_EVEX_DEC32m_NF_DEC64m_DEC64m_EVEX_DEC64m_NF_DEC8m_DEC8m_EVEX_DEC8m_NF_INC16m_INC16m_EVEX_INC16m_NF_INC32m_INC32m_EVEX_INC32m_NF_INC64m_INC64m_EVEX_INC64m_NF_INC8m_INC8m_EVEX_INC8m_NF_NEG16m_NEG16m_EVEX_NEG16m_NF_NEG32m_NEG32m_EVEX_NEG32m_NF_NEG64m_NEG64m_EVEX_NEG64m_NF_NEG8m_NEG8m_EVEX_NEG8m_NF_NOT16m_NOT16m_EVEX_NOT32m_NOT32m_EVEX_NOT64m_NOT64m_EVEX_NOT8m_NOT8m_EVEX") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #930
  {DBGFIELD("DEC16m_ND_DEC16m_NF_ND_DEC32m_ND_DEC32m_NF_ND_DEC64m_ND_DEC64m_NF_ND_DEC8m_ND_DEC8m_NF_ND_INC16m_ND_INC16m_NF_ND_INC32m_ND_INC32m_NF_ND_INC64m_ND_INC64m_NF_ND_INC8m_ND_INC8m_NF_ND_NEG16m_ND_NEG16m_NF_ND_NEG32m_ND_NEG32m_NF_ND_NEG64m_ND_NEG64m_NF_ND_NEG8m_ND_NEG8m_NF_ND_NOT16m_ND_NOT32m_ND_NOT64m_ND_NOT8m_ND") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #931
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #932
  {DBGFIELD("RET16_LRET16_LRET32") 1, false, false, false, 1007, 1, 110, 1,  0, 0}, // #933
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #934
  {DBGFIELD("AND16mi_AND16mi8_AND16mi8_EVEX_AND16mi8_NF_AND16mi_EVEX_AND16mi_NF_AND32mi_AND32mi8_AND32mi8_EVEX_AND32mi8_NF_AND32mi_EVEX_AND32mi_NF_AND64mi32_AND64mi32_EVEX_AND64mi32_NF_AND64mi8_AND64mi8_EVEX_AND64mi8_NF_AND8mi_AND8mi8_AND8mi_EVEX_AND8mi_NF_OR16mi_OR16mi8_OR16mi8_EVEX_OR16mi8_NF_OR16mi_EVEX_OR16mi_NF_OR32mi_OR32mi8_OR32mi8Locked_OR32mi8_EVEX_OR32mi8_NF_OR32mi_EVEX_OR32mi_NF_OR64mi32_OR64mi32_EVEX_OR64mi32_NF_OR64mi8_OR64mi8_EVEX_OR64mi8_NF_OR8mi_OR8mi8_OR8mi_EVEX_OR8mi_NF_XOR16mi_XOR16mi8_XOR16mi8_EVEX_XOR16mi8_NF_XOR16mi_EVEX_XOR16mi_NF_XOR32mi_XOR32mi8_XOR32mi8_EVEX_XOR32mi8_NF_XOR32mi_EVEX_XOR32mi_NF_XOR64mi32_XOR64mi32_EVEX_XOR64mi32_NF_XOR64mi8_XOR64mi8_EVEX_XOR64mi8_NF_XOR8mi_XOR8mi8_XOR8mi_EVEX_XOR8mi_NF") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #935
  {DBGFIELD("AND16mi8_ND_AND16mi8_NF_ND_AND16mi_ND_AND16mi_NF_ND_AND16mr_ND_AND16mr_NF_ND_AND32mi8_ND_AND32mi8_NF_ND_AND32mi_ND_AND32mi_NF_ND_AND32mr_ND_AND32mr_NF_ND_AND64mi32_ND_AND64mi32_NF_ND_AND64mi8_ND_AND64mi8_NF_ND_AND64mr_ND_AND64mr_NF_ND_AND8mi_ND_AND8mi_NF_ND_AND8mr_ND_AND8mr_NF_ND_OR16mi8_ND_OR16mi8_NF_ND_OR16mi_ND_OR16mi_NF_ND_OR16mr_ND_OR16mr_NF_ND_OR32mi8_ND_OR32mi8_NF_ND_OR32mi_ND_OR32mi_NF_ND_OR32mr_ND_OR32mr_NF_ND_OR64mi32_ND_OR64mi32_NF_ND_OR64mi8_ND_OR64mi8_NF_ND_OR64mr_ND_OR64mr_NF_ND_OR8mi_ND_OR8mi_NF_ND_OR8mr_ND_OR8mr_NF_ND_XOR16mi8_ND_XOR16mi8_NF_ND_XOR16mi_ND_XOR16mi_NF_ND_XOR16mr_ND_XOR16mr_NF_ND_XOR32mi8_ND_XOR32mi8_NF_ND_XOR32mi_ND_XOR32mi_NF_ND_XOR32mr_ND_XOR32mr_NF_ND_XOR64mi32_ND_XOR64mi32_NF_ND_XOR64mi8_ND_XOR64mi8_NF_ND_XOR64mr_ND_XOR64mr_NF_ND_XOR8mi_ND_XOR8mi_NF_ND_XOR8mr_ND_XOR8mr_NF_ND") 1, false, false, false, 2226, 2,  1, 1, 14, 1}, // #936
  {DBGFIELD("AND16mr_AND16mr_EVEX_AND32mr_AND32mr_EVEX_AND64mr_AND64mr_EVEX_AND8mr_AND8mr_EVEX_OR16mr_OR16mr_EVEX_OR32mr_OR32mr_EVEX_OR64mr_OR64mr_EVEX_OR8mr_OR8mr_EVEX_XOR16mr_XOR16mr_EVEX_XOR32mr_XOR32mr_EVEX_XOR64mr_XOR64mr_EVEX_XOR8mr_XOR8mr_EVEX") 1, false, false, false, 2226, 2,  1, 1, 15, 1}, // #937
  {DBGFIELD("AND16mr_NF_AND32mr_NF_AND64mr_NF_AND8mr_NF_OR16mr_NF_OR32mr_NF_OR64mr_NF_OR8mr_NF_XOR16mr_NF_XOR32mr_NF_XOR64mr_NF_XOR8mr_NF") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #938
  {DBGFIELD("SHLD16mri8_EVEX_SHLD16mri8_ND_SHLD16mri8_NF_SHLD16mri8_NF_ND_SHLD32mri8_SHLD32mri8_EVEX_SHLD32mri8_ND_SHLD32mri8_NF_SHLD32mri8_NF_ND_SHLD64mri8_EVEX_SHLD64mri8_ND_SHLD64mri8_NF_SHLD64mri8_NF_ND_SHRD16mri8_EVEX_SHRD16mri8_ND_SHRD16mri8_NF_SHRD16mri8_NF_ND_SHRD32mri8_SHRD32mri8_EVEX_SHRD32mri8_ND_SHRD32mri8_NF_SHRD32mri8_NF_ND_SHRD64mri8_EVEX_SHRD64mri8_ND_SHRD64mri8_NF_SHRD64mri8_NF_ND") 1, false, false, false, 1165, 1, 14, 1,  0, 0}, // #939
  {DBGFIELD("SHLD16rrCL_EVEX_SHLD16rrCL_ND_SHLD16rrCL_NF_SHLD16rrCL_NF_ND_SHLD32rrCL_SHLD32rrCL_EVEX_SHLD32rrCL_ND_SHLD32rrCL_NF_SHLD32rrCL_NF_ND_SHLD64rrCL_EVEX_SHLD64rrCL_ND_SHLD64rrCL_NF_SHLD64rrCL_NF_ND_SHRD16rrCL_EVEX_SHRD16rrCL_ND_SHRD16rrCL_NF_SHRD16rrCL_NF_ND_SHRD32rrCL_SHRD32rrCL_EVEX_SHRD32rrCL_ND_SHRD32rrCL_NF_SHRD32rrCL_NF_ND_SHRD64rrCL_EVEX_SHRD64rrCL_ND_SHRD64rrCL_NF_SHRD64rrCL_NF_ND") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #940
  {DBGFIELD("SHLD16mrCL_EVEX_SHLD16mrCL_ND_SHLD16mrCL_NF_SHLD16mrCL_NF_ND_SHLD32mrCL_SHLD32mrCL_EVEX_SHLD32mrCL_ND_SHLD32mrCL_NF_SHLD32mrCL_NF_ND_SHLD64mrCL_EVEX_SHLD64mrCL_ND_SHLD64mrCL_NF_SHLD64mrCL_NF_ND_SHRD16mrCL_EVEX_SHRD16mrCL_ND_SHRD16mrCL_NF_SHRD16mrCL_NF_ND_SHRD32mrCL_SHRD32mrCL_EVEX_SHRD32mrCL_ND_SHRD32mrCL_NF_SHRD32mrCL_NF_ND_SHRD64mrCL_EVEX_SHRD64mrCL_ND_SHRD64mrCL_NF_SHRD64mrCL_NF_ND") 1, false, false, false, 1165, 1, 14, 1,  0, 0}, // #941
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #942
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #943
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #944
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #945
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #946
  {DBGFIELD("VPMASKMOVDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #947
  {DBGFIELD("VPMASKMOVDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #948
  {DBGFIELD("VPMASKMOVDYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #949
  {DBGFIELD("VPMASKMOVDmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #950
  {DBGFIELD("VPMASKMOVQYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #951
  {DBGFIELD("VPMASKMOVQmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #952
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #953
  {DBGFIELD("VPGATHERDDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #954
  {DBGFIELD("VPGATHERDDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #955
  {DBGFIELD("VPGATHERDQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #956
  {DBGFIELD("VPGATHERDQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #957
  {DBGFIELD("VPGATHERQDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #958
  {DBGFIELD("VPGATHERQDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #959
  {DBGFIELD("VPGATHERQQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #960
  {DBGFIELD("VPGATHERQQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #961
  {DBGFIELD("VPERM2F128rr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #962
  {DBGFIELD("VPERM2I128rr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #963
  {DBGFIELD("VPERM2F128rm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #964
  {DBGFIELD("VPERM2I128rm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #965
  {DBGFIELD("VBROADCASTF128rm")   1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #966
  {DBGFIELD("VEXTRACTF128rr")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #967
  {DBGFIELD("VEXTRACTI128rr")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #968
  {DBGFIELD("VEXTRACTF128mr")     1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #969
  {DBGFIELD("VEXTRACTI128mr")     1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #970
  {DBGFIELD("VINSERTF128rr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #971
  {DBGFIELD("VINSERTI128rr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #972
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 3, false, false, false, 2228, 3,  6, 1,  0, 0}, // #973
  {DBGFIELD("VCVTDQ2PDYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #974
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 4, false, false, false, 2246, 3,  6, 1,  0, 0}, // #975
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_VCVTPD2DQrm_VCVTTPD2DQrm") 5, false, false, false, 2249, 3,  7, 1,  0, 0}, // #976
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #977
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #978
  {DBGFIELD("MMX_CVTPI2PDrr")     3, false, false, false, 2228, 3,  6, 1,  0, 0}, // #979
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 4, false, false, false, 2246, 3,  6, 1,  0, 0}, // #980
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 3, false, false, false, 2249, 3,  7, 1,  0, 0}, // #981
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 3, false, false, false, 2249, 3,  7, 1,  0, 0}, // #982
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int_VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 4, false, false, false, 2241, 3, 22, 1,  0, 0}, // #983
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 3, false, false, false, 2228, 3,  3, 1,  0, 1}, // #984
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 3, false, false, false, 2228, 3,  3, 1,  7, 1}, // #985
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 3, false, false, false, 2249, 3,  7, 1,  0, 0}, // #986
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 3, false, false, false, 2249, 3,  7, 1,  0, 0}, // #987
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int") 3, false, false, false, 2249, 3,  7, 1,  0, 0}, // #988
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 4, false, false, false, 2238, 3, 22, 1,  0, 0}, // #989
  {DBGFIELD("VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int") 4, false, false, false, 2241, 3, 22, 1,  0, 0}, // #990
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false,  4, 1,  1, 1,  0, 0}, // #991
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false,  4, 1,  1, 1,  0, 0}, // #992
  {DBGFIELD("SHA256MSG2rm_SHA256MSG2rm_EVEX") 1, false, false, false, 2279, 2, 10, 1, 14, 1}, // #993
  {DBGFIELD("SHA256MSG2rr_SHA256MSG2rr_EVEX") 1, false, false, false, 2279, 2, 10, 1,  0, 0}, // #994
  {DBGFIELD("SHA1MSG1rr_SHA1MSG1rr_EVEX_SHA256MSG1rr_SHA256MSG1rr_EVEX") 1, false, false, false, 2279, 2, 10, 1,  0, 0}, // #995
  {DBGFIELD("SHA1MSG1rm_SHA1MSG1rm_EVEX_SHA256MSG1rm_SHA256MSG1rm_EVEX") 1, false, false, false, 2279, 2, 10, 1, 14, 1}, // #996
  {DBGFIELD("SHA1MSG2rr")         1, false, false, false, 2279, 2, 10, 1,  0, 0}, // #997
  {DBGFIELD("SHA1MSG2rm")         1, false, false, false, 2279, 2, 10, 1, 14, 1}, // #998
  {DBGFIELD("SHA1NEXTErr")        1, false, false, false, 2279, 2, 10, 1,  0, 0}, // #999
  {DBGFIELD("SHA1NEXTErm")        1, false, false, false, 2279, 2, 10, 1, 14, 1}, // #1000
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 2279, 2, 10, 1,  0, 0}, // #1001
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, false, 2279, 2, 10, 1, 14, 1}, // #1002
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 2279, 2, 10, 1,  0, 0}, // #1003
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, false, 2279, 2, 10, 1, 14, 1}, // #1004
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #1005
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 3, false, false, false, 2228, 3,  3, 1,  0, 0}, // #1006
  {DBGFIELD("VCVTDQ2PSYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1007
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 3, false, false, false, 2228, 3,  3, 1,  0, 0}, // #1008
  {DBGFIELD("MOV8rm_MOV8rm_NOREX_MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1009
  {DBGFIELD("MOVBE16rm")          1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1010
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1011
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1012
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1013
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1014
  {DBGFIELD("ADC8mr_SBB8mr")      1, false, false, false, 2226, 2,  1, 1, 15, 2}, // #1015
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #1016
  {DBGFIELD("LEA16r")             1, false, false, false,  3, 2,  1, 1,  0, 0}, // #1017
  {DBGFIELD("LCMPXCHG8")          1, false, false, false, 2224, 2,  1, 1,  0, 0}, // #1018
  {DBGFIELD("LCMPXCHG16B")        1, false, false, false, 2224, 2,  1, 1,  0, 0}, // #1019
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #1020
  {DBGFIELD("XCHG8rm_XCHG16rm")   1, false, false, false, 214, 1,  5, 1,  0, 0}, // #1021
  {DBGFIELD("POPCNT16rr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1022
  {DBGFIELD("LZCNT16rr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1023
  {DBGFIELD("TZCNT16rr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1024
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1025
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1026
  {DBGFIELD("RCL8mi_RCL16mi_RCL32mi_RCL64mi") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1027
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1028
  {DBGFIELD("RCR8mCL_RCR16mCL_RCR32mCL_RCR64mCL") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1029
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1030
  {DBGFIELD("RCL8mCL_RCL16mCL_RCL32mCL_RCL64mCL") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1031
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1032
  {DBGFIELD("MMX_MOVQ2FR64rr")    1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1033
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1034
  {DBGFIELD("EXTRQ")              1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1035
  {DBGFIELD("INSERTQ")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1036
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1037
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1038
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1039
  {DBGFIELD("MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 5, false, false, false, 2249, 3,  7, 1,  0, 0}, // #1040
  {DBGFIELD("SHA1MSG1rr")         1, false, false, false, 2279, 2, 10, 1,  0, 0}, // #1041
  {DBGFIELD("SHA1MSG1rm")         1, false, false, false, 2279, 2, 10, 1, 14, 1}, // #1042
  {DBGFIELD("SHA256MSG1rr")       1, false, false, false, 2279, 2, 10, 1,  0, 0}, // #1043
  {DBGFIELD("SHA256MSG1rm")       1, false, false, false, 2279, 2, 10, 1, 14, 1}, // #1044
  {DBGFIELD("SHA256MSG2rr")       1, false, false, false, 2279, 2, 10, 1,  0, 0}, // #1045
  {DBGFIELD("SHA256MSG2rm")       1, false, false, false, 2279, 2, 10, 1, 14, 1}, // #1046
  {DBGFIELD("VPERMPSYrm")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1047
  {DBGFIELD("VPERMPDYri")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1048
  {DBGFIELD("VPERMQYri")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1049
  {DBGFIELD("VPERMPDYmi")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1050
  {DBGFIELD("VPERMQYmi")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1051
  {DBGFIELD("VPERMDYrm")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1052
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1053
  {DBGFIELD("MOVSX32rr32")        1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1054
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1055
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1056
  {DBGFIELD("VXORPSrr_VXORPDrr")  1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1057
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1058
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1059
  {DBGFIELD("VPXORrr")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1060
  {DBGFIELD("VPANDNrr")           1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1061
  {DBGFIELD("VPANDNYrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1062
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1063
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1064
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1065
  {DBGFIELD("KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1066
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1067
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1068
  {DBGFIELD("VALIGNDZrri_VALIGNQZrri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1069
  {DBGFIELD("VALIGNDZ128rri_VALIGNQZ128rri") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1070
  {DBGFIELD("VALIGNDZ256rri_VALIGNQZ256rri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD("VPERMPSYrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1072
  {DBGFIELD("VPERMDYrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1073
  {DBGFIELD("VFIXUPIMMPDZ128rrik_VFIXUPIMMPDZ128rrikz_VFIXUPIMMPSZ128rrik_VFIXUPIMMPSZ128rrikz_VFIXUPIMMPDZ128rri_VFIXUPIMMPSZ128rri_VRANGEPDZ128rri_VRANGEPDZ128rrik_VRANGEPDZ128rrikz_VRANGEPSZ128rri_VRANGEPSZ128rrik_VRANGEPSZ128rrikz_VRANGESDZrri_VRANGESDZrrib_VRANGESDZrribk_VRANGESDZrribkz_VRANGESDZrrik_VRANGESDZrrikz_VRANGESSZrri_VRANGESSZrrib_VRANGESSZrribk_VRANGESSZrribkz_VRANGESSZrrik_VRANGESSZrrikz") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1074
  {DBGFIELD("VFIXUPIMMPDZ256rrik_VFIXUPIMMPDZ256rrikz_VFIXUPIMMPSZ256rrik_VFIXUPIMMPSZ256rrikz_VFIXUPIMMPDZ256rri_VFIXUPIMMPSZ256rri_VRANGEPDZ256rri_VRANGEPDZ256rrik_VRANGEPDZ256rrikz_VRANGEPSZ256rri_VRANGEPSZ256rrik_VRANGEPSZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1075
  {DBGFIELD("VFIXUPIMMPDZrrik_VFIXUPIMMPDZrrikz_VFIXUPIMMPSZrrik_VFIXUPIMMPSZrrikz_VRANGEPDZrri_VRANGEPDZrrib_VRANGEPDZrribk_VRANGEPDZrribkz_VRANGEPDZrrik_VRANGEPDZrrikz_VRANGEPSZrri_VRANGEPSZrrib_VRANGEPSZrribk_VRANGEPSZrribkz_VRANGEPSZrrik_VRANGEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1076
  {DBGFIELD("VFIXUPIMMSDZrrik_VFIXUPIMMSDZrrikz_VFIXUPIMMSSZrrik_VFIXUPIMMSSZrrikz") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1077
  {DBGFIELD("VSCALEFSDZrrb_Int_VSCALEFSDZrrb_Intk_VSCALEFSDZrrb_Intkz_VSCALEFSSZrrb_Int_VSCALEFSSZrrb_Intk_VSCALEFSSZrrb_Intkz") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1078
  {DBGFIELD("VREDUCEPDZ128rri_VREDUCEPDZ128rrik_VREDUCEPDZ128rrikz_VREDUCEPSZ128rri_VREDUCEPSZ128rrik_VREDUCEPSZ128rrikz_VREDUCESDZrri_VREDUCESDZrrib_VREDUCESDZrribk_VREDUCESDZrribkz_VREDUCESDZrrik_VREDUCESDZrrikz_VREDUCESSZrri_VREDUCESSZrrib_VREDUCESSZrribk_VREDUCESSZrribkz_VREDUCESSZrrik_VREDUCESSZrrikz") 1, false, false, false, 2244, 2, 10, 1,  0, 0}, // #1079
  {DBGFIELD("VREDUCEPDZrri_VREDUCEPDZrrib_VREDUCEPDZrribk_VREDUCEPDZrribkz_VREDUCEPDZrrik_VREDUCEPDZrrikz_VREDUCEPSZrri_VREDUCEPSZrrib_VREDUCEPSZrribk_VREDUCEPSZrribkz_VREDUCEPSZrrik_VREDUCEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1080
  {DBGFIELD("VDPBF16PSZ128r_VDPBF16PSZ128rk_VDPBF16PSZ128rkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1081
  {DBGFIELD("VDPBF16PSZ256r_VDPBF16PSZ256rk_VDPBF16PSZ256rkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1082
  {DBGFIELD("VDPBF16PSZr_VDPBF16PSZrk_VDPBF16PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1083
  {DBGFIELD("VPDPBUSDSZ128r_VPDPBUSDSZ128rk_VPDPBUSDSZ128rkz_VPDPBUSDZ128r_VPDPBUSDZ128rk_VPDPBUSDZ128rkz_VPDPWSSDSZ128r_VPDPWSSDSZ128rk_VPDPWSSDSZ128rkz_VPDPWSSDZ128r_VPDPWSSDZ128rk_VPDPWSSDZ128rkz_VPMADD52HUQZ128r_VPMADD52HUQZ128rk_VPMADD52HUQZ128rkz_VPMADD52LUQZ128r_VPMADD52LUQZ128rk_VPMADD52LUQZ128rkz") 1, false, false, false, 2279, 2, 10, 1,  0, 0}, // #1084
  {DBGFIELD("VPDPBUSDSZ256r_VPDPBUSDSZ256rk_VPDPBUSDSZ256rkz_VPDPBUSDZ256r_VPDPBUSDZ256rk_VPDPBUSDZ256rkz_VPDPWSSDSZ256r_VPDPWSSDSZ256rk_VPDPWSSDSZ256rkz_VPDPWSSDZ256r_VPDPWSSDZ256rk_VPDPWSSDZ256rkz_VPMADD52HUQZ256r_VPMADD52HUQZ256rk_VPMADD52HUQZ256rkz_VPMADD52LUQZ256r_VPMADD52LUQZ256rk_VPMADD52LUQZ256rkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1085
  {DBGFIELD("VPDPBUSDSZr_VPDPBUSDSZrk_VPDPBUSDSZrkz_VPDPBUSDZr_VPDPBUSDZrk_VPDPBUSDZrkz_VPDPWSSDSZr_VPDPWSSDSZrk_VPDPWSSDSZrkz_VPDPWSSDZr_VPDPWSSDZrk_VPDPWSSDZrkz_VPMADD52HUQZr_VPMADD52HUQZrk_VPMADD52HUQZrkz_VPMADD52LUQZr_VPMADD52LUQZrk_VPMADD52LUQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1086
  {DBGFIELD("VPLZCNTDZ128rr_VPLZCNTDZ128rrk_VPLZCNTDZ128rrkz_VPLZCNTQZ128rr_VPLZCNTQZ128rrk_VPLZCNTQZ128rrkz_VPSHLDDZ128rri_VPSHLDDZ128rrik_VPSHLDDZ128rrikz_VPSHLDQZ128rri_VPSHLDQZ128rrik_VPSHLDQZ128rrikz_VPSHLDVDZ128rk_VPSHLDVDZ128rkz_VPSHLDVQZ128rk_VPSHLDVQZ128rkz_VPSHLDVWZ128rk_VPSHLDVWZ128rkz_VPSHLDWZ128rri_VPSHLDWZ128rrik_VPSHLDWZ128rrikz_VPSHRDDZ128rri_VPSHRDDZ128rrik_VPSHRDDZ128rrikz_VPSHRDQZ128rri_VPSHRDQZ128rrik_VPSHRDQZ128rrikz_VPSHRDVDZ128rk_VPSHRDVDZ128rkz_VPSHRDVQZ128rk_VPSHRDVQZ128rkz_VPSHRDVWZ128rk_VPSHRDVWZ128rkz_VPSHRDWZ128rri_VPSHRDWZ128rrik_VPSHRDWZ128rrikz_VPSHUFBITQMBZ128rr_VPSHUFBITQMBZ128rrk") 1, false, false, false, 2279, 2, 10, 1,  0, 0}, // #1087
  {DBGFIELD("VPLZCNTDZ256rr_VPLZCNTDZ256rrk_VPLZCNTDZ256rrkz_VPLZCNTQZ256rr_VPLZCNTQZ256rrk_VPLZCNTQZ256rrkz_VPSHLDDZ256rri_VPSHLDDZ256rrik_VPSHLDDZ256rrikz_VPSHLDQZ256rri_VPSHLDQZ256rrik_VPSHLDQZ256rrikz_VPSHLDVDZ256rk_VPSHLDVDZ256rkz_VPSHLDVQZ256rk_VPSHLDVQZ256rkz_VPSHLDVWZ256rk_VPSHLDVWZ256rkz_VPSHLDWZ256rri_VPSHLDWZ256rrik_VPSHLDWZ256rrikz_VPSHRDDZ256rri_VPSHRDDZ256rrik_VPSHRDDZ256rrikz_VPSHRDQZ256rri_VPSHRDQZ256rrik_VPSHRDQZ256rrikz_VPSHRDVDZ256rk_VPSHRDVDZ256rkz_VPSHRDVQZ256rk_VPSHRDVQZ256rkz_VPSHRDVWZ256rk_VPSHRDVWZ256rkz_VPSHRDWZ256rri_VPSHRDWZ256rrik_VPSHRDWZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1088
  {DBGFIELD("VPLZCNTDZrr_VPLZCNTDZrrk_VPLZCNTDZrrkz_VPLZCNTQZrr_VPLZCNTQZrrk_VPLZCNTQZrrkz_VPSHLDDZrri_VPSHLDDZrrik_VPSHLDDZrrikz_VPSHLDQZrri_VPSHLDQZrrik_VPSHLDQZrrikz_VPSHLDVDZrk_VPSHLDVDZrkz_VPSHLDVQZrk_VPSHLDVQZrkz_VPSHLDVWZrk_VPSHLDVWZrkz_VPSHLDWZrri_VPSHLDWZrrik_VPSHLDWZrrikz_VPSHRDDZrri_VPSHRDDZrrik_VPSHRDDZrrikz_VPSHRDQZrri_VPSHRDQZrrik_VPSHRDQZrrikz_VPSHRDVDZrk_VPSHRDVDZrkz_VPSHRDVQZrk_VPSHRDVQZrkz_VPSHRDVWZrk_VPSHRDVWZrkz_VPSHRDWZrri_VPSHRDWZrrik_VPSHRDWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1089
  {DBGFIELD("PSLLDrr_PSLLQrr_PSLLWrr_PSRADrr_PSRAWrr_PSRLDrr_PSRLQrr_PSRLWrr_VPSLLDZ128rr_VPSLLDZ128rrk_VPSLLDZ128rrkz_VPSLLDrr_VPSLLQZ128rr_VPSLLQZ128rrk_VPSLLQZ128rrkz_VPSLLQrr_VPSLLWZ128rr_VPSLLWZ128rrk_VPSLLWZ128rrkz_VPSLLWrr_VPSRADZ128rr_VPSRADZ128rrk_VPSRADZ128rrkz_VPSRADrr_VPSRAQZ128rr_VPSRAQZ128rrk_VPSRAQZ128rrkz_VPSRAWZ128rr_VPSRAWZ128rrk_VPSRAWZ128rrkz_VPSRAWrr_VPSRLDZ128rr_VPSRLDZ128rrk_VPSRLDZ128rrkz_VPSRLDrr_VPSRLQZ128rr_VPSRLQZ128rrk_VPSRLQZ128rrkz_VPSRLQrr_VPSRLWZ128rr_VPSRLWZ128rrk_VPSRLWZ128rrkz_VPSRLWrr") 2, false, false, false, 269, 3, 12, 1,  0, 0}, // #1090
  {DBGFIELD("VPSLLDYrr_VPSLLDZ256rr_VPSLLDZ256rrk_VPSLLDZ256rrkz_VPSLLQYrr_VPSLLQZ256rr_VPSLLQZ256rrk_VPSLLQZ256rrkz_VPSLLWYrr_VPSLLWZ256rr_VPSLLWZ256rrk_VPSLLWZ256rrkz_VPSRADYrr_VPSRADZ256rr_VPSRADZ256rrk_VPSRADZ256rrkz_VPSRAQZ256rr_VPSRAQZ256rrk_VPSRAQZ256rrkz_VPSRAWYrr_VPSRAWZ256rr_VPSRAWZ256rrk_VPSRAWZ256rrkz_VPSRLDYrr_VPSRLDZ256rr_VPSRLDZ256rrk_VPSRLDZ256rrkz_VPSRLQYrr_VPSRLQZ256rr_VPSRLQZ256rrk_VPSRLQZ256rrkz_VPSRLWYrr_VPSRLWZ256rr_VPSRLWZ256rrk_VPSRLWZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1091
  {DBGFIELD("VPSLLDZrr_VPSLLDZrrk_VPSLLDZrrkz_VPSLLQZrr_VPSLLQZrrk_VPSLLQZrrkz_VPSLLWZrr_VPSLLWZrrk_VPSLLWZrrkz_VPSRADZrr_VPSRADZrrk_VPSRADZrrkz_VPSRAQZrr_VPSRAQZrrk_VPSRAQZrrkz_VPSRAWZrr_VPSRAWZrrk_VPSRAWZrrkz_VPSRLDZrr_VPSRLDZrrk_VPSRLDZrrkz_VPSRLQZrr_VPSRLQZrrk_VPSRLQZrrkz_VPSRLWZrr_VPSRLWZrrk_VPSRLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1092
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri_VPSLLDQZ256ri_VPSRLDQZ256ri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1093
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1094
  {DBGFIELD("VPSLLDQZri_VPSRLDQZri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1095
  {DBGFIELD("VPSHUFBYrr_VPSHUFBZ256rr_VPSHUFBZ256rrk_VPSHUFBZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1096
  {DBGFIELD("VPSHUFBZ128rr_VPSHUFBZ128rrk_VPSHUFBZ128rrkz") 4, false, false, false, 2289, 3, 14, 1,  0, 0}, // #1097
  {DBGFIELD("VPSHUFBZrr_VPSHUFBZrrk_VPSHUFBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1098
  {DBGFIELD("VPROLVDZ128rr_VPROLVDZ128rrk_VPROLVDZ128rrkz_VPROLVQZ128rr_VPROLVQZ128rrk_VPROLVQZ128rrkz_VPRORVDZ128rr_VPRORVDZ128rrk_VPRORVDZ128rrkz_VPRORVQZ128rr_VPRORVQZ128rrk_VPRORVQZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1099
  {DBGFIELD("VPROLVDZ256rr_VPROLVDZ256rrk_VPROLVDZ256rrkz_VPROLVQZ256rr_VPROLVQZ256rrk_VPROLVQZ256rrkz_VPRORVDZ256rr_VPRORVDZ256rrk_VPRORVDZ256rrkz_VPRORVQZ256rr_VPRORVQZ256rrk_VPRORVQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1100
  {DBGFIELD("VPROLVDZrr_VPROLVDZrrk_VPROLVDZrrkz_VPROLVQZrr_VPROLVQZrrk_VPROLVQZrrkz_VPRORVDZrr_VPRORVDZrrk_VPRORVDZrrkz_VPRORVQZrr_VPRORVQZrrk_VPRORVQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1101
  {DBGFIELD("VPROLDZ256ri_VPROLDZ256rik_VPROLDZ256rikz_VPROLQZ256ri_VPROLQZ256rik_VPROLQZ256rikz_VPRORDZ256ri_VPRORDZ256rik_VPRORDZ256rikz_VPRORQZ256ri_VPRORQZ256rik_VPRORQZ256rikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1102
  {DBGFIELD("VPROLDZ128ri_VPROLDZ128rik_VPROLDZ128rikz_VPROLQZ128ri_VPROLQZ128rik_VPROLQZ128rikz_VPRORDZ128ri_VPRORDZ128rik_VPRORDZ128rikz_VPRORQZ128ri_VPRORQZ128rik_VPRORQZ128rikz") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1103
  {DBGFIELD("VPROLDZri_VPROLDZrik_VPROLDZrikz_VPROLQZri_VPROLQZrik_VPROLQZrikz_VPRORDZri_VPRORDZrik_VPRORDZrikz_VPRORQZri_VPRORQZrik_VPRORQZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1104
  {DBGFIELD("VFMSUB231SSZr_Intkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1105
  {DBGFIELD("VPSLLDZ128ri_VPSLLDZ128rik_VPSLLDZ128rikz_VPSLLQZ128ri_VPSLLQZ128rik_VPSLLQZ128rikz_VPSLLWZ128ri_VPSLLWZ128rik_VPSLLWZ128rikz_VPSRADZ128ri_VPSRADZ128rik_VPSRADZ128rikz_VPSRAQZ128ri_VPSRAQZ128rik_VPSRAQZ128rikz_VPSRAWZ128ri_VPSRAWZ128rik_VPSRAWZ128rikz_VPSRLDZ128ri_VPSRLDZ128rik_VPSRLDZ128rikz_VPSRLQZ128ri_VPSRLQZ128rik_VPSRLQZ128rikz_VPSRLWZ128ri_VPSRLWZ128rik_VPSRLWZ128rikz") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1106
  {DBGFIELD("VPSLLDZ256ri_VPSLLDZ256rik_VPSLLDZ256rikz_VPSLLQZ256ri_VPSLLQZ256rik_VPSLLQZ256rikz_VPSLLWZ256ri_VPSLLWZ256rik_VPSLLWZ256rikz_VPSRADZ256ri_VPSRADZ256rik_VPSRADZ256rikz_VPSRAQZ256ri_VPSRAQZ256rik_VPSRAQZ256rikz_VPSRAWZ256ri_VPSRAWZ256rik_VPSRAWZ256rikz_VPSRLDZ256ri_VPSRLDZ256rik_VPSRLDZ256rikz_VPSRLQZ256ri_VPSRLQZ256rik_VPSRLQZ256rikz_VPSRLWZ256ri_VPSRLWZ256rik_VPSRLWZ256rikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1107
  {DBGFIELD("VPSLLDZri_VPSLLDZrik_VPSLLDZrikz_VPSLLQZri_VPSLLQZrik_VPSLLQZrikz_VPSLLWZri_VPSLLWZrik_VPSLLWZrikz_VPSRADZri_VPSRADZrik_VPSRADZrikz_VPSRAQZri_VPSRAQZrik_VPSRAQZrikz_VPSRAWZri_VPSRAWZrik_VPSRAWZrikz_VPSRLDZri_VPSRLDZrik_VPSRLDZrikz_VPSRLQZri_VPSRLQZrik_VPSRLQZrikz_VPSRLWZri_VPSRLWZrik_VPSRLWZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1108
  {DBGFIELD("PALIGNRrri_VPALIGNRZ128rri_VPALIGNRZ128rrik_VPALIGNRZ128rrikz_VPALIGNRrri") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1109
  {DBGFIELD("VPALIGNRZ256rri_VPALIGNRZ256rrik_VPALIGNRZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1110
  {DBGFIELD("VPALIGNRZrri_VPALIGNRZrrik_VPALIGNRZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1111
  {DBGFIELD("PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWZ128rr_VPACKSSDWZ128rrk_VPACKSSDWZ128rrkz_VPACKSSDWrr_VPACKSSWBZ128rr_VPACKSSWBZ128rrk_VPACKSSWBZ128rrkz_VPACKSSWBrr_VPACKUSDWZ128rr_VPACKUSDWZ128rrk_VPACKUSDWZ128rrkz_VPACKUSDWrr_VPACKUSWBZ128rr_VPACKUSWBZ128rrk_VPACKUSWBZ128rrkz_VPACKUSWBrr") 1, false, false, false, 2226, 2,  1, 1,  0, 0}, // #1112
  {DBGFIELD("VPACKSSDWZ256rr_VPACKSSDWZ256rrk_VPACKSSDWZ256rrkz_VPACKSSWBZ256rr_VPACKSSWBZ256rrk_VPACKSSWBZ256rrkz_VPACKUSDWZ256rr_VPACKUSDWZ256rrk_VPACKUSDWZ256rrkz_VPACKUSWBZ256rr_VPACKUSWBZ256rrk_VPACKUSWBZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1113
  {DBGFIELD("VPACKSSDWZrr_VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrr_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrr_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrr_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1114
  {DBGFIELD("CMPPDrri_VCMPPDrri_VMAXCPDZ128rr_VMAXCPDZ128rrk_VMAXCPDZ128rrkz_VMAXPDZ128rr_VMAXPDZ128rrk_VMAXPDZ128rrkz_VMINCPDZ128rr_VMINCPDZ128rrk_VMINCPDZ128rrkz_VMINPDZ128rr_VMINPDZ128rrk_VMINPDZ128rrkz") 3, false, false, false, 2231, 3,  3, 1,  0, 0}, // #1115
  {DBGFIELD("CMPPSrri_VCMPPSrri") 3, false, false, false, 2231, 3,  3, 1,  0, 0}, // #1116
  {DBGFIELD("CM